<?php

/**
 * Edit or add a source.
 */

// *** Safety line ***
if (!defined('ADMIN_PAGE')) {
    exit;
}



// TODO create seperate controller script.
include_once(__DIR__ . "/../include/editor_cls.php");
$editor_cls = new editor_cls;

// *** Process queries (needed for picture ordering and delete) ***
$phpself = 'index.php';
include_once(__DIR__ . "/../include/editor_inc.php");
echo $confirm; // Confirm message to remove picture from source.

require_once  __DIR__ . "/../models/edit_source.php";
$editSourceModel = new EditSourceModel($dbh);
$editSourceModel->set_source_id($dbh, $tree_id);
$editSourceModel->update_source($dbh, $tree_id, $db_functions, $editor_cls);
$editSource['source_id'] = $editSourceModel->get_source_id();



$phpself = 'index.php';
$field_text_large = 'style="height: 100px; width:550px"';

include(__DIR__ . '/../include/editor_event_cls.php');
$event_cls = new editor_event_cls;

$new_tree = false;

// *** Editor icon for admin and editor: select family tree ***
if (isset($tree_id) and $tree_id) {
    $db_functions->set_tree_id($tree_id);
}

$source_qry = $dbh->query("SELECT * FROM humo_sources WHERE source_tree_id='" . $tree_id . "' ORDER BY IF (source_title!='',source_title,source_text)");
?>

<h1 class="center"><?= __('Sources'); ?></h1>
<?= __('These sources can be connected to multiple persons, families, events and other items.'); ?>

<?php if (isset($_POST['source_remove2'])) { ?>
    <div class="alert alert-success">
        <?= __('Source is removed!'); ?>
    </div>
<?php }; ?>

<?php if (isset($_POST['source_remove'])) { ?>
    <div class="alert alert-danger">
        <strong><?= __('Are you sure you want to remove this source and ALL source references?'); ?></strong>
        <form method="post" action="<?= $phpself; ?>" style="display : inline;">
            <input type="hidden" name="page" value="<?= $page; ?>">
            <input type="hidden" name="source_id" value="<?= $editSource['source_id']; ?>">
            <input type="hidden" name="source_gedcomnr" value="<?= $_POST['source_gedcomnr']; ?>">
            <input type="submit" name="source_remove2" value="<?= __('Yes'); ?>" style="color : red; font-weight: bold;">
            <input type="submit" name="dummy5" value="<?= __('No'); ?>" style="color : blue; font-weight: bold;">
        </form>
    </div>
<?php }; ?>

<form method="POST" action="<?= $phpself; ?>" style="display : inline;">
    <input type="hidden" name="page" value="<?= $page; ?>">

    <div class="p-3 m-2 genealogy_search">
        <div class="row">

            <div class="col-auto">
                <label for="tree" class="col-form-label">
                    <?= __('Family tree'); ?>:
                </label>
            </div>

            <div class="col-2">
                <?php $editor_cls->select_tree($page); ?>
            </div>

            <div class="col-auto">
                <label for="tree" class="col-form-label">
                    <?= __('Select source'); ?>:
                </label>
            </div>

            <div class="col-4">
                <select size="1" name="source_id" class="form-select form-select-sm" onChange="this.form.submit();">
                    <!-- For new source in new database... -->
                    <option value=""><?= __('Select source'); ?></option>
                    <?php
                    while ($sourceDb = $source_qry->fetch(PDO::FETCH_OBJ)) {
                        $selected = '';
                        if ($editSource['source_id'] == $sourceDb->source_id) {
                            $selected = ' selected';
                        }

                        //if ($check_source_gedcomnr == $sourceDb->source_gedcomnr) {
                        //    $selected = ' selected';
                        //    $source_id = $sourceDb->source_id;
                        //}

                        if ($sourceDb->source_title) {
                            $show_text = $sourceDb->source_title;
                        } else {
                            $show_text = substr($sourceDb->source_text, 0, 40);
                            if (strlen($sourceDb->source_text) > 40) $show_text .= '...';
                        }
                        $restricted = '';
                        if (@$sourceDb->source_status == 'restricted') $restricted = ' *' . __('restricted') . '*';
                    ?>
                        <option value="<?= $sourceDb->source_id; ?>" <?= $selected; ?>><?= $show_text; ?> [<?= @$sourceDb->source_gedcomnr . $restricted; ?>]</option>
                    <?php } ?>
                </select>
            </div>

            <div class="col-auto">
                <?= __('or'); ?>:
                <input type="submit" name="add_source" value="<?= __('Add source'); ?>" class="btn btn-sm btn-secondary">
            </div>
        </div>
    </div>
</form>

<?php
// *** Show selected source ***
if ($editSource['source_id'] or isset($_POST['add_source'])) {
    if (isset($_POST['add_source'])) {
        $source_gedcomnr = '';
        $source_status = '';
        $source_title = '';
        $source_date = '';
        $source_place = '';
        $source_publ = '';
        $source_refn = '';
        $source_auth = '';
        $source_auth = '';
        $source_subj = '';
        $source_item = '';
        $source_kind = '';
        $source_text = '';
        $source_repo_caln = '';
        $source_repo_page = '';
        $source_repo_gedcomnr = '';
    } else {
        @$source_qry = $dbh->query("SELECT * FROM humo_sources WHERE source_tree_id='" . $tree_id . "' AND source_id='" . $editSource['source_id'] . "'");
        //$sourceDb=$db_functions->get_source ($sourcenum);

        $die_message = __('No valid source number.');
        try {
            @$sourceDb = $source_qry->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            echo $die_message;
        }
        $source_gedcomnr = $sourceDb->source_gedcomnr;
        $source_status = $sourceDb->source_status;
        $source_title = $sourceDb->source_title;
        $source_date = $sourceDb->source_date;
        $source_place = $sourceDb->source_place;
        $source_publ = $sourceDb->source_publ;
        $source_refn = $sourceDb->source_refn;
        $source_auth = $sourceDb->source_auth;
        $source_auth = $sourceDb->source_auth;
        $source_subj = $sourceDb->source_subj;
        $source_item = $sourceDb->source_item;
        $source_kind = $sourceDb->source_kind;
        $source_text = $sourceDb->source_text;
        $source_repo_caln = $sourceDb->source_repo_caln;
        $source_repo_page = $sourceDb->source_repo_page;
        $source_repo_gedcomnr = $sourceDb->source_repo_gedcomnr;
    }

    $repo_qry = $dbh->query("SELECT * FROM humo_repositories WHERE repo_tree_id='" . $tree_id . "' ORDER BY repo_name, repo_place");
?>
    <form method="POST" action="<?= $phpself; ?>" name="form3" id="form3">
        <input type="hidden" name="page" value="<?= $page; ?>">
        <input type="hidden" name="source_id" value="<?= $editSource['source_id']; ?>">
        <input type="hidden" name="source_gedcomnr" value="<?= $source_gedcomnr; ?>">
        <table class="humo standard" border="1">
            <tr class="table_header">
                <th><?= __('Option'); ?></th>
                <th colspan="3"><?= __('Value'); ?></th>
            </tr>

            <tr>
                <td><?= __('Status:'); ?></td>
                <td colspan="3">
                    <select class="fonts" size="1" name="source_status">
                        <option value="publish" <?php if ($source_status == 'publish') echo ' selected'; ?>><?= __('publish'); ?></option>
                        <option value="restricted" <?php if ($source_status == 'restricted') echo ' selected'; ?>><?= __('restricted'); ?></option>
                    </select> <?= __('restricted = only visible for selected user groups'); ?>
                </td>
            </tr>

            <tr>
                <td><?= __('Title'); ?></td>
                <td colspan="3"><input type="text" name="source_title" value="<?= htmlspecialchars($source_title); ?>" size="60"></td>
            </tr>

            <tr>
                <td><?= __('Subject'); ?></td>
                <td colspan="3"><input type="text" name="source_subj" value="<?= htmlspecialchars($source_subj); ?>" size="60"></td>
            </tr>

            <tr>
                <td><?= __('date') . ' - ' . __('place'); ?></td>
                <td colspan="3"><?= $editor_cls->date_show($source_date, "source_date"); ?> <input type="text" name="source_place" value="<?= htmlspecialchars($source_place); ?>" placeholder=<?= ucfirst(__('place')); ?> size="50"></td>
            </tr>

            <tr>
                <td><?= __('Repository'); ?></td>
                <td colspan="3">
                    <select size="1" name="source_repo_gedcomnr">
                        <option value=""></option>
                        <?php while ($repoDb = $repo_qry->fetch(PDO::FETCH_OBJ)) { ?>
                            <option value="<?= $repoDb->repo_gedcomnr; ?>" <?= $repoDb->repo_gedcomnr == $source_repo_gedcomnr ? ' selected' : ''; ?>>
                                <?= $repoDb->repo_gedcomnr; ?>, <?= $repoDb->repo_name; ?> <?= $repoDb->repo_place; ?></option>
                        <?php } ?>
                    </select>
                    <!-- For new repository in new database... -->
                    &nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?page=edit_repositories"><?= __('Add repositories'); ?></a>
                </td>
            </tr>

            <tr>
                <td><?= __('Publication'); ?></td>
                <td colspan="3"><input type="text" name="source_publ" value="<?= htmlspecialchars($source_publ); ?>" size="60"> https://... <?= __('will be shown as a link.'); ?></td>
            </tr>
            <tr>
                <td><?= __('Own code'); ?></td>
                <td colspan="3"><input type="text" name="source_refn" value="<?= $source_refn; ?>" size="60"></td>
            </tr>
            <tr>
                <td><?= __('Author'); ?></td>
                <td colspan="3"><input type="text" name="source_auth" value="<?= $source_auth; ?>" size="60"></td>
            </tr>
            <tr>
                <td><?= __('Nr.'); ?></td>
                <td colspan="3"><input type="text" name="source_item" value="<?= $source_item; ?>" size="60"></td>
            </tr>
            <tr>
                <td><?= __('Kind'); ?></td>
                <td colspan="3"><input type="text" name="source_kind" value="<?= $source_kind; ?>" size="60"></td>
            </tr>
            <tr>
                <td><?= __('Archive'); ?></td>
                <td colspan="3"><input type="text" name="source_repo_caln" value="<?= $source_repo_caln; ?>" size="60"></td>
            </tr>
            <tr>
                <td><?= __('Page'); ?></td>
                <td colspan="3"><input type="text" name="source_repo_page" value="<?= $source_repo_page; ?>" size="60"></td>
            </tr>
            <tr>
                <td><?= __('text'); ?></td>
                <td colspan="3"><textarea rows="6" cols="80" name="source_text" <?= $field_text_large; ?>><?= $editor_cls->text_show($source_text); ?></textarea></td>
            </tr>

            <?php
            // *** Picture by source ***
            if (!isset($_POST['add_source'])) {
                echo $event_cls->show_event('source', $sourceDb->source_gedcomnr, 'source_picture');
            }

            if (isset($_POST['add_source'])) {
                echo '<tr><td>' . __('Add') . '</td><td colspan="3"><input type="submit" name="source_add" value="' . __('Add') . '"></td></tr>';
            } else {
                echo '<tr><td>' . __('Save') . '</td><td colspan="3"><input type="submit" name="source_change2" value="' . __('Save') . '">';
                echo ' ' . __('or') . ' <input type="submit" name="source_remove" value="' . __('Delete') . '">';
                echo '</td></tr>';
            }
            ?>
        </table>
    </form>

<?php
    // *** Source example in IFRAME ***
    if (!isset($_POST['add_source'])) {
        $vars['source_gedcomnr'] = $sourceDb->source_gedcomnr;
        $sourcestring = $link_cls->get_link('../', 'source', $tree_id, false, $vars);

        echo '<p>' . __('Preview') . '<br>';
        echo '<iframe src ="' . $sourcestring . '" class="iframe">';
        //TODO TRANSLATE
        echo '  <p>Your browser does not support iframes.</p>';
        echo '</iframe>';
    }
}

// *** Needed to add pictures ***
function editor_label2($label, $style = '')
{
    $text = '<span style="display: inline-block; width:150px; vertical-align: top;">';
    if ($style == 'bold') $text .= '<b>';
    $text .= ucfirst($label);
    if ($style == 'bold') $text .= '</b>';
    $text .= '</span>';
    return $text;
}
