<?php $confirm_delete = __('Supprimer les marques d\'appareils photos sélectionnées ?'); ?>
<?php include('cameras_menu.tpl.php'); ?>
<div id="page_table" class="page_content">
	<div>
		<nav id="section_nav">
<?php include('breadcrumb.tpl.php'); ?>
		</nav>

<?php if (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

		<div class="tools">
			<div><span class="icon icon_search show_tool"><a data-id="search" class="js<?php if ($_GET['section_1'] == 'cameras-brands-search') : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('cameras-brands' . (strstr($_GET['section_1'], 'search') ? '' : '-search') . '/page/' . $_GET['page']); ?>"><?php echo __('Recherche'); ?></a></span></div>
			<span class="sep">-</span>
			<div><span class="icon icon_options show_tool"><a data-id="options" class="js<?php if ($_GET['section_1'] == 'cameras-brands-display') : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('cameras-brands' . (strstr($_GET['section_1'], 'display') ? '' : '-display') . '/page/' . $_GET['page']); ?>"><?php echo __('Options d\'affichage'); ?></a></span></div>
		</div>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'cameras-brands-search') : ?> show<?php endif; ?>" id="search">
			<fieldset>
				<p class="field">
					<label for="search_query"><?php echo __('Rechercher :'); ?></label>
					<input<?php if ($_GET['section_1'] == 'cameras-brands-search') : ?> autofocus<?php endif; ?> required data-help-icon="search" value="<?php echo $tpl['search']['query']; ?>" class="focus" type="text" name="search_query" id="search_query" maxlength="255" size="50" data-reset="">
				</p>
				<p class="field">
					<input<?php echo $tpl['search']['all_words'] ? ' checked' : ''; ?> type="checkbox" name="search_options[all_words]" id="search_all_words" data-reset="1">
					<label for="search_all_words"><?php echo __('Rechercher tous les mots'); ?></label>
				</p>
				<input name="search_options[columns][]" type="hidden" value="camera_brand_name">
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="search" type="submit" value="<?php echo __('Chercher'); ?>">
				<input class="button reset_js" type="reset" value="<?php echo __('Réinitialiser'); ?>">
			</fieldset>
		</form>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'cameras-brands-display') : ?> show<?php endif; ?>" id="options">
			<fieldset>
				<p class="field">
					<label for="nb_per_page"><?php echo __('Nombre de marques par page :'); ?></label>
					<input<?php if ($_GET['section_1'] == 'cameras-brands-display') : ?> autofocus<?php endif; ?> required maxlength="3" size="3" value="<?php echo $tpl['options']['nb_per_page']; ?>" name="nb_per_page" id="nb_per_page" type="text" class="focus">
				</p>
				<p class="field">
					<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
					<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['order_by_column'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
					<select name="order_by_order">
<?php foreach ($tpl['options']['order_by_order'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="options" type="submit" value="<?php echo __('Valider'); ?>">
			</fieldset>
		</form>

<?php if ($tpl['objects_count'] > 0) : ?>

<?php include('pagination.tpl.php'); ?>

		<div class="table_form_container">
			<form class="table_form" id="cameras_form" action="<?php echo $tpl['current_url']; ?>" method="post">

				<div id="obj_links_js">
<?php include('object_select.tpl.php'); ?>
				</div>

				<table class="default page">
					<tr>
						<th><?php echo __('Marque'); ?></th>
						<th><?php echo __('Fichiers liés'); ?></th>
						<th class="null"></th>
					</tr>
<?php $n = 1; foreach ($tpl['cameras'] as &$i) : ?>
					<tr class="selectable_class<?php if (is_integer($n++ / 2)) : ?> even<?php endif; ?>">
						<td><?php echo $i['brand_name']; ?></td>
						<td class="num"><?php if ($i['link']) : ?><a href="<?php echo $i['link']; ?>"><?php echo $i['count']; ?></a><?php else : ?>0<?php endif; ?></td>
						<td class="selectable_zone"><input class="selectable" name="selected[<?php echo $i['id']; ?>]" type="checkbox"></td>
					</tr>
<?php endforeach; ?>
				</table>

				<div id="submit" class="submit_actions submit_table<?php if ($tpl['nb_pages'] > 1) : ?> submit_pages<?php endif; ?>">
					<div>
						<p id="form_actions">
							<label for="selection_action"><?php printf(__('Action sur la sélection (%s) :'), '<span id="select_num">0</span>'); ?></label>
							<select id="selection_action" name="action">
								<optgroup label="<?php echo __('Suppression'); ?>">
									<option value="delete_confirm"><?php echo __('Supprimer'); ?></option>
								</optgroup>
							</select>
							<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
							<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
						</p>
					</div>
				</div>
			</form>
		</div>

		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var confirm_delete = "<?php echo $tpl['php2js']($confirm_delete); ?>";
		</script>

<?php include('pagination.tpl.php'); ?>

<?php else : ?>
		<br>
		<div class="report_classic">
			<div class="report_msg report_info">
				<p><?php echo isset($_GET['search']) ? __('Aucune marque d\'appareil photo trouvée.') : __('Aucune marque d\'appareil photo.'); ?></p>
			</div>
		</div>
<?php endif; ?>

<?php endif; ?>

	</div>
</div>