<form action="<?php echo $tpl['current_url']; ?>" method="post">
	<fieldset>
		<legend><?php echo __('Base de données'); ?></legend>
		<p class="field">
			<span class="text"><?php echo __('Ces outils permettent d\'effectuer des opérations de maintenance sur la base de données. La vérification des statistiques va vérifier et éventuellement corriger les statistiques de tous les fichiers et de toutes les catégories. Le nettoyage de la base de données permet de réorganiser et d\'alléger la base de données. Ces opérations peuvent prendre plusieurs minutes si vous avez un grand nombre de fichiers.'); ?></span>
		</p>
		<p class="field">
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input name="stats" type="submit" class="submit" value="<?php echo __('Vérifier les statistiques'); ?>">
			&nbsp;
			<input name="vacuum" type="submit" class="submit" value="<?php echo __('Nettoyer la base de données'); ?>">
		</p>

<?php if (isset($tpl['dbstats_report']) && $tpl['dbstats_report']['count'] > -1) : ?>
<?php if ($tpl['dbstats_report']['count'] > 0) : ?>
		<div id="maintenance_summary" class="report_classic">
<?php if ($tpl['dbstats_report']['count_categories'] > 0) : ?>
			<div class="report_msg report_success"><p><?php printf(__('Nombre de catégories corrigées : %s'), $tpl['dbstats_report']['count_categories']); ?></p></div>
<?php endif; ?>
<?php if ($tpl['dbstats_report']['count_items'] > 0) : ?>
			<div class="report_msg report_success"><p><?php printf(__('Nombre de fichiers corrigés : %s'), $tpl['dbstats_report']['count_items']); ?></p></div>
<?php endif; ?>
		</div>
		<div id="check_stats_details">
<?php foreach ($tpl['dbstats_report']['details']['categories'] as &$i) : ?>
			<div>
				<p><?php echo '<a href="' . $tpl['link']($i['type'] . '/' . $i['id']) . '">' . sprintf(__('Catégorie %s'), $i['id'] . ' : ' . $i['path']) . '</a>'; ?></p>
				<table class="default">
					<tr>
						<th><?php echo __('Colonne'); ?></th>
						<th><?php echo __('Avant'); ?></th>
						<th><?php echo __('Après'); ?></th>
					</tr>
<?php foreach ($i['report'] as $col => $s) : ?>
					<tr>
						<td><?php echo $col; ?></td>
						<td><?php echo $s['before']; ?></td>
						<td><?php echo $s['after']; ?></td>
					</tr>
<?php endforeach; ?>
				</table>
			</div>
<?php endforeach; ?>
<?php foreach ($tpl['dbstats_report']['details']['items'] as &$i) : ?>
			<div>
				<p><?php echo '<a href="' . $tpl['link']('item-edit/' . $i['id']) . '">' . sprintf(__('Fichier %s'), $i['id'] . ' : ' . $i['path']) . '</a>'; ?></p>
				<table class="default">
					<tr>
						<th><?php echo __('Colonne'); ?></th>
						<th><?php echo __('Avant'); ?></th>
						<th><?php echo __('Après'); ?></th>
					</tr>
<?php foreach ($i['report'] as $col => $s) : ?>
					<tr>
						<td><?php echo $col; ?></td>
						<td><?php echo $s['before']; ?></td>
						<td><?php echo $s['after']; ?></td>
					</tr>
<?php endforeach; ?>
				</table>
			</div>
<?php endforeach; ?>
		</div>
<?php else : ?>
		<div id="maintenance_summary" class="report_classic"><div class="report_msg report_info"><p><?php echo __('Aucune modification effectuée car toutes les statistiques sont correctes.'); ?></p></div></div>
<?php endif; ?>
<?php endif; ?>

<?php if (isset($tpl['dbvacuum_report'])) : ?>
		<div id="maintenance_summary" class="report_classic"><div class="report_msg report_<?php echo $tpl['dbvacuum_report']['success'] ? 'success' : 'error'; ?>"><p><?php echo $tpl['dbvacuum_report']['message']; ?></p></div></div>
<?php endif; ?>

	</fieldset>
</form>