<?php include('options_menu.tpl.php'); ?>

<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="page">
	<fieldset>
		<legend><?php echo __('Téléchargement'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="download_item">
			<input<?php if ($tpl['config']['download_item']) : ?> checked<?php endif; ?> id="download_item" name="config[download_item]" type="checkbox">
			<label for="download_item"><?php echo __('Autoriser le téléchargement des photos et vidéos'); ?></label>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Photos'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="items_resize">
			<input<?php if ($tpl['config']['items_resize']) : ?> checked<?php endif; ?> id="items_resize" name="config[items_resize]" type="checkbox">
			<label for="items_resize"><?php echo __('Redimensionner les photos'); ?></label>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<label for="items_resize_width"><?php echo __('Dimensions maximum :'); ?></label>
				<span class="block">
					<input required value="<?php echo $tpl['config']['items_resize_width']; ?>" id="items_resize_width" name="config[items_resize_width]" type="text" maxlength="5" size="5">
					x
					<input required value="<?php echo $tpl['config']['items_resize_height']; ?>" id="items_resize_height" name="config[items_resize_height]" type="text" maxlength="5" size="5">
					<?php echo __('pixels'); ?>
				</span>
			</p>
			<p class="field">
				<label for="items_resize_type"><?php echo __('Format :'); ?></label>
				<select class="block" name="config[items_resize_type]" id="items_resize_type">
<?php foreach ($tpl['file_types'] as $value => $name) : ?>
					<option<?php if ($tpl['config']['items_resize_type'] == $value) : ?> selected<?php endif; ?> value="<?php echo $value; ?>"><?php echo $name; ?></option>
<?php endforeach; ?>
				</select>
			</p>
			<p class="field">
				<label for="items_resize_quality"><?php echo __('Qualité (entre 0 et 100) :'); ?></label>
				<input required value="<?php echo $tpl['config']['items_resize_quality']; ?>" id="items_resize_quality" name="config[items_resize_quality]" type="text" maxlength="3" size="3">
			</p>
		</div>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Vidéos'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="video_muted">
			<input<?php if ($tpl['config']['video_muted']) : ?> checked<?php endif; ?> id="video_muted" name="config[video_muted]" type="checkbox">
			<label for="video_muted"><?php echo __('Couper le son des vidéos'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="video_loop">
			<input<?php if ($tpl['config']['video_loop']) : ?> checked<?php endif; ?> id="video_loop" name="config[video_loop]" type="checkbox">
			<label for="video_loop"><?php echo __('Lire les vidéos en boucle'); ?></label>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Vignettes'); ?></legend>
		<p class="field">
			<label for="thumbs_item_nb_per_page"><?php echo __('Nombre de vignettes par page :'); ?></label>
			<select name="config[thumbs_item_nb_per_page]" id="thumbs_item_nb_per_page">
<?php foreach ($tpl['items_nb_per_page'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label><?php echo __('Ordre d\'affichage :'); ?></label>
		</p>
		<div class="field_sublvl">
<?php for ($n = 1; $n <= 3; $n++) : ?>
			<p class="field">
				<label for="items_sortby_<?php echo $n; ?>"><?php printf(__('Critère n°%s :'), $n); ?></label>
				<select id="items_sortby_<?php echo $n; ?>" class="block" name="config[items][sortby_<?php echo $n; ?>]">
<?php foreach ($tpl['items_sort_by_params'] as $col => $text) : ?>
<?php if ($n == 1 && $col == 'none') : continue; endif; ?>
					<option value="<?php echo $col; ?>"<?php if ($col == $tpl['items_sort_by'][$n - 1][0]) : ?> selected<?php endif; ?>><?php echo $text; ?></option>
<?php endforeach; ?>
				</select>
				<select class="block" name="config[items][orderby_<?php echo $n; ?>]">
<?php foreach ($tpl['order_by_params'] as $ascdesc => $text) : ?>
					<option value="<?php echo $ascdesc; ?>"<?php if ($ascdesc == $tpl['items_sort_by'][$n - 1][1]) : ?> selected<?php endif; ?>><?php echo $text; ?></option>
<?php endforeach; ?>
				</select>
			</p>
<?php endfor; ?>
		</div>
		<p class="field">
			<?php echo __('Informations à afficher :'); ?>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_title">
					<input<?php if ($tpl['config']['thumbs_item_info_title']) : ?> checked<?php endif; ?> id="thumbs_item_info_title" name="config[thumbs_item_info_title]" type="checkbox">
					<label for="thumbs_item_info_title"><?php echo __('Titre'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_rating">
					<input<?php if ($tpl['config']['thumbs_item_info_rating']) : ?> checked<?php endif; ?> id="thumbs_item_info_rating" name="config[thumbs_item_info_rating]" type="checkbox">
					<label for="thumbs_item_info_rating"><?php echo __('Note moyenne'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_date">
					<input<?php if ($tpl['config']['thumbs_item_info_date']) : ?> checked<?php endif; ?> id="thumbs_item_info_date" name="config[thumbs_item_info_date]" type="checkbox">
					<label for="thumbs_item_info_date"><?php echo __('Date de publication'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_size">
					<input<?php if ($tpl['config']['thumbs_item_info_size']) : ?> checked<?php endif; ?> id="thumbs_item_info_size" name="config[thumbs_item_info_size]" type="checkbox">
					<label for="thumbs_item_info_size"><?php echo __('Dimensions'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_filesize">
					<input<?php if ($tpl['config']['thumbs_item_info_filesize']) : ?> checked<?php endif; ?> id="thumbs_item_info_filesize" name="config[thumbs_item_info_filesize]" type="checkbox">
					<label for="thumbs_item_info_filesize"><?php echo __('Poids'); ?></label>
				</span>
			</p>
			<p class="field">
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_description">
					<input<?php if ($tpl['config']['thumbs_item_info_description']) : ?> checked<?php endif; ?> id="thumbs_item_info_description" name="config[thumbs_item_info_description]" type="checkbox">
					<label for="thumbs_item_info_description"><?php echo __('Description'); ?></label>
				</span>
				<span class="sep">&nbsp;-&nbsp;</span>
				<span class="block">
					<label for="thumbs_item_info_description_limit"><?php echo __('Limiter la longueur de la description à'); ?></label>
					<input required value="<?php echo $tpl['config']['thumbs_item_info_description_limit']; ?>" id="thumbs_item_info_description_limit" name="config[thumbs_item_info_description_limit]" type="text" maxlength="4" size="5">
					<?php echo __('caractères (0 pour aucune limite)'); ?>
				</span>
			</p>
			<p class="field">
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_views">
					<input<?php if ($tpl['config']['thumbs_item_info_views']) : ?> checked<?php endif; ?> id="thumbs_item_info_views" name="config[thumbs_item_info_views]" type="checkbox">
					<label for="thumbs_item_info_views"><?php echo __('Nombre de vues'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_comments">
					<input<?php if ($tpl['config']['thumbs_item_info_comments']) : ?> checked<?php endif; ?> id="thumbs_item_info_comments" name="config[thumbs_item_info_comments]" type="checkbox">
					<label for="thumbs_item_info_comments"><?php echo __('Nombre de commentaires'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_votes">
					<input<?php if ($tpl['config']['thumbs_item_info_votes']) : ?> checked<?php endif; ?> id="thumbs_item_info_votes" name="config[thumbs_item_info_votes]" type="checkbox">
					<label for="thumbs_item_info_votes"><?php echo __('Nombre de votes'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_item_info_favorites">
					<input<?php if ($tpl['config']['thumbs_item_info_favorites']) : ?> checked<?php endif; ?> id="thumbs_item_info_favorites" name="config[thumbs_item_info_favorites]" type="checkbox">
					<label for="thumbs_item_info_favorites"><?php echo __('Nombre de favoris'); ?></label>
				</span>
			</p>
		</div>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Modèle de description'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="items_description_model">
			<input<?php if ($tpl['config']['items_description_model']) : ?> checked<?php endif; ?> id="items_description_model" name="config[items_description_model]" type="checkbox">
			<label data-help-icon="description_model" for="items_description_model"><?php echo __('Utiliser un modèle de description :'); ?></label>
		</p>
		<div class="field_var_list">
			<div>
				<p class="field">
					<span class="html_outer">
						<span class="html_inner">
							<textarea rows="20" cols="50" id="items_description_model_text" name="config[items_description_model_text]"><?php echo $tpl['config']['items_description_model_text']; ?></textarea>
							<span>HTML</span>
						</span>
					</span>
				</p>
			</div>
			<div>
				<ul>
					<li><?php echo __('Informations :'); ?><span>{TITLE}, {DESCRIPTION}, {FILENAME}, {ID}, {URL}, {USERNAME}</span></li>
					<li><?php echo __('Propriétés du fichier :'); ?><span>{FILETYPE}, {FILESIZE}, {WIDTH}, {HEIGHT}, {DURATION}</span></li>
					<li><?php echo __('Dates de publication et de création :'); ?><span>{DATEPUBLISHED}, {DATECREATED}, {DATETIMEPUBLISHED}, {DATETIMECREATED}</span></li>
					<li><?php echo __('Métadonnées :'); ?><span>{EXIF:DateTimeOriginal}, {IPTC:Copyright}, {XMP:Description}, etc.</span></li>
					<li><?php echo __('Conditions :'); ?><span>{IF(DURATION)}...{ENDIF(DURATION)}, {IF(XMP:Description)}...{ENDIF(XMP:Description)}, etc.</span></li>
				</ul>
			</div>
		</div>
	</fieldset>
	<div id="submit">
		<div>
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input type="submit" value="<?php echo __('Enregistrer'); ?>">
		</div>
	</div>
</form>