<?php $confirm_delete = __('Supprimer les utilisateurs sélectionnés ?'); ?>
<?php include('users_menu.tpl.php'); ?>
<div id="page_users" class="page_content">
	<div>
		<div id="browse" class="browse js_box">
			<span id="browse_link" class="icon icon_browse js_box_link"><a class="js" href="javascript:;"><?php echo __('Parcourir'); ?></a></span>
			<div id="browse_content" class="js_box_inner">
				<div id="browse_arrow"></div>
				<div id="browse_inner">
					<p id="browse_search" class="field"><input name="search" type="text"></p>
					<div>
						<ul tabindex="-1">
							<li id="!v<?php if (!isset($_GET['group_id'])) : ?>c<?php endif; ?>{0}"><a href="<?php echo $tpl['all_groups_link']; ?>"><b><?php echo '*' . __('Tous'); ?></b><i><?php echo $tpl['users_count']; ?></i></a></li>
<?php foreach ($tpl['groups'] as &$i) : ?>
<?php if ($i['nb_users'] > 0) : ?>
							<li id="v<?php if (isset($_GET['group_id']) && $_GET['group_id'] == $i['id']) : ?>c<?php endif; ?>{<?php echo $i['id']; ?>}"><a href="javascript:;"><b><?php echo $i['name']; ?></b><i><?php echo $i['nb_users']; ?></i></a></li>
<?php endif; ?>
<?php endforeach; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<nav id="section_nav">
<?php include('breadcrumb.tpl.php'); ?>
		</nav>

<?php if (isset($_POST['action']) && $_POST['action'] == 'change_group_confirm') : ?>
		<form id="action_selection" action="<?php echo $tpl['current_url']; ?>" method="post">
			<div>
				<p class="field"><?php printf(__('Sélection : %s'), count($_POST['selected'] ?? [])); ?></p>
				<p class="field">
					<label for="group_id"><?php echo __('Nouveau groupe :'); ?></label>
					<select autofocus id="group_id" name="group_id">
<?php foreach ($tpl['groups'] as &$i) : ?>
<?php if ($i['id'] > 2) : ?>
						<option value="<?php echo $i['id']; ?>"><?php echo $i['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
					</select>
				</p>
<?php if (!empty($_POST['selected'])) : ?>
<?php foreach ($_POST['selected'] as $id => &$value) : ?>
				<input name="selected[<?php echo $id; ?>]" type="hidden" value="<?php echo $value; ?>">
<?php endforeach; ?>
<?php endif; ?>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="action" type="hidden" value="change_group">
				<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
				<input name="cancel" type="submit" value="<?php echo __('Annuler'); ?>">
			</div>
		</form>
<?php elseif (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

		<div class="tools">
			<div><span class="icon icon_user_add show_tool<?php if ($tpl['new_user']['fail']) : ?> autoclick<?php endif; ?>"><a data-id="user_add" class="js<?php if (strstr($_GET['section_1'], 'add')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('users' . (strstr($_GET['section_1'], 'add') ? '' : '-add') . '/page/' . $_GET['page']); ?>"><?php echo __('Ajouter un utilisateur'); ?></a></span></div>
			<span class="sep">-</span>
			<div><span class="icon icon_search show_tool"><a data-id="search" class="js<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('users' . (strstr($_GET['section_1'], 'search') ? '' : '-search') . '/page/' . $_GET['page']); ?>"><?php echo __('Recherche'); ?></a></span></div>
			<span class="sep">-</span>
			<div><span class="icon icon_options show_tool"><a data-id="options" class="js<?php if (strstr($_GET['section_1'], 'display')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('users' . (strstr($_GET['section_1'], 'display') ? '' : '-display') . '/page/' . $_GET['page']); ?>"><?php echo __('Options d\'affichage'); ?></a></span></div>
		</div>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'users-add') : ?> show<?php endif; ?>" id="user_add">
			<fieldset>
				<p class="field">
					<label for="new_user_status"><?php echo __('État :'); ?></label>
					<select id="new_user_status" name="status">
<?php foreach ($tpl['user_status'] as &$i) : ?>
						<option<?php if ($i['current'] && $tpl['new_user']['fail']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<p class="field">
					<label for="new_user_group"><?php echo __('Groupe :'); ?></label>
					<select id="new_user_group" name="group_id">
<?php foreach ($tpl['groups'] as &$i) : ?>
<?php if ($i['id'] > 2) : ?>
						<option<?php if ($i['current'] && $tpl['new_user']['fail']) : ?> selected<?php endif; ?> value="<?php echo $i['id']; ?>"><?php echo $i['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
					</select>
				</p>
				<p class="field<?php if ($tpl['field_error'] == 'login') : ?> field_error<?php endif; ?>">
					<label for="new_user_login"><?php echo __('Nom d\'utilisateur :'); ?></label>
					<input<?php if ($_GET['section_1'] == 'users-add') : ?> autofocus<?php endif; ?> required maxlength="<?php echo $tpl['profile_params']['login']['maxlength']; ?>" value="<?php echo ($tpl['new_user']['fail']) ? $tpl['new_user']['login'] : ''; ?>" name="login" id="new_user_login" type="text" class="focus large">
				</p>
				<p class="field<?php if ($tpl['field_error'] == 'password') : ?> field_error<?php endif; ?>">
					<label for="new_user_password"><?php echo __('Mot de passe :'); ?></label>
					<input required maxlength="<?php echo $tpl['profile_params']['password']['maxlength']; ?>" value="<?php echo ($tpl['new_user']['fail']) ? $tpl['new_user']['password'] : ''; ?>" name="password" id="new_user_password" type="password" class="large">
				</p>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="user_add" type="submit" value="<?php echo __('Valider'); ?>">
			</fieldset>
		</form>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" id="search">
			<fieldset>
				<p class="field">
					<label for="search_query"><?php echo __('Rechercher :'); ?></label>
					<input<?php if (strstr($_GET['section_1'], 'search')) : ?> autofocus<?php endif; ?> required data-help-icon="search" value="<?php echo $tpl['search']['query']; ?>" class="focus" type="text" name="search_query" id="search_query" maxlength="255" size="50" data-reset="">
				</p>
				<p class="field">
					<input<?php echo $tpl['search']['all_words'] ? ' checked' : ''; ?> type="checkbox" name="search_options[all_words]" id="search_all_words" data-reset="1">
					<label for="search_all_words"><?php echo __('Rechercher tous les mots'); ?></label>
				</p>
				<p class="field">
					<span class="icon icon_search_options showhide" rel="#adv_search"><a class="js" href="<?php echo $tpl['link']('users-' . (strstr($_GET['section_1'], 'advanced') ? 'search' : 'search-advanced') . '/page/' . $_GET['page']); ?>"><?php echo __('Options de recherche'); ?></a></span>
				</p>
				<div id="adv_search" class="adv_search_col<?php if (strstr($_GET['section_1'], 'advanced')) : ?> show<?php endif; ?>">
					<div>
						<p class="field">
							<?php echo __('Rechercher dans les champs suivants :'); ?>
						</p>
						<div class="field_sublvl">
							<p class="field">
								<input<?php echo $tpl['search']['columns']['user_login'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="user_login" id="search_user_login" data-reset="1">
								<label for="search_user_login"><?php echo __('Nom d\'utilisateur'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['columns']['user_email'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="user_email" id="search_user_email" data-reset="0">
								<label for="search_user_email"><?php echo __('Courriel'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['columns']['user_website'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="user_website" id="search_user_website" data-reset="0">
								<label for="search_user_website"><?php echo __('Site Web'); ?></label>
							</p>
							<p class="field">
								<input<?php echo $tpl['search']['columns']['user_crtip'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="user_crtip" id="search_user_crtip" data-reset="0">
								<label for="search_user_crtip"><?php echo __('IP d\'inscription'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['columns']['user_lastvstip'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="user_lastvstip" id="search_user_lastvstip" data-reset="0">
								<label for="search_user_lastvstip"><?php echo __('IP de dernière visite'); ?></label>
							</p>
						</div>
						<p class="field">
							<label for="search_status"><?php echo __('Rechercher par état :'); ?></label>
							<select name="search_options[status]" id="search_status" data-reset="*">
<?php foreach ($tpl['search']['status'] as &$i) : ?>
								<option<?php echo $i['selected'] ? ' selected' : ''; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
							</select>
						</p>
					</div>
					<div>
						<p class="field">
							<input<?php echo $tpl['search']['date'] ? ' checked' : ''; ?> id="search_date" type="checkbox" name="search_options[date]" data-reset="0">
							<label for="search_date"><?php echo __('Rechercher par date :'); ?></label>
						</p>
						<div class="field_sublvl">
							<p class="field">
								<input<?php echo $tpl['search']['date_column'] == 'user_crtdt' ? ' checked' : ''; ?> id="search_date_column_user_crtdt" type="radio" name="search_options[date_column]" value="user_crtdt" data-reset="1">
								<label for="search_date_column_user_crtdt"><?php echo __('Date d\'inscription'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['date_column'] == 'user_lastvstdt' ? ' checked' : ''; ?> id="search_date_column_user_lastvstdt" type="radio" name="search_options[date_column]" value="user_lastvstdt" data-reset="0">
								<label for="search_date_column_user_lastvstdt"><?php echo __('Date de dernière visite'); ?></label>
							</p>
<?php include('search_date.tpl.php'); ?>
						</div>
					</div>
				</div>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="search" type="submit" value="<?php echo __('Chercher'); ?>">
				<input class="button reset_js" type="reset" value="<?php echo __('Réinitialiser'); ?>">
			</fieldset>
		</form>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'users-display') : ?> show<?php endif; ?>" id="options">
			<fieldset>
				<p class="field">
					<label for="nb_per_page"><?php echo __('Nombre d\'utilisateurs par page :'); ?></label>
					<input<?php if ($_GET['section_1'] == 'users-display') : ?> autofocus<?php endif; ?> required maxlength="3" size="3" value="<?php echo $tpl['options']['nb_per_page']; ?>" name="nb_per_page" id="nb_per_page" type="text" class="focus">
				</p>
				<p class="field">
					<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
					<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['order_by_column'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
					<select name="order_by_order">
<?php foreach ($tpl['options']['order_by_order'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<p class="field">
					<label for="thumbs_size"><?php echo __('Taille des avatars :'); ?></label>
					<select name="thumbs_size" id="thumbs_size">
<?php foreach ($tpl['options']['thumbs_size'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="options" type="submit" value="<?php echo __('Valider'); ?>">
			</fieldset>
		</form>

<?php if ($tpl['objects_count'] > 0) : ?>

<?php include('pagination.tpl.php'); ?>

		<div id="obj_links_js">
			<form>
				<a class="js show_all" href="javascript:;"><?php echo __('Tout montrer'); ?></a>
				<span class="sep">-</span>
				<a class="js hide_all" href="javascript:;"><?php echo __('Tout cacher'); ?></a>
				&nbsp;<?php echo __('pour'); ?>&nbsp;
				<select id="show_items">
					<option value="obj_fold"><?php echo __('Tout'); ?></option>
					<option value="obj_fold_infos"><?php echo __('Informations'); ?></option>
					<option value="obj_fold_stats"><?php echo __('Statistiques'); ?></option>
				</select>
			</form>
<?php include('object_select.tpl.php'); ?>
		</div>

		<form<?php if ($tpl['options']['thumbs_size'][1]['selected']) : ?> class="large"<?php endif; ?> id="obj_form" action="<?php echo $tpl['current_url']; ?>" method="post">

<?php foreach ($tpl['users'] as &$i) : ?>
			<div id="obj_<?php echo $i['id']; ?>" class="large selectable_class obj<?php if ($i['pending']) : ?> obj_pending<?php endif; ?><?php if ($i['deactivated']) : ?> obj_deactivated<?php endif; ?><?php if (!$i['activated']) : ?> obj_invisible<?php endif; ?><?php if (isset($_POST['selected'][$i['id']])) : ?> selected<?php endif; ?>">
				<div class="obj_body">
					<div class="obj_image">
						<a title="<?php echo __('Modifier l\'avatar'); ?>" href="<?php echo $tpl['link']('user-avatar/' . $i['id']); ?>">
							<img
								alt="<?php printf(__('Avatar de %s'), $i['nickname']); ?>"
								src="<?php echo $i['avatar_src']; ?>">
						</a>
					</div>
					<div class="obj_infos">
						<div class="obj_basics">
							<p class="obj_title">
								<span class="obj_title_link">
									<a title="<?php echo __('Éditer le profil'); ?>" href="<?php echo $tpl['link']('user/' . $i['id']); ?>"><?php echo $i['nickname']; ?></a>
								</span>
<?php if ($i['gallery_link']) : ?>
								<a title="<?php echo __('Voir dans la galerie'); ?>" class="obj_gallery_link" href="<?php echo $i['gallery_link']; ?>"></a>
<?php endif; ?>
							</p>
							<p class="obj_status"><span><?php echo $i['status_text']; ?></span></p>
						</div>
						<div class="obj_details">
							<p class="obj_links">
<?php if ($tpl['profile_activated']) : ?>
								<span class="icon icon_profile show_parts"><a data-id="obj_fold_infos_<?php echo $i['id']; ?>" class="js" href="javascript:;"><?php echo __('Informations'); ?></a></span>
								&nbsp;-&nbsp;
<?php endif; ?>
								<span class="icon icon_stats show_parts"><a data-id="obj_fold_stats_<?php echo $i['id']; ?>" class="js" href="javascript:;"><?php echo __('Statistiques'); ?></a></span>
							</p>
							<p class="obj_cat">
								<a title="<?php echo __('Éditer le groupe'); ?>" href="<?php echo $tpl['link']('group/' . $i['group_id']); ?>"><?php echo $i['group_name']; ?></a>
<?php if ($i['superadmin']) : ?>
								<img title="<?php echo __('Super-administrateur'); ?>" width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/crown.png">
<?php elseif ($i['admin']) : ?>
								<img title="<?php echo __('Administrateur'); ?>" width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/medal.png">
<?php endif; ?>
							</p>
						</div>
					</div>
					<div class="obj_checkbox<?php if ($i['perm_delete']) : ?> selectable_zone<?php endif; ?>">
						<input<?php if (isset($_POST['selected'][$i['id']])) : ?> checked<?php endif; ?><?php if (!$i['perm_delete']) : ?> disabled<?php endif; ?> class="selectable" name="selected[<?php echo $i['id']; ?>]" type="checkbox">
					</div>
				</div>
<?php if ($tpl['profile_activated']) : ?>
				<div class="obj_fold obj_fold_infos" id="obj_fold_infos_<?php echo $i['id']; ?>">
					<table class="light">
<?php if ($tpl['profile_params']['nickname']['activated']) : ?>
						<tr>
							<td><?php echo __('Nom d\'utilisateur'); ?></td>
							<td><?php echo $i['login']; ?></td>
						</tr>
						<tr>
							<td><?php echo __('Pseudonyme'); ?></td>
							<td><?php echo $i['nickname'] != '' ? $i['nickname'] : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php if ($tpl['profile_params']['name']['activated']) : ?>
						<tr>
							<td><?php echo __('Nom'); ?></td>
							<td><?php echo $i['name'] != '' ? $i['name'] : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php if ($tpl['profile_params']['firstname']['activated']) : ?>
						<tr>
							<td><?php echo __('Prénom'); ?></td>
							<td><?php echo $i['firstname'] != '' ? $i['firstname'] : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php if ($tpl['profile_params']['gender']['activated']) : ?>
						<tr>
							<td><?php echo __('Genre'); ?></td>
							<td><?php echo $i['gender']; ?></td>
						</tr>
<?php endif; ?>
<?php if ($tpl['profile_params']['birthdate']['activated']) : ?>
						<tr>
							<td><?php echo __('Date de naissance'); ?></td>
							<td><?php echo $i['birthdate'] != '' ? $i['birthdate'] : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php if ($tpl['profile_params']['email']['activated']) : ?>
						<tr>
							<td><?php echo __('Courriel'); ?></td>
							<td><?php echo $i['email'] != '' ? '<a class="ex" href="mailto:' . $i['email'] . '">' . $i['email'] . '</a>' : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php if ($tpl['profile_params']['website']['activated']) : ?>
						<tr>
							<td><?php echo __('Site Web'); ?></td>
							<td><?php echo $i['website'] != '' ? '<a class="ex" href="' . $i['website'] . '">' . $i['website'] . '</a>' : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php if ($tpl['profile_params']['location']['activated']) : ?>
						<tr>
							<td><?php echo __('Localisation'); ?></td>
							<td><?php echo $i['location'] != '' ? $i['location'] : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php if ($tpl['profile_params']['description']['activated']) : ?>
						<tr>
							<td><?php echo __('Description'); ?></td>
							<td><?php echo $i['description'] != '' ? nl2br($i['description']) : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php for ($n = 1; $n <= 5; $n++) : ?>
<?php if ($tpl['profile_params']['custom_' . $n]['activated']) : ?>
						<tr>
							<td><?php echo $tpl['profile_custom'][$n]; ?></td>
							<td><?php echo $i['custom_' . $n] != '' ? $i['custom_' . $n] : '/'; ?></td>
						</tr>
<?php endif; ?>
<?php endfor; ?>
					</table>
				</div>
<?php endif; ?>
				<div class="obj_fold obj_fold_stats" id="obj_fold_stats_<?php echo $i['id']; ?>">
<?php include('user_stats.tpl.php'); ?>
				</div>
			</div>
<?php endforeach; ?>

			<div id="submit" class="submit_actions<?php if ($tpl['nb_pages'] > 1) : ?> submit_pages<?php endif; ?>">
				<div>
					<div id="form_actions">
						<label for="selection_action"><?php printf(__('Action sur la sélection (%s) :'), '<span id="select_num">' . (empty($_POST['selected']) ? 0 : count($_POST['selected'])) . '</span>'); ?></label>
						<select id="selection_action" name="action">
							<optgroup label="<?php echo __('État'); ?>">
								<option value="activate"><?php echo __('Activer'); ?></option>
								<option value="deactivate"><?php echo __('Désactiver'); ?></option>
							</optgroup>
							<optgroup label="<?php echo __('Groupe'); ?>">
								<option class="sublist" data-id="list_groups" value="change_group_confirm"><?php echo __('Changer le groupe'); ?></option>
							</optgroup>
							<optgroup label="<?php echo __('Courriel'); ?>">
								<option value="sendmail"><?php echo __('Envoyer un courriel'); ?></option>
							</optgroup>
							<optgroup label="<?php echo __('Suppression'); ?>">
								<option value="delete_confirm"><?php echo __('Supprimer'); ?></option>
							</optgroup>
						</select>
						<p class="action_second" id="list_groups">
							<select name="group_id">
<?php foreach ($tpl['groups'] as &$i) : ?>
<?php if ($i['id'] > 2) : ?>
								<option value="<?php echo $i['id']; ?>"><?php echo $i['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
							</select>
						</p>
						<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
						<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
					</div>
				</div>
			</div>
		</form>

		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var confirm_delete = "<?php echo $tpl['php2js']($confirm_delete); ?>";
		</script>

<?php include('pagination.tpl.php'); ?>

<?php else : ?>
		<br>
		<div class="report_classic">
			<div class="report_msg report_info">
				<p><?php echo (isset($_GET['search'])) ? __('Aucun utilisateur trouvé.') : __('Aucun utilisateur en attente.'); ?></p>
			</div>
		</div>
<?php endif; ?>

<?php endif; ?>

	</div>
</div>