
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `igalerie312`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cameras_brands`
--

CREATE TABLE `[[dbprefix]]cameras_brands` (
  `camera_brand_id` int(11) NOT NULL AUTO_INCREMENT,
  `camera_brand_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `camera_brand_url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`camera_brand_id`),
  UNIQUE KEY `[[dbprefix]]cameras_brands_uk1` (`camera_brand_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cameras_items`
--

CREATE TABLE `[[dbprefix]]cameras_items` (
  `camera_model_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  UNIQUE KEY `[[dbprefix]]cameras_items_uk1` (`item_id`),
  KEY `[[dbprefix]]cameras_items_fk1` (`camera_model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cameras_models`
--

CREATE TABLE `[[dbprefix]]cameras_models` (
  `camera_model_id` int(11) NOT NULL AUTO_INCREMENT,
  `camera_brand_id` int(11) NOT NULL,
  `camera_model_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `camera_model_url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`camera_model_id`),
  UNIQUE KEY `[[dbprefix]]cameras_models_uk1` (`camera_model_name`),
  KEY `[[dbprefix]]cameras_models_fk1` (`camera_brand_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `thumb_id` int(11) NOT NULL DEFAULT '0',
  `password_id` int(11) DEFAULT NULL,
  `cat_parents` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.',
  `parent_id` int(11) NOT NULL DEFAULT '1',
  `cat_path` varbinary(767) NOT NULL,
  `cat_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cat_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cat_desc` text COLLATE utf8mb4_unicode_ci,
  `cat_lat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_long` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_tb_params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_a_size` bigint(20) NOT NULL DEFAULT '0',
  `cat_a_subalbs` int(11) NOT NULL DEFAULT '0',
  `cat_a_subcats` int(11) NOT NULL DEFAULT '0',
  `cat_a_albums` int(11) NOT NULL DEFAULT '0',
  `cat_a_images` int(11) NOT NULL DEFAULT '0',
  `cat_a_videos` int(11) NOT NULL DEFAULT '0',
  `cat_a_hits` bigint(20) NOT NULL DEFAULT '0',
  `cat_a_comments` int(11) NOT NULL DEFAULT '0',
  `cat_a_votes` int(11) NOT NULL DEFAULT '0',
  `cat_a_rating` double NOT NULL DEFAULT '0',
  `cat_a_favorites` int(11) NOT NULL DEFAULT '0',
  `cat_d_size` bigint(20) NOT NULL DEFAULT '0',
  `cat_d_subalbs` int(11) NOT NULL DEFAULT '0',
  `cat_d_subcats` int(11) NOT NULL DEFAULT '0',
  `cat_d_albums` int(11) NOT NULL DEFAULT '0',
  `cat_d_images` int(11) NOT NULL DEFAULT '0',
  `cat_d_videos` int(11) NOT NULL DEFAULT '0',
  `cat_d_hits` bigint(20) NOT NULL DEFAULT '0',
  `cat_d_comments` int(11) NOT NULL DEFAULT '0',
  `cat_d_votes` int(11) NOT NULL DEFAULT '0',
  `cat_d_rating` double NOT NULL DEFAULT '0',
  `cat_d_favorites` int(11) NOT NULL DEFAULT '0',
  `cat_votable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `cat_commentable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `cat_downloadable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `cat_uploadable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `cat_creatable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `cat_crtdt` datetime NOT NULL,
  `cat_lastpubdt` datetime DEFAULT NULL,
  `cat_filemtime` datetime DEFAULT NULL,
  `cat_orderby` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_watermark` text COLLATE utf8mb4_unicode_ci,
  `cat_status` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `cat_position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`),
  UNIQUE KEY `[[dbprefix]]categories_uk1` (`cat_path`),
  KEY `[[dbprefix]]categories_fk1` (`user_id`),
  KEY `[[dbprefix]]categories_fk2` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 1, 0, NULL, '1.', 1, '.', '', '', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '1', '1', '1', '1', '1', '[[regtime]]', NULL, NULL, NULL, NULL, '1', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `com_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '2',
  `com_crtdt` datetime NOT NULL,
  `com_lastupddt` datetime NOT NULL,
  `com_author` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_email` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `com_website` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `com_ip` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_status` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`com_id`),
  KEY `[[dbprefix]]comments_fk1` (`user_id`),
  KEY `[[dbprefix]]comments_fk2` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `conf_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `conf_value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`conf_name`),
  UNIQUE KEY `[[dbprefix]]config_uk1` (`conf_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('admin_link', '1'),
('albums_download', '0'),
('app_history', '[{"version":"3.1.2","date":"[[regtime]]"}]'),
('app_version', '3.1.2'),
('blacklist_emails', ''),
('blacklist_ips', ''),
('blacklist_names', '*best price*\n*casino*\n*cialis*\n*viagra*'),
('blacklist_words', '<embed\n<html\n<img\n<meta\n<object\n<script\n<style\n[email\n[img\n[url\nhref =\nhref=\nsrc =\nsrc='),
('browse', '1'),
('browse_ajax', '0'),
('browse_items_count', '0'),
('browse_sql_order_by', 'cat_name ASC'),
('categories_description_model', '0'),
('categories_description_model_text', '{DESCRIPTION}'),
('categories_sql_order_by', 'cat_name ASC'),
('categories_stats', '1'),
('categories_stats_order', '["items","images","videos","albums","filesize","recent_items","recent_images","recent_videos","views","comments","rating","votes","favorites"]'),
('categories_stats_params', '{"albums":{"status":1},"comments":{"status":1},"favorites":{"status":1},"filesize":{"status":0},"images":{"status":1},"items":{"status":0},"rating":{"status":0},"recent_images":{"status":1},"recent_items":{"status":0},"recent_videos":{"status":0},"videos":{"status":0},"views":{"status":1},"votes":{"status":1}}'),
('comments', '0'),
('comments_antiflood', '60'),
('comments_emoji_delete', '0'),
('comments_emoji_picker', '1'),
('comments_maxchars', '1000'),
('comments_maxlines', '20'),
('comments_maxurls', '1'),
('comments_moderate', '0'),
('comments_order_by', 'ASC'),
('comments_page_count', '20'),
('comments_read_only', '0'),
('comments_required_email', '0'),
('comments_required_website', '0'),
('comments_url_to_link', '1'),
('comments_url_to_link_maxlength', '40'),
('daily_update', '[[regdate]]'),
('dates_expiration', '[]'),
('dates_publication', '[]'),
('diaporama', '1'),
('diaporama_auto_duration', '3'),
('diaporama_auto_loop', '0'),
('diaporama_auto_start', '0'),
('diaporama_carousel', '1'),
('diaporama_carousel_thumbs_ratio', 'normal'),
('diaporama_carousel_thumbs_size', '80'),
('diaporama_control_bars', '1'),
('diaporama_fullscreen', '0'),
('diaporama_fullscreen_mobile', '1'),
('diaporama_keyboard', '1'),
('diaporama_over_image_description', '0'),
('diaporama_over_image_title', '0'),
('diaporama_show_informations', '0'),
('diaporama_transition_duration', '500'),
('diaporama_transition_effect', 'fade'),
('diaporama_zoom', '1'),
('diaporama_zoom_limit', '100'),
('download_item', '1'),
('exif', '0'),
('exif_order', '["Make","Model","Lens","DateTimeOriginal","DateTimeDigitized","DateTime","GPSCoordinates","GPSAltitude","LightSource","Flash","FNumber","MaxApertureValue","FocalLength","FocalLengthIn35mmFilm","DigitalZoomRatio","ISOSpeedRatings","ExposureBiasValue","ExposureMode","ExposureProgram","ExposureTime","SceneType","SceneCaptureType","CustomRendered","MeteringMode","Orientation","WhiteBalance","SensingMethod","SubjectDistanceRange","SubjectDistance","XResolution","YResolution","ResolutionUnit","ColorSpace","GainControl","Contrast","Saturation","Sharpness","Software","Artist","Copyright","ExifVersion","FlashPixVersion"]'),
('exif_params', '{"Artist":{"status":0},"ColorSpace":{"status":0},"Contrast":{"status":0},"Copyright":{"status":0},"CustomRendered":{"status":0},"DateTime":{"status":0},"DateTimeDigitized":{"status":0},"DateTimeOriginal":{"status":1},"DigitalZoomRatio":{"status":0,"format":"%2.1Fx"},"ExifVersion":{"status":0},"ExposureBiasValue":{"status":0,"format":"%+2.2F Ev"},"ExposureMode":{"status":0},"ExposureProgram":{"status":0},"ExposureTime":{"status":1},"Flash":{"status":1},"FlashPixVersion":{"status":0},"FNumber":{"status":1,"format":"f\\/%2.1F"},"FocalLength":{"status":1,"format":"%2.2F mm"},"FocalLengthIn35mmFilm":{"status":0,"format":"%2.2F mm"},"GainControl":{"status":0},"GPSAltitude":{"status":0,"format":"%.2F m"},"GPSCoordinates":{"status":0},"ISOSpeedRatings":{"status":1},"Lens":{"status":1},"LightSource":{"status":0},"Make":{"status":1},"MaxApertureValue":{"status":0,"format":"%2.2F mm"},"MeteringMode":{"status":0},"Model":{"status":1},"Orientation":{"status":0},"ResolutionUnit":{"status":0},"Saturation":{"status":0},"SceneCaptureType":{"status":0},"SceneType":{"status":0},"SensingMethod":{"status":0},"Sharpness":{"status":0},"Software":{"status":0},"SubjectDistance":{"status":0,"format":"%2.2F m"},"SubjectDistanceRange":{"status":0},"WhiteBalance":{"status":0},"XResolution":{"status":0,"format":"%d"},"YResolution":{"status":0,"format":"%d"}}'),
('favorites', '1'),
('favorites_download', '0'),
('gallery_closed', '0'),
('gallery_closed_text', ''),
('gallery_description', ''),
('gallery_footer_text', ''),
('gallery_title', '[[site_name]]'),
('geolocation', '0'),
('geolocation_default_layer', 'map'),
('geolocation_default_zoom', '12'),
('iptc', '0'),
('iptc_get_data', '1'),
('iptc_order', '["ObjectName","Headline","Description","DescriptionWriter","Keywords","Copyright","Source","Contact","Creator","CreatorTitle","Credit","Instructions","Country","CountryCode","ProvinceState","City","SubLocation","DateCreated","TimeCreated","DigitalCreationDate","DigitalCreationTime","Orientation","Software","SoftwareVersion"]'),
('iptc_params', '{"City":{"status":1},"Contact":{"status":1},"Copyright":{"status":1},"Country":{"status":0},"CountryCode":{"status":0},"Creator":{"status":1},"CreatorTitle":{"status":0},"Credit":{"status":1},"DateCreated":{"status":1},"Description":{"status":1},"DescriptionWriter":{"status":0},"DigitalCreationDate":{"status":1},"DigitalCreationTime":{"status":0},"Headline":{"status":0},"Instructions":{"status":0},"Keywords":{"status":1},"ObjectName":{"status":1},"Orientation":{"status":0},"ProvinceState":{"status":0},"Software":{"status":0},"SoftwareVersion":{"status":0},"Source":{"status":1},"SubLocation":{"status":0},"TimeCreated":{"status":0}}'),
('iptc_title_tag', 'Headline'),
('items_description_model', '0'),
('items_description_model_text', '{DESCRIPTION}'),
('items_recent', '1'),
('items_recent_days', '7'),
('items_resize', '0'),
('items_resize_height', '1200'),
('items_resize_quality', '90'),
('items_resize_type', 'webp'),
('items_resize_width', '1200'),
('items_sql_order_by', 'item_pubdt DESC'),
('lang_default', '[[language]]'),
('lang_detect', '1'),
('lang_params', '{"filemtime":1768172372,"langs":{"en":"English","fr":"Français"}}'),
('lang_switch', '1'),
('links', '1'),
('links_params', '[]'),
('mail_auto_bcc', '1'),
('mail_auto_primary_recipient_address', ''),
('mail_auto_sender_address', '[[admin_email]]'),
('mail_auto_sender_name', 'iGalerie'),
('mail_auto_signature', '0'),
('mail_auto_signature_text', ''),
('mail_notify_comment_follow_message', 'A new comment has been posted on the {ITEM_URL} file you are following.\n\nThis message has been sent to you automatically because you have activated the "New comments on photos or videos where I have posted" notification option in your profile.'),
('mail_notify_comment_follow_subject', '[{GALLERY_TITLE}] New comment (follow-up)'),
('mail_notify_comment_message', 'A new comment has been posted by {USER_NAME} in the gallery {GALLERY_URL} on the file {ITEM_URL}.'),
('mail_notify_comment_pending_message', 'A new comment has been posted by {USER_NAME} in the {GALLERY_URL} gallery and is awaiting validation.'),
('mail_notify_comment_pending_subject', '[{GALLERY_TITLE}] New comment (pending)'),
('mail_notify_comment_subject', '[{GALLERY_TITLE}] New comment'),
('mail_notify_items_http_message', 'New files have been added to the gallery {GALLERY_URL} in the album "{ALBUM_TITLE}" by {USER_NAME}.'),
('mail_notify_items_http_subject', '[{GALLERY_TITLE}] New files'),
('mail_notify_items_message', 'New files have been added to the {GALLERY_URL} gallery.'),
('mail_notify_items_pending_message', 'New files have been added to the gallery {GALLERY_URL} in the album "{ALBUM_TITLE}" by {USER_NAME} and are awaiting validation.'),
('mail_notify_items_pending_subject', '[{GALLERY_TITLE}] New files (pending)'),
('mail_notify_items_subject', '[{GALLERY_TITLE}] New files'),
('mail_notify_registration_message', 'User {USER_NAME} has just registered in gallery {GALLERY_URL}.\n\nYou can view his profile here: {USER_URL}'),
('mail_notify_registration_pending_message', 'User {USER_NAME} has just registered in gallery {GALLERY_URL} and is awaiting validation.'),
('mail_notify_registration_pending_subject', '[{GALLERY_TITLE}] New registration (pending)'),
('mail_notify_registration_subject', '[{GALLERY_TITLE}] New registration'),
('new_version', '{"md5":"5fbf387e91c185e55b7f25844518ba40","php":"7.2","version":"3.1.2"}'),
('new_version_check', '1'),
('new_version_check_date', '[[regdate]]'),
('pages_order', '["comments","tags","history","cameras","worldmap","members","contact"]'),
('pages_params', '{"cameras":{"status":0},"comments":{"status":1,"nb_per_page":20},"contact":{"status":0,"email":"[[admin_email]]","message":""},"history":{"status":0},"members":{"status":1,"nb_per_page":20,"order_by":"user_crtdt DESC","show_crtdt":1,"show_lastvstdt":0,"show_title":1},"tags":{"status":1},"worldmap":{"status":1,"center_lat":46.5,"center_long":3,"zoom":4}}'),
('random_item', '0'),
('rss', '0'),
('rss_max_items', '20'),
('search', '0'),
('search_advanced', '0'),
('search_suggestion', '0'),
('selection', '0'),
('stats_short_numbers', '1'),
('tags', '0'),
('tags_max', '15'),
('theme_params', ''),
('theme_template', 'default'),
('thumbs_cat_info_albums', '1'),
('thumbs_cat_info_comments', '1'),
('thumbs_cat_info_description', '0'),
('thumbs_cat_info_description_limit', '500'),
('thumbs_cat_info_favorites', '1'),
('thumbs_cat_info_filesize', '0'),
('thumbs_cat_info_items', '1'),
('thumbs_cat_info_rating', '1'),
('thumbs_cat_info_title', '1'),
('thumbs_cat_info_views', '1'),
('thumbs_cat_info_votes', '1'),
('thumbs_cat_nb_per_page', '12'),
('thumbs_item_info_comments', '1'),
('thumbs_item_info_date', '0'),
('thumbs_item_info_description', '0'),
('thumbs_item_info_description_limit', '500'),
('thumbs_item_info_favorites', '1'),
('thumbs_item_info_filesize', '0'),
('thumbs_item_info_rating', '0'),
('thumbs_item_info_size', '0'),
('thumbs_item_info_title', '1'),
('thumbs_item_info_views', '1'),
('thumbs_item_info_votes', '1'),
('thumbs_item_nb_per_page', '24'),
('thumbs_quality', '90'),
('thumbs_type', 'webp'),
('tz_default', 'Europe/Paris'),
('upload_maxfilesize', '100'),
('upload_maxheight', '8000'),
('upload_maxtotalfiles', '100'),
('upload_maxwidth', '8000'),
('upload_resize', '0'),
('upload_resize_maxheight', '768'),
('upload_resize_maxwidth', '1024'),
('upload_resize_quality', '95'),
('users', '0'),
('users_description_maxlength', '500'),
('users_items_resize', '1'),
('users_items_resize_height', '768'),
('users_items_resize_quality', '90'),
('users_items_resize_type', 'webp'),
('users_items_resize_width', '1024'),
('users_log_activity', '1'),
('users_log_activity_delete', '1'),
('users_log_activity_delete_days', '10'),
('users_log_activity_no_admin', '0'),
('users_log_activity_rejected_only', '1'),
('users_online', '0'),
('users_online_duration', '300'),
('users_only_members', '0'),
('users_only_members_contact', '0'),
('users_password_minlength', '6'),
('users_profile_params', '{"birthdate":{"activated":0,"required":0},"description":{"activated":1,"required":0},"email":{"activated":1,"required":0},"firstname":{"activated":0,"required":0},"gender":{"activated":0,"required":0},"group_id":{"activated":1,"required":1},"lang":{"activated":1,"required":0},"location":{"activated":0,"required":0},"login":{"activated":1,"required":1},"name":{"activated":0,"required":0},"nickname":{"activated":0,"required":0},"password":{"activated":1,"required":0},"custom_1":{"activated":0,"required":0,"name":""},"custom_2":{"activated":0,"required":0,"name":""},"custom_3":{"activated":0,"required":0,"name":""},"custom_4":{"activated":0,"required":0,"name":""},"custom_5":{"activated":0,"required":0,"name":""},"status":{"activated":1,"required":1},"tz":{"activated":1,"required":0},"website":{"activated":1,"required":0}}'),
('users_registration', '1'),
('users_registration_password', ''),
('users_registration_password_text', ''),
('users_registration_valid_admin', '0'),
('users_registration_valid_email', '1'),
('users_registration_valid_password', '0'),
('video_captures', '0'),
('video_loop', '0'),
('video_muted', '0'),
('views_admin', '0'),
('views_ip', '0'),
('views_ip_list', ''),
('views_useragent', '1'),
('views_useragent_list', '*addthis*\n*admantx*\n*ads*\n*ahrefs*\n*alexa*\n*archive*\n*ask*\n*baidu*\n*bing*\n*bot*\n*b-o-t*\n*bubing*\n*crawl*\n*dataprovider*\n*daum*\n*envolk*\n*evaliant*\n*exalead*\n*explorer*\n*facebook*\n*fetcher*\n*genieo*\n*gigablast*\n*google*\n*ichiro*\n*jobboerse*\n*mail.ru*\n*megaindex*\n*netcraft*\n*newspaper*\n*owlin*\n*panscient*\n*pinterest*\n*qwant*\n*riddler*\n*search*\n*seo*\n*sistrix*\n*slurp*\n*sogou*\n*scoutjet*\n*spider*\n*squider*\n*thetradedesk*\n*vagabondo*\n*yahoo*\n*yandex*\n*yeti*\n*zgrab*'),
('votes', '0'),
('welcome', '1'),
('xmp', '0'),
('xmp_get_data', '1'),
('xmp_order', '["Contributor","Coverage","Creator","Date","Description","Format","Identifier","Language","Publisher","Relation","Rights","Source","Subject","Title","Type"]'),
('xmp_params', '{"Contributor":{"status":0},"Coverage":{"status":0},"Creator":{"status":1},"Date":{"status":1},"Description":{"status":1},"Format":{"status":0},"Identifier":{"status":0},"Language":{"status":0},"Publisher":{"status":0},"Relation":{"status":0},"Rights":{"status":1},"Source":{"status":0},"Subject":{"status":0},"Title":{"status":1},"Type":{"status":0}}'),
('xmp_priority', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favorites`
--

CREATE TABLE `[[dbprefix]]favorites` (
  `user_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `fav_date` datetime NOT NULL,
  UNIQUE KEY `[[dbprefix]]favorites_uk1` (`user_id`,`item_id`),
  KEY `[[dbprefix]]favorites_fk2` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_desc` text COLLATE utf8mb4_unicode_ci,
  `group_crtdt` datetime NOT NULL,
  `group_perms` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_admin` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
(1, '', '', NULL, '[[regtime]]', '{"albums_download":1,"comments_add":1,"comments_add_mode":1,"comments_read":1,"create_albums":0,"create_albums_categories":0,"create_albums_gallery_root":0,"create_albums_owner":0,"image_original":1,"members_profile":1,"perm_list":"black","selection":0,"upload":0,"upload_mode":1,"upload_owner":0,"upload_type":"all","votes":1}', '1'),
(2, '', '', NULL, '[[regtime]]', '{"albums_download":1,"comments_add":1,"comments_add_mode":1,"comments_read":1,"create_albums":0,"create_albums_categories":0,"create_albums_gallery_root":0,"create_albums_owner":0,"image_original":1,"members_profile":1,"perm_list":"black","selection":0,"upload":0,"upload_mode":1,"upload_owner":0,"upload_type":"all","votes":1}', '0'),
(3, '', '', NULL, '[[regtime]]', '{"albums_download":1,"comments_add":1,"comments_add_mode":1,"comments_read":1,"create_albums":0,"create_albums_categories":0,"create_albums_gallery_root":0,"create_albums_owner":0,"image_original":1,"members_profile":1,"perm_list":"black","selection":0,"upload":0,"upload_mode":1,"upload_owner":0,"upload_type":"all","votes":1}', '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups_permissions`
--

CREATE TABLE `[[dbprefix]]groups_permissions` (
  `group_id` int(11) NOT NULL,
  `cat_id` int(11) NOT NULL,
  `perm_list` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `[[dbprefix]]groups_permissions_uk1` (`group_id`,`cat_id`,`perm_list`),
  KEY `[[dbprefix]]groups_permissions_fk2` (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]items`
--

CREATE TABLE `[[dbprefix]]items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `cat_id` int(11) NOT NULL,
  `item_type` smallint(6) NOT NULL,
  `item_path` varbinary(767) NOT NULL,
  `item_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_width` int(11) NOT NULL,
  `item_height` int(11) NOT NULL,
  `item_duration` smallint(6) DEFAULT NULL,
  `item_tb_params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_filesize` int(11) NOT NULL,
  `item_exif` text COLLATE utf8mb4_unicode_ci,
  `item_iptc` text COLLATE utf8mb4_unicode_ci,
  `item_xmp` text COLLATE utf8mb4_unicode_ci,
  `item_orientation` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `item_lat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_long` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_desc` text COLLATE utf8mb4_unicode_ci,
  `item_adddt` datetime NOT NULL,
  `item_pubdt` datetime DEFAULT NULL,
  `item_expdt` datetime DEFAULT NULL,
  `item_crtdt` datetime DEFAULT NULL,
  `item_hits` bigint(20) NOT NULL DEFAULT '0',
  `item_comments` int(11) NOT NULL DEFAULT '0',
  `item_votes` int(11) NOT NULL DEFAULT '0',
  `item_rating` double NOT NULL DEFAULT '0',
  `item_favorites` int(11) NOT NULL DEFAULT '0',
  `item_votable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `item_commentable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `item_downloadable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `item_status` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `item_position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `[[dbprefix]]items_uk1` (`item_path`),
  KEY `[[dbprefix]]items_fk1` (`user_id`),
  KEY `[[dbprefix]]items_fk2` (`cat_id`),
  KEY `[[dbprefix]]items_pubdt_idx` (`item_pubdt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]items_pending`
--

CREATE TABLE `[[dbprefix]]items_pending` (
  `pending_id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `pending_file` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pending_type` smallint(6) NOT NULL,
  `pending_filesize` int(11) NOT NULL,
  `pending_exif` text COLLATE utf8mb4_unicode_ci,
  `pending_iptc` text COLLATE utf8mb4_unicode_ci,
  `pending_xmp` text COLLATE utf8mb4_unicode_ci,
  `pending_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pending_height` smallint(6) NOT NULL,
  `pending_width` smallint(6) NOT NULL,
  `pending_duration` smallint(6) DEFAULT NULL,
  `pending_adddt` datetime NOT NULL,
  `pending_ip` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`pending_id`),
  UNIQUE KEY `[[dbprefix]]items_pending_uk1` (`pending_file`,`cat_id`),
  KEY `[[dbprefix]]items_pending_fk1` (`cat_id`),
  KEY `[[dbprefix]]items_pending_fk2` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]passwords`
--

CREATE TABLE `[[dbprefix]]passwords` (
  `password_id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL,
  `password_hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`password_id`),
  UNIQUE KEY `[[dbprefix]]passwords_uk1` (`password_hash`),
  KEY `[[dbprefix]]passwords_fk1` (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search`
--

CREATE TABLE `[[dbprefix]]search` (
  `search_id` char(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `search_query` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `search_options` text COLLATE utf8mb4_unicode_ci,
  `search_date` datetime NOT NULL,
  PRIMARY KEY (`search_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]selection`
--

CREATE TABLE `[[dbprefix]]selection` (
  `user_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `selection_date` datetime NOT NULL,
  UNIQUE KEY `[[dbprefix]]selection_uk1` (`user_id`,`item_id`),
  KEY `[[dbprefix]]selection_fk2` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `session_id` int(11) NOT NULL AUTO_INCREMENT,
  `session_token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expire` datetime NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `[[dbprefix]]sessions_uk1` (`session_token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]sessions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions_categories`
--

CREATE TABLE `[[dbprefix]]sessions_categories` (
  `session_id` int(11) NOT NULL,
  `cat_id` int(11) NOT NULL,
  UNIQUE KEY `[[dbprefix]]sessions_categories_uk1` (`session_id`,`cat_id`),
  KEY `[[dbprefix]]sessions_categories_fk2` (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions_users`
--

CREATE TABLE `[[dbprefix]]sessions_users` (
  `session_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  UNIQUE KEY `[[dbprefix]]sessions_users_uk1` (`session_id`,`user_id`),
  KEY `[[dbprefix]]sessions_users_fk2` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]sessions_users`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats`
--

CREATE TABLE `[[dbprefix]]stats` (
  `stat_date` date NOT NULL,
  `stat_albums` int(11) NOT NULL,
  `stat_images` int(11) NOT NULL,
  `stat_videos` int(11) NOT NULL,
  `stat_size` bigint(20) NOT NULL,
  `stat_hits` bigint(20) NOT NULL,
  `stat_comments` int(11) NOT NULL,
  `stat_votes` int(11) NOT NULL,
  `stat_favorites` int(11) NOT NULL,
  `stat_users` smallint(6) NOT NULL,
  PRIMARY KEY (`stat_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tag_url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `[[dbprefix]]tags_uk1` (`tag_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags_items`
--

CREATE TABLE `[[dbprefix]]tags_items` (
  `tag_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  UNIQUE KEY `[[dbprefix]]tags_items_uk1` (`tag_id`,`item_id`),
  KEY `[[dbprefix]]tags_items_fk2` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL DEFAULT '3',
  `user_login` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_nickname` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_firstname` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_gender` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '?',
  `user_birthdate` date DEFAULT NULL,
  `user_location` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_description` text COLLATE utf8mb4_unicode_ci,
  `user_email` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_website` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_custom_1` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_custom_2` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_custom_3` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_custom_4` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_custom_5` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_prefs` text COLLATE utf8mb4_unicode_ci,
  `user_watermark` text COLLATE utf8mb4_unicode_ci,
  `user_avatar` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `user_nohits` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `user_alert` char(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '000000',
  `user_lang` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_tz` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_status` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `user_crtdt` datetime NOT NULL,
  `user_crtip` varchar(39) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_lastvstdt` datetime DEFAULT NULL,
  `user_lastvstip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_rkey` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_rdate` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `[[dbprefix]]users_uk1` (`user_login`),
  UNIQUE KEY `[[dbprefix]]users_uk2` (`user_password`),
  KEY `[[dbprefix]]users_fk1` (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, 1, '[[admin_username]]', '[[admin_pass]]', NULL, NULL, NULL, '?', NULL, NULL, NULL, '[[admin_email]]', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0', '111111', '[[language]]', 'Europe/Paris', '1', '[[regtime]]', '[[clientip]]', '[[regtime]]', '[[clientip]]', NULL, NULL),
(2, 2, 'guest', '$2y$10$wkiyBBFoIxqeoxO2nSavoeznWAm4OQ3PdQ8AKZDbn1lt/byQ7alEi', NULL, NULL, NULL, '?', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0', '000000', 'en', 'Europe/Paris', '1', '[[regtime]]', '', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_logs`
--

CREATE TABLE `[[dbprefix]]users_logs` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `log_page` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL,
  `log_action` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_match` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_post` text COLLATE utf8mb4_unicode_ci,
  `log_ip` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `[[dbprefix]]users_logs_fk1` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]votes`
--

CREATE TABLE `[[dbprefix]]votes` (
  `vote_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '2',
  `vote_rating` int(11) NOT NULL,
  `vote_date` datetime NOT NULL,
  `vote_ip` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vote_cookie` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`vote_id`),
  KEY `[[dbprefix]]votes_fk1` (`user_id`),
  KEY `[[dbprefix]]votes_fk2` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]cameras_items`
--
ALTER TABLE `[[dbprefix]]cameras_items`
  ADD CONSTRAINT `[[dbprefix]]cameras_items_fk1` FOREIGN KEY (`camera_model_id`) REFERENCES `[[dbprefix]]cameras_models` (`camera_model_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]cameras_items_fk2` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]items` (`item_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]cameras_models`
--
ALTER TABLE `[[dbprefix]]cameras_models`
  ADD CONSTRAINT `[[dbprefix]]cameras_models_fk1` FOREIGN KEY (`camera_brand_id`) REFERENCES `[[dbprefix]]cameras_brands` (`camera_brand_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]categories`
--
ALTER TABLE `[[dbprefix]]categories`
  ADD CONSTRAINT `[[dbprefix]]categories_fk1` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`),
  ADD CONSTRAINT `[[dbprefix]]categories_fk2` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]categories` (`cat_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]comments`
--
ALTER TABLE `[[dbprefix]]comments`
  ADD CONSTRAINT `[[dbprefix]]comments_fk1` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`),
  ADD CONSTRAINT `[[dbprefix]]comments_fk2` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]items` (`item_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]favorites`
--
ALTER TABLE `[[dbprefix]]favorites`
  ADD CONSTRAINT `[[dbprefix]]favorites_fk1` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]favorites_fk2` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]items` (`item_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]groups_permissions`
--
ALTER TABLE `[[dbprefix]]groups_permissions`
  ADD CONSTRAINT `[[dbprefix]]groups_permissions_fk1` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]groups` (`group_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]groups_permissions_fk2` FOREIGN KEY (`cat_id`) REFERENCES `[[dbprefix]]categories` (`cat_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]items`
--
ALTER TABLE `[[dbprefix]]items`
  ADD CONSTRAINT `[[dbprefix]]items_fk1` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`),
  ADD CONSTRAINT `[[dbprefix]]items_fk2` FOREIGN KEY (`cat_id`) REFERENCES `[[dbprefix]]categories` (`cat_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]items_pending`
--
ALTER TABLE `[[dbprefix]]items_pending`
  ADD CONSTRAINT `[[dbprefix]]items_pending_fk1` FOREIGN KEY (`cat_id`) REFERENCES `[[dbprefix]]categories` (`cat_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]items_pending_fk2` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`);

--
-- Constraints for table `[[dbprefix]]passwords`
--
ALTER TABLE `[[dbprefix]]passwords`
  ADD CONSTRAINT `[[dbprefix]]passwords_fk1` FOREIGN KEY (`cat_id`) REFERENCES `[[dbprefix]]categories` (`cat_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]selection`
--
ALTER TABLE `[[dbprefix]]selection`
  ADD CONSTRAINT `[[dbprefix]]selection_fk1` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]selection_fk2` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]items` (`item_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]sessions_categories`
--
ALTER TABLE `[[dbprefix]]sessions_categories`
  ADD CONSTRAINT `[[dbprefix]]sessions_categories_fk1` FOREIGN KEY (`session_id`) REFERENCES `[[dbprefix]]sessions` (`session_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]sessions_categories_fk2` FOREIGN KEY (`cat_id`) REFERENCES `[[dbprefix]]categories` (`cat_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]sessions_users`
--
ALTER TABLE `[[dbprefix]]sessions_users`
  ADD CONSTRAINT `[[dbprefix]]sessions_users_fk1` FOREIGN KEY (`session_id`) REFERENCES `[[dbprefix]]sessions` (`session_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]sessions_users_fk2` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]tags_items`
--
ALTER TABLE `[[dbprefix]]tags_items`
  ADD CONSTRAINT `[[dbprefix]]tags_items_fk1` FOREIGN KEY (`tag_id`) REFERENCES `[[dbprefix]]tags` (`tag_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]tags_items_fk2` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]items` (`item_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]users`
--
ALTER TABLE `[[dbprefix]]users`
  ADD CONSTRAINT `[[dbprefix]]users_fk1` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]groups` (`group_id`);

--
-- Constraints for table `[[dbprefix]]users_logs`
--
ALTER TABLE `[[dbprefix]]users_logs`
  ADD CONSTRAINT `[[dbprefix]]users_logs_fk1` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`);

--
-- Constraints for table `[[dbprefix]]votes`
--
ALTER TABLE `[[dbprefix]]votes`
  ADD CONSTRAINT `[[dbprefix]]votes_fk1` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`user_id`),
  ADD CONSTRAINT `[[dbprefix]]votes_fk2` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]items` (`item_id`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
