<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

use ILIAS\Filesystem\Filesystem;

class ilDclMobFieldModel extends ilDclFileFieldModel
{
    private Filesystem $file_system;

    public function __construct(int $a_id = 0)
    {
        global $DIC;
        $this->file_system = $DIC->filesystem()->web();
        parent::__construct($a_id);
    }

    public function getValidFieldProperties(): array
    {
        return [
            ilDclBaseFieldModel::PROP_WIDTH,
            ilDclBaseFieldModel::PROP_HEIGHT,
            ilDclBaseFieldModel::PROP_LINK_DETAIL_PAGE_MOB
        ];
    }

    public function getFileSystem(): Filesystem
    {
        return $this->file_system;
    }

    public function filenameToAscii(string $filename): string
    {
        return (new ilFileServicesPolicy($this->file_settings))->ascii($filename);
    }

    protected function getExtensions(): array
    {
        return ['jpg', 'jpeg', 'gif', 'png', 'mp3', 'flx', 'mp4', 'm4v', 'mov', 'wmv'];
    }
}
