# Roadmap for the UICore services

### Static Routing (ilCtrl)

The superficial goal for the routing service (ilCtrl) can be easily explained by showing the following example:

- (a) `http://ilias.local/ilias.php?baseClass=ilrepositorygui&cmdNode=xf:lt&cmdClass=ilObjCourseGUI&cmd=view&ref_id=85`
- (b) `https://ilias.local/repository/course/view/85`

ILIAS currently uses an URL similar to (a) in order to show the content of a course. Visually, the goal will be to get
the same result using something in the fashion of URL (b), which is way more reabable and anticipatable. Most
importantly though, it will be **static**, meaning the URL for viewing the content of course nr. 85 will always be the
same. For the current URL this is not the case, due to the dynamic nature of the control-flow, which will be
passed to each request URL and is visible by the `cmdNode` parameter.

### No global state manipulation

Besides having some unpleasing URLs, ilCtrl also struggles with another issue behind the scenes. Currently it is
possible to alter the state of ilCtrl globally, which means any controler can affect the outcome of methods which
generate link targets (URLs). Culprits for such manipulations are mainly `ilCtrl::setParameterByClass()` and
`ilCtrl::saveParameterByClass()`, which will most likely be deprecated in the future. This causes very unpredictable
outcomes which are only ever recognised at runtime, due to the dynamic nature of the control flow. Besides deprecating
these mechanis, we will also introduce new methods to generate isolated link targets if/when possible.

### No dynamic control flow

The underlying structure of ilCtrl is a graph, which has one entrypoint and one endpoint per request, but may use
different paths accross one or multiple other controllers, depending on the `cmdNode` request parameter. This structure
has been used to reuse functionalities of controllers by routing through them. However, routing through multiple
controllers, paradoxically, has led to much redundancy. This is because every controller needs to implement the
`executeCommand()` method which is called by ilCtrl to perform tasks. Because a controller often cannot know which
controllers are called prior to them, developers tend to perform the same tasks in every controller (e.g. access-checks,
setting up tabs, setting request parameters, etc). This issue can only be properly adressed by changing the underlying
data structure and use a more predictable contept instead. To reduce the amount of redundant code, we could introduce an
abstract controller which implements the basic requirements like the `executeCommand()`.

### No ilCtrl::getHTML()

Next to `executeCommand()` which is used to forward and dispatch the current request, there is also a `getHTML()`
method, which is used to reuse HTML generated by controllers. This method disrupts the actual control flow by starting a
new isolated forwarding process to gather HTML output along the way. This causes even more unexpected behaviour and has
nothing to do with routing. While migrating more controllers to UI components there will simultaneously be less
controllers that depend on this mechanic. This method will be deprecated in the future.

### Actual template engine

ILIAS still uses a relict as a template engine which has been EOL since 2007 and does not compare to what any modern
template angine can achieve today. The goal will eventually be to replace this relict with a more modern engine like
[Blade](https://laravel.com/docs/10.x/blade) or [Twig](https://twig.symfony.com/), which in the end, should only ever
be used in the UI framework.
