<?php

declare(strict_types=1);

/******************************************************************************
 *
 * This file is part of ILIAS, a powerful learning management system.
 *
 * ILIAS is licensed with the GPL-3.0, you should have received a copy
 * of said license along with the source code.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 *      https://www.ilias.de
 *      https://github.com/ILIAS-eLearning
 *
 *****************************************************************************/

use PHPUnit\Framework\TestCase;
use ILIAS\DI\Container;

class ilServicesXmlTest extends TestCase
{
    public function testHeader(): void
    {
        $writer = new ilXmlWriter();
        $writer->xmlHeader();

        $this->assertEquals(
            $this->brutallyTrim("<?xml version=\"1.0\" encoding=\"utf-8\"?><!--Generated by ILIAS XmlWriter-->"),
            $this->brutallyTrim($writer->xmlDumpMem())
        );
    }

    public function testStartEndTag(): void
    {
        $writer = new ilXmlWriter();
        $writer->xmlStartTag('lorem');
        $writer->xmlEndTag('lorem');
        $this->assertEquals(
            $this->brutallyTrim("<lorem></lorem>"),
            $this->brutallyTrim($writer->xmlDumpMem())
        );
    }

    public function testElements(): void
    {
        $writer = new ilXmlWriter();
        $writer->xmlStartTag('lorem');
        $writer->xmlElement('ipsum', ['attr1' => 1], 'data1');
        $writer->xmlElement('dolor', ['attr2' => 2, 'attr3' => 3], 'data2');
        $writer->xmlEndTag('lorem');
        $this->assertEquals(
            $this->brutallyTrim(
                "<lorem><ipsum attr1=\"1\"> data1</ipsum><dolor attr2=\"2\" attr3=\"3\"> data2</dolor></lorem>"
            ),
            $this->brutallyTrim($writer->xmlDumpMem())
        );
    }

    protected function brutallyTrim(string $string): string
    {
        $string = str_replace(["\n", "\r", "\t"], "", $string);
        $string = preg_replace('# {2,}#', " ", $string);
        $string = preg_replace("/>(\s+)</", "><", $string);
        $string = str_replace(" >", ">", $string);
        $string = str_replace(" <", "<", $string);
        return trim($string);
    }
}
