<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 */

use ILIAS\Setup;

class ilECSAgent extends Setup\Agent\NullAgent
{
    public function getUpdateObjective(\ILIAS\Setup\Config $config = null): \ILIAS\Setup\Objective
    {
        return new Setup\ObjectiveCollection(
            "ECS",
            true,
            new \ilDatabaseUpdateStepsExecutedObjective(
                new ilECSDBUpdateSteps()
            ),
            new \ilDatabaseUpdateStepsExecutedObjective(
                new ilECSUpdateSteps8()
            ),
            new \ilDatabaseUpdateStepsExecutedObjective(
                new ilECSUpdateSteps9()
            )
        );
    }

    public function getStatusObjective(\ILIAS\Setup\Metrics\Storage $storage): \ILIAS\Setup\Objective
    {
        return new Setup\ObjectiveCollection(
            'Component WebServices',
            true,
            new ilDatabaseUpdateStepsMetricsCollectedObjective($storage, new ilECSDBUpdateSteps()),
            new ilDatabaseUpdateStepsMetricsCollectedObjective($storage, new ilECSUpdateSteps8()),
            new ilDatabaseUpdateStepsMetricsCollectedObjective($storage, new ilECSUpdateSteps9())
        );
    }
}
