<?php

declare(strict_types=1);

return [
    'urn:oasis:names:tc:SAML:metadata:algsupport' => [
        'DigestMethod' => '\SimpleSAML\SAML2\XML\alg\DigestMethod',
        'SigningMethod' => '\SimpleSAML\SAML2\XML\alg\SigningMethod',
    ],
    'urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp' => [
        'RelayState' => '\SimpleSAML\SAML2\XML\ecp\RelayState',
        'Request' => '\SimpleSAML\SAML2\XML\ecp\Request',
        'RequestAuthenticated' => '\SimpleSAML\SAML2\XML\ecp\RequestAuthenticated',
        'Response' => '\SimpleSAML\SAML2\XML\ecp\Response',
        'SubjectConfirmation' => '\SimpleSAML\SAML2\XML\ecp\SubjectConfirmation',
    ],
    'http://eduid.cz/schema/metadata/1.0' => [
        'RepublishRequest' => '\SimpleSAML\SAML2\XML\emd\RepublishRequest',
    ],
    'urn:oasis:names:tc:SAML:2.0:metadata' => [
        'AdditionalMetadataLocation' => '\SimpleSAML\SAML2\XML\md\AdditionalMetadataLocation',
        'AffiliateMember' => '\SimpleSAML\SAML2\XML\md\AffiliateMember',
        'AffiliationDescriptor' => '\SimpleSAML\SAML2\XML\md\AffiliationDescriptor',
        'AssertionIDRequestService' => '\SimpleSAML\SAML2\XML\md\AssertionIDRequestService',
        'AssertionConsumerService' => '\SimpleSAML\SAML2\XML\md\AssertionConsumerService',
        'ArtifactResolutionService' => '\SimpleSAML\SAML2\XML\md\ArtifactResolutionService',
        'AttributeAuthorityDescriptor' => '\SimpleSAML\SAML2\XML\md\AttributeAuthorityDescriptor',
        'AttributeConsumingService' => '\SimpleSAML\SAML2\XML\md\AttributeConsumingService',
        'AttributeProfile' => '\SimpleSAML\SAML2\XML\md\AttributeProfile',
        'AttributeService' => '\SimpleSAML\SAML2\XML\md\AttributeService',
        'AuthnAuthorityDescriptor' => '\SimpleSAML\SAML2\XML\md\AuthnAuthorityDescriptor',
        'AuthnQueryService' => '\SimpleSAML\SAML2\XML\md\AuthnQueryService',
        'AuthzService' => '\SimpleSAML\SAML2\XML\md\AuthzService',
        'Company' => '\SimpleSAML\SAML2\XML\md\Company',
        'ContactPerson' => '\SimpleSAML\SAML2\XML\md\ContactPerson',
        'EmailAddress' => '\SimpleSAML\SAML2\XML\md\EmailAddress',
        'EncryptionMethod' => '\SimpleSAML\SAML2\XML\md\EncryptionMethod',
        'EntitiesDescriptor' => '\SimpleSAML\SAML2\XML\md\EntitiesDescriptor',
        'EntityDescriptor' => '\SimpleSAML\SAML2\XML\md\EntityDescriptor',
        'Extensions' => '\SimpleSAML\SAML2\XML\md\Extensions',
        'GivenName' => '\SimpleSAML\SAML2\XML\md\GivenName',
        'IDPSSODescriptor' => '\SimpleSAML\SAML2\XML\md\IDPSSODescriptor',
        'KeyDescriptor' => '\SimpleSAML\SAML2\XML\md\KeyDescriptor',
        'ManageNameIDService' => '\SimpleSAML\SAML2\XML\md\ManageNameIDService',
        'NameIDFormat' => '\SimpleSAML\SAML2\XML\md\NameIDFormat',
        'NameIDMappingService' => '\SimpleSAML\SAML2\XML\md\NameIDMappingService',
        'Organization' => '\SimpleSAML\SAML2\XML\md\Organization',
        'OrganizationDisplayName' => '\SimpleSAML\SAML2\XML\md\OrganizationDisplayName',
        'OrganizationName' => '\SimpleSAML\SAML2\XML\md\OrganizationName',
        'OrganizationURL' => '\SimpleSAML\SAML2\XML\md\OrganizationURL',
        'PDPDescriptor' => '\SimpleSAML\SAML2\XML\md\PDPDescriptor',
        'RequestedAttribute' => '\SimpleSAML\SAML2\XML\md\RequestedAttribute',
        'RoleDescriptor' => '\SimpleSAML\SAML2\XML\md\AbstractRoleDescriptor',
        'ServiceDescription' => '\SimpleSAML\SAML2\XML\md\ServiceDescription',
        'ServiceName' => '\SimpleSAML\SAML2\XML\md\ServiceName',
        'SingleLogoutService' => '\SimpleSAML\SAML2\XML\md\SingleLogoutService',
        'SingleSignOnService' => '\SimpleSAML\SAML2\XML\md\SingleSignOnService',
        'SPSSODescriptor' => '\SimpleSAML\SAML2\XML\md\SPSSODescriptor',
        'SurName' => '\SimpleSAML\SAML2\XML\md\SurName',
        'TelephoneNumber' => '\SimpleSAML\SAML2\XML\md\TelephoneNumber',
    ],
    'urn:oasis:names:tc:SAML:profiles:SSO:request-init' => [
        'RequestInitiator' => '\SimpleSAML\SAML2\XML\init\RequestInitiator',
    ],
    'urn:oasis:names:tc:SAML:metadata:rpi' => [
        'Publication' => '\SimpleSAML\SAML2\XML\mdrpi\Publication',
        'PublicationInfo' => '\SimpleSAML\SAML2\XML\mdrpi\PublicationInfo',
        'PublicationPath' => '\SimpleSAML\SAML2\XML\mdrpi\PublicationPath',
        'RegistrationInfo' => '\SimpleSAML\SAML2\XML\mdrpi\RegistrationInfo',
        'RegistrationPolicy' => '\SimpleSAML\SAML2\XML\mdrpi\RegistrationPolicy',
        'UsagePolicy' => '\SimpleSAML\SAML2\XML\mdrpi\UsagePolicy',
    ],
    'urn:oasis:names:tc:SAML:metadata:ui' => [
        'Description' => '\SimpleSAML\SAML2\XML\mdui\Description',
        'DiscoHints' => '\SimpleSAML\SAML2\XML\mdui\DiscoHints',
        'DisplayName' => '\SimpleSAML\SAML2\XML\mdui\DisplayName',
        'DomainHint' => '\SimpleSAML\SAML2\XML\mdui\DomainHint',
        'GeolocationHint' => '\SimpleSAML\SAML2\XML\mdui\GeolocationHint',
        'InformationURL' => '\SimpleSAML\SAML2\XML\mdui\InformationURL',
        'IPHint' => '\SimpleSAML\SAML2\XML\mdui\IPHint',
        'Keywords' => '\SimpleSAML\SAML2\XML\mdui\Keywords',
        'Logo' => '\SimpleSAML\SAML2\XML\mdui\Logo',
        'PrivacyStatementURL' => '\SimpleSAML\SAML2\XML\mdui\PrivacyStatementURL',
        'UIInfo' => '\SimpleSAML\SAML2\XML\mdui\UIInfo',
    ],
    'urn:oasis:names:tc:SAML:metadata:attribute' => [
        'EntityAttributes' => '\SimpleSAML\SAML2\XML\mdattr\EntityAttributes',
    ],
    'urn:mace:shibboleth:metadata:1.0' => [
        'KeyAuthority' => '\SimpleSAML\SAML2\XML\shibmd\KeyAuthority',
        'Scope' => '\SimpleSAML\SAML2\XML\shibmd\Scope',
    ],
    'urn:oasis:names:tc:SAML:2.0:assertion' => [
        'Action' => '\SimpleSAML\SAML2\XML\saml\Action',
        'Advice' => '\SimpleSAML\SAML2\XML\saml\Advice',
        'Assertion' => '\SimpleSAML\SAML2\XML\saml\Assertion',
        'AssertionIDRef' => '\SimpleSAML\SAML2\XML\saml\AssertionIDRef',
        'AssertionURIRef' => '\SimpleSAML\SAML2\XML\saml\AssertionURIRef',
        'Attribute' => '\SimpleSAML\SAML2\XML\saml\Attribute',
        'AttributeStatement' => '\SimpleSAML\SAML2\XML\saml\AttributeStatement',
        'AttributeValue' => '\SimpleSAML\SAML2\XML\saml\AttributeValue',
        'Audience' => '\SimpleSAML\SAML2\XML\saml\Audience',
        'AudienceRestriction' => '\SimpleSAML\SAML2\XML\saml\AudienceRestriction',
        'AuthenticatingAuthority' => '\SimpleSAML\SAML2\XML\saml\AuthenticatingAuthority',
        'AuthnContext' => '\SimpleSAML\SAML2\XML\saml\AuthnContext',
        'AuthnContextClassRef' => '\SimpleSAML\SAML2\XML\saml\AuthnContextClassRef',
        'AuthnContextDecl' => '\SimpleSAML\SAML2\XML\saml\AuthnContextDecl',
        'AuthnContextDeclRef' => '\SimpleSAML\SAML2\XML\saml\AuthnContextDeclRef',
        'AuthnStatement' => '\SimpleSAML\SAML2\XML\saml\AuthnStatement',
        'AuthzDecisionStatement' => '\SimpleSAML\SAML2\XML\saml\AuthzDecisionStatement',
        'BaseID' => '\SimpleSAML\SAML2\XML\saml\AbstractBaseID',
        'Condition' => '\SimpleSAML\SAML2\XML\saml\AbstractCondition',
        'Conditions' => '\SimpleSAML\SAML2\XML\saml\Conditions',
        'EncryptedAssertion' => '\SimpleSAML\SAML2\XML\saml\EncryptedAssertion',
        'EncryptedAttribute' => '\SimpleSAML\SAML2\XML\saml\EncryptedAttribute',
        'EncryptedID' => '\SimpleSAML\SAML2\XML\saml\EncryptedID',
        'Evidence' => '\SimpleSAML\SAML2\XML\saml\Evidence',
        'Issuer' => '\SimpleSAML\SAML2\XML\saml\Issuer',
        'NameID' => '\SimpleSAML\SAML2\XML\saml\NameID',
        'OneTimeUse' => '\SimpleSAML\SAML2\XML\saml\OneTimeUse',
        'ProxyRestriction' => '\SimpleSAML\SAML2\XML\saml\ProxyRestriction',
        'Statement' => '\SimpleSAML\SAML2\XML\saml\AbstractStatement',
        'Subject' => '\SimpleSAML\SAML2\XML\saml\Subject',
        'SubjectConfirmation' => '\SimpleSAML\SAML2\XML\saml\SubjectConfirmation',
        'SubjectConfirmationData' => '\SimpleSAML\SAML2\XML\saml\SubjectConfirmationData',
        'SubjectLocality' => '\SimpleSAML\SAML2\XML\saml\SubjectLocality',
    ],
    'urn:oasis:names:tc:SAML:2.0:protocol' => [
        'Artifact' => '\SimpleSAML\SAML2\XML\samlp\Artifact',
        'ArtifactResolve' => '\SimpleSAML\SAML2\XML\samlp\ArtifactResolve',
        'ArtifactResponse' => '\SimpleSAML\SAML2\XML\samlp\ArtifactResponse',
        'AssertionIDRequest' => '\SimpleSAML\SAML2\XML\samlp\AssertionIDRequest',
        'AttributeQuery' => '\SimpleSAML\SAML2\XML\samlp\AttributeQuery',
        'AuthnQuery' => '\SimpleSAML\SAML2\XML\samlp\AuthnQuery',
        'AuthnRequest' => '\SimpleSAML\SAML2\XML\samlp\AuthnRequest',
        'AuthzDecisionQuery' => '\SimpleSAML\SAML2\XML\samlp\AuthzDecisionQuery',
        'Extensions' => '\SimpleSAML\SAML2\XML\samlp\Extensions',
        'GetComplete' => '\SimpleSAML\SAML2\XML\samlp\GetComplete',
        'IDPEntry' => '\SimpleSAML\SAML2\XML\samlp\IDPEntry',
        'IDPList' => '\SimpleSAML\SAML2\XML\samlp\IDPList',
        'LogoutRequest' => '\SimpleSAML\SAML2\XML\samlp\LogoutRequest',
        'LogoutResponse' => '\SimpleSAML\SAML2\XML\samlp\LogoutResponse',
//        'ManageNameIDRequest' => '\SimpleSAML\SAML2\XML\samlp\ManageNameIDRequest',
//        'ManageNameIDResponse' => '\SimpleSAML\SAML2\XML\samlp\ManageNameIDResponse',
        'NameIDPolicy' => '\SimpleSAML\SAML2\XML\samlp\NameIDPolicy',
//        'NewEncryptedID' => '\SimpleSAML\SAML2\XML\samlp\NewEncryptedID',
//        'NewID' => '\SimpleSAML\SAML2\XML\samlp\NewID',
        'RequestedAuthnContext' => '\SimpleSAML\SAML2\XML\samlp\RequestedAuthnContext',
        'RequesterID' => '\SimpleSAML\SAML2\XML\samlp\RequesterID',
        'Response' => '\SimpleSAML\SAML2\XML\samlp\Response',
        'Scoping' => '\SimpleSAML\SAML2\XML\samlp\Scoping',
        'SessionIndex' => '\SimpleSAML\SAML2\XML\samlp\SessionIndex',
        'Status' => '\SimpleSAML\SAML2\XML\samlp\Status',
        'StatusCode' => '\SimpleSAML\SAML2\XML\samlp\StatusCode',
        'StatusDetail' => '\SimpleSAML\SAML2\XML\samlp\StatusDetail',
        'StatusMessage' => '\SimpleSAML\SAML2\XML\samlp\StatusMessage',
//        'SubjectQuery' => '\SimpleSAML\SAML2\XML\samlp\SubjectQuery',
//        'Terminate' => '\SimpleSAML\SAML2\XML\samlp\Terminate',
    ],
    'urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol' => [
        'DiscoveryResponse' => '\SimpleSAML\SAML2\XML\idpdisc\DiscoveryResponse',
    ],
];
