-- MySQL dump 10.13  Distrib 8.0.43, for Linux (x86_64)
--
-- Host: localhost    Database: ilias104
-- ------------------------------------------------------
-- Server version	8.0.37

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `acc_access_key`
--

DROP TABLE IF EXISTS `acc_access_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acc_access_key` (
  `lang_key` char(2) NOT NULL DEFAULT '',
  `function_id` int NOT NULL DEFAULT '0',
  `access_key` char(1) DEFAULT NULL,
  PRIMARY KEY (`lang_key`,`function_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_access_key`
--

LOCK TABLES `acc_access_key` WRITE;
/*!40000 ALTER TABLE `acc_access_key` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_access_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_cache`
--

DROP TABLE IF EXISTS `acc_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acc_cache` (
  `user_id` int NOT NULL DEFAULT '0',
  `time` int NOT NULL DEFAULT '0',
  `result` longtext,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_cache`
--

LOCK TABLES `acc_cache` WRITE;
/*!40000 ALTER TABLE `acc_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_criterion_to_doc`
--

DROP TABLE IF EXISTS `acc_criterion_to_doc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acc_criterion_to_doc` (
  `id` int NOT NULL DEFAULT '0',
  `doc_id` int NOT NULL DEFAULT '0',
  `criterion_id` varchar(50) NOT NULL,
  `criterion_value` varchar(255) DEFAULT NULL,
  `assigned_ts` int NOT NULL DEFAULT '0',
  `modification_ts` int NOT NULL DEFAULT '0',
  `owner_usr_id` int NOT NULL DEFAULT '0',
  `last_modified_usr_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_criterion_to_doc`
--

LOCK TABLES `acc_criterion_to_doc` WRITE;
/*!40000 ALTER TABLE `acc_criterion_to_doc` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_criterion_to_doc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_criterion_to_doc_seq`
--

DROP TABLE IF EXISTS `acc_criterion_to_doc_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acc_criterion_to_doc_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_criterion_to_doc_seq`
--

LOCK TABLES `acc_criterion_to_doc_seq` WRITE;
/*!40000 ALTER TABLE `acc_criterion_to_doc_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_criterion_to_doc_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_documents`
--

DROP TABLE IF EXISTS `acc_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acc_documents` (
  `id` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `creation_ts` int NOT NULL DEFAULT '0',
  `modification_ts` int NOT NULL DEFAULT '0',
  `sorting` int NOT NULL DEFAULT '0',
  `owner_usr_id` int NOT NULL DEFAULT '0',
  `last_modified_usr_id` int NOT NULL DEFAULT '0',
  `text` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_documents`
--

LOCK TABLES `acc_documents` WRITE;
/*!40000 ALTER TABLE `acc_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_documents_seq`
--

DROP TABLE IF EXISTS `acc_documents_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acc_documents_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_documents_seq`
--

LOCK TABLES `acc_documents_seq` WRITE;
/*!40000 ALTER TABLE `acc_documents_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_documents_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_user_access_key`
--

DROP TABLE IF EXISTS `acc_user_access_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acc_user_access_key` (
  `user_id` int NOT NULL DEFAULT '0',
  `function_id` smallint NOT NULL DEFAULT '0',
  `access_key` char(1) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`function_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_user_access_key`
--

LOCK TABLES `acc_user_access_key` WRITE;
/*!40000 ALTER TABLE `acc_user_access_key` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_user_access_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acl_ws`
--

DROP TABLE IF EXISTS `acl_ws`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acl_ws` (
  `node_id` int NOT NULL DEFAULT '0',
  `object_id` int NOT NULL DEFAULT '0',
  `extended_data` varchar(200) DEFAULT NULL,
  `tstamp` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`node_id`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acl_ws`
--

LOCK TABLES `acl_ws` WRITE;
/*!40000 ALTER TABLE `acl_ws` DISABLE KEYS */;
/*!40000 ALTER TABLE `acl_ws` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `addressbook_mlist`
--

DROP TABLE IF EXISTS `addressbook_mlist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `addressbook_mlist` (
  `ml_id` bigint NOT NULL DEFAULT '0',
  `user_id` bigint NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `createdate` datetime DEFAULT NULL,
  `changedate` datetime DEFAULT NULL,
  `lmode` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`ml_id`),
  KEY `i1_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addressbook_mlist`
--

LOCK TABLES `addressbook_mlist` WRITE;
/*!40000 ALTER TABLE `addressbook_mlist` DISABLE KEYS */;
/*!40000 ALTER TABLE `addressbook_mlist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `addressbook_mlist_ass`
--

DROP TABLE IF EXISTS `addressbook_mlist_ass`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `addressbook_mlist_ass` (
  `a_id` bigint NOT NULL DEFAULT '0',
  `ml_id` bigint NOT NULL DEFAULT '0',
  `usr_id` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`a_id`),
  KEY `i1_idx` (`ml_id`),
  KEY `i2_idx` (`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addressbook_mlist_ass`
--

LOCK TABLES `addressbook_mlist_ass` WRITE;
/*!40000 ALTER TABLE `addressbook_mlist_ass` DISABLE KEYS */;
/*!40000 ALTER TABLE `addressbook_mlist_ass` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `addressbook_mlist_ass_seq`
--

DROP TABLE IF EXISTS `addressbook_mlist_ass_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `addressbook_mlist_ass_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addressbook_mlist_ass_seq`
--

LOCK TABLES `addressbook_mlist_ass_seq` WRITE;
/*!40000 ALTER TABLE `addressbook_mlist_ass_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `addressbook_mlist_ass_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `addressbook_mlist_seq`
--

DROP TABLE IF EXISTS `addressbook_mlist_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `addressbook_mlist_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addressbook_mlist_seq`
--

LOCK TABLES `addressbook_mlist_seq` WRITE;
/*!40000 ALTER TABLE `addressbook_mlist_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `addressbook_mlist_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adl_shared_data`
--

DROP TABLE IF EXISTS `adl_shared_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adl_shared_data` (
  `slm_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `target_id` varchar(4000) NOT NULL DEFAULT '',
  `store` longtext,
  `cp_node_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`cp_node_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adl_shared_data`
--

LOCK TABLES `adl_shared_data` WRITE;
/*!40000 ALTER TABLE `adl_shared_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `adl_shared_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adm_set_templ_hide_tab`
--

DROP TABLE IF EXISTS `adm_set_templ_hide_tab`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adm_set_templ_hide_tab` (
  `template_id` int NOT NULL DEFAULT '0',
  `tab_id` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`template_id`,`tab_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adm_set_templ_hide_tab`
--

LOCK TABLES `adm_set_templ_hide_tab` WRITE;
/*!40000 ALTER TABLE `adm_set_templ_hide_tab` DISABLE KEYS */;
/*!40000 ALTER TABLE `adm_set_templ_hide_tab` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adm_set_templ_value`
--

DROP TABLE IF EXISTS `adm_set_templ_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adm_set_templ_value` (
  `template_id` int NOT NULL DEFAULT '0',
  `setting` varchar(40) NOT NULL DEFAULT '',
  `value` varchar(4000) DEFAULT NULL,
  `hide` tinyint DEFAULT NULL,
  PRIMARY KEY (`template_id`,`setting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adm_set_templ_value`
--

LOCK TABLES `adm_set_templ_value` WRITE;
/*!40000 ALTER TABLE `adm_set_templ_value` DISABLE KEYS */;
INSERT INTO `adm_set_templ_value` VALUES (1,'pass_scoring','0',1),(2,'pass_scoring','0',1);
/*!40000 ALTER TABLE `adm_set_templ_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_field_int`
--

DROP TABLE IF EXISTS `adv_md_field_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_field_int` (
  `field_id` int NOT NULL,
  `title` varchar(128) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `lang_code` varchar(5) NOT NULL,
  PRIMARY KEY (`field_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_field_int`
--

LOCK TABLES `adv_md_field_int` WRITE;
/*!40000 ALTER TABLE `adv_md_field_int` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_field_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_obj_rec_select`
--

DROP TABLE IF EXISTS `adv_md_obj_rec_select`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_obj_rec_select` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `rec_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`rec_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_obj_rec_select`
--

LOCK TABLES `adv_md_obj_rec_select` WRITE;
/*!40000 ALTER TABLE `adv_md_obj_rec_select` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_obj_rec_select` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_record`
--

DROP TABLE IF EXISTS `adv_md_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_record` (
  `record_id` int NOT NULL DEFAULT '0',
  `import_id` varchar(64) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '0',
  `title` varchar(128) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `parent_obj` int DEFAULT NULL,
  `gpos` int DEFAULT NULL,
  `lang_default` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`record_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_record`
--

LOCK TABLES `adv_md_record` WRITE;
/*!40000 ALTER TABLE `adv_md_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_record_files`
--

DROP TABLE IF EXISTS `adv_md_record_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_record_files` (
  `object_id` bigint NOT NULL DEFAULT '0',
  `rid` varchar(64) NOT NULL DEFAULT '',
  `is_global` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`rid`,`is_global`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_record_files`
--

LOCK TABLES `adv_md_record_files` WRITE;
/*!40000 ALTER TABLE `adv_md_record_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_record_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_record_int`
--

DROP TABLE IF EXISTS `adv_md_record_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_record_int` (
  `record_id` int NOT NULL,
  `title` varchar(128) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `lang_code` varchar(5) NOT NULL,
  PRIMARY KEY (`record_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_record_int`
--

LOCK TABLES `adv_md_record_int` WRITE;
/*!40000 ALTER TABLE `adv_md_record_int` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_record_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_record_obj_ord`
--

DROP TABLE IF EXISTS `adv_md_record_obj_ord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_record_obj_ord` (
  `record_id` int NOT NULL,
  `obj_id` int NOT NULL,
  `position` int NOT NULL,
  PRIMARY KEY (`record_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_record_obj_ord`
--

LOCK TABLES `adv_md_record_obj_ord` WRITE;
/*!40000 ALTER TABLE `adv_md_record_obj_ord` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_record_obj_ord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_record_objs`
--

DROP TABLE IF EXISTS `adv_md_record_objs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_record_objs` (
  `record_id` int NOT NULL DEFAULT '0',
  `obj_type` char(6) NOT NULL DEFAULT '',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `optional` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`record_id`,`obj_type`,`sub_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_record_objs`
--

LOCK TABLES `adv_md_record_objs` WRITE;
/*!40000 ALTER TABLE `adv_md_record_objs` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_record_objs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_record_scope`
--

DROP TABLE IF EXISTS `adv_md_record_scope`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_record_scope` (
  `scope_id` int NOT NULL DEFAULT '0',
  `record_id` int NOT NULL,
  `ref_id` int NOT NULL,
  PRIMARY KEY (`scope_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_record_scope`
--

LOCK TABLES `adv_md_record_scope` WRITE;
/*!40000 ALTER TABLE `adv_md_record_scope` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_record_scope` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_record_scope_seq`
--

DROP TABLE IF EXISTS `adv_md_record_scope_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_record_scope_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_record_scope_seq`
--

LOCK TABLES `adv_md_record_scope_seq` WRITE;
/*!40000 ALTER TABLE `adv_md_record_scope_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_record_scope_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_record_seq`
--

DROP TABLE IF EXISTS `adv_md_record_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_record_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_record_seq`
--

LOCK TABLES `adv_md_record_seq` WRITE;
/*!40000 ALTER TABLE `adv_md_record_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_record_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_substitutions`
--

DROP TABLE IF EXISTS `adv_md_substitutions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_substitutions` (
  `obj_type` varchar(4) NOT NULL DEFAULT ' ',
  `substitution` longtext,
  `hide_description` tinyint NOT NULL DEFAULT '0',
  `hide_field_names` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_substitutions`
--

LOCK TABLES `adv_md_substitutions` WRITE;
/*!40000 ALTER TABLE `adv_md_substitutions` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_substitutions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_date`
--

DROP TABLE IF EXISTS `adv_md_values_date`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_date` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value` date DEFAULT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_date`
--

LOCK TABLES `adv_md_values_date` WRITE;
/*!40000 ALTER TABLE `adv_md_values_date` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_date` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_datetime`
--

DROP TABLE IF EXISTS `adv_md_values_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_datetime` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value` datetime DEFAULT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_datetime`
--

LOCK TABLES `adv_md_values_datetime` WRITE;
/*!40000 ALTER TABLE `adv_md_values_datetime` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_enum`
--

DROP TABLE IF EXISTS `adv_md_values_enum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_enum` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `disabled` tinyint NOT NULL DEFAULT '0',
  `value_index` varchar(16) NOT NULL,
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`,`value_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_enum`
--

LOCK TABLES `adv_md_values_enum` WRITE;
/*!40000 ALTER TABLE `adv_md_values_enum` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_enum` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_extlink`
--

DROP TABLE IF EXISTS `adv_md_values_extlink`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_extlink` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value` varchar(2000) DEFAULT NULL,
  `title` varchar(500) DEFAULT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_extlink`
--

LOCK TABLES `adv_md_values_extlink` WRITE;
/*!40000 ALTER TABLE `adv_md_values_extlink` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_extlink` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_float`
--

DROP TABLE IF EXISTS `adv_md_values_float`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_float` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_float`
--

LOCK TABLES `adv_md_values_float` WRITE;
/*!40000 ALTER TABLE `adv_md_values_float` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_float` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_int`
--

DROP TABLE IF EXISTS `adv_md_values_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_int` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value` int DEFAULT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_int`
--

LOCK TABLES `adv_md_values_int` WRITE;
/*!40000 ALTER TABLE `adv_md_values_int` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_intlink`
--

DROP TABLE IF EXISTS `adv_md_values_intlink`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_intlink` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value` int NOT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_intlink`
--

LOCK TABLES `adv_md_values_intlink` WRITE;
/*!40000 ALTER TABLE `adv_md_values_intlink` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_intlink` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_location`
--

DROP TABLE IF EXISTS `adv_md_values_location`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_location` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `loc_lat` double DEFAULT NULL,
  `loc_long` double DEFAULT NULL,
  `loc_zoom` tinyint DEFAULT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_location`
--

LOCK TABLES `adv_md_values_location` WRITE;
/*!40000 ALTER TABLE `adv_md_values_location` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_location` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_ltext`
--

DROP TABLE IF EXISTS `adv_md_values_ltext`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_ltext` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value_index` varchar(16) NOT NULL,
  `value` varchar(4000) DEFAULT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`sub_type`,`sub_id`,`field_id`,`value_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_ltext`
--

LOCK TABLES `adv_md_values_ltext` WRITE;
/*!40000 ALTER TABLE `adv_md_values_ltext` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_ltext` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_md_values_text`
--

DROP TABLE IF EXISTS `adv_md_values_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_md_values_text` (
  `obj_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value` varchar(4000) DEFAULT NULL,
  `disabled` tinyint NOT NULL DEFAULT '0',
  `sub_type` varchar(10) NOT NULL DEFAULT '-',
  `sub_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`field_id`,`sub_type`,`sub_id`),
  KEY `i1_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_md_values_text`
--

LOCK TABLES `adv_md_values_text` WRITE;
/*!40000 ALTER TABLE `adv_md_values_text` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_md_values_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_mdf_definition`
--

DROP TABLE IF EXISTS `adv_mdf_definition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_mdf_definition` (
  `field_id` int NOT NULL DEFAULT '0',
  `record_id` int NOT NULL DEFAULT '0',
  `import_id` varchar(32) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  `field_type` tinyint NOT NULL DEFAULT '0',
  `field_values` text,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(2000) DEFAULT NULL,
  `searchable` tinyint NOT NULL DEFAULT '0',
  `required` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_mdf_definition`
--

LOCK TABLES `adv_mdf_definition` WRITE;
/*!40000 ALTER TABLE `adv_mdf_definition` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_mdf_definition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_mdf_definition_seq`
--

DROP TABLE IF EXISTS `adv_mdf_definition_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_mdf_definition_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_mdf_definition_seq`
--

LOCK TABLES `adv_mdf_definition_seq` WRITE;
/*!40000 ALTER TABLE `adv_mdf_definition_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_mdf_definition_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adv_mdf_enum`
--

DROP TABLE IF EXISTS `adv_mdf_enum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adv_mdf_enum` (
  `field_id` int NOT NULL,
  `lang_code` varchar(5) NOT NULL,
  `idx` int NOT NULL,
  `value` varchar(4000) NOT NULL,
  `position` int DEFAULT NULL,
  PRIMARY KEY (`field_id`,`lang_code`,`idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adv_mdf_enum`
--

LOCK TABLES `adv_mdf_enum` WRITE;
/*!40000 ALTER TABLE `adv_mdf_enum` DISABLE KEYS */;
/*!40000 ALTER TABLE `adv_mdf_enum` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aicc_course`
--

DROP TABLE IF EXISTS `aicc_course`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `aicc_course` (
  `obj_id` int NOT NULL DEFAULT '0',
  `course_creator` varchar(255) DEFAULT NULL,
  `course_id` varchar(50) DEFAULT NULL,
  `course_system` varchar(50) DEFAULT NULL,
  `course_title` varchar(255) DEFAULT NULL,
  `c_level` varchar(5) DEFAULT NULL,
  `max_fields_cst` int DEFAULT '0',
  `max_fields_ort` int DEFAULT '0',
  `total_aus` int NOT NULL DEFAULT '0',
  `total_blocks` int NOT NULL DEFAULT '0',
  `total_complex_obj` int DEFAULT '0',
  `total_objectives` int DEFAULT '0',
  `version` varchar(10) DEFAULT NULL,
  `max_normal` tinyint DEFAULT NULL,
  `description` longtext,
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aicc_course`
--

LOCK TABLES `aicc_course` WRITE;
/*!40000 ALTER TABLE `aicc_course` DISABLE KEYS */;
/*!40000 ALTER TABLE `aicc_course` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aicc_object`
--

DROP TABLE IF EXISTS `aicc_object`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `aicc_object` (
  `obj_id` int NOT NULL DEFAULT '0',
  `slm_id` int NOT NULL DEFAULT '0',
  `system_id` varchar(50) DEFAULT NULL,
  `title` varchar(4000) DEFAULT NULL,
  `description` longtext,
  `developer_id` varchar(50) DEFAULT NULL,
  `c_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`obj_id`),
  KEY `i1_idx` (`slm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aicc_object`
--

LOCK TABLES `aicc_object` WRITE;
/*!40000 ALTER TABLE `aicc_object` DISABLE KEYS */;
/*!40000 ALTER TABLE `aicc_object` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aicc_object_seq`
--

DROP TABLE IF EXISTS `aicc_object_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `aicc_object_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aicc_object_seq`
--

LOCK TABLES `aicc_object_seq` WRITE;
/*!40000 ALTER TABLE `aicc_object_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `aicc_object_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aicc_units`
--

DROP TABLE IF EXISTS `aicc_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `aicc_units` (
  `obj_id` int NOT NULL DEFAULT '0',
  `c_type` varchar(50) DEFAULT NULL,
  `command_line` varchar(255) DEFAULT NULL,
  `max_time_allowed` time DEFAULT NULL,
  `time_limit_action` varchar(50) DEFAULT NULL,
  `max_score` double DEFAULT NULL,
  `core_vendor` varchar(4000) DEFAULT NULL,
  `system_vendor` varchar(4000) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `mastery_score` int NOT NULL DEFAULT '0',
  `web_launch` varchar(255) DEFAULT NULL,
  `au_password` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aicc_units`
--

LOCK TABLES `aicc_units` WRITE;
/*!40000 ALTER TABLE `aicc_units` DISABLE KEYS */;
/*!40000 ALTER TABLE `aicc_units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aicc_units_seq`
--

DROP TABLE IF EXISTS `aicc_units_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `aicc_units_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aicc_units_seq`
--

LOCK TABLES `aicc_units_seq` WRITE;
/*!40000 ALTER TABLE `aicc_units_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `aicc_units_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ass_log`
--

DROP TABLE IF EXISTS `ass_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ass_log` (
  `ass_log_id` int NOT NULL DEFAULT '0',
  `user_fi` int NOT NULL DEFAULT '0',
  `obj_fi` int NOT NULL DEFAULT '0',
  `logtext` varchar(4000) DEFAULT NULL,
  `question_fi` int DEFAULT NULL,
  `original_fi` int DEFAULT NULL,
  `ref_id` int DEFAULT NULL,
  `test_only` varchar(1) DEFAULT '0',
  `tstamp` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ass_log_id`),
  KEY `i1_idx` (`user_fi`,`obj_fi`),
  KEY `i2_idx` (`obj_fi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ass_log`
--

LOCK TABLES `ass_log` WRITE;
/*!40000 ALTER TABLE `ass_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `ass_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ass_log_seq`
--

DROP TABLE IF EXISTS `ass_log_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ass_log_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ass_log_seq`
--

LOCK TABLES `ass_log_seq` WRITE;
/*!40000 ALTER TABLE `ass_log_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ass_log_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_ext_attr_mapping`
--

DROP TABLE IF EXISTS `auth_ext_attr_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `auth_ext_attr_mapping` (
  `auth_src_id` int NOT NULL DEFAULT '0',
  `attribute` varchar(75) NOT NULL,
  `ext_attribute` varchar(1000) DEFAULT NULL,
  `update_automatically` tinyint NOT NULL DEFAULT '0',
  `auth_mode` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`auth_mode`,`auth_src_id`,`attribute`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auth_ext_attr_mapping`
--

LOCK TABLES `auth_ext_attr_mapping` WRITE;
/*!40000 ALTER TABLE `auth_ext_attr_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_ext_attr_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `background_task`
--

DROP TABLE IF EXISTS `background_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `background_task` (
  `id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `handler` varchar(1000) DEFAULT NULL,
  `steps` mediumint NOT NULL DEFAULT '0',
  `cstep` mediumint DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `params` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `background_task`
--

LOCK TABLES `background_task` WRITE;
/*!40000 ALTER TABLE `background_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `background_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `background_task_seq`
--

DROP TABLE IF EXISTS `background_task_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `background_task_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `background_task_seq`
--

LOCK TABLES `background_task_seq` WRITE;
/*!40000 ALTER TABLE `background_task_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `background_task_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `badge_badge`
--

DROP TABLE IF EXISTS `badge_badge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `badge_badge` (
  `id` int NOT NULL DEFAULT '0',
  `parent_id` int NOT NULL DEFAULT '0',
  `type_id` varchar(255) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `descr` varchar(4000) DEFAULT NULL,
  `conf` varchar(4000) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `valid` varchar(255) DEFAULT NULL,
  `crit` varchar(4000) DEFAULT NULL,
  `image_rid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `badge_badge`
--

LOCK TABLES `badge_badge` WRITE;
/*!40000 ALTER TABLE `badge_badge` DISABLE KEYS */;
/*!40000 ALTER TABLE `badge_badge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `badge_badge_seq`
--

DROP TABLE IF EXISTS `badge_badge_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `badge_badge_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `badge_badge_seq`
--

LOCK TABLES `badge_badge_seq` WRITE;
/*!40000 ALTER TABLE `badge_badge_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `badge_badge_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `badge_image_templ_type`
--

DROP TABLE IF EXISTS `badge_image_templ_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `badge_image_templ_type` (
  `tmpl_id` int NOT NULL DEFAULT '0',
  `type_id` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`tmpl_id`,`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `badge_image_templ_type`
--

LOCK TABLES `badge_image_templ_type` WRITE;
/*!40000 ALTER TABLE `badge_image_templ_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `badge_image_templ_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `badge_image_template`
--

DROP TABLE IF EXISTS `badge_image_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `badge_image_template` (
  `id` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `image_rid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `badge_image_template`
--

LOCK TABLES `badge_image_template` WRITE;
/*!40000 ALTER TABLE `badge_image_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `badge_image_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `badge_image_template_seq`
--

DROP TABLE IF EXISTS `badge_image_template_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `badge_image_template_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `badge_image_template_seq`
--

LOCK TABLES `badge_image_template_seq` WRITE;
/*!40000 ALTER TABLE `badge_image_template_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `badge_image_template_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `badge_user_badge`
--

DROP TABLE IF EXISTS `badge_user_badge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `badge_user_badge` (
  `badge_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `tstamp` int NOT NULL DEFAULT '0',
  `awarded_by` int DEFAULT NULL,
  `pos` smallint DEFAULT NULL,
  PRIMARY KEY (`badge_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `badge_user_badge`
--

LOCK TABLES `badge_user_badge` WRITE;
/*!40000 ALTER TABLE `badge_user_badge` DISABLE KEYS */;
/*!40000 ALTER TABLE `badge_user_badge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `benchmark`
--

DROP TABLE IF EXISTS `benchmark`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `benchmark` (
  `id` int NOT NULL DEFAULT '0',
  `cdate` datetime DEFAULT NULL,
  `module` varchar(150) DEFAULT NULL,
  `benchmark` varchar(150) DEFAULT NULL,
  `duration` double DEFAULT NULL,
  `sql_stmt` longtext,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`module`,`benchmark`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `benchmark`
--

LOCK TABLES `benchmark` WRITE;
/*!40000 ALTER TABLE `benchmark` DISABLE KEYS */;
/*!40000 ALTER TABLE `benchmark` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `benchmark_seq`
--

DROP TABLE IF EXISTS `benchmark_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `benchmark_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `benchmark_seq`
--

LOCK TABLES `benchmark_seq` WRITE;
/*!40000 ALTER TABLE `benchmark_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `benchmark_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `book_obj_use_book`
--

DROP TABLE IF EXISTS `book_obj_use_book`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `book_obj_use_book` (
  `obj_id` int NOT NULL DEFAULT '0',
  `book_ref_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`book_ref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `book_obj_use_book`
--

LOCK TABLES `book_obj_use_book` WRITE;
/*!40000 ALTER TABLE `book_obj_use_book` DISABLE KEYS */;
/*!40000 ALTER TABLE `book_obj_use_book` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `book_sel_object`
--

DROP TABLE IF EXISTS `book_sel_object`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `book_sel_object` (
  `user_id` int NOT NULL DEFAULT '0',
  `object_id` int NOT NULL DEFAULT '0',
  `pool_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `book_sel_object`
--

LOCK TABLES `book_sel_object` WRITE;
/*!40000 ALTER TABLE `book_sel_object` DISABLE KEYS */;
/*!40000 ALTER TABLE `book_sel_object` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_entry`
--

DROP TABLE IF EXISTS `booking_entry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_entry` (
  `booking_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `deadline` int NOT NULL DEFAULT '0',
  `num_bookings` int NOT NULL DEFAULT '0',
  `target_obj_id` int DEFAULT NULL,
  PRIMARY KEY (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_entry`
--

LOCK TABLES `booking_entry` WRITE;
/*!40000 ALTER TABLE `booking_entry` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_entry_seq`
--

DROP TABLE IF EXISTS `booking_entry_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_entry_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_entry_seq`
--

LOCK TABLES `booking_entry_seq` WRITE;
/*!40000 ALTER TABLE `booking_entry_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_entry_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_member`
--

DROP TABLE IF EXISTS `booking_member`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_member` (
  `participant_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `booking_pool_id` varchar(255) NOT NULL,
  `assigner_user_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`participant_id`,`user_id`,`booking_pool_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_member`
--

LOCK TABLES `booking_member` WRITE;
/*!40000 ALTER TABLE `booking_member` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_member` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_member_seq`
--

DROP TABLE IF EXISTS `booking_member_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_member_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_member_seq`
--

LOCK TABLES `booking_member_seq` WRITE;
/*!40000 ALTER TABLE `booking_member_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_member_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_obj_assignment`
--

DROP TABLE IF EXISTS `booking_obj_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_obj_assignment` (
  `booking_id` int NOT NULL DEFAULT '0',
  `target_obj_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`booking_id`,`target_obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_obj_assignment`
--

LOCK TABLES `booking_obj_assignment` WRITE;
/*!40000 ALTER TABLE `booking_obj_assignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_obj_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_object`
--

DROP TABLE IF EXISTS `booking_object`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_object` (
  `booking_object_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `schedule_id` int DEFAULT NULL,
  `pool_id` int DEFAULT '0',
  `description` varchar(1000) DEFAULT NULL,
  `nr_items` smallint NOT NULL DEFAULT '1',
  `info_file` varchar(500) DEFAULT NULL,
  `post_text` varchar(4000) DEFAULT NULL,
  `post_file` varchar(500) DEFAULT NULL,
  `obj_info_rid` varchar(64) DEFAULT NULL,
  `book_info_rid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`booking_object_id`),
  KEY `i1_idx` (`pool_id`),
  KEY `i2_idx` (`schedule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_object`
--

LOCK TABLES `booking_object` WRITE;
/*!40000 ALTER TABLE `booking_object` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_object` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_object_seq`
--

DROP TABLE IF EXISTS `booking_object_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_object_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_object_seq`
--

LOCK TABLES `booking_object_seq` WRITE;
/*!40000 ALTER TABLE `booking_object_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_object_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_preferences`
--

DROP TABLE IF EXISTS `booking_preferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_preferences` (
  `book_pool_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `book_obj_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`book_pool_id`,`user_id`,`book_obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_preferences`
--

LOCK TABLES `booking_preferences` WRITE;
/*!40000 ALTER TABLE `booking_preferences` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_preferences` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_reservation`
--

DROP TABLE IF EXISTS `booking_reservation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_reservation` (
  `booking_reservation_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `object_id` int NOT NULL DEFAULT '0',
  `date_from` int NOT NULL DEFAULT '0',
  `date_to` int NOT NULL DEFAULT '0',
  `status` smallint DEFAULT NULL,
  `group_id` int DEFAULT NULL,
  `assigner_id` int NOT NULL DEFAULT '0',
  `context_obj_id` int DEFAULT '0',
  `message` varchar(4000) NOT NULL DEFAULT '',
  PRIMARY KEY (`booking_reservation_id`),
  KEY `i1_idx` (`user_id`),
  KEY `i2_idx` (`object_id`),
  KEY `i3_idx` (`date_from`),
  KEY `i4_idx` (`date_to`),
  KEY `i5_idx` (`context_obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_reservation`
--

LOCK TABLES `booking_reservation` WRITE;
/*!40000 ALTER TABLE `booking_reservation` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_reservation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_reservation_group_seq`
--

DROP TABLE IF EXISTS `booking_reservation_group_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_reservation_group_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_reservation_group_seq`
--

LOCK TABLES `booking_reservation_group_seq` WRITE;
/*!40000 ALTER TABLE `booking_reservation_group_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_reservation_group_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_reservation_seq`
--

DROP TABLE IF EXISTS `booking_reservation_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_reservation_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_reservation_seq`
--

LOCK TABLES `booking_reservation_seq` WRITE;
/*!40000 ALTER TABLE `booking_reservation_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_reservation_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_schedule`
--

DROP TABLE IF EXISTS `booking_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_schedule` (
  `booking_schedule_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `pool_id` int NOT NULL DEFAULT '0',
  `deadline` int DEFAULT NULL,
  `rent_min` int DEFAULT NULL,
  `rent_max` int DEFAULT NULL,
  `raster` int DEFAULT NULL,
  `auto_break` int DEFAULT NULL,
  `av_from` int DEFAULT NULL,
  `av_to` int DEFAULT NULL,
  PRIMARY KEY (`booking_schedule_id`),
  KEY `i1_idx` (`pool_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_schedule`
--

LOCK TABLES `booking_schedule` WRITE;
/*!40000 ALTER TABLE `booking_schedule` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_schedule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_schedule_seq`
--

DROP TABLE IF EXISTS `booking_schedule_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_schedule_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_schedule_seq`
--

LOCK TABLES `booking_schedule_seq` WRITE;
/*!40000 ALTER TABLE `booking_schedule_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_schedule_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_schedule_slot`
--

DROP TABLE IF EXISTS `booking_schedule_slot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_schedule_slot` (
  `booking_schedule_id` int NOT NULL DEFAULT '0',
  `day_id` varchar(2) NOT NULL DEFAULT '',
  `slot_id` tinyint NOT NULL DEFAULT '0',
  `times` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`booking_schedule_id`,`day_id`,`slot_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_schedule_slot`
--

LOCK TABLES `booking_schedule_slot` WRITE;
/*!40000 ALTER TABLE `booking_schedule_slot` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_schedule_slot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_settings`
--

DROP TABLE IF EXISTS `booking_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_settings` (
  `booking_pool_id` int NOT NULL DEFAULT '0',
  `public_log` tinyint DEFAULT NULL,
  `pool_offline` tinyint DEFAULT NULL,
  `slots_no` smallint DEFAULT '0',
  `schedule_type` tinyint NOT NULL DEFAULT '1',
  `ovlimit` tinyint DEFAULT NULL,
  `rsv_filter_period` smallint DEFAULT NULL,
  `reminder_status` tinyint NOT NULL DEFAULT '0',
  `reminder_day` int NOT NULL DEFAULT '0',
  `last_remind_ts` int NOT NULL DEFAULT '0',
  `preference_nr` int NOT NULL DEFAULT '0',
  `pref_deadline` int NOT NULL DEFAULT '0',
  `pref_booking_hash` varchar(23) NOT NULL DEFAULT '0',
  `messages` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`booking_pool_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_settings`
--

LOCK TABLES `booking_settings` WRITE;
/*!40000 ALTER TABLE `booking_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booking_user`
--

DROP TABLE IF EXISTS `booking_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booking_user` (
  `entry_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `tstamp` int NOT NULL DEFAULT '0',
  `booking_message` varchar(1024) DEFAULT NULL,
  `notification_sent` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`entry_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booking_user`
--

LOCK TABLES `booking_user` WRITE;
/*!40000 ALTER TABLE `booking_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `booking_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bookmark_data`
--

DROP TABLE IF EXISTS `bookmark_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookmark_data` (
  `obj_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `title` varchar(200) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `target` varchar(200) DEFAULT NULL,
  `type` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`obj_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bookmark_data`
--

LOCK TABLES `bookmark_data` WRITE;
/*!40000 ALTER TABLE `bookmark_data` DISABLE KEYS */;
INSERT INTO `bookmark_data` VALUES (1,0,'dummy_folder','','','bmf');
/*!40000 ALTER TABLE `bookmark_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bookmark_data_seq`
--

DROP TABLE IF EXISTS `bookmark_data_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookmark_data_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bookmark_data_seq`
--

LOCK TABLES `bookmark_data_seq` WRITE;
/*!40000 ALTER TABLE `bookmark_data_seq` DISABLE KEYS */;
INSERT INTO `bookmark_data_seq` VALUES (1);
/*!40000 ALTER TABLE `bookmark_data_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bookmark_tree`
--

DROP TABLE IF EXISTS `bookmark_tree`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookmark_tree` (
  `tree` int NOT NULL DEFAULT '0',
  `child` int NOT NULL DEFAULT '0',
  `parent` int DEFAULT NULL,
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `depth` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`tree`,`child`),
  KEY `i1_idx` (`child`),
  KEY `i2_idx` (`parent`),
  KEY `i3_idx` (`child`,`tree`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bookmark_tree`
--

LOCK TABLES `bookmark_tree` WRITE;
/*!40000 ALTER TABLE `bookmark_tree` DISABLE KEYS */;
INSERT INTO `bookmark_tree` VALUES (6,1,0,1,2,1);
/*!40000 ALTER TABLE `bookmark_tree` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buddylist`
--

DROP TABLE IF EXISTS `buddylist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `buddylist` (
  `usr_id` int NOT NULL DEFAULT '0',
  `buddy_usr_id` int NOT NULL DEFAULT '0',
  `ts` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`usr_id`,`buddy_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buddylist`
--

LOCK TABLES `buddylist` WRITE;
/*!40000 ALTER TABLE `buddylist` DISABLE KEYS */;
/*!40000 ALTER TABLE `buddylist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buddylist_requests`
--

DROP TABLE IF EXISTS `buddylist_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `buddylist_requests` (
  `usr_id` int NOT NULL DEFAULT '0',
  `buddy_usr_id` int NOT NULL DEFAULT '0',
  `ignored` tinyint NOT NULL DEFAULT '0',
  `ts` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`usr_id`,`buddy_usr_id`),
  KEY `i1_idx` (`buddy_usr_id`,`ignored`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buddylist_requests`
--

LOCK TABLES `buddylist_requests` WRITE;
/*!40000 ALTER TABLE `buddylist_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `buddylist_requests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_clob`
--

DROP TABLE IF EXISTS `cache_clob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_clob` (
  `component` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `entry_id` varchar(50) NOT NULL DEFAULT '',
  `value` longtext,
  `expire_time` int NOT NULL DEFAULT '0',
  `ilias_version` varchar(10) DEFAULT NULL,
  `int_key_1` int DEFAULT NULL,
  `int_key_2` int DEFAULT NULL,
  `text_key_1` varchar(20) DEFAULT NULL,
  `text_key_2` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`component`,`name`,`entry_id`),
  KEY `et_idx` (`expire_time`),
  KEY `iv_idx` (`ilias_version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_clob`
--

LOCK TABLES `cache_clob` WRITE;
/*!40000 ALTER TABLE `cache_clob` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_clob` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_text`
--

DROP TABLE IF EXISTS `cache_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_text` (
  `component` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `entry_id` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(4000) DEFAULT NULL,
  `expire_time` int NOT NULL DEFAULT '0',
  `ilias_version` varchar(10) DEFAULT NULL,
  `int_key_1` int DEFAULT NULL,
  `int_key_2` int DEFAULT NULL,
  `text_key_1` varchar(20) DEFAULT NULL,
  `text_key_2` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`component`,`name`,`entry_id`),
  KEY `et_idx` (`expire_time`),
  KEY `iv_idx` (`ilias_version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_text`
--

LOCK TABLES `cache_text` WRITE;
/*!40000 ALTER TABLE `cache_text` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_auth_token`
--

DROP TABLE IF EXISTS `cal_auth_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_auth_token` (
  `user_id` int NOT NULL DEFAULT '0',
  `hash` varchar(32) NOT NULL DEFAULT '',
  `selection` int NOT NULL DEFAULT '0',
  `calendar` int NOT NULL DEFAULT '0',
  `ical` longtext,
  `c_time` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`hash`),
  KEY `i1_idx` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_auth_token`
--

LOCK TABLES `cal_auth_token` WRITE;
/*!40000 ALTER TABLE `cal_auth_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_auth_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_cat_assignments`
--

DROP TABLE IF EXISTS `cal_cat_assignments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_cat_assignments` (
  `cal_id` int NOT NULL DEFAULT '0',
  `cat_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`cal_id`,`cat_id`),
  KEY `i2_idx` (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_cat_assignments`
--

LOCK TABLES `cal_cat_assignments` WRITE;
/*!40000 ALTER TABLE `cal_cat_assignments` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_cat_assignments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_cat_visibility`
--

DROP TABLE IF EXISTS `cal_cat_visibility`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_cat_visibility` (
  `user_id` int NOT NULL DEFAULT '0',
  `cat_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `visible` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`cat_id`,`obj_id`),
  KEY `i1_idx` (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_cat_visibility`
--

LOCK TABLES `cal_cat_visibility` WRITE;
/*!40000 ALTER TABLE `cal_cat_visibility` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_cat_visibility` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_categories`
--

DROP TABLE IF EXISTS `cal_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_categories` (
  `cat_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `title` char(128) DEFAULT NULL,
  `color` char(8) DEFAULT NULL,
  `type` tinyint NOT NULL DEFAULT '0',
  `loc_type` tinyint NOT NULL DEFAULT '1',
  `remote_url` varchar(500) DEFAULT NULL,
  `remote_user` varchar(50) DEFAULT NULL,
  `remote_pass` varchar(50) DEFAULT NULL,
  `remote_sync` datetime DEFAULT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `i2_idx` (`obj_id`),
  KEY `i3_idx` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_categories`
--

LOCK TABLES `cal_categories` WRITE;
/*!40000 ALTER TABLE `cal_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_categories_seq`
--

DROP TABLE IF EXISTS `cal_categories_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_categories_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_categories_seq`
--

LOCK TABLES `cal_categories_seq` WRITE;
/*!40000 ALTER TABLE `cal_categories_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_categories_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_ch_group`
--

DROP TABLE IF EXISTS `cal_ch_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_ch_group` (
  `grp_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `multiple_assignments` tinyint NOT NULL DEFAULT '0',
  `title` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`grp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_ch_group`
--

LOCK TABLES `cal_ch_group` WRITE;
/*!40000 ALTER TABLE `cal_ch_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_ch_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_ch_group_seq`
--

DROP TABLE IF EXISTS `cal_ch_group_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_ch_group_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_ch_group_seq`
--

LOCK TABLES `cal_ch_group_seq` WRITE;
/*!40000 ALTER TABLE `cal_ch_group_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_ch_group_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_ch_settings`
--

DROP TABLE IF EXISTS `cal_ch_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_ch_settings` (
  `user_id` int NOT NULL DEFAULT '0',
  `admin_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`admin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_ch_settings`
--

LOCK TABLES `cal_ch_settings` WRITE;
/*!40000 ALTER TABLE `cal_ch_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_ch_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_entries`
--

DROP TABLE IF EXISTS `cal_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_entries` (
  `cal_id` int NOT NULL DEFAULT '0',
  `last_update` datetime DEFAULT NULL,
  `title` char(128) DEFAULT NULL,
  `subtitle` char(64) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `location` varchar(4000) DEFAULT NULL,
  `fullday` tinyint NOT NULL DEFAULT '0',
  `starta` datetime DEFAULT NULL,
  `enda` datetime DEFAULT NULL,
  `informations` varchar(4000) DEFAULT NULL,
  `auto_generated` tinyint NOT NULL DEFAULT '0',
  `context_id` int NOT NULL DEFAULT '0',
  `translation_type` tinyint NOT NULL DEFAULT '0',
  `notification` tinyint NOT NULL DEFAULT '0',
  `context_info` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cal_id`),
  KEY `i1_idx` (`last_update`),
  KEY `i2_idx` (`context_id`),
  KEY `i3_idx` (`starta`),
  KEY `i4_idx` (`enda`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_entries`
--

LOCK TABLES `cal_entries` WRITE;
/*!40000 ALTER TABLE `cal_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_entries_seq`
--

DROP TABLE IF EXISTS `cal_entries_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_entries_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_entries_seq`
--

LOCK TABLES `cal_entries_seq` WRITE;
/*!40000 ALTER TABLE `cal_entries_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_entries_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_notification`
--

DROP TABLE IF EXISTS `cal_notification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_notification` (
  `notification_id` int NOT NULL DEFAULT '0',
  `cal_id` int NOT NULL DEFAULT '0',
  `user_type` tinyint NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `email` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `i1_idx` (`cal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_notification`
--

LOCK TABLES `cal_notification` WRITE;
/*!40000 ALTER TABLE `cal_notification` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_notification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_notification_seq`
--

DROP TABLE IF EXISTS `cal_notification_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_notification_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_notification_seq`
--

LOCK TABLES `cal_notification_seq` WRITE;
/*!40000 ALTER TABLE `cal_notification_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_notification_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_rec_exclusion`
--

DROP TABLE IF EXISTS `cal_rec_exclusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_rec_exclusion` (
  `excl_id` int NOT NULL DEFAULT '0',
  `cal_id` int NOT NULL DEFAULT '0',
  `excl_date` date DEFAULT NULL,
  PRIMARY KEY (`excl_id`),
  KEY `i1_idx` (`cal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_rec_exclusion`
--

LOCK TABLES `cal_rec_exclusion` WRITE;
/*!40000 ALTER TABLE `cal_rec_exclusion` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_rec_exclusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_rec_exclusion_seq`
--

DROP TABLE IF EXISTS `cal_rec_exclusion_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_rec_exclusion_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_rec_exclusion_seq`
--

LOCK TABLES `cal_rec_exclusion_seq` WRITE;
/*!40000 ALTER TABLE `cal_rec_exclusion_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_rec_exclusion_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_recurrence_rules`
--

DROP TABLE IF EXISTS `cal_recurrence_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_recurrence_rules` (
  `rule_id` int NOT NULL DEFAULT '0',
  `cal_id` int NOT NULL DEFAULT '0',
  `cal_recurrence` int NOT NULL DEFAULT '0',
  `freq_type` char(20) DEFAULT NULL,
  `freq_until_date` datetime DEFAULT NULL,
  `freq_until_count` int NOT NULL DEFAULT '0',
  `intervall` int NOT NULL DEFAULT '0',
  `byday` char(64) DEFAULT NULL,
  `byweekno` char(64) DEFAULT '0',
  `bymonth` char(64) DEFAULT NULL,
  `bymonthday` char(64) DEFAULT NULL,
  `byyearday` char(64) DEFAULT NULL,
  `bysetpos` char(64) DEFAULT '0',
  `weekstart` char(2) DEFAULT NULL,
  PRIMARY KEY (`rule_id`),
  KEY `i1_idx` (`cal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_recurrence_rules`
--

LOCK TABLES `cal_recurrence_rules` WRITE;
/*!40000 ALTER TABLE `cal_recurrence_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_recurrence_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_recurrence_rules_seq`
--

DROP TABLE IF EXISTS `cal_recurrence_rules_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_recurrence_rules_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_recurrence_rules_seq`
--

LOCK TABLES `cal_recurrence_rules_seq` WRITE;
/*!40000 ALTER TABLE `cal_recurrence_rules_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_recurrence_rules_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_registrations`
--

DROP TABLE IF EXISTS `cal_registrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_registrations` (
  `cal_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `dstart` int NOT NULL DEFAULT '0',
  `dend` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`cal_id`,`usr_id`,`dstart`,`dend`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_registrations`
--

LOCK TABLES `cal_registrations` WRITE;
/*!40000 ALTER TABLE `cal_registrations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_registrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_shared`
--

DROP TABLE IF EXISTS `cal_shared`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_shared` (
  `cal_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `obj_type` int NOT NULL DEFAULT '0',
  `create_date` datetime DEFAULT NULL,
  `writable` tinyint DEFAULT '0',
  PRIMARY KEY (`cal_id`,`obj_id`),
  KEY `i1_idx` (`obj_id`,`obj_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_shared`
--

LOCK TABLES `cal_shared` WRITE;
/*!40000 ALTER TABLE `cal_shared` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_shared` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cal_shared_status`
--

DROP TABLE IF EXISTS `cal_shared_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cal_shared_status` (
  `cal_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`cal_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cal_shared_status`
--

LOCK TABLES `cal_shared_status` WRITE;
/*!40000 ALTER TABLE `cal_shared_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `cal_shared_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_admconfig`
--

DROP TABLE IF EXISTS `chatroom_admconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_admconfig` (
  `instance_id` int NOT NULL DEFAULT '0',
  `server_settings` varchar(2000) NOT NULL DEFAULT '',
  `default_config` tinyint NOT NULL DEFAULT '0',
  `client_settings` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_admconfig`
--

LOCK TABLES `chatroom_admconfig` WRITE;
/*!40000 ALTER TABLE `chatroom_admconfig` DISABLE KEYS */;
/*!40000 ALTER TABLE `chatroom_admconfig` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_admconfig_seq`
--

DROP TABLE IF EXISTS `chatroom_admconfig_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_admconfig_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_admconfig_seq`
--

LOCK TABLES `chatroom_admconfig_seq` WRITE;
/*!40000 ALTER TABLE `chatroom_admconfig_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `chatroom_admconfig_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_bans`
--

DROP TABLE IF EXISTS `chatroom_bans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_bans` (
  `room_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `timestamp` int NOT NULL DEFAULT '0',
  `remark` varchar(1000) DEFAULT NULL,
  `actor_id` int DEFAULT NULL,
  PRIMARY KEY (`room_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_bans`
--

LOCK TABLES `chatroom_bans` WRITE;
/*!40000 ALTER TABLE `chatroom_bans` DISABLE KEYS */;
/*!40000 ALTER TABLE `chatroom_bans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_history`
--

DROP TABLE IF EXISTS `chatroom_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_history` (
  `hist_id` bigint NOT NULL DEFAULT '0',
  `room_id` int NOT NULL DEFAULT '0',
  `message` varchar(4000) DEFAULT NULL,
  `timestamp` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`hist_id`),
  KEY `i1_idx` (`room_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_history`
--

LOCK TABLES `chatroom_history` WRITE;
/*!40000 ALTER TABLE `chatroom_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `chatroom_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_history_seq`
--

DROP TABLE IF EXISTS `chatroom_history_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_history_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_history_seq`
--

LOCK TABLES `chatroom_history_seq` WRITE;
/*!40000 ALTER TABLE `chatroom_history_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `chatroom_history_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_sessions`
--

DROP TABLE IF EXISTS `chatroom_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_sessions` (
  `sess_id` bigint NOT NULL DEFAULT '0',
  `room_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `userdata` varchar(4000) DEFAULT NULL,
  `connected` int NOT NULL DEFAULT '0',
  `disconnected` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`sess_id`),
  KEY `i1_idx` (`room_id`,`user_id`),
  KEY `i2_idx` (`disconnected`),
  KEY `i3_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_sessions`
--

LOCK TABLES `chatroom_sessions` WRITE;
/*!40000 ALTER TABLE `chatroom_sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `chatroom_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_sessions_seq`
--

DROP TABLE IF EXISTS `chatroom_sessions_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_sessions_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_sessions_seq`
--

LOCK TABLES `chatroom_sessions_seq` WRITE;
/*!40000 ALTER TABLE `chatroom_sessions_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `chatroom_sessions_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_settings`
--

DROP TABLE IF EXISTS `chatroom_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_settings` (
  `room_id` int NOT NULL DEFAULT '0',
  `object_id` int DEFAULT '0',
  `room_type` varchar(20) NOT NULL DEFAULT '',
  `allow_anonymous` tinyint DEFAULT '0',
  `allow_custom_usernames` tinyint DEFAULT '0',
  `enable_history` tinyint DEFAULT '0',
  `autogen_usernames` varchar(50) DEFAULT 'Anonymous #',
  `display_past_msgs` int NOT NULL DEFAULT '0',
  `online_status` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`room_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_settings`
--

LOCK TABLES `chatroom_settings` WRITE;
/*!40000 ALTER TABLE `chatroom_settings` DISABLE KEYS */;
INSERT INTO `chatroom_settings` VALUES (2,185,'default',0,0,0,'Anonymous #',0,1);
/*!40000 ALTER TABLE `chatroom_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_settings_seq`
--

DROP TABLE IF EXISTS `chatroom_settings_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_settings_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_settings_seq`
--

LOCK TABLES `chatroom_settings_seq` WRITE;
/*!40000 ALTER TABLE `chatroom_settings_seq` DISABLE KEYS */;
INSERT INTO `chatroom_settings_seq` VALUES (2);
/*!40000 ALTER TABLE `chatroom_settings_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chatroom_users`
--

DROP TABLE IF EXISTS `chatroom_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chatroom_users` (
  `room_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `userdata` varchar(4000) NOT NULL DEFAULT '',
  `connected` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`room_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chatroom_users`
--

LOCK TABLES `chatroom_users` WRITE;
/*!40000 ALTER TABLE `chatroom_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `chatroom_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_comment`
--

DROP TABLE IF EXISTS `cmi_comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_comment` (
  `cmi_comment_id` int NOT NULL DEFAULT '0',
  `cmi_node_id` int DEFAULT NULL,
  `c_comment` longtext,
  `c_timestamp` datetime DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `sourceislms` tinyint DEFAULT NULL,
  PRIMARY KEY (`cmi_comment_id`),
  KEY `i2_idx` (`cmi_node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_comment`
--

LOCK TABLES `cmi_comment` WRITE;
/*!40000 ALTER TABLE `cmi_comment` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_comment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_comment_seq`
--

DROP TABLE IF EXISTS `cmi_comment_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_comment_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_comment_seq`
--

LOCK TABLES `cmi_comment_seq` WRITE;
/*!40000 ALTER TABLE `cmi_comment_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_comment_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_correct_response`
--

DROP TABLE IF EXISTS `cmi_correct_response`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_correct_response` (
  `cmi_correct_resp_id` int NOT NULL DEFAULT '0',
  `cmi_interaction_id` int DEFAULT NULL,
  `pattern` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cmi_correct_resp_id`),
  KEY `i1_idx` (`cmi_interaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_correct_response`
--

LOCK TABLES `cmi_correct_response` WRITE;
/*!40000 ALTER TABLE `cmi_correct_response` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_correct_response` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_correct_response_seq`
--

DROP TABLE IF EXISTS `cmi_correct_response_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_correct_response_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_correct_response_seq`
--

LOCK TABLES `cmi_correct_response_seq` WRITE;
/*!40000 ALTER TABLE `cmi_correct_response_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_correct_response_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_custom`
--

DROP TABLE IF EXISTS `cmi_custom`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_custom` (
  `sco_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `lvalue` varchar(64) NOT NULL DEFAULT ' ',
  `rvalue` varchar(255) DEFAULT NULL,
  `c_timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`,`lvalue`,`obj_id`,`sco_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_custom`
--

LOCK TABLES `cmi_custom` WRITE;
/*!40000 ALTER TABLE `cmi_custom` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_custom` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_gobjective`
--

DROP TABLE IF EXISTS `cmi_gobjective`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_gobjective` (
  `user_id` int NOT NULL,
  `satisfied` varchar(50) DEFAULT NULL,
  `measure` varchar(50) DEFAULT NULL,
  `scope_id` int NOT NULL,
  `status` varchar(50) DEFAULT NULL,
  `objective_id` varchar(253) NOT NULL,
  `score_raw` varchar(50) DEFAULT NULL,
  `score_min` varchar(50) DEFAULT NULL,
  `score_max` varchar(50) DEFAULT NULL,
  `progress_measure` varchar(50) DEFAULT NULL,
  `completion_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`scope_id`,`objective_id`),
  KEY `i2_idx` (`scope_id`,`objective_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_gobjective`
--

LOCK TABLES `cmi_gobjective` WRITE;
/*!40000 ALTER TABLE `cmi_gobjective` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_gobjective` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_interaction`
--

DROP TABLE IF EXISTS `cmi_interaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_interaction` (
  `cmi_interaction_id` int NOT NULL DEFAULT '0',
  `cmi_node_id` int DEFAULT NULL,
  `description` longtext,
  `id` varchar(255) DEFAULT NULL,
  `latency` varchar(20) DEFAULT NULL,
  `result` varchar(4000) DEFAULT NULL,
  `c_timestamp` varchar(40) DEFAULT NULL,
  `c_type` varchar(32) DEFAULT NULL,
  `weighting` double DEFAULT NULL,
  `learner_response` longtext,
  PRIMARY KEY (`cmi_interaction_id`),
  KEY `i2_idx` (`id`),
  KEY `i3_idx` (`c_type`),
  KEY `i4_idx` (`cmi_node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_interaction`
--

LOCK TABLES `cmi_interaction` WRITE;
/*!40000 ALTER TABLE `cmi_interaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_interaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_interaction_seq`
--

DROP TABLE IF EXISTS `cmi_interaction_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_interaction_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_interaction_seq`
--

LOCK TABLES `cmi_interaction_seq` WRITE;
/*!40000 ALTER TABLE `cmi_interaction_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_interaction_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_node`
--

DROP TABLE IF EXISTS `cmi_node`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_node` (
  `accesscount` int DEFAULT NULL,
  `accessduration` varchar(20) DEFAULT NULL,
  `accessed` varchar(20) DEFAULT NULL,
  `activityabsduration` varchar(20) DEFAULT NULL,
  `activityattemptcount` int DEFAULT NULL,
  `activityexpduration` varchar(20) DEFAULT NULL,
  `activityprogstatus` tinyint DEFAULT NULL,
  `attemptabsduration` varchar(20) DEFAULT NULL,
  `attemptcomplamount` double DEFAULT NULL,
  `attemptcomplstatus` tinyint DEFAULT NULL,
  `attemptexpduration` varchar(20) DEFAULT NULL,
  `attemptprogstatus` tinyint DEFAULT NULL,
  `audio_captioning` int DEFAULT NULL,
  `audio_level` double DEFAULT NULL,
  `availablechildren` varchar(255) DEFAULT NULL,
  `cmi_node_id` int NOT NULL DEFAULT '0',
  `completion` double DEFAULT NULL,
  `completion_status` varchar(32) DEFAULT NULL,
  `completion_threshold` varchar(32) DEFAULT NULL,
  `cp_node_id` int NOT NULL DEFAULT '0',
  `created` varchar(20) DEFAULT NULL,
  `credit` varchar(32) DEFAULT NULL,
  `delivery_speed` double DEFAULT NULL,
  `c_entry` varchar(255) DEFAULT NULL,
  `c_exit` varchar(255) DEFAULT NULL,
  `c_language` varchar(5) DEFAULT NULL,
  `launch_data` longtext,
  `learner_name` varchar(255) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `c_max` double DEFAULT NULL,
  `c_min` double DEFAULT NULL,
  `c_mode` varchar(20) DEFAULT NULL,
  `modified` varchar(20) DEFAULT NULL,
  `progress_measure` double DEFAULT NULL,
  `c_raw` double DEFAULT NULL,
  `scaled` double DEFAULT NULL,
  `scaled_passing_score` double DEFAULT NULL,
  `session_time` varchar(20) DEFAULT NULL,
  `success_status` varchar(255) DEFAULT NULL,
  `suspend_data` longtext,
  `total_time` varchar(20) DEFAULT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `c_timestamp` datetime DEFAULT NULL,
  `additional_tables` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`cmi_node_id`),
  KEY `i1_idx` (`cp_node_id`),
  KEY `i2_idx` (`completion_status`),
  KEY `i3_idx` (`credit`),
  KEY `i5_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_node`
--

LOCK TABLES `cmi_node` WRITE;
/*!40000 ALTER TABLE `cmi_node` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_node` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_node_seq`
--

DROP TABLE IF EXISTS `cmi_node_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_node_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_node_seq`
--

LOCK TABLES `cmi_node_seq` WRITE;
/*!40000 ALTER TABLE `cmi_node_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_node_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_objective`
--

DROP TABLE IF EXISTS `cmi_objective`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_objective` (
  `cmi_interaction_id` int DEFAULT NULL,
  `cmi_node_id` int DEFAULT NULL,
  `cmi_objective_id` int NOT NULL DEFAULT '0',
  `description` longtext,
  `id` varchar(4000) DEFAULT NULL,
  `c_max` double DEFAULT NULL,
  `c_min` double DEFAULT NULL,
  `c_raw` double DEFAULT NULL,
  `scaled` double DEFAULT NULL,
  `progress_measure` double DEFAULT NULL,
  `success_status` varchar(32) DEFAULT NULL,
  `scope` varchar(16) DEFAULT NULL,
  `completion_status` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`cmi_objective_id`),
  KEY `i2_idx` (`cmi_interaction_id`),
  KEY `i4_idx` (`success_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_objective`
--

LOCK TABLES `cmi_objective` WRITE;
/*!40000 ALTER TABLE `cmi_objective` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_objective` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmi_objective_seq`
--

DROP TABLE IF EXISTS `cmi_objective_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmi_objective_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmi_objective_seq`
--

LOCK TABLES `cmi_objective_seq` WRITE;
/*!40000 ALTER TABLE `cmi_objective_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmi_objective_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_del_object`
--

DROP TABLE IF EXISTS `cmix_del_object`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_del_object` (
  `obj_id` int NOT NULL,
  `type_id` int NOT NULL,
  `activity_id` varchar(128) NOT NULL,
  `added` datetime NOT NULL,
  `updated` datetime DEFAULT NULL,
  PRIMARY KEY (`obj_id`,`type_id`,`activity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_del_object`
--

LOCK TABLES `cmix_del_object` WRITE;
/*!40000 ALTER TABLE `cmix_del_object` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_del_object` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_del_user`
--

DROP TABLE IF EXISTS `cmix_del_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_del_user` (
  `usr_id` int NOT NULL,
  `added` datetime NOT NULL,
  `updated` datetime DEFAULT NULL,
  `obj_id` int NOT NULL,
  PRIMARY KEY (`usr_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_del_user`
--

LOCK TABLES `cmix_del_user` WRITE;
/*!40000 ALTER TABLE `cmix_del_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_del_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_lrs_types`
--

DROP TABLE IF EXISTS `cmix_lrs_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_lrs_types` (
  `type_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `availability` int NOT NULL DEFAULT '1',
  `remarks` varchar(4000) DEFAULT NULL,
  `time_to_delete` int DEFAULT NULL,
  `lrs_endpoint` varchar(255) NOT NULL,
  `lrs_key` varchar(128) NOT NULL,
  `lrs_secret` varchar(128) NOT NULL,
  `privacy_comment_default` varchar(2000) NOT NULL,
  `external_lrs` tinyint NOT NULL DEFAULT '0',
  `force_privacy_settings` tinyint NOT NULL DEFAULT '0',
  `bypass_proxy` tinyint NOT NULL DEFAULT '0',
  `only_moveon` tinyint NOT NULL DEFAULT '0',
  `achieved` tinyint NOT NULL DEFAULT '1',
  `answered` tinyint NOT NULL DEFAULT '1',
  `completed` tinyint NOT NULL DEFAULT '1',
  `failed` tinyint NOT NULL DEFAULT '1',
  `initialized` tinyint NOT NULL DEFAULT '1',
  `passed` tinyint NOT NULL DEFAULT '1',
  `progressed` tinyint NOT NULL DEFAULT '1',
  `satisfied` tinyint NOT NULL DEFAULT '1',
  `c_terminated` tinyint NOT NULL DEFAULT '1',
  `hide_data` tinyint NOT NULL DEFAULT '0',
  `c_timestamp` tinyint NOT NULL DEFAULT '0',
  `duration` tinyint NOT NULL DEFAULT '1',
  `no_substatements` tinyint NOT NULL DEFAULT '0',
  `privacy_ident` smallint NOT NULL DEFAULT '0',
  `privacy_name` smallint NOT NULL DEFAULT '0',
  `delete_data` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_lrs_types`
--

LOCK TABLES `cmix_lrs_types` WRITE;
/*!40000 ALTER TABLE `cmix_lrs_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_lrs_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_lrs_types_seq`
--

DROP TABLE IF EXISTS `cmix_lrs_types_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_lrs_types_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_lrs_types_seq`
--

LOCK TABLES `cmix_lrs_types_seq` WRITE;
/*!40000 ALTER TABLE `cmix_lrs_types_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_lrs_types_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_results`
--

DROP TABLE IF EXISTS `cmix_results`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_results` (
  `id` int NOT NULL,
  `obj_id` int NOT NULL,
  `usr_id` int NOT NULL,
  `version` smallint NOT NULL DEFAULT '1',
  `score` double DEFAULT NULL,
  `status` varchar(32) NOT NULL DEFAULT '0',
  `last_update` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`obj_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_results`
--

LOCK TABLES `cmix_results` WRITE;
/*!40000 ALTER TABLE `cmix_results` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_results` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_results_seq`
--

DROP TABLE IF EXISTS `cmix_results_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_results_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_results_seq`
--

LOCK TABLES `cmix_results_seq` WRITE;
/*!40000 ALTER TABLE `cmix_results_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_results_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_settings`
--

DROP TABLE IF EXISTS `cmix_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_settings` (
  `obj_id` int NOT NULL DEFAULT '0',
  `lrs_type_id` int NOT NULL DEFAULT '0',
  `content_type` varchar(32) DEFAULT NULL,
  `source_type` varchar(32) DEFAULT NULL,
  `activity_id` varchar(255) DEFAULT NULL,
  `instructions` varchar(4000) DEFAULT NULL,
  `offline_status` tinyint NOT NULL DEFAULT '1',
  `launch_url` varchar(255) DEFAULT NULL,
  `auth_fetch_url` tinyint NOT NULL DEFAULT '0',
  `launch_method` varchar(32) DEFAULT NULL,
  `launch_mode` varchar(32) DEFAULT NULL,
  `mastery_score` double NOT NULL DEFAULT '0',
  `keep_lp` tinyint NOT NULL DEFAULT '0',
  `usr_privacy_comment` varchar(4000) DEFAULT NULL,
  `show_statements` tinyint NOT NULL DEFAULT '0',
  `xml_manifest` longtext,
  `version` int NOT NULL DEFAULT '1',
  `highscore_enabled` tinyint NOT NULL DEFAULT '0',
  `highscore_achieved_ts` tinyint NOT NULL DEFAULT '0',
  `highscore_percentage` tinyint NOT NULL DEFAULT '0',
  `highscore_wtime` tinyint NOT NULL DEFAULT '0',
  `highscore_own_table` tinyint NOT NULL DEFAULT '0',
  `highscore_top_table` tinyint NOT NULL DEFAULT '0',
  `highscore_top_num` int NOT NULL DEFAULT '0',
  `bypass_proxy` tinyint NOT NULL DEFAULT '0',
  `only_moveon` tinyint NOT NULL DEFAULT '0',
  `achieved` tinyint NOT NULL DEFAULT '1',
  `answered` tinyint NOT NULL DEFAULT '1',
  `completed` tinyint NOT NULL DEFAULT '1',
  `failed` tinyint NOT NULL DEFAULT '1',
  `initialized` tinyint NOT NULL DEFAULT '1',
  `passed` tinyint NOT NULL DEFAULT '1',
  `progressed` tinyint NOT NULL DEFAULT '1',
  `satisfied` tinyint NOT NULL DEFAULT '1',
  `c_terminated` tinyint NOT NULL DEFAULT '1',
  `hide_data` tinyint NOT NULL DEFAULT '0',
  `c_timestamp` tinyint NOT NULL DEFAULT '0',
  `duration` tinyint NOT NULL DEFAULT '1',
  `no_substatements` tinyint NOT NULL DEFAULT '0',
  `privacy_ident` smallint NOT NULL DEFAULT '0',
  `privacy_name` smallint NOT NULL DEFAULT '0',
  `publisher_id` varchar(255) NOT NULL DEFAULT '',
  `anonymous_homepage` tinyint NOT NULL DEFAULT '1',
  `moveon` varchar(32) NOT NULL DEFAULT '',
  `launch_parameters` varchar(255) NOT NULL DEFAULT '',
  `entitlement_key` varchar(255) NOT NULL DEFAULT '',
  `switch_to_review` tinyint NOT NULL DEFAULT '1',
  `delete_data` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_settings`
--

LOCK TABLES `cmix_settings` WRITE;
/*!40000 ALTER TABLE `cmix_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_token`
--

DROP TABLE IF EXISTS `cmix_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_token` (
  `token` varchar(255) NOT NULL DEFAULT '0',
  `valid_until` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `lrs_type_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `cmi5_session` varchar(255) NOT NULL DEFAULT '',
  `returned_for_cmi5_session` varchar(255) NOT NULL DEFAULT '',
  `cmi5_session_data` longtext,
  PRIMARY KEY (`token`),
  UNIQUE KEY `c1_idx` (`obj_id`,`usr_id`),
  KEY `i1_idx` (`token`,`valid_until`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_token`
--

LOCK TABLES `cmix_token` WRITE;
/*!40000 ALTER TABLE `cmix_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cmix_users`
--

DROP TABLE IF EXISTS `cmix_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cmix_users` (
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `proxy_success` tinyint NOT NULL DEFAULT '0',
  `fetched_until` datetime DEFAULT NULL,
  `usr_ident` varchar(255) DEFAULT NULL,
  `privacy_ident` smallint NOT NULL DEFAULT '0',
  `registration` varchar(255) NOT NULL DEFAULT '',
  `satisfied` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`usr_id`,`privacy_ident`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cmix_users`
--

LOCK TABLES `cmix_users` WRITE;
/*!40000 ALTER TABLE `cmix_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `cmix_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conditions`
--

DROP TABLE IF EXISTS `conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `conditions` (
  `condition_id` int NOT NULL DEFAULT '0',
  `target_ref_id` int NOT NULL DEFAULT '0',
  `target_obj_id` int NOT NULL DEFAULT '0',
  `target_type` varchar(8) DEFAULT NULL,
  `trigger_ref_id` int NOT NULL DEFAULT '0',
  `trigger_obj_id` int NOT NULL DEFAULT '0',
  `trigger_type` varchar(8) DEFAULT NULL,
  `operator` varchar(64) DEFAULT NULL,
  `value` varchar(128) DEFAULT NULL,
  `ref_handling` tinyint NOT NULL DEFAULT '1',
  `obligatory` tinyint NOT NULL DEFAULT '1',
  `num_obligatory` tinyint NOT NULL DEFAULT '0',
  `hidden_status` tinyint DEFAULT '0',
  PRIMARY KEY (`condition_id`),
  KEY `tot_idx` (`target_obj_id`,`target_type`),
  KEY `i1_idx` (`target_obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conditions`
--

LOCK TABLES `conditions` WRITE;
/*!40000 ALTER TABLE `conditions` DISABLE KEYS */;
/*!40000 ALTER TABLE `conditions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conditions_seq`
--

DROP TABLE IF EXISTS `conditions_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `conditions_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conditions_seq`
--

LOCK TABLES `conditions_seq` WRITE;
/*!40000 ALTER TABLE `conditions_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `conditions_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cont_filter_field`
--

DROP TABLE IF EXISTS `cont_filter_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cont_filter_field` (
  `ref_id` int NOT NULL DEFAULT '0',
  `record_set_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cont_filter_field`
--

LOCK TABLES `cont_filter_field` WRITE;
/*!40000 ALTER TABLE `cont_filter_field` DISABLE KEYS */;
/*!40000 ALTER TABLE `cont_filter_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cont_member_skills`
--

DROP TABLE IF EXISTS `cont_member_skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cont_member_skills` (
  `obj_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `tref_id` int NOT NULL DEFAULT '0',
  `skill_id` int NOT NULL DEFAULT '0',
  `level_id` int NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`user_id`,`skill_id`,`tref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cont_member_skills`
--

LOCK TABLES `cont_member_skills` WRITE;
/*!40000 ALTER TABLE `cont_member_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `cont_member_skills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cont_skills`
--

DROP TABLE IF EXISTS `cont_skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cont_skills` (
  `id` int NOT NULL DEFAULT '0',
  `skill_id` int NOT NULL DEFAULT '0',
  `tref_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`skill_id`,`tref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cont_skills`
--

LOCK TABLES `cont_skills` WRITE;
/*!40000 ALTER TABLE `cont_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `cont_skills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_reference`
--

DROP TABLE IF EXISTS `container_reference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_reference` (
  `obj_id` int NOT NULL DEFAULT '0',
  `target_obj_id` int NOT NULL DEFAULT '0',
  `title_type` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`obj_id`,`target_obj_id`),
  KEY `i1_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_reference`
--

LOCK TABLES `container_reference` WRITE;
/*!40000 ALTER TABLE `container_reference` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_reference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_settings`
--

DROP TABLE IF EXISTS `container_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_settings` (
  `id` int NOT NULL DEFAULT '0',
  `keyword` char(40) NOT NULL DEFAULT '',
  `value` char(50) DEFAULT NULL,
  PRIMARY KEY (`id`,`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_settings`
--

LOCK TABLES `container_settings` WRITE;
/*!40000 ALTER TABLE `container_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_sorting`
--

DROP TABLE IF EXISTS `container_sorting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_sorting` (
  `obj_id` int NOT NULL DEFAULT '0',
  `child_id` int NOT NULL DEFAULT '0',
  `position` int NOT NULL DEFAULT '0',
  `parent_type` varchar(5) DEFAULT NULL,
  `parent_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`child_id`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_sorting`
--

LOCK TABLES `container_sorting` WRITE;
/*!40000 ALTER TABLE `container_sorting` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_sorting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_sorting_bl`
--

DROP TABLE IF EXISTS `container_sorting_bl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_sorting_bl` (
  `obj_id` int NOT NULL DEFAULT '0',
  `block_ids` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_sorting_bl`
--

LOCK TABLES `container_sorting_bl` WRITE;
/*!40000 ALTER TABLE `container_sorting_bl` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_sorting_bl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_sorting_set`
--

DROP TABLE IF EXISTS `container_sorting_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_sorting_set` (
  `obj_id` int NOT NULL DEFAULT '0',
  `sort_mode` tinyint NOT NULL DEFAULT '0',
  `sort_direction` tinyint NOT NULL DEFAULT '0',
  `new_items_position` tinyint NOT NULL DEFAULT '1',
  `new_items_order` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_sorting_set`
--

LOCK TABLES `container_sorting_set` WRITE;
/*!40000 ALTER TABLE `container_sorting_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_sorting_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `content_object`
--

DROP TABLE IF EXISTS `content_object`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `content_object` (
  `id` int NOT NULL DEFAULT '0',
  `default_layout` varchar(100) DEFAULT 'toc2win',
  `stylesheet` int NOT NULL DEFAULT '0',
  `page_header` char(8) DEFAULT 'st_title',
  `is_online` char(1) DEFAULT 'n',
  `toc_active` char(1) DEFAULT 'y',
  `lm_menu_active` char(1) DEFAULT 'y',
  `toc_mode` char(8) DEFAULT 'chapters',
  `clean_frames` char(1) DEFAULT 'n',
  `print_view_active` char(1) DEFAULT 'y',
  `numbering` char(1) DEFAULT 'n',
  `hist_user_comments` char(1) DEFAULT 'n',
  `public_access_mode` char(8) DEFAULT 'complete',
  `public_html_file` varchar(50) DEFAULT NULL,
  `public_xml_file` varchar(50) DEFAULT NULL,
  `downloads_active` char(1) DEFAULT 'n',
  `downloads_public_active` char(1) DEFAULT 'y',
  `header_page` int NOT NULL DEFAULT '0',
  `footer_page` int NOT NULL DEFAULT '0',
  `no_glo_appendix` char(1) DEFAULT 'n',
  `layout_per_page` tinyint DEFAULT NULL,
  `public_scorm_file` varchar(50) DEFAULT NULL,
  `rating` tinyint NOT NULL DEFAULT '0',
  `hide_head_foot_print` tinyint NOT NULL DEFAULT '0',
  `disable_def_feedback` int NOT NULL DEFAULT '0',
  `rating_pages` tinyint DEFAULT '0',
  `progr_icons` tinyint NOT NULL DEFAULT '0',
  `store_tries` tinyint NOT NULL DEFAULT '0',
  `restrict_forw_nav` tinyint NOT NULL DEFAULT '0',
  `for_translation` tinyint NOT NULL DEFAULT '0',
  `act_est_reading_time` tinyint NOT NULL DEFAULT '0',
  `est_reading_time` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `content_object`
--

LOCK TABLES `content_object` WRITE;
/*!40000 ALTER TABLE `content_object` DISABLE KEYS */;
/*!40000 ALTER TABLE `content_object` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `content_page_data`
--

DROP TABLE IF EXISTS `content_page_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `content_page_data` (
  `content_page_id` int NOT NULL DEFAULT '0',
  `stylesheet` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `content_page_data`
--

LOCK TABLES `content_page_data` WRITE;
/*!40000 ALTER TABLE `content_page_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `content_page_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `content_page_metrics`
--

DROP TABLE IF EXISTS `content_page_metrics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `content_page_metrics` (
  `content_page_id` int NOT NULL DEFAULT '0',
  `page_id` int NOT NULL DEFAULT '0',
  `lang` varchar(2) NOT NULL DEFAULT '-',
  `reading_time` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_page_id`,`page_id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `content_page_metrics`
--

LOCK TABLES `content_page_metrics` WRITE;
/*!40000 ALTER TABLE `content_page_metrics` DISABLE KEYS */;
/*!40000 ALTER TABLE `content_page_metrics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `copg_multilang`
--

DROP TABLE IF EXISTS `copg_multilang`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `copg_multilang` (
  `parent_type` varchar(10) NOT NULL DEFAULT '0',
  `parent_id` int NOT NULL DEFAULT '0',
  `master_lang` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`parent_type`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `copg_multilang`
--

LOCK TABLES `copg_multilang` WRITE;
/*!40000 ALTER TABLE `copg_multilang` DISABLE KEYS */;
/*!40000 ALTER TABLE `copg_multilang` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `copg_multilang_lang`
--

DROP TABLE IF EXISTS `copg_multilang_lang`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `copg_multilang_lang` (
  `parent_type` varchar(10) NOT NULL DEFAULT '0',
  `parent_id` int NOT NULL DEFAULT '0',
  `lang` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`parent_type`,`parent_id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `copg_multilang_lang`
--

LOCK TABLES `copg_multilang_lang` WRITE;
/*!40000 ALTER TABLE `copg_multilang_lang` DISABLE KEYS */;
/*!40000 ALTER TABLE `copg_multilang_lang` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `copg_pc_def`
--

DROP TABLE IF EXISTS `copg_pc_def`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `copg_pc_def` (
  `pc_type` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(40) NOT NULL DEFAULT '',
  `directory` varchar(40) DEFAULT NULL,
  `int_links` tinyint NOT NULL DEFAULT '0',
  `style_classes` tinyint NOT NULL DEFAULT '0',
  `xsl` tinyint NOT NULL DEFAULT '0',
  `component` varchar(40) DEFAULT NULL,
  `def_enabled` tinyint DEFAULT '0',
  `top_item` tinyint NOT NULL DEFAULT '0',
  `order_nr` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`pc_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `copg_pc_def`
--

LOCK TABLES `copg_pc_def` WRITE;
/*!40000 ALTER TABLE `copg_pc_def` DISABLE KEYS */;
INSERT INTO `copg_pc_def` VALUES ('amdfrm','AMDForm','Page',0,0,0,'components/ILIAS/Portfolio',0,1,139),('amdpl','AMDPageList','classes',0,0,0,'components/ILIAS/Wiki',0,1,240),('blog','Blog','PC/Blog',0,0,0,'components/ILIAS/COPage',0,1,100),('cach','ConsultationHours','Page',0,0,0,'components/ILIAS/Portfolio',0,1,138),('contpop','ContentPopup','PC/InteractiveImage',0,0,0,'components/ILIAS/COPage',1,0,0),('dtab','DataTable','PC/Table',0,1,0,'components/ILIAS/COPage',1,1,50),('flit','FileItem','PC/FileList',0,1,0,'components/ILIAS/COPage',1,0,0),('flst','FileList','PC/FileList',0,1,0,'components/ILIAS/COPage',1,1,40),('gcell','GridCell','PC/Grid',0,0,0,'components/ILIAS/COPage',1,0,0),('grid','Grid','PC/Grid',0,0,0,'components/ILIAS/COPage',1,1,67),('iim','InteractiveImage','classes',1,1,0,'components/ILIAS/COPage',1,1,100),('incl','ContentInclude','PC/ContentInclude',1,1,0,'components/ILIAS/COPage',0,1,110),('lay','LayoutTemplate','PC/LayoutTemplate',0,0,0,'components/ILIAS/COPage',0,1,195),('lhist','LearningHistory','classes',0,0,0,'components/ILIAS/LearningHistory',0,1,136),('li','ListItem','PC/List',0,0,0,'components/ILIAS/COPage',1,0,0),('list','List','PC/List',0,1,0,'components/ILIAS/COPage',1,1,220),('lpe','LoginPageElement','PC/Login',0,0,0,'components/ILIAS/COPage',0,1,120),('lsocurriculum','Curriculum','classes/PageEditor',0,0,0,'components/ILIAS/LearningSequence',0,1,127),('lsostartbutton','Launcher','classes/PageEditor',0,0,0,'components/ILIAS/LearningSequence',0,1,127),('map','Map','PC/Map',0,0,0,'components/ILIAS/COPage',0,1,280),('mcrs','MyCourses','Page',0,0,0,'components/ILIAS/Portfolio',0,1,137),('media','MediaObject','PC/MediaObject',0,1,0,'components/ILIAS/COPage',1,1,20),('par','Paragraph','PC/Paragraph',1,1,0,'components/ILIAS/COPage',1,1,10),('pcqst','Question','PC/Question',0,0,0,'components/ILIAS/COPage',0,1,55),('plach','PlaceHolder','PC/PlaceHolder',0,1,0,'components/ILIAS/COPage',0,1,5),('plug','Plugged','classes',0,0,0,'components/ILIAS/COPage',0,1,210),('prgactionnote','PRGActionNote','classes/PageEditor',0,0,0,'components/ILIAS/StudyProgramme',0,1,128),('prgstatusinfo','PRGStatusInfo','classes/PageEditor',0,0,0,'components/ILIAS/StudyProgramme',0,1,127),('prof','Profile','PC/Profile',0,0,0,'components/ILIAS/COPage',0,1,130),('repobj','Resources','PC/Resources',0,0,0,'components/ILIAS/COPage',0,1,150),('sec','Section','PC/Section',0,1,0,'components/ILIAS/COPage',1,1,60),('skills','Skills','PC/Skills',0,0,0,'components/ILIAS/COPage',0,1,160),('src','SourceCode','PC/SourceCode',0,0,0,'components/ILIAS/COPage',1,1,190),('tab','Table','PC/Table',0,1,0,'components/ILIAS/COPage',1,1,200),('tabs','Tabs','PC/Tabs',0,1,0,'components/ILIAS/COPage',1,1,65),('tabstab','Tab','PC/Tabs',0,0,0,'components/ILIAS/COPage',1,0,0),('td','TableData','PC/Table',0,0,0,'components/ILIAS/COPage',1,0,0),('templ','ContentTemplate','PC/ContentTemplate',0,0,0,'components/ILIAS/COPage',0,1,200),('vrfc','Verification','PC/Verification',0,0,0,'components/ILIAS/COPage',0,1,180);
/*!40000 ALTER TABLE `copg_pc_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `copg_pobj_def`
--

DROP TABLE IF EXISTS `copg_pobj_def`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `copg_pobj_def` (
  `parent_type` varchar(20) NOT NULL DEFAULT '',
  `class_name` varchar(80) NOT NULL DEFAULT '',
  `directory` varchar(40) DEFAULT NULL,
  `component` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`parent_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `copg_pobj_def`
--

LOCK TABLES `copg_pobj_def` WRITE;
/*!40000 ALTER TABLE `copg_pobj_def` DISABLE KEYS */;
INSERT INTO `copg_pobj_def` VALUES ('aout','ilLogoutPage','classes','components/ILIAS/Authentication'),('auth','ilLoginPage','classes','components/ILIAS/Authentication'),('blp','ilBlogPosting','classes','components/ILIAS/Blog'),('cont','ilContainerPage','Page','components/ILIAS/Container'),('copa','ilContentPagePage','classes','components/ILIAS/ContentPage'),('cstr','ilContainerStartObjectsPage','StartObjects','components/ILIAS/Container'),('dclf','ilDclDetailedViewDefinition','classes/DetailedView','components/ILIAS/DataCollection'),('dshs','ilDashboardPage','classes','components/ILIAS/Dashboard'),('frm','ilForumPage','classes/CoPage','components/ILIAS/Forum'),('impr','ilImprint','classes','components/ILIAS/Imprint'),('lm','ilLMPage','classes','components/ILIAS/LearningModule'),('lobj','ilLOPage','classes/Objectives','components/ILIAS/Course'),('lsoe','ilLSOExtroPage','classes/PageEditor','components/ILIAS/LearningSequence'),('lsoi','ilLSOIntroPage','classes/PageEditor','components/ILIAS/LearningSequence'),('mep','ilMediaPoolPage','classes','components/ILIAS/MediaPool'),('prtf','ilPortfolioPage','Page','components/ILIAS/Portfolio'),('prtt','ilPortfolioTemplatePage','Template','components/ILIAS/Portfolio'),('qfbg','ilAssGenFeedbackPage','classes/feedback','components/ILIAS/TestQuestionPool'),('qfbs','ilAssSpecFeedbackPage','classes/feedback','components/ILIAS/TestQuestionPool'),('qht','ilAssHintPage','classes','components/ILIAS/TestQuestionPool'),('qpl','ilAssQuestionPage','classes','components/ILIAS/TestQuestionPool'),('sahs','ilSCORM2004Page','classes','components/ILIAS/Scorm2004'),('stys','ilPageLayoutPage','Layout/classes','components/ILIAS/COPage'),('term','ilGlossaryDefPage','classes','components/ILIAS/Glossary'),('tst','ilTestPage','classes/PageEditor','components/ILIAS/Test'),('wpg','ilWikiPage','classes','components/ILIAS/Wiki');
/*!40000 ALTER TABLE `copg_pobj_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `copg_section_timings`
--

DROP TABLE IF EXISTS `copg_section_timings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `copg_section_timings` (
  `page_id` int NOT NULL DEFAULT '0',
  `parent_type` varchar(10) NOT NULL DEFAULT '',
  `unix_ts` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`,`parent_type`,`unix_ts`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `copg_section_timings`
--

LOCK TABLES `copg_section_timings` WRITE;
/*!40000 ALTER TABLE `copg_section_timings` DISABLE KEYS */;
/*!40000 ALTER TABLE `copg_section_timings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `copy_wizard_options`
--

DROP TABLE IF EXISTS `copy_wizard_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `copy_wizard_options` (
  `copy_id` int NOT NULL DEFAULT '0',
  `source_id` int NOT NULL DEFAULT '0',
  `options` longtext,
  PRIMARY KEY (`copy_id`,`source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `copy_wizard_options`
--

LOCK TABLES `copy_wizard_options` WRITE;
/*!40000 ALTER TABLE `copy_wizard_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `copy_wizard_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_auxilaryresource`
--

DROP TABLE IF EXISTS `cp_auxilaryresource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_auxilaryresource` (
  `auxiliaryresourceid` varchar(255) DEFAULT NULL,
  `cp_node_id` int NOT NULL DEFAULT '0',
  `purpose` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_auxilaryresource`
--

LOCK TABLES `cp_auxilaryresource` WRITE;
/*!40000 ALTER TABLE `cp_auxilaryresource` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_auxilaryresource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_condition`
--

DROP TABLE IF EXISTS `cp_condition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_condition` (
  `c_condition` varchar(50) DEFAULT NULL,
  `cp_node_id` int NOT NULL DEFAULT '0',
  `measurethreshold` varchar(50) DEFAULT NULL,
  `c_operator` varchar(50) DEFAULT NULL,
  `referencedobjective` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_condition`
--

LOCK TABLES `cp_condition` WRITE;
/*!40000 ALTER TABLE `cp_condition` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_condition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_datamap`
--

DROP TABLE IF EXISTS `cp_datamap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_datamap` (
  `sco_node_id` int NOT NULL DEFAULT '0',
  `cp_node_id` int NOT NULL DEFAULT '0',
  `slm_id` int NOT NULL DEFAULT '0',
  `target_id` varchar(4000) NOT NULL DEFAULT '',
  `read_shared_data` tinyint DEFAULT '1',
  `write_shared_data` tinyint DEFAULT '1',
  PRIMARY KEY (`cp_node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_datamap`
--

LOCK TABLES `cp_datamap` WRITE;
/*!40000 ALTER TABLE `cp_datamap` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_datamap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_dependency`
--

DROP TABLE IF EXISTS `cp_dependency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_dependency` (
  `cp_node_id` int NOT NULL DEFAULT '0',
  `resourceid` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`),
  KEY `i2_idx` (`resourceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_dependency`
--

LOCK TABLES `cp_dependency` WRITE;
/*!40000 ALTER TABLE `cp_dependency` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_dependency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_file`
--

DROP TABLE IF EXISTS `cp_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_file` (
  `cp_node_id` int NOT NULL DEFAULT '0',
  `href` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_file`
--

LOCK TABLES `cp_file` WRITE;
/*!40000 ALTER TABLE `cp_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_hidelmsui`
--

DROP TABLE IF EXISTS `cp_hidelmsui`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_hidelmsui` (
  `cp_node_id` int NOT NULL DEFAULT '0',
  `value` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`),
  KEY `i1_idx` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_hidelmsui`
--

LOCK TABLES `cp_hidelmsui` WRITE;
/*!40000 ALTER TABLE `cp_hidelmsui` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_hidelmsui` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_item`
--

DROP TABLE IF EXISTS `cp_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_item` (
  `completionthreshold` varchar(50) DEFAULT '1.0',
  `cp_node_id` int NOT NULL DEFAULT '0',
  `datafromlms` varchar(4000) DEFAULT NULL,
  `id` varchar(200) DEFAULT NULL,
  `isvisible` varchar(32) DEFAULT NULL,
  `parameters` varchar(255) DEFAULT NULL,
  `resourceid` varchar(200) DEFAULT NULL,
  `sequencingid` varchar(50) DEFAULT NULL,
  `timelimitaction` varchar(30) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `progressweight` varchar(50) DEFAULT '1.0',
  `completedbymeasure` tinyint DEFAULT '0',
  PRIMARY KEY (`cp_node_id`),
  KEY `i1_idx` (`id`),
  KEY `i2_idx` (`sequencingid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_item`
--

LOCK TABLES `cp_item` WRITE;
/*!40000 ALTER TABLE `cp_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_manifest`
--

DROP TABLE IF EXISTS `cp_manifest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_manifest` (
  `base` varchar(200) DEFAULT NULL,
  `cp_node_id` int NOT NULL DEFAULT '0',
  `defaultorganization` varchar(255) DEFAULT NULL,
  `id` varchar(200) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `version` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`),
  KEY `i1_idx` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_manifest`
--

LOCK TABLES `cp_manifest` WRITE;
/*!40000 ALTER TABLE `cp_manifest` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_manifest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_mapinfo`
--

DROP TABLE IF EXISTS `cp_mapinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_mapinfo` (
  `cp_node_id` int NOT NULL DEFAULT '0',
  `readnormalmeasure` tinyint DEFAULT NULL,
  `readsatisfiedstatus` tinyint DEFAULT NULL,
  `targetobjectiveid` varchar(255) DEFAULT NULL,
  `writenormalmeasure` tinyint DEFAULT NULL,
  `writesatisfiedstatus` tinyint DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`),
  KEY `i1_idx` (`targetobjectiveid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_mapinfo`
--

LOCK TABLES `cp_mapinfo` WRITE;
/*!40000 ALTER TABLE `cp_mapinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_mapinfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_node`
--

DROP TABLE IF EXISTS `cp_node`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_node` (
  `cp_node_id` int NOT NULL DEFAULT '0',
  `nodename` varchar(50) DEFAULT NULL,
  `slm_id` int DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`),
  KEY `i2_idx` (`nodename`),
  KEY `i3_idx` (`slm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_node`
--

LOCK TABLES `cp_node` WRITE;
/*!40000 ALTER TABLE `cp_node` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_node` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_node_seq`
--

DROP TABLE IF EXISTS `cp_node_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_node_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_node_seq`
--

LOCK TABLES `cp_node_seq` WRITE;
/*!40000 ALTER TABLE `cp_node_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_node_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_objective`
--

DROP TABLE IF EXISTS `cp_objective`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_objective` (
  `cp_node_id` int NOT NULL DEFAULT '0',
  `minnormalmeasure` varchar(50) DEFAULT NULL,
  `objectiveid` varchar(200) DEFAULT NULL,
  `c_primary` tinyint DEFAULT NULL,
  `satisfiedbymeasure` tinyint DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_objective`
--

LOCK TABLES `cp_objective` WRITE;
/*!40000 ALTER TABLE `cp_objective` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_objective` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_organization`
--

DROP TABLE IF EXISTS `cp_organization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_organization` (
  `cp_node_id` int NOT NULL DEFAULT '0',
  `id` varchar(200) DEFAULT NULL,
  `objectivesglobtosys` tinyint DEFAULT NULL,
  `sequencingid` varchar(50) DEFAULT NULL,
  `structure` varchar(200) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`),
  KEY `i1_idx` (`id`),
  KEY `i2_idx` (`sequencingid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_organization`
--

LOCK TABLES `cp_organization` WRITE;
/*!40000 ALTER TABLE `cp_organization` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_organization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_package`
--

DROP TABLE IF EXISTS `cp_package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_package` (
  `created` varchar(20) DEFAULT NULL,
  `c_identifier` varchar(255) DEFAULT NULL,
  `jsdata` longtext,
  `modified` varchar(20) DEFAULT NULL,
  `obj_id` int NOT NULL DEFAULT '0',
  `persistprevattempts` int DEFAULT NULL,
  `c_settings` varchar(255) DEFAULT NULL,
  `xmldata` longtext,
  `activitytree` longtext,
  `global_to_system` tinyint NOT NULL DEFAULT '1',
  `shared_data_global_to_system` tinyint DEFAULT '1',
  PRIMARY KEY (`obj_id`),
  KEY `i1_idx` (`c_identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_package`
--

LOCK TABLES `cp_package` WRITE;
/*!40000 ALTER TABLE `cp_package` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_package` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_resource`
--

DROP TABLE IF EXISTS `cp_resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_resource` (
  `base` varchar(4000) DEFAULT NULL,
  `cp_node_id` int NOT NULL DEFAULT '0',
  `href` varchar(4000) DEFAULT NULL,
  `id` varchar(200) DEFAULT NULL,
  `scormtype` varchar(32) DEFAULT NULL,
  `c_type` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`),
  KEY `i1_idx` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_resource`
--

LOCK TABLES `cp_resource` WRITE;
/*!40000 ALTER TABLE `cp_resource` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_rule`
--

DROP TABLE IF EXISTS `cp_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_rule` (
  `action` varchar(50) DEFAULT NULL,
  `childactivityset` varchar(50) DEFAULT NULL,
  `conditioncombination` varchar(50) DEFAULT NULL,
  `cp_node_id` int NOT NULL DEFAULT '0',
  `minimumcount` int DEFAULT NULL,
  `minimumpercent` varchar(50) DEFAULT NULL,
  `c_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_rule`
--

LOCK TABLES `cp_rule` WRITE;
/*!40000 ALTER TABLE `cp_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_sequencing`
--

DROP TABLE IF EXISTS `cp_sequencing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_sequencing` (
  `activityabsdurlimit` varchar(20) DEFAULT NULL,
  `activityexpdurlimit` varchar(20) DEFAULT NULL,
  `attemptabsdurlimit` varchar(20) DEFAULT NULL,
  `attemptexpdurlimit` varchar(20) DEFAULT NULL,
  `attemptlimit` int DEFAULT NULL,
  `begintimelimit` varchar(20) DEFAULT NULL,
  `choice` tinyint DEFAULT NULL,
  `choiceexit` tinyint DEFAULT NULL,
  `completionbycontent` tinyint DEFAULT NULL,
  `constrainchoice` tinyint DEFAULT NULL,
  `cp_node_id` int NOT NULL DEFAULT '0',
  `endtimelimit` varchar(20) DEFAULT NULL,
  `flow` tinyint DEFAULT NULL,
  `forwardonly` tinyint DEFAULT NULL,
  `id` varchar(200) DEFAULT NULL,
  `measuresatisfactive` tinyint DEFAULT NULL,
  `objectivemeasweight` double DEFAULT NULL,
  `objectivebycontent` tinyint DEFAULT NULL,
  `preventactivation` tinyint DEFAULT NULL,
  `randomizationtiming` varchar(50) DEFAULT NULL,
  `reorderchildren` tinyint DEFAULT NULL,
  `requiredcompleted` varchar(50) DEFAULT NULL,
  `requiredincomplete` varchar(50) DEFAULT NULL,
  `requirednotsatisfied` varchar(50) DEFAULT NULL,
  `requiredforsatisfied` varchar(50) DEFAULT NULL,
  `rollupobjectivesatis` tinyint DEFAULT NULL,
  `rollupprogcompletion` tinyint DEFAULT NULL,
  `selectcount` int DEFAULT NULL,
  `selectiontiming` varchar(50) DEFAULT NULL,
  `sequencingid` varchar(50) DEFAULT NULL,
  `tracked` tinyint DEFAULT NULL,
  `usecurattemptobjinfo` tinyint DEFAULT NULL,
  `usecurattemptproginfo` tinyint DEFAULT NULL,
  PRIMARY KEY (`cp_node_id`),
  KEY `i1_idx` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_sequencing`
--

LOCK TABLES `cp_sequencing` WRITE;
/*!40000 ALTER TABLE `cp_sequencing` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_sequencing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_suspend`
--

DROP TABLE IF EXISTS `cp_suspend`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_suspend` (
  `data` longtext,
  `user_id` int NOT NULL,
  `obj_id` int NOT NULL,
  PRIMARY KEY (`user_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_suspend`
--

LOCK TABLES `cp_suspend` WRITE;
/*!40000 ALTER TABLE `cp_suspend` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_suspend` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cp_tree`
--

DROP TABLE IF EXISTS `cp_tree`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cp_tree` (
  `child` int NOT NULL DEFAULT '0',
  `depth` int DEFAULT NULL,
  `lft` int DEFAULT NULL,
  `obj_id` int NOT NULL DEFAULT '0',
  `parent` int DEFAULT NULL,
  `rgt` int DEFAULT NULL,
  PRIMARY KEY (`obj_id`,`child`),
  KEY `i1_idx` (`child`),
  KEY `i2_idx` (`obj_id`),
  KEY `i3_idx` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cp_tree`
--

LOCK TABLES `cp_tree` WRITE;
/*!40000 ALTER TABLE `cp_tree` DISABLE KEYS */;
/*!40000 ALTER TABLE `cp_tree` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cron_job`
--

DROP TABLE IF EXISTS `cron_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cron_job` (
  `job_id` varchar(50) NOT NULL DEFAULT '',
  `component` varchar(200) DEFAULT NULL,
  `schedule_type` tinyint DEFAULT NULL,
  `schedule_value` int DEFAULT NULL,
  `job_status` tinyint DEFAULT NULL,
  `job_status_user_id` int DEFAULT NULL,
  `job_status_type` tinyint DEFAULT NULL,
  `job_status_ts` int DEFAULT NULL,
  `job_result_status` tinyint DEFAULT NULL,
  `job_result_user_id` int DEFAULT NULL,
  `job_result_code` varchar(64) DEFAULT NULL,
  `job_result_message` varchar(400) DEFAULT NULL,
  `job_result_type` tinyint DEFAULT NULL,
  `job_result_ts` int DEFAULT NULL,
  `class` varchar(255) DEFAULT NULL,
  `path` varchar(400) DEFAULT NULL,
  `running_ts` int DEFAULT NULL,
  `job_result_dur` int DEFAULT NULL,
  `alive_ts` int DEFAULT NULL,
  PRIMARY KEY (`job_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cron_job`
--

LOCK TABLES `cron_job` WRITE;
/*!40000 ALTER TABLE `cron_job` DISABLE KEYS */;
INSERT INTO `cron_job` VALUES ('auth_destroy_expired_sessions','components/ILIAS/Authentication',3,1,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilAuthDestroyExpiredSessionsCron',NULL,NULL,NULL,NULL),('book_notification','components/ILIAS/BookingManager',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilBookCronNotification',NULL,NULL,NULL,NULL),('book_pref_book','components/ILIAS/BookingManager',1,NULL,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilBookingPrefBookCron',NULL,NULL,NULL,NULL),('cal_consultation','components/ILIAS/Calendar',0,0,0,0,0,0,0,0,'','',0,0,'ilConsultationHourCron','Services/Calendar/classes/ConsultationHours/',0,0,0),('cal_remote_reader','components/ILIAS/Calendar',2,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilCalendarCronRemoteReader','Services/Calendar/classes/Cron/',NULL,NULL,NULL),('certificate','components/ILIAS/Certificate',2,1,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilCertificateCron',NULL,NULL,NULL,NULL),('copg_history_cleanup','components/ILIAS/COPage',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilCleanCOPageHistoryCronjob','Services/COPage/Cron',NULL,NULL,NULL),('crs_timings_reminder','components/ILIAS/Course',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilTimingsCronReminder',NULL,NULL,NULL,NULL),('ecs_task_handler','components/ILIAS/WebServices',3,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilCronEcsTaskScheduler',NULL,NULL,NULL,NULL),('exc_feedback_notification','components/ILIAS/Exercise',0,0,1,0,0,1381511097,0,0,'','',0,0,'ilExcCronFeedbackNotification',NULL,0,0,0),('exc_reminders','components/ILIAS/Exercise',1,NULL,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilExcCronReminders',NULL,NULL,NULL,NULL),('file_system_clean_temp_dir','components/ILIAS/Filesystem',1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilFileSystemCleanTempDirCron',NULL,NULL,NULL,NULL),('finish_unfinished_passes','components/ILIAS/Test',1,0,0,0,0,0,0,0,'','',0,0,'ilCronFinishUnfinishedTestPasses',NULL,0,0,0),('frm_notification','components/ILIAS/Forum',3,1,0,0,0,0,0,0,'','',0,0,'ilForumCronNotification',NULL,0,0,0),('ldap_sync','components/ILIAS/LDAP',0,0,0,0,0,0,0,0,'','',0,0,'ilLDAPCronSynchronization',NULL,0,0,0),('log_error_file_cleanup','components/ILIAS/Logging',4,10,0,0,0,0,0,0,'','',0,0,'ilLoggerCronCleanErrorFiles','Services/Logging/classes/error/',0,0,0),('lp_object_statistics','components/ILIAS/Tracking',0,0,1,0,0,1381511103,0,0,'','',0,0,'ilLPCronObjectStatistics',NULL,0,0,0),('lti_outcome','components/ILIAS/LTIProvider',2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilLTICronOutcomeService',NULL,NULL,NULL,NULL),('mail_notification','components/ILIAS/Mail',0,0,1,6,1,1481898063,NULL,6,'job_manual_reset','Cron job re-activated by admin',1,0,'ilMailCronNotification',NULL,0,0,0),('mail_orphaned_mails','components/ILIAS/Mail',1,1,0,0,0,0,0,0,'','',0,0,'ilMailCronOrphanedMails',NULL,0,0,0),('mem_min_members','components/ILIAS/Membership',0,0,1,0,0,1443610661,0,0,'','',0,0,'ilMembershipCronMinMembers','Services/Membership/classes/Cron',0,0,0),('mem_notification','components/ILIAS/Membership',1,0,0,0,0,0,0,0,'','',0,0,'ilMembershipCronNotifications','Services/Membership/classes/Cron',0,0,0),('meta_oer_harvester','components/ILIAS/MetaData',1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilCronOerHarvester',NULL,NULL,NULL,NULL),('orgunit_paths','components/ILIAS/OrgUnit',1,0,1,0,0,1472816001,0,0,'','',0,0,'ilCronUpdateOrgUnitPaths',NULL,0,0,0),('prg_invalidate_expired_progresses','components/ILIAS/StudyProgramme',4,1,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilPrgInvalidateExpiredProgressesCronJob',NULL,NULL,NULL,NULL),('prg_restart_assignments_temporal_progress','components/ILIAS/StudyProgramme',4,1,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilPrgRestartAssignmentsCronJob',NULL,NULL,NULL,NULL),('prg_update_progress','components/ILIAS/StudyProgramme',4,1,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilPrgUpdateProgressCronJob',NULL,NULL,NULL,NULL),('prg_user_not_restarted','components/ILIAS/StudyProgramme',4,1,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilPrgUserNotRestartedCronJob',NULL,NULL,NULL,NULL),('prg_user_risky_to_fail','components/ILIAS/StudyProgramme',4,1,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilPrgUserRiskyToFailCronJob',NULL,NULL,NULL,NULL),('skll_notification','components/ILIAS/Skill',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilSkillNotifications',NULL,NULL,NULL,NULL),('src_lucene_indexer','components/ILIAS/Search',1,0,0,0,0,0,0,0,'','',0,0,'ilLuceneIndexer','Services/Search/classes/Lucene/',0,0,0),('survey_notification','components/ILIAS/Survey',0,0,1,0,0,1381511099,0,0,'','',0,0,'ilSurveyCronNotification',NULL,0,0,0),('sysc_trash','components/ILIAS/SystemCheck',5,1,0,0,0,0,0,0,'','',0,0,'ilSCCronTrash',NULL,0,0,0),('user_check_accounts','components/ILIAS/User',0,0,0,0,0,0,0,0,'','',0,0,'ilUserCronCheckAccounts',NULL,0,0,0),('user_inactivated','components/ILIAS/User',1,0,0,0,0,0,0,0,'','',0,0,'ilCronDeleteInactivatedUserAccounts',NULL,0,0,0),('user_inactive','components/ILIAS/User',1,0,0,0,0,0,0,0,'','',0,0,'ilCronDeleteInactiveUserAccounts',NULL,0,0,0),('user_never_logged_in','components/ILIAS/User',1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilCronDeleteNeverLoggedInUserAccounts',NULL,NULL,NULL,NULL),('wopi_crawler','components/ILIAS/WOPI',5,1,1,0,0,1702399177,NULL,NULL,NULL,NULL,NULL,NULL,'ilWOPICrawler',NULL,NULL,NULL,NULL),('xapi_deletion_cron','components/ILIAS/CmiXapi',1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilCmiXapiDelCron',NULL,NULL,NULL,NULL),('xapi_results_evaluation','components/ILIAS/CmiXapi',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ilXapiResultsCronjob',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cron_job` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_archives`
--

DROP TABLE IF EXISTS `crs_archives`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_archives` (
  `archive_id` int NOT NULL DEFAULT '0',
  `course_id` int NOT NULL DEFAULT '0',
  `archive_name` varchar(255) DEFAULT NULL,
  `archive_type` tinyint NOT NULL DEFAULT '0',
  `archive_date` bigint DEFAULT NULL,
  `archive_size` int DEFAULT NULL,
  `archive_lang` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`archive_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_archives`
--

LOCK TABLES `crs_archives` WRITE;
/*!40000 ALTER TABLE `crs_archives` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_archives` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_archives_seq`
--

DROP TABLE IF EXISTS `crs_archives_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_archives_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_archives_seq`
--

LOCK TABLES `crs_archives_seq` WRITE;
/*!40000 ALTER TABLE `crs_archives_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_archives_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_f_definitions`
--

DROP TABLE IF EXISTS `crs_f_definitions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_f_definitions` (
  `field_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `field_name` varchar(255) DEFAULT NULL,
  `field_type` tinyint NOT NULL DEFAULT '0',
  `field_values` longtext,
  `field_required` tinyint NOT NULL DEFAULT '0',
  `field_values_opt` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_f_definitions`
--

LOCK TABLES `crs_f_definitions` WRITE;
/*!40000 ALTER TABLE `crs_f_definitions` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_f_definitions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_f_definitions_seq`
--

DROP TABLE IF EXISTS `crs_f_definitions_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_f_definitions_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_f_definitions_seq`
--

LOCK TABLES `crs_f_definitions_seq` WRITE;
/*!40000 ALTER TABLE `crs_f_definitions_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_f_definitions_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_file`
--

DROP TABLE IF EXISTS `crs_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_file` (
  `file_id` int NOT NULL DEFAULT '0',
  `course_id` int NOT NULL DEFAULT '0',
  `file_name` char(64) DEFAULT NULL,
  `file_type` char(64) DEFAULT NULL,
  `file_size` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_file`
--

LOCK TABLES `crs_file` WRITE;
/*!40000 ALTER TABLE `crs_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_file_seq`
--

DROP TABLE IF EXISTS `crs_file_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_file_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_file_seq`
--

LOCK TABLES `crs_file_seq` WRITE;
/*!40000 ALTER TABLE `crs_file_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_file_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_groupings`
--

DROP TABLE IF EXISTS `crs_groupings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_groupings` (
  `crs_grp_id` int NOT NULL DEFAULT '0',
  `crs_ref_id` int NOT NULL DEFAULT '0',
  `crs_id` int NOT NULL DEFAULT '0',
  `unique_field` char(32) DEFAULT NULL,
  PRIMARY KEY (`crs_grp_id`),
  KEY `i1_idx` (`crs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_groupings`
--

LOCK TABLES `crs_groupings` WRITE;
/*!40000 ALTER TABLE `crs_groupings` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_groupings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_items`
--

DROP TABLE IF EXISTS `crs_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_items` (
  `parent_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `timing_type` tinyint DEFAULT NULL,
  `timing_start` bigint NOT NULL DEFAULT '0',
  `timing_end` bigint NOT NULL DEFAULT '0',
  `suggestion_start` bigint NOT NULL DEFAULT '0',
  `suggestion_end` bigint NOT NULL DEFAULT '0',
  `changeable` tinyint NOT NULL DEFAULT '0',
  `visible` tinyint NOT NULL DEFAULT '0',
  `position` int DEFAULT NULL,
  `suggestion_start_rel` bigint DEFAULT '0',
  `suggestion_end_rel` bigint DEFAULT '0',
  PRIMARY KEY (`parent_id`,`obj_id`),
  KEY `ob_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_items`
--

LOCK TABLES `crs_items` WRITE;
/*!40000 ALTER TABLE `crs_items` DISABLE KEYS */;
INSERT INTO `crs_items` VALUES (1,9,1,1450792127,1450792127,1450792127,1450792127,0,0,0,0,0),(9,8,1,1450792127,1450792127,1450792127,1450792127,0,0,0,0,0),(9,12,1,1481898045,1481898045,1481898045,1481898045,0,0,0,0,0),(9,16,1,1450795974,1450795974,1450795974,1450795974,0,0,0,0,0),(9,17,1,1481897710,1481897710,1481897710,1481897710,0,0,0,0,0),(9,18,1,1450795859,1450795859,1450795859,1450795859,0,0,0,0,0),(9,22,1,1450796001,1450796001,1450796001,1450796001,0,0,0,0,0),(9,23,1,1450795847,1450795847,1450795847,1450795847,0,0,0,0,0),(9,29,1,1450795894,1450795894,1450795894,1450795894,0,0,0,0,0),(9,30,1,1450796011,1450796011,1450796011,1450796011,0,0,0,0,0),(9,32,1,1481899353,1481899353,1481899353,1481899353,0,0,0,0,0),(9,34,1,1482324927,1482324927,1482324927,1482324927,0,0,0,0,0),(9,36,1,1481898367,1481898367,1481898367,1481898367,0,0,0,0,0),(9,37,1,1450796232,1450796232,1450796232,1450796232,0,0,0,0,0),(9,39,1,1481899398,1481899398,1481899398,1481899398,0,0,0,0,0),(9,52,1,1450795488,1450795488,1450795488,1450795488,0,0,0,0,0),(9,53,1,1450796052,1450796052,1450796052,1450796052,0,0,0,0,0),(9,55,1,1481899451,1481899451,1481899451,1481899451,0,0,0,0,0),(9,57,1,1450796335,1450796335,1450796335,1450796335,0,0,0,0,0),(9,64,1,1450795969,1450795969,1450795969,1450795969,0,0,0,0,0);
/*!40000 ALTER TABLE `crs_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_lm_history`
--

DROP TABLE IF EXISTS `crs_lm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_lm_history` (
  `usr_id` int NOT NULL DEFAULT '0',
  `crs_ref_id` int NOT NULL DEFAULT '0',
  `lm_ref_id` int NOT NULL DEFAULT '0',
  `lm_page_id` int NOT NULL DEFAULT '0',
  `last_access` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`usr_id`,`crs_ref_id`,`lm_ref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_lm_history`
--

LOCK TABLES `crs_lm_history` WRITE;
/*!40000 ALTER TABLE `crs_lm_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_lm_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objective_lm`
--

DROP TABLE IF EXISTS `crs_objective_lm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objective_lm` (
  `lm_ass_id` int NOT NULL DEFAULT '0',
  `objective_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `type` char(6) DEFAULT NULL,
  `position` int DEFAULT '0',
  PRIMARY KEY (`lm_ass_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objective_lm`
--

LOCK TABLES `crs_objective_lm` WRITE;
/*!40000 ALTER TABLE `crs_objective_lm` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objective_lm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objective_lm_seq`
--

DROP TABLE IF EXISTS `crs_objective_lm_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objective_lm_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objective_lm_seq`
--

LOCK TABLES `crs_objective_lm_seq` WRITE;
/*!40000 ALTER TABLE `crs_objective_lm_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objective_lm_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objective_qst`
--

DROP TABLE IF EXISTS `crs_objective_qst`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objective_qst` (
  `qst_ass_id` int NOT NULL DEFAULT '0',
  `objective_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `question_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`qst_ass_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objective_qst`
--

LOCK TABLES `crs_objective_qst` WRITE;
/*!40000 ALTER TABLE `crs_objective_qst` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objective_qst` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objective_qst_seq`
--

DROP TABLE IF EXISTS `crs_objective_qst_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objective_qst_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objective_qst_seq`
--

LOCK TABLES `crs_objective_qst_seq` WRITE;
/*!40000 ALTER TABLE `crs_objective_qst_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objective_qst_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objective_status`
--

DROP TABLE IF EXISTS `crs_objective_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objective_status` (
  `objective_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `status` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`objective_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objective_status`
--

LOCK TABLES `crs_objective_status` WRITE;
/*!40000 ALTER TABLE `crs_objective_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objective_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objective_status_p`
--

DROP TABLE IF EXISTS `crs_objective_status_p`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objective_status_p` (
  `objective_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`objective_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objective_status_p`
--

LOCK TABLES `crs_objective_status_p` WRITE;
/*!40000 ALTER TABLE `crs_objective_status_p` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objective_status_p` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objective_tst`
--

DROP TABLE IF EXISTS `crs_objective_tst`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objective_tst` (
  `test_objective_id` int NOT NULL DEFAULT '0',
  `objective_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `tst_status` tinyint DEFAULT NULL,
  `tst_limit` tinyint DEFAULT NULL,
  `tst_limit_p` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`test_objective_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objective_tst`
--

LOCK TABLES `crs_objective_tst` WRITE;
/*!40000 ALTER TABLE `crs_objective_tst` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objective_tst` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objective_tst_seq`
--

DROP TABLE IF EXISTS `crs_objective_tst_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objective_tst_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objective_tst_seq`
--

LOCK TABLES `crs_objective_tst_seq` WRITE;
/*!40000 ALTER TABLE `crs_objective_tst_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objective_tst_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objectives`
--

DROP TABLE IF EXISTS `crs_objectives`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objectives` (
  `crs_id` int NOT NULL DEFAULT '0',
  `objective_id` int NOT NULL DEFAULT '0',
  `title` varchar(70) DEFAULT NULL,
  `description` varchar(500) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  `created` int NOT NULL DEFAULT '0',
  `active` tinyint DEFAULT '1',
  `passes` smallint DEFAULT '0',
  PRIMARY KEY (`objective_id`),
  KEY `i1_idx` (`crs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objectives`
--

LOCK TABLES `crs_objectives` WRITE;
/*!40000 ALTER TABLE `crs_objectives` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objectives` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_objectives_seq`
--

DROP TABLE IF EXISTS `crs_objectives_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_objectives_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_objectives_seq`
--

LOCK TABLES `crs_objectives_seq` WRITE;
/*!40000 ALTER TABLE `crs_objectives_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_objectives_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_reference_settings`
--

DROP TABLE IF EXISTS `crs_reference_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_reference_settings` (
  `obj_id` int NOT NULL DEFAULT '0',
  `member_update` tinyint NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_reference_settings`
--

LOCK TABLES `crs_reference_settings` WRITE;
/*!40000 ALTER TABLE `crs_reference_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_reference_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_settings`
--

DROP TABLE IF EXISTS `crs_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_settings` (
  `obj_id` int NOT NULL DEFAULT '0',
  `syllabus` varchar(4000) DEFAULT NULL,
  `contact_name` varchar(255) DEFAULT NULL,
  `contact_responsibility` varchar(255) DEFAULT NULL,
  `contact_phone` varchar(255) DEFAULT NULL,
  `contact_email` varchar(255) DEFAULT NULL,
  `contact_consultation` varchar(4000) DEFAULT NULL,
  `activation_type` tinyint NOT NULL DEFAULT '0',
  `activation_start` bigint DEFAULT NULL,
  `activation_end` bigint DEFAULT NULL,
  `sub_limitation_type` tinyint NOT NULL DEFAULT '0',
  `sub_start` bigint DEFAULT NULL,
  `sub_end` bigint DEFAULT NULL,
  `sub_type` int DEFAULT NULL,
  `sub_password` varchar(32) DEFAULT NULL,
  `sub_mem_limit` tinyint NOT NULL DEFAULT '0',
  `sub_max_members` int DEFAULT NULL,
  `sub_notify` int DEFAULT NULL,
  `view_mode` tinyint NOT NULL DEFAULT '0',
  `sortorder` int DEFAULT NULL,
  `archive_start` bigint DEFAULT NULL,
  `archive_end` bigint DEFAULT NULL,
  `archive_type` int DEFAULT NULL,
  `abo` tinyint DEFAULT '1',
  `waiting_list` tinyint NOT NULL DEFAULT '1',
  `important` varchar(4000) DEFAULT NULL,
  `show_members` tinyint NOT NULL DEFAULT '1',
  `latitude` varchar(30) DEFAULT NULL,
  `longitude` varchar(30) DEFAULT NULL,
  `location_zoom` int NOT NULL DEFAULT '0',
  `enable_course_map` tinyint NOT NULL DEFAULT '0',
  `session_limit` tinyint NOT NULL DEFAULT '0',
  `session_prev` bigint NOT NULL DEFAULT '-1',
  `session_next` bigint NOT NULL DEFAULT '-1',
  `reg_ac_enabled` tinyint NOT NULL DEFAULT '0',
  `reg_ac` varchar(32) DEFAULT NULL,
  `status_dt` tinyint DEFAULT '2',
  `auto_notification` tinyint NOT NULL DEFAULT '1',
  `mail_members_type` tinyint DEFAULT '1',
  `crs_start` bigint DEFAULT NULL,
  `crs_end` bigint DEFAULT NULL,
  `leave_end` bigint DEFAULT NULL,
  `auto_wait` tinyint NOT NULL DEFAULT '0',
  `min_members` smallint DEFAULT NULL,
  `show_members_export` int DEFAULT NULL,
  `timing_mode` tinyint DEFAULT '0',
  `period_start` datetime DEFAULT NULL,
  `period_end` datetime DEFAULT NULL,
  `period_time_indication` int NOT NULL DEFAULT '0',
  `target_group` varchar(4000) DEFAULT NULL,
  `tutorial_support_block` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_settings`
--

LOCK TABLES `crs_settings` WRITE;
/*!40000 ALTER TABLE `crs_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_start`
--

DROP TABLE IF EXISTS `crs_start`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_start` (
  `crs_start_id` int NOT NULL DEFAULT '0',
  `crs_id` int NOT NULL DEFAULT '0',
  `item_ref_id` int NOT NULL DEFAULT '0',
  `pos` int DEFAULT NULL,
  PRIMARY KEY (`crs_start_id`),
  KEY `i1_idx` (`crs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_start`
--

LOCK TABLES `crs_start` WRITE;
/*!40000 ALTER TABLE `crs_start` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_start` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_start_seq`
--

DROP TABLE IF EXISTS `crs_start_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_start_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_start_seq`
--

LOCK TABLES `crs_start_seq` WRITE;
/*!40000 ALTER TABLE `crs_start_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_start_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_timings_exceeded`
--

DROP TABLE IF EXISTS `crs_timings_exceeded`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_timings_exceeded` (
  `user_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `sent` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`ref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_timings_exceeded`
--

LOCK TABLES `crs_timings_exceeded` WRITE;
/*!40000 ALTER TABLE `crs_timings_exceeded` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_timings_exceeded` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_timings_planed`
--

DROP TABLE IF EXISTS `crs_timings_planed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_timings_planed` (
  `item_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `planed_start` bigint NOT NULL DEFAULT '0',
  `planed_end` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_timings_planed`
--

LOCK TABLES `crs_timings_planed` WRITE;
/*!40000 ALTER TABLE `crs_timings_planed` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_timings_planed` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_timings_started`
--

DROP TABLE IF EXISTS `crs_timings_started`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_timings_started` (
  `user_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `sent` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`ref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_timings_started`
--

LOCK TABLES `crs_timings_started` WRITE;
/*!40000 ALTER TABLE `crs_timings_started` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_timings_started` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_timings_user`
--

DROP TABLE IF EXISTS `crs_timings_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_timings_user` (
  `ref_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `sstart` bigint NOT NULL DEFAULT '0',
  `ssend` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ref_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_timings_user`
--

LOCK TABLES `crs_timings_user` WRITE;
/*!40000 ALTER TABLE `crs_timings_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_timings_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_timings_usr_accept`
--

DROP TABLE IF EXISTS `crs_timings_usr_accept`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_timings_usr_accept` (
  `crs_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `accept` tinyint NOT NULL DEFAULT '0',
  `remark` varchar(4000) DEFAULT NULL,
  `visible` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`crs_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_timings_usr_accept`
--

LOCK TABLES `crs_timings_usr_accept` WRITE;
/*!40000 ALTER TABLE `crs_timings_usr_accept` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_timings_usr_accept` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_user_data`
--

DROP TABLE IF EXISTS `crs_user_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_user_data` (
  `usr_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `value` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`usr_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_user_data`
--

LOCK TABLES `crs_user_data` WRITE;
/*!40000 ALTER TABLE `crs_user_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_user_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crs_waiting_list`
--

DROP TABLE IF EXISTS `crs_waiting_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crs_waiting_list` (
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `sub_time` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crs_waiting_list`
--

LOCK TABLES `crs_waiting_list` WRITE;
/*!40000 ALTER TABLE `crs_waiting_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `crs_waiting_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_cache`
--

DROP TABLE IF EXISTS `data_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `data_cache` (
  `module` varchar(50) NOT NULL DEFAULT 'common',
  `keyword` varchar(50) NOT NULL DEFAULT ' ',
  `value` longtext,
  PRIMARY KEY (`module`,`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_cache`
--

LOCK TABLES `data_cache` WRITE;
/*!40000 ALTER TABLE `data_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `data_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dav_lock`
--

DROP TABLE IF EXISTS `dav_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dav_lock` (
  `token` varchar(255) NOT NULL DEFAULT ' ',
  `obj_id` int NOT NULL DEFAULT '0',
  `node_id` int NOT NULL DEFAULT '0',
  `ilias_owner` int NOT NULL DEFAULT '0',
  `dav_owner` varchar(200) DEFAULT NULL,
  `expires` int NOT NULL DEFAULT '0',
  `depth` int NOT NULL DEFAULT '0',
  `type` char(1) DEFAULT 'w',
  `scope` char(1) DEFAULT 's',
  PRIMARY KEY (`token`),
  UNIQUE KEY `c1_idx` (`token`),
  KEY `i1_idx` (`obj_id`,`node_id`),
  KEY `i2_idx` (`obj_id`,`node_id`,`token`),
  KEY `i3_idx` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dav_lock`
--

LOCK TABLES `dav_lock` WRITE;
/*!40000 ALTER TABLE `dav_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `dav_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dav_property`
--

DROP TABLE IF EXISTS `dav_property`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dav_property` (
  `obj_id` int NOT NULL DEFAULT '0',
  `node_id` int NOT NULL DEFAULT '0',
  `ns` varchar(120) NOT NULL DEFAULT 'DAV:',
  `name` varchar(120) NOT NULL DEFAULT ' ',
  `value` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`obj_id`,`node_id`,`name`,`ns`),
  KEY `i1_idx` (`obj_id`,`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dav_property`
--

LOCK TABLES `dav_property` WRITE;
/*!40000 ALTER TABLE `dav_property` DISABLE KEYS */;
/*!40000 ALTER TABLE `dav_property` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dbk_translations`
--

DROP TABLE IF EXISTS `dbk_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dbk_translations` (
  `id` int NOT NULL DEFAULT '0',
  `tr_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`tr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dbk_translations`
--

LOCK TABLES `dbk_translations` WRITE;
/*!40000 ALTER TABLE `dbk_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dbk_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `desktop_item`
--

DROP TABLE IF EXISTS `desktop_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `desktop_item` (
  `user_id` int NOT NULL DEFAULT '0',
  `item_id` int NOT NULL DEFAULT '0',
  `type` varchar(4) DEFAULT NULL,
  `parameters` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `desktop_item`
--

LOCK TABLES `desktop_item` WRITE;
/*!40000 ALTER TABLE `desktop_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `desktop_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_a`
--

DROP TABLE IF EXISTS `didactic_tpl_a`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_a` (
  `id` int NOT NULL DEFAULT '0',
  `tpl_id` int NOT NULL DEFAULT '0',
  `type_id` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_a`
--

LOCK TABLES `didactic_tpl_a` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_a` DISABLE KEYS */;
INSERT INTO `didactic_tpl_a` VALUES (1,1,1),(2,2,1);
/*!40000 ALTER TABLE `didactic_tpl_a` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_a_seq`
--

DROP TABLE IF EXISTS `didactic_tpl_a_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_a_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_a_seq`
--

LOCK TABLES `didactic_tpl_a_seq` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_a_seq` DISABLE KEYS */;
INSERT INTO `didactic_tpl_a_seq` VALUES (2);
/*!40000 ALTER TABLE `didactic_tpl_a_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_abr`
--

DROP TABLE IF EXISTS `didactic_tpl_abr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_abr` (
  `action_id` int NOT NULL DEFAULT '0',
  `filter_type` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_abr`
--

LOCK TABLES `didactic_tpl_abr` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_abr` DISABLE KEYS */;
/*!40000 ALTER TABLE `didactic_tpl_abr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_alp`
--

DROP TABLE IF EXISTS `didactic_tpl_alp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_alp` (
  `action_id` int NOT NULL DEFAULT '0',
  `filter_type` tinyint NOT NULL DEFAULT '0',
  `template_type` tinyint NOT NULL DEFAULT '0',
  `template_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_alp`
--

LOCK TABLES `didactic_tpl_alp` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_alp` DISABLE KEYS */;
INSERT INTO `didactic_tpl_alp` VALUES (1,3,2,82),(2,3,2,269);
/*!40000 ALTER TABLE `didactic_tpl_alp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_alr`
--

DROP TABLE IF EXISTS `didactic_tpl_alr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_alr` (
  `action_id` int NOT NULL DEFAULT '0',
  `role_template_id` int DEFAULT NULL,
  PRIMARY KEY (`action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_alr`
--

LOCK TABLES `didactic_tpl_alr` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_alr` DISABLE KEYS */;
/*!40000 ALTER TABLE `didactic_tpl_alr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_en`
--

DROP TABLE IF EXISTS `didactic_tpl_en`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_en` (
  `id` int NOT NULL DEFAULT '0',
  `node` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`node`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_en`
--

LOCK TABLES `didactic_tpl_en` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_en` DISABLE KEYS */;
/*!40000 ALTER TABLE `didactic_tpl_en` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_fp`
--

DROP TABLE IF EXISTS `didactic_tpl_fp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_fp` (
  `pattern_id` int NOT NULL DEFAULT '0',
  `pattern_type` tinyint NOT NULL DEFAULT '0',
  `pattern_sub_type` tinyint NOT NULL DEFAULT '0',
  `pattern` varchar(64) DEFAULT NULL,
  `parent_id` int NOT NULL DEFAULT '0',
  `parent_type` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`pattern_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_fp`
--

LOCK TABLES `didactic_tpl_fp` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_fp` DISABLE KEYS */;
INSERT INTO `didactic_tpl_fp` VALUES (1,1,1,'.*',1,'action'),(2,1,1,'.*',2,'action');
/*!40000 ALTER TABLE `didactic_tpl_fp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_fp_seq`
--

DROP TABLE IF EXISTS `didactic_tpl_fp_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_fp_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_fp_seq`
--

LOCK TABLES `didactic_tpl_fp_seq` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_fp_seq` DISABLE KEYS */;
INSERT INTO `didactic_tpl_fp_seq` VALUES (2);
/*!40000 ALTER TABLE `didactic_tpl_fp_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_objs`
--

DROP TABLE IF EXISTS `didactic_tpl_objs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_objs` (
  `obj_id` int NOT NULL DEFAULT '0',
  `tpl_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ref_id`,`tpl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_objs`
--

LOCK TABLES `didactic_tpl_objs` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_objs` DISABLE KEYS */;
/*!40000 ALTER TABLE `didactic_tpl_objs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_sa`
--

DROP TABLE IF EXISTS `didactic_tpl_sa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_sa` (
  `id` int NOT NULL DEFAULT '0',
  `obj_type` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`obj_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_sa`
--

LOCK TABLES `didactic_tpl_sa` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_sa` DISABLE KEYS */;
INSERT INTO `didactic_tpl_sa` VALUES (1,'grp'),(2,'sess');
/*!40000 ALTER TABLE `didactic_tpl_sa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_settings`
--

DROP TABLE IF EXISTS `didactic_tpl_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_settings` (
  `id` int NOT NULL DEFAULT '0',
  `enabled` tinyint NOT NULL DEFAULT '0',
  `type` tinyint NOT NULL DEFAULT '0',
  `title` varchar(64) DEFAULT NULL,
  `description` varchar(512) DEFAULT NULL,
  `info` varchar(4000) DEFAULT NULL,
  `auto_generated` tinyint NOT NULL DEFAULT '0',
  `exclusive_tpl` tinyint NOT NULL DEFAULT '0',
  `icon_ide` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_settings`
--

LOCK TABLES `didactic_tpl_settings` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_settings` DISABLE KEYS */;
INSERT INTO `didactic_tpl_settings` VALUES (1,1,1,'grp_closed','grp_closed_info','',1,0,NULL),(2,1,1,'sess_closed','sess_closed_info','',1,0,NULL);
/*!40000 ALTER TABLE `didactic_tpl_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `didactic_tpl_settings_seq`
--

DROP TABLE IF EXISTS `didactic_tpl_settings_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `didactic_tpl_settings_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `didactic_tpl_settings_seq`
--

LOCK TABLES `didactic_tpl_settings_seq` WRITE;
/*!40000 ALTER TABLE `didactic_tpl_settings_seq` DISABLE KEYS */;
INSERT INTO `didactic_tpl_settings_seq` VALUES (2);
/*!40000 ALTER TABLE `didactic_tpl_settings_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_cmap_rule`
--

DROP TABLE IF EXISTS `ecs_cmap_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_cmap_rule` (
  `rid` int NOT NULL DEFAULT '0',
  `sid` int NOT NULL DEFAULT '0',
  `mid` int NOT NULL DEFAULT '0',
  `attribute` varchar(64) DEFAULT NULL,
  `ref_id` int NOT NULL DEFAULT '0',
  `is_filter` tinyint NOT NULL DEFAULT '0',
  `filter` varchar(512) DEFAULT NULL,
  `create_subdir` tinyint NOT NULL DEFAULT '0',
  `subdir_type` tinyint NOT NULL DEFAULT '0',
  `directory` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_cmap_rule`
--

LOCK TABLES `ecs_cmap_rule` WRITE;
/*!40000 ALTER TABLE `ecs_cmap_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_cmap_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_cmap_rule_seq`
--

DROP TABLE IF EXISTS `ecs_cmap_rule_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_cmap_rule_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_cmap_rule_seq`
--

LOCK TABLES `ecs_cmap_rule_seq` WRITE;
/*!40000 ALTER TABLE `ecs_cmap_rule_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_cmap_rule_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_cms_data`
--

DROP TABLE IF EXISTS `ecs_cms_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_cms_data` (
  `obj_id` int NOT NULL DEFAULT '0',
  `server_id` int DEFAULT NULL,
  `mid` int DEFAULT NULL,
  `tree_id` int DEFAULT NULL,
  `title` varchar(512) DEFAULT NULL,
  `term` varchar(255) DEFAULT NULL,
  `status` smallint NOT NULL DEFAULT '1',
  `deleted` tinyint NOT NULL DEFAULT '0',
  `cms_id` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_cms_data`
--

LOCK TABLES `ecs_cms_data` WRITE;
/*!40000 ALTER TABLE `ecs_cms_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_cms_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_cms_data_seq`
--

DROP TABLE IF EXISTS `ecs_cms_data_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_cms_data_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_cms_data_seq`
--

LOCK TABLES `ecs_cms_data_seq` WRITE;
/*!40000 ALTER TABLE `ecs_cms_data_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_cms_data_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_cms_tree`
--

DROP TABLE IF EXISTS `ecs_cms_tree`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_cms_tree` (
  `tree` int NOT NULL DEFAULT '0',
  `child` int NOT NULL DEFAULT '0',
  `parent` int DEFAULT NULL,
  `lft` int DEFAULT NULL,
  `rgt` int DEFAULT NULL,
  `depth` int DEFAULT NULL,
  PRIMARY KEY (`tree`,`child`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_cms_tree`
--

LOCK TABLES `ecs_cms_tree` WRITE;
/*!40000 ALTER TABLE `ecs_cms_tree` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_cms_tree` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_community`
--

DROP TABLE IF EXISTS `ecs_community`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_community` (
  `sid` int NOT NULL DEFAULT '0',
  `cid` int NOT NULL DEFAULT '0',
  `own_id` int NOT NULL DEFAULT '0',
  `cname` varchar(255) DEFAULT NULL,
  `mids` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`sid`,`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_community`
--

LOCK TABLES `ecs_community` WRITE;
/*!40000 ALTER TABLE `ecs_community` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_community` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_container_mapping`
--

DROP TABLE IF EXISTS `ecs_container_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_container_mapping` (
  `mapping_id` int NOT NULL DEFAULT '0',
  `container_id` int NOT NULL DEFAULT '0',
  `field_name` varchar(255) DEFAULT NULL,
  `mapping_type` tinyint NOT NULL DEFAULT '0',
  `mapping_value` varchar(255) DEFAULT NULL,
  `date_range_start` int NOT NULL DEFAULT '0',
  `date_range_end` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`mapping_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_container_mapping`
--

LOCK TABLES `ecs_container_mapping` WRITE;
/*!40000 ALTER TABLE `ecs_container_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_container_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_container_mapping_seq`
--

DROP TABLE IF EXISTS `ecs_container_mapping_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_container_mapping_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_container_mapping_seq`
--

LOCK TABLES `ecs_container_mapping_seq` WRITE;
/*!40000 ALTER TABLE `ecs_container_mapping_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_container_mapping_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_course_assignments`
--

DROP TABLE IF EXISTS `ecs_course_assignments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_course_assignments` (
  `id` int NOT NULL DEFAULT '0',
  `sid` int NOT NULL DEFAULT '0',
  `mid` int NOT NULL DEFAULT '0',
  `cms_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` varchar(64) DEFAULT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `cms_sub_id` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_course_assignments`
--

LOCK TABLES `ecs_course_assignments` WRITE;
/*!40000 ALTER TABLE `ecs_course_assignments` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_course_assignments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_course_assignments_seq`
--

DROP TABLE IF EXISTS `ecs_course_assignments_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_course_assignments_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_course_assignments_seq`
--

LOCK TABLES `ecs_course_assignments_seq` WRITE;
/*!40000 ALTER TABLE `ecs_course_assignments_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_course_assignments_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_crs_mapping_atts`
--

DROP TABLE IF EXISTS `ecs_crs_mapping_atts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_crs_mapping_atts` (
  `id` int NOT NULL DEFAULT '0',
  `sid` int NOT NULL DEFAULT '0',
  `mid` int NOT NULL DEFAULT '0',
  `name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_crs_mapping_atts`
--

LOCK TABLES `ecs_crs_mapping_atts` WRITE;
/*!40000 ALTER TABLE `ecs_crs_mapping_atts` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_crs_mapping_atts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_crs_mapping_atts_seq`
--

DROP TABLE IF EXISTS `ecs_crs_mapping_atts_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_crs_mapping_atts_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_crs_mapping_atts_seq`
--

LOCK TABLES `ecs_crs_mapping_atts_seq` WRITE;
/*!40000 ALTER TABLE `ecs_crs_mapping_atts_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_crs_mapping_atts_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_data_mapping`
--

DROP TABLE IF EXISTS `ecs_data_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_data_mapping` (
  `sid` int NOT NULL DEFAULT '0',
  `mapping_type` tinyint NOT NULL DEFAULT '0',
  `ecs_field` varchar(32) NOT NULL DEFAULT '',
  `advmd_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`sid`,`mapping_type`,`ecs_field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_data_mapping`
--

LOCK TABLES `ecs_data_mapping` WRITE;
/*!40000 ALTER TABLE `ecs_data_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_data_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_events`
--

DROP TABLE IF EXISTS `ecs_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_events` (
  `event_id` int NOT NULL DEFAULT '0',
  `type` char(32) DEFAULT NULL,
  `id` int NOT NULL DEFAULT '0',
  `op` char(32) DEFAULT NULL,
  `server_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_events`
--

LOCK TABLES `ecs_events` WRITE;
/*!40000 ALTER TABLE `ecs_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_events_seq`
--

DROP TABLE IF EXISTS `ecs_events_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_events_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_events_seq`
--

LOCK TABLES `ecs_events_seq` WRITE;
/*!40000 ALTER TABLE `ecs_events_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_events_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_export`
--

DROP TABLE IF EXISTS `ecs_export`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_export` (
  `obj_id` int NOT NULL DEFAULT '0',
  `econtent_id` int NOT NULL DEFAULT '0',
  `server_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`server_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_export`
--

LOCK TABLES `ecs_export` WRITE;
/*!40000 ALTER TABLE `ecs_export` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_export` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_import`
--

DROP TABLE IF EXISTS `ecs_import`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_import` (
  `obj_id` int NOT NULL DEFAULT '0',
  `mid` int NOT NULL DEFAULT '0',
  `server_id` int NOT NULL DEFAULT '0',
  `sub_id` varchar(64) DEFAULT NULL,
  `ecs_id` int DEFAULT '0',
  `content_id` varchar(255) DEFAULT NULL,
  `econtent_id` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`server_id`,`obj_id`),
  KEY `i1_idx` (`obj_id`),
  KEY `i2_idx` (`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_import`
--

LOCK TABLES `ecs_import` WRITE;
/*!40000 ALTER TABLE `ecs_import` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_import` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_node_mapping_a`
--

DROP TABLE IF EXISTS `ecs_node_mapping_a`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_node_mapping_a` (
  `server_id` int NOT NULL DEFAULT '0',
  `mid` int NOT NULL DEFAULT '0',
  `cs_root` int NOT NULL DEFAULT '0',
  `cs_id` int NOT NULL DEFAULT '0',
  `ref_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `title_update` tinyint DEFAULT NULL,
  `position_update` tinyint DEFAULT NULL,
  `tree_update` tinyint DEFAULT NULL,
  PRIMARY KEY (`server_id`,`mid`,`cs_root`,`cs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_node_mapping_a`
--

LOCK TABLES `ecs_node_mapping_a` WRITE;
/*!40000 ALTER TABLE `ecs_node_mapping_a` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_node_mapping_a` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_part_settings`
--

DROP TABLE IF EXISTS `ecs_part_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_part_settings` (
  `sid` int NOT NULL DEFAULT '0',
  `mid` int NOT NULL DEFAULT '0',
  `export` tinyint NOT NULL DEFAULT '0',
  `import` tinyint NOT NULL DEFAULT '0',
  `import_type` tinyint DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `cname` varchar(255) DEFAULT NULL,
  `token` tinyint DEFAULT '1',
  `export_types` varchar(4000) DEFAULT NULL,
  `import_types` varchar(4000) DEFAULT NULL,
  `dtoken` tinyint NOT NULL DEFAULT '1',
  `username_placeholders` varchar(500) DEFAULT NULL,
  `incoming_auth_type` varchar(1) NOT NULL DEFAULT '0',
  `incoming_local_accounts` tinyint NOT NULL DEFAULT '1',
  `outgoing_auth_modes` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`sid`,`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_part_settings`
--

LOCK TABLES `ecs_part_settings` WRITE;
/*!40000 ALTER TABLE `ecs_part_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_part_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_remote_user`
--

DROP TABLE IF EXISTS `ecs_remote_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_remote_user` (
  `eru_id` int NOT NULL DEFAULT '0',
  `sid` int NOT NULL DEFAULT '0',
  `mid` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `remote_usr_id` char(50) DEFAULT NULL,
  PRIMARY KEY (`eru_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_remote_user`
--

LOCK TABLES `ecs_remote_user` WRITE;
/*!40000 ALTER TABLE `ecs_remote_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_remote_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_remote_user_seq`
--

DROP TABLE IF EXISTS `ecs_remote_user_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_remote_user_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_remote_user_seq`
--

LOCK TABLES `ecs_remote_user_seq` WRITE;
/*!40000 ALTER TABLE `ecs_remote_user_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_remote_user_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_server`
--

DROP TABLE IF EXISTS `ecs_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_server` (
  `server_id` int NOT NULL DEFAULT '0',
  `active` tinyint DEFAULT '0',
  `protocol` tinyint DEFAULT '1',
  `server` varchar(255) DEFAULT NULL,
  `port` smallint DEFAULT '1',
  `auth_type` tinyint DEFAULT '1',
  `client_cert_path` varchar(512) DEFAULT NULL,
  `ca_cert_path` varchar(512) DEFAULT NULL,
  `key_path` varchar(512) DEFAULT NULL,
  `key_password` varchar(32) DEFAULT NULL,
  `cert_serial` varchar(32) DEFAULT NULL,
  `import_id` int DEFAULT '0',
  `global_role` int DEFAULT '0',
  `econtent_rcp` varchar(512) DEFAULT NULL,
  `user_rcp` varchar(512) DEFAULT NULL,
  `approval_rcp` varchar(512) DEFAULT NULL,
  `duration` int DEFAULT '0',
  `title` varchar(128) DEFAULT NULL,
  `auth_user` varchar(32) DEFAULT NULL,
  `auth_pass` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_server`
--

LOCK TABLES `ecs_server` WRITE;
/*!40000 ALTER TABLE `ecs_server` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_server` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_server_seq`
--

DROP TABLE IF EXISTS `ecs_server_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_server_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_server_seq`
--

LOCK TABLES `ecs_server_seq` WRITE;
/*!40000 ALTER TABLE `ecs_server_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_server_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecs_user_consent`
--

DROP TABLE IF EXISTS `ecs_user_consent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ecs_user_consent` (
  `usr_id` int NOT NULL,
  `mid` int NOT NULL,
  `server_id` int NOT NULL,
  PRIMARY KEY (`usr_id`,`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecs_user_consent`
--

LOCK TABLES `ecs_user_consent` WRITE;
/*!40000 ALTER TABLE `ecs_user_consent` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecs_user_consent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `etal_data`
--

DROP TABLE IF EXISTS `etal_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `etal_data` (
  `object_id` bigint NOT NULL,
  `series_id` char(36) NOT NULL,
  `start_date` bigint NOT NULL,
  `end_date` bigint NOT NULL,
  `all_day` tinyint NOT NULL,
  `employee` bigint NOT NULL,
  `location` varchar(200) DEFAULT NULL,
  `completed` tinyint NOT NULL,
  `standalone_date` tinyint NOT NULL DEFAULT '0',
  `template_id` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `ser_idx` (`series_id`),
  KEY `emp_idx` (`employee`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `etal_data`
--

LOCK TABLES `etal_data` WRITE;
/*!40000 ALTER TABLE `etal_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `etal_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `etal_serie`
--

DROP TABLE IF EXISTS `etal_serie`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `etal_serie` (
  `id` bigint NOT NULL,
  `editing_locked` tinyint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `etal_serie`
--

LOCK TABLES `etal_serie` WRITE;
/*!40000 ALTER TABLE `etal_serie` DISABLE KEYS */;
/*!40000 ALTER TABLE `etal_serie` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `event_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `title` varchar(70) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `location` varchar(4000) DEFAULT NULL,
  `tutor_name` varchar(4000) DEFAULT NULL,
  `tutor_email` varchar(127) DEFAULT NULL,
  `tutor_phone` varchar(127) DEFAULT NULL,
  `details` varchar(4000) DEFAULT NULL,
  `registration` tinyint NOT NULL DEFAULT '0',
  `participation` tinyint NOT NULL DEFAULT '0',
  `reg_type` smallint DEFAULT '0',
  `reg_limit_users` int DEFAULT '0',
  `reg_waiting_list` tinyint DEFAULT '0',
  `reg_limited` tinyint DEFAULT '0',
  `reg_min_users` smallint DEFAULT NULL,
  `reg_auto_wait` tinyint NOT NULL DEFAULT '0',
  `show_members` tinyint NOT NULL DEFAULT '0',
  `mail_members` tinyint NOT NULL DEFAULT '0',
  `reg_notification` int NOT NULL DEFAULT '0',
  `notification_opt` varchar(50) DEFAULT 'notification_option_manual',
  `show_cannot_part` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`event_id`),
  KEY `i1_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_appointment`
--

DROP TABLE IF EXISTS `event_appointment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_appointment` (
  `appointment_id` int NOT NULL DEFAULT '0',
  `event_id` int NOT NULL DEFAULT '0',
  `e_start` datetime DEFAULT NULL,
  `e_end` datetime DEFAULT NULL,
  `starting_time` int NOT NULL DEFAULT '0',
  `ending_time` int NOT NULL DEFAULT '0',
  `fulltime` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`appointment_id`),
  KEY `i1_idx` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_appointment`
--

LOCK TABLES `event_appointment` WRITE;
/*!40000 ALTER TABLE `event_appointment` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_appointment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_appointment_seq`
--

DROP TABLE IF EXISTS `event_appointment_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_appointment_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_appointment_seq`
--

LOCK TABLES `event_appointment_seq` WRITE;
/*!40000 ALTER TABLE `event_appointment_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_appointment_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_items`
--

DROP TABLE IF EXISTS `event_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_items` (
  `event_id` int NOT NULL DEFAULT '0',
  `item_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`event_id`,`item_id`),
  KEY `i1_idx` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_items`
--

LOCK TABLES `event_items` WRITE;
/*!40000 ALTER TABLE `event_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_participants`
--

DROP TABLE IF EXISTS `event_participants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_participants` (
  `event_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `registered` tinyint NOT NULL DEFAULT '0',
  `participated` tinyint NOT NULL DEFAULT '0',
  `mark` longtext,
  `e_comment` longtext,
  `contact` tinyint NOT NULL DEFAULT '0',
  `notification_enabled` int NOT NULL DEFAULT '0',
  `excused` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`event_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_participants`
--

LOCK TABLES `event_participants` WRITE;
/*!40000 ALTER TABLE `event_participants` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_participants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_seq`
--

DROP TABLE IF EXISTS `event_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_seq`
--

LOCK TABLES `event_seq` WRITE;
/*!40000 ALTER TABLE `event_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_ass_file_order`
--

DROP TABLE IF EXISTS `exc_ass_file_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_ass_file_order` (
  `id` int NOT NULL DEFAULT '0',
  `assignment_id` int NOT NULL DEFAULT '0',
  `filename` varchar(150) NOT NULL,
  `order_nr` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`assignment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_ass_file_order`
--

LOCK TABLES `exc_ass_file_order` WRITE;
/*!40000 ALTER TABLE `exc_ass_file_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_ass_file_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_ass_file_order_seq`
--

DROP TABLE IF EXISTS `exc_ass_file_order_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_ass_file_order_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_ass_file_order_seq`
--

LOCK TABLES `exc_ass_file_order_seq` WRITE;
/*!40000 ALTER TABLE `exc_ass_file_order_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_ass_file_order_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_ass_reminders`
--

DROP TABLE IF EXISTS `exc_ass_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_ass_reminders` (
  `type` varchar(32) NOT NULL,
  `ass_id` int NOT NULL,
  `exc_id` int NOT NULL,
  `status` tinyint DEFAULT NULL,
  `start` int DEFAULT NULL,
  `end` int DEFAULT NULL,
  `freq` int DEFAULT NULL,
  `last_send` int DEFAULT NULL,
  `template_id` int DEFAULT NULL,
  `last_send_day` date DEFAULT NULL,
  PRIMARY KEY (`ass_id`,`exc_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_ass_reminders`
--

LOCK TABLES `exc_ass_reminders` WRITE;
/*!40000 ALTER TABLE `exc_ass_reminders` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_ass_reminders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_ass_wiki_team`
--

DROP TABLE IF EXISTS `exc_ass_wiki_team`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_ass_wiki_team` (
  `id` int NOT NULL DEFAULT '0',
  `container_ref_id` int NOT NULL DEFAULT '0',
  `template_ref_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_ass_wiki_team`
--

LOCK TABLES `exc_ass_wiki_team` WRITE;
/*!40000 ALTER TABLE `exc_ass_wiki_team` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_ass_wiki_team` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_assignment`
--

DROP TABLE IF EXISTS `exc_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_assignment` (
  `id` int NOT NULL DEFAULT '0',
  `exc_id` int NOT NULL DEFAULT '0',
  `time_stamp` int DEFAULT NULL,
  `instruction` longtext,
  `title` varchar(200) DEFAULT NULL,
  `start_time` int DEFAULT NULL,
  `mandatory` tinyint DEFAULT '1',
  `order_nr` int NOT NULL DEFAULT '0',
  `type` tinyint NOT NULL DEFAULT '1',
  `peer` tinyint NOT NULL DEFAULT '0',
  `peer_min` smallint NOT NULL DEFAULT '0',
  `fb_file` varchar(1000) DEFAULT NULL,
  `fb_cron` tinyint NOT NULL DEFAULT '0',
  `fb_cron_done` tinyint NOT NULL DEFAULT '0',
  `peer_dl` int DEFAULT '0',
  `peer_file` tinyint DEFAULT '0',
  `peer_prsl` tinyint DEFAULT '0',
  `fb_date` tinyint NOT NULL DEFAULT '1',
  `peer_char` smallint DEFAULT NULL,
  `peer_unlock` tinyint NOT NULL DEFAULT '0',
  `peer_valid` tinyint NOT NULL DEFAULT '1',
  `team_tutor` tinyint NOT NULL DEFAULT '0',
  `max_file` tinyint DEFAULT NULL,
  `deadline2` int DEFAULT NULL,
  `peer_text` tinyint NOT NULL DEFAULT '1',
  `peer_rating` tinyint NOT NULL DEFAULT '1',
  `peer_crit_cat` int DEFAULT NULL,
  `portfolio_template` int DEFAULT NULL,
  `min_char_limit` int DEFAULT NULL,
  `max_char_limit` int DEFAULT NULL,
  `fb_date_custom` int DEFAULT NULL,
  `rmd_submit_status` tinyint DEFAULT NULL,
  `rmd_submit_start` int DEFAULT NULL,
  `rmd_submit_end` int DEFAULT NULL,
  `rmd_submit_freq` int DEFAULT NULL,
  `rmd_grade_status` tinyint DEFAULT NULL,
  `rmd_grade_start` int DEFAULT NULL,
  `rmd_grade_end` int DEFAULT NULL,
  `rmd_grade_freq` int DEFAULT NULL,
  `peer_rmd_status` tinyint DEFAULT NULL,
  `peer_rmd_start` int DEFAULT NULL,
  `peer_rmd_end` int DEFAULT NULL,
  `peer_rmd_freq` int DEFAULT NULL,
  `deadline_mode` tinyint DEFAULT '0',
  `relative_deadline` int DEFAULT '0',
  `rel_deadline_last_subm` int NOT NULL DEFAULT '0',
  `if_rcid` varchar(64) DEFAULT NULL,
  `solution_rid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`exc_id`),
  KEY `i2_idx` (`deadline_mode`,`exc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_assignment`
--

LOCK TABLES `exc_assignment` WRITE;
/*!40000 ALTER TABLE `exc_assignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_assignment_peer`
--

DROP TABLE IF EXISTS `exc_assignment_peer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_assignment_peer` (
  `ass_id` int NOT NULL DEFAULT '0',
  `giver_id` int NOT NULL DEFAULT '0',
  `peer_id` int NOT NULL DEFAULT '0',
  `tstamp` datetime DEFAULT NULL,
  `pcomment` longtext,
  `is_valid` tinyint NOT NULL DEFAULT '0',
  `id` int NOT NULL DEFAULT '0',
  `migrated` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `c1_idx` (`ass_id`,`giver_id`,`peer_id`),
  KEY `i1_idx` (`ass_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_assignment_peer`
--

LOCK TABLES `exc_assignment_peer` WRITE;
/*!40000 ALTER TABLE `exc_assignment_peer` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_assignment_peer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_assignment_peer_seq`
--

DROP TABLE IF EXISTS `exc_assignment_peer_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_assignment_peer_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_assignment_peer_seq`
--

LOCK TABLES `exc_assignment_peer_seq` WRITE;
/*!40000 ALTER TABLE `exc_assignment_peer_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_assignment_peer_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_assignment_seq`
--

DROP TABLE IF EXISTS `exc_assignment_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_assignment_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_assignment_seq`
--

LOCK TABLES `exc_assignment_seq` WRITE;
/*!40000 ALTER TABLE `exc_assignment_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_assignment_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_crit`
--

DROP TABLE IF EXISTS `exc_crit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_crit` (
  `id` int NOT NULL DEFAULT '0',
  `parent` int NOT NULL DEFAULT '0',
  `type` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `descr` varchar(1000) DEFAULT NULL,
  `pos` int NOT NULL DEFAULT '0',
  `required` tinyint NOT NULL DEFAULT '0',
  `def` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_crit`
--

LOCK TABLES `exc_crit` WRITE;
/*!40000 ALTER TABLE `exc_crit` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_crit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_crit_cat`
--

DROP TABLE IF EXISTS `exc_crit_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_crit_cat` (
  `id` int NOT NULL DEFAULT '0',
  `parent` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `pos` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_crit_cat`
--

LOCK TABLES `exc_crit_cat` WRITE;
/*!40000 ALTER TABLE `exc_crit_cat` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_crit_cat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_crit_cat_seq`
--

DROP TABLE IF EXISTS `exc_crit_cat_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_crit_cat_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_crit_cat_seq`
--

LOCK TABLES `exc_crit_cat_seq` WRITE;
/*!40000 ALTER TABLE `exc_crit_cat_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_crit_cat_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_crit_file`
--

DROP TABLE IF EXISTS `exc_crit_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_crit_file` (
  `ass_id` int NOT NULL DEFAULT '0',
  `giver_id` int NOT NULL DEFAULT '0',
  `peer_id` int NOT NULL DEFAULT '0',
  `criteria_id` int NOT NULL DEFAULT '0',
  `rid` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`ass_id`,`giver_id`,`peer_id`,`criteria_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_crit_file`
--

LOCK TABLES `exc_crit_file` WRITE;
/*!40000 ALTER TABLE `exc_crit_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_crit_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_crit_seq`
--

DROP TABLE IF EXISTS `exc_crit_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_crit_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_crit_seq`
--

LOCK TABLES `exc_crit_seq` WRITE;
/*!40000 ALTER TABLE `exc_crit_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_crit_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_data`
--

DROP TABLE IF EXISTS `exc_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_data` (
  `obj_id` int NOT NULL DEFAULT '0',
  `instruction` longtext,
  `time_stamp` int DEFAULT NULL,
  `pass_mode` varchar(8) NOT NULL DEFAULT 'all',
  `pass_nr` int DEFAULT NULL,
  `show_submissions` tinyint NOT NULL DEFAULT '0',
  `compl_by_submission` tinyint NOT NULL DEFAULT '0',
  `certificate_visibility` tinyint NOT NULL DEFAULT '0',
  `tfeedback` tinyint NOT NULL DEFAULT '7',
  `nr_mandatory_random` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_data`
--

LOCK TABLES `exc_data` WRITE;
/*!40000 ALTER TABLE `exc_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_idl`
--

DROP TABLE IF EXISTS `exc_idl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_idl` (
  `ass_id` int NOT NULL DEFAULT '0',
  `member_id` int NOT NULL DEFAULT '0',
  `is_team` tinyint NOT NULL DEFAULT '0',
  `tstamp` int DEFAULT '0',
  `starting_ts` int DEFAULT '0',
  `requested` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ass_id`,`member_id`,`is_team`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_idl`
--

LOCK TABLES `exc_idl` WRITE;
/*!40000 ALTER TABLE `exc_idl` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_idl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_mandatory_random`
--

DROP TABLE IF EXISTS `exc_mandatory_random`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_mandatory_random` (
  `exc_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `ass_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`exc_id`,`usr_id`,`ass_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_mandatory_random`
--

LOCK TABLES `exc_mandatory_random` WRITE;
/*!40000 ALTER TABLE `exc_mandatory_random` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_mandatory_random` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_mem_ass_status`
--

DROP TABLE IF EXISTS `exc_mem_ass_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_mem_ass_status` (
  `ass_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `notice` varchar(4000) DEFAULT NULL,
  `returned` tinyint NOT NULL DEFAULT '0',
  `solved` tinyint DEFAULT NULL,
  `status_time` datetime DEFAULT NULL,
  `sent` tinyint DEFAULT NULL,
  `sent_time` datetime DEFAULT NULL,
  `feedback_time` datetime DEFAULT NULL,
  `feedback` tinyint NOT NULL DEFAULT '0',
  `status` char(9) DEFAULT 'notgraded',
  `mark` varchar(32) DEFAULT NULL,
  `u_comment` varchar(4000) DEFAULT NULL,
  `feedback_rcid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`ass_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_mem_ass_status`
--

LOCK TABLES `exc_mem_ass_status` WRITE;
/*!40000 ALTER TABLE `exc_mem_ass_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_mem_ass_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_members`
--

DROP TABLE IF EXISTS `exc_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_members` (
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `notice` varchar(4000) DEFAULT NULL,
  `returned` tinyint NOT NULL DEFAULT '0',
  `solved` tinyint DEFAULT NULL,
  `status_time` datetime DEFAULT NULL,
  `sent` tinyint DEFAULT NULL,
  `sent_time` datetime DEFAULT NULL,
  `feedback_time` datetime DEFAULT NULL,
  `feedback` tinyint NOT NULL DEFAULT '0',
  `status` char(9) DEFAULT 'notgraded',
  PRIMARY KEY (`obj_id`,`usr_id`),
  KEY `ob_idx` (`obj_id`),
  KEY `i1_idx` (`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_members`
--

LOCK TABLES `exc_members` WRITE;
/*!40000 ALTER TABLE `exc_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_multi_feedback`
--

DROP TABLE IF EXISTS `exc_multi_feedback`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_multi_feedback` (
  `tutor_id` int NOT NULL,
  `ass_id` int NOT NULL,
  `zip_rid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`tutor_id`,`ass_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_multi_feedback`
--

LOCK TABLES `exc_multi_feedback` WRITE;
/*!40000 ALTER TABLE `exc_multi_feedback` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_multi_feedback` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_returned`
--

DROP TABLE IF EXISTS `exc_returned`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_returned` (
  `returned_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `filename` varchar(1000) DEFAULT NULL,
  `filetitle` varchar(1000) DEFAULT NULL,
  `mimetype` varchar(150) DEFAULT NULL,
  `ts` datetime DEFAULT NULL,
  `ass_id` int DEFAULT NULL,
  `atext` longtext,
  `late` tinyint NOT NULL DEFAULT '0',
  `team_id` int NOT NULL DEFAULT '0',
  `web_dir_access_time` datetime DEFAULT NULL,
  `rid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`returned_id`),
  KEY `i1_idx` (`obj_id`),
  KEY `i2_idx` (`user_id`),
  KEY `i3_idx` (`filetitle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_returned`
--

LOCK TABLES `exc_returned` WRITE;
/*!40000 ALTER TABLE `exc_returned` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_returned` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_returned_seq`
--

DROP TABLE IF EXISTS `exc_returned_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_returned_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_returned_seq`
--

LOCK TABLES `exc_returned_seq` WRITE;
/*!40000 ALTER TABLE `exc_returned_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_returned_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_team_data`
--

DROP TABLE IF EXISTS `exc_team_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_team_data` (
  `id` int NOT NULL,
  `feedback_rcid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_team_data`
--

LOCK TABLES `exc_team_data` WRITE;
/*!40000 ALTER TABLE `exc_team_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_team_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exc_usr_tutor`
--

DROP TABLE IF EXISTS `exc_usr_tutor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exc_usr_tutor` (
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `tutor_id` int NOT NULL DEFAULT '0',
  `download_time` datetime DEFAULT NULL,
  `ass_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ass_id`,`usr_id`,`tutor_id`),
  KEY `ob_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exc_usr_tutor`
--

LOCK TABLES `exc_usr_tutor` WRITE;
/*!40000 ALTER TABLE `exc_usr_tutor` DISABLE KEYS */;
/*!40000 ALTER TABLE `exc_usr_tutor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `export_file_info`
--

DROP TABLE IF EXISTS `export_file_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `export_file_info` (
  `obj_id` int NOT NULL DEFAULT '0',
  `export_type` varchar(32) NOT NULL DEFAULT '',
  `file_name` varchar(64) NOT NULL DEFAULT '',
  `version` varchar(16) DEFAULT NULL,
  `create_date` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `filename` varchar(64) NOT NULL DEFAULT '',
  `migrated` int DEFAULT '0',
  PRIMARY KEY (`obj_id`,`export_type`,`filename`),
  KEY `i1_idx` (`create_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `export_file_info`
--

LOCK TABLES `export_file_info` WRITE;
/*!40000 ALTER TABLE `export_file_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `export_file_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `export_files`
--

DROP TABLE IF EXISTS `export_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `export_files` (
  `object_id` bigint NOT NULL DEFAULT '0',
  `rid` varchar(64) NOT NULL DEFAULT '',
  `owner_id` bigint NOT NULL DEFAULT '0',
  `timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`object_id`,`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `export_files`
--

LOCK TABLES `export_files` WRITE;
/*!40000 ALTER TABLE `export_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `export_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `export_files_html`
--

DROP TABLE IF EXISTS `export_files_html`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `export_files_html` (
  `object_id` bigint NOT NULL DEFAULT '0',
  `rid` varchar(64) NOT NULL DEFAULT '',
  `timestamp` datetime DEFAULT NULL,
  `type` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`object_id`,`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `export_files_html`
--

LOCK TABLES `export_files_html` WRITE;
/*!40000 ALTER TABLE `export_files_html` DISABLE KEYS */;
/*!40000 ALTER TABLE `export_files_html` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `export_options`
--

DROP TABLE IF EXISTS `export_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `export_options` (
  `export_id` smallint NOT NULL DEFAULT '0',
  `keyword` smallint NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `value` varchar(32) DEFAULT NULL,
  `pos` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`export_id`,`keyword`,`ref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `export_options`
--

LOCK TABLES `export_options` WRITE;
/*!40000 ALTER TABLE `export_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `export_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `export_public_access`
--

DROP TABLE IF EXISTS `export_public_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `export_public_access` (
  `object_id` bigint NOT NULL DEFAULT '0',
  `export_option_id` varchar(64) NOT NULL DEFAULT '',
  `identification` varchar(64) NOT NULL DEFAULT '',
  `timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `export_public_access`
--

LOCK TABLES `export_public_access` WRITE;
/*!40000 ALTER TABLE `export_public_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `export_public_access` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `feedback_items_seq`
--

DROP TABLE IF EXISTS `feedback_items_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `feedback_items_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `feedback_items_seq`
--

LOCK TABLES `feedback_items_seq` WRITE;
/*!40000 ALTER TABLE `feedback_items_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `feedback_items_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_based_lm`
--

DROP TABLE IF EXISTS `file_based_lm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_based_lm` (
  `id` int NOT NULL DEFAULT '0',
  `is_online` char(1) DEFAULT 'n',
  `startfile` varchar(200) DEFAULT NULL,
  `show_lic` tinyint DEFAULT NULL,
  `show_bib` tinyint DEFAULT NULL,
  `rid` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_based_lm`
--

LOCK TABLES `file_based_lm` WRITE;
/*!40000 ALTER TABLE `file_based_lm` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_based_lm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_data`
--

DROP TABLE IF EXISTS `file_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_data` (
  `file_id` int NOT NULL DEFAULT '0',
  `file_name` char(250) DEFAULT NULL,
  `file_type` char(250) DEFAULT NULL,
  `file_size` int NOT NULL DEFAULT '0',
  `version` int DEFAULT NULL,
  `f_mode` char(8) DEFAULT 'object',
  `rating` tinyint NOT NULL DEFAULT '0',
  `page_count` bigint DEFAULT NULL,
  `max_version` int DEFAULT NULL,
  `rid` varchar(64) NOT NULL DEFAULT '',
  `on_click_mode` tinyint NOT NULL DEFAULT '1',
  `downloads` bigint DEFAULT '0',
  `important_info` longblob,
  PRIMARY KEY (`file_id`),
  KEY `i1_idx` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_data`
--

LOCK TABLES `file_data` WRITE;
/*!40000 ALTER TABLE `file_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_usage`
--

DROP TABLE IF EXISTS `file_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_usage` (
  `id` int NOT NULL DEFAULT '0',
  `usage_type` varchar(10) NOT NULL DEFAULT ' ',
  `usage_id` int NOT NULL DEFAULT '0',
  `usage_hist_nr` int NOT NULL DEFAULT '0',
  `usage_lang` varchar(2) NOT NULL DEFAULT '-',
  PRIMARY KEY (`id`,`usage_type`,`usage_id`,`usage_hist_nr`,`usage_lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_usage`
--

LOCK TABLES `file_usage` WRITE;
/*!40000 ALTER TABLE `file_usage` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_usage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_data`
--

DROP TABLE IF EXISTS `frm_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_data` (
  `top_pk` bigint NOT NULL DEFAULT '0',
  `top_frm_fk` bigint NOT NULL DEFAULT '0',
  `top_name` varchar(255) DEFAULT NULL,
  `top_description` varchar(255) DEFAULT NULL,
  `top_num_posts` int NOT NULL DEFAULT '0',
  `top_num_threads` int NOT NULL DEFAULT '0',
  `top_last_post` varchar(50) DEFAULT NULL,
  `top_mods` int NOT NULL DEFAULT '0',
  `top_date` datetime DEFAULT NULL,
  `visits` int NOT NULL DEFAULT '0',
  `top_update` datetime DEFAULT NULL,
  `update_user` int NOT NULL DEFAULT '0',
  `top_usr_id` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`top_pk`),
  KEY `i1_idx` (`top_frm_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_data`
--

LOCK TABLES `frm_data` WRITE;
/*!40000 ALTER TABLE `frm_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_data_seq`
--

DROP TABLE IF EXISTS `frm_data_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_data_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_data_seq`
--

LOCK TABLES `frm_data_seq` WRITE;
/*!40000 ALTER TABLE `frm_data_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_data_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_drafts_history`
--

DROP TABLE IF EXISTS `frm_drafts_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_drafts_history` (
  `history_id` int NOT NULL DEFAULT '0',
  `draft_id` int NOT NULL DEFAULT '0',
  `post_subject` varchar(4000) NOT NULL DEFAULT '',
  `post_message` longtext NOT NULL,
  `draft_date` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`history_id`),
  KEY `i1_idx` (`draft_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_drafts_history`
--

LOCK TABLES `frm_drafts_history` WRITE;
/*!40000 ALTER TABLE `frm_drafts_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_drafts_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_drafts_history_seq`
--

DROP TABLE IF EXISTS `frm_drafts_history_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_drafts_history_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_drafts_history_seq`
--

LOCK TABLES `frm_drafts_history_seq` WRITE;
/*!40000 ALTER TABLE `frm_drafts_history_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_drafts_history_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_notification`
--

DROP TABLE IF EXISTS `frm_notification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_notification` (
  `notification_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `frm_id` bigint NOT NULL DEFAULT '0',
  `thread_id` bigint NOT NULL DEFAULT '0',
  `admin_force_noti` tinyint NOT NULL DEFAULT '0',
  `user_toggle_noti` tinyint NOT NULL DEFAULT '0',
  `user_id_noti` int DEFAULT NULL,
  `interested_events` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`notification_id`),
  KEY `i1_idx` (`user_id`,`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_notification`
--

LOCK TABLES `frm_notification` WRITE;
/*!40000 ALTER TABLE `frm_notification` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_notification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_notification_seq`
--

DROP TABLE IF EXISTS `frm_notification_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_notification_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_notification_seq`
--

LOCK TABLES `frm_notification_seq` WRITE;
/*!40000 ALTER TABLE `frm_notification_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_notification_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_posts`
--

DROP TABLE IF EXISTS `frm_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_posts` (
  `pos_pk` bigint NOT NULL DEFAULT '0',
  `pos_top_fk` bigint NOT NULL DEFAULT '0',
  `pos_thr_fk` bigint NOT NULL DEFAULT '0',
  `pos_usr_alias` varchar(255) DEFAULT NULL,
  `pos_subject` varchar(4000) DEFAULT NULL,
  `pos_date` datetime DEFAULT NULL,
  `pos_update` datetime DEFAULT NULL,
  `update_user` int NOT NULL DEFAULT '0',
  `pos_cens` tinyint NOT NULL DEFAULT '0',
  `pos_cens_com` varchar(4000) DEFAULT NULL,
  `notify` tinyint NOT NULL DEFAULT '0',
  `import_name` varchar(4000) DEFAULT NULL,
  `pos_status` tinyint NOT NULL DEFAULT '1',
  `pos_message` longtext,
  `pos_author_id` int NOT NULL DEFAULT '0',
  `pos_display_user_id` int NOT NULL DEFAULT '0',
  `is_author_moderator` tinyint DEFAULT NULL,
  `pos_cens_date` datetime DEFAULT NULL,
  `pos_activation_date` datetime DEFAULT NULL,
  `rcid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`pos_pk`),
  KEY `i1_idx` (`pos_thr_fk`),
  KEY `i2_idx` (`pos_top_fk`),
  KEY `i3_idx` (`pos_date`),
  KEY `i5_idx` (`pos_thr_fk`,`pos_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_posts`
--

LOCK TABLES `frm_posts` WRITE;
/*!40000 ALTER TABLE `frm_posts` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_posts_deleted`
--

DROP TABLE IF EXISTS `frm_posts_deleted`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_posts_deleted` (
  `deleted_id` int NOT NULL DEFAULT '0',
  `deleted_date` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `deleted_by` varchar(255) NOT NULL DEFAULT '',
  `forum_title` varchar(255) NOT NULL DEFAULT '',
  `thread_title` varchar(255) NOT NULL DEFAULT '',
  `post_title` varchar(255) NOT NULL DEFAULT '',
  `post_message` longtext NOT NULL,
  `post_date` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `obj_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `thread_id` int NOT NULL DEFAULT '0',
  `forum_id` int NOT NULL DEFAULT '0',
  `pos_display_user_id` int NOT NULL DEFAULT '0',
  `pos_usr_alias` varchar(255) DEFAULT NULL,
  `is_thread_deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`deleted_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_posts_deleted`
--

LOCK TABLES `frm_posts_deleted` WRITE;
/*!40000 ALTER TABLE `frm_posts_deleted` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_posts_deleted` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_posts_deleted_seq`
--

DROP TABLE IF EXISTS `frm_posts_deleted_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_posts_deleted_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_posts_deleted_seq`
--

LOCK TABLES `frm_posts_deleted_seq` WRITE;
/*!40000 ALTER TABLE `frm_posts_deleted_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_posts_deleted_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_posts_drafts`
--

DROP TABLE IF EXISTS `frm_posts_drafts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_posts_drafts` (
  `draft_id` int NOT NULL DEFAULT '0',
  `post_id` bigint NOT NULL DEFAULT '0',
  `thread_id` bigint NOT NULL DEFAULT '0',
  `forum_id` bigint NOT NULL DEFAULT '0',
  `post_author_id` int NOT NULL DEFAULT '0',
  `post_subject` varchar(4000) NOT NULL DEFAULT '',
  `post_message` longtext NOT NULL,
  `post_notify` tinyint NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `post_update` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_user_id` int NOT NULL DEFAULT '0',
  `post_user_alias` varchar(255) DEFAULT NULL,
  `pos_display_usr_id` int NOT NULL DEFAULT '0',
  `notify` tinyint NOT NULL DEFAULT '0',
  `rcid` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`draft_id`),
  KEY `i1_idx` (`post_id`),
  KEY `i2_idx` (`thread_id`),
  KEY `i3_idx` (`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_posts_drafts`
--

LOCK TABLES `frm_posts_drafts` WRITE;
/*!40000 ALTER TABLE `frm_posts_drafts` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_posts_drafts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_posts_drafts_seq`
--

DROP TABLE IF EXISTS `frm_posts_drafts_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_posts_drafts_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_posts_drafts_seq`
--

LOCK TABLES `frm_posts_drafts_seq` WRITE;
/*!40000 ALTER TABLE `frm_posts_drafts_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_posts_drafts_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_posts_seq`
--

DROP TABLE IF EXISTS `frm_posts_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_posts_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_posts_seq`
--

LOCK TABLES `frm_posts_seq` WRITE;
/*!40000 ALTER TABLE `frm_posts_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_posts_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_posts_tree`
--

DROP TABLE IF EXISTS `frm_posts_tree`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_posts_tree` (
  `fpt_pk` bigint NOT NULL DEFAULT '0',
  `thr_fk` bigint NOT NULL DEFAULT '0',
  `pos_fk` bigint NOT NULL DEFAULT '0',
  `parent_pos` bigint NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `depth` int NOT NULL DEFAULT '0',
  `fpt_date` datetime DEFAULT NULL,
  PRIMARY KEY (`fpt_pk`),
  KEY `i1_idx` (`thr_fk`),
  KEY `i2_idx` (`pos_fk`),
  KEY `i3_idx` (`parent_pos`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_posts_tree`
--

LOCK TABLES `frm_posts_tree` WRITE;
/*!40000 ALTER TABLE `frm_posts_tree` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_posts_tree` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_posts_tree_seq`
--

DROP TABLE IF EXISTS `frm_posts_tree_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_posts_tree_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_posts_tree_seq`
--

LOCK TABLES `frm_posts_tree_seq` WRITE;
/*!40000 ALTER TABLE `frm_posts_tree_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_posts_tree_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_settings`
--

DROP TABLE IF EXISTS `frm_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_settings` (
  `obj_id` int NOT NULL DEFAULT '0',
  `default_view` int NOT NULL DEFAULT '0',
  `anonymized` tinyint NOT NULL DEFAULT '0',
  `statistics_enabled` tinyint NOT NULL DEFAULT '0',
  `post_activation` tinyint NOT NULL DEFAULT '0',
  `admin_force_noti` tinyint NOT NULL DEFAULT '0',
  `user_toggle_noti` tinyint NOT NULL DEFAULT '0',
  `preset_subject` tinyint NOT NULL DEFAULT '1',
  `notification_type` varchar(10) DEFAULT NULL,
  `add_re_subject` tinyint NOT NULL DEFAULT '0',
  `mark_mod_posts` tinyint NOT NULL DEFAULT '0',
  `thread_rating` tinyint NOT NULL DEFAULT '0',
  `file_upload_allowed` tinyint NOT NULL DEFAULT '0',
  `interested_events` tinyint NOT NULL DEFAULT '0',
  `lp_req_num_postings` int DEFAULT NULL,
  `stylesheet` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_settings`
--

LOCK TABLES `frm_settings` WRITE;
/*!40000 ALTER TABLE `frm_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_threads`
--

DROP TABLE IF EXISTS `frm_threads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_threads` (
  `thr_pk` bigint NOT NULL DEFAULT '0',
  `thr_top_fk` bigint NOT NULL DEFAULT '0',
  `thr_subject` varchar(255) DEFAULT NULL,
  `thr_usr_alias` varchar(255) DEFAULT NULL,
  `thr_num_posts` int NOT NULL DEFAULT '0',
  `thr_last_post` varchar(50) DEFAULT NULL,
  `thr_date` datetime DEFAULT NULL,
  `thr_update` datetime DEFAULT NULL,
  `visits` int NOT NULL DEFAULT '0',
  `import_name` varchar(4000) DEFAULT NULL,
  `is_sticky` tinyint NOT NULL DEFAULT '0',
  `is_closed` tinyint NOT NULL DEFAULT '0',
  `avg_rating` double NOT NULL DEFAULT '0',
  `thr_author_id` int NOT NULL DEFAULT '0',
  `thr_display_user_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`thr_pk`),
  KEY `i2_idx` (`thr_top_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_threads`
--

LOCK TABLES `frm_threads` WRITE;
/*!40000 ALTER TABLE `frm_threads` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_threads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_threads_seq`
--

DROP TABLE IF EXISTS `frm_threads_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_threads_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_threads_seq`
--

LOCK TABLES `frm_threads_seq` WRITE;
/*!40000 ALTER TABLE `frm_threads_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_threads_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frm_user_read`
--

DROP TABLE IF EXISTS `frm_user_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `frm_user_read` (
  `usr_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `thread_id` int NOT NULL DEFAULT '0',
  `post_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`usr_id`,`obj_id`,`thread_id`,`post_id`),
  KEY `i1_idx` (`usr_id`,`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frm_user_read`
--

LOCK TABLES `frm_user_read` WRITE;
/*!40000 ALTER TABLE `frm_user_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `frm_user_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glo_advmd_col_order`
--

DROP TABLE IF EXISTS `glo_advmd_col_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glo_advmd_col_order` (
  `glo_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  `order_nr` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`glo_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glo_advmd_col_order`
--

LOCK TABLES `glo_advmd_col_order` WRITE;
/*!40000 ALTER TABLE `glo_advmd_col_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `glo_advmd_col_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glo_flashcard_box`
--

DROP TABLE IF EXISTS `glo_flashcard_box`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glo_flashcard_box` (
  `box_nr` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `glo_id` int NOT NULL DEFAULT '0',
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`box_nr`,`user_id`,`glo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glo_flashcard_box`
--

LOCK TABLES `glo_flashcard_box` WRITE;
/*!40000 ALTER TABLE `glo_flashcard_box` DISABLE KEYS */;
/*!40000 ALTER TABLE `glo_flashcard_box` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glo_flashcard_term`
--

DROP TABLE IF EXISTS `glo_flashcard_term`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glo_flashcard_term` (
  `term_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `glo_id` int NOT NULL DEFAULT '0',
  `last_access` datetime DEFAULT NULL,
  `box_nr` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`,`user_id`,`glo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glo_flashcard_term`
--

LOCK TABLES `glo_flashcard_term` WRITE;
/*!40000 ALTER TABLE `glo_flashcard_term` DISABLE KEYS */;
/*!40000 ALTER TABLE `glo_flashcard_term` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glo_glossaries`
--

DROP TABLE IF EXISTS `glo_glossaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glo_glossaries` (
  `id` int NOT NULL DEFAULT '0',
  `glo_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`glo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glo_glossaries`
--

LOCK TABLES `glo_glossaries` WRITE;
/*!40000 ALTER TABLE `glo_glossaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `glo_glossaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glo_term_reference`
--

DROP TABLE IF EXISTS `glo_term_reference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glo_term_reference` (
  `glo_id` int NOT NULL DEFAULT '0',
  `term_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`glo_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glo_term_reference`
--

LOCK TABLES `glo_term_reference` WRITE;
/*!40000 ALTER TABLE `glo_term_reference` DISABLE KEYS */;
/*!40000 ALTER TABLE `glo_term_reference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glossary`
--

DROP TABLE IF EXISTS `glossary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glossary` (
  `id` int NOT NULL DEFAULT '0',
  `is_online` char(1) DEFAULT 'n',
  `virtual` char(7) DEFAULT 'none',
  `public_html_file` varchar(50) DEFAULT NULL,
  `public_xml_file` varchar(50) DEFAULT NULL,
  `glo_menu_active` char(1) DEFAULT 'y',
  `downloads_active` char(1) DEFAULT 'n',
  `pres_mode` varchar(10) NOT NULL DEFAULT 'table',
  `snippet_length` int NOT NULL DEFAULT '200',
  `show_tax` tinyint NOT NULL DEFAULT '0',
  `flash_active` varchar(1) NOT NULL DEFAULT 'n',
  `flash_mode` varchar(10) NOT NULL DEFAULT 'term',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glossary`
--

LOCK TABLES `glossary` WRITE;
/*!40000 ALTER TABLE `glossary` DISABLE KEYS */;
/*!40000 ALTER TABLE `glossary` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glossary_collection`
--

DROP TABLE IF EXISTS `glossary_collection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glossary_collection` (
  `id` int NOT NULL DEFAULT '0',
  `glo_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`glo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glossary_collection`
--

LOCK TABLES `glossary_collection` WRITE;
/*!40000 ALTER TABLE `glossary_collection` DISABLE KEYS */;
/*!40000 ALTER TABLE `glossary_collection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glossary_definition`
--

DROP TABLE IF EXISTS `glossary_definition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glossary_definition` (
  `id` int NOT NULL DEFAULT '0',
  `term_id` int NOT NULL DEFAULT '0',
  `short_text` varchar(4000) DEFAULT NULL,
  `nr` int NOT NULL DEFAULT '0',
  `short_text_dirty` int NOT NULL DEFAULT '0',
  `migration` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glossary_definition`
--

LOCK TABLES `glossary_definition` WRITE;
/*!40000 ALTER TABLE `glossary_definition` DISABLE KEYS */;
/*!40000 ALTER TABLE `glossary_definition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glossary_definition_seq`
--

DROP TABLE IF EXISTS `glossary_definition_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glossary_definition_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glossary_definition_seq`
--

LOCK TABLES `glossary_definition_seq` WRITE;
/*!40000 ALTER TABLE `glossary_definition_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `glossary_definition_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glossary_term`
--

DROP TABLE IF EXISTS `glossary_term`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glossary_term` (
  `id` int NOT NULL DEFAULT '0',
  `glo_id` int NOT NULL DEFAULT '0',
  `term` varchar(200) DEFAULT NULL,
  `language` char(2) DEFAULT NULL,
  `import_id` varchar(50) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `short_text` varchar(4000) DEFAULT NULL,
  `short_text_dirty` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`glo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glossary_term`
--

LOCK TABLES `glossary_term` WRITE;
/*!40000 ALTER TABLE `glossary_term` DISABLE KEYS */;
/*!40000 ALTER TABLE `glossary_term` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glossary_term_seq`
--

DROP TABLE IF EXISTS `glossary_term_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `glossary_term_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glossary_term_seq`
--

LOCK TABLES `glossary_term_seq` WRITE;
/*!40000 ALTER TABLE `glossary_term_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `glossary_term_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grp_settings`
--

DROP TABLE IF EXISTS `grp_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `grp_settings` (
  `obj_id` int NOT NULL DEFAULT '0',
  `information` varchar(4000) DEFAULT NULL,
  `grp_type` tinyint NOT NULL DEFAULT '0',
  `registration_type` tinyint NOT NULL DEFAULT '0',
  `registration_enabled` tinyint NOT NULL DEFAULT '0',
  `registration_unlimited` tinyint NOT NULL DEFAULT '0',
  `registration_start` datetime DEFAULT NULL,
  `registration_end` datetime DEFAULT NULL,
  `registration_password` char(32) DEFAULT NULL,
  `registration_mem_limit` tinyint NOT NULL DEFAULT '0',
  `registration_max_members` int NOT NULL DEFAULT '0',
  `waiting_list` tinyint NOT NULL DEFAULT '0',
  `latitude` varchar(30) DEFAULT NULL,
  `longitude` varchar(30) DEFAULT NULL,
  `location_zoom` int NOT NULL DEFAULT '0',
  `enablemap` tinyint NOT NULL DEFAULT '0',
  `reg_ac_enabled` tinyint NOT NULL DEFAULT '0',
  `reg_ac` varchar(32) DEFAULT NULL,
  `view_mode` tinyint NOT NULL DEFAULT '6',
  `mail_members_type` tinyint DEFAULT '1',
  `registration_min_members` smallint DEFAULT NULL,
  `leave_end` int DEFAULT NULL,
  `auto_wait` tinyint NOT NULL DEFAULT '0',
  `show_members` tinyint NOT NULL DEFAULT '1',
  `grp_start` int DEFAULT NULL,
  `grp_end` int DEFAULT NULL,
  `period_start` datetime DEFAULT NULL,
  `period_end` datetime DEFAULT NULL,
  `period_time_indication` int NOT NULL DEFAULT '0',
  `auto_notification` int NOT NULL DEFAULT '1',
  `session_limit` tinyint NOT NULL DEFAULT '0',
  `session_prev` bigint NOT NULL DEFAULT '-1',
  `session_next` bigint NOT NULL DEFAULT '-1',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grp_settings`
--

LOCK TABLES `grp_settings` WRITE;
/*!40000 ALTER TABLE `grp_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `grp_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gs_footer_items`
--

DROP TABLE IF EXISTS `gs_footer_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gs_footer_items` (
  `id` varchar(255) NOT NULL,
  `type` tinyint NOT NULL,
  `title` varchar(4000) NOT NULL,
  `position` int NOT NULL,
  `is_active` tinyint NOT NULL,
  `parent` varchar(255) DEFAULT NULL,
  `action` varchar(4000) DEFAULT NULL,
  `external` tinyint DEFAULT NULL,
  `core` tinyint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gs_footer_items`
--

LOCK TABLES `gs_footer_items` WRITE;
/*!40000 ALTER TABLE `gs_footer_items` DISABLE KEYS */;
INSERT INTO `gs_footer_items` VALUES ('ilAccessibilitySupportFooterProvider|accessibility',1,'Accessibility',10,1,NULL,NULL,NULL,1),('ilAccessibilitySupportFooterProvider|accessibility_control',2,'Accessibility',0,1,'ilAccessibilitySupportFooterProvider|accessibility','ilias.php?baseClass=ilaccessibilitycontrolconceptgui',0,1),('ilFooterStandardGroupsProvider|imprint',2,'Legal Notice',0,1,'ilFooterStandardGroupsProvider|legal_information','http://10.ilias.localhost/go/impr/0',0,1),('ilFooterStandardGroupsProvider|legal_information',1,'Legal Information',20,1,NULL,NULL,NULL,1),('ilFooterStandardGroupsProvider|services',1,'Services',40,1,NULL,NULL,NULL,1),('ilFooterStandardGroupsProvider|support',1,'Support',30,1,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `gs_footer_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gs_item_translation`
--

DROP TABLE IF EXISTS `gs_item_translation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gs_item_translation` (
  `id` varchar(255) NOT NULL,
  `language_code` varchar(4) NOT NULL,
  `translation` varchar(4000) NOT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`language_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gs_item_translation`
--

LOCK TABLES `gs_item_translation` WRITE;
/*!40000 ALTER TABLE `gs_item_translation` DISABLE KEYS */;
/*!40000 ALTER TABLE `gs_item_translation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_map`
--

DROP TABLE IF EXISTS `help_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_map` (
  `chap` int NOT NULL DEFAULT '0',
  `component` varchar(10) NOT NULL DEFAULT '',
  `screen_id` varchar(100) NOT NULL DEFAULT '',
  `screen_sub_id` varchar(100) NOT NULL DEFAULT '',
  `perm` varchar(20) NOT NULL DEFAULT '',
  `module_id` int NOT NULL DEFAULT '0',
  `full_id` varchar(1000) DEFAULT NULL,
  KEY `sc_idx` (`screen_id`),
  KEY `ch_idx` (`chap`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_map`
--

LOCK TABLES `help_map` WRITE;
/*!40000 ALTER TABLE `help_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `help_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_module`
--

DROP TABLE IF EXISTS `help_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_module` (
  `id` int NOT NULL DEFAULT '0',
  `lm_id` int NOT NULL DEFAULT '0',
  `order_nr` int NOT NULL DEFAULT '0',
  `active` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_module`
--

LOCK TABLES `help_module` WRITE;
/*!40000 ALTER TABLE `help_module` DISABLE KEYS */;
/*!40000 ALTER TABLE `help_module` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_module_seq`
--

DROP TABLE IF EXISTS `help_module_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_module_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_module_seq`
--

LOCK TABLES `help_module_seq` WRITE;
/*!40000 ALTER TABLE `help_module_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `help_module_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_tooltip`
--

DROP TABLE IF EXISTS `help_tooltip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_tooltip` (
  `id` int NOT NULL DEFAULT '0',
  `tt_text` varchar(4000) DEFAULT NULL,
  `tt_id` varchar(200) NOT NULL DEFAULT '',
  `comp` varchar(10) NOT NULL DEFAULT '',
  `lang` char(2) NOT NULL DEFAULT 'de',
  `module_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`tt_id`,`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_tooltip`
--

LOCK TABLES `help_tooltip` WRITE;
/*!40000 ALTER TABLE `help_tooltip` DISABLE KEYS */;
/*!40000 ALTER TABLE `help_tooltip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_tooltip_seq`
--

DROP TABLE IF EXISTS `help_tooltip_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_tooltip_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_tooltip_seq`
--

LOCK TABLES `help_tooltip_seq` WRITE;
/*!40000 ALTER TABLE `help_tooltip_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `help_tooltip_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `history`
--

DROP TABLE IF EXISTS `history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `history` (
  `id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `obj_type` varchar(8) DEFAULT NULL,
  `action` varchar(20) DEFAULT NULL,
  `hdate` datetime DEFAULT NULL,
  `usr_id` int NOT NULL DEFAULT '0',
  `info_params` varchar(4000) DEFAULT NULL,
  `user_comment` longtext,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`obj_id`,`obj_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `history`
--

LOCK TABLES `history` WRITE;
/*!40000 ALTER TABLE `history` DISABLE KEYS */;
/*!40000 ALTER TABLE `history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `history_seq`
--

DROP TABLE IF EXISTS `history_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `history_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `history_seq`
--

LOCK TABLES `history_seq` WRITE;
/*!40000 ALTER TABLE `history_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `history_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iass_info_settings`
--

DROP TABLE IF EXISTS `iass_info_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iass_info_settings` (
  `obj_id` int NOT NULL DEFAULT '0',
  `contact` varchar(100) DEFAULT NULL,
  `responsibility` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `mails` text,
  `consultation_hours` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iass_info_settings`
--

LOCK TABLES `iass_info_settings` WRITE;
/*!40000 ALTER TABLE `iass_info_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `iass_info_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iass_members`
--

DROP TABLE IF EXISTS `iass_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iass_members` (
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `examiner_id` int DEFAULT NULL,
  `record` text,
  `internal_note` text,
  `notify` tinyint NOT NULL DEFAULT '0',
  `notification_ts` int NOT NULL DEFAULT '-1',
  `learning_progress` tinyint DEFAULT '0',
  `finalized` tinyint NOT NULL DEFAULT '0',
  `place` varchar(255) DEFAULT NULL,
  `event_time` bigint DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `user_view_file` tinyint DEFAULT NULL,
  `changer_id` int DEFAULT NULL,
  `change_time` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`obj_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iass_members`
--

LOCK TABLES `iass_members` WRITE;
/*!40000 ALTER TABLE `iass_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `iass_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iass_settings`
--

DROP TABLE IF EXISTS `iass_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iass_settings` (
  `obj_id` int NOT NULL DEFAULT '0',
  `content` text,
  `record_template` text,
  `event_time_place_required` tinyint NOT NULL DEFAULT '0',
  `file_required` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iass_settings`
--

LOCK TABLES `iass_settings` WRITE;
/*!40000 ALTER TABLE `iass_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `iass_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_adn_dismiss`
--

DROP TABLE IF EXISTS `il_adn_dismiss`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_adn_dismiss` (
  `id` bigint NOT NULL,
  `usr_id` bigint DEFAULT NULL,
  `notification_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_adn_dismiss`
--

LOCK TABLES `il_adn_dismiss` WRITE;
/*!40000 ALTER TABLE `il_adn_dismiss` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_adn_dismiss` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_adn_dismiss_seq`
--

DROP TABLE IF EXISTS `il_adn_dismiss_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_adn_dismiss_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_adn_dismiss_seq`
--

LOCK TABLES `il_adn_dismiss_seq` WRITE;
/*!40000 ALTER TABLE `il_adn_dismiss_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_adn_dismiss_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_adn_notifications`
--

DROP TABLE IF EXISTS `il_adn_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_adn_notifications` (
  `id` bigint NOT NULL,
  `title` varchar(256) DEFAULT NULL,
  `body` longtext,
  `type` tinyint DEFAULT NULL,
  `type_during_event` tinyint DEFAULT NULL,
  `dismissable` tinyint DEFAULT NULL,
  `permanent` tinyint DEFAULT NULL,
  `allowed_users` varchar(256) DEFAULT NULL,
  `parent_id` bigint DEFAULT NULL,
  `created_by` bigint DEFAULT NULL,
  `last_update_by` bigint DEFAULT NULL,
  `active` tinyint DEFAULT NULL,
  `limited_to_role_ids` varchar(256) DEFAULT NULL,
  `limit_to_roles` tinyint DEFAULT NULL,
  `interruptive` tinyint DEFAULT NULL,
  `link` varchar(256) DEFAULT NULL,
  `link_type` tinyint DEFAULT NULL,
  `link_target` varchar(256) DEFAULT NULL,
  `event_start` bigint DEFAULT '0',
  `event_end` bigint DEFAULT '0',
  `display_start` bigint DEFAULT '0',
  `display_end` bigint DEFAULT '0',
  `create_date` bigint DEFAULT '0',
  `last_update` bigint DEFAULT '0',
  `has_language_limitation` tinyint NOT NULL DEFAULT '0',
  `limited_to_languages` varchar(256) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_adn_notifications`
--

LOCK TABLES `il_adn_notifications` WRITE;
/*!40000 ALTER TABLE `il_adn_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_adn_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_adn_notifications_seq`
--

DROP TABLE IF EXISTS `il_adn_notifications_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_adn_notifications_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_adn_notifications_seq`
--

LOCK TABLES `il_adn_notifications_seq` WRITE;
/*!40000 ALTER TABLE `il_adn_notifications_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_adn_notifications_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_attribute`
--

DROP TABLE IF EXISTS `il_bibl_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_attribute` (
  `entry_id` int DEFAULT NULL,
  `name` varchar(32) DEFAULT NULL,
  `value` varchar(4000) DEFAULT NULL,
  `id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_attribute`
--

LOCK TABLES `il_bibl_attribute` WRITE;
/*!40000 ALTER TABLE `il_bibl_attribute` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_attribute_seq`
--

DROP TABLE IF EXISTS `il_bibl_attribute_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_attribute_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_attribute_seq`
--

LOCK TABLES `il_bibl_attribute_seq` WRITE;
/*!40000 ALTER TABLE `il_bibl_attribute_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_attribute_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_data`
--

DROP TABLE IF EXISTS `il_bibl_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_data` (
  `id` int NOT NULL DEFAULT '0',
  `filename` varchar(256) DEFAULT NULL,
  `file_type` tinyint NOT NULL DEFAULT '1',
  `rid` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_data`
--

LOCK TABLES `il_bibl_data` WRITE;
/*!40000 ALTER TABLE `il_bibl_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_entry`
--

DROP TABLE IF EXISTS `il_bibl_entry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_entry` (
  `data_id` int DEFAULT NULL,
  `id` int NOT NULL DEFAULT '0',
  `type` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_entry`
--

LOCK TABLES `il_bibl_entry` WRITE;
/*!40000 ALTER TABLE `il_bibl_entry` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_entry_seq`
--

DROP TABLE IF EXISTS `il_bibl_entry_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_entry_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_entry_seq`
--

LOCK TABLES `il_bibl_entry_seq` WRITE;
/*!40000 ALTER TABLE `il_bibl_entry_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_entry_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_field`
--

DROP TABLE IF EXISTS `il_bibl_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_field` (
  `id` int NOT NULL,
  `identifier` varchar(50) NOT NULL,
  `data_type` tinyint NOT NULL,
  `position` int DEFAULT NULL,
  `is_standard_field` tinyint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_field`
--

LOCK TABLES `il_bibl_field` WRITE;
/*!40000 ALTER TABLE `il_bibl_field` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_field_seq`
--

DROP TABLE IF EXISTS `il_bibl_field_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_field_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_field_seq`
--

LOCK TABLES `il_bibl_field_seq` WRITE;
/*!40000 ALTER TABLE `il_bibl_field_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_field_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_filter`
--

DROP TABLE IF EXISTS `il_bibl_filter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_filter` (
  `id` int NOT NULL,
  `field_id` int NOT NULL,
  `object_id` int NOT NULL,
  `filter_type` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_filter`
--

LOCK TABLES `il_bibl_filter` WRITE;
/*!40000 ALTER TABLE `il_bibl_filter` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_filter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_filter_seq`
--

DROP TABLE IF EXISTS `il_bibl_filter_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_filter_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_filter_seq`
--

LOCK TABLES `il_bibl_filter_seq` WRITE;
/*!40000 ALTER TABLE `il_bibl_filter_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_filter_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_overview_model`
--

DROP TABLE IF EXISTS `il_bibl_overview_model`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_overview_model` (
  `ovm_id` int NOT NULL DEFAULT '0',
  `literature_type` varchar(32) DEFAULT NULL,
  `pattern` varchar(512) DEFAULT NULL,
  `file_type_id` int DEFAULT NULL,
  PRIMARY KEY (`ovm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_overview_model`
--

LOCK TABLES `il_bibl_overview_model` WRITE;
/*!40000 ALTER TABLE `il_bibl_overview_model` DISABLE KEYS */;
INSERT INTO `il_bibl_overview_model` VALUES (1,'default','[<strong>|bib_default_author|</strong> ][|bib_default_title|]: <Emph>[|bib_default_publisher| ][|bib_default_year| ][|bib_default_address|]</Emph>',2),(2,'default','[<strong>|ris_default_a1|</strong> ][<strong>|ris_default_au|</strong> ][|ris_default_t1|][ |ris_default_ti|]: <Emph>[|ris_default_pb| ][|ris_default_y1| ][|ris_default_py| ][|ris_default_cy|]</Emph>',1);
/*!40000 ALTER TABLE `il_bibl_overview_model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_settings`
--

DROP TABLE IF EXISTS `il_bibl_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_settings` (
  `id` int NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '-',
  `url` varchar(128) NOT NULL DEFAULT '-',
  `img` varchar(128) DEFAULT NULL,
  `show_in_list` tinyint DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_settings`
--

LOCK TABLES `il_bibl_settings` WRITE;
/*!40000 ALTER TABLE `il_bibl_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_settings_seq`
--

DROP TABLE IF EXISTS `il_bibl_settings_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_settings_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_settings_seq`
--

LOCK TABLES `il_bibl_settings_seq` WRITE;
/*!40000 ALTER TABLE `il_bibl_settings_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_settings_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_translation`
--

DROP TABLE IF EXISTS `il_bibl_translation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_translation` (
  `id` int NOT NULL,
  `field_id` bigint NOT NULL,
  `language_key` varchar(2) NOT NULL,
  `translation` varchar(256) DEFAULT NULL,
  `description` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_translation`
--

LOCK TABLES `il_bibl_translation` WRITE;
/*!40000 ALTER TABLE `il_bibl_translation` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_translation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bibl_translation_seq`
--

DROP TABLE IF EXISTS `il_bibl_translation_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bibl_translation_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bibl_translation_seq`
--

LOCK TABLES `il_bibl_translation_seq` WRITE;
/*!40000 ALTER TABLE `il_bibl_translation_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bibl_translation_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_block_setting`
--

DROP TABLE IF EXISTS `il_block_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_block_setting` (
  `type` varchar(20) NOT NULL DEFAULT ' ',
  `user_id` int NOT NULL DEFAULT '0',
  `block_id` int NOT NULL DEFAULT '0',
  `setting` varchar(40) NOT NULL DEFAULT ' ',
  `value` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`type`,`user_id`,`block_id`,`setting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_block_setting`
--

LOCK TABLES `il_block_setting` WRITE;
/*!40000 ALTER TABLE `il_block_setting` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_block_setting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_blog`
--

DROP TABLE IF EXISTS `il_blog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_blog` (
  `id` int NOT NULL DEFAULT '0',
  `bg_color` char(6) DEFAULT NULL,
  `font_color` char(6) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `ppic` tinyint DEFAULT NULL,
  `rss_active` tinyint DEFAULT '0',
  `approval` tinyint DEFAULT '0',
  `abs_shorten` tinyint DEFAULT '0',
  `abs_shorten_len` smallint DEFAULT '0',
  `abs_image` tinyint DEFAULT '0',
  `abs_img_width` smallint DEFAULT '0',
  `abs_img_height` smallint DEFAULT '0',
  `keywords` tinyint NOT NULL DEFAULT '1',
  `authors` tinyint NOT NULL DEFAULT '1',
  `nav_mode` tinyint NOT NULL DEFAULT '1',
  `nav_list_post` smallint NOT NULL DEFAULT '10',
  `nav_list_mon` smallint DEFAULT '0',
  `ov_post` smallint DEFAULT '0',
  `nav_order` varchar(255) DEFAULT NULL,
  `nav_list_mon_with_post` int DEFAULT '3',
  `act_est_reading_time` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_blog`
--

LOCK TABLES `il_blog` WRITE;
/*!40000 ALTER TABLE `il_blog` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_blog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_blog_posting`
--

DROP TABLE IF EXISTS `il_blog_posting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_blog_posting` (
  `id` int NOT NULL DEFAULT '0',
  `blog_id` int NOT NULL DEFAULT '0',
  `title` varchar(400) DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `author` int NOT NULL DEFAULT '0',
  `approved` tinyint DEFAULT '0',
  `last_withdrawn` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_blog_posting`
--

LOCK TABLES `il_blog_posting` WRITE;
/*!40000 ALTER TABLE `il_blog_posting` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_blog_posting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_blog_posting_seq`
--

DROP TABLE IF EXISTS `il_blog_posting_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_blog_posting_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_blog_posting_seq`
--

LOCK TABLES `il_blog_posting_seq` WRITE;
/*!40000 ALTER TABLE `il_blog_posting_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_blog_posting_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bt_bucket`
--

DROP TABLE IF EXISTS `il_bt_bucket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bt_bucket` (
  `id` bigint NOT NULL DEFAULT '0',
  `user_id` bigint DEFAULT NULL,
  `root_task_id` bigint DEFAULT NULL,
  `current_task_id` bigint DEFAULT NULL,
  `state` smallint DEFAULT NULL,
  `total_number_of_tasks` int DEFAULT NULL,
  `percentage` smallint DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `last_heartbeat` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bt_bucket`
--

LOCK TABLES `il_bt_bucket` WRITE;
/*!40000 ALTER TABLE `il_bt_bucket` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bt_bucket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bt_bucket_seq`
--

DROP TABLE IF EXISTS `il_bt_bucket_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bt_bucket_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bt_bucket_seq`
--

LOCK TABLES `il_bt_bucket_seq` WRITE;
/*!40000 ALTER TABLE `il_bt_bucket_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bt_bucket_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bt_task`
--

DROP TABLE IF EXISTS `il_bt_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bt_task` (
  `id` bigint NOT NULL DEFAULT '0',
  `type` varchar(256) DEFAULT NULL,
  `class_path` varchar(256) DEFAULT NULL,
  `class_name` varchar(256) DEFAULT NULL,
  `bucket_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bt_task`
--

LOCK TABLES `il_bt_task` WRITE;
/*!40000 ALTER TABLE `il_bt_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bt_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bt_task_seq`
--

DROP TABLE IF EXISTS `il_bt_task_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bt_task_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bt_task_seq`
--

LOCK TABLES `il_bt_task_seq` WRITE;
/*!40000 ALTER TABLE `il_bt_task_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bt_task_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bt_value`
--

DROP TABLE IF EXISTS `il_bt_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bt_value` (
  `id` bigint NOT NULL DEFAULT '0',
  `has_parent_task` tinyint DEFAULT NULL,
  `parent_task_id` bigint DEFAULT NULL,
  `hash` varchar(256) DEFAULT NULL,
  `type` varchar(256) DEFAULT NULL,
  `class_path` varchar(256) DEFAULT NULL,
  `class_name` varchar(256) DEFAULT NULL,
  `serialized` longtext,
  `bucket_id` bigint DEFAULT NULL,
  `position` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`bucket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bt_value`
--

LOCK TABLES `il_bt_value` WRITE;
/*!40000 ALTER TABLE `il_bt_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bt_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bt_value_seq`
--

DROP TABLE IF EXISTS `il_bt_value_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bt_value_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bt_value_seq`
--

LOCK TABLES `il_bt_value_seq` WRITE;
/*!40000 ALTER TABLE `il_bt_value_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bt_value_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bt_value_to_task`
--

DROP TABLE IF EXISTS `il_bt_value_to_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bt_value_to_task` (
  `id` bigint NOT NULL DEFAULT '0',
  `task_id` bigint DEFAULT NULL,
  `value_id` bigint DEFAULT NULL,
  `bucket_id` bigint DEFAULT NULL,
  `position` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`task_id`),
  KEY `i2_idx` (`value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bt_value_to_task`
--

LOCK TABLES `il_bt_value_to_task` WRITE;
/*!40000 ALTER TABLE `il_bt_value_to_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bt_value_to_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_bt_value_to_task_seq`
--

DROP TABLE IF EXISTS `il_bt_value_to_task_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_bt_value_to_task_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_bt_value_to_task_seq`
--

LOCK TABLES `il_bt_value_to_task_seq` WRITE;
/*!40000 ALTER TABLE `il_bt_value_to_task_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_bt_value_to_task_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_cert_cron_queue`
--

DROP TABLE IF EXISTS `il_cert_cron_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_cert_cron_queue` (
  `id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `adapter_class` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `started_timestamp` int NOT NULL DEFAULT '0',
  `template_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`obj_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_cert_cron_queue`
--

LOCK TABLES `il_cert_cron_queue` WRITE;
/*!40000 ALTER TABLE `il_cert_cron_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_cert_cron_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_cert_cron_queue_seq`
--

DROP TABLE IF EXISTS `il_cert_cron_queue_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_cert_cron_queue_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_cert_cron_queue_seq`
--

LOCK TABLES `il_cert_cron_queue_seq` WRITE;
/*!40000 ALTER TABLE `il_cert_cron_queue_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_cert_cron_queue_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_cert_template`
--

DROP TABLE IF EXISTS `il_cert_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_cert_template` (
  `id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `obj_type` varchar(255) NOT NULL DEFAULT '',
  `certificate_content` longtext NOT NULL,
  `certificate_hash` varchar(255) NOT NULL,
  `template_values` longtext NOT NULL,
  `background_image_path` varchar(255) DEFAULT NULL,
  `version` bigint NOT NULL DEFAULT '0',
  `ilias_version` varchar(255) NOT NULL DEFAULT 'v5.4.0',
  `created_timestamp` int NOT NULL DEFAULT '0',
  `currently_active` tinyint NOT NULL DEFAULT '0',
  `deleted` tinyint NOT NULL DEFAULT '0',
  `thumbnail_image_path` varchar(255) DEFAULT NULL,
  `background_image_ident` varchar(255) DEFAULT NULL,
  `thumbnail_image_ident` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`obj_id`),
  KEY `i2_idx` (`obj_id`,`deleted`),
  KEY `i3_idx` (`obj_id`,`currently_active`,`deleted`),
  KEY `i4_idx` (`obj_type`),
  KEY `i5_idx` (`background_image_path`,`currently_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_cert_template`
--

LOCK TABLES `il_cert_template` WRITE;
/*!40000 ALTER TABLE `il_cert_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_cert_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_cert_template_seq`
--

DROP TABLE IF EXISTS `il_cert_template_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_cert_template_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_cert_template_seq`
--

LOCK TABLES `il_cert_template_seq` WRITE;
/*!40000 ALTER TABLE `il_cert_template_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_cert_template_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_cert_user_cert`
--

DROP TABLE IF EXISTS `il_cert_user_cert`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_cert_user_cert` (
  `id` int NOT NULL DEFAULT '0',
  `pattern_certificate_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `obj_type` varchar(255) NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `user_name` varchar(255) NOT NULL DEFAULT '0',
  `acquired_timestamp` int NOT NULL DEFAULT '0',
  `certificate_content` longtext NOT NULL,
  `template_values` longtext NOT NULL,
  `valid_until` int DEFAULT NULL,
  `background_image_path` varchar(255) DEFAULT NULL,
  `version` varchar(255) NOT NULL DEFAULT '1',
  `ilias_version` varchar(255) NOT NULL DEFAULT 'v5.4.0',
  `currently_active` tinyint NOT NULL DEFAULT '0',
  `thumbnail_image_path` varchar(255) DEFAULT NULL,
  `certificate_id` varchar(64) NOT NULL DEFAULT '-',
  `background_image_ident` varchar(255) DEFAULT NULL,
  `thumbnail_image_ident` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `c1_idx` (`certificate_id`),
  KEY `i1_idx` (`obj_id`,`pattern_certificate_id`),
  KEY `i2_idx` (`usr_id`,`currently_active`),
  KEY `i3_idx` (`usr_id`,`currently_active`,`acquired_timestamp`),
  KEY `i4_idx` (`usr_id`,`obj_type`,`currently_active`),
  KEY `i5_idx` (`obj_id`,`currently_active`),
  KEY `i6_idx` (`usr_id`,`obj_id`,`currently_active`),
  KEY `i7_idx` (`background_image_path`,`currently_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_cert_user_cert`
--

LOCK TABLES `il_cert_user_cert` WRITE;
/*!40000 ALTER TABLE `il_cert_user_cert` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_cert_user_cert` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_cert_user_cert_seq`
--

DROP TABLE IF EXISTS `il_cert_user_cert_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_cert_user_cert_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_cert_user_cert_seq`
--

LOCK TABLES `il_cert_user_cert_seq` WRITE;
/*!40000 ALTER TABLE `il_cert_user_cert_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_cert_user_cert_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_certificate`
--

DROP TABLE IF EXISTS `il_certificate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_certificate` (
  `obj_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_certificate`
--

LOCK TABLES `il_certificate` WRITE;
/*!40000 ALTER TABLE `il_certificate` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_certificate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_custom_block`
--

DROP TABLE IF EXISTS `il_custom_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_custom_block` (
  `id` int NOT NULL DEFAULT '0',
  `context_obj_id` int DEFAULT NULL,
  `context_obj_type` varchar(10) DEFAULT NULL,
  `context_sub_obj_id` int DEFAULT NULL,
  `context_sub_obj_type` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_custom_block`
--

LOCK TABLES `il_custom_block` WRITE;
/*!40000 ALTER TABLE `il_custom_block` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_custom_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_custom_block_seq`
--

DROP TABLE IF EXISTS `il_custom_block_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_custom_block_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_custom_block_seq`
--

LOCK TABLES `il_custom_block_seq` WRITE;
/*!40000 ALTER TABLE `il_custom_block_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_custom_block_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_db_steps`
--

DROP TABLE IF EXISTS `il_db_steps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_db_steps` (
  `class` varchar(200) NOT NULL,
  `step` int NOT NULL,
  `started` varchar(26) DEFAULT NULL,
  `finished` varchar(26) DEFAULT NULL,
  PRIMARY KEY (`class`,`step`),
  KEY `i1_idx` (`class`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_db_steps`
--

LOCK TABLES `il_db_steps` WRITE;
/*!40000 ALTER TABLE `il_db_steps` DISABLE KEYS */;
INSERT INTO `il_db_steps` VALUES ('AbandonAuthRichTextEditorDatabaseUpdateSteps',1,'2025-07-18 06:53:07.037077','2025-07-18 06:53:07.037888'),('ilAccessControl8DBUpdateSteps',1,'2023-12-12 16:39:39.316416','2023-12-12 16:39:39.330104'),('ilAccessRBACDeleteDbkSteps',1,'2023-12-12 16:39:39.331118','2023-12-12 16:39:39.333780'),('ilAccessRBACDeleteDbkSteps',2,'2023-12-12 16:39:39.334376','2023-12-12 16:39:39.337374'),('ilAccessRBACDeleteDbkSteps',3,'2023-12-12 16:39:39.337997','2023-12-12 16:39:39.339521'),('ilADNDatabaseObjective',1,'2023-12-12 16:39:39.302966','2023-12-12 16:39:39.315435'),('ilAuthenticationDatabaseUpdateSteps8',1,'2023-12-12 16:39:39.340519','2023-12-12 16:39:39.348635'),('ilBadgeDBUpdateSteps',1,'2025-07-18 06:53:07.022218','2025-07-18 06:53:07.024081'),('ilBadgeDBUpdateSteps',2,'2025-07-18 06:53:07.024360','2025-07-18 06:53:07.026215'),('ilBibliograficDB80',1,'2023-12-12 16:39:39.349499','2023-12-12 16:39:39.355083'),('ilBibliograficDB80',2,'2023-12-12 16:39:39.355665','2023-12-12 16:39:39.362170'),('ilCalendarDBUpdateSteps10',1,'2025-07-18 06:53:07.293933','2025-07-18 06:53:07.295723'),('ilCalendarDBUpdateSteps10',2,'2025-07-18 06:53:07.295956','2025-07-18 06:53:07.296709'),('ilCalendarDBUpdateSteps9',1,'2023-12-12 16:39:39.363138','2023-12-12 16:39:39.376860'),('ilCalendarDBUpdateSteps9',2,'2023-12-12 16:39:39.377487','2023-12-12 16:39:39.399312'),('ilCertificateDatabaseUpdateSteps',1,'2023-12-12 16:39:39.400161','2023-12-12 16:39:39.413347'),('ilCertificateDatabaseUpdateSteps',2,'2023-12-12 16:39:39.413839','2023-12-12 16:39:39.417098'),('ilCertificateDatabaseUpdateSteps',3,'2023-12-12 16:39:39.417587','2023-12-12 16:39:39.426976'),('ilCertificateDatabaseUpdateSteps',4,'2023-12-12 16:39:39.427494','2023-12-12 16:39:39.434428'),('ilCertificateDatabaseUpdateSteps',5,'2023-12-12 16:39:39.434913','2023-12-12 16:39:39.449215'),('ilCertificateDatabaseUpdateSteps',6,'2025-07-18 06:53:07.323522','2025-07-18 06:53:07.325849'),('ilCertificateDatabaseUpdateSteps',7,'2025-07-18 06:53:07.326095','2025-07-18 06:53:07.330089'),('ilCertificateDatabaseUpdateSteps',8,'2025-07-18 06:53:07.330340','2025-07-18 06:53:07.332291'),('ilCertificateDatabaseUpdateSteps',9,'2025-07-18 06:53:07.332642','2025-07-18 06:53:07.346225'),('ilCmiXapiDatabaseUpdateSteps',1,'2023-12-12 16:39:39.512934','2023-12-12 16:39:39.518282'),('ilCmiXapiDatabaseUpdateSteps',2,'2023-12-12 16:39:39.518877','2023-12-12 16:39:39.524618'),('ilCmiXapiDatabaseUpdateSteps',3,'2023-12-12 16:39:39.525224','2023-12-12 16:39:39.530839'),('ilCmiXapiDatabaseUpdateSteps',4,'2023-12-12 16:39:39.531436','2023-12-12 16:39:39.537017'),('ilCmiXapiDatabaseUpdateSteps',5,'2023-12-12 16:39:39.537600','2023-12-12 16:39:39.543189'),('ilCmiXapiDatabaseUpdateSteps',6,'2023-12-12 16:39:39.543862','2023-12-12 16:39:39.554877'),('ilCmiXapiDatabaseUpdateSteps',7,'2023-12-12 16:39:39.555474','2023-12-12 16:39:39.561056'),('ilCmiXapiDatabaseUpdateSteps',8,'2023-12-12 16:39:39.561671','2023-12-12 16:39:39.567169'),('ilCmiXapiDatabaseUpdateSteps',9,'2023-12-12 16:39:39.567787','2023-12-12 16:39:39.573091'),('ilCmiXapiDatabaseUpdateSteps',10,'2023-12-12 16:39:39.573688','2023-12-12 16:39:39.579211'),('ilCmiXapiDatabaseUpdateSteps',11,'2023-12-12 16:39:39.579878','2023-12-12 16:39:39.585585'),('ilCmiXapiDatabaseUpdateSteps',12,'2023-12-12 16:39:39.586191','2023-12-12 16:39:39.586832'),('ilCmiXapiDatabaseUpdateSteps',13,'2023-12-12 16:39:39.587451','2023-12-12 16:39:39.593034'),('ilCmiXapiDatabaseUpdateSteps',14,'2023-12-12 16:39:39.593639','2023-12-12 16:39:39.599431'),('ilCmiXapiDatabaseUpdateSteps',15,'2023-12-12 16:39:39.600090','2023-12-12 16:39:39.611849'),('ilCmiXapiDatabaseUpdateSteps',16,'2023-12-12 16:39:39.612522','2023-12-12 16:39:39.624741'),('ilCmiXapiDatabaseUpdateSteps',17,'2024-04-30 15:11:09.019261','2024-04-30 15:11:09.025313'),('ilConditionsDBUpdateSteps',1,'2025-07-18 06:53:06.811671','2025-07-18 06:53:06.818282'),('ilContentPageUpdateSteps',1,'2023-12-12 16:39:39.689885','2023-12-12 16:39:39.690424'),('ilCourseDBUpdateSteps',1,'2025-07-18 06:53:07.415788','2025-07-18 06:53:07.485747'),('ilCourseObjectiveDBUpdateSteps',1,'2023-12-12 16:39:39.691358','2023-12-12 16:39:39.698495'),('ilCourseObjectiveDBUpdateSteps',2,'2023-12-12 16:39:39.699161','2023-12-12 16:39:39.705726'),('ilCourseObjectiveDBUpdateSteps',3,'2025-07-18 06:53:07.412535','2025-07-18 06:53:07.415155'),('ilCtrlDatabaseUpdateSteps',1,'2023-12-12 16:39:41.316207','2023-12-12 16:39:41.325405'),('ilCtrlDatabaseUpdateSteps',2,'2023-12-12 16:39:41.326018','2023-12-12 16:39:41.340462'),('ilCtrlDatabaseUpdateSteps',3,'2023-12-12 16:39:41.341252','2023-12-12 16:39:41.349406'),('ilCtrlDatabaseUpdateSteps',4,'2023-12-12 16:39:41.349953','2023-12-12 16:39:41.357146'),('ilCtrlDatabaseUpdateSteps',5,'2023-12-12 16:39:41.357629','2023-12-12 16:39:41.364305'),('ilCtrlDatabaseUpdateSteps',6,'2023-12-12 16:39:41.364838','2023-12-12 16:39:41.371618'),('ilDataCollectionDBUpdateSteps10',1,'2025-08-26 15:16:08.639522','2025-08-26 15:16:08.640706'),('ilDataCollectionDBUpdateSteps9',1,'2023-12-12 16:39:39.706792','2023-12-12 16:39:39.715602'),('ilDataCollectionDBUpdateSteps9',2,'2023-12-12 16:39:39.716246','2023-12-12 16:39:39.739058'),('ilDataCollectionDBUpdateSteps9',3,'2023-12-12 16:39:39.739786','2023-12-12 16:39:39.748476'),('ilDataCollectionDBUpdateSteps9',4,'2023-12-12 16:39:39.749114','2023-12-12 16:39:39.757937'),('ilDataCollectionDBUpdateSteps9',5,'2023-12-12 16:39:39.758567','2023-12-12 16:39:39.771869'),('ilDataCollectionDBUpdateSteps9',6,'2023-12-12 16:39:39.772568','2023-12-12 16:39:39.773403'),('ilDataCollectionDBUpdateSteps9',7,'2023-12-12 16:39:39.773989','2023-12-12 16:39:39.774820'),('ilDataCollectionDBUpdateSteps9',8,'2023-12-12 16:39:39.775403','2023-12-12 16:39:39.781016'),('ilDataCollectionDBUpdateSteps9',9,'2024-04-30 15:11:09.026028','2024-04-30 15:11:09.026500'),('ilDataCollectionDBUpdateSteps9',10,'2025-07-18 06:53:07.375632','2025-07-18 06:53:07.388538'),('ilDataCollectionDBUpdateSteps9',11,'2025-07-18 06:53:07.388785','2025-07-18 06:53:07.389368'),('ilDataCollectionDBUpdateSteps9',12,'2025-07-18 06:53:07.389649','2025-07-18 06:53:07.390068'),('ilDataCollectionDBUpdateSteps9',13,'2025-07-18 06:53:07.390347','2025-07-18 06:53:07.398573'),('ilDataCollectionDBUpdateSteps9',14,'2025-07-18 06:53:07.398819','2025-07-18 06:53:07.399030'),('ilDataCollectionDBUpdateSteps9',15,'2025-07-18 06:53:07.399303','2025-07-18 06:53:07.406333'),('ilDataCollectionDBUpdateSteps9',16,'2025-07-18 06:53:07.406671','2025-07-18 06:53:07.407459'),('ilDataCollectionDBUpdateSteps9',17,'2025-07-18 06:53:07.407725','2025-07-18 06:53:07.408120'),('ilDataCollectionDBUpdateSteps9',18,'2025-07-18 06:53:07.408349','2025-07-18 06:53:07.408549'),('ilDataCollectionDBUpdateSteps9',19,'2025-07-18 06:53:07.408797','2025-07-18 06:53:07.410706'),('ilDataCollectionDBUpdateSteps9',20,'2025-07-18 06:53:07.410989','2025-07-18 06:53:07.411451'),('ilECSDBUpdateSteps',1,'2023-12-12 16:39:39.782084','2023-12-12 16:39:39.788234'),('ilECSUpdateSteps8',1,'2023-12-12 16:39:41.504023','2023-12-12 16:39:41.515769'),('ilECSUpdateSteps8',2,'2023-12-12 16:39:41.516395','2023-12-12 16:39:41.521923'),('ilECSUpdateSteps8',3,'2023-12-12 16:39:41.522527','2023-12-12 16:39:41.528127'),('ilECSUpdateSteps8',4,'2023-12-12 16:39:41.528772','2023-12-12 16:39:41.534227'),('ilECSUpdateSteps8',5,'2023-12-12 16:39:41.534847','2023-12-12 16:39:41.540300'),('ilECSUpdateSteps8',6,'2023-12-12 16:39:41.540918','2023-12-12 16:39:41.547675'),('ilECSUpdateSteps8',7,'2023-12-12 16:39:41.548340','2023-12-12 16:39:41.553727'),('ilECSUpdateSteps9',1,'2025-07-18 06:53:07.084861','2025-07-18 06:53:07.114341'),('ilECSUpdateSteps9',2,'2025-07-18 06:53:07.117677','2025-07-18 06:53:07.119427'),('ilECSUpdateSteps9',3,'2025-07-18 06:53:07.123785','2025-07-18 06:53:07.126087'),('ilFileObjectDatabaseObjective',1,'2023-12-12 16:39:39.914414','2023-12-12 16:39:39.920671'),('ilFileObjectDatabaseObjective',2,'2023-12-12 16:39:39.921276','2023-12-12 16:39:39.928502'),('ilFileObjectDatabaseObjective',3,'2023-12-12 16:39:39.929117','2023-12-12 16:39:39.929997'),('ilFileObjectDatabaseObjective',4,'2023-12-12 16:39:39.930587','2023-12-12 16:39:39.940527'),('ilFileObjectDatabaseObjective',5,'2023-12-12 16:39:39.941189','2023-12-12 16:39:39.941882'),('ilFileObjectDatabaseObjective',6,'2023-12-12 16:39:39.942672','2023-12-12 16:39:39.949521'),('ilFileObjectDatabaseObjective',7,'2023-12-12 16:39:39.950136','2023-12-12 16:39:39.950687'),('ilFileObjectRBACDatabaseSteps',1,'2023-12-12 16:39:40.132129','2023-12-12 16:39:40.132786'),('ilFileObjectRBACDatabaseSteps',2,'2023-12-12 16:39:40.133332','2023-12-12 16:39:40.135571'),('ilFileObjectRBACDatabaseSteps',3,'2025-07-18 06:53:07.309981','2025-07-18 06:53:07.310260'),('ilFileServicesDatabaseObjective',1,'2023-12-12 16:39:38.029979','2023-12-12 16:39:38.038271'),('ilForumDatabaseUpdateSteps',1,'2023-12-12 16:39:40.136549','2023-12-12 16:39:40.144064'),('ilForumDatabaseUpdateSteps',2,'2023-12-12 16:39:40.144602','2023-12-12 16:39:40.145078'),('ilForumDatabaseUpdateSteps',3,'2023-12-12 16:39:40.145597','2023-12-12 16:39:40.151569'),('ilForumDatabaseUpdateSteps',4,'2023-12-12 16:39:40.152226','2023-12-12 16:39:40.160037'),('ilForumDatabaseUpdateSteps',5,'2023-12-12 16:39:40.160566','2023-12-12 16:39:40.162235'),('ilForumDatabaseUpdateSteps',6,'2023-12-12 16:39:40.162719','2023-12-12 16:39:40.167926'),('ilForumDatabaseUpdateSteps10',1,'2025-07-18 06:53:06.877221','2025-07-18 06:53:06.878629'),('ilForumDatabaseUpdateSteps9',1,'2023-12-12 16:39:40.168707','2023-12-12 16:39:40.175252'),('ilForumDatabaseUpdateSteps9',2,'2023-12-12 16:39:40.175770','2023-12-12 16:39:40.182283'),('ilGlossaryDBUpdateSteps',1,'2023-12-12 16:39:40.183155','2023-12-12 16:39:40.196432'),('ilGlossaryDBUpdateSteps',2,'2023-12-12 16:39:40.197085','2023-12-12 16:39:40.202493'),('ilGlossaryDBUpdateSteps',3,'2023-12-12 16:39:40.203145','2023-12-12 16:39:40.215012'),('ilGlossaryDBUpdateSteps',4,'2023-12-12 16:39:40.215687','2023-12-12 16:39:40.227487'),('ilGlossaryDBUpdateSteps',5,'2023-12-12 16:39:40.228164','2023-12-12 16:39:40.238518'),('ilGlossaryDBUpdateSteps',6,'2023-12-12 16:39:40.239153','2023-12-12 16:39:40.250834'),('ilHTLMDatabaseUpdateSteps10',1,'2025-07-18 06:53:07.300854','2025-07-18 06:53:07.303225'),('ILIAS\\AccessControl\\Setup\\AccessControl10DBUpdateSteps',1,'2025-07-18 06:53:07.297283','2025-07-18 06:53:07.300409'),('ILIAS\\Administration\\Setup\\ilAdministrationDBUpdateSteps',1,'2023-12-12 16:39:38.661190','2023-12-12 16:39:38.661665'),('ILIAS\\Administration\\Setup\\ilAdministrationDBUpdateSteps',2,'2023-12-12 16:39:38.662245','2023-12-12 16:39:38.676688'),('ILIAS\\Administration\\Setup\\ilAdministrationDBUpdateSteps',3,'2023-12-12 16:39:38.677408','2023-12-12 16:39:38.710199'),('ILIAS\\Administration\\Setup\\ilAdministrationDBUpdateSteps',4,'2023-12-12 16:39:38.710871','2023-12-12 16:39:38.711794'),('ILIAS\\AdvancedMetaData\\Setup\\DBUpdateSteps10',1,'2025-07-18 06:53:07.071219','2025-07-18 06:53:07.073131'),('ILIAS\\AdvancedMetaData\\Setup\\DBUpdateSteps10',2,'2025-07-18 06:53:07.073390','2025-07-18 06:53:07.077219'),('ILIAS\\AdvancedMetaData\\Setup\\DBUpdateSteps8',1,'2023-12-12 16:39:38.712839','2023-12-12 16:39:38.721799'),('ILIAS\\AdvancedMetaData\\Setup\\DBUpdateSteps8',2,'2023-12-12 16:39:38.722433','2023-12-12 16:39:38.727867'),('ILIAS\\AdvancedMetaData\\Setup\\DBUpdateSteps8',3,'2023-12-12 16:39:38.728492','2023-12-12 16:39:38.729626'),('ILIAS\\AdvancedMetaData\\Setup\\DBUpdateSteps8',4,'2025-07-18 06:53:07.068904','2025-07-18 06:53:07.070758'),('ILIAS\\Authentication\\Setup\\AbandonLoadDependantSessionDatabaseUpdateObjective',1,'2025-07-18 06:53:07.038389','2025-07-18 06:53:07.049057'),('ILIAS\\Blog\\Setup\\BlogDBUpdateSteps',1,'2023-12-12 16:39:38.730712','2023-12-12 16:39:38.736204'),('ILIAS\\Blog\\Setup\\BlogDBUpdateSteps',2,'2023-12-12 16:39:38.736861','2023-12-12 16:39:38.737915'),('ILIAS\\BookingManager\\Setup\\ilBookingManager8HotfixDBUpdateSteps',1,'2025-07-18 06:53:07.036203','2025-07-18 06:53:07.036548'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',1,'2023-12-12 16:39:38.738873','2023-12-12 16:39:38.746442'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',2,'2023-12-12 16:39:38.747069','2023-12-12 16:39:38.753419'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',3,'2023-12-12 16:39:38.754020','2023-12-12 16:39:38.760822'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',4,'2023-12-12 16:39:38.761441','2023-12-12 16:39:38.773305'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',5,'2023-12-12 16:39:38.774036','2023-12-12 16:39:38.779556'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',6,'2023-12-12 16:39:38.780215','2023-12-12 16:39:38.785707'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',7,'2023-12-12 16:39:38.786336','2023-12-12 16:39:38.797865'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',8,'2025-07-18 06:53:07.031473','2025-07-18 06:53:07.033393'),('ILIAS\\BookingManager\\Setup\\ilBookingManagerDBUpdateSteps',9,'2025-07-18 06:53:07.033694','2025-07-18 06:53:07.035764'),('ILIAS\\Chatroom\\Setup\\UpdateSteps',1,'2023-12-12 16:39:39.450025','2023-12-12 16:39:39.490305'),('ILIAS\\Chatroom\\Setup\\UpdateSteps',2,'2023-12-12 16:39:39.490976','2023-12-12 16:39:39.502927'),('ILIAS\\Chatroom\\Setup\\UpdateSteps',3,'2023-12-12 16:39:39.503552','2023-12-12 16:39:39.510145'),('ILIAS\\Chatroom\\Setup\\UpdateSteps',4,'2023-12-12 16:39:39.510759','2023-12-12 16:39:39.511899'),('ILIAS\\Chatroom\\Setup\\UpdateSteps',5,'2025-07-18 06:53:07.077705','2025-07-18 06:53:07.082265'),('ILIAS\\Chatroom\\Setup\\UpdateSteps',6,'2025-07-18 06:53:07.082573','2025-07-18 06:53:07.082933'),('ILIAS\\Cloud\\RemoveCloudDBUpdate',1,'2025-07-18 06:53:07.287374','2025-07-18 06:53:07.290554'),('ILIAS\\Cloud\\RemoveCloudDBUpdate',2,'2025-07-18 06:53:07.290806','2025-07-18 06:53:07.291026'),('ILIAS\\COPage\\IntLink\\Setup\\LinkDBUpdateSteps',1,'2025-07-18 06:53:07.310766','2025-07-18 06:53:07.312473'),('ILIAS\\COPage\\IntLink\\Setup\\LinkDBUpdateSteps',2,'2025-07-18 06:53:07.312724','2025-07-18 06:53:07.313079'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',1,'2023-12-12 16:39:37.399454','2023-12-12 16:39:37.408012'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',2,'2023-12-12 16:39:37.408541','2023-12-12 16:39:37.422711'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',3,'2023-12-12 16:39:37.423333','2023-12-12 16:39:37.425736'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',4,'2023-12-12 16:39:37.426343','2023-12-12 16:39:37.431884'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',5,'2023-12-12 16:39:37.432512','2023-12-12 16:39:37.433734'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',6,'2023-12-12 16:39:37.434361','2023-12-12 16:39:37.434807'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',7,'2023-12-12 16:39:37.435380','2023-12-12 16:39:37.436265'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',8,'2023-12-12 16:39:37.436849','2023-12-12 16:39:37.437726'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',9,'2023-12-12 16:39:37.438294','2023-12-12 16:39:37.439166'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',10,'2023-12-12 16:39:37.439832','2023-12-12 16:39:37.440784'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',11,'2023-12-12 16:39:37.441392','2023-12-12 16:39:37.442291'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',12,'2023-12-12 16:39:37.442881','2023-12-12 16:39:37.445224'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',13,'2025-07-18 06:53:06.497670','2025-07-18 06:53:06.498699'),('ILIAS\\COPage\\Setup\\ilCOPageDBUpdateSteps',14,'2025-07-18 06:53:06.498949','2025-07-18 06:53:06.500011'),('ILIAS\\COPage\\Setup\\ilCOPageHotfix9DBUpdateSteps',1,'2025-07-18 06:53:07.303785','2025-07-18 06:53:07.306634'),('ILIAS\\Dashboard\\Setup\\ilDashboardUpdateSteps',1,'2023-12-12 16:39:38.799015','2023-12-12 16:39:38.800401'),('ILIAS\\Dashboard\\Setup\\ilDashboardUpdateSteps',2,'2023-12-12 16:39:38.800987','2023-12-12 16:39:38.809540'),('ILIAS\\Dashboard\\Setup\\ilDashboardUpdateSteps',3,'2025-07-18 06:53:07.319271','2025-07-18 06:53:07.319651'),('ILIAS\\EmployeeTalk\\Setup\\ilEmployeeTalkDBUpdateSteps',1,'2023-12-12 16:39:38.816858','2023-12-12 16:39:38.817317'),('ILIAS\\EmployeeTalk\\Setup\\ilEmployeeTalkDBUpdateSteps',2,'2023-12-12 16:39:38.817979','2023-12-12 16:39:38.841591'),('ILIAS\\EmployeeTalk\\Setup\\ilEmployeeTalkDBUpdateSteps',3,'2023-12-12 16:39:38.842258','2023-12-12 16:39:38.847709'),('ILIAS\\EmployeeTalk\\Setup\\ilEmployeeTalkDBUpdateSteps',4,'2023-12-12 16:39:38.848329','2023-12-12 16:39:38.848771'),('ILIAS\\EmployeeTalk\\Setup\\ilEmployeeTalkDBUpdateSteps',5,'2023-12-12 16:39:38.849355','2023-12-12 16:39:38.861092'),('ILIAS\\EmployeeTalk\\Setup\\ilEmployeeTalkDBUpdateSteps',6,'2023-12-12 16:39:38.861704','2023-12-12 16:39:38.867089'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',1,'2023-12-12 16:39:39.798148','2023-12-12 16:39:39.804867'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',2,'2023-12-12 16:39:39.805502','2023-12-12 16:39:39.812537'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',3,'2023-12-12 16:39:39.813214','2023-12-12 16:39:39.820004'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',4,'2023-12-12 16:39:39.820636','2023-12-12 16:39:39.826826'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',5,'2023-12-12 16:39:39.827442','2023-12-12 16:39:39.833671'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',6,'2023-12-12 16:39:39.834305','2023-12-12 16:39:39.839961'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',7,'2023-12-12 16:39:39.840608','2023-12-12 16:39:39.849303'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',8,'2023-12-12 16:39:39.849936','2023-12-12 16:39:39.850592'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',9,'2023-12-12 16:39:39.851188','2023-12-12 16:39:39.865679'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',10,'2023-12-12 16:39:39.866319','2023-12-12 16:39:39.872521'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',11,'2023-12-12 16:39:39.873152','2023-12-12 16:39:39.879330'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',12,'2023-12-12 16:39:39.879965','2023-12-12 16:39:39.885563'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',13,'2023-12-12 16:39:39.886245','2023-12-12 16:39:39.892015'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',14,'2023-12-12 16:39:39.892704','2023-12-12 16:39:39.898466'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',15,'2023-12-12 16:39:39.899113','2023-12-12 16:39:39.911924'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',16,'2023-12-12 16:39:39.912625','2023-12-12 16:39:39.913394'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',17,'2024-04-30 15:11:09.027177','2024-04-30 15:11:09.030647'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',18,'2025-07-18 06:53:07.487793','2025-07-18 06:53:07.489870'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',19,'2025-07-18 06:53:07.490123','2025-07-18 06:53:07.494051'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',20,'2025-07-18 06:53:07.494338','2025-07-18 06:53:07.494651'),('ILIAS\\Exercise\\Setup\\ilExerciseDBUpdateSteps',21,'2025-07-18 06:53:07.494921','2025-07-18 06:53:07.496850'),('ILIAS\\Export\\HTML\\Setup\\DBHTMLExportUpdateSteps',1,'2025-07-18 06:53:06.830880','2025-07-18 06:53:06.834781'),('ILIAS\\Export\\HTML\\Setup\\DBHTMLExportUpdateSteps',2,'2025-07-18 06:53:06.835044','2025-07-18 06:53:06.835343'),('ILIAS\\Export\\HTML\\Setup\\DBHTMLExportUpdateSteps',3,'2025-07-18 06:53:06.835575','2025-07-18 06:53:06.835780'),('ILIAS\\Export\\HTML\\Setup\\DBHTMLExportUpdateSteps',4,'2025-07-18 06:53:06.836042','2025-07-18 06:53:06.837868'),('ILIAS\\Export\\Setup\\DBUpdateSteps10',1,'2025-07-18 06:53:06.819007','2025-07-18 06:53:06.823388'),('ILIAS\\Export\\Setup\\DBUpdateSteps10',2,'2025-07-18 06:53:06.823700','2025-07-18 06:53:06.827577'),('ILIAS\\Export\\Setup\\DBUpdateSteps10',3,'2025-07-18 06:53:06.827816','2025-07-18 06:53:06.830359'),('ILIAS\\GlobalScreen_\\UI\\Footer\\Setup\\DB100',1,'2025-07-18 06:53:06.887638','2025-07-18 06:53:06.888332'),('ILIAS\\GlobalScreen_\\UI\\Footer\\Setup\\DB100',2,'2025-07-18 06:53:06.888657','2025-07-18 06:53:06.890333'),('ILIAS\\GlobalScreen_\\UI\\Footer\\Setup\\DB100',3,'2025-07-18 06:53:06.890586','2025-07-18 06:53:06.894480'),('ILIAS\\GlobalScreen_\\UI\\Footer\\Setup\\DB100',4,'2025-07-18 06:53:06.894725','2025-07-18 06:53:06.897315'),('ILIAS\\GlobalScreen_\\UI\\Footer\\Setup\\DB100',5,'2025-07-18 06:53:06.897582','2025-07-18 06:53:06.898096'),('ILIAS\\Help\\Setup\\ilHelpDBUpdateSteps',1,'2023-12-12 16:39:38.874568','2023-12-12 16:39:38.880049'),('ILIAS\\Help\\Setup\\ilHelpDBUpdateSteps',2,'2023-12-12 16:39:38.880668','2023-12-12 16:39:38.886115'),('ILIAS\\Help\\Setup\\ilHelpDBUpdateSteps',3,'2023-12-12 16:39:38.886720','2023-12-12 16:39:38.887276'),('ILIAS\\Help\\Setup\\ilHelpDBUpdateSteps',4,'2025-07-18 06:53:06.874623','2025-07-18 06:53:06.876635'),('ILIAS\\Help\\Setup\\ilHelpDBUpdateSteps',5,'2025-12-16 16:31:28.054187','2025-12-16 16:31:28.058926'),('ILIAS\\ItemGroup\\Setup\\ilItemGroupDBUpdateSteps',1,'2023-12-12 16:39:38.894598','2023-12-12 16:39:38.900233'),('ILIAS\\ItemGroup\\Setup\\ilItemGroupDBUpdateSteps',2,'2023-12-12 16:39:38.900874','2023-12-12 16:39:38.906340'),('ILIAS\\LDAP\\Setup\\LDAPBindPasswordFieldMigration',1,'2025-07-18 06:53:07.061046','2025-07-18 06:53:07.065188'),('ILIAS\\LearningModule\\Setup\\LearningModuleDBUpdateSteps',1,'2023-12-12 16:39:38.907450','2023-12-12 16:39:38.912966'),('ILIAS\\LearningModule\\Setup\\LearningModuleDBUpdateSteps',2,'2023-12-12 16:39:38.913604','2023-12-12 16:39:38.919087'),('ILIAS\\LearningModule\\Setup\\LearningModuleDBUpdateSteps',3,'2025-07-18 06:53:07.065684','2025-07-18 06:53:07.065996'),('ILIAS\\LegalDocuments\\Setup\\UpdateSteps',1,'2023-12-12 16:39:38.920097','2023-12-12 16:39:38.970055'),('ILIAS\\LegalDocuments\\Setup\\UpdateSteps',2,'2023-12-12 16:39:38.970741','2023-12-12 16:39:38.971244'),('ILIAS\\LegalDocuments\\Setup\\UpdateSteps',3,'2024-01-31 14:38:25.383413','2024-01-31 14:38:25.389480'),('ILIAS\\Link\\Setup\\LinkDBUpdateSteps',1,'2023-12-12 16:39:38.972279','2023-12-12 16:39:38.980246'),('ILIAS\\Link\\Setup\\LinkDBUpdateSteps',2,'2023-12-12 16:39:38.980881','2023-12-12 16:39:38.981557'),('ILIAS\\MediaCast\\Setup\\ilMediaCastDBUpdateSteps',1,'2023-12-12 16:39:38.982512','2023-12-12 16:39:38.988267'),('ILIAS\\MediaCast\\Setup\\ilMediaCastDBUpdateSteps',2,'2023-12-12 16:39:38.988894','2023-12-12 16:39:38.994316'),('ILIAS\\MediaCast\\Setup\\ilMediaCastDBUpdateSteps',3,'2023-12-12 16:39:38.994925','2023-12-12 16:39:39.000555'),('ILIAS\\MediaCast\\Setup\\ilMediaCastDBUpdateSteps',4,'2023-12-12 16:39:39.001272','2023-12-12 16:39:39.004364'),('ILIAS\\MediaObjects\\Setup\\ilMediaObjectsDBUpdateSteps',1,'2023-12-12 16:39:39.005516','2023-12-12 16:39:39.006631'),('ILIAS\\MediaObjects\\Setup\\ilMediaObjectsDBUpdateSteps',2,'2024-01-31 14:38:25.390434','2024-01-31 14:38:25.391265'),('ILIAS\\MediaObjects\\Setup\\ilMediaObjectsDBUpdateSteps',3,'2025-07-18 06:53:06.840760','2025-07-18 06:53:06.841115'),('ILIAS\\MediaObjects\\Setup\\ilMediaObjectsDBUpdateSteps',4,'2025-07-18 06:53:06.841342','2025-07-18 06:53:06.843238'),('ILIAS\\MediaObjects\\Setup\\ilMediaObjectsDBUpdateSteps',5,'2025-07-18 06:53:06.843506','2025-07-18 06:53:06.844562'),('ILIAS\\MediaObjects\\Setup\\ilMediaObjectsDBUpdateSteps',6,'2025-07-18 06:53:06.844821','2025-07-18 06:53:06.847069'),('ILIAS\\MediaObjects\\Setup\\ilMediaObjectsDBUpdateSteps',7,'2025-07-18 06:53:06.847352','2025-07-18 06:53:06.849354'),('ILIAS\\Notes\\Setup\\ilNotesDBUpdateSteps',1,'2023-12-12 16:39:39.007597','2023-12-12 16:39:39.013002'),('ILIAS\\Notes\\Setup\\ilNotesDBUpdateSteps',2,'2025-07-18 06:53:07.348284','2025-07-18 06:53:07.348904'),('ILIAS\\Notes\\Setup\\ilNotesDBUpdateSteps',3,'2025-07-18 06:53:07.349188','2025-07-18 06:53:07.349521'),('ILIAS\\Object\\Setup\\ilObject9DBUpdateSteps',1,'2023-12-12 16:39:39.019667','2023-12-12 16:39:39.024275'),('ILIAS\\Object\\Setup\\ilObject9DBUpdateSteps',2,'2023-12-12 16:39:39.024758','2023-12-12 16:39:39.092466'),('ILIAS\\Object\\Setup\\ilObjectDBUpdateSteps',1,'2023-12-12 16:39:39.013957','2023-12-12 16:39:39.018894'),('ILIAS\\Object\\Setup\\ilObjectDBUpdateSteps',2,'2025-07-18 06:53:07.049556','2025-07-18 06:53:07.050318'),('ILIAS\\Object\\Setup\\ilObjectDBUpdateSteps',3,'2025-07-18 06:53:07.050620','2025-07-18 06:53:07.050885'),('ILIAS\\Object\\Setup\\ilObjectDBUpdateSteps',4,'2025-07-18 06:53:07.051152','2025-07-18 06:53:07.051571'),('ILIAS\\Object\\Setup\\ilObjectDBUpdateSteps',5,'2025-07-18 06:53:07.051796','2025-07-18 06:53:07.052070'),('ILIAS\\Poll\\Setup\\DBUpdateSteps10',1,'2025-07-18 06:53:07.052701','2025-07-18 06:53:07.056492'),('ILIAS\\Poll\\Setup\\DBUpdateSteps10',2,'2025-07-18 06:53:07.056777','2025-07-18 06:53:07.059056'),('ILIAS\\Portfolio\\Setup\\ilPortfolioDBUpdateSteps',1,'2023-12-12 16:39:39.093581','2023-12-12 16:39:39.105685'),('ILIAS\\Portfolio\\Setup\\ilPortfolioDBUpdateSteps',2,'2025-07-18 06:53:06.879129','2025-07-18 06:53:06.879418'),('ILIAS\\Repository\\Setup\\RepositoryDBUpdateSteps',1,'2023-12-12 16:39:39.106736','2023-12-12 16:39:39.107544'),('ILIAS\\Repository\\Setup\\RepositoryDBUpdateSteps',2,'2025-07-18 06:53:07.317247','2025-07-18 06:53:07.318819'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',1,'2023-12-12 16:39:39.108632','2023-12-12 16:39:39.120662'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',2,'2023-12-12 16:39:39.121328','2023-12-12 16:39:39.146185'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',3,'2023-12-12 16:39:39.146860','2023-12-12 16:39:39.152866'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',4,'2023-12-12 16:39:39.153637','2023-12-12 16:39:39.159526'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',5,'2023-12-12 16:39:39.160105','2023-12-12 16:39:39.164979'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',6,'2023-12-12 16:39:39.165526','2023-12-12 16:39:39.176173'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',7,'2023-12-12 16:39:39.176665','2023-12-12 16:39:39.177236'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',8,'2023-12-12 16:39:39.177705','2023-12-12 16:39:39.178231'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',9,'2023-12-12 16:39:39.178728','2023-12-12 16:39:39.183344'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',10,'2023-12-12 16:39:39.183836','2023-12-12 16:39:39.184355'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',11,'2023-12-12 16:39:39.184826','2023-12-12 16:39:39.190503'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',12,'2023-12-12 16:39:39.190996','2023-12-12 16:39:39.196765'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',13,'2024-01-31 14:38:25.392396','2024-01-31 14:38:25.392882'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',14,'2024-01-31 14:38:25.393355','2024-01-31 14:38:25.394528'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',15,'2024-01-31 14:38:25.395022','2024-01-31 14:38:25.395529'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',16,'2024-01-31 14:38:25.396022','2024-01-31 14:38:25.396473'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',17,'2024-01-31 14:38:25.396963','2024-01-31 14:38:25.397440'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',18,'2024-01-31 14:38:25.397913','2024-01-31 14:38:25.398366'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',19,'2024-01-31 14:38:25.398856','2024-01-31 14:38:25.399275'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',20,'2024-04-30 15:11:09.017679','2024-04-30 15:11:09.018014'),('ILIAS\\Style\\Content\\Setup\\ilStyleDBUpdateSteps',21,'2025-07-18 06:53:06.838357','2025-07-18 06:53:06.840247'),('ILIAS\\SurveyQuestionPool\\Setup\\SurveyQuestionPoolDBUpdateSteps',1,'2025-07-18 06:53:07.066560','2025-07-18 06:53:07.068398'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',1,'2025-07-18 06:53:07.209600','2025-07-18 06:53:07.213786'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',2,'2025-07-18 06:53:07.214054','2025-07-18 06:53:07.214388'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',3,'2025-07-18 06:53:07.214698','2025-07-18 06:53:07.244110'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',4,'2025-07-18 06:53:07.244429','2025-07-18 06:53:07.249594'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',5,'2025-07-18 06:53:07.250002','2025-07-18 06:53:07.258408'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',6,'2025-07-18 06:53:07.258688','2025-07-18 06:53:07.260977'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',7,'2025-07-18 06:53:07.261249','2025-07-18 06:53:07.268162'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',8,'2025-07-18 06:53:07.268436','2025-07-18 06:53:07.270400'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',9,'2025-07-18 06:53:07.270663','2025-07-18 06:53:07.271049'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',10,'2025-07-18 06:53:07.271290','2025-07-18 06:53:07.274288'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',11,'2025-07-18 06:53:07.274544','2025-07-18 06:53:07.278419'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',12,'2025-07-18 06:53:07.278684','2025-07-18 06:53:07.283826'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',13,'2025-07-18 06:53:07.284103','2025-07-18 06:53:07.284491'),('ILIAS\\Test\\Setup\\Test10DBUpdateSteps',14,'2025-07-18 06:53:07.284730','2025-07-18 06:53:07.284965'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',1,'2025-07-18 06:53:07.128907','2025-07-18 06:53:07.132259'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',2,'2025-07-18 06:53:07.134005','2025-07-18 06:53:07.137416'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',3,'2025-07-18 06:53:07.138807','2025-07-18 06:53:07.141647'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',4,'2025-07-18 06:53:07.144340','2025-07-18 06:53:07.146907'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',5,'2025-07-18 06:53:07.147896','2025-07-18 06:53:07.150599'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',6,'2025-07-18 06:53:07.151500','2025-07-18 06:53:07.154193'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',7,'2025-07-18 06:53:07.157733','2025-07-18 06:53:07.160482'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',8,'2025-07-18 06:53:07.161608','2025-07-18 06:53:07.180025'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',9,'2025-07-18 06:53:07.180734','2025-07-18 06:53:07.181645'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',10,'2025-07-18 06:53:07.182375','2025-07-18 06:53:07.183451'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',11,'2025-07-18 06:53:07.184037','2025-07-18 06:53:07.185039'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',12,'2025-07-18 06:53:07.185666','2025-07-18 06:53:07.186596'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',13,'2025-07-18 06:53:07.187026','2025-07-18 06:53:07.188357'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',14,'2025-07-18 06:53:07.188783','2025-07-18 06:53:07.194378'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',15,'2025-07-18 06:53:07.194689','2025-07-18 06:53:07.195416'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',16,'2025-07-18 06:53:07.195771','2025-07-18 06:53:07.196418'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',17,'2025-07-18 06:53:07.196774','2025-07-18 06:53:07.199249'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',18,'2025-07-18 06:53:07.199571','2025-07-18 06:53:07.200289'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',19,'2025-07-18 06:53:07.200642','2025-07-18 06:53:07.201362'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',20,'2025-07-18 06:53:07.201680','2025-07-18 06:53:07.202021'),('ILIAS\\Test\\Setup\\Test9DBUpdateSteps',22,'2025-07-18 06:53:07.202319','2025-07-18 06:53:07.208907'),('ILIAS\\User\\Setup\\DBUpdateSteps10',1,'2025-07-18 06:53:06.854129','2025-07-18 06:53:06.854907'),('ILIAS\\User\\Setup\\DBUpdateSteps10',2,'2025-07-18 06:53:06.855188','2025-07-18 06:53:06.863093'),('ILIAS\\User\\Setup\\DBUpdateSteps10',3,'2025-07-18 06:53:06.863347','2025-07-18 06:53:06.863814'),('ILIAS\\User\\Setup\\DBUpdateSteps10',4,'2025-07-18 06:53:06.864112','2025-07-18 06:53:06.864630'),('ILIAS\\User\\Setup\\DBUpdateSteps10',5,'2025-07-18 06:53:06.864916','2025-07-18 06:53:06.868223'),('ILIAS\\Wiki\\Setup\\ilWiki8HotfixDBUpdateSteps',1,'2025-07-18 06:53:07.021380','2025-07-18 06:53:07.021735'),('ILIAS\\Wiki\\Setup\\ilWikiDBUpdateSteps',1,'2023-12-12 16:39:39.203953','2023-12-12 16:39:39.239197'),('ILIAS\\Wiki\\Setup\\ilWikiDBUpdateSteps',2,'2023-12-12 16:39:39.239904','2023-12-12 16:39:39.245378'),('ILIAS\\Wiki\\Setup\\ilWikiDBUpdateSteps',3,'2023-12-12 16:39:39.245988','2023-12-12 16:39:39.259866'),('ILIAS\\Wiki\\Setup\\ilWikiDBUpdateSteps',4,'2023-12-12 16:39:39.260560','2023-12-12 16:39:39.280185'),('ILIAS\\Wiki\\Setup\\ilWikiDBUpdateSteps',5,'2023-12-12 16:39:39.280812','2023-12-12 16:39:39.301898'),('ILIAS\\Wiki\\Setup\\ilWikiDBUpdateSteps',6,'2025-07-18 06:53:07.020517','2025-07-18 06:53:07.020872'),('ilIndividualAssessmentRectifyMembersTableDBUpdateSteps',1,'2023-12-12 16:39:40.251946','2023-12-12 16:39:40.257004'),('ilIndividualAssessmentRectifyMembersTableDBUpdateSteps',2,'2023-12-12 16:39:40.257656','2023-12-12 16:39:40.258318'),('ilIntroduceComponentArtifactDBUpdateSteps',1,'2023-12-12 16:39:39.625922','2023-12-12 16:39:39.633814'),('ilIntroduceComponentArtifactDBUpdateSteps',2,'2023-12-12 16:39:39.634423','2023-12-12 16:39:39.642084'),('ilIntroduceComponentArtifactDBUpdateSteps',3,'2023-12-12 16:39:39.642678','2023-12-12 16:39:39.643189'),('ilIntroduceComponentArtifactDBUpdateSteps',4,'2023-12-12 16:39:39.643787','2023-12-12 16:39:39.660457'),('ilIntroduceComponentArtifactDBUpdateSteps',5,'2023-12-12 16:39:39.661137','2023-12-12 16:39:39.667384'),('ilIntroduceComponentArtifactDBUpdateSteps',6,'2023-12-12 16:39:39.668074','2023-12-12 16:39:39.674546'),('ilIntroduceComponentArtifactDBUpdateSteps',7,'2023-12-12 16:39:39.675172','2023-12-12 16:39:39.682053'),('ilIntroduceComponentArtifactDBUpdateSteps',8,'2023-12-12 16:39:39.682739','2023-12-12 16:39:39.688813'),('ilIntroduceEventHandlingArtifactDBUpdateSteps',1,'2023-12-12 16:39:39.789218','2023-12-12 16:39:39.797080'),('ilLearningSequenceRectifyPostConditionsTableDBUpdateSteps',1,'2023-12-12 16:39:40.445426','2023-12-12 16:39:40.460126'),('ilLearningSequenceRectifyPostConditionsTableDBUpdateSteps',2,'2023-12-12 16:39:40.460745','2023-12-12 16:39:40.469096'),('ilLearningSequenceRectifyPostConditionsTableDBUpdateSteps',3,'2023-12-12 16:39:40.469737','2023-12-12 16:39:40.470737'),('ilLearningSequenceRegisterNotificationType',1,'2023-12-12 16:39:40.471781','2023-12-12 16:39:40.472617'),('ilLearningSequenceRegisterNotificationType',2,'2023-12-12 16:39:40.473202','2023-12-12 16:39:40.474079'),('ilLoggingUpdateSteps8',1,'2023-12-12 16:39:40.475061','2023-12-12 16:39:40.475900'),('ilLTIConsumerDatabaseUpdateSteps',1,'2023-12-12 16:39:40.259312','2023-12-12 16:39:40.265030'),('ilLTIConsumerDatabaseUpdateSteps',2,'2023-12-12 16:39:40.265647','2023-12-12 16:39:40.271342'),('ilLTIConsumerDatabaseUpdateSteps',3,'2023-12-12 16:39:40.271999','2023-12-12 16:39:40.277873'),('ilLTIConsumerDatabaseUpdateSteps',4,'2023-12-12 16:39:40.278484','2023-12-12 16:39:40.284092'),('ilLTIConsumerDatabaseUpdateSteps',5,'2023-12-12 16:39:40.284732','2023-12-12 16:39:40.290336'),('ilLTIConsumerDatabaseUpdateSteps',6,'2023-12-12 16:39:40.290982','2023-12-12 16:39:40.296595'),('ilLTIConsumerDatabaseUpdateSteps',7,'2023-12-12 16:39:40.297211','2023-12-12 16:39:40.302845'),('ilLTIConsumerDatabaseUpdateSteps',8,'2023-12-12 16:39:40.303494','2023-12-12 16:39:40.309589'),('ilLTIConsumerDatabaseUpdateSteps',9,'2023-12-12 16:39:40.310207','2023-12-12 16:39:40.315960'),('ilLTIConsumerDatabaseUpdateSteps',10,'2023-12-12 16:39:40.316586','2023-12-12 16:39:40.322306'),('ilLTIConsumerDatabaseUpdateSteps',11,'2023-12-12 16:39:40.322920','2023-12-12 16:39:40.328713'),('ilLTIConsumerDatabaseUpdateSteps',12,'2023-12-12 16:39:40.329332','2023-12-12 16:39:40.335168'),('ilLTIConsumerDatabaseUpdateSteps',13,'2023-12-12 16:39:40.335799','2023-12-12 16:39:40.341702'),('ilLTIConsumerDatabaseUpdateSteps',14,'2023-12-12 16:39:40.342328','2023-12-12 16:39:40.347680'),('ilLTIConsumerDatabaseUpdateSteps',15,'2023-12-12 16:39:40.348311','2023-12-12 16:39:40.368952'),('ilLTIDatabaseUpdateSteps',1,'2023-12-12 16:39:40.370010','2023-12-12 16:39:40.376439'),('ilLTIDatabaseUpdateSteps',2,'2023-12-12 16:39:40.377073','2023-12-12 16:39:40.383219'),('ilLTIDatabaseUpdateSteps',3,'2023-12-12 16:39:40.383847','2023-12-12 16:39:40.392769'),('ilLTIDatabaseUpdateSteps',4,'2023-12-12 16:39:40.393390','2023-12-12 16:39:40.399362'),('ilLTIDatabaseUpdateSteps',5,'2023-12-12 16:39:40.399988','2023-12-12 16:39:40.405337'),('ilLTIDatabaseUpdateSteps',6,'2023-12-12 16:39:40.405914','2023-12-12 16:39:40.411265'),('ilLTIDatabaseUpdateSteps',7,'2023-12-12 16:39:40.411887','2023-12-12 16:39:40.417318'),('ilLTIDatabaseUpdateSteps',8,'2023-12-12 16:39:40.418019','2023-12-12 16:39:40.435272'),('ilLTIDatabaseUpdateSteps',9,'2023-12-12 16:39:40.435922','2023-12-12 16:39:40.444322'),('ilMailDatabaseUpdateSteps',1,'2023-12-12 16:39:40.663356','2023-12-12 16:39:40.671293'),('ilMailDatabaseUpdateSteps',2,'2023-12-12 16:39:40.671949','2023-12-12 16:39:40.672918'),('ilMailDatabaseUpdateSteps',3,'2023-12-12 16:39:40.673495','2023-12-12 16:39:40.674173'),('ilMailDatabaseUpdateSteps',4,'2023-12-12 16:39:40.674772','2023-12-12 16:39:40.675455'),('ilMailDatabaseUpdateSteps',5,'2023-12-12 16:39:40.676087','2023-12-12 16:39:40.686900'),('ilMailDatabaseUpdateSteps',6,'2023-12-12 16:39:40.687535','2023-12-12 16:39:40.693141'),('ilMailDatabaseUpdateSteps',7,'2023-12-12 16:39:40.693741','2023-12-12 16:39:40.699091'),('ilMailDatabaseUpdateSteps',8,'2023-12-12 16:39:40.699748','2023-12-12 16:39:40.705271'),('ilMailDatabaseUpdateSteps',9,'2023-12-12 16:39:40.705882','2023-12-12 16:39:40.711450'),('ilMailDatabaseUpdateSteps',10,'2023-12-12 16:39:40.712067','2023-12-12 16:39:40.717425'),('ilMailDatabaseUpdateSteps',11,'2023-12-12 16:39:40.718029','2023-12-12 16:39:40.729740'),('ilMailDatabaseUpdateSteps',12,'2023-12-12 16:39:40.730356','2023-12-12 16:39:40.731892'),('ilMailDatabaseUpdateSteps',13,'2025-07-18 06:53:07.320136','2025-07-18 06:53:07.320874'),('ilMailDatabaseUpdateSteps',14,'2025-07-18 06:53:07.321140','2025-07-18 06:53:07.321866'),('ilMailDatabaseUpdateSteps',15,'2025-07-18 06:53:07.322155','2025-07-18 06:53:07.323038'),('ilMDControlledVocabsUpdateSteps',1,'2025-07-18 06:53:06.905932','2025-07-18 06:53:06.909534'),('ilMDControlledVocabsUpdateSteps',2,'2025-07-18 06:53:06.909878','2025-07-18 06:53:06.914414'),('ilMDControlledVocabsUpdateSteps',3,'2025-07-18 06:53:06.914661','2025-07-18 06:53:06.918434'),('ilMDControlledVocabsUpdateSteps',4,'2025-07-18 06:53:06.918733','2025-07-18 06:53:06.948116'),('ilMDControlledVocabsUpdateSteps',5,'2025-07-18 06:53:06.948531','2025-07-18 06:53:06.984897'),('ilMDControlledVocabsUpdateSteps',6,'2025-07-18 06:53:06.985268','2025-07-18 06:53:06.989267'),('ilMDControlledVocabsUpdateSteps',7,'2025-07-18 06:53:06.989581','2025-07-18 06:53:06.990339'),('ilMDControlledVocabsUpdateSteps',8,'2025-07-18 06:53:06.990632','2025-07-18 06:53:07.019696'),('ilMDCopyrightUpdateSteps',1,'2023-12-12 16:39:40.621835','2023-12-12 16:39:40.627401'),('ilMDCopyrightUpdateSteps',2,'2023-12-12 16:39:40.628041','2023-12-12 16:39:40.633497'),('ilMDCopyrightUpdateSteps',3,'2023-12-12 16:39:40.634103','2023-12-12 16:39:40.639372'),('ilMDCopyrightUpdateSteps',4,'2023-12-12 16:39:40.639987','2023-12-12 16:39:40.645401'),('ilMDCopyrightUpdateSteps',5,'2023-12-12 16:39:40.645992','2023-12-12 16:39:40.651340'),('ilMDCopyrightUpdateSteps',6,'2023-12-12 16:39:40.651967','2023-12-12 16:39:40.657337'),('ilMDCopyrightUpdateSteps',7,'2023-12-12 16:39:40.658051','2023-12-12 16:39:40.659947'),('ilMDCopyrightUpdateSteps',8,'2023-12-12 16:39:40.660599','2023-12-12 16:39:40.662327'),('ilMDCopyrightUpdateSteps',9,'2025-07-18 06:53:06.898718','2025-07-18 06:53:06.899009'),('ilMDCopyrightUpdateSteps',10,'2025-07-18 06:53:06.899255','2025-07-18 06:53:06.899768'),('ilMDCopyrightUpdateSteps',11,'2025-07-18 06:53:06.900018','2025-07-18 06:53:06.900550'),('ilMDCopyrightUpdateSteps',12,'2025-07-18 06:53:06.900819','2025-07-18 06:53:06.901218'),('ilMDLOMUpdateSteps',1,'2023-12-12 16:39:40.476845','2023-12-12 16:39:40.482604'),('ilMDLOMUpdateSteps',2,'2023-12-12 16:39:40.483210','2023-12-12 16:39:40.493505'),('ilMDLOMUpdateSteps',3,'2023-12-12 16:39:40.494133','2023-12-12 16:39:40.504527'),('ilMDLOMUpdateSteps',4,'2023-12-12 16:39:40.505181','2023-12-12 16:39:40.515657'),('ilMDLOMUpdateSteps',5,'2023-12-12 16:39:40.516306','2023-12-12 16:39:40.526976'),('ilMDLOMUpdateSteps',6,'2023-12-12 16:39:40.527629','2023-12-12 16:39:40.542589'),('ilMDLOMUpdateSteps',7,'2023-12-12 16:39:40.543237','2023-12-12 16:39:40.558219'),('ilMDLOMUpdateSteps',8,'2023-12-12 16:39:40.558863','2023-12-12 16:39:40.573725'),('ilMDLOMUpdateSteps',9,'2023-12-12 16:39:40.574348','2023-12-12 16:39:40.589676'),('ilMDLOMUpdateSteps',10,'2023-12-12 16:39:40.590295','2023-12-12 16:39:40.605243'),('ilMDLOMUpdateSteps',11,'2023-12-12 16:39:40.605852','2023-12-12 16:39:40.620681'),('ilMDUpdateSteps10',1,'2025-07-18 06:53:06.901643','2025-07-18 06:53:06.905399'),('ilMigrateStudyProgrammeCertificateProviderDBUpdateSteps',1,'2025-07-18 06:53:07.313584','2025-07-18 06:53:07.313812'),('ilNotificationUpdateSteps',1,'2023-12-12 16:39:40.745514','2023-12-12 16:39:40.746045'),('ilNotificationUpdateSteps',2,'2023-12-12 16:39:40.746642','2023-12-12 16:39:40.747782'),('ilNotificationUpdateSteps',3,'2023-12-12 16:39:40.748371','2023-12-12 16:39:40.749597'),('ilNotificationUpdateSteps',4,'2023-12-12 16:39:40.750183','2023-12-12 16:39:40.751779'),('ilNotificationUpdateSteps',5,'2023-12-12 16:39:40.752382','2023-12-12 16:39:40.753632'),('ilNotificationUpdateSteps',6,'2023-12-12 16:39:40.754372','2023-12-12 16:39:40.755632'),('ilNotificationUpdateSteps',7,'2023-12-12 16:39:40.756273','2023-12-12 16:39:40.757139'),('ilNotificationUpdateSteps',8,'2023-12-12 16:39:40.757727','2023-12-12 16:39:40.764151'),('ilNotificationUpdateSteps',9,'2023-12-12 16:39:40.764798','2023-12-12 16:39:40.766089'),('ilNotificationUpdateSteps',10,'2023-12-12 16:39:40.766605','2023-12-12 16:39:40.774578'),('ilNotificationUpdateSteps',11,'2023-12-12 16:39:40.775108','2023-12-12 16:39:40.776339'),('ilObjCloudModuleProgressTableUpdateSteps',1,'2023-12-12 16:39:40.777271','2023-12-12 16:39:40.778064'),('ilPDFGenerationDB90',1,'2023-12-12 16:39:40.778896','2023-12-12 16:39:40.789544'),('ilPDFGenerationDB90',2,'2023-12-12 16:39:40.790049','2023-12-12 16:39:40.799836'),('ilPDFGenerationDB90',3,'2023-12-12 16:39:40.800336','2023-12-12 16:39:40.809509'),('ilPDFGenerationDB90',4,'2023-12-12 16:39:40.810009','2023-12-12 16:39:40.819202'),('ilPDFGenerationDB90',5,'2023-12-12 16:39:40.819725','2023-12-12 16:39:40.828889'),('ilPDFGenerationDB90',6,'2023-12-12 16:39:40.829380','2023-12-12 16:39:40.830736'),('ilPDFGenerationDB90',7,'2023-12-12 16:39:40.831240','2023-12-12 16:39:40.832631'),('ilPDFGenerationDB90',8,'2023-12-12 16:39:40.833116','2023-12-12 16:39:40.834456'),('ilPDFGenerationDB90',9,'2023-12-12 16:39:40.834934','2023-12-12 16:39:40.836311'),('ilPDFGenerationDB90',10,'2023-12-12 16:39:40.836855','2023-12-12 16:39:40.838152'),('ilPDFGenerationDB90',11,'2023-12-12 16:39:40.838623','2023-12-12 16:39:40.839346'),('ilPDFGenerationDB90',12,'2023-12-12 16:39:40.839825','2023-12-12 16:39:40.840539'),('ilPDFGenerationDB90',13,'2023-12-12 16:39:40.841100','2023-12-12 16:39:40.842378'),('ilPDFGenerationDB90',14,'2023-12-12 16:39:40.842860','2023-12-12 16:39:40.843572'),('ilRadiusDBUpdateSteps',1,'2023-12-12 16:39:40.844445','2023-12-12 16:39:40.844895'),('ilRepository9DBUpdateSteps',1,'2025-07-18 06:53:07.316387','2025-07-18 06:53:07.316726'),('ilResourceStorageDB80',1,'2023-12-12 16:39:38.338173','2023-12-12 16:39:38.367464'),('ilResourceStorageDB80',2,'2023-12-12 16:39:38.368013','2023-12-12 16:39:38.388821'),('ilResourceStorageDB80',3,'2023-12-12 16:39:38.389366','2023-12-12 16:39:38.429636'),('ilResourceStorageDB80',4,'2023-12-12 16:39:38.430303','2023-12-12 16:39:38.437061'),('ilResourceStorageDB80',5,'2023-12-12 16:39:38.437660','2023-12-12 16:39:38.471262'),('ilResourceStorageDB80',6,'2023-12-12 16:39:38.471788','2023-12-12 16:39:38.519138'),('ilResourceStorageDB80',7,'2023-12-12 16:39:38.519862','2023-12-12 16:39:38.526648'),('ilResourceStorageDB80',8,'2023-12-12 16:39:38.527269','2023-12-12 16:39:38.556170'),('ilResourceStorageDB80',9,'2023-12-12 16:39:38.556806','2023-12-12 16:39:38.566584'),('ilResourceStorageDB80',10,'2023-12-12 16:39:38.567201','2023-12-12 16:39:38.580806'),('ilResourceStorageDB80',11,'2023-12-12 16:39:38.581452','2023-12-12 16:39:38.598519'),('ilResourceStorageDB80',12,'2023-12-12 16:39:38.599143','2023-12-12 16:39:38.604883'),('ilResourceStorageDB80',13,'2025-07-18 06:53:06.433097','2025-07-18 06:53:06.437945'),('ilResourceStorageDB90',1,'2023-12-12 16:39:39.951730','2023-12-12 16:39:39.994214'),('ilResourceStorageDB90',2,'2023-12-12 16:39:39.994875','2023-12-12 16:39:40.021210'),('ilResourceStorageDB90',3,'2023-12-12 16:39:40.021888','2023-12-12 16:39:40.027049'),('ilResourceStorageDB90',4,'2023-12-12 16:39:40.027697','2023-12-12 16:39:40.032367'),('ilScorm2004DatabaseUpdateSteps',1,'2025-11-04 16:18:51.922597','2025-11-04 16:18:51.925280'),('ilScorm2004DatabaseUpdateSteps',2,'2025-11-04 16:18:51.925565','2025-11-04 16:18:51.931400'),('ilScormAiccDatabaseUpdateSteps',1,'2024-01-31 14:38:25.408514','2024-01-31 14:38:25.417677'),('ilSessionDBUpdateSteps9',1,'2023-12-12 16:39:40.848750','2023-12-12 16:39:40.854713'),('ilSessionDBUpdateSteps9',2,'2023-12-12 16:39:40.855241','2023-12-12 16:39:40.869825'),('ilSkillDBUpdateSteps',1,'2023-12-12 16:39:40.893060','2023-12-12 16:39:40.913834'),('ilSkillDBUpdateSteps',2,'2023-12-12 16:39:40.914360','2023-12-12 16:39:40.919452'),('ilSkillDBUpdateSteps',3,'2023-12-12 16:39:40.919946','2023-12-12 16:39:40.924695'),('ilSkillDBUpdateSteps',4,'2023-12-12 16:39:40.925205','2023-12-12 16:39:40.925597'),('ilSkillDBUpdateSteps',5,'2023-12-12 16:39:40.926110','2023-12-12 16:39:40.926514'),('ilSkillDBUpdateSteps',6,'2023-12-12 16:39:40.927018','2023-12-12 16:39:40.927831'),('ilSkillDBUpdateSteps',7,'2023-12-12 16:39:40.928349','2023-12-12 16:39:40.929305'),('ilSkillDBUpdateSteps',8,'2023-12-12 16:39:40.929848','2023-12-12 16:39:40.935168'),('ilSkillDBUpdateSteps',9,'2023-12-12 16:39:40.935805','2023-12-12 16:39:40.936593'),('ilSkillDBUpdateSteps',10,'2023-12-12 16:39:40.937203','2023-12-12 16:39:40.944921'),('ilSkillDBUpdateSteps',11,'2023-12-12 16:39:40.945559','2023-12-12 16:39:40.957641'),('ilSoapWsdlPathUpdateStep',1,'2025-07-18 06:53:07.083503','2025-07-18 06:53:07.084316'),('ilStudyProgrammeAssignmentTableUpdateSteps',1,'2023-12-12 16:39:40.978569','2023-12-12 16:39:40.986575'),('ilStudyProgrammeAutoCategoryTableUpdateSteps',1,'2023-12-12 16:39:41.008416','2023-12-12 16:39:41.014561'),('ilStudyProgrammeAutoMembershipTableUpdateSteps',1,'2025-07-18 06:53:07.314262','2025-07-18 06:53:07.315808'),('ilStudyProgrammePCStatusInfoUpdateSteps',1,'2023-12-12 16:39:41.015560','2023-12-12 16:39:41.016387'),('ilStudyProgrammeProgressTableUpdateSteps',1,'2023-12-12 16:39:40.958801','2023-12-12 16:39:40.964559'),('ilStudyProgrammeProgressTableUpdateSteps',2,'2023-12-12 16:39:40.965178','2023-12-12 16:39:40.971470'),('ilStudyProgrammeProgressTableUpdateSteps',3,'2023-12-12 16:39:40.972111','2023-12-12 16:39:40.977513'),('ilStudyProgrammeSettingsTableUpdateSteps',1,'2023-12-12 16:39:40.987952','2023-12-12 16:39:40.993671'),('ilStudyProgrammeSettingsTableUpdateSteps',2,'2023-12-12 16:39:40.994296','2023-12-12 16:39:41.007392'),('ilStudyProgrammeUDFDefinitionUpdateSteps',1,'2023-12-12 16:39:41.017295','2023-12-12 16:39:41.022663'),('ilTest9DBUpdateSteps',1,'2023-12-12 16:39:41.096769','2023-12-12 16:39:41.103656'),('ilTest9DBUpdateSteps',2,'2023-12-12 16:39:41.104286','2023-12-12 16:39:41.115799'),('ilTest9DBUpdateSteps',3,'2023-12-12 16:39:41.116433','2023-12-12 16:39:41.118700'),('ilTest9DBUpdateSteps',4,'2023-12-12 16:39:41.119314','2023-12-12 16:39:41.132294'),('ilTest9DBUpdateSteps',5,'2023-12-12 16:39:41.132920','2023-12-12 16:39:41.173231'),('ilTest9DBUpdateSteps',6,'2023-12-12 16:39:41.173872','2023-12-12 16:39:41.194216'),('ilTest9DBUpdateSteps',7,'2023-12-12 16:39:41.194841','2023-12-12 16:39:41.227543'),('ilTest9DBUpdateSteps',8,'2023-12-12 16:39:41.228136','2023-12-12 16:39:41.233772'),('ilTest9DBUpdateSteps',9,'2023-12-12 16:39:41.234280','2023-12-12 16:39:41.240277'),('ilTest9DBUpdateSteps',10,'2023-12-12 16:39:41.240874','2023-12-12 16:39:41.247449'),('ilTest9DBUpdateSteps',11,'2023-12-12 16:39:41.248082','2023-12-12 16:39:41.254525'),('ilTest9DBUpdateSteps',12,'2023-12-12 16:39:41.255153','2023-12-12 16:39:41.256499'),('ilTest9DBUpdateSteps',13,'2023-12-12 16:39:41.257140','2023-12-12 16:39:41.270051'),('ilTest9DBUpdateSteps',14,'2023-12-12 16:39:41.270683','2023-12-12 16:39:41.282114'),('ilTest9DBUpdateSteps',15,'2023-12-12 16:39:41.282746','2023-12-12 16:39:41.289702'),('ilTest9DBUpdateSteps',16,'2023-12-12 16:39:41.290328','2023-12-12 16:39:41.295496'),('ilTest9DBUpdateSteps',17,'2023-12-12 16:39:41.296140','2023-12-12 16:39:41.301432'),('ilTest9DBUpdateSteps',18,'2023-12-12 16:39:41.302072','2023-12-12 16:39:41.307756'),('ilTest9DBUpdateSteps',19,'2024-04-30 15:11:09.036627','2024-04-30 15:11:09.040172'),('ilTestQuestionPool10DBUpdateSteps',1,'2025-07-18 06:53:07.358883','2025-07-18 06:53:07.373053'),('ilTestQuestionPool10DBUpdateSteps',2,'2025-07-18 06:53:07.373304','2025-07-18 06:53:07.375092'),('ilTestQuestionPool80DBUpdateSteps',1,'2023-12-12 16:39:41.023770','2023-12-12 16:39:41.025028'),('ilTestQuestionPool80DBUpdateSteps',2,'2023-12-12 16:39:41.025620','2023-12-12 16:39:41.031146'),('ilTestQuestionPool80DBUpdateSteps',3,'2023-12-12 16:39:41.031863','2023-12-12 16:39:41.038435'),('ilTestQuestionPool80DBUpdateSteps',4,'2023-12-12 16:39:41.039062','2023-12-12 16:39:41.045485'),('ilTestQuestionPool80DBUpdateSteps',5,'2023-12-12 16:39:41.046098','2023-12-12 16:39:41.059436'),('ilTestQuestionPool80DBUpdateSteps',6,'2023-12-12 16:39:41.060098','2023-12-12 16:39:41.065553'),('ilTestQuestionPool80DBUpdateSteps',7,'2023-12-12 16:39:41.066180','2023-12-12 16:39:41.071725'),('ilTestQuestionPool9DBUpdateSteps',1,'2023-12-12 16:39:41.072787','2023-12-12 16:39:41.078929'),('ilTestQuestionPool9DBUpdateSteps',2,'2023-12-12 16:39:41.079544','2023-12-12 16:39:41.085869'),('ilTestQuestionPool9DBUpdateSteps',3,'2023-12-12 16:39:41.086494','2023-12-12 16:39:41.088653'),('ilTestQuestionPool9DBUpdateSteps',4,'2023-12-12 16:39:41.089278','2023-12-12 16:39:41.095717'),('ilTestQuestionPool9DBUpdateSteps',5,'2025-07-18 06:53:07.350483','2025-07-18 06:53:07.353698'),('ilTestQuestionPool9DBUpdateSteps',6,'2025-07-18 06:53:07.353984','2025-07-18 06:53:07.356064'),('ilTestQuestionPool9DBUpdateSteps',7,'2025-07-18 06:53:07.356321','2025-07-18 06:53:07.358415'),('ilTrackingUpdateSteps9',1,'2025-07-18 06:53:06.849847','2025-07-18 06:53:06.853560'),('ilTreeDBUpdateSteps8',1,'2023-12-12 16:39:41.308875','2023-12-12 16:39:41.315183'),('ilUser8DBUpdateSteps',1,'2023-12-12 16:39:41.372439','2023-12-12 16:39:41.392529'),('ilUser8DBUpdateSteps',2,'2023-12-12 16:39:41.393125','2023-12-12 16:39:41.414590'),('ilUser8DBUpdateSteps',3,'2023-12-12 16:39:41.415252','2023-12-12 16:39:41.420387'),('ilUser8DBUpdateSteps',4,'2024-01-31 14:38:25.421546','2024-01-31 14:38:25.426800'),('ilUserDB90',1,'2023-12-12 16:39:41.421460','2023-12-12 16:39:41.427774'),('ilUserDB90',2,'2023-12-12 16:39:41.428399','2023-12-12 16:39:41.440313'),('ilUserDB90',3,'2023-12-12 16:39:41.441020','2023-12-12 16:39:41.446411'),('ilUserDB90',4,'2023-12-12 16:39:41.447095','2023-12-12 16:39:41.447652'),('ilUserDB90',5,'2023-12-12 16:39:41.448240','2023-12-12 16:39:41.453864'),('ilUserDB90',6,'2023-12-12 16:39:41.454487','2023-12-12 16:39:41.459460'),('ilUserDB90',7,'2023-12-12 16:39:41.460101','2023-12-12 16:39:41.470891'),('ilUserDB90',8,'2024-01-31 14:38:25.427561','2024-01-31 14:38:25.428274'),('ilUserDB90',9,'2024-04-30 15:11:09.040853','2024-04-30 15:11:09.041154'),('ilWebResourceDBUpdateSteps',1,'2023-12-12 16:39:41.472042','2023-12-12 16:39:41.478899'),('ilWebResourceDBUpdateSteps',2,'2025-07-18 06:53:06.868758','2025-07-18 06:53:06.874080'),('ilWebResourceDropValidSteps',1,'2023-12-12 16:39:41.479938','2023-12-12 16:39:41.486502'),('ilWebResourceDropValidSteps',2,'2023-12-12 16:39:41.487110','2023-12-12 16:39:41.493529'),('ilWebResourceDropValidSteps',3,'2023-12-12 16:39:41.494136','2023-12-12 16:39:41.500293'),('ilWebResourceDropValidSteps',4,'2023-12-12 16:39:41.500904','2023-12-12 16:39:41.502972'),('ilWOPIDB100',1,'2025-07-18 06:53:07.291500','2025-07-18 06:53:07.293391'),('ilWOPIDB90',1,'2023-12-12 16:39:38.616248','2023-12-12 16:39:38.629801'),('ilWOPIDB90',2,'2023-12-12 16:39:38.630407','2023-12-12 16:39:38.650076'),('ilWOPIDB90',3,'2025-07-18 06:53:06.427551','2025-07-18 06:53:06.429874'),('ilWOPIDB90',4,'2025-07-18 06:53:06.430127','2025-07-18 06:53:06.432128'),('ilWorkflowEngine9DBUpdateSteps',1,'2023-12-12 16:39:41.554740','2023-12-12 16:39:41.555315'),('ilWorkflowEngine9DBUpdateSteps',2,'2023-12-12 16:39:41.555897','2023-12-12 16:39:41.595930'),('ilWorkflowEngine9DBUpdateSteps',3,'2023-12-12 16:39:41.596587','2023-12-12 16:39:41.597086'),('ilWorkflowEngine9DBUpdateSteps',4,'2023-12-12 16:39:41.597674','2023-12-12 16:39:41.601575'),('LSODropActivationDBUpdateSteps',1,'2025-11-04 16:18:51.939250','2025-11-04 16:18:51.943824'),('MigrateCourseCertificateProviderDBUpdateSteps',1,'2025-07-18 06:53:07.346853','2025-07-18 06:53:07.347106'),('MigrateExerciseCertificateProviderDBUpdateSteps',1,'2025-07-18 06:53:07.347534','2025-07-18 06:53:07.347742');
/*!40000 ALTER TABLE `il_db_steps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_data`
--

DROP TABLE IF EXISTS `il_dcl_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_data` (
  `id` int NOT NULL DEFAULT '0',
  `is_online` tinyint DEFAULT NULL,
  `rating` tinyint DEFAULT NULL,
  `public_notes` tinyint DEFAULT NULL,
  `approval` tinyint DEFAULT NULL,
  `notification` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_data`
--

LOCK TABLES `il_dcl_data` WRITE;
/*!40000 ALTER TABLE `il_dcl_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_data_seq`
--

DROP TABLE IF EXISTS `il_dcl_data_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_data_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_data_seq`
--

LOCK TABLES `il_dcl_data_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_data_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_data_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_datatype`
--

DROP TABLE IF EXISTS `il_dcl_datatype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_datatype` (
  `id` int NOT NULL DEFAULT '0',
  `title` varchar(256) DEFAULT NULL,
  `storage_location` int NOT NULL DEFAULT '0',
  `sort` smallint DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_datatype`
--

LOCK TABLES `il_dcl_datatype` WRITE;
/*!40000 ALTER TABLE `il_dcl_datatype` DISABLE KEYS */;
INSERT INTO `il_dcl_datatype` VALUES (1,'number',2,20),(2,'text',1,0),(3,'reference',1,80),(4,'boolean',2,30),(5,'date',3,40),(7,'rating',0,100),(8,'ilias_reference',2,90),(9,'mob',2,60),(11,'formula',0,110),(14,'text_selection',1,10),(15,'date_selection',1,50),(16,'file',1,75),(17,'copy',1,85);
/*!40000 ALTER TABLE `il_dcl_datatype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_datatype_prop`
--

DROP TABLE IF EXISTS `il_dcl_datatype_prop`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_datatype_prop` (
  `id` int NOT NULL DEFAULT '0',
  `datatype_id` int DEFAULT NULL,
  `title` varchar(256) DEFAULT NULL,
  `inputformat` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_datatype_prop`
--

LOCK TABLES `il_dcl_datatype_prop` WRITE;
/*!40000 ALTER TABLE `il_dcl_datatype_prop` DISABLE KEYS */;
INSERT INTO `il_dcl_datatype_prop` VALUES (1,2,'length',1),(2,2,'regex',2),(3,3,'table_id',1),(4,2,'url',4),(5,2,'text_area',4),(6,3,'reference_link',4),(7,9,'width',1),(8,9,'height',1),(9,8,'learning_progress',4),(10,8,'ILIAS_reference_link',4),(11,3,'multiple_selection',4),(12,11,'expression',2),(13,8,'display_action_menu',4),(14,2,'link_detail_page',4),(15,9,'link_detail_page',4);
/*!40000 ALTER TABLE `il_dcl_datatype_prop` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_field`
--

DROP TABLE IF EXISTS `il_dcl_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_field` (
  `id` int NOT NULL DEFAULT '0',
  `table_id` int NOT NULL DEFAULT '0',
  `title` varchar(256) DEFAULT NULL,
  `description` longtext,
  `datatype_id` int NOT NULL DEFAULT '0',
  `is_unique` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`datatype_id`),
  KEY `i2_idx` (`table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_field`
--

LOCK TABLES `il_dcl_field` WRITE;
/*!40000 ALTER TABLE `il_dcl_field` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_field_prop`
--

DROP TABLE IF EXISTS `il_dcl_field_prop`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_field_prop` (
  `id` bigint NOT NULL DEFAULT '0',
  `field_id` bigint NOT NULL DEFAULT '0',
  `name` varchar(4000) NOT NULL DEFAULT '',
  `value` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`id`,`field_id`),
  KEY `i2_idx` (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_field_prop`
--

LOCK TABLES `il_dcl_field_prop` WRITE;
/*!40000 ALTER TABLE `il_dcl_field_prop` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_field_prop` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_field_prop_seq`
--

DROP TABLE IF EXISTS `il_dcl_field_prop_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_field_prop_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_field_prop_seq`
--

LOCK TABLES `il_dcl_field_prop_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_field_prop_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_field_prop_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_field_seq`
--

DROP TABLE IF EXISTS `il_dcl_field_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_field_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_field_seq`
--

LOCK TABLES `il_dcl_field_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_field_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_field_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_record`
--

DROP TABLE IF EXISTS `il_dcl_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_record` (
  `id` int NOT NULL DEFAULT '0',
  `table_id` int NOT NULL DEFAULT '0',
  `create_date` datetime DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `owner` int NOT NULL DEFAULT '0',
  `last_edit_by` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_record`
--

LOCK TABLES `il_dcl_record` WRITE;
/*!40000 ALTER TABLE `il_dcl_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_record_field`
--

DROP TABLE IF EXISTS `il_dcl_record_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_record_field` (
  `id` int NOT NULL DEFAULT '0',
  `record_id` int NOT NULL DEFAULT '0',
  `field_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`record_id`),
  KEY `i2_idx` (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_record_field`
--

LOCK TABLES `il_dcl_record_field` WRITE;
/*!40000 ALTER TABLE `il_dcl_record_field` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_record_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_record_field_seq`
--

DROP TABLE IF EXISTS `il_dcl_record_field_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_record_field_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_record_field_seq`
--

LOCK TABLES `il_dcl_record_field_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_record_field_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_record_field_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_record_seq`
--

DROP TABLE IF EXISTS `il_dcl_record_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_record_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_record_seq`
--

LOCK TABLES `il_dcl_record_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_record_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_record_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_sel_opts`
--

DROP TABLE IF EXISTS `il_dcl_sel_opts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_sel_opts` (
  `id` bigint NOT NULL,
  `field_id` bigint NOT NULL,
  `opt_id` bigint NOT NULL,
  `sorting` bigint NOT NULL,
  `value` varchar(4000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`field_id`),
  KEY `i2_idx` (`opt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_sel_opts`
--

LOCK TABLES `il_dcl_sel_opts` WRITE;
/*!40000 ALTER TABLE `il_dcl_sel_opts` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_sel_opts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_sel_opts_seq`
--

DROP TABLE IF EXISTS `il_dcl_sel_opts_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_sel_opts_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_sel_opts_seq`
--

LOCK TABLES `il_dcl_sel_opts_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_sel_opts_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_sel_opts_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc1_default`
--

DROP TABLE IF EXISTS `il_dcl_stloc1_default`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc1_default` (
  `id` int NOT NULL,
  `tview_set_id` int DEFAULT NULL,
  `value` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc1_default`
--

LOCK TABLES `il_dcl_stloc1_default` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc1_default` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc1_default` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc1_default_seq`
--

DROP TABLE IF EXISTS `il_dcl_stloc1_default_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc1_default_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc1_default_seq`
--

LOCK TABLES `il_dcl_stloc1_default_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc1_default_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc1_default_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc1_value`
--

DROP TABLE IF EXISTS `il_dcl_stloc1_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc1_value` (
  `id` int NOT NULL DEFAULT '0',
  `record_field_id` int NOT NULL DEFAULT '0',
  `value` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`record_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc1_value`
--

LOCK TABLES `il_dcl_stloc1_value` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc1_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc1_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc1_value_seq`
--

DROP TABLE IF EXISTS `il_dcl_stloc1_value_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc1_value_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc1_value_seq`
--

LOCK TABLES `il_dcl_stloc1_value_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc1_value_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc1_value_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc2_default`
--

DROP TABLE IF EXISTS `il_dcl_stloc2_default`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc2_default` (
  `id` int NOT NULL,
  `tview_set_id` int DEFAULT NULL,
  `value` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc2_default`
--

LOCK TABLES `il_dcl_stloc2_default` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc2_default` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc2_default` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc2_default_seq`
--

DROP TABLE IF EXISTS `il_dcl_stloc2_default_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc2_default_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc2_default_seq`
--

LOCK TABLES `il_dcl_stloc2_default_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc2_default_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc2_default_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc2_value`
--

DROP TABLE IF EXISTS `il_dcl_stloc2_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc2_value` (
  `id` int NOT NULL DEFAULT '0',
  `record_field_id` int NOT NULL DEFAULT '0',
  `value` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`record_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc2_value`
--

LOCK TABLES `il_dcl_stloc2_value` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc2_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc2_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc2_value_seq`
--

DROP TABLE IF EXISTS `il_dcl_stloc2_value_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc2_value_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc2_value_seq`
--

LOCK TABLES `il_dcl_stloc2_value_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc2_value_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc2_value_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc3_default`
--

DROP TABLE IF EXISTS `il_dcl_stloc3_default`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc3_default` (
  `id` int NOT NULL,
  `tview_set_id` int NOT NULL,
  `value` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc3_default`
--

LOCK TABLES `il_dcl_stloc3_default` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc3_default` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc3_default` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc3_default_seq`
--

DROP TABLE IF EXISTS `il_dcl_stloc3_default_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc3_default_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc3_default_seq`
--

LOCK TABLES `il_dcl_stloc3_default_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc3_default_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc3_default_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc3_value`
--

DROP TABLE IF EXISTS `il_dcl_stloc3_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc3_value` (
  `id` int NOT NULL DEFAULT '0',
  `record_field_id` int NOT NULL DEFAULT '0',
  `value` datetime DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`record_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc3_value`
--

LOCK TABLES `il_dcl_stloc3_value` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc3_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc3_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_stloc3_value_seq`
--

DROP TABLE IF EXISTS `il_dcl_stloc3_value_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_stloc3_value_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_stloc3_value_seq`
--

LOCK TABLES `il_dcl_stloc3_value_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_stloc3_value_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_stloc3_value_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_table`
--

DROP TABLE IF EXISTS `il_dcl_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_table` (
  `id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `title` varchar(256) DEFAULT NULL,
  `add_perm` tinyint NOT NULL DEFAULT '1',
  `edit_perm` tinyint NOT NULL DEFAULT '1',
  `delete_perm` tinyint NOT NULL DEFAULT '1',
  `edit_by_owner` tinyint NOT NULL DEFAULT '1',
  `limited` tinyint NOT NULL DEFAULT '0',
  `limit_start` datetime DEFAULT NULL,
  `limit_end` datetime DEFAULT NULL,
  `is_visible` tinyint NOT NULL DEFAULT '1',
  `export_enabled` tinyint DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `default_sort_field_id` varchar(16) NOT NULL DEFAULT '0',
  `default_sort_field_order` varchar(4) NOT NULL DEFAULT 'asc',
  `public_comments` int NOT NULL DEFAULT '0',
  `view_own_records_perm` int NOT NULL DEFAULT '0',
  `delete_by_owner` tinyint NOT NULL DEFAULT '0',
  `save_confirmation` tinyint NOT NULL DEFAULT '0',
  `import_enabled` tinyint NOT NULL DEFAULT '1',
  `table_order` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_table`
--

LOCK TABLES `il_dcl_table` WRITE;
/*!40000 ALTER TABLE `il_dcl_table` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_table` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_table_seq`
--

DROP TABLE IF EXISTS `il_dcl_table_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_table_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_table_seq`
--

LOCK TABLES `il_dcl_table_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_table_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_table_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_tableview`
--

DROP TABLE IF EXISTS `il_dcl_tableview`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_tableview` (
  `id` bigint NOT NULL DEFAULT '0',
  `table_id` bigint NOT NULL DEFAULT '0',
  `title` varchar(128) NOT NULL DEFAULT '',
  `roles` longtext,
  `description` varchar(128) NOT NULL DEFAULT '',
  `tableview_order` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `t1_idx` (`table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_tableview`
--

LOCK TABLES `il_dcl_tableview` WRITE;
/*!40000 ALTER TABLE `il_dcl_tableview` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_tableview` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_tableview_seq`
--

DROP TABLE IF EXISTS `il_dcl_tableview_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_tableview_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_tableview_seq`
--

LOCK TABLES `il_dcl_tableview_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_tableview_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_tableview_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_tfield_set`
--

DROP TABLE IF EXISTS `il_dcl_tfield_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_tfield_set` (
  `id` bigint NOT NULL DEFAULT '0',
  `table_id` bigint NOT NULL DEFAULT '0',
  `field` varchar(128) NOT NULL DEFAULT '',
  `field_order` bigint DEFAULT NULL,
  `exportable` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `t2_idx` (`table_id`,`field`),
  KEY `i3_idx` (`field`),
  KEY `i4_idx` (`table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_tfield_set`
--

LOCK TABLES `il_dcl_tfield_set` WRITE;
/*!40000 ALTER TABLE `il_dcl_tfield_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_tfield_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_tfield_set_seq`
--

DROP TABLE IF EXISTS `il_dcl_tfield_set_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_tfield_set_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_tfield_set_seq`
--

LOCK TABLES `il_dcl_tfield_set_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_tfield_set_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_tfield_set_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_tview_set`
--

DROP TABLE IF EXISTS `il_dcl_tview_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_tview_set` (
  `id` bigint NOT NULL DEFAULT '0',
  `tableview_id` bigint NOT NULL DEFAULT '0',
  `field` varchar(128) NOT NULL DEFAULT '',
  `visible` tinyint NOT NULL DEFAULT '0',
  `in_filter` tinyint NOT NULL DEFAULT '0',
  `filter_value` longtext,
  `filter_changeable` tinyint NOT NULL DEFAULT '0',
  `default_value` varchar(255) DEFAULT NULL,
  `required_create` tinyint NOT NULL DEFAULT '0',
  `locked_create` tinyint NOT NULL DEFAULT '0',
  `visible_create` tinyint NOT NULL DEFAULT '1',
  `visible_edit` tinyint NOT NULL DEFAULT '1',
  `required_edit` tinyint NOT NULL DEFAULT '0',
  `locked_edit` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`tableview_id`),
  KEY `i2_idx` (`field`),
  KEY `i3_idx` (`in_filter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_tview_set`
--

LOCK TABLES `il_dcl_tview_set` WRITE;
/*!40000 ALTER TABLE `il_dcl_tview_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_tview_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_tview_set_seq`
--

DROP TABLE IF EXISTS `il_dcl_tview_set_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_tview_set_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_tview_set_seq`
--

LOCK TABLES `il_dcl_tview_set_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_tview_set_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_tview_set_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_dcl_view_seq`
--

DROP TABLE IF EXISTS `il_dcl_view_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_dcl_view_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_dcl_view_seq`
--

LOCK TABLES `il_dcl_view_seq` WRITE;
/*!40000 ALTER TABLE `il_dcl_view_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_dcl_view_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_exc_team`
--

DROP TABLE IF EXISTS `il_exc_team`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_exc_team` (
  `id` int NOT NULL DEFAULT '0',
  `ass_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ass_id`,`user_id`),
  KEY `i1_idx` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_exc_team`
--

LOCK TABLES `il_exc_team` WRITE;
/*!40000 ALTER TABLE `il_exc_team` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_exc_team` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_exc_team_log`
--

DROP TABLE IF EXISTS `il_exc_team_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_exc_team_log` (
  `log_id` int NOT NULL DEFAULT '0',
  `team_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `details` varchar(500) DEFAULT NULL,
  `action` tinyint NOT NULL DEFAULT '0',
  `tstamp` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`log_id`),
  KEY `i1_idx` (`team_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_exc_team_log`
--

LOCK TABLES `il_exc_team_log` WRITE;
/*!40000 ALTER TABLE `il_exc_team_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_exc_team_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_exc_team_log_seq`
--

DROP TABLE IF EXISTS `il_exc_team_log_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_exc_team_log_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_exc_team_log_seq`
--

LOCK TABLES `il_exc_team_log_seq` WRITE;
/*!40000 ALTER TABLE `il_exc_team_log_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_exc_team_log_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_exc_team_seq`
--

DROP TABLE IF EXISTS `il_exc_team_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_exc_team_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_exc_team_seq`
--

LOCK TABLES `il_exc_team_seq` WRITE;
/*!40000 ALTER TABLE `il_exc_team_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_exc_team_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_external_feed_block`
--

DROP TABLE IF EXISTS `il_external_feed_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_external_feed_block` (
  `id` int NOT NULL DEFAULT '0',
  `feed_url` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_external_feed_block`
--

LOCK TABLES `il_external_feed_block` WRITE;
/*!40000 ALTER TABLE `il_external_feed_block` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_external_feed_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_external_feed_block_seq`
--

DROP TABLE IF EXISTS `il_external_feed_block_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_external_feed_block_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_external_feed_block_seq`
--

LOCK TABLES `il_external_feed_block_seq` WRITE;
/*!40000 ALTER TABLE `il_external_feed_block_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_external_feed_block_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_file_icon`
--

DROP TABLE IF EXISTS `il_file_icon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_file_icon` (
  `rid` varchar(64) NOT NULL DEFAULT '',
  `active` tinyint DEFAULT '0',
  `is_default_icon` tinyint DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_file_icon`
--

LOCK TABLES `il_file_icon` WRITE;
/*!40000 ALTER TABLE `il_file_icon` DISABLE KEYS */;
INSERT INTO `il_file_icon` VALUES ('985a74a9-9852-44f6-869f-ecc691f2ef3b',1,1),('733cdf8f-4405-40e4-8dd1-9832e4399cdd',1,1),('e0d14f9e-11d4-43b8-879a-e6827f29947f',1,1),('0dd1bf38-cd5f-4e41-a66c-537491a48c7f',1,1),('42198c75-b1ce-4325-8083-22f34c74d6a2',1,1),('e865fd84-c395-45c0-b183-51dc4b717fb0',1,1),('795bfcf2-4785-412e-9662-7e15b577e507',1,1),('4f6aae82-0ac7-48e0-9bf5-88088b2bc7da',1,1),('acd07d4c-c68d-4073-8822-200a96b1bd22',1,1),('54931c1f-2016-469e-9fa7-38310a0bb59b',1,1),('e117f0a6-1dc4-4b49-9824-fec19b12cf34',1,1),('15ed12e5-9887-4afa-a1a0-9db2ba1e2062',1,1),('b53f55e8-4129-4eb4-aee4-7fd0e76a5143',1,1),('032c84cd-ff86-4329-acb9-ac621466f8f9',1,1),('585bfe28-f063-4e99-af09-3251ed510154',1,1),('491be3c1-37de-4f36-a73d-f029f49f5fbe',1,1),('744d8677-181d-4f74-9a5b-3ba402ab4a24',1,1),('64153991-9fa6-4ad7-b30b-5934a3dc31b2',1,1),('b23cb8be-ebfa-4356-bd2a-ef38fc683297',1,1),('2d4bdf6a-b1cb-48c8-97ea-e80bc4f51e6d',1,1),('0fbc6388-6d90-4bfa-b9a6-58d793425454',1,1),('0894f32c-32be-45f6-9d8c-1e42dd4e0d3b',1,1),('3e5eb0c5-b332-46e0-be31-f731b049798f',1,1),('8ade78bb-960b-4d37-a2e5-8e4b0b6a38ff',1,1),('9c42f1e0-7df8-4539-9be6-8e71acd1a744',1,1),('0362da5a-83ee-46b2-b998-e05ab1b931dd',1,1);
/*!40000 ALTER TABLE `il_file_icon` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_file_icon_suffixes`
--

DROP TABLE IF EXISTS `il_file_icon_suffixes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_file_icon_suffixes` (
  `rid` varchar(64) NOT NULL DEFAULT '',
  `suffix` varchar(32) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_file_icon_suffixes`
--

LOCK TABLES `il_file_icon_suffixes` WRITE;
/*!40000 ALTER TABLE `il_file_icon_suffixes` DISABLE KEYS */;
INSERT INTO `il_file_icon_suffixes` VALUES ('985a74a9-9852-44f6-869f-ecc691f2ef3b','avi'),('733cdf8f-4405-40e4-8dd1-9832e4399cdd','bmp'),('e0d14f9e-11d4-43b8-879a-e6827f29947f','csv'),('0dd1bf38-cd5f-4e41-a66c-537491a48c7f','docx'),('42198c75-b1ce-4325-8083-22f34c74d6a2','flv'),('e865fd84-c395-45c0-b183-51dc4b717fb0','gif'),('795bfcf2-4785-412e-9662-7e15b577e507','ico'),('4f6aae82-0ac7-48e0-9bf5-88088b2bc7da','jpg'),('acd07d4c-c68d-4073-8822-200a96b1bd22','md'),('54931c1f-2016-469e-9fa7-38310a0bb59b','mov'),('e117f0a6-1dc4-4b49-9824-fec19b12cf34','mp3'),('15ed12e5-9887-4afa-a1a0-9db2ba1e2062','mp4'),('b53f55e8-4129-4eb4-aee4-7fd0e76a5143','odp'),('032c84cd-ff86-4329-acb9-ac621466f8f9','ods'),('585bfe28-f063-4e99-af09-3251ed510154','odt'),('491be3c1-37de-4f36-a73d-f029f49f5fbe','pdf'),('744d8677-181d-4f74-9a5b-3ba402ab4a24','png'),('64153991-9fa6-4ad7-b30b-5934a3dc31b2','pptx'),('b23cb8be-ebfa-4356-bd2a-ef38fc683297','rtf'),('2d4bdf6a-b1cb-48c8-97ea-e80bc4f51e6d','svg'),('0fbc6388-6d90-4bfa-b9a6-58d793425454','tiff'),('0894f32c-32be-45f6-9d8c-1e42dd4e0d3b','txt'),('3e5eb0c5-b332-46e0-be31-f731b049798f','wav'),('8ade78bb-960b-4d37-a2e5-8e4b0b6a38ff','wma'),('9c42f1e0-7df8-4539-9be6-8e71acd1a744','xlsx'),('0362da5a-83ee-46b2-b998-e05ab1b931dd','xml');
/*!40000 ALTER TABLE `il_file_icon_suffixes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_gc_memcache_server`
--

DROP TABLE IF EXISTS `il_gc_memcache_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_gc_memcache_server` (
  `id` bigint NOT NULL DEFAULT '0',
  `status` tinyint DEFAULT NULL,
  `host` varchar(256) DEFAULT NULL,
  `port` bigint DEFAULT NULL,
  `weight` smallint DEFAULT NULL,
  `flush_needed` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_gc_memcache_server`
--

LOCK TABLES `il_gc_memcache_server` WRITE;
/*!40000 ALTER TABLE `il_gc_memcache_server` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_gc_memcache_server` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_gc_memcache_server_seq`
--

DROP TABLE IF EXISTS `il_gc_memcache_server_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_gc_memcache_server_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_gc_memcache_server_seq`
--

LOCK TABLES `il_gc_memcache_server_seq` WRITE;
/*!40000 ALTER TABLE `il_gc_memcache_server_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_gc_memcache_server_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_html_block`
--

DROP TABLE IF EXISTS `il_html_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_html_block` (
  `id` int NOT NULL DEFAULT '0',
  `content` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_html_block`
--

LOCK TABLES `il_html_block` WRITE;
/*!40000 ALTER TABLE `il_html_block` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_html_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_md_cpr_selections`
--

DROP TABLE IF EXISTS `il_md_cpr_selections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_md_cpr_selections` (
  `entry_id` int NOT NULL DEFAULT '0',
  `title` varchar(128) DEFAULT NULL,
  `description` longtext,
  `copyright` longtext,
  `language` char(2) DEFAULT NULL,
  `costs` tinyint NOT NULL DEFAULT '0',
  `cpr_restrictions` tinyint NOT NULL DEFAULT '1',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `outdated` tinyint NOT NULL DEFAULT '0',
  `position` tinyint NOT NULL DEFAULT '0',
  `full_name` longtext,
  `link` longtext,
  `image_link` longtext,
  `alt_text` longtext,
  `migrated` int DEFAULT '0',
  `image_file` longtext,
  PRIMARY KEY (`entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_md_cpr_selections`
--

LOCK TABLES `il_md_cpr_selections` WRITE;
/*!40000 ALTER TABLE `il_md_cpr_selections` DISABLE KEYS */;
INSERT INTO `il_md_cpr_selections` VALUES (1,'Attribution Non-commercial No Derivatives (by-nc-nd)','Creative Commons License','<a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-nd/4.0/\"><img alt=\"Creative Commons License\" style=\"border-width:0\" src=\"https://i.creativecommons.org/l/by-nc-nd/4.0/88x31.png\" /></a><br />This work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-nd/4.0/\">Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License</a>.','en',0,1,0,0,0,NULL,NULL,NULL,NULL,0,NULL),(2,'Attribution Non-commercial Share Alike (by-nc-sa)','Creative Commons License','<a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/4.0/\"><img alt=\"Creative Commons License\" style=\"border-width:0\" src=\"https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png\" /></a><br />This work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/4.0/\">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>.','en',0,1,0,0,0,NULL,NULL,NULL,NULL,0,NULL),(3,'Attribution Non-commercial (by-nc)','Creative Commons License','<a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc/4.0/\"><img alt=\"Creative Commons License\" style=\"border-width:0\" src=\"https://i.creativecommons.org/l/by-nc/4.0/88x31.png\" /></a><br />This work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc/4.0/\">Creative Commons Attribution-NonCommercial 4.0 International License</a>.','en',0,1,0,0,0,NULL,NULL,NULL,NULL,0,NULL),(4,'Attribution No Derivatives (by-nd)','Creative Commons License','<a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nd/4.0/\"><img alt=\"Creative Commons License\" style=\"border-width:0\" src=\"https://i.creativecommons.org/l/by-nd/4.0/88x31.png\" /></a><br />This work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nd/4.0/\">Creative Commons Attribution-NoDerivatives 4.0 International License</a>.','en',0,1,0,0,0,NULL,NULL,NULL,NULL,0,NULL),(5,'Attribution Share Alike (by-sa)','Creative Commons License','<a rel=\"license\" href=\"http://creativecommons.org/licenses/by-sa/4.0/\"><img alt=\"Creative Commons License\" style=\"border-width:0\" src=\"https://i.creativecommons.org/l/by-sa/4.0/88x31.png\" /></a><br />This work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-sa/4.0/\">Creative Commons Attribution-ShareAlike 4.0 International License</a>.','en',0,1,0,0,0,NULL,NULL,NULL,NULL,0,NULL),(6,'Attribution (by)','Creative Commons License','<a rel=\"license\" href=\"http://creativecommons.org/licenses/by/4.0/\"><img alt=\"Creative Commons License\" style=\"border-width:0\" src=\"https://i.creativecommons.org/l/by/4.0/88x31.png\" /></a><br />This work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by/4.0/\">Creative Commons Attribution 4.0 International License</a>.','en',0,1,0,0,0,NULL,NULL,NULL,NULL,0,NULL),(7,'All rights reserved','The copyright holder reserves, or holds for their own use, all the rights provided by copyright law.','This work has all rights reserved by the owner.','en',0,1,1,0,0,NULL,NULL,NULL,NULL,0,NULL),(8,'Public Domain','Creative work to which no exclusive intellectual property rights apply.',NULL,NULL,0,1,0,0,1,'Public Domain','http://creativecommons.org/publicdomain/zero/1.0/','https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg','CC0',1,'');
/*!40000 ALTER TABLE `il_md_cpr_selections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_md_cpr_selections_seq`
--

DROP TABLE IF EXISTS `il_md_cpr_selections_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_md_cpr_selections_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_md_cpr_selections_seq`
--

LOCK TABLES `il_md_cpr_selections_seq` WRITE;
/*!40000 ALTER TABLE `il_md_cpr_selections_seq` DISABLE KEYS */;
INSERT INTO `il_md_cpr_selections_seq` VALUES (9);
/*!40000 ALTER TABLE `il_md_cpr_selections_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_md_vocab_contr`
--

DROP TABLE IF EXISTS `il_md_vocab_contr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_md_vocab_contr` (
  `id` int NOT NULL,
  `slot` varchar(64) NOT NULL,
  `source` varchar(64) NOT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `custom_input` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_md_vocab_contr`
--

LOCK TABLES `il_md_vocab_contr` WRITE;
/*!40000 ALTER TABLE `il_md_vocab_contr` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_md_vocab_contr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_md_vocab_contr_seq`
--

DROP TABLE IF EXISTS `il_md_vocab_contr_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_md_vocab_contr_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_md_vocab_contr_seq`
--

LOCK TABLES `il_md_vocab_contr_seq` WRITE;
/*!40000 ALTER TABLE `il_md_vocab_contr_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_md_vocab_contr_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_md_vocab_contr_vals`
--

DROP TABLE IF EXISTS `il_md_vocab_contr_vals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_md_vocab_contr_vals` (
  `vocab_id` int NOT NULL,
  `value` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  PRIMARY KEY (`vocab_id`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_md_vocab_contr_vals`
--

LOCK TABLES `il_md_vocab_contr_vals` WRITE;
/*!40000 ALTER TABLE `il_md_vocab_contr_vals` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_md_vocab_contr_vals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_md_vocab_inactive`
--

DROP TABLE IF EXISTS `il_md_vocab_inactive`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_md_vocab_inactive` (
  `slot` varchar(64) NOT NULL,
  PRIMARY KEY (`slot`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_md_vocab_inactive`
--

LOCK TABLES `il_md_vocab_inactive` WRITE;
/*!40000 ALTER TABLE `il_md_vocab_inactive` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_md_vocab_inactive` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_media_cast_data`
--

DROP TABLE IF EXISTS `il_media_cast_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_media_cast_data` (
  `id` int NOT NULL DEFAULT '0',
  `is_online` tinyint DEFAULT '0',
  `public_files` tinyint DEFAULT '0',
  `downloadable` tinyint DEFAULT '0',
  `def_access` tinyint DEFAULT '0',
  `sortmode` tinyint DEFAULT '3',
  `viewmode` varchar(20) DEFAULT NULL,
  `autoplaymode` tinyint NOT NULL DEFAULT '0',
  `nr_initial_videos` tinyint NOT NULL DEFAULT '0',
  `new_items_in_lp` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_media_cast_data`
--

LOCK TABLES `il_media_cast_data` WRITE;
/*!40000 ALTER TABLE `il_media_cast_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_media_cast_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_media_cast_data_ord`
--

DROP TABLE IF EXISTS `il_media_cast_data_ord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_media_cast_data_ord` (
  `obj_id` int NOT NULL DEFAULT '0',
  `item_id` int NOT NULL DEFAULT '0',
  `pos` mediumint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_media_cast_data_ord`
--

LOCK TABLES `il_media_cast_data_ord` WRITE;
/*!40000 ALTER TABLE `il_media_cast_data_ord` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_media_cast_data_ord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_annotation`
--

DROP TABLE IF EXISTS `il_meta_annotation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_annotation` (
  `meta_annotation_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `entity` longtext,
  `a_date` longtext,
  `description` longtext,
  `description_language` char(2) DEFAULT NULL,
  `a_date_descr` longtext,
  `date_descr_lang` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`meta_annotation_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_annotation`
--

LOCK TABLES `il_meta_annotation` WRITE;
/*!40000 ALTER TABLE `il_meta_annotation` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_annotation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_annotation_seq`
--

DROP TABLE IF EXISTS `il_meta_annotation_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_annotation_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_annotation_seq`
--

LOCK TABLES `il_meta_annotation_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_annotation_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_annotation_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_classification`
--

DROP TABLE IF EXISTS `il_meta_classification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_classification` (
  `meta_classification_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `purpose` varchar(255) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `description_language` char(2) DEFAULT NULL,
  `purpose_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_classification_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_classification`
--

LOCK TABLES `il_meta_classification` WRITE;
/*!40000 ALTER TABLE `il_meta_classification` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_classification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_classification_seq`
--

DROP TABLE IF EXISTS `il_meta_classification_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_classification_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_classification_seq`
--

LOCK TABLES `il_meta_classification_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_classification_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_classification_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_context`
--

DROP TABLE IF EXISTS `il_meta_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_context` (
  `meta_context_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `context` varchar(255) DEFAULT NULL,
  `context_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_context`
--

LOCK TABLES `il_meta_context` WRITE;
/*!40000 ALTER TABLE `il_meta_context` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_context` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_context_seq`
--

DROP TABLE IF EXISTS `il_meta_context_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_context_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_context_seq`
--

LOCK TABLES `il_meta_context_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_context_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_context_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_contribute`
--

DROP TABLE IF EXISTS `il_meta_contribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_contribute` (
  `meta_contribute_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(32) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `role` varchar(255) DEFAULT NULL,
  `c_date` varchar(4000) DEFAULT NULL,
  `c_date_descr` longtext,
  `descr_lang` varchar(2) DEFAULT NULL,
  `role_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_contribute_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_contribute`
--

LOCK TABLES `il_meta_contribute` WRITE;
/*!40000 ALTER TABLE `il_meta_contribute` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_contribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_contribute_seq`
--

DROP TABLE IF EXISTS `il_meta_contribute_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_contribute_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_contribute_seq`
--

LOCK TABLES `il_meta_contribute_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_contribute_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_contribute_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_coverage`
--

DROP TABLE IF EXISTS `il_meta_coverage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_coverage` (
  `meta_coverage_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `coverage` varchar(4000) DEFAULT NULL,
  `coverage_language` char(2) DEFAULT NULL,
  PRIMARY KEY (`meta_coverage_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_coverage`
--

LOCK TABLES `il_meta_coverage` WRITE;
/*!40000 ALTER TABLE `il_meta_coverage` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_coverage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_coverage_seq`
--

DROP TABLE IF EXISTS `il_meta_coverage_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_coverage_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_coverage_seq`
--

LOCK TABLES `il_meta_coverage_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_coverage_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_coverage_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_description`
--

DROP TABLE IF EXISTS `il_meta_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_description` (
  `meta_description_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `description` longtext,
  `description_language` char(2) DEFAULT NULL,
  PRIMARY KEY (`meta_description_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_description`
--

LOCK TABLES `il_meta_description` WRITE;
/*!40000 ALTER TABLE `il_meta_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_description_seq`
--

DROP TABLE IF EXISTS `il_meta_description_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_description_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_description_seq`
--

LOCK TABLES `il_meta_description_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_description_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_description_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_educational`
--

DROP TABLE IF EXISTS `il_meta_educational`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_educational` (
  `meta_educational_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `interactivity_type` varchar(255) DEFAULT NULL,
  `learning_resource_type` varchar(32) DEFAULT NULL,
  `interactivity_level` varchar(255) DEFAULT NULL,
  `semantic_density` varchar(255) DEFAULT NULL,
  `intended_end_user_role` varchar(16) DEFAULT NULL,
  `context` varchar(16) DEFAULT NULL,
  `difficulty` varchar(255) DEFAULT NULL,
  `typical_learning_time` varchar(4000) DEFAULT NULL,
  `tlt_descr` longtext,
  `tlt_descr_lang` varchar(2) DEFAULT NULL,
  `interactivity_type_src` varchar(64) NOT NULL DEFAULT '',
  `interactivity_level_src` varchar(64) NOT NULL DEFAULT '',
  `semantic_density_src` varchar(64) NOT NULL DEFAULT '',
  `difficulty_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_educational_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_educational`
--

LOCK TABLES `il_meta_educational` WRITE;
/*!40000 ALTER TABLE `il_meta_educational` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_educational` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_educational_seq`
--

DROP TABLE IF EXISTS `il_meta_educational_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_educational_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_educational_seq`
--

LOCK TABLES `il_meta_educational_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_educational_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_educational_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_end_usr_role`
--

DROP TABLE IF EXISTS `il_meta_end_usr_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_end_usr_role` (
  `meta_end_usr_role_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `intended_end_user_role` varchar(255) DEFAULT NULL,
  `intended_end_user_role_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_end_usr_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_end_usr_role`
--

LOCK TABLES `il_meta_end_usr_role` WRITE;
/*!40000 ALTER TABLE `il_meta_end_usr_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_end_usr_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_end_usr_role_seq`
--

DROP TABLE IF EXISTS `il_meta_end_usr_role_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_end_usr_role_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_end_usr_role_seq`
--

LOCK TABLES `il_meta_end_usr_role_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_end_usr_role_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_end_usr_role_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_entity`
--

DROP TABLE IF EXISTS `il_meta_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_entity` (
  `meta_entity_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `entity` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`meta_entity_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_entity`
--

LOCK TABLES `il_meta_entity` WRITE;
/*!40000 ALTER TABLE `il_meta_entity` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_entity_seq`
--

DROP TABLE IF EXISTS `il_meta_entity_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_entity_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_entity_seq`
--

LOCK TABLES `il_meta_entity_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_entity_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_entity_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_format`
--

DROP TABLE IF EXISTS `il_meta_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_format` (
  `meta_format_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`meta_format_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`),
  KEY `i2_idx` (`format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_format`
--

LOCK TABLES `il_meta_format` WRITE;
/*!40000 ALTER TABLE `il_meta_format` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_format_seq`
--

DROP TABLE IF EXISTS `il_meta_format_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_format_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_format_seq`
--

LOCK TABLES `il_meta_format_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_format_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_format_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_general`
--

DROP TABLE IF EXISTS `il_meta_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_general` (
  `meta_general_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `general_structure` varchar(255) DEFAULT NULL,
  `title` varchar(4000) DEFAULT NULL,
  `title_language` char(2) DEFAULT NULL,
  `coverage` varchar(4000) DEFAULT NULL,
  `coverage_language` char(2) DEFAULT NULL,
  `general_aggl` varchar(255) DEFAULT NULL,
  `general_structure_src` varchar(64) NOT NULL DEFAULT '',
  `general_aggl_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_general_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_general`
--

LOCK TABLES `il_meta_general` WRITE;
/*!40000 ALTER TABLE `il_meta_general` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_general_seq`
--

DROP TABLE IF EXISTS `il_meta_general_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_general_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_general_seq`
--

LOCK TABLES `il_meta_general_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_general_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_general_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_identifier`
--

DROP TABLE IF EXISTS `il_meta_identifier`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_identifier` (
  `meta_identifier_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `catalog` varchar(4000) DEFAULT NULL,
  `entry` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`meta_identifier_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_identifier`
--

LOCK TABLES `il_meta_identifier` WRITE;
/*!40000 ALTER TABLE `il_meta_identifier` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_identifier` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_identifier_`
--

DROP TABLE IF EXISTS `il_meta_identifier_`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_identifier_` (
  `meta_identifier__id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `catalog` varchar(4000) DEFAULT NULL,
  `entry` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`meta_identifier__id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_identifier_`
--

LOCK TABLES `il_meta_identifier_` WRITE;
/*!40000 ALTER TABLE `il_meta_identifier_` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_identifier_` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_identifier__seq`
--

DROP TABLE IF EXISTS `il_meta_identifier__seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_identifier__seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_identifier__seq`
--

LOCK TABLES `il_meta_identifier__seq` WRITE;
/*!40000 ALTER TABLE `il_meta_identifier__seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_identifier__seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_identifier_seq`
--

DROP TABLE IF EXISTS `il_meta_identifier_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_identifier_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_identifier_seq`
--

LOCK TABLES `il_meta_identifier_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_identifier_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_identifier_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_keyword`
--

DROP TABLE IF EXISTS `il_meta_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_keyword` (
  `meta_keyword_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(32) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `keyword` varchar(4000) DEFAULT NULL,
  `keyword_language` char(2) DEFAULT NULL,
  PRIMARY KEY (`meta_keyword_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_keyword`
--

LOCK TABLES `il_meta_keyword` WRITE;
/*!40000 ALTER TABLE `il_meta_keyword` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_keyword_seq`
--

DROP TABLE IF EXISTS `il_meta_keyword_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_keyword_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_keyword_seq`
--

LOCK TABLES `il_meta_keyword_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_keyword_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_keyword_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_language`
--

DROP TABLE IF EXISTS `il_meta_language`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_language` (
  `meta_language_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` char(6) DEFAULT NULL,
  `parent_type` char(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `language` char(2) DEFAULT NULL,
  PRIMARY KEY (`meta_language_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_language`
--

LOCK TABLES `il_meta_language` WRITE;
/*!40000 ALTER TABLE `il_meta_language` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_language` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_language_seq`
--

DROP TABLE IF EXISTS `il_meta_language_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_language_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_language_seq`
--

LOCK TABLES `il_meta_language_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_language_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_language_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_lifecycle`
--

DROP TABLE IF EXISTS `il_meta_lifecycle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_lifecycle` (
  `meta_lifecycle_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `lifecycle_status` varchar(255) DEFAULT NULL,
  `meta_version` varchar(4000) DEFAULT NULL,
  `version_language` char(2) DEFAULT NULL,
  `lifecycle_status_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_lifecycle_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_lifecycle`
--

LOCK TABLES `il_meta_lifecycle` WRITE;
/*!40000 ALTER TABLE `il_meta_lifecycle` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_lifecycle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_lifecycle_seq`
--

DROP TABLE IF EXISTS `il_meta_lifecycle_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_lifecycle_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_lifecycle_seq`
--

LOCK TABLES `il_meta_lifecycle_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_lifecycle_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_lifecycle_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_location`
--

DROP TABLE IF EXISTS `il_meta_location`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_location` (
  `meta_location_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `location` varchar(4000) DEFAULT NULL,
  `location_type` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`meta_location_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_location`
--

LOCK TABLES `il_meta_location` WRITE;
/*!40000 ALTER TABLE `il_meta_location` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_location` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_location_seq`
--

DROP TABLE IF EXISTS `il_meta_location_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_location_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_location_seq`
--

LOCK TABLES `il_meta_location_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_location_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_location_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_lr_type`
--

DROP TABLE IF EXISTS `il_meta_lr_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_lr_type` (
  `meta_lr_type_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `learning_resource_type` varchar(255) DEFAULT NULL,
  `learning_resource_type_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_lr_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_lr_type`
--

LOCK TABLES `il_meta_lr_type` WRITE;
/*!40000 ALTER TABLE `il_meta_lr_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_lr_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_lr_type_seq`
--

DROP TABLE IF EXISTS `il_meta_lr_type_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_lr_type_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_lr_type_seq`
--

LOCK TABLES `il_meta_lr_type_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_lr_type_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_lr_type_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_meta_data`
--

DROP TABLE IF EXISTS `il_meta_meta_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_meta_data` (
  `meta_meta_data_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` char(6) DEFAULT NULL,
  `meta_data_scheme` char(16) DEFAULT NULL,
  `language` char(2) DEFAULT NULL,
  PRIMARY KEY (`meta_meta_data_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_meta_data`
--

LOCK TABLES `il_meta_meta_data` WRITE;
/*!40000 ALTER TABLE `il_meta_meta_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_meta_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_meta_data_seq`
--

DROP TABLE IF EXISTS `il_meta_meta_data_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_meta_data_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_meta_data_seq`
--

LOCK TABLES `il_meta_meta_data_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_meta_data_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_meta_data_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_meta_schema`
--

DROP TABLE IF EXISTS `il_meta_meta_schema`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_meta_schema` (
  `meta_meta_schema_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `meta_data_schema` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`meta_meta_schema_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_meta_schema`
--

LOCK TABLES `il_meta_meta_schema` WRITE;
/*!40000 ALTER TABLE `il_meta_meta_schema` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_meta_schema` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_meta_schema_seq`
--

DROP TABLE IF EXISTS `il_meta_meta_schema_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_meta_schema_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_meta_schema_seq`
--

LOCK TABLES `il_meta_meta_schema_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_meta_schema_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_meta_schema_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_oer_exposed`
--

DROP TABLE IF EXISTS `il_meta_oer_exposed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_oer_exposed` (
  `obj_id` int NOT NULL,
  `identifier` varchar(64) NOT NULL,
  `datestamp` bigint NOT NULL,
  `metadata` longtext NOT NULL,
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_oer_exposed`
--

LOCK TABLES `il_meta_oer_exposed` WRITE;
/*!40000 ALTER TABLE `il_meta_oer_exposed` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_oer_exposed` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_oer_stat`
--

DROP TABLE IF EXISTS `il_meta_oer_stat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_oer_stat` (
  `obj_id` int NOT NULL,
  `href_id` int NOT NULL,
  `blocked` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_oer_stat`
--

LOCK TABLES `il_meta_oer_stat` WRITE;
/*!40000 ALTER TABLE `il_meta_oer_stat` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_oer_stat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_or_composite`
--

DROP TABLE IF EXISTS `il_meta_or_composite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_or_composite` (
  `meta_or_composite_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `min_version` varchar(255) DEFAULT NULL,
  `max_version` varchar(255) DEFAULT NULL,
  `type_src` varchar(64) NOT NULL DEFAULT '',
  `name_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_or_composite_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_or_composite`
--

LOCK TABLES `il_meta_or_composite` WRITE;
/*!40000 ALTER TABLE `il_meta_or_composite` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_or_composite` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_or_composite_seq`
--

DROP TABLE IF EXISTS `il_meta_or_composite_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_or_composite_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_or_composite_seq`
--

LOCK TABLES `il_meta_or_composite_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_or_composite_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_or_composite_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_relation`
--

DROP TABLE IF EXISTS `il_meta_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_relation` (
  `meta_relation_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` char(6) DEFAULT NULL,
  `kind` char(255) DEFAULT NULL,
  `kind_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_relation_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_relation`
--

LOCK TABLES `il_meta_relation` WRITE;
/*!40000 ALTER TABLE `il_meta_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_relation_seq`
--

DROP TABLE IF EXISTS `il_meta_relation_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_relation_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_relation_seq`
--

LOCK TABLES `il_meta_relation_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_relation_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_relation_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_requirement`
--

DROP TABLE IF EXISTS `il_meta_requirement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_requirement` (
  `meta_requirement_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `operating_system_name` varchar(16) DEFAULT NULL,
  `os_min_version` char(255) DEFAULT NULL,
  `os_max_version` char(255) DEFAULT NULL,
  `browser_name` varchar(32) DEFAULT NULL,
  `browser_minimum_version` char(255) DEFAULT NULL,
  `browser_maximum_version` char(255) DEFAULT NULL,
  `or_composite_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`meta_requirement_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_requirement`
--

LOCK TABLES `il_meta_requirement` WRITE;
/*!40000 ALTER TABLE `il_meta_requirement` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_requirement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_requirement_seq`
--

DROP TABLE IF EXISTS `il_meta_requirement_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_requirement_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_requirement_seq`
--

LOCK TABLES `il_meta_requirement_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_requirement_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_requirement_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_rights`
--

DROP TABLE IF EXISTS `il_meta_rights`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_rights` (
  `meta_rights_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `costs` char(255) DEFAULT NULL,
  `cpr_and_or` char(255) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `description_language` char(2) DEFAULT NULL,
  `costs_src` varchar(64) NOT NULL DEFAULT '',
  `cpr_and_or_src` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`meta_rights_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_rights`
--

LOCK TABLES `il_meta_rights` WRITE;
/*!40000 ALTER TABLE `il_meta_rights` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_rights` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_rights_seq`
--

DROP TABLE IF EXISTS `il_meta_rights_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_rights_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_rights_seq`
--

LOCK TABLES `il_meta_rights_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_rights_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_rights_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_tar`
--

DROP TABLE IF EXISTS `il_meta_tar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_tar` (
  `meta_tar_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(16) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `typical_age_range` varchar(4000) DEFAULT NULL,
  `tar_language` char(2) DEFAULT NULL,
  `tar_min` char(2) DEFAULT NULL,
  `tar_max` char(2) DEFAULT NULL,
  PRIMARY KEY (`meta_tar_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_tar`
--

LOCK TABLES `il_meta_tar` WRITE;
/*!40000 ALTER TABLE `il_meta_tar` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_tar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_tar_seq`
--

DROP TABLE IF EXISTS `il_meta_tar_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_tar_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_tar_seq`
--

LOCK TABLES `il_meta_tar_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_tar_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_tar_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_taxon`
--

DROP TABLE IF EXISTS `il_meta_taxon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_taxon` (
  `meta_taxon_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(32) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `taxon` varchar(4000) DEFAULT NULL,
  `taxon_language` char(2) DEFAULT NULL,
  `taxon_id` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`meta_taxon_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_taxon`
--

LOCK TABLES `il_meta_taxon` WRITE;
/*!40000 ALTER TABLE `il_meta_taxon` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_taxon` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_taxon_path`
--

DROP TABLE IF EXISTS `il_meta_taxon_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_taxon_path` (
  `meta_taxon_path_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `parent_type` varchar(32) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `source` varchar(4000) DEFAULT NULL,
  `source_language` char(2) DEFAULT NULL,
  PRIMARY KEY (`meta_taxon_path_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_taxon_path`
--

LOCK TABLES `il_meta_taxon_path` WRITE;
/*!40000 ALTER TABLE `il_meta_taxon_path` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_taxon_path` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_taxon_path_seq`
--

DROP TABLE IF EXISTS `il_meta_taxon_path_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_taxon_path_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_taxon_path_seq`
--

LOCK TABLES `il_meta_taxon_path_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_taxon_path_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_taxon_path_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_taxon_seq`
--

DROP TABLE IF EXISTS `il_meta_taxon_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_taxon_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_taxon_seq`
--

LOCK TABLES `il_meta_taxon_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_taxon_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_taxon_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_technical`
--

DROP TABLE IF EXISTS `il_meta_technical`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_technical` (
  `meta_technical_id` int NOT NULL DEFAULT '0',
  `rbac_id` int DEFAULT NULL,
  `obj_id` int DEFAULT NULL,
  `obj_type` varchar(6) DEFAULT NULL,
  `t_size` varchar(4000) DEFAULT NULL,
  `ir` varchar(4000) DEFAULT NULL,
  `ir_language` char(2) DEFAULT NULL,
  `opr` varchar(4000) DEFAULT NULL,
  `opr_language` char(2) DEFAULT NULL,
  `duration` varchar(4000) DEFAULT NULL,
  `duration_descr` longtext,
  `duration_descr_lang` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`meta_technical_id`),
  KEY `i1_idx` (`rbac_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_technical`
--

LOCK TABLES `il_meta_technical` WRITE;
/*!40000 ALTER TABLE `il_meta_technical` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_technical` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_meta_technical_seq`
--

DROP TABLE IF EXISTS `il_meta_technical_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_meta_technical_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_meta_technical_seq`
--

LOCK TABLES `il_meta_technical_seq` WRITE;
/*!40000 ALTER TABLE `il_meta_technical_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_meta_technical_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_mm_actions`
--

DROP TABLE IF EXISTS `il_mm_actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_mm_actions` (
  `identification` varchar(255) NOT NULL,
  `action` varchar(4000) DEFAULT NULL,
  `external` tinyint DEFAULT NULL,
  PRIMARY KEY (`identification`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_mm_actions`
--

LOCK TABLES `il_mm_actions` WRITE;
/*!40000 ALTER TABLE `il_mm_actions` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_mm_actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_mm_custom_items`
--

DROP TABLE IF EXISTS `il_mm_custom_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_mm_custom_items` (
  `identifier` varchar(255) NOT NULL,
  `type` varchar(128) DEFAULT NULL,
  `action` varchar(4000) DEFAULT NULL,
  `top_item` tinyint DEFAULT NULL,
  `default_title` varchar(4000) DEFAULT NULL,
  `role_based_visibility` tinyint DEFAULT '0',
  `global_role_ids` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_mm_custom_items`
--

LOCK TABLES `il_mm_custom_items` WRITE;
/*!40000 ALTER TABLE `il_mm_custom_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_mm_custom_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_mm_items`
--

DROP TABLE IF EXISTS `il_mm_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_mm_items` (
  `identification` varchar(255) NOT NULL DEFAULT '',
  `active` tinyint DEFAULT NULL,
  `position` int DEFAULT NULL,
  `parent_identification` varchar(255) DEFAULT NULL,
  `icon_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`identification`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_mm_items`
--

LOCK TABLES `il_mm_items` WRITE;
/*!40000 ALTER TABLE `il_mm_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_mm_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_mm_translation`
--

DROP TABLE IF EXISTS `il_mm_translation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_mm_translation` (
  `id` varchar(255) NOT NULL,
  `identification` varchar(255) DEFAULT NULL,
  `translation` varchar(4000) DEFAULT NULL,
  `language_key` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_mm_translation`
--

LOCK TABLES `il_mm_translation` WRITE;
/*!40000 ALTER TABLE `il_mm_translation` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_mm_translation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_new_item_grp`
--

DROP TABLE IF EXISTS `il_new_item_grp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_new_item_grp` (
  `id` int NOT NULL DEFAULT '0',
  `titles` varchar(1000) DEFAULT NULL,
  `pos` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_new_item_grp`
--

LOCK TABLES `il_new_item_grp` WRITE;
/*!40000 ALTER TABLE `il_new_item_grp` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_new_item_grp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_new_item_grp_seq`
--

DROP TABLE IF EXISTS `il_new_item_grp_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_new_item_grp_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_new_item_grp_seq`
--

LOCK TABLES `il_new_item_grp_seq` WRITE;
/*!40000 ALTER TABLE `il_new_item_grp_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_new_item_grp_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_news_item`
--

DROP TABLE IF EXISTS `il_news_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_news_item` (
  `id` int NOT NULL DEFAULT '0',
  `priority` int DEFAULT '1',
  `title` varchar(200) DEFAULT NULL,
  `content` longtext,
  `context_obj_id` int DEFAULT NULL,
  `context_obj_type` varchar(10) DEFAULT NULL,
  `context_sub_obj_id` int DEFAULT NULL,
  `context_sub_obj_type` varchar(10) DEFAULT NULL,
  `content_type` char(5) DEFAULT 'text',
  `creation_date` datetime DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `visibility` char(6) DEFAULT 'users',
  `content_long` longtext,
  `content_is_lang_var` tinyint DEFAULT '0',
  `mob_id` int DEFAULT NULL,
  `playtime` varchar(8) DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `content_text_is_lang_var` tinyint NOT NULL DEFAULT '0',
  `mob_cnt_download` int NOT NULL DEFAULT '0',
  `mob_cnt_play` int NOT NULL DEFAULT '0',
  `content_html` tinyint NOT NULL DEFAULT '0',
  `update_user_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`context_obj_id`),
  KEY `i2_idx` (`creation_date`),
  KEY `mo_idx` (`mob_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_news_item`
--

LOCK TABLES `il_news_item` WRITE;
/*!40000 ALTER TABLE `il_news_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_news_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_news_item_seq`
--

DROP TABLE IF EXISTS `il_news_item_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_news_item_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_news_item_seq`
--

LOCK TABLES `il_news_item_seq` WRITE;
/*!40000 ALTER TABLE `il_news_item_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_news_item_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_news_read`
--

DROP TABLE IF EXISTS `il_news_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_news_read` (
  `user_id` int NOT NULL DEFAULT '0',
  `news_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`news_id`),
  KEY `i1_idx` (`user_id`),
  KEY `i2_idx` (`news_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_news_read`
--

LOCK TABLES `il_news_read` WRITE;
/*!40000 ALTER TABLE `il_news_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_news_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_news_subscription`
--

DROP TABLE IF EXISTS `il_news_subscription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_news_subscription` (
  `user_id` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`ref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_news_subscription`
--

LOCK TABLES `il_news_subscription` WRITE;
/*!40000 ALTER TABLE `il_news_subscription` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_news_subscription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_object_def`
--

DROP TABLE IF EXISTS `il_object_def`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_object_def` (
  `id` char(10) NOT NULL DEFAULT '',
  `class_name` varchar(200) DEFAULT NULL,
  `component` varchar(200) DEFAULT NULL,
  `location` varchar(250) DEFAULT NULL,
  `checkbox` tinyint NOT NULL DEFAULT '0',
  `inherit` tinyint NOT NULL DEFAULT '0',
  `translate` char(5) DEFAULT NULL,
  `devmode` tinyint NOT NULL DEFAULT '0',
  `allow_link` tinyint NOT NULL DEFAULT '0',
  `allow_copy` tinyint NOT NULL DEFAULT '0',
  `rbac` tinyint NOT NULL DEFAULT '0',
  `system` tinyint NOT NULL DEFAULT '0',
  `sideblock` tinyint NOT NULL DEFAULT '0',
  `default_pos` int NOT NULL DEFAULT '0',
  `grp` char(10) DEFAULT NULL,
  `default_pres_pos` int NOT NULL DEFAULT '0',
  `export` tinyint NOT NULL DEFAULT '0',
  `repository` tinyint NOT NULL DEFAULT '1',
  `workspace` tinyint NOT NULL DEFAULT '0',
  `administration` tinyint NOT NULL DEFAULT '0',
  `amet` tinyint NOT NULL DEFAULT '0',
  `orgunit_permissions` tinyint NOT NULL DEFAULT '0',
  `lti_provider` tinyint NOT NULL DEFAULT '0',
  `offline_handling` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_object_def`
--

LOCK TABLES `il_object_def` WRITE;
/*!40000 ALTER TABLE `il_object_def` DISABLE KEYS */;
INSERT INTO `il_object_def` VALUES ('accs','AccessibilitySettings','components/ILIAS/Accessibility','components/ILIAS/Accessibility/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('adm','SystemFolder','components/ILIAS/SystemFolder','components/ILIAS/SystemFolder/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('adn','AdministrativeNotification','components/ILIAS/AdministrativeNotification','components/ILIAS/AdministrativeNotification/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('adve','AdvancedEditing','components/ILIAS/AdvancedEditing','components/ILIAS/AdvancedEditing/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('assf','TestFolder','components/ILIAS/Test','components/ILIAS/Test/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('auth','AuthSettings','components/ILIAS/Authentication','components/ILIAS/Authentication/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('awra','AwarenessAdministration','components/ILIAS/Awareness','components/ILIAS/Awareness/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('bdga','BadgeAdministration','components/ILIAS/Badge','components/ILIAS/Badge/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('bibl','Bibliographic','components/ILIAS/Bibliographic','components/ILIAS/Bibliographic/classes',1,1,'0',0,1,1,1,0,0,360,NULL,360,1,1,0,0,0,0,0,0),('bibs','BibliographicAdmin','components/ILIAS/Bibliographic','components/ILIAS/Bibliographic/classes/Admin',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('blga','BlogAdministration','components/ILIAS/Blog','components/ILIAS/Blog/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('blog','Blog','components/ILIAS/Blog','components/ILIAS/Blog/classes',1,1,'0',0,1,1,1,0,0,330,NULL,330,1,1,1,0,0,0,0,1),('book','BookingPool','components/ILIAS/BookingManager','components/ILIAS/BookingManager/classes',1,1,NULL,0,1,1,1,0,0,250,NULL,250,0,1,0,0,0,0,0,1),('cadm','ContactAdministration','components/ILIAS/Contact','components/ILIAS/Contact/classes',0,1,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('cals','CalendarSettings','components/ILIAS/Calendar','components/ILIAS/Calendar/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('cat','Category','components/ILIAS/Category','components/ILIAS/Category/classes',1,1,'db',0,0,1,1,0,0,10,'cat',10,1,1,0,0,1,0,0,0),('catr','CategoryReference','components/ILIAS/CategoryReference','components/ILIAS/CategoryReference/classes',1,0,'0',0,0,1,1,0,0,15,'cat',10,1,1,0,0,0,0,0,0),('cert','CertificateSettings','components/ILIAS/Certificate','components/ILIAS/Certificate/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('chta','ChatroomAdmin','components/ILIAS/Chatroom','components/ILIAS/Chatroom/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('chtr','Chatroom','components/ILIAS/Chatroom','components/ILIAS/Chatroom/classes',1,0,'0',0,1,1,1,0,0,90,NULL,150,0,1,0,0,0,0,0,1),('cmis','CmiXapiAdministration','components/ILIAS/CmiXapi','components/ILIAS/CmiXapi/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('cmix','CmiXapi','components/ILIAS/CmiXapi','components/ILIAS/CmiXapi/classes',1,1,'db',0,1,1,1,0,0,120,'lres',0,1,1,0,0,0,0,0,1),('cmps','ComponentSettings','components/ILIAS/Component','components/ILIAS/Component/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('cmxv','CmiXapiVerification','components/ILIAS/CmiXapi','components/ILIAS/CmiXapi/classes/Verification',0,0,'0',0,0,0,0,0,0,90,NULL,150,0,0,0,0,0,0,0,0),('coms','CommentsSettings','components/ILIAS/Notes','components/ILIAS/Notes/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('copa','ContentPage','components/ILIAS/ContentPage','components/ILIAS/ContentPage/classes',1,1,'db',0,1,1,1,0,0,340,NULL,340,1,1,0,0,0,0,0,1),('cpad','ContentPageAdministration','components/ILIAS/ContentPage','components/ILIAS/ContentPage/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('crs','Course','components/ILIAS/Course','components/ILIAS/Course/classes',1,1,'db',0,0,1,1,0,0,20,'crs',30,1,1,0,0,1,1,1,1),('crsr','CourseReference','components/ILIAS/CourseReference','components/ILIAS/CourseReference/classes',1,0,'0',0,0,1,1,0,0,25,'crs',20,1,1,0,0,0,0,0,0),('crss','CourseAdministration','components/ILIAS/Course','components/ILIAS/Course/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('crsv','CourseVerification','components/ILIAS/Course','components/ILIAS/Course/classes/Verification',0,0,'0',0,0,0,0,0,0,90,NULL,150,0,0,0,0,0,0,0,0),('dcl','DataCollection','components/ILIAS/DataCollection','components/ILIAS/DataCollection/classes',1,1,'0',0,1,1,1,0,0,340,NULL,340,1,1,0,0,0,0,0,0),('dpro','DataProtection','components/ILIAS/DataProtection','components/ILIAS/DataProtection/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('dshs','DashboardSettings','components/ILIAS/Dashboard','components/ILIAS/Dashboard/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('ecss','ECSSettings','components/ILIAS/WebServices','components/ILIAS/WebServices/ECS/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('etal','EmployeeTalk','components/ILIAS/EmployeeTalk','components/ILIAS/EmployeeTalk/classes/Talk',1,1,'db',0,0,0,0,0,0,10,'tala',10,0,0,0,1,0,1,0,0),('exc','Exercise','components/ILIAS/Exercise','components/ILIAS/Exercise/classes',1,1,NULL,0,1,1,1,0,0,170,NULL,160,1,1,0,0,1,1,0,1),('excs','ExerciseAdministration','components/ILIAS/Exercise','components/ILIAS/Exercise/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('excv','ExerciseVerification','components/ILIAS/Exercise','components/ILIAS/Exercise/classes',0,0,'0',0,0,0,0,0,0,100,NULL,160,0,0,0,0,0,0,0,0),('extt','ExternalToolsSettings','components/ILIAS/Administration','components/ILIAS/Administration/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('facs','FileAccessSettings','components/ILIAS/File','components/ILIAS/File/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('file','File','components/ILIAS/File','components/ILIAS/File/classes',1,0,'0',0,1,1,1,0,0,90,NULL,150,1,1,1,0,1,0,0,0),('fils','FileServices','components/ILIAS/FileServices','components/ILIAS/FileServices/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('fold','Folder','components/ILIAS/Folder','components/ILIAS/Folder/classes',1,1,'db',0,0,1,1,0,0,40,NULL,20,1,1,0,0,0,0,0,0),('frm','Forum','components/ILIAS/Forum','components/ILIAS/Forum/classes',1,1,'0',0,1,1,1,0,0,70,NULL,90,1,1,0,0,0,0,0,1),('frma','ForumAdministration','components/ILIAS/Forum','components/ILIAS/Forum/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('glo','Glossary','components/ILIAS/Glossary','components/ILIAS/Glossary/classes',1,1,'0',0,1,1,1,0,0,160,NULL,110,1,1,0,0,0,0,0,1),('grp','Group','components/ILIAS/Group','components/ILIAS/Group/classes',1,1,'db',0,0,1,1,0,0,50,NULL,70,1,1,0,0,1,1,1,1),('grpr','GroupReference','components/ILIAS/GroupReference','components/ILIAS/GroupReference/classes',1,0,'0',0,0,1,1,0,0,51,'grp',20,1,1,0,0,0,0,0,0),('grps','GroupAdministration','components/ILIAS/Group','components/ILIAS/Group/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('gsfo','FooterAdministration','components/ILIAS/GlobalScreen_','components/ILIAS/GlobalScreen_/classes/UI/Footer',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('hlps','HelpSettings','components/ILIAS/Help','components/ILIAS/Help/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('htlm','FileBasedLM','components/ILIAS/HTMLLearningModule','components/ILIAS/HTMLLearningModule/classes',1,1,'0',0,1,1,1,0,0,130,'lres',0,1,1,0,0,0,0,0,1),('iass','IndividualAssessment','components/ILIAS/IndividualAssessment','components/ILIAS/IndividualAssessment/classes',1,1,'0',0,1,1,1,0,0,190,NULL,190,1,1,0,0,1,1,0,1),('impr','LegalNotice','components/ILIAS/Imprint','components/ILIAS/Imprint/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('itgr','ItemGroup','components/ILIAS/ItemGroup','components/ILIAS/ItemGroup/classes',1,0,'db',0,0,1,1,0,0,45,NULL,5,1,1,0,0,0,0,0,0),('lhts','LearningHistorySettings','components/ILIAS/LearningHistory','components/ILIAS/LearningHistory/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('lm','LearningModule','components/ILIAS/LearningModule','components/ILIAS/LearningModule/classes',1,1,'db',0,1,1,1,0,0,120,'lres',0,1,1,0,0,0,0,1,1),('lng','Language','components/ILIAS/Language','components/ILIAS/Language/classes',1,0,'0',0,0,0,0,0,0,0,NULL,0,0,1,0,0,0,0,0,0),('lngf','LanguageFolder','components/ILIAS/Language','components/ILIAS/Language/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('logs','LoggingSettings','components/ILIAS/Logging','components/ILIAS/Logging/classes',0,1,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('lrss','LearningResourcesSettings','components/ILIAS/LearningModule','components/ILIAS/LearningModule/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('lso','LearningSequence','components/ILIAS/LearningSequence','components/ILIAS/LearningSequence/classes',1,1,'0',0,0,1,1,0,0,30,'lso',300,1,1,0,0,0,0,0,1),('lsos','LearningSequenceAdmin','components/ILIAS/LearningSequence','components/ILIAS/LearningSequence/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('lti','LTIConsumer','components/ILIAS/LTIConsumer','components/ILIAS/LTIConsumer/classes',1,1,'db',0,1,0,1,0,0,120,'lres',0,0,1,0,0,0,0,0,1),('ltis','LTIAdministration','components/ILIAS/LTIProvider','components/ILIAS/LTIProvider/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('ltiv','LTIConsumerVerification','components/ILIAS/LTIConsumer','components/ILIAS/LTIConsumer/classes/Verification',0,0,'0',0,0,0,0,0,0,90,NULL,150,0,0,0,0,0,0,0,0),('mail','Mail','components/ILIAS/Mail','components/ILIAS/Mail/classes',0,0,'sys',0,0,0,1,0,0,0,NULL,0,0,1,0,1,0,0,0,0),('mcst','MediaCast','components/ILIAS/MediaCast','components/ILIAS/MediaCast/classes',1,1,NULL,0,1,1,1,0,0,110,NULL,130,1,1,0,0,0,0,0,1),('mcts','MediaCastSettings','components/ILIAS/MediaCast','components/ILIAS/MediaCast/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('mds','MDSettings','components/ILIAS/MetaData','components/ILIAS/MetaData/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('mep','MediaPool','components/ILIAS/MediaPool','components/ILIAS/MediaPool/classes',1,1,'db',0,1,1,1,0,0,200,NULL,190,1,1,0,0,0,0,0,1),('mme','MainMenu','components/ILIAS/MainMenu','components/ILIAS/MainMenu/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('mobs','MediaObjectsSettings','components/ILIAS/MediaObjects','components/ILIAS/MediaObjects/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('nota','NotificationAdmin','components/ILIAS/Notifications','components/ILIAS/Notifications/classes',0,0,'sys',0,0,0,0,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('nots','NotesSettings','components/ILIAS/Notes','components/ILIAS/Notes/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('nwss','NewsSettings','components/ILIAS/News','components/ILIAS/News/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('objf','ObjectFolder','components/ILIAS/ILIASObject','components/ILIAS/ILIASObject/classes',0,0,'sys',1,0,0,1,1,0,0,NULL,0,0,1,0,0,0,0,0,0),('orgu','OrgUnit','components/ILIAS/OrgUnit','components/ILIAS/OrgUnit/classes',1,1,'db',0,0,0,1,0,0,10,'orgu',10,1,1,0,1,0,0,0,0),('otpl','ObjectTemplateAdministration','components/ILIAS/DidacticTemplate','components/ILIAS/DidacticTemplate/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('poll','Poll','components/ILIAS/Poll','components/ILIAS/Poll/classes',1,1,'0',0,1,1,1,0,1,350,NULL,350,1,1,1,0,0,0,0,1),('prfa','PortfolioAdministration','components/ILIAS/Portfolio','components/ILIAS/Portfolio/Administration',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('prg','StudyProgramme','components/ILIAS/StudyProgramme','components/ILIAS/StudyProgramme/classes',1,1,'db',0,0,1,1,0,0,30,NULL,30,0,1,0,0,0,1,0,0),('prgr','StudyProgrammeReference','components/ILIAS/StudyProgrammeReference','components/ILIAS/StudyProgrammeReference/classes',1,0,'0',0,1,1,1,0,0,25,'prg',20,0,1,0,0,0,0,0,0),('prgs','StudyProgrammeAdmin','components/ILIAS/StudyProgramme','components/ILIAS/StudyProgramme/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('prss','PersonalWorkspaceSettings','components/ILIAS/PersonalWorkspace','components/ILIAS/PersonalWorkspace/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('prtf','Portfolio','components/ILIAS/Portfolio','components/ILIAS/Portfolio/classes',0,0,'0',0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,0),('prtt','PortfolioTemplate','components/ILIAS/Portfolio','components/ILIAS/Portfolio/Template',1,0,'0',0,1,1,1,0,0,500,NULL,500,1,1,0,0,0,0,0,1),('ps','PrivacySecurity','components/ILIAS/PrivacySecurity','components/ILIAS/PrivacySecurity/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('qpl','QuestionPool','components/ILIAS/TestQuestionPool','components/ILIAS/TestQuestionPool/classes',1,1,'0',0,1,1,1,0,0,210,NULL,200,1,1,0,0,0,0,0,1),('rcat','RemoteCategory','components/ILIAS/RemoteCategory','components/ILIAS/RemoteCategory/classes',1,0,'0',0,1,1,1,0,0,30,'cat',40,0,0,0,0,0,0,0,0),('rcrs','RemoteCourse','components/ILIAS/RemoteCourse','components/ILIAS/RemoteCourse/classes',1,0,'0',0,1,1,1,0,0,30,'crs',40,0,0,0,0,1,0,0,0),('recf','RecoveryFolder','components/ILIAS/Administration','components/ILIAS/Administration/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('reps','RepositorySettings','components/ILIAS/Repository','components/ILIAS/Repository/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('rfil','RemoteFile','components/ILIAS/RemoteFile','components/ILIAS/RemoteFile/classes',1,0,'0',0,1,1,1,0,0,30,'file',40,0,0,0,0,0,0,0,0),('rglo','RemoteGlossary','components/ILIAS/RemoteGlossary','components/ILIAS/RemoteGlossary/classes',1,0,'0',0,1,1,1,0,0,30,'glo',40,0,0,0,0,0,0,0,0),('rgrp','RemoteGroup','components/ILIAS/RemoteGroup','components/ILIAS/RemoteGroup/classes',1,0,'0',0,1,1,1,0,0,30,'grp',40,0,0,0,0,0,0,0,0),('rlm','RemoteLearningModule','components/ILIAS/RemoteLearningModule','components/ILIAS/RemoteLearningModule/classes',1,0,'0',0,1,1,1,0,0,30,'lres',40,0,0,0,0,0,0,0,0),('role','Role','components/ILIAS/AccessControl','components/ILIAS/AccessControl/classes',1,0,'0',0,0,0,0,0,0,0,NULL,0,0,1,0,1,0,0,0,0),('rolf','RoleFolder','components/ILIAS/AccessControl','components/ILIAS/AccessControl/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('rolt','RoleTemplate','components/ILIAS/AccessControl','components/ILIAS/AccessControl/classes',1,0,'0',0,0,0,0,0,0,0,NULL,0,0,1,0,0,0,0,0,0),('root','RootFolder','components/ILIAS/RootFolder','components/ILIAS/RootFolder/classes',0,0,'0',0,0,0,1,1,0,0,NULL,0,0,1,0,0,0,0,0,0),('rtst','RemoteTest','components/ILIAS/RemoteTest','components/ILIAS/RemoteTest/classes',1,0,'0',0,1,1,1,0,0,30,'tst',40,0,0,0,0,0,0,0,0),('rwik','RemoteWiki','components/ILIAS/RemoteWiki','components/ILIAS/RemoteWiki/classes',1,0,'0',0,1,1,1,0,0,30,'wiki',40,0,0,0,0,0,0,0,0),('sahs','SAHSLearningModule','components/ILIAS/ScormAicc','components/ILIAS/ScormAicc/classes',1,1,'0',0,1,1,1,0,0,140,'lres',0,1,1,0,0,0,0,1,1),('scov','SCORMVerification','components/ILIAS/ScormAicc','components/ILIAS/ScormAicc/classes/Verification',0,0,'0',0,0,0,0,0,0,90,NULL,150,0,0,0,0,0,0,0,0),('seas','SearchSettings','components/ILIAS/Search','components/ILIAS/Search/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('sess','Session','components/ILIAS/Session','components/ILIAS/Session/classes',1,0,'0',0,0,1,1,0,0,15,NULL,15,1,1,0,0,1,0,0,0),('skee','SkillTree','components/ILIAS/Skill','components/ILIAS/Skill/Tree/classes',0,0,'0',0,0,0,1,0,0,0,NULL,0,0,1,0,1,0,0,0,0),('skmg','SkillManagement','components/ILIAS/Skill','components/ILIAS/Skill/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('spl','SurveyQuestionPool','components/ILIAS/SurveyQuestionPool','components/ILIAS/SurveyQuestionPool/classes',1,1,'0',0,1,1,1,0,0,220,NULL,210,1,1,0,0,0,0,0,1),('sty','StyleSheet','components/ILIAS/Style','components/ILIAS/Style/Content/classes',1,0,'0',0,0,0,0,0,0,0,NULL,0,0,1,0,0,0,0,0,0),('stys','StyleSettings','components/ILIAS/Style','components/ILIAS/Style/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('svy','Survey','components/ILIAS/Survey','components/ILIAS/Survey/classes',1,1,'0',0,1,1,1,0,0,190,NULL,180,1,1,0,0,0,1,1,1),('svyf','SurveyAdministration','components/ILIAS/Survey','components/ILIAS/Survey/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('sysc','SystemCheck','components/ILIAS/SystemCheck','components/ILIAS/SystemCheck/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('tags','TaggingSettings','components/ILIAS/Tagging','components/ILIAS/Tagging/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('tala','TalkTemplateAdministration','components/ILIAS/EmployeeTalk','components/ILIAS/EmployeeTalk/classes',0,0,'sys',0,0,0,1,1,0,0,'tala',0,0,0,0,1,0,0,0,0),('tals','EmployeeTalkSeries','components/ILIAS/EmployeeTalk','components/ILIAS/EmployeeTalk/classes/TalkSeries',1,1,'db',0,0,0,0,0,0,10,'tala',10,0,0,0,1,0,0,0,0),('talt','TalkTemplate','components/ILIAS/EmployeeTalk','components/ILIAS/EmployeeTalk/classes',1,1,'db',0,0,0,1,0,0,10,'tala',10,0,0,0,1,0,0,0,1),('tax','Taxonomy','components/ILIAS/Taxonomy','components/ILIAS/Taxonomy/classes',1,0,'0',0,0,0,0,0,0,0,NULL,0,0,1,0,0,0,0,0,0),('taxs','TaxonomyAdministration','components/ILIAS/Taxonomy','components/ILIAS/Taxonomy/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('tos','TermsOfService','components/ILIAS/TermsOfService','components/ILIAS/TermsOfService/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('trac','UserTracking','components/ILIAS/Tracking','components/ILIAS/Tracking/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('tst','Test','components/ILIAS/Test','components/ILIAS/Test/classes',1,1,'0',0,1,1,1,0,0,180,NULL,170,1,1,0,0,0,1,1,1),('tstv','TestVerification','components/ILIAS/Test','components/ILIAS/Test/classes',0,0,'0',0,0,0,0,0,0,90,NULL,150,0,0,0,0,0,0,0,0),('usr','User','components/ILIAS/User','components/ILIAS/User/classes',1,0,'0',0,0,0,0,0,0,0,NULL,0,0,1,0,0,0,0,0,0),('usrf','UserFolder','components/ILIAS/User','components/ILIAS/User/classes',0,1,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,1,0,0),('wbdv','WebDAV','components/ILIAS/WebDAV','components/ILIAS/WebDAV/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('wbrs','WebResourceAdministration','components/ILIAS/WebResource','components/ILIAS/WebResource/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('webr','LinkResource','components/ILIAS/WebResource','components/ILIAS/WebResource/classes',1,0,'0',0,1,1,1,0,0,100,NULL,120,1,1,1,0,0,0,0,1),('wfld','WorkspaceFolder','components/ILIAS/WorkspaceFolder','components/ILIAS/WorkspaceFolder/classes',1,1,'0',0,0,0,0,0,0,300,NULL,300,0,0,1,0,0,0,0,0),('wiki','Wiki','components/ILIAS/Wiki','components/ILIAS/Wiki/classes',1,1,NULL,0,1,1,1,0,0,115,NULL,140,1,1,0,0,0,0,1,1),('wiks','WikiSettings','components/ILIAS/Wiki','components/ILIAS/Wiki/classes',0,0,'sys',0,0,0,1,1,0,0,NULL,0,0,1,0,1,0,0,0,0),('wsrt','WorkspaceRootFolder','components/ILIAS/WorkspaceRootFolder','components/ILIAS/WorkspaceRootFolder/classes',0,0,'0',0,0,0,0,1,0,0,NULL,0,0,0,1,0,0,0,0,0);
/*!40000 ALTER TABLE `il_object_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_object_group`
--

DROP TABLE IF EXISTS `il_object_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_object_group` (
  `id` char(10) NOT NULL DEFAULT '',
  `name` varchar(200) DEFAULT NULL,
  `default_pres_pos` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_object_group`
--

LOCK TABLES `il_object_group` WRITE;
/*!40000 ALTER TABLE `il_object_group` DISABLE KEYS */;
INSERT INTO `il_object_group` VALUES ('cat','Categories',10),('crs','Courses',30),('file','Files',150),('glo','Glossaries',110),('grp','Groups',70),('iass','IndividualAssessment',170),('lres','LearningResources',100),('lso','LearningSequence',300),('orgu','Organisational Unit',10),('prg','StudyProgramme',30),('tala','Employee Talk Templates',10),('tst','Tests',170),('wiki','Wikis',140);
/*!40000 ALTER TABLE `il_object_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_object_sub_type`
--

DROP TABLE IF EXISTS `il_object_sub_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_object_sub_type` (
  `obj_type` varchar(10) NOT NULL DEFAULT '',
  `sub_type` varchar(10) NOT NULL DEFAULT '',
  `amet` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_type`,`sub_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_object_sub_type`
--

LOCK TABLES `il_object_sub_type` WRITE;
/*!40000 ALTER TABLE `il_object_sub_type` DISABLE KEYS */;
INSERT INTO `il_object_sub_type` VALUES ('book','bobj',1),('glo','term',1),('mep','mob',1),('mep','mpg',1),('orgu','orgu_type',1),('prg','prg_type',1),('prtf','pfpg',1),('prtt','pfpg',1),('tals','etal',1),('talt','etal',1),('wiki','wpg',1);
/*!40000 ALTER TABLE `il_object_sub_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_object_subobj`
--

DROP TABLE IF EXISTS `il_object_subobj`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_object_subobj` (
  `parent` char(10) NOT NULL DEFAULT '',
  `subobj` char(10) NOT NULL DEFAULT '',
  `mmax` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`parent`,`subobj`),
  KEY `i1_idx` (`subobj`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_object_subobj`
--

LOCK TABLES `il_object_subobj` WRITE;
/*!40000 ALTER TABLE `il_object_subobj` DISABLE KEYS */;
INSERT INTO `il_object_subobj` VALUES ('adm','accs',1),('adm','adn',1),('adm','adve',1),('adm','assf',1),('adm','auth',1),('adm','awra',1),('adm','bdga',1),('adm','bibs',1),('adm','blga',1),('adm','cadm',1),('adm','cals',1),('adm','cert',1),('adm','chta',1),('adm','cmis',1),('adm','cmps',1),('adm','coms',1),('adm','cpad',1),('adm','crss',1),('adm','dpro',1),('adm','dshs',1),('adm','ecss',1),('adm','excs',1),('adm','extt',1),('adm','facs',1),('adm','fils',1),('adm','frma',1),('adm','grps',1),('adm','gsfo',1),('adm','hlps',1),('adm','impr',1),('adm','lhts',1),('adm','lngf',1),('adm','logs',1),('adm','lrss',1),('adm','lsos',1),('adm','ltis',1),('adm','mail',1),('adm','mcts',1),('adm','mds',1),('adm','mme',1),('adm','mobs',1),('adm','nota',1),('adm','nots',1),('adm','nwss',1),('adm','objf',1),('adm','orgu',1),('adm','otpl',1),('adm','prfa',1),('adm','prgs',1),('adm','prss',1),('adm','ps',1),('adm','recf',1),('adm','reps',1),('adm','rolf',0),('adm','seas',1),('adm','skmg',1),('adm','stys',1),('adm','svyf',1),('adm','sysc',1),('adm','tags',1),('adm','tala',1),('adm','taxs',1),('adm','tos',1),('adm','trac',1),('adm','usrf',1),('adm','wbdv',1),('adm','wbrs',1),('adm','wiks',1),('cat','bibl',0),('cat','blog',0),('cat','book',0),('cat','cat',0),('cat','catr',0),('cat','chtr',0),('cat','cmix',0),('cat','copa',0),('cat','crs',0),('cat','crsr',0),('cat','dcl',0),('cat','exc',0),('cat','file',0),('cat','frm',0),('cat','glo',0),('cat','grp',0),('cat','grpr',0),('cat','htlm',0),('cat','iass',0),('cat','itgr',0),('cat','lm',0),('cat','lso',0),('cat','lti',0),('cat','mcst',0),('cat','mep',0),('cat','poll',0),('cat','prg',0),('cat','prgr',0),('cat','prtt',0),('cat','qpl',0),('cat','rcat',0),('cat','rcrs',0),('cat','rfil',0),('cat','rglo',0),('cat','rgrp',0),('cat','rlm',0),('cat','rtst',0),('cat','rwik',0),('cat','sahs',0),('cat','spl',0),('cat','svy',0),('cat','tst',0),('cat','webr',0),('cat','wiki',0),('crs','bibl',0),('crs','blog',0),('crs','book',0),('crs','catr',0),('crs','chtr',0),('crs','cmix',0),('crs','copa',0),('crs','crsr',0),('crs','dcl',0),('crs','exc',0),('crs','file',0),('crs','fold',0),('crs','frm',0),('crs','glo',0),('crs','grp',0),('crs','grpr',0),('crs','htlm',0),('crs','iass',0),('crs','itgr',0),('crs','lm',0),('crs','lso',0),('crs','lti',0),('crs','mcst',0),('crs','mep',0),('crs','poll',0),('crs','prtt',0),('crs','qpl',0),('crs','rcat',0),('crs','rcrs',0),('crs','rgrp',0),('crs','sahs',0),('crs','sess',0),('crs','spl',0),('crs','svy',0),('crs','tst',0),('crs','webr',0),('crs','wiki',0),('fold','bibl',0),('fold','blog',0),('fold','book',0),('fold','chtr',0),('fold','cmix',0),('fold','copa',0),('fold','dcl',0),('fold','exc',0),('fold','file',0),('fold','fold',0),('fold','frm',0),('fold','glo',0),('fold','grp',0),('fold','htlm',0),('fold','iass',0),('fold','itgr',0),('fold','lm',0),('fold','lso',0),('fold','lti',0),('fold','mcst',0),('fold','mep',0),('fold','poll',0),('fold','prtt',0),('fold','qpl',0),('fold','sahs',0),('fold','sess',0),('fold','spl',0),('fold','svy',0),('fold','tst',0),('fold','webr',0),('fold','wiki',0),('grp','bibl',0),('grp','blog',0),('grp','book',0),('grp','catr',0),('grp','chtr',0),('grp','cmix',0),('grp','copa',0),('grp','crsr',0),('grp','dcl',0),('grp','exc',0),('grp','file',0),('grp','fold',0),('grp','frm',0),('grp','glo',0),('grp','grp',0),('grp','grpr',0),('grp','htlm',0),('grp','iass',0),('grp','itgr',0),('grp','lm',0),('grp','lso',0),('grp','lti',0),('grp','mcst',0),('grp','mep',0),('grp','poll',0),('grp','prtt',0),('grp','qpl',0),('grp','rcat',0),('grp','rcrs',0),('grp','rgrp',0),('grp','sahs',0),('grp','sess',0),('grp','spl',0),('grp','svy',0),('grp','tst',0),('grp','webr',0),('grp','wiki',0),('lngf','lng',0),('lso','copa',0),('lso','exc',0),('lso','file',0),('lso','htlm',0),('lso','iass',0),('lso','lm',0),('lso','rolf',1),('lso','sahs',0),('lso','svy',0),('lso','tst',0),('orgu','orgu',0),('prg','crsr',1),('prg','prg',0),('prg','prgr',0),('prg','rolf',1),('recf','bibl',0),('recf','blog',0),('recf','cat',0),('recf','catr',0),('recf','chtr',0),('recf','cmix',0),('recf','copa',0),('recf','crs',0),('recf','crsr',0),('recf','dcl',0),('recf','exc',0),('recf','file',0),('recf','fold',0),('recf','frm',0),('recf','glo',0),('recf','grp',0),('recf','grpr',0),('recf','htlm',0),('recf','itgr',0),('recf','lm',0),('recf','lti',0),('recf','mcst',0),('recf','mep',0),('recf','poll',0),('recf','prg',0),('recf','prgr',0),('recf','prtt',0),('recf','qpl',0),('recf','sahs',0),('recf','sess',0),('recf','spl',0),('recf','svy',0),('recf','tst',0),('recf','webr',0),('recf','wiki',0),('rolf','role',0),('rolf','rolt',0),('root','adm',1),('root','bibl',0),('root','blog',0),('root','book',0),('root','cat',0),('root','catr',0),('root','chtr',0),('root','cmix',0),('root','copa',0),('root','crs',0),('root','crsr',0),('root','dcl',0),('root','exc',0),('root','file',0),('root','frm',0),('root','glo',0),('root','grp',0),('root','grpr',0),('root','htlm',0),('root','iass',0),('root','itgr',0),('root','lm',0),('root','lso',0),('root','lti',0),('root','mcst',0),('root','mep',0),('root','poll',0),('root','prg',0),('root','prgr',0),('root','prtt',0),('root','qpl',0),('root','rcat',0),('root','rcrs',0),('root','rfil',0),('root','rglo',0),('root','rgrp',0),('root','rlm',0),('root','rtst',0),('root','rwik',0),('root','sahs',0),('root','spl',0),('root','svy',0),('root','tst',0),('root','webr',0),('root','wiki',0),('skmg','skee',1),('stys','sty',0),('tala','tals',0),('tala','talt',0),('tals','etal',0),('usrf','usr',0),('wfld','blog',0),('wfld','cmxv',0),('wfld','crsv',0),('wfld','excv',0),('wfld','file',0),('wfld','ltiv',0),('wfld','scov',0),('wfld','tstv',0),('wfld','webr',0),('wfld','wfld',0),('wsrt','blog',0),('wsrt','cmxv',0),('wsrt','crsv',0),('wsrt','excv',0),('wsrt','file',0),('wsrt','ltiv',0),('wsrt','scov',0),('wsrt','tstv',0),('wsrt','webr',0),('wsrt','wfld',0);
/*!40000 ALTER TABLE `il_object_subobj` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_authority`
--

DROP TABLE IF EXISTS `il_orgu_authority`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_authority` (
  `id` bigint NOT NULL DEFAULT '0',
  `over` tinyint DEFAULT NULL,
  `scope` tinyint DEFAULT NULL,
  `position_id` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_authority`
--

LOCK TABLES `il_orgu_authority` WRITE;
/*!40000 ALTER TABLE `il_orgu_authority` DISABLE KEYS */;
INSERT INTO `il_orgu_authority` VALUES (1,1,1,2);
/*!40000 ALTER TABLE `il_orgu_authority` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_authority_seq`
--

DROP TABLE IF EXISTS `il_orgu_authority_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_authority_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_authority_seq`
--

LOCK TABLES `il_orgu_authority_seq` WRITE;
/*!40000 ALTER TABLE `il_orgu_authority_seq` DISABLE KEYS */;
INSERT INTO `il_orgu_authority_seq` VALUES (1);
/*!40000 ALTER TABLE `il_orgu_authority_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_op_contexts`
--

DROP TABLE IF EXISTS `il_orgu_op_contexts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_op_contexts` (
  `id` bigint NOT NULL DEFAULT '0',
  `context` varchar(16) DEFAULT NULL,
  `parent_context_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_op_contexts`
--

LOCK TABLES `il_orgu_op_contexts` WRITE;
/*!40000 ALTER TABLE `il_orgu_op_contexts` DISABLE KEYS */;
INSERT INTO `il_orgu_op_contexts` VALUES (1,'object',0),(2,'iass',1),(3,'crs',1),(4,'grp',1),(5,'tst',1),(6,'exc',1),(7,'svy',1),(8,'prg',1),(9,'usrf',1),(10,'etal',1);
/*!40000 ALTER TABLE `il_orgu_op_contexts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_op_contexts_seq`
--

DROP TABLE IF EXISTS `il_orgu_op_contexts_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_op_contexts_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_op_contexts_seq`
--

LOCK TABLES `il_orgu_op_contexts_seq` WRITE;
/*!40000 ALTER TABLE `il_orgu_op_contexts_seq` DISABLE KEYS */;
INSERT INTO `il_orgu_op_contexts_seq` VALUES (10);
/*!40000 ALTER TABLE `il_orgu_op_contexts_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_operations`
--

DROP TABLE IF EXISTS `il_orgu_operations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_operations` (
  `operation_id` bigint NOT NULL DEFAULT '0',
  `operation_string` varchar(127) DEFAULT NULL,
  `description` varchar(512) DEFAULT NULL,
  `list_order` bigint DEFAULT NULL,
  `context_id` bigint DEFAULT NULL,
  PRIMARY KEY (`operation_id`),
  KEY `i1_idx` (`operation_string`),
  KEY `i3_idx` (`list_order`),
  KEY `i4_idx` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_operations`
--

LOCK TABLES `il_orgu_operations` WRITE;
/*!40000 ALTER TABLE `il_orgu_operations` DISABLE KEYS */;
INSERT INTO `il_orgu_operations` VALUES (1,'read_learning_progress','Read the learning Progress of a User',0,3),(2,'read_learning_progress','Read the learning Progress of a User',0,4),(3,'read_learning_progress','Read the learning Progress of a User',0,2),(4,'read_learning_progress','Read the learning Progress of a User',0,6),(5,'read_learning_progress','Read the learning Progress of a User',0,7),(6,'manage_members','Edit Members in a course',0,3),(7,'manage_members','Edit Members in a group',0,4),(8,'edit_submissions_grades','',0,6),(9,'access_results','',0,7),(10,'write_learning_progress','Write the learning Progress of a User',0,2),(11,'access_enrolments','Access Enrolments in a course',0,3),(12,'read_learning_progress','Read Test Participants Learning Progress',0,5),(13,'access_results','Access Test Participants Results',0,5),(14,'manage_participants','Manage Test Participants',0,5),(15,'score_participants','Score Test Participants',0,5),(16,'view_members','View Memberships of other users',0,8),(17,'read_learning_progress','View learning progress of other users',0,8),(18,'view_individual_plan','View Individual Plans of other users',0,8),(19,'edit_individual_plan','Edit Individual Plans of other users',0,8),(20,'manage_members','Manage Memberships of other users',0,8),(21,'edit_user_accounts','Edit User in User Administration',0,9),(22,'view_certificates','Read the certificates of a User',0,5),(23,'view_certificates','Read the certificates of a User',0,6),(24,'view_certificates','Read the certificates of a User',0,3),(25,'view_competences','Read the competences of a User',0,5),(26,'view_competences','Read the competences of a User',0,4),(27,'view_competences','Read the competences of a User',0,3),(28,'view_competences','Read the competences of a User',0,7),(29,'read_employee_talk','Read Employee Talk',0,10),(30,'create_employee_talk','Create Employee Talk',0,10),(31,'edit_employee_talk','Edit Employee Talk (not only own)',0,10);
/*!40000 ALTER TABLE `il_orgu_operations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_operations_seq`
--

DROP TABLE IF EXISTS `il_orgu_operations_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_operations_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_operations_seq`
--

LOCK TABLES `il_orgu_operations_seq` WRITE;
/*!40000 ALTER TABLE `il_orgu_operations_seq` DISABLE KEYS */;
INSERT INTO `il_orgu_operations_seq` VALUES (31);
/*!40000 ALTER TABLE `il_orgu_operations_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_permissions`
--

DROP TABLE IF EXISTS `il_orgu_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_permissions` (
  `id` bigint NOT NULL DEFAULT '0',
  `context_id` bigint DEFAULT NULL,
  `operations` varchar(256) DEFAULT NULL,
  `parent_id` bigint DEFAULT NULL,
  `position_id` bigint DEFAULT NULL,
  `protected` tinyint DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `co_idx` (`context_id`),
  KEY `po_idx` (`position_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_permissions`
--

LOCK TABLES `il_orgu_permissions` WRITE;
/*!40000 ALTER TABLE `il_orgu_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_orgu_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_permissions_seq`
--

DROP TABLE IF EXISTS `il_orgu_permissions_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_permissions_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_permissions_seq`
--

LOCK TABLES `il_orgu_permissions_seq` WRITE;
/*!40000 ALTER TABLE `il_orgu_permissions_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_orgu_permissions_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_positions`
--

DROP TABLE IF EXISTS `il_orgu_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_positions` (
  `id` bigint NOT NULL DEFAULT '0',
  `title` varchar(512) DEFAULT NULL,
  `description` varchar(4000) DEFAULT NULL,
  `core_position` tinyint DEFAULT NULL,
  `core_identifier` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_positions`
--

LOCK TABLES `il_orgu_positions` WRITE;
/*!40000 ALTER TABLE `il_orgu_positions` DISABLE KEYS */;
INSERT INTO `il_orgu_positions` VALUES (1,'Employees','Employees of a OrgUnit',1,1),(2,'Superiors','Superiors of a OrgUnit',1,2);
/*!40000 ALTER TABLE `il_orgu_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_positions_seq`
--

DROP TABLE IF EXISTS `il_orgu_positions_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_positions_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_positions_seq`
--

LOCK TABLES `il_orgu_positions_seq` WRITE;
/*!40000 ALTER TABLE `il_orgu_positions_seq` DISABLE KEYS */;
INSERT INTO `il_orgu_positions_seq` VALUES (2);
/*!40000 ALTER TABLE `il_orgu_positions_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_ua`
--

DROP TABLE IF EXISTS `il_orgu_ua`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_ua` (
  `id` bigint NOT NULL DEFAULT '0',
  `user_id` bigint DEFAULT NULL,
  `position_id` bigint DEFAULT NULL,
  `orgu_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pi_idx` (`position_id`),
  KEY `ui_idx` (`user_id`),
  KEY `oi_idx` (`orgu_id`),
  KEY `po_idx` (`position_id`,`orgu_id`),
  KEY `pu_idx` (`position_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_ua`
--

LOCK TABLES `il_orgu_ua` WRITE;
/*!40000 ALTER TABLE `il_orgu_ua` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_orgu_ua` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_orgu_ua_seq`
--

DROP TABLE IF EXISTS `il_orgu_ua_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_orgu_ua_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_orgu_ua_seq`
--

LOCK TABLES `il_orgu_ua_seq` WRITE;
/*!40000 ALTER TABLE `il_orgu_ua_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_orgu_ua_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_plugin`
--

DROP TABLE IF EXISTS `il_plugin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_plugin` (
  `last_update_version` char(10) DEFAULT NULL,
  `active` tinyint DEFAULT NULL,
  `db_version` int NOT NULL DEFAULT '0',
  `plugin_id` varchar(20) NOT NULL,
  PRIMARY KEY (`plugin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_plugin`
--

LOCK TABLES `il_plugin` WRITE;
/*!40000 ALTER TABLE `il_plugin` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_plugin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_poll`
--

DROP TABLE IF EXISTS `il_poll`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_poll` (
  `id` int NOT NULL DEFAULT '0',
  `question` varchar(1000) DEFAULT NULL,
  `image` varchar(1000) DEFAULT NULL,
  `view_results` tinyint NOT NULL DEFAULT '3',
  `period` tinyint NOT NULL DEFAULT '0',
  `period_begin` int DEFAULT '0',
  `period_end` int DEFAULT '0',
  `max_answers` tinyint NOT NULL DEFAULT '1',
  `result_sort` tinyint NOT NULL DEFAULT '0',
  `non_anon` tinyint NOT NULL DEFAULT '0',
  `show_results_as` tinyint NOT NULL DEFAULT '1',
  `migrated` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_poll`
--

LOCK TABLES `il_poll` WRITE;
/*!40000 ALTER TABLE `il_poll` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_poll` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_poll_answer`
--

DROP TABLE IF EXISTS `il_poll_answer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_poll_answer` (
  `id` int NOT NULL DEFAULT '0',
  `poll_id` int NOT NULL DEFAULT '0',
  `answer` varchar(1000) DEFAULT NULL,
  `pos` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_poll_answer`
--

LOCK TABLES `il_poll_answer` WRITE;
/*!40000 ALTER TABLE `il_poll_answer` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_poll_answer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_poll_answer_seq`
--

DROP TABLE IF EXISTS `il_poll_answer_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_poll_answer_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_poll_answer_seq`
--

LOCK TABLES `il_poll_answer_seq` WRITE;
/*!40000 ALTER TABLE `il_poll_answer_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_poll_answer_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_poll_image`
--

DROP TABLE IF EXISTS `il_poll_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_poll_image` (
  `object_id` bigint NOT NULL DEFAULT '0',
  `rid` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_poll_image`
--

LOCK TABLES `il_poll_image` WRITE;
/*!40000 ALTER TABLE `il_poll_image` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_poll_image` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_poll_vote`
--

DROP TABLE IF EXISTS `il_poll_vote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_poll_vote` (
  `user_id` int NOT NULL DEFAULT '0',
  `poll_id` int NOT NULL DEFAULT '0',
  `answer_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`poll_id`,`answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_poll_vote`
--

LOCK TABLES `il_poll_vote` WRITE;
/*!40000 ALTER TABLE `il_poll_vote` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_poll_vote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_res`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_res`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_res` (
  `result_id` int NOT NULL DEFAULT '0',
  `question_fi` int NOT NULL DEFAULT '0',
  `result` varchar(255) DEFAULT NULL,
  `range_min` double NOT NULL DEFAULT '0',
  `range_max` double NOT NULL DEFAULT '0',
  `tolerance` double NOT NULL DEFAULT '0',
  `unit_fi` int NOT NULL DEFAULT '0',
  `formula` longtext,
  `rating_simple` int NOT NULL DEFAULT '1',
  `rating_sign` double NOT NULL DEFAULT '0.25',
  `rating_value` double NOT NULL DEFAULT '0.25',
  `rating_unit` double NOT NULL DEFAULT '0.25',
  `points` double NOT NULL DEFAULT '0',
  `resprecision` int NOT NULL DEFAULT '0',
  `result_type` int NOT NULL DEFAULT '0',
  `range_min_txt` varchar(4000) DEFAULT NULL,
  `range_max_txt` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`result_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_res`
--

LOCK TABLES `il_qpl_qst_fq_res` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_res` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_res` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_res_seq`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_res_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_res_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_res_seq`
--

LOCK TABLES `il_qpl_qst_fq_res_seq` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_res_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_res_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_res_unit`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_res_unit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_res_unit` (
  `result_unit_id` int NOT NULL DEFAULT '0',
  `result` varchar(255) DEFAULT NULL,
  `question_fi` int NOT NULL DEFAULT '0',
  `unit_fi` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`result_unit_id`),
  KEY `i1_idx` (`question_fi`,`unit_fi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_res_unit`
--

LOCK TABLES `il_qpl_qst_fq_res_unit` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_res_unit` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_res_unit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_res_unit_seq`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_res_unit_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_res_unit_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_res_unit_seq`
--

LOCK TABLES `il_qpl_qst_fq_res_unit_seq` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_res_unit_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_res_unit_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_ucat`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_ucat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_ucat` (
  `category_id` int NOT NULL DEFAULT '0',
  `category` varchar(255) DEFAULT NULL,
  `question_fi` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_ucat`
--

LOCK TABLES `il_qpl_qst_fq_ucat` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_ucat` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_ucat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_ucat_seq`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_ucat_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_ucat_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_ucat_seq`
--

LOCK TABLES `il_qpl_qst_fq_ucat_seq` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_ucat_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_ucat_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_unit`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_unit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_unit` (
  `unit_id` int NOT NULL DEFAULT '0',
  `unit` varchar(255) DEFAULT NULL,
  `factor` double NOT NULL DEFAULT '0',
  `baseunit_fi` int NOT NULL DEFAULT '0',
  `category_fi` int NOT NULL DEFAULT '0',
  `sequence` int NOT NULL DEFAULT '0',
  `question_fi` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`unit_id`),
  KEY `i2_idx` (`question_fi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_unit`
--

LOCK TABLES `il_qpl_qst_fq_unit` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_unit` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_unit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_unit_seq`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_unit_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_unit_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_unit_seq`
--

LOCK TABLES `il_qpl_qst_fq_unit_seq` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_unit_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_unit_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_var`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_var`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_var` (
  `variable_id` int NOT NULL DEFAULT '0',
  `question_fi` int NOT NULL DEFAULT '0',
  `variable` varchar(255) DEFAULT NULL,
  `range_min` double NOT NULL DEFAULT '0',
  `range_max` double NOT NULL DEFAULT '0',
  `unit_fi` int NOT NULL DEFAULT '0',
  `step_dim_min` int NOT NULL DEFAULT '0',
  `step_dim_max` int NOT NULL DEFAULT '0',
  `varprecision` int NOT NULL DEFAULT '0',
  `intprecision` int NOT NULL DEFAULT '1',
  `range_min_txt` varchar(4000) DEFAULT NULL,
  `range_max_txt` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`variable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_var`
--

LOCK TABLES `il_qpl_qst_fq_var` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_var` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_var` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_qpl_qst_fq_var_seq`
--

DROP TABLE IF EXISTS `il_qpl_qst_fq_var_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_qpl_qst_fq_var_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_qpl_qst_fq_var_seq`
--

LOCK TABLES `il_qpl_qst_fq_var_seq` WRITE;
/*!40000 ALTER TABLE `il_qpl_qst_fq_var_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_qpl_qst_fq_var_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_rating`
--

DROP TABLE IF EXISTS `il_rating`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_rating` (
  `obj_id` int NOT NULL DEFAULT '0',
  `obj_type` char(10) NOT NULL DEFAULT '',
  `sub_obj_id` int NOT NULL DEFAULT '0',
  `sub_obj_type` char(10) NOT NULL DEFAULT '',
  `user_id` int NOT NULL DEFAULT '0',
  `rating` int NOT NULL DEFAULT '0',
  `category_id` int NOT NULL DEFAULT '0',
  `tstamp` int DEFAULT NULL,
  PRIMARY KEY (`obj_id`,`obj_type`,`sub_obj_id`,`sub_obj_type`,`user_id`,`category_id`),
  KEY `obj_idx` (`obj_id`,`obj_type`,`sub_obj_id`,`sub_obj_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_rating`
--

LOCK TABLES `il_rating` WRITE;
/*!40000 ALTER TABLE `il_rating` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_rating` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_rating_cat`
--

DROP TABLE IF EXISTS `il_rating_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_rating_cat` (
  `id` int NOT NULL DEFAULT '0',
  `parent_id` int NOT NULL DEFAULT '0',
  `title` varchar(100) DEFAULT NULL,
  `description` varchar(1000) DEFAULT NULL,
  `pos` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_rating_cat`
--

LOCK TABLES `il_rating_cat` WRITE;
/*!40000 ALTER TABLE `il_rating_cat` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_rating_cat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_rating_cat_seq`
--

DROP TABLE IF EXISTS `il_rating_cat_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_rating_cat_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_rating_cat_seq`
--

LOCK TABLES `il_rating_cat_seq` WRITE;
/*!40000 ALTER TABLE `il_rating_cat_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_rating_cat_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_resource`
--

DROP TABLE IF EXISTS `il_resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_resource` (
  `rid` varchar(64) NOT NULL DEFAULT '',
  `storage_id` varchar(8) NOT NULL DEFAULT '',
  `rtype` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rid`),
  KEY `i1_idx` (`storage_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_resource`
--

LOCK TABLES `il_resource` WRITE;
/*!40000 ALTER TABLE `il_resource` DISABLE KEYS */;
INSERT INTO `il_resource` VALUES ('032c84cd-ff86-4329-acb9-ac621466f8f9','fsv2',1),('0362da5a-83ee-46b2-b998-e05ab1b931dd','fsv2',1),('0894f32c-32be-45f6-9d8c-1e42dd4e0d3b','fsv2',1),('0dd1bf38-cd5f-4e41-a66c-537491a48c7f','fsv2',1),('0fbc6388-6d90-4bfa-b9a6-58d793425454','fsv2',1),('15ed12e5-9887-4afa-a1a0-9db2ba1e2062','fsv2',1),('2d4bdf6a-b1cb-48c8-97ea-e80bc4f51e6d','fsv2',1),('3e5eb0c5-b332-46e0-be31-f731b049798f','fsv2',1),('42198c75-b1ce-4325-8083-22f34c74d6a2','fsv2',1),('491be3c1-37de-4f36-a73d-f029f49f5fbe','fsv2',1),('4f6aae82-0ac7-48e0-9bf5-88088b2bc7da','fsv2',1),('54931c1f-2016-469e-9fa7-38310a0bb59b','fsv2',1),('585bfe28-f063-4e99-af09-3251ed510154','fsv2',1),('64153991-9fa6-4ad7-b30b-5934a3dc31b2','fsv2',1),('733cdf8f-4405-40e4-8dd1-9832e4399cdd','fsv2',1),('744d8677-181d-4f74-9a5b-3ba402ab4a24','fsv2',1),('795bfcf2-4785-412e-9662-7e15b577e507','fsv2',1),('8ade78bb-960b-4d37-a2e5-8e4b0b6a38ff','fsv2',1),('985a74a9-9852-44f6-869f-ecc691f2ef3b','fsv2',1),('9c42f1e0-7df8-4539-9be6-8e71acd1a744','fsv2',1),('acd07d4c-c68d-4073-8822-200a96b1bd22','fsv2',1),('b23cb8be-ebfa-4356-bd2a-ef38fc683297','fsv2',1),('b53f55e8-4129-4eb4-aee4-7fd0e76a5143','fsv2',1),('e0d14f9e-11d4-43b8-879a-e6827f29947f','fsv2',1),('e117f0a6-1dc4-4b49-9824-fec19b12cf34','fsv2',1),('e865fd84-c395-45c0-b183-51dc4b717fb0','fsv2',1);
/*!40000 ALTER TABLE `il_resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_resource_flavour`
--

DROP TABLE IF EXISTS `il_resource_flavour`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_resource_flavour` (
  `rid` varchar(64) NOT NULL,
  `revision` bigint NOT NULL,
  `definition_id` varchar(64) NOT NULL,
  `variant` varchar(768) NOT NULL,
  PRIMARY KEY (`rid`,`revision`,`definition_id`,`variant`),
  KEY `i1_idx` (`rid`),
  KEY `i3_idx` (`definition_id`),
  KEY `i4_idx` (`variant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_resource_flavour`
--

LOCK TABLES `il_resource_flavour` WRITE;
/*!40000 ALTER TABLE `il_resource_flavour` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_resource_flavour` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_resource_info`
--

DROP TABLE IF EXISTS `il_resource_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_resource_info` (
  `rid` varchar(64) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `suffix` varchar(64) DEFAULT NULL,
  `mime_type` varchar(250) DEFAULT NULL,
  `size` bigint NOT NULL DEFAULT '0',
  `creation_date` bigint NOT NULL DEFAULT '0',
  `version_number` bigint NOT NULL,
  PRIMARY KEY (`rid`,`version_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_resource_info`
--

LOCK TABLES `il_resource_info` WRITE;
/*!40000 ALTER TABLE `il_resource_info` DISABLE KEYS */;
INSERT INTO `il_resource_info` VALUES ('032c84cd-ff86-4329-acb9-ac621466f8f9','icon_file_ods.svg','svg','image/svg+xml',3146,[[timestamp]],1),('0362da5a-83ee-46b2-b998-e05ab1b931dd','icon_file_xml.svg','svg','image/svg+xml',3146,[[timestamp]],1),('0894f32c-32be-45f6-9d8c-1e42dd4e0d3b','icon_file_txt.svg','svg','image/svg+xml',3145,[[timestamp]],1),('0dd1bf38-cd5f-4e41-a66c-537491a48c7f','icon_file_docx.svg','svg','image/svg+xml',3150,[[timestamp]],1),('0fbc6388-6d90-4bfa-b9a6-58d793425454','icon_file_tiff.svg','svg','image/svg+xml',3147,[[timestamp]],1),('15ed12e5-9887-4afa-a1a0-9db2ba1e2062','icon_file_mp4.svg','svg','image/svg+xml',3146,[[timestamp]],1),('2d4bdf6a-b1cb-48c8-97ea-e80bc4f51e6d','icon_file_svg.svg','svg','image/svg+xml',3145,[[timestamp]],1),('3e5eb0c5-b332-46e0-be31-f731b049798f','icon_file_wav.svg','svg','image/svg+xml',3146,[[timestamp]],1),('42198c75-b1ce-4325-8083-22f34c74d6a2','icon_file_flv.svg','svg','image/svg+xml',3146,[[timestamp]],1),('491be3c1-37de-4f36-a73d-f029f49f5fbe','icon_file_pdf.svg','svg','image/svg+xml',3145,[[timestamp]],1),('4f6aae82-0ac7-48e0-9bf5-88088b2bc7da','icon_file_jpg.svg','svg','image/svg+xml',3145,[[timestamp]],1),('54931c1f-2016-469e-9fa7-38310a0bb59b','icon_file_mov.svg','svg','image/svg+xml',3146,[[timestamp]],1),('585bfe28-f063-4e99-af09-3251ed510154','icon_file_odt.svg','svg','image/svg+xml',3146,[[timestamp]],1),('64153991-9fa6-4ad7-b30b-5934a3dc31b2','icon_file_pptx.svg','svg','image/svg+xml',3145,[[timestamp]],1),('733cdf8f-4405-40e4-8dd1-9832e4399cdd','icon_file_bmp.svg','svg','image/svg+xml',3146,[[timestamp]],1),('744d8677-181d-4f74-9a5b-3ba402ab4a24','icon_file_png.svg','svg','image/svg+xml',3145,[[timestamp]],1),('795bfcf2-4785-412e-9662-7e15b577e507','icon_file_ico.svg','svg','image/svg+xml',3146,[[timestamp]],1),('8ade78bb-960b-4d37-a2e5-8e4b0b6a38ff','icon_file_wma.svg','svg','image/svg+xml',3145,[[timestamp]],1),('985a74a9-9852-44f6-869f-ecc691f2ef3b','icon_file_avi.svg','svg','image/svg+xml',3146,[[timestamp]],1),('9c42f1e0-7df8-4539-9be6-8e71acd1a744','icon_file_xlsx.svg','svg','image/svg+xml',3146,[[timestamp]],1),('acd07d4c-c68d-4073-8822-200a96b1bd22','icon_file_md.svg','svg','image/svg+xml',3143,[[timestamp]],1),('b23cb8be-ebfa-4356-bd2a-ef38fc683297','icon_file_rtf.svg','svg','image/svg+xml',3145,[[timestamp]],1),('b53f55e8-4129-4eb4-aee4-7fd0e76a5143','icon_file_odp.svg','svg','image/svg+xml',3146,[[timestamp]],1),('e0d14f9e-11d4-43b8-879a-e6827f29947f','icon_file_csv.svg','svg','image/svg+xml',3146,[[timestamp]],1),('e117f0a6-1dc4-4b49-9824-fec19b12cf34','icon_file_mp3.svg','svg','image/svg+xml',3146,[[timestamp]],1),('e865fd84-c395-45c0-b183-51dc4b717fb0','icon_file_gif.svg','svg','image/svg+xml',3146,[[timestamp]],1);
/*!40000 ALTER TABLE `il_resource_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_resource_rc`
--

DROP TABLE IF EXISTS `il_resource_rc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_resource_rc` (
  `rcid` varchar(64) NOT NULL DEFAULT '',
  `title` varchar(4000) DEFAULT NULL,
  `owner_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`rcid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_resource_rc`
--

LOCK TABLES `il_resource_rc` WRITE;
/*!40000 ALTER TABLE `il_resource_rc` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_resource_rc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_resource_rca`
--

DROP TABLE IF EXISTS `il_resource_rca`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_resource_rca` (
  `rcid` varchar(64) NOT NULL DEFAULT '',
  `rid` varchar(64) NOT NULL DEFAULT '',
  `position` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rcid`,`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_resource_rca`
--

LOCK TABLES `il_resource_rca` WRITE;
/*!40000 ALTER TABLE `il_resource_rca` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_resource_rca` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_resource_revision`
--

DROP TABLE IF EXISTS `il_resource_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_resource_revision` (
  `rid` varchar(64) NOT NULL DEFAULT '',
  `available` tinyint DEFAULT '1',
  `version_number` bigint NOT NULL,
  `owner_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `status` int NOT NULL DEFAULT '10',
  PRIMARY KEY (`rid`,`version_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_resource_revision`
--

LOCK TABLES `il_resource_revision` WRITE;
/*!40000 ALTER TABLE `il_resource_revision` DISABLE KEYS */;
INSERT INTO `il_resource_revision` VALUES ('032c84cd-ff86-4329-acb9-ac621466f8f9',1,1,6,'icon_file_ods.svg',10),('0362da5a-83ee-46b2-b998-e05ab1b931dd',1,1,6,'icon_file_xml.svg',10),('0894f32c-32be-45f6-9d8c-1e42dd4e0d3b',1,1,6,'icon_file_txt.svg',10),('0dd1bf38-cd5f-4e41-a66c-537491a48c7f',1,1,6,'icon_file_docx.svg',10),('0fbc6388-6d90-4bfa-b9a6-58d793425454',1,1,6,'icon_file_tiff.svg',10),('15ed12e5-9887-4afa-a1a0-9db2ba1e2062',1,1,6,'icon_file_mp4.svg',10),('2d4bdf6a-b1cb-48c8-97ea-e80bc4f51e6d',1,1,6,'icon_file_svg.svg',10),('3e5eb0c5-b332-46e0-be31-f731b049798f',1,1,6,'icon_file_wav.svg',10),('42198c75-b1ce-4325-8083-22f34c74d6a2',1,1,6,'icon_file_flv.svg',10),('491be3c1-37de-4f36-a73d-f029f49f5fbe',1,1,6,'icon_file_pdf.svg',10),('4f6aae82-0ac7-48e0-9bf5-88088b2bc7da',1,1,6,'icon_file_jpg.svg',10),('54931c1f-2016-469e-9fa7-38310a0bb59b',1,1,6,'icon_file_mov.svg',10),('585bfe28-f063-4e99-af09-3251ed510154',1,1,6,'icon_file_odt.svg',10),('64153991-9fa6-4ad7-b30b-5934a3dc31b2',1,1,6,'icon_file_pptx.svg',10),('733cdf8f-4405-40e4-8dd1-9832e4399cdd',1,1,6,'icon_file_bmp.svg',10),('744d8677-181d-4f74-9a5b-3ba402ab4a24',1,1,6,'icon_file_png.svg',10),('795bfcf2-4785-412e-9662-7e15b577e507',1,1,6,'icon_file_ico.svg',10),('8ade78bb-960b-4d37-a2e5-8e4b0b6a38ff',1,1,6,'icon_file_wma.svg',10),('985a74a9-9852-44f6-869f-ecc691f2ef3b',1,1,6,'icon_file_avi.svg',10),('9c42f1e0-7df8-4539-9be6-8e71acd1a744',1,1,6,'icon_file_xlsx.svg',10),('acd07d4c-c68d-4073-8822-200a96b1bd22',1,1,6,'icon_file_md.svg',10),('b23cb8be-ebfa-4356-bd2a-ef38fc683297',1,1,6,'icon_file_rtf.svg',10),('b53f55e8-4129-4eb4-aee4-7fd0e76a5143',1,1,6,'icon_file_odp.svg',10),('e0d14f9e-11d4-43b8-879a-e6827f29947f',1,1,6,'icon_file_csv.svg',10),('e117f0a6-1dc4-4b49-9824-fec19b12cf34',1,1,6,'icon_file_mp3.svg',10),('e865fd84-c395-45c0-b183-51dc4b717fb0',1,1,6,'icon_file_gif.svg',10);
/*!40000 ALTER TABLE `il_resource_revision` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_resource_stkh`
--

DROP TABLE IF EXISTS `il_resource_stkh`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_resource_stkh` (
  `id` varchar(64) NOT NULL DEFAULT '',
  `class_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_resource_stkh`
--

LOCK TABLES `il_resource_stkh` WRITE;
/*!40000 ALTER TABLE `il_resource_stkh` DISABLE KEYS */;
INSERT INTO `il_resource_stkh` VALUES ('file_icon','ILIAS\\File\\Icon\\ilObjFileIconStakeholder');
/*!40000 ALTER TABLE `il_resource_stkh` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_resource_stkh_u`
--

DROP TABLE IF EXISTS `il_resource_stkh_u`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_resource_stkh_u` (
  `rid` varchar(64) NOT NULL DEFAULT '',
  `stakeholder_id` varchar(64) NOT NULL,
  PRIMARY KEY (`rid`,`stakeholder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_resource_stkh_u`
--

LOCK TABLES `il_resource_stkh_u` WRITE;
/*!40000 ALTER TABLE `il_resource_stkh_u` DISABLE KEYS */;
INSERT INTO `il_resource_stkh_u` VALUES ('032c84cd-ff86-4329-acb9-ac621466f8f9','file_icon'),('0362da5a-83ee-46b2-b998-e05ab1b931dd','file_icon'),('0894f32c-32be-45f6-9d8c-1e42dd4e0d3b','file_icon'),('0dd1bf38-cd5f-4e41-a66c-537491a48c7f','file_icon'),('0fbc6388-6d90-4bfa-b9a6-58d793425454','file_icon'),('15ed12e5-9887-4afa-a1a0-9db2ba1e2062','file_icon'),('2d4bdf6a-b1cb-48c8-97ea-e80bc4f51e6d','file_icon'),('3e5eb0c5-b332-46e0-be31-f731b049798f','file_icon'),('42198c75-b1ce-4325-8083-22f34c74d6a2','file_icon'),('491be3c1-37de-4f36-a73d-f029f49f5fbe','file_icon'),('4f6aae82-0ac7-48e0-9bf5-88088b2bc7da','file_icon'),('54931c1f-2016-469e-9fa7-38310a0bb59b','file_icon'),('585bfe28-f063-4e99-af09-3251ed510154','file_icon'),('64153991-9fa6-4ad7-b30b-5934a3dc31b2','file_icon'),('733cdf8f-4405-40e4-8dd1-9832e4399cdd','file_icon'),('744d8677-181d-4f74-9a5b-3ba402ab4a24','file_icon'),('795bfcf2-4785-412e-9662-7e15b577e507','file_icon'),('8ade78bb-960b-4d37-a2e5-8e4b0b6a38ff','file_icon'),('985a74a9-9852-44f6-869f-ecc691f2ef3b','file_icon'),('9c42f1e0-7df8-4539-9be6-8e71acd1a744','file_icon'),('acd07d4c-c68d-4073-8822-200a96b1bd22','file_icon'),('b23cb8be-ebfa-4356-bd2a-ef38fc683297','file_icon'),('b53f55e8-4129-4eb4-aee4-7fd0e76a5143','file_icon'),('e0d14f9e-11d4-43b8-879a-e6827f29947f','file_icon'),('e117f0a6-1dc4-4b49-9824-fec19b12cf34','file_icon'),('e865fd84-c395-45c0-b183-51dc4b717fb0','file_icon');
/*!40000 ALTER TABLE `il_resource_stkh_u` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_subscribers`
--

DROP TABLE IF EXISTS `il_subscribers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_subscribers` (
  `usr_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `subject` varchar(4000) DEFAULT NULL,
  `sub_time` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`usr_id`,`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_subscribers`
--

LOCK TABLES `il_subscribers` WRITE;
/*!40000 ALTER TABLE `il_subscribers` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_subscribers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_tag`
--

DROP TABLE IF EXISTS `il_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_tag` (
  `obj_id` int NOT NULL DEFAULT '0',
  `obj_type` char(10) NOT NULL DEFAULT '',
  `sub_obj_id` int NOT NULL DEFAULT '0',
  `sub_obj_type` char(10) NOT NULL DEFAULT '',
  `user_id` int NOT NULL DEFAULT '0',
  `tag` varchar(100) NOT NULL DEFAULT ' ',
  `is_offline` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`obj_type`,`sub_obj_id`,`sub_obj_type`,`user_id`,`tag`),
  KEY `i1_idx` (`obj_id`,`obj_type`,`sub_obj_id`,`sub_obj_type`),
  KEY `i2_idx` (`tag`),
  KEY `i3_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_tag`
--

LOCK TABLES `il_tag` WRITE;
/*!40000 ALTER TABLE `il_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_translations`
--

DROP TABLE IF EXISTS `il_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_translations` (
  `id` int NOT NULL DEFAULT '0',
  `id_type` varchar(50) NOT NULL DEFAULT '',
  `lang_code` varchar(2) NOT NULL DEFAULT '',
  `title` varchar(256) DEFAULT NULL,
  `description` varchar(512) DEFAULT NULL,
  `lang_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`id_type`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_translations`
--

LOCK TABLES `il_translations` WRITE;
/*!40000 ALTER TABLE `il_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_upload_policy`
--

DROP TABLE IF EXISTS `il_upload_policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_upload_policy` (
  `policy_id` bigint NOT NULL,
  `title` varchar(256) NOT NULL,
  `upload_limit_in_mb` bigint NOT NULL,
  `audience` varchar(512) NOT NULL,
  `audience_type` smallint NOT NULL,
  `scope_definition` varchar(512) NOT NULL,
  `active` tinyint NOT NULL,
  `valid_from` date DEFAULT NULL,
  `valid_until` date DEFAULT NULL,
  `owner` bigint NOT NULL,
  `create_date` datetime NOT NULL,
  `last_update` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_upload_policy`
--

LOCK TABLES `il_upload_policy` WRITE;
/*!40000 ALTER TABLE `il_upload_policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_upload_policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_upload_policy_seq`
--

DROP TABLE IF EXISTS `il_upload_policy_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_upload_policy_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_upload_policy_seq`
--

LOCK TABLES `il_upload_policy_seq` WRITE;
/*!40000 ALTER TABLE `il_upload_policy_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_upload_policy_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_verification`
--

DROP TABLE IF EXISTS `il_verification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_verification` (
  `id` int NOT NULL DEFAULT '0',
  `type` varchar(100) NOT NULL DEFAULT '',
  `parameters` varchar(1000) DEFAULT NULL,
  `raw_data` longtext,
  PRIMARY KEY (`id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_verification`
--

LOCK TABLES `il_verification` WRITE;
/*!40000 ALTER TABLE `il_verification` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_verification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_wac_secure_path`
--

DROP TABLE IF EXISTS `il_wac_secure_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_wac_secure_path` (
  `path` varchar(64) NOT NULL DEFAULT ' ',
  `component_directory` varchar(256) DEFAULT NULL,
  `checking_class` varchar(256) DEFAULT NULL,
  `in_sec_folder` tinyint DEFAULT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_wac_secure_path`
--

LOCK TABLES `il_wac_secure_path` WRITE;
/*!40000 ALTER TABLE `il_wac_secure_path` DISABLE KEYS */;
INSERT INTO `il_wac_secure_path` VALUES ('assessment','[[softpath]]/components/ILIAS/Test','ilObjTestAccess',0),('chatroom','[[softpath]]/components/ILIAS/Chatroom','ilObjChatroomAccess',0),('container_data','[[softpath]]/components/ILIAS/Container','ilContainerAccess',0),('css','[[softpath]]/components/ILIAS/Style','ilContentStyleWAC',0),('custom_icons','[[softpath]]/components/ILIAS/ILIASObject','ilObjectAccess',0),('ilBadge','[[softpath]]/components/ILIAS/Badge','ilBadgeWAC',1),('ilBlog','[[softpath]]/components/ILIAS/Blog','ilObjBlogAccess',1),('ilBookingManager','[[softpath]]/components/ILIAS/BookingManager','ilObjBookingPoolAccess',0),('ilExercise','[[softpath]]/components/ILIAS/Exercise','ilObjExerciseAccess',0),('ilPoll','[[softpath]]/components/ILIAS/Poll','ilObjPollAccess',1),('ilPortfolio','[[softpath]]/components/ILIAS/Portfolio','ilPortfolioAccessHandler',1),('lm_data','[[softpath]]/components/ILIAS/LearningModule','ilObjLearningModuleAccess',0),('mobs','[[softpath]]/components/ILIAS/MediaObjects','ilObjMediaObjectAccess',0),('previews','[[softpath]]/components/ILIAS/File','ilObjFileAccess',0),('rs','[[softpath]]/components/ILIAS/ResourceStorage','ilWACSignedResourceStorage',1),('thumbs','[[softpath]]/components/ILIAS/MediaObjects','ilObjMediaObjectAccess',0),('usr_images','[[softpath]]/components/ILIAS/User','ilObjUserAccess',0);
/*!40000 ALTER TABLE `il_wac_secure_path` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_wiki_contributor`
--

DROP TABLE IF EXISTS `il_wiki_contributor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_wiki_contributor` (
  `wiki_id` int NOT NULL DEFAULT '0',
  `user_id` int NOT NULL DEFAULT '0',
  `status` int DEFAULT NULL,
  `status_time` datetime DEFAULT NULL,
  PRIMARY KEY (`wiki_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_wiki_contributor`
--

LOCK TABLES `il_wiki_contributor` WRITE;
/*!40000 ALTER TABLE `il_wiki_contributor` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_wiki_contributor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_wiki_data`
--

DROP TABLE IF EXISTS `il_wiki_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_wiki_data` (
  `id` int NOT NULL DEFAULT '0',
  `startpage` varchar(200) DEFAULT NULL,
  `short` varchar(20) DEFAULT NULL,
  `is_online` tinyint DEFAULT '0',
  `rating` tinyint DEFAULT '0',
  `introduction` longtext,
  `public_notes` tinyint DEFAULT '1',
  `imp_pages` tinyint DEFAULT NULL,
  `page_toc` tinyint DEFAULT NULL,
  `rating_side` tinyint NOT NULL DEFAULT '0',
  `rating_new` tinyint NOT NULL DEFAULT '0',
  `rating_ext` tinyint NOT NULL DEFAULT '0',
  `rating_overall` tinyint DEFAULT '0',
  `empty_page_templ` tinyint NOT NULL DEFAULT '1',
  `link_md_values` tinyint DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_wiki_data`
--

LOCK TABLES `il_wiki_data` WRITE;
/*!40000 ALTER TABLE `il_wiki_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_wiki_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_wiki_imp_pages`
--

DROP TABLE IF EXISTS `il_wiki_imp_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_wiki_imp_pages` (
  `wiki_id` int NOT NULL DEFAULT '0',
  `ord` int NOT NULL DEFAULT '0',
  `indent` tinyint NOT NULL DEFAULT '0',
  `page_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`wiki_id`,`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_wiki_imp_pages`
--

LOCK TABLES `il_wiki_imp_pages` WRITE;
/*!40000 ALTER TABLE `il_wiki_imp_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_wiki_imp_pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_wiki_missing_page`
--

DROP TABLE IF EXISTS `il_wiki_missing_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_wiki_missing_page` (
  `wiki_id` int NOT NULL DEFAULT '0',
  `source_id` int NOT NULL DEFAULT '0',
  `target_name` varchar(200) NOT NULL DEFAULT '',
  `lang` varchar(5) NOT NULL DEFAULT '-',
  PRIMARY KEY (`wiki_id`,`source_id`,`target_name`,`lang`),
  KEY `i1_idx` (`wiki_id`,`target_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_wiki_missing_page`
--

LOCK TABLES `il_wiki_missing_page` WRITE;
/*!40000 ALTER TABLE `il_wiki_missing_page` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_wiki_missing_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_wiki_page`
--

DROP TABLE IF EXISTS `il_wiki_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_wiki_page` (
  `id` int NOT NULL DEFAULT '0',
  `title` varchar(200) DEFAULT NULL,
  `wiki_id` int NOT NULL DEFAULT '0',
  `blocked` tinyint DEFAULT NULL,
  `rating` tinyint NOT NULL DEFAULT '0',
  `hide_adv_md` tinyint DEFAULT '0',
  `lang` varchar(10) NOT NULL DEFAULT '-',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_wiki_page`
--

LOCK TABLES `il_wiki_page` WRITE;
/*!40000 ALTER TABLE `il_wiki_page` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_wiki_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `il_wiki_page_seq`
--

DROP TABLE IF EXISTS `il_wiki_page_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `il_wiki_page_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `il_wiki_page_seq`
--

LOCK TABLES `il_wiki_page_seq` WRITE;
/*!40000 ALTER TABLE `il_wiki_page_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `il_wiki_page_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `int_link`
--

DROP TABLE IF EXISTS `int_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `int_link` (
  `source_type` varchar(10) NOT NULL DEFAULT ' ',
  `source_id` int NOT NULL DEFAULT '0',
  `target_type` varchar(10) NOT NULL DEFAULT ' ',
  `target_id` int NOT NULL DEFAULT '0',
  `target_inst` int NOT NULL DEFAULT '0',
  `source_lang` varchar(2) NOT NULL DEFAULT '-',
  PRIMARY KEY (`source_type`,`source_id`,`source_lang`,`target_type`,`target_id`,`target_inst`),
  KEY `ta_idx` (`target_type`,`target_id`,`target_inst`),
  KEY `so_idx` (`source_type`,`source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `int_link`
--

LOCK TABLES `int_link` WRITE;
/*!40000 ALTER TABLE `int_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `int_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `item_group_item`
--

DROP TABLE IF EXISTS `item_group_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `item_group_item` (
  `item_group_id` int NOT NULL DEFAULT '0',
  `item_ref_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_group_id`,`item_ref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `item_group_item`
--

LOCK TABLES `item_group_item` WRITE;
/*!40000 ALTER TABLE `item_group_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `item_group_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `itgr_data`
--

DROP TABLE IF EXISTS `itgr_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `itgr_data` (
  `id` int NOT NULL DEFAULT '0',
  `hide_title` tinyint NOT NULL DEFAULT '0',
  `behaviour` tinyint DEFAULT '0',
  `list_presentation` varchar(10) DEFAULT NULL,
  `tile_size` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `itgr_data`
--

LOCK TABLES `itgr_data` WRITE;
/*!40000 ALTER TABLE `itgr_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `itgr_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `last_visited`
--

DROP TABLE IF EXISTS `last_visited`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `last_visited` (
  `user_id` int NOT NULL DEFAULT '0',
  `nr` int NOT NULL DEFAULT '0',
  `ref_id` int NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL DEFAULT '',
  `sub_obj_id` varchar(40) DEFAULT NULL,
  `goto_link` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`nr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `last_visited`
--

LOCK TABLES `last_visited` WRITE;
/*!40000 ALTER TABLE `last_visited` DISABLE KEYS */;
/*!40000 ALTER TABLE `last_visited` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldap_attribute_mapping`
--

DROP TABLE IF EXISTS `ldap_attribute_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldap_attribute_mapping` (
  `server_id` int NOT NULL DEFAULT '0',
  `keyword` varchar(32) NOT NULL DEFAULT ' ',
  `value` varchar(255) DEFAULT NULL,
  `perform_update` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`server_id`,`keyword`),
  KEY `i1_idx` (`server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldap_attribute_mapping`
--

LOCK TABLES `ldap_attribute_mapping` WRITE;
/*!40000 ALTER TABLE `ldap_attribute_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldap_attribute_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldap_rg_mapping`
--

DROP TABLE IF EXISTS `ldap_rg_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldap_rg_mapping` (
  `mapping_id` int NOT NULL DEFAULT '0',
  `server_id` int NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT NULL,
  `dn` varchar(255) DEFAULT NULL,
  `member_attribute` varchar(64) DEFAULT NULL,
  `member_isdn` tinyint NOT NULL DEFAULT '0',
  `role` int NOT NULL DEFAULT '0',
  `mapping_info` varchar(4000) DEFAULT NULL,
  `mapping_info_type` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`mapping_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldap_rg_mapping`
--

LOCK TABLES `ldap_rg_mapping` WRITE;
/*!40000 ALTER TABLE `ldap_rg_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldap_rg_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldap_rg_mapping_seq`
--

DROP TABLE IF EXISTS `ldap_rg_mapping_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldap_rg_mapping_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldap_rg_mapping_seq`
--

LOCK TABLES `ldap_rg_mapping_seq` WRITE;
/*!40000 ALTER TABLE `ldap_rg_mapping_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldap_rg_mapping_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldap_role_assignments`
--

DROP TABLE IF EXISTS `ldap_role_assignments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldap_role_assignments` (
  `server_id` int NOT NULL DEFAULT '0',
  `rule_id` int NOT NULL DEFAULT '0',
  `type` tinyint NOT NULL DEFAULT '0',
  `dn` varchar(1000) DEFAULT NULL,
  `attribute` varchar(32) DEFAULT NULL,
  `isdn` tinyint NOT NULL DEFAULT '0',
  `att_name` varchar(255) DEFAULT NULL,
  `att_value` varchar(255) DEFAULT NULL,
  `role_id` int NOT NULL DEFAULT '0',
  `add_on_update` tinyint DEFAULT NULL,
  `remove_on_update` tinyint DEFAULT NULL,
  `plugin_id` int DEFAULT NULL,
  PRIMARY KEY (`server_id`,`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldap_role_assignments`
--

LOCK TABLES `ldap_role_assignments` WRITE;
/*!40000 ALTER TABLE `ldap_role_assignments` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldap_role_assignments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldap_role_assignments_seq`
--

DROP TABLE IF EXISTS `ldap_role_assignments_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldap_role_assignments_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldap_role_assignments_seq`
--

LOCK TABLES `ldap_role_assignments_seq` WRITE;
/*!40000 ALTER TABLE `ldap_role_assignments_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldap_role_assignments_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldap_server_settings`
--

DROP TABLE IF EXISTS `ldap_server_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldap_server_settings` (
  `server_id` int NOT NULL DEFAULT '0',
  `active` int NOT NULL DEFAULT '0',
  `name` varchar(32) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `version` int NOT NULL DEFAULT '0',
  `base_dn` varchar(255) DEFAULT NULL,
  `referrals` int NOT NULL DEFAULT '0',
  `tls` int NOT NULL DEFAULT '0',
  `bind_type` int NOT NULL DEFAULT '0',
  `bind_user` varchar(255) DEFAULT NULL,
  `bind_pass` varchar(100) DEFAULT NULL,
  `search_base` varchar(255) DEFAULT NULL,
  `user_scope` tinyint NOT NULL DEFAULT '0',
  `user_attribute` varchar(255) DEFAULT NULL,
  `filter` varchar(512) DEFAULT NULL,
  `group_dn` varchar(255) DEFAULT NULL,
  `group_scope` tinyint NOT NULL DEFAULT '0',
  `group_filter` varchar(255) DEFAULT NULL,
  `group_member` varchar(255) DEFAULT NULL,
  `group_memberisdn` tinyint NOT NULL DEFAULT '0',
  `group_name` varchar(255) DEFAULT NULL,
  `group_attribute` varchar(64) DEFAULT NULL,
  `group_optional` tinyint NOT NULL DEFAULT '0',
  `group_user_filter` varchar(255) DEFAULT NULL,
  `sync_on_login` tinyint NOT NULL DEFAULT '0',
  `sync_per_cron` tinyint NOT NULL DEFAULT '0',
  `role_sync_active` tinyint NOT NULL DEFAULT '0',
  `role_bind_dn` varchar(255) DEFAULT NULL,
  `role_bind_pass` varchar(100) DEFAULT NULL,
  `migration` tinyint NOT NULL DEFAULT '0',
  `authentication` tinyint NOT NULL DEFAULT '1',
  `authentication_type` tinyint NOT NULL DEFAULT '0',
  `username_filter` varchar(255) DEFAULT NULL,
  `escape_dn` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldap_server_settings`
--

LOCK TABLES `ldap_server_settings` WRITE;
/*!40000 ALTER TABLE `ldap_server_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldap_server_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldap_server_settings_seq`
--

DROP TABLE IF EXISTS `ldap_server_settings_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldap_server_settings_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldap_server_settings_seq`
--

LOCK TABLES `ldap_server_settings_seq` WRITE;
/*!40000 ALTER TABLE `ldap_server_settings_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldap_server_settings_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldoc_acceptance_track`
--

DROP TABLE IF EXISTS `ldoc_acceptance_track`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldoc_acceptance_track` (
  `tosv_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `ts` int NOT NULL DEFAULT '0',
  `criteria` longtext,
  PRIMARY KEY (`tosv_id`,`usr_id`,`ts`),
  KEY `i1_idx` (`usr_id`,`ts`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldoc_acceptance_track`
--

LOCK TABLES `ldoc_acceptance_track` WRITE;
/*!40000 ALTER TABLE `ldoc_acceptance_track` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldoc_acceptance_track` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldoc_acceptance_track_seq`
--

DROP TABLE IF EXISTS `ldoc_acceptance_track_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldoc_acceptance_track_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldoc_acceptance_track_seq`
--

LOCK TABLES `ldoc_acceptance_track_seq` WRITE;
/*!40000 ALTER TABLE `ldoc_acceptance_track_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldoc_acceptance_track_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldoc_criteria`
--

DROP TABLE IF EXISTS `ldoc_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldoc_criteria` (
  `id` int NOT NULL DEFAULT '0',
  `doc_id` int NOT NULL DEFAULT '0',
  `criterion_id` varchar(50) NOT NULL,
  `criterion_value` varchar(255) DEFAULT NULL,
  `assigned_ts` int NOT NULL DEFAULT '0',
  `modification_ts` int NOT NULL DEFAULT '0',
  `owner_usr_id` int NOT NULL DEFAULT '0',
  `last_modified_usr_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldoc_criteria`
--

LOCK TABLES `ldoc_criteria` WRITE;
/*!40000 ALTER TABLE `ldoc_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldoc_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldoc_criteria_seq`
--

DROP TABLE IF EXISTS `ldoc_criteria_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldoc_criteria_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldoc_criteria_seq`
--

LOCK TABLES `ldoc_criteria_seq` WRITE;
/*!40000 ALTER TABLE `ldoc_criteria_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldoc_criteria_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldoc_documents`
--

DROP TABLE IF EXISTS `ldoc_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldoc_documents` (
  `id` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `creation_ts` int NOT NULL DEFAULT '0',
  `modification_ts` int NOT NULL DEFAULT '0',
  `sorting` int NOT NULL DEFAULT '0',
  `owner_usr_id` int NOT NULL DEFAULT '0',
  `last_modified_usr_id` int NOT NULL DEFAULT '0',
  `text` longtext,
  `provider` varchar(255) NOT NULL DEFAULT 'tos',
  `hash` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT 'html',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldoc_documents`
--

LOCK TABLES `ldoc_documents` WRITE;
/*!40000 ALTER TABLE `ldoc_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldoc_documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldoc_documents_seq`
--

DROP TABLE IF EXISTS `ldoc_documents_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldoc_documents_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldoc_documents_seq`
--

LOCK TABLES `ldoc_documents_seq` WRITE;
/*!40000 ALTER TABLE `ldoc_documents_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldoc_documents_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldoc_versions`
--

DROP TABLE IF EXISTS `ldoc_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldoc_versions` (
  `id` int NOT NULL DEFAULT '0',
  `text` longtext,
  `hash` varchar(32) DEFAULT NULL,
  `ts` int NOT NULL DEFAULT '0',
  `doc_id` int NOT NULL DEFAULT '0',
  `title` text,
  `type` varchar(255) NOT NULL DEFAULT 'html',
  `provider` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`hash`,`doc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldoc_versions`
--

LOCK TABLES `ldoc_versions` WRITE;
/*!40000 ALTER TABLE `ldoc_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldoc_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ldoc_versions_seq`
--

DROP TABLE IF EXISTS `ldoc_versions_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ldoc_versions_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ldoc_versions_seq`
--

LOCK TABLES `ldoc_versions_seq` WRITE;
/*!40000 ALTER TABLE `ldoc_versions_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `ldoc_versions_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `like_data`
--

DROP TABLE IF EXISTS `like_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `like_data` (
  `user_id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `obj_type` varchar(40) NOT NULL,
  `sub_obj_id` int NOT NULL DEFAULT '0',
  `sub_obj_type` varchar(40) NOT NULL,
  `news_id` int NOT NULL DEFAULT '0',
  `like_type` int NOT NULL DEFAULT '0',
  `exp_ts` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`obj_id`,`obj_type`,`sub_obj_id`,`sub_obj_type`,`news_id`,`like_type`),
  KEY `i1_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `like_data`
--

LOCK TABLES `like_data` WRITE;
/*!40000 ALTER TABLE `like_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `like_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `link_check`
--

DROP TABLE IF EXISTS `link_check`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `link_check` (
  `id` int NOT NULL DEFAULT '0',
  `obj_id` int NOT NULL DEFAULT '0',
  `page_id` int NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT NULL,
  `parent_type` varchar(8) DEFAULT NULL,
  `http_status_code` int NOT NULL DEFAULT '0',
  `last_check` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `link_check`
--

LOCK TABLES `link_check` WRITE;
/*!40000 ALTER TABLE `link_check` DISABLE KEYS */;
/*!40000 ALTER TABLE `link_check` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `link_check_report`
--

DROP TABLE IF EXISTS `link_check_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `link_check_report` (
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `link_check_report`
--

LOCK TABLES `link_check_report` WRITE;
/*!40000 ALTER TABLE `link_check_report` DISABLE KEYS */;
/*!40000 ALTER TABLE `link_check_report` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `link_check_seq`
--

DROP TABLE IF EXISTS `link_check_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `link_check_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `link_check_seq`
--

LOCK TABLES `link_check_seq` WRITE;
/*!40000 ALTER TABLE `link_check_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `link_check_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lm_data`
--

DROP TABLE IF EXISTS `lm_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lm_data` (
  `obj_id` int NOT NULL DEFAULT '0',
  `title` varchar(200) DEFAULT NULL,
  `type` char(2) DEFAULT NULL,
  `lm_id` int NOT NULL DEFAULT '0',
  `import_id` varchar(50) DEFAULT NULL,
  `public_access` char(1) DEFAULT 'n',
  `create_date` datetime DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `active` char(1) DEFAULT 'y',
  `layout` varchar(100) DEFAULT NULL,
  `short_title` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`obj_id`),
  KEY `i1_idx` (`lm_id`),
  KEY `i2_idx` (`type`),
  KEY `im_idx` (`import_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lm_data`
--

LOCK TABLES `lm_data` WRITE;
/*!40000 ALTER TABLE `lm_data` DISABLE KEYS */;
INSERT INTO `lm_data` VALUES (1,'dummy','du',0,'','n',NULL,NULL,'y','',NULL);
/*!40000 ALTER TABLE `lm_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lm_data_seq`
--

DROP TABLE IF EXISTS `lm_data_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lm_data_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lm_data_seq`
--

LOCK TABLES `lm_data_seq` WRITE;
/*!40000 ALTER TABLE `lm_data_seq` DISABLE KEYS */;
INSERT INTO `lm_data_seq` VALUES (1);
/*!40000 ALTER TABLE `lm_data_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lm_data_transl`
--

DROP TABLE IF EXISTS `lm_data_transl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lm_data_transl` (
  `id` int NOT NULL DEFAULT '0',
  `lang` varchar(2) NOT NULL DEFAULT '',
  `title` varchar(200) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `short_title` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lm_data_transl`
--

LOCK TABLES `lm_data_transl` WRITE;
/*!40000 ALTER TABLE `lm_data_transl` DISABLE KEYS */;
/*!40000 ALTER TABLE `lm_data_transl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lm_glossaries`
--

DROP TABLE IF EXISTS `lm_glossaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lm_glossaries` (
  `lm_id` int NOT NULL DEFAULT '0',
  `glo_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`lm_id`,`glo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lm_glossaries`
--

LOCK TABLES `lm_glossaries` WRITE;
/*!40000 ALTER TABLE `lm_glossaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `lm_glossaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lm_menu`
--

DROP TABLE IF EXISTS `lm_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lm_menu` (
  `id` int NOT NULL DEFAULT '0',
  `lm_id` int NOT NULL DEFAULT '0',
  `link_type` char(6) DEFAULT 'extern',
  `title` varchar(200) DEFAULT NULL,
  `target` varchar(200) DEFAULT NULL,
  `link_ref_id` int DEFAULT NULL,
  `active` char(1) DEFAULT 'n',
  PRIMARY KEY (`id`),
  KEY `i1_idx` (`link_type`),
  KEY `i2_idx` (`lm_id`),
  KEY `i3_idx` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lm_menu`
--

LOCK TABLES `lm_menu` WRITE;
/*!40000 ALTER TABLE `lm_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `lm_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lm_menu_seq`
--

DROP TABLE IF EXISTS `lm_menu_seq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lm_menu_seq` (
  `sequence` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lm_menu_seq`
--

LOCK TABLES `lm_menu_seq` WRITE;
/*!40000 ALTER TABLE `lm_menu_seq` DISABLE KEYS */;
/*!40000 ALTER TABLE `lm_menu_seq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lm_read_event`
--

DROP TABLE IF EXISTS `lm_read_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lm_read_event` (
  `obj_id` int NOT NULL DEFAULT '0',
  `usr_id` int NOT NULL DEFAULT '0',
  `read_count` int NOT NULL DEFAULT '0',
  `spent_seconds` int NOT NULL DEFAULT '0',
  `last_access` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`obj_id`,`usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lm_read_event`
--

LOCK TABLES `lm_read_event` WRITE;
/*!40000 ALTER TABLE `lm_read_event` DISABLE KEYS */;
/*!40000 ALTER TABLE `lm_read_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lm_tree`
--

DROP TABLE IF EXISTS `lm_tree`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lm_tree` (
  `lm_id` int NOT NULL DEFAULT '0',
  `child` int NOT NULL DEFAULT '0',
  `parent` int DEFAULT NULL,
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `depth` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`lm_id`,`child`),
  KEY `i1_idx` (`child`),
  KEY `i2_idx` (`parent`),
  KEY `i3_idx` (`lm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lm_tree`
--

LOCK TABLES `lm_tree` WRITE;
/*!40000 ALTER TABLE `lm_tree` DISABLE KEYS */;
/*!40000 ALTER TABLE `lm_tree` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lng_data`
--

DROP TABLE IF EXISTS `lng_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lng_data` (
  `module` varchar(30) NOT NULL DEFAULT ' ',
  `identifier` varchar(200) NOT NULL DEFAULT ' ',
  `lang_key` char(2) NOT NULL DEFAULT '',
  `value` varchar(4000) DEFAULT NULL,
  `local_change` datetime DEFAULT NULL,
  `remarks` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`module`,`identifier`,`lang_key`),
  KEY `i1_idx` (`module`),
  KEY `i2_idx` (`lang_key`),
  KEY `i3_idx` (`local_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lng_data`
--

LOCK TABLES `lng_data` WRITE;
/*!40000 ALTER TABLE `lng_data` DISABLE KEYS */;
INSERT INTO `lng_data` VALUES ('acc','acc_add_document_btn_label','en','Add Document',NULL,NULL),('acc','acc_criterion_assignment_must_be_unique_insert','en','It is not possible to set the language you have selected as the criterion for displaying this document, as it has already been set as the criterion for displaying a different Accessibility document.',NULL,NULL),('acc','acc_criterion_assignment_must_be_unique_update','en','It is not possible to change the criterion for displaying this document to the language you have selected. That language is being used as the criterion for displaying a different Accessibility document.',NULL,NULL),('acc','acc_crit_type_usr_language','en','Profile Language',NULL,NULL),('acc','acc_ctrl_cpt_txt','en','Accessibility Documents',NULL,NULL),('acc','acc_deleted_documents_p','en','The documents have been deleted.',NULL,NULL),('acc','acc_deleted_documents_s','en','The document has been deleted.',NULL,NULL),('acc','acc_document','en','Document',NULL,NULL),('acc','acc_doc_crit_attached','en','The criterion for displaying this Accessibility document has been set successfully.',NULL,NULL),('acc','acc_doc_crit_changed','en','The criterion for displaying this Accessibility document has been changed.',NULL,NULL),('acc','acc_doc_crit_detached','en','The criterion for displaying this Accessibility document has been removed.',NULL,NULL),('acc','acc_doc_delete','en','Delete Document',NULL,NULL),('acc','acc_doc_detach_crit_confirm_title','en','Remove Language Criterion',NULL,NULL),('acc','acc_doc_sure_detach_crit','en','Are you sure that you no longer want this language to be the criterion for displaying this Accessibility document?',NULL,NULL),('acc','acc_form_attach_criterion_head','en','Select Language Criterion for Displaying Accessibility Info Document',NULL,NULL),('acc','acc_form_criterion','en','Criterion',NULL,NULL),('acc','acc_form_document','en','Document',NULL,NULL),('acc','acc_form_document_content_changed','en','The uploaded file has had its html &lt;head&gt; information removed by ILIAS. Please check the result and upload a new file if necessary.',NULL,NULL),('acc','acc_form_document_info','en','Please select a file from your local filesystem. You can either upload a plain text file, or a simple HTML file. HTML files will have their &lt;head&gt; information removed – only the contents of the body element will be used.',NULL,NULL),('acc','acc_form_document_new','en','Change Content',NULL,NULL),('acc','acc_form_document_new_info','en','Here you can select a file from your local filesystem to change the contents of this Accessibility document. You can either upload a plain text file, or a simple HTML file. HTML files will have their &lt;head&gt; information removed - only the contents of the body element will be used. The existing contents of the Accessibility document will be replaced. The document’s acceptance history will not be affected.',NULL,NULL),('acc','acc_form_document_title','en','Title',NULL,NULL),('acc','acc_form_document_title_info','en','Please enter a title for the document.',NULL,NULL),('acc','acc_form_edit_criterion_head','en','Edit Language Criterion',NULL,NULL),('acc','acc_form_edit_doc_head','en','Edit Document',NULL,NULL),('acc','acc_form_new_doc_head','en','Create Document',NULL,NULL),('acc','acc_forward_mail','en','Forward Mail',NULL,NULL),('acc','acc_function','en','Function',NULL,NULL),('acc','acc_last_rep_visited','en','Repository/Last Visited',NULL,NULL),('acc','acc_saved_sorting','en','The new order has been saved.',NULL,NULL),('acc','acc_sure_delete_documents_p','en','Are you sure you want to delete the selected documents?',NULL,NULL),('acc','acc_sure_delete_documents_s','en','Are you sure you want to delete this document?',NULL,NULL),('acc','acc_tbl_docs_action_add_criterion','en','Add Criterion',NULL,NULL),('acc','acc_tbl_docs_cell_not_criterion','en','No language criterion assigned',NULL,NULL),('acc','acc_tbl_docs_head_created','en','Creation Date',NULL,NULL),('acc','acc_tbl_docs_head_criteria','en','Criterion',NULL,NULL),('acc','acc_tbl_docs_head_last_change','en','Last Change',NULL,NULL),('acc','acc_tbl_docs_head_sorting','en','Order',NULL,NULL),('acc','acc_tbl_docs_head_title','en','Title',NULL,NULL),('acc','acc_tbl_docs_title','en','Documents',NULL,NULL),('acc','acc_tree_off','en','Tree Off',NULL,NULL),('acc','acc_tree_on','en','Tree On',NULL,NULL),('adm','adm_accessibility_contacts','en','Contact Point for Accessibility Issues',NULL,NULL),('adm','adm_accessibility_contacts_info','en','Contacts for the ‘Report Accessibility Issue’ link in your installation’s footer. Comma-separated list of account usernames (logins).',NULL,NULL),('adm','adm_acc_ctrl_cpt_desc','en','Display the link to your Accessibility document in the footer of your installation.',NULL,NULL),('adm','adm_acc_ctrl_cpt_enable','en','Accessibility Link in Footer',NULL,NULL),('adm','adm_awrn_support_contacts_info','en','All users assigned as contacts for technical support are listed. Users can be assigned to the list of technical support contacts in the administration section \'System Settings and Maintenance » General Settings\', tab \'Contact Information\'.',NULL,NULL),('adm','adm_support_contacts','en','Technical Support',NULL,NULL),('adm','adm_support_contacts_info','en','Please enter the login names of the people who can be contacted with questions and technical problems here, separated by commas. They can be contacted by e-mail via the \"Contact technical support\" link in the ILIAS footer. If the \"Who is online?\" display is active, these people will also be displayed there as technical support.',NULL,NULL),('administration','adm_achievements','en','Achievements',NULL,NULL),('administration','adm_activate_db_benchmark','en','Activate Benchmarking',NULL,NULL),('administration','adm_activate_db_benchmark_desc','en','Benchmarking will be automatically disabled after one request.',NULL,NULL),('administration','adm_adm_role_protect','en','Protect Administrator Role',NULL,NULL),('administration','adm_adm_role_protect_info','en','Only allow administrators to assign or remove users from the role of administrator.',NULL,NULL),('administration','adm_auth_login','en','Authentication Login',NULL,NULL),('administration','adm_auth_reg','en','Authentication Registration',NULL,NULL),('administration','adm_communication','en','Communication',NULL,NULL),('administration','adm_db_benchmark','en','DB Benchmark',NULL,NULL),('administration','adm_db_benchmark_user','en','User Account Name',NULL,NULL),('administration','adm_db_benchmark_user_desc','en','Measurements will be made for this user only. The username entered should not belong to the user initiating the benchmarking.',NULL,NULL),('administration','adm_db_bench_by_first_table','en','Aggregated by First Table in SQL',NULL,NULL),('administration','adm_db_bench_chronological','en','Chronological',NULL,NULL),('administration','adm_db_bench_slowest_first','en','Slowest First',NULL,NULL),('administration','adm_db_bench_sorted_by_sql','en','Sorted by SQL',NULL,NULL),('administration','adm_extending_ilias','en','Extending ILIAS',NULL,NULL),('administration','adm_external_setting_edit','en','Edit Settings',NULL,NULL),('administration','adm_hide','en','Hide in Settings Form',NULL,NULL),('administration','adm_hide_tabs','en','Hide Tabs',NULL,NULL),('administration','adm_https','en','HTTPS',NULL,NULL),('administration','adm_imprint','en','Legal Notice',NULL,NULL),('administration','adm_imprint_inactive','en','Legal notice is not active and users are not able to access it.',NULL,NULL),('administration','adm_layout_and_navigation','en','Layout and Navigation',NULL,NULL),('administration','adm_legal_regulations','en','Legal Regulations',NULL,NULL),('administration','adm_locale','en','Locale',NULL,NULL),('administration','adm_locale_info','en','Locale setting influences e.g. sorting in lists. Examples are nl_NL or de_DE. Multiple locales can be separated by comma. The first valid one will be used.',NULL,NULL),('administration','adm_maintenance','en','System Settings and Maintenance',NULL,NULL),('administration','adm_missing_entries','en','Missing Entries',NULL,NULL),('administration','adm_missing_entry_add','en','Add New Entry',NULL,NULL),('administration','adm_missing_entry_add_action','en','Add',NULL,NULL),('administration','adm_nr_statements','en','Number of Statements',NULL,NULL),('administration','adm_personal_workspace','en','Personal Workspace',NULL,NULL),('administration','adm_predefined_settings','en','Predefined Settings',NULL,NULL),('administration','adm_pub_section_domain_filter','en','Domain Filter',NULL,NULL),('administration','adm_pub_section_domain_filter_info','en','Domain filters granting anonymous access. Enter one ore more domains, which allow anonymous access.',NULL,NULL),('administration','adm_repository_and_objects','en','Repository and Objects',NULL,NULL),('administration','adm_rep_shorten_description','en','Limited Length of Descriptions',NULL,NULL),('administration','adm_rep_shorten_description_info','en','If activated all descriptions in object lists are presented with a maximum number of characters.',NULL,NULL),('administration','adm_rep_shorten_description_length','en','Maximum number of characters',NULL,NULL),('administration','adm_rep_tree_all_types','en','All Object Types',NULL,NULL),('administration','adm_rep_tree_all_types_info','en','All object types are presented in the Tree View (Slate).',NULL,NULL),('administration','adm_rep_tree_limit_grp_crs','en','Show only in courses and groups.',NULL,NULL),('administration','adm_rep_tree_limit_grp_crs_info','en','The Tree View shows all objects only within courses and groups. Outside courses and groups, only container objects are presented.',NULL,NULL),('administration','adm_rep_tree_only_cntr','en','Container Objects Only',NULL,NULL),('administration','adm_rep_tree_only_cntr_info','en','Only objects of type Study Programme, Category, Course, Group and Learning Sequence are presented in the Tree View.',NULL,NULL),('administration','adm_rep_tree_presentation','en','Tree View of Repository',NULL,NULL),('administration','adm_search_and_find','en','Search and Find',NULL,NULL),('administration','adm_show_comments_tagging_in_lists','en','Show Number of Notes, Comments and Tags in Object Lists',NULL,NULL),('administration','adm_show_comments_tagging_in_lists_tags','en','Display tags instead of number',NULL,NULL),('administration','adm_sql','en','SQL',NULL,NULL),('administration','adm_table','en','Table',NULL,NULL),('administration','adm_time','en','Time',NULL,NULL),('administration','adm_user_administration','en','Users and Roles',NULL,NULL),('administration','adm_user_starting_point','en','Personal Starting Point',NULL,NULL),('administration','adm_user_starting_point_info','en','Select the page or object which is to be shown after login.',NULL,NULL),('administration','adm_user_starting_point_inherit','en','Use Standard Settings',NULL,NULL),('administration','adm_user_starting_point_inherit_info','en','Use the standard global settings as set by the administrator of your platform.',NULL,NULL),('administration','adm_user_starting_point_invalid_info','en','This feature is currently not active.',NULL,NULL),('administration','adm_user_starting_point_object','en','Repository Object',NULL,NULL),('administration','adm_user_starting_point_personal','en','Personal Setting',NULL,NULL),('administration','adm_user_starting_point_personal_info','en','Users may select their own starting page.',NULL,NULL),('administration','adm_user_starting_point_ref_id','en','Reference ID',NULL,NULL),('administration','adm_user_starting_point_ref_id_info','en','Open the object that you would like to use as your Personal Starting Point and copy the number directly following \"ref_id=\" in the browser bar into the text input field above.',NULL,NULL),('administration','adm_value','en','Predefined Value',NULL,NULL),('administration','allow_change_loginname','en','Permit Change of Login Names in ‘Personal Data’',NULL,NULL),('administration','analysis_options','en','Analysis options',NULL,NULL),('administration','analyze_data','en','Analyse and repair data integrity',NULL,NULL),('administration','analyzing_tree_structure','en','Analysing tree structure…',NULL,NULL),('administration','apache_auth_authenticate_on_login_page','en','Try Apache authentication when entering the login page',NULL,NULL),('administration','apache_auth_domains','en','Allowed Redirection Domains',NULL,NULL),('administration','apache_auth_domains_description','en','Enter one domain per line to allow redirection to this target.<br/>If ILIAS is reachable by more than one domain please enter all target you want to allow.<br />Example: example.com allows the redirection to http://example.com and http://www.example.com and all pages located there.',NULL,NULL),('administration','apache_auth_enable_override_login','en','Override default login page',NULL,NULL),('administration','apache_auth_indicator_name','en','Indicator-field for successful authentication',NULL,NULL),('administration','apache_auth_indicator_value','en','Indicator-value for successful authentication',NULL,NULL),('administration','apache_auth_security','en','Security Settings',NULL,NULL),('administration','apache_auth_settings','en','Apache',NULL,NULL),('administration','apache_auth_target_override_login','en','Target url for custom login page',NULL,NULL),('administration','apache_auth_username_by_function','en','Assign user names by custom function',NULL,NULL),('administration','apache_auth_username_config','en','Username configuration',NULL,NULL),('administration','apache_auth_username_config_type','en','Type',NULL,NULL),('administration','apache_auth_username_direct_mapping','en','Straight assignment',NULL,NULL),('administration','apache_auth_username_direct_mapping_fieldname','en','Field for assignment',NULL,NULL),('administration','apache_auth_username_extended_mapping','en','Extended assignment',NULL,NULL),('administration','apache_autocreate','en','Enable account generation',NULL,NULL),('administration','apache_default_role','en','Default user role',NULL,NULL),('administration','apache_enable_auth','en','Enable Apache Authentication support',NULL,NULL),('administration','apache_enable_ldap','en','Enable LDAP user assignment',NULL,NULL),('administration','apache_enable_local','en','Enable local user assignment',NULL,NULL),('administration','apache_ldap_hint_ldap_must_be_configured','en','LDAP must be configured in administration',NULL,NULL),('administration','apache_settings','en','Configure LDAP Authentication',NULL,NULL),('administration','apache_settings_changed_success','en','Configuration saved',NULL,NULL),('administration','auth_apache','en','Apache',NULL,NULL),('administration','auth_auth_mode_determination','en','Authentication Method Determination (for Login)',NULL,NULL),('administration','auth_automatic','en','Fixed Sequence',NULL,NULL),('administration','auth_by_user','en','By the User',NULL,NULL),('administration','auth_kind_determination','en','Kind of Determination',NULL,NULL),('administration','auth_mode_default_change_info','en','Changing the default authentication method affects all user accounts configured to use the default authentication method. If the selected default method (e.g., Shibboleth, SAML, SOAP, ...) does not support or is not configured to allow fallback to local ILIAS authentication, affected users may no longer be able to log in. To avoid this, please ensure that local fallback authentication is activated in the configuration of the selected method, or that the authentication method stored for affected user accounts is manually changed.',NULL,NULL),('administration','auth_mode_determination_info','en','Choose either if the users have to select their authentication method on the login screen or if this is managed by a fixed sequence of authentication methods.',NULL,NULL),('administration','clean','en','Clean up',NULL,NULL),('administration','cleaning','en','Cleaning...',NULL,NULL),('administration','cleaning_final','en','Final cleaning...',NULL,NULL),('administration','clean_desc','en','Remove invalid references and tree entries. Initialize gaps in tree structure.',NULL,NULL),('administration','course_export','en','Visible in Courses',NULL,NULL),('administration','done','en','Done',NULL,NULL),('administration','dumping_tree','en','Dumping tree...',NULL,NULL),('administration','dump_tree','en','Dump tree',NULL,NULL),('administration','dump_tree_desc','en','Perform an analysis of the tree and print all tree nodes along with analysis data.',NULL,NULL),('administration','found','en','found.',NULL,NULL),('administration','found_none','en','none found.',NULL,NULL),('administration','git_hash_short','en','Commit Hash (short): %s',NULL,NULL),('administration','git_last_commit','en','Last Commit: %s',NULL,NULL),('administration','git_revision','en','Number: %s',NULL,NULL),('administration','group_export','en','Visible in Groups',NULL,NULL),('administration','history_loginname','en','Login Name History',NULL,NULL),('administration','initializing_gaps','en','Initializing gaps in tree...',NULL,NULL),('administration','language_all_modules','en','All modules',NULL,NULL),('administration','language_change_settings','en','Change Language Settings',NULL,NULL),('administration','language_cleared_local','en','The local changes were cleared in the database.',NULL,NULL),('administration','language_clear_local_changes','en','Clear local changes in the database',NULL,NULL),('administration','language_clear_local_changes_info','en','Reset the database entries of this language to the default entries defined in lang/ilias_%s.lang. All local changes or additions will be removed.',NULL,NULL),('administration','language_compare','en','Compare',NULL,NULL),('administration','language_default_entries','en',' (default entries)',NULL,NULL),('administration','language_delete_local_additions','en','Delete local additions in the database',NULL,NULL),('administration','language_delete_local_additions_info','en','Delete all entries that were locally added to the database.',NULL,NULL),('administration','language_error_clear_local','en','The local changed could not be cleared in the database!',NULL,NULL),('administration','language_error_delete_local','en','The custom language file can\'t be deleted!',NULL,NULL),('administration','language_error_local_missed','en','The custom language file does not exist!',NULL,NULL),('administration','language_error_read_local','en','The custom language file does not exist or cannot be read!',NULL,NULL),('administration','language_error_write_global','en','The standard language file can\'t be written!',NULL,NULL),('administration','language_export_file','en','Export Language File',NULL,NULL),('administration','language_file_imported','en','The language file %s was imported.',NULL,NULL),('administration','language_file_scope','en','Language file scope',NULL,NULL),('administration','language_former_file_description','en','To compare your local changes with the changes of the last update, please copy the language file of the previously installed ILIAS version to the path mentioned above. Before the next update you can do this with the option \'Backup the standard language file\' on the maintenance tab.',NULL,NULL),('administration','language_former_file_equal','en','The file <b>%s</b> is identical to the current language file.',NULL,NULL),('administration','language_former_file_missing','en','The file <b>%s</b> is missing.',NULL,NULL),('administration','language_import_file','en','Import Language File',NULL,NULL),('administration','language_loaded_local','en','The custom language file was loaded into the database.',NULL,NULL),('administration','language_load_local_changes','en','Load custom language file into the database',NULL,NULL),('administration','language_load_local_changes_info','en','Load the file lang/customizing/ilias_%s.lang.local to the database. New entries of this file are added to the database and existing entries are overwritten.',NULL,NULL),('administration','language_local_file_deleted','en','The custom language file was deleted.',NULL,NULL),('administration','language_maintain','en','Maintain',NULL,NULL),('administration','language_maintain_local_changes','en','Maintain local changes',NULL,NULL),('administration','language_maintenance','en','Language Maintenance',NULL,NULL),('administration','language_merged_global','en','The local changes were merged into the standard language file.',NULL,NULL),('administration','language_merge_local_changes','en','Merge local changes into the standard language file',NULL,NULL),('administration','language_merge_local_changes_info','en','Merge all local changes and additions alphabetically into the standard language file lang/ilias_%s.lang. The web server must have write permission on this file.',NULL,NULL),('administration','language_mode_existing','en','Existing Entries',NULL,NULL),('administration','language_mode_existing_delete','en','Delete existing entries',NULL,NULL),('administration','language_mode_existing_delete_info','en','Delete all entries in the database before importing the file.<br /> WARNING: The imported language file should be complete, otherwise there will be undefined language variables. If that happens, switch to the tab ‘Maintain’ and choose ‘Clear local changes in the database’.',NULL,NULL),('administration','language_mode_existing_keepall','en','Keep all existing entries',NULL,NULL),('administration','language_mode_existing_keepall_info','en','Import only new entries that do not yet exist in the database.',NULL,NULL),('administration','language_mode_existing_keepnew','en','Keep all local changes',NULL,NULL),('administration','language_mode_existing_keepnew_info','en','Import new entries and overwrite all entries that still have their default values. Keep those entries that are already changed in the database.',NULL,NULL),('administration','language_mode_existing_replace','en','Replace existing entries',NULL,NULL),('administration','language_mode_existing_replace_info','en','Import new entries and replace all existing entries with the new values defined in the import file.',NULL,NULL),('administration','language_note_translation','en','Page translation mode is activated for each language separately. Additionally the user needs read and write permission on the language folder.',NULL,NULL),('administration','language_process_maintenance','en','Process Maintenance',NULL,NULL),('administration','language_remove_local_file','en','Delete the custom language file',NULL,NULL),('administration','language_remove_local_file_info','en','Remove the file lang/customizing/ilias_%s.lang.local and change the language status from ‘Installed With Local’ to ‘Installed’. The changes in the database are not touched.',NULL,NULL),('administration','language_saved_dist','en','The backup of the standard ILIAS language file is created.',NULL,NULL),('administration','language_save_dist','en','Backup the standard language file',NULL,NULL),('administration','language_save_dist_failed','en','The backup of the standard ILIAS language file could not be written.',NULL,NULL),('administration','language_save_dist_info','en','Create a backup of the standard ILIAS language file in the ILIAS data directory. This helps after an ILIAS update to find conflicst of own changes with updated language variables.',NULL,NULL),('administration','language_save_local_changes','en','Save all changes to the custom language file',NULL,NULL),('administration','language_save_local_changes_info','en','Save all locally added or changed database entries to the file lang/customizing/ilias_%s.lang.local and set the language status to ‘Installed With Local’. The web server must have write permission in this folder. Please note that this file is the same for all clients of this installation.',NULL,NULL),('administration','language_scope_added','en','Local additions only',NULL,NULL),('administration','language_scope_added_info','en','Export all entries that are locally added in the database. This can be used to backup additional development entries before local changes are deleted on the tab ‘Maintain’.',NULL,NULL),('administration','language_scope_commented','en','Shows only entries with comments in language file',NULL,NULL),('administration','language_scope_conflicts','en','Local and update changes',NULL,NULL),('administration','language_scope_dbremarks','en','Shows only entries with comments in database',NULL,NULL),('administration','language_scope_different','en','Different from compare language',NULL,NULL),('administration','language_scope_equal','en','Equal to compare language',NULL,NULL),('administration','language_scope_global','en','All entries',NULL,NULL),('administration','language_scope_global_info','en','Export all database entries of this language. This can be used for backup purposes.',NULL,NULL),('administration','language_scope_local','en','Local changes only',NULL,NULL),('administration','language_scope_local_info','en','Export all entries that are locally added or changed in the database.',NULL,NULL),('administration','language_scope_merged','en','Local changes merged into the standard language file',NULL,NULL),('administration','language_scope_merged_info','en','Export the standard ILIAS language file with all local changes merged in alphabetically by module and identifier. This can be used to update the standard language file on the ILIAS git repository.',NULL,NULL),('administration','language_scope_unchanged','en','Unchanged entries only',NULL,NULL),('administration','language_scope_unchanged_info','en','Export all default language entries that are not changed in the database. This is the opposite to ‘Local changes only’. Both together are a complete backup of the current language in the database.',NULL,NULL),('administration','language_settings','en','Language Settings',NULL,NULL),('administration','language_statistics','en','Statistics',NULL,NULL),('administration','language_translation','en','Page translation',NULL,NULL),('administration','language_translation_enabled','en','Page translation enabled',NULL,NULL),('administration','language_variables_saved','en','The changes to the language variables were saved successfully.',NULL,NULL),('administration','loginname_change_blocking_time','en','Blocking Time for Changing Login Names',NULL,NULL),('administration','loginname_change_blocking_time_info','en','Enter a number days that a user has to wait before being allowed to re-change their username (login ID). Set to 0 to allow users to change their usernames as often as they want.',NULL,NULL),('administration','loginname_change_blocking_time_invalidity_info','en','Please insert a numeric value.',NULL,NULL),('administration','loginname_history_info','en','Record username (login ID) changes in the database. This history is accessible in the database table ‘loginname_history’.',NULL,NULL),('administration','log_scan','en','Log scan results',NULL,NULL),('administration','log_scan_desc','en','Write scan results to ‘scanlog.log’ in client data directory.',NULL,NULL),('administration','nothing_to_purge','en','Nothing to purge...',NULL,NULL),('administration','nothing_to_remove','en','Nothing to remove...',NULL,NULL),('administration','nothing_to_restore','en','Nothing to restore...',NULL,NULL),('administration','obj_blga','en','Blog',NULL,NULL),('administration','obj_blga_desc','en','Global Blog Settings',NULL,NULL),('administration','obj_chta_desc','en','Chat Administration',NULL,NULL),('administration','obj_excs','en','Exercise',NULL,NULL),('administration','obj_excs_desc','en','Global Exercise Settings',NULL,NULL),('administration','obj_impr','en','Legal Notice',NULL,NULL),('administration','obj_impr_desc','en','Deployment of Legal Notice',NULL,NULL),('administration','obj_mds','en','Metadata',NULL,NULL),('administration','obj_mds_desc','en','Configure Metadata and Custom Metadata Settings',NULL,NULL),('administration','obj_otpl','en','Didactic Templates',NULL,NULL),('administration','obj_otpl_desc','en','Template for creating new objects with predefined permission settings',NULL,NULL),('administration','obj_prfa','en','Portfolio',NULL,NULL),('administration','obj_prfa_desc','en','Global Portfolio Settings',NULL,NULL),('administration','obj_taxs','en','Taxonomy',NULL,NULL),('administration','obj_taxs_desc','en','Global Taxonomy Settings',NULL,NULL),('administration','org_op_edit_user_accounts','en','Edit User Accounts',NULL,NULL),('administration','output_options','en','Output options',NULL,NULL),('administration','path_to_mkisofs','en','Path to mkisofs',NULL,NULL),('administration','prg_export','en','Visible in Study Programmes',NULL,NULL),('administration','purge_age_limit','en','Limit age',NULL,NULL),('administration','purge_age_limit_desc','en','If this field contains a value, only objects which were deleted before the specified number of days will be purged.',NULL,NULL),('administration','purge_count_limit','en','Limit count',NULL,NULL),('administration','purge_count_limit_desc','en','If this field contains a value, only the specified number of objects will be purged.',NULL,NULL),('administration','purge_missing','en','Purge missing objects',NULL,NULL),('administration','purge_missing_desc','en','Remove all missing and unbound objects found from system.',NULL,NULL),('administration','purge_trash','en','Purge deleted objects',NULL,NULL),('administration','purge_trash_desc','en','Remove all objects in trash bin from system.',NULL,NULL),('administration','purge_type_limit','en','Limit type',NULL,NULL),('administration','purge_type_limit_desc','en','If this field contains a value, only objects of the specified type will be purged.',NULL,NULL),('administration','purging','en','Purging...',NULL,NULL),('administration','purging_missing_objs','en','Purging missing objects...',NULL,NULL),('administration','purging_trash','en','Purging trash...',NULL,NULL),('administration','purging_unbound_objs','en','Purging unbound objects...',NULL,NULL),('administration','removing_invalid_childs','en','Removing invalid tree entries...',NULL,NULL),('administration','removing_invalid_refs','en','Removing invalid references...',NULL,NULL),('administration','removing_invalid_rolfs','en','Removing invalid role folders...',NULL,NULL),('administration','repair_options','en','Repair options',NULL,NULL),('administration','restore_missing','en','Restore missing objects',NULL,NULL),('administration','restore_missing_desc','en','Restore missing and unbound objects to RecoveryFolder.',NULL,NULL),('administration','restore_trash','en','Restore deleted objects',NULL,NULL),('administration','restore_trash_desc','en','Restore all objects in trash bin to RecoveryFolder.',NULL,NULL),('administration','restoring','en','Restoring...',NULL,NULL),('administration','restoring_missing_objs','en','Restoring missing objects...',NULL,NULL),('administration','restoring_trash','en','Restoring trash...',NULL,NULL),('administration','restoring_unbound_objs','en','Restoring unbound objects and sub-objects...',NULL,NULL),('administration','reuse_of_loginnames_contained_in_history','en','Reuse of Login Names',NULL,NULL),('administration','reuse_of_loginnames_contained_in_history_info','en','Allow users to reuse any login name (not currently in use) that already appears in the history (even if it belongs to a deleted user).',NULL,NULL),('administration','scan','en','Scan',NULL,NULL),('administration','scanning_system','en','Scanning system...',NULL,NULL),('administration','scan_desc','en','Scan system for corrupted/invalid/missing/unbound objects.',NULL,NULL),('administration','scan_details','en','Scan details',NULL,NULL),('administration','scan_modes','en','Scan modes used',NULL,NULL),('administration','searching_deleted_objs','en','Searching for deleted objects...',NULL,NULL),('administration','searching_invalid_childs','en','Searching for invalid tree entries...',NULL,NULL),('administration','searching_invalid_refs','en','Searching for invalid references...',NULL,NULL),('administration','searching_invalid_rolfs','en','Searching for invalid role folders...',NULL,NULL),('administration','searching_missing_objs','en','Searching for missing objects...',NULL,NULL),('administration','searching_unbound_objs','en','Searching for unbound objects...',NULL,NULL),('administration','skipped','en','skipped',NULL,NULL),('administration','start_scan','en','Start!',NULL,NULL),('administration','svn_path','en','Path: %s',NULL,NULL),('administration','svn_revision_current','en','Current Revision: %s',NULL,NULL),('administration','svn_revision_last_change','en','Last Changed Revision: %s',NULL,NULL),('administration','svn_root','en','Root: %s',NULL,NULL),('administration','systemcheck','en','System check',NULL,NULL),('administration','system_check_no_owner','en','Ownerless Objects',NULL,NULL),('administration','tree_corrupt','en','Tree is corrupted! See scan log for details.',NULL,NULL),('administration','user_criteria','en','Unique user criteria',NULL,NULL),('administration','user_criteria_desc','en','Unique user criteria that is used for test results import/export. This is needed to identify identical users on different ILIAS systems.',NULL,NULL),('administration','usr_loginname_history_info','en','The user changed its login at last at %s. The former login was: %s.',NULL,NULL),('administration','vc_information','en','Show Version Control Information',NULL,NULL),('administration','vc_information_not_determined','en','ILIAS could not determine any version control information.',NULL,NULL),('administration','view_last_log','en','View last Scan log',NULL,NULL),('administration','view_log','en','View details',NULL,NULL),('adn','action_confirm_delete','en','Delete Notifications',NULL,NULL),('adn','action_confirm_delete_msg','en','Would you like to delete the following notification(s)?',NULL,NULL),('adn','administrative_notification','en','Administrative Notifications',NULL,NULL),('adn','administrative_notification_description','en','Provide system-wide notifications in topbar of ILIAS',NULL,NULL),('adn','btn_cancel','en','Cancel',NULL,NULL),('adn','btn_delete','en','Delete',NULL,NULL),('adn','btn_delete_confirm','en','Would you like to delete this Notification?',NULL,NULL),('adn','btn_duplicate','en','Duplicate',NULL,NULL),('adn','btn_edit','en','Edit',NULL,NULL),('adn','btn_reset','en','Reset',NULL,NULL),('adn','btn_reset_confirm','en','Would you like to reset this Notification for all Users?',NULL,NULL),('adn','common_actions','en','Actions',NULL,NULL),('adn','common_add_msg','en','Add Notification',NULL,NULL),('adn','main','en','Notifications',NULL,NULL),('adn','msg_body','en','Body',NULL,NULL),('adn','msg_body_info','en','Body of the Notification',NULL,NULL),('adn','msg_dismissable','en','Dismissable',NULL,NULL),('adn','msg_dismissable_info','en','Notifications can be closed by the user. The user won\'t see this notification again.',NULL,NULL),('adn','msg_display_date_end','en','Displayed Until',NULL,NULL),('adn','msg_display_date_start','en','Displayed From',NULL,NULL),('adn','msg_error_false_date_configuration','en','Can\'t create a notification with this configuration of dates. The event must be within the display time.',NULL,NULL),('adn','msg_event_date_end','en','Event Ends',NULL,NULL),('adn','msg_event_date_start','en','Event Starts',NULL,NULL),('adn','msg_form_title','en','Notification',NULL,NULL),('adn','msg_has_language_limitation','en','Limited to selected languages',NULL,NULL),('adn','msg_has_language_limitation_info','en','Only selected languages will see the notification.',NULL,NULL),('adn','msg_languages','en','Languages',NULL,NULL),('adn','msg_limited_to_role_ids','en','Presentation',NULL,NULL),('adn','msg_limit_to_roles','en','Limited to Selected Roles',NULL,NULL),('adn','msg_limit_to_roles_info','en','Only selected roles will see the notification.',NULL,NULL),('adn','msg_permanent','en','Display',NULL,NULL),('adn','msg_permanent_info','en','Display Notifications permanently or temporarily',NULL,NULL),('adn','msg_permanent_no','en','Show Temporarily',NULL,NULL),('adn','msg_permanent_yes','en','Show Permanently',NULL,NULL),('adn','msg_presentation','en','Presentation',NULL,NULL),('adn','msg_show_to_all_languages','en','Show to all languages',NULL,NULL),('adn','msg_show_to_all_roles','en','Show to all roles',NULL,NULL),('adn','msg_show_to_all_roles_info','en','All users even when not logged-in will see notification.',NULL,NULL),('adn','msg_success_created','en','Notification created',NULL,NULL),('adn','msg_success_deleted','en','Notification(s) sucessfully deleted',NULL,NULL),('adn','msg_success_duplicated','en','Notification sucessfully duplicated',NULL,NULL),('adn','msg_success_reset','en','Notification reset',NULL,NULL),('adn','msg_success_updated','en','Notification updated',NULL,NULL),('adn','msg_table_title','en','Notifications',NULL,NULL),('adn','msg_title','en','Headline',NULL,NULL),('adn','msg_title_info','en','Short Headline of the Notification',NULL,NULL),('adn','msg_type','en','Importance',NULL,NULL),('adn','msg_type_0','en','Notice',NULL,NULL),('adn','msg_type_1','en','Notice',NULL,NULL),('adn','msg_type_2','en','Important',NULL,NULL),('adn','msg_type_3','en','Breaking News',NULL,NULL),('adn','msg_type_during_event','en','During Event',NULL,NULL),('adn','msg_type_info','en','the importance has an influence on the color representation of the notification',NULL,NULL),('adve','advanced_editing_excass_settings','en','Exercise Text Assignments',NULL,NULL),('adve','advanced_editing_tst_editing','en','ILIAS Page Editor for additional question content',NULL,NULL),('adve','advanced_editing_tst_editing_desc','en','Activates ILIAS Page Editor for feedback and hint text editing.',NULL,NULL),('adve','adve_activation','en','Activation',NULL,NULL),('adve','adve_autosave','en','Automatic Saving Intervall',NULL,NULL),('adve','adve_autosave_info','en','Auto-save for text content. With shorter intervals, the server load increases and the performance of the system decreases.',NULL,NULL),('adve','adve_autosave_info_min_10','en','Please choose a value of minimal 10 seconds if you activated this feature.',NULL,NULL),('adve','adve_auto_url_linking','en','URL Auto-Linking',NULL,NULL),('adve','adve_auto_url_linking_info','en','Tries to identify URLs like \"http://..\" in text paragraphs and automatically creates links around them.',NULL,NULL),('adve','adve_blocking_mode','en','Edit Lock',NULL,NULL),('adve','adve_excass_settings','en','Exercise Assignments',NULL,NULL),('adve','adve_grp_copa','en','Content Pages',NULL,NULL),('adve','adve_grp_frm','en','Forums',NULL,NULL),('adve','adve_grp_glo','en','Glossaries',NULL,NULL),('adve','adve_grp_lm','en','ILIAS Learning Modules',NULL,NULL),('adve','adve_grp_rep','en','Repository Pages',NULL,NULL),('adve','adve_grp_scorm','en','SCORM Editing',NULL,NULL),('adve','adve_grp_test','en','Test and Assessment',NULL,NULL),('adve','adve_grp_wiki','en','Wikis',NULL,NULL),('adve','adve_minutes','en','Minutes',NULL,NULL),('adve','adve_minutes_info','en','Minutes of inactivity before an edit lock expires and a page can be edited by another user.',NULL,NULL),('adve','adve_page_editor_settings','en','ILIAS Page Editor',NULL,NULL),('adve','adve_pe_general','en','General',NULL,NULL),('adve','adve_rte_settings','en','TinyMCE Editor',NULL,NULL),('adve','adve_text_content_features','en','Text Content Menu',NULL,NULL),('adve','adve_use_physical','en','Use b/i/u instead of str/emp/imp',NULL,NULL),('adve','adve_use_physical_info','en','This setting replaces the semantic style class buttons for ‘strong’, ‘emphatic’ and ‘important’ with physical attribute buttons ‘b’ (bold), ‘i’ (italic) and ‘u’ (underline). Please note, that this may result in inconsistencies if the style editor is used and other physical attributes are assigned to the strong/emphatic/important style classes.',NULL,NULL),('adve','adve_use_tiny_mce','en','Enable TinyMCE Editor for WYSIWYG Editing',NULL,NULL),('assessment','activate_logging','en','Activate Test and Assessment Logging',NULL,NULL),('assessment','activate_manual_scoring','en','Enable Manual Scoring',NULL,NULL),('assessment','activate_manual_scoring_desc','en','Enables manual Scoring for all question types.',NULL,NULL),('assessment','additional_rating_info','en','Please note that the values given here are expressed as percentages and these must add up to 100.',NULL,NULL),('assessment','addSuggestedSolution','en','Add Content for Recapitulation',NULL,NULL),('assessment','add_answers','en','Add answers',NULL,NULL),('assessment','add_circle','en','Add circle area',NULL,NULL),('assessment','add_gap','en','Add Gap Text',NULL,NULL),('assessment','add_imagemap','en','Import Image Map',NULL,NULL),('assessment','add_poly','en','Add polygon area',NULL,NULL),('assessment','add_rect','en','Add rectangle area',NULL,NULL),('assessment','add_users','en','Add Users',NULL,NULL),('assessment','advanced_rating','en','Advanced Rating',NULL,NULL),('assessment','advanced_rating_info','en','The advanced rating is only available if a unit is assigned to the result. Further rating settings are displayed after saving the specified units.',NULL,NULL),('assessment','allowedextensions','en','Allowed File Extensions',NULL,NULL),('assessment','allowedextensions_info','en','Enter a comma separated list of allowed file extensions if you want to restrict the upload to a given set of file extensions (e.g. doc,xls,odt).',NULL,NULL),('assessment','allow_images','en','Image Support for Answers',NULL,NULL),('assessment','all_available_question_pools','en','All available question pools',NULL,NULL),('assessment','all_participants','en','All participants',NULL,NULL),('assessment','already_added_extra_time','en','already added: %s min',NULL,NULL),('assessment','analyze_errortext','en','Analyze Error Text',NULL,NULL),('assessment','answer','en','Answer',NULL,NULL),('assessment','answered','en','Answered',NULL,NULL),('assessment','answers_multiline','en','Multi Line Answers',NULL,NULL),('assessment','answers_of','en','Answers of:',NULL,NULL),('assessment','answers_select','en','Select',NULL,NULL),('assessment','answers_singleline','en','Single Line Answers',NULL,NULL),('assessment','answers_text_box','en','Text',NULL,NULL),('assessment','answer_characters','en',' characters allowed, entered number of characters:',NULL,NULL),('assessment','answer_image','en','Answer Image',NULL,NULL),('assessment','answer_is_not_correct_but_positive','en','You\'ve got points for your solution but it’s not the best solution',NULL,NULL),('assessment','answer_is_right','en','Your solution is correct',NULL,NULL),('assessment','answer_is_wrong','en','Your solution is wrong',NULL,NULL),('assessment','answer_of','en','Answer of',NULL,NULL),('assessment','answer_options','en','Answer Options:',NULL,NULL),('assessment','answer_question','en','Answer Question',NULL,NULL),('assessment','answer_text','en','Answer Text',NULL,NULL),('assessment','answer_types','en','Editor for Answers',NULL,NULL),('assessment','applet_attributes','en','Applet Attributes',NULL,NULL),('assessment','applet_parameter','en','Parameter',NULL,NULL),('assessment','applet_parameters','en','Applet Parameters',NULL,NULL),('assessment','apply_def_settings_to_tst','en','Apply Settings',NULL,NULL),('assessment','assClozeTest','en','Cloze Question',NULL,NULL),('assessment','assErrorText','en','Error Text',NULL,NULL),('assessment','assessment_existing_pool','en','Use existing question pool',NULL,NULL),('assessment','assessment_new_pool','en','Create new question pool',NULL,NULL),('assessment','assessment_no_pool','en','Do not use question pool',NULL,NULL),('assessment','assessment_pool_selection','en','Pool Selection',NULL,NULL),('assessment','assessment_scoring_adjust','en','Enable corrections',NULL,NULL),('assessment','assessment_scoring_adjust_desc','en','Enables the corrections feature to allow modifications to questions in a test.',NULL,NULL),('assessment','assFileUpload','en','File Upload Question',NULL,NULL),('assessment','assFlashQuestion','en','Flash Question',NULL,NULL),('assessment','assFormulaQuestion','en','Formula Question',NULL,NULL),('assessment','assImagemapQuestion','en','Hot Spot / Image Map Question',NULL,NULL),('assessment','assKprimChoice','en','Multiple Choice Question (Kprim Answers)',NULL,NULL),('assessment','assLongMenu','en','Long Menu',NULL,NULL),('assessment','assMatchingQuestion','en','Matching Question',NULL,NULL),('assessment','assMultipleChoice','en','Multiple Choice Question (Multiple Answers)',NULL,NULL),('assessment','assNumeric','en','Numeric Question',NULL,NULL),('assessment','assOrderingHorizontal','en','Ordering Question (Horizontal)',NULL,NULL),('assessment','assOrderingQuestion','en','Ordering Question (Vertical)',NULL,NULL),('assessment','assQuestions','en','Questions',NULL,NULL),('assessment','assSingleChoice','en','Multiple Choice Question (Single Answer)',NULL,NULL),('assessment','assTextQuestion','en','Essay Question',NULL,NULL),('assessment','assTextSubset','en','Text Subset Question',NULL,NULL),('assessment','ass_cloze_fb_mode','en','Feedback Mode',NULL,NULL),('assessment','ass_cloze_fb_mode_gap_answ','en','Answer specific Feedback',NULL,NULL),('assessment','ass_cloze_fb_mode_gap_answ_info','en','For every gap separate feedbacks can be configured for different answers.',NULL,NULL),('assessment','ass_cloze_fb_mode_gap_qst','en','Feedback per Gap',NULL,NULL),('assessment','ass_cloze_fb_mode_gap_qst_info','en','For every gap a single feedback can be configured.',NULL,NULL),('assessment','ass_cloze_gap_fb_gap_label','en','Gap %s: <i>%s</i>',NULL,NULL),('assessment','ass_cloze_gap_fb_num_empty_label','en','Gap %s - No Input',NULL,NULL),('assessment','ass_cloze_gap_fb_num_rangehit_label','en','Gap %s - Range Hit',NULL,NULL),('assessment','ass_cloze_gap_fb_num_toohigh_label','en','Gap %s - Value too High',NULL,NULL),('assessment','ass_cloze_gap_fb_num_toolow_label','en','Gap %s - Value too Low',NULL,NULL),('assessment','ass_cloze_gap_fb_num_valuehit_label','en','Gap %s - Value Hit',NULL,NULL),('assessment','ass_cloze_gap_fb_sel_empty_label','en','Gap %s - No Selection',NULL,NULL),('assessment','ass_cloze_gap_fb_sel_opt_label','en','Gap %s - Select Option: <i>%s</i>',NULL,NULL),('assessment','ass_cloze_gap_fb_txt_empty_label','en','Gap %s - No Input',NULL,NULL),('assessment','ass_cloze_gap_fb_txt_match_label','en','Gap %s - Given Answer: <i>%s</i>',NULL,NULL),('assessment','ass_cloze_gap_fb_txt_nomatch_label','en','Gap %s - Wrong Answer',NULL,NULL),('assessment','ass_commented_questions_only','en','Only Commented Questions',NULL,NULL),('assessment','ass_comments','en','Comments',NULL,NULL),('assessment','ass_competence_respect_level_ordering','en','Please note that the competence thresholds have to be defined in an ascending order according to the available competence levels.',NULL,NULL),('assessment','ass_completion_by_submission','en','Completed by Submission',NULL,NULL),('assessment','ass_completion_by_submission_info','en','If enabled, the submission of at least one file causes the completion of this question by granting the maximum score for this question. The score could be manually changed later. Switching this setting does not effect already submitted solutions.',NULL,NULL),('assessment','ass_create_export_file_with_results','en','incl. Participant Results',NULL,NULL),('assessment','ass_create_export_test_archive','en','as Archive File',NULL,NULL),('assessment','ass_create_question','en','Create Question',NULL,NULL),('assessment','ass_imap_hint','en','Hint to be shown as Tooltip',NULL,NULL),('assessment','ass_imap_map_file_not_readable','en','The uploaded image map could not be read.',NULL,NULL),('assessment','ass_imap_no_map_found','en','Could not find any form in the uploaded image map.',NULL,NULL),('assessment','ass_lac_expression','en','Expression',NULL,NULL),('assessment','ass_lac_show_legend_btn','en','Show Legend',NULL,NULL),('assessment','ass_lac_unable_to_parse_condition','en','The condition \"%s\" can not be validated.',NULL,NULL),('assessment','ass_lac_validation_error','en','Errors occured while validating the conditional expression(s)!',NULL,NULL),('assessment','ass_location','en','Location',NULL,NULL),('assessment','ass_mc_sel_lim_exhausted_hint','en','Please do not select more than %s of %s answers!',NULL,NULL),('assessment','ass_mc_sel_lim_hint','en','Please select at most %s of the %s answers!',NULL,NULL),('assessment','ass_mc_sel_lim_setting','en','Answering Limitation',NULL,NULL),('assessment','ass_mc_sel_lim_setting_desc','en','With this setting the number of answers choosable by the participants can be limited.',NULL,NULL),('assessment','ass_process_lock','en','Use Locking During Test Attempts',NULL,NULL),('assessment','ass_process_lock_desc','en','Without the use of any locking mechanism, race conditions are possible. This can lead to inconsistent test results.',NULL,NULL),('assessment','ass_process_lock_mode','en','Lock Mode during Test Attempt',NULL,NULL),('assessment','ass_process_lock_mode_db','en','Use Database Table Locks',NULL,NULL),('assessment','ass_process_lock_mode_db_desc','en','This locking mechanism locks tables within the database. Concurrent processes for the same or other users in the same or in another test for the same or another question are waiting until the other process releases his locks.',NULL,NULL),('assessment','ass_process_lock_mode_file','en','Use Filesystem Locks',NULL,NULL),('assessment','ass_process_lock_mode_file_desc','en','This locking mechanism requests locks on empty files in the filesystem. Concurrent processes for the same user and the same test/question are waiting until the other process releases his lock.',NULL,NULL),('assessment','ass_question','en','Question',NULL,NULL),('assessment','ass_size','en','Size',NULL,NULL),('assessment','ass_skl_import_fails_remove_btn','en','Remove this Hint',NULL,NULL),('assessment','autocomplete_error','en','Your autocomplete number is to large, you have answers which have less characters, so they would never be displayed.',NULL,NULL),('assessment','autoparticipants_subtab','en','Participants',NULL,NULL),('assessment','autosave','en','Automatic Saving',NULL,NULL),('assessment','autosavecontent','en','Autosave Content',NULL,NULL),('assessment','autosave_failed','en','Autosave failed!',NULL,NULL),('assessment','autosave_info','en','The answers of the participants to the last opened question are automatically saved by ILIAS. These automatically saved answers are <b>not</b> considered to be answers that have been authorised by the participant. Therefore, they are not taken into account by ILIAS during the automated evaluation. Automatically saved answers must always be evaluated manually! They are also not displayed in a participant’s ‘Results’ tab. The automatic saving of answers is only intended for emergencies, e.g. if the browser window is closed by mistake!',NULL,NULL),('assessment','autosave_ival','en','Interval',NULL,NULL),('assessment','autosave_success','en','Autosave successful...',NULL,NULL),('assessment','average_reached_points','en','Average Points',NULL,NULL),('assessment','backtocallingpage','en','Back to the question page',NULL,NULL),('assessment','backtocallingpool','en','Back to the question pool',NULL,NULL),('assessment','backtocallingtest','en','Back to the test',NULL,NULL),('assessment','back_to_objective_container','en','Go to Course',NULL,NULL),('assessment','baseunit','en','Base Unit',NULL,NULL),('assessment','broken_test','en','Broken Test',NULL,NULL),('assessment','bulkedit_author','en','Set Author',NULL,NULL),('assessment','bulkedit_lifecycle','en','Set Lifecycle',NULL,NULL),('assessment','bulkedit_taxonomies','en','Set Taxonomies',NULL,NULL),('assessment','button_request_next_question_hint','en','Request Next Hint',NULL,NULL),('assessment','button_request_question_hint','en','Request Hint',NULL,NULL),('assessment','cancel_test','en','Suspend the Test',NULL,NULL),('assessment','cannot_edit_marks','en','The test has already been completed by some participants. You can only change the marks if an ’Access to Test Results’ date has been set and that date is in the future i.e. it has not yet been reached.',NULL,NULL),('assessment','cannot_edit_test','en','You do not possess sufficient permissions to edit the test!',NULL,NULL),('assessment','cannot_execute_test','en','You do not possess sufficient permissions to run the test!',NULL,NULL),('assessment','cannot_export_archive','en','Archive-Export cannot be created.',NULL,NULL),('assessment','cannot_read_questionpool','en','You do not possess sufficient permissions to read the question pool data!',NULL,NULL),('assessment','cannot_save_metaobject','en','You do not possess sufficient permissions to save the metadata!',NULL,NULL),('assessment','cannot_switch_to_online_no_questions_andor_no_mark_steps','en','The status cannot be changed to &quot;online&quot; because there are no questions and/or no marks in the test!',NULL,NULL),('assessment','category','en','Category',NULL,NULL),('assessment','changeSuggestedSolution','en','Select type of content for recapitulation',NULL,NULL),('assessment','change_adm_categories_not_allowed','en','You do not have any permissions concerning this category.',NULL,NULL),('assessment','checkbox_checked','en','Checked',NULL,NULL),('assessment','checkbox_unchecked','en','Unchecked',NULL,NULL),('assessment','circle','en','Circle',NULL,NULL),('assessment','circle_click_center','en','Please click on center of the desired area.',NULL,NULL),('assessment','circle_click_circle','en','Please click on a circle point of the desired area.',NULL,NULL),('assessment','clientip','en','Client IP',NULL,NULL),('assessment','client_ip_range','en','Client IP Range',NULL,NULL),('assessment','close_text_hint','en','To add a new gap set the cursor to the position of your choice and use the dropdown ‘Text Gap’. Corresponding editing sections will appear below. You can also edit gaps by clicking on the gaps within the gap text.',NULL,NULL),('assessment','cloze_answer_text_info','en','Spaces preceding or following the answer text will be deleted when the form is saved.',NULL,NULL),('assessment','cloze_fixed_textlength','en','Text Field Length',NULL,NULL),('assessment','cloze_fixed_textlength_description','en','If you enter a value, all text gap fields, not providing an own maximum character limitation, as well as all numeric gap fields will be created with a fixed length of this value, so entering more than the allowed characters is not possible. Note, that for numeric gaps the decimal separator is counted as a regular character.',NULL,NULL),('assessment','cloze_gap_size_info','en','If you enter a value greater than 0, this gap text field will be created with the fixed length of this value. If you do not enter a value, the gap text field will be created with the value of the global fixed length.',NULL,NULL),('assessment','cloze_text','en','Cloze Text',NULL,NULL),('assessment','cloze_textgap_case_insensitive','en','Case Insensitive',NULL,NULL),('assessment','cloze_textgap_case_sensitive','en','Case Sensitive',NULL,NULL),('assessment','cloze_textgap_levenshtein_of','en','Levenshtein Distance of %s',NULL,NULL),('assessment','code','en','Code',NULL,NULL),('assessment','codebase','en','Codebase',NULL,NULL),('assessment','concatenation','en','Concatenation',NULL,NULL),('assessment','confirm_log_deletion','en','Are you sure, you want to delete the selected log entries? You will not be able to recover the deleted entries.',NULL,NULL),('assessment','confirm_sync_questions','en','The question you changed is a copy which has been created for use with the active test. Do you want to change the original of the question too?',NULL,NULL),('assessment','conf_delete_pass','en','Are you sure you want to delete your existing answers?',NULL,NULL),('assessment','coordinates','en','Coordinates',NULL,NULL),('assessment','copy_and_link_to_questionpool','en','Add to question pool',NULL,NULL),('assessment','copy_no_questions_selected','en','Please select at least one question to copy.',NULL,NULL),('assessment','copy_questions_success','en','The question(s) has been copied.',NULL,NULL),('assessment','correct_answers','en','Correct Answers',NULL,NULL),('assessment','counter','en','Counter',NULL,NULL),('assessment','created','en','Created',NULL,NULL),('assessment','create_gaps','en','Create and Refresh Gaps',NULL,NULL),('assessment','create_new','en','Create New',NULL,NULL),('assessment','customstyle','en','Custom Style',NULL,NULL),('assessment','dashboard_tab','en','Participants',NULL,NULL),('assessment','date_time','en','Date and Time',NULL,NULL),('assessment','definition','en','Definition',NULL,NULL),('assessment','definitions','en','Definitions',NULL,NULL),('assessment','definition_image','en','Definition Image',NULL,NULL),('assessment','definition_text','en','Definition Text',NULL,NULL),('assessment','deleteSuggestedSolution','en','Remove this content for recapitulation',NULL,NULL),('assessment','delete_all_user_data_confirmation','en','Are you sure you want to delete the test results of all of the participants of this test?',NULL,NULL),('assessment','delete_image_header','en','Remove image',NULL,NULL),('assessment','delete_image_question','en','Do you really want to remove the image?',NULL,NULL),('assessment','delete_mark_confirmation','en','Are you sure you want to delete the following mark?',NULL,NULL),('assessment','delete_participants_no_valid_participants_selected','en','Test results already exist for the selected participants, so they cannot be removed.',NULL,NULL),('assessment','delete_result_no_valid_participants_selected','en','There are no test results for the selected participants, so they cannot be removed.',NULL,NULL),('assessment','delete_selected_user_data_confirmation','en','Are you sure you want to remove the test data of the selected users?',NULL,NULL),('assessment','delete_user_data','en','Remove Result(s)',NULL,NULL),('assessment','description_maxchars','en','If nothing entered the maximum number of characters for this text answer is unlimited.',NULL,NULL),('assessment','detailed_evaluation','en','Detailed Evaluation',NULL,NULL),('assessment','detailed_evaluation_for','en','Detailed Evaluation for %s',NULL,NULL),('assessment','detailed_evaluation_missing_active_id','en','You must call the ‘Detailed Evaluation’ for a selected participant!',NULL,NULL),('assessment','detailed_evaluation_show','en','Show Detailed Evaluation',NULL,NULL),('assessment','detailed_output_printview','en','Detailed Output with Question Print Views',NULL,NULL),('assessment','detailed_output_solutions','en','Detailed Output with Question Solutions',NULL,NULL),('assessment','detail_ending_time_reached','en','The maximum time available for completing this test has expired. This test has not been available since %s.',NULL,NULL),('assessment','detail_max_processing_time_reached','en','You have exceeded the maximum time available for completing this test! You are no longer allowed to continue with the test.',NULL,NULL),('assessment','detail_starting_time_not_reached','en','You cannot start the test yet. The test will be available from %s onwards.',NULL,NULL),('assessment','direct_feedback','en','Verify Your Solution',NULL,NULL),('assessment','discard_answer','en','Delete Answer',NULL,NULL),('assessment','discard_answer_confirmation','en','Your answer will be finally and completely deleted. You can provide a new answer at any time. But this one will be purged.<br /><br />Do you want to delete your answer?',NULL,NULL),('assessment','dont_use_questionpool','en','Don\'t insert the questions in a question pool (only available in this test)',NULL,NULL),('assessment','download_all_files','en','Download All Files',NULL,NULL),('assessment','duplicate','en','Duplicate',NULL,NULL),('assessment','duplicate_matching_values_selected','en','You have selected duplicate matching values!',NULL,NULL),('assessment','duplicate_order_values_entered','en','You have entered duplicate order values!',NULL,NULL),('assessment','edit_answer','en','Edit Answer',NULL,NULL),('assessment','edit_concluding_remarks','en','Edit Concluding Remarks',NULL,NULL),('assessment','edit_introduction','en','Edit Introduction',NULL,NULL),('assessment','edit_question','en','Edit Question',NULL,NULL),('assessment','edit_test_questions','en','List View',NULL,NULL),('assessment','element_height','en','Minimum Height',NULL,NULL),('assessment','element_height_info','en','This is the minimum height in pixels for term and definition/picture items during the test output.',NULL,NULL),('assessment','enable_examview','en','Overview of Answers Given',NULL,NULL),('assessment','enable_examview_desc','en','When they click on ‘Finish the Test’, participants are presented with an overview of the test’s questions and the answers they provided to those questions. From this overview, they are still able to click on ‘Back’ in order to return to the test and make changes to their answers as long as answers have not been locked (see ‘Answer Lock’ above).',NULL,NULL),('assessment','end_tag','en','End Tag',NULL,NULL),('assessment','enlarge','en','Enlarge',NULL,NULL),('assessment','enter_anonymous_code','en','Enter access code to continue your already started test:',NULL,NULL),('assessment','enter_enough_positive_points','en','The maximum available points must be greater than 0! Please enter sufficient positive points for your answers.',NULL,NULL),('assessment','enter_enough_positive_points_checked','en','At least one answer needs to score. Please enter a positive score for the selection of an answer.',NULL,NULL),('assessment','enter_valid_values','en','Please enter valid value. Chars will be evaluated as incorrect!',NULL,NULL),('assessment','errFormulaQuestion','en','A Formula Question contains incorrect information!!',NULL,NULL),('assessment','errors','en','Errors',NULL,NULL),('assessment','errors_section','en','Error Data',NULL,NULL),('assessment','errortext','en','Error Text',NULL,NULL),('assessment','errortext_info','en','Please enter the error text. To mark a word as an error please insert a hash sign (#) in front of the word. To mark a group of words as an error please encapsulate the words group between double brackets (i.e.: here is ((an example)) of it). If you press the &quot;Analyze Error Text&quot; button, all marked words will be extracted for further processing.',NULL,NULL),('assessment','error_creating_certificate_zip_empty','en','No data for export.',NULL,NULL),('assessment','error_importing_question','en','There was an error importing the question(s) from the file you have selected!',NULL,NULL),('assessment','error_open_image_file','en','Error opening an image file!',NULL,NULL),('assessment','error_random_question_generation','en','A fatal error occurred during the generation of your random questions for the test. Please contact your administrator with the following information: The system could not create an active ID for user ID %s and test ID %s.',NULL,NULL),('assessment','errRecursionInResult','en','The formula contains an infinite recursion.',NULL,NULL),('assessment','err_category_in_use','en','At least one category cannot be deleted. One or more units of the category are already in use.',NULL,NULL),('assessment','err_divider_too_big','en','The divider of one of the variables in this question is too big.',NULL,NULL),('assessment','err_divider_too_big_specific','en','The divider of this variable is too big.',NULL,NULL),('assessment','err_division','en','The value you chose would make it impossible to generate a valid value for the variable.',NULL,NULL),('assessment','err_duplicate_results','en','You used a result variable more than once. This is not allowed in the question text.',NULL,NULL),('assessment','err_no_formula','en','You must enter a formula',NULL,NULL),('assessment','err_no_numeric_value','en','Please enter a numeric value',NULL,NULL),('assessment','err_range','en','The maximum range must be greater than the minimum range',NULL,NULL),('assessment','err_rating_advanced_not_allowed','en','A rating other than simple rating is not allowed since you are offering multiple result units with an identical base unit.',NULL,NULL),('assessment','err_unit_in_results','en','The unit cannot be deleted. It is already in use in one or more test questions.',NULL,NULL),('assessment','err_unit_in_variables','en','The unit cannot be deleted. It is already in use in one or more test questions.',NULL,NULL),('assessment','err_unit_is_baseunit','en','The unit cannot be deleted. It is used as base unit by other units.',NULL,NULL),('assessment','err_wrong_categoryname','en','The category already exists.',NULL,NULL),('assessment','err_wrong_rating_advanced','en','Please make sure that the addition of the advanced rating settings equals to 100 percent',NULL,NULL),('assessment','essay_scoring_mode','en','Scoring Mode',NULL,NULL),('assessment','essay_scoring_mode_keyword_relation_all','en','Automatic Scoring with Keywords on Finding ALL',NULL,NULL),('assessment','essay_scoring_mode_keyword_relation_all_desc','en','The points are granted automatically, if all keywords are found.',NULL,NULL),('assessment','essay_scoring_mode_keyword_relation_any','en','Automatic Scoring with Keywords on Finding ANY',NULL,NULL),('assessment','essay_scoring_mode_keyword_relation_any_desc','en','For any found keyword the corresponding points are granted automatically.',NULL,NULL),('assessment','essay_scoring_mode_keyword_relation_one','en','Automatic Scoring with Keywords on Finding ONE',NULL,NULL),('assessment','essay_scoring_mode_keyword_relation_one_desc','en','The points are granted automatically, if at least one keyword is found.',NULL,NULL),('assessment','essay_scoring_mode_without_keywords','en','No Automatic Scoring',NULL,NULL),('assessment','essay_scoring_mode_without_keywords_desc','en','No points are granted unless the tutor\'s manual scoring.',NULL,NULL),('assessment','evaluated_users','en','Evaluated Users',NULL,NULL),('assessment','eval_all_users','en','Evaluation for All Users',NULL,NULL),('assessment','eval_legend_link','en','Please refer to the legend for the meaning of the column header symbols.',NULL,NULL),('assessment','examid_in_test_pass','en','Display Test ID',NULL,NULL),('assessment','examid_in_test_pass_desc','en','A Test ID is displayed in the test. A new, unique ID is generated for every test attempt.',NULL,NULL),('assessment','examid_in_test_res','en','Display ILIAS Test ID',NULL,NULL),('assessment','examid_in_test_res_desc','en','The ILIAS Test ID will be included in the test results and the Excel-Export-File.',NULL,NULL),('assessment','exam_id','en','Test ID:',NULL,NULL),('assessment','exam_id_label','en','Test ID',NULL,NULL),('assessment','exam_id_of_attempt','en','ID of Attempt',NULL,NULL),('assessment','expected_result_type','en','Expected result type',NULL,NULL),('assessment','export_cert_failed_for_users_p','en','No certificate file could be generated and added for the following %s accounts: %s. Please contact an administrator to check the log file.',NULL,NULL),('assessment','export_cert_failed_for_users_s','en','No certificate file could be generated and added to the archive for the following account: %s. Please contact an administrator to check the log file.',NULL,NULL),('assessment','export_cert_ignored_for_users_p','en','The following %s accounts did not achieve a certificate, or the certificate service is not enabled/activate: %s',NULL,NULL),('assessment','export_cert_ignored_for_users_s','en','The following account did not achieve a certificate, or the certificate service is not enabled/activate: %s',NULL,NULL),('assessment','export_cert_no_users','en','A certificate archive cannot be created due to missing test participants.',NULL,NULL),('assessment','export_essay_qst_with_html','en','Export Essay Question with HTML code',NULL,NULL),('assessment','export_essay_qst_with_html_desc','en','If activated it is possible to export Essay Question with HTML to Excel.',NULL,NULL),('assessment','export_legacy_logs','en','Export Legacy Log Data',NULL,NULL),('assessment','exp_all_test_runs','en','All test attempts',NULL,NULL),('assessment','exp_eval_data','en','Export data',NULL,NULL),('assessment','exp_file_created','en','Export file created.',NULL,NULL),('assessment','exp_grammar_as','en','as',NULL,NULL),('assessment','exp_scored_test_attempt','en','Scored Test Attempt',NULL,NULL),('assessment','exp_type_certificate','en','Certificate (PDF)',NULL,NULL),('assessment','exp_type_excel','en','Microsoft Excel',NULL,NULL),('assessment','exp_type_spss','en','Comma Separated Values (CSV)',NULL,NULL),('assessment','extratime','en','Extra Time',NULL,NULL),('assessment','extratime_added','en','The extra time has been added to the selected participants.',NULL,NULL),('assessment','extra_time_byline','en','Put in extra time in minutes. Already entered extra time is added up.',NULL,NULL),('assessment','extra_time_for_all_participants','en','You are adding some extra time to all participants.',NULL,NULL),('assessment','extra_time_for_selected_participants','en','You are adding extra time to the selected participants.',NULL,NULL),('assessment','extra_time_for_selected_participants_different','en','You have selected participants with different additional times.',NULL,NULL),('assessment','extra_time_for_single_participant','en','Your are adding extra time to the following participant:',NULL,NULL),('assessment','factor','en','Factor',NULL,NULL),('assessment','failed_official','en','failed',NULL,NULL),('assessment','failed_short','en','failed',NULL,NULL),('assessment','false','en','False',NULL,NULL),('assessment','feedback_all','en','Show answer specific feedback for all answers.',NULL,NULL),('assessment','feedback_answers','en','Feedback for Every Answer',NULL,NULL),('assessment','feedback_checked','en','Show answer specific feedback for all chosen/selected answers.',NULL,NULL),('assessment','feedback_complete_solution','en','Correct Solution',NULL,NULL),('assessment','feedback_correct_kprim','en','Show answer specific feedback for all correct answers (Correct answers are those, for that the positive option is to be chosen/selected).',NULL,NULL),('assessment','feedback_correct_sc_mc','en','Show answer specific feedback for all correct answers (Correct answers are those, that lead to a positive score when chosen/selected).',NULL,NULL),('assessment','feedback_generic','en','Correct/Incorrect Answer Feedback',NULL,NULL),('assessment','feedback_incomplete_solution','en','At least one answer is not correct',NULL,NULL),('assessment','feedback_setting','en','Mode of answer specific feedback.',NULL,NULL),('assessment','fileDownload','en','File download',NULL,NULL),('assessment','file_uploads','en','File Uploads',NULL,NULL),('assessment','fill_out_all_required_fields_add_answer','en','Please fill out all required fields before you add answers!',NULL,NULL),('assessment','filter_all_questionpools','en','All Question Pools',NULL,NULL),('assessment','filter_all_question_types','en','All Question Types',NULL,NULL),('assessment','filter_show_questionpools','en','Show Question Pools',NULL,NULL),('assessment','filter_show_question_types','en','Show Question Types',NULL,NULL),('assessment','finalized_by','en','Completed by',NULL,NULL),('assessment','finalized_evaluation','en','Scoring completed',NULL,NULL),('assessment','finalized_on','en','Completed at',NULL,NULL),('assessment','final_statement','en','Concluding Remarks',NULL,NULL),('assessment','final_statement_show_desc','en','Show concluding remarks after the test has been submitted (there is no option to return to the test from this page).',NULL,NULL),('assessment','finished_by_administrator','en','Finished by Administrator',NULL,NULL),('assessment','finished_by_cronjob','en','Finished by Cronjob',NULL,NULL),('assessment','finished_by_duration','en','Finished by time limit',NULL,NULL),('assessment','finished_by_participant','en','Finished by Participant',NULL,NULL),('assessment','finished_by_unknown','en','Finished by Unknown',NULL,NULL),('assessment','finish_all_user_passes','en','Finish all Test Attempts',NULL,NULL),('assessment','finish_pass_for_all_users','en','Are you sure you want to finish the test attempts for all users?',NULL,NULL),('assessment','finish_pass_for_multiple_users_in_processing_time','en','You cannot finish the passes of the selected users together, because for at least one selected user the processing time is not over yet.',NULL,NULL),('assessment','finish_pass_for_user_confirmation','en','Are you sure you want to finish this test attempt for the participant \"%s\"?',NULL,NULL),('assessment','finish_pass_for_user_in_processing_time','en','WARNING: the processing time for this user is not over yet! You should only end the test run if there is a compelling reason (e.g. exclusion from the test).',NULL,NULL),('assessment','finish_test','en','Finish Test',NULL,NULL),('assessment','finish_test_all','en','Are you sure you want to finish the test attempts for all users?',NULL,NULL),('assessment','finish_test_more_than_one_selected','en','Only a single participant may be selected to finish the pass if the test allows only one pass.',NULL,NULL),('assessment','finish_test_multiple','en','Are you sure you want to finish the test attempts for the following participants?',NULL,NULL),('assessment','finish_test_no_valid_participants_selected','en','There are no active test runs for the selected participants, so they cannot be completed.',NULL,NULL),('assessment','finish_test_single','en','Are you sure you want to finish the test attempt for the participant \"%s\"?',NULL,NULL),('assessment','finish_unfinished_passes','en','Finish Uncompleted Attempts',NULL,NULL),('assessment','finish_unfinished_passes_desc','en','Test attempts which have a set finishing time or a time limit will be closed by this cron job.',NULL,NULL),('assessment','fixedparticipants_subtab','en','Manually Selected Participants',NULL,NULL),('assessment','fixed_participants_hint','en','This test is only accessible for the manually added participants listed below. You can disable this setting by deactivating the checkbox ‘Manually Selected Participants’ in the test settings.',NULL,NULL),('assessment','flashfile','en','Flash File',NULL,NULL),('assessment','for','en','for',NULL,NULL),('assessment','forcejs','en','Force JavaScript output for test questions',NULL,NULL),('assessment','formula','en','Formula',NULL,NULL),('assessment','form_msg_area_missing_points','en','Please enter points for all areas.',NULL,NULL),('assessment','fq_formula_desc','en','You may enter predefined variables ($v1 to $vn), defined results (e.g. $r1), braces for expressions, mathematical operators  + (addition), - (subtraction), * (multiplication), / (division), ^ (nth power), the constants ‘pi’ for pi and ‘e’ for euler\'s constant, as well as the functions ‘sin’, ‘sinh’, ‘arcsin’, ‘asin’, ‘arcsinh’, ‘asinh’, ‘cos’, ‘cosh’, ‘arccos’, ‘acos’, ‘arccosh’, ‘acosh’, ‘tan’, ‘tanh’, ‘arctan’, ‘atan’, ‘arctanh’, ‘atanh’, ‘sqrt’, ‘abs’, ‘ln’ and ‘log’.',NULL,NULL),('assessment','fq_no_restriction_info','en','Both decimals and fractions are accepted as input.',NULL,NULL),('assessment','fq_precision_info','en','Enter the number of desired decimal places.',NULL,NULL),('assessment','fq_question_desc','en','You can define variables by inserting $v1, $v2 ... $vn, results by inserting $r1, $r2 .... $rn at the desired position in the question text. Click on the button ‘Parse Question’ to create editing forms for variables and results.',NULL,NULL),('assessment','gap','en','Gap',NULL,NULL),('assessment','gaps','en','Gaps',NULL,NULL),('assessment','gap_combination','en','Gap Combination',NULL,NULL),('assessment','glossary_term','en','Glossary Term',NULL,NULL),('assessment','goto_first_question','en','Show first question',NULL,NULL),('assessment','grading_mark_msg','en','Your mark is: &quot;[mark]&quot;',NULL,NULL),('assessment','grading_status_failed_msg','en','Sorry, you have <b>failed</b> the test.',NULL,NULL),('assessment','grading_status_passed_msg','en','Congratulations, you have <b>passed</b> the test.',NULL,NULL),('assessment','hide_best_solution','en','Hide best solution',NULL,NULL),('assessment','hints','en','Hints',NULL,NULL),('assessment','identical_scoring','en','Identical Scoring',NULL,NULL),('assessment','identical_scoring_desc','en','If selected, gaps with identical solutions will be scored, even if the same solution was used twice or more. If not selected, only the first occurrence of the same solution will be scored.',NULL,NULL),('assessment','imagemap','en','Image Map',NULL,NULL),('assessment','imap_line_color','en','Image Map Line Color',NULL,NULL),('assessment','import_question','en','Import Question(s)',NULL,NULL),('assessment','info_answer_type_change','en','The question already contains images. You can\'t change the answer type to multi-line answers.',NULL,NULL),('assessment','info_text_upload','en','Choose an answer text (UTF-8) file to upload.',NULL,NULL),('assessment','insert_after','en','Insert After',NULL,NULL),('assessment','insert_before','en','Insert Before',NULL,NULL),('assessment','insert_gap','en','Insert Gap',NULL,NULL),('assessment','interaction_type','en','Interaction Type',NULL,NULL),('assessment','internal_links','en','Internal Links',NULL,NULL),('assessment','intprecision','en','Divisible By',NULL,NULL),('assessment','intprecision_info','en','‘Divisible by’ affects only the creation of variables, if the value for the precision is 0. In this case, you define for ‘Divisible by’ an integer value, which must be divisible by with the created variable. A value of 10 thus generates only integers that are divisible by 10. A value of 5 produces integers that are divisible by 5, etc. For a precision of 0, ‘Divisible by’ is a mandatory field and must contain a positive integer. The default value is 1 for any integers.',NULL,NULL),('assessment','invalid_ip','en','Invalid IP',NULL,NULL),('assessment','in_range','en','Within range',NULL,NULL),('assessment','in_trash','en','In Trash',NULL,NULL),('assessment','ip_range_byline','en','Only IP addresses within the defined range can start the test. You can either use IPv4 OR IPv6 addresses.',NULL,NULL),('assessment','ip_range_for_all_participants','en','You are changing the IP Range of all participants',NULL,NULL),('assessment','ip_range_for_selected_participants','en','You are changing the IP Range of the following participant.',NULL,NULL),('assessment','ip_range_for_single_participant','en','You are changing the IP Range of the selected participants.',NULL,NULL),('assessment','ip_range_info','en','Only clients with an IP in the provided range will be able to access the test.',NULL,NULL),('assessment','ip_range_label','en','IP Range',NULL,NULL),('assessment','ip_range_updated','en','The IP-Range has been update for the selected participants.',NULL,NULL),('assessment','javaapplet','en','Java Applet',NULL,NULL),('assessment','kiosk','en','Exam View',NULL,NULL),('assessment','kiosk_description','en','Runs tests in kiosk mode. This hides the browser bar, navigation and all other screen elements that are not part of the test. Participants are prevented from opening other websites.<br />Effectively preventing participants from opening other websites during tests additionally requires the deployment of a suitable browser (e.g. Safe Exam Browser).',NULL,NULL),('assessment','kiosk_options','en','Exam View Options',NULL,NULL),('assessment','kiosk_options_desc','en','Information is displayed in the header section of the screen.',NULL,NULL),('assessment','kiosk_show_participant','en','Show Name of Participant',NULL,NULL),('assessment','kiosk_show_title','en','Show Test Title',NULL,NULL),('assessment','kprim_answers_info','en','The multiple choice question type ‘four times decision right/wrong’ (Type K’, also known as Kprim) gives four answers or additions to a question or an incomplete statement. A decision about the correctness is to be done on all four answers/additions. The maximum points are granted only, if all decisions are correct.',NULL,NULL),('assessment','kprim_instruction_text','en','You have to decide on every statement: [%s] or [%s]',NULL,NULL),('assessment','lacex_assClozeTest_NumberOfResultExpression_d','en','The fourth answer option is a select gap and the second option was selected',NULL,NULL),('assessment','lacex_assClozeTest_NumberOfResultExpression_e','en','R[4] = +2+',NULL,NULL),('assessment','lacex_assClozeTest_NumericResultExpression_d','en','The second answer option is a numeric gap and was answered with the numeric value 5',NULL,NULL),('assessment','lacex_assClozeTest_NumericResultExpression_e','en','R[2] = #5#',NULL,NULL),('assessment','lacex_assClozeTest_StringResultExpression_1_d','en','The first answer option is a text gap and was answered with „Monday“',NULL,NULL),('assessment','lacex_assClozeTest_StringResultExpression_1_e','en','R[1] = ~Monday~',NULL,NULL),('assessment','lacex_assClozeTest_StringResultExpression_2_d','en','The fourth answer option is a select gap and the option labeled as „Green“ was selected',NULL,NULL),('assessment','lacex_assClozeTest_StringResultExpression_2_e','en','R[4] = ~Green~',NULL,NULL),('assessment','lacex_assErrorText_ExclusiveResultExpression_d','en','Exactly the answer options 1, 3 and 4 were chosen while answering the question',NULL,NULL),('assessment','lacex_assErrorText_ExclusiveResultExpression_e','en','R = *1,3,4*',NULL,NULL),('assessment','lacex_assErrorText_NumberOfResultExpression_d','en','While answering the question the second answer option was chosen',NULL,NULL),('assessment','lacex_assErrorText_NumberOfResultExpression_e','en','R = +2+',NULL,NULL),('assessment','lacex_assFormulaQuestion_NumericResultExpression_d','en','The first answer option was answered with the numeric value 3.14159',NULL,NULL),('assessment','lacex_assFormulaQuestion_NumericResultExpression_e','en','R[1] = #3.14159#',NULL,NULL),('assessment','lacex_assImagemapQuestion_ExclusiveResultExpression_d','en','Exactly the answer options 1, 3 and 4 were chosen while answering the question',NULL,NULL),('assessment','lacex_assImagemapQuestion_ExclusiveResultExpression_e','en','R = *1,3,4*',NULL,NULL),('assessment','lacex_assImagemapQuestion_NumberOfResultExpression_d','en','While answering the question the second answer option was chosen',NULL,NULL),('assessment','lacex_assImagemapQuestion_NumberOfResultExpression_e','en','R = +2+',NULL,NULL),('assessment','lacex_assMatchingQuestion_MatchingResultExpression_d','en','The question\'s terms were assigned to definitions as follows: 1 &rarr; 2 and 2 &rarr; 3 and 3 &rarr; 1',NULL,NULL),('assessment','lacex_assMatchingQuestion_MatchingResultExpression_e','en','R = ;1:2; & R = ;2:3; & R = ;3:1;',NULL,NULL),('assessment','lacex_assMultipleChoice_ExclusiveResultExpression_d','en','Exactly the answer options 1, 3 and 4 were chosen while answering the question',NULL,NULL),('assessment','lacex_assMultipleChoice_ExclusiveResultExpression_e','en','R = *1,3,4*',NULL,NULL),('assessment','lacex_assMultipleChoice_NumberOfResultExpression_d','en','While answering the question the second answer option was chosen',NULL,NULL),('assessment','lacex_assMultipleChoice_NumberOfResultExpression_e','en','R = +2+',NULL,NULL),('assessment','lacex_assNumeric_NumericResultExpression_d','en','The question was answered with the numeric value 4.7',NULL,NULL),('assessment','lacex_assNumeric_NumericResultExpression_e','en','R = #4.7#',NULL,NULL),('assessment','lacex_assOrderingHorizontal_OrderingResultExpression_d','en','The question\'s elements were ordered as follows: 2, 5, 1, 4, 3',NULL,NULL),('assessment','lacex_assOrderingHorizontal_OrderingResultExpression_e','en','R = $2,5,1,4,3$',NULL,NULL),('assessment','lacex_assOrderingQuestion_OrderingResultExpression_d','en','The question\'s elements were ordered as follows: 2, 5, 1, 4, 3',NULL,NULL),('assessment','lacex_assOrderingQuestion_OrderingResultExpression_e','en','R = $2,5,1,4,3$',NULL,NULL),('assessment','lacex_assQuestion_EmptyAnswerExpression_d','en','The question was not answered',NULL,NULL),('assessment','lacex_assQuestion_EmptyAnswerExpression_e','en','R = ?',NULL,NULL),('assessment','lacex_assQuestion_PercentageResultExpression_d','en','The questions answer result is equal to or greater than 75%',NULL,NULL),('assessment','lacex_assQuestion_PercentageResultExpression_e','en','R >= %75%',NULL,NULL),('assessment','lacex_assSingleChoice_NumberOfResultExpression_d','en','While answering the question the second answer option was chosen',NULL,NULL),('assessment','lacex_assSingleChoice_NumberOfResultExpression_e','en','R = +2+',NULL,NULL),('assessment','lacex_assTextSubset_StringResultExpression_d','en','For the second answer option the answer „sodium chloride“ was entered',NULL,NULL),('assessment','lacex_assTextSubset_StringResultExpression_e','en','R[2] = ~sodium chloride~',NULL,NULL),('assessment','lacex_example_header','en','Examples',NULL,NULL),('assessment','list_of_participants','en','Participants',NULL,NULL),('assessment','locked','en','locked',NULL,NULL),('assessment','logging_settings','en','Logging',NULL,NULL),('assessment','logs_answer_deleted','en','Answer deleted',NULL,NULL),('assessment','logs_answer_submitted','en','Answer Submitted',NULL,NULL),('assessment','logs_deleted','en','The selected Log Data has been deleted.',NULL,NULL),('assessment','logs_error_on_participant_interaction','en','Error on Participant Interaction',NULL,NULL),('assessment','logs_error_on_question_administration_interaction','en','Error on Question Administration Interaction',NULL,NULL),('assessment','logs_error_on_scoring_interaction','en','Error on Scoring Interaction',NULL,NULL),('assessment','logs_error_on_test_administration_interaction','en','Error on Test Administration Interaction',NULL,NULL),('assessment','logs_error_on_undefined_interaction','en','Error on Undefined Interaction',NULL,NULL),('assessment','logs_extra_time_added','en','Extra Time Added',NULL,NULL),('assessment','logs_main_settings_modified','en','Main Settings Modified',NULL,NULL),('assessment','logs_mark_schema_modified','en','Mark Schema Modified',NULL,NULL),('assessment','logs_mark_schema_reset','en','Mark Schema Reset',NULL,NULL),('assessment','logs_new_test_created','en','New Test Created',NULL,NULL),('assessment','logs_output','en','Log Data Output',NULL,NULL),('assessment','logs_participant_data_removed','en','Participant Data Removed',NULL,NULL),('assessment','logs_pi','en','Participant Interaction',NULL,NULL),('assessment','logs_qai','en','Question Administration Interaction',NULL,NULL),('assessment','logs_questions_synchronised','en','Questions Synchonised',NULL,NULL),('assessment','logs_question_added','en','Question Added',NULL,NULL),('assessment','logs_question_graded','en','Question Graded',NULL,NULL),('assessment','logs_question_grading_reset','en','Grading Reset',NULL,NULL),('assessment','logs_question_modified','en','Question Modified',NULL,NULL),('assessment','logs_question_modified_in_corrections','en','Question Modified in Corrections',NULL,NULL),('assessment','logs_question_moved','en','Question Moved',NULL,NULL),('assessment','logs_question_removed','en','Question Removed',NULL,NULL),('assessment','logs_question_removed_in_corrections','en','Question Removed in Corrections',NULL,NULL),('assessment','logs_question_selection_criteria_modified','en','Question Selection Criteria Modified',NULL,NULL),('assessment','logs_question_shown','en','Question Shown',NULL,NULL),('assessment','logs_question_skipped','en','Question Skipped',NULL,NULL),('assessment','logs_question_synchronisation_reset','en','Question Synchronisation Reset',NULL,NULL),('assessment','logs_scoring_settings_modified','en','Scoring Settings Modified',NULL,NULL),('assessment','logs_si','en','Scoring Interaction',NULL,NULL),('assessment','logs_tai','en','Test Administration Interaction',NULL,NULL),('assessment','logs_te','en','Error',NULL,NULL),('assessment','logs_test_deleted','en','Test Deleted',NULL,NULL),('assessment','logs_test_run_finished','en','Test Run Finished',NULL,NULL),('assessment','logs_test_run_of_participant_closed','en','Run of Participant Closed',NULL,NULL),('assessment','logs_test_run_started','en','Test Run Started',NULL,NULL),('assessment','logs_wrong_test_password_provided','en','Participant entered wrong test password.',NULL,NULL),('assessment','log_deletion_not_allowed','en','You don\'t have the necessary permissions to delete log entries.',NULL,NULL),('assessment','log_entry_type','en','Log Entry Type',NULL,NULL),('assessment','log_ip','en','Log IP',NULL,NULL),('assessment','log_ip_info','en','The IP of Participants is Logged for each interaction with a test. Disabling it does not delete existing IP records.',NULL,NULL),('assessment','log_participant_data_delete_warning','en','This test contains log data for participant interactions that will be deleted when changing the test to a test without names.',NULL,NULL),('assessment','log_text','en','Log message',NULL,NULL),('assessment','log_user_solution_willingly_deleted','en','User deleted the answer.',NULL,NULL),('assessment','longmenu','en','Longmenu',NULL,NULL),('assessment','longmenu_answeroptions_differ','en','This question does not work correctly, as there are not the same amount of gaps in the text as in the correction options.',NULL,NULL),('assessment','longmenu_text','en','Long Menu Text',NULL,NULL),('assessment','mailnottype','en','Send a notification every time a test attempt is completed.',NULL,NULL),('assessment','mailnottype_desc','en','Notify the owner of the test <strong>even if</strong> the number of test attempts has not been limited.',NULL,NULL),('assessment','mainbar_button_label_questionlist','en','Questionlist',NULL,NULL),('assessment','maintenance','en','Maintenance',NULL,NULL),('assessment','manscoring','en','Manual Scoring',NULL,NULL),('assessment','manscoring_done','en','Scored Participants',NULL,NULL),('assessment','manscoring_hint','en','You have added at least one question which may require manual scoring. To avoid participants getting access to the test results before you have finished manual scoring, please set a suitable date before which the results cannot be accessed.',NULL,NULL),('assessment','manscoring_none','en','Unscored Participants',NULL,NULL),('assessment','manscoring_not_allowed','en','The Manual Scoring wasn‘t activated for a question type. You are not allowed to use this tab.',NULL,NULL),('assessment','manscoring_questions_not_found','en','This test attempt does not contain question types which can be scored manually.',NULL,NULL),('assessment','manscoring_results_pass','en','Manual Scored Questions for Pass %s',NULL,NULL),('assessment','manual_editing','en','Manual Editing',NULL,NULL),('assessment','manual_entry','en','Manual Entry',NULL,NULL),('assessment','mark_schema','en','Grading System',NULL,NULL),('assessment','mark_schema_invalid','en','The grading system that you have tried to create contains errors. Please make sure that the values in the ‘Minimum Score Required (in %]’ column are correct.',NULL,NULL),('assessment','matches','en','matches',NULL,NULL),('assessment','matching_pairs','en','Matching Pairs',NULL,NULL),('assessment','matching_shuffle_definitions','en','Definitions only',NULL,NULL),('assessment','matching_shuffle_terms','en','Terms only',NULL,NULL),('assessment','matching_shuffle_terms_definitions','en','Both (Terms and Definitions)',NULL,NULL),('assessment','matching_type','en','Matching Question Subtype',NULL,NULL),('assessment','material','en','Material',NULL,NULL),('assessment','material_file','en','Material File',NULL,NULL),('assessment','maxchars','en','Maximum Number of Characters',NULL,NULL),('assessment','maximum_nr_of_tries_reached','en','You have reached the maximum number of passes for this test. The test cannot be entered!',NULL,NULL),('assessment','maximum_points','en','Maximum Available Points',NULL,NULL),('assessment','maxsize','en','Maximum file upload size',NULL,NULL),('assessment','maxsize_info','en','Enter the maximum size in bytes that should be allowed for file uploads. If you leave this field empty, the maximum size of this installation will be chosen instead.',NULL,NULL),('assessment','max_ip_label','en','Highest IP With Access',NULL,NULL),('assessment','min_auto_complete','en','Autocomplete',NULL,NULL),('assessment','min_ip_label','en','Lowest IP With Access',NULL,NULL),('assessment','min_percentage_ne_0','en','One of your grade categories needs to start at the ‘Minimum Score Required (in %)’ level of 0%  Your grading system hasn’t been saved.',NULL,NULL),('assessment','misc','en','Misc Options',NULL,NULL),('assessment','msg_circle_added','en','Circle added',NULL,NULL),('assessment','msg_no_questions_selected','en','No questions were selected.',NULL,NULL),('assessment','msg_number_of_terms_too_low','en','The number of terms must be greater or equal to the number of definitions.',NULL,NULL),('assessment','msg_poly_added','en','Polygon added',NULL,NULL),('assessment','msg_questions_moved','en','Question(s) moved',NULL,NULL),('assessment','msg_rect_added','en','Rectangle added',NULL,NULL),('assessment','msg_score_settings_modified_and_recalc','en','Your changes were saved and the results recalculated correspondingly.',NULL,NULL),('assessment','msg_score_settings_not_modified','en','Your changes were not saved.',NULL,NULL),('assessment','msg_selected_for_move','en','Question(s) selected for moving',NULL,NULL),('assessment','new_category','en','New Unit Category',NULL,NULL),('assessment','new_unit','en','New Unit',NULL,NULL),('assessment','next_question','en','Next',NULL,NULL),('assessment','next_question_rows','en','Questions %d - %d of %d →',NULL,NULL),('assessment','not_evaluated_users','en','Not Yet Evaluated User',NULL,NULL),('assessment','not_started','en','Not started yet',NULL,NULL),('assessment','not_yet_accessed','en','Not yet accessed',NULL,NULL),('assessment','no_manual_feedback_export_info','en','Manual feedbacks will not be exported.',NULL,NULL),('assessment','no_passed_after_failed','en','Failing marks cannot have a higher minimum level than any passing mark.',NULL,NULL),('assessment','no_passed_mark','en','At least one grade has to be a passing grade. For a grade to be a passing grade, it needs to have the appropriate box in the ‘Passed’ column checked.',NULL,NULL),('assessment','no_questions_available','en','There are no questions available!',NULL,NULL),('assessment','no_question_selected_for_move','en','Please check at least one question to move it!',NULL,NULL),('assessment','no_result_type','en','No Restrictions',NULL,NULL),('assessment','no_selection','en','--- No Selection ---',NULL,NULL),('assessment','no_selection_for_move','en','No question selected for moving',NULL,NULL),('assessment','no_target_selected_for_move','en','You must select a target position!',NULL,NULL),('assessment','no_user_or_group_selected','en','Please check an option what are you searching for (users, groups, roles)!',NULL,NULL),('assessment','no_valid_participant_selection','en','No valid Participants selected.',NULL,NULL),('assessment','nr_of_correct_answers','en','Number of Requested Answers',NULL,NULL),('assessment','number_of_answers','en','Number of Answers',NULL,NULL),('assessment','numeric_gap','en','Numeric Gap',NULL,NULL),('assessment','old_mark_default_not_applied','en','The marks from your personal settings could not be applied as they use an old format. All other settings have been updated.',NULL,NULL),('assessment','option_label','en','Option Labels',NULL,NULL),('assessment','option_label_adequate','en','adequate',NULL,NULL),('assessment','option_label_adequate_or_not','en','adequate / not adequate',NULL,NULL),('assessment','option_label_applicable','en','applicable',NULL,NULL),('assessment','option_label_applicable_or_not','en','applicable / not applicable',NULL,NULL),('assessment','option_label_custom','en','Userdefined Labels',NULL,NULL),('assessment','option_label_custom_false','en','Label for ‘FALSE’',NULL,NULL),('assessment','option_label_custom_true','en','Label for ‘TRUE’',NULL,NULL),('assessment','option_label_info','en','The configured phrases will be used as label for the options selectable by the participant.',NULL,NULL),('assessment','option_label_minus','en','-',NULL,NULL),('assessment','option_label_not_adequate','en','not adequate',NULL,NULL),('assessment','option_label_not_applicable','en','not applicable',NULL,NULL),('assessment','option_label_plus','en','+',NULL,NULL),('assessment','option_label_plus_minus','en','+ / -',NULL,NULL),('assessment','option_label_right','en','right',NULL,NULL),('assessment','option_label_right_wrong','en','right / wrong',NULL,NULL),('assessment','option_label_wrong','en','wrong',NULL,NULL),('assessment','oq_btn_define_pictures','en','Switch to picture definition view',NULL,NULL),('assessment','oq_btn_define_terms','en','Switch to term definition view',NULL,NULL),('assessment','oq_btn_nest_pictures','en','Switch to picture nesting view',NULL,NULL),('assessment','oq_btn_nest_terms','en','Switch to term nesting view',NULL,NULL),('assessment','oq_btn_use_order_pictures','en','Use answer pictures',NULL,NULL),('assessment','oq_btn_use_order_terms','en','Use answer terms',NULL,NULL),('assessment','oq_header_ordering_elements','en','Ordering Elements',NULL,NULL),('assessment','or','en','or',NULL,NULL),('assessment','order','en','Order',NULL,NULL),('assessment','ordering_answer_sequence_info','en','The answer sequence you define here will be taken as the correct solution sequence.',NULL,NULL),('assessment','ordertext','en','Ordering Text',NULL,NULL),('assessment','ordertext_info','en','Please enter the text that should be ordered horizontally. The ordering text will be separated by the whitespace signs in the text. If you need a different separation, you may use the separator %s to separate your text units.',NULL,NULL),('assessment','output','en','Output',NULL,NULL),('assessment','output_mode','en','Output Mode',NULL,NULL),('assessment','out_of_range','en','Out of range',NULL,NULL),('assessment','parseQuestion','en','Parse Question',NULL,NULL),('assessment','participants','en','Participants',NULL,NULL),('assessment','participants_invitation','en','Select Participants Manually',NULL,NULL),('assessment','participants_invitation_description','en','This test can only be accessed by users you have manually added in the ‘Participants’ tab of the test.',NULL,NULL),('assessment','participants_results_subtab','en','All Participants',NULL,NULL),('assessment','part_received_a_of_b_points','en','The participant received %s of %s possible points',NULL,NULL),('assessment','pass','en','Pass',NULL,NULL),('assessment','passed_official','en','passed',NULL,NULL),('assessment','passed_only','en','Passed Tests Only',NULL,NULL),('assessment','passed_short','en','passed',NULL,NULL),('assessment','passed_status','en','Passed Status',NULL,NULL),('assessment','passes_finished','en','%s passes',NULL,NULL),('assessment','pass_finished','en','%s pass',NULL,NULL),('assessment','percentage','en','Percentage',NULL,NULL),('assessment','percentage_points_achieved','en','Reached Points',NULL,NULL),('assessment','percentile','en','Percentile',NULL,NULL),('assessment','picture','en','Picture',NULL,NULL),('assessment','point','en','Point',NULL,NULL),('assessment','points','en','Points',NULL,NULL),('assessment','points_checked','en','Points when Checked',NULL,NULL),('assessment','points_non_numeric_or_negative_msg','en','Inputs for points only accept positive numeric values.',NULL,NULL),('assessment','points_short','en','Pt.',NULL,NULL),('assessment','points_unchecked','en','Points when Unchecked',NULL,NULL),('assessment','points_wrong','en','Wrong Selections',NULL,NULL),('assessment','points_wrong_info','en','Enter the negative points for each selected word that is not in the list of the marked errors.',NULL,NULL),('assessment','polygon','en','Polygon',NULL,NULL),('assessment','polygon_click_next_or_save','en','Please click on the next point of the polygon or save the area. (It is not necessary to click again on the starting point of this polygon !)',NULL,NULL),('assessment','polygon_click_next_point','en','Please click on the next point of the polygon.',NULL,NULL),('assessment','polygon_click_starting_point','en','Please click on the starting point of the polygon.',NULL,NULL),('assessment','positive_numbers_required','en','Please enter only positive numbers.',NULL,NULL),('assessment','postponed','en','postponed',NULL,NULL),('assessment','postpone_question','en','Move Question to the End',NULL,NULL),('assessment','precision','en','Precision',NULL,NULL),('assessment','previous_question','en','Previous',NULL,NULL),('assessment','previous_question_rows','en','<< Questions %d - %d of %d',NULL,NULL),('assessment','print_answers','en','Print Answers',NULL,NULL),('assessment','qpl_assessment_no_assessment_of_questions','en','There is no assessment of questions available for the selected question. The question has not yet been used in a test.',NULL,NULL),('assessment','qpl_assessment_total_of_answers','en','Total of Answers',NULL,NULL),('assessment','qpl_assessment_total_of_right_answers','en','Total Percentage of Correct Answers (percentage of maximum points)',NULL,NULL),('assessment','qpl_bulkedit_success','en','Modifications saved.',NULL,NULL),('assessment','qpl_bulk_save_add','en','Add',NULL,NULL),('assessment','qpl_bulk_save_overwrite','en','Overwrite',NULL,NULL),('assessment','qpl_cancel_skill_assigns_update','en','Cancel',NULL,NULL),('assessment','qpl_confirm_delete_questions','en','Are you sure you want to remove the following questions?',NULL,NULL),('assessment','qpl_copy_insert_clipboard','en','The selected question(s) are copied to the clipboard',NULL,NULL),('assessment','qpl_copy_select_none','en','Please check at least one question to copy it to the clipboard',NULL,NULL),('assessment','qpl_delete_rbac_error','en','You have no rights to remove this question!',NULL,NULL),('assessment','qpl_delete_select_none','en','Please check at least one question to remove it',NULL,NULL),('assessment','qpl_export_excel','en','Microsoft Excel File',NULL,NULL),('assessment','qpl_export_select_none','en','Please check at least one question to export it',NULL,NULL),('assessment','qpl_export_xml','en','QTI XML File',NULL,NULL),('assessment','qpl_form_general_settings','en','General Settings',NULL,NULL),('assessment','qpl_imagemap_preview_missing','en','ILIAS could not create the temporary preview file containing the image map areas. The original image is shown instead. This means that either the web server‘s ImageMagick tool isn‘t configured correctly or there are no write permissions in the temporary directory! Please contact your system administrator.',NULL,NULL),('assessment','qpl_import_create_new_qpl','en','Import the questions in a new question pool',NULL,NULL),('assessment','qpl_import_non_ilias_files','en','Error: The import file contains QTI files which are not created by an ILIAS system. Please contact the ILIAS team to get in import filter for your QTI file format.',NULL,NULL),('assessment','qpl_import_no_items','en','Error: The import file contains no questions!',NULL,NULL),('assessment','qpl_import_verify_found_questions','en','ILIAS found the following questions in the import file. Please select the questions you want to import.',NULL,NULL),('assessment','qpl_lac_desc_brackets','en','Brackets',NULL,NULL),('assessment','qpl_lac_desc_compare_answer_exist','en','Compare if there is an Answer for a Question/Gap',NULL,NULL),('assessment','qpl_lac_desc_compare_with_answer_n','en','Compare the Result with the n-th Answer of the Question',NULL,NULL),('assessment','qpl_lac_desc_compare_with_assignment','en','Compare the Result with the Matching n:m',NULL,NULL),('assessment','qpl_lac_desc_compare_with_exact_sequence','en','Compare the Result with exactly the Given Sequence',NULL,NULL),('assessment','qpl_lac_desc_compare_with_number','en','Compare the Result with the Number n',NULL,NULL),('assessment','qpl_lac_desc_compare_with_quest_res','en','Compare the Result with the Reached Points in Percent',NULL,NULL),('assessment','qpl_lac_desc_compare_with_sequence','en','Compare the Result with the Answer Sequence ($a,..,z$)',NULL,NULL),('assessment','qpl_lac_desc_compare_with_text','en','Compare the Result with the text TEXT',NULL,NULL),('assessment','qpl_lac_desc_logical_and','en','Logical AND',NULL,NULL),('assessment','qpl_lac_desc_logical_or','en','Logical OR',NULL,NULL),('assessment','qpl_lac_desc_negation','en','Negation',NULL,NULL),('assessment','qpl_lac_desc_res_of_answ_m_of_cur_quest','en','Result of m-th Answer of Current Question',NULL,NULL),('assessment','qpl_lac_desc_res_of_cur_quest','en','Result of Current Question',NULL,NULL),('assessment','qpl_lac_legend_header_common','en','Expression Logic',NULL,NULL),('assessment','qpl_lac_legend_header_quest_specific','en','Question Specific Expressions',NULL,NULL),('assessment','qpl_lac_legend_label_operators','en','Operators',NULL,NULL),('assessment','qpl_maxchars_info_numeric_question','en','If you enter a value, the field for the numerical answer will be created with a fixed length of this value, so entering more than the allowed characters is not possible. Note, that for numeric gaps the decimal separator is counted as a regular character.',NULL,NULL),('assessment','qpl_move_insert_clipboard','en','The selected question(s) are marked for moving',NULL,NULL),('assessment','qpl_move_select_none','en','Please check at least one question to select it for moving',NULL,NULL),('assessment','qpl_numeric_lower_needs_valid_lower_alert','en','The lower bound needs to be valid numerical value lower than the upper bound.',NULL,NULL),('assessment','qpl_numeric_upper_needs_valid_upper_alert','en','The upper bound needs to be valid numerical value greater than the lower bound.',NULL,NULL),('assessment','qpl_paste_error','en','At least one question could not be pasted into the question pool. Possible reason: You tried to move the question into the same question pool.',NULL,NULL),('assessment','qpl_paste_no_objects','en','There are no questions in the clipboard. Please copy or move a question into the clipboard.',NULL,NULL),('assessment','qpl_paste_success','en','The question(s) have been pasted into the question pool',NULL,NULL),('assessment','qpl_qst_edit_form_taxonomy','en','Taxonomy \"%s\"',NULL,NULL),('assessment','qpl_qst_edit_form_taxonomy_section','en','Taxonomies',NULL,NULL),('assessment','qpl_qst_inp_matching_mode','en','Matching Mode',NULL,NULL),('assessment','qpl_qst_inp_matching_mode_all_on_all','en','One or More Terms match One or More Definitions (n:n)',NULL,NULL),('assessment','qpl_qst_inp_matching_mode_one_on_one','en','One Term Matches One Definition (1:1)',NULL,NULL),('assessment','qpl_qst_skl_assigns_updated','en','The competence assignments has been updated.',NULL,NULL),('assessment','qpl_qst_skl_assign_properties_modified','en','The assignment\'s properties has been modified.',NULL,NULL),('assessment','qpl_qst_skl_assign_synced_to_orig','en','The competence assignments has been synchronised to the questions original.',NULL,NULL),('assessment','qpl_qst_skl_selection_for_question_header','en','Compence Assignments for Question: %s',NULL,NULL),('assessment','qpl_qst_skl_usg_numq_col','en','Number of Questions in Pool adressing this competence',NULL,NULL),('assessment','qpl_qst_skl_usg_skill_col','en','Competence',NULL,NULL),('assessment','qpl_qst_skl_usg_sklpnt_col','en','Total Sum of Competence-Points per Competence',NULL,NULL),('assessment','qpl_questions_deleted','en','Question(s) removed.',NULL,NULL),('assessment','qpl_question_is_in_use','en','The question you are about to edit exists in %s test(s). If you change this question, you will NOT change the question(s) in the test(s), because the system creates a copy of a question when it is inserted in a test!',NULL,NULL),('assessment','qpl_reset_preview','en','Reset Preview',NULL,NULL),('assessment','qpl_save_skill_assigns_update','en','Save Competence Assignments',NULL,NULL),('assessment','qpl_settings_availability','en','Availability',NULL,NULL),('assessment','qpl_settings_general_form_property_nav_taxonomy','en','Taxonomy Filter as Navigation Tree',NULL,NULL),('assessment','qpl_settings_general_form_property_nav_taxonomy_description','en','When a taxonomy is selected, it well be presented as navigation tree instead of a table filter item.',NULL,NULL),('assessment','qpl_settings_general_form_property_opt_notax_selected','en','Use No Navigation Tree Filter',NULL,NULL),('assessment','qpl_settings_general_form_property_show_taxonomies','en','Show Taxonomies',NULL,NULL),('assessment','qpl_settings_general_form_prop_show_tax_desc','en','Existing taxonomies in this pool are offered for question filtering.',NULL,NULL),('assessment','qpl_settings_subtab_general','en','General Settings',NULL,NULL),('assessment','qpl_settings_subtab_taxonomies','en','Taxonomies',NULL,NULL),('assessment','qpl_skill_point_eval_by_quest_result','en','Evaluation of Competence Points by Question Result',NULL,NULL),('assessment','qpl_skill_point_eval_by_solution_compare','en','Evaluation of Competence Points by Solution Compare',NULL,NULL),('assessment','qpl_skill_point_eval_mode_quest_result','en','Question Result',NULL,NULL),('assessment','qpl_skill_point_eval_mode_solution_compare','en','Solution Compare',NULL,NULL),('assessment','qpl_skl_sub_tab_quest_assign','en','Question/Competence Assignment',NULL,NULL),('assessment','qpl_skl_sub_tab_usages','en','Assignment Frequency',NULL,NULL),('assessment','qpl_sync_quest_skl_assigns_confirmation','en','The question was inserted from another repository object. Should the question\'s original be updated with the current config of competence assignments?',NULL,NULL),('assessment','qpl_tab_competences','en','Competences',NULL,NULL),('assessment','qpl_taxonomy_tab_info_message','en','Taxonomies in question pools can be used to filter the questions. After activating the function in the \"Settings\" tab, they are displayed in the filter in the \"Questions\" tab.',NULL,NULL),('assessment','qst_error_text_too_long','en','One or more text elements marked as erroneous are too long. The maximum size for a text element marked as erroneous is 150 characters:',NULL,NULL),('assessment','qst_essay_allready_written_words','en','Already entered words:',NULL,NULL),('assessment','qst_essay_chars_remaining','en','Remaining characters:',NULL,NULL),('assessment','qst_essay_wordcounter_enabled','en','Count Words',NULL,NULL),('assessment','qst_essay_wordcounter_enabled_info','en','The entered words are counted. The number of written words is shown to the participants below the text input field.',NULL,NULL),('assessment','qst_essay_written_words','en','Number of entered words:',NULL,NULL),('assessment','qst_lifecycle','en','Lifecycle',NULL,NULL),('assessment','qst_lifecycle_draft','en','Draft',NULL,NULL),('assessment','qst_lifecycle_filter_all','en','All Lifecycles',NULL,NULL),('assessment','qst_lifecycle_final','en','Final',NULL,NULL),('assessment','qst_lifecycle_outdated','en','Outdated',NULL,NULL),('assessment','qst_lifecycle_rejected','en','Rejected',NULL,NULL),('assessment','qst_lifecycle_review','en','To be Reviewed',NULL,NULL),('assessment','qst_lifecycle_sharable','en','Shareable',NULL,NULL),('assessment','qst_nested_nested_answers_off','en','No indents, just order',NULL,NULL),('assessment','qst_nested_nested_answers_on','en','Use indents in anwers',NULL,NULL),('assessment','qst_nr_of_tries','en','Number of Tries',NULL,NULL),('assessment','qst_preview_reset_msg','en','The preview has been reset.',NULL,NULL),('assessment','qst_use_nested_answers','en','Nested answers',NULL,NULL),('assessment','questionpool_not_entered','en','Please enter a name for a question pool!',NULL,NULL),('assessment','questionpool_not_selected','en','Please select a question pool!',NULL,NULL),('assessment','questions','en','Questions',NULL,NULL),('assessment','questions_from','en','questions from',NULL,NULL),('assessment','questions_per_page_view','en','Page View',NULL,NULL),('assessment','question_browse_area_info','en','Please select an object from which you want to import questions.',NULL,NULL),('assessment','question_complete_title','en','Complete',NULL,NULL),('assessment','question_cumulated_statistics','en','Cumulated Question Statistics',NULL,NULL),('assessment','question_id','en','Question ID',NULL,NULL),('assessment','question_id_short','en','ID',NULL,NULL),('assessment','question_instances_title','en','This question is used in the following tests',NULL,NULL),('assessment','question_is_part_of_running_test','en','Question is part of a running test and may not be edited.',NULL,NULL),('assessment','question_marking','en','Flagging Questions',NULL,NULL),('assessment','question_marking_description','en','Participants are given the option to flag test questions for themselves. The flags are shown in the ‘Test Attempt Overview’, if that feature it has been activated.',NULL,NULL),('assessment','question_not_answered','en','The question was not answered',NULL,NULL),('assessment','question_saved_for_upload','en','The question was saved automatically in order to reserve hard disk space to store the uploaded file. If you cancel this form now, be aware that you must delete the question in the question pool if you do not want to keep it!',NULL,NULL),('assessment','question_summary','en','Test Attempt Overview',NULL,NULL),('assessment','question_summary_btn','en','Test Attempt Overview',NULL,NULL),('assessment','question_title','en','Question Title',NULL,NULL),('assessment','question_type','en','Question Type',NULL,NULL),('assessment','que_contains_unused_var','en','The question text contains a variable, that is not used in any result formula!',NULL,NULL),('assessment','random_accept_sample','en','Accept Sample',NULL,NULL),('assessment','random_another_sample','en','Get another Sample',NULL,NULL),('assessment','random_selection','en','Random Selection',NULL,NULL),('assessment','range','en','Range',NULL,NULL),('assessment','range_lower_limit','en','Lower Bound',NULL,NULL),('assessment','range_max','en','Range (Maximum)',NULL,NULL),('assessment','range_min','en','Range (Minimum)',NULL,NULL),('assessment','range_upper_limit','en','Upper Bound',NULL,NULL),('assessment','rated_sign','en','Sign',NULL,NULL),('assessment','rated_unit','en','Unit',NULL,NULL),('assessment','rated_value','en','Value',NULL,NULL),('assessment','rating','en','Rating',NULL,NULL),('assessment','rating_sign','en','Rate Sign',NULL,NULL),('assessment','rating_simple','en','Simple Rating',NULL,NULL),('assessment','rating_unit','en','Rate Unit',NULL,NULL),('assessment','rating_value','en','Rate Value',NULL,NULL),('assessment','rectangle','en','Rectangle',NULL,NULL),('assessment','rectangle_click_br_corner','en','Please click on the bottom right corner of the desired area.',NULL,NULL),('assessment','rectangle_click_tl_corner','en','Please click on the top left corner of the desired area.',NULL,NULL),('assessment','redirectAfterSave','en','The maximum working time has been reached. In a few seconds you will be redirected...',NULL,NULL),('assessment','redirection_url','en','URL of webpage',NULL,NULL),('assessment','redirect_after_finishing_rule','en','Redirect',NULL,NULL),('assessment','redirect_after_finishing_tst','en','Redirect',NULL,NULL),('assessment','redirect_after_finishing_tst_desc','en','After completing the test, each participant is automatically redirected to a specific webpage of your choosing. This will only happen if participants do not have direct access to their test results. When entering the address of an external webpage, use the complete URL (including ‘https://’). When redirecting to an Object in ILIAS, use the permalink that can be found in the footer of the Object in question.',NULL,NULL),('assessment','redirect_always','en','Always to the specified webpage',NULL,NULL),('assessment','redirect_always_to_logout','en','Always to the logout screen',NULL,NULL),('assessment','redirect_in_kiosk_mode','en','When ‘Exam View’ is activated to the specified webpage',NULL,NULL),('assessment','redirect_url_invalid','en','Please enter a valid url of the target webpage.',NULL,NULL),('assessment','redirect_url_required_for_rule','en','The url of the webpage is required when \"%s\" is selected.',NULL,NULL),('assessment','region','en','Region',NULL,NULL),('assessment','remaining_duration','en','Remaining Duration',NULL,NULL),('assessment','remove_gap','en','Remove Gap',NULL,NULL),('assessment','remove_participants','en','Remove Participant(s)',NULL,NULL),('assessment','remove_question','en','Remove',NULL,NULL),('assessment','remove_selected_participants_confirmation','en','Are you sure you want to remove the selected participants from the test?',NULL,NULL),('assessment','remove_solution','en','Remove Content for Recapitulation',NULL,NULL),('assessment','reset_definitions','en','Reset Ordering',NULL,NULL),('assessment','reset_pictures','en','Reset Picture Positions',NULL,NULL),('assessment','reset_terms','en','Reset Ordering',NULL,NULL),('assessment','result','en','Result',NULL,NULL),('assessment','results','en','Results',NULL,NULL),('assessment','results_tab','en','Results',NULL,NULL),('assessment','resulttable_all','en','All',NULL,NULL),('assessment','resulttable_correct','en','Correct',NULL,NULL),('assessment','resulttable_incorrect','en','Incorrect/Incomplete',NULL,NULL),('assessment','resulttable_vc_sort_iooa','en','in order of appearance',NULL,NULL),('assessment','resulttable_vc_sort_posscore','en','highest possible score first',NULL,NULL),('assessment','result_co_frac','en','Coprime Fraction',NULL,NULL),('assessment','result_co_frac_info','en','Canceled out fraction i.e.: only 1/3 is a valid result',NULL,NULL),('assessment','result_dec','en','Decimal',NULL,NULL),('assessment','result_dec_info','en','Valid results are i.e.: 2,3 and 2.3',NULL,NULL),('assessment','result_frac','en','Fraction',NULL,NULL),('assessment','result_frac_info','en','i.e.: 1/3 and 2/6 are valid results',NULL,NULL),('assessment','result_type_selection','en','Result Type Selection',NULL,NULL),('assessment','result_units','en','Available Units',NULL,NULL),('assessment','result_units_info','en','The selected units are offered to the learner as part of an answer. The learner has to choose one unit.',NULL,NULL),('assessment','result_unit_info','en','Please note that the selected result unit must also be activated in ‘Available units’.',NULL,NULL),('assessment','result_x','en','Result %s',NULL,NULL),('assessment','res_contains_undef_res','en','A result formula contains an undefined result!',NULL,NULL),('assessment','res_contains_undef_var','en','A result formula contains an undefined variable!',NULL,NULL),('assessment','review_view','en','Review',NULL,NULL),('assessment','running','en','Running',NULL,NULL),('assessment','saved_adjustment','en','Changes saved.',NULL,NULL),('assessment','saveOrder','en','Save Order',NULL,NULL),('assessment','saveOrderAndObligations','en','Save Order and Obligations',NULL,NULL),('assessment','save_and_next','en','Save and Continue',NULL,NULL),('assessment','save_on_navigation','en','Save on Navigation',NULL,NULL),('assessment','save_on_navigation_confirmation','en','Your changed answers will be automatically saved when you navigate.',NULL,NULL),('assessment','save_on_navigation_forced_feedback_hint','en','Before you get feedback on your given answer.',NULL,NULL),('assessment','save_on_navigation_locked_confirmation','en','Your changed answers will be automatically saved and locked when you navigate.',NULL,NULL),('assessment','scored_pass','en','Scored Test Attempt',NULL,NULL),('assessment','score_partsol_enabled','en','Activate Half-Point Scoring',NULL,NULL),('assessment','score_partsol_enabled_info','en','Usually the participant has to answer the question fully correct to get the configured points. With this option the participant gets the half of the configured points with at least three correct decisions.',NULL,NULL),('assessment','scoring','en','Scoring and Results',NULL,NULL),('assessment','scoringadjust','en','Corrections',NULL,NULL),('assessment','search_groups','en','Search Groups',NULL,NULL),('assessment','search_roles','en','Search Roles',NULL,NULL),('assessment','search_term','en','Search Term',NULL,NULL),('assessment','selected_category','en','Selected Category: %s',NULL,NULL),('assessment','selection','en','Selection',NULL,NULL),('assessment','select_at_least_one_feedback_type_and_trigger','en','Please Select at least one type of feedback and a trigger.',NULL,NULL),('assessment','select_at_least_one_lock_answer_type','en','Please select at least one type of answer lock.',NULL,NULL),('assessment','select_gap','en','Select Gap',NULL,NULL),('assessment','select_max_one_item','en','Please select one item only',NULL,NULL),('assessment','select_one_user','en','Please select at least one user.',NULL,NULL),('assessment','select_question','en','Select a Question',NULL,NULL),('assessment','select_target_position_for_move_question','en','Please select a target position to move the question(s) and press one of the insert buttons!',NULL,NULL),('assessment','select_unit','en','--- Select Unit ---',NULL,NULL),('assessment','set_edit_mode','en','Set Edit Mode',NULL,NULL),('assessment','set_filter','en','Set Filter',NULL,NULL),('assessment','set_manscoring_done','en','Mark as ‘Scored Participant’',NULL,NULL),('assessment','set_manual_feedback','en','Manual Feedback',NULL,NULL),('assessment','shape','en','Shape',NULL,NULL),('assessment','showSuggestedSolution','en','Type',NULL,NULL),('assessment','show_all_test_properties_on_info_page','en','Show all Test Properties',NULL,NULL),('assessment','show_all_test_properties_on_info_page_byline','en','Users will be presented with a complete list of test properties in the ‘Info’ tab, i.e. information on scoring and reporting.',NULL,NULL),('assessment','show_answer_overview','en','Show Answer Overview',NULL,NULL),('assessment','show_best_solution','en','Show best solution',NULL,NULL),('assessment','show_detailed_results','en','Show User’s Detailed Results (Marked Pass)',NULL,NULL),('assessment','show_examview_html','en','On screen',NULL,NULL),('assessment','show_hide_best_solution','en','Show or hide best solution',NULL,NULL),('assessment','show_old_concluding_remarks','en','Show Old Concluding Remarks',NULL,NULL),('assessment','show_old_introduction','en','Show Old Introduction',NULL,NULL),('assessment','show_pass_overview','en','Show Marked Pass Overview',NULL,NULL),('assessment','show_requested_question_hints','en','Show Requested Hints',NULL,NULL),('assessment','show_results','en','Show Results',NULL,NULL),('assessment','show_user_answers','en','Show User’s Marked Answers',NULL,NULL),('assessment','shuffle_answers','en','Shuffle Answers',NULL,NULL),('assessment','skip_question','en','Do not Answer and Next',NULL,NULL),('assessment','solution','en','Solution',NULL,NULL),('assessment','solutions','en','Solutions',NULL,NULL),('assessment','solutionText','en','Text',NULL,NULL),('assessment','solution_contain_keywords','en','Score is granted based on the occurrence of the following keywords:',NULL,NULL),('assessment','solution_hint','en','Assigned Content for Recapitulation',NULL,NULL),('assessment','start_tag','en','Start Tag',NULL,NULL),('assessment','statistical_data','en','Statistical Data',NULL,NULL),('assessment','statistics','en','Statistics',NULL,NULL),('assessment','status_of_attempt','en','Status of Attempt',NULL,NULL),('assessment','submit_and_check','en','Save and Check Answer',NULL,NULL),('assessment','submit_answer','en','Save Answer',NULL,NULL),('assessment','suggestedSolutionType','en','Refer to',NULL,NULL),('assessment','suggested_solution','en','Content for Recapitulation',NULL,NULL),('assessment','suggested_solution_added_successfully','en','You successfully set a content for recapitulation!',NULL,NULL),('assessment','suggest_range','en','Suggest Range',NULL,NULL),('assessment','sync_question_to_pool','en','Synchronize Question',NULL,NULL),('assessment','tab_nest_answers','en','Nesting',NULL,NULL),('assessment','taxonomy_node_title','en','Taxonomy Node Title',NULL,NULL),('assessment','taxonomy_title','en','Taxonomy Title',NULL,NULL),('assessment','tax_filter','en','Taxonomy',NULL,NULL),('assessment','tax_filter_notax','en','Questions without assigned Taxonomy',NULL,NULL),('assessment','ta_resulttable_vc_mode_aria','en','switch question mode',NULL,NULL),('assessment','term','en','Term',NULL,NULL),('assessment','terms','en','Terms',NULL,NULL),('assessment','term_image','en','Term Image',NULL,NULL),('assessment','term_text','en','Term Text',NULL,NULL),('assessment','test_attempts_finished','en','The test pass has been finished for the selected participants.',NULL,NULL),('assessment','test_confirm_template_reset','en','Are you sure that you do not want to use the template anymore?',NULL,NULL),('assessment','test_delete_page','en','Delete Question',NULL,NULL),('assessment','test_edit_settings','en','Edit Settings',NULL,NULL),('assessment','test_enable_archiving','en','Enable Archiving',NULL,NULL),('assessment','test_has_datasets_warning_page_view','en','The test already contains data sets. The options to edit questions are limited until you remove these data sets.',NULL,NULL),('assessment','test_has_datasets_warning_page_view_link','en','Participant Results',NULL,NULL),('assessment','test_is_offline','en','You cannot start the test! The test is offline.',NULL,NULL),('assessment','test_jump_to','en','Jump to Question',NULL,NULL),('assessment','test_move_page','en','Move Question',NULL,NULL),('assessment','test_next_question','en','Next Question',NULL,NULL),('assessment','test_prev_question','en','Previous Question',NULL,NULL),('assessment','test_question_set_type','en','Selection of Test Questions',NULL,NULL),('assessment','test_question_set_type_fixed','en','Fixed Questions',NULL,NULL),('assessment','test_question_set_type_fixed_info','en','All test participants see the same questions.<br>You can create questions directly in the test as well as use questions from a Question Pool. If you create new questions, you can decide to save them in a Question Pool.',NULL,NULL),('assessment','test_question_set_type_random','en','Random Questions',NULL,NULL),('assessment','test_question_set_type_random_info','en','Each test participant will see an individually generated set of questions. The questions are drawn from one or more Question Pools.',NULL,NULL),('assessment','test_results','en','Summary Test Results',NULL,NULL),('assessment','test_scoring','en','Scoring Options',NULL,NULL),('assessment','test_template_reset','en','The template has been removed.',NULL,NULL),('assessment','test_title','en','Test Title',NULL,NULL),('assessment','test_using_template','en','This test uses the template %s. If you do not want to use a template and have access to all settings, please click here: %s.',NULL,NULL),('assessment','test_using_template_link','en','Do not use template anymore',NULL,NULL),('assessment','textsize','en','Text Size',NULL,NULL),('assessment','textsize_errortext_info','en','Enter the text size of the error text in percent if you want another size than 100 percent.',NULL,NULL),('assessment','textsize_info','en','Enter the text size of the ordering text in percent if you want another size than 100 percent.',NULL,NULL),('assessment','text_correct','en','Correct Text',NULL,NULL),('assessment','text_gap','en','Text Gap',NULL,NULL),('assessment','text_maximum_chars_allowed','en','Please do not enter more than a maximum of %s characters. Additional characters won\'t get cut, but the exceeding might be considered during scoring.',NULL,NULL),('assessment','text_rating','en','Text Matching Method',NULL,NULL),('assessment','text_wrong','en','Wrong Text',NULL,NULL),('assessment','thumb_size','en','Thumbnail Size',NULL,NULL),('assessment','thumb_size_info','en','The image thumbnails will be created with a maximum values of height and width given, aspect ratio preserved.',NULL,NULL),('assessment','thumb_size_unit_pixel','en','Pixel',NULL,NULL),('assessment','time_format','en','HH MM SS',NULL,NULL),('assessment','timing','en','Extra Time',NULL,NULL),('assessment','tolerance','en','Tolerance (%)',NULL,NULL),('assessment','tolerance_info','en','The tolerance specifies an allowable percentage deviation from the result value. With a tolerance of 0, only the exact result value is evaluated to be correct.',NULL,NULL),('assessment','too_many_targets_selected_for_move','en','You must select exactly one target position!',NULL,NULL),('assessment','toplist_by_score','en','High score by score',NULL,NULL),('assessment','toplist_by_time','en','High score by working time',NULL,NULL),('assessment','toplist_col_achieved','en','Date',NULL,NULL),('assessment','toplist_col_hints','en','Hints',NULL,NULL),('assessment','toplist_col_participant','en','Participant',NULL,NULL),('assessment','toplist_col_percentage','en','Percentage',NULL,NULL),('assessment','toplist_col_rank','en','Rank',NULL,NULL),('assessment','toplist_col_score','en','Score',NULL,NULL),('assessment','toplist_col_wtime','en','Working Time',NULL,NULL),('assessment','total_attempts','en','Total Attempts',NULL,NULL),('assessment','total_duration','en','Total Duration',NULL,NULL),('assessment','total_max_points_cannot_be_negative','en','The maximum amount of reachable points cannot be negative.',NULL,NULL),('assessment','true','en','True',NULL,NULL),('assessment','tst_access_code_created','en','To provide you with permanent access to your test results and to offer you a possibility to resume this test, a unique test access code was created. Please make a note of this code so that you can continue the test later.',NULL,NULL),('assessment','tst_activate_skill_service','en','Competence Service',NULL,NULL),('assessment','tst_activate_skill_service_desc','en','Supports the assignment of questions to competences and the definition of thresholds for reaching a specific competence level.',NULL,NULL),('assessment','tst_activation_limited_visibility_info','en','Before and after the period during which the test is available,  the test\'s title will be displayed, but participants won’t be able to take the test. Access, including to tests already in progress, will be prevented once the period of availability has ended.',NULL,NULL),('assessment','tst_activation_online_info','en','Participants can take the test if it is ‘Online’.',NULL,NULL),('assessment','tst_addit_passes_blocked_after_passed_msg','en','You have passed the test. The test cannot be started again.',NULL,NULL),('assessment','tst_add_quest_cont_edit_mode','en','Editor',NULL,NULL),('assessment','tst_add_quest_cont_edit_mode_IPE','en','Use plain text for questions and answers and ILIAS page editor for feedback and hints',NULL,NULL),('assessment','tst_add_quest_cont_edit_mode_IPE_info','en','No formatting of text in question and answers. No use of LaTex either. But feedback and hints can be reused when question is embedded in ILIAS learning module.',NULL,NULL),('assessment','tst_add_quest_cont_edit_mode_plain','en','Use plain text',NULL,NULL),('assessment','tst_add_quest_cont_edit_mode_plain_info','en','No formatting of text in question, answers, feedback, and hints.',NULL,NULL),('assessment','tst_add_quest_cont_edit_mode_RTE','en','Use Rich-Text-Editor (TinyMCE) for editing questions and answers, feedbacks and hints',NULL,NULL),('assessment','tst_add_quest_cont_edit_mode_RTE_info','en','Allows text formatting of questions, answers, feedbacks and hints. But feedback and hints cannot be reused when question is embedded in ILIAS learning module.',NULL,NULL),('assessment','tst_all_test_competences','en','All Test Competence',NULL,NULL),('assessment','tst_all_user_data_deleted','en','All user data for this test has been removed!',NULL,NULL),('assessment','tst_already_passed_cannot_retake','en','Test already passed. You cannot start the test again.',NULL,NULL),('assessment','tst_already_submitted','en','The test has already been completed and submitted.',NULL,NULL),('assessment','tst_analysis','en','Analysis',NULL,NULL),('assessment','tst_anonymity','en','Privacy',NULL,NULL),('assessment','tst_anonymity_anonymous_test','en','Results Without Names / Anonymous Test',NULL,NULL),('assessment','tst_anonymity_no_anonymization','en','Results With Names',NULL,NULL),('assessment','tst_answered_questions','en','Nr. of Answered Questions',NULL,NULL),('assessment','tst_answered_questions_of_total','en','%s of %s',NULL,NULL),('assessment','tst_answered_questions_test','en','Questions answered in this test',NULL,NULL),('assessment','tst_answer_aggr_answer_header','en','Answer',NULL,NULL),('assessment','tst_answer_aggr_frequency_header','en','Frequency',NULL,NULL),('assessment','tst_answer_details','en','Answer Details',NULL,NULL),('assessment','tst_answer_fixation','en','Lock Answers',NULL,NULL),('assessment','tst_answer_fixation_handling','en','Answer Lock',NULL,NULL),('assessment','tst_answer_fixation_none','en','Do Not Lock Answers',NULL,NULL),('assessment','tst_answer_fixation_none_desc','en','As long as a participant has not finished a test attempt (i.e. by clicking on ‘Finish the Test’), they can change their answers at any time.',NULL,NULL),('assessment','tst_answer_fixation_on_followup_question','en','Lock Answers After Moving to Next Question',NULL,NULL),('assessment','tst_answer_fixation_on_followup_question_desc','en','As soon as the next question in the test has been revealed, a participant’s answers to the previous question are locked and can no longer be changed.',NULL,NULL),('assessment','tst_answer_fixation_on_instantfb_or_followupqst','en','Lock Answers After Feedback or Moving to Next Question',NULL,NULL),('assessment','tst_answer_fixation_on_instantfb_or_followupqst_desc','en','A participant’s answers to a question will be locked as soon as the question\'s feedback is shown or when the next question in the test has been revealed.',NULL,NULL),('assessment','tst_answer_fixation_on_instant_feedback','en','Lock Answers After Feedback Received',NULL,NULL),('assessment','tst_answer_fixation_on_instant_feedback_desc','en','After the feedback to a question has been shown, a participant’s answers are locked and they can no longer change their answers.',NULL,NULL),('assessment','tst_answer_status_answered','en','Answered',NULL,NULL),('assessment','tst_answer_status_editing','en',' (editing)',NULL,NULL),('assessment','tst_answer_status_not_answered','en','Not answered',NULL,NULL),('assessment','tst_attached_xls_file','en','You can find the test results for this participant in the attached Excel file.',NULL,NULL),('assessment','tst_attempt','en','Attempt',NULL,NULL),('assessment','tst_attempt_limit_message','en','Your limit of test attempts is <b>%s</b>.',NULL,NULL),('assessment','tst_attempt_started','en','Attempt Started',NULL,NULL),('assessment','tst_back_to_pass_details','en','Back to Pass Details',NULL,NULL),('assessment','tst_back_to_question_list','en','Back to Question List',NULL,NULL),('assessment','tst_back_to_top','en','Back to Top',NULL,NULL),('assessment','tst_back_to_virtual_pass','en','Back to Question Overview',NULL,NULL),('assessment','tst_best_solution_is','en','The best solution is',NULL,NULL),('assessment','tst_block_passes_after_passed','en','Block Additional Passes After Test is Passed',NULL,NULL),('assessment','tst_block_passes_after_passed_info','en','After a participant has passed the test, no further test attempts are allowed to the participant with this option.',NULL,NULL),('assessment','tst_browse_for_qpl_questions','en','Add from Pool',NULL,NULL),('assessment','tst_browse_for_tst_questions','en','Add from Other Test',NULL,NULL),('assessment','tst_btn_hide_best_solutions','en','Hide Best Solutions',NULL,NULL),('assessment','tst_btn_rebuild_random_question_stage','en','Synchronize Questions from Pool',NULL,NULL),('assessment','tst_btn_reset_pool_sync','en','Edit/Cancel Synchronisation',NULL,NULL),('assessment','tst_btn_show_best_solutions','en','Show Best Solutions',NULL,NULL),('assessment','tst_cannot_online_due_to_switched_quest_set_type_setting','en','The test cannot be set to online, because the test mode setting has been changed. You have to set a test mode relating question config before the test can be set to online.',NULL,NULL),('assessment','tst_change_dyn_test_question_selection','en','Change Question Selection',NULL,NULL),('assessment','tst_change_points_for_question','en','Points for the Answer',NULL,NULL),('assessment','tst_change_quest_set_type_from_old_to_new_with_conflict','en','You are about to change the test mode from <b>%s</b> to <b>%s</b>, although a questions/question pool configuration dependent on the current test mode already exists.<br />This already existing configuration will be lost.',NULL,NULL),('assessment','tst_change_workingtime','en','Add extra time for a participant',NULL,NULL),('assessment','tst_competence','en','Competence',NULL,NULL),('assessment','tst_comp_eval_mode','en','Evaluation by',NULL,NULL),('assessment','tst_comp_points','en','Competence Points',NULL,NULL),('assessment','tst_conditions_checkbox_enabled','en','Exam Conditions',NULL,NULL),('assessment','tst_conditions_checkbox_enabled_desc','en','Participants must select a checkbox to start the test. Please use the introductory message to present the exam to the participants.',NULL,NULL),('assessment','tst_confirm_submit_answers','en','Please confirm your submission of your solution. You won\'t be able to revert your answers after pressing the submit button.',NULL,NULL),('assessment','tst_conflicting_setting','en','This setting does conflict with another setting.',NULL,NULL),('assessment','tst_copy','en','Copy Test',NULL,NULL),('assessment','tst_corrections_answers_tbl','en','Statistics',NULL,NULL),('assessment','tst_corrections_answers_tbl_subindex','en','Statistics for %s',NULL,NULL),('assessment','tst_corrections_incompatible_question_set_type','en','Corrections are only possible if the test uses a fixed set of questions.',NULL,NULL),('assessment','tst_corrections_manscore_reset_warning','en','There are %s manual scorings that have been done for the question \"%s (ID: %s)\". All manual scorings will be reset when saving the question.',NULL,NULL),('assessment','tst_corrections_qst_form','en','Correction of Points',NULL,NULL),('assessment','tst_corrections_tab_question','en','Question',NULL,NULL),('assessment','tst_corrections_tab_solution','en','Solution',NULL,NULL),('assessment','tst_corrections_tab_statistics','en','Statistics',NULL,NULL),('assessment','tst_corr_add_as_answer_btn','en','Add as Correct Answer',NULL,NULL),('assessment','tst_corr_answ_stat_tbl_header_answer','en','Answer',NULL,NULL),('assessment','tst_corr_answ_stat_tbl_header_frequency','en','Frequency',NULL,NULL),('assessment','tst_count_correct_solutions','en','Only Correct and Complete Answers Score Points',NULL,NULL),('assessment','tst_count_correct_solutions_desc','en','Participants score either the maximum number of points for a fully correct and complete answer or 0 points in every other case. This is also valid for questions that define points for partial answers.',NULL,NULL),('assessment','tst_count_partial_solutions','en','Incomplete or Partly Wrong Answers Score Points',NULL,NULL),('assessment','tst_count_partial_solutions_desc','en','When a question defines points for partial answers, points for correctly provided partial answers are added up: Participants can score points for incomplete or partly wrong answers on these questions.',NULL,NULL),('assessment','tst_current_run_no_longer_valid','en','Your current test run is no longer valid. <br>It was probably completed already or finished by a tutor.',NULL,NULL),('assessment','tst_defaults_applied','en','The selected test defaults have been applied.',NULL,NULL),('assessment','tst_defaults_apply_not_possible','en','ILIAS could not apply the selected test defaults to this test! Maybe this test already contains participant data sets.',NULL,NULL),('assessment','tst_defaults_apply_select_one','en','Please select exact one test defaults entry to apply the defaults to this test!',NULL,NULL),('assessment','tst_defaults_available','en','Available test defaults',NULL,NULL),('assessment','tst_defaults_defaults_of_test','en','the settings of this test as',NULL,NULL),('assessment','tst_defaults_enter_name','en','Please enter a name for your test default settings!',NULL,NULL),('assessment','tst_defaults_not_defined','en','You don’t have any test default settings defined yet.',NULL,NULL),('assessment','tst_default_settings','en','Personal Default Settings',NULL,NULL),('assessment','tst_delete_missing_mark','en','Please select at least one mark step to remove it',NULL,NULL),('assessment','tst_derive_new_pool','en','Derive New Question Pool',NULL,NULL),('assessment','tst_derive_new_pools','en','Derive New Question Pools',NULL,NULL),('assessment','tst_dont_show_msg_again_in_current_session','en','Don\'t show this message again in my current session.',NULL,NULL),('assessment','tst_dont_use_previous_answers','en','Your previous answers will not be used as default values in future test attempts',NULL,NULL),('assessment','tst_edit_competence_assign','en','Edit Assignment Properties',NULL,NULL),('assessment','tst_edit_scoring','en','Edit Scoring',NULL,NULL),('assessment','tst_enable_questionlist','en','Show \'List of Questions’',NULL,NULL),('assessment','tst_enable_questionlist_description','en','Participants can switch on a list of the test questions on the left of the actual question.',NULL,NULL),('assessment','tst_ending_time','en','Finishing Time',NULL,NULL),('assessment','tst_ending_time_before_starting_time','en','Please enter a date for the end of the test that is after the start date.',NULL,NULL),('assessment','tst_ending_time_desc','en','Time from which participants can no longer submit answers. <strong>Important</strong>: Do <strong>not</strong> use this option for e-exams/distance exams. Instead, use the function \'Limit Duration of Test\' (see below). Only then will the test be ended on the server side and each participant\'s last entry in Essay-Questions automatically saved as auto-save-content.',NULL,NULL),('assessment','tst_enter_questionpool','en','Please enter a question pool name where the new question will be stored',NULL,NULL),('assessment','tst_eval_question_points','en','Question Results for Pass %s',NULL,NULL),('assessment','tst_eval_results_by_pass','en','List of Answers for Pass %s',NULL,NULL),('assessment','tst_eval_results_by_pass_lo','en','List of Answers for Attempt %s',NULL,NULL),('assessment','tst_eval_results_lo','en','List of Answers',NULL,NULL),('assessment','tst_eval_show_answer','en','Show Answer',NULL,NULL),('assessment','tst_eval_total_finished','en','Total finished tests (Participants that used up all possible passes.)',NULL,NULL),('assessment','tst_eval_total_finished_average_time','en','Average Time on Task',NULL,NULL),('assessment','tst_eval_total_passed','en','Total passed tests',NULL,NULL),('assessment','tst_eval_total_passed_average_points','en','Average points of passed tests',NULL,NULL),('assessment','tst_eval_total_passed_average_time','en','Average Time on Task of All Passed Tests',NULL,NULL),('assessment','tst_eval_total_persons','en','Total number of participants who started the test',NULL,NULL),('assessment','tst_exam_access_code','en','Access Code',NULL,NULL),('assessment','tst_exam_access_code_label','en','Enter access code to continue your already started test. Leave the field empty to start a new test run.',NULL,NULL),('assessment','tst_exam_conditions','en','Exam Conditions',NULL,NULL),('assessment','tst_exam_conditions_label','en','Check to accept the conditions.',NULL,NULL),('assessment','tst_exam_conditions_not_checked_message','en','You need to accept the exam conditions!',NULL,NULL),('assessment','tst_exam_ending_time_message','en','The test cannot be started after %s.',NULL,NULL),('assessment','tst_exam_modal_message_conditions','en','Please confirm the conditions to start the test.',NULL,NULL),('assessment','tst_exam_modal_message_conditions_and_password','en','Please confirm the conditions and enter the password to start the test.',NULL,NULL),('assessment','tst_exam_modal_message_password','en','Please enter the password to start the test.',NULL,NULL),('assessment','tst_exam_not_assigned_participant_disclaimer','en','You cannot start this test, as you are not an assigned participant.',NULL,NULL),('assessment','tst_exam_password','en','Test Password',NULL,NULL),('assessment','tst_exam_password_invalid_message','en','The given password is not valid!',NULL,NULL),('assessment','tst_exam_password_label','en','Password',NULL,NULL),('assessment','tst_exam_required_fields_not_filled_message','en','You need to fill out all required fields!',NULL,NULL),('assessment','tst_exam_start','en','Start Test',NULL,NULL),('assessment','tst_exam_use_previous_answers','en','Previous Answers',NULL,NULL),('assessment','tst_exam_use_previous_answers_label','en','If enabled answers from previous tests will be prefilled.',NULL,NULL),('assessment','tst_extratime_added','en','The working time of the participant has been increased by %s minutes.',NULL,NULL),('assessment','tst_extratime_info','en','If you want to add the working time multiple times for the same participant, please insert the total amount of time you want to add.',NULL,NULL),('assessment','tst_extratime_notavailable','en','Extra time can be added only for tests with one pass and a maximum processing time.',NULL,NULL),('assessment','tst_failed','en','Failed',NULL,NULL),('assessment','tst_failed_imp_qst_skl_assign','en','The question\'s assignments to the following competences could not be created. The according competences could not be identified within the local system.',NULL,NULL),('assessment','tst_failed_imp_skl_thresholds','en','The Import of thresholds for the following competences were skipped, because the according competences within the local system are configured with a different list of levels.',NULL,NULL),('assessment','tst_feedback','en','Feedback',NULL,NULL),('assessment','tst_feedback_is_given_inline','en','The feedback will be displayed along with your answer.',NULL,NULL),('assessment','tst_feedback_not_available_for_answer','en','There is no feedback available for your answer.',NULL,NULL),('assessment','tst_filter_lifecycle_enabled','en','Use Lifecycle as Filter',NULL,NULL),('assessment','tst_filter_question_type','en','Question Type',NULL,NULL),('assessment','tst_filter_question_type_enabled','en','Use Question Type as Filter',NULL,NULL),('assessment','tst_filter_taxonomy','en','Taxonomy',NULL,NULL),('assessment','tst_filter_tax_node','en','Taxonomy Node',NULL,NULL),('assessment','tst_final_information','en','Finishing the Test',NULL,NULL),('assessment','tst_finished','en','Finished',NULL,NULL),('assessment','tst_finish_confirmation_question','en','You are going to finish this test. You won’t be able to enter this test attempt again to change your answers. Do you really want to finish this test?',NULL,NULL),('assessment','tst_finish_confirmation_question_no_attempts_left','en','You are going to finish this test and reach the maximum number of allowed test attempts. You won’t be able to enter this test again to change your answers. Do you really want to finish the test?',NULL,NULL),('assessment','tst_finish_confirm_button','en','Yes, I want to finish the test',NULL,NULL),('assessment','tst_finish_confirm_cancel_button','en','No, go back to the previous question',NULL,NULL),('assessment','tst_finish_notification','en','Notification',NULL,NULL),('assessment','tst_finish_notification_advanced','en','Send complete test result',NULL,NULL),('assessment','tst_finish_notification_content_type','en','Content of e-mail',NULL,NULL),('assessment','tst_finish_notification_desc','en','Sends an e-mail to the test owner for every user that has completed the test.',NULL,NULL),('assessment','tst_finish_notification_no','en','No e-mail',NULL,NULL),('assessment','tst_finish_notification_simple','en','Send username and finish date',NULL,NULL),('assessment','tst_form_dynamic_question_set_config','en','Continues Question Selection',NULL,NULL),('assessment','tst_gap_analysis','en','Gap Analysis',NULL,NULL),('assessment','tst_general_properties','en','General Settings',NULL,NULL),('assessment','tst_header_participant','en','Question and your answer:',NULL,NULL),('assessment','tst_header_participant_no_answer','en','Question - not answered',NULL,NULL),('assessment','tst_header_solution','en','Best Solution:',NULL,NULL),('assessment','tst_heading_scoring','en','Scoring',NULL,NULL),('assessment','tst_hide_info_tab','en','Hide Info Tab',NULL,NULL),('assessment','tst_hide_info_tab_desc','en','Hides the tab ‘Info’ of the test.',NULL,NULL),('assessment','tst_hide_pagecontents','en','Hide page content',NULL,NULL),('assessment','tst_hide_pagecontents_desc','en','ILIAS content placed before and after the actual question text via the \"Edit Page\" button will not be displayed in the result views and print output.',NULL,NULL),('assessment','tst_hide_side_list','en','Hide List of Questions',NULL,NULL),('assessment','tst_highscore_achieved_ts','en','Date',NULL,NULL),('assessment','tst_highscore_achieved_ts_description','en','A column containing the test date will be included in the ranking.',NULL,NULL),('assessment','tst_highscore_all_tables','en','Participant\'s Own Rank and Top Ranking',NULL,NULL),('assessment','tst_highscore_all_tables_description','en','Participants get information about the top ranking and their own position in the ranking.',NULL,NULL),('assessment','tst_highscore_anon','en','Without Names',NULL,NULL),('assessment','tst_highscore_anon_description','en','Ranking is displayed without listing the names of the other participants. This will be the case anyway if the test was taken anonymously.',NULL,NULL),('assessment','tst_highscore_description','en','Within the \'My Results\'-tab participants are presented with a subtab \'Show Ranking\'. On clicking it participants are presented with a league table on the performance in the test. You have to activate \'Access to Test Results\', too in order to use this functionality.',NULL,NULL),('assessment','tst_highscore_enabled','en','Ranking',NULL,NULL),('assessment','tst_highscore_hints','en','Hints',NULL,NULL),('assessment','tst_highscore_hints_description','en','A column containing the requested hints will be included in the ranking.',NULL,NULL),('assessment','tst_highscore_mode','en','Mode',NULL,NULL),('assessment','tst_highscore_own_table','en','Participant\'s Own Rank',NULL,NULL),('assessment','tst_highscore_own_table_description','en','Participants are advised of their own position in the ranking.',NULL,NULL),('assessment','tst_highscore_percentage','en','Percentage',NULL,NULL),('assessment','tst_highscore_percentage_description','en','A column containing the tests percentage will be included in the ranking.',NULL,NULL),('assessment','tst_highscore_score','en','Score',NULL,NULL),('assessment','tst_highscore_score_description','en','A column containing the score will be included in the ranking.',NULL,NULL),('assessment','tst_highscore_top_num','en','Length of Top Ranking',NULL,NULL),('assessment','tst_highscore_top_num_description','en','Specify how many ranks are to be included in the top ranking list.',NULL,NULL),('assessment','tst_highscore_top_num_unit','en','entries',NULL,NULL),('assessment','tst_highscore_top_table','en','Top Ranking',NULL,NULL),('assessment','tst_highscore_top_table_description','en','Participants are presented with a table containing the top rankings.',NULL,NULL),('assessment','tst_highscore_wtime','en','Duration of Test',NULL,NULL),('assessment','tst_highscore_wtime_description','en','A column containing the duration of the test will be included in the ranking.',NULL,NULL),('assessment','tst_imap_qst_mode','en','Mode',NULL,NULL),('assessment','tst_imap_qst_mode_mc','en','Multiple Choice',NULL,NULL),('assessment','tst_imap_qst_mode_sc','en','Single Choice',NULL,NULL),('assessment','tst_import_non_ilias_zip','en','Error: The filename of the uploaded import file does not match the expected format.',NULL,NULL),('assessment','tst_import_verify_found_questions','en','ILIAS found the following questions in the test import file. Please select the questions you want to import with this test.',NULL,NULL),('assessment','tst_input_dynamic_question_set_ordering_tax','en','Ordering Taxonomy',NULL,NULL),('assessment','tst_input_dynamic_question_set_ordering_tax_description','en','The test questions will be presented accordingly to their assignments in the selected taxonomy.',NULL,NULL),('assessment','tst_input_dynamic_question_set_question_ordering','en','Question Ordering',NULL,NULL),('assessment','tst_input_dynamic_question_set_question_ordering_by_date','en','Order Questions by Date',NULL,NULL),('assessment','tst_input_dynamic_question_set_question_ordering_by_tax','en','Order Questions by Taxonomy',NULL,NULL),('assessment','tst_input_dynamic_question_set_source_questionpool','en','Source Question Pool',NULL,NULL),('assessment','tst_input_dynamic_question_set_taxonomie_filter_enabled','en','Provide Taxonomy Filter',NULL,NULL),('assessment','tst_input_dyn_quest_set_answer_status_filter_enabled','en','Provide Answer Status Filter',NULL,NULL),('assessment','tst_inp_all_quest_points_equal_per_pool','en','Use Only Pools with Equal Scored Questions',NULL,NULL),('assessment','tst_inp_all_quest_points_equal_per_pool_desc','en','If enabled, only question pools in which all questions have the same points are offered. Participants of such a test can all have the same number of maximum points, thus the test results will be better comparable. It is recommended to choose this option. Please take note that preexisting rules are not reevaluated upon activation of this setting.',NULL,NULL),('assessment','tst_inp_dyn_quest_set_quest_ordering_by_date_desc','en','The presentation order for the questions bases upon the question\'s last editing date.',NULL,NULL),('assessment','tst_inp_dyn_quest_set_quest_ordering_by_tax_desc','en','The presentation order for the questions bases upon the question\'s assignments in a taxonomy.',NULL,NULL),('assessment','tst_inp_no_available_tax_hint','en','No Available Taxonomies for Selected Question Pool',NULL,NULL),('assessment','tst_inp_quest_amount_cfg_mode','en','Amount of Questions',NULL,NULL),('assessment','tst_inp_quest_amount_cfg_mode_pool','en','Define the amount of questions per selected question pool and taxonomy node.',NULL,NULL),('assessment','tst_inp_quest_amount_cfg_mode_test','en','Define the amount of questions per test',NULL,NULL),('assessment','tst_inp_quest_amount_per_source_pool','en','Question Amount',NULL,NULL),('assessment','tst_inp_quest_amount_per_test','en','Number of Questions for the Whole Test',NULL,NULL),('assessment','tst_inp_source_pool_filter_tax','en','Taxonomy Filter',NULL,NULL),('assessment','tst_inp_source_pool_filter_tax_x','en','Use Taxonomy \"%s\" as Filter',NULL,NULL),('assessment','tst_inp_source_pool_label','en','Question Pool',NULL,NULL),('assessment','tst_inp_source_pool_no_tax_filter','en','Use No Taxonomy Based Filter',NULL,NULL),('assessment','tst_insert_in_test','en','Insert in Test',NULL,NULL),('assessment','tst_insert_missing_question','en','Please select at least one question to insert it into the test!',NULL,NULL),('assessment','tst_insert_questions','en','Are you sure you want to insert the following question(s) to the test?',NULL,NULL),('assessment','tst_instant_feedback','en','Instant Feedback',NULL,NULL),('assessment','tst_instant_feedback_answer_generic','en','Feedback on Fully Correct Answer',NULL,NULL),('assessment','tst_instant_feedback_answer_generic_desc','en','If the answer provided is fully correct ILIAS will show one type of feedback upon clicking the ‘Check’ button.  If the answer provided is not fully correct, another type of feedback will be displayed. Both types of feedback have to be prepared in the tab ‘Feedback’ of the respective question.',NULL,NULL),('assessment','tst_instant_feedback_answer_specific','en','Specific Feedback for Each Answer provided',NULL,NULL),('assessment','tst_instant_feedback_answer_specific_desc','en','On clicking the ‘Check’-button, ILIAS will show a specific feedback for every answer option selected by the participant. The feedback has to be prepared along with the question. This specific feedback is not supported for all question types.',NULL,NULL),('assessment','tst_instant_feedback_contents','en','Included Contents',NULL,NULL),('assessment','tst_instant_feedback_desc','en','When questions are configured with feedback it is provided to participants during the test attempt.',NULL,NULL),('assessment','tst_instant_feedback_results','en','Points Attained',NULL,NULL),('assessment','tst_instant_feedback_results_desc','en','On clicking the ‘Check’ button ILIAS will display how many points were attained by answering this question.',NULL,NULL),('assessment','tst_instant_feedback_solution','en','Show Best Possible Answer',NULL,NULL),('assessment','tst_instant_feedback_solution_desc','en','On clicking the ‘Check’ button ILIAS will display the best possible answer to the question.',NULL,NULL),('assessment','tst_instant_feedback_trigger','en','Feedback Trigger',NULL,NULL),('assessment','tst_instant_feedback_trigger_forced','en','The Feedback is Triggered by Answering Questions',NULL,NULL),('assessment','tst_instant_feedback_trigger_forced_desc','en','The presentation of feedback is forced to all participants with answering a question.',NULL,NULL),('assessment','tst_instant_feedback_trigger_manual','en','Participants can Trigger the Feedback Manually',NULL,NULL),('assessment','tst_instant_feedback_trigger_manual_desc','en','The feedback is availble but will only be shown when a participant triggers the presentation manually.',NULL,NULL),('assessment','tst_introduction','en','Introductory Message',NULL,NULL),('assessment','tst_introduction_desc','en','Shows an introductory message on the ‘Test’ tab. The message can be edited in the sub-tab \'Edit Introduction\' of these settings and is accessible already before the test can be started.',NULL,NULL),('assessment','tst_introduction_text','en','Introductory Message',NULL,NULL),('assessment','tst_invited_nobody','en','No users, groups or roles have been added as fixed test participants',NULL,NULL),('assessment','tst_invited_selected_users','en','The selected users have been added as fixed test participants',NULL,NULL),('assessment','tst_launcher_button_label_passes_limit_reached','en','You have reached the limit of possible test passes',NULL,NULL),('assessment','tst_launcher_status_message_conditions','en','You will be asked for your approval of the exam conditions when you start the test.',NULL,NULL),('assessment','tst_launcher_status_message_conditions_and_password','en','You will be asked for the password and your approval of the exam conditions when you start the test.',NULL,NULL),('assessment','tst_launcher_status_message_password','en','You will be asked for the password when you start the test.',NULL,NULL),('assessment','tst_level','en','Competence Level',NULL,NULL),('assessment','tst_limit_nr_of_tries','en','Limit Number of Test Attempts',NULL,NULL),('assessment','tst_link_only_unassigned','en','You have selected at least one question that is already linked to a question pool. Only unassigned questions can be added to a question pool.',NULL,NULL),('assessment','tst_list_answer_details','en','Show in List Below',NULL,NULL),('assessment','tst_list_of_answers','en','List of Answers',NULL,NULL),('assessment','tst_list_of_answers_show','en','Review of Scored Answers',NULL,NULL),('assessment','tst_list_of_questions_end','en','Show before a participant finishes the test',NULL,NULL),('assessment','tst_list_of_questions_start','en','Show prior to the first question',NULL,NULL),('assessment','tst_list_of_questions_with_description','en','Include question descriptions',NULL,NULL),('assessment','tst_manage_competence_assigns','en','Manage Competence Assignments',NULL,NULL),('assessment','tst_manscoring_input_max_points_for_question','en','Maximum Points for Question',NULL,NULL),('assessment','tst_manscoring_input_question_and_user_solution','en','Question and User Solution',NULL,NULL),('assessment','tst_manscoring_maxpoints_exceeded_input_alert','en','The maximum of %s point(s) is exceeded!',NULL,NULL),('assessment','tst_manscoring_question_section_header','en','Question: %s',NULL,NULL),('assessment','tst_manscoring_user_notification','en','Send Notification',NULL,NULL),('assessment','tst_man_scoring_by_part','en','Scoring by Participant',NULL,NULL),('assessment','tst_man_scoring_by_qst','en','Scoring by Question',NULL,NULL),('assessment','tst_man_scoring_only_answered','en','Only answered',NULL,NULL),('assessment','tst_mark','en','Mark',NULL,NULL),('assessment','tst_mark_create_new_mark_step','en','Create New Mark Step',NULL,NULL),('assessment','tst_mark_minimum_level','en','Minimum Level (in %)',NULL,NULL),('assessment','tst_mark_minimum_level_invalid','en','Minimum Level must be between 0 and 100.',NULL,NULL),('assessment','tst_mark_official_form','en','Official Form',NULL,NULL),('assessment','tst_mark_passed','en','Passed',NULL,NULL),('assessment','tst_mark_reset_to_simple_mark_schema','en','Reset to Simple Mark Schema',NULL,NULL),('assessment','tst_mark_reset_to_simple_mark_schema_confirmation','en','If you proceed the current mark schema set for this test will be replaced by a simple mark schema thus deleting all local changes.',NULL,NULL),('assessment','tst_mark_short_form','en','Short Form',NULL,NULL),('assessment','tst_maximum_points','en','Maximum Points',NULL,NULL),('assessment','tst_max_comp_points','en','Max. Competence Points',NULL,NULL),('assessment','tst_mc_label_none_above','en','None of the answers above',NULL,NULL),('assessment','tst_median_mark_panel','en','Mark of Median',NULL,NULL),('assessment','tst_msg_cannot_modify_dynamic_question_set_conf_due_to_part','en','Continues question selection configuration cannot be modified due to existing participant data.',NULL,NULL),('assessment','tst_msg_cannot_modify_random_question_set_conf_due_to_part','en','The random question set configuration cannot be modified due to existing participant data.',NULL,NULL),('assessment','tst_msg_dynamic_question_set_config_modified','en','Continues question selection configuration has been modified.',NULL,NULL),('assessment','tst_msg_random_qsc_modified_add_new_rule','en','The configuration for the random set of questions has been modified successfully. You can add a new rule now.',NULL,NULL),('assessment','tst_msg_random_question_set_config_modified','en','The configuration for the random set of questions has been modified successfully.',NULL,NULL),('assessment','tst_msg_random_question_set_synced','en','The questions for the current configuration has been synchronized successfully.',NULL,NULL),('assessment','tst_msg_rand_quest_set_change_quest_amount_here','en','You can change the question amount here: %s',NULL,NULL),('assessment','tst_msg_rand_quest_set_incomplete_quest_amount_cfg','en','A test with a random set of questions is not possible without a correctly defined amount of questions.',NULL,NULL),('assessment','tst_msg_rand_quest_set_lost_pools','en','The test\'s question selection configuration has been frozen, because the following question pools that are involved to the config are not available anymore. The non available pools can be newly derived.<br />%s',NULL,NULL),('assessment','tst_msg_rand_quest_set_lost_pools_link','en','Open Selected Question Pools',NULL,NULL),('assessment','tst_msg_rand_quest_set_not_sync','en','The rules for a random selection of questions were newly created or changed. The questions from the pools have to be synchronized in the test before it can be used. This checks also if a random test is possible with the given set of rules.',NULL,NULL),('assessment','tst_msg_rand_quest_set_no_pools_available','en','Currently you cannot add new rules for the question selection, because there are no question pools available.',NULL,NULL),('assessment','tst_msg_rand_quest_set_no_src_pool_defs','en','A test with a random set of questions is not possible without selecting at least one question pool.',NULL,NULL),('assessment','tst_msg_rand_quest_set_pass_buildable','en','A test with a random set of questions is possible with the current configuration.',NULL,NULL),('assessment','tst_msg_rand_quest_set_pass_not_buildable','en','<b>A test with a random set of questions is not possible with the current selection of question pools and the amount of questions.</b><br />',NULL,NULL),('assessment','tst_msg_rand_quest_set_rule_label','en','Rule %s',NULL,NULL),('assessment','tst_msg_rand_quest_set_rule_not_satisfied_missing','en','Rule %s requires %s questions, but there are only %s questions provided.',NULL,NULL),('assessment','tst_msg_rand_quest_set_rule_not_satisfied_missing_shared','en','Additionally from these questions there are %s questions also provided to the following other rules: %s',NULL,NULL),('assessment','tst_msg_rand_quest_set_rule_not_satisfied_reserved','en','Rule %s requires %s questions and there are %s questions provided.',NULL,NULL),('assessment','tst_msg_rand_quest_set_rule_not_satisfied_reserved_shared','en','But there are only %s of the provided questions guaranteed available, because of intersections with the following other rules: %s',NULL,NULL),('assessment','tst_msg_rand_quest_set_stage_pool_last_sync','en','Date of last synchronisation of selected question pools: %s',NULL,NULL),('assessment','tst_msg_skl_lvl_thresholds_saved','en','The competence thresholds has been saved.',NULL,NULL),('assessment','tst_msg_skl_qst_assign_points_not_saved','en','The competence points have not been saved. Please check your input.',NULL,NULL),('assessment','tst_msg_skl_qst_assign_points_saved','en','The competence points have been saved.',NULL,NULL),('assessment','tst_msg_source_pool_definitions_deleted','en','The rule has been removed successfully.',NULL,NULL),('assessment','tst_nav_next_locks_current_answer_confirm','en','When you navigate to the next question your answer to the current question will be locked and cannot be changed any longer.',NULL,NULL),('assessment','tst_nav_next_locks_current_answer_header','en','Navigation to Next Question',NULL,NULL),('assessment','tst_nav_next_locks_empty_answer_confirm','en','You did not answer the current question. An empty solution will be saved and locked as answer. This answer cannot be changed later on.',NULL,NULL),('assessment','tst_nav_next_locks_empty_answer_header','en','Navigation Without Answer',NULL,NULL),('assessment','tst_nav_while_edit_modal_cancel_btn','en','Cancel',NULL,NULL),('assessment','tst_nav_while_edit_modal_header','en','Decision about Answers',NULL,NULL),('assessment','tst_nav_while_edit_modal_nosave_btn','en','Do Not Save',NULL,NULL),('assessment','tst_nav_while_edit_modal_save_btn','en','Save',NULL,NULL),('assessment','tst_nav_while_edit_modal_text','en','What to do with the answers you possibly entered for this question?',NULL,NULL),('assessment','tst_nonpool_questions_get_lost_warning','en','<b>The current test mode includes questions in its configuration that are not assigned to any question pool. If you change the test mode, these questions will be lost permanently.</b>',NULL,NULL),('assessment','tst_non_available_pool_newly_derived','en','The new question pool(s) has been derived successfully.',NULL,NULL),('assessment','tst_non_avail_pools_table','en','Non Available Questionpools',NULL,NULL),('assessment','tst_non_avail_pool_msg_status_lost','en','This question pool is not available anymore. Synchronizing questions from this pool is not possible any longer. You can derive a new question pool from the questions contained in this test.',NULL,NULL),('assessment','tst_non_avail_pool_msg_status_trashed','en','This question pool is trashed, when it gets removed from system permanently, the test is no longer able to synchronize questions from it.',NULL,NULL),('assessment','tst_notification_explanation_admin','en','You receive this mail from ILIAS because you activated the notification.',NULL,NULL),('assessment','tst_notify_manscoring_done_body_msg_reason','en','You have received this notification, because you participated in this test.',NULL,NULL),('assessment','tst_notify_manscoring_done_body_msg_subject','en','Manual Scoring for Test \"%s\" committed',NULL,NULL),('assessment','tst_notify_manscoring_done_body_msg_topic','en','Your test has been graded manually:',NULL,NULL),('assessment','tst_no_evaluation_data','en','There is no evaluation data available.',NULL,NULL),('assessment','tst_no_marks_defined','en','There are no marks defined, please create at least a simple mark schema!',NULL,NULL),('assessment','tst_no_question_selected_for_moving_to_qpl','en','Please choose at least one question to be added to a question pool!',NULL,NULL),('assessment','tst_no_question_selected_for_removal','en','Please check at least one question to remove it!',NULL,NULL),('assessment','tst_no_scorable_qst_available','en','No question to score available',NULL,NULL),('assessment','tst_no_tries','en','none',NULL,NULL),('assessment','tst_nr_of_passes','en','Number of Test Attempts',NULL,NULL),('assessment','tst_nr_of_tries','en','Max. Number of Attempts',NULL,NULL),('assessment','tst_nr_of_tries_desc','en','Maximum number of passes a participant can take.',NULL,NULL),('assessment','tst_nr_of_tries_of_user','en','Passes Already Completed',NULL,NULL),('assessment','tst_num_all_questions','en','Number of All Questions',NULL,NULL),('assessment','tst_num_correct_answered_questions','en','Answered Correctly',NULL,NULL),('assessment','tst_num_non_answered_questions_notseen','en','Not Presented, Yet',NULL,NULL),('assessment','tst_num_non_answered_questions_skipped','en','Skipped',NULL,NULL),('assessment','tst_num_questions','en','Number of Questions',NULL,NULL),('assessment','tst_num_selected_questions','en','Number of Selected Questions',NULL,NULL),('assessment','tst_num_wrong_answered_questions','en',' Answered Wrongly',NULL,NULL),('assessment','tst_objectives_progress_header','en','Learning Objectives Progress',NULL,NULL),('assessment','tst_objective_oriented_test_pass_without_questions','en','The started pass for test \"%s\" does not contain any questions.',NULL,NULL),('assessment','tst_objective_progress_header','en','Learning Objective Progress',NULL,NULL),('assessment','tst_old_style_rnd_quest_set_broken','en','This random test is in a irreparable state, because one or more connected question pools have been deleted. Therefor participants cannot take the test any longer.',NULL,NULL),('assessment','tst_optional_questions_confirmation_non_fixed_test','en','<b>Question related to already passed learning objectives are optional.</b><br /><br />You want to navigate to a question, that relates to an already passed learning objective.<br />You can choose:<br /><br />I you proceed, you can work on these questions. Your answers from previous attempts were not adopted, since new random questions were selected for this attempt. With working on this questions you can also degrade your learning objective result.<br /><br />If you decide to not work on these questions, you can go back. In this case these questions won\'t be considered in the evaluation.',NULL,NULL),('assessment','tst_out_of_time_message','en','You have reached the maximum allowed processing time of the test!',NULL,NULL),('assessment','tst_participant','en','Participant',NULL,NULL),('assessment','tst_participant_fullname_pattern','en','%2$s, %1$s',NULL,NULL),('assessment','tst_participant_status','en','Participant Status',NULL,NULL),('assessment','tst_participating_users','en','Participating Users',NULL,NULL),('assessment','tst_passed','en','Passed',NULL,NULL),('assessment','tst_passes','en','Test Attempts',NULL,NULL),('assessment','tst_password','en','Test Password',NULL,NULL),('assessment','tst_password_details','en','If you define a test password, all users with test access must enter this password to start the test.',NULL,NULL),('assessment','tst_password_enter','en','Enter Password',NULL,NULL),('assessment','tst_password_entered_wrong_password','en','You cannot start the test because you entered the wrong test password!',NULL,NULL),('assessment','tst_password_form','en','Enter Test Password',NULL,NULL),('assessment','tst_password_introduction','en','This test can only be accessed with a test password. Please enter the test password to start the test.',NULL,NULL),('assessment','tst_pass_best_pass','en','Score the Best Attempt',NULL,NULL),('assessment','tst_pass_best_pass_desc','en','The pass in which a participant performed best will be scored. This setting does only apply when more than one test attempt is possible.',NULL,NULL),('assessment','tst_pass_deletion','en','Previous Passes',NULL,NULL),('assessment','tst_pass_deletion_allowed','en','The deletion of non-scoring attempts is allowed.',NULL,NULL),('assessment','tst_pass_details','en','Detailed Results',NULL,NULL),('assessment','tst_pass_details_header_lo_initial','en','Initial Test Results for the Learning Objectives<br />%s - %s',NULL,NULL),('assessment','tst_pass_details_header_lo_qualifying','en','Qualifying Test Results for the Learning Objectives<br />%s - %s',NULL,NULL),('assessment','tst_pass_details_overview_table_title','en','Detailed Overview for Pass %s',NULL,NULL),('assessment','tst_pass_finished','en','Test attempt finished',NULL,NULL),('assessment','tst_pass_finished_on','en','Test attempt finished on',NULL,NULL),('assessment','tst_pass_last_pass','en','Score the Last Attempt',NULL,NULL),('assessment','tst_pass_last_pass_desc','en','The last attempt of a participant will be scored.',NULL,NULL),('assessment','tst_pass_overview_for_participant','en','Test Attempts for Participant: %s',NULL,NULL),('assessment','tst_pass_overview_header_lo_initial_all_objectives','en','Initial Test Results<br />for the Learning Objectives within the Course %s',NULL,NULL),('assessment','tst_pass_overview_header_lo_initial_per_objective','en','Initial Test Results<br />for the Learning Objectives %s within the Course %s',NULL,NULL),('assessment','tst_pass_overview_header_lo_qualifying_all_objectives','en','Qualifying Test Results<br />for the Learning Objectives within the Course %s',NULL,NULL),('assessment','tst_pass_overview_header_lo_qualifying_per_objective','en','Qualifying Test Results<br />for the Learning Objectives %s within the Course %s',NULL,NULL),('assessment','tst_pass_scoring','en','Scoring Multiple Passes',NULL,NULL),('assessment','tst_pass_scoring_best','en','Best Test Attempt',NULL,NULL),('assessment','tst_pass_scoring_last','en','Last Test Attempt',NULL,NULL),('assessment','tst_pass_waiting_enabled','en','Force Waiting Time between Attempts',NULL,NULL),('assessment','tst_pass_waiting_info','en','With this option additional passes can not be started before the defined time is lapsed relating to the last finished pass.',NULL,NULL),('assessment','tst_pass_waiting_time','en','Waiting Time',NULL,NULL),('assessment','tst_percent_solved','en','Percent Solved',NULL,NULL),('assessment','tst_player_answer_saved_and_locked','en','Answer is saved and locked and can no longer be changed',NULL,NULL),('assessment','tst_please_select_source_pool','en','Please select a question pool.',NULL,NULL),('assessment','tst_please_select_target_for_pool_derives','en','Please select a target conatainer.',NULL,NULL),('assessment','tst_position','en','Question %s of %s',NULL,NULL),('assessment','tst_position_without_total','en','Question %s',NULL,NULL),('assessment','tst_postpone','en','Unanswered Questions',NULL,NULL),('assessment','tst_postpone_off','en','Unanswered Questions Stay in Position',NULL,NULL),('assessment','tst_postpone_off_desc','en','Question that users just look at and flip over without answering them, will stay at their position in the test and will not be enqueued at the end of the test.',NULL,NULL),('assessment','tst_postpone_on','en','Unanswered questions will be enqueued',NULL,NULL),('assessment','tst_postpone_on_desc','en','Question that users just look at and flip over without answering them, will be enqueued to be presented again automatically the end of the test.',NULL,NULL),('assessment','tst_presentation_properties','en','Administering the Test: Behavior of the Question',NULL,NULL),('assessment','tst_presentation_settings_section','en','Presentation',NULL,NULL),('assessment','tst_previous_access_code_not_available','en','No previous code available!',NULL,NULL),('assessment','tst_proceed','en','Proceed',NULL,NULL),('assessment','tst_processing_time','en','Limit Duration of Test',NULL,NULL),('assessment','tst_processing_time_desc','en','Participants can work through the test only for a specified period of time. Time is clocking away from the moment a user starts a test for the first time. Suspending the test does not stop the clock. If the number of possible test attempts is limited an additional feature for granting extra time to participants appears in the tab \'Participants\'.',NULL,NULL),('assessment','tst_processing_time_duration','en','Maximum Duration of the Test in Minutes',NULL,NULL),('assessment','tst_processing_time_duration_desc','en','Maximum of time granted to take the test.',NULL,NULL),('assessment','tst_qbt_filter_question_title','en','Title of Question',NULL,NULL),('assessment','tst_qst_added_to_pool_p','en','Successfully added the questions to the selected pool.',NULL,NULL),('assessment','tst_qst_added_to_pool_s','en','Successfully added the question to the selected pool.',NULL,NULL),('assessment','tst_qst_order','en','No.',NULL,NULL),('assessment','tst_qst_skl_cfg_in_pool_hint_dynquestset','en','The Competence-Question-Assignment for tests with mode \"%s\" is to be done in the corresponding question pool:<br />%s<br /><br />The configuration of threshold values is to be done here in the test.',NULL,NULL),('assessment','tst_qst_skl_cfg_in_pool_hint_rndquestset','en','The Competence-Question-Assignment for tests with mode \"%s\" is to be done in the corresponding question pool(s):<br />%s<br /><br />The configuration of threshold values is to be done here in the test.',NULL,NULL),('assessment','tst_question','en','Question',NULL,NULL),('assessment','tst_questions_hints_table_cmd_save_order','en','Save Order',NULL,NULL),('assessment','tst_questions_hints_table_multicmd_cut_hint','en','Cut Hint to Ordering Clipboard',NULL,NULL),('assessment','tst_questions_hints_table_multicmd_delete_hint','en','Delete Hint(s)',NULL,NULL),('assessment','tst_questions_hints_table_multicmd_paste_hint_after','en','Append Hint to the Selected One',NULL,NULL),('assessment','tst_questions_hints_table_multicmd_paste_hint_before','en','Prepend Hint to the Selected One',NULL,NULL),('assessment','tst_questions_hints_toolbar_cmd_add_hint','en','Add Hint',NULL,NULL),('assessment','tst_questions_hints_toolbar_cmd_reset_ordering_clipboard','en','Reset Hint Ordering Clipboard',NULL,NULL),('assessment','tst_questions_inserted','en','Question(s) inserted!',NULL,NULL),('assessment','tst_questions_removed','en','Question(s) removed!',NULL,NULL),('assessment','tst_question_amount','en','Question Amount',NULL,NULL),('assessment','tst_question_answer_status','en','Which questions should be presented?',NULL,NULL),('assessment','tst_question_answer_status_all_non_correct','en','All Questions Except those Answered Correctly',NULL,NULL),('assessment','tst_question_answer_status_non_answered','en','Non Answered Questions',NULL,NULL),('assessment','tst_question_answer_status_wrong_answered','en','Only wrongly answered questions',NULL,NULL),('assessment','tst_question_feedback_back_to_feedback_form','en','Back To Calling Question',NULL,NULL),('assessment','tst_question_feedback_edit_page','en','Edit Content',NULL,NULL),('assessment','tst_question_hints_back_to_hint_list','en','Question Hint List',NULL,NULL),('assessment','tst_question_hints_back_to_question','en','Back to Question',NULL,NULL),('assessment','tst_question_hints_cancel_request','en','Back to Question',NULL,NULL),('assessment','tst_question_hints_confirm_request','en','Request Hint',NULL,NULL),('assessment','tst_question_hints_cut_hints_missing_selection_msg','en','No hint selected for cutting.',NULL,NULL),('assessment','tst_question_hints_cut_hints_single_selection_msg','en','More than one hint was selected for cutting.',NULL,NULL),('assessment','tst_question_hints_delete_hints_confirm_cmd','en','Delete Hint(s)',NULL,NULL),('assessment','tst_question_hints_delete_hints_confirm_header','en','Do you really want to delete the following hint(s)?',NULL,NULL),('assessment','tst_question_hints_delete_hints_confirm_item','en','Hint %s: %s',NULL,NULL),('assessment','tst_question_hints_delete_hints_missing_selection_msg','en','No hint(s) selected for deletion.',NULL,NULL),('assessment','tst_question_hints_delete_success_msg','en','The selected hint(s) has been deleted successfully.',NULL,NULL),('assessment','tst_question_hints_form_cmd_save','en','Save Hint',NULL,NULL),('assessment','tst_question_hints_form_cmd_save_points','en','Save Points',NULL,NULL),('assessment','tst_question_hints_form_cmd_save_points_and_edit_page','en',' Save Points and Edit Page',NULL,NULL),('assessment','tst_question_hints_form_header_create','en','New Hint for Question: %s',NULL,NULL),('assessment','tst_question_hints_form_header_edit','en','Hint %s for Question: %s',NULL,NULL),('assessment','tst_question_hints_form_invalid_msg','en','The hint could not been saved. Please check your inputs.',NULL,NULL),('assessment','tst_question_hints_form_label_hint_points','en','Point Deduction',NULL,NULL),('assessment','tst_question_hints_form_label_hint_text','en','Hint',NULL,NULL),('assessment','tst_question_hints_form_saved_msg','en','The hint has been saved successfully.',NULL,NULL),('assessment','tst_question_hints_index_column_label','en','Hint %s',NULL,NULL),('assessment','tst_question_hints_item_stored_in_ordering_clipboard','en','Hint %s is stored in ordering clipboard.',NULL,NULL),('assessment','tst_question_hints_ordering_clipboard_resetted','en','The ordering clipboard has been reset.',NULL,NULL),('assessment','tst_question_hints_paste_after_success_msg','en','The hint %s has been pasted after hint %s successfully.',NULL,NULL),('assessment','tst_question_hints_paste_before_success_msg','en','The hint %s has been pasted before hint %s successfully.',NULL,NULL),('assessment','tst_question_hints_requested_hint_count_header','en','Requested Hints',NULL,NULL),('assessment','tst_question_hints_request_confirmation','en','Do you really want to request hint %s? For this hint %s point(s) will be deducted.',NULL,NULL),('assessment','tst_question_hints_request_confirmation_no_deduction','en','No points will be deducted for this hint.',NULL,NULL),('assessment','tst_question_hints_save_order_success_msg','en','The order of hint was saved successfully.',NULL,NULL),('assessment','tst_question_hints_tab','en','Hints',NULL,NULL),('assessment','tst_question_hints_table_column_hint_index','en','Index',NULL,NULL),('assessment','tst_question_hints_table_column_hint_order','en','Order',NULL,NULL),('assessment','tst_question_hints_table_column_hint_points','en','Points Deduction',NULL,NULL),('assessment','tst_question_hints_table_column_hint_text','en','Hint',NULL,NULL),('assessment','tst_question_hints_table_header','en','Hints for Question: %s',NULL,NULL),('assessment','tst_question_hints_table_link_delete_hint','en','Delete Hint',NULL,NULL),('assessment','tst_question_hints_table_link_edit_hint','en','Edit Hint',NULL,NULL),('assessment','tst_question_hints_table_link_edit_hint_page','en','Edit Page',NULL,NULL),('assessment','tst_question_hints_table_link_edit_hint_points','en','Edit Points',NULL,NULL),('assessment','tst_question_hints_table_no_items','en','No Existing Hints',NULL,NULL),('assessment','tst_question_mark','en','Flag this question',NULL,NULL),('assessment','tst_question_marked','en','You flagged the question',NULL,NULL),('assessment','tst_question_marker','en','Flagged',NULL,NULL),('assessment','tst_question_no','en','Order',NULL,NULL),('assessment','tst_question_not_from_pool_info','en','No Pool',NULL,NULL),('assessment','tst_question_not_marked','en','Question is not Marked',NULL,NULL),('assessment','tst_question_offer','en','Do you accept this sample or do you want another one?',NULL,NULL),('assessment','tst_question_set_type','en','Selection of Test Questions',NULL,NULL),('assessment','tst_question_set_type_dynamic','en','Question Queue - All Questions from a Question Pool',NULL,NULL),('assessment','tst_question_set_type_dynamic_desc','en','Participants work through questions from one question pool. Questions answered incorrectly will be presented again. Questions can be added and edited in a running test.',NULL,NULL),('assessment','tst_question_set_type_fixed','en','Fixed Set of Questions',NULL,NULL),('assessment','tst_question_set_type_fixed_desc','en','All participants get the same set of questions.',NULL,NULL),('assessment','tst_question_set_type_random','en','Random Set of Questions',NULL,NULL),('assessment','tst_question_set_type_random_desc','en','Each participant gets a different set of questions. Questions are randomly selected from one or more question pools.',NULL,NULL),('assessment','tst_question_title','en','Question Title',NULL,NULL),('assessment','tst_question_type','en','Question Type',NULL,NULL),('assessment','tst_random_nr_of_questions','en','How many questions?',NULL,NULL),('assessment','tst_random_question_set_source_questionpool_summary_string','en','%s (Path: %s) [%s Questions]',NULL,NULL),('assessment','tst_random_select_questionpool','en','Select the question pool to choose the questions from',NULL,NULL),('assessment','tst_reached_points','en','Reached Points',NULL,NULL),('assessment','tst_reached_points_of_max','en','%s of %s',NULL,NULL),('assessment','tst_remove_mark','en','Remove this flag',NULL,NULL),('assessment','tst_remove_question','en','Are you sure you want to remove the following question from the test?',NULL,NULL),('assessment','tst_remove_questions','en','Are you sure you want to remove the following questions from the test?',NULL,NULL),('assessment','tst_remove_questions_and_results','en','This test contains test results. Removing questions from this test will remove the corresponding results. Are you sure you want to remove the following question(s) from the test?',NULL,NULL),('assessment','tst_reporting_date','en','Date',NULL,NULL),('assessment','tst_report_after_date','en','After a fixed score reporting date',NULL,NULL),('assessment','tst_report_after_first_question','en','Offer test results when the test has been started',NULL,NULL),('assessment','tst_report_after_passed','en','Offer test results when the test has been passed',NULL,NULL),('assessment','tst_report_after_test','en','Offer test results when the test is finished',NULL,NULL),('assessment','tst_report_never','en','No test results available',NULL,NULL),('assessment','tst_reset_processing_time','en','Reset duration for every test attempt',NULL,NULL),('assessment','tst_reset_processing_time_desc','en','The duration will be reset to the defined maximum for every test attempt. This setting requires multiple test attempts to become effective.',NULL,NULL),('assessment','tst_result','en','Test Result',NULL,NULL),('assessment','tst_results','en','Test Results',NULL,NULL),('assessment','tst_results_access_always','en','Immediately',NULL,NULL),('assessment','tst_results_access_always_desc','en','Participants can access their results within the ‘Results’-tab immediately after starting the test attempt and while still taking the test. Additionally ILIAS will redirect to the \'Results\'-tab after the test has been finished.',NULL,NULL),('assessment','tst_results_access_date','en','Date',NULL,NULL),('assessment','tst_results_access_date_desc','en','Participants get access to their test results within a \'My Results\'-tab after the defined date.',NULL,NULL),('assessment','tst_results_access_enabled','en','Access to Test Results',NULL,NULL),('assessment','tst_results_access_enabled_desc','en','A tab \'My Results\' will be offered to participants. Options in this section and the following ones below configure what information is to be included into the report and when it will be accessible.',NULL,NULL),('assessment','tst_results_access_finished','en','After Test Attempt is Finished',NULL,NULL),('assessment','tst_results_access_finished_desc','en','ILIAS displays the test results after the test attempt is finished. After finishing the test attempt participants can access their test results within the ‘My Results’-tab at any time.',NULL,NULL),('assessment','tst_results_access_passed','en','After Test has been Passed',NULL,NULL),('assessment','tst_results_access_passed_desc','en','ILIAS displays the test results after the participant has passed the test. After passing the test participants can access their test results within the \'My Results\'-tab at any time.',NULL,NULL),('assessment','tst_results_access_setting','en','Point in Time',NULL,NULL),('assessment','tst_results_aggregated','en','Aggregated Test Results',NULL,NULL),('assessment','tst_results_back_introduction','en','Back to Introductory Message',NULL,NULL),('assessment','tst_results_back_overview','en','Back to Results Overview',NULL,NULL),('assessment','tst_results_details_options','en','Further Options',NULL,NULL),('assessment','tst_results_gamification','en','Gamification',NULL,NULL),('assessment','tst_results_grading_opt_show_details','en','Show detailed test results',NULL,NULL),('assessment','tst_results_grading_opt_show_details_desc','en','In addition to the summary test result, a \"Detailed Results\" action is provided. The \"Detailed test results\" table shows the titles of the questions and the points achieved for each run. The content of the table can be further supplemented in the \"Further options\" section.',NULL,NULL),('assessment','tst_results_grading_opt_show_mark','en','Show Resulting Mark',NULL,NULL),('assessment','tst_results_grading_opt_show_mark_desc','en','The resulting mark will be appended to the summary test result. Participants can access their test results within the ‘My Results’-tab.',NULL,NULL),('assessment','tst_results_grading_opt_show_status','en','Show ‘Passed’ / ‘Failed’ Status',NULL,NULL),('assessment','tst_results_grading_opt_show_status_desc','en','Information on the ‘Passed’ / ‘Failed’ Status will be appended to the summary test result. Participants can access their test results within the ‘My Results’-tab.',NULL,NULL),('assessment','tst_results_overview','en','Pass Overview of the Test Results',NULL,NULL),('assessment','tst_results_print_best_solution','en','Best Solution',NULL,NULL),('assessment','tst_results_print_best_solution_info','en','Additionally for each question the best possible solution will be displayed.',NULL,NULL),('assessment','tst_result_pass','en','Results of Test Attempt',NULL,NULL),('assessment','tst_result_user_name','en','Test Results for %s',NULL,NULL),('assessment','tst_result_user_name_pass','en','Results of Test Attempt %s for %s',NULL,NULL),('assessment','tst_resume_test','en','Resume the Test',NULL,NULL),('assessment','tst_res_jump_to_participant_btn','en','Jump',NULL,NULL),('assessment','tst_res_jump_to_participant_hint_opt','en','Jump to Participant',NULL,NULL),('assessment','tst_res_lo_objectives_header','en','Relevant Learning Objectives',NULL,NULL),('assessment','tst_res_lo_try_header','en','Attempt',NULL,NULL),('assessment','tst_res_lo_try_n','en','Attempt %s',NULL,NULL),('assessment','tst_res_tab_msg_no_lp_access','en','You are currently not allowed to access your Learning Progress, as you are not allowed to see your test results.',NULL,NULL),('assessment','tst_res_tab_msg_res_after_date','en','Your test results will be shown here after: %s',NULL,NULL),('assessment','tst_res_tab_msg_res_after_date_no_res','en','Once you have taken the test your results will be shown here after: %s',NULL,NULL),('assessment','tst_res_tab_msg_res_after_finish_test','en','After finishing the test your results will be shown here.',NULL,NULL),('assessment','tst_res_tab_msg_res_after_taking_test','en','After taking the test your results will be shown here.',NULL,NULL),('assessment','tst_res_tab_msg_res_after_test_passed','en','After passing the test your results will be shown here.',NULL,NULL),('assessment','tst_revert_changes','en','Undo Editing',NULL,NULL),('assessment','tst_rnd_quest_cfg_tab_general','en','Configuration',NULL,NULL),('assessment','tst_rnd_quest_cfg_tab_pool','en','Selected Question Pools',NULL,NULL),('assessment','tst_rnd_quest_set_cfg_general_form','en','Configure Random Set of Questions',NULL,NULL),('assessment','tst_rnd_quest_set_cfg_pool_form','en','Rule for Selection of Questions',NULL,NULL),('assessment','tst_rnd_quest_set_tb_add_pool_btn','en','New Rule for Selection of Questions',NULL,NULL),('assessment','tst_saved_manscoring_by_question_successfully','en','The manual scoring for the question %s for test attempt %s has been saved successfully.',NULL,NULL),('assessment','tst_saved_manscoring_successfully','en','The manual scoring for test attempt %s for %s has been saved successfully.',NULL,NULL),('assessment','tst_save_and_create_new_rule','en','Save and Add New Rule',NULL,NULL),('assessment','tst_save_and_proceed','en','Save and Proceed',NULL,NULL),('assessment','tst_save_comp_points','en','Save Competence Points',NULL,NULL),('assessment','tst_save_manscoring_failed','en','Saving the manual scoring for test attempt %s has failed.',NULL,NULL),('assessment','tst_save_thresholds','en','Save Thresholds',NULL,NULL),('assessment','tst_score_cutting','en','Negative Points',NULL,NULL),('assessment','tst_score_cut_question','en','For Each Questions Negative Points are set to ‘0 Points’',NULL,NULL),('assessment','tst_score_cut_question_desc','en','Participants may score negative results for a question that had negative points for assigned to individual answer options. This setting ensures that per question any negativ result is set to 0 points.',NULL,NULL),('assessment','tst_score_cut_test','en','For the Whole Test a Negative Result is set to ‘0 Points’',NULL,NULL),('assessment','tst_score_cut_test_desc','en','Participants might score negative points in questions. Scored points of all questions are added up. Only if the overall result of the test is negative this overall result will be set to 0 points. With this setting negative points carry a lot of weight.',NULL,NULL),('assessment','tst_score_reporting','en','Score Reporting',NULL,NULL),('assessment','tst_score_reporting_date','en','Score Reporting Date',NULL,NULL),('assessment','tst_search_users','en','Search Participants',NULL,NULL),('assessment','tst_selected_user_data_deleted','en','The test data of the selected user(s) was removed successfully',NULL,NULL),('assessment','tst_select_questionpool','en','Please select a question pool to store the created question',NULL,NULL),('assessment','tst_sequence','en','Sequence',NULL,NULL),('assessment','tst_sequence_fixed','en','The Sequence of Questions is Fixed',NULL,NULL),('assessment','tst_sequence_postpone','en','Questions may be postponed to the end of a test attempt',NULL,NULL),('assessment','tst_sequence_properties','en','Administering the Test: Functionality Available to Participants',NULL,NULL),('assessment','tst_session_settings','en','Session Settings',NULL,NULL),('assessment','tst_settings_conflict_postpone_and_lock','en','\"Unanswered questions will be enqueued\" cannot be used together with \"Lock Answers After Moving to Next Question\".',NULL,NULL),('assessment','tst_settings_conflict_shuffle_and_lock','en','\"Shuffle Questions\" cannot be used together with \"Lock Answers After Moving to Next Question\".',NULL,NULL),('assessment','tst_settings_form_reload_needed','en','The form needed to be reloaded to avoid data loss as the available settings have changed due to the removal of all results of participants.',NULL,NULL),('assessment','tst_settings_header_additional','en','Additional Features',NULL,NULL),('assessment','tst_settings_header_execution','en','Administering the Test: Access',NULL,NULL),('assessment','tst_settings_header_intro','en','Information Before Start of Test',NULL,NULL),('assessment','tst_settings_header_test_run','en','Administering the Test: Test Run',NULL,NULL),('assessment','tst_setting_offer_hints_info','en','Participants request hints to answer a question. With every hint presented the maximum number of points to be earned decreases.',NULL,NULL),('assessment','tst_setting_offer_hints_label','en','Hints',NULL,NULL),('assessment','tst_set_offline_due_to_switched_question_set_type_setting','en','The test has been set to offline, because the test mode setting has been changed. You have to set a new test mode relating question config before the test can be set to online again.',NULL,NULL),('assessment','tst_show_answer_sheet','en','Show Answers',NULL,NULL),('assessment','tst_show_cancel','en','Suspend Test',NULL,NULL),('assessment','tst_show_cancel_description','en','Participants are presented with a button to stop the test run and to continue it later. Caution: Suspending the test does not stop the countdown of the maximum duration of the test.',NULL,NULL),('assessment','tst_show_comp_results','en','Competence Results',NULL,NULL),('assessment','tst_show_results','en','Test Results',NULL,NULL),('assessment','tst_show_side_list','en','Show List of Questions',NULL,NULL),('assessment','tst_show_solution_answers_only','en','Print View of Results (Answers Only)',NULL,NULL),('assessment','tst_show_solution_answers_only_desc','en','If is selected, the ILIAS content you place around a question using the ‘Edit content’ tab page will not be visible in a print-out. If you want to save some paper space, select this option.',NULL,NULL),('assessment','tst_show_solution_compare','en','Show Best Solution in ‘Detailed Results’',NULL,NULL),('assessment','tst_show_solution_compare_desc','en','Participants are presented with an overview comparing their own answers with the best solutions. Please note that this view will be displayed in the \'Detailed Results\' that can be accessed via the \'Show Test Results\'-button on the \'Info\'-tab. It will not be displayed in the printable \'List of Answers\' even though the setting is made here.',NULL,NULL),('assessment','tst_show_solution_details','en','Scored Answers of Participant',NULL,NULL),('assessment','tst_show_solution_details_desc','en','The ‘Table of Detailed Test Results’ will be added by a list of answers.',NULL,NULL),('assessment','tst_show_solution_details_singlepage','en','Scored Answers on single pages',NULL,NULL),('assessment','tst_show_solution_details_singlepage_desc','en','Participants can access each question individually and see if their answers were correct and how many points they scored.',NULL,NULL),('assessment','tst_show_solution_feedback','en','Feedback',NULL,NULL),('assessment','tst_show_solution_feedback_desc','en','Feedback related to the answers provided by the participant is displayed. Please mind  that this option becomes effective only if you have activated ‘Scored Answers of Participant’  and feedback was prepared along with the questions in the first place.',NULL,NULL),('assessment','tst_show_solution_printview','en','Additional ‘List of Answers’ for Printing',NULL,NULL),('assessment','tst_show_solution_printview_desc','en','An overview of all questions with the answers of the respective participant is generated. This list will be offered within the ‘My Results’-tab in a subtab \'Review of Scored Answers\'.',NULL,NULL),('assessment','tst_show_solution_signature','en','Signature Placeholder',NULL,NULL),('assessment','tst_show_solution_signature_desc','en','The prepared printout version will contain a signature placeholder for the participant. Please mind to activate ‘Table of Detailed Test Results’ to use this functionality.',NULL,NULL),('assessment','tst_show_solution_suggested','en','Content for Recapitulation',NULL,NULL),('assessment','tst_show_solution_suggested_desc','en','If content for recapitulation was assigned to the test questions in the first place, this content will be shown in the ‘Table of Detailed Test Results’-table. Participants get an opportunity for remedial learning. For this option to become effective you have to activate ‘Table of Detailed Test Results’ under ‘Access to Test Results’.',NULL,NULL),('assessment','tst_show_summary','en','Show ‘Test Attempt Overview’',NULL,NULL),('assessment','tst_show_summary_description','en','Participants are presented with a button ‘Test Attempt Overview’. On that screen the overall status of all questions will be displayed..',NULL,NULL),('assessment','tst_show_toplist','en','Ranking',NULL,NULL),('assessment','tst_shuffle_questions','en','Shuffle Questions',NULL,NULL),('assessment','tst_shuffle_questions_description','en','Shuffles the sequence of questions for every participant and every test attempt.',NULL,NULL),('assessment','tst_signature','en','Signature',NULL,NULL),('assessment','tst_single_answer_details','en','Show Single Answer',NULL,NULL),('assessment','tst_skill_triggerings_num_req_answers','en','Required Amount of Answers for Competence Triggers',NULL,NULL),('assessment','tst_skill_triggerings_num_req_answers_desc','en','Competences aren\'t triggered before this amount of answered questions contributes to the competence level calculation.',NULL,NULL),('assessment','tst_skill_triggerings_num_req_answers_not_reached_warn','en','At least one of the competences addressed by this test is not triggered by the minimal required amount of questions. No competence records will be written for these competences.<br />The required amount of questions: %s',NULL,NULL),('assessment','tst_skl_level_thresholds_link','en','Configure Competence Thresholds',NULL,NULL),('assessment','tst_skl_level_thresholds_missing','en','There are missing thresholds for the relevant competences!',NULL,NULL),('assessment','tst_skl_res_interpretation_hint_msg','en','Please consider that competence results from a single test has a limited significance. The more information is collected per competence, the merrier valid the significance will be. Should there are single competences without any entry, there is to less information collected.',NULL,NULL),('assessment','tst_skl_sub_tab_thresholds','en','Competence Thresholds',NULL,NULL),('assessment','tst_solution_compare_cfg','en','Configuration for Solution Compare',NULL,NULL),('assessment','tst_sol_comp_expressions','en','Comparison Expressions',NULL,NULL),('assessment','tst_source_question_pool','en','Question Pool',NULL,NULL),('assessment','tst_src_quest_pool_def_list_table','en','Rules for Random Selection of Questions',NULL,NULL),('assessment','tst_starting_time','en','Starting Time',NULL,NULL),('assessment','tst_starting_time_desc','en','Time from which the test can be started. From this moment on, clicking the button \"Start test\" is possible and participants can answer questions.',NULL,NULL),('assessment','tst_start_dyn_test_with_cur_quest_sel','en','Start Test with Current Question Selection',NULL,NULL),('assessment','tst_start_new_test_pass','en','Start New Attempt on Test',NULL,NULL),('assessment','tst_start_test','en','Start the Test',NULL,NULL),('assessment','tst_stat_result_atimeofwork','en','Average Time on Task per Question',NULL,NULL),('assessment','tst_stat_result_firstvisit','en','First Visit',NULL,NULL),('assessment','tst_stat_result_lastvisit','en','Last Visit',NULL,NULL),('assessment','tst_stat_result_mark_median','en','Mark of Median',NULL,NULL),('assessment','tst_stat_result_median','en','Median of Test Result in Points',NULL,NULL),('assessment','tst_stat_result_pworkedthrough','en','Percent of total workload already worked through',NULL,NULL),('assessment','tst_stat_result_qmax','en','Total number of Questions',NULL,NULL),('assessment','tst_stat_result_qworkedthrough','en','Questions already worked through',NULL,NULL),('assessment','tst_stat_result_rank_median','en','Rank of Median',NULL,NULL),('assessment','tst_stat_result_rank_participant','en','Rank of Participant',NULL,NULL),('assessment','tst_stat_result_resultsmarks','en','Test Results in Marks',NULL,NULL),('assessment','tst_stat_result_resultspoints','en','Test Results in Points',NULL,NULL),('assessment','tst_stat_result_timeontask','en','Time on Task',NULL,NULL),('assessment','tst_stat_result_total_participants','en','Total Number of Participants',NULL,NULL),('assessment','tst_stat_result_total_timeontask','en','Total Time On Task (All Test Attempts)',NULL,NULL),('assessment','tst_submit_results','en','Yes, I do confirm the submission.',NULL,NULL),('assessment','tst_tab_competences','en','Competences',NULL,NULL),('assessment','tst_tab_results_objective_oriented','en','Test Results by Learning Objectives',NULL,NULL),('assessment','tst_tab_results_pass_oriented','en','Test Results by Attempts',NULL,NULL),('assessment','tst_tbl_col_answered_questions','en','Answered Questions',NULL,NULL),('assessment','tst_tbl_col_final_mark','en','Mark',NULL,NULL),('assessment','tst_tbl_col_finished_passes','en','Finished Passes',NULL,NULL),('assessment','tst_tbl_col_finished_passes_num_of','en','%s of %s',NULL,NULL),('assessment','tst_tbl_col_last_scored_access','en','Last Scored Access',NULL,NULL),('assessment','tst_tbl_col_passed_status','en','Grading',NULL,NULL),('assessment','tst_tbl_col_pass_finished','en','Pass Finished',NULL,NULL),('assessment','tst_tbl_col_percent_result','en','Percent Solved',NULL,NULL),('assessment','tst_tbl_col_reached_points','en','Reached Points',NULL,NULL),('assessment','tst_tbl_col_scored_pass','en','Scored Pass',NULL,NULL),('assessment','tst_tbl_col_started_passes','en','Started Passes',NULL,NULL),('assessment','tst_tbl_invited_users','en','Manually Selected Participants',NULL,NULL),('assessment','tst_tbl_participants','en','Participants',NULL,NULL),('assessment','tst_tbl_results_grades','en','Results and Grades',NULL,NULL),('assessment','tst_test_result','en','Test Result',NULL,NULL),('assessment','tst_text_count_system','en','Scoring System',NULL,NULL),('assessment','tst_threshold','en','Thresholds (in %)',NULL,NULL),('assessment','tst_time_already_spent','en','You started the test at: %s. Your maximum processing time is %s.',NULL,NULL),('assessment','tst_time_already_spent_left','en','You have %s left.',NULL,NULL),('assessment','tst_time_limit_message','en','You will have <b>%s minutes</b> to answer all questions.',NULL,NULL),('assessment','tst_title_output','en','Show Question Title',NULL,NULL),('assessment','tst_title_output_full','en','Question Titles and Available Points',NULL,NULL),('assessment','tst_title_output_hide_points','en','Only Question Titles',NULL,NULL),('assessment','tst_title_output_info','en','Set which combination of question titles and/or points available should be visible to participants while they are taking the test and within the test attempt overview (see below).',NULL,NULL),('assessment','tst_title_output_no_title','en','Neither Question Titles nor Available Points',NULL,NULL),('assessment','tst_title_output_only_points','en','Only Available Points',NULL,NULL),('assessment','tst_trigger_result_refreshing','en','Results need to be recalculated. This may take a while.',NULL,NULL),('assessment','tst_type','en','Test Type',NULL,NULL),('assessment','tst_unchanged_answer_is_correct','en','The preset answer is correct',NULL,NULL),('assessment','tst_unchanged_order_is_correct','en','The preset order is correct',NULL,NULL),('assessment','tst_user_finished_test','en','User finished test (%s)',NULL,NULL),('assessment','tst_use_previous_answers','en','Use Previous Answers',NULL,NULL),('assessment','tst_use_previous_answers_description','en','Participants will be presented with their answers from previous test attempts. This option has to be activated by individual participants on a modal before starting a test attempt.',NULL,NULL),('assessment','tst_use_previous_answers_user','en','Use my previous answers as default values in future test attempts',NULL,NULL),('assessment','tst_view_competence_assign','en','View Assignment Properties',NULL,NULL),('assessment','tst_virtual_pass_header_lo_initial','en','Initial Test Results for the Learning Objective<br />%s',NULL,NULL),('assessment','tst_virtual_pass_header_lo_qualifying','en','Qualifying Test Results for the Learning Objective<br />%s',NULL,NULL),('assessment','tst_wf_info_answer_adopted_from_prev_pass','en','Your answer from a previous attempt was adopted.',NULL,NULL),('assessment','tst_wf_info_answer_not_adopted','en','There was no answer from previous attempts adopted, so you have to work through this question, because otherwise your learning objective result will be degraded.',NULL,NULL),('assessment','tst_wf_info_optional_question','en','This question relates to an already passed learning objective.',NULL,NULL),('assessment','tst_your_answers','en','These are your answers given to the following questions.',NULL,NULL),('assessment','tst_your_answer_was','en','Your answer was',NULL,NULL),('assessment','unfinished_passes','en','Unfinished Passes',NULL,NULL),('assessment','unit','en','Unit',NULL,NULL),('assessment','units','en','Units',NULL,NULL),('assessment','unit_placeholder','en','** New Unit **',NULL,NULL),('assessment','unlimited','en','unlimited',NULL,NULL),('assessment','unlock','en','Unlock',NULL,NULL),('assessment','un_add_category','en','Add Category',NULL,NULL),('assessment','un_add_unit','en','Add Unit',NULL,NULL),('assessment','un_category_not_exist','en','The requested category does not exist.',NULL,NULL),('assessment','un_cat_deletion_errors_f','en','Cannot delete certain categories:',NULL,NULL),('assessment','un_cat_deletion_errors_f_s','en','Cannot delete category:',NULL,NULL),('assessment','un_cat_deletion_errors_p','en','Could not delete certain categories:',NULL,NULL),('assessment','un_cat_deletion_errors_p_s','en','Could not delete category:',NULL,NULL),('assessment','un_deleted_categories','en','Deletion successfully processed',NULL,NULL),('assessment','un_deleted_categories_s','en','Deletion successfully processed',NULL,NULL),('assessment','un_deleted_units','en','Deletion successfully processed',NULL,NULL),('assessment','un_deleted_units_s','en','Deletion successfully processed',NULL,NULL),('assessment','un_global_units','en','Global Units',NULL,NULL),('assessment','un_local_units','en','Local Units',NULL,NULL),('assessment','un_save_order','en','Save Order',NULL,NULL),('assessment','un_sel_cat_sel_unit','en','Selected Category: %s, Selected Unit: %s',NULL,NULL),('assessment','un_sequence','en','Sequence',NULL,NULL),('assessment','un_show_units','en','Show Units',NULL,NULL),('assessment','un_sure_delete_categories','en','Are you sure you want to delete the selected categories?',NULL,NULL),('assessment','un_sure_delete_categories_s','en','Are you sure you want to delete the selected category?',NULL,NULL),('assessment','un_sure_delete_units','en','Are you sure you want to delete the selected units?',NULL,NULL),('assessment','un_sure_delete_units_s','en','Are you sure you want to delete the selected unit?',NULL,NULL),('assessment','un_units_of_category_x','en','Units of Category: %s',NULL,NULL),('assessment','un_unit_deletion_errors_f','en','Cannot delete certain units:',NULL,NULL),('assessment','un_unit_deletion_errors_f_s','en','Cannot delete unit:',NULL,NULL),('assessment','un_unit_deletion_errors_p','en','Could not delete certain units:',NULL,NULL),('assessment','un_unit_deletion_errors_p_s','en','Could not delete unit:',NULL,NULL),('assessment','updated','en','Updated',NULL,NULL),('assessment','uploaded_material','en','Uploaded Material',NULL,NULL),('assessment','user_has_finished_a_test','en','A participant has finished a test.',NULL,NULL),('assessment','user_ip_outside_range','en','You are not allowed to access the test from this IP.',NULL,NULL),('assessment','user_not_invited','en','You are not supposed to take this test.',NULL,NULL),('assessment','use_previous_solution','en','Use Previous Solution',NULL,NULL),('assessment','use_previous_solution_advice','en','The shown solution for the question is your previously given one. You have to confirm the adoption of the solution, if you like to use it without any change.',NULL,NULL),('assessment','values','en','Values',NULL,NULL),('assessment','value_between_x_and_y','en','The value should be between %s and %s',NULL,NULL),('assessment','variable','en','Variable',NULL,NULL),('assessment','variables','en','Variables',NULL,NULL),('assessment','variable_x','en','Variable %s',NULL,NULL),('assessment','wait_for_next_pass_hint_msg','en','Additional pass is possible on time: %s',NULL,NULL),('assessment','warning_question_not_complete','en','Question is incomplete!',NULL,NULL),('assessment','width','en','Width',NULL,NULL),('assessment','without_solution','en','Participants without solution',NULL,NULL),('assessment','without_solutions_participants','en','Participants without solutions',NULL,NULL),('assessment','with_solution','en','Participants with solution',NULL,NULL),('assessment','with_solutions_participants','en','Participants with solutions',NULL,NULL),('assessment','worked_through','en','Worked Through',NULL,NULL),('assessment','working_time','en','Working Time',NULL,NULL),('assessment','your_results','en','My Results',NULL,NULL),('assessment','you_received_a_of_b_points','en','You received %s of %s possible points',NULL,NULL),('auth','auth_account_code','en','Code',NULL,NULL),('auth','auth_account_code_info','en','To re-activate your account you can use an ILIAS account code.',NULL,NULL),('auth','auth_account_code_title','en','Account Code',NULL,NULL),('auth','auth_account_code_used','en','Your account has been re-activated. Please login once again for security reasons.',NULL,NULL),('auth','auth_account_migration','en','New ILIAS Account',NULL,NULL),('auth','auth_account_migration_keep','en','Migrate Existing User Account',NULL,NULL),('auth','auth_account_migration_name','en','Migration',NULL,NULL),('auth','auth_account_migration_new','en','Create New User Account',NULL,NULL),('auth','auth_activation_code_success','en','Your account has been reactivated. You can now login to ILIAS.',NULL,NULL),('auth','auth_allow_local_info','en','If enabled a local authentication against the ILIAS database is still possible (with a local login/password) for those user accounts, whose authentication mode is set to SAML.',NULL,NULL),('auth','auth_auth_settings','en','Settings',NULL,NULL),('auth','auth_cas_ldap','en','Synchronization using LDAP',NULL,NULL),('auth','auth_cas_ldap_info','en','If enabled, the synchronization of user accounts and role assignments is done using an existing LDAP configuration.',NULL,NULL),('auth','auth_cron_destroy_expired_sessions','en','Deletion of Expired Sessions',NULL,NULL),('auth','auth_cron_destroy_expired_sessions_desc','en','This job deletes expires sessions.',NULL,NULL),('auth','auth_err_expired','en','Your session has been deactivated due to inactivity.',NULL,NULL),('auth','auth_err_invalid_user_account','en','Login failed. Please check that you have entered your username and password correctly. If this issue persists, your account may be inactive or have expired. In this case, please contact your ILIAS platform\'s technical support via the link at the bottom of the screen.',NULL,NULL),('auth','auth_err_ldap_exception','en','Authentication failed due to an internal authentication failure (LDAP).',NULL,NULL),('auth','auth_info_add','en','Choose this option if you have never registered to ILIAS. A new account will be created.',NULL,NULL),('auth','auth_info_migrate','en','If you have already an ILIAS account, enter username and password to migrate your personal data (mail, test results...).',NULL,NULL),('auth','auth_ldap_server_ds','en','LDAP-Server',NULL,NULL),('auth','auth_login_editor','en','Design Login-Page',NULL,NULL),('auth','auth_odic_scope_info','en','In this mask, the standard claims are displayed as a suggestion for a profile data assignment based on the OpenID Connect scopes configured %s. You can adopt this suggestion as an effective profile data assignment by clicking on \"%s\" or make your own adjustments by changing the text fields.',NULL,NULL),('auth','auth_odic_scope_tab_info','en','In this mask you can assign OpenID Connect claims to ILIAS profile data. To do this, enter the scope from which the information should be taken over upon successful authentication in the corresponding text fields for the respective profile date. Activate the corresponding checkbox if the data should also be transferred to an existing ILIAS user account. You can view a list of standard claims %s.',NULL,NULL),('auth','auth_oidc','en','OpenID Connect',NULL,NULL),('auth','auth_oidconnect','en','OpenID Connect',NULL,NULL),('auth','auth_oidc_configured_scopes','en','Pre-fill Scope-based Mapping',NULL,NULL),('auth','auth_oidc_discover_scopes','en','Perform Scope Auto Discovery',NULL,NULL),('auth','auth_oidc_discover_scopes_info','en','The automatic scope discovery was performed. Scopes are added to the field \"Additional Scopes\" in the form below. Please define your relevant scopes and save the form afterwards.',NULL,NULL),('auth','auth_oidc_failed','en','Login via OpenID Connect failed',NULL,NULL),('auth','auth_oidc_here','en','here',NULL,NULL),('auth','auth_oidc_login_element_info','en','Login to ILIAS via OpenID Connect',NULL,NULL),('auth','auth_oidc_mapping_table','en','Mapping ILIAS User Information to OpenID Connect Attributes',NULL,NULL),('auth','auth_oidc_profile','en','User Profile Mapping',NULL,NULL),('auth','auth_oidc_roles','en','Role Assignment',NULL,NULL),('auth','auth_oidc_role_info','en','OpenID Connect Attribute::Value (e.g: ‘roles::employee‘).',NULL,NULL),('auth','auth_oidc_role_mapping_table','en','Mapping ILIAS Roles to OpenID Connect Attributes.',NULL,NULL),('auth','auth_oidc_saved_values','en','Effective Attribute Mapping',NULL,NULL),('auth','auth_oidc_scopes','en','Scopes',NULL,NULL),('auth','auth_oidc_settings','en','Server Settings',NULL,NULL),('auth','auth_oidc_settings_activation','en','Enable OpenID Connect',NULL,NULL),('auth','auth_oidc_settings_additional_scopes','en','Additional Scopes',NULL,NULL),('auth','auth_oidc_settings_additional_scopes_info','en','Standard scopes: address, email, phone, profile',NULL,NULL),('auth','auth_oidc_settings_client_id','en','Client ID',NULL,NULL),('auth','auth_oidc_settings_custom_session_duration','en','Session Duration',NULL,NULL),('auth','auth_oidc_settings_custom_session_duration_option','en','Duration of Own Session',NULL,NULL),('auth','auth_oidc_settings_custom_session_duration_type','en','Session Duration Settings',NULL,NULL),('auth','auth_oidc_settings_default_role','en','Role Assignment',NULL,NULL),('auth','auth_oidc_settings_default_role_info','en','Please select a global role for the ILIAS user accounts that will be created for users who have authenticated themselves using OpenID Connect.',NULL,NULL),('auth','auth_oidc_settings_default_scopes','en','Default Scope',NULL,NULL),('auth','auth_oidc_settings_discovery_error','en','Retrieving the Discovery URL failed with: %s',NULL,NULL),('auth','auth_oidc_settings_discovery_url','en','Discovery URL of the provider',NULL,NULL),('auth','auth_oidc_settings_img','en','Image',NULL,NULL),('auth','auth_oidc_settings_img_file_info','en','Upload an image that you would like to have shown on the login page. The image will link automatically to the OpenID Connect login script.',NULL,NULL),('auth','auth_oidc_settings_invalid_scopes','en','The following values are not valid scopes: %s',NULL,NULL),('auth','auth_oidc_settings_le','en','Visual Presentation of Login Page',NULL,NULL),('auth','auth_oidc_settings_login_options','en','Login Options',NULL,NULL),('auth','auth_oidc_settings_login_option_default','en','Login Not Required',NULL,NULL),('auth','auth_oidc_settings_login_option_default_info','en','Users are not required to log in via the OpenID Connect server if a valid session is in progress.',NULL,NULL),('auth','auth_oidc_settings_login_option_enforce','en','Login Required',NULL,NULL),('auth','auth_oidc_settings_login_option_enforce_info','en','Users are always required to log in via the OpenID Connect Server – even if there is already a valid session in progress.',NULL,NULL),('auth','auth_oidc_settings_logout_scope','en','Logout Options',NULL,NULL),('auth','auth_oidc_settings_logout_scope_global','en','Log Out Globally',NULL,NULL),('auth','auth_oidc_settings_logout_scope_global_info','en','When a users logs out, they end both their OpenID Connect session and their ILIAS session.',NULL,NULL),('auth','auth_oidc_settings_logout_scope_local','en','Log Out of ILIAS ONLY',NULL,NULL),('auth','auth_oidc_settings_logout_scope_local_info','en','When a user logs out, they only end their session in  ILIAS, not their OpenID Connect session.',NULL,NULL),('auth','auth_oidc_settings_provider','en','Provider URL',NULL,NULL),('auth','auth_oidc_settings_secret','en','Client Key',NULL,NULL),('auth','auth_oidc_settings_section_user_sync','en','User Synchronisation Settings',NULL,NULL),('auth','auth_oidc_settings_session_duration','en','Duration',NULL,NULL),('auth','auth_oidc_settings_title','en','Configure OpenID Connect Authentication',NULL,NULL),('auth','auth_oidc_settings_txt','en','Text',NULL,NULL),('auth','auth_oidc_settings_txt_val_info','en','Enter a text to be displayed on the login page. The text will link automatically to the OpenID Connect login script.',NULL,NULL),('auth','auth_oidc_settings_user_attr','en','Attribute name of user accounts',NULL,NULL),('auth','auth_oidc_settings_user_sync','en','Synchronise Automatically',NULL,NULL),('auth','auth_oidc_settings_user_sync_info','en','Users who do not have an ILIAS account, but have successfully authenticated themselves using OpenID Connect, will have an ILIAS account created for them automatically.',NULL,NULL),('auth','auth_oidc_settings_validate_scopes','en','Validate Scopes upon saving',NULL,NULL),('auth','auth_oidc_settings_validate_scope_custom','en','Use custom OpenID Connect Discovery url',NULL,NULL),('auth','auth_oidc_settings_validate_scope_default','en','Use [PROVIDER_URL]/.well-known/openid-configuration',NULL,NULL),('auth','auth_oidc_settings_validate_scope_none','en','Do not validate Scopes on saving',NULL,NULL),('auth','auth_oidc_update_field_info','en','Update Automatically',NULL,NULL),('auth','auth_oidc_update_role_info','en','Only Synchronise Automatically the First Time a User Logs In.',NULL,NULL),('auth','auth_page_type_auth','en','Login Page',NULL,NULL),('auth','auth_required_password','en','Please enter a password.',NULL,NULL),('auth','auth_required_username','en','Please enter a username.',NULL,NULL),('auth','auth_saml_add_idp_btn','en','Add new Identity Provider',NULL,NULL),('auth','auth_saml_add_idp_md_error','en','The given value was not a valid XML document. Ensure the XML contains a valid Identity Provider.',NULL,NULL),('auth','auth_saml_add_idp_md_info','en','Please enter the XML formatted metadata for the Identity Provider.',NULL,NULL),('auth','auth_saml_add_idp_md_label','en','Identity Provider SAML Metadata',NULL,NULL),('auth','auth_saml_configure','en','Configure SAML Authentication',NULL,NULL),('auth','auth_saml_configure_idp','en','Configure SAML IDP: %s',NULL,NULL),('auth','auth_saml_deleted_idp','en','The Identity Provider has been deleted.',NULL,NULL),('auth','auth_saml_enable','en','Enable SAML Support',NULL,NULL),('auth','auth_saml_err_sqlite_driver','en','The SAML authentication requires the SQLite driver for PHP. Please install the SQLite package and try again.',NULL,NULL),('auth','auth_saml_idp','en','IDP',NULL,NULL),('auth','auth_saml_idps','en','SAML IDP List',NULL,NULL),('auth','auth_saml_idps_info','en','Please check and edit the SimpleSAMLphp configuration in \'<strong>%s</strong>\' and \'<strong>%s</strong>\' (external data directory). Don\'t forget to add the paths to your private key and certificate in the authsources.php file. Please read the manual for further explanations %s.<br />Federation Metadata URL: %s',NULL,NULL),('auth','auth_saml_idp_selection_table_desc','en','Bitte wählen Sie den Identity Provider mit dem Sie sich anmelden möchten.',NULL,NULL),('auth','auth_saml_idp_selection_table_title','en','Identity Provider Selection',NULL,NULL),('auth','auth_saml_idp_settings','en','IDP Settings',NULL,NULL),('auth','auth_saml_login_form','en','Button on Login Page',NULL,NULL),('auth','auth_saml_login_form_info','en','If activated and there is at least one active IDP, a button appears on the login page. A click on this button initiates a SAML request.',NULL,NULL),('auth','auth_saml_migration','en','Account Migration:',NULL,NULL),('auth','auth_saml_migration_info','en','Activate this option to give new users the possibility to migrate their existing ILIAS accounts to SAML authentication.',NULL,NULL),('auth','auth_saml_role_select','en','Role:',NULL,NULL),('auth','auth_saml_sure_delete_idp','en','Are you sure you want to delete the selected Identity Provider? This cannot be undone. The affected user accounts will be switched to the default authentication.',NULL,NULL),('auth','auth_saml_sync','en','User Synchronization',NULL,NULL),('auth','auth_saml_sync_info','en','If enabled new user accounts will be created automatically after successful authentication.  Furthermore existing user accounts will be modified according to the defined user profile mapping rules.',NULL,NULL),('auth','auth_saml_uid_claim','en','Unique Attribute for User Account Matching',NULL,NULL),('auth','auth_saml_uid_claim_info','en','Define the attribute ILIAS uses to detect whether or not an incoming authentication request matches an existing ILIAS user account.',NULL,NULL),('auth','auth_saml_unknow_idp','en','The passed Identity Provider does not exist.',NULL,NULL),('auth','auth_saml_update_field_info','en','Update automatically',NULL,NULL),('auth','auth_saml_username_claim','en','Attribute for Username',NULL,NULL),('auth','auth_saml_username_claim_info','en','Define the attribute ILIAS uses to generate the username which will be visible in ILIAS.',NULL,NULL),('auth','auth_saml_user_mapping','en','User Profile Mapping',NULL,NULL),('auth','auth_sync','en','User Synchronisation',NULL,NULL),('auth','auth_sync_cas','en','Automatic generation of user accounts',NULL,NULL),('auth','auth_sync_cas_info','en','Automatically create ILIAS user accounts for users who have successfully authenticated themselves using CAS, but do not yet have an ILIAS account.',NULL,NULL),('auth','destination_after_logout','en','Destination After Logout',NULL,NULL),('auth','destination_external_ressource','en','Show External Ressource',NULL,NULL),('auth','destination_external_ressource_url','en','External URL',NULL,NULL),('auth','destination_internal_ressource','en','Show Internal Ressource',NULL,NULL),('auth','destination_internal_ressource_ref_id','en','Internal Reference Id',NULL,NULL),('auth','destination_login_screen','en','Show Login Screen',NULL,NULL),('auth','destination_login_screen_info','en','Make sure that, for example, an SSO is not addressed that leads to immediate login.',NULL,NULL),('auth','destination_logout_screen','en','Show Logout Screen',NULL,NULL),('auth','err_auth_ldap_failed','en','Authentication failed. Please contact your ILIAS administrator.',NULL,NULL),('auth','err_auth_saml_failed','en','Authentication failed. Please contact your system administrator.',NULL,NULL),('auth','err_auth_saml_no_ilias_user','en','Authentication failed. Please contact your system administrator.',NULL,NULL),('auth','language_does_not_exist','en','The selected language does not exist.',NULL,NULL),('auth','login_page','en','Language of Login-Page',NULL,NULL),('auth','login_pages','en','Login-Pages',NULL,NULL),('auth','logout_behaviour','en','Logout Behaviour',NULL,NULL),('auth','logout_behaviour_invalid_ref_id','en','Please make sure the internal resource id exists and is not in trash',NULL,NULL),('auth','logout_behaviour_invalid_url','en','The external ressource given is not a valid URL.',NULL,NULL),('auth','logout_behaviour_ref_id_no_access','en','Please make sure the \"Anonymous\" user has access to the defined ressource.',NULL,NULL),('auth','logout_behaviour_ref_id_valid_status_changed','en','The configured internal resource is no longer valid. If the resource has been deleted or access for the \"Anonymous\" user has been restricted, please configure a new valid internal resource. Without a valid configuration, the user will be redirected to the logout screen by default.',NULL,NULL),('auth','logout_behaviour_settings','en','Logout Behaviour Settings',NULL,NULL),('auth','logout_editor','en','Design Logout-Page',NULL,NULL),('auth','logout_page','en','Language of Logout-Page',NULL,NULL),('auth','logout_pages','en','Logout-Pages',NULL,NULL),('auth','lti_consumer_inactive','en','LTI tool consumer is disabled.',NULL,NULL),('auth','page_design_activate','en','Activate Page Design',NULL,NULL),('auth','page_design_deactivate','en','Deactivate Page Design',NULL,NULL),('auth','saml_tab_head_idp','en','IDP',NULL,NULL),('awrn','awareness_now_online','en','Online Now',NULL,NULL),('awrn','awareness_settings','en','Settings',NULL,NULL),('awrn','awrn_caching_period','en','Caching Period',NULL,NULL),('awrn','awrn_caching_period_info','en','Time that is waited before the number of users in the top bar is updated and new online users are determined.',NULL,NULL),('awrn','awrn_enable','en','Enable ‘Who is online?’-Tool',NULL,NULL),('awrn','awrn_filter','en','User Filter',NULL,NULL),('awrn','awrn_hide_from_awareness','en','Hide Me From ‘Who is online?’-Tool',NULL,NULL),('awrn','awrn_hide_from_awareness_info','en','The ‘Who is Online?’ tool can be found in the header bar and lists selected users (e.g. contacts or members of your courses).',NULL,NULL),('awrn','awrn_inactive','en','Not Listed',NULL,NULL),('awrn','awrn_incl_offline','en','Online and Offline',NULL,NULL),('awrn','awrn_max_inactivity','en','Maximum Inactivity Period',NULL,NULL),('awrn','awrn_max_inactivity_info','en','After this period users are considered being offline. If nothing is set, the session time will be used.',NULL,NULL),('awrn','awrn_max_nr_entries','en','Max. Number of Items',NULL,NULL),('awrn','awrn_max_nr_entries_info','en','Maximum number of items in the ‘Who is online?’ list. This setting has only minimal performance influence when displaying the tool in the top bar.',NULL,NULL),('awrn','awrn_minutes','en','min',NULL,NULL),('awrn','awrn_online','en','Online',NULL,NULL),('awrn','awrn_online_only','en','Online Only',NULL,NULL),('awrn','awrn_seconds','en','sec',NULL,NULL),('awrn','awrn_user_show','en','Show Your Account in \"Who-Is-Online?\"',NULL,NULL),('awrn','awrn_use_osd','en','Popup Online Users',NULL,NULL),('awrn','awrn_use_osd_info','en','Display a popup to indicate new online users in the ‘Who is online?’ list.',NULL,NULL),('awrn','user_awrn_default','en','Default',NULL,NULL),('awrn','user_awrn_hide','en','Hide my status',NULL,NULL),('awrn','user_awrn_show','en','Show my status',NULL,NULL),('background_tasks','abort','en','Abort',NULL,NULL),('background_tasks','background_tasks','en','Background Tasks',NULL,NULL),('background_tasks','background_tasks_running','en','Background Tasks',NULL,NULL),('background_tasks','completed','en','Completed',NULL,NULL),('background_tasks','proceed_job','en','Proceed',NULL,NULL),('background_tasks','scheduled','en','Scheduled',NULL,NULL),('background_tasks','task_might_be_failed','en','This Task has not responded for a while, you can quit it if needed.',NULL,NULL),('background_tasks','ui_msg_files_violate_maxsize','en','The total download size violates the global limit. The download will be aborted.',NULL,NULL),('background_tasks','ui_msg_no_files_found','en','No files have been found. The download will be aborted.',NULL,NULL),('background_tasks','ui_msg_num_files','en','%s file(-s) were detected for download, do you want to continue?',NULL,NULL),('background_tasks','ui_msg_sum_file_sizes','en','The total download size before creating the zip-folder is %s. Do you want to continue?',NULL,NULL),('background_tasks','waiting','en','Waiting',NULL,NULL),('badge','','en','Are you sure you want to delete the following badges and all their respective assignments?',NULL,NULL),('badge','awarded_by','en','Awarded By',NULL,NULL),('badge','badge_activity_badges','en','Activity Badges',NULL,NULL),('badge','badge_add_template','en','Add Template',NULL,NULL),('badge','badge_add_to_profile','en','Add to Profile',NULL,NULL),('badge','badge_assignment_deletion_confirmation','en','Are you sure you want to revoke the badge ‘%s’ awarded to the following user(s)?',NULL,NULL),('badge','badge_award_badge','en','Award Badge',NULL,NULL),('badge','badge_award_revoke','en','Award/Revoke Badge',NULL,NULL),('badge','badge_badge','en','Badge',NULL,NULL),('badge','badge_course_lp','en','Course LP',NULL,NULL),('badge','badge_course_lp_invalid','en','The following objects have a learning progress mode which is not supported: %s.',NULL,NULL),('badge','badge_create','en','Create Badge',NULL,NULL),('badge','badge_create_image_processing_failed','en','The badge could not be created, an error occurred while processing the image.',NULL,NULL),('badge','badge_criteria','en','Criteria',NULL,NULL),('badge','badge_crs_merit','en','Merit',NULL,NULL),('badge','badge_deletion','en','Badge successfully deleted.',NULL,NULL),('badge','badge_deletion_confirmation','en','Are you sure you want to delete the following badges? This will also delete any of these badges that have been earned by or awarded to users.',NULL,NULL),('badge','badge_image_from_template','en','Use Template',NULL,NULL),('badge','badge_image_from_upload','en','Upload Image',NULL,NULL),('badge','badge_image_templates','en','Image Templates',NULL,NULL),('badge','badge_image_template_form','en','Image Template',NULL,NULL),('badge','badge_in_profile','en','In Profile',NULL,NULL),('badge','badge_issued_on','en','Issued On',NULL,NULL),('badge','badge_lhist_badge_completed','en','Awarded the badge $3$.',NULL,NULL),('badge','badge_lhist_badge_completed_in','en','Awarded the badge $3$ in $1$.',NULL,NULL),('badge','badge_manual','en','Manual Awarding',NULL,NULL),('badge','badge_new_badges','en','You have %1 new badge(s).',NULL,NULL),('badge','badge_notification_badges','en','New Badges',NULL,NULL),('badge','badge_notification_badges_goto','en','To your badges',NULL,NULL),('badge','badge_notification_body','en','You have just received one or more new badges.',NULL,NULL),('badge','badge_notification_osd','en','You have received one or more new badges: [BADGE_LIST]',NULL,NULL),('badge','badge_notification_parent_goto','en','To the repository',NULL,NULL),('badge','badge_notification_reason','en','If you go to the ‘Badges’ section of your ‘Achievements’ in your ILIAS installation (see link above), you will be able to add any new or existing badges to your profile.',NULL,NULL),('badge','badge_notification_subject','en','New Badge(s)',NULL,NULL),('badge','badge_no_valid_types_for_obj','en','There are currently no active badge types and therefore you cannot create new badges. Please contact your installation’s technical support.',NULL,NULL),('badge','badge_object_badges','en','Object Badges',NULL,NULL),('badge','badge_personal_badges','en','My Badges',NULL,NULL),('badge','badge_profile_less','en','Show Fewer',NULL,NULL),('badge','badge_profile_more','en','Show All',NULL,NULL),('badge','badge_remove_badge','en','Revoke Badge',NULL,NULL),('badge','badge_remove_from_profile','en','Remove From Profile',NULL,NULL),('badge','badge_select_one','en','You have to select at least one badge',NULL,NULL),('badge','badge_service_activate','en','Activate Service',NULL,NULL),('badge','badge_service_activate_info','en','Allow badges to be earned and awarded on this installation.',NULL,NULL),('badge','badge_settings','en','Badge Settings',NULL,NULL),('badge','badge_sort_active_badges_first','en','Active Badges First',NULL,NULL),('badge','badge_sort_active_badges_last','en','Active Badges Last',NULL,NULL),('badge','badge_sort_activity_badges_first','en','Activity Badges First',NULL,NULL),('badge','badge_sort_activity_badges_last','en','Activity Badges Last',NULL,NULL),('badge','badge_sort_added_to_profile_last','en','Added To Profile First',NULL,NULL),('badge','badge_sort_excluded_from_profile_first','en','Excluded From Profile First',NULL,NULL),('badge','badge_sort_manual_awarding_first','en','Badges mit manueller Vergabe zuerst',NULL,NULL),('badge','badge_sort_manual_awarding_last','en','Badges mit manueller Vergabe zuletzt',NULL,NULL),('badge','badge_subtype_auto','en','Automatic',NULL,NULL),('badge','badge_subtype_manual','en','Manual',NULL,NULL),('badge','badge_template_deletion_confirmation','en','Are you sure you want to delete the following image templates?',NULL,NULL),('badge','badge_template_types','en','Badge Type Allocation',NULL,NULL),('badge','badge_template_types_all','en','All',NULL,NULL),('badge','badge_template_types_specific','en','Specific',NULL,NULL),('badge','badge_types','en','Types',NULL,NULL),('badge','badge_update_image_processing_failed','en','It was not possible to update the badge. An error occurred while processing the image.',NULL,NULL),('badge','badge_uploaded_image_file_not_found','en','No uploaded image for the badge could be found.',NULL,NULL),('badge','badge_user_profile','en','User Profile',NULL,NULL),('badge','badge_valid','en','Valid Until',NULL,NULL),('badge','criteria','en','Criteria',NULL,NULL),('badge','endless','en','Forever',NULL,NULL),('badge','issued_on','en','Issued On',NULL,NULL),('badge','position_updated','en','The badges displayed in your profile have been updated.',NULL,NULL),('badge','sort_by_date_asc','en','Date Ascending',NULL,NULL),('badge','sort_by_date_desc','en','Date Descending',NULL,NULL),('badge','sort_by_title_asc','en','Title Ascending',NULL,NULL),('badge','sort_by_title_desc','en','Title Descending',NULL,NULL),('badge','table_view','en','Table View',NULL,NULL),('badge','tile_view','en','Tile View',NULL,NULL),('badge','valid_until','en','Valid Until',NULL,NULL),('bgtask','bgtask_blocked','en','Concurrent download',NULL,NULL),('bgtask','bgtask_blocked_cancel_new','en','Cancel new download',NULL,NULL),('bgtask','bgtask_blocked_cancel_old','en','Cancel existing download',NULL,NULL),('bgtask','bgtask_blocked_info','en','There is already a download processed for you.',NULL,NULL),('bgtask','bgtask_cron_gc_desc','en','Deletes obsolete files which were created by background tasks.',NULL,NULL),('bgtask','bgtask_cron_gc_title','en','Background Task Garbage Collection',NULL,NULL),('bgtask','bgtask_download_long','en','The processing of the download with %1$s files (%2$s) might take a while.',NULL,NULL),('bgtask','bgtask_download_too_large','en','The download surpasses the size limit of %s.',NULL,NULL),('bgtask','bgtask_empty_folder','en','The current selection does not include any downloadable content.',NULL,NULL),('bgtask','bgtask_failure','en','Error',NULL,NULL),('bgtask','bgtask_processing','en','Creating download',NULL,NULL),('bgtask','bgtask_setting','en','\'Background Download\' enabled',NULL,NULL),('bgtask','bgtask_setting_info','en','The creation of the ZIP archive is done asynchronously and can be cancelled anytime.',NULL,NULL),('bgtask','bgtask_setting_limit','en','Global Limit',NULL,NULL),('bgtask','bgtask_setting_limit_info','en','A download is only possible if the sum of the file sizes is below this value in MB.',NULL,NULL),('bgtask','bgtask_setting_threshold_count','en','Minimum Number',NULL,NULL),('bgtask','bgtask_setting_threshold_count_info','en','If the number of files exceeds this value the download will be asynchronously.',NULL,NULL),('bgtask','bgtask_setting_threshold_size','en','Minimum Size',NULL,NULL),('bgtask','bgtask_setting_threshold_size_info','en','If the file sizes exceed this value the download will be asynchronously.',NULL,NULL),('bibl','add_filter','en','Add Filter',NULL,NULL),('bibl','bibliography_file','en','Bibliography File',NULL,NULL),('bibl','bibl_copy','en','Copy Bibliography',NULL,NULL),('bibl','bibl_edit','en','Edit Bibliography',NULL,NULL),('bibl','bibl_filter','en','Filter',NULL,NULL),('bibl','bibl_import','en','Import Bibliography',NULL,NULL),('bibl','bibl_library_img','en','Image-URL',NULL,NULL),('bibl','bibl_library_name','en','Name',NULL,NULL),('bibl','bibl_library_show_in_list','en','Show as link in the list',NULL,NULL),('bibl','bibl_library_url','en','Base-URL',NULL,NULL),('bibl','bibl_link_online','en','Lookup inventory',NULL,NULL),('bibl','bibl_msg_translations_deleted','en','Translations were deleted',NULL,NULL),('bibl','bibl_msg_translations_saved','en','Translations were saved',NULL,NULL),('bibl','bibl_new','en','New Bibliography',NULL,NULL),('bibl','bibl_settings_edit','en','Edit Library',NULL,NULL),('bibl','bibl_settings_libraries','en','Libraries',NULL,NULL),('bibl','bibl_settings_new','en','Add Library',NULL,NULL),('bibl','bibl_translation_desc','en','Description',NULL,NULL),('bibl','bibl_translation_lang','en','Language',NULL,NULL),('bibl','bibl_translation_trans','en','Translation',NULL,NULL),('bibl','bibtex','en','Bibtex',NULL,NULL),('bibl','bib_default_abstract','en','Abstract',NULL,NULL),('bibl','bib_default_address','en','Address',NULL,NULL),('bibl','bib_default_author','en','Author',NULL,NULL),('bibl','bib_default_cite','en','Bib Cite',NULL,NULL),('bibl','bib_default_edition','en','Edition',NULL,NULL),('bibl','bib_default_howpublished','en','Published as',NULL,NULL),('bibl','bib_default_isbn','en','ISSN/ISBN',NULL,NULL),('bibl','bib_default_journal','en','Journal',NULL,NULL),('bibl','bib_default_keywords','en','Keywords',NULL,NULL),('bibl','bib_default_month','en','Month',NULL,NULL),('bibl','bib_default_note','en','Note',NULL,NULL),('bibl','bib_default_number','en','Number',NULL,NULL),('bibl','bib_default_organization','en','Organizaton',NULL,NULL),('bibl','bib_default_pages','en','Pages',NULL,NULL),('bibl','bib_default_publisher','en','Publisher',NULL,NULL),('bibl','bib_default_series','en','Series',NULL,NULL),('bibl','bib_default_title','en','Title',NULL,NULL),('bibl','bib_default_type','en','Type',NULL,NULL),('bibl','bib_default_url','en','URL',NULL,NULL),('bibl','bib_default_volume','en','Volume',NULL,NULL),('bibl','bib_default_year','en','Year',NULL,NULL),('bibl','changes_saved','en','Changes were saved.',NULL,NULL),('bibl','custom','en','Custom',NULL,NULL),('bibl','detailed_information','en','Detailed Information',NULL,NULL),('bibl','detail_view','en','Detail View',NULL,NULL),('bibl','download_original_file','en','Download Original File',NULL,NULL),('bibl','field','en','Field',NULL,NULL),('bibl','fields','en','Fields',NULL,NULL),('bibl','filter_deleted','en','The Filter was deleted.',NULL,NULL),('bibl','filter_field_info','en','Please choose a field for which you want to add a filter.',NULL,NULL),('bibl','filter_form_title','en','Add new filter',NULL,NULL),('bibl','filter_type','en','Filter Type',NULL,NULL),('bibl','filter_type_1','en','Textinput',NULL,NULL),('bibl','filter_type_2','en','Selectinput',NULL,NULL),('bibl','filter_type_3','en','Multi-Selectinput',NULL,NULL),('bibl','filter_type_info','en','Please choose a filter type for the field.',NULL,NULL),('bibl','identifier','en','Identifier',NULL,NULL),('bibl','msg_confirm_delete_filter','en','Do you like to delete the following filter?',NULL,NULL),('bibl','msg_filter_info','en','Create a filter here that can be used in the \"Contents\" tab to limit the display of entries.',NULL,NULL),('bibl','news_title_created','en','New bibliography list added',NULL,NULL),('bibl','news_title_updated','en','Bibliography list updated',NULL,NULL),('bibl','not_yet_migrated','en','This Object has not et been migrated. Please contact the administrators of the platform.',NULL,NULL),('bibl','obj_bibl_duplicate','en','Duplicate Bibliography',NULL,NULL),('bibl','order','en','Order',NULL,NULL),('bibl','override_entries','en','Override Entries',NULL,NULL),('bibl','replace_bibliography_file','en','Replace Bibliography File',NULL,NULL),('bibl','replace_bibliography_file_info','en','The current bibliography file will be replaced by the new file. All existing entries from the current file will be deleted.',NULL,NULL),('bibl','ris','en','Ris',NULL,NULL),('bibl','ris_default_a2','en','Location in Archives',NULL,NULL),('bibl','ris_default_au','en','Author',NULL,NULL),('bibl','ris_default_cy','en','Place Published',NULL,NULL),('bibl','ris_default_ep','en','Ending Page Number',NULL,NULL),('bibl','ris_default_id','en','Reference ID',NULL,NULL),('bibl','ris_default_ja','en','Periodical in which article was published',NULL,NULL),('bibl','ris_default_kw','en','Keywords',NULL,NULL),('bibl','ris_default_l3','en','Related records',NULL,NULL),('bibl','ris_default_m1','en','Number',NULL,NULL),('bibl','ris_default_m3','en','Misc. 3',NULL,NULL),('bibl','ris_default_n1','en','Notes',NULL,NULL),('bibl','ris_default_n2','en','Abstract',NULL,NULL),('bibl','ris_default_pb','en','Publisher',NULL,NULL),('bibl','ris_default_py','en','Publication year',NULL,NULL),('bibl','ris_default_sn','en','ISSN/ISBN/ASIN',NULL,NULL),('bibl','ris_default_t1','en','Primary Title',NULL,NULL),('bibl','ris_default_t2','en','Secondary Title',NULL,NULL),('bibl','ris_default_t3','en','Tertiary Title',NULL,NULL),('bibl','ris_default_ti','en','Book title',NULL,NULL),('bibl','ris_default_ty','en','Type',NULL,NULL),('bibl','ris_default_u2','en','User Defined',NULL,NULL),('bibl','ris_default_ur','en','URL',NULL,NULL),('bibl','ris_default_vl','en','Volume',NULL,NULL),('bibl','ris_default_y1','en','Year',NULL,NULL),('bibl','sorting_1','en','By Title (Ascending)',NULL,NULL),('bibl','sorting_2','en','By Title (Descending)',NULL,NULL),('bibl','sorting_3','en','By Author (Ascending)',NULL,NULL),('bibl','sorting_4','en','By Author (Descending)',NULL,NULL),('bibl','sorting_5','en','By Year (Ascending)',NULL,NULL),('bibl','sorting_6','en','By Year (Descending)',NULL,NULL),('bibl','standard','en','Standard',NULL,NULL),('bibl','translate','en','Translate',NULL,NULL),('bibl','Type','en','Type',NULL,NULL),('bkm','bkm_fold_created','en','Bookmark folder has been created.',NULL,NULL),('blog','blog_abstract_image','en','Add Image to Abstract',NULL,NULL),('blog','blog_abstract_image_height','en','Height',NULL,NULL),('blog','blog_abstract_image_info','en','The first image used in the post will be resized so that its longest edge matches the size entered here. This image will be displayed along with the abstract of the post’s text content. Images that are smaller than the minimum size will not be used.',NULL,NULL),('blog','blog_abstract_image_pixels','en','Px',NULL,NULL),('blog','blog_abstract_image_width','en','Width',NULL,NULL),('blog','blog_abstract_shorten','en','Shorten Abstract',NULL,NULL),('blog','blog_abstract_shorten_characters','en','Characters',NULL,NULL),('blog','blog_abstract_shorten_length','en','Maximum Length',NULL,NULL),('blog','blog_add','en','Create Blog',NULL,NULL),('blog','blog_add_contributor','en','Add Contributor',NULL,NULL),('blog','blog_add_posting','en','Add Post',NULL,NULL),('blog','blog_admin_inactive_info','en','You can activate the blog feature by going to ‘Administration » Personal Workspace » Personal Resources’.',NULL,NULL),('blog','blog_admin_toggle_info','en','You can deactivate the blog feature completely by going to ‘Administration » Personal Workspace » Personal Resources’.',NULL,NULL),('blog','blog_approve','en','Approve Post',NULL,NULL),('blog','blog_author','en','Written by',NULL,NULL),('blog','blog_authors','en','Authors',NULL,NULL),('blog','blog_back_to_blog_owner','en','Edit Blog',NULL,NULL),('blog','blog_change_notification_body_approve','en','The following blog post needs approval.',NULL,NULL),('blog','blog_change_notification_body_comment','en','The following blog post has received a comment.',NULL,NULL),('blog','blog_change_notification_body_new','en','A new post has been added to the following blog.',NULL,NULL),('blog','blog_change_notification_body_update','en','The following blog post has been updated.',NULL,NULL),('blog','blog_change_notification_link','en','Link to Blog Post',NULL,NULL),('blog','blog_change_notification_reason','en','You have received this e-mail because you have activated notifications for the blog mentioned above.',NULL,NULL),('blog','blog_change_notification_subject','en','The blog \"%s\" has been updated.',NULL,NULL),('blog','blog_comments','en','Comments',NULL,NULL),('blog','blog_confirm_delete_contributors','en','Are you sure you want to remove the following contributors?',NULL,NULL),('blog','blog_contribute_other_roles','en','In addition to the blog contributors listed below, users with the role(s) %s can also add posts to this blog. They are not listed in the table below, because their respective permission(s) are derived from the object (e.g. course or group) in which this blog is contained.',NULL,NULL),('blog','blog_contributors','en','Blog Contributors',NULL,NULL),('blog','blog_copy','en','Copy Blog',NULL,NULL),('blog','blog_download_submission','en','Download Submission',NULL,NULL),('blog','blog_draft','en','Draft',NULL,NULL),('blog','blog_draft_info','en','The post has been unpublished and is now only visible to contributors.',NULL,NULL),('blog','blog_draft_info_contributors','en','This draft post is currently only visible to the contributors of this blog.',NULL,NULL),('blog','blog_draft_text','en','Unpublished Post',NULL,NULL),('blog','blog_edit','en','Edit Blog',NULL,NULL),('blog','blog_edit_date','en','Edit Date',NULL,NULL),('blog','blog_edit_date_info','en','Publication status does not depend on this date.',NULL,NULL),('blog','blog_edit_keywords','en','Edit Keywords',NULL,NULL),('blog','blog_edit_posting','en','Edit Post',NULL,NULL),('blog','blog_enable_approval','en','Approve Posts',NULL,NULL),('blog','blog_enable_approval_info','en','Posts will only be visible to other users after having being approved by a user with the ‘Edit Settings’ permission for this blog.',NULL,NULL),('blog','blog_enable_keywords','en','Keywords',NULL,NULL),('blog','blog_enable_keywords_info','en','Keywords can be added to posts. These keywords will then be displayed in a ‘Keywords’ block in the sidebar, where they can be used to filter the blog posts accordingly.',NULL,NULL),('blog','blog_enable_nav_authors','en','Authors',NULL,NULL),('blog','blog_enable_nav_authors_info','en','Display a list of all blog authors in an ‘Authors’ side block. Clicking on an author’s username will show all posts by this author in the main section of the blog.',NULL,NULL),('blog','blog_enable_notes','en','Public Comments',NULL,NULL),('blog','blog_enable_rss','en','Activate RSS',NULL,NULL),('blog','blog_enable_rss_info','en','The RSS feed is public and independent of blog sharing or user permissions.',NULL,NULL),('blog','blog_est_reading_time','en','Estimated Reading Time',NULL,NULL),('blog','blog_est_reading_time_info','en','Add an automatically generated estimated reading time to blog posts in the repository.',NULL,NULL),('blog','blog_exercise_info','en','This blog is part of the assignment \"%s\" of the exercise \"%s\".',NULL,NULL),('blog','blog_exercise_submitted_info','en','Your last submission was on %s. Please check the export file: %s',NULL,NULL),('blog','blog_finalized','en','Your blog has been submitted.',NULL,NULL),('blog','blog_finalize_blog','en','Finalise and Submit Blog',NULL,NULL),('blog','blog_import','en','Import Blog',NULL,NULL),('blog','blog_incl_comments','en','including comments',NULL,NULL),('blog','blog_keyword','en','Keyword',NULL,NULL),('blog','blog_keywords','en','Keywords',NULL,NULL),('blog','blog_keyword_enter','en','Write a keyword and press Enter.',NULL,NULL),('blog','blog_latest_posting','en','Latest Post',NULL,NULL),('blog','blog_link','en','Link',NULL,NULL),('blog','blog_list_more','en','More',NULL,NULL),('blog','blog_list_num_postings','en','Number of Posts',NULL,NULL),('blog','blog_list_num_postings_info','en','The maximum number of posts displayed when viewing the blog with no specific month selected.',NULL,NULL),('blog','blog_navigation','en','Posts',NULL,NULL),('blog','blog_nav_mode','en','Posts',NULL,NULL),('blog','blog_nav_mode_month_list','en','Show List of Months',NULL,NULL),('blog','blog_nav_mode_month_list_info','en','List months with posts in the ‘Posts’ block.',NULL,NULL),('blog','blog_nav_mode_month_list_num_month','en','Total Number of Months Shown',NULL,NULL),('blog','blog_nav_mode_month_list_num_month_info','en','Limit the number of months that will be displayed in the ‘Posts’ block. The months displayed will always be the most recent and will be shown with a number indicating how many posts were made in that month as standard.',NULL,NULL),('blog','blog_nav_mode_month_list_num_month_with_post','en','Number of Months With Listed Posts',NULL,NULL),('blog','blog_nav_mode_month_list_num_month_with_post_info','en','These months will be displayed with the titles of all of their posts in the navigation block. Additional months will be displayed with a number indicating the total number of posts made in that month.',NULL,NULL),('blog','blog_nav_mode_month_single','en','Show Selected Month',NULL,NULL),('blog','blog_nav_mode_month_single_info','en','Instead of a list of months, display a drop-down menu, containing all of the months with posts for this blog. Users can use this menu to select the month they wish to view. Only the posts of the selected month will then be shown.',NULL,NULL),('blog','blog_nav_sortorder','en','Block Order',NULL,NULL),('blog','blog_needs_approval','en','Post has not yet been approved',NULL,NULL),('blog','blog_new','en','Create New Blog',NULL,NULL),('blog','blog_news_posting_authors','en','Contributing authors: %s',NULL,NULL),('blog','blog_news_posting_published','en','New blog post published by %s.',NULL,NULL),('blog','blog_news_posting_updated','en','Blog post updated by %s.',NULL,NULL),('blog','blog_new_posting_info','en','The post has been published.',NULL,NULL),('blog','blog_notification_activated','en','Notifications Activated',NULL,NULL),('blog','blog_notification_deactivated','en','Notifications Deactivated',NULL,NULL),('blog','blog_notification_toggle_off','en','Deactivate Notifications',NULL,NULL),('blog','blog_notification_toggle_on','en','Activate Notification',NULL,NULL),('blog','blog_no_keywords','en','No keywords have been entered yet.',NULL,NULL),('blog','blog_number_users_notes_or_comments','en','Number of users who have attached notes or comments to this post',NULL,NULL),('blog','blog_posting','en','Blog Post',NULL,NULL),('blog','blog_postings','en','Posts',NULL,NULL),('blog','blog_posting_deleted','en','Post successfully deleted.',NULL,NULL),('blog','blog_posting_deletion_confirmation','en','Are you sure you want to delete the following post?',NULL,NULL),('blog','blog_posting_edit_approval_info','en','Post needs to be approved by an editor in order to be visible. The post needs to be published before approval can take place.',NULL,NULL),('blog','blog_posting_not_found','en','This blog post is not available.',NULL,NULL),('blog','blog_presentation_frame','en','Blog Presentation',NULL,NULL),('blog','blog_presentation_overview','en','Initial Overview',NULL,NULL),('blog','blog_preview','en','Preview',NULL,NULL),('blog','blog_profile_picture','en','Display Profile Picture',NULL,NULL),('blog','blog_profile_picture_repository_info','en','Profile pictures of authors are only shown on post pages, not on overview pages.',NULL,NULL),('blog','blog_properties','en','Blog Properties',NULL,NULL),('blog','blog_rename_posting','en','Rename Post',NULL,NULL),('blog','blog_selected_pages','en','Selected posts',NULL,NULL),('blog','blog_settings','en','Blog Administration',NULL,NULL),('blog','blog_settings_navigation','en','Navigation Sidebar',NULL,NULL),('blog','blog_show_latest','en','Show Latest Posts/Drafts',NULL,NULL),('blog','blog_show_print_view','en','Show Print View',NULL,NULL),('blog','blog_side_blocks','en','Side Blocks',NULL,NULL),('blog','blog_starting_page','en','Starting Page',NULL,NULL),('blog','blog_task_publishing_draft_title','en','Publish Draft Blog Post \"%s\"',NULL,NULL),('blog','blog_toggle_draft','en','Withdraw Publication',NULL,NULL),('blog','blog_toggle_draft_admin','en','Deactivate Blog Post',NULL,NULL),('blog','blog_toggle_final','en','Publish Post',NULL,NULL),('blog','blog_whole_blog','en','Whole blog',NULL,NULL),('book','booking_multiple_succesfully','en','Bookings successfully carried out.',NULL,NULL),('book','booking_nr_of_items','en','Number of Items',NULL,NULL),('book','book_add','en','Add Booking Pool',NULL,NULL),('book','book_additional_info_file','en','Additional Description',NULL,NULL),('book','book_add_object','en','Add Item',NULL,NULL),('book','book_add_participant','en','Add Participant',NULL,NULL),('book','book_add_schedule','en','Add Schedule',NULL,NULL),('book','book_all','en','Show all',NULL,NULL),('book','book_all_pools_need_schedules','en','Settings not saved. All selected booking pools need to have at least one schedule.',NULL,NULL),('book','book_all_users','en','All Participants',NULL,NULL),('book','book_assign','en','Book',NULL,NULL),('book','book_assign_object','en','Book Items for Participant',NULL,NULL),('book','book_assign_participant','en','Book for Other Participant(s)',NULL,NULL),('book','book_back_to_list','en','Back to List',NULL,NULL),('book','book_bobj','en','Bookable Item',NULL,NULL),('book','book_book','en','Book',NULL,NULL),('book','book_booked_in','en','Booked In',NULL,NULL),('book','book_booking','en','Booking',NULL,NULL),('book','book_booking_information','en','Information',NULL,NULL),('book','book_booking_objects','en','Bookable Items',NULL,NULL),('book','book_booking_reminders','en','Upcoming Bookings',NULL,NULL),('book','book_book_available','en','Book Available Dates',NULL,NULL),('book','book_book_recurrence','en','Book multiple dates',NULL,NULL),('book','book_bulk_confirmation','en','Please check that all values are listed correctly.',NULL,NULL),('book','book_bulk_creation','en','Bulk Creation',NULL,NULL),('book','book_bulk_data','en','Item Data',NULL,NULL),('book','book_cal_entry','en','Booking:',NULL,NULL),('book','book_confirm_booking','en','Confirm Booking',NULL,NULL),('book','book_confirm_booking_for_users','en','Are you sure you want to book this item for the following user(s)?',NULL,NULL),('book','book_confirm_booking_no_schedule','en','Are you sure you want to book the following item?',NULL,NULL),('book','book_confirm_booking_schedule_number_of_objects','en','Booking Confirmation',NULL,NULL),('book','book_confirm_booking_schedule_number_of_objects_info','en','Please enter the number of items that you would like to book.',NULL,NULL),('book','book_confirm_cancel','en','Are you sure you want to cancel the following booking(s)?',NULL,NULL),('book','book_confirm_cancel_aggregation','en','Number of Cancellations',NULL,NULL),('book','book_confirm_delete','en','Are you sure you want to delete the following items?',NULL,NULL),('book','book_copy','en','Copy Booking Pool',NULL,NULL),('book','book_create_objects','en','Create Items',NULL,NULL),('book','book_deadline','en','Deadline',NULL,NULL),('book','book_deadline_hours','en','X hours before time slot begins',NULL,NULL),('book','book_deadline_info','en','Minimum time between booking and booked period',NULL,NULL),('book','book_deadline_options','en','Bookings Can Be Made Until:',NULL,NULL),('book','book_deadline_slot_end','en','Time slot ends',NULL,NULL),('book','book_deadline_slot_start','en','Time slot begins',NULL,NULL),('book','book_deassign','en','Edit Bookings',NULL,NULL),('book','book_download_info','en','Download Additional Description',NULL,NULL),('book','book_edit','en','Edit Booking Pool',NULL,NULL),('book','book_edit_object','en','Edit Bookable Item',NULL,NULL),('book','book_edit_schedule','en','Edit Schedule',NULL,NULL),('book','book_filter_past_reservations','en','Show Past Bookings',NULL,NULL),('book','book_fromto','en','Date Range',NULL,NULL),('book','book_hours','en','Hours before start of timeslot.',NULL,NULL),('book','book_is_used','en','In Use',NULL,NULL),('book','book_limit_objects_available','en','You cannot book this item for %s participants. ‘%s’ is only available %s times.',NULL,NULL),('book','book_list','en','List',NULL,NULL),('book','book_log','en','Bookings',NULL,NULL),('book','book_mail_permanent_link','en','Link to Booking Pool',NULL,NULL),('book','book_mail_to_booker','en','Mail to User',NULL,NULL),('book','book_message','en','Message',NULL,NULL),('book','book_messages','en','Messages',NULL,NULL),('book','book_messages_info','en','Allow users to add a message when booking an item.',NULL,NULL),('book','book_message_info','en','You may enter a message for the booking organiser here.',NULL,NULL),('book','book_missing_availability','en','It was not possible to book all items on all dates.',NULL,NULL),('book','book_missing_items','en','$1 missing item(s).',NULL,NULL),('book','book_new','en','New Booking Pool',NULL,NULL),('book','book_not','en','Not',NULL,NULL),('book','book_notification','en','Send Booking Notifications',NULL,NULL),('book','book_notification_cron_not_active','en','Note: The necessary cron job, \'Send Reservation Notifications\', is currently not active.',NULL,NULL),('book','book_notification_info','en','Send a list of the next day’s bookings to users (own bookings) and admins (if activated).',NULL,NULL),('book','book_not_enough_preferences','en','You have not selected enough preferences. Your preferences have not been saved.',NULL,NULL),('book','book_no_bookings_for_you','en','No bookings have been made for you.',NULL,NULL),('book','book_no_objects','en','No Bookings',NULL,NULL),('book','book_no_of_objects','en','No. of Units',NULL,NULL),('book','book_no_pools_selected','en','No booking pools have been assigned to this course. Booking pools can be assigned via the course\'s \'Resources\' tab.',NULL,NULL),('book','book_no_preferences_for_you','en','No preferences have been recorded for you.',NULL,NULL),('book','book_no_recurrence','en','Book only this date',NULL,NULL),('book','book_nr_of_preferences','en','Number of Preferences',NULL,NULL),('book','book_nr_of_preferences_info','en','Number of preferences each participant is required to state.',NULL,NULL),('book','book_nr_preferences','en','Preferences',NULL,NULL),('book','book_objects_available','en','Items available %s',NULL,NULL),('book','book_object_added','en','Bookable item added.',NULL,NULL),('book','book_object_deleted','en','Bookable item deleted.',NULL,NULL),('book','book_object_selection','en','Item Selection',NULL,NULL),('book','book_object_updated','en','Bookable item updated.',NULL,NULL),('book','book_obj_select','en','Select',NULL,NULL),('book','book_open','en','Open Booking Pool',NULL,NULL),('book','book_overall_limit','en','Limit Total Number of Bookings per User',NULL,NULL),('book','book_overall_limit_warning','en','You have reached the maximum number of bookings allowed.',NULL,NULL),('book','book_participant','en','Book for Participants',NULL,NULL),('book','book_participant_already_assigned','en','One or more participants have already been added.',NULL,NULL),('book','book_participant_assigned','en','Participant(s) added.',NULL,NULL),('book','book_period','en','Period',NULL,NULL),('book','book_pool_added','en','Booking pool successfully created.',NULL,NULL),('book','book_pool_selection','en','Booking Pool Selection',NULL,NULL),('book','book_post_booking_file','en','File',NULL,NULL),('book','book_post_booking_information','en','Booking Information',NULL,NULL),('book','book_post_booking_text','en','Text',NULL,NULL),('book','book_post_booking_text_info','en','Use placeholders to include booking-specific information. <br />[OBJECT] will be replaced by the respective Bookable Item. <br />[PERIOD] will be replaced by the respective schedule.',NULL,NULL),('book','book_preferences','en','Preferences',NULL,NULL),('book','book_preferences_saved','en','Your preferences have been saved.',NULL,NULL),('book','book_preference_info','en','Please select %1 preference(s) by %2. After this deadline, bookings will be allocated automatically, taking into consideration the preferences of all users.',NULL,NULL),('book','book_pref_book_cron','en','Booking with Preferences',NULL,NULL),('book','book_pref_book_cron_info','en','Automatically allocate bookings based on preferences after expiration of deadline.',NULL,NULL),('book','book_pref_deadline','en','Deadline',NULL,NULL),('book','book_pref_deadline_info','en','Preferences can be stated up to this point.',NULL,NULL),('book','book_pref_overview','en','Overview',NULL,NULL),('book','book_public_log','en','Bookings Visible to All Participants',NULL,NULL),('book','book_public_log_info','en','Users with the ‘Read’ permission are able to see the bookings of the other participants in the ‘Bookings’ tab.',NULL,NULL),('book','book_recurrence','en','Recurrence',NULL,NULL),('book','book_refresh','en','Refresh',NULL,NULL),('book','book_reminder_day','en','Send Reminder',NULL,NULL),('book','book_reminder_days','en','day(s) before time-slot of booking',NULL,NULL),('book','book_reminder_day_info','en','Send list of own bookings to users and full list of all upcoming bookings to admins. Please note: in order to receive reminders, users need to have activated notifications via the ‘Actions’ menu at the top right-hand corner of the booking pool.',NULL,NULL),('book','book_reminder_setting','en','Reminder',NULL,NULL),('book','book_rem_intro','en','This is an overview of upcoming reservations:',NULL,NULL),('book','book_rem_reason','en','You have received this mail because you are subscribed to notifications for the booking pool mentioned in this mail.',NULL,NULL),('book','book_rerun_assignments','en','Run Allocation Process',NULL,NULL),('book','book_rerun_confirmation','en','Attention. The process of allocating bookings according to preferences has already taken place. You may restart the process if any errors have occurred, e.g. no bookings have been saved. To prevent multiple allocations, please delete all existing bookings before restarting the process.',NULL,NULL),('book','book_reservations_list','en','Bookings',NULL,NULL),('book','book_reservation_available','en','%s available',NULL,NULL),('book','book_reservation_confirmed','en','Your booking has been confirmed.',NULL,NULL),('book','book_reservation_failed','en','It was not possible to confirm your booking.',NULL,NULL),('book','book_reservation_failed_overbooked','en','Your booking failed because the bookable item in question is no longer available.',NULL,NULL),('book','book_reservation_filter_period','en','Default Value for ‘Date Range’ Filter',NULL,NULL),('book','book_reservation_filter_period_info','en','The default value for the ‘Date Range’ filter in the ‘Bookings’ tab (in days from the current date).',NULL,NULL),('book','book_reservation_fix_info','en','Bookings can only be made for the time slots shown as available below.',NULL,NULL),('book','book_reservation_overview','en','Bookings Overview',NULL,NULL),('book','book_reservation_status_5','en','Cancelled',NULL,NULL),('book','book_reservation_title','en','Booking Reservation for',NULL,NULL),('book','book_schedule','en','Schedule',NULL,NULL),('book','book_schedules','en','Schedules',NULL,NULL),('book','book_schedule_added','en','Booking schedule added.',NULL,NULL),('book','book_schedule_days','en','Time Slots',NULL,NULL),('book','book_schedule_days_info','en','Valid booking times for each day (HH:MM-HH:MM)',NULL,NULL),('book','book_schedule_deleted','en','Booking schedule deleted.',NULL,NULL),('book','book_schedule_slot','en','Time Slot',NULL,NULL),('book','book_schedule_type','en','Booking Mode',NULL,NULL),('book','book_schedule_type_fixed','en','Fixed Schedule',NULL,NULL),('book','book_schedule_type_fixed_info','en','This booking mode can be used for things that can be booked for specific periods of time, such as rooms, services and equipment.',NULL,NULL),('book','book_schedule_type_none','en','No Schedule',NULL,NULL),('book','book_schedule_type_none_direct','en','No Schedule, Direct Booking',NULL,NULL),('book','book_schedule_type_none_direct_info','en','This booking mode is ideal for presentation topics or places in seminars that do not require set times. Participants can book items directly on a first come, first served basis. Each item can only be booked once per participant.',NULL,NULL),('book','book_schedule_type_none_info','en','This type can be used for seminar papers, seminar places and such.',NULL,NULL),('book','book_schedule_type_none_preference','en','No Schedule, Using Preferences',NULL,NULL),('book','book_schedule_type_none_preference_info','en','This booking mode is ideal for presentation topics, places in seminars or similar. Participants get to indicate their preferences in terms of which items they are most interested in. Items will then be allocated automatically after the preferences deadline has passed.',NULL,NULL),('book','book_schedule_updated','en','Booking schedule updated.',NULL,NULL),('book','book_schedule_warning_edit','en','Your booking pool currently does not have a schedule available. To use the booking pool you either need to create a schedule or select a ‘no schedule’ booking mode in the ‘Booking Mode’ section of the ‘Settings’ tab.',NULL,NULL),('book','book_select_pool','en','Select Pool',NULL,NULL),('book','book_set_cancel','en','Cancel Booking',NULL,NULL),('book','book_set_delete','en','Delete Booking',NULL,NULL),('book','book_show_message','en','Show Message',NULL,NULL),('book','book_title_description_nr','en','Title; Description; Number of Units',NULL,NULL),('book','book_title_description_nr_info','en','Enter title, description and number of units separated by semicolon or TAB character (if importing from spreadsheet software). Use one line per item.',NULL,NULL),('book','book_too_many_preferences','en','You have selected too many preferences. Your preferences have not been saved.',NULL,NULL),('book','book_total_individual_bookings_limit','en','Limit the number of bookings that can be carried out by/for individual participants in total, across all available items. Each bookable item can still only be booked once per participant.',NULL,NULL),('book','book_type_warning','en','There are currently no bookable items available. Please create some bookable items to be able to use this booking pool.',NULL,NULL),('book','book_week','en','Week',NULL,NULL),('book','book_your_bookings','en','Your Bookings',NULL,NULL),('book','book_your_preferences','en','Your Preferences',NULL,NULL),('book','book_your_reservations','en','Your Bookings',NULL,NULL),('book','obj_book_duplicate','en','Copy Booking Pool',NULL,NULL),('book','participants','en','Participants',NULL,NULL),('book','reservation_deleted','en','Booking deleted.',NULL,NULL),('book','X_reservations_of','en','%s booking(s) of',NULL,NULL),('buddysystem','buddy_allow_to_contact_me','en','Allow Contact Requests',NULL,NULL),('buddysystem','buddy_allow_to_contact_me_info','en','Other users are able to send me request for getting into contact.',NULL,NULL),('buddysystem','buddy_bs_action_already_ignored','en','Action not possible. Already ignored user \'%s\'.',NULL,NULL),('buddysystem','buddy_bs_action_already_linked','en','Action not possible. Already accepted the contact request from user \'%s\'.',NULL,NULL),('buddysystem','buddy_bs_action_already_requested','en','Action not possible. Already requested user \'%s\'.',NULL,NULL),('buddysystem','buddy_bs_action_already_unlinked','en','Action not possible. The contact state for user \'%s\' is already unlinked.',NULL,NULL),('buddysystem','buddy_bs_action_not_possible','en','Action not possible',NULL,NULL),('buddysystem','buddy_bs_act_btn_txt_ignored_request_to_linked','en','Confirm Request',NULL,NULL),('buddysystem','buddy_bs_act_btn_txt_ignored_request_to_unlinked','en','Cancel Request',NULL,NULL),('buddysystem','buddy_bs_act_btn_txt_linked_to_unlinked','en','Unlink',NULL,NULL),('buddysystem','buddy_bs_act_btn_txt_requested_to_ignored_request','en','Ignore Contact',NULL,NULL),('buddysystem','buddy_bs_act_btn_txt_requested_to_linked','en','Confirm Contact',NULL,NULL),('buddysystem','buddy_bs_act_btn_txt_requested_to_unlinked','en','Cancel Request',NULL,NULL),('buddysystem','buddy_bs_btn_txt_ignored_request_a','en','Requested Contact',NULL,NULL),('buddysystem','buddy_bs_btn_txt_ignored_request_p','en','Request Ignored',NULL,NULL),('buddysystem','buddy_bs_btn_txt_linked_a','en','Linked',NULL,NULL),('buddysystem','buddy_bs_btn_txt_linked_p','en','Linked',NULL,NULL),('buddysystem','buddy_bs_btn_txt_requested_a','en','Requested Contact',NULL,NULL),('buddysystem','buddy_bs_btn_txt_requested_p','en','Request',NULL,NULL),('buddysystem','buddy_bs_btn_txt_unlinked_a','en','Request Contact',NULL,NULL),('buddysystem','buddy_bs_state_ignoredrequest','en','Ignored',NULL,NULL),('buddysystem','buddy_bs_state_ignored_request_a','en','Requested',NULL,NULL),('buddysystem','buddy_bs_state_ignored_request_p','en','Ignored',NULL,NULL),('buddysystem','buddy_bs_state_linked','en','Linked',NULL,NULL),('buddysystem','buddy_bs_state_linked_a','en','Linked',NULL,NULL),('buddysystem','buddy_bs_state_linked_p','en','Linked',NULL,NULL),('buddysystem','buddy_bs_state_requested','en','Requested',NULL,NULL),('buddysystem','buddy_bs_state_requested_a','en','Requested',NULL,NULL),('buddysystem','buddy_bs_state_requested_filter_a','en','Waiting for Reaction',NULL,NULL),('buddysystem','buddy_bs_state_requested_filter_p','en','Action Required',NULL,NULL),('buddysystem','buddy_bs_state_requested_p','en','Requested',NULL,NULL),('buddysystem','buddy_bs_state_unlinked','en','Unlinked',NULL,NULL),('buddysystem','buddy_bs_state_unlinked_a','en','Unlinked',NULL,NULL),('buddysystem','buddy_bs_state_unlinked_p','en','Unlinked',NULL,NULL),('buddysystem','buddy_enable','en','Activate ‘Contacts’',NULL,NULL),('buddysystem','buddy_enable_info','en','If enabled, users are allowed to contact each other by initiating contact requests. Additionally, there is a personal user setting to allow or prevent being contacted.',NULL,NULL),('buddysystem','buddy_handle_contact_request','en','Contact Request',NULL,NULL),('buddysystem','buddy_notification_contact_request','en','Contact Request',NULL,NULL),('buddysystem','buddy_notification_contact_request_ignore','en','Ignore Request',NULL,NULL),('buddysystem','buddy_notification_contact_request_ignore_osd','en','Ignore Request',NULL,NULL),('buddysystem','buddy_notification_contact_request_link','en','Approve Request',NULL,NULL),('buddysystem','buddy_notification_contact_request_link_osd','en','Approve Request',NULL,NULL),('buddysystem','buddy_notification_contact_request_long','en','[SALUTATION][BR][BR]\"[REQUESTING_USER]\" wants to add you to their friends list.[BR][BR]Personal Profile Link: [PERSONAL_PROFILE_LINK][BR][BR][APPROVE_REQUEST_TXT] [APPROVE_REQUEST][BR][IGNORE_REQUEST_TXT] [IGNORE_REQUEST]',NULL,NULL),('buddysystem','buddy_notification_contact_request_short','en','The user \"[REQUESTING_USER]\" wants to add you to their friends list.',NULL,NULL),('buddysystem','buddy_noti_cr_profile_not_published','en','Profile not published',NULL,NULL),('buddysystem','buddy_relation_requested','en','A request has been sent to the user.',NULL,NULL),('buddysystem','buddy_request_approved','en','You successfully approved the contact.',NULL,NULL),('buddysystem','buddy_request_ignored','en','You ignored the user.',NULL,NULL),('buddysystem','buddy_tbl_filter_state','en','Status',NULL,NULL),('buddysystem','buddy_tbl_state_actions_col_label','en','State / Action',NULL,NULL),('buddysystem','buddy_tbl_title_relations','en','Relations to Other Users',NULL,NULL),('buddysystem','buddy_use_osd','en','Popup Contact Requests',NULL,NULL),('buddysystem','buddy_use_osd_info','en','Display a popup to indicate a user wants to add you to his friends lists.',NULL,NULL),('buddysystem','buddy_view_gallery','en','Gallery',NULL,NULL),('buddysystem','buddy_view_table','en','List',NULL,NULL),('cat','cat_copy','en','Copy Category',NULL,NULL),('cat','cat_hide_tax_in_side_block','en','Don\'t Present in Side Panel',NULL,NULL),('cat','cat_import','en','Import Category',NULL,NULL),('cat','cat_more_translations','en','More Translations',NULL,NULL),('cat','cat_show_tax_in_side_block','en','Present in Side Panel',NULL,NULL),('cert','certificate_achievement','en','%1$s obtained.',NULL,NULL),('cert','certificate_achievement_sub_obj','en','Certificate for %1$s',NULL,NULL),('cert','certificate_no_object_title','en','No object title available',NULL,NULL),('cert','certificate_same_not_saved','en','No new version of the certificate template has been saved, as no values were changed.',NULL,NULL),('cert','cert_currently_no_certs','en','You do not have any certificates yet.',NULL,NULL),('cert','cert_description_label','en','Description',NULL,NULL),('cert','cert_download_label','en','Download',NULL,NULL),('cert','cert_error_no_access','en','You do not have the permissions necessary to access this certificate.',NULL,NULL),('cert','cert_issued_on_label','en','Issued On',NULL,NULL),('cert','cert_object_label','en','Object',NULL,NULL),('cert','cert_sortable_by_issue_date_asc','en','Issue Date Ascending',NULL,NULL),('cert','cert_sortable_by_issue_date_desc','en','Issue Date Descending',NULL,NULL),('cert','cert_sortable_by_title_asc','en','Title Ascending',NULL,NULL),('cert','cert_sortable_by_title_desc','en','Title Descending',NULL,NULL),('cert','error_creating_certificate_pdf','en','The certificate could not be created. Please contact your installation’s technical support and ask for the certificate server to be checked.',NULL,NULL),('cert','user_certificates','en','Certificates',NULL,NULL),('certificate','certificate_a4','en','A4 (297 mm x 210 mm)',NULL,NULL),('certificate','certificate_a4_landscape','en','A4 Landscape (210 mm x 297 mm)',NULL,NULL),('certificate','certificate_a5','en','A5 (210 mm x 148 mm)',NULL,NULL),('certificate','certificate_a5_landscape','en','A5 Landscape (148 mm x 210 mm)',NULL,NULL),('certificate','certificate_background_image','en','Background Image',NULL,NULL),('certificate','certificate_card_thumbnail_image','en','Thumbnail Image',NULL,NULL),('certificate','certificate_change_active_status','en','The ‘Active’ status of the certificate has been changed.',NULL,NULL),('certificate','certificate_confirm_deletion_text','en','Are you sure you want to delete all of the data entered for this certificate template?',NULL,NULL),('certificate','certificate_custom','en','Custom',NULL,NULL),('certificate','certificate_edit','en','Create/Edit a Certificate Template',NULL,NULL),('certificate','certificate_error_import','en','An error occurred while trying to import the certificate!',NULL,NULL),('certificate','certificate_error_upload_bgimage','en','An error occurred while trying to upload the background image.',NULL,NULL),('certificate','certificate_export','en','Export',NULL,NULL),('certificate','certificate_failed','en','Failed',NULL,NULL),('certificate','certificate_file_basename','en','Certificate',NULL,NULL),('certificate','certificate_id','en','Certificate ID',NULL,NULL),('certificate','certificate_issue_date','en','Date of Issue',NULL,NULL),('certificate','certificate_learning_progress_must_be_active','en','Only objects with an active Learning Progress can be selected. The Learning Progress is deactivated on the following objects: %s',NULL,NULL),('certificate','certificate_letter','en','Letter (11 inch x 8.5 inch)',NULL,NULL),('certificate','certificate_letter_landscape','en','Letter Landscape (8.5 inch x 11 inch)',NULL,NULL),('certificate','certificate_margin_body','en','Text Margins',NULL,NULL),('certificate','certificate_not_well_formed','en','The certificate text is not correctly formatted. Please enter valid XHTML for the certificate text.',NULL,NULL),('certificate','certificate_pageheight','en','Page Height',NULL,NULL),('certificate','certificate_pagewidth','en','Page Width',NULL,NULL),('certificate','certificate_page_format','en','Page Format',NULL,NULL),('certificate','certificate_page_format_info','en','Please select the page format to be used as the default for new certificates.',NULL,NULL),('certificate','certificate_passed','en','Passed',NULL,NULL),('certificate','certificate_ph_birthday','en','User’s date of birth',NULL,NULL),('certificate','certificate_ph_cert_id','en','Unique Certificate ID',NULL,NULL),('certificate','certificate_ph_city','en','City from user\'s address',NULL,NULL),('certificate','certificate_ph_country','en','Country from user\'s address',NULL,NULL),('certificate','certificate_ph_date','en','Current date',NULL,NULL),('certificate','certificate_ph_datetime','en','Current date and time',NULL,NULL),('certificate','certificate_ph_datetime_completed','en','Date and time of completion',NULL,NULL),('certificate','certificate_ph_date_completed','en','Date of completion',NULL,NULL),('certificate','certificate_ph_department','en','Department to which user belongs',NULL,NULL),('certificate','certificate_ph_exercisetitle','en','Title of exercise',NULL,NULL),('certificate','certificate_ph_firstname','en','User’s first name',NULL,NULL),('certificate','certificate_ph_fullname','en','User’s full name (title, first name and last name)',NULL,NULL),('certificate','certificate_ph_institution','en','Institution to which user belongs',NULL,NULL),('certificate','certificate_ph_introduction','en','The following placeholders may be used',NULL,NULL),('certificate','certificate_ph_lastaccess','en','Date and time of last access by user',NULL,NULL),('certificate','certificate_ph_lastname','en','User’s last name',NULL,NULL),('certificate','certificate_ph_login','en','Username',NULL,NULL),('certificate','certificate_ph_mark','en','User’s mark',NULL,NULL),('certificate','certificate_ph_marklong','en','User’s mark (official version)',NULL,NULL),('certificate','certificate_ph_markshort','en','User’s mark (short version)',NULL,NULL),('certificate','certificate_ph_matriculation','en','User’s matriculation number',NULL,NULL),('certificate','certificate_ph_no_sco','en','If the learning progress for this learning module is determined by a collection of objects, then placeholders for the titles and points of these objects will be made available here.',NULL,NULL),('certificate','certificate_ph_salutation','en','Salutation',NULL,NULL),('certificate','certificate_ph_scormmaxpoints','en','Maximum value in the range for the raw score of the last relevant sco (most suitable for a final exam)',NULL,NULL),('certificate','certificate_ph_scormpoints','en','Points of the SCORM learning module in percent',NULL,NULL),('certificate','certificate_ph_scormtitle','en','Title of the SCORM learning module',NULL,NULL),('certificate','certificate_ph_scos','en','The following were selected to determine the overall learning progress status and are available for statements in the certificate:',NULL,NULL),('certificate','certificate_ph_sco_points_max','en','Placeholder<br/>for max<br/>points',NULL,NULL),('certificate','certificate_ph_sco_points_raw','en','Placeholder<br/>for points',NULL,NULL),('certificate','certificate_ph_sco_points_scaled','en','Placeholder<br/>for points<br/>in percent',NULL,NULL),('certificate','certificate_ph_sco_title','en','Placeholder<br/>for title',NULL,NULL),('certificate','certificate_ph_street','en','Street from user\'s address',NULL,NULL),('certificate','certificate_ph_testtitle','en','Title of test',NULL,NULL),('certificate','certificate_ph_title','en','User’s title',NULL,NULL),('certificate','certificate_ph_title_sco','en','Title',NULL,NULL),('certificate','certificate_ph_zipcode','en','ZIP / Post code from user\'s address',NULL,NULL),('certificate','certificate_points_notavailable','en','This value cannot be calculated',NULL,NULL),('certificate','certificate_preview','en','Preview',NULL,NULL),('certificate','certificate_settings','en','Certificate Settings',NULL,NULL),('certificate','certificate_short_name','en','Certificate File Short Title',NULL,NULL),('certificate','certificate_short_name_description','en','Please enter a short title for the certificate name. The short title will be part of the certificate name: YYMMDD_[surname]_[SHORT_TITLE]_certificate.pdf.',NULL,NULL),('certificate','certificate_text','en','Certificate Text',NULL,NULL),('certificate','certificate_text_info','en','Please enter the text you want to have displayed on the certificate. If the WYSIWYG editor is disabled in the ILIAS administration, you can still use valid XHTML to format the text.',NULL,NULL),('certificate','certificate_unit_description','en','Enter units of measurement as: VALUE[cm|mm|in|pt|pc|px|em], e.g. 10mm or 3in',NULL,NULL),('certificate','certificate_usage','en','Please note that the use and creation of certificates is only possible if you use the ILIAS Java server. The Java server is configured by specifying the network host and port via the ILIAS Setup and is required, among other things, for generating PDF files.',NULL,NULL),('certificate','certificate_var_max_points','en','Maximum number of points in the test used',NULL,NULL),('certificate','certificate_var_result_mark_long','en','Achieved mark presented in \'official form\'',NULL,NULL),('certificate','certificate_var_result_mark_short','en','Achieved mark presented in \'short form\'',NULL,NULL),('certificate','certificate_var_result_passed','en','Passed',NULL,NULL),('certificate','certificate_var_result_percent','en','Percentage achieved in the test',NULL,NULL),('certificate','certificate_var_result_points','en','Number of points achieved in the test',NULL,NULL),('certificate','certificate_var_user_birthday','en','22.05.1952',NULL,NULL),('certificate','certificate_var_user_city','en','London',NULL,NULL),('certificate','certificate_var_user_country','en','UK',NULL,NULL),('certificate','certificate_var_user_department','en','Customer Support',NULL,NULL),('certificate','certificate_var_user_firstname','en','John',NULL,NULL),('certificate','certificate_var_user_fullname','en','John H. Watson, M.D',NULL,NULL),('certificate','certificate_var_user_institution','en','ILIAS Investigations Ltd.',NULL,NULL),('certificate','certificate_var_user_lastname','en','Watson',NULL,NULL),('certificate','certificate_var_user_login','en','jwatson',NULL,NULL),('certificate','certificate_var_user_matriculation','en','8201754',NULL,NULL),('certificate','certificate_var_user_salutation','en','Mr',NULL,NULL),('certificate','certificate_var_user_street','en','221B Baker Street',NULL,NULL),('certificate','certificate_var_user_title','en','Dr',NULL,NULL),('certificate','certificate_var_user_zipcode','en','NW1 6XE',NULL,NULL),('certificate','cert_cron_task_desc','en','This cron job creates persistent certificates based on the learning achievements of users.',NULL,NULL),('certificate','cert_cron_task_title','en','Certificates',NULL,NULL),('certificate','cert_form_sec_add_features','en','Additional Features',NULL,NULL),('certificate','cert_form_sec_availability','en','Availability',NULL,NULL),('certificate','cert_form_sec_layout','en','Layout and Text',NULL,NULL),('certificate','cmix_cert_ph_object_description','en','Description',NULL,NULL),('certificate','cmix_cert_ph_object_title','en','Title of the xAPI/cmi5 Object',NULL,NULL),('certificate','cmix_cert_ph_reached_score','en','Score achieved in percent',NULL,NULL),('certificate','default_background_info','en','This background image will be used as the default background for all certificates unless a different image is uploaded when creating a certificate for a specific object.',NULL,NULL),('certificate','download_certificate','en','Download Certificate',NULL,NULL),('certificate','learning_progress_deactivated','en','Learning progress for this object is currently deactivated. In order to edit the certificate template and for users to be able to obtain certificates, learning progress for this object needs to be activated via Learning Progress » Settings.',NULL,NULL),('certificate','lti_cert_ph_mastery_score','en','Score achieved in percent',NULL,NULL),('certificate','lti_cert_ph_object_description','en','Description',NULL,NULL),('certificate','lti_cert_ph_object_title','en','Title of the LTI Consumer Object',NULL,NULL),('certificate','lti_cert_ph_reached_score','en','Reached score as percentage',NULL,NULL),('certificate','persistent_certificate_mode','en','User Certificate Creation',NULL,NULL),('certificate','persistent_certificate_mode_cron','en','Cron Job',NULL,NULL),('certificate','persistent_certificate_mode_cron_info','en','This option is recommended for systems with high levels of user interaction.',NULL,NULL),('certificate','persistent_certificate_mode_instant','en','Instant',NULL,NULL),('certificate','persistent_certificate_mode_instant_info','en','This option is recommended for systems with low up to medium levels of user interaction. Systems that tend towards longer loading times during the creation of multiple user certificates should switch to the ‘Cron Job’ option.',NULL,NULL),('chatroom','allow_anonymous','en','Allow Anonymous Login',NULL,NULL),('chatroom','allow_custom_usernames','en','Allow Custom User Names',NULL,NULL),('chatroom','anonymous_hint','en','Make sure to set the proper permissions in the ‘Permissions’ tab to allow anonymous user access to this repository item.',NULL,NULL),('chatroom','autogen_usernames','en','Auto Generated User Names',NULL,NULL),('chatroom','autogen_usernames_info','en','Pattern for auto generated user names that is assigned to anonymous user accounts. ‘#’ will be automatically replaced by a number.',NULL,NULL),('chatroom','auto_scroll','en','Scroll to Bottom',NULL,NULL),('chatroom','banned','en','You have been banned from this chat room.',NULL,NULL),('chatroom','bans','en','Bans',NULL,NULL),('chatroom','ban_question','en','Do you really want to ban the user from chat?',NULL,NULL),('chatroom','ban_table_title','en','Banned Users',NULL,NULL),('chatroom','chatroom_auth','en','Authentication',NULL,NULL),('chatroom','chatroom_auth_btn_txt','en','Generate Keys',NULL,NULL),('chatroom','chatroom_auth_key','en','Authentication-Key',NULL,NULL),('chatroom','chatroom_auth_secret','en','Authentication-Secret',NULL,NULL),('chatroom','chatroom_client_name','en','Name',NULL,NULL),('chatroom','chatroom_client_name_info','en','Please enter a name for this ILIAS client. The entered string must be globally unique. Initially this value is set to the client id of the ILIAS client. If changed, the chat server must be restarted.',NULL,NULL),('chatroom','chatroom_enable_osc','en','Enable On-Screen-Chat',NULL,NULL),('chatroom','chatroom_enable_osc_info','en','If activated, the On-Screen Chat will be available for each user. But every user can decided whether or not he/she would like to be contacted by others. Conversations could be started in the ‘Who is online?’-Tool.',NULL,NULL),('chatroom','chatroom_log','en','Chatserver Log',NULL,NULL),('chatroom','chatserver_address','en','IP-Address/FQN of Chat Server',NULL,NULL),('chatroom','chatserver_port','en','Port of Chat Server',NULL,NULL),('chatroom','chat_address','en','Address',NULL,NULL),('chatroom','chat_anonymous_not_allowed','en','Please login to use the chat.',NULL,NULL),('chatroom','chat_auth_token_info','en','Please define unique strings used by ILIAS for authentication purposes when sending requests to the chat server. You can automatically create these strings by clicking the corresponding button. Please note that the chat server is able to communicate with multiple ILIAS clients, but each client name has to be <b>unique</b>.',NULL,NULL),('chatroom','chat_ban','en','Ban',NULL,NULL),('chatroom','chat_broadcast_typing','en','Broadcast Typing',NULL,NULL),('chatroom','chat_broadcast_typing_info','en','If enabled, your typing will be broadcasted to other participants of a conversation or chat room.',NULL,NULL),('chatroom','chat_connection_disconnected','en','#username# left the chat room.',NULL,NULL),('chatroom','chat_connection_established','en','#username# has entered chat room.',NULL,NULL),('chatroom','chat_deletion_disabled','en','Disabled',NULL,NULL),('chatroom','chat_deletion_interval','en','Interval',NULL,NULL),('chatroom','chat_deletion_interval_info','en','If chosen, messages in the repository chat and On-Screen-Chat conversations will be deleted after the defined threshold.',NULL,NULL),('chatroom','chat_deletion_interval_run_at','en','Time',NULL,NULL),('chatroom','chat_deletion_interval_run_at_info','en','Please define the time (format: HH:MM) when the server should process the message deletion.',NULL,NULL),('chatroom','chat_deletion_interval_unit','en','Unit',NULL,NULL),('chatroom','chat_deletion_interval_value','en','Value',NULL,NULL),('chatroom','chat_deletion_ival_max_val','en','The maximum value for the chose unit \'%s\' is: %s',NULL,NULL),('chatroom','chat_deletion_section_head','en','Deletion of old Messages',NULL,NULL),('chatroom','chat_enable_history','en','Enable History',NULL,NULL),('chatroom','chat_enable_history_info','en','Everybody can read and export past chat messages in the tab „History“.',NULL,NULL),('chatroom','chat_error_log_info','en','Please define an absolute server path to the chat server\'s error log file (e.g.: /var/www/ilias/data/chat_error.log). If you do not specify a path, the chat server will automatically create a file located in the chat server directory.',NULL,NULL),('chatroom','chat_functions','en','Chat Functions',NULL,NULL),('chatroom','chat_https_cert_info','en','Please define an absolute server path to the SSL certificate file (e.g.: /etc/ssl/certs/server.pem).',NULL,NULL),('chatroom','chat_https_dhparam_info','en','Please define an absolute server path to a file (e.g.: /etc/ssl/private/dhparam.pem), used for the negotiation of Diffie Hellman parameters (e.g. generated via: openssl dhparam -out /etc/ssl/private/dhparam.pem 2048 ).',NULL,NULL),('chatroom','chat_https_key_info','en','Please define an absolute server path to the private key file (e.g..: /etc/ssl/private/server.key).',NULL,NULL),('chatroom','chat_invitation','en','\"[INVITER_NAME]\" invites you into chat room \"[ROOM_NAME]\"',NULL,NULL),('chatroom','chat_invitations','en','Chat invitations',NULL,NULL),('chatroom','chat_invitation_long','en','[SALUTATION][BR][BR]You have been invited to a chat room:[BR]Chat Room Title: [ROOM_NAME][BR]Invited by: [INVITER_NAME][BR]URL: [LINK][BR][BR]To join the chat room, please follow the given URL.',NULL,NULL),('chatroom','chat_invitation_nc_inv_x','en','You have %s chat invitations.',NULL,NULL),('chatroom','chat_invitation_nc_no_inv','en','You have no chat invitations.',NULL,NULL),('chatroom','chat_invitation_short','en','Please click the link to enter the chat room.',NULL,NULL),('chatroom','chat_invite','en','Invite',NULL,NULL),('chatroom','chat_join','en','Join',NULL,NULL),('chatroom','chat_kick','en','Kick',NULL,NULL),('chatroom','chat_log_info','en','Please define an absolute server path to the chat server\'s log file (e.g.: /var/www/ilias/data/chat.log). If you do not specify a path, the chat server will automatically create a file located in the chat server directory.',NULL,NULL),('chatroom','chat_log_level','en','Log Level',NULL,NULL),('chatroom','chat_mainroom','en','Main Room',NULL,NULL),('chatroom','chat_message','en','Message',NULL,NULL),('chatroom','chat_message_display','en','Options',NULL,NULL),('chatroom','chat_message_options','en','Display',NULL,NULL),('chatroom','chat_not_use_osc','en','Not Using On-Screen-Chat',NULL,NULL),('chatroom','chat_no_use_typing_broadcast','en','Typing will not be broadcasted',NULL,NULL),('chatroom','chat_osc_accepts_messages_no','en','Doesn\'t Receive Chat Messages',NULL,NULL),('chatroom','chat_osc_accepts_messages_yes','en','Receives Chat Messages',NULL,NULL),('chatroom','chat_osc_accept_msg','en','Allow On-Screen Chat Conversations',NULL,NULL),('chatroom','chat_osc_accept_msg_info','en','Allow other users to send you messages using the on-screen chat system.',NULL,NULL),('chatroom','chat_osc_accept_msg_info_slate','en','To have private conversations, you must enable your setting \"Allow On-Screen Chat Conversations\".',NULL,NULL),('chatroom','chat_osc_accept_msg_info_slate_link_txt','en','Visibility (in Profile and Privacy)',NULL,NULL),('chatroom','chat_osc_accept_no_conv_info_slate','en','There are currently no minimzed conversations.',NULL,NULL),('chatroom','chat_osc_add_user','en','Add Further Users',NULL,NULL),('chatroom','chat_osc_conversations','en','Conversations',NULL,NULL),('chatroom','chat_osc_doesnt_accept_msg','en','Conversations not possible',NULL,NULL),('chatroom','chat_osc_head_grp_x_persons','en','%s Users',NULL,NULL),('chatroom','chat_osc_invite_to_conversation','en','Add to Conversation',NULL,NULL),('chatroom','chat_osc_leave_grp_conv','en','Leave Conversation',NULL,NULL),('chatroom','chat_osc_minimize','en','Minimize',NULL,NULL),('chatroom','chat_osc_nc_conv_x_p','en','You have %s hidden conversations.',NULL,NULL),('chatroom','chat_osc_nc_conv_x_s','en','You have one hidden conversation.',NULL,NULL),('chatroom','chat_osc_nc_no_conv','en','No Conversations available',NULL,NULL),('chatroom','chat_osc_nc_prop_time','en','Time',NULL,NULL),('chatroom','chat_osc_no_conv','en','No conversations.',NULL,NULL),('chatroom','chat_osc_no_sub_directory','en','Sub-Directory',NULL,NULL),('chatroom','chat_osc_no_sub_directory_info','en','If the chat server is only reachable through a sub directory with an URL like \"http(s)://[IP/Domain]/[SUB_DIRECTORY]\" it is required to insert the [SUB_DIRECTORY] for this chat server. In most scenarios you can leave this field empty.',NULL,NULL),('chatroom','chat_osc_no_usr_found','en','Could not find any user matching your search.',NULL,NULL),('chatroom','chat_osc_search_modal_info','en','Here you can search for users you would like to add to a conversation. If the search dialogue was opened within a group chat, the new user will be added to this chat. If you started the search within a 1:1 chat, a new group chat window will be opened.',NULL,NULL),('chatroom','chat_osc_self_rej_msgs','en','You currently cannot take part in this conversation because you suppressed receiving messages in your settings.',NULL,NULL),('chatroom','chat_osc_send','en','Send',NULL,NULL),('chatroom','chat_osc_start_conversation','en','Start Conversation',NULL,NULL),('chatroom','chat_osc_subs_rej_msgs','en','Currently it is not possible to continue this conversation. Your chat-partner must activate chats in the chat-settings.',NULL,NULL),('chatroom','chat_osc_subs_rej_msgs_p','en','The following chat partners of your conversation do not want to receive messages anymore: %s',NULL,NULL),('chatroom','chat_osc_sure_to_leave_grp_conv','en','Are you sure you want to leave the group conversation?',NULL,NULL),('chatroom','chat_osc_user','en','User',NULL,NULL),('chatroom','chat_osc_user_left_grp_conv','en','User \'%s\' has left the group conversation.',NULL,NULL),('chatroom','chat_osc_write_a_msg','en','Write a Message ...',NULL,NULL),('chatroom','chat_select_room','en','Select Chat Room',NULL,NULL),('chatroom','chat_settings','en','Chat Settings',NULL,NULL),('chatroom','chat_settings_functions_header','en','Chat Room Functions',NULL,NULL),('chatroom','chat_show_auto_messages','en','Show Status Messages',NULL,NULL),('chatroom','chat_to_mainroom','en','To Main Room',NULL,NULL),('chatroom','chat_users_are_typing','en','Multiple users are typing ...',NULL,NULL),('chatroom','chat_user_action_invite_osd','en','Invite to On-Screen Chat',NULL,NULL),('chatroom','chat_user_action_invite_public_room','en','Invite to Public Room',NULL,NULL),('chatroom','chat_user_x_is_typing','en','User %s is typing ...',NULL,NULL),('chatroom','chat_use_osc','en','Using On-Screen-Chat',NULL,NULL),('chatroom','chat_use_typing_broadcast','en','Typing will be broadcasted',NULL,NULL),('chatroom','chat_whisper','en','Whisper',NULL,NULL),('chatroom','chtr_activation_limited_visibility_info','en','If checked, the title of the chat will be visible even outside of the given availability. The chat however can not be accessed.',NULL,NULL),('chatroom','chtr_activation_online_info','en','Set the chat online to make it visible and available for partcipants. If not, only users with \'Edit Settings\' permission will have access to it.',NULL,NULL),('chatroom','chtr_add','en','Add Chat Room',NULL,NULL),('chatroom','chtr_ban_actor_tbl_head','en','locked by',NULL,NULL),('chatroom','chtr_ban_ts_tbl_head','en','Timestamp',NULL,NULL),('chatroom','chtr_new','en','New Chat Room',NULL,NULL),('chatroom','chtr_server_status','en','Server Status',NULL,NULL),('chatroom','clear_room_history','en','Delete Message History',NULL,NULL),('chatroom','clear_room_history_question','en','Do you really want to delete all messages?',NULL,NULL),('chatroom','client_chatserver_connection','en','Client to Server Connection',NULL,NULL),('chatroom','client_proxy_info','en','If the Server is not accessible with the default IP-Address and Port, it is possible to configure a custom URL for Client to Server connection.',NULL,NULL),('chatroom','connection_url_info','en','Please insert an URL for the Server connection.',NULL,NULL),('chatroom','custom_username','en','Custom Username',NULL,NULL),('chatroom','dhparam','en','Diffie-Hellman Parameter',NULL,NULL),('chatroom','display_past_msgs','en','Number of Past Messages',NULL,NULL),('chatroom','duration_from','en','From',NULL,NULL),('chatroom','duration_to','en','To',NULL,NULL),('chatroom','end_whisper','en','Cancel',NULL,NULL),('chatroom','enter','en','Enter Chat Room',NULL,NULL),('chatroom','error_log','en','Chatserver Error-Log',NULL,NULL),('chatroom','hint_display_past_msgs','en','Number of previous messages shown when chat room is entered. A value of ‘0’ disables this feature.',NULL,NULL),('chatroom','history_byday_title','en','Show Conversation per Day',NULL,NULL),('chatroom','history_cleared','en','The message history was deleted by a moderator.',NULL,NULL),('chatroom','history_title_general','en','Conversation in Chat Room \"%s\"',NULL,NULL),('chatroom','ilias_chatserver_connection','en','ILIAS to Server Connection',NULL,NULL),('chatroom','ilias_proxy_info','en','If the Server is not accessible with the default IP-Address and Port, it is possible to configure a custom URL for ILIAS to Server connection.',NULL,NULL),('chatroom','invite_to_private_room','en','Invite to Chat Room',NULL,NULL),('chatroom','invite_username','en','Username',NULL,NULL),('chatroom','key','en','Key',NULL,NULL),('chatroom','kicked','en','You have been kicked from this chat room.',NULL,NULL),('chatroom','kick_question','en','Do you really want to kick the user from chat?',NULL,NULL),('chatroom','lost_connection','en','The connection to the chat server was interrupted.',NULL,NULL),('chatroom','main','en','Main Room',NULL,NULL),('chatroom','messages','en','Messages',NULL,NULL),('chatroom','no_further_users','en','No other users present.',NULL,NULL),('chatroom','no_messages','en','There are no saved messages for the given period.',NULL,NULL),('chatroom','no_username_given','en','Please choose a username',NULL,NULL),('chatroom','osc_browser_noti_no_permission_error','en','Please remove this domain from the list of blocked domains in the notification settings of your browser or operating system. Otherwise you will not be able to receive browser notifications.',NULL,NULL),('chatroom','osc_browser_noti_no_support_error','en','Browser notifications are not supported in your browser. Please ensure you are requesting ILIAS via HTTPS and use a <a href=\"https://caniuse.com/#feat=notifications\" target=\"_blank\" rel=\"noopener noreferrer\">supported browser</a>.',NULL,NULL),('chatroom','osc_browser_noti_req_permission_error','en','The browser notifications could not be enabled because you did not grant access. Please remove this domain from the list of blocked domains in the notification settings of your browser or operating system.',NULL,NULL),('chatroom','osc_enable_browser_notifications_info','en','If enabled, a browser notification will be shown if you receive new messages and conversations when the ILIAS browser tab is in background, or if the browser is hidden. You will also receive a browser notification for new messages in a conversation after %s minute(s) of idling if the ILIAS tab is in foreground.',NULL,NULL),('chatroom','osc_enable_browser_notifications_label','en','Browser Notifications',NULL,NULL),('chatroom','osc_noti_title','en','New Chat Message',NULL,NULL),('chatroom','period','en','Period',NULL,NULL),('chatroom','permissions','en','Permissions',NULL,NULL),('chatroom','preferred_chatname','en','Preferred Name',NULL,NULL),('chatroom','public_chat_created','en','The public chat room has been added to the repository.',NULL,NULL),('chatroom','scope','en','Room',NULL,NULL),('chatroom','select_custom_username','en','Select Custom Username',NULL,NULL),('chatroom','server_further_information','en','You can find further information about the server configuration in the readme file.',NULL,NULL),('chatroom','server_readme_file_btn_label','en','Readme File',NULL,NULL),('chatroom','session','en','Session',NULL,NULL),('chatroom','settings_general','en','General',NULL,NULL),('chatroom','settings_title','en','Settings',NULL,NULL),('chatroom','start_private_chat','en','Start Private Chat',NULL,NULL),('chatroom','unable_to_connect','en','The connection to the chat server could not be established.',NULL,NULL),('chatroom','unban','en','Unban',NULL,NULL),('chatroom','users','en','Users',NULL,NULL),('chatroom','user_banned','en','The user #user# has been banned.',NULL,NULL),('chatroom','user_invited','en','The user has been invited.',NULL,NULL),('chatroom','user_invited_self','en','#user# invited you to the chat room #room#.',NULL,NULL),('chatroom','user_in_ilias','en','Search and invite user from ILIAS',NULL,NULL),('chatroom','user_in_room','en','Invite user from current chat room',NULL,NULL),('chatroom','user_kicked','en','The user #user# has been kicked.',NULL,NULL),('chatroom','welcome_to_chat','en','Welcome to the chat room.',NULL,NULL),('chatroom','write_message','en','New Message',NULL,NULL),('chatroom_adm','chatserver_settings_title','en','Chatserver Settings',NULL,NULL),('chatroom_adm','chat_cannot_connect_to_server','en','ILIAS cannot build a socket connection to the chat server.',NULL,NULL),('chatroom_adm','chat_enabled','en','Enable Chat',NULL,NULL),('chatroom_adm','client_settings','en','General Settings',NULL,NULL),('chatroom_adm','general_settings_title','en','General Chat Settings',NULL,NULL),('chatroom_adm','https','en','HTTPS',NULL,NULL),('chatroom_adm','osc_adm_browser_noti_info','en','If enabled, users may individually decide whether or not they want to receive browser notifications for new conversations and messages. Notifications are triggered if the user works in different browser tabs or the browser is hidden and ILIAS was put into the background. Users will also receive browser notifications after a certain idle time in a conversation if ILIAS is in the foreground.',NULL,NULL),('chatroom_adm','osc_adm_browser_noti_label','en','Browser Notifications',NULL,NULL),('chatroom_adm','osc_adm_conv_idle_state_threshold_info','en','Cut off notifications by given a minimum interval at which browser notifications are triggered for incoming chat messages..',NULL,NULL),('chatroom_adm','osc_adm_conv_idle_state_threshold_label','en','Time between Browser Notifications',NULL,NULL),('chatroom_adm','port_info','en','Rarely used ports are often blocked by firewalls or proxy servers. The user\'s browser will not be able to establish a connection to the chat server if the defined port is blocked.',NULL,NULL),('chatroom_adm','protocol','en','Protocol',NULL,NULL),('chatroom_adm','public_chat_permissions','en','Public Chat Room Permissions',NULL,NULL),('chatroom_adm','public_chat_settings','en','Public Chat Room Settings',NULL,NULL),('chatroom_adm','server_settings','en','Chatserver Settings',NULL,NULL),('chatroom_adm','settings_has_been_saved','en','Settings has been saved',NULL,NULL),('classification','clsfct_back_to_cat','en','Back to Category',NULL,NULL),('classification','clsfct_block_info','en','Your Selection filters the objects.',NULL,NULL),('classification','clsfct_block_title','en','Selection by Topics',NULL,NULL),('classification','clsfct_content_no_match','en','No objects match your selected criteria.',NULL,NULL),('classification','clsfct_content_title','en','Objects matching your selection',NULL,NULL),('classification','clsfct_selected_objects','en','Selected Objects',NULL,NULL),('cmix','achieved_info','en','Successfully bring about or reach a desired objective, level, or result by effort, skill, or courage.',NULL,NULL),('cmix','achieved_label','en','Statements with the verb \'achieved\'',NULL,NULL),('cmix','activity_id','en','Activity-ID',NULL,NULL),('cmix','activity_id_info','en','This ID is primarily used for the display of data from the LRS. You receive this ID from the resource provider.',NULL,NULL),('cmix','answered_info','en','Indicates the actor replied to a question, where the object is generally an activity representing the question. The text of the answer will often be included in the response inside result.',NULL,NULL),('cmix','answered_label','en','Statements with the verb \'answered\'',NULL,NULL),('cmix','btn_change_registration','en','Submit',NULL,NULL),('cmix','btn_create_lrs_type','en','Add LRS Type',NULL,NULL),('cmix','btn_create_registration','en','Submit',NULL,NULL),('cmix','change_registration','en','E-Mail address for Registration',NULL,NULL),('cmix','cmiexit','en','You can now close the window.',NULL,NULL),('cmix','cmix_add','en','Add xAPI/cmi5 Object',NULL,NULL),('cmix','cmix_add_cmi5_lm','en','cmi5 Learning Module',NULL,NULL),('cmix','cmix_add_cmi5_lm_info','en','This option should be used when the content is a cmi5 compliant learning module. Related features like suitable reportings are available without further configurations.',NULL,NULL),('cmix','cmix_add_lrs_type','en','LRS Type',NULL,NULL),('cmix','cmix_add_lrs_type_info','en','These Types of Learning Record Stores have been made available in the ILIAS Administration.',NULL,NULL),('cmix','cmix_add_source','en','Source',NULL,NULL),('cmix','cmix_add_source_external_app','en','Resource not launched by ILIAS',NULL,NULL),('cmix','cmix_add_source_external_app_info','en','Use this option for separately launched resources as e.g. apps or simulations. Users must agree to the fetching of data.',NULL,NULL),('cmix','cmix_add_source_local_dir','en','Local Directory',NULL,NULL),('cmix','cmix_add_source_local_dir_info','en','Use this option for content packages on your local device.',NULL,NULL),('cmix','cmix_add_source_upload_dir','en','Upload Directory',NULL,NULL),('cmix','cmix_add_source_upload_dir_info','en','Use this option for content packages already uploaded into the ILIAS upload directory which is also used for SCORM and HTML packages.',NULL,NULL),('cmix','cmix_add_source_upload_select','en','--- Please select ---',NULL,NULL),('cmix','cmix_add_source_url','en','Resource URL',NULL,NULL),('cmix','cmix_add_source_url_info','en','Use this option for an external resource.',NULL,NULL),('cmix','cmix_add_xapi_standard_object','en','xAPI Standard Object',NULL,NULL),('cmix','cmix_add_xapi_standard_object_info','en','Use this option to have a generic content module offering all features like different reportings. This option comes with the greatest possible flexibility but requires a more complex configuration.',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_answered','en','Answered',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_asked','en','Asked',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_attempted','en','Attempted',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_attended','en','Attended',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_commented','en','Commented',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_completed','en','Completed',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_exited','en','Exited',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_experienced','en','Experienced',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_failed','en','Failed',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_imported','en','Imported',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_initialized','en','Initialized',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_interacted','en','Interacted',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_launched','en','Launched',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_mastered','en','Mastered',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_passed','en','Passed',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_preferred','en','Preferred',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_progressed','en','Progressed',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_registered','en','Registered',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_responded','en','Responded',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_resumed','en','Resumed',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_scored','en','Scored',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_shared','en','Shared',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_suspended','en','Suspended',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_terminated','en','Terminated',NULL,NULL),('cmix','cmix_adlnetgov_expapi_verbs_voided','en','Voided',NULL,NULL),('cmix','cmix_all_verbs','en','All Verbs',NULL,NULL),('cmix','cmix_copy','en','Copy xAPI/cmi5 Object',NULL,NULL),('cmix','cmix_import','en','Import xAPI/cmi5 Object',NULL,NULL),('cmix','cmix_indication_to_user','en','Further Hints for this LRS',NULL,NULL),('cmix','cmix_info_external_lrs_info','en','This Learning Record Store is an external LRS. An external LRS is characterized by insufficient influence on the LRS by the operator of the ILIAS-Installation. This is the case e.g. if there are no rights to delete data.',NULL,NULL),('cmix','cmix_info_external_lrs_label','en','Additional Info about this LRS',NULL,NULL),('cmix','cmix_info_privacy_section','en','Info about personal data',NULL,NULL),('cmix','cmix_info_privacy_section_launch','en','Info about personal data transmitted at launch',NULL,NULL),('cmix','cmix_lrs_type','en','Learning Record Store (LRS)',NULL,NULL),('cmix','cmix_new','en','New xAPI/cmi5 Object',NULL,NULL),('cmix','completed_info','en','Indicates the actor finished or concluded the activity normally.',NULL,NULL),('cmix','completed_label','en','Statements with the verb \'completed\'',NULL,NULL),('cmix','conf_availability','en','Availability',NULL,NULL),('cmix','conf_availability_0','en','Not available',NULL,NULL),('cmix','conf_availability_0_info','en','Existing xAPI/cmi5 objects that use this LRS type can no longer be used.',NULL,NULL),('cmix','conf_availability_1','en','Existing ones allowed',NULL,NULL),('cmix','conf_availability_1_info','en','This LRS type is not offered when creating new xAPI/cmi5 objects. Existing xAPI/cmi5 objects that use this type can continue to write or read data. Use this option to be able to delete data in the connected LRS at a later time.',NULL,NULL),('cmix','conf_availability_2','en','New producible',NULL,NULL),('cmix','conf_availability_2_info','en','This LRS type can be selected when creating xAPI/cmi5 objects.',NULL,NULL),('cmix','conf_bypass_proxy','en','Detection of Learning Progress',NULL,NULL),('cmix','conf_bypass_proxy_disabled','en','xAPI-Proxy to get immediately data',NULL,NULL),('cmix','conf_bypass_proxy_enabled','en','CronJob to check Learning Record Store',NULL,NULL),('cmix','conf_bypass_proxy_info','en','In most cases it is recommended to use the xAPI-Proxy. Use the CronJob in case of Limitations regarding Resource or Server.',NULL,NULL),('cmix','conf_cronjob_neccessary','en','CronJob necessary for Learning Progress',NULL,NULL),('cmix','conf_cronjob_neccessary_info','en','By activating this option, xAPI-Objects using this LRS type could not use the xAPI-Proxy to get immediately data for Detection of Learning Progress. Use only the CronJob in case of limitations regarding resources or server.',NULL,NULL),('cmix','conf_delete_data','en','Delete Data in LRS',NULL,NULL),('cmix','conf_delete_data_info','en','Deletion is currently only possible with the Learning Record Store (LRS) LearningLocker. Only use the options for deleting the user identification if the data has been pseudonymized in the LRS.',NULL,NULL),('cmix','conf_delete_data_opt0','en','Never',NULL,NULL),('cmix','conf_delete_data_opt1','en','Never - but if users are deleted and if xAPI/cmi objects are moved to the trash or deleted, data will no longer be assignable for ILIAS by deleting the - user identification',NULL,NULL),('cmix','conf_delete_data_opt11','en','When users are deleted and when xAPI/cmi objects are moved to the trash or deleted',NULL,NULL),('cmix','conf_delete_data_opt12','en','Additionally when users are removed from courses or groups',NULL,NULL),('cmix','conf_delete_data_opt2','en','Never - but additionally when users are removed from courses or groups, data will no longer be assignable for ILIAS by deleting the user identification',NULL,NULL),('cmix','conf_description','en','Description',NULL,NULL),('cmix','conf_external_lrs','en','External LRS',NULL,NULL),('cmix','conf_keep_lp','en','Keep Learning Progress',NULL,NULL),('cmix','conf_keep_lp_info','en','The ILIAS learning progress status completed would be freezed.',NULL,NULL),('cmix','conf_launch_mode','en','Launch Mode',NULL,NULL),('cmix','conf_launch_mode_browse','en','Browse',NULL,NULL),('cmix','conf_launch_mode_browse_info','en','This option should provide a user experience that allows the user to \"look around\" without judgement.',NULL,NULL),('cmix','conf_launch_mode_normal','en','Normal',NULL,NULL),('cmix','conf_launch_mode_normal_info','en','Data related to the learning progress should be recorded.',NULL,NULL),('cmix','conf_launch_mode_review','en','Review',NULL,NULL),('cmix','conf_launch_mode_review_info','en','This option should provide a user experience that allows the user to \"revisit / review\" already completed material.',NULL,NULL),('cmix','conf_lrs_endpoint','en','Endpoint',NULL,NULL),('cmix','conf_lrs_key','en','Key / Login',NULL,NULL),('cmix','conf_lrs_secret','en','Secret / Password',NULL,NULL),('cmix','conf_new_window','en','New Window',NULL,NULL),('cmix','conf_new_window_info','en','The content is opened in a new window. When leaving the content this window gets closed.',NULL,NULL),('cmix','conf_own_window','en','Own Window',NULL,NULL),('cmix','conf_own_window_info','en','The content is opened in the same window and replaces the ILIAS Screen. When leaving the content the user returns to ILIAS.',NULL,NULL),('cmix','conf_privacy_comment_default','en','Indication to User',NULL,NULL),('cmix','conf_privacy_ident','en','User Identification',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_ext_account','en','External User ID combined with a unique ILIAS platform id formatted as an E-Mail address',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_ext_account_info','en','This is identical to each call, but may allow a direct conclusion about the user.',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_login','en','ILIAS Login combined with a unique ILIAS platform id formatted as an E-Mail address',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_login_info','en','Sends the login name. This is identical to each call, but may allow a direct conclusion about the ILIAS user.',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_random','en','Random ID combined with a unique ILIAS platform ID formatted as an E-Mail address',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_random_info','en','For each ILIAS object and ILIAS user a random ID is generated which remains identical for each call. Conclusions about a user are very limited because it is practically impossible to create user profiles across objects.',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_sha256','en','Hash combined with a unique ILIAS platform id formatted as an E-Mail address',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_sha256url','en','Hash combined with the ILIAS Domain formatted as an E-Mail address',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_sha256url_info','en','This is identical to each call, with with a maximum of 80 characters significantly shorter than the variant with the ILIAS platform ID and allows only very limited conclusions about the ILIAS user.',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_sha256_info','en','This is identical to each call, but does not permit any direct conclusions about the ILIAS user.',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_user_id','en','ILIAS user id combined with a unique ILIAS platform id formatted as an E-Mail address',NULL,NULL),('cmix','conf_privacy_ident_il_uuid_user_id_info','en','Sends the internal numeric user id. This is identical to each call, but may allow conclusions about the ILIAS user.',NULL,NULL),('cmix','conf_privacy_ident_info','en','Standard is frequently the E-Mail address. The unique ILIAS platform id is:',NULL,NULL),('cmix','conf_privacy_ident_real_email','en','E-Mail Address',NULL,NULL),('cmix','conf_privacy_ident_real_email_info','en','Sends E-Mail Address of user as identification (Warning: an E-Mail Address might be used by multiple users!)',NULL,NULL),('cmix','conf_privacy_name','en','User name',NULL,NULL),('cmix','conf_privacy_name_firstname','en','First name',NULL,NULL),('cmix','conf_privacy_name_firstname_info','en','Sends the first name of the user name from ILIAS',NULL,NULL),('cmix','conf_privacy_name_fullname','en','Entire name',NULL,NULL),('cmix','conf_privacy_name_fullname_info','en','Sends title, first name and last name',NULL,NULL),('cmix','conf_privacy_name_info','en','Sending an user name is usually not required.',NULL,NULL),('cmix','conf_privacy_name_lastname','en','Title and last name',NULL,NULL),('cmix','conf_privacy_name_lastname_info','en','Sends Mister or Ms/Mrs. (unless otherwise specified) and the last name',NULL,NULL),('cmix','conf_privacy_name_none','en','No one',NULL,NULL),('cmix','conf_privacy_name_none_info','en','Sends \'-\' instead of a name',NULL,NULL),('cmix','conf_privacy_setting_conf','en','Configuration Options',NULL,NULL),('cmix','conf_privacy_setting_default','en','Default Settings, changeable for Objects',NULL,NULL),('cmix','conf_privacy_setting_force','en','Settings are not changeable for Objects',NULL,NULL),('cmix','conf_privacy_setting_info','en','Configuration Options for Privacy Settings',NULL,NULL),('cmix','conf_remarks','en','Internal comments',NULL,NULL),('cmix','conf_title','en','Title',NULL,NULL),('cmix','conf_user_ident','en','User identification',NULL,NULL),('cmix','conf_user_ident_il_uuid_ext_account','en','External User ID combined with a unique ILIAS platform id formatted as an E-Mail adress',NULL,NULL),('cmix','conf_user_ident_il_uuid_ext_account_info','en','This is identical to each call, but may allow a direct conclusion about the user.',NULL,NULL),('cmix','conf_user_ident_il_uuid_login','en','ILIAS Login combined with a unique ILIAS platform id formatted as an E-Mail adress',NULL,NULL),('cmix','conf_user_ident_il_uuid_login_info','en','This is identical to each call, but may allow a direct conclusion about the ILIAS user.',NULL,NULL),('cmix','conf_user_ident_il_uuid_random','en','Random ID combined with a unique ILIAS platform ID formatted as an E-Mail address',NULL,NULL),('cmix','conf_user_ident_il_uuid_random_info','en','For each ILIAS object and ILIAS user a random ID is generated which remains identical for each call. Conclusions about a user are very limited because it is practically impossible to create user profiles across objects.',NULL,NULL),('cmix','conf_user_ident_il_uuid_user_id','en','ILIAS user id combined with a unique ILIAS platform id formatted as an E-Mail adress',NULL,NULL),('cmix','conf_user_ident_il_uuid_user_id_info','en','This is identical to each call, but doesn\'t allow a direct conclusion about the ILIAS user.',NULL,NULL),('cmix','conf_user_ident_info','en','Standard is frequently the email address. The unique ILIAS platform id is:',NULL,NULL),('cmix','conf_user_ident_real_email','en','E-Mail Address',NULL,NULL),('cmix','conf_user_ident_real_email_info','en','Sends E-Mail Address of user as identification (Warning: an E-Mail Address might be used by multiple users!)',NULL,NULL),('cmix','conf_user_name','en','User Name',NULL,NULL),('cmix','conf_user_name_firstname','en','First Name',NULL,NULL),('cmix','conf_user_name_firstname_info','en','Sends the first name of the user name from ILIAS',NULL,NULL),('cmix','conf_user_name_fullname','en','Entire Name',NULL,NULL),('cmix','conf_user_name_fullname_info','en','Sends title, first name and last name',NULL,NULL),('cmix','conf_user_name_info','en','Sending an user name is usually not required.',NULL,NULL),('cmix','conf_user_name_lastname','en','Title and Last Name',NULL,NULL),('cmix','conf_user_name_lastname_info','en','Sends Mister or Ms/Mrs. (unless otherwise specified) and the last name',NULL,NULL),('cmix','conf_user_name_none','en','No one',NULL,NULL),('cmix','conf_user_name_none_info','en','Sends \'-\' instead of a name',NULL,NULL),('cmix','conf_user_registered_mail','en','Registered E-Mail-Address',NULL,NULL),('cmix','conf_use_proxy','en','xAPI-Proxy',NULL,NULL),('cmix','conf_use_proxy_info','en','The xAPI proxy provides real-time data to determine learning progress in ILIAS. The proxy reduces personal data in accordance with the selected data protection options. If the xAPI proxy is deactivated, the learning content writes the learning progress directly to the LRS. This data must then also be retrieved directly from the LRS. The cron job \"xAPI/cmi5 get results\" is required to determine the learning progress. The xAPI proxy is mandatory for cmi5 objects and is activated automatically.',NULL,NULL),('cmix','conf_use_proxy_info_cmi5','en','The xAPI proxy provides real-time data to determine learning progress in ILIAS. The proxy reduces personal data in accordance with the selected data protection options. The xAPI proxy is mandatory for cmi5 objects.',NULL,NULL),('cmix','conf_use_proxy_info_xapi','en','The xAPI proxy provides real-time data to determine learning progress in ILIAS. The proxy reduces personal data in accordance with the selected data protection options. If the xAPI proxy is deactivated, the learning content writes the learning progress directly to the LRS. This data must then also be retrieved directly from the LRS. The cron job \"xAPI/cmi5 get results\" is required to determine the learning progress.',NULL,NULL),('cmix','content_privacy_ident','en','User identification for resource',NULL,NULL),('cmix','content_privacy_name','en','User name for resource',NULL,NULL),('cmix','create_lrs_type_form','en','New LRS Type',NULL,NULL),('cmix','create_registration','en','Register your E-Mail address',NULL,NULL),('cmix','cron_xapi_del','en','Delete xAPI/cmi5 data in the Learning Record Store',NULL,NULL),('cmix','cron_xapi_del_desc','en','Data is deleted according to the settings of the xAPI/cmi5 objects.',NULL,NULL),('cmix','cron_xapi_results_evaluation','en','Fetch xAPI/cmi5 Results',NULL,NULL),('cmix','cron_xapi_results_evaluation_desc','en','Requests all xAPI results from learning record stores for objects not supporting the ILIAS xAPI proxy.',NULL,NULL),('cmix','description_info','en','The description will be shown below the title.',NULL,NULL),('cmix','download_certificate','en','Download Certificate',NULL,NULL),('cmix','duration_info','en','The duration can be entered e.g. for answering a task. The duration is set to the default value 0 seconds (PT00.000S) by this option.',NULL,NULL),('cmix','duration_label','en','Duration',NULL,NULL),('cmix','edit_lrs_type_form','en','LRS Type',NULL,NULL),('cmix','failed_info','en','Indicates the actor did not successfully pass an activity to a level of predetermined satisfaction.',NULL,NULL),('cmix','failed_label','en','Statements with the verb \'failed\'',NULL,NULL),('cmix','fetch_xapi_statements','en','Fetch results from Learning Record Store',NULL,NULL),('cmix','field_user_ident','en','E-Mail-Address',NULL,NULL),('cmix','field_user_ident_info','en','Enter the e-mail address used in the external application to identify you.',NULL,NULL),('cmix','form_change_registration','en','Registration',NULL,NULL),('cmix','form_create_registration','en','Registration',NULL,NULL),('cmix','hide_data_info','en','With this option which is only available for the ILIAS LRS proxy certain data is stored in statements with unrecognizable values in the Learning Record Store.',NULL,NULL),('cmix','hide_data_label','en','Blacken data',NULL,NULL),('cmix','highscore_achieved_ts','en','Date',NULL,NULL),('cmix','highscore_achieved_ts_description','en','A column containing the date will be included in the ranking.',NULL,NULL),('cmix','highscore_all_tables','en','Participant\'s Own Rank and Top Ranking',NULL,NULL),('cmix','highscore_all_tables_description','en','Participants get information about the top ranking and their own position in the ranking.',NULL,NULL),('cmix','highscore_description','en','The names of other users could be displayed if the right \'View learning experiences of other users\' is set.',NULL,NULL),('cmix','highscore_enabled','en','Ranking',NULL,NULL),('cmix','highscore_mode','en','Mode',NULL,NULL),('cmix','highscore_own_table','en','Participant\'s Own Rank',NULL,NULL),('cmix','highscore_own_table_description','en','Participants are advised of their own position in the ranking.',NULL,NULL),('cmix','highscore_percentage','en','Percentage',NULL,NULL),('cmix','highscore_percentage_description','en','A column containing the score as percentage will be included in the ranking.',NULL,NULL),('cmix','highscore_score','en','Score',NULL,NULL),('cmix','highscore_score_description','en','A column containing the score will be included in the ranking.',NULL,NULL),('cmix','highscore_top_num','en','Length of Top Ranking',NULL,NULL),('cmix','highscore_top_num_description','en','Specify how many ranks are to be included in the top ranking list.',NULL,NULL),('cmix','highscore_top_num_unit','en','entries',NULL,NULL),('cmix','highscore_top_table','en','Top Ranking',NULL,NULL),('cmix','highscore_top_table_description','en','Participants are presented with a table containing the top rankings.',NULL,NULL),('cmix','highscore_wtime','en','Duration',NULL,NULL),('cmix','highscore_wtime_description','en','A column containing the duration will be included in the ranking.',NULL,NULL),('cmix','info_availability','en','Hereby you can operate the availability of the LRS type within the magazine. All types can set on \"allow existing ones\" instead of being deleted.',NULL,NULL),('cmix','info_description','en','This description will be shown when choosing the type for new objects.',NULL,NULL),('cmix','info_external_lrs','en','A hint will be shown to users when dealing with an external LRS. An external LRS is characterized by insufficient influence on the LRS the by the operator of the ILIAS-installation. This is the case when there are no rights to delete.',NULL,NULL),('cmix','info_lrs_endpoint','en','URL of the endpoint without \'/\' at the end',NULL,NULL),('cmix','info_lrs_key','en','Key or login for access, i.e. 12345',NULL,NULL),('cmix','info_lrs_secret','en','Shared secret / Password, i.e. secret',NULL,NULL),('cmix','info_privacy_comment_default','en','Please insert, if required, an additional indication on data security when using this LRS.',NULL,NULL),('cmix','info_remarks','en','Place to write down your comments on this LRS type here.',NULL,NULL),('cmix','info_title','en','This title will be shown when choosing the type for new objects.',NULL,NULL),('cmix','initialized_info','en','Indicates the activity provider has determined that the actor successfully started an activity.',NULL,NULL),('cmix','initialized_label','en','Statements with the verb \'initialized\'',NULL,NULL),('cmix','launch_options','en','Options for Launch',NULL,NULL),('cmix','launch_url','en','URL of the resource',NULL,NULL),('cmix','launch_url_info','en','Insert here the Internet address by adding http:// or https:// . Options for data security are also relevant for remote resources.',NULL,NULL),('cmix','log_options','en','Options for the display of transmitted data',NULL,NULL),('cmix','lrs_authentication','en','Authentication',NULL,NULL),('cmix','lrs_type_not_avail_msg','en','This LRS Type is not available.',NULL,NULL),('cmix','no_substatements_info','en','With this option - which is only available for the ILIAS LRS proxy - the storage of subordinate statements can be suppressed. This can for example affect the answering of single tasks in a test. The content is informed that the statements would have been saved.',NULL,NULL),('cmix','no_substatements_label','en','Do not store substatements',NULL,NULL),('cmix','online_info','en','This makes the object visible and usable for the users.',NULL,NULL),('cmix','only_moveon_info','en','With this option, which is only available for the ILIAS LRS proxy, only statements with defined verbs are stored in the Learning Record Store (WhiteList). The content is informed that the statements would have been saved. This usually ensures the expiration date but should be discussed with the content provider.',NULL,NULL),('cmix','only_moveon_label','en','Save learning success data only',NULL,NULL),('cmix','passed_info','en','Indicates the actor successfully passed an activity to a level of predetermined satisfaction.',NULL,NULL),('cmix','passed_label','en','Statements with the verb \'passed\'',NULL,NULL),('cmix','privacy_options','en','Options for data security',NULL,NULL),('cmix','progressed_info','en','Indicates a value of how much of an actor has advanced or moved through an activity.',NULL,NULL),('cmix','progressed_label','en','Statements with the verb \'progressed\'',NULL,NULL),('cmix','registration_saved_successfully','en','Saved successfully',NULL,NULL),('cmix','satisfied_info','en','Indicates that the authority or activity provider determined the actor has fulfilled the criteria of the object or activity.',NULL,NULL),('cmix','satisfied_label','en','Statements with the verb \'satisfied\'',NULL,NULL),('cmix','sect_learning_progress_options','en','Options for Learning Progress',NULL,NULL),('cmix','show_debug','en','Display Learning Experiences',NULL,NULL),('cmix','show_debug_info','en','Shows tab ‘Learning Experiences’ with information about own interaction with cmi5 module. Data of other users is displayed if permission ‘View learning experiences of other users’ is given.',NULL,NULL),('cmix','tab_export','en','Export',NULL,NULL),('cmix','tab_info','en','Info',NULL,NULL),('cmix','tab_lrs_types','en','LRS Types',NULL,NULL),('cmix','tab_scoring','en','Ranking',NULL,NULL),('cmix','tab_settings','en','Settings',NULL,NULL),('cmix','tab_statements','en','Learning Experiences',NULL,NULL),('cmix','tbl_action_raw_data','en','View Raw Data',NULL,NULL),('cmix','tbl_lrs_types_header','en','LRS Types',NULL,NULL),('cmix','tbl_lrs_type_availability','en','Availability',NULL,NULL),('cmix','tbl_lrs_type_title','en','Title',NULL,NULL),('cmix','tbl_lrs_type_usages','en','Usages Count',NULL,NULL),('cmix','tbl_statements_actor','en','User',NULL,NULL),('cmix','tbl_statements_date','en','Date',NULL,NULL),('cmix','tbl_statements_object','en','Object',NULL,NULL),('cmix','tbl_statements_verb','en','Verb',NULL,NULL),('cmix','terminated_info','en','Indicates that the actor successfully ended an activity.',NULL,NULL),('cmix','terminated_label','en','Statements with the verb \'terminated\'',NULL,NULL),('cmix','timestamp_info','en','The timestamp marks the time of an action indicated by the statement. The timestamp is set to the default value 01.01.1970 (1970-01-01T00:00:00.000Z) by this option. Please note that a Learning Record Store may automatically set a value for the stored date, which can be almost identical to the timestamp.',NULL,NULL),('cmix','timestamp_label','en','Timestamp',NULL,NULL),('cmix','title_info','en','Give the object a title.',NULL,NULL),('cmix','type_cmi5','en','cmi5 Learning Module',NULL,NULL),('cmix','type_generic','en','xAPI Standard Object',NULL,NULL),('cmix','use_fetch','en','Authorization through Fetch-URL',NULL,NULL),('cmix','use_fetch_info','en','As long as the resource supports this option, you should use this option to increase data security.',NULL,NULL),('cmix','xapi_statements_fetched_successfully','en','Results from Learning Record Store were fetched successfully',NULL,NULL),('cmix','xapi_statements_last_fetch_date','en','Last fetch of Results:',NULL,NULL),('cmix','xapi_statements_not_fetched_yet','en','Results from Learning Record Store are not fetched yet',NULL,NULL),('cmps','cmps_activate','en','Activate',NULL,NULL),('cmps','cmps_active','en','Active',NULL,NULL),('cmps','cmps_add_new_rank','en','Position in Add-New-Object List',NULL,NULL),('cmps','cmps_available','en','Available',NULL,NULL),('cmps','cmps_available_version','en','Available Version',NULL,NULL),('cmps','cmps_basic_files','en','Basic Files',NULL,NULL),('cmps','cmps_class_file','en','Class File',NULL,NULL),('cmps','cmps_component','en','Component',NULL,NULL),('cmps','cmps_configure','en','Configure',NULL,NULL),('cmps','cmps_current_db_version','en','Current DB-Version',NULL,NULL),('cmps','cmps_current_version','en','Current Version',NULL,NULL),('cmps','cmps_database','en','Database',NULL,NULL),('cmps','cmps_db_update','en','DB Update Script',NULL,NULL),('cmps','cmps_deactivate','en','Deactivate',NULL,NULL),('cmps','cmps_detailed_information','en','Detailed Informationen',NULL,NULL),('cmps','cmps_dir','en','Directory',NULL,NULL),('cmps','cmps_enable_creation','en','Enable Creation',NULL,NULL),('cmps','cmps_file_version','en','Update File Version',NULL,NULL),('cmps','cmps_group','en','Group',NULL,NULL),('cmps','cmps_id','en','ID',NULL,NULL),('cmps','cmps_ilias_max_version','en','Max. ILIAS Version',NULL,NULL),('cmps','cmps_ilias_min_version','en','Min. ILIAS Version',NULL,NULL),('cmps','cmps_inactive','en','Inactive',NULL,NULL),('cmps','cmps_install','en','Install',NULL,NULL),('cmps','cmps_is_active','en','Activated',NULL,NULL),('cmps','cmps_is_installed','en','Installed',NULL,NULL),('cmps','cmps_languages','en','Languages',NULL,NULL),('cmps','cmps_lang_files','en','Language Files',NULL,NULL),('cmps','cmps_lang_prefix','en','Language Variables Prefix',NULL,NULL),('cmps','cmps_main_dir','en','Main Directory',NULL,NULL),('cmps','cmps_missing','en','Missing',NULL,NULL),('cmps','cmps_module','en','Module',NULL,NULL),('cmps','cmps_must_installed','en','The component must be installed.',NULL,NULL),('cmps','cmps_name','en','Name',NULL,NULL),('cmps','cmps_needs_matching_ilias_version','en','This plugin does not work with your current ILIAS version.',NULL,NULL),('cmps','cmps_needs_newer_ilias_version','en','This plugin version only runs on newer ILIAS versions. Please upgrade ILIAS.',NULL,NULL),('cmps','cmps_needs_newer_plugin_version','en','This ILIAS version needs a newer plugin version. Please upgrade the plugin.',NULL,NULL),('cmps','cmps_needs_update','en','Needs update.',NULL,NULL),('cmps','cmps_needs_upgrade','en','The plugin version currently installed is older than a previously installed version. Please upgrade the plugin.',NULL,NULL),('cmps','cmps_no_db_update_file_available','en','No DB update script available.',NULL,NULL),('cmps','cmps_no_language_file_available','en','No language file available.',NULL,NULL),('cmps','cmps_plugin','en','Plugin',NULL,NULL),('cmps','cmps_plugins','en','Plugins',NULL,NULL),('cmps','cmps_plugin_activated','en','The plugin has been activated.',NULL,NULL),('cmps','cmps_plugin_db_prefixes','en','DB Table Prefixes',NULL,NULL),('cmps','cmps_plugin_deactivated','en','The plugin has been deactivated.',NULL,NULL),('cmps','cmps_plugin_deinstalled','en','The plugin has been uninstalled',NULL,NULL),('cmps','cmps_plugin_file','en','Plugin File',NULL,NULL),('cmps','cmps_plugin_lang_prefixes','en','Plugin Language Prefixes',NULL,NULL),('cmps','cmps_plugin_slot','en','Plugin Slot',NULL,NULL),('cmps','cmps_plugin_uninstalled','en','All language and database related entries have been deleted and the plugin has been set inactive. Now you can remove the plugin\'s directory and source code in the ‘Customizing’ directory to uninstall the plugin definitely.',NULL,NULL),('cmps','cmps_plugin_updated','en','The plugin has been updated',NULL,NULL),('cmps','cmps_refresh','en','Refresh Languages',NULL,NULL),('cmps','cmps_refresh_lng','en','Refresh language',NULL,NULL),('cmps','cmps_repository_object_types','en','Repository Object Types',NULL,NULL),('cmps','cmps_rep_object','en','Repository Object Type',NULL,NULL),('cmps','cmps_responsible','en','Responsible',NULL,NULL),('cmps','cmps_responsible_mail','en','Mail (Responsible)',NULL,NULL),('cmps','cmps_save_options','en','Save',NULL,NULL),('cmps','cmps_service','en','Service',NULL,NULL),('cmps','cmps_show_details','en','Show Details',NULL,NULL),('cmps','cmps_slots','en','Slots',NULL,NULL),('cmps','cmps_status','en','Status',NULL,NULL),('cmps','cmps_supports_cli_setup','en','Supports CLI-Setup',NULL,NULL),('cmps','cmps_supports_export','en','Supports export',NULL,NULL),('cmps','cmps_supports_learning_progress','en','Supports learning progress',NULL,NULL),('cmps','cmps_uninstall','en','Uninstall',NULL,NULL),('cmps','cmps_uninstall_confirm','en','Are you sure you want to uninstall the plugin \"%s\" and remove all related database entries?',NULL,NULL),('cmps','cmps_uninstall_inactive_confirm','en','The plugin \"%1$s\" can currently not be activated (\"%2$s\"). In this state plugins cannot be uninstalled completely. As only the core integration is reverted, plugin custom data may remain. Would you like to continue with the partial uninstall?',NULL,NULL),('cmps','cmps_update','en','Update',NULL,NULL),('cmps','cmps_version','en','Version',NULL,NULL),('cmps','database_is_uptodate','en','The database is up to date.',NULL,NULL),('cmps','no_changes','en','No changes',NULL,NULL),('cmxv','cmxv_create','en','Create Certificate for xAPI/cmi5 Object',NULL,NULL),('cmxv','cmxv_create_info','en','Select a completed xAPI/cmi5 object to generate a certificate for it',NULL,NULL),('cntr','cntr_add_new_item','en','Add New Object',NULL,NULL),('cntr','cntr_adopt_content','en','Adopt Content',NULL,NULL),('cntr','cntr_container_only_on_their_own','en','Categories, courses, groups, folders, learning sequences or study programmes can only be copied as single objects. Please select one item only.',NULL,NULL),('cntr','cntr_copy_crs_grp','en','My Courses and Groups',NULL,NULL),('cntr','cntr_copy_repo_tree','en','Repository Tree',NULL,NULL),('cntr','cntr_hide_title_and_icon','en','Hide Title and Icon',NULL,NULL),('cntr','cntr_manage','en','Manage',NULL,NULL),('cntr','cntr_ordering','en','Sorting',NULL,NULL),('cntr','cntr_saved_sorting','en','Saved Sorting.',NULL,NULL),('cntr','cntr_switched_editor','en','Switched to new content.',NULL,NULL),('cntr','cntr_switch_to_new_editor_cmd','en','Switch to new content of this page. Old content will be removed.',NULL,NULL),('cntr','cntr_switch_to_new_editor_message','en','This is the supported standard editor. The content from the old editor cannot be transferred. Please start adding new page content below. If you click the following link, the new content will be used.',NULL,NULL),('cntr','cntr_taxonomy_definitions','en','Taxonomy Definition',NULL,NULL),('cntr','cntr_taxonomy_show_sideblock','en','Present in Side Panel',NULL,NULL),('cntr','cntr_taxonomy_sideblock_settings','en','Presentation Settings',NULL,NULL),('cntr','cntr_tax_none_available','en','There are no taxonomies available.',NULL,NULL),('cntr','cntr_tax_settings_info','en','Taxonomies in categories classify and filter the objects contained in the category. After adding taxonomies, classifications can be made via the \"Metadata\" tabs and the \"Taxonomy Assignment\" sub-tabs of the respective objects. Taxonomies can additionally be displayed in the side block of the category\'s \"Contents\" tab to enable direct filtering of the assigned objects.',NULL,NULL),('cntr','cntr_text_media_editor','en','Edit Page',NULL,NULL),('cntr','cntr_view_by_type','en','Grouped-by-Type View',NULL,NULL),('cntr','cntr_view_info_by_type','en','This content presentation groups all items by resource type.',NULL,NULL),('cntr','cntr_view_info_sessions','en','This content presentation groups all sessions first. After that the other course content is listed.',NULL,NULL),('cntr','cntr_view_info_simple','en','This content presentation lists all items in one block.',NULL,NULL),('cntr','cntr_view_sessions','en','Sessions View',NULL,NULL),('cntr','cntr_view_simple','en','Simple View',NULL,NULL),('cntr','container_import_zip_file_invalid','en','The uploaded file is not a valid ILIAS export file. To upload a directory structure please use a file object.',NULL,NULL),('cntr','edit_questions','en','Edit Questions',NULL,NULL),('cntr','exc_next_deadline_single','en','Deadline',NULL,NULL),('cntr','msg_no_downloadable_objects','en','No downloadable objects found.',NULL,NULL),('cntr','objects_duplicated','en','Objects copied',NULL,NULL),('cntr','prtf_create_portfolio_from_template','en','Create Portfolio From Template',NULL,NULL),('cntr','sorting_new_items_at_bottom','en','Bottom',NULL,NULL),('cntr','sorting_new_items_at_top','en','Top',NULL,NULL),('cntr','sorting_new_items_direction','en','Sorting Direction for New Objects',NULL,NULL),('cntr','sorting_new_items_order','en','Arrangement of New Objects',NULL,NULL),('cntr','sorting_new_items_position','en','Position of New Objects',NULL,NULL),('cntr','tab_back_to_repository','en','Back to Repository',NULL,NULL),('common','absolute_path','en','Absolute Path',NULL,NULL),('common','accept_usr_agreement_btn','en','Accept',NULL,NULL),('common','access','en','Access',NULL,NULL),('common','accesscount_registered_users','en','Read by number of distinct ILIAS users',NULL,NULL),('common','accessFree','en','Remove \'Valid Until\' Date',NULL,NULL),('common','accessibility_control_concept','en','Accessibility',NULL,NULL),('common','accessRestrict','en','Set \'Valid Until\' Date',NULL,NULL),('common','access_expired','en','expired',NULL,NULL),('common','access_free_granted','en','Set the selected user(s) to unlimited access',NULL,NULL),('common','access_from','en','Access (from)',NULL,NULL),('common','access_public','en','Public',NULL,NULL),('common','access_restricted','en','Set the selected user(s) to limited access',NULL,NULL),('common','access_scope','en','Access',NULL,NULL),('common','access_unlimited','en','Unlimited',NULL,NULL),('common','access_until','en','Valid Until',NULL,NULL),('common','access_users','en','Logged in Users',NULL,NULL),('common','account','en','My Account',NULL,NULL),('common','account_expires_body','en','your account %s on %s will expire at %s. After this date, access to ILIAS with this account will no longer be possible. To save your personal documents and certificates, please download them in good time.',NULL,NULL),('common','account_expires_subject','en','Your ILIAS account will expire soon!',NULL,NULL),('common','action','en','Action',NULL,NULL),('common','actions','en','Actions',NULL,NULL),('common','actions_for','en','Actions for %s',NULL,NULL),('common','action_aborted','en','Action aborted',NULL,NULL),('common','activate','en','Set Active',NULL,NULL),('common','activate_https','en','HTTPS handling by ILIAS<br />(Login)',NULL,NULL),('common','activate_tracking','en','Activation',NULL,NULL),('common','activation','en','Edit Timings',NULL,NULL),('common','active','en','Active',NULL,NULL),('common','add','en','Add',NULL,NULL),('common','added_new_condition','en','Created new condition.',NULL,NULL),('common','additional_info','en','Additional Information',NULL,NULL),('common','address','en','Address',NULL,NULL),('common','add_condition','en','Add Precondition',NULL,NULL),('common','add_entry','en','Add/Edit entry',NULL,NULL),('common','add_member','en','Add Member',NULL,NULL),('common','add_member_role','en','Add Member Role',NULL,NULL),('common','add_new_user_defined_field','en','Add New Custom Field',NULL,NULL),('common','add_note','en','Add Note',NULL,NULL),('common','add_parameter','en','New Parameter',NULL,NULL),('common','add_remove_edit_entries_of_main_menu','en','Add, remove or edit entries of the main menu',NULL,NULL),('common','add_role','en','Add Role',NULL,NULL),('common','add_translation','en','Add translation',NULL,NULL),('common','add_user','en','Add Local User',NULL,NULL),('common','add_user_defined_field','en','Add New Field',NULL,NULL),('common','administrate_users','en','Local User Administration',NULL,NULL),('common','administrate_users_headline','en','Local ILIAS Accounts of this Category',NULL,NULL),('common','administration','en','Administration',NULL,NULL),('common','administrator','en','Administrator',NULL,NULL),('common','admin_force_noti','en','Notification active',NULL,NULL),('common','adopt','en','Adopt',NULL,NULL),('common','advanced_editing_allow_html_tags','en','Allow the selected HTML tags for text editing',NULL,NULL),('common','advanced_editing_assessment_settings','en','Allowed HTML Tags for the ILIAS Test and Assessment tool',NULL,NULL),('common','advanced_editing_frm_post_settings','en','Forum Post Settings',NULL,NULL),('common','advanced_editing_rep_page_editing','en','Enable Content Editing in Repository',NULL,NULL),('common','advanced_editing_rep_page_editing_desc','en','This feature allows adding text/media to pages of a category, course, group or folder. If deactivated, existing content will be hidden.',NULL,NULL),('common','advanced_editing_required_tags','en','The following HTML tags are required: %s',NULL,NULL),('common','advanced_editing_survey_settings','en','Allowed HTML Tags for the ILIAS survey tool',NULL,NULL),('common','adve_assessment_settings','en','Test and Assessment Settings',NULL,NULL),('common','adve_frm_post_settings','en','Forum Posts',NULL,NULL),('common','adve_general_settings','en','General Settings',NULL,NULL),('common','adve_survey_settings','en','Survey Settings',NULL,NULL),('common','agree_date','en','ToS agreed to on',NULL,NULL),('common','all','en','All',NULL,NULL),('common','allow_assign_users','en','Allow user assignment for local administrators.',NULL,NULL),('common','allow_override_alert','en','Rules for .htaccess are not interpreted correctly.',NULL,NULL),('common','allow_register','en','Available in registration form for new users',NULL,NULL),('common','allow_user_toggle_noti','en','Member is allowed to deactivate notification',NULL,NULL),('common','all_global_roles','en','Global Roles',NULL,NULL),('common','all_local_roles','en','Local Roles (all)',NULL,NULL),('common','all_objects','en','All Objects',NULL,NULL),('common','all_roles','en','All Roles',NULL,NULL),('common','all_topics','en','All Topics',NULL,NULL),('common','all_users','en','All Users',NULL,NULL),('common','already_delivered_files','en','Submitted Files',NULL,NULL),('common','and','en','and',NULL,NULL),('common','angry','en','Angry',NULL,NULL),('common','anonymous','en','Anonymous',NULL,NULL),('common','answers','en','Answers',NULL,NULL),('common','any_language','en','Any language',NULL,NULL),('common','apache_auth','en','Apache Authentication',NULL,NULL),('common','applications','en','Applications',NULL,NULL),('common','application_completed','en','Application is complete',NULL,NULL),('common','application_date','en','Application Date',NULL,NULL),('common','apply','en','Apply',NULL,NULL),('common','apply_filter','en','Apply Filter',NULL,NULL),('common','appointment','en','Appointment',NULL,NULL),('common','approve_date','en','Approved on',NULL,NULL),('common','approve_recipient','en','Login ID of Approver',NULL,NULL),('common','archive','en','Archive',NULL,NULL),('common','archive_broken','en','Archive seems to be broken or empty.',NULL,NULL),('common','are_you_sure','en','Are you sure?',NULL,NULL),('common','assf_allowed_questiontypes','en','Available Question Types',NULL,NULL),('common','assf_allowed_questiontypes_desc','en','All the checked question types will be available in this ILIAS installation. If you don\'t want to allow the creation of a certain question type in this installation, you must remove the selection in the associated check box.',NULL,NULL),('common','assf_questiontypes','en','Question Settings',NULL,NULL),('common','assign','en','Assign',NULL,NULL),('common','assigned_members','en','Assigned Members',NULL,NULL),('common','assigned_roles','en','Assigned Roles',NULL,NULL),('common','assign_global_role','en','Assign to Global Role',NULL,NULL),('common','assign_local_role','en','Assign to Local Role',NULL,NULL),('common','associated_user','en','associated User',NULL,NULL),('common','astounded','en','Astounded',NULL,NULL),('common','attachment','en','Attachment',NULL,NULL),('common','attachments','en','Attachments',NULL,NULL),('common','attempts','en','Attempts',NULL,NULL),('common','at_least_one_style','en','At least one style must remain activated.',NULL,NULL),('common','authenticate_ilias','en','ILIAS Native Authentication',NULL,NULL),('common','authentication_settings','en','Authentication',NULL,NULL),('common','author','en','Author',NULL,NULL),('common','authoring_mode','en','Authoring Mode',NULL,NULL),('common','authors','en','Authors',NULL,NULL),('common','auth_active_roles','en','Global Roles Available on Registration Form',NULL,NULL),('common','auth_allow_local','en','Allow Local Authentication',NULL,NULL),('common','auth_cas','en','CAS',NULL,NULL),('common','auth_cas_allow_local_desc','en','Allows CAS users to authenticate themselves with their local ILIAS username and a local password.',NULL,NULL),('common','auth_cas_auth','en','Configure CAS Authentication',NULL,NULL),('common','auth_cas_auth_desc','en','For CAS authentication to work, the server setting prevent_super_global_replacement in client.ini.php must be set.',NULL,NULL),('common','auth_cas_port_desc','en','E.g. 443 if the full CAS server URI is https://auth.yourserver.com:443/cas/',NULL,NULL),('common','auth_cas_server_desc','en','E.g. auth.yourserver.com if the full CAS server URI is https://auth.yourserver.com:443/cas/',NULL,NULL),('common','auth_cas_uri_desc','en','Local URI, e.g. cas if the full CAS server URI is https://auth.yourserver.com:443/cas/',NULL,NULL),('common','auth_configure','en','configure...',NULL,NULL),('common','auth_create_users','en','Create Non-Existing Users Automatically',NULL,NULL),('common','auth_default','en','Default setting',NULL,NULL),('common','auth_default_mode_changed_to','en','Default authentication mode changed to',NULL,NULL),('common','auth_ecs','en','ECS',NULL,NULL),('common','auth_ldap','en','LDAP',NULL,NULL),('common','auth_ldap_enable','en','Enable LDAP support',NULL,NULL),('common','auth_ldap_migration','en','Account Migration',NULL,NULL),('common','auth_ldap_migration_info','en','Activate this option to give new users the possibility to migrate their existing ILIAS accounts to LDAP authentication.',NULL,NULL),('common','auth_local','en','ILIAS Auth',NULL,NULL),('common','auth_login_instructions','en','Instructions Shown on Login Page',NULL,NULL),('common','auth_mode','en','Authentication Mode',NULL,NULL),('common','auth_mode_not_changed','en','(Nothing changed)',NULL,NULL),('common','auth_mode_roles_changed','en','Changed authentication mode for this Role',NULL,NULL),('common','auth_new_account_mail_desc','en','Send new account e-mail to user, if user is generated automatically. A password will only be generated, if ‘Allow Local Authentication’ is also activated.',NULL,NULL),('common','auth_per_default','en','Per Default',NULL,NULL),('common','auth_remark_non_local_auth','en','Selecting an authentication mode other than ‘ILIAS Auth’ (which uses the ILIAS database) means that users will not be able to change their login name or password after registration.',NULL,NULL),('common','auth_role_auth_mode','en','Authentication Mode',NULL,NULL),('common','auth_saml','en','SAML',NULL,NULL),('common','auth_script','en','Custom',NULL,NULL),('common','auth_select','en','Select Authentication Mode',NULL,NULL),('common','auth_selection','en','Login Options',NULL,NULL),('common','auth_settings','en','Authentication Settings',NULL,NULL),('common','auth_shib','en','Shibboleth',NULL,NULL),('common','auth_shibboleth','en','Shibboleth',NULL,NULL),('common','auth_shib_instructions','en','Be sure to read the README for instructions on how to configure Shibboleth support for ILIAS.',NULL,NULL),('common','auth_shib_not_configured','en','Shibboleth is not configured yet',NULL,NULL),('common','auth_soap','en','SOAP',NULL,NULL),('common','auth_soap_allow_local_desc','en','This allows SOAP users to authenticate with their local ILIAS username and a local password.',NULL,NULL),('common','auth_soap_auth','en','Configure SOAP Authentication',NULL,NULL),('common','auth_soap_auth_desc','en','This settings deal only with SOAP based user authentication, not with the ILIAS SOAP interface.',NULL,NULL),('common','auth_soap_create_users_desc','en','Creates automatically an ILIAS user account, for users that successfully authenticated against SOAP, without having an ILIAS account yet.',NULL,NULL),('common','auth_soap_namespace','en','Namespace',NULL,NULL),('common','auth_soap_namespace_desc','en','As defined in WSDL. Must be specified, if .NET SOAP style is used.',NULL,NULL),('common','auth_soap_port_desc','en','E.g. 8080 if the full SOAP server URI is http://auth.yourserver.com:8080/dir/server.php',NULL,NULL),('common','auth_soap_server_desc','en','E.g. auth.yourserver.com if the full SOAP server URI is http://auth.yourserver.com:8080/dir/server.php',NULL,NULL),('common','auth_soap_settings_saved','en','SOAP authentication settings saved',NULL,NULL),('common','auth_soap_uri_desc','en','Local URI, e.g. dir/server.php if the full SOAP server URI is http://auth.yourserver.com:8080/dir/server.php',NULL,NULL),('common','auth_soap_user_default_role_desc','en','This role is assigned to automatically created SOAP users.',NULL,NULL),('common','auth_soap_use_dotnet','en','Use .NET SOAP Style',NULL,NULL),('common','auth_soap_use_https','en','Use HTTPS',NULL,NULL),('common','auth_user_default_role','en','Default Role',NULL,NULL),('common','autocomplete_more','en','more',NULL,NULL),('common','available','en','Available',NULL,NULL),('common','awra','en','Who is online?',NULL,NULL),('common','back','en','Back',NULL,NULL),('common','backto_lua','en','Back to Local User Administration',NULL,NULL),('common','back_to_course','en','Back to Course',NULL,NULL),('common','back_to_crs_content','en','Back to Course Content',NULL,NULL),('common','back_to_fold_content','en','Back to Folder Content',NULL,NULL),('common','back_to_grp_content','en','Back to Group Content',NULL,NULL),('common','basedn','en','BaseDN',NULL,NULL),('common','basic_settings','en','Basic Settings',NULL,NULL),('common','before','en','Before',NULL,NULL),('common','behind','en','Behind',NULL,NULL),('common','benchmark','en','Benchmark',NULL,NULL),('common','benchmarks','en','Benchmarks',NULL,NULL),('common','bibl_add','en','Add Bibliography',NULL,NULL),('common','bib_data','en','Bibliographical Data',NULL,NULL),('common','birthday','en','Birthday',NULL,NULL),('common','bkm_import','en','Import Bookmarks',NULL,NULL),('common','bkm_import_ok','en','Successfully imported %d bookmarks and %d bookmark folders.',NULL,NULL),('common','bkm_sendmail','en','Send as attachment',NULL,NULL),('common','block','en','Block',NULL,NULL),('common','bm','en','Bookmark',NULL,NULL),('common','bmf','en','Bookmark Folder',NULL,NULL),('common','bm_add_to_ilias','en','Add to ILIAS Bookmarks',NULL,NULL),('common','bold','en','Bold',NULL,NULL),('common','bold_action','en','Insert Bold - Click to insert bold text.',NULL,NULL),('common','bookings','en','Bookings',NULL,NULL),('common','bookmarks','en','Bookmarks',NULL,NULL),('common','bookmarks_of','en','Bookmarks of',NULL,NULL),('common','bookmark_added','en','The Bookmark has been created.',NULL,NULL),('common','bookmark_folder_new','en','New Bookmark Folder',NULL,NULL),('common','bookmark_new','en','New Bookmark',NULL,NULL),('common','bookmark_target','en','Target',NULL,NULL),('common','breadcrumbs_aria_label','en','Breadcrumbs',NULL,NULL),('common','breadcrumb_navigation','en','Breadcrumb Navigation',NULL,NULL),('common','briefcase','en','Background Tasks',NULL,NULL),('common','btn_add','en','Add',NULL,NULL),('common','btn_back','en','Back',NULL,NULL),('common','btn_next','en','Continue',NULL,NULL),('common','btn_previous','en','Back',NULL,NULL),('common','btn_remove_system','en','Remove from System',NULL,NULL),('common','btn_undelete','en','Restore',NULL,NULL),('common','buddy_allow_to_contact_me_no','en','Doesn`t Receive Contact Requests',NULL,NULL),('common','buddy_allow_to_contact_me_yes','en','Receives Contact Requests',NULL,NULL),('common','building_export_file','en','Building Export File...',NULL,NULL),('common','bulletlist_action','en','Insert Bulletpoint-List - Click to insert a bulletpoint-list.',NULL,NULL),('common','by','en','By',NULL,NULL),('common','bytes','en','Bytes',NULL,NULL),('common','calendar','en','Calendar',NULL,NULL),('common','cal_from','en','From:',NULL,NULL),('common','cal_until','en','Until:',NULL,NULL),('common','cancel','en','Cancel',NULL,NULL),('common','cancel_file_upload','en','Do you really want to cancel all pending uploads?',NULL,NULL),('common','cannot_find_xml','en','Cannot find any XML-file.',NULL,NULL),('common','cannot_uninstall_language_in_use','en','You cannot uninstall the language currently in use!',NULL,NULL),('common','cannot_uninstall_systemlanguage','en','You cannot uninstall the system language!',NULL,NULL),('common','cannot_unzip_file','en','Cannot unpack file.',NULL,NULL),('common','cant_deactivate_if_users_assigned','en','You cannot deactivate a style if there are still users assigned to it.',NULL,NULL),('common','cat','en','Category',NULL,NULL),('common','categories','en','Categories',NULL,NULL),('common','categories_imported','en','Category import complete.',NULL,NULL),('common','catr','en','Category Link',NULL,NULL),('common','catr_add','en','Add Category Link',NULL,NULL),('common','catr_edit_info','en','Please choose one category for creating a new link.',NULL,NULL),('common','catr_new','en','Create Category Link',NULL,NULL),('common','catr_settings','en','Category Link Settings',NULL,NULL),('common','cat_add','en','Add Category',NULL,NULL),('common','cat_added','en','Category added',NULL,NULL),('common','cat_copy_threads_info','en','Please decide which category items should be copied, linked or even omitted.',NULL,NULL),('common','cat_edit','en','Category Settings',NULL,NULL),('common','cat_new','en','New Category',NULL,NULL),('common','cat_wizard_page','en','Copy Category (Step 2/2)',NULL,NULL),('common','certificate','en','Certificate',NULL,NULL),('common','certificates','en','Certificates',NULL,NULL),('common','certificate_file_already_exists_error','en','The certificate file already exists in the file system.',NULL,NULL),('common','certificate_file_input_output_error','en','The certificate file was found but couldn\'t be deleted because of internal errors. Please contact your administrator.',NULL,NULL),('common','certificate_file_not_found_error','en','The certificate file doesn\'t exist in the file system anymore. Die Zertikatsdatei wurde im Dateisystem nicht mehr gefunden.',NULL,NULL),('common','certificate_persistent_option','en','Certificates of Achievements',NULL,NULL),('common','certificate_selection','en','Origin of Certificates',NULL,NULL),('common','certificate_workspace_option','en','Certificates of Personal Resources',NULL,NULL),('common','change','en','Change',NULL,NULL),('common','changeable','en','Changeable in Profile',NULL,NULL),('common','changed_to','en','changed to',NULL,NULL),('common','change_assignment','en','Change assignment',NULL,NULL),('common','change_header_title','en','Edit Header Title',NULL,NULL),('common','change_owner','en','Change Owner',NULL,NULL),('common','change_sort_direction','en','Change sort direction',NULL,NULL),('common','changing_loginname_not_possible_info','en','You changed your login name at last at %s. The next change can be performed at %s.',NULL,NULL),('common','chapter','en','Chapter',NULL,NULL),('common','characters','en','characters',NULL,NULL),('common','chat_enter_public_room','en','Public Chat Room',NULL,NULL),('common','chat_enter_public_room_tooltip','en','Enter public chat room',NULL,NULL),('common','chat_users_active','en','Active users',NULL,NULL),('common','check','en','Check',NULL,NULL),('common','checked','en','Checked',NULL,NULL),('common','checked_files','en','Importable files',NULL,NULL),('common','check_all','en','Check all',NULL,NULL),('common','check_langfile','en','Please check your language file',NULL,NULL),('common','check_languages','en','Check All Languages',NULL,NULL),('common','check_link','en','Weblink check',NULL,NULL),('common','check_link_desc','en','If enabled all external links in ILIAS learning modules will be checked if they are active.',NULL,NULL),('common','check_user_accounts','en','Check user accounts',NULL,NULL),('common','check_user_accounts_desc','en','If enabled, all users whose account expires will be informed by e-mail two weeks before. Furthermore all users which have not confirmed their account after a registration with e-mail confirmation will be deleted.',NULL,NULL),('common','check_web_resources','en','Check Weblinks',NULL,NULL),('common','check_web_resources_desc','en','If enabled all Weblinks will be checked if they are active.',NULL,NULL),('common','chg_ilias_and_webfolder_password','en','Change Web Folder Password',NULL,NULL),('common','chg_ilias_password','en','Change ILIAS Password',NULL,NULL),('common','chg_password','en','Change Password',NULL,NULL),('common','choose_language','en','Choose Your Language',NULL,NULL),('common','choose_only_one_language','en','Please choose only one language',NULL,NULL),('common','chown_warning','en','Attention, you may loose access permissions on this object after changing the owner.',NULL,NULL),('common','chta_edit_permission','en','Change Permission Settings',NULL,NULL),('common','chta_read','en','Read access to Chat Room Administration',NULL,NULL),('common','chta_visible','en','Chat Room Administration is visible',NULL,NULL),('common','chta_write','en','Edit Chat Room Administration',NULL,NULL),('common','chtr_copy','en','Copy Chat Room',NULL,NULL),('common','chtr_import','en','Import Chat Room',NULL,NULL),('common','city','en','City, State',NULL,NULL),('common','cleaned_file','en','File has been cleaned.',NULL,NULL),('common','cleaning_failed','en','Cleaning failed.',NULL,NULL),('common','clear','en','Clear',NULL,NULL),('common','clear_clipboard','en','Clear Clipboard',NULL,NULL),('common','client','en','Client',NULL,NULL),('common','clientlist_available_clients','en','Available Clients',NULL,NULL),('common','clientlist_clientlist','en','Client List',NULL,NULL),('common','clientlist_installation_name','en','Installation Name',NULL,NULL),('common','clientlist_login','en','Login',NULL,NULL),('common','clientlist_login_page','en','Login page',NULL,NULL),('common','clientlist_public_access','en','Public Access',NULL,NULL),('common','clientlist_start_page','en','Start page',NULL,NULL),('common','client_id','en','Client ID',NULL,NULL),('common','client_ip','en','Client IP',NULL,NULL),('common','clipboard','en','Clipboard',NULL,NULL),('common','close','en','Close',NULL,NULL),('common','cmix','en','Object xAPI/cmi5',NULL,NULL),('common','cnt_new','en','(%s New)',NULL,NULL),('common','collapse','en','Collapse',NULL,NULL),('common','collapsed','en','Collapsed',NULL,NULL),('common','collapse_all','en','Collapse All',NULL,NULL),('common','collapse_content','en','Collapse Content',NULL,NULL),('common','columns','en','Columns',NULL,NULL),('common','column_selection','en','Column Selection',NULL,NULL),('common','comma_separated','en','Comma Separated',NULL,NULL),('common','comment','en','Comment',NULL,NULL),('common','comments','en','Comments',NULL,NULL),('common','compose','en','Compose',NULL,NULL),('common','concurrent_uploads','en','Number of concurrent uploads',NULL,NULL),('common','concurrent_uploads_info','en','Defines the number of files that can be uploaded per upload process at the same time.',NULL,NULL),('common','condition','en','Condition',NULL,NULL),('common','conditions_updated','en','Conditions saved',NULL,NULL),('common','condition_accredited_or_passed','en','Accredited or Passed',NULL,NULL),('common','condition_already_assigned','en','Object already assigned.',NULL,NULL),('common','condition_circle_created','en','This association is not possible, since the objects would interdepend.',NULL,NULL),('common','condition_deleted','en','Condition deleted.',NULL,NULL),('common','condition_finished','en','Finished',NULL,NULL),('common','condition_not_finished','en','Not finished',NULL,NULL),('common','condition_passed','en','Passed',NULL,NULL),('common','condition_select_object','en','Please select one object.',NULL,NULL),('common','cond_ref_handling','en','Link Settings',NULL,NULL),('common','cond_ref_shared','en','Shared Preconditions for all Links',NULL,NULL),('common','cond_ref_unique','en','Unique Preconditions for Links',NULL,NULL),('common','confirm','en','Confirm',NULL,NULL),('common','confirmation','en','Confirmation',NULL,NULL),('common','confirm_delete_parameter','en','Do you really want to delete the parameter?',NULL,NULL),('common','conflict_handling','en','Conflict handling',NULL,NULL),('common','contact','en','Contact',NULL,NULL),('common','contact_data','en','Contact Information',NULL,NULL),('common','contact_sysadmin','en','Contact Technical Support',NULL,NULL),('common','container','en','Container',NULL,NULL),('common','container_no_items','en','No Materials Available',NULL,NULL),('common','content','en','Content',NULL,NULL),('common','content_frame','en','Content Frame',NULL,NULL),('common','content_styles','en','Content Styles',NULL,NULL),('common','context','en','Context',NULL,NULL),('common','continue','en','Continue',NULL,NULL),('common','continue_work','en','Continue',NULL,NULL),('common','contra','en','Contra',NULL,NULL),('common','cont_iim_content_popups_info','en','Content popups appear, when the user clicks on interactive parts of the background image. On this screen you only define the popups. Their content can be edited on the editing screen of the page.',NULL,NULL),('common','cont_iim_create_info','en','Please upload the background picture for the interactive image.',NULL,NULL),('common','cont_iim_overlay_info','en','Overlay images are used to alter (e.g. highlight) parts of the background image when the mouse hovers over them. After uploading the images, you can select them in the ‘Triggers’ tab.',NULL,NULL),('common','copa','en','Content Page',NULL,NULL),('common','copy','en','Copy',NULL,NULL),('common','copyChapter','en','Copy',NULL,NULL),('common','copyPage','en','Copy',NULL,NULL),('common','copy_all','en','Copy all',NULL,NULL),('common','copy_n_of_suffix','en','- Copy (%1$s)',NULL,NULL),('common','copy_of','en','Copy of',NULL,NULL),('common','copy_of_suffix','en','- Copy',NULL,NULL),('common','copy_perma_link','en','Copy link to clipboard',NULL,NULL),('common','copy_selected_items','en','Copy',NULL,NULL),('common','count','en','Count',NULL,NULL),('common','counter_novelty','en','News',NULL,NULL),('common','counter_status','en','Status',NULL,NULL),('common','country','en','Country',NULL,NULL),('common','country_free_text','en','Country (Free Text Input)',NULL,NULL),('common','country_selection','en','Country (Drop Down Selection)',NULL,NULL),('common','course','en','Course',NULL,NULL),('common','courses','en','Courses',NULL,NULL),('common','create','en','Create',NULL,NULL),('common','created','en','Creation Date',NULL,NULL),('common','create_date','en','Created on',NULL,NULL),('common','create_export_file','en','Create export file',NULL,NULL),('common','create_stylesheet','en','Create Style',NULL,NULL),('common','cronjob_last_start','en','Last Start of the Cron Job',NULL,NULL),('common','cronjob_last_start_unknown','en','Indeterminate',NULL,NULL),('common','cron_forum_notification','en','Send Forum Notifications via Cron Job',NULL,NULL),('common','cron_forum_notification_crob_desc','en','If enabled, all users who have enabled notifications for certain forums or forum threads will daily receive a notification mail about all new  or changed posts but no immediate notification for each submitted post.',NULL,NULL),('common','cron_forum_notification_disabled','en','Can\'t be disabled when the Cron Job is active.',NULL,NULL),('common','cron_jobs','en','Cron Jobs',NULL,NULL),('common','cron_lucene_index','en','Update Lucene search index',NULL,NULL),('common','cron_lucene_index_info','en','If enabled, the Lucene search index will be updated. Please configure the Lucene server in the Administration at \'Search and Find » Search\', tab \'Lucene\'.',NULL,NULL),('common','cron_mail_notification','en','New Mail Notifications',NULL,NULL),('common','cron_mail_notification_cron','en','regularly per cron job',NULL,NULL),('common','cron_mail_notification_desc','en','On request, ILIAS sends e-mail notifications about new mails. In contrast to the immediate forwarding of all mails, this cronjob collects the mails of one day and delivers them as a package. Please enable the option \'%s\' to use this feature. Additionally, the e-mail notifications for each ILIAS account have to be activated in the personal mail settings.',NULL,NULL),('common','cron_mail_notification_message','en','Send Mail Notifications with Mail-Message',NULL,NULL),('common','cron_mail_notification_message_info','en','E-mail notifications contain the complete content of the mails received in ILIAS. This means that they can be read without having to log in again.',NULL,NULL),('common','cron_mail_notification_never','en','never',NULL,NULL),('common','cron_users_without_login_del_create_date_thr','en','Thresholt',NULL,NULL),('common','cron_users_without_login_del_create_date_thr_info','en','All user accounts created before the defined threshold will be taken into consideration.',NULL,NULL),('common','cron_users_without_login_del_role_whitelist','en','Included Roles',NULL,NULL),('common','cron_users_without_login_del_role_whitelist_info','en','Only users with one of the selected global roles will be deleted. Does a user have a role that is not selected, the user account remains.',NULL,NULL),('common','crs','en','Course',NULL,NULL),('common','crsr','en','Course Link',NULL,NULL),('common','crsr_add','en','Add Course Link',NULL,NULL),('common','crsr_edit_info','en','Please choose one course for creating a new link.',NULL,NULL),('common','crsr_new','en','Create Course Link',NULL,NULL),('common','crsr_settings','en','Course Link Settings',NULL,NULL),('common','crs_activation_start_invalid','en','The start and the finish time is not valid.',NULL,NULL),('common','crs_add','en','Add Course',NULL,NULL),('common','crs_added','en','Course added',NULL,NULL),('common','crs_archives','en','Archives',NULL,NULL),('common','crs_cancel_waiting_list','en','Do you really want to remove yourself from the waiting list of course \"%s\"?',NULL,NULL),('common','crs_copy_threads_info','en','Please decide which course materials should be copied, linked or even omitted.',NULL,NULL),('common','crs_edit','en','Edit Course',NULL,NULL),('common','crs_list_reg','en','Registration',NULL,NULL),('common','crs_list_reg_end','en','Registration End',NULL,NULL),('common','crs_list_reg_limit_full','en','No places left',NULL,NULL),('common','crs_list_reg_limit_places','en','Free places',NULL,NULL),('common','crs_list_reg_noreg','en','No Registration Possible',NULL,NULL),('common','crs_list_reg_period','en','Registration Period',NULL,NULL),('common','crs_list_reg_start','en','Registration Begin',NULL,NULL),('common','crs_members_gallery','en','Course Members Gallery',NULL,NULL),('common','crs_member_not_passed','en','Not passed',NULL,NULL),('common','crs_member_passed','en','Passed',NULL,NULL),('common','crs_new','en','New Course',NULL,NULL),('common','crs_removed_from_waiting_list','en','You have been detached from the waiting list of course \"%s\".',NULL,NULL),('common','crs_status_blocked','en','[Access refused]',NULL,NULL),('common','crs_status_pending','en','[Waiting for registration]',NULL,NULL),('common','crs_subscribers_assigned','en','Assigned new user(s)',NULL,NULL),('common','crs_title','en','Course Title',NULL,NULL),('common','crs_unsubscribe','en','Unsubscribe from Course',NULL,NULL),('common','crs_wizard_page','en','Copy Course (Step 2/2)',NULL,NULL),('common','csv_export','en','CSV-Export',NULL,NULL),('common','currently_used_disk_space','en','Currently used disk space',NULL,NULL),('common','current_ip','en','Current IP:',NULL,NULL),('common','current_ip_alert','en','Notice: if you enter a wrong ip you won\'t be able to access the system with this profile anymore.',NULL,NULL),('common','current_password','en','Current Password',NULL,NULL),('common','current_user_avatar','en','Your User Avatar',NULL,NULL),('common','customize_page','en','Customize Page',NULL,NULL),('common','cut','en','Cut',NULL,NULL),('common','cutPage','en','Cut',NULL,NULL),('common','daily','en','daily',NULL,NULL),('common','database','en','Database',NULL,NULL),('common','database_version','en','Current Database Version',NULL,NULL),('common','dataset','en','Item',NULL,NULL),('common','date','en','Date',NULL,NULL),('common','dateplaner','en','Calendar',NULL,NULL),('common','day','en','Day',NULL,NULL),('common','days','en','Days',NULL,NULL),('common','db_host','en','Database Host',NULL,NULL),('common','db_name','en','Database Name',NULL,NULL),('common','db_need_update','en','Database needs an update!',NULL,NULL),('common','db_pass','en','Database Password',NULL,NULL),('common','db_type','en','Database Type',NULL,NULL),('common','db_user','en','Database User',NULL,NULL),('common','db_version','en','Database Version',NULL,NULL),('common','dd_mm_yyyy','en','DD.MM.YYYY',NULL,NULL),('common','deactivate','en','Set Inactive',NULL,NULL),('common','decrease_attempts','en','Attempts - 1',NULL,NULL),('common','default','en','Default',NULL,NULL),('common','defaults','en','Defaults',NULL,NULL),('common','default_auth_mode','en','Default Authentication Method',NULL,NULL),('common','default_auth_mode_info','en','Please choose the authentication method that is preselected on the login page.',NULL,NULL),('common','default_language','en','Default Language',NULL,NULL),('common','default_perm_settings','en','Default Permissions',NULL,NULL),('common','default_role','en','Default Role',NULL,NULL),('common','default_roles','en','Default Roles',NULL,NULL),('common','default_skin','en','Default Skin',NULL,NULL),('common','default_skin_style','en','Default Skin / Style',NULL,NULL),('common','default_style','en','Default Style',NULL,NULL),('common','def_repository_view','en','Default repository view',NULL,NULL),('common','delete','en','Delete',NULL,NULL),('common','deleted','en','Deleted',NULL,NULL),('common','deleted_user','en','The user has been deleted',NULL,NULL),('common','deleted_users','en','Deleted users',NULL,NULL),('common','delete_existing_file','en','Delete Existing File',NULL,NULL),('common','delete_inactivated_user_accounts','en','Delete inactivated user accounts',NULL,NULL),('common','delete_inactivated_user_accounts_desc','en','If enabled, user accounts will be deleted %s days after their inactivation.',NULL,NULL),('common','delete_inactivated_user_accounts_include_roles','en','Considered roles',NULL,NULL),('common','delete_inactivated_user_accounts_include_roles_desc','en','Only ILIAS-Accounts assigned to one of the selected Roles will be deleted.',NULL,NULL),('common','delete_inactivated_user_accounts_period','en','Days passed since inactivation',NULL,NULL),('common','delete_inactivated_user_accounts_period_desc','en','Accounts will be deleted if this number of days has passed since inactivation.',NULL,NULL),('common','delete_inactive_user_accounts','en','Delete user accounts with no login for a long time',NULL,NULL),('common','delete_inactive_user_accounts_desc','en','If enabled, user accounts will be deleted depending on the date of their last login.',NULL,NULL),('common','delete_inactive_user_accounts_include_roles','en','Considered roles',NULL,NULL),('common','delete_inactive_user_accounts_include_roles_desc','en','Only ILIAS-Accounts assigned to one of the selected Roles will be deleted.',NULL,NULL),('common','delete_inactive_user_accounts_period','en','Days passed since last login',NULL,NULL),('common','delete_inactive_user_accounts_period_desc','en','All user accounts without login within the defined number of days will be deleted automatically.',NULL,NULL),('common','delete_parameter','en','Delete Parameter',NULL,NULL),('common','delete_selected_items','en','Delete',NULL,NULL),('common','deletion_notification','en','\"%s\" has canceled the attendance of session \"%s\".',NULL,NULL),('common','deliver','en','Deliver',NULL,NULL),('common','deny_usr_agreement','en','Do Not Accept Terms of Service?',NULL,NULL),('common','deny_usr_agreement_btn','en','Do Not Accept',NULL,NULL),('common','department','en','Department',NULL,NULL),('common','desc','en','Description',NULL,NULL),('common','description','en','Description',NULL,NULL),('common','desired_password','en','New Password',NULL,NULL),('common','details','en','Details',NULL,NULL),('common','didactic_template','en','Didactic Template',NULL,NULL),('common','disable','en','disable',NULL,NULL),('common','disabled','en','Disabled',NULL,NULL),('common','disable_check','en','Disable check',NULL,NULL),('common','disable_ext_lang_maint','en','Disable Extended Maintenance',NULL,NULL),('common','disable_hide_user_toggle','en','Member is allowed to deactivate',NULL,NULL),('common','disclose','en','Disclose',NULL,NULL),('common','dislike','en','Dislike',NULL,NULL),('common','domain','en','Domain',NULL,NULL),('common','down','en','Down',NULL,NULL),('common','download','en','Download',NULL,NULL),('common','downloading_settings','en','Download Settings',NULL,NULL),('common','download_all_returned_files','en','Download All Submissions',NULL,NULL),('common','download_link','en','Download Link',NULL,NULL),('common','download_multiple_objects','en','Download Multiple Objects',NULL,NULL),('common','download_selected_items','en','Download',NULL,NULL),('common','dpro_accept_usr_agreement','en','Accept Declaration of Data Protection?',NULL,NULL),('common','dpro_accept_usr_agreement_intro','en','There is a new Declaration of Data Protection. You need to accept it before proceeding with the use of ILIAS. Read the following document carefully and give your consent or dissent at the bottom of the page.',NULL,NULL),('common','dpro_agreed_on','en','DoDP agreed to on',NULL,NULL),('common','dpro_force_accept_usr_agreement','en','You must accept the Declaration of Data Protection!',NULL,NULL),('common','dpro_no_agreement_description','en','There is currently no Declaration of Data Protection document available for this installation. Please contact the <a href=\"%1$s\">system administrator</a>.',NULL,NULL),('common','dpro_refuse_acceptance','en','Refuse to Accept the Declaration of Data Protection',NULL,NULL),('common','dpro_usr_agreement','en','Declaration of Data Protection',NULL,NULL),('common','dpro_usr_agreement_footer_intro','en','You have declared your consent to this Declaration of Data Protection.',NULL,NULL),('common','dpro_withdraw_consent_description','en','Withdraw your consent to our Declaration of Data Protection here.',NULL,NULL),('common','dpro_withdraw_consent_description_external','en','Please return to your ILIAS installation and log in again to complete the process of withdrawing your consent to the Declaration of Data Protection.',NULL,NULL),('common','dpro_withdraw_consent_description_internal','en','Please log in again to complete the process of withdrawing your consent to the Declaration of Data Protection.',NULL,NULL),('common','dpro_withdraw_consent_header','en','Withdraw to Consent of Declaration of Data Protection',NULL,NULL),('common','dpro_withdraw_consent_info','en','Withdraw your consent to our Declaration of Data Protection.',NULL,NULL),('common','dpro_withdraw_consent_info_external','en','Please contact the administrator of your authentication system and inform them of your intention to withdraw your consent to the Declaration of Data Protection.',NULL,NULL),('common','drafts','en','Drafts',NULL,NULL),('common','drag_files_here','en','Drag-and-drop your files here',NULL,NULL),('common','drag_file_here','en','Drag-and-drop your file here',NULL,NULL),('common','drag_handle','en','Draggable element',NULL,NULL),('common','drop_files_on_repo_obj_info','en','Drop the files here to upload them into this object.',NULL,NULL),('common','edit','en','Edit',NULL,NULL),('common','edited_on','en','Edited on',NULL,NULL),('common','editor','en','Editor',NULL,NULL),('common','edit_assignments','en','Edit Assignments',NULL,NULL),('common','edit_cat_settings','en','Advanced Category Settings',NULL,NULL),('common','edit_content','en','Edit Content',NULL,NULL),('common','edit_grouping','en','Edit Membership Limitation',NULL,NULL),('common','edit_metadata','en','Edit Metadata',NULL,NULL),('common','edit_operations','en','Edit Operations',NULL,NULL),('common','edit_page','en','Edit Page',NULL,NULL),('common','edit_page_content','en','Edit Page Content',NULL,NULL),('common','edit_page_meta','en','Edit Page Metadata',NULL,NULL),('common','edit_properties','en','Edit Properties',NULL,NULL),('common','edit_stylesheet','en','Edit Style',NULL,NULL),('common','email','en','E-Mail',NULL,NULL),('common','email_not_valid','en','The e-mail address you entered is not valid!',NULL,NULL),('common','enable','en','Enable',NULL,NULL),('common','enabled','en','Enabled',NULL,NULL),('common','enable_anonymous_fora','en','Allow post with pseudonym',NULL,NULL),('common','enable_anonymous_fora_desc','en','If this option is disabled, the feature ‘Post with pseudonym’ is not available in forums anymore.',NULL,NULL),('common','enable_calendar','en','Enable Calendar',NULL,NULL),('common','enable_comments_export','en','Enable Comments Export',NULL,NULL),('common','enable_course_group_notifications','en','Daily mail for group and course news',NULL,NULL),('common','enable_course_group_notifications_desc','en','If enabled, participants can subscribe to a daily summary of news.',NULL,NULL),('common','enable_custom_icons','en','Enable custom icons',NULL,NULL),('common','enable_custom_icons_info','en','This allows you to define custom icons for single container objects and the content page object. The properties section of these objects will provide an image upload dialog.',NULL,NULL),('common','enable_dnd_upload','en','Enable drag-and-drop upload',NULL,NULL),('common','enable_dnd_upload_info','en','Files can be uploaded with drag-and-drop from the local computer if enabled.',NULL,NULL),('common','enable_download_folder','en','Action \'Download Folder\' enabled',NULL,NULL),('common','enable_download_folder_info','en','Enables a \'Download\' option inside the Actions drop-down of folders.',NULL,NULL),('common','enable_export_scorm_desc','en','Display of Personal Data in the Protocol Data (SCORM)',NULL,NULL),('common','enable_fora_statistics','en','Enable Statistics in Forum',NULL,NULL),('common','enable_fora_statistics_desc','en','If disabled, nobody is able to access the forum statistics.',NULL,NULL),('common','enable_hide_user_toggle','en','Member is not allowed to deactivate',NULL,NULL),('common','enable_multi_download','en','\'Download of multiple objects\' enabled',NULL,NULL),('common','enable_multi_download_info','en','Multiple folders/files can be selected and downloaded as zip archive.',NULL,NULL),('common','enable_password_assistance','en','Enable Password Assistance',NULL,NULL),('common','enable_preview','en','Enable Preview',NULL,NULL),('common','enable_preview_info','en','Enable the display of preview images for supported file types.',NULL,NULL),('common','enable_repository_dnd_upload','en','Enable in Repository',NULL,NULL),('common','enable_repository_dnd_upload_info','en','Enables that files can be dragged from the computer directly onto an object in the repository to start uploading the files into this object.',NULL,NULL),('common','enable_sahs_protocol_data','en','Activate Protocol Data',NULL,NULL),('common','enable_sahs_protocol_data_desc','en','Show Protocol Data (SCORM)',NULL,NULL),('common','enable_search_engine','en','Open Public Area for Internet Search Engines (e.g Google).<br />The Apache module ‘mod_rewrite’ is required for this extension. Please take care that you have appropriate permissions to use .htaccess configurations.',NULL,NULL),('common','enable_trash','en','Enable Trash',NULL,NULL),('common','enable_trash_info','en','If enabled, deleted Objects are moved into Trash and may be recovered later. When deactivating this option deleted Objects are removed irreversibly from the System!',NULL,NULL),('common','enable_webdav','en','Enable WebDAV access',NULL,NULL),('common','enable_webdav_info','en','Allows WebDAV clients to access the repository as a web folder. Users can open web folders using the ‘Open as web folder’ action in the repository, or by entering the following address in a WebDAV client: <a href=\"%1$s\" folder=\"%1$s\">%1$s</a>',NULL,NULL),('common','enlarge','en','Enlarge',NULL,NULL),('common','entered_notification','en','\"%s\" has joined the session \"%s\".',NULL,NULL),('common','enter_in_mb_desc','en','Enter a value in MB.',NULL,NULL),('common','enter_new_name','en','Please enter a name',NULL,NULL),('common','entry_status','en','Entry status',NULL,NULL),('common','error','en','Error',NULL,NULL),('common','error_empty_file_or_folder','en','The file size is 0 bytes or it is a folder.',NULL,NULL),('common','error_extraction_failed','en','The extraction of the archive and its directories failed. Probably because you don’t have the permission to create folders or categories within this object.',NULL,NULL),('common','error_parser','en','Error starting the parser.',NULL,NULL),('common','error_upload_was_zero_bytes','en','The upload failed as this is a folder, the file size is 0 bytes or exceeded the max. upload size or the file was renamed meanwhile.',NULL,NULL),('common','err_1_param','en','Only 1 parameter!',NULL,NULL),('common','err_2_param','en','Only 2 parameter!',NULL,NULL),('common','err_auth_apache_failed','en','The authentication has failed. Maybe you have no valid user certificate or your smart card is not inserted.',NULL,NULL),('common','err_auth_cas_no_ilias_user','en','Login failed. CAS authentication successful, but no corresponding ILIAS user exists. Please contact your system administrator.',NULL,NULL),('common','err_auth_ldap_no_ilias_user','en','Login failed. LDAP authentication successful, but no corresponding ILIAS user exists. Please contact your system administrator.',NULL,NULL),('common','err_auth_mode_inactive','en','Your authentication method is deactivated.',NULL,NULL),('common','err_auth_soap_no_ilias_user','en','Login failed. SOAP authentication successful, but no corresponding ILIAS user exists. Please contact your system administrator.',NULL,NULL),('common','err_check_input','en','The settings could not be saved. Please check your input.',NULL,NULL),('common','err_count_param','en','Reason: Wrong parameter count',NULL,NULL),('common','err_disabled','en','Account creation via Shibboleth has been disabled. Please contact the system administrator for further information.',NULL,NULL),('common','err_double_entries','en','Reason: Duplicate Entries',NULL,NULL),('common','err_inactive','en','This account has not been activated. Please contact the system administrator for access.',NULL,NULL),('common','err_inactive_login_attempts','en','Your user account has been deactivated due too many failed login attempts. Click \'Contact Technical Support\' at the footer of this page to notify the administrator about the need to re-activate your account.',NULL,NULL),('common','err_invalid_port','en','Invalid port number',NULL,NULL),('common','err_in_line','en','Error in line',NULL,NULL),('common','err_no_cookies','en','Please enable session cookies in your browser!',NULL,NULL),('common','err_no_langfile_found','en','No language file found!',NULL,NULL),('common','err_no_param','en','No parameter!',NULL,NULL),('common','err_over_3_param','en','More than 3 parameters!',NULL,NULL),('common','err_role_not_assignable','en','You cannot assign users to this role at this location',NULL,NULL),('common','err_session_expired','en','Your session is expired!',NULL,NULL),('common','err_valid_login_account_creation_disabled','en','Authentication succeeded, but the creation of new user accounts is currently disabled. Please contact your system administrator.',NULL,NULL),('common','err_wrong_header','en','Reason: Wrong header.',NULL,NULL),('common','err_wrong_login','en','Wrong Login or Password',NULL,NULL),('common','err_wrong_password','en','Wrong Password',NULL,NULL),('common','etal_talks','en','Talks',NULL,NULL),('common','event_assign_files','en','File Assignment',NULL,NULL),('common','event_ass_materials_prop','en','Session Materials',NULL,NULL),('common','exc','en','Exercise',NULL,NULL),('common','excs','en','Exercises',NULL,NULL),('common','exc_add','en','Add Exercise',NULL,NULL),('common','exc_added','en','Exercise added',NULL,NULL),('common','exc_date_not_valid','en','The date is not valid',NULL,NULL),('common','exc_deassign_members','en','Remove Participant(s)',NULL,NULL),('common','exc_download_files','en','Download Files',NULL,NULL),('common','exc_edit','en','New exercise created',NULL,NULL),('common','exc_edit_exercise','en','Edit exercise',NULL,NULL),('common','exc_edit_until','en','Edit Until',NULL,NULL),('common','exc_exercise_sent','en','Exercise Sent',NULL,NULL),('common','exc_files','en','Files',NULL,NULL),('common','exc_files_returned','en','Submitted Files',NULL,NULL),('common','exc_instruction','en','Work Instructions',NULL,NULL),('common','exc_last_submission','en','Last Submission',NULL,NULL),('common','exc_members_already_assigned','en','These users are already assigned to the assignment.',NULL,NULL),('common','exc_members_assigned','en','Members assigned',NULL,NULL),('common','exc_members_comments_saved','en','The exercise comments for the selected user have been saved',NULL,NULL),('common','exc_member_of_crs_grp','en','Member in Course/Group',NULL,NULL),('common','exc_new','en','New Exercise',NULL,NULL),('common','exc_next_deadline','en','Next Deadline',NULL,NULL),('common','exc_obj','en','Exercise',NULL,NULL),('common','exc_save_changes','en','Save',NULL,NULL),('common','exc_schedule','en','Schedule',NULL,NULL),('common','exc_select_one_file','en','Please select exactly one file.',NULL,NULL),('common','exc_sent','en','The exercise has been sent to the selected users',NULL,NULL),('common','exc_sent_at','en','Sent on <br />%s',NULL,NULL),('common','exc_status','en','Status',NULL,NULL),('common','exc_status_saved','en','Exercise updated',NULL,NULL),('common','exc_submission','en','Submission',NULL,NULL),('common','exc_time_over_short','en','Time is up.',NULL,NULL),('common','exc_time_to_send','en','Remaining Working Time',NULL,NULL),('common','exc_upload_error','en','Error uploading file',NULL,NULL),('common','execute','en','Apply',NULL,NULL),('common','exercise_time_over','en','The time allocated for completing this exercise is over. Files cannot be submitted anymore!',NULL,NULL),('common','expand','en','Expand',NULL,NULL),('common','expanded','en','Expanded',NULL,NULL),('common','expand_all','en','Expand All',NULL,NULL),('common','expand_content','en','Expand Content',NULL,NULL),('common','export','en','Export',NULL,NULL),('common','export_format','en','Export format',NULL,NULL),('common','export_html','en','Export as HTML File',NULL,NULL),('common','extracting','en','Extracting...',NULL,NULL),('common','ext_cat_settings','en','Edit Advanced Category Settings',NULL,NULL),('common','ext_link','en','Link',NULL,NULL),('common','eyeclosed','en','Eye Closed - Click to hide the input\'s contents',NULL,NULL),('common','eyeopened','en','Eye Open - Click to reveal the input\'s contents',NULL,NULL),('common','failure_message','en','Failure Message',NULL,NULL),('common','fax','en','Fax',NULL,NULL),('common','feed','en','Web Feed',NULL,NULL),('common','feedback','en','Feedback',NULL,NULL),('common','field_name','en','Field Name',NULL,NULL),('common','field_type','en','Field Type',NULL,NULL),('common','file','en','File',NULL,NULL),('common','filename','en','File Name',NULL,NULL),('common','filename_extension_missing','en','File name extension missing',NULL,NULL),('common','filename_hidden_backup_file','en','Hidden backup file',NULL,NULL),('common','filename_hidden_unix_file','en','Hidden Unix file',NULL,NULL),('common','filename_interoperability','en','Interoperability',NULL,NULL),('common','filename_special_characters','en','Due to the character / this object is not visible in web folders',NULL,NULL),('common','filename_special_filename','en','Objects with names . and .. are not visible in web folders',NULL,NULL),('common','filename_visibility','en','Visibility',NULL,NULL),('common','filename_windows_empty_extension','en','Due to the character . at the end of the name this object is not visible in Windows web folders',NULL,NULL),('common','filename_windows_special_characters','en','Due to one of the characters \\ / : * ? \" < > | this object is not visible in Windows web folders',NULL,NULL),('common','filename_windows_webdav_issue','en','Due to the character # this object is not visible in Windows web folders',NULL,NULL),('common','files','en','Files',NULL,NULL),('common','filesize','en','File Size',NULL,NULL),('common','filetype','en','File Type',NULL,NULL),('common','file_add','en','Upload File',NULL,NULL),('common','file_added','en','File uploaded.',NULL,NULL),('common','file_add_and_metadata','en','Upload File and Edit Metadata',NULL,NULL),('common','file_allowed_suffixes','en','Allowed file types:',NULL,NULL),('common','file_confirm_delete_all_versions','en','You have selected all file versions. Deleting all versions of this file will result in the deletion of the whole file object. Do you wish to continue?',NULL,NULL),('common','file_confirm_delete_versions','en','Are you sure you want to delete the following file version(s)?',NULL,NULL),('common','file_created','en','File has been added.',NULL,NULL),('common','file_edit','en','Edit File Information',NULL,NULL),('common','file_info','en','File Information',NULL,NULL),('common','file_is_infected','en','The file is infected by a virus.',NULL,NULL),('common','file_notice','en','Maximum upload size:',NULL,NULL),('common','file_not_found','en','File Not Found',NULL,NULL),('common','file_not_found_sec','en','This file cannot be found in ILIAS or has been blocked for security reasons.',NULL,NULL),('common','file_not_valid','en','File not valid!',NULL,NULL),('common','file_no_valid_file_type','en','This file type is not allowed.',NULL,NULL),('common','file_objects','en','File Objects',NULL,NULL),('common','file_rollback','en','Publish This Version',NULL,NULL),('common','file_rollback_done','en','File version %s has been published, assigned a new version number and can be found at the top of the ‘Versions’ table below.',NULL,NULL),('common','file_rollback_select_exact_one','en','Only one file version can be published at any one time. Please select only one file version to publish.',NULL,NULL),('common','file_some_invalid_file_types_removed','en','Some file types are not allowed and have been removed.',NULL,NULL),('common','file_suffix_repl','en','File Upload Suffix Replacement',NULL,NULL),('common','file_suffix_repl_info','en','Enter file types with suffix (separated by comma) that shall be be renamed with a ‘.sec’ when uploaded into webspace to prevent execution of this file. This is done per default for these suffixes:',NULL,NULL),('common','file_system_clean_temp_dir_cron','en','Clean Temp Directory',NULL,NULL),('common','file_system_clean_temp_dir_cron_info','en','This cron job cleans the ILIAS temp-directory of files which are older than 10 days. This prevents the accumulation of unused files which would otherwise lead to the temp directory taking up too much disk space.',NULL,NULL),('common','file_updated','en','File has been updated.',NULL,NULL),('common','file_upload_pending','en','Pending file',NULL,NULL),('common','file_valid','en','File is valid!',NULL,NULL),('common','file_version','en','Version Provided in File',NULL,NULL),('common','file_versions_deleted','en','The selected file versions were successfully deleted.',NULL,NULL),('common','file_version_create','en','Initial version',NULL,NULL),('common','file_version_intermediate_version','en','Intermediate Version',NULL,NULL),('common','file_version_new_version','en','New version',NULL,NULL),('common','file_version_published_version','en','Published Version',NULL,NULL),('common','file_version_replace','en','All versions replaced',NULL,NULL),('common','file_version_rollback','en','Rollback to version %s from %s',NULL,NULL),('common','fill_out_all_required_fields','en','Please fill out all required fields',NULL,NULL),('common','filter','en','Filter',NULL,NULL),('common','filter_users_without_access','en','Only users without access',NULL,NULL),('common','filter_users_without_disk_usage','en','Only users with no disk space used',NULL,NULL),('common','filter_users_with_access','en','Only users with access',NULL,NULL),('common','filter_users_with_disk_usage','en','Only users with disk space used',NULL,NULL),('common','first','en','First',NULL,NULL),('common','firstname','en','First Name',NULL,NULL),('common','flatview','en','Hide Sidebar',NULL,NULL),('common','fold','en','Folder',NULL,NULL),('common','folder','en','Folder',NULL,NULL),('common','folders','en','Folders',NULL,NULL),('common','fold_add','en','Add Folder',NULL,NULL),('common','fold_added','en','Folder added',NULL,NULL),('common','fold_copy_threads_info','en','Please decide which materials should be copied, linked or even omitted.',NULL,NULL),('common','fold_edit','en','Edit Folder',NULL,NULL),('common','fold_new','en','New Folder',NULL,NULL),('common','fold_wizard_page','en','Copy Folder (Step 2/2)',NULL,NULL),('common','follow_link_to_read_mails','en','click the following link to read these mails:',NULL,NULL),('common','forgot_password','en','Forgot your password?',NULL,NULL),('common','forgot_username','en','Forgot your username?',NULL,NULL),('common','form_input_not_valid','en','Some of the information entered is incomplete or invalid. Please correct your entry.',NULL,NULL),('common','forum','en','Forum',NULL,NULL),('common','forums','en','Forums',NULL,NULL),('common','forums_anonymized','en','Forum anonymized',NULL,NULL),('common','forums_anonymous','en','anonym',NULL,NULL),('common','forums_articles','en','Posts',NULL,NULL),('common','forums_closed','en','closed',NULL,NULL),('common','forums_disable_forum_notification','en','Disable Notification for this Forum',NULL,NULL),('common','forums_enable_forum_notification','en','Enable Notification for this Forum',NULL,NULL),('common','forums_forum_notification_enabled','en','You will be notified about new posts in this forum.',NULL,NULL),('common','forums_last_post','en','Latest Post',NULL,NULL),('common','forums_last_posting_asc','en','Last Post Ascending',NULL,NULL),('common','forums_last_posting_dsc','en','Last Post Descending',NULL,NULL),('common','forums_notification_settings','en','Forums Notification Settings',NULL,NULL),('common','forums_rating_asc','en','Rating Ascending',NULL,NULL),('common','forums_rating_dsc','en','Rating Descending',NULL,NULL),('common','forums_threads','en','Threads',NULL,NULL),('common','forums_thread_sorting_asc','en','Thread Title A→Z',NULL,NULL),('common','forums_thread_sorting_dsc','en','Thread Title Z→A',NULL,NULL),('common','forums_use_alias','en','You may use a pseudonym for your post. If you leave this field blank, your post will be marked as written by ‘%s’.',NULL,NULL),('common','forums_your_name','en','Your Name',NULL,NULL),('common','forum_direct_notification','en','Notification',NULL,NULL),('common','forum_notify_me','en','Notify me when a direct answer has been given to this post. Notification about any post in this thread or forum can be enabled in the upper right Actions menu.',NULL,NULL),('common','forum_post_replied','en','Your forum entry has been replied.',NULL,NULL),('common','frm','en','Forum',NULL,NULL),('common','frm_add','en','Add Forum',NULL,NULL),('common','frm_added','en','Forum added',NULL,NULL),('common','frm_edit','en','Edit Forum',NULL,NULL),('common','frm_import','en','Import Forum',NULL,NULL),('common','frm_latest_postings','en','Latest Posts',NULL,NULL),('common','frm_new','en','New Forum',NULL,NULL),('common','frm_no_threads','en','There are no threads available at the moment.',NULL,NULL),('common','from','en','From',NULL,NULL),('common','fullname','en','Full name',NULL,NULL),('common','functions','en','Functions',NULL,NULL),('common','further_informations','en','Further Information',NULL,NULL),('common','gdf_add','en','Add Definition',NULL,NULL),('common','gdf_new','en','New Definition',NULL,NULL),('common','gender','en','Salutation',NULL,NULL),('common','gender_f','en','Ms.',NULL,NULL),('common','gender_m','en','Mr.',NULL,NULL),('common','gender_n','en','Not stated',NULL,NULL),('common','general','en','General',NULL,NULL),('common','general_settings','en','General Settings',NULL,NULL),('common','generate','en','Generate',NULL,NULL),('common','ghostscript_not_configured','en','Ghostscript is not configured. Please open the <a href=\"cli/setup.php?cmd=mastersettings\" target=\"_blank\">Setup</a> to configure it.',NULL,NULL),('common','glo','en','Glossary',NULL,NULL),('common','global','en','Global',NULL,NULL),('common','global_default','en','Global Default',NULL,NULL),('common','global_fixed','en','Global Fixed',NULL,NULL),('common','global_role_assignment','en','Global Role Assignment',NULL,NULL),('common','global_settings','en','Global settings',NULL,NULL),('common','global_user','en','Global users',NULL,NULL),('common','glossaries','en','Glossaries',NULL,NULL),('common','glossary','en','Glossary',NULL,NULL),('common','glo_add','en','Add Glossary',NULL,NULL),('common','glo_added','en','Glossary added',NULL,NULL),('common','glo_import','en','Import Glossary',NULL,NULL),('common','glo_mode','en','Mode',NULL,NULL),('common','glo_mode_desc','en','A virtual glossary works like a normal glossary. Additionally it contains the terms from all glossaries that are located on the same level in the repository like the virtual glossary (level) respectively from all glossaries that are located downwards in the repository from the position of the virtual glossary (subtree).',NULL,NULL),('common','glo_mode_normal','en','Standard Glossary',NULL,NULL),('common','glo_new','en','New Glossary',NULL,NULL),('common','go','en','Go',NULL,NULL),('common','grade','en','Grade',NULL,NULL),('common','group','en','Group',NULL,NULL),('common','groupings','en','Membership Limitations',NULL,NULL),('common','groupings_assigned_obj_crs','en','Assigned Courses',NULL,NULL),('common','groupings_assigned_obj_grp','en','Assigned Groups',NULL,NULL),('common','groups','en','Groups',NULL,NULL),('common','group_members','en','Group Members',NULL,NULL),('common','group_name','en','Group Name',NULL,NULL),('common','group_new_registrations','en','Join Requests',NULL,NULL),('common','group_password_registration_msg','en','If you know the group password, you can join this group. Please contact a group administrator, if you don\'t know the password.',NULL,NULL),('common','group_registration','en','Registration',NULL,NULL),('common','group_registration_mode','en','Registration Procedure',NULL,NULL),('common','group_registration_time','en','Registration Period',NULL,NULL),('common','group_req_direct','en','Join directly',NULL,NULL),('common','group_req_registration_msg','en','You have to request for membership to access this group. Please describe your interest for becoming member in the message form. You will be notified as soon as an administrator has accepted or declined your request.',NULL,NULL),('common','group_status','en','Group is',NULL,NULL),('common','grp','en','Group',NULL,NULL),('common','grpr','en','Group Link',NULL,NULL),('common','grpr_add','en','Add Group Link',NULL,NULL),('common','grpr_edit','en','Edit Group Link',NULL,NULL),('common','grpr_edit_info','en','Please choose one group for creating a new group link.',NULL,NULL),('common','grpr_new','en','Create Group Link',NULL,NULL),('common','grpr_settings','en','Group Link Settings',NULL,NULL),('common','grp_add','en','Add Group',NULL,NULL),('common','grp_added','en','Group added',NULL,NULL),('common','grp_btn_unsubscribe','en','Unsubscribe from Group',NULL,NULL),('common','grp_cancel_waiting_list','en','Do you really want to remove yourself from the waiting list of group \"%s\"?',NULL,NULL),('common','grp_copy_threads_info','en','Please decide which materials should be copied, linked or even omitted.',NULL,NULL),('common','grp_deleted_export_files','en','Deleted selected files.',NULL,NULL),('common','grp_dismiss_member','en','Are you sure you want to unsubscribe the following member(s) from the group?',NULL,NULL),('common','grp_dismiss_myself','en','Are you sure you want to unsubscribe from this group?',NULL,NULL),('common','grp_edit','en','Edit Group',NULL,NULL),('common','grp_err_administrator_required','en','Member could not be removed, at least one administrator per group is required !',NULL,NULL),('common','grp_header_edit_members','en','Edit members',NULL,NULL),('common','grp_list_members','en','List Members',NULL,NULL),('common','grp_list_reg','en','Registration',NULL,NULL),('common','grp_list_reg_end','en','Registration End',NULL,NULL),('common','grp_list_reg_limit_full','en','No places left',NULL,NULL),('common','grp_list_reg_limit_places','en','Free places',NULL,NULL),('common','grp_list_reg_noreg','en','No Registration Possible',NULL,NULL),('common','grp_list_reg_period','en','Registration Period',NULL,NULL),('common','grp_list_reg_start','en','Registration Begin',NULL,NULL),('common','grp_list_users','en','List Users',NULL,NULL),('common','grp_members_gallery','en','Group Members Gallery',NULL,NULL),('common','grp_mem_change_status','en','Change Participant Status',NULL,NULL),('common','grp_mem_send_mail','en','Send member a mail',NULL,NULL),('common','grp_msg_applicants_assigned','en','Applicant(s) assigned as group member(s)',NULL,NULL),('common','grp_msg_membership_annulled','en','Cancelled membership.',NULL,NULL),('common','grp_msg_member_assigned','en','User(s) assigned as group member(s)',NULL,NULL),('common','grp_new','en','New Group',NULL,NULL),('common','grp_registration','en','Join Group',NULL,NULL),('common','grp_registration_completed','en','You have joined the group',NULL,NULL),('common','grp_removed_from_waiting_list','en','You have been detached from the waiting list of group \"%s\".',NULL,NULL),('common','grp_select_one_file','en','Please select one file.',NULL,NULL),('common','grp_wizard_page','en','Copy Group (Step 2/2)',NULL,NULL),('common','header_action','en','Insert Heading - Click to insert a heading.',NULL,NULL),('common','header_searchable','en','Searchable',NULL,NULL),('common','header_title','en','Header Title',NULL,NULL),('common','header_visible_registration','en','Visible in Registration',NULL,NULL),('common','header_zip','en','Upload Zip-Archive of Multiple Files',NULL,NULL),('common','height','en','Height',NULL,NULL),('common','help','en','Help',NULL,NULL),('common','HH','en','HH:MM',NULL,NULL),('common','hide','en','Hide',NULL,NULL),('common','hide_all_details','en','Hide all details',NULL,NULL),('common','hide_details','en','Hide Details',NULL,NULL),('common','hide_filter','en','Hide Filter',NULL,NULL),('common','hide_own_online_status','en','Hide My Online Status',NULL,NULL),('common','hide_visible_sections','en','Hide More Information &raquo;',NULL,NULL),('common','hint','en','Hint',NULL,NULL),('common','history','en','History',NULL,NULL),('common','hist_lm_delete_pg','en','Page \"%1\" [%2] has been deleted.',NULL,NULL),('common','hist_lm_delete_st','en','Chapter \"%1\" [%2] has been deleted.',NULL,NULL),('common','hist_lm_pg_create','en','Page created.',NULL,NULL),('common','hist_lm_pg_update','en','Page changed.',NULL,NULL),('common','hist_lm_st_create','en','Chapter created.',NULL,NULL),('common','hist_webr_add','en','Added new Weblink with title: \"%1\"',NULL,NULL),('common','hist_webr_delete','en','Deleted Weblink with title: \"%1\"',NULL,NULL),('common','hist_webr_update','en','Modified Weblink with title: \"%1\"',NULL,NULL),('common','hobby','en','Interests/Hobbies',NULL,NULL),('common','home','en','Public Area',NULL,NULL),('common','host','en','Host',NULL,NULL),('common','hour','en','Hour',NULL,NULL),('common','hours','en','Hours',NULL,NULL),('common','htlm','en','Learning Module HTML',NULL,NULL),('common','htlm_add','en','Add HTML Learning Module',NULL,NULL),('common','htlm_new','en','New HTML Learning Module',NULL,NULL),('common','http','en','HTTP',NULL,NULL),('common','https_not_possible','en','This server is not supporting HTTPS connections.',NULL,NULL),('common','http_not_possible','en','This server is not supporting http requests.',NULL,NULL),('common','http_path','en','HTTP Path',NULL,NULL),('common','i2passwd','en','ILIAS 2 password',NULL,NULL),('common','iass_import','en','Import Individual Assessment',NULL,NULL),('common','iass_new','en','Create Individual Assessment',NULL,NULL),('common','icon','en','Icon',NULL,NULL),('common','icon_settings','en','Custom Icons',NULL,NULL),('common','id','en','ID',NULL,NULL),('common','identifier','en','Identifier',NULL,NULL),('common','if_no_title_then_filename','en','Leave blank to use file name as title.',NULL,NULL),('common','ignore_on_conflict','en','Insert/Update action will be followed strictly',NULL,NULL),('common','ignore_required_fields','en','Ignore required fields',NULL,NULL),('common','ignore_required_fields_info','en','If activated, you can submit this form without filling out all mandatory fields. The new user has to add the missing information on the personal profile after the next login.',NULL,NULL),('common','ilias_version','en','ILIAS version',NULL,NULL),('common','il_astpl_loc_initial','en','Initial Test',NULL,NULL),('common','il_astpl_loc_qualified','en','Qualifying Test',NULL,NULL),('common','il_blog_contributor','en','Blog Author',NULL,NULL),('common','il_blog_editor','en','Blog Editor',NULL,NULL),('common','il_chat_moderator','en','Chat Moderator',NULL,NULL),('common','il_crs_admin','en','Course Administrator',NULL,NULL),('common','il_crs_member','en','Course Member',NULL,NULL),('common','il_crs_non_member','en','Course non-member',NULL,NULL),('common','il_crs_tutor','en','Course Tutor',NULL,NULL),('common','il_frm_moderator','en','Forum moderator',NULL,NULL),('common','il_grp_admin','en','Group Administrator',NULL,NULL),('common','il_grp_member','en','Group Member',NULL,NULL),('common','il_grp_status_closed','en','Group closed',NULL,NULL),('common','il_grp_status_open','en','Group open',NULL,NULL),('common','il_iass_member','en','Participant',NULL,NULL),('common','il_lso_admin','en','Learning Sequence Admin',NULL,NULL),('common','il_lso_member','en','Learning Sequence Member',NULL,NULL),('common','il_lti_instructor','en','LTI Instructor',NULL,NULL),('common','il_lti_learner','en','LTI Learner',NULL,NULL),('common','il_lti_user','en','LTI User',NULL,NULL),('common','il_orgu_employee','en','Employee',NULL,NULL),('common','il_orgu_superior','en','Superior',NULL,NULL),('common','image','en','Image',NULL,NULL),('common','import','en','Import',NULL,NULL),('common','important','en','Important',NULL,NULL),('common','imported','en','imported',NULL,NULL),('common','import_categories','en','Import Categories',NULL,NULL),('common','import_cat_localrol','en','Create local role for every new category',NULL,NULL),('common','import_cat_table','en','The following table is only meaningful if the checkbox is set',NULL,NULL),('common','import_failure_log','en','Import failure log',NULL,NULL),('common','import_file','en','Import File',NULL,NULL),('common','import_file_not_valid_here','en','The import file is not valid or the contained object type cannot be imported here.',NULL,NULL),('common','import_finished','en','Number of imported messages.',NULL,NULL),('common','import_lm','en','Import ILIAS Learning module',NULL,NULL),('common','import_qpl','en','Import Question Pool for Tests',NULL,NULL),('common','import_questions_into_qpl','en','Import question(s) into question pool',NULL,NULL),('common','import_sahs','en','Import SCORM Package',NULL,NULL),('common','import_sahs_info','en','To correct typos or images, use the option to replace individual files via the file directory. Upload a SCORM export from your authoring tool here and not an ILIAS export file. Make sure that your authoring tool has retained the IDs in the manifest file. Attention: Even popular authoring tools cannot do this. SCORM learning modules of certain authoring tools discard learner data obtained if you change the number of answer options of questions or insert new questions. Check in a test installation whether learning statuses that have already been achieved are possible when learning modules that have already been started are called up again.',NULL,NULL),('common','import_sahs_new','en','Import New Version of SCORM Package',NULL,NULL),('common','import_svy','en','Import Survey',NULL,NULL),('common','import_tst','en','Import Test',NULL,NULL),('common','import_users','en','Import Users',NULL,NULL),('common','import_warning_log','en','Import warning log',NULL,NULL),('common','imprint','en','Legal Notice',NULL,NULL),('common','in','en','in',NULL,NULL),('common','inactive','en','Inactive',NULL,NULL),('common','inbox','en','Inbox',NULL,NULL),('common','include_local','en','include custom language file when updating language',NULL,NULL),('common','info','en','Information',NULL,NULL),('common','inform_user_mail','en','Send mail to inform user about changes',NULL,NULL),('common','info_access_and_status_info','en','Access- and status information',NULL