<?php
/**
 * Admin View: Product import form
 *
 * @package Kkart\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<form class="kkart-progress-form-content kkart-importer" enctype="multipart/form-data" method="post">
	<header>
		<h2><?php esc_html_e( 'Import products from a CSV file', 'kkart' ); ?></h2>
		<p><?php esc_html_e( 'This tool allows you to import (or merge) product data to your store from a CSV or TXT file.', 'kkart' ); ?></p>
	</header>
	<section>
		<table class="form-table kkart-importer-options">
			<tbody>
				<tr>
					<th scope="row">
						<label for="upload">
							<?php esc_html_e( 'Choose a CSV file from your computer:', 'kkart' ); ?>
						</label>
					</th>
					<td>
						<?php
						if ( ! empty( $upload_dir['error'] ) ) {
							?>
							<div class="inline error">
								<p><?php esc_html_e( 'Before you can upload your import file, you will need to fix the following error:', 'kkart' ); ?></p>
								<p><strong><?php echo esc_html( $upload_dir['error'] ); ?></strong></p>
							</div>
							<?php
						} else {
							?>
							<input type="file" id="upload" name="import" size="25" />
							<input type="hidden" name="action" value="save" />
							<input type="hidden" name="max_file_size" value="<?php echo esc_attr( $bytes ); ?>" />
							<br>
							<small>
								<?php
								printf(
									/* translators: %s: maximum upload size */
									esc_html__( 'Maximum size: %s', 'kkart' ),
									esc_html( $size )
								);
								?>
							</small>
							<?php
						}
						?>
					</td>
				</tr>
				<tr>
					<th><label for="kkart-importer-update-existing"><?php esc_html_e( 'Update existing products', 'kkart' ); ?></label><br/></th>
					<td>
						<input type="hidden" name="update_existing" value="0" />
						<input type="checkbox" id="kkart-importer-update-existing" name="update_existing" value="1" />
						<label for="kkart-importer-update-existing"><?php esc_html_e( 'Existing products that match by ID or SKU will be updated. Products that do not exist will be skipped.', 'kkart' ); ?></label>
					</td>
				</tr>
				<tr class="kkart-importer-advanced hidden">
					<th>
						<label for="kkart-importer-file-url"><?php esc_html_e( 'Alternatively, enter the path to a CSV file on your server:', 'kkart' ); ?></label>
					</th>
					<td>
						<label for="kkart-importer-file-url" class="kkart-importer-file-url-field-wrapper">
							<code><?php echo esc_html( ABSPATH ) . ' '; ?></code><input type="text" id="kkart-importer-file-url" name="file_url" />
						</label>
					</td>
				</tr>
				<tr class="kkart-importer-advanced hidden">
					<th><label><?php esc_html_e( 'CSV Delimiter', 'kkart' ); ?></label><br/></th>
					<td><input type="text" name="delimiter" placeholder="," size="2" /></td>
				</tr>
				<tr class="kkart-importer-advanced hidden">
					<th><label><?php esc_html_e( 'Use previous column mapping preferences?', 'kkart' ); ?></label><br/></th>
					<td><input type="checkbox" id="kkart-importer-map-preferences" name="map_preferences" value="1" /></td>
				</tr>
			</tbody>
		</table>
	</section>
	<script type="text/javascript">
		jQuery(function() {
			jQuery( '.kkart-importer-toggle-advanced-options' ).on( 'click', function() {
				var elements = jQuery( '.kkart-importer-advanced' );
				if ( elements.is( '.hidden' ) ) {
					elements.removeClass( 'hidden' );
					jQuery( this ).text( jQuery( this ).data( 'hidetext' ) );
				} else {
					elements.addClass( 'hidden' );
					jQuery( this ).text( jQuery( this ).data( 'showtext' ) );
				}
				return false;
			} );
		});
	</script>
	<div class="kkart-actions">
		<a href="#" class="kkart-importer-toggle-advanced-options" data-hidetext="<?php esc_attr_e( 'Hide advanced options', 'kkart' ); ?>" data-showtext="<?php esc_attr_e( 'Show advanced options', 'kkart' ); ?>"><?php esc_html_e( 'Show advanced options', 'kkart' ); ?></a>
		<button type="submit" class="button button-primary button-next" value="<?php esc_attr_e( 'Continue', 'kkart' ); ?>" name="save_step"><?php esc_html_e( 'Continue', 'kkart' ); ?></button>
		<?php wp_nonce_field( 'kkart-csv-importer' ); ?>
	</div>
</form>
