<?php
/**
 * Kkart Account Settings.
 *
 * @package Kkart\Admin
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'KKART_Settings_Accounts', false ) ) {
	return new KKART_Settings_Accounts();
}

/**
 * KKART_Settings_Accounts.
 */
class KKART_Settings_Accounts extends KKART_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'account';
		$this->label = __( 'Accounts &amp; Privacy', 'kkart' );
		parent::__construct();
	}

	/**
	 * Get settings array.
	 *
	 * @return array
	 */
	public function get_settings() {
		$erasure_text = esc_html__( 'account erasure request', 'kkart' );
		$privacy_text = esc_html__( 'privacy page', 'kkart' );
		if ( current_user_can( 'manage_privacy_options' ) ) {
			if ( version_compare( get_bloginfo( 'version' ), '5.3', '<' ) ) {
				$erasure_text = sprintf( '<a href="%s">%s</a>', esc_url( admin_url( 'tools.php?page=remove_personal_data' ) ), $erasure_text );
			} else {
				$erasure_text = sprintf( '<a href="%s">%s</a>', esc_url( admin_url( 'erase-personal-data.php' ) ), $erasure_text );
			}
			$privacy_text = sprintf( '<a href="%s">%s</a>', esc_url( admin_url( 'options-privacy.php' ) ), $privacy_text );
		}

		$account_settings = array(
			array(
				'title' => '',
				'type'  => 'title',
				'id'    => 'account_registration_options',
			),
			array(
				'title'         => __( 'Guest checkout', 'kkart' ),
				'desc'          => __( 'Allow customers to place orders without an account', 'kkart' ),
				'id'            => 'kkart_enable_guest_checkout',
				'default'       => 'yes',
				'type'          => 'checkbox',
				'checkboxgroup' => 'start',
				'autoload'      => false,
			),
			array(
				'title'         => __( 'Login', 'kkart' ),
				'desc'          => __( 'Allow customers to log into an existing account during checkout', 'kkart' ),
				'id'            => 'kkart_enable_checkout_login_reminder',
				'default'       => 'no',
				'type'          => 'checkbox',
				'checkboxgroup' => 'end',
				'autoload'      => false,
			),
			array(
				'title'         => __( 'Account creation', 'kkart' ),
				'desc'          => __( 'Allow customers to create an account during checkout', 'kkart' ),
				'id'            => 'kkart_enable_signup_and_login_from_checkout',
				'default'       => 'no',
				'type'          => 'checkbox',
				'checkboxgroup' => 'start',
				'autoload'      => false,
			),
			array(
				'desc'          => __( 'Allow customers to create an account on the "My account" page', 'kkart' ),
				'id'            => 'kkart_enable_myaccount_registration',
				'default'       => 'no',
				'type'          => 'checkbox',
				'checkboxgroup' => '',
				'autoload'      => false,
			),
			array(
				'desc'          => __( 'When creating an account, automatically generate an account username for the customer based on their name, surname or email', 'kkart' ),
				'id'            => 'kkart_registration_generate_username',
				'default'       => 'yes',
				'type'          => 'checkbox',
				'checkboxgroup' => '',
				'autoload'      => false,
			),
			array(
				'desc'          => __( 'When creating an account, automatically generate an account password', 'kkart' ),
				'id'            => 'kkart_registration_generate_password',
				'default'       => 'yes',
				'type'          => 'checkbox',
				'checkboxgroup' => 'end',
				'autoload'      => false,
			),
			array(
				'title'         => __( 'Account erasure requests', 'kkart' ),
				'desc'          => __( 'Remove personal data from orders on request', 'kkart' ),
				/* Translators: %s URL to erasure request screen. */
				'desc_tip'      => sprintf( esc_html__( 'When handling an %s, should personal data within orders be retained or removed?', 'kkart' ), $erasure_text ),
				'id'            => 'kkart_erasure_request_removes_order_data',
				'type'          => 'checkbox',
				'default'       => 'no',
				'checkboxgroup' => 'start',
				'autoload'      => false,
			),
			array(
				'desc'          => __( 'Remove access to downloads on request', 'kkart' ),
				/* Translators: %s URL to erasure request screen. */
				'desc_tip'      => sprintf( esc_html__( 'When handling an %s, should access to downloadable files be revoked and download logs cleared?', 'kkart' ), $erasure_text ),
				'id'            => 'kkart_erasure_request_removes_download_data',
				'type'          => 'checkbox',
				'default'       => 'no',
				'checkboxgroup' => 'end',
				'autoload'      => false,
			),
			array(
				'title'         => __( 'Personal data removal', 'kkart' ),
				'desc'          => __( 'Allow personal data to be removed in bulk from orders', 'kkart' ),
				'desc_tip'      => __( 'Adds an option to the orders screen for removing personal data in bulk. Note that removing personal data cannot be undone.', 'kkart' ),
				'id'            => 'kkart_allow_bulk_remove_personal_data',
				'type'          => 'checkbox',
				'checkboxgroup' => 'start',
				'default'       => 'no',
				'autoload'      => false,
			),
			array(
				'type' => 'sectionend',
				'id'   => 'account_registration_options',
			),
			array(
				'title' => __( 'Privacy policy', 'kkart' ),
				'type'  => 'title',
				'id'    => 'privacy_policy_options',
				/* translators: %s: privacy page link. */
				'desc'  => sprintf( esc_html__( 'This section controls the display of your website privacy policy. The privacy notices below will not show up unless a %s is set.', 'kkart' ), $privacy_text ),
			),

			array(
				'title'    => __( 'Registration privacy policy', 'kkart' ),
				'desc_tip' => __( 'Optionally add some text about your store privacy policy to show on account registration forms.', 'kkart' ),
				'id'       => 'kkart_registration_privacy_policy_text',
				/* translators: %s privacy policy page name and link */
				'default'  => sprintf( __( 'Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our %s.', 'kkart' ), '[privacy_policy]' ),
				'type'     => 'textarea',
				'css'      => 'min-width: 50%; height: 75px;',
			),

			array(
				'title'    => __( 'Checkout privacy policy', 'kkart' ),
				'desc_tip' => __( 'Optionally add some text about your store privacy policy to show during checkout.', 'kkart' ),
				'id'       => 'kkart_checkout_privacy_policy_text',
				/* translators: %s privacy policy page name and link */
				'default'  => sprintf( __( 'Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our %s.', 'kkart' ), '[privacy_policy]' ),
				'type'     => 'textarea',
				'css'      => 'min-width: 50%; height: 75px;',
			),
			array(
				'type' => 'sectionend',
				'id'   => 'privacy_policy_options',
			),
			array(
				'title' => __( 'Personal data retention', 'kkart' ),
				'desc'  => __( 'Choose how long to retain personal data when it\'s no longer needed for processing. Leave the following options blank to retain this data indefinitely.', 'kkart' ),
				'type'  => 'title',
				'id'    => 'personal_data_retention',
			),
			array(
				'title'       => __( 'Retain inactive accounts ', 'kkart' ),
				'desc_tip'    => __( 'Inactive accounts are those which have not logged in, or placed an order, for the specified duration. They will be deleted. Any orders will be converted into guest orders.', 'kkart' ),
				'id'          => 'kkart_delete_inactive_accounts',
				'type'        => 'relative_date_selector',
				'placeholder' => __( 'N/A', 'kkart' ),
				'default'     => array(
					'number' => '',
					'unit'   => 'months',
				),
				'autoload'    => false,
			),
			array(
				'title'       => __( 'Retain pending orders ', 'kkart' ),
				'desc_tip'    => __( 'Pending orders are unpaid and may have been abandoned by the customer. They will be trashed after the specified duration.', 'kkart' ),
				'id'          => 'kkart_trash_pending_orders',
				'type'        => 'relative_date_selector',
				'placeholder' => __( 'N/A', 'kkart' ),
				'default'     => '',
				'autoload'    => false,
			),
			array(
				'title'       => __( 'Retain failed orders', 'kkart' ),
				'desc_tip'    => __( 'Failed orders are unpaid and may have been abandoned by the customer. They will be trashed after the specified duration.', 'kkart' ),
				'id'          => 'kkart_trash_failed_orders',
				'type'        => 'relative_date_selector',
				'placeholder' => __( 'N/A', 'kkart' ),
				'default'     => '',
				'autoload'    => false,
			),
			array(
				'title'       => __( 'Retain cancelled orders', 'kkart' ),
				'desc_tip'    => __( 'Cancelled orders are unpaid and may have been cancelled by the store owner or customer. They will be trashed after the specified duration.', 'kkart' ),
				'id'          => 'kkart_trash_cancelled_orders',
				'type'        => 'relative_date_selector',
				'placeholder' => __( 'N/A', 'kkart' ),
				'default'     => '',
				'autoload'    => false,
			),
			array(
				'title'       => __( 'Retain completed orders', 'kkart' ),
				'desc_tip'    => __( 'Retain completed orders for a specified duration before anonymizing the personal data within them.', 'kkart' ),
				'id'          => 'kkart_anonymize_completed_orders',
				'type'        => 'relative_date_selector',
				'placeholder' => __( 'N/A', 'kkart' ),
				'default'     => array(
					'number' => '',
					'unit'   => 'months',
				),
				'autoload'    => false,
			),
			array(
				'type' => 'sectionend',
				'id'   => 'personal_data_retention',
			),
		);

		$settings = apply_filters(
			'kkart_' . $this->id . '_settings',
			$account_settings
		);

		return apply_filters( 'kkart_get_settings_' . $this->id, $settings );
	}
}

return new KKART_Settings_Accounts();
