<?php
/**
 * Kkart Product Settings
 *
 * @package Kkart\Admin
 * @version 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( class_exists( 'KKART_Settings_Products', false ) ) {
	return new KKART_Settings_Products();
}

/**
 * KKART_Settings_Products.
 */
class KKART_Settings_Products extends KKART_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'products';
		$this->label = __( 'Products', 'kkart' );

		parent::__construct();
	}

	/**
	 * Get sections.
	 *
	 * @return array
	 */
	public function get_sections() {
		$sections = array(
			''             => __( 'General', 'kkart' ),
			'inventory'    => __( 'Inventory', 'kkart' ),
			'downloadable' => __( 'Downloadable products', 'kkart' ),
		);

		return apply_filters( 'kkart_get_sections_' . $this->id, $sections );
	}

	/**
	 * Output the settings.
	 */
	public function output() {
		global $current_section;

		$settings = $this->get_settings( $current_section );

		KKART_Admin_Settings::output_fields( $settings );
	}

	/**
	 * Save settings.
	 */
	public function save() {
		global $current_section;

		$settings = $this->get_settings( $current_section );
		KKART_Admin_Settings::save_fields( $settings );

		if ( $current_section ) {
			do_action( 'kkart_update_options_' . $this->id . '_' . $current_section );
		}
	}

	/**
	 * Get settings array.
	 *
	 * @param string $current_section Current section name.
	 * @return array
	 */
	public function get_settings( $current_section = '' ) {
		if ( 'inventory' === $current_section ) {
			$settings = apply_filters(
				'kkart_inventory_settings',
				array(
					array(
						'title' => __( 'Inventory', 'kkart' ),
						'type'  => 'title',
						'desc'  => '',
						'id'    => 'product_inventory_options',
					),

					array(
						'title'   => __( 'Manage stock', 'kkart' ),
						'desc'    => __( 'Enable stock management', 'kkart' ),
						'id'      => 'kkart_manage_stock',
						'default' => 'yes',
						'type'    => 'checkbox',
					),

					array(
						'title'             => __( 'Hold stock (minutes)', 'kkart' ),
						'desc'              => __( 'Hold stock (for unpaid orders) for x minutes. When this limit is reached, the pending order will be cancelled. Leave blank to disable.', 'kkart' ),
						'id'                => 'kkart_hold_stock_minutes',
						'type'              => 'number',
						'custom_attributes' => array(
							'min'  => 0,
							'step' => 1,
						),
						'css'               => 'width: 80px;',
						'default'           => '60',
						'autoload'          => false,
						'class'             => 'manage_stock_field',
					),

					array(
						'title'         => __( 'Notifications', 'kkart' ),
						'desc'          => __( 'Enable low stock notifications', 'kkart' ),
						'id'            => 'kkart_notify_low_stock',
						'default'       => 'yes',
						'type'          => 'checkbox',
						'checkboxgroup' => 'start',
						'autoload'      => false,
						'class'         => 'manage_stock_field',
					),

					array(
						'desc'          => __( 'Enable out of stock notifications', 'kkart' ),
						'id'            => 'kkart_notify_no_stock',
						'default'       => 'yes',
						'type'          => 'checkbox',
						'checkboxgroup' => 'end',
						'autoload'      => false,
						'class'         => 'manage_stock_field',
					),

					array(
						'title'    => __( 'Notification recipient(s)', 'kkart' ),
						'desc'     => __( 'Enter recipients (comma separated) that will receive this notification.', 'kkart' ),
						'id'       => 'kkart_stock_email_recipient',
						'type'     => 'text',
						'default'  => get_option( 'admin_email' ),
						'css'      => 'width: 250px;',
						'autoload' => false,
						'desc_tip' => true,
						'class'    => 'manage_stock_field',
					),

					array(
						'title'             => __( 'Low stock threshold', 'kkart' ),
						'desc'              => __( 'When product stock reaches this amount you will be notified via email.', 'kkart' ),
						'id'                => 'kkart_notify_low_stock_amount',
						'css'               => 'width:50px;',
						'type'              => 'number',
						'custom_attributes' => array(
							'min'  => 0,
							'step' => 1,
						),
						'default'           => '2',
						'autoload'          => false,
						'desc_tip'          => true,
						'class'             => 'manage_stock_field',
					),

					array(
						'title'             => __( 'Out of stock threshold', 'kkart' ),
						'desc'              => __( 'When product stock reaches this amount the stock status will change to "out of stock" and you will be notified via email. This setting does not affect existing "in stock" products.', 'kkart' ),
						'id'                => 'kkart_notify_no_stock_amount',
						'css'               => 'width:50px;',
						'type'              => 'number',
						'custom_attributes' => array(
							'min'  => 0,
							'step' => 1,
						),
						'default'           => '0',
						'desc_tip'          => true,
						'class'             => 'manage_stock_field',
					),

					array(
						'title'   => __( 'Out of stock visibility', 'kkart' ),
						'desc'    => __( 'Hide out of stock items from the catalog', 'kkart' ),
						'id'      => 'kkart_hide_out_of_stock_items',
						'default' => 'no',
						'type'    => 'checkbox',
					),

					array(
						'title'    => __( 'Stock display format', 'kkart' ),
						'desc'     => __( 'This controls how stock quantities are displayed on the frontend.', 'kkart' ),
						'id'       => 'kkart_stock_format',
						'css'      => 'min-width:150px;',
						'class'    => 'kkart-enhanced-select',
						'default'  => '',
						'type'     => 'select',
						'options'  => array(
							''           => __( 'Always show quantity remaining in stock e.g. "12 in stock"', 'kkart' ),
							'low_amount' => __( 'Only show quantity remaining in stock when low e.g. "Only 2 left in stock"', 'kkart' ),
							'no_amount'  => __( 'Never show quantity remaining in stock', 'kkart' ),
						),
						'desc_tip' => true,
					),

					array(
						'type' => 'sectionend',
						'id'   => 'product_inventory_options',
					),

				)
			);

		} elseif ( 'downloadable' === $current_section ) {
			$settings = apply_filters(
				'kkart_downloadable_products_settings',
				array(
					array(
						'title' => __( 'Downloadable products', 'kkart' ),
						'type'  => 'title',
						'id'    => 'digital_download_options',
					),

					array(
						'title'    => __( 'File download method', 'kkart' ),
						'desc_tip' => sprintf(
							/* translators: 1: X-Accel-Redirect 2: X-Sendfile 3: mod_xsendfile */
							__( 'Forcing downloads will keep URLs hidden, but some servers may serve large files unreliably. If supported, %1$s / %2$s can be used to serve downloads instead (server requires %3$s).', 'kkart' ),
							'<code>X-Accel-Redirect</code>',
							'<code>X-Sendfile</code>',
							'<code>mod_xsendfile</code>'
						),
						'id'       => 'kkart_file_download_method',
						'type'     => 'select',
						'class'    => 'kkart-enhanced-select',
						'css'      => 'min-width:300px;',
						'default'  => 'force',
						'desc'     => sprintf(
							// translators: Link to Kkart Docs.
							__( "If you are using X-Accel-Redirect download method along with NGINX server, make sure that you have applied settings as described in <a href='%s'>Digital/Downloadable Product Handling</a> guide.", 'kkart' ),
							'https://docs.kkart.com/document/digital-downloadable-product-handling#nginx-setting'
						),
						'options'  => array(
							'force'     => __( 'Force downloads', 'kkart' ),
							'xsendfile' => __( 'X-Accel-Redirect/X-Sendfile', 'kkart' ),
							'redirect'  => apply_filters( 'kkart_redirect_only_method_is_secure', false ) ? __( 'Redirect only', 'kkart' ) : __( 'Redirect only (Insecure)', 'kkart' ),
						),
						'autoload' => false,
					),

					array(
						'title'         => __( 'Access restriction', 'kkart' ),
						'desc'          => __( 'Downloads require login', 'kkart' ),
						'id'            => 'kkart_downloads_require_login',
						'type'          => 'checkbox',
						'default'       => 'no',
						'desc_tip'      => __( 'This setting does not apply to guest purchases.', 'kkart' ),
						'checkboxgroup' => 'start',
						'autoload'      => false,
					),

					array(
						'desc'          => __( 'Grant access to downloadable products after payment', 'kkart' ),
						'id'            => 'kkart_downloads_grant_access_after_payment',
						'type'          => 'checkbox',
						'default'       => 'yes',
						'desc_tip'      => __( 'Enable this option to grant access to downloads when orders are "processing", rather than "completed".', 'kkart' ),
						'checkboxgroup' => 'end',
						'autoload'      => false,
					),

					array(
						'title' => __( 'Filename', 'kkart' ),
						'desc' => __( 'Append a unique string to filename for security', 'kkart' ),
						'id' => 'kkart_downloads_add_hash_to_filename',
						'type' => 'checkbox',
						'default' => 'yes',
						'desc_tip' => sprintf(
							// translators: Link to Kkart Docs.
							__( "Not required if your download directory is protected. <a href='%s'>See this guide</a> for more details. Files already uploaded will not be affected.", 'kkart' ),
							'https://docs.kkart.com/document/digital-downloadable-product-handling#unique-string'
						),
					),

					array(
						'type' => 'sectionend',
						'id'   => 'digital_download_options',
					),

				)
			);

		} else {
			$settings = apply_filters(
				'kkart_product_settings',
				apply_filters(
					'kkart_products_general_settings',
					array(
						array(
							'title' => __( 'Shop pages', 'kkart' ),
							'type'  => 'title',
							'desc'  => '',
							'id'    => 'catalog_options',
						),
						array(
							'title'    => __( 'Shop page', 'kkart' ),
							/* translators: %s: URL to settings. */
							'desc'     => sprintf( __( 'The base page can also be used in your <a href="%s">product permalinks</a>.', 'kkart' ), admin_url( 'options-permalink.php' ) ),
							'id'       => 'kkart_shop_page_id',
							'type'     => 'single_select_page',
							'default'  => '',
							'args'     => array( 'post_status' => 'publish,private' ),
							'class'    => 'kkart-enhanced-select-nostd',
							'css'      => 'min-width:300px;',
							'desc_tip' => __( 'This sets the base page of your shop - this is where your product archive will be.', 'kkart' ),
						),
						array(
							'title'         => __( 'Add to cart behaviour', 'kkart' ),
							'desc'          => __( 'Redirect to the cart page after successful addition', 'kkart' ),
							'id'            => 'kkart_cart_redirect_after_add',
							'default'       => 'no',
							'type'          => 'checkbox',
							'checkboxgroup' => 'start',
						),
						array(
							'desc'          => __( 'Enable AJAX add to cart buttons on archives', 'kkart' ),
							'id'            => 'kkart_enable_ajax_add_to_cart',
							'default'       => 'yes',
							'type'          => 'checkbox',
							'checkboxgroup' => 'end',
						),
						array(
							'title'       => __( 'Placeholder image', 'kkart' ),
							'id'          => 'kkart_placeholder_image',
							'type'        => 'text',
							'default'     => '',
							'class'       => '',
							'css'         => '',
							'placeholder' => __( 'Enter attachment ID or URL to an image', 'kkart' ),
							'desc_tip'    => __( 'This is the attachment ID, or image URL, used for placeholder images in the product catalog. Products with no image will use this.', 'kkart' ),
						),
						array(
							'type' => 'sectionend',
							'id'   => 'catalog_options',
						),

						array(
							'title' => __( 'Measurements', 'kkart' ),
							'type'  => 'title',
							'id'    => 'product_measurement_options',
						),

						array(
							'title'    => __( 'Weight unit', 'kkart' ),
							'desc'     => __( 'This controls what unit you will define weights in.', 'kkart' ),
							'id'       => 'kkart_weight_unit',
							'class'    => 'kkart-enhanced-select',
							'css'      => 'min-width:300px;',
							'default'  => 'kg',
							'type'     => 'select',
							'options'  => array(
								'kg'  => __( 'kg', 'kkart' ),
								'g'   => __( 'g', 'kkart' ),
								'lbs' => __( 'lbs', 'kkart' ),
								'oz'  => __( 'oz', 'kkart' ),
							),
							'desc_tip' => true,
						),

						array(
							'title'    => __( 'Dimensions unit', 'kkart' ),
							'desc'     => __( 'This controls what unit you will define lengths in.', 'kkart' ),
							'id'       => 'kkart_dimension_unit',
							'class'    => 'kkart-enhanced-select',
							'css'      => 'min-width:300px;',
							'default'  => 'cm',
							'type'     => 'select',
							'options'  => array(
								'm'  => __( 'm', 'kkart' ),
								'cm' => __( 'cm', 'kkart' ),
								'mm' => __( 'mm', 'kkart' ),
								'in' => __( 'in', 'kkart' ),
								'yd' => __( 'yd', 'kkart' ),
							),
							'desc_tip' => true,
						),

						array(
							'type' => 'sectionend',
							'id'   => 'product_measurement_options',
						),

						array(
							'title' => __( 'Reviews', 'kkart' ),
							'type'  => 'title',
							'desc'  => '',
							'id'    => 'product_rating_options',
						),

						array(
							'title'           => __( 'Enable reviews', 'kkart' ),
							'desc'            => __( 'Enable product reviews', 'kkart' ),
							'id'              => 'kkart_enable_reviews',
							'default'         => 'yes',
							'type'            => 'checkbox',
							'checkboxgroup'   => 'start',
							'show_if_checked' => 'option',
						),

						array(
							'desc'            => __( 'Show "verified owner" label on customer reviews', 'kkart' ),
							'id'              => 'kkart_review_rating_verification_label',
							'default'         => 'yes',
							'type'            => 'checkbox',
							'checkboxgroup'   => '',
							'show_if_checked' => 'yes',
							'autoload'        => false,
						),

						array(
							'desc'            => __( 'Reviews can only be left by "verified owners"', 'kkart' ),
							'id'              => 'kkart_review_rating_verification_required',
							'default'         => 'no',
							'type'            => 'checkbox',
							'checkboxgroup'   => 'end',
							'show_if_checked' => 'yes',
							'autoload'        => false,
						),

						array(
							'title'           => __( 'Product ratings', 'kkart' ),
							'desc'            => __( 'Enable star rating on reviews', 'kkart' ),
							'id'              => 'kkart_enable_review_rating',
							'default'         => 'yes',
							'type'            => 'checkbox',
							'checkboxgroup'   => 'start',
							'show_if_checked' => 'option',
						),

						array(
							'desc'            => __( 'Star ratings should be required, not optional', 'kkart' ),
							'id'              => 'kkart_review_rating_required',
							'default'         => 'yes',
							'type'            => 'checkbox',
							'checkboxgroup'   => 'end',
							'show_if_checked' => 'yes',
							'autoload'        => false,
						),

						array(
							'type' => 'sectionend',
							'id'   => 'product_rating_options',
						),

					)
				)
			);
		}

		return apply_filters( 'kkart_get_settings_' . $this->id, $settings, $current_section );
	}
}

return new KKART_Settings_Products();
