<?php
/**
 * Admin View: Page - Addons
 *
 * @package Kkart\Admin
 * @var string $view
 * @var object $addons
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="wrap kkart kkart_addons_wrap">
	<nav class="nav-tab-wrapper kkart-nav-tab-wrapper">
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-addons' ) ); ?>" class="nav-tab nav-tab-active"><?php esc_html_e( 'Browse Extensions', 'kkart' ); ?></a>

		<?php
			$count_html = KKART_Helper_Updater::get_updates_count_html();
			// translators: Count of updates for Kkart.com subscriptions.
			$menu_title = sprintf( __( 'Kkart.com Subscriptions %s', 'kkart' ), $count_html );
		?>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-addons&section=helper' ) ); ?>" class="nav-tab"><?php echo wp_kses_post( $menu_title ); ?></a>
	</nav>

	<h1 class="screen-reader-text"><?php esc_html_e( 'Kkart Extensions', 'kkart' ); ?></h1>

	<?php if ( $sections ) : ?>
		<ul class="subsubsub">
			<?php foreach ( $sections as $section ) : ?>
				<li>
					<a
						class="<?php echo $current_section === $section->slug ? 'current' : ''; ?>"
						href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-addons&section=' . esc_attr( $section->slug ) ) ); ?>">
						<?php echo esc_html( $section->label ); ?>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>

		<?php if ( isset( $_GET['search'] ) ) : // phpcs:ignore WordPress.Security.NonceVerification.Recommended ?>
			<h1 class="search-form-title" >
				<?php // translators: search keyword. ?>
				<?php printf( esc_html__( 'Showing search results for: %s', 'kkart' ), '<strong>' . esc_html( sanitize_text_field( wp_unslash( $_GET['search'] ) ) ) . '</strong>' ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended ?>
			</h1>
		<?php endif; ?>

		<form class="search-form" method="GET">
			<button type="submit">
				<span class="dashicons dashicons-search"></span>
			</button>
			<input
				type="text"
				name="search"
				value="<?php echo esc_attr( isset( $_GET['search'] ) ? sanitize_text_field( wp_unslash( $_GET['search'] ) ) : '' ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended ?>"
				placeholder="<?php esc_attr_e( 'Enter a search term and press enter', 'kkart' ); ?>">
			<input type="hidden" name="page" value="kkart-addons">
			<?php $page_section = ( isset( $_GET['section'] ) && '_featured' !== $_GET['section'] ) ? sanitize_text_field( wp_unslash( $_GET['section'] ) ) : '_all'; // phpcs:ignore WordPress.Security.NonceVerification.Recommended ?>
			<input type="hidden" name="section" value="<?php echo esc_attr( $page_section ); ?>">
		</form>
		<?php if ( '_featured' === $current_section ) : ?>
			<div class="addons-featured">
				<?php
					$featured = KKART_Admin_Addons::get_featured();
				?>
			</div>
		<?php endif; ?>
		<?php if ( '_featured' !== $current_section && $addons ) : ?>
			<?php if ( 'shipping_methods' === $current_section ) : ?>
				<div class="addons-shipping-methods">
					<?php KKART_Admin_Addons::output_wcs_banner_block(); ?>
				</div>
			<?php endif; ?>
			<?php if ( 'payment-gateways' === $current_section ) : ?>
				<div class="addons-shipping-methods">
					<?php KKART_Admin_Addons::output_wcpay_banner_block(); ?>
				</div>
			<?php endif; ?>
			<ul class="products">
			<?php foreach ( $addons as $addon ) : ?>
				<?php
				if ( 'shipping_methods' === $current_section ) {
					// Do not show USPS or Canada Post extensions for US and CA stores, respectively.
					$country = KKART()->countries->get_base_country();
					if ( 'US' === $country
						&& false !== strpos(
							$addon->link,
							'kkart.com/products/usps-shipping-method'
						)
					) {
						continue;
					}
					if ( 'CA' === $country
						&& false !== strpos(
							$addon->link,
							'kkart.com/products/canada-post-shipping-method'
						)
					) {
						continue;
					}
				}
				?>
				<li class="product">
					<a href="<?php echo esc_attr( KKART_Admin_Addons::add_in_app_purchase_url_params( $addon->link ) ); ?>">
						<?php if ( ! empty( $addon->image ) ) : ?>
							<span class="product-img-wrap"><img src="<?php echo esc_url( $addon->image ); ?>"/></span>
						<?php else : ?>
							<h2><?php echo esc_html( $addon->title ); ?></h2>
						<?php endif; ?>
						<span class="price"><?php echo wp_kses_post( $addon->price ); ?></span>
						<p><?php echo wp_kses_post( $addon->excerpt ); ?></p>
					</a>
				</li>
			<?php endforeach; ?>
			</ul>
		<?php endif; ?>
	<?php else : ?>
		<?php /* translators: a url */ ?>
		<p><?php printf( wp_kses_post( __( 'Our catalog of Kkart Extensions can be found on Kkart.com here: <a href="%s">Kkart Extensions Catalog</a>', 'kkart' ) ), 'https://kkart.com/product-category/kkart-extensions/' ); ?></p>
	<?php endif; ?>

	<?php if ( 'Storefront' !== $theme['Name'] && '_featured' !== $current_section ) : ?>
		<div class="storefront">
			<a href="<?php echo esc_url( 'https://kkart.com/storefront/' ); ?>" target="_blank"><img src="<?php echo esc_url( KKART()->plugin_url() ); ?>/assets/images/storefront.png" alt="<?php esc_attr_e( 'Storefront', 'kkart' ); ?>" /></a>
			<h2><?php esc_html_e( 'Looking for a Kkart theme?', 'kkart' ); ?></h2>
			<p><?php echo wp_kses_post( __( 'We recommend Storefront, the <em>official</em> Kkart theme.', 'kkart' ) ); ?></p>
			<p><?php echo wp_kses_post( __( 'Storefront is an intuitive, flexible and <strong>free</strong> WordPress theme offering deep integration with Kkart and many of the most popular customer-facing extensions.', 'kkart' ) ); ?></p>
			<p>
				<a href="https://kkart.com/storefront/" target="_blank" class="button"><?php esc_html_e( 'Read all about it', 'kkart' ); ?></a>
				<a href="<?php echo esc_url( wp_nonce_url( self_admin_url( 'update.php?action=install-theme&theme=storefront' ), 'install-theme_storefront' ) ); ?>" class="button button-primary"><?php esc_html_e( 'Download &amp; install', 'kkart' ); ?></a>
			</p>
		</div>
	<?php endif; ?>
</div>
