<?php
/**
 * Admin View: Page - Status Database Logs
 *
 * @package Kkart\Admin\Logs
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<form method="post" id="mainform" action="">
	<?php $log_table_list->search_box( __( 'Search logs', 'kkart' ), 'log' ); ?>
	<?php $log_table_list->display(); ?>

	<input type="hidden" name="page" value="kkart-status" />
	<input type="hidden" name="tab" value="logs" />

	<?php submit_button( __( 'Flush all logs', 'kkart' ), 'delete', 'flush-logs' ); ?>
	<?php wp_nonce_field( 'kkart-status-logs' ); ?>
</form>
<?php
kkart_enqueue_js(
	"jQuery( '#flush-logs' ).click( function() {
		if ( window.confirm('" . esc_js( __( 'Are you sure you want to clear all logs from the database?', 'kkart' ) ) . "') ) {
			return true;
		}
		return false;
	});"
);
