<?php
/**
 * Order items HTML for meta box.
 *
 * @package Kkart\Admin
 */

defined( 'ABSPATH' ) || exit;

global $wpdb;

$payment_gateway     = kkart_get_payment_gateway_by_order( $order );
$line_items          = $order->get_items( apply_filters( 'kkart_admin_order_item_types', 'line_item' ) );
$discounts           = $order->get_items( 'discount' );
$line_items_fee      = $order->get_items( 'fee' );
$line_items_shipping = $order->get_items( 'shipping' );

if ( kkart_tax_enabled() ) {
	$order_taxes      = $order->get_taxes();
	$tax_classes      = KKART_Tax::get_tax_classes();
	$classes_options  = kkart_get_product_tax_class_options();
	$show_tax_columns = count( $order_taxes ) === 1;
}
?>
<div class="kkart_order_items_wrapper kkart-order-items-editable">
	<table cellpadding="0" cellspacing="0" class="kkart_order_items">
		<thead>
			<tr>
				<th class="item sortable" colspan="2" data-sort="string-ins"><?php esc_html_e( 'Item', 'kkart' ); ?></th>
				<?php do_action( 'kkart_admin_order_item_headers', $order ); ?>
				<th class="item_cost sortable" data-sort="float"><?php esc_html_e( 'Cost', 'kkart' ); ?></th>
				<th class="quantity sortable" data-sort="int"><?php esc_html_e( 'Qty', 'kkart' ); ?></th>
				<th class="line_cost sortable" data-sort="float"><?php esc_html_e( 'Total', 'kkart' ); ?></th>
				<?php
				if ( ! empty( $order_taxes ) ) :
					foreach ( $order_taxes as $tax_id => $tax_item ) :
						$tax_class      = kkart_get_tax_class_by_tax_id( $tax_item['rate_id'] );
						$tax_class_name = isset( $classes_options[ $tax_class ] ) ? $classes_options[ $tax_class ] : __( 'Tax', 'kkart' );
						$column_label   = ! empty( $tax_item['label'] ) ? $tax_item['label'] : __( 'Tax', 'kkart' );
						/* translators: %1$s: tax item name %2$s: tax class name  */
						$column_tip = sprintf( esc_html__( '%1$s (%2$s)', 'kkart' ), $tax_item['name'], $tax_class_name );
						?>
						<th class="line_tax tips" data-tip="<?php echo esc_attr( $column_tip ); ?>">
							<?php echo esc_attr( $column_label ); ?>
							<input type="hidden" class="order-tax-id" name="order_taxes[<?php echo esc_attr( $tax_id ); ?>]" value="<?php echo esc_attr( $tax_item['rate_id'] ); ?>">
							<?php if ( $order->is_editable() ) : ?>
								<a class="delete-order-tax" href="#" data-rate_id="<?php echo esc_attr( $tax_id ); ?>"></a>
							<?php endif; ?>
						</th>
						<?php
					endforeach;
				endif;
				?>
				<th class="kkart-order-edit-line-item" width="1%">&nbsp;</th>
			</tr>
		</thead>
		<tbody id="order_line_items">
			<?php
			foreach ( $line_items as $item_id => $item ) {
				do_action( 'kkart_before_order_item_' . $item->get_type() . '_html', $item_id, $item, $order );

				include __DIR__ . '/html-order-item.php';

				do_action( 'kkart_order_item_' . $item->get_type() . '_html', $item_id, $item, $order );
			}
			do_action( 'kkart_admin_order_items_after_line_items', $order->get_id() );
			?>
		</tbody>
		<tbody id="order_fee_line_items">
			<?php
			foreach ( $line_items_fee as $item_id => $item ) {
				include __DIR__ . '/html-order-fee.php';
			}
			do_action( 'kkart_admin_order_items_after_fees', $order->get_id() );
			?>
		</tbody>
		<tbody id="order_shipping_line_items">
			<?php
			$shipping_methods = KKART()->shipping() ? KKART()->shipping()->load_shipping_methods() : array();
			foreach ( $line_items_shipping as $item_id => $item ) {
				include __DIR__ . '/html-order-shipping.php';
			}
			do_action( 'kkart_admin_order_items_after_shipping', $order->get_id() );
			?>
		</tbody>
		<tbody id="order_refunds">
			<?php
			$refunds = $order->get_refunds();

			if ( $refunds ) {
				foreach ( $refunds as $refund ) {
					include __DIR__ . '/html-order-refund.php';
				}
				do_action( 'kkart_admin_order_items_after_refunds', $order->get_id() );
			}
			?>
		</tbody>
	</table>
</div>
<div class="kkart-order-data-row kkart-order-totals-items kkart-order-items-editable">
	<?php
	$coupons = $order->get_items( 'coupon' );
	if ( $coupons ) :
		?>
		<div class="kkart-used-coupons">
			<ul class="kkart_coupon_list">
				<li><strong><?php esc_html_e( 'Coupon(s)', 'kkart' ); ?></strong></li>
				<?php
				foreach ( $coupons as $item_id => $item ) :
					$post_id = $wpdb->get_var( $wpdb->prepare( "SELECT ID FROM {$wpdb->posts} WHERE post_title = %s AND post_type = 'shop_coupon' AND post_status = 'publish' LIMIT 1;", $item->get_code() ) ); // phpcs:disable WordPress.WP.GlobalVariablesOverride.Prohibited
					$class   = $order->is_editable() ? 'code editable' : 'code';
					?>
					<li class="<?php echo esc_attr( $class ); ?>">
						<?php if ( $post_id ) : ?>
							<?php
							$post_url = apply_filters(
								'kkart_admin_order_item_coupon_url',
								add_query_arg(
									array(
										'post'   => $post_id,
										'action' => 'edit',
									),
									admin_url( 'post.php' )
								),
								$item,
								$order
							);
							?>
							<a href="<?php echo esc_url( $post_url ); ?>" class="tips" data-tip="<?php echo esc_attr( kkart_price( $item->get_discount(), array( 'currency' => $order->get_currency() ) ) ); ?>">
								<span><?php echo esc_html( $item->get_code() ); ?></span>
							</a>
						<?php else : ?>
							<span class="tips" data-tip="<?php echo esc_attr( kkart_price( $item->get_discount(), array( 'currency' => $order->get_currency() ) ) ); ?>">
								<span><?php echo esc_html( $item->get_code() ); ?></span>
							</span>
						<?php endif; ?>
						<?php if ( $order->is_editable() ) : ?>
							<a class="remove-coupon" href="javascript:void(0)" aria-label="Remove" data-code="<?php echo esc_attr( $item->get_code() ); ?>"></a>
						<?php endif; ?>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>
	<table class="kkart-order-totals">
			<tr>
				<td class="label"><?php esc_html_e( 'Items Subtotal:', 'kkart' ); ?></td>
				<td width="1%"></td>
				<td class="total">
					<?php echo kkart_price( $order->get_subtotal(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</td>
			</tr>
		<?php if ( 0 < $order->get_total_discount() ) : ?>
			<tr>
				<td class="label"><?php esc_html_e( 'Coupon(s):', 'kkart' ); ?></td>
				<td width="1%"></td>
				<td class="total">-
					<?php echo kkart_price( $order->get_total_discount(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</td>
			</tr>
		<?php endif; ?>
		<?php if ( 0 < $order->get_total_fees() ) : ?>
			<tr>
				<td class="label"><?php esc_html_e( 'Fees:', 'kkart' ); ?></td>
				<td width="1%"></td>
				<td class="total">
					<?php echo kkart_price( $order->get_total_fees(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</td>
			</tr>
		<?php endif; ?>

		<?php do_action( 'kkart_admin_order_totals_after_discount', $order->get_id() ); ?>

		<?php if ( $order->get_shipping_methods() ) : ?>
			<tr>
				<td class="label"><?php esc_html_e( 'Shipping:', 'kkart' ); ?></td>
				<td width="1%"></td>
				<td class="total">
					<?php echo kkart_price( $order->get_shipping_total(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</td>
			</tr>
		<?php endif; ?>

		<?php do_action( 'kkart_admin_order_totals_after_shipping', $order->get_id() ); ?>

		<?php if ( kkart_tax_enabled() ) : ?>
			<?php foreach ( $order->get_tax_totals() as $code => $tax_total ) : ?>
				<tr>
					<td class="label"><?php echo esc_html( $tax_total->label ); ?>:</td>
					<td width="1%"></td>
					<td class="total">
						<?php echo kkart_price( $tax_total->amount, array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</td>
				</tr>
			<?php endforeach; ?>
		<?php endif; ?>

		<?php do_action( 'kkart_admin_order_totals_after_tax', $order->get_id() ); ?>

		<tr>
			<td class="label"><?php esc_html_e( 'Order Total', 'kkart' ); ?>:</td>
			<td width="1%"></td>
			<td class="total">
				<?php echo kkart_price( $order->get_total(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			</td>
		</tr>

	</table>

	<div class="clear"></div>

	<?php if ( in_array( $order->get_status(), array( 'processing', 'completed', 'refunded' ), true ) && ! empty( $order->get_date_paid() ) ) : ?>

		<table class="kkart-order-totals" style="border-top: 1px solid #999; margin-top:12px; padding-top:12px">
			<tr>
				<td class="<?php echo $order->get_total_refunded() ? 'label' : 'label label-highlight'; ?>"><?php esc_html_e( 'Paid', 'kkart' ); ?>: <br /></td>
				<td width="1%"></td>
				<td class="total">
					<?php echo kkart_price( $order->get_total(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="description">
					<?php
					if ( $order->get_payment_method_title() ) {
						/* translators: 1: payment date. 2: payment method */
						echo esc_html( sprintf( __( '%1$s via %2$s', 'kkart' ), $order->get_date_paid()->date_i18n( get_option( 'date_format' ) ), $order->get_payment_method_title() ) );
					} else {
						echo esc_html( $order->get_date_paid()->date_i18n( get_option( 'date_format' ) ) );
					}
					?>
					</span>
				</td>
				<td colspan="2"></td>
			</tr>
		</table>

	<div class="clear"></div>

	<?php endif; ?>

	<?php if ( $order->get_total_refunded() ) : ?>
		<table class="kkart-order-totals" style="border-top: 1px solid #999; margin-top:12px; padding-top:12px">
			<tr>
				<td class="label refunded-total"><?php esc_html_e( 'Refunded', 'kkart' ); ?>:</td>
				<td width="1%"></td>
				<td class="total refunded-total">-<?php echo kkart_price( $order->get_total_refunded(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
			</tr>

			<?php do_action( 'kkart_admin_order_totals_after_refunded', $order->get_id() ); ?>

			<tr>
				<td class="label label-highlight"><?php esc_html_e( 'Net Payment', 'kkart' ); ?>:</td>
				<td width="1%"></td>
				<td class="total">
				<?php echo kkart_price( $order->get_total() - $order->get_total_refunded(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</td>
			</tr>

		</table>
	<?php endif; ?>

	<div class="clear"></div>

	<table class="kkart-order-totals">
		<?php do_action( 'kkart_admin_order_totals_after_total', $order->get_id() ); ?>
	</table>

	<div class="clear"></div>
</div>
<div class="kkart-order-data-row kkart-order-bulk-actions kkart-order-data-row-toggle">
	<p class="add-items">
		<?php if ( $order->is_editable() ) : ?>
			<button type="button" class="button add-line-item"><?php esc_html_e( 'Add item(s)', 'kkart' ); ?></button>
			<?php if ( kkart_coupons_enabled() ) : ?>
				<button type="button" class="button add-coupon"><?php esc_html_e( 'Apply coupon', 'kkart' ); ?></button>
			<?php endif; ?>
		<?php else : ?>
			<span class="description"><?php echo kkart_help_tip( __( 'To edit this order change the status back to "Pending"', 'kkart' ) ); ?> <?php esc_html_e( 'This order is no longer editable.', 'kkart' ); ?></span>
		<?php endif; ?>
		<?php if ( 0 < $order->get_total() - $order->get_total_refunded() || 0 < absint( $order->get_item_count() - $order->get_item_count_refunded() ) ) : ?>
			<button type="button" class="button refund-items"><?php esc_html_e( 'Refund', 'kkart' ); ?></button>
		<?php endif; ?>
		<?php
			// Allow adding custom buttons.
			do_action( 'kkart_order_item_add_action_buttons', $order );
		?>
		<?php if ( $order->is_editable() ) : ?>
			<button type="button" class="button button-primary calculate-action"><?php esc_html_e( 'Recalculate', 'kkart' ); ?></button>
		<?php endif; ?>
	</p>
</div>
<div class="kkart-order-data-row kkart-order-add-item kkart-order-data-row-toggle" style="display:none;">
	<button type="button" class="button add-order-item"><?php esc_html_e( 'Add product(s)', 'kkart' ); ?></button>
	<button type="button" class="button add-order-fee"><?php esc_html_e( 'Add fee', 'kkart' ); ?></button>
	<button type="button" class="button add-order-shipping"><?php esc_html_e( 'Add shipping', 'kkart' ); ?></button>
	<?php if ( kkart_tax_enabled() ) : ?>
		<button type="button" class="button add-order-tax"><?php esc_html_e( 'Add tax', 'kkart' ); ?></button>
	<?php endif; ?>
	<?php
		// Allow adding custom buttons.
		do_action( 'kkart_order_item_add_line_buttons', $order );
	?>
	<button type="button" class="button cancel-action"><?php esc_html_e( 'Cancel', 'kkart' ); ?></button>
	<button type="button" class="button button-primary save-action"><?php esc_html_e( 'Save', 'kkart' ); ?></button>
</div>
<?php if ( 0 < $order->get_total() - $order->get_total_refunded() || 0 < absint( $order->get_item_count() - $order->get_item_count_refunded() ) ) : ?>
<div class="kkart-order-data-row kkart-order-refund-items kkart-order-data-row-toggle" style="display: none;">
	<table class="kkart-order-totals">
		<?php if ( 'yes' === get_option( 'kkart_manage_stock' ) ) : ?>
			<tr>
				<td class="label"><label for="restock_refunded_items"><?php esc_html_e( 'Restock refunded items', 'kkart' ); ?>:</label></td>
				<td class="total"><input type="checkbox" id="restock_refunded_items" name="restock_refunded_items" <?php checked( apply_filters( 'kkart_restock_refunded_items', true ) ); ?> /></td>
			</tr>
		<?php endif; ?>
		<tr>
			<td class="label"><?php esc_html_e( 'Amount already refunded', 'kkart' ); ?>:</td>
			<td class="total">-<?php echo kkart_price( $order->get_total_refunded(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
		</tr>
		<tr>
			<td class="label"><?php esc_html_e( 'Total available to refund', 'kkart' ); ?>:</td>
			<td class="total"><?php echo kkart_price( $order->get_total() - $order->get_total_refunded(), array( 'currency' => $order->get_currency() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
		</tr>
		<tr>
			<td class="label">
				<label for="refund_amount">
					<?php echo kkart_help_tip( __( 'Refund the line items above. This will show the total amount to be refunded', 'kkart' ) ); ?>
					<?php esc_html_e( 'Refund amount', 'kkart' ); ?>:
				</label>
			</td>
			<td class="total">
				<input type="text" id="refund_amount" name="refund_amount" class="kkart_input_price"
				<?php
				if ( kkart_tax_enabled() ) {
					// If taxes are enabled, using this refund amount can cause issues due to taxes not being refunded also.
					// The refunds should be added to the line items, not the order as a whole.
					echo 'readonly';
				}
				?>
				/>
				<div class="clear"></div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<label for="refund_reason">
					<?php echo kkart_help_tip( __( 'Note: the refund reason will be visible by the customer.', 'kkart' ) ); ?>
					<?php esc_html_e( 'Reason for refund (optional):', 'kkart' ); ?>
				</label>
			</td>
			<td class="total">
				<input type="text" id="refund_reason" name="refund_reason" />
				<div class="clear"></div>
			</td>
		</tr>
	</table>
	<div class="clear"></div>
	<div class="refund-actions">
		<?php
		$refund_amount = '<span class="kkart-order-refund-amount">' . kkart_price( 0, array( 'currency' => $order->get_currency() ) ) . '</span>';
		$gateway_name  = false !== $payment_gateway ? ( ! empty( $payment_gateway->method_title ) ? $payment_gateway->method_title : $payment_gateway->get_title() ) : __( 'Payment gateway', 'kkart' );

		if ( false !== $payment_gateway && $payment_gateway->can_refund_order( $order ) ) {
			/* translators: refund amount, gateway name */
			echo '<button type="button" class="button button-primary do-api-refund">' . sprintf( esc_html__( 'Refund %1$s via %2$s', 'kkart' ), wp_kses_post( $refund_amount ), esc_html( $gateway_name ) ) . '</button>';
		}
		?>
		<?php /* translators: refund amount  */ ?>
		<button type="button" class="button button-primary do-manual-refund tips" data-tip="<?php esc_attr_e( 'You will need to manually issue a refund through your payment gateway after using this.', 'kkart' ); ?>"><?php printf( esc_html__( 'Refund %s manually', 'kkart' ), wp_kses_post( $refund_amount ) ); ?></button>
		<button type="button" class="button cancel-action"><?php esc_html_e( 'Cancel', 'kkart' ); ?></button>
		<input type="hidden" id="refunded_amount" name="refunded_amount" value="<?php echo esc_attr( $order->get_total_refunded() ); ?>" />
		<div class="clear"></div>
	</div>
</div>
<?php endif; ?>

<script type="text/template" id="tmpl-kkart-modal-add-products">
	<div class="kkart-backbone-modal">
		<div class="kkart-backbone-modal-content">
			<section class="kkart-backbone-modal-main" role="main">
				<header class="kkart-backbone-modal-header">
					<h1><?php esc_html_e( 'Add products', 'kkart' ); ?></h1>
					<button class="modal-close modal-close-link dashicons dashicons-no-alt">
						<span class="screen-reader-text">Close modal panel</span>
					</button>
				</header>
				<article>
					<form action="" method="post">
						<table class="widefat">
							<thead>
								<tr>
									<th><?php esc_html_e( 'Product', 'kkart' ); ?></th>
									<th><?php esc_html_e( 'Quantity', 'kkart' ); ?></th>
								</tr>
							</thead>
							<?php
								$row = '
									<td><select class="kkart-product-search" name="item_id" data-allow_clear="true" data-display_stock="true" data-exclude_type="variable" data-placeholder="' . esc_attr__( 'Search for a product&hellip;', 'kkart' ) . '"></select></td>
									<td><input type="number" step="1" min="0" max="9999" autocomplete="off" name="item_qty" placeholder="1" size="4" class="quantity" /></td>';
							?>
							<tbody data-row="<?php echo esc_attr( $row ); ?>">
								<tr>
									<?php echo $row; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
								</tr>
							</tbody>
						</table>
					</form>
				</article>
				<footer>
					<div class="inner">
						<button id="btn-ok" class="button button-primary button-large"><?php esc_html_e( 'Add', 'kkart' ); ?></button>
					</div>
				</footer>
			</section>
		</div>
	</div>
	<div class="kkart-backbone-modal-backdrop modal-close"></div>
</script>

<script type="text/template" id="tmpl-kkart-modal-add-tax">
	<div class="kkart-backbone-modal">
		<div class="kkart-backbone-modal-content">
			<section class="kkart-backbone-modal-main" role="main">
				<header class="kkart-backbone-modal-header">
					<h1><?php esc_html_e( 'Add tax', 'kkart' ); ?></h1>
					<button class="modal-close modal-close-link dashicons dashicons-no-alt">
						<span class="screen-reader-text">Close modal panel</span>
					</button>
				</header>
				<article>
					<form action="" method="post">
						<table class="widefat">
							<thead>
								<tr>
									<th>&nbsp;</th>
									<th><?php esc_html_e( 'Rate name', 'kkart' ); ?></th>
									<th><?php esc_html_e( 'Tax class', 'kkart' ); ?></th>
									<th><?php esc_html_e( 'Rate code', 'kkart' ); ?></th>
									<th><?php esc_html_e( 'Rate %', 'kkart' ); ?></th>
								</tr>
							</thead>
						<?php
						$rates = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}kkart_tax_rates ORDER BY tax_rate_name LIMIT 100" );
						foreach ( $rates as $rate ) {
							echo '
									<tr>
										<td><input type="radio" id="add_order_tax_' . absint( $rate->tax_rate_id ) . '" name="add_order_tax" value="' . absint( $rate->tax_rate_id ) . '" /></td>
										<td><label for="add_order_tax_' . absint( $rate->tax_rate_id ) . '">' . esc_html( KKART_Tax::get_rate_label( $rate ) ) . '</label></td>
										<td>' . ( isset( $classes_options[ $rate->tax_rate_class ] ) ? esc_html( $classes_options[ $rate->tax_rate_class ] ) : '-' ) . '</td>
										<td>' . esc_html( KKART_Tax::get_rate_code( $rate ) ) . '</td>
										<td>' . esc_html( KKART_Tax::get_rate_percent( $rate ) ) . '</td>
									</tr>
								';
						}
						?>
						</table>
						<?php if ( absint( $wpdb->get_var( "SELECT COUNT(tax_rate_id) FROM {$wpdb->prefix}kkart_tax_rates;" ) ) > 100 ) : ?>
							<p>
								<label for="manual_tax_rate_id"><?php esc_html_e( 'Or, enter tax rate ID:', 'kkart' ); ?></label><br/>
								<input type="number" name="manual_tax_rate_id" id="manual_tax_rate_id" step="1" placeholder="<?php esc_attr_e( 'Optional', 'kkart' ); ?>" />
							</p>
						<?php endif; ?>
					</form>
				</article>
				<footer>
					<div class="inner">
						<button id="btn-ok" class="button button-primary button-large"><?php esc_html_e( 'Add', 'kkart' ); ?></button>
					</div>
				</footer>
			</section>
		</div>
	</div>
	<div class="kkart-backbone-modal-backdrop modal-close"></div>
</script>
