<?php
/**
 * Kkart Order Tracking
 *
 * @package Kkart\Tracks
 */

defined( 'ABSPATH' ) || exit;

/**
 * This class adds actions to track usage of a Kkart Order.
 */
class KKART_Order_Tracking {

	/**
	 * Init tracking.
	 */
	public function init() {
		add_action( 'kkart_admin_order_data_after_order_details', array( $this, 'track_order_viewed' ) );
	}

	/**
	 * Send a Tracks event when an order is viewed.
	 *
	 * @param KKART_Order $order Order.
	 */
	public function track_order_viewed( $order ) {
		if ( ! $order instanceof KKART_Order || ! $order->get_id() ) {
			return;
		}
		$properties = array(
			'current_status' => $order->get_status(),
			'date_created'   => $order->get_date_created() ? $order->get_date_created()->format( DateTime::ATOM ) : '',
			'payment_method' => $order->get_payment_method(),
		);

		KKART_Tracks::record_event( 'single_order_view', $properties );
	}
}

