
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `instantcms2180`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]activity`
--

CREATE TABLE `[[dbprefix]]activity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(11) unsigned DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `group_id` int(11) unsigned DEFAULT NULL,
  `subject_title` varchar(140) DEFAULT NULL,
  `subject_id` int(11) unsigned DEFAULT NULL,
  `subject_url` varchar(250) DEFAULT NULL,
  `reply_url` varchar(250) DEFAULT NULL,
  `images` text,
  `images_count` int(11) unsigned DEFAULT NULL,
  `date_pub` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `is_private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_parent_hidden` tinyint(1) unsigned DEFAULT NULL,
  `is_pub` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `type_id` (`type_id`),
  KEY `user_id` (`user_id`),
  KEY `date_pub` (`date_pub`),
  KEY `is_private` (`is_private`),
  KEY `group_id` (`group_id`),
  KEY `is_parent_hidden` (`is_parent_hidden`),
  KEY `is_pub` (`is_pub`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Activity feed' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]activity_types`
--

CREATE TABLE `[[dbprefix]]activity_types` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `is_enabled` tinyint(1) unsigned DEFAULT '1',
  `controller` varchar(32) NOT NULL,
  `name` varchar(32) NOT NULL,
  `title` varchar(100) NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `is_enabled` (`is_enabled`),
  KEY `controller` (`controller`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Activity feed types' AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]activity_types`
--

INSERT INTO `[[dbprefix]]activity_types` VALUES
(1, 1, 'content', 'add.pages', 'Adding pages', 'added the page %s'),
(7, 1, 'users', 'friendship', 'Friendship', 'and %s became friends'),
(8, 1, 'users', 'signup', 'New users', 'registered. Welcome!'),
(12, 1, 'users', 'status', 'Status changing', '&rarr; %s'),
(19, 1, 'users', 'avatar', 'Avatar changing', 'changed avatar'),
(20, 1, 'comments', 'vote.comment', 'Rating comments', 'evaluate a comment on the %s page'),
(21, 1, 'groups', 'join', 'Group joining', 'joined the group %s'),
(22, 1, 'groups', 'leave', 'Group leaving', 'left the group %s'),
(23, 0, 'content', 'add.albums', 'Adding albums', 'added album %s'),
(24, 1, 'photos', 'add.photos', 'Photo uploading', 'uploaded photos to the album %s'),
(25, 1, 'subscriptions', 'subscribe', 'Subscription to content', 'subscribes to the %s list');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_actions`
--

CREATE TABLE `[[dbprefix]]billing_actions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `controller` varchar(32) DEFAULT NULL COMMENT 'Controller name',
  `name` varchar(64) DEFAULT NULL COMMENT 'Action name',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `prices` text COMMENT 'YAML with prices by group',
  PRIMARY KEY (`id`),
  KEY `controller` (`controller`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Paid actions' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]billing_actions`
--

INSERT INTO `[[dbprefix]]billing_actions` VALUES
(1, 'content', 'pages_add', 'Pages: adding', '---\n3: 0\n4: 0\n5: 0\n6: 0\n'),
(2, 'content', 'albums_add', 'Photo albums: adding', '---\n3: 0\n4: 0\n5: 0\n6: 0\n');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_holds`
--

CREATE TABLE `[[dbprefix]]billing_holds` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `target` varchar(100) DEFAULT NULL COMMENT 'Operation identifier',
  `user_id` int(11) unsigned NOT NULL COMMENT 'User ID',
  `amount` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT 'Amount',
  `payload` text COMMENT 'JSON with operation parameters',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`target`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Pending balances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_log`
--

CREATE TABLE `[[dbprefix]]billing_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned DEFAULT NULL COMMENT 'Operation type: 1 - income, 0 - payment',
  `action_id` int(11) unsigned DEFAULT NULL COMMENT 'Paid action ID',
  `date_created` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Operation creation date',
  `date_done` timestamp NULL DEFAULT NULL COMMENT 'Operation completion date',
  `amount` decimal(11,2) DEFAULT NULL COMMENT 'Amount in internal currency',
  `summ` decimal(11,2) DEFAULT NULL COMMENT 'Amount in real currency',
  `user_id` int(11) unsigned DEFAULT NULL COMMENT 'User ID',
  `sender_id` int(11) unsigned DEFAULT NULL COMMENT 'User ID of the sender (for transfers)',
  `status` tinyint(1) unsigned DEFAULT NULL COMMENT 'Operation status: 0 - created, 1 - completed',
  `description` varchar(512) DEFAULT NULL COMMENT 'Operation description',
  `url` varchar(255) DEFAULT NULL COMMENT 'URL of the related purchase',
  `ref_link_id` int(11) unsigned DEFAULT NULL COMMENT 'Referral entry ID from billing_refs table',
  `plan_id` int(11) unsigned DEFAULT NULL COMMENT 'Tariff plan ID',
  `plan_period` tinyint(1) unsigned DEFAULT NULL COMMENT 'Tariff plan duration',
  `system_id` int(11) unsigned DEFAULT NULL COMMENT 'Payment system ID',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `action_id` (`action_id`),
  KEY `date_created` (`date_created`),
  KEY `user_id` (`user_id`),
  KEY `sender_id` (`sender_id`),
  KEY `status` (`status`),
  KEY `ref_link_id` (`ref_link_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='List of all transactions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_outs`
--

CREATE TABLE `[[dbprefix]]billing_outs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date_created` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation date',
  `date_done` timestamp NULL DEFAULT NULL COMMENT 'Completion date',
  `user_id` int(11) unsigned DEFAULT NULL COMMENT 'ID of the user who submitted the request',
  `amount` decimal(11,2) unsigned DEFAULT NULL COMMENT 'Amount in internal currency',
  `summ` decimal(11,2) unsigned DEFAULT NULL COMMENT 'Amount in real currency',
  `system` varchar(64) DEFAULT NULL COMMENT 'Destination of the withdrawal',
  `purse` varchar(32) DEFAULT NULL COMMENT 'Wallet/account number',
  `status` tinyint(1) unsigned DEFAULT '0' COMMENT 'Request status',
  `code` varchar(32) DEFAULT NULL COMMENT 'Withdrawal confirmation code',
  `done_code` varchar(32) DEFAULT NULL COMMENT 'Withdrawal completion code',
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `user_id` (`user_id`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Withdrawal requests' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_paid_fields`
--

CREATE TABLE `[[dbprefix]]billing_paid_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ctype_id` int(11) unsigned DEFAULT NULL COMMENT 'Content type ID',
  `field` varchar(20) DEFAULT NULL COMMENT 'System name of the field',
  `price_field` varchar(20) DEFAULT NULL COMMENT 'Name of the field containing the price',
  `prices` text COMMENT 'YAML with prices by user group',
  `is_to_author` tinyint(1) unsigned DEFAULT NULL COMMENT 'Payment goes to the author',
  `is_notify_author` tinyint(1) unsigned DEFAULT NULL COMMENT 'Notify the author about the purchase',
  `notify_email` varchar(100) DEFAULT NULL COMMENT 'Email for field purchase notifications',
  `btn_titles` text COMMENT 'JSON with button titles',
  PRIMARY KEY (`id`),
  KEY `ctype_id` (`ctype_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Field sales' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_paid_fields_log`
--

CREATE TABLE `[[dbprefix]]billing_paid_fields_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `field_id` int(11) unsigned DEFAULT NULL COMMENT 'ID of the purchasable field from billing_paid_fields',
  `item_id` int(11) unsigned DEFAULT NULL COMMENT 'ID of the content item',
  `user_id` int(11) unsigned DEFAULT NULL COMMENT 'ID of the user who purchased the field',
  `date_sold` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Date of purchase',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`item_id`,`field_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Field sale transactions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_payouts`
--

CREATE TABLE `[[dbprefix]]billing_payouts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `is_enabled` tinyint(1) unsigned DEFAULT NULL COMMENT 'Enabled?',
  `title` varchar(128) DEFAULT NULL COMMENT 'Payout title',
  `groups` text COMMENT 'User groups eligible for the payout',
  `user_id` int(11) unsigned DEFAULT NULL COMMENT 'User ID for the payout',
  `is_topup_balance` tinyint(1) unsigned DEFAULT NULL COMMENT 'Top up the balance up to the specified amount',
  `is_passed` tinyint(1) unsigned DEFAULT NULL COMMENT 'Restrict by time since registration',
  `is_rating` tinyint(1) unsigned DEFAULT NULL COMMENT 'Restrict by user rating',
  `is_karma` tinyint(1) unsigned DEFAULT NULL COMMENT 'Restrict by user reputation',
  `is_field` tinyint(1) unsigned DEFAULT NULL COMMENT 'Restrict by profile field value',
  `passed_days` int(11) unsigned DEFAULT NULL COMMENT 'Minimum days since registration',
  `rating` int(11) DEFAULT NULL COMMENT 'Minimum rating',
  `karma` int(11) DEFAULT NULL COMMENT 'Minimum reputation',
  `field` varchar(64) DEFAULT NULL COMMENT 'Profile field name',
  `field_value` varchar(128) DEFAULT NULL COMMENT 'Required value of the profile field',
  `amount` decimal(11,2) DEFAULT NULL COMMENT 'Fixed payout amount',
  `field_amount` varchar(64) DEFAULT NULL COMMENT 'Payout amount based on this profile field value',
  `period` int(11) unsigned DEFAULT NULL COMMENT 'Payout frequency (in days)',
  `date_last` timestamp NULL DEFAULT NULL COMMENT 'Date of last payout',
  PRIMARY KEY (`id`),
  KEY `is_enabled` (`is_enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Scheduled payouts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_plans`
--

CREATE TABLE `[[dbprefix]]billing_plans` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL COMMENT 'Plan name',
  `description` text COMMENT 'Plan description',
  `is_enabled` tinyint(1) unsigned DEFAULT NULL COMMENT 'Enabled?',
  `is_real_price` tinyint(1) unsigned DEFAULT NULL COMMENT 'Purchase with real currency only',
  `max_out` decimal(11,2) unsigned DEFAULT NULL COMMENT 'Maximum withdrawal amount',
  `groups` text COMMENT 'YAML with target user groups',
  `prices` text COMMENT 'YAML with prices by group',
  `users` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of users subscribed to the plan',
  `ordering` int(11) unsigned DEFAULT NULL COMMENT 'Display order in list',
  PRIMARY KEY (`id`),
  KEY `is_enabled` (`is_enabled`),
  KEY `ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Subscription plans' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_plans_log`
--

CREATE TABLE `[[dbprefix]]billing_plans_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned DEFAULT NULL COMMENT 'ID of the user who purchased the subscription',
  `plan_id` int(11) unsigned DEFAULT NULL COMMENT 'ID of the subscription plan',
  `old_groups` text COMMENT 'YAML of the user’s groups before the subscription',
  `date_until` timestamp NULL DEFAULT NULL COMMENT 'Subscription expiration date',
  `is_paused` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Inactive plan?',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `date_until` (`date_until`),
  KEY `plan_id` (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Active subscriptions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_refs`
--

CREATE TABLE `[[dbprefix]]billing_refs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned DEFAULT NULL COMMENT 'ID of the user who registered',
  `ref_id` int(11) unsigned DEFAULT NULL COMMENT 'ID of the user whose referral link was used',
  `level` tinyint(1) unsigned DEFAULT NULL COMMENT 'Referral level',
  `date_reg` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Registration date',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ref_id` (`ref_id`),
  KEY `level` (`level`),
  KEY `date_reg` (`date_reg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Referrals' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_systems`
--

CREATE TABLE `[[dbprefix]]billing_systems` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) DEFAULT NULL COMMENT 'Internal system name of the payment system',
  `title` varchar(64) DEFAULT NULL COMMENT 'Display name of the payment system',
  `payment_url` varchar(255) DEFAULT NULL COMMENT 'External URL of the payment form',
  `rate` decimal(8,4) unsigned DEFAULT '1.0000' COMMENT 'Exchange rate of the payment system currency',
  `options` text COMMENT 'YAML with configuration options',
  `is_enabled` tinyint(1) unsigned DEFAULT NULL COMMENT 'Enabled?',
  `ordering` int(11) unsigned DEFAULT NULL COMMENT 'Sort order in the list',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Payment systems' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]billing_systems`
--

INSERT INTO `[[dbprefix]]billing_systems` VALUES
(2, 'wmz', 'Webmoney WMZ', 'https://merchant.webmoney.ru/lmi/payment.asp', '1.0000', '---\npurse: ""\nsecret_key: ""\ntest_mode: "0"\n', NULL, 2),
(3, 'robokassa', 'E-money, cards, terminals (Robokassa)', 'billing/prepare/robokassa', '1.0000', '---\nmerchant_login: ""\npassword1: ""\npassword2: ""\nfiscal_on: null\nfiscal_sno: osn\nfiscal_method: full_payment\nfiscal_object: service\nfiscal_name: ""\nfiscal_tax: none\n', NULL, 6),
(4, 'interkassa', 'E-money, cards, terminals (Interkassa)', 'https://sci.interkassa.com', '1.0000', '---\nik_co_id: ""\nik_secret_key: ""\n', NULL, 7),
(8, 'w1', 'E-money, cards, terminals (W1)', 'https://wl.walletone.com/checkout/checkout/Index', '1.0000', '---\nmerchant_id: ""\nkey: ""\ncurrency_id: ""\n', NULL, 8),
(9, 'test', 'Test (instant top-up)', 'billing/prepare/test', '0.1000', NULL, 1, 1),
(10, 'yandex', 'ЮMoney', 'https://yoomoney.ru/quickpay/confirm.xml', '1.0000', '---\nreceiver: ""\nsecret_key: ""\n', 0, 12),
(11, 'yakassa', 'ЮKassa', 'billing/prepare/yakassa', '1.0000', '---\nshop_id: ""\nkey: ""\n', NULL, 13),
(14, 'paypal', 'PayPal', 'https://api.sandbox.paypal.com', '1.0000', '---\naccount: ""\ncurrency: USD\nclient_id: ""\nsecret: ""\n', 0, 10),
(16, 'payeer', 'PAYEER', 'https://payeer.com/merchant/', '1.0000', '---\nshop_id: ""\nsecret_key: ""\nsig_key: ""\ncurr: USD\n', NULL, 16);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_terms`
--

CREATE TABLE `[[dbprefix]]billing_terms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ctype_id` int(11) unsigned DEFAULT NULL COMMENT 'Content type ID',
  `prices` text COMMENT 'YAML with prices by group',
  PRIMARY KEY (`id`),
  KEY `ctype_id` (`ctype_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Prices for one day publication' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_transfers`
--

CREATE TABLE `[[dbprefix]]billing_transfers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `from_id` int(11) unsigned DEFAULT NULL COMMENT 'User ID, from whom the transfer is from',
  `to_id` int(11) unsigned DEFAULT NULL COMMENT 'User ID to whom the transfer is to',
  `amount` decimal(11,2) unsigned DEFAULT NULL COMMENT 'Transfer amount',
  `description` varchar(255) DEFAULT NULL COMMENT 'Operation description',
  `code` varchar(32) DEFAULT NULL COMMENT 'Transfer Confirmation Code',
  `status` tinyint(1) DEFAULT '0' COMMENT 'Transfer status',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `from_id` (`from_id`),
  KEY `to_id` (`to_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Transfers between users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_vip_fields`
--

CREATE TABLE `[[dbprefix]]billing_vip_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ctype_id` int(11) unsigned DEFAULT NULL COMMENT 'Content type ID',
  `field` varchar(40) DEFAULT NULL COMMENT 'System field name',
  `prices` text COMMENT 'YAML with prices by group',
  `description` varchar(255) DEFAULT NULL COMMENT 'Description for transaction history',
  PRIMARY KEY (`id`),
  KEY `ctype_id` (`ctype_id`),
  KEY `field` (`field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Fields for sale when filling out' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_vip_fields_log`
--

CREATE TABLE `[[dbprefix]]billing_vip_fields_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `field_id` int(11) unsigned DEFAULT NULL COMMENT 'Field ID from the billing_vip_fields table',
  `item_id` int(11) unsigned DEFAULT NULL COMMENT 'Content type ID',
  `user_id` int(11) unsigned DEFAULT NULL COMMENT 'User ID of the user who purchased the field filling',
  `date_sold` timestamp NULL DEFAULT NULL COMMENT 'The date of sale',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`item_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Purchases to fill out fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) unsigned DEFAULT NULL COMMENT 'Parent comment ID',
  `level` tinyint(4) unsigned DEFAULT NULL,
  `ordering` int(11) unsigned DEFAULT NULL COMMENT 'Order number in the tree',
  `user_id` int(11) unsigned DEFAULT NULL COMMENT 'Author ID',
  `date_pub` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Publication date',
  `date_last_modified` timestamp NULL DEFAULT NULL COMMENT 'Last modified date',
  `target_controller` varchar(32) DEFAULT NULL COMMENT 'Commented content controller',
  `target_subject` varchar(32) DEFAULT NULL COMMENT 'Commented object',
  `target_id` int(11) unsigned DEFAULT NULL COMMENT 'Commented object ID',
  `target_url` varchar(250) DEFAULT NULL COMMENT 'Commented object URL',
  `target_title` varchar(100) DEFAULT NULL COMMENT 'Commented object title',
  `author_name` varchar(100) DEFAULT NULL COMMENT 'Author (guest) name',
  `author_email` varchar(100) DEFAULT NULL COMMENT 'Author (guest) E-mail',
  `author_ip` varbinary(16) DEFAULT NULL COMMENT 'Author ip',
  `content` text COMMENT 'Comment text',
  `content_html` text COMMENT 'Sanitized text',
  `is_deleted` tinyint(1) unsigned DEFAULT NULL COMMENT 'Comment deleted?',
  `is_private` tinyint(1) unsigned DEFAULT '0' COMMENT 'Only for friends?',
  `rating` int(11) NOT NULL DEFAULT '0',
  `is_approved` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `target_id` (`target_id`,`target_controller`,`target_subject`,`ordering`),
  KEY `author_ip` (`author_ip`),
  KEY `is_approved` (`is_approved`,`is_deleted`,`date_pub`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='User comments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments_rating`
--

CREATE TABLE `[[dbprefix]]comments_rating` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int(11) unsigned DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `score` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `comment_id` (`comment_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments_tracks`
--

CREATE TABLE `[[dbprefix]]comments_tracks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned DEFAULT NULL,
  `target_controller` varchar(32) DEFAULT NULL,
  `target_subject` varchar(32) DEFAULT NULL,
  `target_id` int(11) unsigned DEFAULT NULL,
  `target_url` varchar(250) DEFAULT NULL,
  `target_title` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `target_id` (`target_id`,`target_controller`,`target_subject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='User subscriptions to new comments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_datasets`
--

CREATE TABLE `[[dbprefix]]content_datasets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ctype_id` int(11) unsigned DEFAULT NULL COMMENT 'Content typpe ID',
  `name` varchar(32) NOT NULL COMMENT 'Dataset title',
  `title` varchar(100) DEFAULT NULL COMMENT 'Dataset heading',
  `description` text COMMENT 'Dataset description',
  `ordering` int(11) unsigned DEFAULT NULL COMMENT 'Order number',
  `is_visible` tinyint(1) unsigned DEFAULT NULL COMMENT 'Show dataset on site?',
  `filters` text COMMENT 'Dataset filters array',
  `sorting` text COMMENT 'Sorting rules array',
  `index` varchar(40) DEFAULT NULL COMMENT 'Index title',
  `groups_view` text COMMENT 'Show to groups',
  `groups_hide` text COMMENT 'Hide from groups',
  `seo_keys` varchar(256) DEFAULT NULL,
  `seo_desc` varchar(256) DEFAULT NULL,
  `seo_title` varchar(256) DEFAULT NULL,
  `seo_h1` varchar(256) DEFAULT NULL,
  `cats_view` text COMMENT 'Show to cats',
  `cats_hide` text COMMENT 'Hide from cats',
  `max_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `target_controller` varchar(32) DEFAULT NULL,
  `list` text,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `ctype_id` (`ctype_id`,`ordering`),
  KEY `index` (`index`),
  KEY `target_controller` (`target_controller`,`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Content type datasets' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_folders`
--

CREATE TABLE `[[dbprefix]]content_folders` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ctype_id` int(11) unsigned DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `title` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`ctype_id`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_relations`
--

CREATE TABLE `[[dbprefix]]content_relations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(256) DEFAULT NULL,
  `target_controller` varchar(32) NOT NULL DEFAULT 'content',
  `ctype_id` int(11) unsigned DEFAULT NULL,
  `child_ctype_id` int(11) unsigned DEFAULT NULL,
  `layout` varchar(32) DEFAULT NULL,
  `options` text,
  `seo_keys` varchar(256) DEFAULT NULL,
  `seo_desc` varchar(256) DEFAULT NULL,
  `seo_title` varchar(256) DEFAULT NULL,
  `ordering` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ctype_id` (`ctype_id`,`ordering`),
  KEY `child_ctype_id` (`child_ctype_id`,`target_controller`,`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_relations_bind`
--

CREATE TABLE `[[dbprefix]]content_relations_bind` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_ctype_id` int(11) unsigned DEFAULT NULL,
  `parent_item_id` int(11) unsigned DEFAULT NULL,
  `child_ctype_id` int(11) unsigned DEFAULT NULL,
  `child_item_id` int(11) unsigned DEFAULT NULL,
  `target_controller` varchar(32) NOT NULL DEFAULT 'content',
  PRIMARY KEY (`id`),
  KEY `parent_ctype_id` (`parent_ctype_id`),
  KEY `child_ctype_id` (`child_ctype_id`),
  KEY `parent_item_id` (`parent_item_id`,`target_controller`),
  KEY `child_item_id` (`child_item_id`,`target_controller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_types`
--

CREATE TABLE `[[dbprefix]]content_types` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `name` varchar(32) NOT NULL COMMENT 'System name',
  `description` text COMMENT 'Description',
  `ordering` int(11) DEFAULT NULL,
  `is_enabled` tinyint(1) unsigned DEFAULT '1',
  `is_date_range` tinyint(1) unsigned DEFAULT NULL,
  `is_cats` tinyint(1) unsigned DEFAULT NULL COMMENT 'Enable categories?',
  `is_cats_recursive` tinyint(1) unsigned DEFAULT NULL COMMENT 'End-to-end view of categories?',
  `is_folders` tinyint(1) unsigned DEFAULT NULL,
  `is_in_groups` tinyint(1) unsigned DEFAULT NULL COMMENT 'Create in groups',
  `is_in_groups_only` tinyint(1) unsigned DEFAULT NULL COMMENT 'Create only in groups',
  `is_comments` tinyint(1) unsigned DEFAULT NULL COMMENT 'Comments enabled?',
  `is_rating` tinyint(1) unsigned DEFAULT NULL COMMENT 'Allow rating?',
  `is_tags` tinyint(1) unsigned DEFAULT NULL,
  `is_auto_keys` tinyint(1) unsigned DEFAULT NULL COMMENT 'Autogeneration of keywords?',
  `is_auto_desc` tinyint(1) unsigned DEFAULT NULL COMMENT 'Autogeneration of description?',
  `is_auto_url` tinyint(1) unsigned DEFAULT NULL COMMENT 'Generate URL from title?',
  `is_fixed_url` tinyint(1) unsigned DEFAULT NULL COMMENT 'Do not change URL when editing an item?',
  `url_pattern` varchar(255) DEFAULT '{id}-{title}',
  `options` text COMMENT 'Options array',
  `labels` text COMMENT 'Labels array',
  `seo_keys` varchar(256) DEFAULT NULL COMMENT 'Keywords',
  `seo_desc` varchar(256) DEFAULT NULL COMMENT 'Description',
  `seo_title` varchar(256) DEFAULT NULL,
  `item_append_html` text,
  `is_fixed` tinyint(1) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `ordering` (`ordering`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Content types' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]content_types`
--

INSERT INTO `[[dbprefix]]content_types` VALUES
(1, 'Pages', 'pages', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, NULL, NULL, '{id}-{title}', '---\nis_cats_change: null\nis_cats_open_root: null\nis_cats_only_last: null\nis_show_cats: null\nis_tags_in_list: null\nis_tags_in_item: null\nis_rss: null\nlist_on: null\nprofile_on: null\nlist_show_filter: null\nlist_expand_filter: null\nlist_style:\nitem_on: 1\nis_cats_keys: null\nis_cats_desc: null\nis_cats_auto_url: 1\nseo_title_pattern:\nseo_keys_pattern: ''{content|string_get_meta_keywords}''\nseo_desc_pattern: ''{content|string_get_meta_description}''\n', '---\none: page\ntwo: pages\nmany: pages\ncreate: page\nlist:\nprofile:\n', NULL, NULL, NULL, NULL, 1),
(7, 'Photo albums', 'albums', '<p>User photo albums</p>', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, 1, 1, 1, 1, 1, 1, 1, '{id}-{title}', '---\nis_cats_change: null\nis_cats_open_root: null\nis_cats_only_last: null\nis_show_cats: null\nis_tags_in_list: null\nis_tags_in_item: 1\nis_rss: 1\nlist_on: 1\nprofile_on: 1\nlist_show_filter: null\nlist_expand_filter: null\nitem_on: 1\nis_cats_keys: null\nis_cats_desc: null\nis_cats_auto_url: 1\nseo_title_pattern:\nseo_keys_pattern: ''{content|string_get_meta_keywords}''\nseo_desc_pattern: ''{content|string_get_meta_description}''\n', '---\none: album\ntwo: albums\nmany: albums\ncreate: album\nlist:\nprofile:\n', NULL, NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]controllers`
--

CREATE TABLE `[[dbprefix]]controllers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `name` varchar(32) NOT NULL COMMENT 'System name',
  `slug` varchar(64) DEFAULT NULL,
  `is_enabled` tinyint(1) unsigned DEFAULT '1' COMMENT 'Enabled?',
  `options` text COMMENT 'Settings array',
  `author` varchar(128) NOT NULL COMMENT 'Author name',
  `url` varchar(250) DEFAULT NULL COMMENT 'Author site',
  `version` varchar(8) NOT NULL COMMENT 'Version',
  `is_backend` tinyint(1) unsigned DEFAULT NULL COMMENT 'Admin panel?',
  `is_external` tinyint(1) unsigned DEFAULT NULL COMMENT 'Third-party component',
  `files` text COMMENT 'Controller files list (for third-party components)',
  `addon_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Components' AUTO_INCREMENT=44 ;

--
-- Dumping data for table `[[dbprefix]]controllers`
--

INSERT INTO `[[dbprefix]]controllers` VALUES
(1, 'Control Panel', 'admin', NULL, 1, '---\ndashboard_order:\n  stat: 0\n  activity: 1\n  news: 2\n  sysinfo: 3\n  resources: 4\n  users_online: 5\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 0, NULL, NULL, NULL),
(2, 'Content', 'content', NULL, 1, NULL, 'InstantCMS Team', 'https://instantcms.ru', '2.0', 0, NULL, NULL, NULL),
(3, 'User Profiles', 'users', NULL, 1, '---\nis_ds_online: 1\nis_ds_rating: 1\nis_ds_popular: 1\nis_filter: 1\nis_auth_only: null\nis_status: 1\nis_wall: 1\nis_themes_on: 1\nmax_tabs: 6\nis_friends_on: 1\nis_karma: 1\nis_karma_comments: 1\nkarma_time: 30\nrestricted_slugs: |\n  *admin*\r\n  *moder*\nlimit: 15\nlist_allowed: [ ]\nshow_user_groups: 1\nshow_reg_data: 1\nshow_last_visit: 1\nprofile_max_friends_count: 10\nseo_keys: ""\nseo_desc: ''Site users list{page:, %s}''\ntag_title: ""\ntag_desc: ""\ntag_h1: ""\nseo_h1: Users\nseo_title: ''Users{page:, %s}''\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(5, 'Private messages', 'messages', NULL, 1, '---\nlimit: 10\ngroups_allowed: [ ]\neditor: "2"\neditor_presets: null\ntime_delete_old: 0\nrealtime_mode: ajax\nrefresh_time: 15\nsocket_host: ""\nsocket_port: 3000\nuse_queue: null\nis_enable_pm: 1\nis_contact_first_select: null\ntypograph_id: "2"\nemail_template: ""\n', 'InstantCMS Team', 'https://instantcms.ru/', '2.0', 1, NULL, NULL, NULL),
(6, 'Authorization & Registration', 'auth', NULL, 1, '---\nis_reg_enabled: 1\nreg_reason: >\n  We apologize, but,\n  we do not accept\n  new users at the moment\nis_reg_invites: null\nreg_captcha: null\nverify_email: null\nverify_exp: 48\nauth_captcha: null\nrestricted_emails: |\n  *@shitmail.me\r\n  *@mailspeed.ru\r\n  *@temp-mail.ru\r\n  *@guerrillamail.com\r\n  *@12minutemail.com\r\n  *@mytempemail.com\r\n  *@spamobox.com\r\n  *@disposableinbox.com\r\n  *@filzmail.com\r\n  *@freemail.ms\r\n  *@anonymbox.com\r\n  *@lroid.com\r\n  *@yopmail.com\r\n  *@TempEmail.net\r\n  *@spambog.com\r\n  *@mailforspam.com\r\n  *@spam.su\r\n  *@no-spam.ws\r\n  *@mailinator.com\r\n  *@spamavert.com\r\n  *@trashcanmail.com\nrestricted_names: |\n  admin*\r\n  moderator\nrestricted_ips:\nis_invites: 1\nis_invites_strict: 1\ninvites_period: 7\ninvites_qty: 3\ninvites_min_karma: 0\ninvites_min_rating: 0\ninvites_min_days: 0\nreg_auto_auth: 1\nfirst_auth_redirect: profileedit\nauth_redirect: none\ndef_groups:\n  - 3\nis_site_only_auth_users: null\nguests_allow_controllers:\n  - auth\n  - geo\nseo_keys:\nseo_desc:\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(13, 'Moderation Panel', 'moderation', NULL, 1, NULL, 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(19, 'Image Upload', 'images', NULL, 1, NULL, 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(23, 'Wysiwyg editors', 'wysiwygs', NULL, 1, NULL, 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(25, 'Multilinguality', 'languages', NULL, 1, '---\nservice: google\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(26, 'Typograph', 'typograph', NULL, 1, NULL, 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(27, 'Activity Feed', 'activity', NULL, 1, '---\ntypes:\n  - 10\n  - 11\n  - 17\n  - 16\n  - 14\n  - 13\n  - 18\n  - 7\n  - 19\n  - 12\n  - 8\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(28, 'Billing', 'billing', NULL, 1, '---\ncurrency_title: points\ncurrency: point|points|points\ncurrency_real: usd\nmin_pack: 0\nreg_bonus: 0\nin_mode: enabled\nprices:\n  - \n    amount: 1\n    price: 1\nis_plans: 1\nplan_remind_days: 3\nis_transfers: 1\nis_transfers_mail: null\nis_transfers_notify: null\nrtp_groups: [ ]\nis_rtp: null\nrtp_rate: 0.5\nis_ptr: 1\nptr_rate: 1\nis_out: null\nout_groups: [ ]\nis_out_mail: 1\nout_period_days: 0\nout_min: 1\nout_rate: 0.5\nout_systems: |\n  Stripe\r\n  PayPal\nout_email: ""\nis_refs: 1\nref_days: 100\nref_url: ""\nref_terms: ""\nref_bonus: 0\nref_mode: all\nref_type: linear\nref_scale: 2\nref_levels:\n  - \n    percent: 1\ncur_real_symb: $\nis_refs_as_invite: 1\npay_field_html: ''<a class="btn btn-primary billing-buy-field" href="{url}">{solid%coins} {title}</a>''\nlimit_log: 15\nlimit_out: 15\nlimit_refs: 15\nbtn_titles:\n  guest: ''Buying from {price}''\n  user: ''Buy for {price}''\n', 'InstantCMS Team', 'https://instantcms.io', '2.1.0', 1, NULL, NULL, NULL),
(29, 'Comments', 'comments', NULL, 1, '---\ndisable_icms_comments: null\nis_guests: 1\nguest_ip_delay: 1\nrestricted_ips: ""\ndim_negative: 1\nupdate_user_rating: 1\nlimit: 20\nseo_keys: ""\nseo_desc: ""\nis_guests_moderate: 1\nrestricted_emails: ""\nrestricted_names: ""\nlimit_nesting: 5\nshow_author_email: 1\neditor: "4"\neditor_presets: null\nshow_list:\n  - "0"\ntypograph_id: "1"\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(30, 'Content Security Policy', 'csp', NULL, 1, '---\nenable_csp: null\ncsp_str: "default-src ''self''; script-src ''unsafe-eval'' ''nonce-{nonce}'' ''strict-dynamic''; style-src ''self'' data: ''unsafe-inline'' https://fonts.googleapis.com; img-src ''self'' data: https://instantcms.ru; font-src ''self'' data: https://fonts.gstatic.com"\nis_report_only: 1\nenable_report: 1\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(31, 'Form constructor', 'forms', NULL, 1, '---\nsend_text: >\n  Thanks! Form\n sent successfully.\nallow_embed: null\nallow_embed_domain:\ndenied_embed_domain:\nletter: |\n  [subject:Form: {form_title} - {site}]\r\n  \r\n  Hello.\r\n  \r\n  The form <b>{form_title}</b> has been sent from the site {site}.\r\n  \r\n  Form data:\r\n  \r\n  {form_data}\r\n  \r\n  --\r\n   Best regards, {site}\r\n   <small>This letter is sent automatically, please do not reply.</small>\nnotify_text: ''<p>Hello.</p><p>Form <strong>{form_title}</strong> submitted.</p><p><strong>Form data:</strong></p><p>{form_data}</p>''\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(32, 'Geobase', 'geo', NULL, 1, '---\nauto_detect: 1\nauto_detect_provider: geoiplookup\ndefault_country_id: null\ndefault_country_id_cache: null\ndefault_region_id: null\ndefault_region_id_cache: null\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(33, 'Groups', 'groups', NULL, 1, '---\nis_ds_rating: 1\nis_ds_popular: 1\nis_wall: 1\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(34, 'Photos', 'photos', NULL, 1, '---\nsizes:\n  - normal\n  - small\n  - big\nis_origs: 1\npreset: big\npreset_small: normal\ntypes: |\n  1 | Фото\n  2 | Векторы\n  3 | Иллюстрации\nordering: date_pub\norderto: desc\nlimit: 20\ndownload_view:\n  normal: [ ]\n  micro: [ ]\n  small: [ ]\n  content_list_small: [ ]\n  content_list: [ ]\n  big: [ ]\n  content_item: [ ]\n  original: [ ]\ndownload_hide:\n  normal: null\n  micro: null\n  small: null\n  content_list_small: null\n  content_list: null\n  big: null\n  content_item: null\n  original:\n    - "1"\n    - "3"\n    - "4"\nurl_pattern: ''{id}-{title}''\npreset_related: normal\nrelated_limit: 0\neditor: "1"\neditor_presets: null\nseo_keys: ""\nseo_desc: ""\nallow_add_public_albums: null\nallow_download: 1\nhide_photo_item_info: null\ntypograph_id: "3"\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(35, 'Rating', 'rating', NULL, 1, '---\nis_hidden: 1\nis_show: 1\nallow_guest_vote: null\ntemplate: widget\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(36, 'reCAPTCHA', 'recaptcha', NULL, 1, '---\npublic_key:\nprivate_key:\ntheme: light\nlang: en\nsize: normal\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(37, 'Redirects', 'redirect', NULL, 1, '---\nno_redirect_list:\nblack_list:\nis_check_link: null\nwhite_list:\nredirect_time: 10\nis_check_refer: 1\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(38, 'RSS feeds', 'rss', NULL, 1, NULL, 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(39, 'Search', 'search', NULL, 1, '---\nperpage: 15\ntypes:\n  - pages\n  - articles\n  - posts\n  - albums\n  - board\n  - news\n  - groups\n  - photos\nis_hash_tag: null\norder_by: fsort\nseo_h1: ''{query?|Search}{query?Search results for «%s»}''\nseo_title: ''{query?|Search}{query?Search results for «%s»}''\nseo_keys: ""\nseo_desc: ''{target_title}: {query?|Search}{query?Search results for «%s»}''\nlist_type_as_original: "0"\nshow_search_params: 1\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(40, 'Sitemap and robots.txt generator', 'sitemap', NULL, 1, '---\nsources:\n  content|pages: 1\n  content|albums: 1\n  content|articles: 1\n  content|posts: 1\n  content|board: 1\n  content|news: 1\n  frontpage|root: 1\n  groups|profiles: 1\n  users|profiles: 1\nshow_lastmod: 1\nshow_changefreq: 1\ndefault_changefreq: daily\nshow_priority: 1\nrobots: |\n  User-agent: *\r\n  Disallow:\ngenerate_html_sitemap: null\nchangefreq:\n  content:\n    pages:\n    albums:\n    articles:\n    posts:\n    board:\n    news:\n  frontpage:\n    root:\n  groups:\n    profiles:\n  users:\n    profiles:\npriority:\n  content:\n    pages:\n    albums:\n    articles:\n    posts:\n    board:\n    news:\n  frontpage:\n    root: 1.0\n  groups:\n    profiles: 0.8\n  users:\n    profiles: 0.8\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(41, 'Subscriptions', 'subscriptions', NULL, 1, '---\nguest_email_confirmation: 1\nneed_auth: null\nverify_exp: 24\nupdate_user_rating: 1\nrating_value: 1\nadmin_email:\nlimit: 20\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(42, 'Tags', 'tags', NULL, 1, '---\nordering: frequency\nstyle: cloud\nmax_fs: 22\nmin_fs: 12\nmin_freq: 0\nmin_len: 0\nlimit: 10\ncolors:\nshuffle: 1\nseo_keys:\nseo_desc:\nseo_title_pattern:\nseo_desc_pattern:\nseo_h1_pattern:\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL),
(43, 'Wall', 'wall', NULL, 1, '---\nlimit: 15\norder_by: date_last_reply\nshow_entries: 5\neditor: "4"\neditor_presets: null\ntypograph_id: "1"\n', 'InstantCMS Team', 'https://instantcms.ru', '2.0', 1, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_albums`
--

CREATE TABLE `[[dbprefix]]con_albums` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `content` text,
  `slug` varchar(100) DEFAULT NULL,
  `seo_keys` varchar(256) DEFAULT NULL,
  `seo_desc` varchar(256) DEFAULT NULL,
  `seo_title` varchar(256) DEFAULT NULL,
  `tags` varchar(1000) DEFAULT NULL,
  `template` varchar(150) DEFAULT NULL,
  `date_pub` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_last_modified` timestamp NULL DEFAULT NULL,
  `date_pub_end` timestamp NULL DEFAULT NULL,
  `is_pub` tinyint(1) NOT NULL DEFAULT '1',
  `hits_count` int(11) DEFAULT '0',
  `user_id` int(11) unsigned DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `parent_type` varchar(32) DEFAULT NULL,
  `parent_title` varchar(100) DEFAULT NULL,
  `parent_url` varchar(255) DEFAULT NULL,
  `is_parent_hidden` tinyint(1) DEFAULT NULL,
  `category_id` int(11) unsigned NOT NULL DEFAULT '1',
  `folder_id` int(11) unsigned DEFAULT NULL,
  `is_comments_on` tinyint(1) unsigned DEFAULT '1',
  `comments` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `is_deleted` tinyint(1) unsigned DEFAULT NULL,
  `is_approved` tinyint(1) DEFAULT '1',
  `approved_by` int(11) DEFAULT NULL,
  `date_approved` timestamp NULL DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `cover_image` text,
  `photos_count` int(11) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `folder_id` (`folder_id`),
  KEY `slug` (`slug`),
  KEY `date_pub` (`is_pub`,`is_parent_hidden`,`is_deleted`,`is_approved`,`date_pub`),
  KEY `parent_id` (`parent_id`,`parent_type`,`date_pub`),
  KEY `user_id` (`user_id`,`date_pub`),
  KEY `date_pub_end` (`date_pub_end`),
  FULLTEXT KEY `fulltext_search` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_albums_cats`
--

CREATE TABLE `[[dbprefix]]con_albums_cats` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `description` text,
  `slug` varchar(255) DEFAULT NULL,
  `slug_key` varchar(255) DEFAULT NULL,
  `seo_keys` varchar(256) DEFAULT NULL,
  `seo_desc` varchar(256) DEFAULT NULL,
  `seo_title` varchar(256) DEFAULT NULL,
  `seo_h1` varchar(256) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `ns_left` int(11) DEFAULT NULL,
  `ns_right` int(11) DEFAULT NULL,
  `ns_level` int(11) DEFAULT NULL,
  `ns_differ` varchar(32) NOT NULL DEFAULT '',
  `ns_ignore` tinyint(4) NOT NULL DEFAULT '0',
  `allow_add` text,
  `is_hidden` tinyint(1) unsigned DEFAULT NULL,
  `cover` text,
  PRIMARY KEY (`id`),
  KEY `ordering` (`ordering`),
  KEY `slug` (`slug`),
  KEY `ns_left` (`ns_level`,`ns_right`,`ns_left`),
  KEY `parent_id` (`parent_id`,`ns_left`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]con_albums_cats`
--

INSERT INTO `[[dbprefix]]con_albums_cats` VALUES
(1, 0, '---', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, 2, 0, '', 0, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_albums_cats_bind`
--

CREATE TABLE `[[dbprefix]]con_albums_cats_bind` (
  `item_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  KEY `item_id` (`item_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_albums_fields`
--

CREATE TABLE `[[dbprefix]]con_albums_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ctype_id` int(11) DEFAULT NULL,
  `name` varchar(40) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `hint` varchar(200) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `is_enabled` tinyint(1) unsigned DEFAULT '1',
  `fieldset` varchar(32) DEFAULT NULL,
  `type` varchar(16) DEFAULT NULL,
  `is_in_list` tinyint(1) DEFAULT NULL,
  `is_in_item` tinyint(1) DEFAULT NULL,
  `is_in_filter` tinyint(1) DEFAULT NULL,
  `is_private` tinyint(1) DEFAULT NULL,
  `is_fixed` tinyint(1) DEFAULT NULL,
  `is_fixed_type` tinyint(1) DEFAULT NULL,
  `is_system` tinyint(1) DEFAULT NULL,
  `values` text,
  `options` text,
  `groups_read` text,
  `groups_add` text,
  `groups_edit` text,
  `filter_view` text,
  PRIMARY KEY (`id`),
  KEY `is_enabled` (`is_enabled`,`ordering`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]con_albums_fields`
--

INSERT INTO `[[dbprefix]]con_albums_fields` VALUES
(1, 7, 'title', 'Album title', NULL, 1, 1, NULL, 'caption', 1, 1, 1, NULL, 1, 1, 0, NULL, '---\nlabel_in_list: none\nlabel_in_item: none\nis_required: 1\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(2, 7, 'date_pub', 'Publication date', NULL, 2, 1, NULL, 'date', 1, 1, 1, NULL, 1, 1, 1, NULL, '---\nlabel_in_list: none\nlabel_in_item: left\nis_required: null\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(3, 7, 'user', 'Author', NULL, 3, 1, NULL, 'user', 1, 1, NULL, NULL, 1, 1, 1, NULL, '---\nlabel_in_list: none\nlabel_in_item: left\nis_required: null\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(4, 7, 'content', 'Album description', NULL, 4, 1, NULL, 'text', 1, 1, NULL, NULL, 1, NULL, NULL, NULL, '---\nmin_length: 0\nmax_length: 2048\nis_html_filter: null\nlabel_in_list: none\nlabel_in_item: none\nis_required: null\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(5, 7, 'cover_image', 'Album cover image', NULL, 5, 1, NULL, 'image', 1, NULL, NULL, NULL, 1, 1, 1, NULL, '---\nlabel_in_list: left\nlabel_in_item: left\nis_required: null\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(6, 7, 'is_public', 'Public photo album', 'Other users will be able to upload photos in this album', 6, 1, NULL, 'checkbox', 0, 0, NULL, NULL, 1, NULL, NULL, NULL, '---\nlabel_in_list: none\nlabel_in_item: none\n', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_albums_props`
--

CREATE TABLE `[[dbprefix]]con_albums_props` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `fieldset` varchar(32) DEFAULT NULL,
  `type` varchar(16) DEFAULT NULL,
  `is_in_filter` tinyint(1) DEFAULT NULL,
  `values` text,
  `options` text,
  PRIMARY KEY (`id`),
  KEY `is_active` (`is_in_filter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_albums_props_bind`
--

CREATE TABLE `[[dbprefix]]con_albums_props_bind` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `prop_id` int(11) DEFAULT NULL,
  `cat_id` int(11) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `prop_id` (`prop_id`),
  KEY `ordering` (`cat_id`,`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_albums_props_values`
--

CREATE TABLE `[[dbprefix]]con_albums_props_values` (
  `prop_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  KEY `prop_id` (`prop_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_pages`
--

CREATE TABLE `[[dbprefix]]con_pages` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `content` text,
  `slug` varchar(100) DEFAULT NULL,
  `seo_keys` varchar(256) DEFAULT NULL,
  `seo_desc` varchar(256) DEFAULT NULL,
  `seo_title` varchar(256) DEFAULT NULL,
  `tags` varchar(1000) DEFAULT NULL,
  `template` varchar(150) DEFAULT NULL,
  `date_pub` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_last_modified` timestamp NULL DEFAULT NULL,
  `date_pub_end` timestamp NULL DEFAULT NULL,
  `is_pub` tinyint(1) NOT NULL DEFAULT '1',
  `hits_count` int(11) DEFAULT '0',
  `user_id` int(11) unsigned DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `parent_type` varchar(32) DEFAULT NULL,
  `parent_title` varchar(100) DEFAULT NULL,
  `parent_url` varchar(255) DEFAULT NULL,
  `is_parent_hidden` tinyint(1) DEFAULT NULL,
  `category_id` int(11) unsigned NOT NULL DEFAULT '1',
  `folder_id` int(11) unsigned DEFAULT NULL,
  `is_comments_on` tinyint(1) unsigned DEFAULT '1',
  `comments` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `is_deleted` tinyint(1) unsigned DEFAULT NULL,
  `is_approved` tinyint(1) DEFAULT '1',
  `approved_by` int(11) DEFAULT NULL,
  `date_approved` timestamp NULL DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `attach` text,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `folder_id` (`folder_id`),
  KEY `slug` (`slug`),
  KEY `date_pub` (`is_pub`,`is_parent_hidden`,`is_deleted`,`is_approved`,`date_pub`),
  KEY `parent_id` (`parent_id`,`parent_type`,`date_pub`),
  KEY `user_id` (`user_id`,`date_pub`),
  KEY `date_pub_end` (`date_pub_end`),
  FULLTEXT KEY `fulltext_search` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_pages_cats`
--

CREATE TABLE `[[dbprefix]]con_pages_cats` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `description` text,
  `slug` varchar(255) DEFAULT NULL,
  `slug_key` varchar(255) DEFAULT NULL,
  `seo_keys` varchar(256) DEFAULT NULL,
  `seo_desc` varchar(256) DEFAULT NULL,
  `seo_title` varchar(256) DEFAULT NULL,
  `seo_h1` varchar(256) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `ns_left` int(11) DEFAULT NULL,
  `ns_right` int(11) DEFAULT NULL,
  `ns_level` int(11) DEFAULT NULL,
  `ns_differ` varchar(32) NOT NULL DEFAULT '',
  `ns_ignore` tinyint(4) NOT NULL DEFAULT '0',
  `allow_add` text,
  `is_hidden` tinyint(1) unsigned DEFAULT NULL,
  `cover` text,
  PRIMARY KEY (`id`),
  KEY `ordering` (`ordering`),
  KEY `slug` (`slug`),
  KEY `ns_left` (`ns_level`,`ns_right`,`ns_left`),
  KEY `parent_id` (`parent_id`,`ns_left`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]con_pages_cats`
--

INSERT INTO `[[dbprefix]]con_pages_cats` VALUES
(1, 0, '---', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, 2, 0, '', 0, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_pages_cats_bind`
--

CREATE TABLE `[[dbprefix]]con_pages_cats_bind` (
  `item_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  KEY `item_id` (`item_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_pages_fields`
--

CREATE TABLE `[[dbprefix]]con_pages_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ctype_id` int(11) DEFAULT NULL,
  `name` varchar(40) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `hint` varchar(200) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `is_enabled` tinyint(1) unsigned DEFAULT '1',
  `fieldset` varchar(32) DEFAULT NULL,
  `type` varchar(16) DEFAULT NULL,
  `is_in_list` tinyint(1) DEFAULT NULL,
  `is_in_item` tinyint(1) DEFAULT NULL,
  `is_in_filter` tinyint(1) DEFAULT NULL,
  `is_private` tinyint(1) DEFAULT NULL,
  `is_fixed` tinyint(1) DEFAULT NULL,
  `is_fixed_type` tinyint(1) DEFAULT NULL,
  `is_system` tinyint(1) DEFAULT NULL,
  `values` text,
  `options` text,
  `groups_read` text,
  `groups_add` text,
  `groups_edit` text,
  `filter_view` text,
  PRIMARY KEY (`id`),
  KEY `is_enabled` (`is_enabled`,`ordering`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]con_pages_fields`
--

INSERT INTO `[[dbprefix]]con_pages_fields` VALUES
(1, 1, 'title', 'Title', NULL, 1, 1, NULL, 'caption', 1, 1, 1, NULL, 1, 1, NULL, NULL, '---\nlabel_in_list: none\nlabel_in_item: none\nis_required: 1\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(2, 1, 'date_pub', 'Publication date', NULL, 2, 1, NULL, 'date', NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, '---\nlabel_in_list: none\nlabel_in_item: left\nis_required: null\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(3, 1, 'user', 'Author', NULL, 3, 1, NULL, 'user', NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, '---\nlabel_in_list: none\nlabel_in_item: left\nis_required: null\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(4, 1, 'content', 'Page content', NULL, 4, 1, NULL, 'html', NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, '---\neditor: 3\nis_html_filter: 1\nteaser_len:\nlabel_in_list: none\nlabel_in_item: none\nis_required: 1\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL),
(5, 1, 'attach', 'Download', 'Attach a file to the page', 5, 1, NULL, 'file', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '---\nshow_name: 0\nextensions: jpg, gif, png\nmax_size_mb: 2\nshow_size: 1\nlabel_in_list: none\nlabel_in_item: none\nis_required: null\nis_digits: null\nis_alphanumeric: null\nis_email: null\nis_unique: null\nprofile_value:\n', '---\n- 0\n', NULL, '---\n- 0\n', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_pages_props`
--

CREATE TABLE `[[dbprefix]]con_pages_props` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `fieldset` varchar(32) DEFAULT NULL,
  `type` varchar(16) DEFAULT NULL,
  `is_in_filter` tinyint(1) DEFAULT NULL,
  `values` text,
  `options` text,
  PRIMARY KEY (`id`),
  KEY `is_active` (`is_in_filter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_pages_props_bind`
--

CREATE TABLE `[[dbprefix]]con_pages_props_bind` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `prop_id` int(11) DEFAULT NULL,
  `cat_id` int(11) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `prop_id` (`prop_id`),
  KEY `ordering` (`cat_id`,`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]con_pages_props_values`
--

CREATE TABLE `[[dbprefix]]con_pages_props_values` (
  `prop_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  KEY `prop_id` (`prop_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]csp_logs`
--

CREATE TABLE `[[dbprefix]]csp_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date_pub` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `blocked_uri` varchar(255) DEFAULT NULL,
  `referrer` varchar(255) DEFAULT NULL,
  `line_number` smallint(6) DEFAULT NULL,
  `document_uri` varchar(255) DEFAULT NULL,
  `violated_directive` varchar(64) DEFAULT NULL,
  `effective_directive` varchar(64) DEFAULT NULL,
  `status_code` smallint(6) DEFAULT NULL,
  `ip` varbinary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date_pub` (`date_pub`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='CSP Logs' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events`
--

CREATE TABLE `[[dbprefix]]events` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `event` varchar(64) DEFAULT NULL COMMENT 'Event',
  `listener` varchar(32) DEFAULT NULL COMMENT 'Listener (component)',
  `ordering` int(5) unsigned DEFAULT NULL COMMENT 'Order number',
  `is_enabled` tinyint(1) unsigned DEFAULT '1' COMMENT 'Activity`',
  PRIMARY KEY (`id`),
  KEY `hook` (`event`),
  KEY `listener` (`listener`),
  KEY `is_enabled` (`is_enabled`,`ordering`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Binding hooks to events' AUTO_INCREMENT=412 ;

--
-- Dumping data for table `[[dbprefix]]events`
--

INSERT INTO `[[dbprefix]]events` VALUES
(6, 'widget_content_list_before_update_bind', 'content', 6, 1),
(7, 'menu_admin', 'admin', 7, 1),
(8, 'user_login', 'admin', 8, 1),
(9, 'admin_confirm_login', 'admin', 9, 1),
(10, 'user_profile_update', 'auth', 10, 1),
(11, 'frontpage', 'auth', 11, 1),
(12, 'page_is_allowed', 'auth', 12, 1),
(13, 'frontpage_types', 'auth', 13, 1),
(23, 'fulltext_search', 'content', 23, 1),
(24, 'admin_dashboard_chart', 'content', 24, 1),
(25, 'menu_content', 'content', 25, 1),
(26, 'user_delete', 'content', 26, 1),
(27, 'user_privacy_types', 'content', 27, 1),
(28, 'sitemap_sources', 'content', 28, 1),
(30, 'rss_content_controller_form', 'content', 30, 1),
(31, 'rss_content_controller_after_update', 'content', 31, 1),
(32, 'frontpage', 'content', 32, 1),
(33, 'frontpage_types', 'content', 33, 1),
(34, 'ctype_relation_childs', 'content', 34, 1),
(35, 'admin_content_dataset_fields_list', 'content', 35, 1),
(36, 'moderation_list', 'content', 36, 1),
(37, 'ctype_lists_context', 'content', 37, 1),
(38, 'ctype_after_update', 'frontpage', 38, 1),
(39, 'ctype_after_delete', 'frontpage', 39, 1),
(62, 'user_delete', 'images', 62, 1),
(63, 'admin_dashboard_chart', 'messages', 63, 1),
(64, 'menu_messages', 'messages', 64, 1),
(65, 'users_profile_view', 'messages', 65, 1),
(66, 'user_privacy_types', 'messages', 66, 1),
(67, 'user_delete', 'messages', 67, 1),
(68, 'user_notify_types', 'messages', 68, 1),
(69, 'admin_dashboard_block', 'moderation', 69, 1),
(70, 'content_after_trash_put', 'moderation', 70, 1),
(71, 'content_after_restore', 'moderation', 71, 1),
(72, 'content_before_delete', 'moderation', 72, 1),
(73, 'menu_moderation', 'moderation', 73, 1),
(99, 'html_filter', 'typograph', 99, 1),
(100, 'admin_dashboard_chart', 'users', 100, 1),
(101, 'menu_users', 'users', 101, 1),
(102, 'rating_vote', 'users', 102, 1),
(103, 'user_notify_types', 'users', 103, 1),
(104, 'user_privacy_types', 'users', 104, 1),
(105, 'user_tab_info', 'users', 105, 1),
(106, 'auth_login', 'users', 106, 1),
(107, 'user_preloaded', 'users', 107, 1),
(108, 'wall_permissions', 'users', 108, 1),
(109, 'wall_after_add', 'users', 109, 1),
(110, 'wall_after_delete', 'users', 110, 1),
(111, 'content_privacy_types', 'users', 111, 1),
(112, 'content_view_hidden', 'users', 112, 1),
(113, 'sitemap_sources', 'users', 113, 1),
(114, 'content_before_childs', 'users', 114, 1),
(115, 'ctype_relation_childs', 'users', 115, 1),
(119, 'page_is_allowed', 'widgets', 119, 1),
(123, 'content_groups_before_delete', 'moderation', 123, 1),
(124, 'comments_after_refuse', 'moderation', 124, 1),
(127, 'admin_subscriptions_list', 'content', 127, 1),
(140, 'admin_dashboard_block', 'users', 140, 1),
(142, 'sitemap_sources', 'frontpage', 142, 1),
(150, 'tags_search_subjects', 'content', 150, 1),
(151, 'images_before_upload', 'typograph', 151, 1),
(152, 'engine_start', 'content', 152, 1),
(164, 'comments_targets', 'content', 164, 1),
(167, 'admin_dashboard_block', 'admin', 167, 1),
(169, 'user_notify_types', 'content', 169, 1),
(170, 'form_users_password_2fa', 'authga', 170, 1),
(171, 'controller_auth_after_save_options', 'authga', 171, 1),
(172, 'form_users_password', 'auth', 172, 1),
(173, 'auth_twofactor_list', 'authga', 173, 1),
(174, 'users_before_edit_password', 'authga', 174, 1),
(176, 'admin_col_scheme_options', 'bootstrap4', 176, 1),
(178, 'admin_row_scheme_options', 'bootstrap4', 178, 1),
(186, 'ctype_field_users_after_update', 'bootstrap4', 186, 1),
(187, 'widget_menu_form', 'bootstrap4', 187, 1),
(190, 'db_nested_tables', 'content', 190, 1),
(191, 'widget_content_list_form', 'content', 191, 1),
(214, 'render_widget_menu_menu', 'bootstrap4', 214, 1),
(218, 'comments_after_delete_list', 'moderation', 218, 1),
(219, 'form_get', 'languages', 219, 1),
(220, 'widget_options_full_form', 'languages', 220, 1),
(221, 'languages_forms', 'admin', 221, 1),
(222, 'languages_forms', 'widgets', 222, 1),
(223, 'languages_forms', 'content', 223, 1),
(224, 'form_make', 'languages', 224, 1),
(225, 'languages_forms', 'users', 225, 1),
(228, 'grid_activity_types', 'languages', 228, 1),
(229, 'content_form_field', 'languages', 229, 1),
(230, 'ctype_field_after_add', 'languages', 230, 1),
(231, 'ctype_field_after_update', 'languages', 231, 1),
(232, 'engine_start', 'languages', 232, 1),
(234, 'ctype_basic_form', 'languages', 234, 1),
(235, 'frontpage_action_index', 'languages', 235, 1),
(236, 'content_before_item', 'languages', 236, 1),
(237, 'content_before_list', 'languages', 237, 1),
(238, 'content_item_form', 'languages', 238, 1),
(239, 'content_after_add_approve', 'activity', 1, 1),
(240, 'content_after_update_approve', 'activity', 2, 1),
(241, 'publish_delayed_content', 'activity', 3, 1),
(242, 'user_delete', 'activity', 4, 1),
(243, 'user_tab_info', 'activity', 5, 1),
(244, 'user_tab_show', 'activity', 6, 1),
(245, 'subscribe', 'activity', 125, 1),
(246, 'unsubscribe', 'activity', 126, 1),
(247, 'admin_dashboard_block', 'activity', 168, 1),
(248, 'admin_inline_save_subscriptions', 'activity', 175, 1),
(249, 'user_add_status_after', 'activity', 181, 1),
(250, 'users_add_friendship_mutual', 'activity', 188, 1),
(251, 'user_registered', 'activity', 189, 1),
(252, 'users_after_update', 'activity', 193, 1),
(253, 'ctype_labels_after_update', 'activity', 195, 1),
(254, 'ctype_after_delete', 'activity', 196, 1),
(255, 'comments_rate_after', 'activity', 197, 1),
(256, 'content_albums_after_delete', 'activity', 198, 1),
(257, 'content_photos_after_add', 'activity', 199, 1),
(258, 'comments_after_delete_list', 'activity', 200, 1),
(259, 'content_after_delete', 'activity', 201, 1),
(260, 'content_after_restore', 'activity', 205, 1),
(261, 'content_after_trash_put', 'activity', 206, 1),
(262, 'content_groups_after_delete', 'activity', 209, 1),
(263, 'group_after_join', 'activity', 210, 1),
(264, 'group_after_leave', 'activity', 211, 1),
(265, 'groups_after_accept_request', 'activity', 212, 1),
(266, 'groups_after_update', 'activity', 213, 1),
(267, 'languages_forms', 'activity', 227, 1),
(268, 'admin_users_filter', 'billing', 244, 1),
(269, 'content_add', 'billing', 245, 1),
(270, 'content_after_add_approve', 'billing', 246, 1),
(271, 'content_after_update_approve', 'billing', 247, 1),
(272, 'content_before_item', 'billing', 249, 1),
(273, 'content_edit', 'billing', 250, 1),
(274, 'content_validate', 'billing', 251, 1),
(275, 'cron_payouts', 'billing', 252, 1),
(276, 'cron_relegation', 'billing', 253, 1),
(277, 'ctype_after_add', 'billing', 254, 1),
(278, 'ctype_after_delete', 'billing', 255, 1),
(279, 'grid_admin_users', 'billing', 257, 1),
(280, 'menu_billing', 'billing', 258, 1),
(281, 'user_delete', 'billing', 259, 1),
(282, 'user_profile_buttons', 'billing', 260, 1),
(283, 'user_registered', 'billing', 261, 1),
(284, 'user_tab_info', 'billing', 262, 1),
(285, 'user_tab_show', 'billing', 263, 1),
(286, 'engine_start', 'billing', 264, 1),
(287, 'content_after_add', 'billing', 265, 1),
(288, 'content_after_update', 'billing', 266, 1),
(289, 'content_after_delete', 'billing', 267, 1),
(290, 'moderation_cancel', 'billing', 268, 1),
(291, 'moderation_rework', 'billing', 269, 1),
(292, 'content_after_update', 'comments', 14, 1),
(293, 'admin_dashboard_chart', 'comments', 16, 1),
(294, 'user_privacy_types', 'comments', 17, 1),
(295, 'user_login', 'comments', 18, 1),
(296, 'user_notify_types', 'comments', 19, 1),
(297, 'user_delete', 'comments', 20, 1),
(298, 'user_tab_info', 'comments', 21, 1),
(299, 'user_tab_show', 'comments', 22, 1),
(300, 'moderation_list', 'comments', 122, 1),
(301, 'content_before_item', 'comments', 156, 1),
(302, 'content_item_form', 'comments', 158, 1),
(303, 'ctype_basic_form', 'comments', 159, 1),
(304, 'photos_before_item', 'comments', 163, 1),
(305, 'content_before_list', 'comments', 166, 1),
(306, 'content_after_delete', 'comments', 202, 1),
(307, 'content_after_restore', 'comments', 207, 1),
(308, 'content_after_trash_put', 'comments', 208, 1),
(309, 'restore_user', 'comments', 216, 1),
(310, 'set_user_is_deleted', 'comments', 217, 1),
(311, 'photos_after_delete_list', 'comments', 239, 1),
(312, 'admin_content_filter', 'comments', 240, 1),
(313, 'admin_content_dataset_fields_list', 'comments', 241, 1),
(314, 'engine_start', 'csp', 239, 1),
(315, 'content_before_item', 'forms', 192, 1),
(316, 'languages_forms', 'forms', 233, 1),
(317, 'form_admin_widgets_page', 'geo', 243, 1),
(318, 'admin_dashboard_chart', 'groups', 40, 1),
(319, 'content_view_hidden', 'groups', 41, 1),
(320, 'content_before_list', 'groups', 42, 1),
(321, 'rating_vote', 'groups', 43, 1),
(322, 'user_privacy_types', 'groups', 44, 1),
(323, 'user_profile_buttons', 'groups', 45, 1),
(324, 'user_notify_types', 'groups', 46, 1),
(325, 'user_delete', 'groups', 47, 1),
(326, 'user_tab_info', 'groups', 48, 1),
(327, 'user_tab_show', 'groups', 49, 1),
(328, 'menu_groups', 'groups', 50, 1),
(329, 'sitemap_sources', 'groups', 51, 1),
(330, 'sitemap_urls', 'groups', 52, 1),
(331, 'content_privacy_types', 'groups', 53, 1),
(332, 'content_add_permissions', 'groups', 54, 1),
(333, 'fulltext_search', 'groups', 55, 1),
(334, 'content_before_childs', 'groups', 56, 1),
(335, 'ctype_relation_childs', 'groups', 57, 1),
(336, 'admin_groups_dataset_fields_list', 'groups', 58, 1),
(337, 'content_validate', 'groups', 59, 1),
(338, 'moderation_list', 'groups', 60, 1),
(339, 'content_before_item', 'groups', 61, 1),
(340, 'ctype_lists_context', 'groups', 120, 1),
(341, 'ctype_basic_form', 'groups', 161, 1),
(342, 'content_item_form_context', 'groups', 194, 1),
(343, 'languages_forms', 'groups', 226, 1),
(344, 'content_albums_items_html', 'photos', 74, 1),
(345, 'fulltext_search', 'photos', 75, 1),
(346, 'admin_albums_ctype_menu', 'photos', 76, 1),
(347, 'content_albums_after_add', 'photos', 77, 1),
(348, 'content_albums_after_delete', 'photos', 78, 1),
(349, 'content_albums_item_html', 'photos', 79, 1),
(350, 'content_albums_before_item', 'photos', 80, 1),
(351, 'content_albums_before_list', 'photos', 81, 1),
(352, 'user_delete', 'photos', 82, 1),
(353, 'admin_subscriptions_list', 'photos', 128, 1),
(354, 'sitemap_sources', 'photos', 143, 1),
(355, 'comments_targets', 'photos', 165, 1),
(356, 'user_delete', 'rating', 83, 1),
(357, 'content_before_list', 'rating', 84, 1),
(358, 'user_notify_types', 'rating', 155, 1),
(359, 'content_before_item', 'rating', 157, 1),
(360, 'ctype_basic_form', 'rating', 160, 1),
(361, 'photos_before_item', 'rating', 162, 1),
(362, 'content_after_delete', 'rating', 203, 1),
(363, 'photos_after_delete_list', 'rating', 240, 1),
(364, 'admin_content_filter', 'rating', 241, 1),
(365, 'admin_content_dataset_fields_list', 'rating', 242, 1),
(366, 'captcha_html', 'recaptcha', 85, 1),
(367, 'captcha_validate', 'recaptcha', 86, 1),
(368, 'captcha_list', 'recaptcha', 87, 1),
(369, 'engine_start', 'redirect', 215, 1),
(370, 'ctype_basic_form', 'rss', 87, 1),
(371, 'ctype_before_add', 'rss', 88, 1),
(372, 'ctype_after_add', 'rss', 89, 1),
(373, 'ctype_before_edit', 'rss', 90, 1),
(374, 'ctype_before_update', 'rss', 91, 1),
(375, 'ctype_after_delete', 'rss', 92, 1),
(376, 'content_before_category', 'rss', 93, 1),
(377, 'content_before_profile', 'rss', 94, 1),
(378, 'photos_before_item', 'search', 95, 1),
(379, 'content_before_list', 'search', 96, 1),
(380, 'content_before_item', 'search', 97, 1),
(381, 'before_print_head', 'search', 98, 1),
(382, 'engine_start', 'sitemap', 141, 1),
(383, 'user_delete', 'subscriptions', 129, 1),
(384, 'content_toolbar_html', 'subscriptions', 130, 1),
(385, 'photos_toolbar_html', 'subscriptions', 131, 1),
(386, 'content_filter_buttons_html', 'subscriptions', 132, 1),
(387, 'user_tab_info', 'subscriptions', 133, 1),
(388, 'content_photos_after_add', 'subscriptions', 134, 1),
(389, 'user_notify_types', 'subscriptions', 135, 1),
(390, 'user_tab_show', 'subscriptions', 136, 1),
(391, 'content_after_add_approve', 'subscriptions', 137, 1),
(392, 'publish_delayed_content', 'subscriptions', 138, 1),
(393, 'ctype_basic_form', 'subscriptions', 139, 1),
(394, 'content_category_after_update', 'subscriptions', 153, 1),
(395, 'ctype_lists_context', 'tags', 121, 1),
(396, 'ctype_basic_form', 'tags', 144, 1),
(397, 'content_after_add', 'tags', 145, 1),
(398, 'content_before_update', 'tags', 146, 1),
(399, 'content_item_form', 'tags', 147, 1),
(400, 'content_before_item', 'tags', 148, 1),
(401, 'content_before_list', 'tags', 149, 1),
(402, 'content_after_delete', 'tags', 204, 1),
(403, 'admin_dashboard_chart', 'wall', 116, 1),
(404, 'user_notify_types', 'wall', 117, 1),
(405, 'user_delete', 'wall', 118, 1),
(406, 'process_render_users_profile_view', 'wall', 179, 1),
(407, 'process_render_groups_group_view', 'wall', 180, 1),
(408, 'user_add_status', 'wall', 182, 1),
(409, 'form_groups_options', 'wall', 183, 1),
(410, 'form_users_options', 'wall', 184, 1),
(411, 'user_privacy_types', 'wall', 185, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forms`
--

CREATE TABLE `[[dbprefix]]forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `options` text,
  `tpl_form` varchar(100) DEFAULT NULL,
  `hash` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Form designer fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forms_fields`
--

CREATE TABLE `[[dbprefix]]forms_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) DEFAULT NULL,
  `name` varchar(40) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `hint` varchar(200) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `is_enabled` tinyint(3) unsigned DEFAULT '1',
  `fieldset` varchar(32) DEFAULT NULL,
  `type` varchar(16) DEFAULT NULL,
  `values` text,
  `options` text,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`,`is_enabled`,`ordering`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Поля конструктора форм' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]geo_cities`
--

CREATE TABLE `[[dbprefix]]geo_cities` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` int(10) unsigned NOT NULL DEFAULT '0',
  `region_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `ordering` int(11) unsigned NOT NULL DEFAULT '10000',
  `is_enabled` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=47910 ;

--
-- Dumping data for table `[[dbprefix]]geo_cities`
--

INSERT INTO `[[dbprefix]]geo_cities` VALUES
(10, 254, 122, 'Mobile', 10000, 1),
(277, 254, 127, 'Eagle', 10000, 1),
(429, 254, 135, 'Macomb', 10000, 1),
(616, 254, 145, 'Redwood Falls', 10000, 1),
(687, 254, 149, 'Burwell', 10000, 1),
(1153, 254, 172, 'Burlington', 10000, 1),
(1154, 254, 172, 'Montpelier', 10000, 1),
(1155, 254, 172, 'Newport', 10000, 1),
(1156, 254, 172, 'Rutland', 10000, 1),
(1157, 254, 172, 'Saint Johnsbury', 10000, 1),
(1158, 254, 172, 'Wilmington', 10000, 1),
(1163, 165, 76, 'Ulaangom', 10000, 1),
(1165, 33, 8, 'Rio Branco', 10000, 1),
(1166, 33, 1219, 'Bel', 10000, 1),
(1171, 114, 49, 'Denpasar', 10000, 1),
(1172, 33, 10, 'Macap', 10000, 1),
(1173, 33, 11, 'Salvador', 10000, 1),
(1175, 33, 13, 'Teresina', 10000, 1),
(1180, 254, 166, 'Salt Lake City', 10000, 1),
(1181, 33, 15, 'Foz do Igua', 10000, 1),
(1182, 43, 35, 'Montreal', 10000, 1),
(1185, 203, 3544, 'Ulan-Ude', 10000, 1),
(1189, 203, 3608, 'Izhevsk', 10000, 1),
(1190, 203, 3617, 'Birobidzhan', 10000, 1),
(1191, 159, 56, 'Hermosillo', 10000, 1),
(1193, 159, 2891, 'Tepic', 10000, 1),
(1196, 165, 2738, 'Ondorhaan', 10000, 1),
(1197, 165, 80, 'Choibalsan', 10000, 1),
(1201, 33, 16, 'Macei', 10000, 1),
(1202, 33, 17, 'Jo', 10000, 1),
(1203, 33, 18, 'Boa Vista', 10000, 1),
(1204, 33, 19, 'Aracaju', 10000, 1),
(1205, 43, 36, 'Edmonton', 10000, 1),
(1206, 43, 37, 'Toronto', 10000, 1),
(1211, 159, 59, 'Guadalajara', 10000, 1),
(1212, 159, 60, 'Pachuca', 10000, 1),
(1213, 159, 61, 'Cuernavaca', 10000, 1),
(1214, 159, 62, 'Tuxtla Gutierrez', 10000, 1),
(1215, 159, 63, 'Villahermosa', 10000, 1),
(1216, 159, 2896, 'Merida', 10000, 1),
(1217, 165, 81, 'Moron', 10000, 1),
(1218, 165, 82, 'Suhbaatar', 10000, 1),
(1221, 254, 133, 'Honolulu', 10000, 1),
(1222, 254, 138, 'Kansas City', 10000, 1),
(1225, 14, 1, 'Melbourne', 10000, 1),
(1226, 14, 2, 'Hobart', 10000, 1),
(1227, 33, 20, 'Man', 10000, 1),
(1228, 33, 21, 'S', 10000, 1),
(1229, 33, 22, 'Porto Velho', 10000, 1),
(1230, 43, 38, 'Winnipeg', 10000, 1),
(1231, 203, 105, 'Makhachkala', 10000, 1),
(1232, 203, 106, 'Yoshkar-Ola', 10000, 1),
(1235, 114, 2160, 'Ujung Pandang', 10000, 1),
(1236, 159, 2887, 'Saltillo', 10000, 1),
(1237, 159, 66, 'Acapulco', 10000, 1),
(1238, 165, 2729, 'Tsetserleg', 10000, 1),
(1242, 254, 131, 'Miami', 10000, 1),
(1249, 33, 1220, 'Recife', 10000, 1),
(1250, 33, 24, 'S', 10000, 1),
(1251, 33, 25, 'Palmas', 10000, 1),
(1253, 203, 110, 'Kazan', 10000, 1),
(1254, 159, 2893, 'Queretaro', 10000, 1),
(1255, 159, 2890, 'Morelia', 10000, 1),
(1265, 254, 149, 'Omaha', 10000, 1),
(1267, 254, 158, 'Oklahoma City', 10000, 1),
(1268, 14, 3, 'Brisbane', 10000, 1),
(1275, 159, 69, 'Monterrey', 10000, 1),
(1276, 159, 70, 'Ciudad Victoria', 10000, 1),
(1277, 159, 71, 'Leon', 10000, 1),
(1278, 165, 2737, 'Altai', 10000, 1),
(1283, 33, 26, 'Cuiab', 10000, 1),
(1284, 43, 39, 'Halifax', 10000, 1),
(1285, 165, 2731, 'Olgii', 10000, 1),
(1288, 254, 152, 'Newark', 10000, 1),
(1291, 33, 27, 'Belo Horizonte', 10000, 1),
(1292, 43, 40, 'Regina', 10000, 1),
(1293, 43, 41, 'St. John''s', 10000, 1),
(1295, 159, 72, 'Chetumal', 10000, 1),
(1298, 43, 42, 'Fredericton', 10000, 1),
(1303, 254, 161, 'Newport', 10000, 1),
(1306, 33, 28, 'Vit', 10000, 1),
(1307, 33, 29, 'Rio de Janeiro', 10000, 1),
(1308, 33, 30, 'Florian', 10000, 1),
(1311, 14, 4, 'Sydney', 10000, 1),
(1312, 14, 5, 'Adelaide', 10000, 1),
(1314, 114, 2151, 'Pontianak', 10000, 1),
(1315, 114, 2154, 'Samarinda', 10000, 1),
(1316, 159, 73, 'Mexicali', 10000, 1),
(1317, 254, 155, 'Raleigh', 10000, 1),
(1319, 33, 1217, 'Bras', 10000, 1),
(1320, 43, 43, 'Vancouver', 10000, 1),
(1323, 14, 6, 'Perth', 10000, 1),
(1324, 33, 32, 'Porto Alegre', 10000, 1),
(1327, 14, 7, 'Darwin', 10000, 1),
(1328, 33, 33, 'Campo Grande', 10000, 1),
(1329, 33, 34, 'Natal', 10000, 1),
(1331, 159, 74, 'La Paz', 10000, 1),
(1332, 43, 45, 'Charlottetown', 10000, 1),
(1333, 43, 46, 'Yellowknife', 10000, 1),
(1336, 14, 174, 'Canberra', 10000, 1),
(1342, 165, 193, 'Bulgan', 10000, 1),
(1343, 165, 194, 'Hovd', 10000, 1),
(1344, 159, 2886, 'Campeche', 10000, 1),
(1345, 159, 196, 'Chihuahua', 10000, 1),
(1346, 159, 197, 'Colima', 10000, 1),
(1347, 159, 198, 'Durango', 10000, 1),
(1348, 159, 2889, 'Estado De Mexico', 10000, 1),
(1350, 159, 201, 'Oaxaca', 10000, 1),
(1353, 159, 204, 'Tlaxcala', 10000, 1),
(1355, 159, 206, 'Zacatecas', 10000, 1),
(1362, 203, 3546, 'Chelyabinsk', 10000, 1),
(1364, 203, 3548, 'Chukchi', 10000, 1),
(1367, 203, 3552, 'Irkutsk', 10000, 1),
(1368, 203, 3553, 'Ivanovo', 10000, 1),
(1371, 203, 3561, 'Kemerovo', 10000, 1),
(1384, 203, 3578, 'Moscow', 10000, 1),
(1386, 203, 3582, 'Novgorod', 10000, 1),
(1387, 203, 3583, 'Novosibirsk', 10000, 1),
(1388, 203, 3584, 'Omsk', 10000, 1),
(1390, 203, 3585, 'Orenburg', 10000, 1),
(1392, 203, 3588, 'Perm''', 10000, 1),
(1396, 203, 3596, 'Saint Petersburg', 10000, 1),
(1398, 203, 3597, 'Saratov', 10000, 1),
(1400, 203, 3599, 'Smolensk', 10000, 1),
(1402, 203, 3602, 'Tambov', 10000, 1),
(1410, 203, 3612, 'Volgograd', 10000, 1),
(1416, 56, 1322, 'Kinsasa', 10000, 1),
(3332, 39, 1192, 'Moulmein', 10000, 1),
(3333, 11, 1018, 'Gyumri', 10000, 1),
(3334, 11, 1018, 'Spitak', 10000, 1),
(3335, 11, 1017, 'Vanadzor', 10000, 1),
(3336, 11, 1022, 'Yerevan', 10000, 1),
(3338, 10, 1051, 'Bahia Blanca', 10000, 1),
(3340, 10, 1055, 'Cordoba', 10000, 1),
(3341, 10, 1058, 'Crespo', 10000, 1),
(3342, 10, 1066, 'General Roca', 10000, 1),
(3343, 10, 1051, 'La Plata', 10000, 1),
(3344, 10, 1063, 'Luj', 10000, 1),
(3345, 10, 1065, 'Neuquen', 10000, 1),
(3346, 10, 1058, 'Paran', 10000, 1),
(3347, 10, 1051, 'Pinamar', 10000, 1),
(3348, 10, 1070, 'Rio Cuarto', 10000, 1),
(3349, 10, 1051, 'San Clemente del Tuy', 10000, 1),
(3350, 10, 1074, 'San Miguel de Tucuman', 10000, 1),
(3351, 10, 1071, 'Santa Fe', 10000, 1),
(3352, 15, 1083, 'Abtenau', 10000, 1),
(3353, 15, 1080, 'Graz', 10000, 1),
(3354, 15, 1081, 'Kitzbuhel', 10000, 1),
(3355, 15, 1077, 'Lilienfeld', 10000, 1),
(3356, 15, 1078, 'Linz', 10000, 1),
(3357, 15, 1079, 'Salzburg', 10000, 1),
(3358, 15, 1081, 'Solden', 10000, 1),
(3361, 15, 1075, 'Stegersbach', 10000, 1),
(3362, 15, 1078, 'Steyr', 10000, 1),
(3364, 14, 4, 'Albury', 10000, 1),
(3365, 14, 5, 'Beachport', 10000, 1),
(3366, 14, 4, 'Bega', 10000, 1),
(3367, 14, 1, 'Berwick', 10000, 1),
(3368, 14, 3, 'Blue Mountain', 10000, 1),
(3369, 14, 4, 'Bowral', 10000, 1),
(3370, 14, 3, 'Cairns', 10000, 1),
(3371, 14, 2, 'Campbell Town', 10000, 1),
(3372, 14, 1, 'Chelsea', 10000, 1),
(3374, 14, 3, 'Cooktown', 10000, 1),
(3375, 14, 4, 'Cootamundra', 10000, 1),
(3376, 14, 3, 'Croydon', 10000, 1),
(3377, 14, 4, 'Dubbo', 10000, 1),
(3378, 14, 5, 'Elizabeth', 10000, 1),
(3379, 14, 3, 'Gold Coast', 10000, 1),
(3380, 14, 4, 'Goulburn', 10000, 1),
(3381, 14, 4, 'Grafton', 10000, 1),
(3383, 14, 4, 'Inverell', 10000, 1),
(3384, 14, 4, 'Kempsey', 10000, 1),
(3386, 14, 4, 'Lithgow', 10000, 1),
(3387, 14, 3, 'Mackay', 10000, 1),
(3388, 14, 4, 'Maitland', 10000, 1),
(3389, 14, 3, 'Manly', 10000, 1),
(3390, 14, 1, 'Mildura', 10000, 1),
(3391, 14, 5, 'Millicent', 10000, 1),
(3392, 14, 1, 'Moe', 10000, 1),
(3393, 14, 4, 'Mona Vale', 10000, 1),
(3394, 14, 4, 'Newcastle', 10000, 1),
(3395, 14, 4, 'Orange', 10000, 1),
(3396, 14, 1, 'Shepparton', 10000, 1),
(3397, 14, 4, 'Srtoud', 10000, 1),
(3399, 14, 4, 'Tamworth', 10000, 1),
(3400, 14, 4, 'Wagga Wagga', 10000, 1),
(3401, 14, 4, 'Warringa', 10000, 1),
(3402, 14, 4, 'Wauchope', 10000, 1),
(3403, 14, 4, 'Wyong', 10000, 1),
(3404, 14, 4, 'Young', 10000, 1),
(3405, 16, 904, 'Baku', 10000, 1),
(3406, 24, 5051, 'Brussels', 10000, 1),
(3407, 24, 1131, 'Charleroi', 10000, 1),
(3408, 24, 1137, 'Diksmuide', 10000, 1),
(3409, 24, 5306, 'Dilbeek', 10000, 1),
(3410, 24, 1131, 'Frameries', 10000, 1),
(3411, 24, 5305, 'Genappe', 10000, 1),
(3412, 24, 1133, 'Hasselt', 10000, 1),
(3413, 24, 1137, 'Kortrijk', 10000, 1),
(3415, 24, 1129, 'Malines', 10000, 1),
(3416, 24, 1129, 'Mechelen', 10000, 1),
(3417, 24, 1135, 'Namur', 10000, 1),
(3418, 24, 1137, 'Pittem', 10000, 1),
(3419, 38, 5352, 'Bousse', 10000, 1),
(3420, 38, 4486, 'Ouahigouya', 10000, 1),
(3421, 38, 4477, 'Yako', 10000, 1),
(3422, 37, 1244, 'Plovdiv', 10000, 1),
(3423, 37, 1246, 'Sofia', 10000, 1),
(3424, 37, 1247, 'Varna', 10000, 1),
(3426, 29, 1172, 'Cochabamba', 10000, 1),
(3428, 29, 1175, 'Oruro', 10000, 1),
(3429, 29, 1178, 'Santa Cruz', 10000, 1),
(3430, 33, 24, '', 10000, 1),
(3431, 33, 27, 'Barbacena', 10000, 1),
(3432, 33, 24, 'Campinas', 10000, 1),
(3433, 33, 14, 'Fortaleza', 10000, 1),
(3434, 33, 1220, 'Garanhuns', 10000, 1),
(3435, 33, 11, 'Itapetinga', 10000, 1),
(3436, 33, 24, 'Jundia', 10000, 1),
(3437, 33, 15, 'Londrina', 10000, 1),
(3438, 33, 27, 'Nepomuceno', 10000, 1),
(3440, 33, 24, 'S', 10000, 1),
(3441, 31, 1116, 'Gaborone', 10000, 1),
(3442, 23, 1207, 'Minsk', 10000, 1),
(3443, 23, 1208, 'Molodechno', 10000, 1),
(3444, 23, 1206, 'Minsk', 10000, 1),
(3445, 25, 1165, 'Belize', 10000, 1),
(3446, 25, 1166, 'Belmopan', 10000, 1),
(3447, 25, 1170, 'Punta Gorda', 10000, 1),
(3448, 25, 1168, 'Orange Walk', 10000, 1),
(3449, 43, 38, 'Brandon', 10000, 1),
(3450, 43, 37, 'Brockville', 10000, 1),
(3451, 43, 37, 'Brussels', 10000, 1),
(3452, 43, 37, 'Burlington', 10000, 1),
(3453, 43, 37, 'Collingwood', 10000, 1),
(3454, 43, 43, 'Courtenay', 10000, 1),
(3455, 43, 43, 'Cranbrook', 10000, 1),
(3456, 43, 43, 'Dawson Creek', 10000, 1),
(3457, 43, 37, 'Georgina', 10000, 1),
(3459, 43, 35, 'Granby', 10000, 1),
(3460, 43, 37, 'Hamilton', 10000, 1),
(3461, 43, 43, 'Kamloops', 10000, 1),
(3462, 43, 37, 'Kingston', 10000, 1),
(3463, 43, 35, 'La Salle', 10000, 1),
(3464, 43, 37, 'Leamington', 10000, 1),
(3468, 43, 37, 'Markham', 10000, 1),
(3469, 43, 42, 'Moncton', 10000, 1),
(3470, 43, 37, 'Orillia', 10000, 1),
(3473, 43, 37, 'Owen Sound', 10000, 1),
(3474, 43, 37, 'Peterborough', 10000, 1),
(3476, 43, 43, 'Prince Rupert', 10000, 1),
(3477, 43, 35, 'Quebec', 10000, 1),
(3479, 43, 37, 'Sarnia', 10000, 1),
(3480, 43, 37, 'Scarborough', 10000, 1),
(3483, 43, 42, 'Saint John', 10000, 1),
(3484, 43, 37, 'Stratford', 10000, 1),
(3486, 43, 37, 'Thunder Bay', 10000, 1),
(3487, 43, 43, 'Vernon', 10000, 1),
(3488, 43, 37, 'Waterloo', 10000, 1),
(3489, 43, 37, 'Wawa', 10000, 1),
(3492, 43, 37, 'Woodstock', 10000, 1),
(3493, 234, 4029, 'Bern', 10000, 1),
(3494, 234, 4033, 'Chur', 10000, 1),
(3496, 234, 4033, 'Davos', 10000, 1),
(3497, 234, 4027, 'Liestal', 10000, 1),
(3498, 234, 4044, 'Locarno', 10000, 1),
(3499, 234, 4029, 'Saas Fee', 10000, 1),
(3500, 234, 4033, 'Saint Moritz', 10000, 1),
(3501, 234, 4035, 'Sursee', 10000, 1),
(3502, 234, 4039, 'Winterthur', 10000, 1),
(3503, 60, 2283, 'Abidjan', 10000, 1),
(3504, 48, 1370, 'La Serena', 10000, 1),
(3506, 48, 1367, 'Pucon', 10000, 1),
(3507, 48, 1373, 'Punta Arenas', 10000, 1),
(3508, 48, 1375, 'Santiago', 10000, 1),
(3509, 48, 1368, 'Talca', 10000, 1),
(3510, 48, 1372, 'Valdivia', 10000, 1),
(3511, 48, 1364, 'Valparaiso', 10000, 1),
(3513, 42, 1386, 'Douala', 10000, 1),
(3514, 42, 1389, 'Limbe', 10000, 1),
(3515, 42, 1387, 'Mankon Bamenda', 10000, 1),
(3516, 49, 1342, 'Baoding', 10000, 1),
(3517, 49, 1348, 'Beihai', 10000, 1),
(3518, 49, 1353, 'Beijing', 10000, 1),
(3519, 49, 1353, 'Changchun', 10000, 1),
(3520, 49, 1341, 'Changhua City', 10000, 1),
(3521, 49, 1347, 'Changhua', 10000, 1),
(3522, 49, 1343, 'Changsha', 10000, 1),
(3523, 49, 1336, 'Changshu', 10000, 1),
(3524, 49, 1355, 'Changzhi', 10000, 1),
(3525, 49, 1358, 'Chengdu', 10000, 1),
(3529, 49, 1363, 'Chongqing', 10000, 1),
(3532, 49, 1350, 'Dalian', 10000, 1),
(3533, 49, 1349, 'Dandong', 10000, 1),
(3534, 49, 1342, 'Dongying', 10000, 1),
(3537, 49, 1361, 'Foshan', 10000, 1),
(3538, 49, 1339, 'Fuzhou', 10000, 1),
(3539, 49, 1361, 'Guangzhou', 10000, 1),
(3540, 49, 1348, 'Guilin', 10000, 1),
(3543, 49, 1334, 'Hangzhou', 10000, 1),
(3544, 49, 1340, 'Harbin', 10000, 1),
(3545, 49, 1333, 'Hefei', 10000, 1),
(3549, 49, 586, 'Hsin Tien', 10000, 1),
(3550, 49, 586, 'Hsin-Chu County', 10000, 1),
(3551, 49, 1357, 'Hsin-Chu', 10000, 1),
(3552, 49, 586, 'Hsintien City', 10000, 1),
(3553, 49, 1343, 'Hua-Lien City', 10000, 1),
(3554, 49, 586, 'Hua-Lien County', 10000, 1),
(3555, 49, 586, 'I-Lan County', 10000, 1),
(3556, 49, 1337, 'Jilin', 10000, 1),
(3557, 49, 1356, 'Jinan', 10000, 1),
(3558, 49, 1358, 'Kaifeng', 10000, 1),
(3559, 49, 1361, 'Kaiping', 10000, 1),
(3560, 236, 4273, 'Kaohsiung County', 10000, 1),
(3561, 236, 4273, 'Kaohsiung Municipality', 10000, 1),
(3562, 49, 586, 'Keelung City', 10000, 1),
(3563, 49, 1349, 'Kunming', 10000, 1),
(3565, 49, 1350, 'Liaoyang', 10000, 1),
(3566, 49, 1348, 'Liuzhou', 10000, 1),
(3567, 49, 586, 'Luchou Township', 10000, 1),
(3568, 49, 1341, 'Luoyang', 10000, 1),
(3569, 49, 586, 'Miao-Li County', 10000, 1),
(3570, 49, 586, 'Mucha District', 10000, 1),
(3571, 49, 1336, 'Nanjing', 10000, 1),
(3572, 49, 586, 'Nantou County', 10000, 1),
(3573, 49, 586, 'Neipu Hsiang', 10000, 1),
(3574, 49, 1334, 'Ningbo', 10000, 1),
(3575, 49, 586, 'Pei-Kang Township', 10000, 1),
(3576, 49, 1356, 'Qingdao', 10000, 1),
(3577, 49, 1342, 'Qinhuangdao', 10000, 1),
(3578, 49, 1339, 'Quanzhou', 10000, 1),
(3579, 49, 1356, 'Qufu', 10000, 1),
(3580, 49, 1334, 'Quzhou', 10000, 1),
(3581, 49, 1354, 'Shanghai', 10000, 1),
(3582, 49, 1350, 'Shenyang', 10000, 1),
(3583, 49, 1361, 'Shenzhen', 10000, 1),
(3584, 49, 1342, 'Shijiazhuang', 10000, 1),
(3585, 49, 586, 'Shin Lin District', 10000, 1),
(3586, 49, 1334, 'Shiyan', 10000, 1),
(3587, 49, 1336, 'Suzhou', 10000, 1),
(3588, 49, 586, 'Taichung City', 10000, 1),
(3589, 49, 586, 'Tai-Nan City', 10000, 1),
(3592, 49, 586, 'Tamsui Township', 10000, 1),
(3594, 49, 1359, 'TIANJIN', 10000, 1),
(3595, 49, 586, 'Wuchi Town', 10000, 1),
(3596, 49, 1344, 'WUHAN', 10000, 1),
(3597, 49, 1336, 'WUXI', 10000, 1),
(3598, 49, 1339, 'XIAMEN', 10000, 1),
(3599, 49, 1336, 'YANGZHOU', 10000, 1),
(3600, 49, 1356, 'YANTAI', 10000, 1),
(3601, 49, 1350, 'YINGKOU', 10000, 1),
(3602, 49, 1343, 'YUEYANG', 10000, 1),
(3603, 49, 586, 'Yungho City', 10000, 1),
(3604, 49, 1344, 'YUSHU', 10000, 1),
(3605, 49, 1341, 'ZHENGZHOU', 10000, 1),
(3606, 49, 1349, 'ZHENJIANG', 10000, 1),
(3607, 49, 1334, 'ZHOUSHAN', 10000, 1),
(3608, 49, 1361, 'ZHUHAI', 10000, 1),
(3609, 49, 1356, 'ZIBO', 10000, 1),
(3610, 49, 1358, 'ZIGONG', 10000, 1),
(3611, 53, 1401, 'Armenia', 10000, 1),
(3612, 53, 1401, 'Barranquilla', 10000, 1),
(3614, 53, 1419, 'Bucaramanga', 10000, 1),
(3615, 53, 1422, 'Cali', 10000, 1),
(3617, 53, 1398, 'Cartagena', 10000, 1),
(3619, 53, 1403, 'Honda', 10000, 1),
(3620, 53, 1421, 'Ibague', 10000, 1),
(3621, 53, 1430, 'Manizales', 10000, 1),
(3622, 53, 1399, 'Medellin', 10000, 1),
(3623, 53, 1403, 'Popayan', 10000, 1),
(3624, 53, 1431, 'Santa Marta', 10000, 1),
(3625, 53, 1411, 'Sincelejo', 10000, 1),
(3626, 53, 1414, 'Tunja', 10000, 1),
(3627, 59, 1433, 'Cartago', 10000, 1),
(3628, 59, 1434, 'Ciudad Quesada', 10000, 1),
(3629, 59, 1438, 'Escazu', 10000, 1),
(3630, 59, 1435, 'Heredia', 10000, 1),
(3631, 59, 1437, 'Jaco', 10000, 1),
(3632, 59, 1434, 'Liberia', 10000, 1),
(3634, 59, 1438, 'San Jose', 10000, 1),
(3635, 59, 1438, 'San Ramon', 10000, 1),
(3636, 59, 1433, 'Turrialba', 10000, 1),
(3637, 44, 1481, 'Mindelo', 10000, 1),
(3638, 44, 1476, 'Praia', 10000, 1),
(3639, 64, 5122, 'Brno', 10000, 1),
(3640, 64, 5125, 'Karlovy Vary', 10000, 1),
(3641, 64, 5129, 'Krnov', 10000, 1),
(3642, 64, 5128, 'Olomouc', 10000, 1),
(3643, 64, 1746, 'Prague', 10000, 1),
(3644, 64, 5130, 'Zamberk', 10000, 1),
(3645, 91, 1918, 'Aachen', 10000, 1),
(3646, 91, 1913, 'Ansbach', 10000, 1),
(3647, 91, 1926, 'Apolda', 10000, 1),
(3648, 91, 1913, 'Augsburg', 10000, 1),
(3649, 91, 1913, 'Bad Koenigshofen', 10000, 1),
(3650, 91, 1917, 'Bad Zwischenahn', 10000, 1),
(3651, 91, 1927, 'Berlin', 10000, 1),
(3652, 91, 1920, 'Bexbach', 10000, 1),
(3653, 91, 1917, 'Billerbeck', 10000, 1),
(3654, 91, 1919, 'Bingen Am Rhein', 10000, 1),
(3655, 91, 1916, 'Braunfels', 10000, 1),
(3656, 91, 1917, 'Braunschweig', 10000, 1),
(3657, 91, 1920, 'Budingen', 10000, 1),
(3658, 91, 1913, 'Coburg', 10000, 1),
(3659, 91, 1918, 'Cologne', 10000, 1),
(3660, 91, 1912, 'Crailsheim', 10000, 1),
(3661, 91, 1924, 'Cranzahl', 10000, 1),
(3662, 91, 1913, 'Dorfen', 10000, 1),
(3663, 91, 1918, 'Dortmund', 10000, 1),
(3664, 91, 1924, 'Dresden', 10000, 1),
(3665, 91, 1912, 'Eberbach', 10000, 1),
(3666, 91, 1913, 'Eichstatt', 10000, 1),
(3667, 91, 1926, 'Eisenach', 10000, 1),
(3668, 91, 1918, 'Emmerich', 10000, 1),
(3669, 91, 1926, 'Erfurt', 10000, 1),
(3670, 91, 1912, 'Esslingen', 10000, 1),
(3671, 91, 1921, 'Eutin', 10000, 1),
(3672, 91, 1912, 'Freiburg Im Breisgau', 10000, 1),
(3673, 91, 1912, 'Friedrichshafen', 10000, 1),
(3674, 91, 1912, 'Friolzheim', 10000, 1),
(3675, 91, 1913, 'Fussen', 10000, 1),
(3676, 91, 1917, 'Garbsen', 10000, 1),
(3679, 91, 1912, 'Gedern', 10000, 1),
(3680, 91, 1926, 'Gera', 10000, 1),
(3682, 91, 1921, 'Gluckstadt', 10000, 1),
(3683, 91, 1926, 'Gotha', 10000, 1),
(3684, 91, 1912, 'Gottelfingen', 10000, 1),
(3685, 91, 1923, 'Greifswald', 10000, 1),
(3686, 91, 1919, 'Grunstadt', 10000, 1),
(3687, 91, 1913, 'Gunzenhausen', 10000, 1),
(3688, 91, 1915, 'Hamburg', 10000, 1),
(3689, 91, 1918, 'Hamm', 10000, 1),
(3690, 91, 1917, 'Helmstedt', 10000, 1),
(3691, 91, 1918, 'Herford', 10000, 1),
(3692, 91, 1913, 'Hof', 10000, 1),
(3695, 91, 1919, 'Kaiserslautern', 10000, 1),
(3696, 91, 1918, 'Kleve', 10000, 1),
(3697, 91, 1919, 'Koblenz', 10000, 1),
(3698, 91, 1927, 'Koenigs Wusterhausen', 10000, 1),
(3699, 91, 1918, 'Krefeld', 10000, 1),
(3700, 91, 1913, 'Kubelstein Stadt Schesslitz', 10000, 1),
(3701, 91, 1919, 'Kusel', 10000, 1),
(3702, 91, 1912, 'Leinfelden-Echterdingen', 10000, 1),
(3703, 91, 1924, 'Leipzig', 10000, 1),
(3704, 91, 1918, 'Lengerich', 10000, 1),
(3705, 91, 1912, 'Leonberg', 10000, 1),
(3706, 91, 1913, 'Lichtenfels', 10000, 1),
(3707, 91, 1919, 'Linz Am Rhein', 10000, 1),
(3708, 91, 1921, 'Lubeck', 10000, 1),
(3709, 91, 1918, 'Ludinghausen', 10000, 1),
(3710, 91, 1919, 'Ludwigshafen Am Rhein', 10000, 1),
(3711, 91, 1925, 'Lutherstadt Wittenberg', 10000, 1),
(3712, 91, 1919, 'Mainz', 10000, 1),
(3713, 91, 1912, 'Malsch', 10000, 1),
(3714, 91, 1912, 'Mannheim', 10000, 1),
(3715, 91, 1912, 'Marbach Am Neckar', 10000, 1),
(3717, 91, 1918, 'Marl', 10000, 1),
(3718, 91, 1916, 'Melsungen', 10000, 1),
(3719, 91, 1913, 'Memmingen', 10000, 1),
(3720, 91, 1912, 'Me', 10000, 1),
(3721, 91, 1919, 'Morzheim', 10000, 1),
(3722, 91, 1913, 'Munich', 10000, 1),
(3723, 91, 1918, 'Munster', 10000, 1),
(3725, 91, 1913, 'Neu Ulm', 10000, 1),
(3727, 91, 1913, 'Neustadt An Der Waldnaab', 10000, 1),
(3728, 91, 1917, 'Nienburg', 10000, 1),
(3729, 91, 1912, 'Ofterdingen', 10000, 1),
(3730, 91, 1917, 'Osnabruck', 10000, 1),
(3731, 91, 1918, 'Paderborn', 10000, 1),
(3732, 91, 1913, 'Passau', 10000, 1),
(3733, 91, 1912, 'Pfaffenweiler', 10000, 1),
(3734, 91, 1921, 'Pinneberg', 10000, 1),
(3735, 91, 1918, 'Porta Westfalica', 10000, 1),
(3736, 91, 1922, 'Potsdam', 10000, 1),
(3737, 91, 1912, 'Rastatt', 10000, 1),
(3738, 91, 1918, 'Ratingen', 10000, 1),
(3739, 91, 1913, 'Regensburg', 10000, 1),
(3740, 91, 1922, 'Rheinsberg', 10000, 1),
(3741, 91, 1914, 'Rodental', 10000, 1),
(3742, 91, 1920, 'Saarbrucken', 10000, 1),
(3743, 91, 1919, 'Schaumburg', 10000, 1),
(3744, 91, 1919, 'Schifferstadt', 10000, 1),
(3745, 91, 1917, 'Schledehausen', 10000, 1),
(3746, 91, 1912, 'Schwabisch Gmund', 10000, 1),
(3747, 91, 1923, 'Schwerin', 10000, 1),
(3748, 91, 1912, 'Schwieberdingen', 10000, 1),
(3749, 91, 1917, 'Seevetal', 10000, 1),
(3750, 91, 1917, 'Soltau', 10000, 1),
(3752, 91, 1917, 'Stade', 10000, 1),
(3753, 91, 1912, 'Stuttgart', 10000, 1),
(3754, 91, 1912, 'Sulzfeld', 10000, 1),
(3755, 91, 1913, 'Tirschenreuth', 10000, 1),
(3756, 91, 1919, 'Trier', 10000, 1),
(3757, 91, 1912, 'Trossingen', 10000, 1),
(3758, 91, 1912, 'Tubingen', 10000, 1),
(3759, 91, 1912, 'Ulm', 10000, 1),
(3761, 91, 1912, 'Walldorf', 10000, 1),
(3762, 91, 1913, 'WASSERBURG', 10000, 1),
(3763, 91, 1926, 'Weimar', 10000, 1),
(3764, 91, 1918, 'Wesel', 10000, 1),
(3765, 91, 1912, 'Wiernsheim', 10000, 1),
(3766, 91, 1912, 'Wiesloch', 10000, 1),
(3767, 91, 1917, 'Wilhelmshaven', 10000, 1),
(3768, 91, 1912, 'Winterlingen', 10000, 1),
(3769, 91, 1917, 'Wittmund', 10000, 1),
(3770, 91, 1912, 'Wolfach', 10000, 1),
(3771, 91, 1917, 'Wolfenbuttel', 10000, 1),
(3772, 91, 1919, 'Worms', 10000, 1),
(3773, 91, 1913, 'WURZBURG', 10000, 1),
(3774, 91, 1924, 'Zittau', 10000, 1),
(3775, 91, 1919, 'Zweibrucken', 10000, 1),
(3776, 65, 1494, 'Aalborg', 10000, 1),
(3777, 65, 1489, 'Ebeltoft', 10000, 1),
(3778, 65, 1498, 'Haderslev', 10000, 1),
(3780, 65, 1492, 'Odense', 10000, 1),
(3781, 65, 1498, 'Rodding', 10000, 1),
(3782, 65, 1495, 'Varde', 10000, 1),
(3783, 68, 1529, 'La Romana', 10000, 1),
(3784, 68, 1540, 'Santiago', 10000, 1),
(3786, 3, 875, 'Mascara', 10000, 1),
(3787, 70, 1550, 'Cuenca', 10000, 1),
(3788, 70, 1551, 'Guaranda', 10000, 1),
(3789, 70, 1558, 'Guayaquil', 10000, 1),
(3790, 70, 1559, 'Ibarra', 10000, 1),
(3791, 70, 1555, 'Latacunga', 10000, 1),
(3792, 70, 1565, 'Quito', 10000, 1),
(3793, 70, 1554, 'Riobamba', 10000, 1),
(3794, 70, 1565, 'Santo Domingo De Los Colorados', 10000, 1),
(3795, 75, 1636, 'Parnu', 10000, 1),
(3796, 75, 1640, 'Tartu', 10000, 1),
(3797, 71, 1593, 'Alexandria', 10000, 1),
(3798, 71, 1580, 'Cairo', 10000, 1),
(3799, 71, 1577, 'Giza', 10000, 1),
(3800, 71, 1580, 'Heliopolis', 10000, 1),
(3801, 71, 1592, 'Luxor', 10000, 1),
(3803, 226, 3910, 'Aledo', 10000, 1),
(3804, 226, 3913, 'Aviles', 10000, 1),
(3805, 226, 3935, 'Balaguer', 10000, 1),
(3806, 226, 3936, 'Barcarrota', 10000, 1),
(3807, 226, 3935, 'Barcelona', 10000, 1),
(3808, 226, 3938, 'Bilbao', 10000, 1),
(3810, 226, 3930, 'Cadiz', 10000, 1),
(3811, 226, 3886, 'Ciudadela', 10000, 1),
(3812, 226, 3930, 'El Puerto De Santa Maria', 10000, 1),
(3814, 226, 3913, 'Gijon', 10000, 1),
(3815, 226, 3930, 'Granada', 10000, 1),
(3816, 226, 3930, 'Huelva', 10000, 1),
(3817, 226, 3932, 'Las Palmas de Gran Canaria', 10000, 1),
(3818, 226, 3908, 'Madrid', 10000, 1),
(3819, 226, 3930, 'Malaga', 10000, 1),
(3820, 226, 3910, 'Murcia', 10000, 1),
(3821, 226, 3913, 'Oviedo', 10000, 1),
(3822, 226, 3886, 'Palma de Mallorca', 10000, 1),
(3823, 226, 3886, 'Petra', 10000, 1),
(3826, 226, 3930, 'Santa Fe', 10000, 1),
(3828, 226, 3930, 'Sevilla ', 10000, 1),
(3829, 226, 3933, 'Toledo', 10000, 1),
(3830, 226, 3908, 'Tres Cantos', 10000, 1),
(3831, 226, 3910, 'Yecla', 10000, 1),
(3832, 76, 1691, 'Axum', 10000, 1),
(3833, 81, 5023, 'Alajarvi', 10000, 1),
(3834, 81, 4879, 'Heinola', 10000, 1),
(3835, 81, 5023, 'Jakobstad', 10000, 1),
(3836, 81, 1779, 'Jarvenpaa', 10000, 1),
(3837, 81, 5023, 'Kokkola', 10000, 1),
(3838, 81, 5022, 'Kuopio', 10000, 1),
(3839, 81, 4879, 'Lappeenranta', 10000, 1),
(3840, 81, 5023, 'Lapua', 10000, 1),
(3841, 81, 4879, 'Porvoo', 10000, 1),
(3842, 81, 1777, 'Rovaniemi', 10000, 1),
(3843, 81, 1779, 'Salo', 10000, 1),
(3844, 81, 5023, 'Seinajoki', 10000, 1),
(3845, 81, 4879, 'Tampere', 10000, 1),
(3846, 80, 1784, 'Nailuva', 10000, 1),
(3847, 82, 1813, 'Albertville', 10000, 1),
(3848, 82, 1807, 'Albi', 10000, 1),
(3849, 82, 1811, 'Angouleme', 10000, 1),
(3850, 82, 1812, 'Antibes', 10000, 1),
(3851, 82, 1793, 'Arcachon', 10000, 1),
(3852, 82, 1804, 'Arles', 10000, 1),
(3853, 82, 1798, 'Aubigny-sur-Nere', 10000, 1),
(3854, 82, 1812, 'Avignon', 10000, 1),
(3855, 82, 1808, 'Bar-sur-Loup', 10000, 1),
(3856, 82, 1793, 'Bayonne', 10000, 1),
(3857, 82, 1801, 'Belfort', 10000, 1),
(3858, 82, 1793, 'Biarritz', 10000, 1),
(3859, 82, 1794, 'Billom', 10000, 1),
(3860, 82, 1793, 'Bordeaux', 10000, 1),
(3861, 82, 1803, 'Boulogne-Billancourt', 10000, 1),
(3862, 82, 1797, 'Brest', 10000, 1),
(3863, 82, 1796, 'Bruyeres', 10000, 1),
(3864, 82, 1795, 'Caen', 10000, 1),
(3865, 82, 1808, 'Calais', 10000, 1),
(3866, 82, 1808, 'Cambrai', 10000, 1),
(3867, 82, 1812, 'Cannes', 10000, 1),
(3868, 82, 1812, 'Cavaliere Sur Mer', 10000, 1),
(3869, 82, 1803, 'Cergy-Pontoise', 10000, 1),
(3870, 82, 1796, 'Chambolle-Musigny', 10000, 1),
(3871, 82, 1808, 'Chamonix', 10000, 1),
(3872, 82, 1794, 'Chavaniac', 10000, 1),
(3873, 82, 1794, 'Clermont-Ferrand', 10000, 1),
(3874, 82, 1809, 'Coex', 10000, 1),
(3875, 82, 1805, 'Cognac', 10000, 1),
(3876, 82, 1814, 'Colmar', 10000, 1),
(3877, 82, 1810, 'Compiegne', 10000, 1),
(3878, 82, 1813, 'Courchevel', 10000, 1),
(3879, 82, 1795, 'Deauville', 10000, 1),
(3880, 82, 1796, 'Dijon', 10000, 1),
(3881, 82, 1808, 'Douai', 10000, 1),
(3883, 82, 1814, 'Eguisheim', 10000, 1),
(3884, 82, 1796, 'Entrains-Sur-Nohain', 10000, 1),
(3885, 82, 1808, 'Fourmies', 10000, 1),
(3886, 82, 1812, 'Frejus', 10000, 1),
(3887, 82, 1814, 'Geispolsheim', 10000, 1),
(3888, 82, 1813, 'Grenoble', 10000, 1),
(3889, 82, 1814, 'Henin-Beaumont', 10000, 1),
(3890, 82, 1812, 'La Garde-Freinet', 10000, 1),
(3891, 82, 1811, 'La Rochelle', 10000, 1),
(3892, 82, 1793, 'La Teste', 10000, 1),
(3893, 82, 1794, 'La Vergne', 10000, 1),
(3894, 82, 1813, 'La Verpilliere', 10000, 1),
(3895, 82, 1794, 'Langeac', 10000, 1),
(3896, 82, 1812, 'Le Cannet', 10000, 1),
(3897, 82, 1802, 'Le Havre', 10000, 1),
(3898, 82, 1810, 'Le Toquet', 10000, 1),
(3899, 82, 1803, 'Le Vesinet', 10000, 1),
(3900, 82, 1803, 'Le Bourget', 10000, 1),
(3901, 82, 1805, 'Limoges', 10000, 1),
(3902, 82, 1796, 'Longvic', 10000, 1),
(3903, 82, 1798, 'Luray', 10000, 1),
(3905, 82, 1796, 'Macon', 10000, 1),
(3906, 82, 1808, 'Marcq-En-Baroeul', 10000, 1),
(3907, 82, 1806, 'Metz', 10000, 1),
(3908, 82, 1793, 'Mimizan', 10000, 1),
(3909, 82, 1801, 'Montbeliard', 10000, 1),
(3910, 82, 1812, 'Montelimar', 10000, 1),
(3911, 82, 1803, 'Montgeron', 10000, 1),
(3912, 82, 1804, 'Montpellier', 10000, 1),
(3913, 82, 1806, 'Nancy', 10000, 1),
(3914, 82, 1809, 'Nantes', 10000, 1),
(3915, 82, 1803, 'Neuilly-Plaisance', 10000, 1),
(3916, 82, 1812, 'Nice', 10000, 1),
(3918, 82, 1812, 'Orange', 10000, 1),
(3919, 82, 1798, 'Orleans', 10000, 1),
(3920, 82, 1793, 'Pau', 10000, 1),
(3921, 82, 1795, 'Peronne', 10000, 1),
(3922, 82, 1804, 'Perpignan', 10000, 1),
(3923, 82, 1797, 'Pontivy', 10000, 1),
(3924, 82, 1797, 'Rennes', 10000, 1),
(3925, 82, 1806, 'Rombas', 10000, 1),
(3926, 82, 1798, 'Romorantin', 10000, 1),
(3927, 82, 1806, 'Saint Avold', 10000, 1),
(3928, 82, 1813, 'Saint Etienne', 10000, 1),
(3929, 82, 1803, 'Saint Mande', 10000, 1),
(3930, 82, 1807, 'Saint-Clar', 10000, 1),
(3932, 82, 1798, 'Senonches', 10000, 1),
(3933, 82, 1803, 'Saint Cloud', 10000, 1),
(3934, 82, 1798, 'Saint Cyr Sur Loire', 10000, 1),
(3935, 82, 1798, 'Saint-Germain-en-Laye', 10000, 1),
(3936, 82, 1814, 'Strasbourg', 10000, 1),
(3937, 82, 1811, 'Toulon', 10000, 1),
(3938, 82, 1807, 'Toulouse', 10000, 1),
(3939, 82, 1798, 'Tours', 10000, 1),
(3940, 82, 1811, 'Vendome', 10000, 1),
(3941, 82, 1796, 'Vichy', 10000, 1),
(3942, 82, 1803, 'Vincennes', 10000, 1),
(3943, 82, 1811, 'Vitre', 10000, 1),
(3944, 90, 1833, 'Bat''umi', 10000, 1),
(3945, 90, 5327, 'Mtskheta', 10000, 1),
(3946, 90, 5329, 'P''ot''I', 10000, 1),
(3947, 90, 1879, 'Tbilisi', 10000, 1),
(3948, 90, 5324, 'T''elavi', 10000, 1),
(3949, 92, 1893, 'Accra', 10000, 1),
(3950, 92, 1901, 'Bolgatanga', 10000, 1),
(3951, 92, 1896, 'Cape Coast', 10000, 1),
(3952, 92, 1901, 'Ga District', 10000, 1),
(3953, 92, 1894, 'Kumasi', 10000, 1),
(3954, 92, 1897, 'Oyoko', 10000, 1),
(3956, 92, 1898, 'Tamale', 10000, 1),
(3957, 92, 1893, 'Tema', 10000, 1),
(3958, 88, 1815, 'Banjul', 10000, 1),
(3959, 88, 1819, 'Kanifing', 10000, 1),
(3960, 102, 2004, 'Conakry', 10000, 1),
(3961, 98, 635, 'Lamentin', 10000, 1),
(3963, 95, 1962, 'Athens', 10000, 1),
(3964, 95, 1964, 'Corinth', 10000, 1),
(3965, 95, 1940, 'Kalamaria', 10000, 1),
(3966, 95, 1938, 'Kozani', 10000, 1),
(3967, 95, 1951, 'Lamia', 10000, 1),
(3969, 95, 1963, 'Navplion', 10000, 1),
(3970, 95, 1965, 'Patras', 10000, 1),
(3971, 95, 1962, 'Piraeus', 10000, 1),
(3972, 95, 1940, 'Thessaloniki', 10000, 1),
(3973, 95, 1949, 'Trikala', 10000, 1),
(3974, 95, 1933, 'Tripolis', 10000, 1),
(3975, 95, 1955, 'Zakinthos', 10000, 1),
(3976, 100, 1991, 'Antigua', 10000, 1),
(3977, 100, 1992, 'Chichicastenango', 10000, 1),
(3978, 100, 2000, 'Coban', 10000, 1),
(3979, 100, 1996, 'Cuilapa', 10000, 1),
(3980, 100, 1984, 'Escuintla', 10000, 1),
(3982, 100, 1988, 'Jalapa', 10000, 1),
(3983, 100, 1989, 'Jutiapa', 10000, 1),
(3984, 100, 1987, 'PUERTO BARRIOS', 10000, 1),
(3985, 100, 1991, 'Quezaltenango', 10000, 1),
(3986, 100, 1985, 'SAN JUAN SACATEPEQUEZ', 10000, 1),
(3987, 100, 1992, 'SANTA CRUZ DEL QUICHE', 10000, 1),
(3989, 100, 1997, 'SOLOLA', 10000, 1),
(3990, 100, 2000, 'ZACAPA', 10000, 1),
(3991, 104, 2032, 'Georgetown', 10000, 1),
(3992, 108, 2063, 'Juticalpa', 10000, 1),
(3993, 108, 2056, 'TEGUCIGALPA', 10000, 1),
(3994, 61, 5039, 'Karlovac', 10000, 1),
(3995, 61, 5039, 'Komiza', 10000, 1),
(3996, 61, 5039, 'Split', 10000, 1),
(3997, 61, 5045, 'Zagreb', 10000, 1),
(3998, 105, 2048, 'Jacmel', 10000, 1),
(3999, 105, 2046, 'PETIT GOAVE', 10000, 1),
(4000, 105, 2046, 'PORT-AU-PRINCE', 10000, 1),
(4001, 111, 2071, 'Budapest', 10000, 1),
(4002, 111, 2076, 'Debrecen', 10000, 1),
(4003, 111, 2086, 'Jaszbereny', 10000, 1),
(4004, 111, 2068, 'Pecs', 10000, 1),
(4005, 111, 2083, 'Siofok', 10000, 1),
(4006, 111, 2072, 'Szeged', 10000, 1),
(4007, 111, 2074, 'Szekesfehervar', 10000, 1),
(4008, 111, 2086, 'Szolnok', 10000, 1),
(4009, 114, 2147, 'Bandung', 10000, 1),
(4010, 114, 2145, 'Jakarta', 10000, 1),
(4011, 114, 2149, 'Surabaya', 10000, 1),
(4013, 117, 1599, 'Cork', 10000, 1),
(4015, 117, 1601, 'Dublin', 10000, 1),
(4016, 117, 1598, 'Ennis', 10000, 1),
(4017, 117, 1600, 'Enniscorthy', 10000, 1),
(4018, 117, 1602, 'Galway', 10000, 1),
(4019, 117, 1603, 'Killarney', 10000, 1),
(4020, 117, 1608, 'Limerick', 10000, 1),
(4021, 117, 1603, 'Listowel', 10000, 1),
(4022, 117, 1599, 'Longford', 10000, 1),
(4023, 117, 1620, 'New Ross', 10000, 1),
(4025, 117, 1616, 'Sligo', 10000, 1),
(4026, 117, 1603, 'Tralee', 10000, 1),
(4027, 117, 1618, 'Waterford', 10000, 1),
(4028, 118, 2234, 'Afula', 10000, 1),
(4029, 118, 2234, 'Akko', 10000, 1),
(4034, 118, 2235, 'Bethshemesh', 10000, 1),
(4035, 118, 2232, 'Eilat', 10000, 1),
(4036, 118, 2236, 'Givatayim', 10000, 1),
(4037, 118, 2235, 'Haifa', 10000, 1),
(4038, 118, 2235, 'Hatzor', 10000, 1),
(4039, 118, 2236, 'Herzliyya', 10000, 1),
(4041, 118, 2234, 'Karmi''el', 10000, 1),
(4044, 118, 2236, 'Kiryat Ekron', 10000, 1),
(4045, 118, 2235, 'Kiryat Motzkin', 10000, 1),
(4046, 118, 2233, 'Petah Tiqva', 10000, 1),
(4047, 118, 2233, 'Raanana', 10000, 1),
(4048, 118, 2236, 'Ramat Gan', 10000, 1),
(4049, 118, 2236, 'Ramat Hasharon', 10000, 1),
(4050, 118, 2233, 'Rehovot', 10000, 1),
(4051, 118, 2236, 'Rishon Le Zion', 10000, 1),
(4052, 118, 2234, 'Safed', 10000, 1),
(4054, 118, 2235, 'Tiberias', 10000, 1),
(4055, 118, 2237, 'Yavne', 10000, 1),
(4056, 118, 2233, 'Yehud', 10000, 1),
(4057, 118, 2232, 'Yeroham', 10000, 1),
(4058, 113, 2185, 'Bangalore', 10000, 1),
(4060, 113, 2190, 'Jaipur', 10000, 1),
(4062, 113, 2182, 'Pune', 10000, 1),
(4063, 113, 2191, 'Salem', 10000, 1),
(4064, 113, 2177, 'Simla', 10000, 1),
(4065, 113, 2169, 'Vijayawada', 10000, 1),
(4066, 115, 2223, 'Tehran', 10000, 1),
(4068, 112, 2129, 'Reykjav', 10000, 1),
(4069, 119, 2252, 'Agrigento', 10000, 1),
(4070, 119, 2249, 'Alba', 10000, 1),
(4071, 119, 2241, 'Amalfi', 10000, 1),
(4072, 119, 2255, 'Assisi', 10000, 1),
(4074, 119, 2249, 'Asti', 10000, 1),
(4075, 119, 2246, 'Bergamo', 10000, 1),
(4076, 119, 2242, 'Bologna', 10000, 1),
(4077, 119, 2252, 'Caltanissetta', 10000, 1),
(4078, 119, 2246, 'Cantu', 10000, 1),
(4079, 119, 2250, 'Capurso', 10000, 1),
(4081, 119, 2244, 'Cisterna', 10000, 1),
(4082, 119, 2240, 'Cosenza', 10000, 1),
(4083, 119, 2246, 'Cremona', 10000, 1),
(4085, 119, 2242, 'Ferrara', 10000, 1),
(4086, 119, 2253, 'Fiesole', 10000, 1),
(4088, 119, 2253, 'Florence', 10000, 1),
(4089, 119, 2252, 'Floridia', 10000, 1),
(4090, 119, 2241, 'Gaeta', 10000, 1),
(4091, 119, 2245, 'Genoa', 10000, 1),
(4092, 119, 2253, 'Greve', 10000, 1),
(4094, 119, 2245, 'Imperia', 10000, 1),
(4095, 119, 2249, 'Ivrea', 10000, 1),
(4096, 119, 2245, 'La Spezia', 10000, 1),
(4097, 119, 2246, 'Lodi', 10000, 1),
(4098, 119, 2246, 'Lonate Pozzolo', 10000, 1),
(4099, 119, 2253, 'Lucca', 10000, 1),
(4100, 119, 2244, 'Marino', 10000, 1),
(4102, 119, 2252, 'Milazzo', 10000, 1),
(4103, 119, 2242, 'Modena', 10000, 1),
(4105, 119, 2246, 'Monza', 10000, 1),
(4106, 119, 2242, 'Noceto', 10000, 1),
(4107, 119, 2251, 'Oristano', 10000, 1),
(4109, 119, 2240, 'Paterno', 10000, 1),
(4110, 119, 2257, 'Pedavena', 10000, 1),
(4111, 119, 2255, 'Perugia', 10000, 1),
(4112, 119, 2238, 'Pescara', 10000, 1),
(4114, 119, 2249, 'Pinerolo', 10000, 1),
(4115, 119, 2253, 'Pisa', 10000, 1),
(4116, 119, 2239, 'Potenza', 10000, 1),
(4117, 119, 2250, 'Putignano', 10000, 1),
(4118, 119, 2242, 'Reggio Emilia', 10000, 1),
(4119, 119, 2252, 'Ribera', 10000, 1),
(4120, 119, 2242, 'Rimini', 10000, 1),
(4121, 119, 2244, 'Rome', 10000, 1),
(4122, 119, 2247, 'San Benedetto Del Tronto', 10000, 1),
(4123, 119, 2245, 'Sestri Levante', 10000, 1),
(4124, 119, 2241, 'Sorrento', 10000, 1),
(4125, 119, 2255, 'Spoleto', 10000, 1),
(4126, 119, 2252, 'Terrasini', 10000, 1),
(4127, 119, 2249, 'Torre Pellice', 10000, 1),
(4128, 119, 2244, 'Viterbo', 10000, 1),
(4130, 120, 2381, 'Montego Bay', 10000, 1),
(4131, 120, 2383, 'Morant Bay', 10000, 1),
(4132, 120, 2378, 'Ocho Rios', 10000, 1),
(4134, 126, 2391, 'Amman', 10000, 1),
(4135, 126, 2387, 'Madaba', 10000, 1),
(4136, 122, 2338, 'Akashi', 10000, 1),
(4137, 122, 2326, 'Anjo', 10000, 1),
(4138, 122, 2358, 'Arita', 10000, 1),
(4140, 122, 2337, 'Asahikawa', 10000, 1),
(4141, 122, 2363, 'Ashikaga', 10000, 1),
(4142, 122, 2338, 'Ashiya', 10000, 1),
(4143, 122, 2335, 'Aso', 10000, 1),
(4144, 122, 2344, 'Atsugi', 10000, 1),
(4146, 122, 2328, 'Beppu', 10000, 1),
(4147, 122, 2329, 'Chiba', 10000, 1),
(4148, 122, 2359, 'Chichibu', 10000, 1),
(4149, 122, 2351, 'Chino', 10000, 1),
(4150, 122, 2337, 'Chitose', 10000, 1),
(4151, 122, 2329, 'Choshi', 10000, 1),
(4153, 122, 2337, 'Ebetsu', 10000, 1),
(4154, 122, 2362, 'Fuji', 10000, 1),
(4155, 122, 2362, 'Fujinomiya', 10000, 1),
(4156, 122, 2344, 'Fujisawa', 10000, 1),
(4157, 122, 2339, 'Fujishiro', 10000, 1),
(4161, 122, 2331, 'Fukui', 10000, 1),
(4162, 122, 2332, 'Fukuoka', 10000, 1),
(4163, 122, 2329, 'Futtsu', 10000, 1),
(4164, 122, 2334, 'Gifu', 10000, 1),
(4165, 122, 2362, 'Gotemba', 10000, 1),
(4167, 122, 2344, 'Hadano', 10000, 1),
(4168, 122, 2341, 'Hanamaki', 10000, 1),
(4169, 122, 2326, 'Handa', 10000, 1),
(4170, 122, 2359, 'Hanno', 10000, 1),
(4171, 122, 2368, 'Hashimoto', 10000, 1),
(4172, 122, 2326, 'Hekinan', 10000, 1),
(4173, 122, 2365, 'Higashimurayama', 10000, 1),
(4174, 122, 2357, 'Higashiosaka', 10000, 1),
(4175, 122, 2360, 'Hikone', 10000, 1),
(4176, 122, 2338, 'Himeji', 10000, 1),
(4177, 122, 2365, 'Hino', 10000, 1),
(4178, 122, 2372, 'Hirara', 10000, 1),
(4179, 122, 2344, 'Hiratsuka', 10000, 1),
(4180, 122, 2336, 'Hiroshima', 10000, 1),
(4182, 122, 2339, 'Hitachi', 10000, 1),
(4184, 122, 2346, 'Hondo', 10000, 1),
(4187, 122, 2329, 'Ichihara', 10000, 1),
(4188, 122, 2329, 'Ichikawa', 10000, 1),
(4189, 122, 2371, 'Ichikawadaimon', 10000, 1),
(4190, 122, 2329, 'Ikata', 10000, 1),
(4191, 122, 2362, 'Ikawa', 10000, 1),
(4192, 122, 2330, 'Imabari', 10000, 1),
(4193, 122, 2361, 'Imaichi', 10000, 1),
(4194, 122, 2336, 'Imazu', 10000, 1),
(4195, 122, 2352, 'Isahaya', 10000, 1),
(4197, 122, 2335, 'Isesaki', 10000, 1),
(4198, 122, 2328, 'Itayanagi', 10000, 1),
(4199, 122, 2348, 'Iwai', 10000, 1),
(4200, 122, 2333, 'Iwaki', 10000, 1),
(4201, 122, 2336, 'Iwakuni', 10000, 1),
(4202, 122, 2337, 'Iwamizawa', 10000, 1),
(4203, 122, 2349, 'Iwanuma', 10000, 1),
(4204, 122, 2362, 'Iwata', 10000, 1),
(4205, 122, 2368, 'Izumo', 10000, 1),
(4206, 122, 2343, 'Kagoshima', 10000, 1),
(4207, 122, 2338, 'Kaibara', 10000, 1),
(4208, 122, 2357, 'Kaizuka', 10000, 1),
(4209, 122, 2362, 'Kakegawa', 10000, 1),
(4212, 122, 2347, 'Kameoka', 10000, 1),
(4214, 122, 2334, 'Kanayama', 10000, 1),
(4215, 122, 2340, 'Kanazawa', 10000, 1),
(4218, 122, 2329, 'Kashiwa', 10000, 1),
(4219, 122, 2326, 'Kasugai', 10000, 1),
(4220, 122, 2359, 'Kawagoe', 10000, 1),
(4221, 122, 2338, 'Kawanishi', 10000, 1),
(4222, 122, 2344, 'Kawasaki', 10000, 1),
(4223, 122, 2365, 'Kijima', 10000, 1),
(4224, 122, 2335, 'Kiryu', 10000, 1),
(4225, 122, 2329, 'Kisarazu', 10000, 1),
(4226, 122, 2349, 'Kishiwada', 10000, 1),
(4227, 122, 2336, 'Kitakami', 10000, 1),
(4228, 122, 2332, 'Kitakyushu', 10000, 1),
(4229, 122, 2337, 'Kitami', 10000, 1),
(4230, 122, 2338, 'Kobe', 10000, 1),
(4231, 122, 2345, 'Kochi', 10000, 1),
(4232, 122, 2371, 'Kofu', 10000, 1),
(4234, 122, 2326, 'Komaki', 10000, 1),
(4236, 122, 2343, 'Kuji', 10000, 1),
(4237, 122, 2346, 'Kumamoto', 10000, 1),
(4238, 122, 2356, 'Kurashiki', 10000, 1),
(4239, 122, 2327, 'Kure', 10000, 1),
(4241, 122, 2328, 'Kuroishi', 10000, 1),
(4242, 122, 2332, 'Kurume', 10000, 1),
(4243, 122, 2360, 'Kusatsu', 10000, 1),
(4244, 122, 2343, 'Kushikino', 10000, 1),
(4245, 122, 2368, 'Kushimoto', 10000, 1),
(4246, 122, 2347, 'Kyoto', 10000, 1),
(4247, 122, 2360, 'Makino', 10000, 1),
(4248, 122, 2351, 'Matsumoto', 10000, 1),
(4249, 122, 2329, 'Matsuto Shi', 10000, 1),
(4250, 122, 2330, 'Matsuyama', 10000, 1),
(4251, 122, 2337, 'Memuro', 10000, 1),
(4254, 122, 2340, 'Mikawa', 10000, 1),
(4255, 122, 2338, 'Miki', 10000, 1),
(4256, 122, 2362, 'Mikkabi', 10000, 1),
(4258, 122, 2356, 'Minori', 10000, 1),
(4259, 122, 2328, 'Misawa', 10000, 1),
(4260, 122, 2345, 'Mishima', 10000, 1),
(4261, 122, 2339, 'Mito', 10000, 1),
(4262, 122, 2350, 'Miyazaki', 10000, 1),
(4263, 122, 2347, 'Miyazu', 10000, 1),
(4264, 122, 2337, 'Mombetsu', 10000, 1),
(4266, 122, 2330, 'Moriyama', 10000, 1),
(4267, 122, 2364, 'Motoyama', 10000, 1),
(4268, 122, 2347, 'Muko', 10000, 1),
(4269, 122, 2351, 'Mure', 10000, 1),
(4271, 122, 2355, 'Nagano', 10000, 1),
(4272, 122, 2335, 'Naganohara', 10000, 1),
(4273, 122, 2354, 'Nagaoka', 10000, 1),
(4275, 122, 2352, 'Nagasaki', 10000, 1),
(4276, 122, 2372, 'Nago', 10000, 1),
(4277, 122, 2326, 'Nagoya', 10000, 1),
(4278, 122, 2372, 'Naha', 10000, 1),
(4281, 122, 2329, 'Narashino', 10000, 1),
(4282, 122, 2365, 'Narita', 10000, 1),
(4283, 122, 2337, 'Nemuro', 10000, 1),
(4286, 122, 2354, 'Niigata', 10000, 1),
(4288, 122, 2371, 'Nirasaki', 10000, 1),
(4289, 122, 2338, 'Nishinomiya', 10000, 1),
(4290, 122, 2338, 'Nishiwaki', 10000, 1),
(4291, 122, 2350, 'Nobeoka', 10000, 1),
(4292, 122, 2327, 'Noshiro', 10000, 1),
(4293, 122, 2362, 'Numazu', 10000, 1),
(4294, 122, 2367, 'Nyuzen', 10000, 1),
(4295, 122, 2337, 'Obihiro', 10000, 1),
(4296, 122, 2344, 'Odawara', 10000, 1),
(4297, 122, 2360, 'Ohara', 10000, 1),
(4298, 122, 2362, 'Ohito', 10000, 1),
(4299, 122, 2344, 'Oiso', 10000, 1),
(4301, 122, 2351, 'Okaya', 10000, 1),
(4302, 122, 2356, 'Okayama', 10000, 1),
(4303, 122, 2326, 'Okazaki', 10000, 1),
(4305, 122, 2332, 'Omuta', 10000, 1),
(4306, 122, 2355, 'Ono', 10000, 1),
(4307, 122, 2357, 'Osaka', 10000, 1),
(4311, 122, 2365, 'Ota', 10000, 1),
(4312, 122, 2360, 'Otsu', 10000, 1),
(4314, 122, 2371, 'Ryuo', 10000, 1),
(4316, 122, 2359, 'Sakado', 10000, 1),
(4317, 122, 2337, 'Sakai', 10000, 1),
(4318, 122, 2338, 'Sanda', 10000, 1),
(4319, 122, 2337, 'Sapporo', 10000, 1),
(4320, 122, 2337, 'Saroma', 10000, 1),
(4321, 122, 2338, 'Sasayama', 10000, 1),
(4322, 122, 2352, 'Sasebo', 10000, 1),
(4323, 122, 2338, 'Sawara', 10000, 1),
(4324, 122, 2365, 'Sayama', 10000, 1),
(4325, 122, 2349, 'Sendai', 10000, 1),
(4328, 122, 2362, 'Shimada', 10000, 1),
(4330, 122, 2362, 'Shimizu', 10000, 1),
(4331, 122, 2362, 'Shimoda', 10000, 1),
(4332, 122, 2337, 'Shimukappu', 10000, 1),
(4334, 122, 2332, 'Shingu', 10000, 1),
(4335, 122, 2351, 'Shiojiri', 10000, 1),
(4336, 122, 2337, 'Shizunai', 10000, 1),
(4337, 122, 2362, 'Shizuoka', 10000, 1),
(4338, 122, 2359, 'Shobu', 10000, 1),
(4339, 122, 2359, 'Soka', 10000, 1),
(4340, 122, 2351, 'Suwa', 10000, 1),
(4341, 122, 2365, 'Tachikawa', 10000, 1),
(4342, 122, 2370, 'Tahara', 10000, 1),
(4343, 122, 2334, 'Tajimi', 10000, 1),
(4344, 122, 2339, 'Takahagi', 10000, 1),
(4345, 122, 2357, 'Takaishi', 10000, 1),
(4346, 122, 2342, 'Takamatsu', 10000, 1),
(4347, 122, 2367, 'Takaoka', 10000, 1),
(4348, 122, 2338, 'Takarazuka', 10000, 1),
(4349, 122, 2335, 'Takasaki', 10000, 1),
(4350, 122, 2330, 'Takayama', 10000, 1),
(4352, 122, 2338, 'Takino', 10000, 1),
(4354, 122, 2329, 'Tamana', 10000, 1),
(4356, 122, 2329, 'Tateyama', 10000, 1),
(4357, 122, 2338, 'Tatsuno', 10000, 1),
(4358, 122, 2337, 'Teshio', 10000, 1),
(4359, 122, 2366, 'Toba', 10000, 1),
(4360, 122, 2372, 'Tobaru', 10000, 1),
(4362, 122, 2359, 'Tokorozawa', 10000, 1),
(4363, 122, 2364, 'Tokushima', 10000, 1),
(4364, 122, 2365, 'Tokyo', 10000, 1),
(4365, 122, 2357, 'Tondabayashi', 10000, 1),
(4367, 122, 2367, 'Toyama', 10000, 1),
(4368, 122, 2326, 'Toyokawa', 10000, 1),
(4370, 122, 2357, 'Toyonaka', 10000, 1),
(4371, 122, 2359, 'Toyota', 10000, 1),
(4373, 122, 2353, 'Tsuru', 10000, 1),
(4374, 122, 2369, 'Tsuruoka', 10000, 1),
(4375, 122, 2343, 'Tsuruta', 10000, 1),
(4376, 122, 2364, 'Tsushima', 10000, 1),
(4377, 122, 2356, 'Tsuyama', 10000, 1),
(4378, 122, 2359, 'Urawa', 10000, 1),
(4379, 122, 2329, 'Urayasu', 10000, 1),
(4380, 122, 2363, 'Utsunomiya', 10000, 1),
(4381, 122, 2331, 'Wakayama', 10000, 1),
(4382, 122, 2359, 'Warabi', 10000, 1),
(4384, 122, 2371, 'Yamanouchi', 10000, 1),
(4385, 122, 2354, 'Yamauchi', 10000, 1),
(4386, 122, 2370, 'Yao', 10000, 1),
(4387, 122, 2338, 'Yashiro', 10000, 1),
(4388, 122, 2339, 'Yatabe', 10000, 1),
(4389, 122, 2356, 'Yokaichi', 10000, 1),
(4390, 122, 2355, 'Yokkaichi', 10000, 1),
(4391, 122, 2344, 'Yokohama', 10000, 1),
(4392, 122, 2344, 'Yokosuka', 10000, 1),
(4393, 122, 2369, 'Yonezawa', 10000, 1),
(4394, 122, 2329, 'Yotsukaido', 10000, 1),
(4397, 129, 2401, 'Eldoret', 10000, 1),
(4399, 129, 2402, 'Kakamega', 10000, 1),
(4400, 129, 2400, 'Kisumu', 10000, 1),
(4401, 129, 2397, 'Meru', 10000, 1),
(4402, 129, 2396, 'Mombasa', 10000, 1),
(4403, 129, 2398, 'Nairobi', 10000, 1),
(4404, 129, 2397, 'Nakuru', 10000, 1),
(4405, 129, 2395, 'Nyeri', 10000, 1),
(4406, 135, 2403, 'Bishkek', 10000, 1),
(4407, 135, 2409, 'Karakol', 10000, 1),
(4408, 128, 2445, 'Almaty', 10000, 1),
(4409, 128, 2459, 'Kokshetau', 10000, 1),
(4410, 128, 2460, 'Zhambyl', 10000, 1),
(4411, 228, 1306, 'Nuwara Eliya', 10000, 1),
(4412, 140, 2583, 'Clay-Ashland', 10000, 1),
(4413, 140, 2574, 'Gbarnga', 10000, 1),
(4414, 140, 2583, 'Monrovia', 10000, 1),
(4415, 139, 2617, 'Maseru', 10000, 1),
(4416, 143, 2531, 'Kaunas', 10000, 1),
(4417, 143, 2535, 'Klaipeda', 10000, 1),
(4418, 144, 2623, 'Diekirch', 10000, 1),
(4419, 144, 2625, 'Esch-Sur-Alzette', 10000, 1),
(4420, 144, 2623, 'Ettelbruck', 10000, 1),
(4421, 137, 2501, 'Liepaja', 10000, 1),
(4422, 137, 2510, 'RIGA', 10000, 1),
(4423, 168, 2813, 'Agadir', 10000, 1),
(4424, 168, 2787, 'Casablanca', 10000, 1),
(4425, 163, 2696, 'Chisinau', 10000, 1),
(4426, 151, 2770, 'Bamako', 10000, 1),
(4427, 151, 2773, 'Gao', 10000, 1),
(4428, 151, 2770, 'Tombouctou', 10000, 1),
(4429, 148, 2768, 'Blantyre', 10000, 1),
(4430, 148, 2755, 'Lilongwe', 10000, 1),
(4431, 159, 71, 'Acambaro', 10000, 1),
(4432, 159, 56, 'Agua Prieta', 10000, 1),
(4433, 159, 2885, 'Aguascalientes', 10000, 1),
(4434, 159, 59, 'Ajijic', 10000, 1),
(4435, 159, 203, 'Alamos', 10000, 1),
(4436, 159, 2887, 'Arizpe', 10000, 1),
(4437, 159, 2889, 'Atotonilco', 10000, 1),
(4438, 159, 59, 'Autlan De Navarro', 10000, 1),
(4439, 159, 74, 'Cabo San Lucas', 10000, 1),
(4440, 159, 56, 'Caborca', 10000, 1),
(4441, 159, 56, 'Cananea', 10000, 1),
(4442, 159, 72, 'Cancun', 10000, 1),
(4444, 159, 71, 'Celaya', 10000, 1),
(4445, 159, 2890, 'Chapala', 10000, 1),
(4446, 159, 2892, 'Chignahuapan', 10000, 1),
(4447, 159, 66, 'Chilpancingo', 10000, 1),
(4448, 159, 196, 'Ciudad Juarez', 10000, 1),
(4449, 159, 198, 'Ciudad Lerdo', 10000, 1),
(4450, 159, 2896, 'Ciudad Obregon', 10000, 1),
(4451, 159, 2895, 'Cordoba', 10000, 1),
(4452, 159, 2894, 'Cosala', 10000, 1),
(4453, 159, 72, 'Coyoacan', 10000, 1),
(4455, 159, 56, 'Cumpas', 10000, 1),
(4456, 159, 62, 'Delicias', 10000, 1),
(4457, 159, 2896, 'Dzidzantun', 10000, 1),
(4458, 159, 201, 'El Rosario', 10000, 1),
(4459, 159, 56, 'Empalme', 10000, 1),
(4460, 159, 73, 'Ensenada', 10000, 1),
(4461, 159, 69, 'Gomez Palacio', 10000, 1),
(4462, 159, 66, 'Guamuchil', 10000, 1),
(4463, 159, 71, 'Guanajuato', 10000, 1),
(4464, 159, 56, 'Guaymas', 10000, 1),
(4465, 159, 70, 'Hidalgo', 10000, 1),
(4466, 159, 2886, 'Huatabampo', 10000, 1),
(4467, 159, 71, 'Irapuato', 10000, 1),
(4468, 159, 2890, 'Jacona', 10000, 1),
(4469, 159, 59, 'La Barca', 10000, 1),
(4470, 159, 59, 'Lagos De Moreno', 10000, 1),
(4471, 159, 2891, 'Lazaro Cardenas', 10000, 1),
(4472, 159, 59, 'Loreto', 10000, 1),
(4473, 159, 2894, 'Los Mochis', 10000, 1),
(4475, 159, 73, 'Maneadero', 10000, 1),
(4476, 159, 197, 'Manzanillo', 10000, 1),
(4477, 159, 2894, 'Mazatlan', 10000, 1),
(4479, 159, 73, 'Mulege', 10000, 1),
(4481, 159, 56, 'Nacozari De Garcia', 10000, 1),
(4482, 159, 2889, 'Naucalpan', 10000, 1),
(4483, 159, 56, 'Navojoa', 10000, 1),
(4484, 159, 59, 'Ocotlan', 10000, 1),
(4485, 159, 2895, 'Orizaba', 10000, 1),
(4486, 159, 196, 'Parral', 10000, 1),
(4487, 159, 204, 'Piedras Negras', 10000, 1),
(4488, 159, 59, 'Poncitlan', 10000, 1),
(4489, 159, 2892, 'Puebla', 10000, 1),
(4490, 159, 56, 'Puerto Penasco', 10000, 1),
(4491, 159, 59, 'Puerto Vallarta', 10000, 1),
(4492, 159, 198, 'Rosario', 10000, 1),
(4493, 159, 56, 'Sahuaripa', 10000, 1),
(4494, 159, 71, 'Salamanca', 10000, 1),
(4495, 159, 62, 'Salvatierra', 10000, 1),
(4496, 159, 62, 'San Cristobal De Las Casas', 10000, 1),
(4497, 159, 201, 'San Felipe', 10000, 1),
(4498, 159, 74, 'San Jose Del Cabo', 10000, 1),
(4499, 159, 201, 'San Juan Del Rio', 10000, 1),
(4500, 159, 56, 'San Luis Rio Colorado', 10000, 1),
(4501, 159, 71, 'San Miguel De Allende', 10000, 1),
(4503, 159, 196, 'Santa Rosalia', 10000, 1),
(4504, 159, 2895, 'Sayula', 10000, 1),
(4505, 159, 66, 'Taxco', 10000, 1),
(4506, 159, 73, 'Tecate', 10000, 1),
(4507, 159, 2890, 'Tehuantepec', 10000, 1),
(4508, 159, 59, 'Tepatitlan', 10000, 1),
(4509, 159, 2889, 'Tijuana', 10000, 1),
(4510, 159, 66, 'Tixtla De Guerrero', 10000, 1),
(4512, 159, 59, 'Tlaquepaque', 10000, 1),
(4513, 159, 74, 'Todos Santos', 10000, 1),
(4514, 159, 2889, 'Toluca', 10000, 1),
(4515, 159, 2887, 'Torreon', 10000, 1),
(4516, 159, 60, 'Tula', 10000, 1),
(4517, 159, 60, 'Tulancingo', 10000, 1),
(4518, 159, 56, 'Ures', 10000, 1),
(4519, 159, 2890, 'Uruapan', 10000, 1),
(4520, 159, 2889, 'Valle De Bravo', 10000, 1),
(4522, 159, 2887, 'Valles', 10000, 1),
(4523, 159, 2895, 'Veracruz', 10000, 1),
(4524, 159, 2895, 'Xalapa', 10000, 1),
(4526, 159, 59, 'Zapopan', 10000, 1),
(4528, 171, 4647, 'Otjiwarongo', 10000, 1),
(4529, 181, 2967, 'Benin City', 10000, 1),
(4530, 181, 2962, 'Ibadan', 10000, 1),
(4531, 181, 2972, 'Ile-Ife', 10000, 1),
(4532, 181, 2953, 'Kaduna', 10000, 1),
(4533, 181, 2941, 'Lagos', 10000, 1),
(4534, 181, 718, 'Owerri', 10000, 1),
(4535, 181, 2943, 'Port Harcourt', 10000, 1),
(4536, 179, 3064, 'Bluefields', 10000, 1),
(4537, 179, 3056, 'Corinto', 10000, 1),
(4538, 179, 3048, 'Diriamba', 10000, 1),
(4539, 179, 3051, 'Esteli', 10000, 1),
(4540, 179, 3052, 'Granada', 10000, 1),
(4541, 179, 3059, 'Jalapa', 10000, 1),
(4542, 179, 3053, 'Jinotega', 10000, 1),
(4543, 179, 3048, 'Jinotepe', 10000, 1),
(4544, 179, 3050, 'Juigalpa', 10000, 1),
(4545, 179, 3063, 'Laguna De Perlas', 10000, 1),
(4546, 179, 3054, 'Leon', 10000, 1),
(4547, 179, 3056, 'Managua', 10000, 1),
(4549, 179, 3057, 'Masaya', 10000, 1),
(4550, 179, 3059, 'Ocotal', 10000, 1),
(4551, 179, 3049, 'Posoltega', 10000, 1),
(4552, 179, 3063, 'Puerto Cabezas', 10000, 1),
(4553, 179, 3064, 'Rama', 10000, 1),
(4554, 179, 3061, 'Rivas', 10000, 1),
(4555, 179, 3061, 'San Isidro', 10000, 1),
(4556, 179, 3061, 'San Jorge', 10000, 1),
(4557, 179, 3061, 'San Marcos', 10000, 1),
(4558, 179, 3056, 'San Rafael', 10000, 1),
(4559, 179, 3055, 'Santo Domingo', 10000, 1),
(4560, 179, 3055, 'Somoto', 10000, 1),
(4563, 179, 3063, 'Waspan', 10000, 1),
(4564, 175, 2985, 'Delft', 10000, 1),
(4565, 175, 2977, 'Dieren', 10000, 1),
(4566, 175, 2982, 'Enschede', 10000, 1),
(4568, 175, 2984, 'Kapelle', 10000, 1),
(4570, 175, 2975, 'Meppel', 10000, 1),
(4571, 175, 2977, 'Nijmegen', 10000, 1),
(4573, 175, 2983, 'Rhenen', 10000, 1),
(4574, 175, 2985, 'Rotterdam', 10000, 1),
(4575, 175, 2983, 'Soest', 10000, 1),
(4577, 185, 2995, 'Bergen', 10000, 1),
(4578, 185, 2990, 'Fagernes', 10000, 1),
(4579, 185, 3007, 'Flekkefjord', 10000, 1),
(4580, 185, 2999, 'Gjovik', 10000, 1),
(4581, 185, 2994, 'Hamar', 10000, 1),
(4582, 185, 2993, 'Hammerfest', 10000, 1),
(4583, 185, 2992, 'Kongsberg', 10000, 1),
(4585, 185, 2997, 'Mo', 10000, 1),
(4586, 185, 3001, 'Moss', 10000, 1),
(4587, 185, 3002, 'Stavanger', 10000, 1),
(4588, 185, 3003, 'Sunndal', 10000, 1),
(4590, 185, 3004, 'Trondheim', 10000, 1),
(4591, 185, 2995, 'Voss', 10000, 1),
(4592, 174, 3009, 'Kathmandu', 10000, 1),
(4593, 178, 4723, 'Ashburton', 10000, 1),
(4594, 178, 4706, 'Auckland', 10000, 1),
(4596, 178, 4723, 'Christchurch', 10000, 1),
(4597, 178, 4744, 'Dunedin', 10000, 1),
(4599, 178, 4814, 'Gisborne', 10000, 1),
(4600, 178, 3137, 'Hamilton', 10000, 1),
(4601, 178, 4741, 'Kaikohe', 10000, 1),
(4602, 178, 4721, 'Lower Hutt', 10000, 1),
(4604, 178, 5019, 'Palmerston North', 10000, 1),
(4605, 178, 4744, 'Queenstown', 10000, 1),
(4606, 178, 4729, 'Rotorua', 10000, 1),
(4607, 178, 4729, 'Tauranga', 10000, 1),
(4608, 178, 4729, 'Te Puke', 10000, 1),
(4609, 178, 4723, 'Timaru', 10000, 1),
(4610, 178, 3137, 'Tokoroa', 10000, 1),
(4611, 178, 4721, 'Upper Hutt', 10000, 1),
(4612, 178, 3129, 'Waitara', 10000, 1),
(4614, 178, 5019, 'Wanganui', 10000, 1),
(4615, 178, 4741, 'Whangarei', 10000, 1),
(4616, 190, 3292, 'Anton', 10000, 1),
(4617, 190, 3293, 'Colon', 10000, 1),
(4618, 190, 3291, 'David', 10000, 1),
(4619, 190, 3297, 'Panama City', 10000, 1),
(4620, 194, 3191, 'Arequipa', 10000, 1),
(4621, 194, 3194, 'Callao', 10000, 1),
(4622, 194, 3189, 'Caras', 10000, 1),
(4623, 194, 3189, 'Chimbote', 10000, 1),
(4624, 194, 3195, 'Cuzco', 10000, 1),
(4625, 194, 3202, 'Lima', 10000, 1),
(4626, 194, 3202, 'Miraflores', 10000, 1),
(4627, 194, 3202, 'Pucallpa', 10000, 1),
(4628, 194, 3200, 'Trujillo', 10000, 1),
(4629, 191, 3333, 'Lae', 10000, 1),
(4630, 195, 3426, 'Bacarra', 10000, 1),
(4631, 195, 3533, 'Bacolod', 10000, 1),
(4632, 195, 3473, 'Baguio', 10000, 1),
(4633, 195, 3469, 'Cagayan', 10000, 1),
(4634, 195, 3460, 'Camiling', 10000, 1),
(4635, 195, 3418, 'Cavite City', 10000, 1),
(4636, 195, 3485, 'Cebu', 10000, 1),
(4637, 195, 3490, 'Davao', 10000, 1),
(4638, 195, 3496, 'Iloilo', 10000, 1),
(4640, 195, 3467, 'Kalibo', 10000, 1),
(4641, 195, 3461, 'Laoag', 10000, 1),
(4642, 195, 3403, 'Legaspi', 10000, 1),
(4643, 195, 3502, 'Lipa City', 10000, 1),
(4644, 195, 3505, 'Makati', 10000, 1),
(4645, 195, 3505, 'Manila', 10000, 1),
(4646, 195, 3505, 'Marikina', 10000, 1),
(4647, 195, 3508, 'Olongapo', 10000, 1),
(4648, 195, 3435, 'Palo', 10000, 1),
(4649, 195, 3447, 'Puerto Princesa', 10000, 1),
(4650, 195, 3505, 'Quezon City', 10000, 1),
(4651, 195, 3416, 'Roxas', 10000, 1),
(4652, 195, 3463, 'San Pablo', 10000, 1),
(4654, 187, 3219, 'Lahore', 10000, 1),
(4655, 187, 3218, 'Peshawar', 10000, 1),
(4657, 197, 3285, 'Bielsko-Biala', 10000, 1),
(4659, 197, 3285, 'Czestochowa', 10000, 1),
(4660, 197, 3284, 'Gdansk', 10000, 1),
(4661, 197, 3284, 'Gdynia', 10000, 1),
(4662, 197, 3278, 'Gorzow Wielkopolski', 10000, 1),
(4663, 197, 3288, 'Gulcz', 10000, 1),
(4664, 197, 3274, 'Jelenia Gora', 10000, 1),
(4665, 197, 3285, 'Katowice', 10000, 1),
(4667, 197, 3280, 'Lomianki', 10000, 1),
(4668, 197, 3283, 'Lomza', 10000, 1),
(4669, 197, 3280, 'Milanowek', 10000, 1),
(4670, 197, 3285, 'Olsztyn', 10000, 1),
(4671, 197, 3280, 'Plock', 10000, 1),
(4672, 197, 3288, 'Poznan', 10000, 1),
(4673, 197, 3280, 'Pultusk', 10000, 1),
(4674, 197, 3282, 'Rzeszow', 10000, 1),
(4675, 197, 3279, 'Slomniki', 10000, 1),
(4676, 197, 3289, 'Szczecin', 10000, 1),
(4677, 197, 3277, 'Torun', 10000, 1),
(4680, 197, 3274, 'Wroclaw', 10000, 1),
(4681, 197, 3285, 'Zawiercie', 10000, 1),
(4682, 197, 3276, 'Zielona Gora', 10000, 1),
(4683, 198, 3319, 'Angra Do Heroismo', 10000, 1),
(4684, 198, 3305, 'Coimbra', 10000, 1),
(4685, 198, 3307, 'Faro', 10000, 1),
(4686, 198, 3308, 'Funchal', 10000, 1),
(4688, 198, 3319, 'Horta', 10000, 1),
(4689, 198, 3307, 'Lagoa', 10000, 1),
(4690, 198, 3308, 'Machico', 10000, 1),
(4691, 198, 3318, 'Mangualde', 10000, 1),
(4692, 198, 3319, 'Ponta Delgada', 10000, 1),
(4694, 198, 3319, 'Ribeira Grande', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(4696, 198, 3305, 'Vila Do Porto', 10000, 1),
(4697, 198, 3319, 'Villa Franca Do Campo', 10000, 1),
(4698, 193, 3185, 'Asuncion', 10000, 1),
(4699, 193, 3185, 'Santa Maria', 10000, 1),
(4700, 202, 3366, 'Brasov', 10000, 1),
(4701, 202, 3367, 'Bucharest', 10000, 1),
(4702, 202, 3370, 'Cluj-Napoca', 10000, 1),
(4703, 202, 3389, 'Sibiu', 10000, 1),
(4704, 203, 3539, 'Archangelsk', 10000, 1),
(4705, 203, 3591, 'Azov', 10000, 1),
(4707, 203, 3537, 'Barnaul', 10000, 1),
(4708, 203, 3571, 'Borovichi', 10000, 1),
(4709, 203, 3606, 'Budennovsk', 10000, 1),
(4711, 203, 3612, 'Cherepovets', 10000, 1),
(4712, 203, 105, 'Derbent', 10000, 1),
(4713, 203, 3603, 'Dikson', 10000, 1),
(4714, 203, 3577, 'Dmitrov', 10000, 1),
(4715, 203, 3577, 'Dubna', 10000, 1),
(4716, 203, 3601, 'Ekaterinburg', 10000, 1),
(4717, 203, 3600, 'Georgievsk', 10000, 1),
(4718, 203, 3588, 'Ishim', 10000, 1),
(4719, 203, 3600, 'Kislovodsk', 10000, 1),
(4720, 203, 3577, 'Konakovo', 10000, 1),
(4721, 203, 3539, 'Kotlas', 10000, 1),
(4722, 203, 3569, 'Krasnodar', 10000, 1),
(4723, 203, 3569, 'Krasnogorsk', 10000, 1),
(4724, 203, 3582, 'Krestsy', 10000, 1),
(4726, 203, 3589, 'Vladivostok', 10000, 1),
(4727, 203, 3600, 'Lermontov', 10000, 1),
(4728, 203, 3578, 'Lomonosov', 10000, 1),
(4730, 203, 3589, 'Nakhodka', 10000, 1),
(4733, 203, 3600, 'Novopavlovsk', 10000, 1),
(4734, 203, 3570, 'Novorossiisk', 10000, 1),
(4735, 203, 3557, 'Obninsk', 10000, 1),
(4736, 203, 3539, 'Okha', 10000, 1),
(4737, 203, 3575, 'Palatka', 10000, 1),
(4738, 203, 3616, 'Pereslavl''-Zalesskiy', 10000, 1),
(4740, 203, 3558, 'Provideniya', 10000, 1),
(4741, 203, 3560, 'Pryazha', 10000, 1),
(4742, 203, 3591, 'Pushkin', 10000, 1),
(4743, 203, 3555, 'Pushkino', 10000, 1),
(4744, 203, 3600, 'Pyatigorsk', 10000, 1),
(4745, 203, 3591, 'Rostov-On-Don', 10000, 1),
(4747, 203, 3537, 'Rubtsovsk', 10000, 1),
(4748, 203, 3616, 'Rybinsk', 10000, 1),
(4749, 203, 3576, 'Sarov', 10000, 1),
(4750, 203, 3577, 'Serpukhov', 10000, 1),
(4752, 203, 3569, 'Sochi', 10000, 1),
(4753, 203, 3562, 'Sovetskaya Gavan''', 10000, 1),
(4755, 203, 3582, 'Staraya Russa', 10000, 1),
(4756, 203, 91, 'Syktyvkar', 10000, 1),
(4757, 203, 3582, 'Taldom', 10000, 1),
(4759, 203, 3595, 'Togliatti', 10000, 1),
(4760, 203, 3538, 'Tynda', 10000, 1),
(4763, 203, 3549, 'Vladikavkaz', 10000, 1),
(4767, 203, 3577, 'Zelenograd', 10000, 1),
(4771, 233, 4002, 'Eskilstuna', 10000, 1),
(4773, 233, 4010, 'Gothenburg', 10000, 1),
(4774, 233, 4009, 'Hammenh', 10000, 1),
(4775, 233, 4009, 'Helsingborg', 10000, 1),
(4776, 233, 3992, 'Jonkoping', 10000, 1),
(4778, 233, 4004, 'Karlskoga', 10000, 1),
(4779, 233, 3994, 'Leksand', 10000, 1),
(4782, 233, 4010, 'M', 10000, 1),
(4783, 233, 3994, 'Mora', 10000, 1),
(4784, 233, 4004, 'Munkfors', 10000, 1),
(4785, 233, 4009, 'Nybro', 10000, 1),
(4786, 233, 4002, 'Oxel', 10000, 1),
(4787, 233, 3986, 'Ronneby', 10000, 1),
(4788, 233, 4010, 'Skovde', 10000, 1),
(4789, 233, 4008, 'Solna', 10000, 1),
(4791, 233, 4004, 'Sunne', 10000, 1),
(4792, 233, 3996, 'Vaxjo', 10000, 1),
(4793, 233, 3993, 'Vimmerby', 10000, 1),
(4794, 221, 3763, 'Ljubljana', 10000, 1),
(4795, 220, 2592, 'Bardejov', 10000, 1),
(4796, 220, 2590, 'Kosice', 10000, 1),
(4797, 220, 2591, 'Nitra', 10000, 1),
(4798, 220, 2592, 'Spisska Nova Ves', 10000, 1),
(4799, 218, 3852, 'Bo', 10000, 1),
(4800, 218, 3853, 'Freetown', 10000, 1),
(4801, 211, 3860, 'San Marino', 10000, 1),
(4802, 214, 3697, 'Dakar', 10000, 1),
(4803, 214, 3697, 'Kaolack', 10000, 1),
(4804, 214, 3695, 'Linguere', 10000, 1),
(4806, 214, 3699, 'Ziguinchor', 10000, 1),
(4807, 72, 1646, 'Arcatao', 10000, 1),
(4809, 72, 1655, 'San Antonio Los Ranchos', 10000, 1),
(4810, 72, 1654, 'San Jose Las Flores', 10000, 1),
(4811, 72, 1654, 'San Miguel', 10000, 1),
(4812, 72, 1644, 'Santa Ana', 10000, 1),
(4813, 72, 1647, 'Tenancingo', 10000, 1),
(4814, 240, 5395, 'Lome', 10000, 1),
(4815, 239, 4102, 'Bangkok', 10000, 1),
(4817, 239, 776, 'Laem Chabang', 10000, 1),
(4819, 237, 4140, 'Dushanbe', 10000, 1),
(4820, 237, 4142, 'Khujand', 10000, 1),
(4821, 247, 5053, 'Ashgabat', 10000, 1),
(4822, 245, 4190, 'Carthage', 10000, 1),
(4823, 245, 4184, 'Gafsa', 10000, 1),
(4824, 246, 4225, 'Istanbul', 10000, 1),
(4825, 246, 4226, 'Izmir', 10000, 1),
(4826, 246, 4223, 'Mersin', 10000, 1),
(4827, 246, 4239, 'Mugla', 10000, 1),
(4829, 238, 4276, 'Arusha', 10000, 1),
(4830, 238, 4293, 'Bagamoyo', 10000, 1),
(4831, 238, 4277, 'Dar Es Salaam', 10000, 1),
(4832, 238, 4293, 'Morogoro', 10000, 1),
(4833, 238, 4290, 'Shinyanga', 10000, 1),
(4834, 251, 4441, 'Alushta', 10000, 1),
(4835, 251, 4437, 'Bogodukhov', 10000, 1),
(4836, 251, 4443, 'Brovary', 10000, 1),
(4837, 251, 4431, 'Cherkassy', 10000, 1),
(4838, 251, 4431, 'Chernivtsi', 10000, 1),
(4840, 251, 4434, 'Dnebrovsky', 10000, 1),
(4841, 251, 4435, 'Gorlovka', 10000, 1),
(4842, 251, 4431, 'Kaniv', 10000, 1),
(4843, 251, 4437, 'Kharkiv', 10000, 1),
(4844, 251, 4446, 'Kherson', 10000, 1),
(4846, 251, 4442, 'Kiev', 10000, 1),
(4848, 251, 4445, 'Lviv', 10000, 1),
(4849, 251, 4437, 'Merefa', 10000, 1),
(4850, 251, 4447, 'Odessa', 10000, 1),
(4851, 251, 4448, 'Poltava', 10000, 1),
(4852, 251, 4431, 'Shpola', 10000, 1),
(4854, 251, 4453, 'Smila', 10000, 1),
(4855, 251, 4452, 'Ternopil', 10000, 1),
(4857, 251, 4455, 'Uzhgorod', 10000, 1),
(4858, 251, 4447, 'Yalta', 10000, 1),
(4859, 259, 4535, 'Caracas', 10000, 1),
(4860, 259, 4527, 'Puerto la Cruz', 10000, 1),
(4861, 250, 4307, 'Jinja', 10000, 1),
(4862, 250, 4311, 'Kampala', 10000, 1),
(4863, 253, 5392, 'Andover', 10000, 1),
(4864, 253, 5392, 'Ashby-de-la-Zouch', 10000, 1),
(4865, 253, 5392, 'Ashford', 10000, 1),
(4866, 253, 5392, 'Barnet', 10000, 1),
(4868, 253, 5391, 'Belfast', 10000, 1),
(4869, 253, 5392, 'Belper', 10000, 1),
(4870, 253, 5392, 'Berwick Upon Tweed', 10000, 1),
(4871, 253, 5392, 'Billericay', 10000, 1),
(4872, 253, 5392, 'Birmingham', 10000, 1),
(4873, 253, 5390, 'Braemar', 10000, 1),
(4874, 253, 5389, 'Brecon', 10000, 1),
(4875, 253, 5392, 'Brentwood', 10000, 1),
(4876, 253, 5392, 'Broomfield', 10000, 1),
(4877, 253, 5392, 'Burton Upon Tren', 10000, 1),
(4878, 253, 5392, 'Cambridge', 10000, 1),
(4879, 253, 5392, 'Canterbury', 10000, 1),
(4880, 253, 5392, 'Cheltenham', 10000, 1),
(4881, 253, 5392, 'Chester', 10000, 1),
(4884, 253, 5392, 'Colchester', 10000, 1),
(4885, 253, 5392, 'Coventry', 10000, 1),
(4886, 253, 5390, 'Cumbernauld', 10000, 1),
(4887, 253, 5392, 'Dartmouth', 10000, 1),
(4889, 253, 5392, 'Doncaster', 10000, 1),
(4890, 253, 5390, 'Dunbar', 10000, 1),
(4891, 253, 5390, 'Dundee', 10000, 1),
(4892, 253, 5392, 'Durham', 10000, 1),
(4893, 253, 5390, 'Edinburgh', 10000, 1),
(4894, 253, 5390, 'Falkirk', 10000, 1),
(4895, 253, 5390, 'Forres', 10000, 1),
(4896, 253, 5392, 'Glastonbury', 10000, 1),
(4898, 253, 5390, 'Grangemouth', 10000, 1),
(4899, 253, 5392, 'Great Wilbraham', 10000, 1),
(4900, 253, 5390, 'Greenock', 10000, 1),
(4902, 253, 5392, 'Hartlepool', 10000, 1),
(4903, 253, 5392, 'Haverhill', 10000, 1),
(4904, 253, 5389, 'Hawarden', 10000, 1),
(4905, 253, 5390, 'Inverness', 10000, 1),
(4906, 253, 5392, 'Keighley', 10000, 1),
(4907, 253, 5390, 'Kelso', 10000, 1),
(4908, 253, 5390, 'Kennet', 10000, 1),
(4909, 253, 5392, 'Kettering', 10000, 1),
(4910, 253, 5392, 'Kingston Upon Hull', 10000, 1),
(4911, 253, 5392, 'Laughton', 10000, 1),
(4912, 253, 5392, 'Lewes', 10000, 1),
(4913, 253, 5389, 'Machynlleth', 10000, 1),
(4914, 253, 5392, 'Mansfield', 10000, 1),
(4915, 253, 5392, 'Margate', 10000, 1),
(4916, 253, 5392, 'Marlborough', 10000, 1),
(4917, 253, 5392, 'Merton', 10000, 1),
(4918, 253, 5390, 'Newark', 10000, 1),
(4919, 253, 5392, 'Newcastle Upon Tyne', 10000, 1),
(4922, 253, 5392, 'Northampton', 10000, 1),
(4923, 253, 5390, 'Oban', 10000, 1),
(4925, 253, 5392, 'Penzance', 10000, 1),
(4926, 253, 5390, 'Plains', 10000, 1),
(4927, 253, 5392, 'Plymouth', 10000, 1),
(4928, 253, 5392, 'Portsmouth', 10000, 1),
(4931, 253, 5392, 'Salisbury', 10000, 1),
(4932, 253, 5392, 'Scarborough', 10000, 1),
(4935, 253, 5392, 'Southampton', 10000, 1),
(4936, 253, 5392, 'Southborough', 10000, 1),
(4937, 253, 5392, 'Stoke On Trent', 10000, 1),
(4938, 253, 5392, 'Stratford-Upon-Avon', 10000, 1),
(4939, 253, 5392, 'Stroud', 10000, 1),
(4941, 253, 5392, 'Taunton', 10000, 1),
(4943, 253, 5392, 'Truro', 10000, 1),
(4945, 253, 5392, 'Wallingford', 10000, 1),
(4947, 253, 5392, 'Wareham', 10000, 1),
(4948, 253, 5392, 'Warwick', 10000, 1),
(4949, 253, 5392, 'Watford', 10000, 1),
(4950, 253, 5392, 'Whitby', 10000, 1),
(4952, 253, 5392, 'Wisbech', 10000, 1),
(4953, 253, 5392, 'Wisborough Green', 10000, 1),
(4954, 256, 4496, 'Maldonado', 10000, 1),
(4955, 256, 4497, 'Montevideo', 10000, 1),
(4956, 256, 4498, 'Paysandu', 10000, 1),
(4957, 257, 4508, 'Bukhara', 10000, 1),
(4958, 257, 4516, 'Samarkand', 10000, 1),
(4959, 257, 4519, 'Tashkent', 10000, 1),
(4960, 260, 4568, 'Ho Chi Minh City', 10000, 1),
(4961, 260, 4612, 'Hue', 10000, 1),
(4962, 4, 5309, 'Pago Pago', 10000, 1),
(4963, 273, 4681, 'Kitwe', 10000, 1),
(4964, 273, 4688, 'Lusaka', 10000, 1),
(4965, 274, 4693, 'Chinhoyi', 10000, 1),
(4966, 274, 4690, 'Gweru', 10000, 1),
(4967, 274, 4691, 'Harare', 10000, 1),
(4968, 274, 4689, 'Mutare', 10000, 1),
(4969, 17, 1150, 'Freeport', 10000, 1),
(4971, 17, 1148, 'Nassau', 10000, 1),
(4972, 56, 1316, 'Pointe Noire', 10000, 1),
(4973, 64, 5134, 'Uhersky Brod', 10000, 1),
(4974, 64, 601, 'Kladno', 10000, 1),
(4977, 133, 2435, 'Andong', 10000, 1),
(4978, 133, 2425, 'Anyang', 10000, 1),
(4979, 133, 2430, 'Bucheon City', 10000, 1),
(4981, 133, 2424, 'Jeju', 10000, 1),
(4982, 133, 2428, 'Chinju', 10000, 1),
(4983, 133, 2425, 'Chonju', 10000, 1),
(4985, 133, 2426, 'Chungju', 10000, 1),
(4987, 133, 2432, 'Inchon', 10000, 1),
(4989, 133, 2427, 'Kangnung', 10000, 1),
(4990, 133, 2425, 'Kunsan', 10000, 1),
(4991, 133, 2435, 'Kwangju', 10000, 1),
(4992, 133, 2429, 'Masan', 10000, 1),
(4993, 133, 2424, 'Pohang', 10000, 1),
(4994, 133, 2429, 'Pusan', 10000, 1),
(4996, 133, 2427, 'Sokch''o', 10000, 1),
(4998, 133, 2432, 'Suwon', 10000, 1),
(4999, 133, 2433, 'Taegu', 10000, 1),
(5000, 133, 2436, 'Taejon', 10000, 1),
(5001, 133, 2427, 'Tongdu-ch''on', 10000, 1),
(5002, 133, 2428, 'Ulsan', 10000, 1),
(5003, 133, 2427, 'Wonju', 10000, 1),
(5004, 91, 1915, 'Diekirch North', 10000, 1),
(5005, 146, 5135, 'Skopje', 10000, 1),
(5006, 146, 5239, 'Tetovo', 10000, 1),
(5009, 152, 689, 'Mosta', 10000, 1),
(5010, 253, 5390, 'Hamilton', 10000, 1),
(5011, 253, 5390, 'Prestwick', 10000, 1),
(5012, 253, 5390, 'Stirling', 10000, 1),
(5013, 220, 2589, 'Bratislava', 10000, 1),
(5015, 133, 2432, 'Songnam', 10000, 1),
(5017, 49, 586, 'Ping-Tung City', 10000, 1),
(5018, 49, 586, 'Ping-Tung County', 10000, 1),
(5020, 49, 586, 'Tai-Tung County', 10000, 1),
(5021, 49, 586, 'Xian', 10000, 1),
(5023, 118, 2233, 'B''nei Brak', 10000, 1),
(5024, 49, 586, 'Pan-Chiao City', 10000, 1),
(5028, 39, 1196, 'Yangon', 10000, 1),
(5030, 36, 1249, 'Bandar Seri Begawan', 10000, 1),
(5033, 29, 1172, 'Aiquile', 10000, 1),
(5034, 29, 1174, 'Apolo', 10000, 1),
(5035, 29, 1177, 'Atocha', 10000, 1),
(5036, 29, 1179, 'Bermejo', 10000, 1),
(5037, 29, 1175, 'Caracollo', 10000, 1),
(5038, 29, 1174, 'Chara', 10000, 1),
(5039, 29, 1172, 'Chimore', 10000, 1),
(5040, 29, 1173, 'Chulumani', 10000, 1),
(5042, 29, 1174, 'Corioco', 10000, 1),
(5043, 29, 1173, 'Cotoca', 10000, 1),
(5045, 29, 1173, 'Guayaramerin', 10000, 1),
(5046, 29, 1172, 'Lagunillas', 10000, 1),
(5047, 29, 1174, 'Machacamarca', 10000, 1),
(5048, 29, 1172, 'Mizque', 10000, 1),
(5050, 29, 1176, 'Portachuelo', 10000, 1),
(5051, 29, 1177, 'Potosi', 10000, 1),
(5052, 29, 1178, 'Puerto Grether', 10000, 1),
(5053, 29, 1172, 'Puerto Patino', 10000, 1),
(5054, 29, 1172, 'Puerto Villarroel', 10000, 1),
(5055, 29, 1172, 'Punata', 10000, 1),
(5057, 29, 1173, 'Riberalta', 10000, 1),
(5058, 29, 1173, 'San Borja', 10000, 1),
(5059, 29, 1178, 'San Jose de Chiquitos', 10000, 1),
(5060, 29, 1178, 'Santa Ana', 10000, 1),
(5061, 29, 1178, 'Santa Rosa del Sara', 10000, 1),
(5063, 29, 1171, 'Sucre', 10000, 1),
(5064, 29, 1179, 'Tarija', 10000, 1),
(5065, 29, 1176, 'Trinidad', 10000, 1),
(5066, 29, 1177, 'Tupiza', 10000, 1),
(5067, 29, 1174, 'Uyuni', 10000, 1),
(5070, 29, 1171, 'Villazon', 10000, 1),
(5071, 29, 1174, 'Vinto', 10000, 1),
(5072, 29, 1179, 'Yacuiba', 10000, 1),
(5073, 29, 1174, 'Yolosa', 10000, 1),
(5075, 17, 1139, 'Freetown', 10000, 1),
(5076, 17, 1156, 'Marsh Harbour', 10000, 1),
(5077, 17, 1148, 'Nassau City', 10000, 1),
(5080, 48, 1366, 'Antofagasta', 10000, 1),
(5081, 48, 1376, 'Arica', 10000, 1),
(5082, 48, 1371, 'Cerrillos', 10000, 1),
(5084, 48, 1369, 'Chiguayante', 10000, 1),
(5085, 48, 1369, 'Chillan', 10000, 1),
(5086, 48, 1369, 'Concepcion', 10000, 1),
(5087, 48, 1370, 'Conchali', 10000, 1),
(5088, 48, 1375, 'El Arrayan', 10000, 1),
(5089, 48, 1370, 'El Bosque', 10000, 1),
(5090, 48, 1376, 'Estacion Central', 10000, 1),
(5091, 48, 1369, 'Huachipato', 10000, 1),
(5094, 48, 1376, 'Iquique', 10000, 1),
(5095, 48, 1375, 'La Cisterna', 10000, 1),
(5096, 48, 1375, 'La Dehesa', 10000, 1),
(5097, 48, 1364, 'La Florida', 10000, 1),
(5098, 48, 1376, 'La Granja', 10000, 1),
(5100, 48, 1375, 'La Reina', 10000, 1),
(5101, 48, 1375, 'Las Condes', 10000, 1),
(5103, 48, 1375, 'Lo Espejo', 10000, 1),
(5105, 48, 1375, 'Macul', 10000, 1),
(5106, 48, 1375, 'Maipu', 10000, 1),
(5107, 48, 1375, 'Nunoa', 10000, 1),
(5109, 48, 1376, 'Pena Blanca', 10000, 1),
(5110, 48, 1375, 'Penalolen', 10000, 1),
(5111, 48, 1369, 'Penco', 10000, 1),
(5112, 48, 1375, 'Providencia', 10000, 1),
(5114, 48, 1375, 'Puente Alto', 10000, 1),
(5115, 48, 1375, 'Quilicura', 10000, 1),
(5116, 48, 1364, 'Quilpue', 10000, 1),
(5117, 48, 1375, 'Quinta Normal', 10000, 1),
(5118, 48, 1371, 'Rancagua', 10000, 1),
(5119, 48, 1370, 'Recoleta', 10000, 1),
(5120, 48, 1364, 'Renaca', 10000, 1),
(5121, 48, 1375, 'Renca', 10000, 1),
(5122, 48, 1370, 'San Bernardo', 10000, 1),
(5123, 48, 1375, 'San Joaquin', 10000, 1),
(5124, 48, 1370, 'San Miguel', 10000, 1),
(5125, 48, 1368, 'San Pedro', 10000, 1),
(5126, 48, 1366, 'San Ramon', 10000, 1),
(5127, 48, 1371, 'San Vicente', 10000, 1),
(5128, 48, 1375, 'Vitacura', 10000, 1),
(5129, 53, 1400, 'Arauca', 10000, 1),
(5130, 53, 1419, 'Barrancabermeja', 10000, 1),
(5131, 53, 1398, 'Barrancas', 10000, 1),
(5132, 53, 1413, 'Buga', 10000, 1),
(5133, 53, 1415, 'Chiquinquira', 10000, 1),
(5134, 53, 1414, 'Cucuta', 10000, 1),
(5136, 53, 1419, 'El Centro', 10000, 1),
(5137, 53, 1426, 'Engativa', 10000, 1),
(5138, 53, 1399, 'Envigado', 10000, 1),
(5139, 53, 1426, 'Facatativa', 10000, 1),
(5140, 53, 1413, 'Florencia', 10000, 1),
(5141, 53, 1426, 'Fontibon', 10000, 1),
(5142, 53, 1399, 'Fragua', 10000, 1),
(5143, 53, 1426, 'Funza', 10000, 1),
(5144, 53, 1426, 'Fusagasuga', 10000, 1),
(5146, 53, 1419, 'Galan', 10000, 1),
(5147, 53, 1419, 'Girardot', 10000, 1),
(5148, 53, 1413, 'Ipiales', 10000, 1),
(5149, 53, 1399, 'Itagui', 10000, 1),
(5150, 53, 1415, 'Junin', 10000, 1),
(5151, 53, 1421, 'La Calera', 10000, 1),
(5152, 53, 1413, 'La Victoria', 10000, 1),
(5153, 53, 1413, 'Las Cruces', 10000, 1),
(5154, 53, 1400, 'Las Delicias', 10000, 1),
(5155, 53, 1421, 'Laureles', 10000, 1),
(5156, 53, 1398, 'Leticia', 10000, 1),
(5157, 53, 1427, 'Madrid', 10000, 1),
(5158, 53, 1411, 'Maicao', 10000, 1),
(5159, 53, 1429, 'Melgar', 10000, 1),
(5160, 53, 1406, 'Monteria', 10000, 1),
(5161, 53, 1403, 'Mosquera', 10000, 1),
(5162, 53, 1410, 'Neiva', 10000, 1),
(5163, 53, 1429, 'Paipa', 10000, 1),
(5165, 53, 1422, 'Palmira', 10000, 1),
(5166, 53, 1414, 'Pamplona', 10000, 1),
(5167, 53, 1413, 'Pasto', 10000, 1),
(5168, 53, 1417, 'Pereira', 10000, 1),
(5170, 53, 1405, 'Quibdo', 10000, 1),
(5171, 53, 1411, 'Riohacha', 10000, 1),
(5173, 53, 1418, 'San Andres', 10000, 1),
(5176, 53, 1426, 'Soacha', 10000, 1),
(5177, 53, 1429, 'Sogamoso', 10000, 1),
(5178, 53, 1426, 'Suba', 10000, 1),
(5179, 53, 1426, 'Tocaima', 10000, 1),
(5180, 53, 1426, 'Usaquen', 10000, 1),
(5181, 53, 1404, 'Valledupar', 10000, 1),
(5182, 53, 1414, 'Villa De Leiva', 10000, 1),
(5183, 53, 1412, 'Villavicencio', 10000, 1),
(5184, 53, 1421, 'Yopal', 10000, 1),
(5185, 53, 1426, 'Zipaquira', 10000, 1),
(5191, 68, 1524, 'Arenoso', 10000, 1),
(5192, 68, 1519, 'Azua', 10000, 1),
(5193, 68, 1519, 'Azua De Compostela', 10000, 1),
(5194, 68, 1521, 'Bahoruco', 10000, 1),
(5195, 68, 1548, 'Bajos De Haina', 10000, 1),
(5196, 68, 1533, 'Bani', 10000, 1),
(5197, 68, 1528, 'Banica', 10000, 1),
(5198, 68, 1521, 'Barahona', 10000, 1),
(5199, 68, 1547, 'Bayaguana', 10000, 1),
(5200, 68, 1538, 'Bohechio', 10000, 1),
(5201, 68, 1546, 'Bonao', 10000, 1),
(5202, 68, 1521, 'Cabral', 10000, 1),
(5203, 68, 1530, 'Cabrera', 10000, 1),
(5204, 68, 1548, 'Cambita Garabitos', 10000, 1),
(5207, 68, 1531, 'Castanuelas', 10000, 1),
(5208, 68, 1524, 'Castillo', 10000, 1),
(5209, 68, 1525, 'Cayetano Germosen', 10000, 1),
(5211, 68, 1537, 'Cevicos', 10000, 1),
(5212, 68, 1527, 'Chavon Abajo', 10000, 1),
(5213, 68, 1528, 'Comendador', 10000, 1),
(5214, 68, 1537, 'Cotui', 10000, 1),
(5215, 68, 1526, 'Cristobal', 10000, 1),
(5216, 68, 1522, 'Dajabon', 10000, 1),
(5217, 68, 1547, 'Don Juan', 10000, 1),
(5218, 68, 1523, 'Duarte', 10000, 1),
(5219, 68, 1526, 'Duverge', 10000, 1),
(5220, 68, 1519, 'El Cacao', 10000, 1),
(5221, 68, 1538, 'El Cercado', 10000, 1),
(5222, 68, 1530, 'El Factor', 10000, 1),
(5223, 68, 1539, 'El Guayabal', 10000, 1),
(5224, 68, 1528, 'El Llano', 10000, 1),
(5225, 68, 1521, 'El Penon', 10000, 1),
(5226, 68, 1522, 'El Pino', 10000, 1),
(5228, 68, 1544, 'El Valle', 10000, 1),
(5229, 68, 1528, 'Elias Pina', 10000, 1),
(5230, 68, 1521, 'Enriquillo', 10000, 1),
(5232, 68, 1547, 'Esperalvillo', 10000, 1),
(5233, 68, 1542, 'Esperanza', 10000, 1),
(5234, 68, 1519, 'Estebania', 10000, 1),
(5235, 68, 1537, 'Fantino', 10000, 1),
(5236, 68, 1521, 'Fundacion', 10000, 1),
(5237, 68, 1520, 'Galvan', 10000, 1),
(5238, 68, 1525, 'Gaspar Hernandez', 10000, 1),
(5239, 68, 1519, 'Guayabal', 10000, 1),
(5241, 68, 1544, 'Hato Mayor', 10000, 1),
(5242, 68, 1544, 'Hato Mayor Del Rey', 10000, 1),
(5243, 68, 1527, 'Higuey', 10000, 1),
(5244, 68, 1528, 'Hondo Valle', 10000, 1),
(5245, 68, 1524, 'Hostos', 10000, 1),
(5246, 68, 1523, 'Independencia', 10000, 1),
(5247, 68, 1525, 'Jamao Al Norte', 10000, 1),
(5248, 68, 1526, 'Jimani', 10000, 1),
(5249, 68, 1525, 'Jose Contreras', 10000, 1),
(5250, 68, 1538, 'Juan De Herrera', 10000, 1),
(5251, 68, 1528, 'Juan Santiago', 10000, 1),
(5252, 68, 1521, 'La Altagracia', 10000, 1),
(5253, 68, 1521, 'La Cienaga', 10000, 1),
(5254, 68, 1548, 'La Cueva', 10000, 1),
(5255, 68, 1526, 'La Descubierta', 10000, 1),
(5257, 68, 1543, 'La Mata', 10000, 1),
(5259, 68, 1542, 'Laguna Salada', 10000, 1),
(5260, 68, 1519, 'Las Charcas', 10000, 1),
(5261, 68, 1537, 'Las Cuevas', 10000, 1),
(5262, 68, 1524, 'Las Guaranas', 10000, 1),
(5263, 68, 1537, 'Las Matas', 10000, 1),
(5264, 68, 1538, 'Las Matas De Farfan', 10000, 1),
(5266, 68, 1521, 'Las Salinas', 10000, 1),
(5267, 68, 1536, 'Las Terrenas', 10000, 1),
(5269, 68, 1522, 'Loma De Cabrera', 10000, 1),
(5270, 68, 1541, 'Los Almacigos', 10000, 1),
(5271, 68, 1548, 'Los Cacaos', 10000, 1),
(5272, 68, 1520, 'Los Rios', 10000, 1),
(5273, 68, 1546, 'Maimon', 10000, 1),
(5274, 68, 1542, 'Mao', 10000, 1),
(5276, 68, 1533, 'Matanzas', 10000, 1),
(5277, 68, 1526, 'Mella', 10000, 1),
(5278, 68, 1543, 'Miches', 10000, 1),
(5279, 68, 1525, 'Moca', 10000, 1),
(5280, 68, 1541, 'Moncion', 10000, 1),
(5281, 68, 1546, 'Monsenor Nouel', 10000, 1),
(5283, 68, 1531, 'Monte Plata', 10000, 1),
(5284, 68, 1530, 'Nagua', 10000, 1),
(5285, 68, 1520, 'Neiba', 10000, 1),
(5286, 68, 1520, 'Neyba', 10000, 1),
(5287, 68, 1548, 'Nigua', 10000, 1),
(5288, 68, 1527, 'Nisibon', 10000, 1),
(5289, 68, 1533, 'Nizao', 10000, 1),
(5290, 68, 1527, 'Otra Banda', 10000, 1),
(5291, 68, 1532, 'Oviedo', 10000, 1),
(5292, 68, 1519, 'Padre Las Casas', 10000, 1),
(5293, 68, 1521, 'Paraiso', 10000, 1),
(5294, 68, 1522, 'Partido', 10000, 1),
(5295, 68, 1532, 'Pedernales', 10000, 1),
(5296, 68, 1528, 'Pedro Santana', 10000, 1),
(5297, 68, 1521, 'Penon', 10000, 1),
(5298, 68, 1531, 'Pepillo Salcedo', 10000, 1),
(5299, 68, 1519, 'Peralta', 10000, 1),
(5300, 68, 1533, 'Peravia', 10000, 1),
(5301, 68, 1546, 'Piedra Blanca', 10000, 1),
(5302, 68, 1524, 'Pimentel', 10000, 1),
(5303, 68, 1521, 'Polo', 10000, 1),
(5305, 68, 1519, 'Pueblo Viejo', 10000, 1),
(5306, 68, 1533, 'Rancho Arriba', 10000, 1),
(5307, 68, 1522, 'Restauracion', 10000, 1),
(5308, 68, 1544, 'Rio San Juan', 10000, 1),
(5309, 68, 1533, 'Sabana Buey', 10000, 1),
(5310, 68, 1544, 'Sabana De La Mar', 10000, 1),
(5311, 68, 1547, 'Sabana Grande De Boya', 10000, 1),
(5312, 68, 1548, 'Sabana Grande Palenque', 10000, 1),
(5313, 68, 1533, 'Sabana Larga', 10000, 1),
(5314, 68, 1519, 'Sabana Yegua', 10000, 1),
(5315, 68, 1535, 'Salcedo', 10000, 1),
(5318, 68, 1548, 'San Cristobal', 10000, 1),
(5320, 68, 1524, 'San Francisco De Macoris', 10000, 1),
(5322, 68, 1541, 'San Ignacio De Sabaneta', 10000, 1),
(5324, 68, 1533, 'San Jose De Ocoa', 10000, 1),
(5325, 68, 1539, 'San Juan', 10000, 1),
(5327, 68, 1527, 'San Rafael Del Yuma', 10000, 1),
(5328, 68, 1525, 'San Victor', 10000, 1),
(5329, 68, 1536, 'Sanchez', 10000, 1),
(5332, 68, 1541, 'Santiago Rodriguez', 10000, 1),
(5335, 68, 1519, 'Tabara Arriba', 10000, 1),
(5336, 68, 1520, 'Tamayo', 10000, 1),
(5337, 68, 1535, 'Tenares', 10000, 1),
(5338, 68, 1520, 'Ubilla', 10000, 1),
(5339, 68, 1538, 'Vallejuelo', 10000, 1),
(5340, 68, 1542, 'Valverde', 10000, 1),
(5341, 68, 1521, 'Vicente Noble', 10000, 1),
(5342, 68, 1548, 'Villa Altagracia', 10000, 1),
(5344, 68, 1520, 'Villa Jaragua', 10000, 1),
(5345, 68, 1524, 'Villa Riva', 10000, 1),
(5346, 68, 1535, 'Villa Tapia', 10000, 1),
(5347, 68, 1531, 'Villa Vasquez', 10000, 1),
(5348, 68, 1548, 'Yaguate', 10000, 1),
(5349, 68, 1547, 'Yamasa', 10000, 1),
(5350, 68, 1519, 'Yayas De Viajama', 10000, 1),
(5351, 70, 1566, 'Ambato', 10000, 1),
(5352, 70, 1562, 'Bahia', 10000, 1),
(5353, 70, 1562, 'Bahia De Caraquez', 10000, 1),
(5354, 70, 1560, 'Loja', 10000, 1),
(5355, 70, 1556, 'Machala', 10000, 1),
(5356, 70, 1562, 'Manta', 10000, 1),
(5357, 70, 1559, 'Otavalo', 10000, 1),
(5358, 70, 1562, 'Portoviejo', 10000, 1),
(5359, 70, 1549, 'Puerto Ayora', 10000, 1),
(5360, 70, 1549, 'Puerto Baquerizo Moreno', 10000, 1),
(5361, 70, 1565, 'Santo Domingo', 10000, 1),
(5362, 70, 1553, 'Tulcan', 10000, 1),
(5363, 100, 1985, 'Boca Del Monte', 10000, 1),
(5364, 100, 1985, 'Guatemala', 10000, 1),
(5365, 100, 1985, 'MIXCO', 10000, 1),
(5366, 100, 1985, 'SAN MIGUEL PETAPA', 10000, 1),
(5367, 100, 1985, 'VILLA CANALES', 10000, 1),
(5368, 100, 1989, 'VILLA NUEVA', 10000, 1),
(5369, 104, 2032, 'Albion', 10000, 1),
(5371, 104, 2034, 'Bartica', 10000, 1),
(5374, 104, 2035, 'Blairmont', 10000, 1),
(5375, 104, 2034, 'Charity', 10000, 1),
(5383, 104, 2035, 'Fort Wellington', 10000, 1),
(5384, 104, 2035, 'Hopetown', 10000, 1),
(5385, 104, 2038, 'Linden', 10000, 1),
(5386, 104, 2038, 'MACKENZIE', 10000, 1),
(5387, 104, 2032, 'MAHAICA', 10000, 1),
(5388, 104, 2035, 'MAHAICONY', 10000, 1),
(5389, 104, 2033, 'NEW AMSTERDAM', 10000, 1),
(5390, 104, 2033, 'OREALLA', 10000, 1),
(5391, 104, 2034, 'PARIKA', 10000, 1),
(5392, 104, 2033, 'PORT MOURANT', 10000, 1),
(5393, 104, 2038, 'ROCKSTONE', 10000, 1),
(5394, 104, 2033, 'ROSE HALL', 10000, 1),
(5395, 104, 2035, 'ROSIGNOL', 10000, 1),
(5397, 104, 2033, 'SKELDON', 10000, 1),
(5398, 104, 2033, 'SPRINGLANDS', 10000, 1),
(5399, 104, 2036, 'SUDDIE', 10000, 1),
(5402, 108, 2056, 'Comayaguela', 10000, 1),
(5403, 108, 2056, 'Cortes', 10000, 1),
(5404, 108, 2055, 'Danli', 10000, 1),
(5405, 108, 2056, 'El Llano', 10000, 1),
(5406, 108, 2056, 'El Progreso', 10000, 1),
(5408, 108, 2054, 'La Lima', 10000, 1),
(5409, 108, 2066, 'Progreso', 10000, 1),
(5410, 108, 2054, 'Puerto Cortes', 10000, 1),
(5411, 108, 2054, 'SAN PEDRO SULA', 10000, 1),
(5412, 108, 2050, 'SANTA RITA', 10000, 1),
(5413, 108, 2049, 'TELA', 10000, 1),
(5414, 108, 2064, 'YORO', 10000, 1),
(5415, 108, 2055, 'YUSCARAN', 10000, 1),
(5416, 105, 2042, 'Bourdon', 10000, 1),
(5418, 105, 2044, 'Carrefour Shada', 10000, 1),
(5419, 105, 2042, 'Delmas', 10000, 1),
(5421, 105, 2046, 'Diquini', 10000, 1),
(5422, 105, 2046, 'MARTISSANT', 10000, 1),
(5423, 105, 2046, 'PETIONVILLE', 10000, 1),
(5425, 120, 2381, 'AdelphI', 10000, 1),
(5426, 120, 2373, 'Amity Hall', 10000, 1),
(5427, 120, 2381, 'Anchovy', 10000, 1),
(5428, 120, 2381, 'Bickersteth', 10000, 1),
(5430, 120, 2379, 'Braeton', 10000, 1),
(5431, 120, 2375, 'Browns Town', 10000, 1),
(5433, 120, 2379, 'Bushy Park', 10000, 1),
(5434, 120, 2383, 'Cambridge', 10000, 1),
(5435, 120, 2381, 'Catadupa', 10000, 1),
(5436, 120, 2379, 'Central Village', 10000, 1),
(5437, 120, 2373, 'Chapelton', 10000, 1),
(5438, 120, 2381, 'Chatham', 10000, 1),
(5439, 120, 2374, 'Chigwell', 10000, 1),
(5440, 120, 2380, 'Claremont', 10000, 1),
(5441, 120, 2382, 'Copse', 10000, 1),
(5442, 120, 2373, 'Denbigh', 10000, 1),
(5443, 120, 2378, 'Discovery Bay', 10000, 1),
(5444, 120, 2384, 'Duncans', 10000, 1),
(5445, 120, 2384, 'Falmouth', 10000, 1),
(5447, 120, 2381, 'Flagstaff', 10000, 1),
(5449, 120, 2381, 'Flower Hill', 10000, 1),
(5450, 120, 2373, 'Four Paths', 10000, 1),
(5451, 120, 2373, 'Freetown', 10000, 1),
(5453, 120, 2384, 'Gales Valley', 10000, 1),
(5454, 120, 2379, 'Garlands', 10000, 1),
(5455, 120, 2377, 'Golden Spring', 10000, 1),
(5456, 120, 2377, 'Gordon Town', 10000, 1),
(5457, 120, 2379, 'Goshen', 10000, 1),
(5458, 120, 2385, 'Grange Hill', 10000, 1),
(5459, 120, 2379, 'Gregory Park', 10000, 1),
(5460, 120, 2381, 'Guilsbro', 10000, 1),
(5461, 120, 2377, 'Half Way Tree', 10000, 1),
(5462, 120, 2383, 'Harbour Head', 10000, 1),
(5465, 120, 2379, 'Highgate', 10000, 1),
(5466, 120, 2380, 'Hopeton', 10000, 1),
(5469, 120, 2379, 'Innswood', 10000, 1),
(5471, 120, 2386, 'Johns Hall', 10000, 1),
(5472, 120, 2373, 'Kellits', 10000, 1),
(5473, 120, 2375, 'Kendal', 10000, 1),
(5474, 120, 2380, 'Kensington', 10000, 1),
(5475, 120, 2374, 'Lethe', 10000, 1),
(5476, 120, 2381, 'Lima', 10000, 1),
(5477, 120, 2373, 'Lime Hall', 10000, 1),
(5478, 120, 2379, 'Linstead', 10000, 1),
(5479, 120, 2373, 'Lionel Town', 10000, 1),
(5480, 120, 2381, 'Lottery', 10000, 1),
(5481, 120, 2374, 'Lucea', 10000, 1),
(5482, 120, 2378, 'Lydford', 10000, 1),
(5483, 120, 2375, 'Mandeville', 10000, 1),
(5485, 120, 2379, 'Marlie Mount', 10000, 1),
(5486, 120, 2381, 'Maroon Town', 10000, 1),
(5487, 120, 2373, 'May Pen', 10000, 1),
(5489, 120, 2380, 'Middle Quarters', 10000, 1),
(5490, 120, 2373, 'Milk River Bath', 10000, 1),
(5491, 120, 2377, 'Mocho', 10000, 1),
(5492, 120, 2378, 'Moneague', 10000, 1),
(5493, 120, 2377, 'Montpelier', 10000, 1),
(5494, 120, 2381, 'Mount Carey', 10000, 1),
(5495, 120, 2379, 'Naggo Head', 10000, 1),
(5496, 120, 2380, 'Nain', 10000, 1),
(5497, 120, 2385, 'Negril', 10000, 1),
(5499, 120, 2379, 'Old Harbour', 10000, 1),
(5500, 120, 2373, 'Palmers', 10000, 1),
(5501, 120, 2379, 'Passage Fort', 10000, 1),
(5502, 120, 2381, 'Point', 10000, 1),
(5503, 120, 2377, 'Port Maria', 10000, 1),
(5504, 120, 2379, 'Portmore', 10000, 1),
(5505, 120, 2375, 'Porus', 10000, 1),
(5506, 120, 2373, 'Race Course', 10000, 1),
(5507, 120, 2381, 'Reading', 10000, 1),
(5508, 120, 2379, 'Rest', 10000, 1),
(5509, 120, 2373, 'Rhymesbury', 10000, 1),
(5510, 120, 2384, 'Rio Bueno', 10000, 1),
(5511, 120, 2374, 'Salt Spring', 10000, 1),
(5512, 120, 2385, 'Seven Rivers', 10000, 1),
(5513, 120, 2374, 'Shettlewood', 10000, 1),
(5515, 120, 2381, 'Somerton', 10000, 1),
(5517, 120, 2379, 'Spanish Town', 10000, 1),
(5518, 120, 2381, 'Spot Valley', 10000, 1),
(5519, 120, 2381, 'Spring Mount', 10000, 1),
(5521, 120, 2384, 'Spring Vale', 10000, 1),
(5522, 120, 2379, 'Spring Village', 10000, 1),
(5523, 120, 2379, 'Springfield', 10000, 1),
(5524, 120, 2375, 'Spur Tree', 10000, 1),
(5529, 120, 2379, 'Stanberry Grove', 10000, 1),
(5531, 120, 2377, 'Stony Hill', 10000, 1),
(5533, 120, 2381, 'Unity Hall', 10000, 1),
(5537, 120, 2381, 'Wiltshire', 10000, 1),
(5539, 41, 1267, 'Battambang', 10000, 1),
(5542, 41, 1268, 'Kampong Cham', 10000, 1),
(5543, 41, 1271, 'Kampong Thom', 10000, 1),
(5544, 41, 1268, 'Kampot', 10000, 1),
(5545, 41, 1270, 'Kandal', 10000, 1),
(5547, 41, 1275, 'Kratie', 10000, 1),
(5550, 41, 1280, 'Prey Veng', 10000, 1),
(5551, 41, 1278, 'Pursat', 10000, 1),
(5553, 41, 1287, 'Siem Reap', 10000, 1),
(5555, 41, 1283, 'Stung Treng', 10000, 1),
(5556, 41, 1284, 'Svay Rieng', 10000, 1),
(5557, 41, 1285, 'Takeo', 10000, 1),
(5559, 184, 5369, 'Saipan', 10000, 1),
(5561, 190, 3292, 'Aguadulce', 10000, 1),
(5562, 190, 3291, 'Alanje', 10000, 1),
(5564, 190, 3291, 'Bambito', 10000, 1),
(5567, 190, 3290, 'Bocas Del Toro', 10000, 1),
(5568, 190, 3299, 'Boquete', 10000, 1),
(5569, 190, 3291, 'Cerro Punta', 10000, 1),
(5570, 190, 3290, 'Changuinola', 10000, 1),
(5571, 190, 3291, 'Chiriqui', 10000, 1),
(5572, 190, 3299, 'Chitre', 10000, 1),
(5573, 190, 3292, 'Cocle', 10000, 1),
(5574, 190, 3298, 'Concepcion', 10000, 1),
(5576, 190, 3291, 'Dolega', 10000, 1),
(5578, 190, 3291, 'El Varital', 10000, 1),
(5579, 190, 3291, 'Gualaca', 10000, 1),
(5581, 190, 3291, 'La Primavera', 10000, 1),
(5583, 190, 3296, 'Las Tablas', 10000, 1),
(5584, 190, 3296, 'Loma Colorada', 10000, 1),
(5585, 190, 3296, 'Los Santos', 10000, 1),
(5588, 190, 3296, 'Pedregal', 10000, 1),
(5589, 190, 3292, 'Penonome', 10000, 1),
(5590, 190, 3291, 'Puerto Armuelles', 10000, 1),
(5591, 190, 3291, 'Remedios', 10000, 1),
(5592, 190, 3299, 'San Cristobal', 10000, 1),
(5593, 190, 3291, 'San Lorenzo', 10000, 1),
(5594, 190, 3291, 'San Mateo', 10000, 1),
(5595, 190, 3292, 'San Pablo', 10000, 1),
(5596, 190, 3291, 'Santa Cruz', 10000, 1),
(5597, 190, 3299, 'Santiago', 10000, 1),
(5601, 190, 3299, 'Veraguas', 10000, 1),
(5603, 190, 3291, 'Volcan', 10000, 1),
(5604, 194, 3191, 'Aplao', 10000, 1),
(5605, 194, 3191, 'Camana', 10000, 1),
(5606, 194, 3191, 'Cayma', 10000, 1),
(5608, 194, 3202, 'Collique', 10000, 1),
(5609, 194, 3202, 'Magdalena', 10000, 1),
(5610, 194, 3191, 'Sabandia', 10000, 1),
(5611, 194, 3191, 'Socabaya', 10000, 1),
(5612, 194, 3195, 'Yanahuara', 10000, 1),
(5613, 187, 3218, 'Abbottabad', 10000, 1),
(5614, 187, 3218, 'Attock', 10000, 1),
(5615, 187, 3219, 'Burewala', 10000, 1),
(5617, 187, 3221, 'Kamoki', 10000, 1),
(5618, 187, 3219, 'Khewra', 10000, 1),
(5619, 187, 3218, 'Mardan', 10000, 1),
(5620, 187, 3221, 'Mirpur', 10000, 1),
(5622, 187, 3222, 'Rahimyar Khan', 10000, 1),
(5624, 193, 3174, 'Capiata', 10000, 1),
(5625, 193, 3170, 'Ciudad Del Este', 10000, 1),
(5626, 193, 3174, 'Fernando De La Mora', 10000, 1),
(5627, 193, 3174, 'Lambare', 10000, 1),
(5628, 193, 3174, 'Limpio', 10000, 1),
(5629, 193, 3174, 'Luque', 10000, 1),
(5631, 193, 3174, 'Mariano Roque Alonso', 10000, 1),
(5632, 193, 3182, 'San Lorenzo', 10000, 1),
(5633, 193, 3174, 'Villa Elisa', 10000, 1),
(5634, 259, 4542, 'Acarigua', 10000, 1),
(5635, 259, 4528, 'Achaguas', 10000, 1),
(5636, 259, 4543, 'Agua Blanca', 10000, 1),
(5637, 259, 4537, 'Altagracia De Orituco', 10000, 1),
(5638, 259, 4536, 'Amuay', 10000, 1),
(5639, 259, 4527, 'Anaco', 10000, 1),
(5640, 259, 4545, 'Apartaderos', 10000, 1),
(5641, 259, 4543, 'Araure', 10000, 1),
(5642, 259, 4548, 'Bachaquero', 10000, 1),
(5643, 259, 4530, 'Barinas', 10000, 1),
(5644, 259, 4529, 'Bejuma', 10000, 1),
(5645, 259, 4546, 'Bocono', 10000, 1),
(5646, 259, 4528, 'Bruzual', 10000, 1),
(5647, 259, 4538, 'Cabudare', 10000, 1),
(5648, 259, 4537, 'Calabozo', 10000, 1),
(5649, 259, 4529, 'Camatagua', 10000, 1),
(5651, 259, 4526, 'Capacho', 10000, 1),
(5652, 259, 5061, 'Caraballeda', 10000, 1),
(5653, 259, 4541, 'Caripe', 10000, 1),
(5654, 259, 4538, 'Carora', 10000, 1),
(5655, 259, 4541, 'Carrizales', 10000, 1),
(5656, 259, 4544, 'Carupano', 10000, 1),
(5657, 259, 4540, 'Catia La Mar', 10000, 1),
(5658, 259, 4540, 'Charallave', 10000, 1),
(5660, 259, 4547, 'Chivacoa', 10000, 1),
(5661, 259, 4548, 'Ciudad Ojeda', 10000, 1),
(5662, 259, 4548, 'Colon', 10000, 1),
(5663, 259, 4535, 'Coro', 10000, 1),
(5664, 259, 4540, 'Cua', 10000, 1),
(5665, 259, 4536, 'Cumarebo', 10000, 1),
(5666, 259, 4539, 'Ejido', 10000, 1),
(5667, 259, 4531, 'El Callao', 10000, 1),
(5668, 259, 4533, 'El Junquito', 10000, 1),
(5669, 259, 4527, 'El Palito', 10000, 1),
(5670, 259, 4537, 'El Sombrero', 10000, 1),
(5672, 259, 4527, 'El Tigrito', 10000, 1),
(5673, 259, 4538, 'El Tocuyo', 10000, 1),
(5674, 259, 4536, 'El Vigia', 10000, 1),
(5675, 259, 4528, 'Elorza', 10000, 1),
(5676, 259, 4543, 'Guanare', 10000, 1),
(5677, 259, 4528, 'Guasdualito', 10000, 1),
(5680, 259, 4536, 'Judibana', 10000, 1),
(5681, 259, 4541, 'La Asuncion', 10000, 1),
(5682, 259, 4545, 'La Fria', 10000, 1),
(5683, 259, 5061, 'La Guaira', 10000, 1),
(5684, 259, 4548, 'Lagunillas', 10000, 1),
(5685, 259, 4530, 'Las Morochas', 10000, 1),
(5686, 259, 4542, 'Las Piedras', 10000, 1),
(5688, 259, 4548, 'Machiques', 10000, 1),
(5689, 259, 5061, 'Macuto', 10000, 1),
(5690, 259, 5061, 'Maiquetia', 10000, 1),
(5691, 259, 4528, 'Mantecal', 10000, 1),
(5692, 259, 4539, 'Merida', 10000, 1),
(5693, 259, 4545, 'Michelena', 10000, 1),
(5694, 259, 4539, 'Mucuchies', 10000, 1),
(5695, 259, 4540, 'Ocumare Del Tuy', 10000, 1),
(5696, 259, 4542, 'Pampatar', 10000, 1),
(5697, 259, 5061, 'Piedra Azul', 10000, 1),
(5698, 259, 4536, 'Piritu', 10000, 1),
(5699, 259, 4542, 'Porlamar', 10000, 1),
(5700, 259, 4526, 'Puerto Ayacucho', 10000, 1),
(5701, 259, 4536, 'Puerto Escondido', 10000, 1),
(5702, 259, 4531, 'Puertp Ordaz', 10000, 1),
(5703, 259, 4527, 'Puerto Piritu', 10000, 1),
(5704, 259, 4536, 'Punta Cardon', 10000, 1),
(5705, 259, 4541, 'Punta de Mata', 10000, 1),
(5706, 259, 4544, 'Punta de Piedras', 10000, 1),
(5707, 259, 4540, 'Punto Fijo', 10000, 1),
(5708, 259, 4538, 'Quibor', 10000, 1),
(5709, 259, 4545, 'Rubio', 10000, 1),
(5710, 259, 4546, 'San Antonio', 10000, 1),
(5711, 259, 4545, 'San Antonio Del Tachira', 10000, 1),
(5712, 259, 4526, 'San Carlos', 10000, 1),
(5713, 259, 4529, 'San Casimiro', 10000, 1),
(5714, 259, 4545, 'San Cristobal', 10000, 1),
(5715, 259, 4532, 'San Diego', 10000, 1),
(5716, 259, 4547, 'San Felipe', 10000, 1),
(5717, 259, 4545, 'San Felix', 10000, 1),
(5718, 259, 4528, 'San Fernando', 10000, 1),
(5719, 259, 4528, 'San Fernando de Apure', 10000, 1),
(5720, 259, 4529, 'San Juan de Los Morros', 10000, 1),
(5721, 259, 4527, 'San Mateo', 10000, 1),
(5722, 259, 4529, 'San Sebastian', 10000, 1),
(5723, 259, 4526, 'Santa Barbara', 10000, 1),
(5724, 259, 4548, 'Santa Rita', 10000, 1),
(5725, 259, 4530, 'Santa Rosa', 10000, 1),
(5727, 259, 4548, 'Tamare', 10000, 1),
(5728, 259, 4545, 'Tariba', 10000, 1),
(5730, 259, 4548, 'Tia Juana', 10000, 1),
(5731, 259, 4533, 'Tinaquillo', 10000, 1),
(5732, 259, 4544, 'Tocuyito', 10000, 1),
(5733, 259, 4546, 'Trujillo', 10000, 1),
(5734, 259, 4534, 'Tucupita', 10000, 1),
(5735, 259, 4544, 'Turen', 10000, 1),
(5736, 259, 4526, 'Turmero', 10000, 1),
(5737, 259, 4531, 'Upata', 10000, 1),
(5738, 259, 4545, 'Urena', 10000, 1),
(5739, 259, 4546, 'Valera', 10000, 1),
(5740, 259, 4537, 'Valle De La Pascua', 10000, 1),
(5741, 259, 4547, 'Yaritagua', 10000, 1),
(5742, 259, 4537, 'Zaraza', 10000, 1),
(5743, 243, 4054, 'Biche', 10000, 1),
(5744, 243, 4058, 'Blanchisseuse', 10000, 1),
(5745, 243, 4058, 'Brasso Seco Village', 10000, 1),
(5746, 243, 4056, 'Caigual', 10000, 1),
(5747, 243, 4056, 'Carmichael', 10000, 1),
(5749, 243, 4061, 'Charlotteville', 10000, 1),
(5750, 243, 4052, 'Charuma', 10000, 1),
(5751, 243, 4056, 'Cheeyou', 10000, 1),
(5752, 243, 4052, 'Coryal', 10000, 1),
(5753, 243, 4054, 'Cuche', 10000, 1),
(5754, 243, 4056, 'Cunaripa', 10000, 1),
(5755, 243, 4059, 'Erin', 10000, 1),
(5756, 243, 4054, 'Fonrose', 10000, 1),
(5757, 243, 4057, 'Grande Riviere', 10000, 1),
(5758, 243, 4056, 'Guaico Tamana', 10000, 1),
(5759, 243, 4056, 'Hasnalli', 10000, 1),
(5760, 243, 4056, 'Howson', 10000, 1),
(5761, 243, 4058, 'Las Cuevas', 10000, 1),
(5762, 243, 4056, 'Lower Fishing Pond', 10000, 1),
(5763, 243, 4056, 'Mamon', 10000, 1),
(5764, 243, 4058, 'Maracas Bay Village', 10000, 1),
(5765, 243, 4057, 'Matelot', 10000, 1),
(5766, 243, 4056, 'Matura', 10000, 1),
(5767, 243, 4062, 'Mayo', 10000, 1),
(5768, 243, 4057, 'Monte Video', 10000, 1),
(5769, 243, 4062, 'Moruga', 10000, 1),
(5770, 243, 4056, 'Mount Harris', 10000, 1),
(5771, 243, 4054, 'Navet', 10000, 1),
(5772, 243, 4056, 'Nestor', 10000, 1),
(5774, 243, 4053, 'Pierreville', 10000, 1),
(5775, 243, 4062, 'Plaisance', 10000, 1),
(5776, 243, 4056, 'Plum Mitan', 10000, 1),
(5777, 243, 4061, 'Plymouth', 10000, 1),
(5779, 243, 4054, 'Poole', 10000, 1),
(5780, 243, 4057, 'Redhead', 10000, 1),
(5781, 243, 4061, 'Roxborough', 10000, 1),
(5782, 243, 4053, 'Rushville', 10000, 1),
(5783, 243, 4056, 'Salybia', 10000, 1),
(5784, 243, 4057, 'Sans Souci', 10000, 1),
(5785, 243, 4061, 'Scarborough', 10000, 1),
(5786, 243, 4058, 'Saint Joseph', 10000, 1),
(5788, 243, 4057, 'Toco', 10000, 1),
(5789, 243, 4054, 'Unis', 10000, 1),
(5790, 243, 4056, 'Upper Fishing Pond', 10000, 1),
(5791, 243, 4056, 'Upper Manzanilla', 10000, 1),
(5793, 43, 36, 'Banff', 10000, 1),
(5794, 43, 36, 'Calgary', 10000, 1),
(5795, 43, 36, 'Cold Lake', 10000, 1),
(5796, 43, 36, 'Coronation', 10000, 1),
(5797, 43, 36, 'Fort Chipeyan', 10000, 1),
(5798, 43, 36, 'Fort McMurray', 10000, 1),
(5799, 43, 36, 'Grande Prairie', 10000, 1),
(5800, 43, 36, 'High Level', 10000, 1),
(5801, 43, 36, 'Jasper', 10000, 1),
(5802, 43, 36, 'Lac La Biche', 10000, 1),
(5803, 43, 36, 'Lethbridge', 10000, 1),
(5804, 43, 36, 'Lloydminster', 10000, 1),
(5805, 43, 36, 'Medicine Hat', 10000, 1),
(5806, 43, 36, 'Peace River', 10000, 1),
(5807, 43, 36, 'Red Deer', 10000, 1),
(5808, 43, 36, 'Rocky Mountain House', 10000, 1),
(5809, 43, 36, 'Slave Lake', 10000, 1),
(5810, 43, 36, 'Wainwright', 10000, 1),
(5811, 43, 36, 'Whitecourt', 10000, 1),
(5812, 43, 43, 'Abbotsford', 10000, 1),
(5813, 43, 43, 'Atlin', 10000, 1),
(5814, 43, 43, 'Campbell River', 10000, 1),
(5815, 43, 43, 'Castlegar', 10000, 1),
(5816, 43, 43, 'Comox', 10000, 1),
(5817, 43, 43, 'Fort St John', 10000, 1),
(5818, 43, 43, 'Kelowna', 10000, 1),
(5819, 43, 43, 'Nanaimo', 10000, 1),
(5820, 43, 43, 'Penticton', 10000, 1),
(5821, 43, 43, 'Prince George', 10000, 1),
(5822, 43, 43, 'Smithers', 10000, 1),
(5823, 43, 43, 'Terrace', 10000, 1),
(5824, 43, 43, 'Victoria', 10000, 1),
(5825, 43, 43, 'Williams Lake', 10000, 1),
(5826, 253, 5392, 'Bath', 10000, 1),
(5827, 253, 5392, 'Benson', 10000, 1),
(5832, 253, 5392, 'Chatham', 10000, 1),
(5833, 253, 5392, 'Derby', 10000, 1),
(5834, 253, 5392, 'Dover', 10000, 1),
(5835, 253, 5392, 'Exeter', 10000, 1),
(5836, 253, 5392, 'Falmouth', 10000, 1),
(5837, 253, 5392, 'Hull End', 10000, 1),
(5838, 253, 5392, 'Ipswich', 10000, 1),
(5840, 253, 5392, 'Lincoln', 10000, 1),
(5844, 253, 5392, 'Middlesbrough', 10000, 1),
(5845, 253, 5389, 'Newcastle', 10000, 1),
(5847, 253, 5392, 'Nottingham', 10000, 1),
(5848, 253, 5392, 'Peterborough', 10000, 1),
(5850, 253, 5392, 'Shrewsbury', 10000, 1),
(5851, 253, 5392, 'Teeside', 10000, 1),
(5852, 253, 5392, 'Waddington', 10000, 1),
(5853, 253, 5392, 'Warrington', 10000, 1),
(5854, 253, 5392, 'Wimbledon', 10000, 1),
(5855, 43, 38, 'Churchill', 10000, 1),
(5856, 43, 38, 'Dauphin', 10000, 1),
(5857, 43, 38, 'Island Lake', 10000, 1),
(5858, 43, 38, 'Pilot Mound', 10000, 1),
(5859, 43, 38, 'Portage', 10000, 1),
(5860, 43, 38, 'Steinbach', 10000, 1),
(5861, 43, 38, 'Thompson', 10000, 1),
(5862, 43, 42, 'Chatham', 10000, 1),
(5863, 43, 42, 'Edmundston', 10000, 1),
(5864, 43, 42, 'Saint Stephen', 10000, 1),
(5865, 43, 41, 'Deer Lake', 10000, 1),
(5866, 43, 41, 'Gander', 10000, 1),
(5867, 43, 41, 'Goose Bay', 10000, 1),
(5869, 43, 41, 'Wabush', 10000, 1),
(5870, 43, 46, 'Inuvik', 10000, 1),
(5871, 43, 4996, 'Iqaluit', 10000, 1),
(5873, 43, 39, 'Amherst', 10000, 1),
(5874, 43, 39, 'Bridgewater', 10000, 1),
(5875, 43, 39, 'Digby', 10000, 1),
(5876, 43, 39, 'Kentville', 10000, 1),
(5877, 43, 39, 'New Glasgow', 10000, 1),
(5878, 43, 39, 'Port Hawksbury', 10000, 1),
(5879, 43, 39, 'Sydney', 10000, 1),
(5880, 43, 39, 'Truro', 10000, 1),
(5881, 43, 39, 'Yarmouth', 10000, 1),
(5882, 43, 37, 'Antrim', 10000, 1),
(5883, 43, 37, 'Arnprior', 10000, 1),
(5884, 43, 37, 'Belleville', 10000, 1),
(5885, 43, 37, 'Brantford', 10000, 1),
(5886, 43, 37, 'Burk''s Falls', 10000, 1),
(5887, 43, 37, 'Cobalt', 10000, 1),
(5888, 43, 37, 'Cornwall', 10000, 1),
(5889, 43, 37, 'Deep River', 10000, 1),
(5890, 43, 37, 'Dryden', 10000, 1),
(5891, 43, 37, 'Eganville', 10000, 1),
(5892, 43, 37, 'Grand Bend', 10000, 1),
(5893, 43, 37, 'Hawkesbury', 10000, 1),
(5894, 43, 37, 'Huntsville', 10000, 1),
(5895, 43, 37, 'Kemptville', 10000, 1),
(5896, 43, 37, 'Kenora', 10000, 1),
(5897, 43, 37, 'Kirkland Lake', 10000, 1),
(5898, 43, 37, 'Kitchener', 10000, 1),
(5899, 43, 37, 'Lindsay', 10000, 1),
(5900, 43, 37, 'London', 10000, 1),
(5901, 43, 37, 'Maniwaki', 10000, 1),
(5902, 43, 37, 'Mattawa', 10000, 1),
(5903, 43, 37, 'Moosonee', 10000, 1),
(5904, 43, 37, 'Niagara Falls', 10000, 1),
(5905, 43, 37, 'North Bay', 10000, 1),
(5906, 43, 37, 'Ottawa', 10000, 1),
(5907, 43, 37, 'Pembroke', 10000, 1),
(5908, 43, 37, 'Port Dover', 10000, 1),
(5909, 43, 37, 'Port Stanley', 10000, 1),
(5910, 43, 37, 'Powassan', 10000, 1),
(5911, 43, 37, 'Renfrew', 10000, 1),
(5913, 43, 37, 'South River', 10000, 1),
(5914, 43, 37, 'St. Catharines', 10000, 1),
(5915, 43, 37, 'Saint Thomas', 10000, 1),
(5916, 43, 37, 'Sturgeon Falls', 10000, 1),
(5917, 43, 37, 'Sudbury', 10000, 1),
(5919, 43, 37, 'Timmins', 10000, 1),
(5920, 43, 37, 'Trenton', 10000, 1),
(5921, 43, 37, 'Upsula', 10000, 1),
(5922, 43, 37, 'White River', 10000, 1),
(5923, 43, 37, 'Whitney', 10000, 1),
(5924, 43, 37, 'Windsor', 10000, 1),
(5925, 43, 45, 'Summerside', 10000, 1),
(5926, 43, 35, 'Bagotville', 10000, 1),
(5928, 43, 35, 'Chibougamau', 10000, 1),
(5929, 43, 35, 'Chicoutimi', 10000, 1),
(5930, 43, 35, 'Hull', 10000, 1),
(5932, 43, 35, 'Kuujjuaq', 10000, 1),
(5934, 43, 35, 'La Tuque', 10000, 1),
(5935, 43, 35, 'Mont-Joli', 10000, 1),
(5936, 43, 35, 'Mont-laurier', 10000, 1),
(5938, 43, 35, 'Saint-Jovite', 10000, 1),
(5939, 43, 35, 'Sept-Iles', 10000, 1),
(5940, 43, 35, 'Sherbrooke', 10000, 1),
(5941, 43, 35, 'Temiscaming', 10000, 1),
(5942, 43, 35, 'Thetford Mines', 10000, 1),
(5944, 43, 35, 'Val-d''Or', 10000, 1),
(5945, 43, 40, 'Moose Jaw', 10000, 1),
(5946, 43, 40, 'Saskatoon', 10000, 1),
(5947, 253, 5390, 'Aberdeen', 10000, 1),
(5948, 253, 5390, 'Aviemore', 10000, 1),
(5949, 253, 5390, 'Cladich', 10000, 1),
(5950, 253, 5390, 'Glasgow', 10000, 1),
(5951, 253, 5390, 'Hawick', 10000, 1),
(5952, 253, 5390, 'Kirkwall', 10000, 1),
(5953, 253, 5390, 'Loch Ness', 10000, 1),
(5954, 253, 5390, 'Motherwell', 10000, 1),
(5955, 253, 5390, 'St Andrews', 10000, 1),
(5956, 253, 5390, 'Wick', 10000, 1),
(5957, 253, 5389, 'Cardiff', 10000, 1),
(5958, 253, 5389, 'Holyhead', 10000, 1),
(5959, 253, 5389, 'Milford', 10000, 1),
(5960, 253, 5389, 'Swansea', 10000, 1),
(5961, 253, 5389, 'Wrexham', 10000, 1),
(5963, 43, 815, 'Beaver Creek', 10000, 1),
(5964, 43, 815, 'Burwash', 10000, 1),
(5965, 43, 815, 'Carmacks', 10000, 1),
(5966, 43, 815, 'Dawson City', 10000, 1),
(5967, 43, 815, 'Faro', 10000, 1),
(5969, 43, 815, 'Mayo', 10000, 1),
(5970, 43, 815, 'Old Crow', 10000, 1),
(5971, 43, 815, 'Ross River', 10000, 1),
(5972, 43, 815, 'Snag', 10000, 1),
(5973, 43, 815, 'Teslin', 10000, 1),
(5974, 43, 815, 'Watson Lake', 10000, 1),
(5975, 43, 815, 'Whitehorse', 10000, 1),
(5976, 1, 835, 'Kabul', 10000, 1),
(5977, 2, 1011, 'Tirane', 10000, 1),
(5978, 3, 856, 'Algiers', 10000, 1),
(5979, 3, 879, 'Annaba', 10000, 1),
(5980, 3, 861, 'Oran', 10000, 1),
(5981, 3, 858, 'Skikda', 10000, 1),
(5982, 6, 1046, 'Luanda', 10000, 1),
(5983, 9, 818, 'Saint Johns', 10000, 1),
(5984, 10, 1066, 'Bariloche', 10000, 1),
(5985, 10, 1071, 'Ceres', 10000, 1),
(5986, 10, 1058, 'Concordia', 10000, 1),
(5987, 10, 1058, 'Gualeguaychu', 10000, 1),
(5988, 10, 1063, 'Malarg', 10000, 1),
(5989, 10, 1055, 'Marcos Ju', 10000, 1),
(5990, 10, 1063, 'Mendoza', 10000, 1),
(5991, 10, 1056, 'Paso de los Libres', 10000, 1),
(5992, 10, 1071, 'Reconquista ', 10000, 1),
(5993, 10, 1071, 'Rosario', 10000, 1),
(5994, 10, 1060, 'San Rafael', 10000, 1),
(5995, 10, 1072, 'Santiago del Estero', 10000, 1),
(5996, 10, 1054, 'Trelew', 10000, 1),
(5998, 12, 549, 'Oranjestad', 10000, 1),
(5999, 14, 7, 'Alice Springs', 10000, 1),
(6001, 14, 3, 'Birdsville', 10000, 1),
(6002, 14, 3, 'Boulia', 10000, 1),
(6003, 14, 3, 'Bowen', 10000, 1),
(6004, 14, 6, 'Broome', 10000, 1),
(6005, 14, 1, 'Cape Otway', 10000, 1),
(6006, 14, 3, 'Charleville', 10000, 1),
(6007, 14, 4, 'Cobar', 10000, 1),
(6008, 14, 4, 'Coffs Harbour', 10000, 1),
(6009, 14, 3, 'Cunnamulla', 10000, 1),
(6010, 14, 1, 'Sale', 10000, 1),
(6011, 14, 6, 'Exmouth', 10000, 1),
(6012, 14, 2, 'George Town', 10000, 1),
(6013, 14, 6, 'Geraldton', 10000, 1),
(6015, 14, 3, 'Gladstone', 10000, 1),
(6016, 14, 6, 'Kalgoorlie', 10000, 1),
(6017, 14, 2, 'Launceston', 10000, 1),
(6018, 14, 5, 'Mount Gambier', 10000, 1),
(6019, 14, 3, 'Mount Isa', 10000, 1),
(6021, 14, 4, 'Nowra', 10000, 1),
(6022, 14, 5, 'Oodnadatta', 10000, 1),
(6023, 14, 3, 'Richmond', 10000, 1),
(6024, 14, 3, 'Roma', 10000, 1),
(6025, 14, 2, 'Strahan', 10000, 1),
(6026, 14, 7, 'Tennant Creek', 10000, 1),
(6027, 14, 3, 'Townsville', 10000, 1),
(6028, 14, 6, 'Williamstown', 10000, 1),
(6030, 14, 1, 'Wilsons Promontory', 10000, 1),
(6031, 14, 3, 'Windorah', 10000, 1),
(6032, 14, 5, 'Woomera', 10000, 1),
(6033, 15, 1081, 'Innsbruck', 10000, 1),
(6034, 15, 1083, 'Vienna', 10000, 1),
(6035, 18, 1085, 'Al Manamah', 10000, 1),
(6036, 20, 1162, 'Dhaka', 10000, 1),
(6037, 24, 1129, 'Antwerp', 10000, 1),
(6038, 24, 1136, 'Gent', 10000, 1),
(6039, 24, 1132, 'Liege', 10000, 1),
(6040, 25, 1165, 'Belize City', 10000, 1),
(6041, 26, 1201, 'Porto-Novo', 10000, 1),
(6042, 27, 1119, 'Hamilton', 10000, 1),
(6043, 27, 1125, 'Somerset', 10000, 1),
(6044, 27, 1124, 'Saint George', 10000, 1),
(6045, 29, 1174, 'La Paz', 10000, 1),
(6046, 30, 5116, 'Sarajevo', 10000, 1),
(6047, 33, 21, 'Barra do Corda', 10000, 1),
(6048, 33, 11, 'Barreiras', 10000, 1),
(6049, 33, 13, 'Caravelas', 10000, 1),
(6050, 33, 12, 'Catal', 10000, 1),
(6051, 33, 15, 'Curitiba', 10000, 1),
(6053, 33, 12, 'Goi', 10000, 1),
(6054, 33, 11, 'Ilh', 10000, 1),
(6055, 33, 13, 'Parna', 10000, 1),
(6056, 33, 24, 'Pirapora', 10000, 1),
(6057, 33, 25, 'Porto Nacional', 10000, 1),
(6059, 33, 34, 'Santa Cruz', 10000, 1),
(6060, 33, 1219, 'Santar', 10000, 1),
(6061, 33, 24, 'Santos', 10000, 1),
(6062, 33, 14, 'Sobral', 10000, 1),
(6063, 33, 33, 'Tr', 10000, 1),
(6064, 33, 27, 'Uberaba', 10000, 1),
(6065, 37, 1245, 'Ruse', 10000, 1),
(6066, 40, 1252, 'Bujumbura', 10000, 1),
(6067, 41, 1277, 'Phnom Penh', 10000, 1),
(6068, 42, 1391, 'Yaounde', 10000, 1),
(6069, 45, 1380, 'George Town', 10000, 1),
(6070, 46, 1445, 'Bangui', 10000, 1),
(6072, 49, 1351, 'Abag Qi', 10000, 1),
(6073, 49, 1340, 'Aihui', 10000, 1),
(6074, 49, 1353, 'Akqi', 10000, 1),
(6075, 49, 586, 'Alar', 10000, 1),
(6076, 49, 1345, 'Altay', 10000, 1),
(6077, 49, 1340, 'Anda', 10000, 1),
(6078, 49, 586, 'Andir', 10000, 1),
(6079, 49, 1357, 'Ankang', 10000, 1),
(6080, 49, 1333, 'Anqing', 10000, 1),
(6081, 49, 1348, 'Anyang', 10000, 1),
(6082, 49, 1345, 'Arxan', 10000, 1),
(6083, 49, 1345, 'Bachu', 10000, 1),
(6084, 49, 1350, 'Baiang', 10000, 1),
(6085, 49, 586, 'Bailing-Miao', 10000, 1),
(6086, 49, 1346, 'Baingoin', 10000, 1),
(6087, 49, 1345, 'Balguntay', 10000, 1),
(6088, 49, 1357, 'Baoji', 10000, 1),
(6089, 49, 1353, 'Baoshan', 10000, 1),
(6090, 49, 1358, 'Barkam', 10000, 1),
(6091, 49, 1351, 'Bayan Mod', 10000, 1),
(6092, 49, 1345, 'Bayanbulak', 10000, 1),
(6093, 49, 586, 'Baytik Shan', 10000, 1),
(6094, 49, 1349, 'Bijie', 10000, 1),
(6095, 49, 1333, 'Bose', 10000, 1),
(6096, 49, 1351, 'Bugt', 10000, 1),
(6097, 49, 586, 'Chabgling', 10000, 1),
(6098, 49, 1334, 'Changbai', 10000, 1),
(6099, 49, 1343, 'Changde', 10000, 1),
(6100, 49, 1339, 'Changting', 10000, 1),
(6101, 49, 1361, 'Chaoyang', 10000, 1),
(6102, 49, 1342, 'Chengde', 10000, 1),
(6103, 49, 586, 'Chengshantou', 10000, 1),
(6104, 49, 1361, 'Chenzhou', 10000, 1),
(6105, 49, 1351, 'Chifeng', 10000, 1),
(6106, 49, 1360, 'Chuxiong', 10000, 1),
(6107, 49, 586, 'Da Xian', 10000, 1),
(6108, 49, 586, 'Dachen Dao', 10000, 1),
(6109, 49, 1334, 'Dali', 10000, 1),
(6110, 49, 1362, 'Danxian', 10000, 1),
(6111, 49, 586, 'Daocheng', 10000, 1),
(6112, 49, 586, 'Da-Qaidam', 10000, 1),
(6113, 49, 1338, 'Darlag', 10000, 1),
(6115, 49, 1358, 'Dawu', 10000, 1),
(6116, 49, 586, 'Dege', 10000, 1),
(6117, 49, 1338, 'Delingha', 10000, 1),
(6118, 49, 1346, 'Dengqen', 10000, 1),
(6119, 49, 1346, 'Deqen', 10000, 1),
(6120, 49, 1334, 'Dinghai', 10000, 1),
(6121, 49, 1334, 'Dongfang', 10000, 1),
(6122, 49, 1361, 'Dongsha Dao', 10000, 1),
(6123, 49, 1334, 'Dongsheng', 10000, 1),
(6124, 49, 1338, 'Dulan', 10000, 1),
(6125, 49, 1337, 'Dunhua', 10000, 1),
(6126, 49, 1347, 'Dunhuang', 10000, 1),
(6127, 49, 1351, 'Duolun', 10000, 1),
(6128, 49, 1348, 'Dushan', 10000, 1),
(6129, 49, 1351, 'Ejin Qi', 10000, 1),
(6130, 49, 586, 'Emei Shan', 10000, 1),
(6131, 49, 1344, 'Enshi', 10000, 1),
(6132, 49, 1351, 'Erenhot', 10000, 1),
(6133, 49, 1344, 'Fangxian', 10000, 1),
(6134, 49, 1358, 'Fengjie', 10000, 1),
(6135, 49, 1342, 'Fengning', 10000, 1),
(6136, 49, 1361, 'Fogang', 10000, 1),
(6137, 49, 1339, 'Fuding', 10000, 1),
(6138, 49, 1340, 'Fujin', 10000, 1),
(6139, 49, 1358, 'Fuyang', 10000, 1),
(6140, 49, 1345, 'Fuyun', 10000, 1),
(6141, 49, 1338, 'Gangca', 10000, 1),
(6142, 49, 1347, 'Ganzhou', 10000, 1),
(6143, 49, 1333, 'Gaoyao', 10000, 1),
(6144, 49, 1358, 'Garze', 10000, 1),
(6145, 49, 1338, 'Golmud', 10000, 1),
(6146, 49, 1351, 'Guaizihu', 10000, 1),
(6147, 49, 1335, 'Guangchang', 10000, 1),
(6148, 49, 1360, 'Guangnan', 10000, 1),
(6149, 49, 1348, 'Guiping', 10000, 1),
(6150, 49, 1334, 'Gushi', 10000, 1),
(6151, 49, 1351, 'Hailar', 10000, 1),
(6152, 49, 1351, 'Hails', 10000, 1),
(6153, 49, 1334, 'Haiyang', 10000, 1),
(6154, 49, 586, 'Haiyang Dao', 10000, 1),
(6155, 49, 1351, 'Haliut', 10000, 1),
(6156, 49, 1345, 'Hami', 10000, 1),
(6157, 49, 1348, 'Hechi', 10000, 1),
(6158, 49, 1349, 'Henan', 10000, 1),
(6159, 49, 1355, 'Hequ', 10000, 1),
(6160, 49, 1361, 'Heyuan', 10000, 1),
(6161, 49, 1334, 'Hezuo', 10000, 1),
(6162, 49, 1345, 'Hoboksar', 10000, 1),
(6164, 49, 1345, 'Hotan', 10000, 1),
(6165, 49, 586, 'Hua Shan', 10000, 1),
(6166, 49, 1351, 'Huade', 10000, 1),
(6167, 49, 1356, 'Huadian', 10000, 1),
(6168, 49, 1342, 'Huailai', 10000, 1),
(6169, 49, 1347, 'Huajialing', 10000, 1),
(6170, 49, 1333, 'Huang Shan', 10000, 1),
(6171, 49, 1351, 'Huhhot', 10000, 1),
(6172, 49, 1358, 'Huili', 10000, 1),
(6173, 49, 1356, 'Huimin', 10000, 1),
(6174, 49, 1348, 'Huize', 10000, 1),
(6175, 49, 1340, 'Hulin', 10000, 1),
(6176, 49, 1340, 'Huma', 10000, 1),
(6177, 49, 1333, 'Huoshan', 10000, 1),
(6178, 49, 1351, 'Jartai', 10000, 1),
(6179, 49, 1351, 'Jarud Qi', 10000, 1),
(6180, 49, 586, 'Jian', 10000, 1),
(6181, 49, 586, 'Jiangchen', 10000, 1),
(6182, 49, 1344, 'Jiangling', 10000, 1),
(6183, 49, 1355, 'Jiexiu', 10000, 1),
(6184, 49, 1335, 'Jingdezhen', 10000, 1),
(6185, 49, 1336, 'Jinghe', 10000, 1),
(6186, 49, 1360, 'Jinghong', 10000, 1),
(6187, 49, 1356, 'Jining', 10000, 1),
(6188, 49, 1350, 'Jinnzhou', 10000, 1),
(6189, 49, 1358, 'Jiulong', 10000, 1),
(6190, 49, 1347, 'Jiuquan', 10000, 1),
(6191, 49, 586, 'Jiuxian Shan', 10000, 1),
(6192, 49, 1353, 'Jixi', 10000, 1),
(6193, 49, 1351, 'Jurh', 10000, 1),
(6194, 49, 586, 'Kaba He', 10000, 1),
(6195, 49, 1358, 'Kangding', 10000, 1),
(6196, 49, 1345, 'Karamay', 10000, 1),
(6197, 49, 1345, 'Kashi', 10000, 1),
(6198, 49, 1340, 'Keshan', 10000, 1),
(6199, 49, 1345, 'Korla', 10000, 1),
(6200, 49, 1350, 'Kuandian', 10000, 1),
(6201, 49, 1345, 'Kuqa', 10000, 1),
(6202, 49, 586, 'Lan Yu', 10000, 1),
(6203, 49, 1360, 'Lancang', 10000, 1),
(6204, 49, 1358, 'Langzhong', 10000, 1),
(6205, 49, 1347, 'Lanzhou', 10000, 1),
(6206, 49, 1338, 'Lenghu', 10000, 1),
(6207, 49, 1342, 'Leting', 10000, 1),
(6208, 49, 1352, 'Lhasa', 10000, 1),
(6209, 49, 1354, 'Lhunze', 10000, 1),
(6210, 49, 586, 'Lian Xian', 10000, 1),
(6211, 49, 1358, 'Liangping', 10000, 1),
(6212, 49, 1361, 'Lianping', 10000, 1),
(6214, 49, 1348, 'Lijiang', 10000, 1),
(6215, 49, 1360, 'Lincang', 10000, 1),
(6216, 49, 1348, 'Lindong', 10000, 1),
(6217, 49, 1343, 'Lingling', 10000, 1),
(6218, 49, 1358, 'Linjiang', 10000, 1),
(6219, 49, 1342, 'Linxi', 10000, 1),
(6220, 49, 1356, 'Linyi', 10000, 1),
(6221, 49, 1358, 'Lishi', 10000, 1),
(6222, 49, 1361, 'Lishui', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(6223, 49, 1334, 'Liyang', 10000, 1),
(6224, 49, 1334, 'Longkou', 10000, 1),
(6225, 49, 1348, 'Longzhou', 10000, 1),
(6226, 49, 586, 'Lu Shan', 10000, 1),
(6227, 49, 1334, 'Luodian', 10000, 1),
(6228, 49, 1360, 'Lushi', 10000, 1),
(6229, 49, 1360, 'Lusi', 10000, 1),
(6230, 49, 1360, 'Luxi', 10000, 1),
(6231, 49, 1361, 'Luzhou', 10000, 1),
(6232, 49, 1344, 'Macheng', 10000, 1),
(6233, 49, 1333, 'Madoi', 10000, 1),
(6234, 49, 1351, 'Mandal', 10000, 1),
(6235, 49, 1338, 'Mangnai', 10000, 1),
(6236, 49, 586, 'Mazong Shan', 10000, 1),
(6237, 49, 1353, 'Mazu', 10000, 1),
(6238, 49, 1341, 'Mengjin', 10000, 1),
(6239, 49, 1334, 'Mengla', 10000, 1),
(6240, 49, 1348, 'Mengshan', 10000, 1),
(6241, 49, 1360, 'Mengzi', 10000, 1),
(6242, 49, 1344, 'Mianyang', 10000, 1),
(6243, 49, 1347, 'Minqin', 10000, 1),
(6244, 49, 1359, 'Mohe', 10000, 1),
(6245, 49, 1340, 'Mudanjiang', 10000, 1),
(6246, 49, 1353, 'Nagqu', 10000, 1),
(6247, 49, 1339, 'Nancheng', 10000, 1),
(6248, 49, 1334, 'Nanchong', 10000, 1),
(6249, 49, 1358, 'Nanping', 10000, 1),
(6250, 49, 1334, 'Nanyang', 10000, 1),
(6251, 49, 1334, 'Nanyue', 10000, 1),
(6252, 49, 586, 'Nanzhong', 10000, 1),
(6253, 49, 1360, 'Napo', 10000, 1),
(6254, 49, 1351, 'Naran Bulag', 10000, 1),
(6255, 49, 1336, 'Neijiang', 10000, 1),
(6256, 49, 1340, 'Nenjiang', 10000, 1),
(6257, 49, 1346, 'Nyingchi', 10000, 1),
(6258, 49, 1351, 'Otog Qi', 10000, 1),
(6259, 49, 1346, 'Pagri', 10000, 1),
(6260, 49, 586, 'Pengjia Yu', 10000, 1),
(6261, 49, 1349, 'Pingliang', 10000, 1),
(6262, 49, 1339, 'Pingtan', 10000, 1),
(6263, 49, 1358, 'Pingwu', 10000, 1),
(6264, 49, 1353, 'Pishan', 10000, 1),
(6265, 49, 1353, 'Pucheng', 10000, 1),
(6266, 49, 1346, 'Qamdo', 10000, 1),
(6267, 49, 1337, 'Qian Gorlos', 10000, 1),
(6268, 49, 1345, 'Qijiaojing', 10000, 1),
(6269, 49, 1335, 'Qingjiang', 10000, 1),
(6270, 49, 1360, 'Qinglong', 10000, 1),
(6271, 49, 1342, 'Qingyuan', 10000, 1),
(6272, 49, 1348, 'Qinzhou', 10000, 1),
(6273, 49, 1362, 'Qionghai', 10000, 1),
(6274, 49, 1340, 'Qiqihar', 10000, 1),
(6275, 49, 1345, 'Qitai', 10000, 1),
(6276, 49, 1358, 'Quzian', 10000, 1),
(6277, 49, 586, 'Qumarleb', 10000, 1),
(6278, 49, 1356, 'Rizhao', 10000, 1),
(6279, 49, 1335, 'Rongjiang', 10000, 1),
(6280, 49, 1349, 'Ruili', 10000, 1),
(6281, 49, 586, 'Ruo''Ergai', 10000, 1),
(6282, 49, 1345, 'Ruoqiang', 10000, 1),
(6283, 49, 1343, 'Sangzhi', 10000, 1),
(6284, 49, 586, 'Sanhu Dao', 10000, 1),
(6285, 49, 1349, 'Sansui', 10000, 1),
(6286, 49, 586, 'Sertar', 10000, 1),
(6287, 49, 1363, 'Shache', 10000, 1),
(6288, 49, 586, 'Shangchuan Dao', 10000, 1),
(6289, 49, 1347, 'Shangzhi', 10000, 1),
(6290, 49, 1362, 'Shanwei', 10000, 1),
(6291, 49, 1353, 'Shaoguan', 10000, 1),
(6292, 49, 1339, 'Shaowu', 10000, 1),
(6293, 49, 1343, 'Shaoyang', 10000, 1),
(6294, 49, 1334, 'Shengsi', 10000, 1),
(6295, 49, 1334, 'Shengxian', 10000, 1),
(6296, 49, 1353, 'Shipu', 10000, 1),
(6297, 49, 1346, 'Shiquanhe', 10000, 1),
(6298, 49, 586, 'Simaoi', 10000, 1),
(6299, 49, 1349, 'Sinan', 10000, 1),
(6300, 49, 1349, 'Siping', 10000, 1),
(6301, 49, 1353, 'Sog Xian', 10000, 1),
(6302, 49, 1347, 'Songpan', 10000, 1),
(6303, 49, 1340, 'Suifenhe', 10000, 1),
(6304, 49, 1340, 'Sunwu', 10000, 1),
(6305, 49, 1360, 'Tacheng', 10000, 1),
(6306, 49, 586, 'Tai Shan', 10000, 1),
(6307, 49, 1340, 'Tailai', 10000, 1),
(6308, 49, 1353, 'Taiyuan', 10000, 1),
(6309, 49, 1334, 'Tangshan', 10000, 1),
(6310, 49, 1360, 'Tengchong', 10000, 1),
(6311, 49, 1359, 'Tianmu Shan', 10000, 1),
(6312, 49, 1347, 'Tianshui', 10000, 1),
(6313, 49, 1345, 'Tikanlik', 10000, 1),
(6314, 49, 1346, 'Tingri', 10000, 1),
(6315, 49, 1343, 'Tongdao', 10000, 1),
(6316, 49, 1338, 'Tongde', 10000, 1),
(6317, 49, 1359, 'Tonghe', 10000, 1),
(6318, 49, 1351, 'Tongliao', 10000, 1),
(6319, 49, 1351, 'Tulihe', 10000, 1),
(6320, 49, 586, 'Tuotouhe', 10000, 1),
(6321, 49, 1345, 'Turpan', 10000, 1),
(6322, 49, 1351, 'Uliastai', 10000, 1),
(6323, 49, 1345, 'Urumqi', 10000, 1),
(6324, 49, 1358, 'Wanyuan', 10000, 1),
(6325, 49, 1347, 'Weichang', 10000, 1),
(6326, 49, 1356, 'Weifang', 10000, 1),
(6327, 49, 1349, 'Weining', 10000, 1),
(6328, 49, 586, 'Wudaoling', 10000, 1),
(6329, 49, 1334, 'Wudu', 10000, 1),
(6330, 49, 1341, 'Wugang', 10000, 1),
(6331, 49, 586, 'Wushaoling', 10000, 1),
(6332, 49, 586, 'Wutai Shan', 10000, 1),
(6333, 49, 1348, 'Wuzhou', 10000, 1),
(6334, 49, 1346, 'Xainza', 10000, 1),
(6335, 49, 1355, 'Xi ujimqin Qi', 10000, 1),
(6336, 49, 1357, 'Xian', 10000, 1),
(6337, 49, 1348, 'Xichang', 10000, 1),
(6338, 49, 1347, 'Xifengzhen', 10000, 1),
(6339, 49, 1353, 'Xigaze', 10000, 1),
(6340, 49, 1351, 'Xilin Hot', 10000, 1),
(6341, 49, 1351, 'Xin Barag Youqi', 10000, 1),
(6342, 49, 1348, 'Xingren', 10000, 1),
(6343, 49, 1342, 'Xingtai', 10000, 1),
(6344, 49, 1338, 'Xining', 10000, 1),
(6345, 49, 1355, 'Xinxian', 10000, 1),
(6346, 49, 1348, 'Xinyang', 10000, 1),
(6347, 49, 1357, 'Xinyi', 10000, 1),
(6348, 49, 1362, 'Xisha Dao', 10000, 1),
(6349, 49, 1335, 'Xiushui', 10000, 1),
(6350, 49, 1347, 'Xunwu', 10000, 1),
(6351, 49, 586, 'Ya''an', 10000, 1),
(6352, 49, 1360, 'Yanan', 10000, 1),
(6353, 49, 1357, 'Yanchi', 10000, 1),
(6354, 49, 1336, 'Yangcheng', 10000, 1),
(6355, 49, 1334, 'Yangjiang', 10000, 1),
(6356, 49, 1344, 'Yanji', 10000, 1),
(6357, 49, 1339, 'Yanzhou', 10000, 1),
(6358, 49, 586, 'Yaxian', 10000, 1),
(6359, 49, 1358, 'Yibin', 10000, 1),
(6360, 49, 1335, 'Yichun', 10000, 1),
(6361, 49, 586, 'Yihu', 10000, 1),
(6362, 49, 1353, 'Yinchuan', 10000, 1),
(6363, 49, 1335, 'Yining', 10000, 1),
(6364, 49, 1356, 'Yiyuan', 10000, 1),
(6365, 49, 586, 'Yongan', 10000, 1),
(6366, 49, 1358, 'Youyang', 10000, 1),
(6367, 49, 586, 'Yu Xian', 10000, 1),
(6368, 49, 1343, 'Yuanjiang', 10000, 1),
(6369, 49, 1343, 'Yuanling', 10000, 1),
(6370, 49, 1360, 'Yuanmou', 10000, 1),
(6371, 49, 1355, 'Yuanping', 10000, 1),
(6372, 49, 1342, 'Yulin', 10000, 1),
(6373, 49, 1347, 'Yumenzhen', 10000, 1),
(6374, 49, 1355, 'Yuncheng', 10000, 1),
(6375, 49, 1349, 'Yushe', 10000, 1),
(6376, 49, 1338, 'Zadoi', 10000, 1),
(6377, 49, 1344, 'Zaoyang', 10000, 1),
(6378, 49, 1342, 'Zhangjiakou', 10000, 1),
(6379, 49, 1334, 'Zhangwu', 10000, 1),
(6380, 49, 1347, 'Zhangye', 10000, 1),
(6381, 49, 1361, 'Zhanjiang', 10000, 1),
(6382, 49, 1360, 'Zhanyi', 10000, 1),
(6383, 49, 1360, 'Zhaotong', 10000, 1),
(6384, 49, 1343, 'Zhijiang', 10000, 1),
(6385, 49, 1352, 'Zhongning', 10000, 1),
(6386, 49, 1344, 'Zhongxiang', 10000, 1),
(6387, 49, 1341, 'Zhumadian', 10000, 1),
(6388, 49, 586, 'Ziao''ergou', 10000, 1),
(6389, 49, 586, 'Zihua', 10000, 1),
(6390, 49, 1349, 'Zunyi', 10000, 1),
(6391, 49, 1343, 'Zuzhou', 10000, 1),
(6392, 61, 5027, 'Dubrovnik', 10000, 1),
(6393, 62, 1457, 'Havana', 10000, 1),
(6394, 63, 1486, 'Nicosia', 10000, 1),
(6395, 64, 5129, 'Ostrava', 10000, 1),
(6398, 67, 1511, 'Roseau', 10000, 1),
(6399, 68, 1534, 'Puerto Plata', 10000, 1),
(6400, 72, 1653, 'San Salvador', 10000, 1),
(6401, 75, 1629, 'Tallinn', 10000, 1),
(6402, 76, 1696, 'Addis Ababa', 10000, 1),
(6403, 81, 4879, 'Helsinki', 10000, 1),
(6404, 81, 5023, 'Turku', 10000, 1),
(6406, 82, 1808, 'Lille', 10000, 1),
(6407, 82, 1807, 'Lourdes', 10000, 1),
(6408, 82, 1812, 'Marseille', 10000, 1),
(6409, 82, 1803, 'Paris', 10000, 1),
(6410, 82, 1799, 'Reims', 10000, 1),
(6412, 82, 1813, 'Val-d''Isere', 10000, 1),
(6413, 84, 5383, 'Cayenne', 10000, 1),
(6414, 87, 1821, 'Libreville', 10000, 1),
(6415, 91, 1918, 'Bochum', 10000, 1),
(6416, 91, 1918, 'Bonn', 10000, 1),
(6417, 91, 1918, 'Dusseldorf', 10000, 1),
(6418, 91, 1918, 'Essen', 10000, 1),
(6419, 91, 1916, 'Frankfurt', 10000, 1),
(6420, 91, 1917, 'Hannover', 10000, 1),
(6421, 91, 1912, 'Heidelberg', 10000, 1),
(6422, 91, 1916, 'Kassel', 10000, 1),
(6423, 91, 1913, 'N', 10000, 1),
(6424, 95, 1972, 'Irakleion', 10000, 1),
(6425, 95, 1952, 'Kerkira', 10000, 1),
(6426, 95, 1948, 'Larisa', 10000, 1),
(6427, 95, 632, 'Limnos', 10000, 1),
(6428, 95, 1976, 'Myconos', 10000, 1),
(6429, 95, 1965, 'Patrai', 10000, 1),
(6430, 95, 1974, 'Rhodes', 10000, 1),
(6431, 95, 1962, 'Sparta', 10000, 1),
(6433, 99, 636, 'Agana', 10000, 1),
(6434, 108, 2050, 'Choluteca', 10000, 1),
(6435, 108, 2052, 'Comayagua', 10000, 1),
(6436, 108, 2059, 'La Ceiba', 10000, 1),
(6437, 108, 2053, 'Santa Rosa', 10000, 1),
(6438, 111, 2091, 'Gyor', 10000, 1),
(6439, 111, 2070, 'Miskolc', 10000, 1),
(6440, 112, 2107, 'Akureyri', 10000, 1),
(6441, 112, 2125, 'Egilsstadir', 10000, 1),
(6444, 112, 2142, 'Kirkjubaejarklaustur', 10000, 1),
(6445, 112, 2126, 'Raufarhofn', 10000, 1),
(6446, 112, 2111, 'Saudarkrokur', 10000, 1),
(6447, 112, 2128, 'Vestmannaeyjar', 10000, 1),
(6448, 113, 2175, 'Ahmedabad', 10000, 1),
(6449, 113, 2189, 'Amritsar', 10000, 1),
(6450, 113, 2181, 'Bhopal', 10000, 1),
(6451, 113, 2187, 'Bhubaneshwar', 10000, 1),
(6452, 113, 2194, 'Calcutta', 10000, 1),
(6453, 113, 2169, 'Hyderabad', 10000, 1),
(6454, 113, 2193, 'Kanpur', 10000, 1),
(6455, 113, 2193, 'Lucknow', 10000, 1),
(6456, 113, 2189, 'Ludhiana', 10000, 1),
(6457, 113, 2182, 'Mumbai', 10000, 1),
(6458, 113, 2182, 'Nagpur', 10000, 1),
(6460, 113, 2178, 'Srinagar', 10000, 1),
(6461, 113, 2179, 'Trivandrum', 10000, 1),
(6462, 114, 2145, 'Bali', 10000, 1),
(6463, 114, 2154, 'Balikpapan', 10000, 1),
(6464, 114, 2165, 'Palembang', 10000, 1),
(6465, 114, 2148, 'Semarang', 10000, 1),
(6466, 115, 2213, 'Ahvaz', 10000, 1),
(6467, 115, 2227, 'Mashhad', 10000, 1),
(6468, 115, 2230, 'Tabriz', 10000, 1),
(6469, 116, 2314, 'Baghdad', 10000, 1),
(6470, 116, 2309, 'Basra', 10000, 1),
(6471, 253, 5391, 'Armagh', 10000, 1),
(6472, 117, 1611, 'Bangor', 10000, 1),
(6474, 253, 5391, 'Omagh', 10000, 1),
(6475, 117, 1598, 'Shannon', 10000, 1),
(6476, 118, 2237, 'Jerusalem', 10000, 1),
(6477, 119, 2254, 'Bolzano', 10000, 1),
(6478, 119, 2251, 'Cagliari', 10000, 1),
(6479, 119, 2246, 'Como', 10000, 1),
(6481, 119, 2249, 'Novara', 10000, 1),
(6482, 119, 2257, 'Padova', 10000, 1),
(6483, 119, 2252, 'Palermo', 10000, 1),
(6484, 119, 2243, 'Trieste', 10000, 1),
(6485, 119, 2249, 'Turin', 10000, 1),
(6486, 119, 2257, 'Venice', 10000, 1),
(6489, 122, 2333, 'Aikawa', 10000, 1),
(6490, 122, 2337, 'Akita', 10000, 1),
(6491, 122, 2328, 'Aomori', 10000, 1),
(6493, 122, 2352, 'Fukue', 10000, 1),
(6494, 122, 659, 'Hachijojima', 10000, 1),
(6495, 122, 2337, 'Hakodate', 10000, 1),
(6496, 122, 2361, 'Hamada', 10000, 1),
(6498, 122, 2361, 'Izuhara', 10000, 1),
(6499, 122, 2326, 'Kanoya', 10000, 1),
(6500, 122, 2329, 'Komatsu', 10000, 1),
(6501, 122, 2337, 'Kushiro', 10000, 1),
(6502, 122, 2335, 'Maebashi', 10000, 1),
(6503, 122, 2347, 'Maizuru', 10000, 1),
(6504, 122, 2361, 'Matsue', 10000, 1),
(6508, 122, 2333, 'Miyako', 10000, 1),
(6509, 122, 2359, 'Miyakojima', 10000, 1),
(6511, 122, 2343, 'Naze', 10000, 1),
(6512, 122, 2355, 'Oita', 10000, 1),
(6513, 122, 2372, 'Okinawa', 10000, 1),
(6515, 122, 2339, 'Onahama', 10000, 1),
(6516, 122, 2352, 'Oshima', 10000, 1),
(6517, 122, 2348, 'Owase', 10000, 1),
(6518, 122, 2361, 'Saigo', 10000, 1),
(6520, 122, 2357, 'Suttsu', 10000, 1),
(6521, 122, 2348, 'Suzuka', 10000, 1),
(6523, 122, 2366, 'Tottori', 10000, 1),
(6524, 122, 2337, 'Urakawa', 10000, 1),
(6525, 122, 2340, 'Wajima', 10000, 1),
(6526, 122, 2352, 'Wakamatsu', 10000, 1),
(6527, 122, 2337, 'Wakkanai', 10000, 1),
(6528, 122, 2357, 'Yokota', 10000, 1),
(6529, 128, 2455, 'Karaganda', 10000, 1),
(6530, 129, 2397, 'Embu', 10000, 1),
(6531, 129, 2401, 'Kitale', 10000, 1),
(6532, 132, 2417, 'P''yongyang', 10000, 1),
(6533, 134, 2439, 'Kuwait', 10000, 1),
(6534, 138, 2484, 'Beirut', 10000, 1),
(6535, 138, 2483, 'Tripoli', 10000, 1),
(6536, 141, 2674, 'Tripoli', 10000, 1),
(6537, 143, 2572, 'Vilnius', 10000, 1),
(6538, 144, 2625, 'Luxembourg', 10000, 1),
(6539, 149, 2897, 'Johor Baharu', 10000, 1),
(6540, 149, 2911, 'Kota Kinabalu', 10000, 1),
(6542, 149, 2900, 'Malacca', 10000, 1),
(6543, 149, 2906, 'Miri', 10000, 1),
(6544, 149, 2905, 'Penang', 10000, 1),
(6545, 152, 689, 'Valletta', 10000, 1),
(6546, 155, 5376, 'Fort-De-France', 10000, 1),
(6547, 159, 2890, 'Apatzingan', 10000, 1),
(6548, 159, 73, 'Baja San Quintin', 10000, 1),
(6550, 159, 2887, 'Ciudad Acuna', 10000, 1),
(6551, 159, 2886, 'Ciudad Del Carmen', 10000, 1),
(6552, 159, 59, 'Ciudad Guzman', 10000, 1),
(6553, 159, 70, 'Ciudad Madero', 10000, 1),
(6554, 159, 72, 'Cozumel', 10000, 1),
(6555, 159, 56, 'Heroica Caborca', 10000, 1),
(6556, 159, 66, 'Ixtapa', 10000, 1),
(6557, 159, 2895, 'Jalapa', 10000, 1),
(6558, 159, 203, 'Linares', 10000, 1),
(6559, 159, 70, 'Matamoros', 10000, 1),
(6560, 159, 2887, 'Monclova', 10000, 1),
(6562, 159, 56, 'Nogales', 10000, 1),
(6563, 159, 70, 'Nuevo Laredo', 10000, 1),
(6564, 159, 60, 'Progreso', 10000, 1),
(6565, 159, 201, 'Puerto Angel', 10000, 1),
(6566, 159, 72, 'Puerto Juarez', 10000, 1),
(6567, 159, 70, 'Reynosa', 10000, 1),
(6568, 159, 2887, 'Sabinas', 10000, 1),
(6569, 159, 201, 'Salina Cruz', 10000, 1),
(6570, 159, 70, 'Tampico', 10000, 1),
(6571, 159, 66, 'Zihuatanejo', 10000, 1),
(6573, 168, 2793, 'Fez', 10000, 1),
(6574, 168, 2799, 'Marrakesh', 10000, 1),
(6575, 168, 2803, 'Oujda', 10000, 1),
(6576, 168, 2804, 'Rabat', 10000, 1),
(6577, 168, 2807, 'Tangier', 10000, 1),
(6578, 168, 2818, 'Tetouan', 10000, 1),
(6579, 169, 2915, 'Maputo', 10000, 1),
(6580, 175, 2981, 'Amsterdam', 10000, 1),
(6581, 175, 2981, 'Den Helder', 10000, 1),
(6582, 175, 2981, 'Edam', 10000, 1),
(6583, 175, 2980, 'Eindhoven', 10000, 1),
(6584, 175, 2978, 'Groningen', 10000, 1),
(6585, 175, 2976, 'Leeuwarden', 10000, 1),
(6586, 175, 2985, 'Leiden', 10000, 1),
(6587, 175, 2989, 'Lelystad', 10000, 1),
(6588, 175, 2985, 'The Hague', 10000, 1),
(6589, 175, 2983, 'Utrecht', 10000, 1),
(6590, 175, 2984, 'Vlissingen', 10000, 1),
(6592, 178, 3126, 'Invercargill', 10000, 1),
(6593, 178, 4721, 'Wellington', 10000, 1),
(6594, 180, 2926, 'Niamey', 10000, 1),
(6595, 185, 2999, 'Lillehammer', 10000, 1),
(6596, 185, 3000, 'Oslo', 10000, 1),
(6597, 186, 2851, 'Masqat', 10000, 1),
(6598, 187, 3219, 'Faisalabad', 10000, 1),
(6599, 187, 3222, 'Hyderadad', 10000, 1),
(6600, 187, 3223, 'Islamabad', 10000, 1),
(6601, 187, 3220, 'Karachi', 10000, 1),
(6602, 187, 3219, 'Rawalpindi', 10000, 1),
(6603, 190, 3293, 'Portobelo', 10000, 1),
(6604, 190, 3293, 'Rainbow City', 10000, 1),
(6605, 194, 3207, 'Piura', 10000, 1),
(6606, 195, 3516, 'Quezon', 10000, 1),
(6607, 197, 3276, 'Lodz', 10000, 1),
(6608, 198, 3311, 'Lisbon', 10000, 1),
(6609, 198, 3313, 'Oporto ', 10000, 1),
(6611, 200, 3349, 'Doha', 10000, 1),
(6612, 202, 3359, 'Arad', 10000, 1),
(6613, 202, 3371, 'Constanta', 10000, 1),
(6614, 202, 3360, 'Pitesti', 10000, 1),
(6615, 202, 3392, 'Timisoara', 10000, 1),
(6617, 203, 3581, 'Nizhniy Novgorod', 10000, 1),
(6618, 204, 3627, 'Kigali', 10000, 1),
(6619, 213, 3631, 'Al Madinah', 10000, 1),
(6622, 213, 3631, 'Dhahran', 10000, 1),
(6623, 213, 3641, 'Jiddah', 10000, 1),
(6624, 213, 3636, 'Mecca', 10000, 1),
(6625, 213, 3633, 'Riyadh', 10000, 1),
(6626, 214, 3692, 'Saint-Louis', 10000, 1),
(6628, 224, 3689, 'Cape Town', 10000, 1),
(6629, 224, 3680, 'Durban', 10000, 1),
(6630, 224, 3684, 'Johannesburg', 10000, 1),
(6631, 224, 3684, 'Pretoria', 10000, 1),
(6632, 224, 3684, 'Soweto', 10000, 1),
(6633, 226, 3910, 'Cartagena', 10000, 1),
(6634, 226, 3930, 'C', 10000, 1),
(6635, 226, 3934, 'Leon', 10000, 1),
(6637, 226, 3911, 'Pamplona', 10000, 1),
(6638, 226, 3930, 'Rota', 10000, 1),
(6639, 226, 3937, 'Santiago de Compostela', 10000, 1),
(6641, 226, 3935, 'Tortosa', 10000, 1),
(6642, 226, 3939, 'Valencia', 10000, 1),
(6643, 228, 1306, 'Colombo', 10000, 1),
(6644, 229, 3956, 'Khartoum', 10000, 1),
(6645, 230, 3043, 'Paramaribo', 10000, 1),
(6651, 233, 4007, 'Ostmark', 10000, 1),
(6652, 233, 3998, 'Arjeplog', 10000, 1),
(6653, 233, 4005, 'Bjur', 10000, 1),
(6654, 233, 3994, 'Bor', 10000, 1),
(6655, 233, 4005, 'Dikan', 10000, 1),
(6656, 233, 3998, 'Esrange', 10000, 1),
(6657, 233, 4009, 'Falsterbo', 10000, 1),
(6658, 233, 3991, 'G', 10000, 1),
(6659, 233, 3998, 'Gallivare', 10000, 1),
(6660, 233, 3987, 'G', 10000, 1),
(6664, 233, 4005, 'Gunnarn', 10000, 1),
(6665, 233, 3992, 'Hagshult', 10000, 1),
(6666, 233, 3990, 'Halmstad', 10000, 1),
(6667, 233, 3998, 'Haparanda', 10000, 1),
(6669, 233, 4005, 'Hemavan', 10000, 1),
(6671, 233, 4008, 'Holmg', 10000, 1),
(6672, 233, 3993, 'Hultsfred', 10000, 1),
(6673, 233, 4005, 'Idvattnet', 10000, 1),
(6675, 233, 3998, 'Jokkmokk', 10000, 1),
(6676, 233, 3998, 'Kallax', 10000, 1),
(6677, 233, 3998, 'Karesuando', 10000, 1),
(6678, 233, 4004, 'Karlstad', 10000, 1),
(6680, 233, 3998, 'Kiruna', 10000, 1),
(6681, 233, 4005, 'Klimpfj', 10000, 1),
(6683, 233, 4006, 'Kramfors', 10000, 1),
(6684, 233, 4009, 'Kristianstad', 10000, 1),
(6685, 233, 4009, 'Kullen', 10000, 1),
(6686, 233, 3998, 'Kvikkjokk', 10000, 1),
(6687, 233, 3998, 'Lainio', 10000, 1),
(6688, 233, 4008, 'Landsort', 10000, 1),
(6689, 233, 4000, 'Link', 10000, 1),
(6690, 233, 4009, 'Ljungbyhed', 10000, 1),
(6691, 233, 4010, 'Lur', 10000, 1),
(6692, 233, 3993, 'M', 10000, 1),
(6694, 233, 4000, 'Malexander', 10000, 1),
(6696, 233, 3994, 'Malung', 10000, 1),
(6700, 233, 4002, 'Osby', 10000, 1),
(6702, 233, 3998, 'Pajala', 10000, 1),
(6703, 233, 3994, 'R', 10000, 1),
(6705, 233, 4010, 'S', 10000, 1),
(6706, 233, 3994, 'S', 10000, 1),
(6708, 233, 3994, 'Siljansn', 10000, 1),
(6709, 233, 4010, 'Sk', 10000, 1),
(6711, 233, 4005, 'Skellefte', 10000, 1),
(6712, 233, 3999, 'St', 10000, 1),
(6713, 233, 4008, 'Stockholm', 10000, 1),
(6715, 233, 3991, 'Storlien', 10000, 1),
(6716, 233, 4006, 'Sundsvall', 10000, 1),
(6717, 233, 3991, 'Sveg', 10000, 1),
(6718, 233, 4006, 'Svensk', 10000, 1),
(6721, 233, 4005, 'Umea', 10000, 1),
(6723, 233, 4003, 'Uppsala', 10000, 1),
(6725, 233, 3994, 'V', 10000, 1),
(6726, 233, 3998, 'Vidsel', 10000, 1),
(6727, 233, 4005, 'Vindeln', 10000, 1),
(6728, 233, 3989, 'Visby', 10000, 1),
(6730, 234, 4031, 'Geneva', 10000, 1),
(6731, 234, 4047, 'Lausanne', 10000, 1),
(6732, 234, 4035, 'Lucerne  ', 10000, 1),
(6733, 234, 4047, 'Montreux', 10000, 1),
(6734, 234, 4036, 'Neuchatel', 10000, 1),
(6736, 234, 4049, 'Zurich', 10000, 1),
(6737, 235, 4012, 'Al Ladhiqiyah', 10000, 1),
(6738, 235, 4023, 'Damascus', 10000, 1),
(6739, 236, 773, 'Hua-lien', 10000, 1),
(6740, 236, 4273, 'Kaohsiung', 10000, 1),
(6741, 236, 773, 'P''ing-tung', 10000, 1),
(6742, 236, 4275, 'T''ai-chung', 10000, 1),
(6743, 236, 4273, 'Tainan', 10000, 1),
(6744, 236, 4274, 'Taipei', 10000, 1),
(6746, 238, 4293, 'Kilimanjaro', 10000, 1),
(6747, 238, 4299, 'Zanzibar', 10000, 1),
(6748, 17, 1145, 'Abraham''s Bay', 10000, 1),
(6749, 17, 1155, 'Behring Point', 10000, 1),
(6750, 17, 1160, 'Cockburn Town', 10000, 1),
(6751, 17, 1149, 'Colonel Hill', 10000, 1),
(6752, 17, 1153, 'Cooper''s Town', 10000, 1),
(6753, 17, 1140, 'Georgetown', 10000, 1),
(6754, 17, 1143, 'Matthew Town', 10000, 1),
(6755, 17, 1139, 'Old Bight', 10000, 1),
(6756, 17, 1160, 'Port Nelson', 10000, 1),
(6757, 17, 1158, 'Rock Sound', 10000, 1),
(6758, 17, 1157, 'San Andros', 10000, 1),
(6759, 17, 1156, 'Sandy Point', 10000, 1),
(6760, 17, 1149, 'Snug Corner', 10000, 1),
(6761, 245, 4190, 'Tunis', 10000, 1),
(6762, 246, 4259, 'Ankara', 10000, 1),
(6763, 251, 4434, 'Char''kov', 10000, 1),
(6764, 252, 4998, 'Abu Dhabi', 10000, 1),
(6765, 252, 5002, 'Dubai', 10000, 1),
(6766, 252, 5004, 'Ras al Khaymah', 10000, 1),
(6769, 256, 4490, 'Artigas', 10000, 1),
(6770, 256, 4491, 'Colonia', 10000, 1),
(6771, 256, 4492, 'Paso De Los Toros', 10000, 1),
(6772, 256, 4500, 'Rivera', 10000, 1),
(6773, 256, 4501, 'Rocha', 10000, 1),
(6774, 256, 4502, 'Salto', 10000, 1),
(6775, 256, 4505, 'Tacuarembo', 10000, 1),
(6777, 259, 4538, 'Barquisimeto', 10000, 1),
(6778, 259, 4548, 'Maracaibo', 10000, 1),
(6779, 259, 4542, 'Margarita', 10000, 1),
(6780, 259, 4532, 'Valencia', 10000, 1),
(6781, 260, 4564, 'Hanoi', 10000, 1),
(6783, 261, 5384, 'Charlotte Amalie', 10000, 1),
(6784, 270, 4678, 'Sanaa', 10000, 1),
(6785, 271, 5063, 'Belgrade', 10000, 1),
(6788, 254, 123, 'Anchorage', 10000, 1),
(6789, 254, 123, 'Arctic Village', 10000, 1),
(6790, 254, 123, 'Barrow', 10000, 1),
(6791, 254, 123, 'Bethel', 10000, 1),
(6792, 254, 123, 'Bettles Field', 10000, 1),
(6793, 254, 123, 'Cold Bay', 10000, 1),
(6794, 254, 123, 'Cordova', 10000, 1),
(6795, 254, 123, 'Denali National Park', 10000, 1),
(6796, 254, 123, 'Dillingham', 10000, 1),
(6797, 254, 123, 'Dutch Harbor', 10000, 1),
(6798, 254, 123, 'Eagle River', 10000, 1),
(6799, 254, 123, 'Fairbanks', 10000, 1),
(6800, 254, 123, 'Fort Yukon', 10000, 1),
(6801, 254, 123, 'Galena', 10000, 1),
(6802, 254, 123, 'Girdwood', 10000, 1),
(6803, 254, 123, 'Gakona', 10000, 1),
(6804, 254, 123, 'Gustavus', 10000, 1),
(6805, 254, 123, 'Haines', 10000, 1),
(6806, 254, 123, 'Healy', 10000, 1),
(6807, 254, 123, 'Homer', 10000, 1),
(6808, 254, 123, 'Juneau', 10000, 1),
(6809, 254, 123, 'Kenai', 10000, 1),
(6810, 254, 123, 'Ketchikan', 10000, 1),
(6811, 254, 123, 'King Salmon', 10000, 1),
(6812, 254, 123, 'Kodiak', 10000, 1),
(6813, 254, 123, 'Kotzebue', 10000, 1),
(6814, 254, 123, 'Mc Grath', 10000, 1),
(6815, 254, 123, 'Nome', 10000, 1),
(6816, 254, 123, 'Northway', 10000, 1),
(6817, 254, 123, 'Palmer', 10000, 1),
(6819, 254, 123, 'Savoonga', 10000, 1),
(6820, 254, 123, 'Seldovia', 10000, 1),
(6821, 254, 123, 'Seward', 10000, 1),
(6822, 254, 123, 'Shishmaref', 10000, 1),
(6823, 254, 123, 'Sitka', 10000, 1),
(6824, 254, 123, 'Skagway', 10000, 1),
(6825, 254, 123, 'Sleetmute', 10000, 1),
(6827, 254, 123, 'Talkeetna', 10000, 1),
(6828, 254, 123, 'Tanana', 10000, 1),
(6829, 254, 123, 'Togiak', 10000, 1),
(6830, 254, 123, 'Tok', 10000, 1),
(6831, 254, 123, 'Unalakleet', 10000, 1),
(6832, 254, 123, 'Valdez', 10000, 1),
(6833, 254, 123, 'Willow', 10000, 1),
(6834, 254, 123, 'Wrangell', 10000, 1),
(6835, 254, 123, 'Yakutat', 10000, 1),
(6836, 254, 122, 'Abbeville', 10000, 1),
(6837, 254, 122, 'Alexander City', 10000, 1),
(6838, 254, 122, 'Andalusia', 10000, 1),
(6839, 254, 122, 'Anniston', 10000, 1),
(6840, 254, 122, 'Ashland', 10000, 1),
(6841, 254, 122, 'Athens', 10000, 1),
(6842, 254, 122, 'Auburn', 10000, 1),
(6843, 254, 122, 'Bay Minette', 10000, 1),
(6844, 254, 122, 'Bessemer', 10000, 1),
(6845, 254, 122, 'Birmingham', 10000, 1),
(6846, 254, 122, 'Brewton', 10000, 1),
(6847, 254, 122, 'Butler', 10000, 1),
(6848, 254, 122, 'Camden', 10000, 1),
(6849, 254, 122, 'Carrollton', 10000, 1),
(6850, 254, 122, 'Centreville', 10000, 1),
(6851, 254, 122, 'Chatom', 10000, 1),
(6852, 254, 122, 'Clanton', 10000, 1),
(6853, 254, 122, 'Columbiana', 10000, 1),
(6854, 254, 122, 'Cullman', 10000, 1),
(6855, 254, 122, 'Decatur', 10000, 1),
(6856, 254, 122, 'Demopolis', 10000, 1),
(6857, 254, 122, 'Dothan', 10000, 1),
(6858, 254, 122, 'Double Springs', 10000, 1),
(6859, 254, 122, 'Elberta', 10000, 1),
(6860, 254, 122, 'Enterprise', 10000, 1),
(6861, 254, 122, 'Eufaula', 10000, 1),
(6862, 254, 122, 'Eutaw', 10000, 1),
(6863, 254, 122, 'Evergreen', 10000, 1),
(6864, 254, 122, 'Fayette', 10000, 1),
(6865, 254, 122, 'Florence', 10000, 1),
(6867, 254, 122, 'Fort Payne', 10000, 1),
(6868, 254, 122, 'Gadsden', 10000, 1),
(6869, 254, 122, 'Greensboro', 10000, 1),
(6870, 254, 122, 'Greenville', 10000, 1),
(6872, 254, 122, 'Guntersville', 10000, 1),
(6873, 254, 122, 'Hamilton', 10000, 1),
(6874, 254, 122, 'Hartford', 10000, 1),
(6875, 254, 122, 'Hayneville', 10000, 1),
(6876, 254, 122, 'Heflin', 10000, 1),
(6879, 254, 122, 'Huntsville', 10000, 1),
(6880, 254, 122, 'Jacksonville', 10000, 1),
(6881, 254, 122, 'Jasper', 10000, 1),
(6882, 254, 122, 'Lanett', 10000, 1),
(6883, 254, 122, 'Livingston', 10000, 1),
(6884, 254, 122, 'Luverne', 10000, 1),
(6885, 254, 122, 'Madison', 10000, 1),
(6886, 254, 122, 'Marion', 10000, 1),
(6888, 254, 122, 'Monroeville', 10000, 1),
(6889, 254, 122, 'Montgomery', 10000, 1),
(6891, 254, 122, 'Muscle Shoals', 10000, 1),
(6892, 254, 122, 'Northport', 10000, 1),
(6893, 254, 122, 'Oneonta', 10000, 1),
(6894, 254, 122, 'Opelika', 10000, 1),
(6895, 254, 122, 'Ozark', 10000, 1),
(6896, 254, 122, 'Pell City', 10000, 1),
(6897, 254, 122, 'Phenix City', 10000, 1),
(6898, 254, 122, 'Piedmont', 10000, 1),
(6899, 254, 122, 'Pinson', 10000, 1),
(6900, 254, 122, 'Prattville', 10000, 1),
(6903, 254, 122, 'Roanoke', 10000, 1),
(6904, 254, 122, 'Rockford', 10000, 1),
(6906, 254, 122, 'Russellville', 10000, 1),
(6907, 254, 122, 'Scottsboro', 10000, 1),
(6908, 254, 122, 'Selma', 10000, 1),
(6909, 254, 122, 'Talladega', 10000, 1),
(6910, 254, 122, 'Tallassee', 10000, 1),
(6911, 254, 122, 'Troy', 10000, 1),
(6912, 254, 122, 'Tuscaloosa', 10000, 1),
(6913, 254, 122, 'Tuscumbia', 10000, 1),
(6914, 254, 122, 'Tuskegee', 10000, 1),
(6915, 254, 122, 'Union Springs', 10000, 1),
(6916, 254, 122, 'Vernon', 10000, 1),
(6917, 254, 125, 'Arkadelphia', 10000, 1),
(6918, 254, 125, 'Arkansas City', 10000, 1),
(6919, 254, 125, 'Ash Flat', 10000, 1),
(6920, 254, 125, 'Ashdown', 10000, 1),
(6921, 254, 125, 'Augusta', 10000, 1),
(6922, 254, 125, 'Batesville', 10000, 1),
(6923, 254, 125, 'Benton', 10000, 1),
(6924, 254, 125, 'Bentonville', 10000, 1),
(6925, 254, 125, 'Berryville', 10000, 1),
(6926, 254, 125, 'Blytheville', 10000, 1),
(6927, 254, 125, 'Booneville', 10000, 1),
(6928, 254, 125, 'Camden', 10000, 1),
(6929, 254, 125, 'Clarendon', 10000, 1),
(6930, 254, 125, 'Clarksville', 10000, 1),
(6931, 254, 125, 'Clinton', 10000, 1),
(6932, 254, 125, 'Conway', 10000, 1),
(6933, 254, 125, 'Corning', 10000, 1),
(6934, 254, 125, 'Crossett', 10000, 1),
(6935, 254, 125, 'Danville', 10000, 1),
(6936, 254, 125, 'De Queen', 10000, 1),
(6937, 254, 125, 'De Witt', 10000, 1),
(6938, 254, 125, 'Des Arc', 10000, 1),
(6939, 254, 125, 'Dumas', 10000, 1),
(6940, 254, 125, 'El Dorado', 10000, 1),
(6941, 254, 125, 'Eureka Springs', 10000, 1),
(6942, 254, 125, 'Fayetteville', 10000, 1),
(6943, 254, 125, 'Fordyce', 10000, 1),
(6944, 254, 125, 'Forrest City', 10000, 1),
(6945, 254, 125, 'Fort Smith', 10000, 1),
(6946, 254, 125, 'Fouke', 10000, 1),
(6947, 254, 125, 'Hampton', 10000, 1),
(6948, 254, 125, 'Harrison', 10000, 1),
(6949, 254, 125, 'Heber Springs', 10000, 1),
(6950, 254, 125, 'Helena', 10000, 1),
(6951, 254, 125, 'Hope', 10000, 1),
(6952, 254, 125, 'Hot Springs National Park', 10000, 1),
(6953, 254, 125, 'Hoxie', 10000, 1),
(6954, 254, 125, 'Huntsville', 10000, 1),
(6955, 254, 125, 'Jacksonville', 10000, 1),
(6956, 254, 125, 'Jasper', 10000, 1),
(6957, 254, 125, 'Jonesboro', 10000, 1),
(6958, 254, 125, 'Lake Village', 10000, 1),
(6959, 254, 125, 'Lewisville', 10000, 1),
(6960, 254, 125, 'Little Rock', 10000, 1),
(6961, 254, 125, 'Lonoke', 10000, 1),
(6962, 254, 125, 'Magnolia', 10000, 1),
(6963, 254, 125, 'Malvern', 10000, 1),
(6965, 254, 125, 'Marion', 10000, 1),
(6966, 254, 125, 'Marshall', 10000, 1),
(6967, 254, 125, 'Melbourne', 10000, 1),
(6968, 254, 125, 'Mena', 10000, 1),
(6969, 254, 125, 'Monticello', 10000, 1),
(6970, 254, 125, 'Morrilton', 10000, 1),
(6971, 254, 125, 'Mount Ida', 10000, 1),
(6972, 254, 125, 'Mountain Home', 10000, 1),
(6974, 254, 125, 'Murfreesboro', 10000, 1),
(6975, 254, 125, 'Nashville', 10000, 1),
(6976, 254, 125, 'Newport', 10000, 1),
(6977, 254, 125, 'North Little Rock', 10000, 1),
(6978, 254, 125, 'Ozark', 10000, 1),
(6979, 254, 125, 'Paragould', 10000, 1),
(6980, 254, 125, 'Peel', 10000, 1),
(6981, 254, 125, 'Perryville', 10000, 1),
(6982, 254, 125, 'Pine Bluff', 10000, 1),
(6983, 254, 125, 'Pocahontas', 10000, 1),
(6984, 254, 125, 'Prescott', 10000, 1),
(6985, 254, 125, 'Rogers', 10000, 1),
(6986, 254, 125, 'Russellville', 10000, 1),
(6987, 254, 125, 'Salem', 10000, 1),
(6988, 254, 125, 'Searcy', 10000, 1),
(6989, 254, 125, 'Sheridan', 10000, 1),
(6990, 254, 125, 'Sherwood', 10000, 1),
(6991, 254, 125, 'Siloam Springs', 10000, 1),
(6992, 254, 125, 'Springdale', 10000, 1),
(6993, 254, 125, 'Star City', 10000, 1),
(6994, 254, 125, 'Stuttgart', 10000, 1),
(6995, 254, 125, 'Summit', 10000, 1),
(6996, 254, 125, 'Texarkana', 10000, 1),
(6997, 254, 125, 'Trumann', 10000, 1),
(6998, 254, 125, 'Van Buren', 10000, 1),
(6999, 254, 125, 'Waldron', 10000, 1),
(7000, 254, 125, 'Walnut Ridge', 10000, 1),
(7001, 254, 125, 'Warren', 10000, 1),
(7002, 254, 125, 'West Memphis', 10000, 1),
(7003, 254, 125, 'Wynne', 10000, 1),
(7004, 254, 124, 'Alpine', 10000, 1),
(7005, 254, 124, 'Apache Junction', 10000, 1),
(7006, 254, 124, 'Avondale', 10000, 1),
(7007, 254, 124, 'Bisbee', 10000, 1),
(7008, 254, 124, 'Bullhead City', 10000, 1),
(7010, 254, 124, 'Carefree', 10000, 1),
(7011, 254, 124, 'Casa Grande', 10000, 1),
(7012, 254, 124, 'Chandler', 10000, 1),
(7013, 254, 124, 'Chinle', 10000, 1),
(7014, 254, 124, 'Coolidge', 10000, 1),
(7015, 254, 124, 'Cottonwood', 10000, 1),
(7016, 254, 124, 'Douglas', 10000, 1),
(7017, 254, 124, 'Flagstaff', 10000, 1),
(7019, 254, 124, 'Gila Bend', 10000, 1),
(7020, 254, 124, 'Gilbert', 10000, 1),
(7021, 254, 124, 'Glendale', 10000, 1),
(7022, 254, 124, 'Globe', 10000, 1),
(7023, 254, 124, 'Grand Canyon', 10000, 1),
(7024, 254, 124, 'Green Valley', 10000, 1),
(7025, 254, 124, 'Greer', 10000, 1),
(7026, 254, 124, 'Heber', 10000, 1),
(7027, 254, 124, 'Holbrook', 10000, 1),
(7028, 254, 124, 'Kayenta', 10000, 1),
(7029, 254, 124, 'Kingman', 10000, 1),
(7030, 254, 124, 'Lake Havasu City', 10000, 1),
(7031, 254, 124, 'McNary', 10000, 1),
(7032, 254, 124, 'Mesa', 10000, 1),
(7035, 254, 124, 'Nogales', 10000, 1),
(7036, 254, 124, 'North Rim', 10000, 1),
(7038, 254, 124, 'Page', 10000, 1),
(7039, 254, 124, 'Parker', 10000, 1),
(7040, 254, 124, 'Payson', 10000, 1),
(7041, 254, 124, 'Peoria', 10000, 1),
(7042, 254, 124, 'Phoenix', 10000, 1),
(7044, 254, 124, 'Prescott', 10000, 1),
(7045, 254, 124, 'Safford', 10000, 1),
(7046, 254, 124, 'Scottsdale', 10000, 1),
(7047, 254, 124, 'Sedona', 10000, 1),
(7048, 254, 124, 'Show Low', 10000, 1),
(7049, 254, 124, 'Sierra Vista', 10000, 1),
(7050, 254, 124, 'Springerville', 10000, 1),
(7052, 254, 124, 'Sun City', 10000, 1),
(7053, 254, 124, 'Tempe', 10000, 1),
(7054, 254, 124, 'Tombstone', 10000, 1),
(7055, 254, 124, 'Tuba City', 10000, 1),
(7056, 254, 124, 'Tucson', 10000, 1),
(7058, 254, 124, 'Wickenburg', 10000, 1),
(7059, 254, 124, 'Willcox', 10000, 1),
(7060, 254, 124, 'Williams', 10000, 1),
(7062, 254, 124, 'Window Rock', 10000, 1),
(7063, 254, 124, 'Winslow', 10000, 1),
(7064, 254, 124, 'Yuma', 10000, 1),
(7065, 254, 126, 'Adelanto', 10000, 1),
(7066, 254, 126, 'Alameda', 10000, 1),
(7067, 254, 126, 'Alamo', 10000, 1),
(7068, 254, 126, 'Alhambra', 10000, 1),
(7069, 254, 126, 'Alpine', 10000, 1),
(7070, 254, 126, 'Altadena', 10000, 1),
(7071, 254, 126, 'Alturas', 10000, 1),
(7072, 254, 126, 'Anaheim', 10000, 1),
(7073, 254, 126, 'Angels Camp', 10000, 1),
(7074, 254, 126, 'Antioch', 10000, 1),
(7075, 254, 126, 'Apple Valley', 10000, 1),
(7076, 254, 126, 'Arcadia', 10000, 1),
(7077, 254, 126, 'Arcata', 10000, 1),
(7079, 254, 126, 'Arroyo Grande', 10000, 1),
(7080, 254, 126, 'Artois', 10000, 1),
(7081, 254, 126, 'Arvin', 10000, 1),
(7082, 254, 126, 'Atascadero', 10000, 1),
(7083, 254, 126, 'Atwater', 10000, 1),
(7084, 254, 126, 'Auburn', 10000, 1),
(7085, 254, 126, 'Avalon', 10000, 1),
(7086, 254, 126, 'Avenal', 10000, 1),
(7087, 254, 126, 'Azusa', 10000, 1),
(7088, 254, 126, 'Bakersfield', 10000, 1),
(7089, 254, 126, 'Baldwin Park', 10000, 1),
(7090, 254, 126, 'Banning', 10000, 1),
(7091, 254, 126, 'Barstow', 10000, 1),
(7092, 254, 126, 'Arnold', 10000, 1),
(7093, 254, 126, 'Beaumont', 10000, 1),
(7094, 254, 126, 'Bell', 10000, 1),
(7095, 254, 126, 'Bell Gardens', 10000, 1),
(7096, 254, 126, 'Bellflower', 10000, 1),
(7097, 254, 126, 'Belmont', 10000, 1),
(7098, 254, 126, 'Benicia', 10000, 1),
(7099, 254, 126, 'Berkeley', 10000, 1),
(7100, 254, 126, 'Beverly Hills', 10000, 1),
(7101, 254, 126, 'Big Bear City', 10000, 1),
(7102, 254, 126, 'Big Sur', 10000, 1),
(7103, 254, 126, 'Bishop', 10000, 1),
(7105, 254, 126, 'Blythe', 10000, 1),
(7106, 254, 126, 'Bodega Bay', 10000, 1),
(7107, 254, 126, 'Borrego Springs', 10000, 1),
(7108, 254, 126, 'Brawley', 10000, 1),
(7109, 254, 126, 'Brea', 10000, 1),
(7110, 254, 126, 'Brentwood', 10000, 1),
(7111, 254, 126, 'Bridgeport', 10000, 1),
(7113, 254, 126, 'Buena Park', 10000, 1),
(7114, 254, 126, 'Burbank', 10000, 1),
(7115, 254, 126, 'Burlingame', 10000, 1),
(7116, 254, 126, 'Burney', 10000, 1),
(7117, 254, 126, 'Buttonwillow', 10000, 1),
(7118, 254, 126, 'Byron', 10000, 1),
(7119, 254, 126, 'Calexico', 10000, 1),
(7120, 254, 126, 'California City', 10000, 1),
(7121, 254, 126, 'Camarillo', 10000, 1),
(7122, 254, 126, 'Cambria', 10000, 1),
(7123, 254, 126, 'Camp Pendleton', 10000, 1),
(7124, 254, 126, 'Campbell', 10000, 1),
(7125, 254, 126, 'Campo', 10000, 1),
(7126, 254, 126, 'Carlsbad', 10000, 1),
(7127, 254, 126, 'Carmel', 10000, 1),
(7128, 254, 126, 'Carmichael', 10000, 1),
(7129, 254, 126, 'Carpinteria', 10000, 1),
(7130, 254, 126, 'Carson', 10000, 1),
(7131, 254, 126, 'Castro Valley', 10000, 1),
(7132, 254, 126, 'Cathedral City', 10000, 1),
(7133, 254, 126, 'Ceres', 10000, 1),
(7134, 254, 126, 'Cerritos', 10000, 1),
(7135, 254, 126, 'Chatsworth', 10000, 1),
(7136, 254, 126, 'Chico', 10000, 1),
(7137, 254, 126, 'Chino', 10000, 1),
(7138, 254, 126, 'Chowchilla', 10000, 1),
(7139, 254, 126, 'Chula Vista', 10000, 1),
(7140, 254, 126, 'Citrus Heights', 10000, 1),
(7141, 254, 126, 'Claremont', 10000, 1),
(7142, 254, 126, 'Clayton', 10000, 1),
(7143, 254, 126, 'Clearlake', 10000, 1),
(7144, 254, 126, 'Cloverdale', 10000, 1),
(7145, 254, 126, 'Clovis', 10000, 1),
(7146, 254, 126, 'Coalinga', 10000, 1),
(7147, 254, 126, 'Colton', 10000, 1),
(7148, 254, 126, 'Colusa', 10000, 1),
(7149, 254, 126, 'Compton', 10000, 1),
(7150, 254, 126, 'Concord', 10000, 1),
(7151, 254, 126, 'Corona', 10000, 1),
(7152, 254, 126, 'Coronado', 10000, 1),
(7153, 254, 126, 'Costa Mesa', 10000, 1),
(7154, 254, 126, 'Covina', 10000, 1),
(7155, 254, 126, 'Crescent City', 10000, 1),
(7156, 254, 126, 'Crockett', 10000, 1),
(7157, 254, 126, 'Culver City', 10000, 1),
(7158, 254, 126, 'Cupertino', 10000, 1),
(7160, 254, 126, 'Cypress', 10000, 1),
(7161, 254, 126, 'Daly City', 10000, 1),
(7162, 254, 126, 'Dana Point', 10000, 1),
(7163, 254, 126, 'Danville', 10000, 1),
(7164, 254, 126, 'Davis', 10000, 1),
(7166, 254, 126, 'Del Mar', 10000, 1),
(7167, 254, 126, 'Delano', 10000, 1),
(7168, 254, 126, 'Diamond Bar', 10000, 1),
(7169, 254, 126, 'Dinuba', 10000, 1),
(7170, 254, 126, 'Dixon', 10000, 1),
(7172, 254, 126, 'Downey', 10000, 1),
(7173, 254, 126, 'Duarte', 10000, 1),
(7174, 254, 126, 'Dublin', 10000, 1),
(7175, 254, 126, 'Dunsmuir', 10000, 1),
(7176, 254, 126, 'Earlimart', 10000, 1),
(7177, 254, 126, 'Edison', 10000, 1),
(7179, 254, 126, 'El Cajon', 10000, 1),
(7180, 254, 126, 'El Centro', 10000, 1),
(7181, 254, 126, 'El Cerrito', 10000, 1),
(7182, 254, 126, 'El Monte', 10000, 1),
(7183, 254, 126, 'El Sobrante', 10000, 1),
(7184, 254, 126, 'Elk Grove', 10000, 1),
(7185, 254, 126, 'Encinitas', 10000, 1),
(7186, 254, 126, 'Escalon', 10000, 1),
(7187, 254, 126, 'Escondido', 10000, 1),
(7188, 254, 126, 'Eureka', 10000, 1),
(7189, 254, 126, 'Fair Oaks', 10000, 1),
(7190, 254, 126, 'Fallbrook', 10000, 1),
(7191, 254, 126, 'Fillmore', 10000, 1),
(7192, 254, 126, 'Florence', 10000, 1),
(7193, 254, 126, 'Folsom', 10000, 1),
(7194, 254, 126, 'Fontana', 10000, 1),
(7195, 254, 126, 'Fort Bragg', 10000, 1),
(7197, 254, 126, 'Fountain Valley', 10000, 1),
(7198, 254, 126, 'Frazier Park', 10000, 1),
(7199, 254, 126, 'Fremont', 10000, 1),
(7200, 254, 126, 'Fresno', 10000, 1),
(7201, 254, 126, 'Fullerton', 10000, 1),
(7202, 254, 126, 'Galt', 10000, 1),
(7203, 254, 126, 'Garden Grove', 10000, 1),
(7204, 254, 126, 'Gardena', 10000, 1),
(7205, 254, 126, 'Gilroy', 10000, 1),
(7206, 254, 126, 'Glendale', 10000, 1),
(7207, 254, 126, 'Glendora', 10000, 1),
(7208, 254, 126, 'Glennville', 10000, 1),
(7209, 254, 126, 'Goleta', 10000, 1),
(7210, 254, 126, 'Gridley', 10000, 1),
(7211, 254, 126, 'Hacienda Heights', 10000, 1),
(7212, 254, 126, 'Half Moon Bay', 10000, 1),
(7213, 254, 126, 'Hallelujah Jct', 10000, 1),
(7214, 254, 126, 'Hanford', 10000, 1),
(7215, 254, 126, 'Hawthorne', 10000, 1),
(7216, 254, 126, 'Hayfork', 10000, 1),
(7217, 254, 126, 'Hayward', 10000, 1),
(7218, 254, 126, 'Healdsburg', 10000, 1),
(7219, 254, 126, 'Hemet', 10000, 1),
(7220, 254, 126, 'Hercules', 10000, 1),
(7221, 254, 126, 'Hesperia', 10000, 1),
(7222, 254, 126, 'Highland', 10000, 1),
(7223, 254, 126, 'Hollister', 10000, 1),
(7224, 254, 126, 'Huntington Beach', 10000, 1),
(7225, 254, 126, 'Imperial', 10000, 1),
(7226, 254, 126, 'Imperial Beach', 10000, 1),
(7227, 254, 126, 'Indio', 10000, 1),
(7228, 254, 126, 'Inglewood', 10000, 1),
(7229, 254, 126, 'Irvine', 10000, 1),
(7230, 254, 126, 'Jackson', 10000, 1),
(7231, 254, 126, 'Jamul', 10000, 1),
(7232, 254, 126, 'Joshua Tree National Park', 10000, 1),
(7233, 254, 126, 'Julian', 10000, 1),
(7234, 254, 126, 'Kernville', 10000, 1),
(7235, 254, 126, 'King City', 10000, 1),
(7236, 254, 126, 'Kings Beach', 10000, 1),
(7237, 254, 126, 'Knights Landing', 10000, 1),
(7238, 254, 126, 'La Habra', 10000, 1),
(7239, 254, 126, 'La Jolla', 10000, 1),
(7240, 254, 126, 'La Mesa', 10000, 1),
(7241, 254, 126, 'La Mirada', 10000, 1),
(7242, 254, 126, 'La Puente', 10000, 1),
(7243, 254, 126, 'La Verne', 10000, 1),
(7244, 254, 126, 'Lafayette', 10000, 1),
(7245, 254, 126, 'Laguna Beach', 10000, 1),
(7246, 254, 126, 'Laguna Hills', 10000, 1),
(7247, 254, 126, 'Laguna Niguel', 10000, 1),
(7248, 254, 126, 'Lake Arrowhead', 10000, 1),
(7250, 254, 126, 'Lake Elsinore', 10000, 1),
(7251, 254, 126, 'Lake Forest', 10000, 1),
(7252, 254, 126, 'Lake Isabella', 10000, 1),
(7253, 254, 126, 'Lakeport', 10000, 1),
(7254, 254, 126, 'Lakeside', 10000, 1),
(7255, 254, 126, 'Lakewood', 10000, 1),
(7256, 254, 126, 'Lamont', 10000, 1),
(7257, 254, 126, 'Lancaster', 10000, 1),
(7258, 254, 126, 'Lathrop', 10000, 1),
(7259, 254, 126, 'Lawndale', 10000, 1),
(7261, 254, 126, 'Lebec', 10000, 1),
(7262, 254, 126, 'Lemon Grove', 10000, 1),
(7263, 254, 126, 'Lemoore', 10000, 1),
(7265, 254, 126, 'Linden', 10000, 1),
(7266, 254, 126, 'Lindsay', 10000, 1),
(7267, 254, 126, 'Livermore', 10000, 1),
(7268, 254, 126, 'Lockeford', 10000, 1),
(7269, 254, 126, 'Lodi', 10000, 1),
(7270, 254, 126, 'Lomita', 10000, 1),
(7271, 254, 126, 'Lompoc', 10000, 1),
(7272, 254, 126, 'Lone Pine', 10000, 1),
(7273, 254, 126, 'Long Beach', 10000, 1),
(7274, 254, 126, 'Los Altos', 10000, 1),
(7275, 254, 126, 'Los Angeles', 10000, 1),
(7276, 254, 126, 'Los Banos', 10000, 1),
(7277, 254, 126, 'Los Gatos', 10000, 1),
(7278, 254, 126, 'Lost Hills', 10000, 1),
(7279, 254, 126, 'Lucerne Valley', 10000, 1),
(7280, 254, 126, 'Lynwood', 10000, 1),
(7281, 254, 126, 'Madera', 10000, 1),
(7282, 254, 126, 'Malibu', 10000, 1),
(7283, 254, 126, 'Mammoth Lakes', 10000, 1),
(7284, 254, 126, 'Mammoth Mountain', 10000, 1),
(7285, 254, 126, 'Manhattan Beach', 10000, 1),
(7286, 254, 126, 'Manteca', 10000, 1),
(7287, 254, 126, 'Manzanita Lake', 10000, 1),
(7288, 254, 126, 'Maricopa', 10000, 1),
(7289, 254, 126, 'Mariposa', 10000, 1),
(7290, 254, 126, 'Markleeville', 10000, 1),
(7291, 254, 126, 'Martinez', 10000, 1),
(7292, 254, 126, 'Marysville', 10000, 1),
(7294, 254, 126, 'Maywood', 10000, 1),
(7297, 254, 126, 'Mendocino', 10000, 1),
(7298, 254, 126, 'Mendota', 10000, 1),
(7299, 254, 126, 'Menifee', 10000, 1),
(7300, 254, 126, 'Menlo Park', 10000, 1),
(7301, 254, 126, 'Merced', 10000, 1),
(7302, 254, 126, 'Mill Valley', 10000, 1),
(7303, 254, 126, 'Millbrae', 10000, 1),
(7304, 254, 126, 'Milpitas', 10000, 1),
(7305, 254, 126, 'Mineral', 10000, 1),
(7306, 254, 126, 'Mission Viejo', 10000, 1),
(7307, 254, 126, 'Modesto', 10000, 1),
(7308, 254, 126, 'Mojave', 10000, 1),
(7309, 254, 126, 'Monrovia', 10000, 1),
(7310, 254, 126, 'Montclair', 10000, 1),
(7311, 254, 126, 'Montebello', 10000, 1),
(7312, 254, 126, 'Monterey', 10000, 1),
(7313, 254, 126, 'Monterey Park', 10000, 1),
(7314, 254, 126, 'Moorpark', 10000, 1),
(7315, 254, 126, 'Moraga', 10000, 1),
(7316, 254, 126, 'Moreno Valley', 10000, 1),
(7317, 254, 126, 'Morgan Hill', 10000, 1),
(7318, 254, 126, 'Morro Bay', 10000, 1),
(7319, 254, 126, 'Mount Laguna', 10000, 1),
(7320, 254, 126, 'Mount Shasta', 10000, 1),
(7321, 254, 126, 'Mount Wilson', 10000, 1),
(7322, 254, 126, 'Mountain View', 10000, 1),
(7323, 254, 126, 'Murrieta', 10000, 1),
(7324, 254, 126, 'Napa', 10000, 1),
(7325, 254, 126, 'National City', 10000, 1),
(7326, 254, 126, 'Needles', 10000, 1),
(7327, 254, 126, 'Nevada City', 10000, 1),
(7328, 254, 126, 'Newark', 10000, 1),
(7329, 254, 126, 'Newport Beach', 10000, 1),
(7330, 254, 126, 'Norco', 10000, 1),
(7331, 254, 126, 'North Highlands', 10000, 1),
(7332, 254, 126, 'Northridge', 10000, 1),
(7333, 254, 126, 'Norwalk', 10000, 1),
(7334, 254, 126, 'Novato', 10000, 1),
(7335, 254, 126, 'Oakland', 10000, 1),
(7336, 254, 126, 'Oakley', 10000, 1),
(7337, 254, 126, 'Ojai', 10000, 1),
(7338, 254, 126, 'Olema', 10000, 1),
(7339, 254, 126, 'Ontario', 10000, 1),
(7340, 254, 126, 'Orange', 10000, 1),
(7341, 254, 126, 'Orangevale', 10000, 1),
(7342, 254, 126, 'Orinda', 10000, 1),
(7343, 254, 126, 'Orland', 10000, 1),
(7344, 254, 126, 'Oroville', 10000, 1),
(7346, 254, 126, 'Oxnard', 10000, 1),
(7347, 254, 126, 'Pacifica', 10000, 1),
(7348, 254, 126, 'Palm Desert', 10000, 1),
(7349, 254, 126, 'Palm Springs', 10000, 1),
(7350, 254, 126, 'Palmdale', 10000, 1),
(7351, 254, 126, 'Palo Alto', 10000, 1),
(7353, 254, 126, 'Paradise', 10000, 1),
(7354, 254, 126, 'Paramount', 10000, 1),
(7355, 254, 126, 'Pasadena', 10000, 1),
(7356, 254, 126, 'Paso Robles', 10000, 1),
(7357, 254, 126, 'Pebble Beach', 10000, 1),
(7358, 254, 126, 'Perris', 10000, 1),
(7359, 254, 126, 'Petaluma', 10000, 1),
(7360, 254, 126, 'Phelan', 10000, 1),
(7361, 254, 126, 'Pico Rivera', 10000, 1),
(7362, 254, 126, 'Pinole', 10000, 1),
(7363, 254, 126, 'Piru', 10000, 1),
(7364, 254, 126, 'Pismo Beach', 10000, 1),
(7365, 254, 126, 'Pittsburg', 10000, 1),
(7366, 254, 126, 'Placentia', 10000, 1),
(7367, 254, 126, 'Placerville', 10000, 1),
(7368, 254, 126, 'Pleasant Hill', 10000, 1),
(7369, 254, 126, 'Pleasanton', 10000, 1),
(7370, 254, 126, 'Point Mugu', 10000, 1),
(7373, 254, 126, 'Pollock Pines', 10000, 1),
(7374, 254, 126, 'Port Hueneme', 10000, 1),
(7375, 254, 126, 'Porterville', 10000, 1),
(7376, 254, 126, 'Potter Valley', 10000, 1),
(7377, 254, 126, 'Poway', 10000, 1),
(7378, 254, 126, 'Quincy', 10000, 1),
(7380, 254, 126, 'Ramona', 10000, 1),
(7381, 254, 126, 'Ranchita', 10000, 1),
(7382, 254, 126, 'Rancho Cordova', 10000, 1),
(7383, 254, 126, 'Rancho Cucamonga', 10000, 1),
(7384, 254, 126, 'Rancho Palos Verdes', 10000, 1),
(7386, 254, 126, 'Rancho Sante Fe', 10000, 1),
(7387, 254, 126, 'Randsburg', 10000, 1),
(7388, 254, 126, 'Red Bluff', 10000, 1),
(7389, 254, 126, 'Redding', 10000, 1),
(7390, 254, 126, 'Redlands', 10000, 1),
(7391, 254, 126, 'Redondo Beach', 10000, 1),
(7392, 254, 126, 'Redwood City', 10000, 1),
(7393, 254, 126, 'Reedley', 10000, 1),
(7394, 254, 126, 'Rialto', 10000, 1),
(7395, 254, 126, 'Richmond', 10000, 1),
(7396, 254, 126, 'Ridgecrest', 10000, 1),
(7397, 254, 126, 'Rio Vista', 10000, 1),
(7398, 254, 126, 'Ripon', 10000, 1),
(7399, 254, 126, 'Riverside', 10000, 1),
(7400, 254, 126, 'Rocklin', 10000, 1),
(7401, 254, 126, 'Rodeo', 10000, 1),
(7402, 254, 126, 'Rohnert Park', 10000, 1),
(7403, 254, 126, 'Rosamond', 10000, 1),
(7404, 254, 126, 'Rosemead', 10000, 1),
(7405, 254, 126, 'Roseville', 10000, 1),
(7406, 254, 126, 'Rowland Heights', 10000, 1),
(7408, 254, 126, 'Sacramento', 10000, 1),
(7410, 254, 126, 'Salinas', 10000, 1),
(7411, 254, 126, 'San Andreas', 10000, 1),
(7412, 254, 126, 'San Bernardino', 10000, 1),
(7413, 254, 126, 'San Bruno', 10000, 1),
(7414, 254, 126, 'San Carlos', 10000, 1),
(7415, 254, 126, 'San Clemente', 10000, 1),
(7416, 254, 126, 'San Diego', 10000, 1),
(7417, 254, 126, 'San Dimas', 10000, 1),
(7418, 254, 126, 'San Fernando', 10000, 1),
(7419, 254, 126, 'San Francisco', 10000, 1),
(7420, 254, 126, 'San Gabriel', 10000, 1),
(7421, 254, 126, 'San Jacinto', 10000, 1),
(7422, 254, 126, 'San Jose', 10000, 1),
(7423, 254, 126, 'San Juan Capistrano', 10000, 1),
(7424, 254, 126, 'San Leandro', 10000, 1),
(7425, 254, 126, 'San Luis Obispo', 10000, 1),
(7426, 254, 126, 'San Marcos', 10000, 1),
(7427, 254, 126, 'San Mateo', 10000, 1),
(7428, 254, 126, 'San Pablo', 10000, 1),
(7429, 254, 126, 'San Rafael', 10000, 1),
(7430, 254, 126, 'San Ramon', 10000, 1),
(7431, 254, 126, 'San Simeon', 10000, 1),
(7432, 254, 126, 'Santa Ana', 10000, 1),
(7433, 254, 126, 'Santa Barbara', 10000, 1),
(7434, 254, 126, 'Santa Clara', 10000, 1),
(7435, 254, 126, 'Santa Clarita', 10000, 1),
(7436, 254, 126, 'Santa Cruz', 10000, 1),
(7437, 254, 126, 'Santa Maria', 10000, 1),
(7438, 254, 126, 'Santa Monica', 10000, 1),
(7439, 254, 126, 'Santa Paula', 10000, 1),
(7440, 254, 126, 'Santa Rosa', 10000, 1),
(7441, 254, 126, 'Santee', 10000, 1),
(7442, 254, 126, 'Saratoga', 10000, 1),
(7443, 254, 126, 'Sausalito', 10000, 1),
(7444, 254, 126, 'Seal Beach', 10000, 1),
(7445, 254, 126, 'Seaside', 10000, 1),
(7447, 254, 126, 'Sequoia National Park', 10000, 1),
(7448, 254, 126, 'Shafter', 10000, 1),
(7449, 254, 126, 'Shasta Lake', 10000, 1),
(7450, 254, 126, 'Sherman Oaks', 10000, 1),
(7453, 254, 126, 'Simi Valley', 10000, 1),
(7454, 254, 126, 'Solana Beach', 10000, 1),
(7455, 254, 126, 'Solvang', 10000, 1),
(7456, 254, 126, 'Sonoma', 10000, 1),
(7457, 254, 126, 'Sonora', 10000, 1),
(7458, 254, 126, 'South El Monte', 10000, 1),
(7459, 254, 126, 'South Gate', 10000, 1),
(7460, 254, 126, 'South Lake', 10000, 1),
(7461, 254, 126, 'South Lake Tahoe', 10000, 1),
(7462, 254, 126, 'South Pasadena', 10000, 1),
(7463, 254, 126, 'South San Francisco', 10000, 1),
(7464, 254, 126, 'Spring Valley', 10000, 1),
(7465, 254, 126, 'Stanford', 10000, 1),
(7466, 254, 126, 'Stanton', 10000, 1),
(7467, 254, 126, 'Stinson Beach', 10000, 1),
(7468, 254, 126, 'Stockton', 10000, 1),
(7469, 254, 126, 'Strawberry Valley', 10000, 1),
(7470, 254, 126, 'Suisun City', 10000, 1),
(7471, 254, 126, 'Sun City', 10000, 1),
(7472, 254, 126, 'Sunnyvale', 10000, 1),
(7473, 254, 126, 'Sunol', 10000, 1),
(7474, 254, 126, 'Susanville', 10000, 1),
(7475, 254, 126, 'Taft', 10000, 1),
(7476, 254, 126, 'Tahoe City', 10000, 1),
(7477, 254, 126, 'Tecate', 10000, 1),
(7478, 254, 126, 'Tehachapi', 10000, 1),
(7479, 254, 126, 'Temecula', 10000, 1),
(7480, 254, 126, 'Temple City', 10000, 1),
(7481, 254, 126, 'Thermal', 10000, 1),
(7482, 254, 126, 'Thousand Oaks', 10000, 1),
(7483, 254, 126, 'Torrance', 10000, 1),
(7484, 254, 126, 'Trabuco Canyon', 10000, 1),
(7485, 254, 126, 'Tracy', 10000, 1),
(7486, 254, 126, 'Travis AFB', 10000, 1),
(7487, 254, 126, 'Truckee', 10000, 1),
(7488, 254, 126, 'Tulare', 10000, 1),
(7489, 254, 126, 'Tulelake', 10000, 1),
(7490, 254, 126, 'Turlock', 10000, 1),
(7491, 254, 126, 'Tustin', 10000, 1),
(7492, 254, 126, 'Twentynine Palms', 10000, 1),
(7493, 254, 126, 'Ukiah', 10000, 1),
(7494, 254, 126, 'Union City', 10000, 1),
(7495, 254, 126, 'Upland', 10000, 1),
(7496, 254, 126, 'Vacaville', 10000, 1),
(7497, 254, 126, 'Valencia', 10000, 1),
(7498, 254, 126, 'Vallejo', 10000, 1),
(7499, 254, 126, 'Valley Center', 10000, 1),
(7500, 254, 126, 'Van Nuys', 10000, 1),
(7501, 254, 126, 'Ventura', 10000, 1),
(7502, 254, 126, 'Victorville', 10000, 1),
(7503, 254, 126, 'Visalia', 10000, 1),
(7504, 254, 126, 'Vista', 10000, 1),
(7505, 254, 126, 'Walnut', 10000, 1),
(7506, 254, 126, 'Walnut Creek', 10000, 1),
(7507, 254, 126, 'Wasco', 10000, 1),
(7508, 254, 126, 'Watsonville', 10000, 1),
(7509, 254, 126, 'West Covina', 10000, 1),
(7510, 254, 126, 'West Hollywood', 10000, 1),
(7511, 254, 126, 'West Sacramento', 10000, 1),
(7512, 254, 126, 'Westlake Village', 10000, 1),
(7513, 254, 126, 'Westminster', 10000, 1),
(7514, 254, 126, 'Whittier', 10000, 1),
(7515, 254, 126, 'Wildomar', 10000, 1),
(7516, 254, 126, 'Willow Brook', 10000, 1),
(7517, 254, 126, 'Willows', 10000, 1),
(7518, 254, 126, 'Woodacre', 10000, 1),
(7519, 254, 126, 'Woodland', 10000, 1),
(7520, 254, 126, 'Woodland Hills', 10000, 1),
(7521, 254, 126, 'Wrightwood', 10000, 1),
(7522, 254, 126, 'Yorba Linda', 10000, 1),
(7523, 254, 126, 'Yosemite Village', 10000, 1),
(7524, 254, 126, 'Yreka', 10000, 1),
(7525, 254, 126, 'Yuba City', 10000, 1),
(7526, 254, 126, 'Yucaipa', 10000, 1),
(7528, 254, 127, 'Akron', 10000, 1),
(7529, 254, 127, 'Alamosa', 10000, 1),
(7530, 254, 127, 'Allenspark', 10000, 1),
(7531, 254, 127, 'Arvada', 10000, 1),
(7532, 254, 127, 'Aspen', 10000, 1),
(7533, 254, 127, 'Aurora', 10000, 1),
(7534, 254, 127, 'Boulder', 10000, 1),
(7535, 254, 127, 'Breckenridge', 10000, 1),
(7536, 254, 127, 'Broomfield', 10000, 1),
(7537, 254, 127, 'Buena Vista', 10000, 1),
(7538, 254, 127, 'Burlington', 10000, 1),
(7539, 254, 127, 'Canon City', 10000, 1),
(7540, 254, 127, 'Cheyenne Wells', 10000, 1),
(7541, 254, 127, 'Colorado Springs', 10000, 1),
(7543, 254, 127, 'Cortez', 10000, 1),
(7544, 254, 127, 'Craig', 10000, 1),
(7545, 254, 127, 'Crested Butte', 10000, 1),
(7546, 254, 127, 'Cripple Creek', 10000, 1),
(7548, 254, 127, 'Denver', 10000, 1),
(7549, 254, 127, 'Dillon', 10000, 1),
(7550, 254, 127, 'Divide', 10000, 1),
(7551, 254, 127, 'Durango', 10000, 1),
(7552, 254, 127, 'Eads', 10000, 1),
(7554, 254, 127, 'Englewood', 10000, 1),
(7555, 254, 127, 'Erie', 10000, 1),
(7556, 254, 127, 'Estes Park', 10000, 1),
(7557, 254, 127, 'Florissant', 10000, 1),
(7558, 254, 127, 'Fort Collins', 10000, 1),
(7559, 254, 127, 'Fort Morgan', 10000, 1),
(7560, 254, 127, 'Gardner', 10000, 1),
(7561, 254, 127, 'Glenwood Springs', 10000, 1),
(7562, 254, 127, 'Grand Junction', 10000, 1),
(7563, 254, 127, 'Greeley', 10000, 1),
(7564, 254, 127, 'Gunnison', 10000, 1),
(7566, 254, 127, 'Kim', 10000, 1),
(7567, 254, 127, 'La Junta', 10000, 1),
(7568, 254, 127, 'Lafayette', 10000, 1),
(7570, 254, 127, 'Lamar', 10000, 1),
(7571, 254, 127, 'Las Animas', 10000, 1),
(7572, 254, 127, 'Leadville', 10000, 1),
(7573, 254, 127, 'Limon', 10000, 1),
(7574, 254, 127, 'Littleton', 10000, 1),
(7575, 254, 127, 'Longmont', 10000, 1),
(7576, 254, 127, 'Louisville', 10000, 1),
(7577, 254, 127, 'Loveland', 10000, 1),
(7578, 254, 127, 'Lyons', 10000, 1),
(7579, 254, 127, 'Monte Vista', 10000, 1),
(7580, 254, 127, 'Montrose', 10000, 1),
(7581, 254, 127, 'Nederland', 10000, 1),
(7582, 254, 127, 'Peaceful Valley', 10000, 1),
(7583, 254, 127, 'Pueblo', 10000, 1),
(7585, 254, 127, 'Rifle', 10000, 1),
(7586, 254, 127, 'Salida', 10000, 1),
(7587, 254, 127, 'Steamboat Springs', 10000, 1),
(7588, 254, 127, 'Sterling', 10000, 1),
(7590, 254, 127, 'Telluride', 10000, 1),
(7592, 254, 127, 'Trinidad', 10000, 1),
(7593, 254, 127, 'Vail', 10000, 1),
(7594, 254, 127, 'Victor', 10000, 1),
(7595, 254, 127, 'Walsenburg', 10000, 1),
(7596, 254, 127, 'Ward', 10000, 1),
(7597, 254, 127, 'Westminster', 10000, 1),
(7598, 254, 127, 'Wheat Ridge', 10000, 1),
(7599, 254, 127, 'Winter Park', 10000, 1),
(7600, 254, 127, 'Woodland Park', 10000, 1),
(7601, 254, 127, 'Yuma', 10000, 1),
(7602, 254, 128, 'Berlin', 10000, 1),
(7603, 254, 128, 'Bridgeport', 10000, 1),
(7604, 254, 128, 'Bristol', 10000, 1),
(7605, 254, 128, 'Canaan', 10000, 1),
(7606, 254, 128, 'Cromwell', 10000, 1),
(7607, 254, 128, 'Danbury', 10000, 1),
(7608, 254, 128, 'East Hartford', 10000, 1),
(7609, 254, 128, 'East Haven', 10000, 1),
(7610, 254, 128, 'Enfield', 10000, 1),
(7611, 254, 128, 'Fairfield', 10000, 1),
(7612, 254, 128, 'Farmington', 10000, 1),
(7613, 254, 128, 'Goshen', 10000, 1),
(7614, 254, 128, 'Greenwich', 10000, 1),
(7615, 254, 128, 'Groton', 10000, 1),
(7616, 254, 128, 'Hamden', 10000, 1),
(7617, 254, 128, 'Hartford', 10000, 1),
(7618, 254, 128, 'Kent', 10000, 1),
(7619, 254, 128, 'Lebanon', 10000, 1),
(7621, 254, 128, 'Litchfield', 10000, 1),
(7622, 254, 128, 'Manchester', 10000, 1),
(7623, 254, 128, 'Meriden', 10000, 1),
(7624, 254, 128, 'Middletown', 10000, 1),
(7625, 254, 128, 'Milford', 10000, 1),
(7627, 254, 128, 'Naugatuck', 10000, 1),
(7628, 254, 128, 'New Britain', 10000, 1),
(7629, 254, 128, 'New Haven', 10000, 1),
(7630, 254, 128, 'New London', 10000, 1),
(7631, 254, 128, 'Newington', 10000, 1),
(7632, 254, 128, 'Norfolk', 10000, 1),
(7633, 254, 128, 'North Haven', 10000, 1),
(7634, 254, 128, 'Norwalk', 10000, 1),
(7635, 254, 128, 'Norwich', 10000, 1),
(7636, 254, 128, 'Old Saybrook', 10000, 1),
(7637, 254, 128, 'Orange', 10000, 1),
(7638, 254, 128, 'Plainville', 10000, 1),
(7639, 254, 128, 'Plymouth', 10000, 1),
(7640, 254, 128, 'Putnam', 10000, 1),
(7641, 254, 128, 'Rocky Hill', 10000, 1),
(7642, 254, 128, 'Shelton', 10000, 1),
(7643, 254, 128, 'Simsbury', 10000, 1),
(7644, 254, 128, 'Southington', 10000, 1),
(7645, 254, 128, 'Stamford', 10000, 1),
(7646, 254, 128, 'Storrs Mansfield', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(7647, 254, 128, 'Stratford', 10000, 1),
(7648, 254, 128, 'Torrington', 10000, 1),
(7649, 254, 128, 'Trumbull', 10000, 1),
(7650, 254, 128, 'Vernon Rockville', 10000, 1),
(7651, 254, 128, 'Wallingford', 10000, 1),
(7652, 254, 128, 'East Windsor', 10000, 1),
(7653, 254, 128, 'Waterbury', 10000, 1),
(7654, 254, 128, 'W Hartford', 10000, 1),
(7655, 254, 128, 'West Haven', 10000, 1),
(7657, 254, 128, 'Westport', 10000, 1),
(7658, 254, 128, 'Wethersfield', 10000, 1),
(7659, 254, 128, 'Willimantic', 10000, 1),
(7660, 254, 128, 'Winsted', 10000, 1),
(7663, 254, 129, 'Georgetown', 10000, 1),
(7664, 254, 129, 'Newark', 10000, 1),
(7665, 254, 129, 'Rehoboth Beach', 10000, 1),
(7666, 254, 129, 'Seaford', 10000, 1),
(7667, 254, 129, 'Wilmington', 10000, 1),
(7668, 254, 131, 'Altamonte Springs', 10000, 1),
(7669, 254, 131, 'Apalachicola', 10000, 1),
(7670, 254, 131, 'Arcadia', 10000, 1),
(7671, 254, 131, 'Avon Park', 10000, 1),
(7672, 254, 131, 'Bartow', 10000, 1),
(7673, 254, 131, 'Belle Glade', 10000, 1),
(7674, 254, 131, 'Blountstown', 10000, 1),
(7675, 254, 131, 'Boca Raton', 10000, 1),
(7676, 254, 131, 'Bonifay', 10000, 1),
(7677, 254, 131, 'Bonita Springs', 10000, 1),
(7679, 254, 131, 'Bradenton', 10000, 1),
(7680, 254, 131, 'Brandon', 10000, 1),
(7681, 254, 131, 'Bristol', 10000, 1),
(7682, 254, 131, 'Bronson', 10000, 1),
(7683, 254, 131, 'Brooksville', 10000, 1),
(7685, 254, 131, 'Bushnell', 10000, 1),
(7686, 254, 131, 'Cape Coral', 10000, 1),
(7687, 254, 131, 'Opa Locka', 10000, 1),
(7688, 254, 131, 'Casselberry', 10000, 1),
(7690, 254, 131, 'Chipley', 10000, 1),
(7691, 254, 131, 'Clearwater', 10000, 1),
(7692, 254, 131, 'Clewiston', 10000, 1),
(7693, 254, 131, 'Cocoa', 10000, 1),
(7698, 254, 131, 'Crawfordville', 10000, 1),
(7699, 254, 131, 'Crestview', 10000, 1),
(7700, 254, 131, 'Cross City', 10000, 1),
(7702, 254, 131, 'Dade City', 10000, 1),
(7703, 254, 131, 'Dania', 10000, 1),
(7704, 254, 131, 'Daytona Beach', 10000, 1),
(7706, 254, 131, 'Deland', 10000, 1),
(7707, 254, 131, 'Deerfield Beach', 10000, 1),
(7708, 254, 131, 'Delray Beach', 10000, 1),
(7709, 254, 131, 'Deltona', 10000, 1),
(7710, 254, 131, 'Destin', 10000, 1),
(7712, 254, 131, 'Dunedin', 10000, 1),
(7713, 254, 131, 'Englewood', 10000, 1),
(7714, 254, 131, 'Everglades City', 10000, 1),
(7715, 254, 131, 'Fernandina Beach', 10000, 1),
(7716, 254, 131, 'Ferry Pass', 10000, 1),
(7717, 254, 131, 'Fort Lauderdale', 10000, 1),
(7718, 254, 131, 'Fort Myers', 10000, 1),
(7719, 254, 131, 'Fort Pierce', 10000, 1),
(7720, 254, 131, 'Fort Walton Beach', 10000, 1),
(7721, 254, 131, 'Gainesville', 10000, 1),
(7722, 254, 131, 'Greenacres City', 10000, 1),
(7724, 254, 131, 'Hallandale', 10000, 1),
(7725, 254, 131, 'Hernando', 10000, 1),
(7726, 254, 131, 'Hialeah', 10000, 1),
(7727, 254, 131, 'Hollywood', 10000, 1),
(7728, 254, 131, 'Homestead Afb', 10000, 1),
(7730, 254, 131, 'Immokalee', 10000, 1),
(7731, 254, 131, 'Inverness', 10000, 1),
(7732, 254, 131, 'Jacksonville', 10000, 1),
(7733, 254, 131, 'Jasper', 10000, 1),
(7734, 254, 131, 'Jay', 10000, 1),
(7735, 254, 131, 'Jupiter', 10000, 1),
(7736, 254, 131, 'Key Biscayne', 10000, 1),
(7737, 254, 131, 'Key West', 10000, 1),
(7738, 254, 131, 'Kissimmee', 10000, 1),
(7739, 254, 131, 'Lake Butler', 10000, 1),
(7740, 254, 131, 'Lake City', 10000, 1),
(7741, 254, 131, 'Lake Placid', 10000, 1),
(7742, 254, 131, 'Lake Worth', 10000, 1),
(7743, 254, 131, 'Lakeland', 10000, 1),
(7744, 254, 131, 'Largo', 10000, 1),
(7747, 254, 131, 'Lealman', 10000, 1),
(7748, 254, 131, 'Live Oak', 10000, 1),
(7749, 254, 131, 'Lorida', 10000, 1),
(7750, 254, 131, 'Macclenny', 10000, 1),
(7751, 254, 131, 'Madison', 10000, 1),
(7752, 254, 131, 'Marathon', 10000, 1),
(7753, 254, 131, 'Marco Island', 10000, 1),
(7755, 254, 131, 'Marianna', 10000, 1),
(7756, 254, 131, 'Mary Esther', 10000, 1),
(7757, 254, 131, 'Mayo', 10000, 1),
(7759, 254, 131, 'Melbourne', 10000, 1),
(7760, 254, 131, 'Miami Beach', 10000, 1),
(7761, 254, 131, 'Middleburg', 10000, 1),
(7762, 254, 131, 'Milton', 10000, 1),
(7764, 254, 131, 'Monticello', 10000, 1),
(7765, 254, 131, 'Moore Haven', 10000, 1),
(7766, 254, 131, 'Naples', 10000, 1),
(7767, 254, 131, 'NASA Shuttle Facility', 10000, 1),
(7768, 254, 131, 'Navarre', 10000, 1),
(7769, 254, 131, 'North Fort Myers', 10000, 1),
(7771, 254, 131, 'North Miami Beach', 10000, 1),
(7772, 254, 131, 'North Port', 10000, 1),
(7773, 254, 131, 'Ocala', 10000, 1),
(7774, 254, 131, 'Okeechobee', 10000, 1),
(7776, 254, 131, 'Orlando', 10000, 1),
(7777, 254, 131, 'Ormond Beach', 10000, 1),
(7778, 254, 131, 'Palatka', 10000, 1),
(7779, 254, 131, 'Palm Bay', 10000, 1),
(7780, 254, 131, 'Palm Beach', 10000, 1),
(7782, 254, 131, 'Palm Coast', 10000, 1),
(7783, 254, 131, 'Palm Harbor', 10000, 1),
(7784, 254, 131, 'Panama City', 10000, 1),
(7785, 254, 131, 'Pembroke Pines', 10000, 1),
(7786, 254, 131, 'Pensacola', 10000, 1),
(7787, 254, 131, 'Perry', 10000, 1),
(7789, 254, 131, 'Pinellas Park', 10000, 1),
(7790, 254, 131, 'Plant City', 10000, 1),
(7792, 254, 131, 'Pompano Beach', 10000, 1),
(7793, 254, 131, 'Ponte Vedra Beach', 10000, 1),
(7794, 254, 131, 'Port Charlotte', 10000, 1),
(7795, 254, 131, 'Port Orange', 10000, 1),
(7797, 254, 131, 'Port St. Lucie', 10000, 1),
(7798, 254, 131, 'Punta Gorda', 10000, 1),
(7799, 254, 131, 'Quincy', 10000, 1),
(7801, 254, 131, 'Ruskin', 10000, 1),
(7802, 254, 131, 'Sanford', 10000, 1),
(7803, 254, 131, 'Sarasota', 10000, 1),
(7804, 254, 131, 'Sebring', 10000, 1),
(7806, 254, 131, 'Spring Hill', 10000, 1),
(7808, 254, 131, 'Starke', 10000, 1),
(7809, 254, 131, 'Stuart', 10000, 1),
(7811, 254, 131, 'Tallahassee', 10000, 1),
(7813, 254, 131, 'Tampa', 10000, 1),
(7814, 254, 131, 'Tavares', 10000, 1),
(7815, 254, 131, 'Tavernier', 10000, 1),
(7816, 254, 131, 'Titusville', 10000, 1),
(7818, 254, 131, 'Trenton', 10000, 1),
(7819, 254, 131, 'Valparaiso', 10000, 1),
(7820, 254, 131, 'Venice', 10000, 1),
(7821, 254, 131, 'Venus', 10000, 1),
(7822, 254, 131, 'Vero Beach', 10000, 1),
(7823, 254, 131, 'Wauchula', 10000, 1),
(7824, 254, 131, 'West Palm Beach', 10000, 1),
(7826, 254, 131, 'Winter Haven', 10000, 1),
(7827, 254, 131, 'Winter Park', 10000, 1),
(7828, 254, 131, 'Winter Springs', 10000, 1),
(7829, 254, 132, 'Abbeville', 10000, 1),
(7830, 254, 132, 'Adel', 10000, 1),
(7831, 254, 132, 'Alamo', 10000, 1),
(7832, 254, 132, 'Albany', 10000, 1),
(7833, 254, 132, 'Alma', 10000, 1),
(7834, 254, 132, 'Alpharetta', 10000, 1),
(7835, 254, 132, 'Americus', 10000, 1),
(7836, 254, 132, 'Appling', 10000, 1),
(7837, 254, 132, 'Ashburn', 10000, 1),
(7838, 254, 132, 'Athens', 10000, 1),
(7839, 254, 132, 'Atlanta', 10000, 1),
(7840, 254, 132, 'Augusta', 10000, 1),
(7841, 254, 132, 'Austell', 10000, 1),
(7842, 254, 132, 'Bainbridge', 10000, 1),
(7843, 254, 132, 'Barnesville', 10000, 1),
(7844, 254, 132, 'Baxley', 10000, 1),
(7845, 254, 132, 'Blackshear', 10000, 1),
(7846, 254, 132, 'Blairsville', 10000, 1),
(7847, 254, 132, 'Blakely', 10000, 1),
(7848, 254, 132, 'Blue Ridge', 10000, 1),
(7849, 254, 132, 'Brunswick', 10000, 1),
(7850, 254, 132, 'Buchanan', 10000, 1),
(7851, 254, 132, 'Buena Vista', 10000, 1),
(7852, 254, 132, 'Butler', 10000, 1),
(7853, 254, 132, 'Cairo', 10000, 1),
(7854, 254, 132, 'Calhoun', 10000, 1),
(7855, 254, 132, 'Canton', 10000, 1),
(7856, 254, 132, 'Carnesville', 10000, 1),
(7857, 254, 132, 'Carrollton', 10000, 1),
(7858, 254, 132, 'Cartersville', 10000, 1),
(7859, 254, 132, 'Cedartown', 10000, 1),
(7860, 254, 132, 'Chatsworth', 10000, 1),
(7861, 254, 132, 'Clarkesville', 10000, 1),
(7862, 254, 132, 'Clayton', 10000, 1),
(7863, 254, 132, 'Cleveland', 10000, 1),
(7864, 254, 132, 'Cochran', 10000, 1),
(7866, 254, 132, 'Colquitt', 10000, 1),
(7867, 254, 132, 'Columbus', 10000, 1),
(7868, 254, 132, 'Conyers', 10000, 1),
(7869, 254, 132, 'Cordele', 10000, 1),
(7870, 254, 132, 'Covington', 10000, 1),
(7871, 254, 132, 'Crawfordville', 10000, 1),
(7872, 254, 132, 'Cumming', 10000, 1),
(7873, 254, 132, 'Cusseta', 10000, 1),
(7874, 254, 132, 'Cuthbert', 10000, 1),
(7875, 254, 132, 'Dahlonega', 10000, 1),
(7876, 254, 132, 'Dallas', 10000, 1),
(7877, 254, 132, 'Dalton', 10000, 1),
(7878, 254, 132, 'Danielsville', 10000, 1),
(7879, 254, 132, 'Darien', 10000, 1),
(7880, 254, 132, 'Dawson', 10000, 1),
(7881, 254, 132, 'Dawsonville', 10000, 1),
(7882, 254, 132, 'Decatur', 10000, 1),
(7883, 254, 132, 'Donalsonville', 10000, 1),
(7884, 254, 132, 'Douglas', 10000, 1),
(7885, 254, 132, 'Douglasville', 10000, 1),
(7886, 254, 132, 'Dublin', 10000, 1),
(7887, 254, 132, 'Duluth', 10000, 1),
(7890, 254, 132, 'Eastman', 10000, 1),
(7891, 254, 132, 'Eatonton', 10000, 1),
(7892, 254, 132, 'Elberton', 10000, 1),
(7893, 254, 132, 'Ellaville', 10000, 1),
(7894, 254, 132, 'Ellijay', 10000, 1),
(7895, 254, 132, 'Fayetteville', 10000, 1),
(7896, 254, 132, 'Fitzgerald', 10000, 1),
(7897, 254, 132, 'Forsyth', 10000, 1),
(7898, 254, 132, 'Fort Benning', 10000, 1),
(7899, 254, 132, 'Fort Gaines', 10000, 1),
(7901, 254, 132, 'Fort Valley', 10000, 1),
(7902, 254, 132, 'Franklin', 10000, 1),
(7903, 254, 132, 'Gainesville', 10000, 1),
(7904, 254, 132, 'Georgetown', 10000, 1),
(7905, 254, 132, 'Gibson', 10000, 1),
(7906, 254, 132, 'Gray', 10000, 1),
(7907, 254, 132, 'Greensboro', 10000, 1),
(7908, 254, 132, 'Greenville', 10000, 1),
(7909, 254, 132, 'Griffin', 10000, 1),
(7910, 254, 132, 'Hagan', 10000, 1),
(7911, 254, 132, 'Hamilton', 10000, 1),
(7912, 254, 132, 'Hartwell', 10000, 1),
(7913, 254, 132, 'Hawkinsville', 10000, 1),
(7914, 254, 132, 'Hazlehurst', 10000, 1),
(7915, 254, 132, 'Hiawassee', 10000, 1),
(7916, 254, 132, 'Hinesville', 10000, 1),
(7917, 254, 132, 'Folkston', 10000, 1),
(7918, 254, 132, 'Homer', 10000, 1),
(7919, 254, 132, 'Irwinton', 10000, 1),
(7920, 254, 132, 'Jackson', 10000, 1),
(7921, 254, 132, 'Jasper', 10000, 1),
(7922, 254, 132, 'Jefferson', 10000, 1),
(7923, 254, 132, 'Jeffersonville', 10000, 1),
(7925, 254, 132, 'Jesup', 10000, 1),
(7926, 254, 132, 'Jonesboro', 10000, 1),
(7927, 254, 131, 'Kings Bay', 10000, 1),
(7928, 254, 132, 'Knoxville', 10000, 1),
(7929, 254, 139, 'La Fayette', 10000, 1),
(7931, 254, 132, 'Lakeland', 10000, 1),
(7932, 254, 132, 'Lawrenceville', 10000, 1),
(7933, 254, 132, 'Leesburg', 10000, 1),
(7934, 254, 132, 'Lexington', 10000, 1),
(7935, 254, 132, 'Lincolntown', 10000, 1),
(7936, 254, 132, 'Lithonia', 10000, 1),
(7938, 254, 132, 'Ludowici', 10000, 1),
(7939, 254, 132, 'Lumpkin', 10000, 1),
(7940, 254, 132, 'Mableton', 10000, 1),
(7941, 254, 132, 'Macon', 10000, 1),
(7942, 254, 132, 'Madison', 10000, 1),
(7943, 254, 132, 'Marietta', 10000, 1),
(7945, 254, 132, 'McDonough', 10000, 1),
(7947, 254, 132, 'Metter', 10000, 1),
(7948, 254, 132, 'Milledgeville', 10000, 1),
(7949, 254, 132, 'Millen', 10000, 1),
(7950, 254, 132, 'Monroe', 10000, 1),
(7951, 254, 132, 'Monticello', 10000, 1),
(7952, 254, 132, 'Morgan', 10000, 1),
(7953, 254, 132, 'Moultrie', 10000, 1),
(7954, 254, 132, 'Mount Vernon', 10000, 1),
(7955, 254, 132, 'Nahunta', 10000, 1),
(7956, 254, 132, 'Nashville', 10000, 1),
(7957, 254, 132, 'Newnan', 10000, 1),
(7958, 254, 132, 'Newton', 10000, 1),
(7959, 254, 132, 'Norcross', 10000, 1),
(7961, 254, 132, 'Ocilla', 10000, 1),
(7962, 254, 132, 'Odum', 10000, 1),
(7963, 254, 132, 'Oglethorpe', 10000, 1),
(7964, 254, 132, 'Peachtree City', 10000, 1),
(7965, 254, 132, 'Pearson', 10000, 1),
(7966, 254, 132, 'Pembroke', 10000, 1),
(7967, 254, 132, 'Perry', 10000, 1),
(7968, 254, 132, 'Preston', 10000, 1),
(7969, 254, 132, 'Quitman', 10000, 1),
(7970, 254, 132, 'Redan', 10000, 1),
(7971, 254, 132, 'Reidsville', 10000, 1),
(7972, 254, 132, 'Ringgold', 10000, 1),
(7973, 254, 132, 'Rome', 10000, 1),
(7974, 254, 132, 'Roswell', 10000, 1),
(7975, 254, 132, 'Sandersville', 10000, 1),
(7976, 254, 132, 'Savannah', 10000, 1),
(7977, 254, 132, 'Smyrna', 10000, 1),
(7978, 254, 132, 'Soperton', 10000, 1),
(7979, 254, 132, 'Sparta', 10000, 1),
(7980, 254, 132, 'Springfield', 10000, 1),
(7982, 254, 132, 'Statenville', 10000, 1),
(7983, 254, 132, 'Statesboro', 10000, 1),
(7984, 254, 132, 'Summerville', 10000, 1),
(7985, 254, 132, 'Swainsboro', 10000, 1),
(7986, 254, 132, 'Sylvania', 10000, 1),
(7987, 254, 132, 'Sylvester', 10000, 1),
(7988, 254, 132, 'Talbotton', 10000, 1),
(7989, 254, 132, 'Thomaston', 10000, 1),
(7990, 254, 132, 'Thomasville', 10000, 1),
(7991, 254, 132, 'Thomson', 10000, 1),
(7992, 254, 132, 'Tifton', 10000, 1),
(7993, 254, 132, 'Toccoa', 10000, 1),
(7994, 254, 132, 'Trenton', 10000, 1),
(7995, 254, 132, 'Tucker', 10000, 1),
(7996, 254, 132, 'Valdosta', 10000, 1),
(7997, 254, 132, 'Vidalia', 10000, 1),
(7998, 254, 132, 'Vienna', 10000, 1),
(7999, 254, 132, 'Warner Robins', 10000, 1),
(8000, 254, 132, 'Warrenton', 10000, 1),
(8001, 254, 132, 'Washington', 10000, 1),
(8002, 254, 132, 'Watkinsville', 10000, 1),
(8003, 254, 132, 'Waycross', 10000, 1),
(8004, 254, 132, 'Waynesboro', 10000, 1),
(8005, 254, 132, 'Winder', 10000, 1),
(8006, 254, 132, 'Woodbine', 10000, 1),
(8007, 254, 132, 'Wrightsville', 10000, 1),
(8008, 254, 133, 'Hilo', 10000, 1),
(8009, 254, 133, 'Kahului', 10000, 1),
(8010, 254, 133, 'Kailua', 10000, 1),
(8012, 254, 133, 'Kaneohe', 10000, 1),
(8013, 254, 133, 'Kaunakakai', 10000, 1),
(8014, 254, 133, 'Lahaina', 10000, 1),
(8015, 254, 133, 'Lanai City', 10000, 1),
(8016, 254, 133, 'Lihue', 10000, 1),
(8018, 254, 133, 'Pearl City', 10000, 1),
(8019, 254, 133, 'Wailuku', 10000, 1),
(8020, 254, 133, 'Waipahu', 10000, 1),
(8021, 254, 137, 'Albia', 10000, 1),
(8022, 254, 137, 'Algona', 10000, 1),
(8023, 254, 137, 'Allison', 10000, 1),
(8024, 254, 137, 'Ames', 10000, 1),
(8025, 254, 137, 'Anamosa', 10000, 1),
(8026, 254, 137, 'Ankeny', 10000, 1),
(8027, 254, 137, 'Atlantic', 10000, 1),
(8028, 254, 137, 'Audubon', 10000, 1),
(8029, 254, 137, 'Bedford', 10000, 1),
(8030, 254, 137, 'Bettendorf', 10000, 1),
(8031, 254, 137, 'Bloomfield', 10000, 1),
(8032, 254, 137, 'Boone', 10000, 1),
(8033, 254, 137, 'Burlington', 10000, 1),
(8034, 254, 137, 'Carroll', 10000, 1),
(8035, 254, 137, 'Cedar Falls', 10000, 1),
(8036, 254, 137, 'Cedar Rapids', 10000, 1),
(8037, 254, 137, 'Centerville', 10000, 1),
(8038, 254, 137, 'Chariton', 10000, 1),
(8039, 254, 137, 'Charles City', 10000, 1),
(8040, 254, 137, 'Cherokee', 10000, 1),
(8041, 254, 137, 'Clarinda', 10000, 1),
(8042, 254, 137, 'Clarion', 10000, 1),
(8043, 254, 137, 'Clear Lake', 10000, 1),
(8044, 254, 137, 'Clinton', 10000, 1),
(8045, 254, 137, 'Corning', 10000, 1),
(8046, 254, 137, 'Corydon', 10000, 1),
(8047, 254, 137, 'Council Bluffs', 10000, 1),
(8048, 254, 137, 'Cresco', 10000, 1),
(8049, 254, 137, 'Creston', 10000, 1),
(8050, 254, 137, 'Davenport', 10000, 1),
(8051, 254, 137, 'Decorah', 10000, 1),
(8052, 254, 137, 'Denison', 10000, 1),
(8053, 254, 137, 'Des Moines', 10000, 1),
(8054, 254, 137, 'Dubuque', 10000, 1),
(8055, 254, 137, 'Elkader', 10000, 1),
(8056, 254, 137, 'Emmetsburg', 10000, 1),
(8057, 254, 137, 'Estherville', 10000, 1),
(8058, 254, 137, 'Fairfield', 10000, 1),
(8059, 254, 137, 'Forest City', 10000, 1),
(8060, 254, 137, 'Fort Dodge', 10000, 1),
(8061, 254, 137, 'Fort Madison', 10000, 1),
(8062, 254, 137, 'Garner', 10000, 1),
(8063, 254, 137, 'Glenwood', 10000, 1),
(8064, 254, 137, 'Greenfield', 10000, 1),
(8065, 254, 137, 'Grundy', 10000, 1),
(8066, 254, 137, 'Guthrie Center', 10000, 1),
(8067, 254, 137, 'Harlan', 10000, 1),
(8068, 254, 137, 'Humboldt', 10000, 1),
(8069, 254, 137, 'Ida Grove', 10000, 1),
(8070, 254, 137, 'Independence', 10000, 1),
(8071, 254, 137, 'Indianola', 10000, 1),
(8072, 254, 137, 'Iowa City', 10000, 1),
(8073, 254, 137, 'Iowa Falls', 10000, 1),
(8074, 254, 137, 'Jefferson', 10000, 1),
(8075, 254, 137, 'Keokuk', 10000, 1),
(8076, 254, 137, 'Keosauqua', 10000, 1),
(8077, 254, 137, 'Kirkville', 10000, 1),
(8078, 254, 137, 'Knoxville', 10000, 1),
(8079, 254, 137, 'Lamoni', 10000, 1),
(8080, 254, 137, 'Le Mars', 10000, 1),
(8081, 254, 137, 'Leon', 10000, 1),
(8082, 254, 137, 'Logan', 10000, 1),
(8083, 254, 137, 'Manchester', 10000, 1),
(8084, 254, 137, 'Maquoketa', 10000, 1),
(8085, 254, 137, 'Marengo', 10000, 1),
(8086, 254, 137, 'Marion', 10000, 1),
(8087, 254, 137, 'Marshalltown', 10000, 1),
(8088, 254, 137, 'Mason City', 10000, 1),
(8089, 254, 137, 'Milford', 10000, 1),
(8090, 254, 137, 'Montezuma', 10000, 1),
(8091, 254, 137, 'Mount Ayr', 10000, 1),
(8092, 254, 137, 'Mount Pleasant', 10000, 1),
(8093, 254, 137, 'Muscatine', 10000, 1),
(8094, 254, 137, 'Nevada', 10000, 1),
(8095, 254, 137, 'New Hampton', 10000, 1),
(8096, 254, 137, 'Newton', 10000, 1),
(8097, 254, 137, 'Northwood', 10000, 1),
(8098, 254, 137, 'Onawa', 10000, 1),
(8099, 254, 137, 'Osage', 10000, 1),
(8100, 254, 137, 'Osceola', 10000, 1),
(8101, 254, 137, 'Oskaloosa', 10000, 1),
(8102, 254, 137, 'Ottumwa', 10000, 1),
(8103, 254, 137, 'Perry', 10000, 1),
(8104, 254, 137, 'Pocahontas', 10000, 1),
(8105, 254, 137, 'Red Oak', 10000, 1),
(8106, 254, 137, 'Rock Rapids', 10000, 1),
(8107, 254, 137, 'Rockwell City', 10000, 1),
(8108, 254, 137, 'Sac City', 10000, 1),
(8109, 254, 137, 'Sanborn', 10000, 1),
(8110, 254, 137, 'Shenandoah', 10000, 1),
(8111, 254, 137, 'Sibley', 10000, 1),
(8112, 254, 137, 'Sigourney', 10000, 1),
(8113, 254, 137, 'Sioux Center', 10000, 1),
(8114, 254, 137, 'Sioux City', 10000, 1),
(8115, 254, 137, 'Spencer', 10000, 1),
(8116, 254, 137, 'Storm Lake', 10000, 1),
(8117, 254, 137, 'Tipton', 10000, 1),
(8118, 254, 137, 'Toledo', 10000, 1),
(8119, 254, 137, 'Urbandale', 10000, 1),
(8120, 254, 137, 'Vinton', 10000, 1),
(8121, 254, 137, 'Wapello', 10000, 1),
(8122, 254, 137, 'Washington', 10000, 1),
(8123, 254, 137, 'Waterloo', 10000, 1),
(8124, 254, 137, 'Waukon', 10000, 1),
(8125, 254, 137, 'Waverly', 10000, 1),
(8126, 254, 137, 'Webster City', 10000, 1),
(8127, 254, 137, 'West Des Moines', 10000, 1),
(8128, 254, 137, 'West Point', 10000, 1),
(8129, 254, 137, 'West Union', 10000, 1),
(8130, 254, 137, 'Winterset', 10000, 1),
(8131, 254, 134, 'Bear Lake', 10000, 1),
(8132, 254, 134, 'Boise', 10000, 1),
(8133, 254, 134, 'Burley', 10000, 1),
(8134, 254, 134, 'Caldwell', 10000, 1),
(8135, 254, 134, 'Challis', 10000, 1),
(8137, 254, 134, 'Eagle', 10000, 1),
(8138, 254, 134, 'Elk City', 10000, 1),
(8139, 254, 134, 'Grace', 10000, 1),
(8140, 254, 134, 'Grangeville', 10000, 1),
(8141, 254, 134, 'Hagerman', 10000, 1),
(8142, 254, 134, 'Hailey', 10000, 1),
(8143, 254, 134, 'Idaho Falls', 10000, 1),
(8144, 254, 134, 'Island Park', 10000, 1),
(8145, 254, 134, 'Jerome', 10000, 1),
(8146, 254, 134, 'Lewiston', 10000, 1),
(8147, 254, 134, 'Malad City', 10000, 1),
(8148, 254, 134, 'Malta', 10000, 1),
(8149, 254, 134, 'McCall', 10000, 1),
(8150, 254, 134, 'Montpelier', 10000, 1),
(8151, 254, 134, 'Moscow', 10000, 1),
(8152, 254, 134, 'Mountain Home', 10000, 1),
(8153, 254, 134, 'Mullan', 10000, 1),
(8154, 254, 134, 'Nampa', 10000, 1),
(8155, 254, 134, 'Orofino', 10000, 1),
(8156, 254, 134, 'Pocatello', 10000, 1),
(8157, 254, 134, 'Rexburg', 10000, 1),
(8158, 254, 134, 'Riggins', 10000, 1),
(8159, 254, 134, 'Salmon', 10000, 1),
(8161, 254, 134, 'Stanley', 10000, 1),
(8162, 254, 134, 'Sun Valley', 10000, 1),
(8163, 254, 134, 'Twin Falls', 10000, 1),
(8164, 254, 135, 'Addison', 10000, 1),
(8165, 254, 135, 'Albion', 10000, 1),
(8166, 254, 135, 'Aledo', 10000, 1),
(8167, 254, 135, 'Alton', 10000, 1),
(8168, 254, 135, 'Anna', 10000, 1),
(8169, 254, 135, 'Arlington Heights', 10000, 1),
(8170, 254, 135, 'Aurora', 10000, 1),
(8171, 254, 135, 'Bartlett', 10000, 1),
(8172, 254, 135, 'Beardstown', 10000, 1),
(8173, 254, 135, 'Belleville', 10000, 1),
(8174, 254, 135, 'Bellwood', 10000, 1),
(8175, 254, 135, 'Belvidere', 10000, 1),
(8176, 254, 135, 'Benton', 10000, 1),
(8177, 254, 135, 'Berwyn', 10000, 1),
(8178, 254, 135, 'Bloomington', 10000, 1),
(8179, 254, 135, 'Blue Island', 10000, 1),
(8180, 254, 135, 'Bolingbrook', 10000, 1),
(8181, 254, 135, 'Buffalo Grove', 10000, 1),
(8182, 254, 135, 'Burbank', 10000, 1),
(8183, 254, 135, 'Cairo', 10000, 1),
(8184, 254, 135, 'Calumet City', 10000, 1),
(8185, 254, 135, 'Carbondale', 10000, 1),
(8186, 254, 135, 'Carlinville', 10000, 1),
(8187, 254, 135, 'Carlyle', 10000, 1),
(8188, 254, 135, 'Carmi', 10000, 1),
(8189, 254, 135, 'Carol Stream', 10000, 1),
(8190, 254, 135, 'Carpentersville', 10000, 1),
(8191, 254, 135, 'Carrollton', 10000, 1),
(8192, 254, 135, 'Carthage', 10000, 1),
(8193, 254, 135, 'Centralia', 10000, 1),
(8194, 254, 135, 'Champaign', 10000, 1),
(8195, 254, 135, 'Charleston', 10000, 1),
(8196, 254, 135, 'Chatham', 10000, 1),
(8197, 254, 135, 'Chester', 10000, 1),
(8198, 254, 135, 'Chicago', 10000, 1),
(8199, 254, 135, 'Chicago Heights', 10000, 1),
(8201, 254, 135, 'Cicero', 10000, 1),
(8202, 254, 135, 'Clinton', 10000, 1),
(8203, 254, 135, 'Collinsville', 10000, 1),
(8204, 254, 135, 'Crystal Lake', 10000, 1),
(8205, 254, 135, 'Danville', 10000, 1),
(8206, 254, 135, 'Darien', 10000, 1),
(8207, 254, 135, 'Decatur', 10000, 1),
(8208, 254, 135, 'Deerfield', 10000, 1),
(8209, 254, 135, 'Dekalb', 10000, 1),
(8210, 254, 135, 'Des Plaines', 10000, 1),
(8211, 254, 135, 'Dixon', 10000, 1),
(8212, 254, 135, 'Dolton', 10000, 1),
(8213, 254, 135, 'Downers Grove', 10000, 1),
(8214, 254, 135, 'Du Quoin', 10000, 1),
(8215, 254, 135, 'East Moline', 10000, 1),
(8216, 254, 135, 'East Peoria', 10000, 1),
(8217, 254, 135, 'East Saint Louis', 10000, 1),
(8218, 254, 135, 'Edwardsville', 10000, 1),
(8219, 254, 135, 'Effingham', 10000, 1),
(8220, 254, 135, 'Eldorado', 10000, 1),
(8221, 254, 135, 'Elgin', 10000, 1),
(8222, 254, 135, 'Elizabethtown', 10000, 1),
(8223, 254, 135, 'Elk Grove Village', 10000, 1),
(8224, 254, 135, 'Elmhurst', 10000, 1),
(8225, 254, 135, 'Elmwood Park', 10000, 1),
(8226, 254, 135, 'Evanston', 10000, 1),
(8227, 254, 135, 'Evergreen Park', 10000, 1),
(8228, 254, 135, 'Fairfield', 10000, 1),
(8229, 254, 135, 'Flora', 10000, 1),
(8230, 254, 135, 'Franklin Park', 10000, 1),
(8231, 254, 135, 'Freeport', 10000, 1),
(8232, 254, 135, 'Galena', 10000, 1),
(8233, 254, 135, 'Galesburg', 10000, 1),
(8234, 254, 135, 'Geneseo', 10000, 1),
(8235, 254, 135, 'Glen Ellyn', 10000, 1),
(8236, 254, 135, 'Glendale Heights', 10000, 1),
(8237, 254, 135, 'Glenview', 10000, 1),
(8238, 254, 135, 'Golconda', 10000, 1),
(8239, 254, 135, 'Goodwine', 10000, 1),
(8240, 254, 135, 'Granite City', 10000, 1),
(8241, 254, 135, 'Greenville', 10000, 1),
(8242, 254, 135, 'Hammond', 10000, 1),
(8243, 254, 135, 'Hardin', 10000, 1),
(8244, 254, 135, 'Harrisburg', 10000, 1),
(8245, 254, 135, 'Harvey', 10000, 1),
(8246, 254, 135, 'Havana', 10000, 1),
(8247, 254, 135, 'Highland Park', 10000, 1),
(8248, 254, 135, 'Hillsboro', 10000, 1),
(8249, 254, 135, 'Hillside', 10000, 1),
(8250, 254, 135, 'Hoffman Estates', 10000, 1),
(8251, 254, 135, 'Homewood', 10000, 1),
(8252, 254, 135, 'Jacksonville', 10000, 1),
(8253, 254, 135, 'Jerseyville', 10000, 1),
(8254, 254, 135, 'Joliet', 10000, 1),
(8255, 254, 135, 'Kankakee', 10000, 1),
(8256, 254, 135, 'Lacon', 10000, 1),
(8257, 254, 135, 'Lansing', 10000, 1),
(8258, 254, 135, 'Lawrenceville', 10000, 1),
(8259, 254, 135, 'Lewistown', 10000, 1),
(8260, 254, 135, 'Libertyville', 10000, 1),
(8261, 254, 135, 'Lisle', 10000, 1),
(8262, 254, 135, 'Litchfield', 10000, 1),
(8263, 254, 135, 'Lombard', 10000, 1),
(8264, 254, 135, 'Machesney Park', 10000, 1),
(8265, 254, 135, 'Marion', 10000, 1),
(8266, 254, 135, 'Marseilles', 10000, 1),
(8267, 254, 135, 'Marshall', 10000, 1),
(8268, 254, 135, 'Mattoon', 10000, 1),
(8269, 254, 135, 'Maywood', 10000, 1),
(8270, 254, 135, 'Mc Leansboro', 10000, 1),
(8271, 254, 135, 'Melrose Park', 10000, 1),
(8272, 254, 135, 'Metropolis', 10000, 1),
(8273, 254, 135, 'Moline', 10000, 1),
(8274, 254, 135, 'Monticello', 10000, 1),
(8275, 254, 135, 'Morris', 10000, 1),
(8276, 254, 135, 'Morton Grove', 10000, 1),
(8277, 254, 135, 'Mound City', 10000, 1),
(8278, 254, 135, 'Mount Carmel', 10000, 1),
(8279, 254, 135, 'Mount Carroll', 10000, 1),
(8280, 254, 135, 'Mount Prospect', 10000, 1),
(8281, 254, 135, 'Mount Sterling', 10000, 1),
(8282, 254, 135, 'Mount Vernon', 10000, 1),
(8283, 254, 135, 'Mundelein', 10000, 1),
(8284, 254, 135, 'Naperville', 10000, 1),
(8285, 254, 135, 'Nashville', 10000, 1),
(8286, 254, 135, 'Newton', 10000, 1),
(8287, 254, 135, 'Niles', 10000, 1),
(8288, 254, 135, 'Normal', 10000, 1),
(8289, 254, 135, 'North Chicago', 10000, 1),
(8290, 254, 135, 'Northbrook', 10000, 1),
(8291, 254, 135, 'Oak Forest', 10000, 1),
(8292, 254, 135, 'Oak Lawn', 10000, 1),
(8293, 254, 135, 'Oak Park', 10000, 1),
(8294, 254, 135, 'Olney', 10000, 1),
(8295, 254, 135, 'Oquawka', 10000, 1),
(8296, 254, 135, 'Orland Park', 10000, 1),
(8297, 254, 135, 'Ottawa', 10000, 1),
(8298, 254, 135, 'Palatine', 10000, 1),
(8299, 254, 135, 'Paris', 10000, 1),
(8300, 254, 135, 'Park Forest', 10000, 1),
(8301, 254, 135, 'Park Ridge', 10000, 1),
(8302, 254, 135, 'Paxton', 10000, 1),
(8303, 254, 135, 'Pekin', 10000, 1),
(8304, 254, 135, 'Peoria', 10000, 1),
(8305, 254, 135, 'Petersburg', 10000, 1),
(8306, 254, 135, 'Pittsfield', 10000, 1),
(8307, 254, 135, 'Plano', 10000, 1),
(8308, 254, 135, 'Pontiac', 10000, 1),
(8309, 254, 135, 'Princeton', 10000, 1),
(8310, 254, 135, 'Quincy', 10000, 1),
(8311, 254, 135, 'Rantoul', 10000, 1),
(8312, 254, 135, 'Roanoke', 10000, 1),
(8313, 254, 135, 'Robinson', 10000, 1),
(8314, 254, 135, 'Rochelle', 10000, 1),
(8315, 254, 135, 'Rock Island', 10000, 1),
(8316, 254, 135, 'Rockford', 10000, 1),
(8317, 254, 135, 'Rolling Meadows', 10000, 1),
(8318, 254, 135, 'Roselle', 10000, 1),
(8319, 254, 135, 'Rosiclare', 10000, 1),
(8320, 254, 135, 'Rushville', 10000, 1),
(8321, 254, 135, 'Salem', 10000, 1),
(8323, 254, 135, 'Schaumburg', 10000, 1),
(8324, 254, 135, 'Shawneetown', 10000, 1),
(8325, 254, 135, 'Shelbyville', 10000, 1),
(8326, 254, 135, 'Skokie', 10000, 1),
(8327, 254, 135, 'South Holland', 10000, 1),
(8328, 254, 135, 'Spring Valley', 10000, 1),
(8329, 254, 135, 'Springfield', 10000, 1),
(8331, 254, 135, 'Sterling', 10000, 1),
(8332, 254, 135, 'Streamwood', 10000, 1),
(8333, 254, 135, 'Sullivan', 10000, 1),
(8334, 254, 135, 'Taylorville', 10000, 1),
(8335, 254, 135, 'Tinley Park', 10000, 1),
(8336, 254, 135, 'Toledo', 10000, 1),
(8337, 254, 135, 'Toulon', 10000, 1),
(8338, 254, 135, 'Tuscola', 10000, 1),
(8340, 254, 135, 'Urbana', 10000, 1),
(8341, 254, 135, 'Vandalia', 10000, 1),
(8342, 254, 135, 'Victoria', 10000, 1),
(8343, 254, 135, 'Vienna', 10000, 1),
(8344, 254, 135, 'Villa Park', 10000, 1),
(8345, 254, 135, 'Waterloo', 10000, 1),
(8346, 254, 135, 'Watseka', 10000, 1),
(8347, 254, 135, 'Waukegan', 10000, 1),
(8348, 254, 135, 'Westmont', 10000, 1),
(8349, 254, 135, 'Wheaton', 10000, 1),
(8350, 254, 135, 'Wheeling', 10000, 1),
(8351, 254, 135, 'Wilmette', 10000, 1),
(8352, 254, 135, 'Winchester', 10000, 1),
(8353, 254, 135, 'Woodridge', 10000, 1),
(8354, 254, 135, 'Woodstock', 10000, 1),
(8355, 254, 135, 'Zion', 10000, 1),
(8356, 254, 136, 'Anderson', 10000, 1),
(8357, 254, 136, 'Angola', 10000, 1),
(8358, 254, 136, 'Auburn', 10000, 1),
(8359, 254, 136, 'Bedford', 10000, 1),
(8360, 254, 136, 'Bloomington', 10000, 1),
(8361, 254, 136, 'Bluffton', 10000, 1),
(8362, 254, 136, 'Boonville', 10000, 1),
(8363, 254, 136, 'Brazil', 10000, 1),
(8364, 254, 136, 'Brookville', 10000, 1),
(8365, 254, 136, 'Brownsburg', 10000, 1),
(8366, 254, 136, 'Brownstown', 10000, 1),
(8367, 254, 136, 'Carmel', 10000, 1),
(8368, 254, 136, 'Charlestown', 10000, 1),
(8369, 254, 136, 'Clarksville', 10000, 1),
(8370, 254, 136, 'Columbia City', 10000, 1),
(8371, 254, 136, 'Columbus', 10000, 1),
(8372, 254, 136, 'Connersville', 10000, 1),
(8373, 254, 136, 'Corydon', 10000, 1),
(8374, 254, 136, 'Crawfordsville', 10000, 1),
(8375, 254, 136, 'Decatur', 10000, 1),
(8376, 254, 136, 'Delphi', 10000, 1),
(8377, 254, 136, 'East Chicago', 10000, 1),
(8378, 254, 136, 'Elkhart', 10000, 1),
(8379, 254, 136, 'English', 10000, 1),
(8380, 254, 136, 'Evansville', 10000, 1),
(8381, 254, 136, 'Fort Wayne', 10000, 1),
(8382, 254, 136, 'Fowler', 10000, 1),
(8383, 254, 136, 'Frankfort', 10000, 1),
(8384, 254, 136, 'Franklin', 10000, 1),
(8385, 254, 136, 'French Lick', 10000, 1),
(8386, 254, 136, 'Gary', 10000, 1),
(8387, 254, 136, 'Goshen', 10000, 1),
(8388, 254, 136, 'Granger', 10000, 1),
(8389, 254, 136, 'Greencastle', 10000, 1),
(8390, 254, 136, 'Greenfield', 10000, 1),
(8391, 254, 136, 'Greensburg', 10000, 1),
(8392, 254, 136, 'Greenwood', 10000, 1),
(8393, 254, 136, 'Hammond', 10000, 1),
(8395, 254, 136, 'Hartford City', 10000, 1),
(8396, 254, 136, 'Highland', 10000, 1),
(8397, 254, 136, 'Hobart', 10000, 1),
(8398, 254, 136, 'Huntington', 10000, 1),
(8399, 254, 136, 'Indianapolis', 10000, 1),
(8400, 254, 136, 'Jasper', 10000, 1),
(8401, 254, 136, 'Jeffersonville', 10000, 1),
(8402, 254, 136, 'Kendallville', 10000, 1),
(8403, 254, 136, 'Kentland', 10000, 1),
(8404, 254, 136, 'Knox', 10000, 1),
(8405, 254, 136, 'Kokomo', 10000, 1),
(8406, 254, 136, 'La Porte', 10000, 1),
(8407, 254, 136, 'Lafayette', 10000, 1),
(8408, 254, 136, 'Lagrange', 10000, 1),
(8410, 254, 136, 'Lawrenceburg', 10000, 1),
(8411, 254, 136, 'Lebanon', 10000, 1),
(8412, 254, 136, 'Liberty', 10000, 1),
(8413, 254, 136, 'Linton', 10000, 1),
(8414, 254, 136, 'Logansport', 10000, 1),
(8415, 254, 136, 'Madison', 10000, 1),
(8416, 254, 136, 'Marion', 10000, 1),
(8417, 254, 136, 'Martinsville', 10000, 1),
(8418, 254, 136, 'Merrillville', 10000, 1),
(8419, 254, 136, 'Michigan City', 10000, 1),
(8420, 254, 136, 'Mishawaka', 10000, 1),
(8421, 254, 136, 'Monticello', 10000, 1),
(8422, 254, 136, 'Mount Vernon', 10000, 1),
(8423, 254, 136, 'Muncie', 10000, 1),
(8424, 254, 136, 'Munster', 10000, 1),
(8425, 254, 136, 'Nashville', 10000, 1),
(8426, 254, 136, 'New Albany', 10000, 1),
(8427, 254, 136, 'New Castle', 10000, 1),
(8428, 254, 136, 'New Goshen', 10000, 1),
(8429, 254, 136, 'Newport', 10000, 1),
(8430, 254, 136, 'Noblesville', 10000, 1),
(8431, 254, 136, 'Osgood', 10000, 1),
(8433, 254, 136, 'Grissom AFB', 10000, 1),
(8434, 254, 136, 'Petersburg', 10000, 1),
(8435, 254, 136, 'Plainfield', 10000, 1),
(8436, 254, 136, 'Plymouth', 10000, 1),
(8437, 254, 136, 'Portage', 10000, 1),
(8439, 254, 136, 'Portland', 10000, 1),
(8440, 254, 136, 'Princeton', 10000, 1),
(8441, 254, 136, 'Rensselaer', 10000, 1),
(8442, 254, 136, 'Richmond', 10000, 1),
(8443, 254, 136, 'Rising Sun', 10000, 1),
(8444, 254, 136, 'Rochester', 10000, 1),
(8445, 254, 136, 'Rockville', 10000, 1),
(8446, 254, 136, 'Rushville', 10000, 1),
(8447, 254, 136, 'Salem', 10000, 1),
(8448, 254, 136, 'Santa Claus', 10000, 1),
(8449, 254, 136, 'Schererville', 10000, 1),
(8450, 254, 136, 'Scottsburg', 10000, 1),
(8451, 254, 136, 'Seymour', 10000, 1),
(8452, 254, 136, 'Shelbyville', 10000, 1),
(8453, 254, 136, 'Shoals', 10000, 1),
(8454, 254, 136, 'South Bend', 10000, 1),
(8455, 254, 136, 'Spencer', 10000, 1),
(8456, 254, 136, 'Sullivan', 10000, 1),
(8457, 254, 136, 'Tell City', 10000, 1),
(8458, 254, 136, 'Terre Haute', 10000, 1),
(8459, 254, 136, 'Tipton', 10000, 1),
(8460, 254, 136, 'Valparaiso', 10000, 1),
(8461, 254, 136, 'Veedersburg', 10000, 1),
(8462, 254, 136, 'Vevay', 10000, 1),
(8463, 254, 136, 'Vincennes', 10000, 1),
(8464, 254, 136, 'Wabash', 10000, 1),
(8465, 254, 136, 'Warsaw', 10000, 1),
(8466, 254, 136, 'Washington', 10000, 1),
(8467, 254, 136, 'West Lafayette', 10000, 1),
(8468, 254, 136, 'Williamsport', 10000, 1),
(8469, 254, 136, 'Winamac', 10000, 1),
(8470, 254, 136, 'Winchester', 10000, 1),
(8471, 254, 138, 'Abilene', 10000, 1),
(8472, 254, 138, 'Anthony', 10000, 1),
(8473, 254, 138, 'Ashland', 10000, 1),
(8474, 254, 138, 'Atchison', 10000, 1),
(8475, 254, 138, 'Atwood', 10000, 1),
(8476, 254, 138, 'Bazaar', 10000, 1),
(8477, 254, 138, 'Belleville', 10000, 1),
(8478, 254, 138, 'Beloit', 10000, 1),
(8479, 254, 138, 'Blue Rapids', 10000, 1),
(8480, 254, 138, 'Burlington', 10000, 1),
(8481, 254, 138, 'Chanute', 10000, 1),
(8482, 254, 138, 'Chase', 10000, 1),
(8483, 254, 138, 'Cimarron', 10000, 1),
(8484, 254, 138, 'Clay Center', 10000, 1),
(8485, 254, 138, 'Colby', 10000, 1),
(8486, 254, 138, 'Coldwater', 10000, 1),
(8487, 254, 138, 'Columbus', 10000, 1),
(8488, 254, 138, 'Concordia', 10000, 1),
(8489, 254, 138, 'Council Grove', 10000, 1),
(8490, 254, 138, 'Dighton', 10000, 1),
(8491, 254, 138, 'Dodge City', 10000, 1),
(8492, 254, 138, 'Edwardsville', 10000, 1),
(8493, 254, 138, 'El Dorado', 10000, 1),
(8494, 254, 138, 'Elkhart', 10000, 1),
(8495, 254, 138, 'Ellsworth', 10000, 1),
(8496, 254, 138, 'Emporia', 10000, 1),
(8497, 254, 138, 'Eureka', 10000, 1),
(8499, 254, 138, 'Fort Scott', 10000, 1),
(8500, 254, 138, 'Fredonia', 10000, 1),
(8501, 254, 138, 'Garden City', 10000, 1),
(8502, 254, 138, 'Garnett', 10000, 1),
(8503, 254, 138, 'Goodland', 10000, 1),
(8504, 254, 138, 'Gove', 10000, 1),
(8505, 254, 138, 'Great Bend', 10000, 1),
(8506, 254, 138, 'Greensburg', 10000, 1),
(8507, 254, 138, 'Hays', 10000, 1),
(8508, 254, 138, 'Hiawatha', 10000, 1),
(8509, 254, 138, 'Hill City', 10000, 1),
(8510, 254, 138, 'Hillsboro', 10000, 1),
(8511, 254, 138, 'Holton', 10000, 1),
(8512, 254, 138, 'Howard', 10000, 1),
(8513, 254, 138, 'Hoxie', 10000, 1),
(8514, 254, 138, 'Hugoton', 10000, 1),
(8515, 254, 138, 'Hutchinson', 10000, 1),
(8516, 254, 138, 'Independence', 10000, 1),
(8517, 254, 138, 'Iola', 10000, 1),
(8518, 254, 138, 'Jetmore', 10000, 1),
(8519, 254, 138, 'Johnson City', 10000, 1),
(8520, 254, 138, 'Junction City', 10000, 1),
(8521, 254, 138, 'Kingman', 10000, 1),
(8522, 254, 138, 'Kinsley', 10000, 1),
(8523, 254, 138, 'La Crosse', 10000, 1),
(8524, 254, 138, 'Lakin', 10000, 1),
(8525, 254, 138, 'Larned', 10000, 1),
(8526, 254, 138, 'Lawrence', 10000, 1),
(8527, 254, 138, 'Leavenworth', 10000, 1),
(8530, 254, 138, 'Leoti', 10000, 1),
(8531, 254, 138, 'Liberal', 10000, 1),
(8532, 254, 138, 'Lincoln', 10000, 1),
(8533, 254, 138, 'Lyndon', 10000, 1),
(8534, 254, 138, 'Lyons', 10000, 1),
(8535, 254, 138, 'Manhattan', 10000, 1),
(8536, 254, 138, 'Mankato', 10000, 1),
(8537, 254, 138, 'Marion', 10000, 1),
(8538, 254, 138, 'Mc Farland', 10000, 1),
(8539, 254, 138, 'McPherson', 10000, 1),
(8540, 254, 138, 'Meade', 10000, 1),
(8541, 254, 138, 'Medicine Lodge', 10000, 1),
(8542, 254, 138, 'Minneapolis', 10000, 1),
(8543, 254, 138, 'Mound City', 10000, 1),
(8544, 254, 138, 'Ness City', 10000, 1),
(8545, 254, 138, 'Newton', 10000, 1),
(8546, 254, 138, 'Norton', 10000, 1),
(8547, 254, 138, 'Oakley', 10000, 1),
(8548, 254, 138, 'Oberlin', 10000, 1),
(8549, 254, 138, 'Olathe', 10000, 1),
(8550, 254, 138, 'Osawatomie', 10000, 1),
(8551, 254, 138, 'Osborne', 10000, 1),
(8552, 254, 138, 'Oswego', 10000, 1),
(8553, 254, 138, 'Ottawa', 10000, 1),
(8554, 254, 138, 'Shawnee Mission', 10000, 1),
(8556, 254, 138, 'Parsons', 10000, 1),
(8557, 254, 138, 'Phillipsburg', 10000, 1),
(8558, 254, 138, 'Pittsburg', 10000, 1),
(8560, 254, 138, 'Pratt', 10000, 1),
(8562, 254, 138, 'Richfield', 10000, 1),
(8563, 254, 138, 'Russell', 10000, 1),
(8564, 254, 138, 'Salina', 10000, 1),
(8565, 254, 138, 'Scott City', 10000, 1),
(8566, 254, 138, 'Sedan', 10000, 1),
(8567, 254, 138, 'Seneca', 10000, 1),
(8568, 254, 138, 'Sharon Springs', 10000, 1),
(8570, 254, 138, 'Smith Center', 10000, 1),
(8571, 254, 138, 'Saint Francis', 10000, 1),
(8572, 254, 138, 'Saint John', 10000, 1),
(8573, 254, 138, 'Stockton', 10000, 1),
(8574, 254, 138, 'Sublette', 10000, 1),
(8575, 254, 138, 'Syracuse', 10000, 1),
(8576, 254, 138, 'Topeka', 10000, 1),
(8577, 254, 138, 'Tribune', 10000, 1),
(8578, 254, 138, 'Troy', 10000, 1),
(8579, 254, 138, 'Ulysses', 10000, 1),
(8580, 254, 138, 'Valley Falls', 10000, 1),
(8581, 254, 138, 'Wa Keeney', 10000, 1),
(8582, 254, 138, 'Washington', 10000, 1),
(8583, 254, 138, 'Wellington', 10000, 1),
(8584, 254, 138, 'Westmoreland', 10000, 1),
(8585, 254, 138, 'Wichita', 10000, 1),
(8586, 254, 138, 'Winfield', 10000, 1),
(8587, 254, 138, 'Yates Center', 10000, 1),
(8588, 254, 139, 'Albany', 10000, 1),
(8589, 254, 139, 'Alexandria', 10000, 1),
(8590, 254, 139, 'Ashland', 10000, 1),
(8591, 254, 139, 'Barbourville', 10000, 1),
(8592, 254, 139, 'Bardstown', 10000, 1),
(8593, 254, 139, 'Bardwell', 10000, 1),
(8594, 254, 139, 'Beattyville', 10000, 1),
(8595, 254, 139, 'Bedford', 10000, 1),
(8596, 254, 139, 'Benton', 10000, 1),
(8597, 254, 139, 'Booneville', 10000, 1),
(8598, 254, 139, 'Bowling Green', 10000, 1),
(8599, 254, 139, 'Brandenburg', 10000, 1),
(8600, 254, 139, 'Brooksville', 10000, 1),
(8601, 254, 139, 'Brownsville', 10000, 1),
(8602, 254, 139, 'Burkesville', 10000, 1),
(8603, 254, 139, 'Cadiz', 10000, 1),
(8604, 254, 139, 'Calhoun', 10000, 1),
(8605, 254, 139, 'Campbellsville', 10000, 1),
(8606, 254, 139, 'Campton', 10000, 1),
(8607, 254, 139, 'Carlisle', 10000, 1),
(8608, 254, 139, 'Carrollton', 10000, 1),
(8609, 254, 139, 'Catlettsburg', 10000, 1),
(8610, 254, 139, 'Clinton', 10000, 1),
(8611, 254, 139, 'Columbia', 10000, 1),
(8612, 254, 139, 'Covington', 10000, 1),
(8613, 254, 139, 'Cynthiana', 10000, 1),
(8614, 254, 139, 'Danville', 10000, 1),
(8615, 254, 139, 'Dixon', 10000, 1),
(8616, 254, 139, 'Eddyville', 10000, 1),
(8617, 254, 139, 'Edmonton', 10000, 1),
(8618, 254, 139, 'Elizabethtown', 10000, 1),
(8619, 254, 139, 'Elkton', 10000, 1),
(8620, 254, 139, 'Falmouth', 10000, 1),
(8621, 254, 139, 'Flemingsburg', 10000, 1),
(8622, 254, 139, 'Florence', 10000, 1),
(8624, 254, 139, 'Frankfort', 10000, 1),
(8625, 254, 139, 'Franklin', 10000, 1),
(8626, 254, 139, 'Frenchburg', 10000, 1),
(8627, 254, 139, 'Georgetown', 10000, 1),
(8628, 254, 139, 'Glasgow', 10000, 1),
(8629, 254, 139, 'Grayson', 10000, 1),
(8630, 254, 139, 'Greensburg', 10000, 1),
(8631, 254, 139, 'Greenup', 10000, 1),
(8632, 254, 139, 'Greenville', 10000, 1),
(8633, 254, 139, 'Hardinsburg', 10000, 1),
(8634, 254, 139, 'Harlan', 10000, 1),
(8635, 254, 139, 'Harrodsburg', 10000, 1),
(8636, 254, 139, 'Hartford', 10000, 1),
(8637, 254, 139, 'Hawesville', 10000, 1),
(8638, 254, 139, 'Henderson', 10000, 1),
(8639, 254, 139, 'Hickman', 10000, 1),
(8641, 254, 139, 'Hindman', 10000, 1),
(8642, 254, 139, 'Hodgenville', 10000, 1),
(8643, 254, 139, 'Hopkinsville', 10000, 1),
(8644, 254, 139, 'Hyden', 10000, 1),
(8645, 254, 139, 'Independence', 10000, 1),
(8646, 254, 139, 'Inez', 10000, 1),
(8647, 254, 139, 'Irvine', 10000, 1),
(8648, 254, 139, 'Jackson', 10000, 1),
(8649, 254, 139, 'Jamestown', 10000, 1),
(8651, 254, 139, 'La Grange', 10000, 1),
(8652, 254, 139, 'Lancaster', 10000, 1),
(8653, 254, 139, 'Lawrenceburg', 10000, 1),
(8654, 254, 139, 'Lebanon', 10000, 1),
(8655, 254, 139, 'Leitchfield', 10000, 1),
(8656, 254, 139, 'Lexington', 10000, 1),
(8657, 254, 139, 'Liberty', 10000, 1),
(8658, 254, 139, 'London', 10000, 1),
(8659, 254, 139, 'Louisa', 10000, 1),
(8660, 254, 139, 'Louisville', 10000, 1),
(8661, 254, 139, 'Madisonville', 10000, 1),
(8663, 254, 139, 'Manchester', 10000, 1),
(8664, 254, 139, 'Marion', 10000, 1),
(8665, 254, 139, 'Mayfield', 10000, 1),
(8666, 254, 139, 'Maysville', 10000, 1),
(8668, 254, 139, 'Middlesboro', 10000, 1),
(8669, 254, 139, 'Monticello', 10000, 1),
(8670, 254, 139, 'Morehead', 10000, 1),
(8671, 254, 139, 'Morganfield', 10000, 1),
(8672, 254, 139, 'Morgantown', 10000, 1),
(8673, 254, 139, 'Mount Olivet', 10000, 1),
(8674, 254, 139, 'Mount Sterling', 10000, 1),
(8675, 254, 139, 'Mount Vernon', 10000, 1),
(8676, 254, 139, 'Munfordville', 10000, 1),
(8677, 254, 139, 'Murray', 10000, 1),
(8678, 254, 139, 'New Castle', 10000, 1),
(8679, 254, 139, 'Newburg', 10000, 1),
(8680, 254, 139, 'Newport', 10000, 1),
(8681, 254, 139, 'Nicholasville', 10000, 1),
(8682, 254, 139, 'Owensboro', 10000, 1),
(8683, 254, 139, 'Owenton', 10000, 1),
(8684, 254, 139, 'Owingsville', 10000, 1),
(8685, 254, 139, 'Paducah', 10000, 1),
(8686, 254, 139, 'Paintsville', 10000, 1),
(8687, 254, 139, 'Paris', 10000, 1),
(8688, 254, 139, 'Pikeville', 10000, 1),
(8689, 254, 139, 'Prestonsburg', 10000, 1),
(8691, 254, 139, 'Princeton', 10000, 1),
(8692, 254, 139, 'Radcliff', 10000, 1),
(8693, 254, 139, 'Richmond', 10000, 1),
(8694, 254, 139, 'Russellville', 10000, 1),
(8695, 254, 139, 'Salyersville', 10000, 1),
(8696, 254, 139, 'Sandy Hook', 10000, 1),
(8697, 254, 139, 'Scottsville', 10000, 1),
(8698, 254, 139, 'Shelbyville', 10000, 1),
(8699, 254, 139, 'Shepherdsville', 10000, 1),
(8700, 254, 139, 'Smithland', 10000, 1),
(8701, 254, 139, 'Somerset', 10000, 1),
(8702, 254, 139, 'Springfield', 10000, 1),
(8703, 254, 139, 'Stanford', 10000, 1),
(8704, 254, 139, 'Stanton', 10000, 1),
(8705, 254, 139, 'Taylorsville', 10000, 1),
(8706, 254, 139, 'Tompkinsville', 10000, 1),
(8708, 254, 139, 'Vanceburg', 10000, 1),
(8709, 254, 139, 'Versailles', 10000, 1),
(8710, 254, 139, 'Warsaw', 10000, 1),
(8711, 254, 139, 'West Liberty', 10000, 1),
(8712, 254, 139, 'Whitesburg', 10000, 1),
(8713, 254, 139, 'Whitley City', 10000, 1),
(8714, 254, 139, 'Wickliffe', 10000, 1),
(8715, 254, 139, 'Williamsburg', 10000, 1),
(8716, 254, 139, 'Williamstown', 10000, 1),
(8717, 254, 139, 'Winchester', 10000, 1),
(8718, 254, 140, 'Abbeville', 10000, 1),
(8719, 254, 140, 'Alexandria', 10000, 1),
(8720, 254, 140, 'Ball', 10000, 1),
(8721, 254, 140, 'Barataria', 10000, 1),
(8722, 254, 140, 'Bastrop', 10000, 1),
(8723, 254, 140, 'Baton Rouge', 10000, 1),
(8724, 254, 140, 'Bogalusa', 10000, 1),
(8725, 254, 140, 'Boothville', 10000, 1),
(8726, 254, 140, 'Bossier City', 10000, 1),
(8727, 254, 140, 'Bunkie', 10000, 1),
(8728, 254, 140, 'Cameron', 10000, 1),
(8729, 254, 140, 'Chalmette', 10000, 1),
(8730, 254, 140, 'Clinton', 10000, 1),
(8731, 254, 140, 'Colfax', 10000, 1),
(8732, 254, 140, 'Columbia', 10000, 1),
(8733, 254, 140, 'Coushatta', 10000, 1),
(8734, 254, 140, 'Crowley', 10000, 1),
(8735, 254, 140, 'Dalcour', 10000, 1),
(8737, 254, 140, 'Donaldsonville', 10000, 1),
(8738, 254, 140, 'Farmerville', 10000, 1),
(8739, 254, 140, 'Fort Polk Aaf', 10000, 1),
(8740, 254, 140, 'Franklin', 10000, 1),
(8741, 254, 140, 'Golden Meadow', 10000, 1),
(8742, 254, 140, 'Gonzales', 10000, 1),
(8743, 254, 140, 'Grambling', 10000, 1),
(8744, 254, 140, 'Greensburg', 10000, 1),
(8745, 254, 140, 'Gretna', 10000, 1),
(8746, 254, 140, 'Hammond', 10000, 1),
(8747, 254, 140, 'Harrisonburg', 10000, 1),
(8748, 254, 140, 'Harvey', 10000, 1),
(8749, 254, 140, 'Homer', 10000, 1),
(8750, 254, 140, 'Houma', 10000, 1),
(8751, 254, 140, 'Jena', 10000, 1),
(8752, 254, 140, 'Jennings', 10000, 1),
(8753, 254, 140, 'Jonesboro', 10000, 1),
(8754, 254, 140, 'Jonesville', 10000, 1),
(8755, 254, 140, 'Kenner', 10000, 1),
(8756, 254, 140, 'Lafayette', 10000, 1),
(8757, 254, 140, 'Lafitte', 10000, 1),
(8758, 254, 140, 'Lake Charles', 10000, 1),
(8759, 254, 140, 'Lake Providence', 10000, 1),
(8760, 254, 140, 'La Place', 10000, 1),
(8761, 254, 140, 'Leesville', 10000, 1),
(8762, 254, 140, 'Livingston', 10000, 1),
(8763, 254, 140, 'Mansfield', 10000, 1),
(8764, 254, 140, 'Many', 10000, 1),
(8765, 254, 140, 'Marksville', 10000, 1),
(8766, 254, 140, 'Marrero', 10000, 1),
(8767, 254, 140, 'Meraux', 10000, 1),
(8768, 254, 140, 'Metairie', 10000, 1),
(8769, 254, 140, 'Monroe', 10000, 1),
(8770, 254, 140, 'Morgan City', 10000, 1),
(8771, 254, 140, 'Napoleonville', 10000, 1),
(8772, 254, 140, 'Natchitoches', 10000, 1),
(8773, 254, 140, 'New Iberia', 10000, 1),
(8774, 254, 140, 'New Orleans', 10000, 1),
(8775, 254, 140, 'New Roads', 10000, 1),
(8776, 254, 140, 'Oak Grove', 10000, 1),
(8777, 254, 140, 'Oakdale', 10000, 1),
(8778, 254, 140, 'Opelousas', 10000, 1),
(8779, 254, 140, 'Pierre Part', 10000, 1),
(8780, 254, 140, 'Pineville', 10000, 1),
(8781, 254, 140, 'Plaquemine', 10000, 1),
(8782, 254, 140, 'Port Allen', 10000, 1),
(8783, 254, 140, 'Port Sulphur', 10000, 1),
(8785, 254, 140, 'Prairieville', 10000, 1),
(8786, 254, 140, 'Rayville', 10000, 1),
(8787, 254, 140, 'Reserve', 10000, 1),
(8788, 254, 140, 'Ruston', 10000, 1),
(8789, 254, 140, 'Shreveport', 10000, 1),
(8790, 254, 140, 'Simsboro', 10000, 1),
(8791, 254, 140, 'Slidell', 10000, 1),
(8792, 254, 140, 'Sorrento', 10000, 1),
(8793, 254, 140, 'Springhill', 10000, 1),
(8794, 254, 140, 'Saint Francisville', 10000, 1),
(8795, 254, 140, 'Saint Joseph', 10000, 1),
(8796, 254, 140, 'Saint Martinville', 10000, 1),
(8797, 254, 140, 'Sulphur', 10000, 1),
(8798, 254, 140, 'Tallulah', 10000, 1),
(8799, 254, 140, 'Thibodaux', 10000, 1),
(8800, 254, 140, 'Tioga', 10000, 1),
(8801, 254, 140, 'Vidalia', 10000, 1),
(8802, 254, 140, 'Ville Platte', 10000, 1),
(8804, 254, 140, 'Winnfield', 10000, 1),
(8805, 254, 140, 'Winnsboro', 10000, 1),
(8806, 254, 143, 'Agawam', 10000, 1),
(8807, 254, 143, 'Amherst', 10000, 1),
(8808, 254, 143, 'Arlington', 10000, 1),
(8809, 254, 143, 'Attleboro', 10000, 1),
(8810, 254, 143, 'Barnstable', 10000, 1),
(8811, 254, 143, 'Bedford', 10000, 1),
(8812, 254, 143, 'Belmont', 10000, 1),
(8813, 254, 143, 'Berkley', 10000, 1),
(8814, 254, 143, 'Beverly', 10000, 1),
(8815, 254, 143, 'Billerica', 10000, 1),
(8816, 254, 143, 'Boston', 10000, 1),
(8817, 254, 143, 'Braintree', 10000, 1),
(8818, 254, 143, 'Bridgewater', 10000, 1),
(8819, 254, 143, 'Brockton', 10000, 1),
(8820, 254, 143, 'Burlington', 10000, 1),
(8821, 254, 143, 'Cambridge', 10000, 1),
(8822, 254, 143, 'Chatham', 10000, 1),
(8823, 254, 143, 'Chelsea', 10000, 1),
(8824, 254, 143, 'Chicopee', 10000, 1),
(8825, 254, 143, 'Chicopee Falls', 10000, 1),
(8826, 254, 143, 'Danvers', 10000, 1),
(8827, 254, 143, 'Dartmouth', 10000, 1),
(8828, 254, 143, 'Dedham', 10000, 1),
(8829, 254, 143, 'Dighton', 10000, 1),
(8831, 254, 143, 'Edgartown', 10000, 1),
(8832, 254, 143, 'Everett', 10000, 1),
(8833, 254, 143, 'Fall River', 10000, 1),
(8834, 254, 143, 'Falmouth', 10000, 1),
(8835, 254, 143, 'Fitchburg', 10000, 1),
(8836, 254, 143, 'Framingham', 10000, 1),
(8837, 254, 143, 'Franklin', 10000, 1),
(8839, 254, 143, 'Gloucester', 10000, 1),
(8840, 254, 143, 'Greenfield', 10000, 1),
(8841, 254, 143, 'Harwich', 10000, 1),
(8842, 254, 143, 'Haverhill', 10000, 1),
(8843, 254, 143, 'Hinsdale', 10000, 1),
(8844, 254, 143, 'Holliston', 10000, 1),
(8845, 254, 143, 'Holyoke', 10000, 1),
(8846, 254, 143, 'Hyannis', 10000, 1),
(8847, 254, 143, 'Hyannis Port', 10000, 1),
(8848, 254, 143, 'Lawrence', 10000, 1),
(8849, 254, 143, 'Leominster', 10000, 1),
(8850, 254, 143, 'Lexington', 10000, 1),
(8851, 254, 143, 'Lowell', 10000, 1),
(8852, 254, 143, 'Lynn', 10000, 1),
(8854, 254, 143, 'Malden', 10000, 1),
(8855, 254, 143, 'Marlborough', 10000, 1),
(8857, 254, 143, 'Medford', 10000, 1),
(8858, 254, 143, 'Melrose', 10000, 1),
(8859, 254, 143, 'Methuen', 10000, 1),
(8860, 254, 143, 'Milford', 10000, 1),
(8861, 254, 143, 'Milton', 10000, 1),
(8862, 254, 143, 'Nantucket', 10000, 1),
(8864, 254, 143, 'Natick', 10000, 1),
(8865, 254, 143, 'Needham', 10000, 1),
(8866, 254, 143, 'New Bedford', 10000, 1),
(8867, 254, 143, 'Newburyport', 10000, 1),
(8868, 254, 143, 'Newton', 10000, 1),
(8869, 254, 143, 'Northampton', 10000, 1),
(8870, 254, 143, 'Norwood', 10000, 1),
(8871, 254, 143, 'Orange', 10000, 1),
(8872, 254, 143, 'Peabody', 10000, 1),
(8873, 254, 143, 'Pittsfield', 10000, 1),
(8874, 254, 143, 'Plymouth', 10000, 1),
(8875, 254, 143, 'Quincy', 10000, 1),
(8876, 254, 143, 'Randolph', 10000, 1),
(8877, 254, 143, 'Reading', 10000, 1),
(8878, 254, 143, 'Revere', 10000, 1),
(8879, 254, 143, 'Salem', 10000, 1),
(8880, 254, 143, 'Saugus', 10000, 1),
(8881, 254, 143, 'Somerset', 10000, 1),
(8882, 254, 143, 'Somerville', 10000, 1),
(8884, 254, 143, 'South Yarmouth', 10000, 1),
(8885, 254, 143, 'Southborough', 10000, 1),
(8886, 254, 143, 'Springfield', 10000, 1),
(8887, 254, 143, 'Stockbridge', 10000, 1),
(8888, 254, 143, 'Stoneham', 10000, 1),
(8889, 254, 143, 'Sturbridge', 10000, 1),
(8890, 254, 143, 'Swansea', 10000, 1),
(8891, 254, 143, 'Taunton', 10000, 1),
(8892, 254, 143, 'Wakefield', 10000, 1),
(8893, 254, 143, 'Waltham', 10000, 1),
(8894, 254, 143, 'Wareham', 10000, 1),
(8895, 254, 143, 'Watertown', 10000, 1),
(8896, 254, 143, 'Wellesley', 10000, 1),
(8897, 254, 143, 'West Springfield', 10000, 1),
(8898, 254, 143, 'Westchester', 10000, 1),
(8899, 254, 143, 'Westfield', 10000, 1),
(8901, 254, 143, 'Winchester', 10000, 1),
(8902, 254, 143, 'Woburn', 10000, 1),
(8903, 254, 143, 'Worcester', 10000, 1),
(8906, 254, 142, 'Andrews Air Force Base', 10000, 1),
(8907, 254, 142, 'Annapolis', 10000, 1),
(8908, 254, 142, 'Arnold', 10000, 1),
(8909, 254, 142, 'Baltimore', 10000, 1),
(8910, 254, 142, 'Barnesville', 10000, 1),
(8911, 254, 142, 'Bethesda', 10000, 1),
(8912, 254, 142, 'Bowie', 10000, 1),
(8913, 254, 142, 'Cambridge', 10000, 1),
(8916, 254, 142, 'Centreville', 10000, 1),
(8917, 254, 142, 'Chesapeake Bay', 10000, 1),
(8918, 254, 142, 'Chesapeake Beach', 10000, 1),
(8919, 254, 142, 'Chestertown', 10000, 1),
(8921, 254, 142, 'Clinton', 10000, 1),
(8922, 254, 142, 'College Park', 10000, 1),
(8923, 254, 142, 'Columbia', 10000, 1),
(8924, 254, 142, 'Cumberland', 10000, 1),
(8926, 254, 142, 'Denton', 10000, 1),
(8927, 254, 142, 'Dundalk', 10000, 1),
(8928, 254, 142, 'Easton', 10000, 1),
(8929, 254, 142, 'Edgewood', 10000, 1),
(8930, 254, 142, 'Elkton', 10000, 1),
(8931, 254, 142, 'Ellicott City', 10000, 1),
(8932, 254, 142, 'Federalsburg', 10000, 1),
(8933, 254, 142, 'District Heights', 10000, 1),
(8934, 254, 142, 'Frederick', 10000, 1),
(8935, 254, 142, 'Gaithersburg', 10000, 1),
(8936, 254, 142, 'Germantown', 10000, 1),
(8937, 254, 142, 'Glen Burnie', 10000, 1),
(8938, 254, 142, 'Greenbelt', 10000, 1),
(8939, 254, 142, 'Hagerstown', 10000, 1),
(8940, 254, 142, 'Hunt Valley', 10000, 1),
(8941, 254, 142, 'Joppatone', 10000, 1),
(8942, 254, 142, 'La Plata', 10000, 1),
(8945, 254, 142, 'Laurel', 10000, 1),
(8947, 254, 142, 'Leonardtown', 10000, 1),
(8948, 254, 142, 'Lexington Park', 10000, 1),
(8949, 254, 142, 'Middle River', 10000, 1),
(8950, 254, 142, 'North Laurel', 10000, 1),
(8951, 254, 142, 'Oakland', 10000, 1),
(8952, 254, 142, 'Ocean City', 10000, 1),
(8953, 254, 142, 'Olney', 10000, 1),
(8954, 254, 142, 'Oxon Hill', 10000, 1),
(8956, 254, 142, 'Perry Hall', 10000, 1),
(8957, 254, 142, 'Perryville', 10000, 1),
(8958, 254, 142, 'Pikesville', 10000, 1),
(8959, 254, 142, 'Pocomoke City', 10000, 1),
(8960, 254, 142, 'Poolesville', 10000, 1),
(8961, 254, 142, 'Potomac', 10000, 1),
(8962, 254, 142, 'Prince Frederick', 10000, 1),
(8963, 254, 142, 'Randallstown', 10000, 1),
(8965, 254, 142, 'Salisbury', 10000, 1),
(8966, 254, 142, 'Severn', 10000, 1),
(8967, 254, 142, 'Severna Park', 10000, 1),
(8968, 254, 142, 'Silver Spring', 10000, 1),
(8969, 254, 142, 'South Laurel', 10000, 1),
(8971, 254, 142, 'Saint Marys City', 10000, 1),
(8972, 254, 142, 'Suitland', 10000, 1),
(8973, 254, 142, 'Sunderland', 10000, 1),
(8974, 254, 142, 'Takoma Park', 10000, 1),
(8975, 254, 142, 'Towson', 10000, 1),
(8976, 254, 142, 'Waldorf', 10000, 1),
(8977, 254, 142, 'Westminster', 10000, 1),
(8979, 254, 142, 'White Oak', 10000, 1),
(8982, 254, 141, 'Auburn', 10000, 1),
(8983, 254, 141, 'Augusta', 10000, 1),
(8984, 254, 141, 'Bangor', 10000, 1),
(8985, 254, 141, 'Bar Harbor', 10000, 1),
(8986, 254, 141, 'Bath', 10000, 1),
(8987, 254, 141, 'Biddeford', 10000, 1),
(8988, 254, 141, 'Brunswick', 10000, 1),
(8989, 254, 141, 'Canton', 10000, 1),
(8990, 254, 141, 'Caribou', 10000, 1),
(8991, 254, 141, 'Casco', 10000, 1),
(8992, 254, 141, 'Clayton Lake', 10000, 1),
(8994, 254, 141, 'East Millinocket', 10000, 1),
(8995, 254, 141, 'Farmington', 10000, 1),
(8996, 254, 141, 'Fort Kent', 10000, 1),
(8997, 254, 141, 'Freeport', 10000, 1),
(8998, 254, 141, 'Greenville', 10000, 1),
(8999, 254, 141, 'Hallowell', 10000, 1),
(9000, 254, 141, 'Houlton', 10000, 1),
(9001, 254, 141, 'Kennebunkport', 10000, 1),
(9002, 254, 141, 'Kingfield', 10000, 1),
(9003, 254, 141, 'Lewiston', 10000, 1),
(9004, 254, 141, 'Limestone Loring AFB', 10000, 1),
(9005, 254, 141, 'Millinocket', 10000, 1),
(9006, 254, 141, 'Newcastle', 10000, 1),
(9007, 254, 141, 'Ogunquit', 10000, 1),
(9008, 254, 141, 'Orono', 10000, 1),
(9010, 254, 141, 'Portland', 10000, 1),
(9011, 254, 141, 'Presque Island', 10000, 1),
(9012, 254, 141, 'Princeton', 10000, 1),
(9013, 254, 141, 'Rumford', 10000, 1),
(9014, 254, 141, 'Sanford', 10000, 1),
(9015, 254, 141, 'South Portland', 10000, 1),
(9017, 254, 141, 'Unity', 10000, 1),
(9018, 254, 141, 'Waterville', 10000, 1),
(9019, 254, 141, 'Wells', 10000, 1),
(9020, 254, 141, 'West Boothbay Harbor', 10000, 1),
(9021, 254, 144, 'Adrian', 10000, 1),
(9022, 254, 144, 'Allen Park', 10000, 1),
(9023, 254, 144, 'Allendale', 10000, 1),
(9024, 254, 144, 'Alma', 10000, 1),
(9025, 254, 144, 'Alpena', 10000, 1),
(9026, 254, 144, 'Ann Arbor', 10000, 1),
(9027, 254, 144, 'Atlanta', 10000, 1),
(9028, 254, 144, 'Auburn Hills', 10000, 1),
(9029, 254, 144, 'Bad Axe', 10000, 1),
(9030, 254, 144, 'Baldwin', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(9031, 254, 144, 'Battle Creek', 10000, 1),
(9032, 254, 144, 'Bay City', 10000, 1),
(9033, 254, 144, 'Bellaire', 10000, 1),
(9034, 254, 144, 'Benton Harbor', 10000, 1),
(9035, 254, 144, 'Bessemer', 10000, 1),
(9036, 254, 144, 'Big Rapids', 10000, 1),
(9037, 254, 144, 'Birmingham', 10000, 1),
(9038, 254, 144, 'Boyne Mountain', 10000, 1),
(9039, 254, 144, 'Burton', 10000, 1),
(9040, 254, 144, 'Cadillac', 10000, 1),
(9041, 254, 144, 'Canton', 10000, 1),
(9042, 254, 144, 'Caro', 10000, 1),
(9043, 254, 144, 'Channing', 10000, 1),
(9044, 254, 144, 'Charlevoix', 10000, 1),
(9045, 254, 144, 'Charlotte', 10000, 1),
(9046, 254, 144, 'Cheboygan', 10000, 1),
(9047, 254, 144, 'Clinton', 10000, 1),
(9048, 254, 144, 'Coldwater', 10000, 1),
(9049, 254, 144, 'Crystal Falls', 10000, 1),
(9050, 254, 144, 'Dearborn', 10000, 1),
(9051, 254, 144, 'Dearborn Heights', 10000, 1),
(9052, 254, 144, 'Detroit', 10000, 1),
(9053, 254, 144, 'Dowagiac', 10000, 1),
(9055, 254, 144, 'East Lansing', 10000, 1),
(9056, 254, 144, 'Eastpointe', 10000, 1),
(9058, 254, 144, 'Escanaba', 10000, 1),
(9060, 254, 144, 'Ferndale', 10000, 1),
(9061, 254, 144, 'Flint', 10000, 1),
(9062, 254, 144, 'Frankfort', 10000, 1),
(9063, 254, 144, 'Fremont', 10000, 1),
(9064, 254, 144, 'Garden City', 10000, 1),
(9065, 254, 144, 'Gaylord', 10000, 1),
(9066, 254, 144, 'Gladwin', 10000, 1),
(9067, 254, 144, 'Grand Haven', 10000, 1),
(9068, 254, 144, 'Grand Rapids', 10000, 1),
(9069, 254, 144, 'Grayling', 10000, 1),
(9070, 254, 144, 'Greenville', 10000, 1),
(9071, 254, 144, 'Harrison', 10000, 1),
(9072, 254, 144, 'Harrisville', 10000, 1),
(9073, 254, 144, 'Hart', 10000, 1),
(9074, 254, 144, 'Hastings', 10000, 1),
(9075, 254, 144, 'Hillsdale', 10000, 1),
(9076, 254, 144, 'Holland', 10000, 1),
(9077, 254, 144, 'Houghton', 10000, 1),
(9078, 254, 144, 'Houghton Lake', 10000, 1),
(9079, 254, 144, 'Howell', 10000, 1),
(9080, 254, 144, 'Inkster', 10000, 1),
(9081, 254, 144, 'Ionia', 10000, 1),
(9082, 254, 144, 'Iron Mountain', 10000, 1),
(9083, 254, 144, 'Ironwood', 10000, 1),
(9084, 254, 144, 'Ishpeming', 10000, 1),
(9085, 254, 144, 'Jackson', 10000, 1),
(9086, 254, 144, 'Kalamazoo', 10000, 1),
(9087, 254, 144, 'Kalkaska', 10000, 1),
(9089, 254, 144, 'Lake City', 10000, 1),
(9091, 254, 144, 'Lansing', 10000, 1),
(9092, 254, 144, 'Lapeer', 10000, 1),
(9093, 254, 144, 'Leland', 10000, 1),
(9094, 254, 144, 'Lincoln Park', 10000, 1),
(9095, 254, 144, 'Livonia', 10000, 1),
(9096, 254, 144, 'Ludington', 10000, 1),
(9097, 254, 144, 'Mackinac Island', 10000, 1),
(9098, 254, 144, 'Madison Heights', 10000, 1),
(9099, 254, 144, 'Manistee', 10000, 1),
(9100, 254, 144, 'Manistique', 10000, 1),
(9101, 254, 144, 'Marenisco', 10000, 1),
(9102, 254, 144, 'Marquette', 10000, 1),
(9103, 254, 144, 'Marshall', 10000, 1),
(9104, 254, 144, 'Menominee', 10000, 1),
(9105, 254, 144, 'Midland', 10000, 1),
(9107, 254, 144, 'Mio', 10000, 1),
(9108, 254, 144, 'Monroe', 10000, 1),
(9109, 254, 144, 'Mount Clemens', 10000, 1),
(9110, 254, 144, 'Mount Pleasant', 10000, 1),
(9111, 254, 144, 'Munising', 10000, 1),
(9112, 254, 144, 'Muskegon', 10000, 1),
(9113, 254, 144, 'Newberry', 10000, 1),
(9114, 254, 144, 'Niles', 10000, 1),
(9115, 254, 144, 'Novi', 10000, 1),
(9116, 254, 144, 'Oak Park', 10000, 1),
(9117, 254, 144, 'Okemos', 10000, 1),
(9118, 254, 144, 'Ontonagon', 10000, 1),
(9119, 254, 144, 'Oscoda', 10000, 1),
(9120, 254, 144, 'Owosso', 10000, 1),
(9121, 254, 144, 'Pellston', 10000, 1),
(9122, 254, 144, 'Petoskey', 10000, 1),
(9124, 254, 144, 'Pontiac', 10000, 1),
(9125, 254, 144, 'Port Huron', 10000, 1),
(9126, 254, 144, 'Portage', 10000, 1),
(9127, 254, 144, 'Redford', 10000, 1),
(9128, 254, 144, 'Reed City', 10000, 1),
(9129, 254, 144, 'Rochester', 10000, 1),
(9131, 254, 144, 'Romulus', 10000, 1),
(9132, 254, 144, 'Roscommon', 10000, 1),
(9133, 254, 144, 'Roseville', 10000, 1),
(9134, 254, 144, 'Royal Oak', 10000, 1),
(9135, 254, 144, 'Saginaw', 10000, 1),
(9136, 254, 144, 'Sandusky', 10000, 1),
(9138, 254, 144, 'Sawyer AFB', 10000, 1),
(9139, 254, 144, 'South Haven', 10000, 1),
(9140, 254, 144, 'Southfield', 10000, 1),
(9141, 254, 144, 'Southgate', 10000, 1),
(9143, 254, 144, 'Standish', 10000, 1),
(9144, 254, 144, 'Sterling Heights', 10000, 1),
(9145, 254, 144, 'Tawas City', 10000, 1),
(9146, 254, 144, 'Taylor', 10000, 1),
(9147, 254, 144, 'Three Rivers', 10000, 1),
(9148, 254, 144, 'Traverse City', 10000, 1),
(9150, 254, 144, 'Troy', 10000, 1),
(9151, 254, 144, 'Warren', 10000, 1),
(9153, 254, 144, 'Waterford', 10000, 1),
(9154, 254, 144, 'West Bloomfield', 10000, 1),
(9155, 254, 144, 'Westland', 10000, 1),
(9156, 254, 144, 'White Cloud', 10000, 1),
(9158, 254, 144, 'Wyandotte', 10000, 1),
(9160, 254, 144, 'Ypsilanti', 10000, 1),
(9161, 254, 145, 'Ada', 10000, 1),
(9162, 254, 145, 'Aitkin', 10000, 1),
(9163, 254, 145, 'Albert Lea', 10000, 1),
(9164, 254, 145, 'Alexandria', 10000, 1),
(9166, 254, 145, 'Orr', 10000, 1),
(9167, 254, 145, 'Austin', 10000, 1),
(9168, 254, 145, 'Baudette', 10000, 1),
(9169, 254, 145, 'Bemidji', 10000, 1),
(9170, 254, 145, 'Benson', 10000, 1),
(9171, 254, 145, 'Biwabik', 10000, 1),
(9174, 254, 145, 'Blue Earth', 10000, 1),
(9175, 254, 145, 'Brainerd', 10000, 1),
(9176, 254, 145, 'Breckenridge', 10000, 1),
(9179, 254, 145, 'Buffalo', 10000, 1),
(9180, 254, 145, 'Burnsville', 10000, 1),
(9181, 254, 145, 'Caledonia', 10000, 1),
(9182, 254, 145, 'Cambridge', 10000, 1),
(9183, 254, 145, 'Canby', 10000, 1),
(9185, 254, 145, 'Champlin', 10000, 1),
(9186, 254, 145, 'Chaska', 10000, 1),
(9187, 254, 145, 'Clearwater', 10000, 1),
(9188, 254, 145, 'Cold Spring', 10000, 1),
(9190, 254, 145, 'Cottage Grove', 10000, 1),
(9191, 254, 145, 'Cove', 10000, 1),
(9192, 254, 145, 'Crookston', 10000, 1),
(9193, 254, 145, 'Crosby', 10000, 1),
(9194, 254, 145, 'Minneapolis', 10000, 1),
(9195, 254, 145, 'Deer Creek', 10000, 1),
(9196, 254, 145, 'Detroit Lakes', 10000, 1),
(9197, 254, 145, 'Duluth', 10000, 1),
(9199, 254, 145, 'Eden Prairie', 10000, 1),
(9201, 254, 145, 'Elbow Lake', 10000, 1),
(9202, 254, 145, 'Elk River', 10000, 1),
(9203, 254, 145, 'Ely', 10000, 1),
(9205, 254, 145, 'Fairmont', 10000, 1),
(9206, 254, 145, 'Faribault', 10000, 1),
(9207, 254, 145, 'Federal Dam', 10000, 1),
(9208, 254, 145, 'Fergus Falls', 10000, 1),
(9209, 254, 145, 'Foley', 10000, 1),
(9211, 254, 145, 'Gaylord', 10000, 1),
(9212, 254, 145, 'Finlayson', 10000, 1),
(9213, 254, 145, 'Glenwood', 10000, 1),
(9214, 254, 145, 'Gonvick', 10000, 1),
(9215, 254, 145, 'Grand Marais', 10000, 1),
(9216, 254, 145, 'Grand Rapids', 10000, 1),
(9217, 254, 145, 'Granite Falls', 10000, 1),
(9218, 254, 145, 'Hallock', 10000, 1),
(9219, 254, 145, 'Hibbing', 10000, 1),
(9220, 254, 145, 'Hinckley', 10000, 1),
(9221, 254, 145, 'Hutchinson', 10000, 1),
(9222, 254, 145, 'International Falls', 10000, 1),
(9223, 254, 145, 'Inver Grove Heights', 10000, 1),
(9224, 254, 145, 'Isabella', 10000, 1),
(9225, 254, 145, 'Ivanhoe', 10000, 1),
(9226, 254, 145, 'Jackson', 10000, 1),
(9227, 254, 145, 'Jacobson', 10000, 1),
(9228, 254, 145, 'Lakeville', 10000, 1),
(9229, 254, 145, 'Le Center', 10000, 1),
(9230, 254, 145, 'Lindstrom', 10000, 1),
(9231, 254, 145, 'Litchfield', 10000, 1),
(9232, 254, 145, 'Little Falls', 10000, 1),
(9233, 254, 145, 'Long Prairie', 10000, 1),
(9234, 254, 145, 'Luverne', 10000, 1),
(9235, 254, 145, 'Madison', 10000, 1),
(9236, 254, 145, 'Mahnomen', 10000, 1),
(9237, 254, 145, 'Mankato', 10000, 1),
(9238, 254, 145, 'Mantorville', 10000, 1),
(9239, 254, 145, 'Osseo', 10000, 1),
(9240, 254, 145, 'Mapleton', 10000, 1),
(9241, 254, 145, 'Saint Paul', 10000, 1),
(9242, 254, 145, 'Marshall', 10000, 1),
(9243, 254, 145, 'Millerville', 10000, 1),
(9245, 254, 145, 'Minnetonka', 10000, 1),
(9246, 254, 145, 'Montevideo', 10000, 1),
(9247, 254, 145, 'Monticello', 10000, 1),
(9248, 254, 145, 'Moorhead', 10000, 1),
(9249, 254, 145, 'Mora', 10000, 1),
(9250, 254, 145, 'Morris', 10000, 1),
(9252, 254, 145, 'New Ulm', 10000, 1),
(9254, 254, 145, 'Olivia', 10000, 1),
(9255, 254, 145, 'Ortonville', 10000, 1),
(9256, 254, 145, 'Owatonna', 10000, 1),
(9257, 254, 145, 'Park Rapids', 10000, 1),
(9258, 254, 145, 'Pequot Lakes', 10000, 1),
(9259, 254, 145, 'Pine City', 10000, 1),
(9260, 254, 145, 'Pipestone', 10000, 1),
(9262, 254, 145, 'Preston', 10000, 1),
(9263, 254, 145, 'Red Lake Falls', 10000, 1),
(9264, 254, 145, 'Red Wing', 10000, 1),
(9266, 254, 145, 'Rochester', 10000, 1),
(9267, 254, 145, 'Roseau', 10000, 1),
(9269, 254, 145, 'Seaforth', 10000, 1),
(9270, 254, 145, 'Shakopee', 10000, 1),
(9272, 254, 145, 'Slayton', 10000, 1),
(9273, 254, 145, 'Spring Grove', 10000, 1),
(9275, 254, 145, 'Saint James', 10000, 1),
(9278, 254, 145, 'Saint Peter', 10000, 1),
(9279, 254, 145, 'Kellogg', 10000, 1),
(9280, 254, 145, 'Thief River Falls', 10000, 1),
(9281, 254, 145, 'Tofte', 10000, 1),
(9282, 254, 145, 'Cook', 10000, 1),
(9283, 254, 145, 'Two Harbors', 10000, 1),
(9284, 254, 145, 'Taylors Falls', 10000, 1),
(9285, 254, 145, 'Utica', 10000, 1),
(9286, 254, 145, 'Virginia', 10000, 1),
(9287, 254, 145, 'Wabasha', 10000, 1),
(9288, 254, 145, 'Wadena', 10000, 1),
(9289, 254, 145, 'Wannaska', 10000, 1),
(9290, 254, 145, 'Warren', 10000, 1),
(9291, 254, 145, 'Warroad', 10000, 1),
(9292, 254, 145, 'Waseca', 10000, 1),
(9293, 254, 145, 'Wheaton', 10000, 1),
(9296, 254, 145, 'Willmar', 10000, 1),
(9297, 254, 145, 'Wilmont', 10000, 1),
(9298, 254, 145, 'Windom', 10000, 1),
(9299, 254, 145, 'Winona', 10000, 1),
(9301, 254, 145, 'Worthington', 10000, 1),
(9302, 254, 145, 'Wrenshall', 10000, 1),
(9304, 254, 147, 'Albany', 10000, 1),
(9305, 254, 147, 'Alton', 10000, 1),
(9306, 254, 147, 'Arnold', 10000, 1),
(9307, 254, 147, 'Aurora', 10000, 1),
(9308, 254, 147, 'Ava', 10000, 1),
(9309, 254, 147, 'Ballwin', 10000, 1),
(9310, 254, 147, 'Belton', 10000, 1),
(9311, 254, 147, 'Benton', 10000, 1),
(9312, 254, 147, 'Bethany', 10000, 1),
(9313, 254, 147, 'Blue Springs', 10000, 1),
(9314, 254, 147, 'Boliver', 10000, 1),
(9315, 254, 147, 'Boonville', 10000, 1),
(9316, 254, 147, 'Bowling Green', 10000, 1),
(9317, 254, 147, 'Branson', 10000, 1),
(9318, 254, 147, 'Brookfield', 10000, 1),
(9319, 254, 147, 'Buffalo', 10000, 1),
(9320, 254, 147, 'Butler', 10000, 1),
(9321, 254, 147, 'California', 10000, 1),
(9322, 254, 147, 'Camdenton', 10000, 1),
(9323, 254, 147, 'Cape Girardeau', 10000, 1),
(9324, 254, 147, 'Carrollton', 10000, 1),
(9325, 254, 147, 'Caruthersville', 10000, 1),
(9326, 254, 147, 'Centerville', 10000, 1),
(9327, 254, 147, 'Charleston', 10000, 1),
(9328, 254, 147, 'Chesterfield', 10000, 1),
(9329, 254, 147, 'Chillicothe', 10000, 1),
(9330, 254, 147, 'Sainte Genevieve', 10000, 1),
(9331, 254, 147, 'Clinton', 10000, 1),
(9332, 254, 147, 'Columbia', 10000, 1),
(9333, 254, 147, 'Dexter', 10000, 1),
(9334, 254, 147, 'Doniphan', 10000, 1),
(9335, 254, 147, 'Edina', 10000, 1),
(9336, 254, 147, 'Eminence', 10000, 1),
(9337, 254, 147, 'Farmington', 10000, 1),
(9338, 254, 147, 'Fayette', 10000, 1),
(9340, 254, 147, 'Florissant', 10000, 1),
(9342, 254, 147, 'Fredericktown', 10000, 1),
(9343, 254, 147, 'Fulton', 10000, 1),
(9344, 254, 147, 'Gainesville', 10000, 1),
(9345, 254, 147, 'Galena', 10000, 1),
(9346, 254, 147, 'Gallatin', 10000, 1),
(9348, 254, 147, 'Grandview', 10000, 1),
(9349, 254, 147, 'Grant City', 10000, 1),
(9350, 254, 147, 'Greenfield', 10000, 1),
(9351, 254, 147, 'Greenville', 10000, 1),
(9352, 254, 147, 'Hannibal', 10000, 1),
(9354, 254, 147, 'Hartville', 10000, 1),
(9355, 254, 147, 'Hermann', 10000, 1),
(9356, 254, 147, 'Hermitage', 10000, 1),
(9357, 254, 147, 'Hillsboro', 10000, 1),
(9358, 254, 147, 'Houston', 10000, 1),
(9359, 254, 147, 'Independence', 10000, 1),
(9360, 254, 147, 'Ironton', 10000, 1),
(9361, 254, 147, 'Jefferson City', 10000, 1),
(9362, 254, 147, 'Joplin', 10000, 1),
(9363, 254, 147, 'Kahoka', 10000, 1),
(9364, 254, 147, 'Kansas City', 10000, 1),
(9365, 254, 147, 'Kennett', 10000, 1),
(9366, 254, 147, 'Keytesville', 10000, 1),
(9367, 254, 147, 'Kingston', 10000, 1),
(9368, 254, 147, 'Kirksville', 10000, 1),
(9370, 254, 147, 'Knob Noster', 10000, 1),
(9371, 254, 147, 'Lake Ozark', 10000, 1),
(9372, 254, 147, 'Lamar', 10000, 1),
(9373, 254, 147, 'Lancaster', 10000, 1),
(9374, 254, 147, 'Lebanon', 10000, 1),
(9375, 254, 147, 'Lees Summit', 10000, 1),
(9376, 254, 147, 'Lexington', 10000, 1),
(9377, 254, 147, 'Liberty', 10000, 1),
(9378, 254, 147, 'Linn', 10000, 1),
(9379, 254, 147, 'Linneus', 10000, 1),
(9380, 254, 147, 'Macon', 10000, 1),
(9381, 254, 147, 'Malden', 10000, 1),
(9382, 254, 147, 'Marble Hill', 10000, 1),
(9383, 254, 147, 'Marshall', 10000, 1),
(9384, 254, 147, 'Marshfield', 10000, 1),
(9385, 254, 147, 'Maryland Heights', 10000, 1),
(9386, 254, 147, 'Maryville', 10000, 1),
(9387, 254, 147, 'Maysville', 10000, 1),
(9388, 254, 147, 'Memphis', 10000, 1),
(9389, 254, 147, 'Mexico', 10000, 1),
(9390, 254, 147, 'Milan', 10000, 1),
(9391, 254, 147, 'Moberly', 10000, 1),
(9392, 254, 147, 'Monett', 10000, 1),
(9394, 254, 147, 'Monticello', 10000, 1),
(9395, 254, 147, 'Neosho', 10000, 1),
(9396, 254, 147, 'Nevada', 10000, 1),
(9397, 254, 147, 'New London', 10000, 1),
(9398, 254, 147, 'New Madrid', 10000, 1),
(9401, 254, 147, 'Oregon', 10000, 1),
(9404, 254, 147, 'Palmyra', 10000, 1),
(9405, 254, 147, 'Paris', 10000, 1),
(9406, 254, 147, 'Perryville', 10000, 1),
(9407, 254, 147, 'Pineville', 10000, 1),
(9408, 254, 147, 'Plattsburg', 10000, 1),
(9409, 254, 147, 'Poplar Bluff', 10000, 1),
(9410, 254, 147, 'Potosi', 10000, 1),
(9411, 254, 147, 'Princeton', 10000, 1),
(9412, 254, 147, 'Raymore', 10000, 1),
(9414, 254, 147, 'Richmond', 10000, 1),
(9415, 254, 147, 'Rock Port', 10000, 1),
(9416, 254, 147, 'Rolla', 10000, 1),
(9417, 254, 147, 'Salem', 10000, 1),
(9418, 254, 147, 'Savannah', 10000, 1),
(9419, 254, 147, 'Sedalia', 10000, 1),
(9420, 254, 147, 'Shelbyville', 10000, 1),
(9421, 254, 147, 'Sikeston', 10000, 1),
(9423, 254, 147, 'Spickard', 10000, 1),
(9424, 254, 147, 'Springfield', 10000, 1),
(9427, 254, 147, 'Saint Peters', 10000, 1),
(9428, 254, 147, 'Steelville', 10000, 1),
(9429, 254, 147, 'Stockton', 10000, 1),
(9430, 254, 147, 'Stover', 10000, 1),
(9431, 254, 147, 'Tarkio', 10000, 1),
(9432, 254, 147, 'Trenton', 10000, 1),
(9433, 254, 147, 'Troy', 10000, 1),
(9434, 254, 147, 'Tuscumbia', 10000, 1),
(9435, 254, 147, 'Unionville', 10000, 1),
(9437, 254, 147, 'Van Buren', 10000, 1),
(9438, 254, 147, 'Versailles', 10000, 1),
(9439, 254, 147, 'Vichy', 10000, 1),
(9440, 254, 147, 'Vienna', 10000, 1),
(9441, 254, 147, 'Warrensburg', 10000, 1),
(9442, 254, 147, 'Warrenton', 10000, 1),
(9443, 254, 147, 'Warsaw', 10000, 1),
(9444, 254, 147, 'Washington', 10000, 1),
(9445, 254, 147, 'Waynesville', 10000, 1),
(9446, 254, 147, 'West Plains', 10000, 1),
(9447, 254, 147, 'Weston', 10000, 1),
(9448, 254, 147, 'Willow Springs', 10000, 1),
(9449, 254, 146, 'Aberdeen', 10000, 1),
(9450, 254, 146, 'Ackerman', 10000, 1),
(9451, 254, 146, 'Ashland', 10000, 1),
(9452, 254, 146, 'Batesville', 10000, 1),
(9453, 254, 146, 'Bay Springs', 10000, 1),
(9454, 254, 146, 'Bay Saint. Louis', 10000, 1),
(9455, 254, 146, 'Belzoni', 10000, 1),
(9456, 254, 146, 'Biloxi', 10000, 1),
(9457, 254, 146, 'Booneville', 10000, 1),
(9458, 254, 146, 'Brandon', 10000, 1),
(9459, 254, 146, 'Brookhaven', 10000, 1),
(9460, 254, 146, 'Canton', 10000, 1),
(9461, 254, 146, 'Carrollton', 10000, 1),
(9462, 254, 146, 'Carthage', 10000, 1),
(9463, 254, 146, 'Charleston', 10000, 1),
(9464, 254, 146, 'Clarksdale', 10000, 1),
(9465, 254, 146, 'Cleveland', 10000, 1),
(9466, 254, 146, 'Clinton', 10000, 1),
(9467, 254, 146, 'Coffeeville', 10000, 1),
(9468, 254, 146, 'Collins', 10000, 1),
(9469, 254, 146, 'Columbia', 10000, 1),
(9470, 254, 146, 'Columbus', 10000, 1),
(9472, 254, 146, 'Corinth', 10000, 1),
(9473, 254, 146, 'De Kalb', 10000, 1),
(9474, 254, 146, 'Decatur', 10000, 1),
(9475, 254, 146, 'Fayette', 10000, 1),
(9476, 254, 146, 'Forest', 10000, 1),
(9478, 254, 146, 'Fulton', 10000, 1),
(9479, 254, 146, 'Greenville', 10000, 1),
(9480, 254, 146, 'Greenwood', 10000, 1),
(9481, 254, 146, 'Grenada', 10000, 1),
(9482, 254, 146, 'Gulfport', 10000, 1),
(9483, 254, 146, 'Hattiesburg', 10000, 1),
(9484, 254, 146, 'Hazlehurst', 10000, 1),
(9485, 254, 146, 'Hernando', 10000, 1),
(9486, 254, 146, 'Holly Springs', 10000, 1),
(9487, 254, 146, 'Houston', 10000, 1),
(9488, 254, 146, 'Indianola', 10000, 1),
(9489, 254, 146, 'Iuka', 10000, 1),
(9490, 254, 146, 'Jackson', 10000, 1),
(9491, 254, 146, 'Kosciusko', 10000, 1),
(9492, 254, 146, 'Laurel', 10000, 1),
(9493, 254, 146, 'Leakesville', 10000, 1),
(9494, 254, 146, 'Lexington', 10000, 1),
(9495, 254, 146, 'Liberty', 10000, 1),
(9496, 254, 146, 'Louisville', 10000, 1),
(9497, 254, 146, 'Lucedale', 10000, 1),
(9498, 254, 146, 'Marks', 10000, 1),
(9499, 254, 146, 'Mayersville', 10000, 1),
(9500, 254, 146, 'McComb', 10000, 1),
(9501, 254, 146, 'Meadville', 10000, 1),
(9502, 254, 146, 'Mendenhall', 10000, 1),
(9503, 254, 146, 'Meridian', 10000, 1),
(9504, 254, 146, 'Mississippi State', 10000, 1),
(9505, 254, 146, 'Monticello', 10000, 1),
(9506, 254, 146, 'Natchez', 10000, 1),
(9507, 254, 146, 'New Albany', 10000, 1),
(9508, 254, 146, 'New Augusta', 10000, 1),
(9509, 254, 146, 'Oxford', 10000, 1),
(9510, 254, 146, 'Pascagoula', 10000, 1),
(9511, 254, 146, 'Pearl', 10000, 1),
(9512, 254, 146, 'Philadelphia', 10000, 1),
(9513, 254, 146, 'Picayune', 10000, 1),
(9514, 254, 146, 'Pittsboro', 10000, 1),
(9515, 254, 146, 'Pontotoc', 10000, 1),
(9516, 254, 146, 'Poplarville', 10000, 1),
(9517, 254, 146, 'Port Gibson', 10000, 1),
(9518, 254, 146, 'Prentiss', 10000, 1),
(9519, 254, 146, 'Purvis', 10000, 1),
(9520, 254, 146, 'Quitman', 10000, 1),
(9521, 254, 146, 'Raleigh', 10000, 1),
(9522, 254, 146, 'Ripley', 10000, 1),
(9523, 254, 146, 'Rolling Fork', 10000, 1),
(9524, 254, 146, 'Senatobia', 10000, 1),
(9525, 254, 146, 'Starkville', 10000, 1),
(9526, 254, 146, 'Tunica', 10000, 1),
(9527, 254, 146, 'Tupelo', 10000, 1),
(9528, 254, 146, 'Tylertown', 10000, 1),
(9529, 254, 146, 'Vicksburg', 10000, 1),
(9530, 254, 146, 'Walthall', 10000, 1),
(9531, 254, 146, 'Waynesboro', 10000, 1),
(9532, 254, 146, 'West Point', 10000, 1),
(9533, 254, 146, 'Wiggins', 10000, 1),
(9534, 254, 146, 'Winona', 10000, 1),
(9535, 254, 146, 'Woodville', 10000, 1),
(9536, 254, 146, 'Yazoo City', 10000, 1),
(9537, 254, 148, 'Anaconda', 10000, 1),
(9538, 254, 148, 'Baker', 10000, 1),
(9539, 254, 148, 'Belgrade', 10000, 1),
(9541, 254, 148, 'Big Timber', 10000, 1),
(9542, 254, 148, 'Billings', 10000, 1),
(9543, 254, 148, 'Bozeman', 10000, 1),
(9544, 254, 148, 'Broadus', 10000, 1),
(9545, 254, 148, 'Butte', 10000, 1),
(9546, 254, 148, 'Cut Bank', 10000, 1),
(9547, 254, 148, 'Dillon', 10000, 1),
(9548, 254, 148, 'Drummond', 10000, 1),
(9550, 254, 148, 'Glasgow', 10000, 1),
(9551, 254, 148, 'Glendive', 10000, 1),
(9552, 254, 148, 'Great Falls', 10000, 1),
(9553, 254, 148, 'Hamilton', 10000, 1),
(9554, 254, 148, 'Hardin', 10000, 1),
(9555, 254, 148, 'Harlowton', 10000, 1),
(9556, 254, 148, 'Havre', 10000, 1),
(9557, 254, 148, 'Helena', 10000, 1),
(9558, 254, 148, 'Jordan', 10000, 1),
(9559, 254, 148, 'Kalispell', 10000, 1),
(9560, 254, 148, 'Lewistown', 10000, 1),
(9561, 254, 148, 'Libby', 10000, 1),
(9562, 254, 148, 'Livingston', 10000, 1),
(9563, 254, 148, 'Miles City', 10000, 1),
(9564, 254, 148, 'Missoula', 10000, 1),
(9566, 254, 148, 'Plentywood', 10000, 1),
(9567, 254, 148, 'Polson', 10000, 1),
(9568, 254, 148, 'Red Lodge', 10000, 1),
(9569, 254, 148, 'Roundup', 10000, 1),
(9570, 254, 148, 'Sidney', 10000, 1),
(9571, 254, 148, 'Silver Bow', 10000, 1),
(9572, 254, 148, 'Superior', 10000, 1),
(9573, 254, 148, 'Thompson Falls', 10000, 1),
(9574, 254, 148, 'Wisdom', 10000, 1),
(9575, 254, 148, 'Wolf Point', 10000, 1),
(9576, 254, 155, 'Albemarle', 10000, 1),
(9577, 254, 155, 'Asheboro', 10000, 1),
(9578, 254, 155, 'Asheville', 10000, 1),
(9579, 254, 155, 'Atlantic Beach', 10000, 1),
(9580, 254, 155, 'Bakersville', 10000, 1),
(9582, 254, 155, 'Black Mountain', 10000, 1),
(9583, 254, 155, 'Boone', 10000, 1),
(9584, 254, 155, 'Brevard', 10000, 1),
(9585, 254, 155, 'Bryson City', 10000, 1),
(9586, 254, 155, 'Burgaw', 10000, 1),
(9587, 254, 155, 'Burlington', 10000, 1),
(9588, 254, 155, 'Burnsville', 10000, 1),
(9589, 254, 155, 'Camden', 10000, 1),
(9590, 254, 155, 'Camp Lejeune', 10000, 1),
(9591, 254, 155, 'Cape Hatteras', 10000, 1),
(9592, 254, 155, 'Cary', 10000, 1),
(9593, 254, 155, 'Chapel Hill', 10000, 1),
(9594, 254, 155, 'Charlotte', 10000, 1),
(9595, 254, 155, 'Cherokee', 10000, 1),
(9596, 254, 155, 'Cherry Point', 10000, 1),
(9597, 254, 155, 'Clinton', 10000, 1),
(9598, 254, 155, 'Columbia', 10000, 1),
(9599, 254, 155, 'Columbus', 10000, 1),
(9600, 254, 155, 'Concord', 10000, 1),
(9601, 254, 155, 'Corolla', 10000, 1),
(9602, 254, 155, 'Currituck', 10000, 1),
(9603, 254, 155, 'Danbury', 10000, 1),
(9604, 254, 155, 'Dobson', 10000, 1),
(9606, 254, 155, 'Durham', 10000, 1),
(9607, 254, 155, 'Edenton', 10000, 1),
(9608, 254, 155, 'Elizabeth City', 10000, 1),
(9609, 254, 155, 'Elizabethtown', 10000, 1),
(9610, 254, 155, 'Fayetteville', 10000, 1),
(9611, 254, 155, 'Forest City', 10000, 1),
(9613, 254, 155, 'Franklin', 10000, 1),
(9614, 254, 155, 'Gastonia', 10000, 1),
(9615, 254, 155, 'Gatesville', 10000, 1),
(9616, 254, 155, 'Glenville', 10000, 1),
(9617, 254, 155, 'Goldsboro', 10000, 1),
(9619, 254, 155, 'Greensboro', 10000, 1),
(9620, 254, 155, 'Greenville', 10000, 1),
(9621, 254, 155, 'Halifax', 10000, 1),
(9622, 254, 155, 'Hatteras', 10000, 1),
(9623, 254, 155, 'Havelock', 10000, 1),
(9624, 254, 155, 'Hayesville', 10000, 1),
(9625, 254, 155, 'Hendersonville', 10000, 1),
(9626, 254, 155, 'Hertford', 10000, 1),
(9627, 254, 155, 'Hickory', 10000, 1),
(9628, 254, 155, 'High Point', 10000, 1),
(9629, 254, 155, 'Jacksonville', 10000, 1),
(9630, 254, 155, 'Jefferson', 10000, 1),
(9631, 254, 155, 'Kannapolis', 10000, 1),
(9632, 254, 155, 'Kenansville', 10000, 1),
(9633, 254, 155, 'Kinston', 10000, 1),
(9634, 254, 155, 'Kitty Hawk', 10000, 1),
(9635, 254, 155, 'Laurinburg', 10000, 1),
(9636, 254, 155, 'Lenoir', 10000, 1),
(9637, 254, 155, 'Lexington', 10000, 1),
(9638, 254, 155, 'Lillington', 10000, 1),
(9639, 254, 155, 'Lincolnton', 10000, 1),
(9640, 254, 155, 'Linville', 10000, 1),
(9641, 254, 155, 'Louisburg', 10000, 1),
(9642, 254, 155, 'Lumberton', 10000, 1),
(9643, 254, 155, 'Marion', 10000, 1),
(9644, 254, 155, 'Monroe', 10000, 1),
(9645, 254, 155, 'Morehead City', 10000, 1),
(9647, 254, 155, 'Mount Mitchell', 10000, 1),
(9648, 254, 155, 'Murphy', 10000, 1),
(9649, 254, 155, 'Nags Head', 10000, 1),
(9650, 254, 155, 'Nashville', 10000, 1),
(9651, 254, 155, 'New Bern', 10000, 1),
(9652, 254, 155, 'Newland', 10000, 1),
(9653, 254, 155, 'Oxford', 10000, 1),
(9654, 254, 155, 'Pinehurst', 10000, 1),
(9655, 254, 155, 'Pisgah Forest', 10000, 1),
(9656, 254, 155, 'Pittsboro', 10000, 1),
(9657, 254, 155, 'Plymouth', 10000, 1),
(9658, 254, 155, 'Raeford', 10000, 1),
(9659, 254, 155, 'Reidsville', 10000, 1),
(9660, 254, 155, 'Roanoke Rapids', 10000, 1),
(9661, 254, 155, 'Robbinsville', 10000, 1),
(9662, 254, 155, 'Rockingham', 10000, 1),
(9663, 254, 155, 'Rocky Mount', 10000, 1),
(9664, 254, 155, 'Roxboro', 10000, 1),
(9665, 254, 155, 'Salisbury', 10000, 1),
(9666, 254, 155, 'Sanford', 10000, 1),
(9668, 254, 155, 'Saratoga', 10000, 1),
(9669, 254, 155, 'Selma', 10000, 1),
(9670, 254, 155, 'Shelby', 10000, 1),
(9671, 254, 155, 'Smithfield', 10000, 1),
(9672, 254, 155, 'Snow Hill', 10000, 1),
(9673, 254, 155, 'Southern Pines', 10000, 1),
(9674, 254, 155, 'Sparta', 10000, 1),
(9675, 254, 155, 'Spruce Pine', 10000, 1),
(9676, 254, 155, 'Statesville', 10000, 1),
(9677, 254, 155, 'Stumpy Point', 10000, 1),
(9678, 254, 155, 'Swanquarter', 10000, 1),
(9679, 254, 155, 'Sylva', 10000, 1),
(9680, 254, 155, 'Tarboro', 10000, 1),
(9681, 254, 155, 'Taylorsville', 10000, 1),
(9682, 254, 155, 'Trenton', 10000, 1),
(9683, 254, 155, 'Troy', 10000, 1),
(9684, 254, 155, 'Tryon', 10000, 1),
(9685, 254, 155, 'Wadesboro', 10000, 1),
(9686, 254, 155, 'Walkertown', 10000, 1),
(9687, 254, 155, 'Walnut', 10000, 1),
(9688, 254, 155, 'Warrenton', 10000, 1),
(9689, 254, 155, 'Washington', 10000, 1),
(9690, 254, 155, 'Waynesville', 10000, 1),
(9691, 254, 155, 'Whiteville', 10000, 1),
(9692, 254, 155, 'Wilkesboro', 10000, 1),
(9693, 254, 155, 'Williamston', 10000, 1),
(9694, 254, 155, 'Wilmington', 10000, 1),
(9695, 254, 155, 'Wilson', 10000, 1),
(9696, 254, 155, 'Windsor', 10000, 1),
(9697, 254, 155, 'Winnabow', 10000, 1),
(9698, 254, 155, 'Winston Salem', 10000, 1),
(9699, 254, 155, 'Winton', 10000, 1),
(9700, 254, 155, 'Yadkinville', 10000, 1),
(9701, 254, 155, 'Yanceyville', 10000, 1),
(9702, 254, 156, 'Alexander', 10000, 1),
(9703, 254, 156, 'Amidon', 10000, 1),
(9704, 254, 156, 'Ashley', 10000, 1),
(9705, 254, 156, 'Beach', 10000, 1),
(9706, 254, 156, 'Beulah', 10000, 1),
(9707, 254, 156, 'Bismarck', 10000, 1),
(9708, 254, 156, 'Bottineau', 10000, 1),
(9709, 254, 156, 'Bowbells', 10000, 1),
(9710, 254, 156, 'Bowman', 10000, 1),
(9711, 254, 156, 'Cando', 10000, 1),
(9712, 254, 156, 'Carrington', 10000, 1),
(9713, 254, 156, 'Carson', 10000, 1),
(9714, 254, 156, 'Cavalier', 10000, 1),
(9715, 254, 156, 'Center', 10000, 1),
(9716, 254, 156, 'Cooperstown', 10000, 1),
(9717, 254, 156, 'Crosby', 10000, 1),
(9718, 254, 156, 'Devils Lake', 10000, 1),
(9719, 254, 156, 'Dickinson', 10000, 1),
(9720, 254, 156, 'Ellendale', 10000, 1),
(9721, 254, 156, 'Fargo', 10000, 1),
(9722, 254, 156, 'Fessenden', 10000, 1),
(9723, 254, 156, 'Finley', 10000, 1),
(9724, 254, 156, 'Forman', 10000, 1),
(9725, 254, 156, 'Fort Yates', 10000, 1),
(9726, 254, 156, 'Garrison', 10000, 1),
(9727, 254, 156, 'Grafton', 10000, 1),
(9728, 254, 156, 'Grand Forks', 10000, 1),
(9729, 254, 156, 'Hettinger', 10000, 1),
(9730, 254, 156, 'Hillsboro', 10000, 1),
(9731, 254, 156, 'Jamestown', 10000, 1),
(9733, 254, 156, 'Lakota', 10000, 1),
(9734, 254, 156, 'Langdon', 10000, 1),
(9735, 254, 156, 'Lidgerwood', 10000, 1),
(9736, 254, 156, 'Linton', 10000, 1),
(9737, 254, 156, 'Lisbon', 10000, 1),
(9738, 254, 156, 'Mandan', 10000, 1),
(9739, 254, 156, 'Manning', 10000, 1),
(9740, 254, 156, 'McClusky', 10000, 1),
(9742, 254, 156, 'Minot', 10000, 1),
(9743, 254, 156, 'Mohall', 10000, 1),
(9744, 254, 156, 'Mott', 10000, 1),
(9745, 254, 156, 'Napoleon', 10000, 1),
(9746, 254, 156, 'New Rockford', 10000, 1),
(9747, 254, 156, 'Petersburg', 10000, 1),
(9748, 254, 156, 'Rolla', 10000, 1),
(9749, 254, 156, 'Rugby', 10000, 1),
(9750, 254, 156, 'Sherwood', 10000, 1),
(9751, 254, 156, 'Stanley', 10000, 1),
(9752, 254, 156, 'Steele', 10000, 1),
(9753, 254, 156, 'Towner', 10000, 1),
(9754, 254, 156, 'Valley City', 10000, 1),
(9755, 254, 156, 'Wahpeton', 10000, 1),
(9756, 254, 156, 'Washburn', 10000, 1),
(9757, 254, 156, 'Watford City', 10000, 1),
(9758, 254, 156, 'Williston', 10000, 1),
(9759, 254, 149, 'Ainsworth', 10000, 1),
(9760, 254, 149, 'Albion', 10000, 1),
(9761, 254, 149, 'Alliance', 10000, 1),
(9762, 254, 149, 'Alma', 10000, 1),
(9763, 254, 149, 'Arthur', 10000, 1),
(9764, 254, 149, 'Auburn', 10000, 1),
(9765, 254, 149, 'Aurora', 10000, 1),
(9766, 254, 149, 'Bartlett', 10000, 1),
(9767, 254, 149, 'Bassett', 10000, 1),
(9768, 254, 149, 'Beatrice', 10000, 1),
(9769, 254, 149, 'Beaver City', 10000, 1),
(9770, 254, 149, 'Bellevue', 10000, 1),
(9771, 254, 149, 'Benkelman', 10000, 1),
(9772, 254, 149, 'Blair', 10000, 1),
(9773, 254, 149, 'Bloomfield', 10000, 1),
(9774, 254, 149, 'Brewster', 10000, 1),
(9775, 254, 149, 'Bridgeport', 10000, 1),
(9776, 254, 149, 'Broken Bow', 10000, 1),
(9777, 254, 149, 'Butte', 10000, 1),
(9778, 254, 149, 'Central City', 10000, 1),
(9779, 254, 149, 'Chadron', 10000, 1),
(9780, 254, 149, 'Chappell', 10000, 1),
(9781, 254, 149, 'Clay Center', 10000, 1),
(9782, 254, 149, 'Columbus', 10000, 1),
(9783, 254, 149, 'Crete', 10000, 1),
(9784, 254, 149, 'Dakota City', 10000, 1),
(9785, 254, 149, 'David City', 10000, 1),
(9786, 254, 149, 'Elwood', 10000, 1),
(9787, 254, 149, 'Fairbury', 10000, 1),
(9788, 254, 149, 'Falls City', 10000, 1),
(9789, 254, 149, 'Franklin', 10000, 1),
(9790, 254, 149, 'Fremont', 10000, 1),
(9791, 254, 149, 'Fullerton', 10000, 1),
(9792, 254, 149, 'Geneva', 10000, 1),
(9793, 254, 149, 'Grand Island', 10000, 1),
(9794, 254, 149, 'Grant', 10000, 1),
(9795, 254, 149, 'Greeley', 10000, 1),
(9796, 254, 149, 'Harrisburg', 10000, 1),
(9797, 254, 149, 'Harrison', 10000, 1),
(9798, 254, 149, 'Hartington', 10000, 1),
(9799, 254, 149, 'Hastings', 10000, 1),
(9800, 254, 149, 'Hayes Center', 10000, 1),
(9801, 254, 149, 'Hebron', 10000, 1),
(9802, 254, 149, 'Holdrege', 10000, 1),
(9803, 254, 149, 'Hyannis', 10000, 1),
(9804, 254, 149, 'Imperial', 10000, 1),
(9805, 254, 149, 'Kearney', 10000, 1),
(9806, 254, 149, 'Kimball', 10000, 1),
(9807, 254, 149, 'Lexington', 10000, 1),
(9808, 254, 149, 'Lincoln', 10000, 1),
(9809, 254, 149, 'Loup City', 10000, 1),
(9811, 254, 149, 'Mc Cook', 10000, 1),
(9812, 254, 149, 'Minden', 10000, 1),
(9813, 254, 149, 'Mullen', 10000, 1),
(9814, 254, 149, 'Nebraska City', 10000, 1),
(9815, 254, 149, 'Neligh', 10000, 1),
(9816, 254, 149, 'Nelson', 10000, 1),
(9817, 254, 149, 'Norfolk', 10000, 1),
(9818, 254, 149, 'North Platte', 10000, 1),
(9819, 254, 149, 'Ogallala', 10000, 1),
(9822, 254, 149, 'Ord', 10000, 1),
(9823, 254, 149, 'Osceola', 10000, 1),
(9824, 254, 149, 'Oshkosh', 10000, 1),
(9825, 254, 149, 'Papillion', 10000, 1),
(9826, 254, 149, 'Pawnee City', 10000, 1),
(9827, 254, 149, 'Pierce', 10000, 1),
(9828, 254, 149, 'Plattsmouth', 10000, 1),
(9829, 254, 149, 'Ponca', 10000, 1),
(9830, 254, 149, 'Red Cloud', 10000, 1),
(9831, 254, 149, 'Rushville', 10000, 1),
(9832, 254, 149, 'Schuyler', 10000, 1),
(9833, 254, 149, 'Scottsbluff', 10000, 1),
(9834, 254, 149, 'Seward', 10000, 1),
(9835, 254, 149, 'Sidney', 10000, 1),
(9836, 254, 149, 'Springview', 10000, 1),
(9838, 254, 149, 'Stanton', 10000, 1),
(9839, 254, 149, 'Stapleton', 10000, 1),
(9840, 254, 149, 'Stockville', 10000, 1),
(9841, 254, 149, 'Taylor', 10000, 1),
(9842, 254, 149, 'Tecumseh', 10000, 1),
(9843, 254, 149, 'Tekamah', 10000, 1),
(9844, 254, 149, 'Thedford', 10000, 1),
(9845, 254, 149, 'Trenton', 10000, 1),
(9846, 254, 149, 'Tryon', 10000, 1),
(9847, 254, 149, 'Valentine', 10000, 1),
(9848, 254, 149, 'Wahoo', 10000, 1),
(9849, 254, 149, 'Wayne', 10000, 1),
(9850, 254, 149, 'West Point', 10000, 1),
(9851, 254, 149, 'Winnebago', 10000, 1),
(9852, 254, 149, 'York', 10000, 1),
(9853, 254, 151, 'Berlin', 10000, 1),
(9854, 254, 151, 'Claremont', 10000, 1),
(9855, 254, 151, 'Concord', 10000, 1),
(9857, 254, 151, 'Dover', 10000, 1),
(9859, 254, 151, 'Hanover', 10000, 1),
(9860, 254, 151, 'Happy Corner', 10000, 1),
(9861, 254, 151, 'Jackson', 10000, 1),
(9862, 254, 151, 'Jaffrey', 10000, 1),
(9863, 254, 151, 'Keene', 10000, 1),
(9864, 254, 151, 'Laconia', 10000, 1),
(9865, 254, 151, 'Lebanon', 10000, 1),
(9866, 254, 151, 'Lincoln', 10000, 1),
(9867, 254, 151, 'Littleton', 10000, 1),
(9868, 254, 151, 'Manchester', 10000, 1),
(9869, 254, 151, 'Nashua', 10000, 1),
(9870, 254, 151, 'Plymouth', 10000, 1),
(9871, 254, 151, 'Portsmouth', 10000, 1),
(9872, 254, 151, 'Rochester', 10000, 1),
(9873, 254, 151, 'Salem', 10000, 1),
(9875, 254, 151, 'Water Village', 10000, 1),
(9876, 254, 152, 'Asbury Park', 10000, 1),
(9877, 254, 152, 'Atlantic City', 10000, 1),
(9878, 254, 152, 'Avalon', 10000, 1),
(9879, 254, 152, 'Barnegat', 10000, 1),
(9880, 254, 152, 'Barneget Lighthouse', 10000, 1),
(9881, 254, 152, 'Bayonne', 10000, 1),
(9882, 254, 152, 'Belleville', 10000, 1),
(9883, 254, 152, 'Belmar', 10000, 1),
(9884, 254, 152, 'Bergenfield', 10000, 1),
(9885, 254, 152, 'Bloomfield', 10000, 1),
(9887, 254, 152, 'Bridgeton', 10000, 1),
(9888, 254, 152, 'Caldwell', 10000, 1),
(9889, 254, 152, 'Camden', 10000, 1),
(9890, 254, 152, 'Cape May', 10000, 1),
(9891, 254, 152, 'Cherry Hill', 10000, 1),
(9892, 254, 152, 'Cliffside Park', 10000, 1),
(9893, 254, 152, 'Clifton', 10000, 1),
(9894, 254, 152, 'Cranford', 10000, 1),
(9895, 254, 152, 'East Brunswick Towns', 10000, 1),
(9896, 254, 152, 'East Orange', 10000, 1),
(9899, 254, 152, 'Elizabeth', 10000, 1),
(9900, 254, 152, 'Englewood', 10000, 1),
(9901, 254, 152, 'Trenton', 10000, 1),
(9902, 254, 152, 'Fair Lawn', 10000, 1),
(9903, 254, 152, 'Fairfield', 10000, 1),
(9904, 254, 152, 'Fairton', 10000, 1),
(9906, 254, 152, 'Fort Lee', 10000, 1),
(9907, 254, 152, 'Franklin', 10000, 1),
(9908, 254, 152, 'Freehold', 10000, 1),
(9909, 254, 152, 'Garfield', 10000, 1),
(9910, 254, 152, 'Glassboro', 10000, 1),
(9911, 254, 152, 'Hackensack', 10000, 1),
(9912, 254, 152, 'Hammonton', 10000, 1),
(9913, 254, 152, 'Hazlet', 10000, 1),
(9915, 254, 152, 'Hillside', 10000, 1),
(9916, 254, 152, 'Hoboken', 10000, 1),
(9917, 254, 152, 'Hopatcong', 10000, 1),
(9918, 254, 152, 'Irvington', 10000, 1),
(9919, 254, 152, 'Jackson', 10000, 1),
(9920, 254, 152, 'Jersey City', 10000, 1),
(9922, 254, 152, 'Lakehurst', 10000, 1),
(9923, 254, 152, 'Lakewood', 10000, 1),
(9924, 254, 152, 'Linden', 10000, 1),
(9925, 254, 152, 'Livingston', 10000, 1),
(9926, 254, 152, 'Lodi', 10000, 1),
(9927, 254, 152, 'Long Branch', 10000, 1),
(9928, 254, 152, 'Mahwah', 10000, 1),
(9929, 254, 152, 'Manahawkin', 10000, 1),
(9930, 254, 152, 'Maplewood', 10000, 1),
(9931, 254, 152, 'Mays Landing', 10000, 1),
(9932, 254, 152, 'Medford', 10000, 1),
(9933, 254, 152, 'Middletown Township', 10000, 1),
(9934, 254, 152, 'Milford', 10000, 1),
(9935, 254, 152, 'Millville', 10000, 1),
(9936, 254, 152, 'Montclair', 10000, 1),
(9937, 254, 152, 'Montvale', 10000, 1),
(9938, 254, 152, 'Morris Plains', 10000, 1),
(9939, 254, 152, 'Morristown', 10000, 1),
(9940, 254, 152, 'Mount Arlington', 10000, 1),
(9941, 254, 152, 'Tuckerton', 10000, 1),
(9942, 254, 152, 'New Brunswick', 10000, 1),
(9943, 254, 152, 'Newton', 10000, 1),
(9944, 254, 152, 'North Bergen', 10000, 1),
(9945, 254, 152, 'Nutley', 10000, 1),
(9946, 254, 152, 'Ocean City', 10000, 1),
(9947, 254, 152, 'Old Bridge', 10000, 1),
(9948, 254, 152, 'Old Bridge Township', 10000, 1),
(9949, 254, 152, 'Orange', 10000, 1),
(9950, 254, 152, 'Paramus', 10000, 1),
(9951, 254, 152, 'Park Ridge', 10000, 1),
(9952, 254, 152, 'Parsippany', 10000, 1),
(9953, 254, 152, 'Passaic', 10000, 1),
(9954, 254, 152, 'Paterson', 10000, 1),
(9955, 254, 152, 'Paulsboro', 10000, 1),
(9956, 254, 152, 'Penns Grove', 10000, 1),
(9957, 254, 152, 'Perth Amboy', 10000, 1),
(9958, 254, 152, 'Phillipsburg', 10000, 1),
(9959, 254, 152, 'Piscataway', 10000, 1),
(9960, 254, 152, 'Plainfield', 10000, 1),
(9961, 254, 152, 'Point Pleasant Beach', 10000, 1),
(9962, 254, 152, 'Princeton', 10000, 1),
(9963, 254, 152, 'Rahway', 10000, 1),
(9964, 254, 152, 'Ridgewood', 10000, 1),
(9965, 254, 152, 'Rockaway', 10000, 1),
(9966, 254, 152, 'Roselle', 10000, 1),
(9967, 254, 152, 'Sayreville', 10000, 1),
(9968, 254, 152, 'Scotch Plains', 10000, 1),
(9970, 254, 152, 'Seaside Heights', 10000, 1),
(9971, 254, 152, 'Secaucus', 10000, 1),
(9972, 254, 152, 'Beach Haven', 10000, 1),
(9973, 254, 152, 'Somerset', 10000, 1),
(9974, 254, 152, 'Somerville', 10000, 1),
(9975, 254, 152, 'South Plainfield', 10000, 1),
(9976, 254, 152, 'Sparta', 10000, 1),
(9977, 254, 152, 'Spring Lake', 10000, 1),
(9978, 254, 152, 'Summit', 10000, 1),
(9979, 254, 152, 'Sussex', 10000, 1),
(9980, 254, 152, 'Teaneck', 10000, 1),
(9981, 254, 152, 'Teterboro', 10000, 1),
(9982, 254, 152, 'Toms River', 10000, 1),
(9984, 254, 152, 'Union City', 10000, 1),
(9986, 254, 152, 'Vernon', 10000, 1),
(9988, 254, 152, 'Vineland', 10000, 1),
(9989, 254, 152, 'Washington', 10000, 1),
(9991, 254, 152, 'West Milford', 10000, 1),
(9992, 254, 152, 'West New York', 10000, 1),
(9993, 254, 152, 'West Orange', 10000, 1),
(9994, 254, 152, 'Westfield', 10000, 1),
(9995, 254, 152, 'Whippany', 10000, 1),
(9996, 254, 152, 'Wildwood', 10000, 1),
(9997, 254, 152, 'Willingboro', 10000, 1),
(9998, 254, 152, 'Woodbridge', 10000, 1),
(9999, 254, 152, 'Woodbury', 10000, 1),
(10000, 254, 152, 'Wrightstown', 10000, 1),
(10001, 254, 153, 'Alamogordo', 10000, 1),
(10002, 254, 153, 'Albuquerque', 10000, 1),
(10003, 254, 153, 'Carrizozo', 10000, 1),
(10004, 254, 153, 'Angel Fire', 10000, 1),
(10005, 254, 153, 'Artesia', 10000, 1),
(10006, 254, 153, 'Belen', 10000, 1),
(10007, 254, 153, 'Bernalillo', 10000, 1),
(10008, 254, 153, 'Carlsbad', 10000, 1),
(10010, 254, 153, 'Cedarvale', 10000, 1),
(10011, 254, 153, 'Chama', 10000, 1),
(10012, 254, 153, 'Clayton', 10000, 1),
(10013, 254, 153, 'Cloudcroft', 10000, 1),
(10014, 254, 153, 'Clovis', 10000, 1),
(10015, 254, 153, 'Crownpoint', 10000, 1),
(10016, 254, 153, 'Deming', 10000, 1),
(10017, 254, 153, 'Dona Ana', 10000, 1),
(10018, 254, 153, 'Pinon', 10000, 1),
(10019, 254, 153, 'Escabosa', 10000, 1),
(10020, 254, 153, 'Farmington', 10000, 1),
(10021, 254, 153, 'Fort Sumner', 10000, 1),
(10022, 254, 153, 'Gallup', 10000, 1),
(10023, 254, 153, 'Grants', 10000, 1),
(10024, 254, 153, 'Grenville', 10000, 1),
(10025, 254, 153, 'Hobbs', 10000, 1),
(10026, 254, 153, 'Las Cruces', 10000, 1),
(10027, 254, 153, 'Las Vegas', 10000, 1),
(10028, 254, 153, 'Lordsburg', 10000, 1),
(10029, 254, 153, 'Los Alamos', 10000, 1),
(10030, 254, 153, 'Los Lunas', 10000, 1),
(10031, 254, 153, 'Luna', 10000, 1),
(10032, 254, 153, 'Mosquero', 10000, 1),
(10033, 254, 153, 'Portales', 10000, 1),
(10034, 254, 153, 'Raton', 10000, 1),
(10035, 254, 153, 'Red River', 10000, 1),
(10036, 254, 153, 'Reserve', 10000, 1),
(10037, 254, 153, 'Rio Rancho', 10000, 1),
(10038, 254, 153, 'Roswell', 10000, 1),
(10039, 254, 153, 'Ruidoso', 10000, 1),
(10040, 254, 153, 'Santa Fe', 10000, 1),
(10041, 254, 153, 'Santa Rosa', 10000, 1),
(10042, 254, 153, 'Santo Domingo Pueblo', 10000, 1),
(10043, 254, 153, 'Shiprock', 10000, 1),
(10044, 254, 153, 'Silver City', 10000, 1),
(10045, 254, 153, 'Socorro', 10000, 1),
(10047, 254, 153, 'Taos', 10000, 1),
(10049, 254, 153, 'Tucumcari', 10000, 1),
(10050, 254, 153, 'Wagon Mound', 10000, 1),
(10051, 254, 153, 'Williamsburg', 10000, 1),
(10052, 254, 153, 'Zuni', 10000, 1),
(10053, 254, 150, 'Austin', 10000, 1),
(10054, 254, 150, 'Battle Mountain', 10000, 1),
(10055, 254, 150, 'Caliente', 10000, 1),
(10056, 254, 150, 'Carson City', 10000, 1),
(10057, 254, 150, 'Elko', 10000, 1),
(10058, 254, 150, 'Ely', 10000, 1),
(10059, 254, 150, 'Eureka', 10000, 1),
(10060, 254, 150, 'Fallon', 10000, 1),
(10061, 254, 150, 'Fernley', 10000, 1),
(10062, 254, 150, 'Gardnerville', 10000, 1),
(10063, 254, 150, 'Hawthorne', 10000, 1),
(10064, 254, 150, 'Henderson', 10000, 1),
(10065, 254, 150, 'Incline Village', 10000, 1),
(10066, 254, 150, 'Jackpot', 10000, 1),
(10068, 254, 150, 'Las Vegas', 10000, 1),
(10069, 254, 150, 'Laughlin', 10000, 1),
(10070, 254, 150, 'Lovelock', 10000, 1),
(10071, 254, 150, 'Mc Dermitt', 10000, 1),
(10072, 254, 150, 'Mercury', 10000, 1),
(10073, 254, 150, 'Mesquite', 10000, 1),
(10075, 254, 150, 'North Las Vegas', 10000, 1),
(10076, 254, 150, 'Orovada', 10000, 1),
(10078, 254, 150, 'Reno', 10000, 1),
(10079, 254, 150, 'Sparks', 10000, 1),
(10080, 254, 150, 'Stateline', 10000, 1),
(10082, 254, 150, 'Tonopah', 10000, 1),
(10083, 254, 150, 'Virginia City', 10000, 1),
(10084, 254, 150, 'West Wendover', 10000, 1),
(10085, 254, 134, 'Wildhorse', 10000, 1),
(10086, 254, 150, 'Winnemucca', 10000, 1),
(10087, 254, 150, 'Yerington', 10000, 1),
(10088, 254, 154, 'Adams', 10000, 1),
(10089, 254, 154, 'Albany', 10000, 1),
(10090, 254, 154, 'Albion', 10000, 1),
(10091, 254, 154, 'Amityville', 10000, 1),
(10092, 254, 154, 'Amsterdam', 10000, 1),
(10093, 254, 154, 'Auburn', 10000, 1),
(10094, 254, 154, 'Baldwin', 10000, 1),
(10095, 254, 154, 'Batavia', 10000, 1),
(10096, 254, 154, 'Bath', 10000, 1),
(10097, 254, 154, 'Bay Shore', 10000, 1),
(10098, 254, 154, 'Binghamton', 10000, 1),
(10099, 254, 154, 'Boonville', 10000, 1),
(10100, 254, 154, 'Brentwood', 10000, 1),
(10102, 254, 154, 'Brockport', 10000, 1),
(10103, 254, 154, 'Bronx', 10000, 1),
(10104, 254, 154, 'Brooklyn', 10000, 1),
(10105, 254, 154, 'Buffalo', 10000, 1),
(10106, 254, 154, 'Canandaigua', 10000, 1),
(10107, 254, 154, 'Canton', 10000, 1),
(10108, 254, 154, 'Centereach', 10000, 1),
(10109, 254, 154, 'Central Islip', 10000, 1),
(10111, 254, 154, 'Cobleskill', 10000, 1),
(10112, 254, 154, 'Commack', 10000, 1),
(10114, 254, 154, 'Cooperstown', 10000, 1),
(10115, 254, 154, 'Copiague', 10000, 1),
(10116, 254, 154, 'Coram', 10000, 1),
(10117, 254, 154, 'Corning', 10000, 1),
(10119, 254, 154, 'Cortland', 10000, 1),
(10120, 254, 154, 'Deer Park', 10000, 1),
(10121, 254, 154, 'Delhi', 10000, 1),
(10122, 254, 154, 'East Meadows', 10000, 1),
(10123, 254, 154, 'East Northport', 10000, 1),
(10125, 254, 154, 'Elizabethtown', 10000, 1),
(10126, 254, 154, 'Elmira', 10000, 1),
(10127, 254, 154, 'Elmont', 10000, 1),
(10128, 254, 154, 'Farmingdale', 10000, 1),
(10129, 254, 154, 'Florida', 10000, 1),
(10130, 254, 154, 'Flushing', 10000, 1),
(10131, 254, 154, 'Fonda', 10000, 1),
(10133, 254, 154, 'Franklin Square', 10000, 1),
(10134, 254, 154, 'Fredonia', 10000, 1),
(10135, 254, 154, 'Freeport', 10000, 1),
(10136, 254, 154, 'Fultonville', 10000, 1),
(10137, 254, 154, 'Garden City', 10000, 1),
(10138, 254, 154, 'Geneseo', 10000, 1),
(10139, 254, 154, 'Glen Cove', 10000, 1),
(10140, 254, 154, 'Glens Falls', 10000, 1),
(10141, 254, 154, 'Glenwood', 10000, 1),
(10142, 254, 154, 'Glenwood Landing', 10000, 1),
(10143, 254, 154, 'Gloversville', 10000, 1),
(10144, 254, 154, 'Greenport', 10000, 1),
(10145, 254, 154, 'Harriman', 10000, 1),
(10146, 254, 154, 'Harrison', 10000, 1),
(10147, 254, 154, 'Au Sable Forks', 10000, 1),
(10148, 254, 154, 'Hempstead', 10000, 1),
(10149, 254, 154, 'Henrietta', 10000, 1),
(10150, 254, 154, 'Hicksville', 10000, 1),
(10151, 254, 154, 'Holbrook', 10000, 1),
(10153, 254, 154, 'Hudson Falls', 10000, 1),
(10154, 254, 154, 'Hunter', 10000, 1),
(10156, 254, 154, 'Inwood', 10000, 1),
(10158, 254, 154, 'Islip', 10000, 1),
(10159, 254, 154, 'Ithaca', 10000, 1),
(10160, 254, 154, 'Jamestown', 10000, 1),
(10161, 254, 154, 'Kingston', 10000, 1),
(10163, 254, 154, 'Lake George', 10000, 1),
(10164, 254, 154, 'Lake Pleasant', 10000, 1),
(10165, 254, 154, 'Levittown', 10000, 1),
(10166, 254, 154, 'Lindenhurst', 10000, 1),
(10167, 254, 154, 'Lockport', 10000, 1),
(10168, 254, 154, 'Long Beach', 10000, 1),
(10169, 254, 154, 'Lowville', 10000, 1),
(10170, 254, 154, 'Malone', 10000, 1),
(10171, 254, 154, 'Massapequa', 10000, 1),
(10172, 254, 154, 'Massena', 10000, 1),
(10173, 254, 154, 'Medford', 10000, 1),
(10174, 254, 154, 'Melville', 10000, 1),
(10175, 254, 154, 'Merrick', 10000, 1),
(10176, 254, 154, 'Middletown', 10000, 1),
(10177, 254, 154, 'Montauk', 10000, 1),
(10178, 254, 154, 'Monticello', 10000, 1),
(10179, 254, 154, 'Mount Vernon', 10000, 1),
(10180, 254, 154, 'New City', 10000, 1),
(10181, 254, 154, 'New Rochelle', 10000, 1),
(10182, 254, 154, 'New York', 10000, 1),
(10183, 254, 154, 'Newark', 10000, 1),
(10184, 254, 154, 'Newburgh', 10000, 1),
(10185, 254, 154, 'Newcomb', 10000, 1),
(10186, 254, 154, 'Niagara Falls', 10000, 1),
(10187, 254, 154, 'North Tonawanda', 10000, 1),
(10188, 254, 154, 'Norwich', 10000, 1),
(10189, 254, 154, 'Oceanside', 10000, 1),
(10190, 254, 154, 'Ogdensburg', 10000, 1),
(10191, 254, 154, 'Old Forge', 10000, 1),
(10192, 254, 154, 'Olean', 10000, 1),
(10193, 254, 154, 'Oneida', 10000, 1),
(10194, 254, 154, 'Oneonta', 10000, 1),
(10195, 254, 154, 'Ossining', 10000, 1),
(10196, 254, 154, 'Oswego', 10000, 1),
(10197, 254, 154, 'Oyster Bay', 10000, 1),
(10198, 254, 154, 'Palisades', 10000, 1),
(10199, 254, 154, 'Peekskill', 10000, 1),
(10200, 254, 154, 'Penn Yan', 10000, 1),
(10201, 254, 154, 'Plainview', 10000, 1),
(10203, 254, 154, 'Port Chester', 10000, 1),
(10204, 254, 154, 'Port Jefferson', 10000, 1),
(10205, 254, 154, 'Port Jervis', 10000, 1),
(10206, 254, 154, 'Poughkeepsie', 10000, 1),
(10207, 254, 154, 'Pulaski', 10000, 1),
(10208, 254, 154, 'Riverhead', 10000, 1),
(10209, 254, 154, 'Rochester', 10000, 1),
(10210, 254, 154, 'Rockville Centre', 10000, 1),
(10211, 254, 154, 'Rome', 10000, 1),
(10212, 254, 154, 'Ronkonkoma', 10000, 1),
(10213, 254, 154, 'Salamanca', 10000, 1),
(10214, 254, 154, 'Saranac Lake', 10000, 1),
(10215, 254, 154, 'Saratoga Springs', 10000, 1),
(10216, 254, 154, 'Schenectady', 10000, 1),
(10217, 254, 154, 'Selden', 10000, 1),
(10218, 254, 154, 'Shirley', 10000, 1),
(10219, 254, 154, 'Skaneateles', 10000, 1),
(10220, 254, 154, 'Smithtown', 10000, 1),
(10221, 254, 147, 'Southhampton', 10000, 1),
(10222, 254, 154, 'Spring Valley', 10000, 1),
(10223, 254, 154, 'Staten Island', 10000, 1),
(10225, 254, 154, 'Stony Brook', 10000, 1),
(10226, 254, 154, 'Suffern', 10000, 1),
(10228, 254, 154, 'Syracuse', 10000, 1),
(10229, 254, 154, 'Troy', 10000, 1),
(10230, 254, 154, 'Uniondale', 10000, 1),
(10232, 254, 154, 'Utica', 10000, 1),
(10233, 254, 154, 'Valley Stream', 10000, 1),
(10234, 254, 154, 'Warsaw', 10000, 1),
(10235, 254, 154, 'Waterloo', 10000, 1),
(10236, 254, 154, 'Watertown', 10000, 1),
(10237, 254, 154, 'Watkins Glen', 10000, 1),
(10238, 254, 154, 'Wellsville', 10000, 1),
(10239, 254, 154, 'West Babylon', 10000, 1),
(10240, 254, 154, 'West Islip', 10000, 1),
(10241, 254, 154, 'West Point', 10000, 1),
(10243, 254, 154, 'Westport', 10000, 1),
(10244, 254, 154, 'White Plains', 10000, 1),
(10245, 254, 154, 'Windham', 10000, 1),
(10246, 254, 154, 'Woodbury', 10000, 1),
(10247, 254, 154, 'Yonkers', 10000, 1),
(10248, 254, 157, 'Akron', 10000, 1),
(10249, 254, 157, 'Alliance', 10000, 1),
(10250, 254, 157, 'Appleton', 10000, 1),
(10251, 254, 157, 'Ashland', 10000, 1),
(10252, 254, 157, 'Ashtabula', 10000, 1),
(10253, 254, 157, 'Athens', 10000, 1),
(10255, 254, 157, 'Barberton', 10000, 1),
(10256, 254, 157, 'Batavia', 10000, 1),
(10257, 254, 157, 'Dayton', 10000, 1),
(10258, 254, 157, 'Bellefontaine', 10000, 1),
(10260, 254, 157, 'Bowling Green', 10000, 1),
(10261, 254, 157, 'Brookpark', 10000, 1),
(10262, 254, 157, 'Brunswick', 10000, 1),
(10263, 254, 157, 'Bryan', 10000, 1),
(10264, 254, 157, 'Bucyrus', 10000, 1),
(10265, 254, 157, 'Cadiz', 10000, 1),
(10266, 254, 157, 'Caldwell', 10000, 1),
(10267, 254, 157, 'Cambridge', 10000, 1),
(10268, 254, 157, 'Canton', 10000, 1),
(10269, 254, 157, 'Carrollton', 10000, 1),
(10270, 254, 157, 'Celina', 10000, 1),
(10272, 254, 157, 'Chardon', 10000, 1),
(10273, 254, 157, 'Chillicothe', 10000, 1),
(10274, 254, 157, 'Cincinnati', 10000, 1),
(10275, 254, 157, 'Circleville', 10000, 1),
(10276, 254, 157, 'Cleveland', 10000, 1),
(10278, 254, 157, 'Columbus', 10000, 1),
(10279, 254, 157, 'Coshocton', 10000, 1),
(10280, 254, 157, 'Cuyahoga Falls', 10000, 1),
(10282, 254, 157, 'Defiance', 10000, 1),
(10283, 254, 157, 'Delaware', 10000, 1),
(10284, 254, 157, 'Dover', 10000, 1),
(10285, 254, 157, 'Dublin', 10000, 1),
(10287, 254, 157, 'Eastlake', 10000, 1),
(10288, 254, 157, 'Eaton', 10000, 1),
(10289, 254, 157, 'Elyria', 10000, 1),
(10290, 254, 157, 'Euclid', 10000, 1),
(10291, 254, 157, 'Fairborn', 10000, 1),
(10292, 254, 157, 'Fairfield', 10000, 1),
(10293, 254, 157, 'Findlay', 10000, 1),
(10294, 254, 157, 'Fremont', 10000, 1),
(10296, 254, 157, 'Gallipolis', 10000, 1),
(10298, 254, 157, 'Georgetown', 10000, 1),
(10299, 254, 157, 'Girard', 10000, 1),
(10300, 254, 157, 'Green', 10000, 1),
(10301, 254, 157, 'Greenville', 10000, 1),
(10302, 254, 157, 'Grove City', 10000, 1),
(10303, 254, 157, 'Hamilton', 10000, 1),
(10304, 254, 157, 'Hillsboro', 10000, 1),
(10306, 254, 157, 'Huron', 10000, 1),
(10307, 254, 157, 'Ironton', 10000, 1),
(10308, 254, 157, 'Irwin', 10000, 1),
(10309, 254, 157, 'Jackson', 10000, 1),
(10310, 254, 157, 'Jefferson', 10000, 1),
(10311, 254, 157, 'Kent', 10000, 1),
(10312, 254, 157, 'Kenton', 10000, 1),
(10314, 254, 157, 'Lafayette', 10000, 1),
(10315, 254, 157, 'Lakewood', 10000, 1),
(10316, 254, 157, 'Lancaster', 10000, 1),
(10317, 254, 157, 'Lebanon', 10000, 1),
(10318, 254, 157, 'Lima', 10000, 1),
(10319, 254, 157, 'Logan', 10000, 1),
(10320, 254, 157, 'London', 10000, 1),
(10321, 254, 157, 'Lorain', 10000, 1),
(10322, 254, 157, 'Mansfield', 10000, 1),
(10323, 254, 157, 'Maple Heights', 10000, 1),
(10324, 254, 157, 'Marietta', 10000, 1),
(10325, 254, 157, 'Marion', 10000, 1),
(10326, 254, 157, 'Marysville', 10000, 1),
(10327, 254, 157, 'Massillon', 10000, 1),
(10329, 254, 157, 'Mc Arthur', 10000, 1),
(10330, 254, 157, 'Mc Connelsville', 10000, 1),
(10331, 254, 157, 'Medina', 10000, 1),
(10332, 254, 157, 'Mentor', 10000, 1),
(10333, 254, 157, 'Middlefield', 10000, 1),
(10334, 254, 157, 'Middletown', 10000, 1),
(10335, 254, 157, 'Millersburg', 10000, 1),
(10336, 254, 157, 'Mount Gilead', 10000, 1),
(10337, 254, 157, 'Mount Vernon', 10000, 1),
(10338, 254, 157, 'Napoleon', 10000, 1),
(10339, 254, 157, 'New Lexington', 10000, 1),
(10340, 254, 157, 'Newark', 10000, 1),
(10341, 254, 157, 'Niles', 10000, 1),
(10342, 254, 157, 'North Ridgeville', 10000, 1),
(10343, 254, 157, 'North Royalton', 10000, 1),
(10344, 254, 157, 'Norwalk', 10000, 1),
(10346, 254, 157, 'Ottawa', 10000, 1),
(10347, 254, 157, 'Painesville', 10000, 1),
(10349, 254, 157, 'Paulding', 10000, 1),
(10350, 254, 157, 'Piqua', 10000, 1),
(10352, 254, 157, 'Pomeroy', 10000, 1),
(10353, 254, 157, 'Port Clinton', 10000, 1),
(10354, 254, 157, 'Portsmouth', 10000, 1),
(10355, 254, 157, 'Ravenna', 10000, 1),
(10356, 254, 157, 'Reynoldsburg', 10000, 1),
(10357, 254, 157, 'Rickenbacker AFB', 10000, 1),
(10358, 254, 157, 'Rittman', 10000, 1),
(10359, 254, 157, 'Rocky River', 10000, 1),
(10360, 254, 157, 'Salem', 10000, 1),
(10361, 254, 157, 'Sandusky', 10000, 1),
(10363, 254, 157, 'Sidney', 10000, 1),
(10364, 254, 157, 'Solon', 10000, 1),
(10366, 254, 157, 'Springfield', 10000, 1),
(10367, 254, 157, 'Saint Clairsville', 10000, 1),
(10368, 254, 157, 'Saint Marys', 10000, 1),
(10369, 254, 157, 'Steubenville', 10000, 1),
(10370, 254, 157, 'Stow', 10000, 1),
(10371, 254, 157, 'Strongsville', 10000, 1),
(10372, 254, 157, 'Tiffin', 10000, 1),
(10373, 254, 157, 'Toledo', 10000, 1),
(10374, 254, 157, 'Troy', 10000, 1),
(10375, 254, 157, 'Urbana', 10000, 1),
(10376, 254, 157, 'Van Wert', 10000, 1),
(10377, 254, 157, 'Warren', 10000, 1),
(10378, 254, 157, 'Washington Court House', 10000, 1),
(10379, 254, 157, 'Wauseon', 10000, 1),
(10380, 254, 157, 'Waverly', 10000, 1),
(10382, 254, 157, 'West Union', 10000, 1),
(10383, 254, 157, 'Westerville', 10000, 1),
(10384, 254, 157, 'Westlake', 10000, 1),
(10385, 254, 157, 'Willoughby', 10000, 1),
(10386, 254, 157, 'Wilmington', 10000, 1),
(10387, 254, 157, 'Woodsfield', 10000, 1),
(10388, 254, 157, 'Wooster', 10000, 1),
(10389, 254, 157, 'Xenia', 10000, 1),
(10390, 254, 157, 'Youngstown', 10000, 1),
(10391, 254, 157, 'Zanesville', 10000, 1),
(10392, 254, 158, 'Ada', 10000, 1),
(10393, 254, 158, 'Altus', 10000, 1),
(10394, 254, 158, 'Alva', 10000, 1),
(10395, 254, 158, 'Anadarko', 10000, 1),
(10396, 254, 158, 'Antlers', 10000, 1),
(10397, 254, 158, 'Ardmore', 10000, 1),
(10398, 254, 158, 'Atoka', 10000, 1),
(10399, 254, 158, 'Bartlesville', 10000, 1),
(10400, 254, 158, 'Beaver', 10000, 1),
(10401, 254, 158, 'Bethany', 10000, 1),
(10402, 254, 158, 'Boise City', 10000, 1),
(10403, 254, 158, 'Broken Arrow', 10000, 1),
(10404, 254, 158, 'Buffalo', 10000, 1),
(10405, 254, 158, 'Chandler', 10000, 1),
(10406, 254, 158, 'Cherokee', 10000, 1),
(10407, 254, 158, 'Cheyenne', 10000, 1),
(10408, 254, 158, 'Chickasha', 10000, 1),
(10409, 254, 158, 'Claremore', 10000, 1),
(10410, 254, 158, 'Clinton', 10000, 1),
(10411, 254, 158, 'Coalgate', 10000, 1),
(10412, 254, 158, 'Cordell', 10000, 1),
(10414, 254, 158, 'Duncan', 10000, 1),
(10415, 254, 158, 'Durant', 10000, 1),
(10416, 254, 158, 'Edmond', 10000, 1),
(10417, 254, 158, 'El Reno', 10000, 1),
(10418, 254, 158, 'Elk City', 10000, 1),
(10419, 254, 158, 'Enid', 10000, 1),
(10420, 254, 158, 'Eufaula', 10000, 1),
(10421, 254, 158, 'Fairview', 10000, 1),
(10422, 254, 158, 'Fort Sill', 10000, 1),
(10423, 254, 158, 'Frederick', 10000, 1),
(10424, 254, 158, 'Gage', 10000, 1),
(10425, 254, 158, 'Grove', 10000, 1),
(10426, 254, 158, 'Guthrie', 10000, 1),
(10427, 254, 158, 'Guymon', 10000, 1),
(10428, 254, 158, 'Hobart', 10000, 1),
(10429, 254, 158, 'Holdenville', 10000, 1),
(10430, 254, 158, 'Hollis', 10000, 1),
(10431, 254, 158, 'Hugo', 10000, 1),
(10432, 254, 158, 'Idabel', 10000, 1),
(10433, 254, 158, 'Kingfisher', 10000, 1),
(10434, 254, 158, 'Lawton', 10000, 1),
(10435, 254, 158, 'Madill', 10000, 1),
(10436, 254, 158, 'Mangum', 10000, 1),
(10437, 254, 158, 'Marietta', 10000, 1),
(10438, 254, 158, 'McAlester', 10000, 1),
(10439, 254, 158, 'Medford', 10000, 1),
(10440, 254, 158, 'Miami', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(10443, 254, 158, 'Muskogee', 10000, 1),
(10444, 254, 158, 'Norman', 10000, 1),
(10445, 254, 158, 'Nowata', 10000, 1),
(10446, 254, 158, 'Okemah', 10000, 1),
(10447, 254, 158, 'Okmulgee', 10000, 1),
(10448, 254, 158, 'Oologah', 10000, 1),
(10449, 254, 158, 'Pauls Valley', 10000, 1),
(10450, 254, 158, 'Pawhuska', 10000, 1),
(10451, 254, 158, 'Pawnee', 10000, 1),
(10452, 254, 158, 'Perry', 10000, 1),
(10453, 254, 158, 'Ponca City', 10000, 1),
(10454, 254, 158, 'Poteau', 10000, 1),
(10455, 254, 158, 'Pryor', 10000, 1),
(10456, 254, 158, 'Sallisaw', 10000, 1),
(10457, 254, 158, 'Sapulpa', 10000, 1),
(10458, 254, 158, 'Shawnee', 10000, 1),
(10459, 254, 158, 'Stidham', 10000, 1),
(10460, 254, 158, 'Stigler', 10000, 1),
(10461, 254, 158, 'Stillwater', 10000, 1),
(10462, 254, 158, 'Stilwell', 10000, 1),
(10463, 254, 158, 'Sulphur', 10000, 1),
(10464, 254, 158, 'Tahlequah', 10000, 1),
(10465, 254, 158, 'Taloga', 10000, 1),
(10466, 254, 158, 'Tishomingo', 10000, 1),
(10467, 254, 158, 'Tulsa', 10000, 1),
(10468, 254, 158, 'Vance AFB', 10000, 1),
(10469, 254, 158, 'Vinita', 10000, 1),
(10470, 254, 158, 'Wagoner', 10000, 1),
(10471, 254, 158, 'Walters', 10000, 1),
(10472, 254, 158, 'Watonga', 10000, 1),
(10473, 254, 158, 'Waurika', 10000, 1),
(10474, 254, 158, 'Wheeless', 10000, 1),
(10475, 254, 158, 'Wilburton', 10000, 1),
(10477, 254, 158, 'Woodward', 10000, 1),
(10478, 254, 158, 'Yukon', 10000, 1),
(10479, 254, 159, 'Albany', 10000, 1),
(10481, 254, 159, 'Amity', 10000, 1),
(10482, 254, 159, 'Ashland', 10000, 1),
(10483, 254, 159, 'Astoria', 10000, 1),
(10484, 254, 159, 'Baker City', 10000, 1),
(10485, 254, 159, 'Beaverton', 10000, 1),
(10486, 254, 159, 'Bend', 10000, 1),
(10487, 254, 159, 'Boardman', 10000, 1),
(10488, 254, 159, 'Brookings', 10000, 1),
(10489, 254, 159, 'Burns', 10000, 1),
(10490, 254, 159, 'Carlton', 10000, 1),
(10491, 254, 159, 'Coos Bay', 10000, 1),
(10492, 254, 159, 'Corvallis', 10000, 1),
(10493, 254, 159, 'Dayton', 10000, 1),
(10494, 254, 159, 'Dundee', 10000, 1),
(10495, 254, 159, 'Eugene', 10000, 1),
(10496, 254, 159, 'Florence', 10000, 1),
(10497, 254, 159, 'Government Camp', 10000, 1),
(10498, 254, 159, 'Grants Pass', 10000, 1),
(10499, 254, 159, 'Gresham', 10000, 1),
(10500, 254, 159, 'Hillsboro', 10000, 1),
(10501, 254, 159, 'Hinkle', 10000, 1),
(10502, 254, 159, 'Hood River', 10000, 1),
(10503, 254, 159, 'Keizer', 10000, 1),
(10504, 254, 159, 'Klamath Falls', 10000, 1),
(10505, 254, 159, 'La Grande', 10000, 1),
(10506, 254, 159, 'La Pine', 10000, 1),
(10507, 254, 159, 'Lafayette', 10000, 1),
(10508, 254, 159, 'Lake Oswego', 10000, 1),
(10509, 254, 159, 'Lakeview', 10000, 1),
(10510, 254, 159, 'Lincoln City', 10000, 1),
(10511, 254, 159, 'Madras', 10000, 1),
(10512, 254, 159, 'McMinnville', 10000, 1),
(10513, 254, 159, 'Meacham', 10000, 1),
(10514, 254, 159, 'Medford', 10000, 1),
(10516, 254, 159, 'Newberg', 10000, 1),
(10517, 254, 159, 'Newport', 10000, 1),
(10518, 254, 159, 'North Bend', 10000, 1),
(10519, 254, 159, 'Ontario', 10000, 1),
(10520, 254, 159, 'Oregon City', 10000, 1),
(10521, 254, 159, 'Pendleton', 10000, 1),
(10522, 254, 159, 'Portland', 10000, 1),
(10523, 254, 159, 'Prineville', 10000, 1),
(10524, 254, 159, 'Redmond', 10000, 1),
(10525, 254, 159, 'Roseburg', 10000, 1),
(10526, 254, 159, 'Salem', 10000, 1),
(10528, 254, 159, 'Seaside', 10000, 1),
(10530, 254, 159, 'Sheridan', 10000, 1),
(10531, 254, 159, 'Sisters', 10000, 1),
(10532, 254, 159, 'Springfield', 10000, 1),
(10534, 254, 159, 'The Dalles', 10000, 1),
(10536, 254, 159, 'Tillamook', 10000, 1),
(10537, 254, 159, 'Troutdale', 10000, 1),
(10538, 254, 159, 'Umatilla', 10000, 1),
(10540, 254, 159, 'Willamina', 10000, 1),
(10541, 254, 159, 'Yamhill', 10000, 1),
(10543, 254, 160, 'Allentown', 10000, 1),
(10545, 254, 160, 'Altoona', 10000, 1),
(10548, 254, 160, 'Northern Cambria', 10000, 1),
(10549, 254, 160, 'Beaver Falls', 10000, 1),
(10550, 254, 160, 'Bedford', 10000, 1),
(10551, 254, 160, 'Belle Vernon', 10000, 1),
(10552, 254, 160, 'Bellefonte', 10000, 1),
(10553, 254, 160, 'Bensalem Township', 10000, 1),
(10554, 254, 160, 'Berwick', 10000, 1),
(10555, 254, 160, 'Bethel Park', 10000, 1),
(10556, 254, 160, 'Bethlehem', 10000, 1),
(10557, 254, 160, 'Blairsville', 10000, 1),
(10558, 254, 160, 'Bloomsburg', 10000, 1),
(10561, 254, 160, 'Bradford', 10000, 1),
(10562, 254, 160, 'Bristol', 10000, 1),
(10563, 254, 160, 'Butler', 10000, 1),
(10564, 254, 160, 'California', 10000, 1),
(10565, 254, 160, 'Carlisle', 10000, 1),
(10566, 254, 160, 'Chambersburg', 10000, 1),
(10567, 254, 160, 'Cheltenham Township', 10000, 1),
(10568, 254, 160, 'Chester', 10000, 1),
(10569, 254, 160, 'Clarion', 10000, 1),
(10570, 254, 160, 'Clearfield', 10000, 1),
(10571, 254, 160, 'Clymer', 10000, 1),
(10572, 254, 160, 'Coatesville', 10000, 1),
(10573, 254, 160, 'Concordville', 10000, 1),
(10574, 254, 160, 'Coraopolis', 10000, 1),
(10575, 254, 160, 'Coudersport', 10000, 1),
(10576, 254, 160, 'Danville', 10000, 1),
(10577, 254, 160, 'Devon', 10000, 1),
(10578, 254, 160, 'Doylestown', 10000, 1),
(10579, 254, 160, 'Drexel Hill', 10000, 1),
(10580, 254, 160, 'Du Bois', 10000, 1),
(10581, 254, 160, 'Easton', 10000, 1),
(10582, 254, 160, 'Edinboro', 10000, 1),
(10583, 254, 160, 'Elderton', 10000, 1),
(10584, 254, 160, 'Erie', 10000, 1),
(10585, 254, 160, 'Pittston', 10000, 1),
(10586, 254, 160, 'Folcroft', 10000, 1),
(10587, 254, 160, 'Franklin', 10000, 1),
(10588, 254, 160, 'Garden View', 10000, 1),
(10589, 254, 160, 'Gettysburg', 10000, 1),
(10590, 254, 160, 'Greensburg', 10000, 1),
(10591, 254, 160, 'Greenville', 10000, 1),
(10592, 254, 160, 'Harrisburg', 10000, 1),
(10593, 254, 160, 'Haverford Township', 10000, 1),
(10595, 254, 160, 'Hershey', 10000, 1),
(10596, 254, 160, 'Homer City', 10000, 1),
(10597, 254, 160, 'Honesdale', 10000, 1),
(10598, 254, 160, 'Huntingdon', 10000, 1),
(10599, 254, 160, 'Indiana', 10000, 1),
(10601, 254, 160, 'Jim Thorpe', 10000, 1),
(10602, 254, 160, 'Johnstown', 10000, 1),
(10603, 254, 160, 'Kittanning', 10000, 1),
(10604, 254, 160, 'Kutztown', 10000, 1),
(10605, 254, 160, 'Lancaster', 10000, 1),
(10606, 254, 160, 'Lansdale', 10000, 1),
(10607, 254, 160, 'Laporte', 10000, 1),
(10608, 254, 160, 'Latrobe', 10000, 1),
(10609, 254, 160, 'Lebanon', 10000, 1),
(10610, 254, 160, 'Lehighton', 10000, 1),
(10611, 254, 160, 'Levittown', 10000, 1),
(10612, 254, 160, 'Lewisburg', 10000, 1),
(10613, 254, 160, 'Lewistown', 10000, 1),
(10614, 254, 160, 'Liberty', 10000, 1),
(10615, 254, 160, 'Ligonier', 10000, 1),
(10616, 254, 160, 'Lock Haven', 10000, 1),
(10618, 254, 160, 'Marion Center', 10000, 1),
(10619, 254, 160, 'Marple', 10000, 1),
(10620, 254, 160, 'Matamoras', 10000, 1),
(10621, 254, 160, 'Mc Keesport', 10000, 1),
(10622, 254, 160, 'Meadville', 10000, 1),
(10623, 254, 160, 'Media', 10000, 1),
(10624, 254, 160, 'Middleburg', 10000, 1),
(10625, 254, 160, 'Middletown', 10000, 1),
(10626, 254, 160, 'Mifflinburg', 10000, 1),
(10627, 254, 160, 'Milford', 10000, 1),
(10628, 254, 160, 'Millersville', 10000, 1),
(10629, 254, 160, 'Milton', 10000, 1),
(10630, 254, 160, 'Monroeville', 10000, 1),
(10631, 254, 160, 'Montrose', 10000, 1),
(10633, 254, 160, 'Morgantown', 10000, 1),
(10635, 254, 160, 'Mount Union', 10000, 1),
(10636, 254, 160, 'New Bloomfield', 10000, 1),
(10637, 254, 160, 'New Castle', 10000, 1),
(10638, 254, 160, 'New Hope', 10000, 1),
(10639, 254, 160, 'Newtown', 10000, 1),
(10640, 254, 160, 'Norristown', 10000, 1),
(10641, 254, 160, 'Northumberland', 10000, 1),
(10642, 254, 160, 'Ohiopyle', 10000, 1),
(10643, 254, 160, 'Oil City', 10000, 1),
(10645, 254, 160, 'Perryopolis', 10000, 1),
(10646, 254, 160, 'Philadelphia', 10000, 1),
(10647, 254, 160, 'Philipsburg', 10000, 1),
(10648, 254, 160, 'Pittsburgh', 10000, 1),
(10650, 254, 160, 'Plymouth Meeting', 10000, 1),
(10651, 254, 160, 'Pocono Summit', 10000, 1),
(10652, 254, 160, 'Pottstown', 10000, 1),
(10653, 254, 160, 'Pottsville', 10000, 1),
(10654, 254, 160, 'Clifton Heights', 10000, 1),
(10655, 254, 160, 'Punxsutawney', 10000, 1),
(10656, 254, 160, 'Quakertown', 10000, 1),
(10657, 254, 160, 'Wayne', 10000, 1),
(10658, 254, 160, 'Reading', 10000, 1),
(10659, 254, 160, 'Ridley Park', 10000, 1),
(10660, 254, 160, 'Scranton', 10000, 1),
(10661, 254, 160, 'Selinsgrove', 10000, 1),
(10662, 254, 160, 'Sellersville', 10000, 1),
(10664, 254, 160, 'Shamokin', 10000, 1),
(10665, 254, 160, 'Sharon', 10000, 1),
(10667, 254, 160, 'Shippensburg', 10000, 1),
(10669, 254, 160, 'Slippery Rock', 10000, 1),
(10670, 254, 160, 'Smethport', 10000, 1),
(10671, 254, 160, 'Snow Shoe', 10000, 1),
(10672, 254, 160, 'Somerset', 10000, 1),
(10673, 254, 160, 'Spring Mountain', 10000, 1),
(10674, 254, 160, 'Springfield', 10000, 1),
(10676, 254, 160, 'State College', 10000, 1),
(10677, 254, 160, 'Stroudsburg', 10000, 1),
(10678, 254, 160, 'Sunbury', 10000, 1),
(10679, 254, 160, 'Tionesta', 10000, 1),
(10680, 254, 160, 'Feasterville Trevose', 10000, 1),
(10681, 254, 160, 'Tunkhannock', 10000, 1),
(10683, 254, 160, 'Uniontown', 10000, 1),
(10684, 254, 160, 'University Park', 10000, 1),
(10685, 254, 160, 'Upper Darby', 10000, 1),
(10686, 254, 160, 'Villanova', 10000, 1),
(10687, 254, 160, 'Warminster', 10000, 1),
(10688, 254, 160, 'Warren', 10000, 1),
(10689, 254, 160, 'Washington', 10000, 1),
(10690, 254, 160, 'Waynesburg', 10000, 1),
(10691, 254, 160, 'Wellsboro', 10000, 1),
(10692, 254, 160, 'West Chester', 10000, 1),
(10693, 254, 160, 'West Mifflin', 10000, 1),
(10697, 254, 160, 'Williamsport', 10000, 1),
(10698, 254, 160, 'Willow Grove', 10000, 1),
(10699, 254, 160, 'Wyalusing', 10000, 1),
(10700, 254, 160, 'York', 10000, 1),
(10701, 254, 161, 'Block Island', 10000, 1),
(10702, 254, 161, 'Cranston', 10000, 1),
(10703, 254, 161, 'East Providence', 10000, 1),
(10704, 254, 161, 'Kingston', 10000, 1),
(10705, 254, 161, 'Little Compton', 10000, 1),
(10706, 254, 161, 'Pawtucket', 10000, 1),
(10707, 254, 161, 'Providence', 10000, 1),
(10708, 254, 161, 'Smithfield', 10000, 1),
(10709, 254, 161, 'Tiverton', 10000, 1),
(10711, 254, 161, 'Warwick', 10000, 1),
(10712, 254, 161, 'West Warwick', 10000, 1),
(10713, 254, 161, 'Westerly', 10000, 1),
(10714, 254, 161, 'Woonsocket', 10000, 1),
(10715, 254, 162, 'Abbeville', 10000, 1),
(10716, 254, 162, 'Aiken', 10000, 1),
(10717, 254, 162, 'Allendale', 10000, 1),
(10718, 254, 162, 'Anderson', 10000, 1),
(10719, 254, 162, 'Bamberg', 10000, 1),
(10720, 254, 162, 'Barnwell', 10000, 1),
(10721, 254, 162, 'Beaufort', 10000, 1),
(10722, 254, 162, 'Belton', 10000, 1),
(10723, 254, 162, 'Bennettsville', 10000, 1),
(10724, 254, 162, 'Bishopville', 10000, 1),
(10725, 254, 162, 'Camden', 10000, 1),
(10726, 254, 162, 'Charleston', 10000, 1),
(10727, 254, 162, 'Cheraw', 10000, 1),
(10728, 254, 162, 'Chester', 10000, 1),
(10729, 254, 162, 'Clinton', 10000, 1),
(10730, 254, 162, 'Columbia', 10000, 1),
(10732, 254, 162, 'Dillon', 10000, 1),
(10733, 254, 162, 'Edgefield', 10000, 1),
(10734, 254, 162, 'Florence', 10000, 1),
(10735, 254, 162, 'Saint Matthews', 10000, 1),
(10736, 254, 162, 'Gaffney', 10000, 1),
(10737, 254, 162, 'Georgetown', 10000, 1),
(10738, 254, 162, 'Goose Creek', 10000, 1),
(10739, 254, 162, 'Greenville', 10000, 1),
(10740, 254, 162, 'Greenwood', 10000, 1),
(10741, 254, 162, 'Hampton', 10000, 1),
(10742, 254, 162, 'Hartsville', 10000, 1),
(10743, 254, 162, 'Hilton Head', 10000, 1),
(10744, 254, 162, 'Kingstree', 10000, 1),
(10745, 254, 162, 'Lancaster', 10000, 1),
(10746, 254, 162, 'Marion', 10000, 1),
(10748, 254, 162, 'Moncks Corner', 10000, 1),
(10749, 254, 162, 'Mount Pleasant', 10000, 1),
(10750, 254, 162, 'Myrtle Beach', 10000, 1),
(10751, 254, 162, 'Newberry', 10000, 1),
(10752, 254, 162, 'North Charleston', 10000, 1),
(10753, 254, 162, 'Orangeburg', 10000, 1),
(10754, 254, 162, 'Paris Island', 10000, 1),
(10755, 254, 162, 'Ridgeland', 10000, 1),
(10756, 254, 162, 'Rock Hill', 10000, 1),
(10757, 254, 162, 'Saluda', 10000, 1),
(10758, 254, 162, 'Santee', 10000, 1),
(10759, 254, 162, 'Seneca', 10000, 1),
(10760, 254, 162, 'Spartanburg', 10000, 1),
(10762, 254, 162, 'Summerton', 10000, 1),
(10763, 254, 162, 'Summerville', 10000, 1),
(10764, 254, 162, 'Sumter', 10000, 1),
(10765, 254, 162, 'Sunset', 10000, 1),
(10766, 254, 162, 'Union', 10000, 1),
(10767, 254, 162, 'Walterboro', 10000, 1),
(10768, 254, 162, 'Winnsboro', 10000, 1),
(10769, 254, 163, 'Aberdeen', 10000, 1),
(10770, 254, 163, 'Alexandria', 10000, 1),
(10771, 254, 163, 'Armour', 10000, 1),
(10773, 254, 163, 'Belle Fourche', 10000, 1),
(10774, 254, 163, 'Bison', 10000, 1),
(10775, 254, 163, 'Britton', 10000, 1),
(10776, 254, 163, 'Brookings', 10000, 1),
(10777, 254, 163, 'Buffalo', 10000, 1),
(10778, 254, 163, 'Burke', 10000, 1),
(10779, 254, 163, 'Canton', 10000, 1),
(10780, 254, 163, 'Chamberlain', 10000, 1),
(10781, 254, 163, 'Clark', 10000, 1),
(10782, 254, 163, 'Clear Lake', 10000, 1),
(10783, 254, 163, 'Corsica', 10000, 1),
(10784, 254, 163, 'Custer', 10000, 1),
(10785, 254, 163, 'De Smet', 10000, 1),
(10786, 254, 163, 'Deadwood', 10000, 1),
(10787, 254, 163, 'Edgemont', 10000, 1),
(10788, 254, 163, 'Faulkton', 10000, 1),
(10789, 254, 163, 'Flandreau', 10000, 1),
(10790, 254, 163, 'Gannvalley', 10000, 1),
(10791, 254, 163, 'Geddes', 10000, 1),
(10792, 254, 163, 'Gettysburg', 10000, 1),
(10793, 254, 163, 'Hayes', 10000, 1),
(10794, 254, 163, 'Hayti', 10000, 1),
(10795, 254, 163, 'Highmore', 10000, 1),
(10796, 254, 163, 'Hill City', 10000, 1),
(10797, 254, 163, 'Hot Springs', 10000, 1),
(10798, 254, 163, 'Howard', 10000, 1),
(10799, 254, 163, 'Huron', 10000, 1),
(10800, 254, 163, 'Ipswich', 10000, 1),
(10801, 254, 163, 'Kadoka', 10000, 1),
(10802, 254, 163, 'Kennebec', 10000, 1),
(10803, 254, 163, 'Kingsburg', 10000, 1),
(10804, 254, 163, 'Lake Andes', 10000, 1),
(10805, 254, 163, 'Lead', 10000, 1),
(10806, 254, 163, 'Lemmon', 10000, 1),
(10807, 254, 163, 'Leola', 10000, 1),
(10808, 254, 163, 'Madison', 10000, 1),
(10809, 254, 163, 'Martin', 10000, 1),
(10811, 254, 163, 'Milbank', 10000, 1),
(10812, 254, 163, 'Miller', 10000, 1),
(10813, 254, 163, 'Parkston', 10000, 1),
(10814, 254, 163, 'Mitchell', 10000, 1),
(10815, 254, 163, 'Mobridge', 10000, 1),
(10816, 254, 163, 'Mound City', 10000, 1),
(10817, 254, 163, 'Murdo', 10000, 1),
(10818, 254, 163, 'Onida', 10000, 1),
(10819, 254, 163, 'Parker', 10000, 1),
(10820, 254, 163, 'Parmelee', 10000, 1),
(10821, 254, 163, 'Philip', 10000, 1),
(10822, 254, 163, 'Pickstown', 10000, 1),
(10823, 254, 163, 'Pierre', 10000, 1),
(10824, 254, 163, 'Pine Ridge', 10000, 1),
(10825, 254, 163, 'Plankinton', 10000, 1),
(10826, 254, 163, 'Rapid City', 10000, 1),
(10827, 254, 163, 'Redfield', 10000, 1),
(10828, 254, 163, 'Redig', 10000, 1),
(10829, 254, 163, 'Salem', 10000, 1),
(10830, 254, 163, 'Sioux Falls', 10000, 1),
(10831, 254, 163, 'Sisseton', 10000, 1),
(10832, 254, 163, 'Spearfish', 10000, 1),
(10833, 254, 163, 'Union Center', 10000, 1),
(10834, 254, 163, 'Sturgis', 10000, 1),
(10835, 254, 163, 'Timber Lake', 10000, 1),
(10836, 254, 163, 'Vermillion', 10000, 1),
(10837, 254, 163, 'Watertown', 10000, 1),
(10838, 254, 163, 'Webster', 10000, 1),
(10839, 254, 163, 'Wessington Springs', 10000, 1),
(10840, 254, 163, 'White River', 10000, 1),
(10841, 254, 163, 'Winner', 10000, 1),
(10842, 254, 163, 'Woonsocket', 10000, 1),
(10843, 254, 163, 'Yankton', 10000, 1),
(10844, 254, 164, 'Alamo', 10000, 1),
(10845, 254, 164, 'Altamont', 10000, 1),
(10846, 254, 164, 'Ashland City', 10000, 1),
(10847, 254, 164, 'Athens', 10000, 1),
(10849, 254, 164, 'Benton', 10000, 1),
(10850, 254, 164, 'Bolivar', 10000, 1),
(10851, 254, 164, 'Brentwood', 10000, 1),
(10852, 254, 164, 'Bristol', 10000, 1),
(10853, 254, 164, 'Brownsville', 10000, 1),
(10854, 254, 164, 'Byrdstown', 10000, 1),
(10855, 254, 164, 'Camden', 10000, 1),
(10856, 254, 164, 'Carthage', 10000, 1),
(10857, 254, 164, 'Celina', 10000, 1),
(10858, 254, 164, 'Centerville', 10000, 1),
(10859, 254, 164, 'Chattanooga', 10000, 1),
(10860, 254, 164, 'Clarksville', 10000, 1),
(10861, 254, 164, 'Cleveland', 10000, 1),
(10862, 254, 164, 'Columbia', 10000, 1),
(10863, 254, 164, 'Cookeville', 10000, 1),
(10864, 254, 164, 'Covington', 10000, 1),
(10865, 254, 164, 'Crossville', 10000, 1),
(10866, 254, 164, 'Dayton', 10000, 1),
(10867, 254, 164, 'Decatur', 10000, 1),
(10868, 254, 164, 'Dickson', 10000, 1),
(10869, 254, 164, 'Dover', 10000, 1),
(10870, 254, 164, 'Dunlap', 10000, 1),
(10871, 254, 164, 'Dyersburg', 10000, 1),
(10873, 254, 164, 'Elizabethton', 10000, 1),
(10874, 254, 164, 'Erin', 10000, 1),
(10875, 254, 164, 'Erwin', 10000, 1),
(10876, 254, 164, 'Fayetteville', 10000, 1),
(10877, 254, 164, 'Franklin', 10000, 1),
(10878, 254, 164, 'Gainesboro', 10000, 1),
(10879, 254, 164, 'Gallatin', 10000, 1),
(10880, 254, 164, 'Gatlinburg', 10000, 1),
(10881, 254, 164, 'Germantown', 10000, 1),
(10882, 254, 164, 'Greeneville', 10000, 1),
(10883, 254, 164, 'Hartsville', 10000, 1),
(10884, 254, 164, 'Henderson', 10000, 1),
(10885, 254, 164, 'Hendersonville', 10000, 1),
(10886, 254, 164, 'Hohenwald', 10000, 1),
(10887, 254, 164, 'Huntsville', 10000, 1),
(10888, 254, 164, 'Jackson', 10000, 1),
(10889, 254, 164, 'Jamestown', 10000, 1),
(10890, 254, 164, 'Jasper', 10000, 1),
(10891, 254, 164, 'Jefferson City', 10000, 1),
(10892, 254, 164, 'Johnson City', 10000, 1),
(10893, 254, 164, 'Kingsport', 10000, 1),
(10894, 254, 164, 'Knoxville', 10000, 1),
(10895, 254, 164, 'La Follette', 10000, 1),
(10896, 254, 164, 'Lafayette', 10000, 1),
(10897, 254, 164, 'Lawrenceburg', 10000, 1),
(10898, 254, 164, 'Lebanon', 10000, 1),
(10899, 254, 164, 'Lenoir', 10000, 1),
(10900, 254, 164, 'Lewisburg', 10000, 1),
(10901, 254, 164, 'Lexington', 10000, 1),
(10902, 254, 164, 'Linden', 10000, 1),
(10903, 254, 164, 'Livingston', 10000, 1),
(10904, 254, 164, 'Lookout Mountain', 10000, 1),
(10905, 254, 164, 'Loudon', 10000, 1),
(10906, 254, 164, 'Lynchburg', 10000, 1),
(10907, 254, 164, 'Manchester', 10000, 1),
(10908, 254, 164, 'Martin', 10000, 1),
(10909, 254, 164, 'Maryville', 10000, 1),
(10910, 254, 164, 'Maynardville', 10000, 1),
(10913, 254, 164, 'Memphis', 10000, 1),
(10914, 254, 164, 'Milan', 10000, 1),
(10915, 254, 164, 'Monteagle', 10000, 1),
(10916, 254, 164, 'Morristown', 10000, 1),
(10917, 254, 164, 'Mountain City', 10000, 1),
(10918, 254, 164, 'Murfreesboro', 10000, 1),
(10919, 254, 164, 'Nashville', 10000, 1),
(10920, 254, 164, 'Newport', 10000, 1),
(10921, 254, 164, 'Oak Ridge', 10000, 1),
(10922, 254, 164, 'Paris', 10000, 1),
(10923, 254, 164, 'Parsons', 10000, 1),
(10924, 254, 164, 'Pigeon Forge', 10000, 1),
(10925, 254, 164, 'Pikeville', 10000, 1),
(10926, 254, 164, 'Pulaski', 10000, 1),
(10927, 254, 164, 'Ripley', 10000, 1),
(10928, 254, 164, 'Rockwood', 10000, 1),
(10929, 254, 164, 'Rogersville', 10000, 1),
(10930, 254, 164, 'Rutledge', 10000, 1),
(10931, 254, 164, 'Selmer', 10000, 1),
(10932, 254, 164, 'Sevierville', 10000, 1),
(10933, 254, 164, 'Shelbyville', 10000, 1),
(10934, 254, 164, 'Smithville', 10000, 1),
(10935, 254, 164, 'Sneedville', 10000, 1),
(10936, 254, 164, 'Somerville', 10000, 1),
(10937, 254, 164, 'Sparta', 10000, 1),
(10938, 254, 164, 'Spencer', 10000, 1),
(10939, 254, 164, 'Springfield', 10000, 1),
(10940, 254, 164, 'Sweetwater', 10000, 1),
(10941, 254, 164, 'Tazewell', 10000, 1),
(10942, 254, 164, 'Tiptonville', 10000, 1),
(10943, 254, 164, 'Townsend', 10000, 1),
(10944, 254, 164, 'Union City', 10000, 1),
(10945, 254, 164, 'Wartburg', 10000, 1),
(10946, 254, 164, 'Waverly', 10000, 1),
(10947, 254, 164, 'Waynesboro', 10000, 1),
(10948, 254, 164, 'Winchester', 10000, 1),
(10949, 254, 164, 'Woodbury', 10000, 1),
(10950, 254, 165, 'Abilene', 10000, 1),
(10951, 254, 165, 'Albany', 10000, 1),
(10952, 254, 165, 'Alice', 10000, 1),
(10953, 254, 165, 'Allen', 10000, 1),
(10954, 254, 165, 'Alpine', 10000, 1),
(10955, 254, 165, 'Alvin', 10000, 1),
(10956, 254, 165, 'Amarillo', 10000, 1),
(10957, 254, 165, 'Anahuac', 10000, 1),
(10958, 254, 165, 'Andrews', 10000, 1),
(10959, 254, 165, 'Anson', 10000, 1),
(10960, 254, 165, 'Archer City', 10000, 1),
(10961, 254, 165, 'Arlington', 10000, 1),
(10962, 254, 165, 'Aspermont', 10000, 1),
(10963, 254, 165, 'Athens', 10000, 1),
(10964, 254, 165, 'Atlanta', 10000, 1),
(10965, 254, 165, 'Austin', 10000, 1),
(10966, 254, 165, 'Ballinger', 10000, 1),
(10967, 254, 165, 'Bandera', 10000, 1),
(10968, 254, 165, 'Bastrop', 10000, 1),
(10969, 254, 165, 'Bay City', 10000, 1),
(10970, 254, 165, 'Baytown', 10000, 1),
(10971, 254, 165, 'Beaumont', 10000, 1),
(10972, 254, 165, 'Bedford', 10000, 1),
(10973, 254, 165, 'Beeville', 10000, 1),
(10974, 254, 165, 'Bellville', 10000, 1),
(10976, 254, 165, 'Benjamin', 10000, 1),
(10977, 254, 165, 'Big Lake', 10000, 1),
(10978, 254, 165, 'Big Spring', 10000, 1),
(10979, 254, 165, 'Boerne', 10000, 1),
(10980, 254, 165, 'Bonham', 10000, 1),
(10981, 254, 165, 'Borger', 10000, 1),
(10982, 254, 165, 'Brackettville', 10000, 1),
(10983, 254, 165, 'Brady', 10000, 1),
(10984, 254, 165, 'Breckenridge', 10000, 1),
(10985, 254, 165, 'Bremond', 10000, 1),
(10986, 254, 165, 'Brenham', 10000, 1),
(10987, 254, 165, 'Brownfield', 10000, 1),
(10988, 254, 165, 'Brownsville', 10000, 1),
(10989, 254, 165, 'Brownwood', 10000, 1),
(10990, 254, 165, 'Bruni', 10000, 1),
(10991, 254, 165, 'Bryan', 10000, 1),
(10992, 254, 165, 'Burnet', 10000, 1),
(10993, 254, 165, 'Caldwell', 10000, 1),
(10994, 254, 165, 'Cameron', 10000, 1),
(10995, 254, 165, 'Canadian', 10000, 1),
(10996, 254, 165, 'Canton', 10000, 1),
(10997, 254, 165, 'Canyon', 10000, 1),
(10998, 254, 165, 'Carrizo Springs', 10000, 1),
(10999, 254, 165, 'Carrollton', 10000, 1),
(11000, 254, 165, 'Carswell Afb', 10000, 1),
(11001, 254, 165, 'Carthage', 10000, 1),
(11002, 254, 165, 'Cedar Hill', 10000, 1),
(11003, 254, 165, 'Center', 10000, 1),
(11004, 254, 165, 'Centerville', 10000, 1),
(11005, 254, 165, 'Channelview', 10000, 1),
(11006, 254, 165, 'Channing', 10000, 1),
(11007, 254, 165, 'Goliad', 10000, 1),
(11008, 254, 165, 'Childress', 10000, 1),
(11009, 254, 165, 'Clarendon', 10000, 1),
(11010, 254, 165, 'Clarksville', 10000, 1),
(11011, 254, 165, 'Claude', 10000, 1),
(11012, 254, 165, 'Cleburne', 10000, 1),
(11013, 254, 165, 'Clifton', 10000, 1),
(11014, 254, 165, 'Clute', 10000, 1),
(11015, 254, 165, 'Clyde', 10000, 1),
(11016, 254, 165, 'Coldspring', 10000, 1),
(11017, 254, 165, 'Coleman', 10000, 1),
(11018, 254, 165, 'College Station', 10000, 1),
(11019, 254, 165, 'Colorado City', 10000, 1),
(11020, 254, 165, 'Columbus', 10000, 1),
(11021, 254, 165, 'Comanche', 10000, 1),
(11022, 254, 165, 'Commerce', 10000, 1),
(11023, 254, 165, 'Conroe', 10000, 1),
(11024, 254, 165, 'Cookville', 10000, 1),
(11025, 254, 165, 'Cooper', 10000, 1),
(11026, 254, 165, 'Coppell', 10000, 1),
(11027, 254, 165, 'Copperas Cove', 10000, 1),
(11028, 254, 165, 'Corpus Christi', 10000, 1),
(11029, 254, 165, 'Corsicana', 10000, 1),
(11030, 254, 165, 'Cotulla', 10000, 1),
(11031, 254, 165, 'Crane', 10000, 1),
(11032, 254, 165, 'Crockett', 10000, 1),
(11033, 254, 165, 'Crosbyton', 10000, 1),
(11034, 254, 165, 'Crowell', 10000, 1),
(11035, 254, 165, 'Crystal City', 10000, 1),
(11036, 254, 165, 'Cuero', 10000, 1),
(11037, 254, 165, 'Daingerfield', 10000, 1),
(11038, 254, 165, 'Dalhart', 10000, 1),
(11039, 254, 165, 'Dallas', 10000, 1),
(11040, 254, 165, 'Decatur', 10000, 1),
(11041, 254, 165, 'Deer Park', 10000, 1),
(11042, 254, 165, 'Del Rio', 10000, 1),
(11043, 254, 165, 'Denison', 10000, 1),
(11044, 254, 165, 'Denton', 10000, 1),
(11045, 254, 165, 'Denver City', 10000, 1),
(11046, 254, 165, 'Desoto', 10000, 1),
(11047, 254, 165, 'Dickens', 10000, 1),
(11048, 254, 165, 'Dimmitt', 10000, 1),
(11049, 254, 165, 'Dumas', 10000, 1),
(11050, 254, 165, 'Duncanville', 10000, 1),
(11051, 254, 165, 'Eagle Pass', 10000, 1),
(11052, 254, 165, 'Eastland', 10000, 1),
(11053, 254, 165, 'Edinburg', 10000, 1),
(11054, 254, 165, 'Edna', 10000, 1),
(11055, 254, 165, 'El Paso', 10000, 1),
(11056, 254, 165, 'Eldorado', 10000, 1),
(11057, 254, 165, 'Emory', 10000, 1),
(11058, 254, 165, 'Encinal', 10000, 1),
(11059, 254, 165, 'Ennis', 10000, 1),
(11060, 254, 165, 'Euless', 10000, 1),
(11061, 254, 165, 'Fairfield', 10000, 1),
(11062, 254, 165, 'Falfurrias', 10000, 1),
(11064, 254, 165, 'Farwell', 10000, 1),
(11065, 254, 165, 'Floresville', 10000, 1),
(11066, 254, 165, 'Flower Mound', 10000, 1),
(11067, 254, 165, 'Floydada', 10000, 1),
(11069, 254, 165, 'Fort Stockton', 10000, 1),
(11070, 254, 165, 'Fort Worth', 10000, 1),
(11073, 254, 165, 'Freeport', 10000, 1),
(11074, 254, 165, 'Friendswood', 10000, 1),
(11075, 254, 165, 'Gail', 10000, 1),
(11076, 254, 165, 'Gainesville', 10000, 1),
(11077, 254, 165, 'Galveston', 10000, 1),
(11078, 254, 165, 'Garden City', 10000, 1),
(11079, 254, 165, 'Garland', 10000, 1),
(11080, 254, 165, 'Gatesville', 10000, 1),
(11081, 254, 165, 'George West', 10000, 1),
(11082, 254, 165, 'Georgetown', 10000, 1),
(11083, 254, 165, 'Giddings', 10000, 1),
(11084, 254, 165, 'Gilmer', 10000, 1),
(11085, 254, 165, 'Glen Rose', 10000, 1),
(11086, 254, 165, 'Goldthwaite', 10000, 1),
(11087, 254, 165, 'Gonzales', 10000, 1),
(11088, 254, 165, 'Graham', 10000, 1),
(11089, 254, 165, 'Granbury', 10000, 1),
(11090, 254, 165, 'Grand Prairie', 10000, 1),
(11091, 254, 165, 'Grapevine', 10000, 1),
(11092, 254, 165, 'Greenville', 10000, 1),
(11093, 254, 165, 'Groesbeck', 10000, 1),
(11094, 254, 165, 'Groveton', 10000, 1),
(11096, 254, 165, 'Guthrie', 10000, 1),
(11097, 254, 165, 'Hamilton', 10000, 1),
(11098, 254, 165, 'Harlingen', 10000, 1),
(11099, 254, 165, 'Haskell', 10000, 1),
(11100, 254, 165, 'Hearne', 10000, 1),
(11101, 254, 165, 'Hebbronville', 10000, 1),
(11102, 254, 165, 'Hemphill', 10000, 1),
(11103, 254, 165, 'Hempstead', 10000, 1),
(11104, 254, 165, 'Henderson', 10000, 1),
(11105, 254, 165, 'Henrietta', 10000, 1),
(11106, 254, 165, 'Hereford', 10000, 1),
(11107, 254, 165, 'Hillsboro', 10000, 1),
(11108, 254, 165, 'Hondo', 10000, 1),
(11109, 254, 165, 'Houston', 10000, 1),
(11112, 254, 165, 'Humble', 10000, 1),
(11113, 254, 165, 'Huntsville', 10000, 1),
(11114, 254, 165, 'Hurst', 10000, 1),
(11115, 254, 165, 'Irving', 10000, 1),
(11116, 254, 165, 'Jacksboro', 10000, 1),
(11117, 254, 165, 'Jasper', 10000, 1),
(11118, 254, 165, 'Jefferson', 10000, 1),
(11119, 254, 165, 'Johnson City', 10000, 1),
(11120, 254, 165, 'Junction', 10000, 1),
(11121, 254, 165, 'Karnes City', 10000, 1),
(11122, 254, 165, 'Katy', 10000, 1),
(11123, 254, 165, 'Kaufman', 10000, 1),
(11125, 254, 165, 'Kerrville', 10000, 1),
(11126, 254, 165, 'Killeen', 10000, 1),
(11127, 254, 165, 'Kingsville', 10000, 1),
(11129, 254, 165, 'Kountze', 10000, 1),
(11130, 254, 165, 'Kurten', 10000, 1),
(11131, 254, 165, 'La Grange', 10000, 1),
(11132, 254, 165, 'La Porte', 10000, 1),
(11133, 254, 165, 'Terlingua', 10000, 1),
(11134, 254, 165, 'Lake Jackson', 10000, 1),
(11135, 254, 165, 'Lamesa', 10000, 1),
(11136, 254, 165, 'Lampasas', 10000, 1),
(11137, 254, 165, 'Lancaster', 10000, 1),
(11138, 254, 165, 'Laredo', 10000, 1),
(11140, 254, 165, 'League City', 10000, 1),
(11141, 254, 165, 'Leakey', 10000, 1),
(11142, 254, 165, 'Levelland', 10000, 1),
(11143, 254, 165, 'Lewisville', 10000, 1),
(11144, 254, 165, 'Liberty', 10000, 1),
(11145, 254, 165, 'Lipscomb', 10000, 1),
(11146, 254, 165, 'Littlefield', 10000, 1),
(11147, 254, 165, 'Livingston', 10000, 1),
(11148, 254, 165, 'Llano', 10000, 1),
(11149, 254, 165, 'Lockhart', 10000, 1),
(11150, 254, 165, 'Longview', 10000, 1),
(11151, 254, 165, 'Lubbock', 10000, 1),
(11152, 254, 165, 'Lubbock Reese AFB', 10000, 1),
(11153, 254, 165, 'Lufkin', 10000, 1),
(11154, 254, 165, 'Madisonville', 10000, 1),
(11155, 254, 165, 'Marathon', 10000, 1),
(11156, 254, 165, 'Marble Falls', 10000, 1),
(11157, 254, 165, 'Marfa', 10000, 1),
(11158, 254, 165, 'Marlin', 10000, 1),
(11159, 254, 165, 'Marshall', 10000, 1),
(11160, 254, 165, 'Mason', 10000, 1),
(11161, 254, 165, 'Matador', 10000, 1),
(11162, 254, 165, 'McAllen', 10000, 1),
(11163, 254, 165, 'Mc Kinney', 10000, 1),
(11164, 254, 165, 'Memphis', 10000, 1),
(11165, 254, 165, 'Menard', 10000, 1),
(11166, 254, 165, 'Mentone', 10000, 1),
(11167, 254, 165, 'Meridian', 10000, 1),
(11168, 254, 165, 'Mertzon', 10000, 1),
(11169, 254, 165, 'Mesquite', 10000, 1),
(11170, 254, 165, 'Miami', 10000, 1),
(11171, 254, 165, 'Midland', 10000, 1),
(11172, 254, 165, 'Mineral Wells', 10000, 1),
(11173, 254, 165, 'Mirando City', 10000, 1),
(11174, 254, 165, 'Mission', 10000, 1),
(11175, 254, 165, 'Missouri City', 10000, 1),
(11176, 254, 165, 'Monahans', 10000, 1),
(11177, 254, 165, 'Montague', 10000, 1),
(11178, 254, 165, 'Morton', 10000, 1),
(11179, 254, 165, 'Mount Vernon', 10000, 1),
(11180, 254, 165, 'Muleshoe', 10000, 1),
(11181, 254, 165, 'Nacogdoches', 10000, 1),
(11182, 254, 165, 'Navasota', 10000, 1),
(11183, 254, 165, 'New Boston', 10000, 1),
(11184, 254, 165, 'New Braunfels', 10000, 1),
(11185, 254, 165, 'Newton', 10000, 1),
(11186, 254, 165, 'North Richland Hills', 10000, 1),
(11187, 254, 165, 'Odessa', 10000, 1),
(11188, 254, 165, 'Orange', 10000, 1),
(11189, 254, 165, 'Ozona', 10000, 1),
(11190, 254, 165, 'Paducah', 10000, 1),
(11191, 254, 165, 'Paint Rock', 10000, 1),
(11192, 254, 165, 'Palacios', 10000, 1),
(11193, 254, 165, 'Palestine', 10000, 1),
(11194, 254, 165, 'Pampa', 10000, 1),
(11195, 254, 165, 'Panhandle', 10000, 1),
(11196, 254, 165, 'Paris', 10000, 1),
(11197, 254, 165, 'Pearland', 10000, 1),
(11198, 254, 165, 'Pearsall', 10000, 1),
(11199, 254, 165, 'Pecos', 10000, 1),
(11200, 254, 165, 'Perryton', 10000, 1),
(11201, 254, 165, 'Pharr', 10000, 1),
(11202, 254, 165, 'Pittsburg', 10000, 1),
(11203, 254, 165, 'Plainview', 10000, 1),
(11204, 254, 165, 'Plano', 10000, 1),
(11205, 254, 165, 'Pleasanton', 10000, 1),
(11206, 254, 165, 'Port Arthur', 10000, 1),
(11207, 254, 165, 'Port Lavaca', 10000, 1),
(11208, 254, 165, 'Post', 10000, 1),
(11209, 254, 165, 'Presidio', 10000, 1),
(11210, 254, 165, 'Quanah', 10000, 1),
(11211, 254, 165, 'Quitman', 10000, 1),
(11213, 254, 165, 'Rankin', 10000, 1),
(11214, 254, 165, 'Raymondville', 10000, 1),
(11216, 254, 165, 'Refugio', 10000, 1),
(11217, 254, 165, 'Richardson', 10000, 1),
(11218, 254, 165, 'Richmond', 10000, 1),
(11219, 254, 165, 'Rio Grande City', 10000, 1),
(11220, 254, 165, 'Robert Lee', 10000, 1),
(11221, 254, 165, 'Roby', 10000, 1),
(11222, 254, 165, 'Rockport', 10000, 1),
(11223, 254, 165, 'Rocksprings', 10000, 1),
(11224, 254, 165, 'Rockwall', 10000, 1),
(11225, 254, 165, 'Rosenberg', 10000, 1),
(11226, 254, 165, 'Round Rock', 10000, 1),
(11227, 254, 165, 'Rowlett', 10000, 1),
(11228, 254, 165, 'San Angelo', 10000, 1),
(11229, 254, 165, 'San Antonio', 10000, 1),
(11230, 254, 165, 'San Augustine', 10000, 1),
(11231, 254, 165, 'San Benito', 10000, 1),
(11232, 254, 165, 'San Diego', 10000, 1),
(11233, 254, 165, 'San Marcos', 10000, 1),
(11234, 254, 165, 'San Saba', 10000, 1),
(11235, 254, 165, 'Sanderson', 10000, 1),
(11236, 254, 165, 'Sarita', 10000, 1),
(11237, 254, 165, 'Seguin', 10000, 1),
(11238, 254, 165, 'Seminole', 10000, 1),
(11239, 254, 165, 'Seymour', 10000, 1),
(11240, 254, 165, 'Sherman', 10000, 1),
(11241, 254, 165, 'Sierra Blanca', 10000, 1),
(11242, 254, 165, 'Silverton', 10000, 1),
(11243, 254, 165, 'Sinton', 10000, 1),
(11244, 254, 165, 'Snyder', 10000, 1),
(11245, 254, 165, 'Sonora', 10000, 1),
(11246, 254, 165, 'South Padre Island', 10000, 1),
(11247, 254, 165, 'Spearman', 10000, 1),
(11248, 254, 165, 'Spring', 10000, 1),
(11249, 254, 165, 'Stanton', 10000, 1),
(11250, 254, 165, 'Stephenville', 10000, 1),
(11251, 254, 165, 'Sterling City', 10000, 1),
(11252, 254, 165, 'Stratford', 10000, 1),
(11253, 254, 165, 'Sugar Land', 10000, 1),
(11254, 254, 165, 'Sulphur Springs', 10000, 1),
(11255, 254, 165, 'Sweetwater', 10000, 1),
(11256, 254, 165, 'Tahoka', 10000, 1),
(11257, 254, 165, 'Temple', 10000, 1),
(11258, 254, 165, 'Texarkana', 10000, 1),
(11259, 254, 165, 'Texas City', 10000, 1),
(11260, 254, 165, 'The Colony', 10000, 1),
(11261, 254, 165, 'Throckmorton', 10000, 1),
(11262, 254, 165, 'Tilden', 10000, 1),
(11263, 254, 165, 'Tomball', 10000, 1),
(11264, 254, 165, 'Tulia', 10000, 1),
(11265, 254, 165, 'Tyler', 10000, 1),
(11266, 254, 165, 'Uvalde', 10000, 1),
(11267, 254, 165, 'Vancourt', 10000, 1),
(11268, 254, 165, 'Vega', 10000, 1),
(11269, 254, 165, 'Vernon', 10000, 1),
(11270, 254, 165, 'Victoria', 10000, 1),
(11271, 254, 165, 'Waco', 10000, 1),
(11272, 254, 165, 'Wadsworth', 10000, 1),
(11274, 254, 165, 'Weatherford', 10000, 1),
(11275, 254, 165, 'Wellington', 10000, 1),
(11276, 254, 165, 'Weslaco', 10000, 1),
(11277, 254, 165, 'Wharton', 10000, 1),
(11278, 254, 165, 'Wheeler', 10000, 1),
(11279, 254, 165, 'Wichita Falls', 10000, 1),
(11280, 254, 165, 'Wink', 10000, 1),
(11281, 254, 165, 'Woodville', 10000, 1),
(11282, 254, 165, 'Yoakum', 10000, 1),
(11283, 254, 165, 'Zapata', 10000, 1),
(11284, 254, 166, 'Bicknell', 10000, 1),
(11285, 254, 166, 'Blanding', 10000, 1),
(11286, 254, 166, 'Bountiful', 10000, 1),
(11287, 254, 166, 'Brian Head', 10000, 1),
(11288, 254, 166, 'Brigham City', 10000, 1),
(11289, 254, 166, 'Bryce Canyon', 10000, 1),
(11290, 254, 166, 'Bryce Canyon National Park', 10000, 1),
(11291, 254, 166, 'Cedar City', 10000, 1),
(11292, 254, 166, 'Clearfield', 10000, 1),
(11293, 254, 166, 'Coalville', 10000, 1),
(11294, 254, 166, 'Delta', 10000, 1),
(11295, 254, 166, 'Duchesne', 10000, 1),
(11296, 254, 166, 'Ephraim', 10000, 1),
(11297, 254, 166, 'Escalante', 10000, 1),
(11298, 254, 166, 'Fillmore', 10000, 1),
(11300, 254, 166, 'Green River', 10000, 1),
(11301, 254, 166, 'Hanksville', 10000, 1),
(11302, 254, 166, 'Heber City', 10000, 1),
(11303, 254, 166, 'Joseph', 10000, 1),
(11304, 254, 166, 'Kanab', 10000, 1),
(11305, 254, 166, 'Laketown', 10000, 1),
(11306, 254, 166, 'Layton', 10000, 1),
(11307, 254, 166, 'Logan', 10000, 1),
(11308, 254, 166, 'Manila', 10000, 1),
(11309, 254, 166, 'Manti', 10000, 1),
(11310, 254, 166, 'Midvale', 10000, 1),
(11311, 254, 166, 'Milford', 10000, 1),
(11312, 254, 166, 'Moab', 10000, 1),
(11313, 254, 166, 'Monticello', 10000, 1),
(11315, 254, 166, 'Nephi', 10000, 1),
(11316, 254, 166, 'Ogden', 10000, 1),
(11317, 254, 166, 'Orem', 10000, 1),
(11318, 254, 166, 'Park City', 10000, 1),
(11319, 254, 166, 'Payson', 10000, 1),
(11320, 254, 166, 'Price', 10000, 1),
(11321, 254, 166, 'Provo', 10000, 1),
(11322, 254, 166, 'Randolph', 10000, 1),
(11323, 254, 166, 'Richfield', 10000, 1),
(11324, 254, 166, 'Roosevelt', 10000, 1),
(11325, 254, 166, 'Roy', 10000, 1),
(11329, 254, 166, 'Spanish Fork', 10000, 1),
(11331, 254, 166, 'Tooele', 10000, 1),
(11332, 254, 166, 'Vernal', 10000, 1),
(11333, 254, 166, 'Wendover', 10000, 1),
(11336, 254, 167, 'Abingdon', 10000, 1),
(11337, 254, 167, 'Accomac', 10000, 1),
(11338, 254, 167, 'Alexandria', 10000, 1),
(11339, 254, 167, 'Amherst', 10000, 1),
(11340, 254, 167, 'Annandale', 10000, 1),
(11341, 254, 167, 'Appomattox', 10000, 1),
(11342, 254, 167, 'Arlington', 10000, 1),
(11343, 254, 167, 'Ashburn', 10000, 1),
(11344, 254, 167, 'Bedford', 10000, 1),
(11345, 254, 167, 'Berryville', 10000, 1),
(11346, 254, 167, 'Blacksburg', 10000, 1),
(11347, 254, 167, 'Bland', 10000, 1),
(11348, 254, 167, 'Bowling Green', 10000, 1),
(11349, 254, 167, 'Boydton', 10000, 1),
(11350, 254, 167, 'Bruington', 10000, 1),
(11351, 254, 167, 'Buckingham', 10000, 1),
(11352, 254, 167, 'Burke', 10000, 1),
(11353, 254, 167, 'Roanoke', 10000, 1),
(11354, 254, 167, 'Centreville', 10000, 1),
(11355, 254, 167, 'Chantilly', 10000, 1),
(11356, 254, 167, 'Charlottesville', 10000, 1),
(11357, 254, 167, 'Chesapeake', 10000, 1),
(11358, 254, 167, 'Chesterfield', 10000, 1),
(11359, 254, 167, 'Christiansburg', 10000, 1),
(11360, 254, 167, 'Clintwood', 10000, 1),
(11361, 254, 167, 'Courtland', 10000, 1),
(11362, 254, 167, 'Covington', 10000, 1),
(11363, 254, 167, 'Culpeper', 10000, 1),
(11364, 254, 167, 'Cumberland', 10000, 1),
(11365, 254, 167, 'Danville', 10000, 1),
(11367, 254, 167, 'Eastville', 10000, 1),
(11368, 254, 167, 'Emporia', 10000, 1),
(11369, 254, 167, 'Fairfax', 10000, 1),
(11370, 254, 167, 'Falls Church', 10000, 1),
(11371, 254, 167, 'Farmville', 10000, 1),
(11372, 254, 167, 'Fincastle', 10000, 1),
(11373, 254, 167, 'Floyd', 10000, 1),
(11374, 254, 167, 'Fredericksburg', 10000, 1),
(11375, 254, 167, 'Front Royal', 10000, 1),
(11376, 254, 167, 'Galax', 10000, 1),
(11377, 254, 167, 'Gate City', 10000, 1),
(11378, 254, 167, 'Gloucester', 10000, 1),
(11379, 254, 167, 'Goochland', 10000, 1),
(11380, 254, 167, 'Grundy', 10000, 1),
(11381, 254, 167, 'Hampton', 10000, 1),
(11382, 254, 167, 'Hanover', 10000, 1),
(11383, 254, 167, 'Harrisonburg', 10000, 1),
(11384, 254, 167, 'Heathsville', 10000, 1),
(11385, 254, 167, 'Herndon', 10000, 1),
(11387, 254, 167, 'Hopewell', 10000, 1),
(11388, 254, 167, 'Independence', 10000, 1),
(11389, 254, 167, 'Isle Of Wight', 10000, 1),
(11390, 254, 167, 'Jonesville', 10000, 1),
(11391, 254, 167, 'King George', 10000, 1),
(11392, 254, 167, 'King William', 10000, 1),
(11394, 254, 167, 'Lancaster', 10000, 1),
(11396, 254, 167, 'Lawrenceville', 10000, 1),
(11397, 254, 167, 'Lebanon', 10000, 1),
(11398, 254, 167, 'Leesburg', 10000, 1),
(11399, 254, 167, 'Lexington', 10000, 1),
(11400, 254, 167, 'Lorton', 10000, 1),
(11401, 254, 167, 'Louisa', 10000, 1),
(11402, 254, 167, 'Lovingston', 10000, 1),
(11403, 254, 167, 'Lunenburg', 10000, 1),
(11404, 254, 167, 'Luray', 10000, 1),
(11405, 254, 167, 'Lynchburg', 10000, 1),
(11406, 254, 167, 'Madison', 10000, 1),
(11407, 254, 167, 'Manassas', 10000, 1),
(11408, 254, 167, 'Marion', 10000, 1),
(11409, 254, 167, 'Martinsville', 10000, 1),
(11411, 254, 167, 'Mathews', 10000, 1),
(11412, 254, 167, 'Mc Lean', 10000, 1),
(11413, 254, 167, 'Mechanicsville', 10000, 1),
(11414, 254, 167, 'Montross', 10000, 1),
(11415, 254, 167, 'Mount Vernon', 10000, 1),
(11416, 254, 167, 'New Castle', 10000, 1),
(11417, 254, 167, 'New Kent', 10000, 1),
(11418, 254, 167, 'Newport News', 10000, 1),
(11419, 254, 167, 'Nokesville', 10000, 1),
(11420, 254, 167, 'Norfolk', 10000, 1),
(11422, 254, 167, 'Oakton', 10000, 1),
(11423, 254, 167, 'Orange', 10000, 1),
(11424, 254, 167, 'Palmyra', 10000, 1),
(11425, 254, 167, 'Pearisburg', 10000, 1),
(11426, 254, 167, 'Petersburg', 10000, 1),
(11427, 254, 167, 'Portsmouth', 10000, 1),
(11428, 254, 167, 'Powhatan', 10000, 1),
(11429, 254, 160, 'Presto', 10000, 1),
(11430, 254, 167, 'Pulaski', 10000, 1),
(11431, 254, 167, 'Quantico', 10000, 1),
(11432, 254, 167, 'Radford', 10000, 1),
(11433, 254, 167, 'Reston', 10000, 1),
(11434, 254, 167, 'Richmond', 10000, 1),
(11436, 254, 167, 'Rocky Mount', 10000, 1),
(11437, 254, 167, 'Salem', 10000, 1),
(11438, 254, 167, 'Saluda', 10000, 1),
(11440, 254, 167, 'South Boston', 10000, 1),
(11441, 254, 167, 'Springfield', 10000, 1),
(11442, 254, 167, 'Stafford', 10000, 1),
(11443, 254, 167, 'Stanardsville', 10000, 1),
(11444, 254, 167, 'Staunton', 10000, 1),
(11445, 254, 167, 'Sterling', 10000, 1),
(11446, 254, 167, 'Stuart', 10000, 1),
(11447, 254, 167, 'Suffolk', 10000, 1),
(11448, 254, 167, 'Surry', 10000, 1),
(11449, 254, 167, 'Sussex', 10000, 1),
(11450, 254, 167, 'Tappahannock', 10000, 1),
(11451, 254, 167, 'Tazewell', 10000, 1),
(11453, 254, 167, 'Virginia Beach', 10000, 1),
(11455, 254, 167, 'Warm Springs', 10000, 1),
(11456, 254, 167, 'Warrenton', 10000, 1),
(11457, 254, 167, 'Warsaw', 10000, 1),
(11458, 254, 167, 'Washington', 10000, 1),
(11459, 254, 167, 'Waynesboro', 10000, 1),
(11461, 254, 167, 'Williamsburg', 10000, 1),
(11462, 254, 167, 'Winchester', 10000, 1),
(11463, 254, 167, 'Winterham', 10000, 1),
(11464, 254, 167, 'Wise', 10000, 1),
(11465, 254, 167, 'Woodbridge', 10000, 1),
(11466, 254, 167, 'Woodstock', 10000, 1),
(11467, 254, 167, 'Wytheville', 10000, 1),
(11469, 254, 168, 'Auburn', 10000, 1),
(11470, 254, 168, 'Bellevue', 10000, 1),
(11471, 254, 168, 'Bellingham', 10000, 1),
(11472, 254, 168, 'Blaine', 10000, 1),
(11473, 254, 168, 'Bremerton', 10000, 1),
(11475, 254, 168, 'Burlington', 10000, 1),
(11476, 254, 168, 'Centralia', 10000, 1),
(11477, 254, 168, 'Cheney', 10000, 1),
(11479, 254, 168, 'Colville', 10000, 1),
(11480, 254, 168, 'Rockport', 10000, 1),
(11481, 254, 168, 'East Pasco', 10000, 1),
(11482, 254, 168, 'Edmonds', 10000, 1),
(11483, 254, 168, 'Ellensburg', 10000, 1),
(11484, 254, 168, 'Ephrata', 10000, 1),
(11485, 254, 168, 'Everett', 10000, 1),
(11486, 254, 168, 'Fairchild', 10000, 1),
(11487, 254, 168, 'Federal Way', 10000, 1),
(11488, 254, 168, 'Ferndale', 10000, 1),
(11489, 254, 168, 'Forks', 10000, 1),
(11491, 254, 168, 'Friday Harbor', 10000, 1),
(11492, 254, 168, 'Deming', 10000, 1),
(11493, 254, 168, 'Hanford', 10000, 1),
(11494, 254, 168, 'Hoquiam', 10000, 1),
(11495, 254, 168, 'Kennewick', 10000, 1),
(11496, 254, 168, 'Kent', 10000, 1),
(11497, 254, 168, 'Kirkland', 10000, 1),
(11498, 254, 168, 'Lacey', 10000, 1),
(11499, 254, 168, 'Lakewood', 10000, 1),
(11500, 254, 168, 'Longview', 10000, 1),
(11501, 254, 168, 'Lynden', 10000, 1),
(11502, 254, 168, 'Lynnwood', 10000, 1),
(11503, 254, 168, 'Mercer Island', 10000, 1),
(11505, 254, 168, 'Mount Vernon', 10000, 1),
(11506, 254, 168, 'Neah Bay', 10000, 1),
(11507, 254, 168, 'Ocean Shores', 10000, 1),
(11508, 254, 168, 'Olympia', 10000, 1),
(11509, 254, 168, 'Omak', 10000, 1),
(11510, 254, 168, 'Opportunity', 10000, 1),
(11511, 254, 168, 'Othello', 10000, 1),
(11512, 254, 168, 'Packwood', 10000, 1),
(11514, 254, 168, 'Pasco', 10000, 1),
(11515, 254, 168, 'Port Angeles', 10000, 1),
(11516, 254, 168, 'Port Townsend', 10000, 1),
(11517, 254, 168, 'Pullman', 10000, 1),
(11518, 254, 168, 'Puyallup', 10000, 1),
(11519, 254, 168, 'Quillayute', 10000, 1),
(11521, 254, 168, 'Redmond', 10000, 1),
(11522, 254, 168, 'Renton', 10000, 1),
(11523, 254, 168, 'Richland', 10000, 1),
(11527, 254, 168, 'Seattle', 10000, 1),
(11528, 254, 168, 'Sequim', 10000, 1),
(11529, 254, 168, 'Spokane', 10000, 1),
(11530, 254, 168, 'Stampede', 10000, 1),
(11531, 254, 168, 'Sumas', 10000, 1),
(11532, 254, 168, 'Tacoma', 10000, 1),
(11533, 254, 168, 'University Place', 10000, 1),
(11534, 254, 168, 'Vancouver', 10000, 1),
(11535, 254, 168, 'Walla Walla', 10000, 1),
(11536, 254, 168, 'Wenatchee', 10000, 1),
(11538, 254, 168, 'Yakima', 10000, 1),
(11539, 254, 170, 'Alma', 10000, 1),
(11540, 254, 170, 'Antigo', 10000, 1),
(11541, 254, 170, 'Appleton', 10000, 1),
(11542, 254, 170, 'Ashland', 10000, 1),
(11543, 254, 170, 'Balsam Lake', 10000, 1),
(11544, 254, 170, 'Baraboo', 10000, 1),
(11545, 254, 170, 'Bayfield', 10000, 1),
(11546, 254, 170, 'Beaver Dam', 10000, 1),
(11547, 254, 170, 'Beloit', 10000, 1),
(11548, 254, 170, 'Berlin', 10000, 1),
(11549, 254, 170, 'Black River Falls', 10000, 1),
(11550, 254, 170, 'Brookfield', 10000, 1),
(11551, 254, 170, 'Burlington', 10000, 1),
(11552, 254, 170, 'Chilton', 10000, 1),
(11553, 254, 170, 'Chippewa Falls', 10000, 1),
(11554, 254, 170, 'Crandon', 10000, 1),
(11555, 254, 170, 'Darlington', 10000, 1),
(11556, 254, 170, 'Dodgeville', 10000, 1),
(11557, 254, 170, 'Dresser', 10000, 1),
(11558, 254, 170, 'Durand', 10000, 1),
(11559, 254, 170, 'Eagle River', 10000, 1),
(11560, 254, 170, 'Eau Claire', 10000, 1),
(11561, 254, 170, 'Elkhorn', 10000, 1),
(11562, 254, 170, 'Florence', 10000, 1),
(11563, 254, 170, 'Fond Du Lac', 10000, 1),
(11564, 254, 170, 'Franklin', 10000, 1),
(11565, 254, 170, 'Friendship', 10000, 1),
(11566, 254, 170, 'Green Bay', 10000, 1),
(11568, 254, 170, 'Hayward', 10000, 1),
(11569, 254, 170, 'Hurley', 10000, 1),
(11570, 254, 170, 'Janesville', 10000, 1),
(11571, 254, 170, 'Jefferson', 10000, 1),
(11572, 254, 170, 'Junction City', 10000, 1),
(11573, 254, 170, 'Kenosha', 10000, 1),
(11576, 254, 170, 'Keshena', 10000, 1),
(11577, 254, 170, 'Kewaunee', 10000, 1),
(11578, 254, 170, 'La Crosse', 10000, 1),
(11579, 254, 170, 'Ladysmith', 10000, 1),
(11581, 254, 170, 'Lone Rock', 10000, 1),
(11582, 254, 170, 'Madison', 10000, 1),
(11583, 254, 170, 'Manitowoc', 10000, 1),
(11584, 254, 170, 'Marinette', 10000, 1),
(11585, 254, 170, 'Marshfield', 10000, 1),
(11586, 254, 170, 'Mauston', 10000, 1),
(11587, 254, 170, 'Medford', 10000, 1),
(11588, 254, 170, 'Menomonie', 10000, 1),
(11589, 254, 170, 'Mequon', 10000, 1),
(11590, 254, 170, 'Merrill', 10000, 1),
(11591, 254, 170, 'Milwaukee', 10000, 1),
(11592, 254, 170, 'Monroe', 10000, 1),
(11593, 254, 170, 'Montello', 10000, 1),
(11594, 254, 170, 'Neenah', 10000, 1),
(11595, 254, 170, 'Neillsville', 10000, 1),
(11596, 254, 170, 'New Berlin', 10000, 1),
(11597, 254, 170, 'New London', 10000, 1),
(11598, 254, 170, 'New Richmond', 10000, 1),
(11599, 254, 170, 'Oconto', 10000, 1),
(11600, 254, 170, 'Osceola', 10000, 1),
(11601, 254, 170, 'Oshkosh', 10000, 1),
(11602, 254, 170, 'Park Falls', 10000, 1),
(11603, 254, 170, 'Phillips', 10000, 1),
(11604, 254, 170, 'Platteville', 10000, 1),
(11605, 254, 170, 'Port Washington', 10000, 1),
(11606, 254, 170, 'Portage', 10000, 1),
(11607, 254, 170, 'Prairie Du Chien', 10000, 1),
(11608, 254, 170, 'Racine', 10000, 1),
(11609, 254, 170, 'Rhinelander', 10000, 1),
(11610, 254, 170, 'Rice Lake', 10000, 1),
(11611, 254, 170, 'Richland Center', 10000, 1),
(11612, 254, 170, 'River Falls', 10000, 1),
(11613, 254, 170, 'Seymour', 10000, 1),
(11614, 254, 170, 'Shawano', 10000, 1),
(11615, 254, 170, 'Sheboygan', 10000, 1),
(11616, 254, 170, 'Shell Lake', 10000, 1),
(11617, 254, 170, 'Silver Lake', 10000, 1),
(11618, 254, 170, 'Siren', 10000, 1),
(11619, 254, 170, 'Sparta', 10000, 1),
(11620, 254, 170, 'Stevens Point', 10000, 1),
(11621, 254, 170, 'Sturgeon Bay', 10000, 1),
(11622, 254, 170, 'Superior', 10000, 1),
(11623, 254, 170, 'Tomah', 10000, 1),
(11624, 254, 170, 'Twin Lakes', 10000, 1),
(11625, 254, 170, 'Viroqua', 10000, 1),
(11627, 254, 170, 'Washburn', 10000, 1),
(11628, 254, 170, 'Waukesha', 10000, 1),
(11629, 254, 170, 'Wausau', 10000, 1),
(11632, 254, 170, 'West Bend', 10000, 1),
(11633, 254, 170, 'Whitehall', 10000, 1),
(11634, 254, 170, 'Whitewater', 10000, 1),
(11636, 254, 169, 'Bartow', 10000, 1),
(11637, 254, 169, 'Beckley', 10000, 1),
(11638, 254, 169, 'Berkeley Springs', 10000, 1),
(11639, 254, 169, 'Bluefield', 10000, 1),
(11640, 254, 169, 'Bridgeport', 10000, 1),
(11641, 254, 169, 'Buckhannon', 10000, 1),
(11642, 254, 169, 'Charles Town', 10000, 1),
(11643, 254, 169, 'Charleston', 10000, 1),
(11644, 254, 169, 'Circleville', 10000, 1),
(11645, 254, 169, 'Clarksburg', 10000, 1),
(11646, 254, 169, 'Clay', 10000, 1),
(11647, 254, 169, 'Daybrook', 10000, 1),
(11648, 254, 169, 'Elizabeth', 10000, 1),
(11649, 254, 169, 'Elkins', 10000, 1),
(11650, 254, 169, 'Fairmont', 10000, 1),
(11652, 254, 169, 'Franklin', 10000, 1),
(11653, 254, 169, 'Glenville', 10000, 1),
(11654, 254, 169, 'Grafton', 10000, 1),
(11655, 254, 169, 'Grantsville', 10000, 1),
(11656, 254, 169, 'Green Bank', 10000, 1),
(11657, 254, 169, 'Hamlin', 10000, 1),
(11658, 254, 169, 'Harrisville', 10000, 1),
(11659, 254, 169, 'Hinton', 10000, 1),
(11660, 254, 169, 'Huntington', 10000, 1),
(11661, 254, 169, 'Keyser', 10000, 1),
(11662, 254, 169, 'Kingwood', 10000, 1),
(11663, 254, 169, 'Lewisburg', 10000, 1),
(11664, 254, 169, 'Logan', 10000, 1),
(11665, 254, 169, 'Madison', 10000, 1),
(11666, 254, 169, 'Marlinton', 10000, 1),
(11667, 254, 169, 'Martinsburg', 10000, 1),
(11668, 254, 169, 'Middlebourne', 10000, 1),
(11669, 254, 169, 'Moorefield', 10000, 1),
(11670, 254, 169, 'Morgantown', 10000, 1),
(11671, 254, 169, 'Moundsville', 10000, 1),
(11672, 254, 169, 'New Martinsville', 10000, 1),
(11673, 254, 169, 'Oak Hill', 10000, 1),
(11674, 254, 169, 'Parkersburg', 10000, 1),
(11675, 254, 169, 'Parsons', 10000, 1),
(11676, 254, 169, 'Petersburg', 10000, 1),
(11677, 254, 169, 'Philippi', 10000, 1),
(11678, 254, 169, 'Pineville', 10000, 1),
(11679, 254, 169, 'Point Pleasant', 10000, 1),
(11680, 254, 169, 'Ripley', 10000, 1),
(11681, 254, 169, 'Romney', 10000, 1),
(11682, 254, 169, 'Scott Depot', 10000, 1),
(11685, 254, 169, 'Spencer', 10000, 1),
(11686, 254, 169, 'Saint Marys', 10000, 1),
(11687, 254, 169, 'Summersville', 10000, 1),
(11688, 254, 169, 'Sutton', 10000, 1),
(11689, 254, 169, 'Union', 10000, 1),
(11690, 254, 169, 'Wayne', 10000, 1),
(11691, 254, 169, 'Webster', 10000, 1),
(11692, 254, 169, 'Weirton', 10000, 1),
(11693, 254, 169, 'Welch', 10000, 1),
(11694, 254, 169, 'West Union', 10000, 1),
(11695, 254, 169, 'Weston', 10000, 1),
(11696, 254, 169, 'Wheeling', 10000, 1),
(11697, 254, 169, 'White Pine', 10000, 1),
(11698, 254, 169, 'White Sulphur Springs', 10000, 1),
(11699, 254, 169, 'Williamson', 10000, 1),
(11700, 254, 169, 'Winfield', 10000, 1),
(11702, 254, 171, 'Big Piney', 10000, 1),
(11703, 254, 171, 'Buffalo', 10000, 1),
(11704, 254, 171, 'Casper', 10000, 1),
(11705, 254, 171, 'Cheyenne', 10000, 1),
(11706, 254, 171, 'Cody', 10000, 1),
(11707, 254, 171, 'Douglas', 10000, 1),
(11708, 254, 171, 'Evanston', 10000, 1),
(11709, 254, 171, 'Gillette', 10000, 1),
(11710, 254, 171, 'Glendo', 10000, 1),
(11712, 254, 171, 'Green River', 10000, 1),
(11713, 254, 171, 'Guernsey', 10000, 1),
(11714, 254, 171, 'Hanna', 10000, 1),
(11715, 254, 171, 'Jackson', 10000, 1),
(11716, 254, 171, 'Kemmerer', 10000, 1),
(11717, 254, 171, 'Lander', 10000, 1),
(11718, 254, 171, 'Laramie', 10000, 1),
(11719, 254, 171, 'Newcastle', 10000, 1),
(11720, 254, 171, 'Pine Bluffs', 10000, 1),
(11721, 254, 171, 'Pinedale', 10000, 1),
(11722, 254, 171, 'Rawlins', 10000, 1),
(11723, 254, 171, 'Riverton', 10000, 1),
(11724, 254, 171, 'Rock Springs', 10000, 1),
(11725, 254, 171, 'Saratoga', 10000, 1),
(11726, 254, 171, 'Sheridan', 10000, 1),
(11727, 254, 171, 'Sundance', 10000, 1),
(11728, 254, 171, 'Thermopolis', 10000, 1),
(11729, 254, 171, 'Torrington', 10000, 1),
(11730, 254, 171, 'Wheatland', 10000, 1),
(11731, 254, 171, 'Worland', 10000, 1),
(11745, 254, 132, 'Rochelle', 10000, 1),
(11746, 254, 132, 'Pitts', 10000, 1),
(11747, 253, 5392, 'Guildford', 10000, 1),
(11749, 254, 170, 'Stoughton', 10000, 1),
(11750, 43, 37, 'Mississauga', 10000, 1),
(11753, 254, 135, 'Rochester', 10000, 1),
(11756, 254, 151, 'Nottingham', 10000, 1),
(11757, 254, 152, 'Manville', 10000, 1),
(11759, 254, 157, 'Loudonville', 10000, 1),
(11760, 254, 154, 'Mineola', 10000, 1),
(11761, 234, 4025, 'Baden', 10000, 1),
(11763, 254, 155, 'Evergreen', 10000, 1),
(11764, 14, 4, 'Lismore', 10000, 1),
(11765, 254, 152, 'Madison', 10000, 1),
(11768, 119, 2257, 'Vicenza', 10000, 1),
(11770, 175, 2981, 'Aalsmeer', 10000, 1),
(11771, 254, 164, 'South Fulton', 10000, 1),
(11772, 152, 689, 'Rabat', 10000, 1),
(11773, 254, 132, 'Kennesaw', 10000, 1),
(11774, 91, 1913, 'Dachau', 10000, 1),
(11775, 253, 5392, 'Reading', 10000, 1),
(11776, 253, 5392, 'Hemel Hempstead', 10000, 1),
(11777, 254, 133, 'Kihei', 10000, 1),
(11778, 91, 1921, 'Elmshorn', 10000, 1),
(11779, 43, 37, 'Barrie', 10000, 1),
(11780, 14, 1, 'Bendigo', 10000, 1),
(11781, 254, 131, 'Crystal River', 10000, 1),
(11782, 254, 143, 'Templeton', 10000, 1),
(11783, 253, 5392, 'Worcester', 10000, 1),
(11787, 254, 154, 'Great Neck', 10000, 1),
(11789, 254, 144, 'Allegan', 10000, 1),
(11792, 254, 133, 'Kapolei', 10000, 1),
(11794, 254, 154, 'Morrisville', 10000, 1),
(11795, 254, 131, 'Key Largo', 10000, 1),
(11796, 254, 142, 'Temple Hills', 10000, 1),
(11797, 81, 4879, 'Espoo', 10000, 1),
(11799, 43, 37, 'Grimsby', 10000, 1),
(11800, 254, 155, 'Arden', 10000, 1),
(11801, 253, 5392, 'Stockport', 10000, 1),
(11803, 254, 160, 'Annville', 10000, 1),
(11804, 254, 157, 'Northwood', 10000, 1),
(11805, 91, 1916, 'Darmstadt', 10000, 1),
(11806, 254, 126, 'Sebastopol', 10000, 1),
(11807, 254, 151, 'Derry', 10000, 1),
(11808, 43, 36, 'Camrose', 10000, 1),
(11809, 254, 160, 'Eagleville', 10000, 1),
(11810, 254, 135, 'Savoy', 10000, 1),
(11811, 254, 154, 'Woodmere', 10000, 1),
(11813, 254, 127, 'Palisade', 10000, 1),
(11815, 254, 159, 'Cottage Grove', 10000, 1),
(11816, 254, 135, 'Gibson City', 10000, 1),
(11818, 43, 43, 'Surrey', 10000, 1),
(11821, 254, 131, 'St. Petersburg', 10000, 1),
(11822, 254, 168, 'Ritzville', 10000, 1),
(11823, 254, 162, 'Clemson', 10000, 1),
(11824, 253, 5392, 'York', 10000, 1),
(11826, 91, 1917, 'Bispingen', 10000, 1),
(11827, 43, 43, 'Gabriola', 10000, 1),
(11828, 254, 145, 'Stillwater', 10000, 1),
(11829, 254, 152, 'Union', 10000, 1),
(11832, 224, 3689, 'Bellville', 10000, 1),
(11834, 82, 1803, 'Noisy-le-Grand', 10000, 1),
(11835, 254, 144, 'Baraga', 10000, 1),
(11837, 43, 37, 'Shelburne', 10000, 1),
(11838, 254, 133, 'Hanapepe', 10000, 1),
(11839, 178, 4706, 'Papatoetoe', 10000, 1),
(11840, 254, 133, 'Keaau', 10000, 1),
(11842, 43, 40, 'North Battleford', 10000, 1),
(11844, 185, 3001, 'Fredrikstad', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(11845, 254, 170, 'Lakewood', 10000, 1),
(11848, 234, 4049, 'Buchs', 10000, 1),
(11850, 91, 1913, 'Rosenheim', 10000, 1),
(11851, 254, 131, 'Longwood', 10000, 1),
(11852, 254, 154, 'Woodstock', 10000, 1),
(11853, 254, 126, 'Scotts Valley', 10000, 1),
(11855, 43, 37, 'Port Hope', 10000, 1),
(11856, 254, 131, 'Odessa', 10000, 1),
(11857, 43, 35, 'Pierrefonds', 10000, 1),
(11859, 254, 135, 'McHenry', 10000, 1),
(11860, 253, 5392, 'Sunderland', 10000, 1),
(11863, 254, 165, 'Pasadena', 10000, 1),
(11864, 254, 165, 'Seabrook', 10000, 1),
(11865, 254, 162, 'Ninety Six', 10000, 1),
(11866, 43, 37, 'Whitby', 10000, 1),
(11867, 254, 168, 'Gig Harbor', 10000, 1),
(11868, 254, 134, 'Sugar City', 10000, 1),
(11869, 254, 138, 'Saint Joseph', 10000, 1),
(11870, 254, 147, 'Saint Joseph', 10000, 1),
(11871, 14, 1, 'Hawthorn', 10000, 1),
(11872, 14, 6, 'Bunbury', 10000, 1),
(11874, 119, 2242, 'Piacenza', 10000, 1),
(11875, 254, 125, 'Boston', 10000, 1),
(11876, 91, 1921, 'Kiel', 10000, 1),
(11878, 43, 43, 'Merville', 10000, 1),
(11879, 43, 43, 'Black Creek', 10000, 1),
(11880, 43, 37, 'Thorold', 10000, 1),
(11881, 254, 128, 'Stonington', 10000, 1),
(11882, 254, 168, 'Monroe', 10000, 1),
(11883, 82, 1812, 'Aix-en-Provence', 10000, 1),
(11884, 112, 2115, 'Hafnarfj', 10000, 1),
(11886, 254, 142, 'Libertytown', 10000, 1),
(11887, 133, 2432, 'Uijongbu', 10000, 1),
(11888, 81, 4879, 'Lahti', 10000, 1),
(11889, 254, 159, 'Forest Grove', 10000, 1),
(11890, 254, 166, 'Mount Pleasant', 10000, 1),
(11891, 43, 37, 'Guelph', 10000, 1),
(11892, 254, 165, 'Princeton', 10000, 1),
(11893, 91, 1913, 'Erlangen', 10000, 1),
(11895, 159, 2892, 'Cholula', 10000, 1),
(11896, 254, 147, 'St. Louis', 10000, 1),
(11897, 254, 159, 'Coquille', 10000, 1),
(11898, 254, 170, 'Algoma', 10000, 1),
(11900, 254, 154, 'Manhasset', 10000, 1),
(11901, 254, 131, 'Palmetto', 10000, 1),
(11902, 91, 1916, 'Wiesbaden', 10000, 1),
(11904, 233, 4006, '', 10000, 1),
(11908, 82, 1813, 'Villeurbanne', 10000, 1),
(11910, 254, 159, 'Cave Junction', 10000, 1),
(11912, 254, 154, 'Vestal', 10000, 1),
(11915, 119, 2249, 'Torino', 10000, 1),
(11916, 185, 2994, 'Flisa', 10000, 1),
(11921, 254, 172, 'Woodstock', 10000, 1),
(11922, 254, 141, 'Gardiner', 10000, 1),
(11924, 18, 1094, 'Isa Town', 10000, 1),
(11926, 254, 146, 'Ocean Springs', 10000, 1),
(11927, 254, 168, 'Otis Orchards', 10000, 1),
(11928, 254, 168, 'Oak Harbor', 10000, 1),
(11929, 233, 4010, 'Trollh', 10000, 1),
(11930, 254, 157, 'Sylvania', 10000, 1),
(11931, 254, 126, 'Hopland', 10000, 1),
(11934, 14, 4, 'Penrith', 10000, 1),
(11936, 175, 2985, 'Zwijndrecht', 10000, 1),
(11937, 119, 2246, 'Milano', 10000, 1),
(11938, 253, 5392, 'Halifax', 10000, 1),
(11939, 254, 143, 'Shelburne Falls', 10000, 1),
(11941, 254, 164, 'Ooltewah', 10000, 1),
(11942, 251, 4449, 'Rivne', 10000, 1),
(11943, 175, 2980, 'Tilburg', 10000, 1),
(11947, 233, 3996, '', 10000, 1),
(11948, 185, 2990, 'Lillestr', 10000, 1),
(11949, 91, 1925, 'Quedlinburg', 10000, 1),
(11950, 175, 2983, 'Leersum', 10000, 1),
(11953, 254, 152, 'Belle Mead', 10000, 1),
(11954, 254, 159, 'Wilsonville', 10000, 1),
(11955, 114, 2147, 'Bogor', 10000, 1),
(11956, 254, 142, 'Stevensville', 10000, 1),
(11957, 14, 4, 'Wollongong', 10000, 1),
(11960, 254, 133, 'Hanalei', 10000, 1),
(11961, 254, 133, 'Kailua-Kona', 10000, 1),
(11962, 254, 133, 'Kealakekua', 10000, 1),
(11964, 254, 155, 'Eden', 10000, 1),
(11966, 63, 1487, 'Limassol', 10000, 1),
(11967, 254, 144, 'East Jordan', 10000, 1),
(11968, 254, 134, 'Homedale', 10000, 1),
(11969, 254, 166, 'West Jordan', 10000, 1),
(11970, 91, 1923, 'Rostock', 10000, 1),
(11971, 226, 3937, 'Vigo', 10000, 1),
(11972, 254, 155, 'Candler', 10000, 1),
(11973, 254, 168, 'Poulsbo', 10000, 1),
(11974, 254, 155, 'Enka', 10000, 1),
(11975, 253, 5392, 'Oldham', 10000, 1),
(11977, 254, 131, 'Pomona Park', 10000, 1),
(11979, 234, 4029, 'Thun', 10000, 1),
(11981, 254, 168, 'Bothell', 10000, 1),
(11982, 154, 691, 'Kwajalein', 10000, 1),
(11983, 254, 155, 'Pinetown', 10000, 1),
(11984, 254, 169, 'Peterstown', 10000, 1),
(11985, 254, 165, 'Brookshire', 10000, 1),
(11986, 254, 157, 'East Liverpool', 10000, 1),
(11987, 254, 154, 'Kinderhook', 10000, 1),
(11988, 254, 157, 'Streetsboro', 10000, 1),
(11989, 185, 3005, 'Skien', 10000, 1),
(11990, 254, 157, 'Hudson', 10000, 1),
(11991, 43, 43, 'Stewart', 10000, 1),
(11993, 254, 131, 'Eustis', 10000, 1),
(11994, 271, 5062, 'Podgorica', 10000, 1),
(11995, 254, 165, 'Wimberley', 10000, 1),
(11996, 254, 162, 'Lexington', 10000, 1),
(11997, 43, 37, 'Oshawa', 10000, 1),
(11998, 254, 160, 'Leola', 10000, 1),
(11999, 254, 168, 'Darrington', 10000, 1),
(12000, 254, 131, 'Lake Wales', 10000, 1),
(12001, 254, 154, 'Tonawanda', 10000, 1),
(12003, 253, 5392, 'Shaftesbury', 10000, 1),
(12004, 119, 2246, 'Cardano al Campo', 10000, 1),
(12005, 119, 2245, 'Genova', 10000, 1),
(12007, 254, 128, 'Windsor', 10000, 1),
(12008, 253, 5392, 'London', 10000, 1),
(12009, 253, 5392, 'Wellingborough', 10000, 1),
(12013, 254, 135, 'Columbia', 10000, 1),
(12014, 149, 2905, 'George Town', 10000, 1),
(12015, 254, 136, 'Denver', 10000, 1),
(12016, 254, 154, 'Plattsburgh', 10000, 1),
(12018, 119, 2252, 'Siracusa', 10000, 1),
(12019, 43, 37, 'Bracebridge', 10000, 1),
(12020, 254, 134, 'Sandpoint', 10000, 1),
(12021, 254, 157, 'Vandalia', 10000, 1),
(12022, 254, 154, 'Jamesville', 10000, 1),
(12023, 119, 2245, 'Savona', 10000, 1),
(12024, 233, 4009, 'Landskrona', 10000, 1),
(12025, 91, 1918, 'Oberhausen', 10000, 1),
(12026, 254, 159, 'Jacksonville', 10000, 1),
(12027, 254, 148, 'West Yellowstone', 10000, 1),
(12028, 185, 3001, 'Skjeberg', 10000, 1),
(12029, 254, 141, 'Buxton', 10000, 1),
(12030, 254, 136, 'Mooresville', 10000, 1),
(12031, 254, 160, 'East Freedom', 10000, 1),
(12032, 254, 155, 'Morganton', 10000, 1),
(12034, 254, 154, 'Larchmont', 10000, 1),
(12035, 43, 43, 'Fernie', 10000, 1),
(12037, 254, 126, 'Cobb', 10000, 1),
(12038, 43, 43, 'Duncan', 10000, 1),
(12041, 185, 3001, 'Sarpsborg', 10000, 1),
(12042, 254, 160, 'Downingtown', 10000, 1),
(12045, 82, 1803, 'Plaisir', 10000, 1),
(12047, 254, 161, 'East Greenwich', 10000, 1),
(12048, 14, 4, 'Parramatta', 10000, 1),
(12049, 254, 123, 'Soldotna', 10000, 1),
(12053, 144, 2623, 'Clervaux', 10000, 1),
(12054, 43, 37, 'Brampton', 10000, 1),
(12055, 233, 4008, 'Sollentuna', 10000, 1),
(12056, 254, 147, 'Windsor', 10000, 1),
(12057, 254, 131, 'Worthington Springs', 10000, 1),
(12058, 43, 35, 'Beaumont', 10000, 1),
(12059, 253, 5392, 'Wakefield', 10000, 1),
(12063, 43, 37, 'Oakville', 10000, 1),
(12064, 254, 161, 'Bristol', 10000, 1),
(12066, 43, 37, 'Welland', 10000, 1),
(12067, 254, 162, 'Duncan', 10000, 1),
(12069, 254, 152, 'Salem', 10000, 1),
(12070, 254, 144, 'Stevensville', 10000, 1),
(12071, 254, 159, 'Sandy', 10000, 1),
(12072, 254, 154, 'Hornell', 10000, 1),
(12074, 254, 147, 'Brighton', 10000, 1),
(12077, 254, 152, 'Edison', 10000, 1),
(12078, 254, 126, 'Newbury Park', 10000, 1),
(12079, 254, 170, 'Plover', 10000, 1),
(12080, 254, 156, 'Casselton', 10000, 1),
(12081, 254, 158, 'Jenks', 10000, 1),
(12082, 224, 3684, 'Germiston', 10000, 1),
(12083, 185, 3008, 'Sandefjord', 10000, 1),
(12084, 254, 166, 'Loa', 10000, 1),
(12085, 254, 152, 'Williamstown', 10000, 1),
(12087, 14, 2, 'Devonport', 10000, 1),
(12088, 185, 2996, 'Aalesund', 10000, 1),
(12089, 253, 5389, 'Mold', 10000, 1),
(12090, 81, 5023, 'Vaasa', 10000, 1),
(12091, 233, 4009, 'Gisl', 10000, 1),
(12094, 254, 145, 'Chanhassen', 10000, 1),
(12095, 254, 137, 'Hudson', 10000, 1),
(12097, 224, 3680, 'Pietermaritzburg', 10000, 1),
(12099, 254, 168, 'Belfair', 10000, 1),
(12100, 43, 39, 'Bedford', 10000, 1),
(12101, 14, 3, 'Maryborough', 10000, 1),
(12103, 254, 157, 'Springboro', 10000, 1),
(12104, 82, 1803, 'Barbizon', 10000, 1),
(12105, 82, 1803, 'Issy-les-Moulineaux', 10000, 1),
(12106, 91, 1916, 'Offenbach', 10000, 1),
(12107, 91, 1916, 'Hanau', 10000, 1),
(12108, 253, 5392, 'Huddersfield', 10000, 1),
(12109, 254, 160, 'Hatfield', 10000, 1),
(12110, 159, 72, 'Playa Del Carmen', 10000, 1),
(12111, 254, 126, 'Oakhurst', 10000, 1),
(12112, 10, 1051, 'San Martin', 10000, 1),
(12113, 254, 159, 'Toledo', 10000, 1),
(12114, 43, 43, 'Port Hardy', 10000, 1),
(12115, 224, 3680, 'Richards Bay', 10000, 1),
(12116, 91, 1913, 'Starnberg', 10000, 1),
(12117, 254, 131, 'Saint Petersburg', 10000, 1),
(12118, 254, 139, 'Elkhorn City', 10000, 1),
(12119, 43, 43, 'Burnaby', 10000, 1),
(12120, 254, 170, 'Walworth', 10000, 1),
(12121, 233, 3994, 'Vansbro', 10000, 1),
(12122, 254, 160, 'Montoursville', 10000, 1),
(12123, 178, 3089, 'Wairoa', 10000, 1),
(12124, 254, 136, 'Ligonier', 10000, 1),
(12125, 254, 147, 'Nixa', 10000, 1),
(12126, 118, 2233, 'Kfar saba', 10000, 1),
(12127, 224, 3685, 'Secunda', 10000, 1),
(12128, 253, 5392, 'Worthing', 10000, 1),
(12129, 221, 3772, 'Maribor', 10000, 1),
(12131, 254, 136, 'Chesterton', 10000, 1),
(12132, 233, 3994, 'Borl', 10000, 1),
(12134, 254, 152, 'Marlboro', 10000, 1),
(12135, 18, 1085, 'Manama', 10000, 1),
(12136, 14, 6, 'Fremantle', 10000, 1),
(12137, 254, 160, 'Barnesville', 10000, 1),
(12138, 254, 140, 'West Monroe', 10000, 1),
(12139, 43, 37, 'Aurora', 10000, 1),
(12140, 254, 152, 'Elmwood Park', 10000, 1),
(12142, 254, 154, 'Johnstown', 10000, 1),
(12144, 254, 165, 'West Columbia', 10000, 1),
(12145, 254, 135, 'Romeoville', 10000, 1),
(12146, 254, 155, 'Leland', 10000, 1),
(12147, 43, 35, 'Buckingham', 10000, 1),
(12148, 43, 43, 'Mission', 10000, 1),
(12149, 119, 2241, 'Caserta', 10000, 1),
(12150, 114, 2150, 'Yogyakarta', 10000, 1),
(12152, 149, 2897, 'Batu Pahat', 10000, 1),
(12153, 81, 4879, 'Forssa', 10000, 1),
(12154, 254, 154, 'Mahopac', 10000, 1),
(12155, 65, 1494, 'Dronninglund', 10000, 1),
(12156, 114, 2148, 'Purworejo', 10000, 1),
(12157, 43, 42, 'Miramichi', 10000, 1),
(12158, 254, 126, 'Boulder Creek', 10000, 1),
(12159, 254, 154, 'West Winfield', 10000, 1),
(12160, 253, 5392, 'Chichester', 10000, 1),
(12161, 254, 126, 'Springville', 10000, 1),
(12163, 43, 43, 'Maple Ridge', 10000, 1),
(12164, 82, 1797, 'Saint Malo', 10000, 1),
(12165, 233, 4010, 'Bor', 10000, 1),
(12166, 254, 168, 'Manchester', 10000, 1),
(12167, 254, 159, 'Woodburn', 10000, 1),
(12168, 254, 136, 'Lake Station', 10000, 1),
(12169, 254, 145, 'Denham', 10000, 1),
(12173, 254, 139, 'Jenkins', 10000, 1),
(12175, 81, 1779, 'Oulu', 10000, 1),
(12176, 119, 2240, 'Palmi', 10000, 1),
(12177, 175, 2976, 'Wolvega', 10000, 1),
(12178, 233, 4009, 'Lund', 10000, 1),
(12179, 254, 160, 'Hauto', 10000, 1),
(12180, 254, 168, 'Mukilteo', 10000, 1),
(12181, 175, 2984, 'Terneuzen', 10000, 1),
(12182, 254, 136, 'Batesville', 10000, 1),
(12183, 254, 154, 'Ferndale', 10000, 1),
(12184, 254, 154, 'Wallkill', 10000, 1),
(12186, 226, 3937, 'A Coru', 10000, 1),
(12187, 14, 1, 'Cheltenham', 10000, 1),
(12188, 226, 3930, 'Vera', 10000, 1),
(12190, 254, 160, 'Perkasie', 10000, 1),
(12191, 254, 160, 'East Stroudsburg', 10000, 1),
(12194, 254, 144, 'Negaunee', 10000, 1),
(12195, 254, 138, 'Bonner Springs', 10000, 1),
(12196, 254, 152, 'Springfield', 10000, 1),
(12197, 14, 4, 'Campbelltown', 10000, 1),
(12198, 24, 1137, 'Knokke-Heist', 10000, 1),
(12199, 254, 131, 'Keystone Heights', 10000, 1),
(12200, 254, 131, 'Archer', 10000, 1),
(12202, 254, 143, 'Concord', 10000, 1),
(12203, 234, 4046, 'Martigny', 10000, 1),
(12206, 254, 132, 'Stockbridge', 10000, 1),
(12207, 254, 144, 'Haslett', 10000, 1),
(12208, 254, 125, 'Beebe', 10000, 1),
(12209, 254, 165, 'Quinlan', 10000, 1),
(12210, 82, 1809, 'Angers', 10000, 1),
(12211, 119, 2241, 'Napoli', 10000, 1),
(12212, 254, 159, 'Dufur', 10000, 1),
(12213, 254, 152, 'Flanders', 10000, 1),
(12214, 254, 170, 'New Glarus', 10000, 1),
(12215, 254, 170, 'Verona', 10000, 1),
(12216, 254, 170, 'Oregon', 10000, 1),
(12217, 254, 170, 'Middleton', 10000, 1),
(12219, 254, 170, 'Sun Prairie', 10000, 1),
(12220, 149, 2907, 'Petaling Jaya', 10000, 1),
(12221, 254, 170, 'Waunakee', 10000, 1),
(12222, 254, 170, 'Mount Horeb', 10000, 1),
(12225, 175, 2985, 'Gouda', 10000, 1),
(12226, 254, 170, 'Black Earth', 10000, 1),
(12227, 234, 4047, 'Pully', 10000, 1),
(12228, 254, 170, 'Cambridge', 10000, 1),
(12229, 254, 170, 'Deerfield', 10000, 1),
(12230, 253, 5392, 'Maidstone', 10000, 1),
(12231, 254, 170, 'Wisconsin Dells', 10000, 1),
(12232, 254, 170, 'Sauk City', 10000, 1),
(12233, 254, 170, 'Prairie du Sac', 10000, 1),
(12234, 254, 170, 'Lodi', 10000, 1),
(12235, 254, 170, 'Cross Plains', 10000, 1),
(12236, 254, 170, 'Belleville', 10000, 1),
(12237, 254, 170, 'Edgerton', 10000, 1),
(12238, 254, 170, 'Evansville', 10000, 1),
(12241, 254, 131, 'Hilliard', 10000, 1),
(12242, 254, 159, 'Central Point', 10000, 1),
(12243, 254, 151, 'Peterborough', 10000, 1),
(12244, 254, 135, 'Makanda', 10000, 1),
(12246, 254, 140, 'Pearl River', 10000, 1),
(12247, 254, 126, 'Oceanside', 10000, 1),
(12248, 254, 157, 'Johnstown', 10000, 1),
(12249, 254, 126, 'Browns Valley', 10000, 1),
(12251, 175, 2979, 'Roermond', 10000, 1),
(12252, 254, 168, 'Anacortes', 10000, 1),
(12253, 119, 2240, 'Lamezia Terme', 10000, 1),
(12255, 152, 689, 'Victoria', 10000, 1),
(12256, 254, 155, 'China Grove', 10000, 1),
(12258, 254, 151, 'Milford', 10000, 1),
(12259, 175, 2977, 'Apeldoorn', 10000, 1),
(12260, 254, 159, 'Bandon', 10000, 1),
(12261, 254, 146, 'Raymond', 10000, 1),
(12262, 175, 2975, 'Assen', 10000, 1),
(12263, 254, 145, 'Anoka', 10000, 1),
(12264, 254, 127, 'Ignacio', 10000, 1),
(12265, 254, 133, 'Pukalani', 10000, 1),
(12266, 224, 3681, 'Sasolburg', 10000, 1),
(12267, 254, 169, 'Belle', 10000, 1),
(12268, 254, 127, 'Livermore', 10000, 1),
(12269, 10, 1051, 'Chacabuco', 10000, 1),
(12271, 254, 144, 'Potterville', 10000, 1),
(12273, 254, 154, 'Woodside', 10000, 1),
(12274, 254, 135, 'Amboy', 10000, 1),
(12275, 14, 1, 'Preston', 10000, 1),
(12276, 254, 157, 'Cardington', 10000, 1),
(12277, 149, 2907, 'Klang', 10000, 1),
(12278, 254, 123, 'Wasilla', 10000, 1),
(12279, 254, 170, 'Lancaster', 10000, 1),
(12280, 175, 2981, 'Leidschendam', 10000, 1),
(12281, 253, 5391, 'Ballymena', 10000, 1),
(12282, 224, 3684, 'Midrand', 10000, 1),
(12283, 36, 1248, 'Kuala Belait', 10000, 1),
(12286, 234, 4025, 'Brugg', 10000, 1),
(12287, 119, 2246, 'Brescia', 10000, 1),
(12288, 254, 135, 'Highland', 10000, 1),
(12289, 43, 37, 'Perth', 10000, 1),
(12290, 254, 166, 'Pleasant Grove', 10000, 1),
(12291, 64, 5134, 'Zlin', 10000, 1),
(12292, 14, 3, 'Caloundra', 10000, 1),
(12293, 254, 135, 'Wyanet', 10000, 1),
(12294, 254, 135, 'Monee', 10000, 1),
(12295, 118, 2232, 'Hevron', 10000, 1),
(12296, 65, 1498, 'Nordb', 10000, 1),
(12297, 233, 4000, 'Norrk', 10000, 1),
(12298, 254, 157, 'New Philadelphia', 10000, 1),
(12300, 175, 2979, 'Venlo', 10000, 1),
(12301, 81, 5023, 'toijala', 10000, 1),
(12303, 24, 1134, 'Marche-En-Famenne', 10000, 1),
(12304, 254, 148, 'Laurel', 10000, 1),
(12307, 254, 146, 'Houlka', 10000, 1),
(12308, 254, 154, 'Hollis Hills', 10000, 1),
(12309, 254, 160, 'Elizabethtown', 10000, 1),
(12310, 14, 1, 'Geelong', 10000, 1),
(12311, 254, 152, 'Butler', 10000, 1),
(12312, 239, 4076, 'Phetchabun', 10000, 1),
(12313, 43, 37, 'Chatham', 10000, 1),
(12314, 254, 144, 'White Pigeon', 10000, 1),
(12315, 253, 5392, 'Milton Keynes', 10000, 1),
(12316, 159, 2887, 'Pi edras Negras', 10000, 1),
(12317, 43, 35, 'Gatineau', 10000, 1),
(12318, 43, 35, 'Aylmer', 10000, 1),
(12319, 119, 2257, 'Verona', 10000, 1),
(12320, 233, 4004, 'Torsby', 10000, 1),
(12321, 254, 152, 'Oak Ridge', 10000, 1),
(12323, 14, 3, 'Nambour', 10000, 1),
(12324, 254, 170, 'Palmyra', 10000, 1),
(12325, 185, 3002, 'Egersund', 10000, 1),
(12326, 254, 160, 'Clarks Summit', 10000, 1),
(12327, 159, 2896, 'M', 10000, 1),
(12328, 254, 140, 'Saint Bernard', 10000, 1),
(12329, 15, 1082, 'Hohenems', 10000, 1),
(12332, 254, 142, 'Frostburg', 10000, 1),
(12333, 254, 160, 'Nazareth', 10000, 1),
(12334, 254, 152, 'Pompton Lakes', 10000, 1),
(12335, 14, 1, 'Cobram', 10000, 1),
(12339, 254, 160, 'New Kensington', 10000, 1),
(12340, 254, 126, 'North Hollywood', 10000, 1),
(12341, 254, 160, 'Phoenixville', 10000, 1),
(12343, 254, 158, 'Afton', 10000, 1),
(12344, 254, 152, 'Egg Harbor City', 10000, 1),
(12345, 254, 172, 'Colchester', 10000, 1),
(12346, 254, 128, 'Colchester', 10000, 1),
(12347, 254, 131, 'Panama City Beach', 10000, 1),
(12349, 254, 152, 'Lavallette', 10000, 1),
(12350, 43, 37, 'Courtice', 10000, 1),
(12351, 254, 122, 'Boaz', 10000, 1),
(12352, 254, 132, 'Bonaire', 10000, 1),
(12353, 254, 132, 'Kathleen', 10000, 1),
(12354, 254, 135, 'Glencoe', 10000, 1),
(12355, 149, 2903, 'Ipoh', 10000, 1),
(12357, 43, 37, 'Valley East', 10000, 1),
(12358, 254, 154, 'Cedarhurst', 10000, 1),
(12359, 254, 125, 'Bella Vista', 10000, 1),
(12360, 254, 141, 'Lincoln', 10000, 1),
(12361, 33, 29, 'Petr', 10000, 1),
(12362, 254, 167, 'Rockbridge Baths', 10000, 1),
(12363, 33, 15, 'Uni', 10000, 1),
(12365, 254, 169, 'Beaver', 10000, 1),
(12366, 254, 159, 'Molalla', 10000, 1),
(12367, 91, 1913, 'Allersberg', 10000, 1),
(12368, 119, 2252, 'Augusta', 10000, 1),
(12369, 254, 126, 'Castroville', 10000, 1),
(12370, 43, 43, 'North Vancouver', 10000, 1),
(12373, 234, 4040, 'Schaffhausen', 10000, 1),
(12374, 253, 5392, 'Eastrea', 10000, 1),
(12375, 43, 43, 'Fort Nelson', 10000, 1),
(12376, 91, 1918, 'Ahaus', 10000, 1),
(12377, 254, 146, 'Olive Branch', 10000, 1),
(12378, 233, 4000, 'Orminge', 10000, 1),
(12379, 254, 147, 'Fair Grove', 10000, 1),
(12381, 195, 3450, 'Muntinlupa', 10000, 1),
(12382, 119, 2253, 'Pistoia', 10000, 1),
(12383, 65, 1500, 'Kolding', 10000, 1),
(12384, 185, 3007, 'Kristiansand', 10000, 1),
(12385, 43, 37, 'North York', 10000, 1),
(12388, 149, 2898, 'Kulim', 10000, 1),
(12389, 149, 2905, 'Bayan Lepas', 10000, 1),
(12390, 198, 3313, 'Maia', 10000, 1),
(12391, 254, 167, 'Vienna', 10000, 1),
(12392, 43, 35, 'Saint-Casimir', 10000, 1),
(12393, 254, 141, 'Guilford', 10000, 1),
(12397, 254, 144, 'Tecumseh', 10000, 1),
(12398, 254, 165, 'Smithville', 10000, 1),
(12399, 15, 1082, 'Bregenz', 10000, 1),
(12400, 14, 4, 'Burwood', 10000, 1),
(12401, 185, 2998, 'Namsos', 10000, 1),
(12402, 253, 5392, 'Basingstoke', 10000, 1),
(12403, 119, 2246, 'Mantova', 10000, 1),
(12406, 224, 3684, 'Sandton', 10000, 1),
(12407, 233, 3986, 'Karlskrona', 10000, 1),
(12408, 82, 1814, 'Neuf-Brisach', 10000, 1),
(12410, 254, 157, 'South Lebanon', 10000, 1),
(12411, 233, 4007, 'V', 10000, 1),
(12412, 254, 125, 'White Hall', 10000, 1),
(12413, 254, 131, 'Gulf Breeze', 10000, 1),
(12415, 254, 157, 'Pataskala', 10000, 1),
(12416, 253, 5392, 'Maidenhead', 10000, 1),
(12417, 254, 159, 'Cornelius', 10000, 1),
(12418, 254, 135, 'Johnston City', 10000, 1),
(12419, 21, 1104, 'Bridgetown', 10000, 1),
(12420, 253, 5392, 'Hornchurch', 10000, 1),
(12421, 254, 170, 'Two Rivers', 10000, 1),
(12422, 254, 131, 'Tarpon Springs', 10000, 1),
(12423, 91, 1916, 'Bad Orb', 10000, 1),
(12425, 254, 160, 'Shrewsbury', 10000, 1),
(12426, 254, 165, 'Happy', 10000, 1),
(12428, 254, 124, 'Benson', 10000, 1),
(12429, 254, 126, 'San Pedro', 10000, 1),
(12431, 254, 167, 'Hallieford', 10000, 1),
(12434, 254, 126, 'Granada Hills', 10000, 1),
(12435, 254, 127, 'Meeker', 10000, 1),
(12436, 254, 124, 'Ash Fork', 10000, 1),
(12437, 254, 145, 'Wyoming', 10000, 1),
(12438, 43, 43, 'Armstrong', 10000, 1),
(12439, 185, 2997, 'Narvik', 10000, 1),
(12445, 253, 5389, 'Bangor', 10000, 1),
(12446, 59, 1434, 'Playas del Coco', 10000, 1),
(12447, 81, 4879, 'Imatra', 10000, 1),
(12448, 254, 126, 'Calabasas', 10000, 1),
(12449, 233, 4006, 'H', 10000, 1),
(12450, 254, 131, 'Williston', 10000, 1),
(12451, 254, 131, 'Jensen Beach', 10000, 1),
(12452, 43, 43, 'Sidney', 10000, 1),
(12453, 111, 2067, 'Kecskemet', 10000, 1),
(12455, 233, 3991, '', 10000, 1),
(12458, 254, 124, 'Clarkdale', 10000, 1),
(12460, 254, 168, 'Camano Island', 10000, 1),
(12461, 175, 2980, 'Gemert', 10000, 1),
(12462, 254, 166, 'Kaysville', 10000, 1),
(12463, 81, 4879, 'Kouvola', 10000, 1),
(12464, 254, 126, 'Guerneville', 10000, 1),
(12466, 15, 1077, 'Baden', 10000, 1),
(12467, 15, 1076, 'D', 10000, 1),
(12468, 254, 126, 'Grover Beach', 10000, 1),
(12469, 254, 126, 'Rancho Santa Margarita', 10000, 1),
(12470, 75, 1639, 'Kuressaare', 10000, 1),
(12471, 43, 37, 'Fort Frances', 10000, 1),
(12472, 254, 136, 'Moores Hill', 10000, 1),
(12473, 43, 36, 'Stettler', 10000, 1),
(12474, 14, 4, 'Blacktown', 10000, 1),
(12475, 43, 37, 'Kanata', 10000, 1),
(12476, 234, 4047, 'Vevey', 10000, 1),
(12477, 254, 128, 'Cheshire', 10000, 1),
(12479, 254, 154, 'Wappingers Falls', 10000, 1),
(12480, 253, 5392, 'Bournemouth', 10000, 1),
(12481, 254, 170, 'Oconomowoc', 10000, 1),
(12482, 234, 4049, 'Kloten', 10000, 1),
(12483, 254, 165, 'Portland', 10000, 1),
(12485, 254, 154, 'Nassau', 10000, 1),
(12486, 254, 157, 'Oxford', 10000, 1),
(12487, 254, 145, 'North Branch', 10000, 1),
(12488, 254, 154, 'Ballston Lake', 10000, 1),
(12489, 43, 36, 'Legal', 10000, 1),
(12490, 178, 3089, 'Hastings', 10000, 1),
(12491, 254, 126, 'Corning', 10000, 1),
(12492, 254, 135, 'Vernon Hills', 10000, 1),
(12493, 65, 1500, 'Vejle', 10000, 1),
(12497, 254, 126, 'Foresthill', 10000, 1),
(12498, 99, 636, 'Dededo', 10000, 1),
(12499, 65, 1489, 'Skanderborg', 10000, 1),
(12501, 253, 5392, 'Eastbourne', 10000, 1),
(12502, 254, 170, 'De Pere', 10000, 1),
(12503, 254, 122, 'Eclectic', 10000, 1),
(12504, 254, 147, 'Union', 10000, 1),
(12505, 254, 154, 'Highland Mills', 10000, 1),
(12506, 33, 32, 'Tr', 10000, 1),
(12507, 254, 160, 'Hawley', 10000, 1),
(12508, 254, 144, 'Manchester', 10000, 1),
(12509, 254, 128, 'Watertown', 10000, 1),
(12510, 198, 3311, 'Torres Vedras', 10000, 1),
(12511, 185, 2998, 'Stjordal', 10000, 1),
(12513, 254, 167, 'Colonial Beach', 10000, 1),
(12514, 254, 168, 'Bainbridge Island', 10000, 1),
(12515, 207, 3944, 'Castries', 10000, 1),
(12516, 254, 135, 'Pawnee', 10000, 1),
(12517, 254, 162, 'Ridgeville', 10000, 1),
(12518, 43, 37, 'Stoney Creek', 10000, 1),
(12519, 254, 141, 'Rockland', 10000, 1),
(12520, 254, 157, 'Kingston', 10000, 1),
(12521, 254, 124, 'Yarnell', 10000, 1),
(12522, 175, 2977, 'Arnhem', 10000, 1),
(12523, 119, 2249, 'Moncalieri', 10000, 1),
(12524, 253, 5392, 'Wimborne Minster', 10000, 1),
(12525, 91, 1912, 'Ludwigsburg', 10000, 1),
(12526, 253, 5392, 'Bolton', 10000, 1),
(12528, 253, 5392, 'Wellington', 10000, 1),
(12529, 253, 5389, 'Haverfordwest', 10000, 1),
(12530, 253, 5392, 'Welwyn Garden City', 10000, 1),
(12531, 175, 2984, 'Middelburg', 10000, 1),
(12532, 234, 4029, 'Burgdorf', 10000, 1),
(12533, 178, 3129, 'New Plymouth', 10000, 1),
(12534, 14, 3, 'Redcliffe', 10000, 1),
(12535, 24, 5305, 'Grez-Doiceau', 10000, 1),
(12536, 254, 170, 'Delavan', 10000, 1),
(12539, 254, 135, 'Streator', 10000, 1),
(12540, 149, 2898, 'Alor Setar', 10000, 1),
(12542, 233, 4002, 'Katrineholm', 10000, 1),
(12543, 254, 135, 'Knoxville', 10000, 1),
(12544, 254, 160, 'Titusville', 10000, 1),
(12546, 254, 167, 'Yorktown', 10000, 1),
(12547, 33, 27, 'Juiz de For a', 10000, 1),
(12548, 254, 135, 'Flanagan', 10000, 1),
(12549, 185, 2997, 'Bodo', 10000, 1),
(12550, 233, 3986, 'S', 10000, 1),
(12551, 253, 5392, 'Winchester', 10000, 1),
(12553, 43, 37, 'Kapuskasing', 10000, 1),
(12554, 113, 2190, 'Udaipur', 10000, 1),
(12555, 175, 2980, 'Bergen op Zoom', 10000, 1),
(12556, 185, 2998, 'Steinkjer', 10000, 1),
(12557, 91, 1913, 'Zangberg', 10000, 1),
(12558, 91, 1913, 'Burgbernheim', 10000, 1),
(12559, 254, 143, 'Swampscott', 10000, 1),
(12560, 65, 1503, 'Frederiksberg', 10000, 1),
(12562, 253, 5392, 'Gloucester', 10000, 1),
(12564, 254, 125, 'Osceola', 10000, 1),
(12565, 175, 2980, 'Oss', 10000, 1),
(12569, 254, 170, 'Hudson', 10000, 1),
(12570, 254, 142, 'Linthicum Heights', 10000, 1),
(12571, 254, 168, 'Enumclaw', 10000, 1),
(12572, 14, 4, 'Armidale', 10000, 1),
(12573, 254, 168, 'Freeland', 10000, 1),
(12574, 114, 2148, 'Purwokerto', 10000, 1),
(12575, 43, 37, 'Cambridge', 10000, 1),
(12576, 254, 146, 'Kiln', 10000, 1),
(12577, 254, 160, 'Saegertown', 10000, 1),
(12578, 254, 164, 'Kingston', 10000, 1),
(12579, 254, 142, 'Snow Hill', 10000, 1),
(12580, 203, 3562, 'Khabarovsk', 10000, 1),
(12581, 254, 157, 'Fredericktown', 10000, 1),
(12583, 254, 126, 'Pomona', 10000, 1),
(12584, 254, 172, 'Barre', 10000, 1),
(12585, 254, 152, 'Clark', 10000, 1),
(12586, 254, 160, 'Wilkes Barre', 10000, 1),
(12587, 254, 147, 'Herculaneum', 10000, 1),
(12588, 254, 126, 'Fairfax', 10000, 1),
(12589, 168, 2810, 'Tafraout', 10000, 1),
(12590, 157, 2828, 'Port Louis', 10000, 1),
(12591, 233, 4010, 'G', 10000, 1),
(12592, 14, 4, 'Oberon', 10000, 1),
(12593, 254, 127, 'Golden', 10000, 1),
(12597, 254, 163, 'Hudson', 10000, 1),
(12598, 65, 1499, 'Naestved', 10000, 1),
(12599, 254, 126, 'Pauma Valley', 10000, 1),
(12600, 254, 165, 'Mexia', 10000, 1),
(12602, 14, 4, 'Pyrmont', 10000, 1),
(12603, 254, 133, 'Haleiwa', 10000, 1),
(12604, 5, 1023, 'Andorra La Vella', 10000, 1),
(12605, 5, 5052, 'Escaldes', 10000, 1),
(12606, 254, 152, 'Flemington', 10000, 1),
(12607, 233, 4010, 'Ulricehamn', 10000, 1),
(12608, 254, 139, 'Corydon', 10000, 1),
(12609, 14, 1, 'Warrnambool', 10000, 1),
(12610, 14, 4, 'Bathurst', 10000, 1),
(12611, 254, 152, 'Brick', 10000, 1),
(12612, 233, 3987, 'Ljusdal', 10000, 1),
(12613, 122, 2337, 'Meguro', 10000, 1),
(12614, 175, 2982, 'Zwolle', 10000, 1),
(12615, 175, 2980, 'Waalwijk', 10000, 1),
(12616, 233, 4010, 'Ljungskile', 10000, 1),
(12617, 185, 3002, 'Haugesund', 10000, 1),
(12618, 119, 2256, 'Aosta', 10000, 1),
(12620, 24, 1132, 'Verviers', 10000, 1),
(12621, 185, 3005, 'Porsgrunn', 10000, 1),
(12622, 81, 5023, 'Jyv', 10000, 1),
(12623, 195, 3505, 'Pasig', 10000, 1),
(12624, 233, 3999, 'Lindesberg', 10000, 1),
(12625, 24, 5051, 'Leuven', 10000, 1),
(12626, 253, 5392, 'Gravesend', 10000, 1),
(12629, 91, 1913, 'Parsberg', 10000, 1),
(12630, 233, 3992, 'Vetlanda', 10000, 1),
(12631, 175, 2981, 'Haarlem', 10000, 1),
(12632, 252, 5005, 'Sharjah ', 10000, 1),
(12633, 119, 2253, 'Prato', 10000, 1),
(12634, 14, 4, 'Port Macquarie', 10000, 1),
(12635, 119, 2252, 'Catania', 10000, 1),
(12636, 43, 37, 'Pickering', 10000, 1),
(12637, 175, 2983, 'Amersfoort', 10000, 1),
(12638, 254, 147, 'Osage Beach', 10000, 1),
(12639, 233, 3987, 'S', 10000, 1),
(12641, 119, 2242, 'Parma', 10000, 1),
(12642, 99, 636, 'Tamuning', 10000, 1),
(12644, 254, 152, 'Marlton', 10000, 1),
(12645, 254, 144, 'Mackinaw City', 10000, 1),
(12647, 61, 5039, 'Supetar', 10000, 1),
(12648, 224, 3683, 'Port Elizabeth', 10000, 1),
(12649, 254, 143, 'North Adams', 10000, 1),
(12650, 254, 154, 'Brewster', 10000, 1),
(12651, 175, 2979, 'Helden', 10000, 1),
(12652, 254, 154, 'Cambria Heights', 10000, 1),
(12653, 234, 4030, 'Fribourg', 10000, 1),
(12655, 43, 35, 'Ormstown', 10000, 1),
(12656, 43, 37, 'Nepean', 10000, 1),
(12657, 254, 139, 'Bandana', 10000, 1),
(12659, 254, 143, 'Northfield', 10000, 1),
(12660, 254, 160, 'Girard', 10000, 1),
(12661, 254, 126, 'Corte Madera', 10000, 1),
(12662, 226, 3935, 'Matar', 10000, 1),
(12663, 254, 140, 'Sterlington', 10000, 1),
(12666, 254, 148, 'Whitefish', 10000, 1),
(12667, 254, 165, 'Mansfield', 10000, 1),
(12668, 254, 135, 'Gridley', 10000, 1),
(12669, 254, 126, 'Antelope', 10000, 1),
(12670, 254, 136, 'Preble', 10000, 1),
(12671, 254, 168, 'Issaquah', 10000, 1),
(12672, 254, 152, 'Liberty Corner', 10000, 1),
(12674, 185, 2992, 'Drammen', 10000, 1),
(12677, 199, 736, 'Bayamon', 10000, 1),
(12678, 254, 131, 'North Palm Beach', 10000, 1),
(12679, 233, 4008, 'S', 10000, 1),
(12680, 254, 126, 'Reseda', 10000, 1),
(12681, 254, 124, 'Dragoon', 10000, 1),
(12682, 254, 142, 'Finksburg', 10000, 1),
(12683, 254, 168, 'Duvall', 10000, 1),
(12684, 185, 3008, 'Horten', 10000, 1),
(12685, 265, 802, 'Hawthorne', 10000, 1),
(12687, 254, 152, 'Hawthorne', 10000, 1),
(12688, 254, 145, 'Springfield', 10000, 1),
(12690, 233, 3998, 'Pite', 10000, 1),
(12692, 254, 168, 'Prosser', 10000, 1),
(12693, 254, 126, 'Chino Hills', 10000, 1),
(12694, 233, 4009, 'Trelleborg', 10000, 1),
(12695, 198, 3312, 'Elvas', 10000, 1),
(12696, 254, 158, 'Glenpool', 10000, 1),
(12697, 254, 126, 'Cayucos', 10000, 1),
(12698, 65, 1493, 'R', 10000, 1),
(12699, 197, 3275, 'Bydgoszcz', 10000, 1),
(12700, 233, 4010, 'Alings', 10000, 1),
(12701, 234, 4044, 'Lugano', 10000, 1),
(12702, 43, 43, 'Chetwynd', 10000, 1),
(12704, 221, 5398, 'Ravne na Koroskem', 10000, 1),
(12706, 65, 1499, 'N', 10000, 1),
(12707, 149, 2911, 'Tawau', 10000, 1),
(12708, 254, 155, 'Butner', 10000, 1),
(12710, 254, 140, 'Angola', 10000, 1),
(12711, 254, 126, 'Pine Grove', 10000, 1),
(12712, 254, 164, 'Greenbrier', 10000, 1),
(12713, 254, 141, 'Rockwood', 10000, 1),
(12714, 65, 1495, 'Esbjerg', 10000, 1),
(12715, 254, 152, 'Atco', 10000, 1),
(12716, 254, 152, 'Voorhees', 10000, 1),
(12717, 253, 5392, 'Stafford', 10000, 1),
(12718, 119, 2253, 'Livorno', 10000, 1),
(12719, 43, 39, 'Lower Sackville', 10000, 1),
(12720, 254, 144, 'Fennville', 10000, 1),
(12721, 254, 139, 'Prospect', 10000, 1),
(12723, 254, 131, 'New Symrna Beach', 10000, 1),
(12724, 224, 3689, 'Stellenbosch', 10000, 1),
(12725, 254, 135, 'Montgomery', 10000, 1),
(12726, 254, 126, 'Twain Harte', 10000, 1),
(12727, 254, 152, 'Red Bank', 10000, 1),
(12728, 254, 126, 'Fairfield', 10000, 1),
(12729, 254, 158, 'Weatherford', 10000, 1),
(12730, 197, 3280, 'Warsaw', 10000, 1),
(12731, 254, 154, 'Endicott', 10000, 1),
(12732, 254, 135, 'West Chicago', 10000, 1),
(12733, 254, 133, 'Laie', 10000, 1),
(12734, 233, 4010, 'Mariestad', 10000, 1),
(12735, 254, 159, 'Reedsport', 10000, 1),
(12737, 254, 137, 'Elgin', 10000, 1),
(12738, 254, 144, 'Oakland', 10000, 1),
(12739, 254, 168, 'Port Orchard', 10000, 1),
(12740, 254, 145, 'Northfield', 10000, 1),
(12741, 254, 158, 'Newalla', 10000, 1),
(12743, 43, 41, 'Carbonear', 10000, 1),
(12744, 254, 165, 'Hitchcock', 10000, 1),
(12745, 254, 142, 'Rockville', 10000, 1),
(12747, 254, 157, 'Nova', 10000, 1),
(12748, 254, 166, 'Centerville', 10000, 1),
(12749, 254, 126, 'Pacific Grove', 10000, 1),
(12750, 43, 35, 'Saint-R', 10000, 1),
(12751, 254, 131, 'Debary', 10000, 1),
(12752, 253, 5392, 'Grimsby', 10000, 1),
(12753, 254, 157, 'Shelby', 10000, 1),
(12754, 254, 154, 'Nanuet', 10000, 1),
(12755, 254, 158, 'Tonkawa', 10000, 1),
(12756, 254, 164, 'Crockett Mills', 10000, 1),
(12758, 254, 139, 'Harold', 10000, 1),
(12759, 254, 126, 'Crestline', 10000, 1),
(12760, 254, 136, 'Geneva', 10000, 1),
(12761, 254, 157, 'Harrison', 10000, 1),
(12762, 43, 37, 'Gloucester', 10000, 1),
(12763, 254, 160, 'Cresson', 10000, 1),
(12764, 254, 141, 'Warren', 10000, 1),
(12766, 254, 160, 'Fairfield', 10000, 1),
(12767, 254, 157, 'Hilliard', 10000, 1),
(12768, 14, 1, 'Diamond Creek', 10000, 1),
(12770, 254, 158, 'Agra', 10000, 1),
(12771, 254, 160, 'Alum Bank', 10000, 1),
(12772, 226, 3935, 'Barber', 10000, 1),
(12773, 199, 736, 'San Juan', 10000, 1),
(12774, 254, 159, 'Rhododendron', 10000, 1),
(12775, 254, 123, 'Elmendorf Afb', 10000, 1),
(12776, 254, 146, 'Horn Lake', 10000, 1),
(12778, 254, 168, 'Moses Lake', 10000, 1),
(12779, 195, 3448, 'Angeles City', 10000, 1),
(12780, 254, 142, 'Clarksburg', 10000, 1),
(12781, 254, 145, 'Bagley', 10000, 1),
(12782, 239, 4064, 'Chiang Mai', 10000, 1),
(12783, 254, 172, 'Saint Albans', 10000, 1),
(12784, 254, 154, 'Huntington', 10000, 1),
(12785, 43, 36, 'Spruce Grove', 10000, 1),
(12786, 43, 39, 'Dartmouth', 10000, 1),
(12787, 219, 756, 'Tampines', 10000, 1),
(12788, 254, 162, 'Greer', 10000, 1),
(12789, 254, 144, 'Flushing', 10000, 1),
(12790, 254, 157, 'North Olmsted', 10000, 1),
(12791, 254, 151, 'Wolfeboro', 10000, 1),
(12792, 195, 3441, 'Cagayan De Oro', 10000, 1),
(12793, 254, 128, 'Wilton', 10000, 1),
(12794, 254, 126, 'Aliso Viejo', 10000, 1),
(12795, 33, 32, 'Passo Fundo', 10000, 1),
(12796, 254, 125, 'Sulphur Springs', 10000, 1),
(12797, 254, 166, 'Lindon', 10000, 1),
(12798, 43, 37, 'Listowel', 10000, 1),
(12799, 254, 135, 'Fairview Heights', 10000, 1),
(12800, 254, 154, 'Scarsdale', 10000, 1),
(12802, 43, 37, 'Parkhill', 10000, 1),
(12803, 254, 166, 'Saint George', 10000, 1),
(12804, 254, 122, 'Daphne', 10000, 1),
(12805, 254, 157, 'Delta', 10000, 1),
(12806, 254, 124, 'Mayer', 10000, 1),
(12808, 254, 159, 'Junction City', 10000, 1),
(12809, 64, 5130, 'Pardubice', 10000, 1),
(12810, 24, 1131, 'Braine-Le-Comte', 10000, 1),
(12811, 254, 126, 'Harbor City', 10000, 1),
(12812, 254, 158, 'Blanchard', 10000, 1),
(12813, 254, 144, 'Paris', 10000, 1),
(12814, 43, 43, 'Delta', 10000, 1),
(12815, 175, 2983, 'Bilthoven', 10000, 1),
(12816, 65, 1494, 'Frederikshavn', 10000, 1),
(12817, 65, 1491, 'Gilleleje', 10000, 1),
(12818, 114, 2166, 'Padang', 10000, 1),
(12819, 254, 139, 'South Shore', 10000, 1),
(12820, 24, 1131, 'Mons', 10000, 1),
(12821, 185, 2997, 'Mo i Rana', 10000, 1),
(12822, 65, 1491, 'H', 10000, 1),
(12823, 233, 3996, 'Ljungby', 10000, 1),
(12824, 82, 1803, 'Gennevilliers', 10000, 1),
(12825, 82, 1810, 'Pr', 10000, 1),
(12826, 14, 6, 'Armadale', 10000, 1),
(12827, 91, 1912, 'Karlsruhe', 10000, 1),
(12828, 195, 3449, 'Dagupan City', 10000, 1),
(12829, 253, 5392, 'Fleet', 10000, 1),
(12831, 91, 1917, 'Oldenburg', 10000, 1),
(12832, 82, 1803, 'Versailles', 10000, 1),
(12833, 152, 689, 'Siggiewi', 10000, 1),
(12834, 185, 3002, 'Sandnes', 10000, 1),
(12835, 199, 736, 'Aguadilla', 10000, 1),
(12836, 253, 5390, 'Lerwick', 10000, 1),
(12837, 91, 1913, 'Bamberg', 10000, 1),
(12838, 253, 5389, 'Aberystwyth', 10000, 1),
(12839, 226, 3935, 'El Prat De Llobregat', 10000, 1),
(12840, 175, 2983, 'Maarssen', 10000, 1),
(12841, 82, 1810, 'Amiens', 10000, 1),
(12842, 254, 155, 'Hudson', 10000, 1),
(12843, 185, 2990, 'Son', 10000, 1),
(12844, 82, 1796, 'Beaune', 10000, 1),
(12845, 254, 131, 'Santa Rosa Beach', 10000, 1),
(12846, 254, 154, 'Shoreham', 10000, 1),
(12847, 254, 126, 'North Fork', 10000, 1),
(12848, 254, 143, 'Westminster', 10000, 1),
(12849, 254, 168, 'Fall City', 10000, 1),
(12851, 199, 736, 'Caguas', 10000, 1),
(12852, 198, 3319, 'Madalena', 10000, 1),
(12853, 253, 5392, 'Swindon', 10000, 1),
(12855, 14, 5, 'Reynella', 10000, 1),
(12856, 119, 2246, 'Vigevano', 10000, 1),
(12857, 43, 40, 'Prince Albert', 10000, 1),
(12858, 254, 165, 'Buda', 10000, 1),
(12859, 254, 143, 'Groton', 10000, 1),
(12860, 254, 131, 'Edgewater', 10000, 1),
(12861, 91, 1917, 'Hameln', 10000, 1),
(12862, 254, 160, 'Conshohocken', 10000, 1),
(12863, 24, 5306, 'Grimbergen', 10000, 1),
(12864, 91, 1918, 'Duisburg', 10000, 1),
(12865, 91, 1913, 'Oberbergkirchen', 10000, 1),
(12867, 15, 1081, 'Zirl', 10000, 1),
(12868, 254, 155, 'Murfreesboro', 10000, 1),
(12872, 243, 4058, 'Saint Augustine', 10000, 1),
(12874, 118, 2233, 'Ness Ziona', 10000, 1),
(12875, 254, 164, 'Antioch', 10000, 1),
(12876, 14, 1, 'Prahran', 10000, 1),
(12877, 254, 144, 'Saint Joseph', 10000, 1),
(12878, 254, 168, 'Aberdeen', 10000, 1),
(12879, 254, 152, 'Shrewsbury', 10000, 1),
(12880, 254, 154, 'Jefferson Valley', 10000, 1),
(12881, 256, 4503, 'San Jos', 10000, 1),
(12882, 254, 145, 'Rushmore', 10000, 1),
(12883, 253, 5392, 'Ely', 10000, 1),
(12884, 14, 3, 'Ipswich', 10000, 1),
(12886, 254, 131, 'Rockledge', 10000, 1),
(12887, 254, 157, 'Archbold', 10000, 1),
(12888, 149, 2907, 'Selayang Jaya', 10000, 1),
(12889, 254, 168, 'Silverdale', 10000, 1),
(12890, 254, 152, 'Holmdel', 10000, 1),
(12891, 254, 142, 'Hyattsville', 10000, 1),
(12892, 254, 154, 'Saugerties', 10000, 1),
(12893, 243, 4055, 'Port of Spain', 10000, 1),
(12894, 254, 147, 'Hazelwood', 10000, 1),
(12895, 254, 129, 'Dover', 10000, 1),
(12896, 254, 152, 'Metuchen', 10000, 1),
(12897, 149, 2901, 'Kuala Pilah', 10000, 1),
(12898, 14, 5, 'Brighton', 10000, 1),
(12900, 149, 2901, 'Seremban', 10000, 1),
(12901, 97, 5361, 'Hillsborough', 10000, 1),
(12902, 91, 1917, 'Clausthal-Zellerfeld', 10000, 1),
(12904, 254, 154, 'Rego Park', 10000, 1),
(12905, 254, 152, 'Bridgewater', 10000, 1),
(12907, 199, 736, 'Guaynabo', 10000, 1),
(12908, 109, 646, 'Kwun Tong', 10000, 1),
(12910, 254, 158, 'Calera', 10000, 1),
(12911, 254, 134, 'Rathdrum', 10000, 1),
(12912, 91, 1912, 'Waiblingen', 10000, 1),
(12913, 254, 152, 'Highland Park', 10000, 1),
(12914, 254, 128, 'Avon', 10000, 1),
(12915, 91, 1918, 'Minden', 10000, 1),
(12916, 254, 154, 'Oxford', 10000, 1),
(12917, 114, 2166, 'Medan', 10000, 1),
(12918, 109, 646, 'Kowloon', 10000, 1),
(12919, 149, 2906, 'Kuching', 10000, 1),
(12920, 254, 137, 'Oelwein', 10000, 1),
(12921, 254, 137, 'Kalona', 10000, 1),
(12923, 199, 736, 'Mayag', 10000, 1),
(12924, 254, 126, 'Los Alamitos', 10000, 1),
(12925, 254, 168, 'Toledo', 10000, 1),
(12926, 254, 154, 'Greenvale', 10000, 1),
(12927, 254, 154, 'Williston Park', 10000, 1),
(12928, 175, 2981, 'Zaandam', 10000, 1),
(12929, 119, 2245, 'Bordighera', 10000, 1),
(12931, 254, 152, 'Waldwick', 10000, 1),
(12932, 254, 154, 'Armonk', 10000, 1),
(12933, 254, 131, 'Shalimar', 10000, 1),
(12934, 65, 1501, 'Struer', 10000, 1),
(12935, 254, 169, 'Danville', 10000, 1),
(12937, 33, 24, 'S', 10000, 1),
(12938, 24, 1137, 'Izegem', 10000, 1),
(12939, 254, 154, 'Jamaica', 10000, 1),
(12940, 254, 126, 'Del Rey', 10000, 1),
(12941, 233, 4008, 'Norrt', 10000, 1),
(12942, 185, 3008, 'Larvik', 10000, 1),
(12943, 91, 1918, 'Bielefeld', 10000, 1),
(12944, 82, 1795, 'Granville', 10000, 1),
(12945, 175, 2980, 'Helmond', 10000, 1),
(12946, 118, 2236, 'Holon', 10000, 1),
(12947, 64, 5124, 'Jihlava', 10000, 1),
(12948, 253, 5389, 'Betws-y-Coed', 10000, 1),
(12950, 254, 154, 'North Babylon', 10000, 1),
(12951, 226, 3930, 'Aroche', 10000, 1),
(12952, 254, 154, 'Homer', 10000, 1),
(12953, 80, 1784, 'Suva', 10000, 1),
(12954, 254, 154, 'Old Westbury', 10000, 1),
(12955, 254, 135, 'Christopher', 10000, 1),
(12956, 15, 1081, 'W', 10000, 1),
(12957, 254, 152, 'Bordentown', 10000, 1),
(12958, 233, 4009, 'B', 10000, 1),
(12960, 220, 2588, 'Banska Bystrica', 10000, 1),
(12961, 254, 154, 'Potsdam', 10000, 1),
(12962, 65, 1489, '', 10000, 1),
(12963, 254, 132, 'Centerville', 10000, 1),
(12964, 65, 1490, 'Roenne', 10000, 1),
(12965, 254, 124, 'Litchfield Park', 10000, 1),
(12966, 254, 137, 'New London', 10000, 1),
(12967, 254, 169, 'Saint Albans', 10000, 1),
(12969, 254, 153, 'San Juan Pueblo', 10000, 1),
(12970, 43, 37, 'Thornhill', 10000, 1),
(12971, 254, 165, 'Stamford', 10000, 1),
(12972, 254, 168, 'Clarkston', 10000, 1),
(12973, 254, 152, 'Bellmawr', 10000, 1),
(12974, 254, 149, 'Culbertson', 10000, 1),
(12975, 14, 3, 'Toowoomba', 10000, 1),
(12976, 8, 4761, 'Molodesjnaja', 10000, 1),
(12977, 233, 3990, 'Skummesl', 10000, 1),
(12978, 254, 154, 'Hawthorne', 10000, 1),
(12981, 152, 689, 'Zebbug', 10000, 1),
(12982, 253, 5392, 'Woking', 10000, 1),
(12983, 14, 1, 'Ballarat', 10000, 1),
(12984, 254, 159, 'Westlake', 10000, 1),
(12985, 253, 5392, 'Aylesbury', 10000, 1),
(12986, 254, 131, 'Palm City', 10000, 1),
(12987, 43, 36, 'Fox Creek', 10000, 1),
(12988, 91, 1918, 'Remscheid', 10000, 1),
(12989, 254, 157, 'Galion', 10000, 1),
(12990, 254, 152, 'Boonton', 10000, 1),
(12991, 254, 135, 'Gurnee', 10000, 1),
(12992, 254, 164, 'Millington', 10000, 1),
(12993, 254, 125, 'West Fork', 10000, 1),
(12994, 254, 143, 'North Attleboro', 10000, 1),
(12995, 254, 157, 'Shadyside', 10000, 1),
(12996, 254, 172, 'Hartland', 10000, 1),
(12997, 254, 154, 'Babylon', 10000, 1),
(13001, 254, 134, 'Meridian', 10000, 1),
(13002, 43, 40, 'Estevan', 10000, 1),
(13003, 254, 157, 'Proctorville', 10000, 1),
(13004, 254, 160, 'Corry', 10000, 1),
(13005, 254, 161, 'North Kingstown', 10000, 1),
(13006, 254, 122, 'Arab', 10000, 1),
(13007, 254, 126, 'San Lorenzo', 10000, 1),
(13009, 149, 2907, 'Shah Alam', 10000, 1),
(13010, 254, 135, 'Barrington', 10000, 1),
(13011, 43, 36, 'Saint Albert', 10000, 1),
(13012, 254, 159, 'Hubbard', 10000, 1),
(13013, 91, 1912, 'Forst', 10000, 1),
(13014, 254, 127, 'Morrison', 10000, 1),
(13015, 119, 2252, 'messina', 10000, 1),
(13016, 254, 132, 'Flowery Branch', 10000, 1),
(13017, 82, 1814, 'Mulhouse', 10000, 1),
(13019, 253, 5392, 'High Wycombe', 10000, 1),
(13020, 254, 160, 'Mount Carmel', 10000, 1),
(13021, 109, 646, 'Fanling', 10000, 1),
(13022, 43, 43, 'Ganges', 10000, 1),
(13023, 119, 2249, 'Verbania', 10000, 1),
(13025, 254, 167, 'Basye', 10000, 1),
(13026, 224, 3684, 'Lenasia', 10000, 1),
(13027, 254, 126, 'El Segundo', 10000, 1),
(13028, 91, 1918, 'Haan', 10000, 1),
(13029, 185, 2991, 'Grimstad', 10000, 1),
(13031, 254, 126, 'Midway City', 10000, 1),
(13032, 254, 167, 'Quinton', 10000, 1),
(13033, 254, 146, 'Petal', 10000, 1),
(13034, 254, 154, 'Lake Placid', 10000, 1),
(13035, 254, 144, 'Glenn', 10000, 1),
(13037, 254, 154, 'Williamson', 10000, 1),
(13038, 254, 170, 'Barron', 10000, 1),
(13039, 109, 646, 'Sheung Shui', 10000, 1),
(13040, 254, 152, 'Lafayette', 10000, 1),
(13042, 226, 3934, 'Valladolid', 10000, 1),
(13043, 254, 154, 'Hauppauge', 10000, 1),
(13044, 254, 139, 'Fort Thomas', 10000, 1),
(13045, 226, 3939, 'Orihuela', 10000, 1),
(13046, 254, 160, 'Roulette', 10000, 1),
(13048, 187, 3219, 'Multan', 10000, 1),
(13049, 187, 3219, 'Muzaffargarh', 10000, 1),
(13050, 43, 43, 'Salt Spring Island', 10000, 1),
(13051, 175, 2979, 'Heerlen', 10000, 1),
(13052, 24, 1137, 'Ostend', 10000, 1),
(13053, 254, 147, 'Slater', 10000, 1),
(13054, 233, 4003, 'Tierp', 10000, 1),
(13055, 254, 142, 'Bel Air', 10000, 1),
(13057, 254, 141, 'Ellsworth', 10000, 1),
(13058, 254, 132, 'Lithia Springs', 10000, 1),
(13059, 43, 37, 'Schomberg', 10000, 1),
(13060, 254, 126, 'Playa del Rey', 10000, 1),
(13062, 253, 5392, 'Bracknell', 10000, 1),
(13063, 65, 1501, 'Ribe', 10000, 1),
(13064, 254, 144, 'Leslie', 10000, 1),
(13065, 254, 125, 'Lakeview', 10000, 1),
(13066, 185, 2998, 'Levanger', 10000, 1),
(13067, 254, 126, 'Marina Del Rey', 10000, 1),
(13068, 185, 2999, 'Domb', 10000, 1),
(13069, 254, 147, 'Carthage', 10000, 1),
(13070, 124, 661, 'St Helier', 10000, 1),
(13071, 24, 1133, 'Genk', 10000, 1),
(13073, 254, 168, 'East Wenatche', 10000, 1),
(13074, 75, 1635, 'Rakvere', 10000, 1),
(13075, 254, 126, 'Venice', 10000, 1),
(13076, 254, 126, 'Pacific Palasaides', 10000, 1),
(13077, 254, 154, 'Tully', 10000, 1),
(13078, 61, 5043, 'Trogir', 10000, 1),
(13079, 254, 126, 'Hermosa Beach', 10000, 1),
(13080, 75, 1635, 'Tapa', 10000, 1),
(13081, 233, 4008, 'Nyn', 10000, 1),
(13082, 171, 4635, 'Windhoek', 10000, 1),
(13083, 142, 2606, 'Vaduz', 10000, 1),
(13084, 233, 4009, '', 10000, 1),
(13085, 254, 154, 'Baldwinsville', 10000, 1),
(13086, 254, 137, 'Larchwood', 10000, 1),
(13087, 185, 2996, 'Kristiansund', 10000, 1),
(13089, 254, 131, 'New Port Richey', 10000, 1),
(13090, 254, 165, 'Krum', 10000, 1),
(13091, 254, 136, 'Bloomfield', 10000, 1),
(13092, 254, 157, 'Gates Mills', 10000, 1),
(13093, 65, 1495, 'Grindsted', 10000, 1),
(13094, 221, 3752, 'Koper', 10000, 1),
(13097, 233, 3998, 'Lule', 10000, 1),
(13098, 254, 154, 'Richmond Hill', 10000, 1),
(13099, 254, 139, 'Hazard', 10000, 1),
(13100, 254, 135, 'Saint Charles', 10000, 1),
(13101, 254, 158, 'Colbert', 10000, 1),
(13102, 112, 2118, '', 10000, 1),
(13104, 254, 165, 'Bowie', 10000, 1),
(13106, 114, 2157, 'Mataram', 10000, 1),
(13107, 43, 37, 'Dunrobin', 10000, 1),
(13108, 239, 4081, 'Udon Thani', 10000, 1),
(13109, 254, 126, 'Agoura Hills', 10000, 1),
(13110, 233, 3990, 'Kungsbacka', 10000, 1),
(13111, 254, 157, 'Hamler', 10000, 1),
(13112, 43, 35, 'Laval', 10000, 1),
(13113, 43, 37, 'Novar', 10000, 1),
(13114, 254, 160, 'Langhorne', 10000, 1),
(13115, 254, 154, 'Hudson', 10000, 1),
(13117, 254, 168, 'Maple Valley', 10000, 1),
(13118, 254, 152, 'Manasquan', 10000, 1),
(13120, 254, 151, 'Windham', 10000, 1),
(13121, 254, 127, 'Sedalia', 10000, 1),
(13123, 254, 168, 'Lake Stevens', 10000, 1),
(13124, 254, 143, 'Brighton', 10000, 1),
(13125, 254, 157, 'Lakeside Marblehead', 10000, 1),
(13126, 254, 126, 'Foothill Ranch', 10000, 1),
(13127, 254, 165, 'Alamo', 10000, 1),
(13128, 239, 4109, 'Rayong', 10000, 1),
(13129, 254, 138, 'Hesston', 10000, 1),
(13130, 233, 4005, 'Nordmaling', 10000, 1),
(13132, 149, 2903, 'Kampar', 10000, 1),
(13133, 65, 1501, 'Ringsted', 10000, 1),
(13134, 14, 4, 'Tweed Heads', 10000, 1),
(13135, 253, 5392, 'Leek', 10000, 1),
(13137, 176, 5047, 'Willemstad', 10000, 1),
(13138, 65, 1501, 'Silkeborg', 10000, 1),
(13139, 234, 4028, 'Basel', 10000, 1),
(13140, 33, 24, 'Limeira', 10000, 1),
(13141, 33, 24, 'Bauru', 10000, 1),
(13142, 233, 4008, 'Gustavsberg', 10000, 1),
(13143, 254, 160, 'Aspers', 10000, 1),
(13144, 254, 131, 'Orange Park', 10000, 1),
(13145, 221, 3782, 'Murska Sobota', 10000, 1),
(13146, 61, 5028, 'Pula', 10000, 1),
(13147, 113, 2191, 'Chennai', 10000, 1),
(13149, 254, 155, 'Garner', 10000, 1),
(13150, 254, 157, 'Maineville', 10000, 1),
(13151, 254, 145, 'Chisholm', 10000, 1),
(13153, 254, 157, 'Salineville', 10000, 1),
(13154, 175, 2985, 'Noordwijk', 10000, 1),
(13155, 254, 159, 'Phoenix', 10000, 1),
(13156, 254, 165, 'Muenster', 10000, 1),
(13157, 18, 1085, 'Awali', 10000, 1),
(13158, 248, 785, 'Balfour Town', 10000, 1),
(13159, 91, 1917, 'Cuxhaven', 10000, 1),
(13160, 91, 1918, 'Moers', 10000, 1),
(13162, 254, 132, 'Tybee Island', 10000, 1),
(13163, 43, 37, 'Newmarket', 10000, 1),
(13165, 185, 2994, 'Moelv', 10000, 1),
(13166, 254, 158, 'Hennessey', 10000, 1),
(13167, 254, 145, 'Forest Lake', 10000, 1),
(13169, 24, 5305, 'Wavre', 10000, 1),
(13172, 119, 2246, 'Sondrio', 10000, 1),
(13173, 91, 1913, 'Waldkirchen', 10000, 1),
(13174, 65, 1498, 'Sonderborg', 10000, 1),
(13175, 65, 1498, 'Augustenborg', 10000, 1),
(13176, 14, 3, 'Noosa', 10000, 1),
(13177, 254, 152, 'Forked River', 10000, 1),
(13178, 253, 5392, 'Slough', 10000, 1),
(13179, 59, 1436, 'Barra Del Colorado', 10000, 1),
(13180, 254, 152, 'West Long Branch', 10000, 1),
(13182, 253, 5392, 'Lancaster', 10000, 1),
(13183, 254, 127, 'Gypsum', 10000, 1),
(13184, 224, 3688, 'Klerksdorp', 10000, 1),
(13185, 233, 3992, 'Hillerstorp', 10000, 1),
(13186, 233, 4010, 'Karlsborg', 10000, 1),
(13187, 24, 5306, 'Overijse', 10000, 1),
(13188, 254, 131, 'Alachua', 10000, 1),
(13189, 254, 159, 'Gladstone', 10000, 1),
(13191, 254, 154, 'Rye', 10000, 1),
(13192, 254, 147, 'Saint Charles', 10000, 1),
(13193, 254, 152, 'Englishtown', 10000, 1),
(13194, 43, 35, 'L', 10000, 1),
(13195, 254, 152, 'Pennsville', 10000, 1),
(13196, 254, 132, 'Stone Mountain', 10000, 1),
(13199, 202, 3369, 'Oravita', 10000, 1),
(13200, 254, 152, 'Frenchtown', 10000, 1),
(13201, 24, 1137, 'Harelbeke', 10000, 1),
(13203, 198, 3307, 'Tavira', 10000, 1),
(13204, 33, 24, 'Tremembe', 10000, 1),
(13205, 254, 143, 'Pembroke', 10000, 1),
(13206, 175, 2989, 'Dronten', 10000, 1),
(13207, 226, 3930, 'Algeciras', 10000, 1),
(13208, 254, 143, 'Boxford', 10000, 1),
(13209, 91, 1918, 'Hagen', 10000, 1),
(13210, 254, 147, 'Tea', 10000, 1),
(13211, 199, 736, 'Fajardo', 10000, 1),
(13213, 224, 3683, 'East london', 10000, 1),
(13214, 43, 35, 'Saint-Lazare', 10000, 1),
(13215, 195, 3412, 'Tuguegarao City', 10000, 1),
(13216, 119, 2242, 'Ravenna', 10000, 1),
(13217, 91, 1923, 'Neustrelitz', 10000, 1),
(13220, 254, 162, 'Ladson', 10000, 1),
(13221, 254, 168, 'Grandview', 10000, 1),
(13223, 254, 137, 'Slater', 10000, 1),
(13225, 233, 3986, 'Pukavik', 10000, 1),
(13226, 254, 154, 'Syosset', 10000, 1),
(13227, 197, 3283, 'Bialystok', 10000, 1),
(13228, 91, 1921, 'Flensburg', 10000, 1),
(13229, 233, 3992, 'Tran', 10000, 1),
(13230, 175, 2985, 'Vlaardingen', 10000, 1),
(13231, 234, 4049, 'Windlach', 10000, 1),
(13232, 254, 165, 'Somerville', 10000, 1),
(13233, 254, 135, 'Geneva', 10000, 1),
(13235, 254, 136, 'Dunkirk', 10000, 1),
(13236, 254, 144, 'Calumet', 10000, 1),
(13237, 65, 1501, 'Haslev', 10000, 1),
(13238, 254, 154, 'Tuxedo Park', 10000, 1),
(13239, 24, 1132, 'Eupen', 10000, 1),
(13241, 254, 136, 'Elwood', 10000, 1),
(13242, 233, 4004, 'Arvika', 10000, 1),
(13243, 254, 143, 'Amesbury', 10000, 1),
(13245, 59, 1438, 'San Francisco De Dos Rios', 10000, 1),
(13246, 254, 134, 'Driggs', 10000, 1),
(13247, 43, 35, 'Boucherville', 10000, 1),
(13249, 119, 2251, 'Selargius', 10000, 1),
(13251, 254, 151, 'Jefferson', 10000, 1),
(13252, 254, 168, 'Westport', 10000, 1),
(13253, 254, 135, 'Lexington', 10000, 1),
(13255, 10, 1051, 'Turdera', 10000, 1),
(13257, 254, 158, 'Disney', 10000, 1),
(13258, 254, 158, 'Eucha', 10000, 1),
(13259, 254, 170, 'Hartford', 10000, 1),
(13261, 53, 1421, 'Ibagu', 10000, 1),
(13262, 254, 144, 'Morenci', 10000, 1),
(13263, 254, 152, 'Lanoka Harbor', 10000, 1),
(13264, 254, 143, 'Sharon', 10000, 1),
(13265, 43, 35, 'Saint-Hippolyte-de-Kilkenny', 10000, 1),
(13266, 254, 126, 'El Granada', 10000, 1),
(13267, 254, 131, 'Boynton Beach', 10000, 1),
(13268, 43, 37, 'Ajax', 10000, 1),
(13269, 254, 159, 'Sixes', 10000, 1),
(13270, 254, 141, 'Van Buren', 10000, 1),
(13271, 254, 154, 'Washingtonville', 10000, 1),
(13272, 254, 135, 'Renault', 10000, 1),
(13273, 43, 37, 'Uxbridge', 10000, 1),
(13274, 254, 135, 'Barber''s Corner', 10000, 1),
(13275, 14, 4, 'Windsor', 10000, 1),
(13277, 149, 2897, 'Kota Tinggi', 10000, 1),
(13278, 254, 124, 'Elgin', 10000, 1),
(13279, 254, 157, 'Bluffton', 10000, 1),
(13280, 254, 152, 'Dumont', 10000, 1),
(13281, 254, 157, 'Bellaire', 10000, 1),
(13282, 254, 140, 'Ponchatoula', 10000, 1),
(13283, 175, 2989, 'Almere', 10000, 1),
(13284, 254, 126, 'Oakdale', 10000, 1),
(13285, 53, 1399, 'Rionegro', 10000, 1),
(13286, 65, 1501, 'Ulstrup', 10000, 1),
(13287, 253, 5392, 'Wolverhampton', 10000, 1),
(13288, 119, 2253, 'viareggio', 10000, 1),
(13289, 253, 5389, 'Beddgelert', 10000, 1),
(13290, 254, 136, 'Winona Lake', 10000, 1),
(13291, 254, 126, 'Manchester', 10000, 1),
(13292, 119, 2249, 'Borgomanero', 10000, 1),
(13294, 234, 4039, 'Rapperswil', 10000, 1),
(13295, 43, 43, 'Qualicum Beach', 10000, 1),
(13296, 253, 5392, 'Huntingdon', 10000, 1),
(13297, 91, 1912, 'Aalen', 10000, 1),
(13298, 254, 145, 'Collegeville', 10000, 1),
(13299, 203, 3577, 'Troitsk', 10000, 1),
(13301, 175, 2985, 'Lisse', 10000, 1),
(13303, 24, 1131, 'Hennuyeres', 10000, 1),
(13304, 117, 1619, 'Mullingar', 10000, 1),
(13305, 233, 4008, 'Sundbyberg', 10000, 1),
(13306, 91, 1918, 'Viersen', 10000, 1),
(13307, 119, 2245, 'Rapallo', 10000, 1),
(13308, 253, 5392, 'Whitehaven', 10000, 1),
(13309, 254, 133, 'Waimea', 10000, 1),
(13310, 254, 144, 'Milford', 10000, 1),
(13311, 91, 1913, 'Schongau', 10000, 1),
(13312, 239, 4100, 'Non Buri ', 10000, 1),
(13314, 43, 37, 'Saint Marys', 10000, 1),
(13315, 43, 39, 'Portuguese Cove', 10000, 1),
(13316, 33, 24, 'S', 10000, 1),
(13317, 15, 1077, 'Korneuburg', 10000, 1),
(13319, 254, 152, 'Burlington', 10000, 1),
(13320, 254, 154, 'Catskill', 10000, 1),
(13321, 254, 143, 'North Andover', 10000, 1),
(13322, 149, 2907, 'Kajang', 10000, 1),
(13323, 185, 3003, 'F', 10000, 1),
(13324, 81, 5023, 'Valkeakoski', 10000, 1),
(13325, 43, 35, 'Bellefeuille', 10000, 1),
(13326, 33, 24, 'Diadema', 10000, 1),
(13327, 91, 1912, 'Villingen-Schwenningen', 10000, 1),
(13328, 91, 1918, 'Havixbeck', 10000, 1),
(13330, 254, 126, 'Lake Tahoe', 10000, 1),
(13331, 185, 2990, 'Jessheim', 10000, 1),
(13332, 185, 3008, 'T', 10000, 1),
(13333, 254, 144, 'Clarkston', 10000, 1),
(13334, 24, 1129, 'Turnhout', 10000, 1),
(13335, 254, 142, 'Brunswick', 10000, 1),
(13336, 233, 4003, 'Grillby', 10000, 1),
(13337, 61, 5034, 'Osijek', 10000, 1),
(13338, 254, 170, 'Sister Bay', 10000, 1),
(13339, 159, 2895, 'Tuxpan', 10000, 1),
(13340, 254, 159, 'Tualatin', 10000, 1),
(13342, 254, 144, 'Hancock', 10000, 1),
(13343, 254, 144, 'Croswell', 10000, 1),
(13344, 226, 3932, 'Puerto de la Cruz', 10000, 1),
(13345, 254, 135, 'Hinsdale', 10000, 1),
(13347, 254, 127, 'Ridgway', 10000, 1),
(13348, 254, 144, 'Harbor Beach', 10000, 1),
(13349, 254, 166, 'Parowan', 10000, 1),
(13351, 254, 162, 'Conway', 10000, 1),
(13352, 254, 126, 'Redway', 10000, 1),
(13353, 185, 3005, 'Notodden', 10000, 1),
(13354, 254, 143, 'Harvard', 10000, 1),
(13355, 233, 4010, 'Grebbestad', 10000, 1),
(13356, 91, 1913, 'Helmbrechts', 10000, 1),
(13358, 175, 2977, 'Ede', 10000, 1),
(13359, 254, 152, 'Chester', 10000, 1),
(13360, 65, 1491, 'Aller', 10000, 1),
(13361, 254, 143, 'Vineyard Haven', 10000, 1),
(13362, 254, 126, 'Stonyford', 10000, 1),
(13363, 233, 4006, 'Liden', 10000, 1),
(13364, 15, 1077, 'Wieselburg', 10000, 1),
(13365, 254, 154, 'Westhampton Beach', 10000, 1),
(13366, 253, 5392, 'Wells', 10000, 1),
(13367, 254, 164, 'Oneida', 10000, 1),
(13369, 254, 136, 'Newburgh', 10000, 1),
(13370, 254, 132, 'Temple', 10000, 1),
(13372, 254, 154, 'Seneca Falls', 10000, 1),
(13373, 254, 153, 'Espanola', 10000, 1),
(13374, 81, 5022, 'Varkaus', 10000, 1),
(13375, 185, 3005, 'Langesund', 10000, 1),
(13376, 254, 126, 'Kelseyville', 10000, 1),
(13377, 233, 4003, 'Enk', 10000, 1),
(13378, 233, 4010, 'Tanumshede', 10000, 1),
(13379, 254, 126, 'Idyllwild', 10000, 1),
(13380, 81, 5022, 'Nilsi', 10000, 1),
(13381, 119, 2251, 'Nuoro', 10000, 1),
(13382, 91, 1916, 'Bad Vilbel', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(13383, 254, 128, 'Durham', 10000, 1),
(13384, 254, 143, 'Belchertown', 10000, 1),
(13385, 254, 145, 'Saint Charles', 10000, 1),
(13386, 254, 143, 'Tyngsboro', 10000, 1),
(13387, 253, 5392, 'Letchworth', 10000, 1),
(13388, 254, 126, 'Yucca Valley', 10000, 1),
(13389, 43, 36, 'Valleyview', 10000, 1),
(13390, 175, 2980, 'Drunen', 10000, 1),
(13391, 254, 167, 'Colonial Heights', 10000, 1),
(13392, 254, 126, 'Lower Lake', 10000, 1),
(13393, 10, 1051, 'Castelar', 10000, 1),
(13394, 254, 157, 'Upper Sandusky', 10000, 1),
(13395, 254, 144, 'Huntington Woods', 10000, 1),
(13396, 254, 141, 'Saco', 10000, 1),
(13397, 254, 131, 'Branford', 10000, 1),
(13398, 254, 143, 'Shirley', 10000, 1),
(13399, 178, 3089, 'Napier', 10000, 1),
(13400, 254, 170, 'Merrillan', 10000, 1),
(13401, 198, 3311, 'Ericeira', 10000, 1),
(13402, 91, 1923, 'Neubrandenburg', 10000, 1),
(13403, 254, 145, 'Lake Elmo', 10000, 1),
(13404, 91, 1923, 'Wesenberg', 10000, 1),
(13405, 91, 1922, 'F', 10000, 1),
(13406, 254, 152, 'Dayton', 10000, 1),
(13407, 254, 160, 'Towanda', 10000, 1),
(13408, 254, 126, 'Coarsegold', 10000, 1),
(13409, 254, 145, 'Dassel', 10000, 1),
(13410, 254, 144, 'Cedar Springs', 10000, 1),
(13411, 254, 145, 'Angle Inlet', 10000, 1),
(13412, 254, 142, 'Crisfield', 10000, 1),
(13414, 239, 4124, 'Phuket', 10000, 1),
(13415, 254, 150, 'Pahrump', 10000, 1),
(13416, 254, 144, 'Walker', 10000, 1),
(13417, 10, 1051, 'Haedo', 10000, 1),
(13418, 254, 157, 'Amherst', 10000, 1),
(13421, 254, 126, 'Weed', 10000, 1),
(13422, 254, 144, 'Trenton', 10000, 1),
(13424, 254, 136, 'Shipshewana', 10000, 1),
(13425, 254, 155, 'Jamestown', 10000, 1),
(13426, 254, 144, 'Cassopolis', 10000, 1),
(13429, 254, 135, 'Georgetown', 10000, 1),
(13430, 254, 163, 'Beresford', 10000, 1),
(13431, 254, 163, 'Fairview', 10000, 1),
(13432, 254, 163, 'Worthing', 10000, 1),
(13433, 254, 163, 'Alcester', 10000, 1),
(13434, 254, 160, 'Pen Argyl', 10000, 1),
(13435, 43, 36, 'Strathmore', 10000, 1),
(13436, 254, 144, 'Vassar', 10000, 1),
(13437, 254, 131, 'Labelle', 10000, 1),
(13438, 254, 160, 'Narberth', 10000, 1),
(13439, 15, 1075, 'Pinkafeld', 10000, 1),
(13440, 254, 142, 'Emmitsburg', 10000, 1),
(13442, 253, 5389, 'Llandrindod Well', 10000, 1),
(13443, 256, 4492, 'Durazno', 10000, 1),
(13444, 175, 2980, 'Woensdrecht', 10000, 1),
(13445, 91, 1916, 'Gie', 10000, 1),
(13447, 254, 164, 'Collierville', 10000, 1),
(13449, 43, 43, 'Powell River', 10000, 1),
(13450, 254, 140, 'DeRidder', 10000, 1),
(13451, 175, 2982, 'Kampen', 10000, 1),
(13452, 233, 3999, '', 10000, 1),
(13453, 14, 1, 'South Yarra', 10000, 1),
(13455, 198, 3318, 'Viseu', 10000, 1),
(13456, 175, 2982, 'Raalte', 10000, 1),
(13457, 24, 1133, 'Tongeren', 10000, 1),
(13459, 175, 2985, 'Leiderdorp', 10000, 1),
(13460, 254, 172, 'Fairfax', 10000, 1),
(13462, 175, 2985, 'Capelle Aan Den Ijssel', 10000, 1),
(13463, 10, 1051, 'Mar del Plata', 10000, 1),
(13464, 233, 4004, 'Skillingsfors', 10000, 1),
(13465, 65, 1494, 'Br', 10000, 1),
(13466, 254, 146, 'Itta Bena', 10000, 1),
(13467, 91, 1913, 'Bayreuth', 10000, 1),
(13468, 119, 2246, 'Pavia', 10000, 1),
(13470, 91, 1912, 'Konstanz', 10000, 1),
(13471, 99, 636, 'Agat', 10000, 1),
(13473, 233, 4010, 'Vanersborg', 10000, 1),
(13474, 254, 122, 'Summerdale', 10000, 1),
(13475, 254, 145, 'Frazee', 10000, 1),
(13477, 43, 37, 'Elliot lake', 10000, 1),
(13478, 254, 165, 'Mabank', 10000, 1),
(13479, 119, 2248, 'Frosolone', 10000, 1),
(13480, 254, 164, 'Rives', 10000, 1),
(13481, 91, 1918, 'Wassenberg', 10000, 1),
(13482, 33, 30, 'Joinville', 10000, 1),
(13483, 254, 142, 'Owings Mills', 10000, 1),
(13484, 226, 3935, 'Torrelles de Llobregat', 10000, 1),
(13485, 256, 4491, 'Carmelo', 10000, 1),
(13486, 43, 42, 'Bathurst', 10000, 1),
(13487, 43, 37, 'Newcastle', 10000, 1),
(13488, 253, 5392, 'Leamington', 10000, 1),
(13490, 254, 142, 'Havre De Grace', 10000, 1),
(13491, 119, 2253, 'Grosseto', 10000, 1),
(13492, 254, 154, 'Floral Park', 10000, 1),
(13493, 254, 167, 'Honaker', 10000, 1),
(13494, 159, 2888, 'Mexico', 10000, 1),
(13496, 254, 160, 'Scottdale', 10000, 1),
(13497, 254, 165, 'Magnolia', 10000, 1),
(13498, 119, 2245, 'San Remo', 10000, 1),
(13499, 254, 135, 'Minonk', 10000, 1),
(13500, 254, 160, 'Murrysville', 10000, 1),
(13501, 254, 126, 'Studio City', 10000, 1),
(13502, 254, 151, 'Meredith', 10000, 1),
(13503, 254, 158, 'Bixby', 10000, 1),
(13504, 219, 756, 'Toa Payoh', 10000, 1),
(13505, 81, 4879, 'Kotka', 10000, 1),
(13506, 234, 4049, 'Uster', 10000, 1),
(13507, 254, 160, 'Waynesboro', 10000, 1),
(13508, 254, 145, 'Isanti', 10000, 1),
(13510, 254, 128, 'New Milford', 10000, 1),
(13511, 43, 43, 'Revelstoke', 10000, 1),
(13512, 254, 142, 'Mount Rainier', 10000, 1),
(13513, 254, 144, 'Mohawk', 10000, 1),
(13514, 43, 36, 'Cardston', 10000, 1),
(13515, 149, 2906, 'Sibu', 10000, 1),
(13516, 254, 135, 'Marengo', 10000, 1),
(13517, 254, 157, 'Luckey', 10000, 1),
(13518, 254, 128, 'Southbury', 10000, 1),
(13519, 49, 1361, 'Guangdong', 10000, 1),
(13521, 254, 170, 'Wisconsin Rapids', 10000, 1),
(13523, 243, 4060, 'San Fernando', 10000, 1),
(13524, 254, 135, 'Richmond', 10000, 1),
(13526, 145, 2683, 'Macau', 10000, 1),
(13527, 254, 155, 'Hampstead', 10000, 1),
(13529, 224, 3680, 'Newcastle', 10000, 1),
(13530, 233, 3992, 'Eksjo', 10000, 1),
(13531, 254, 135, 'Herrin', 10000, 1),
(13532, 254, 159, 'Rockaway Beach', 10000, 1),
(13533, 239, 4122, 'Koh Samui', 10000, 1),
(13534, 178, 3137, 'Taupo', 10000, 1),
(13537, 254, 154, 'Rock Hill', 10000, 1),
(13538, 14, 4, 'Gosford', 10000, 1),
(13539, 254, 133, 'Makawao', 10000, 1),
(13542, 43, 43, 'Kitimat', 10000, 1),
(13543, 197, 3277, 'Lublin', 10000, 1),
(13544, 254, 167, 'Catlett', 10000, 1),
(13545, 149, 2907, 'Subang Jaya', 10000, 1),
(13546, 253, 5392, 'Lichfield', 10000, 1),
(13547, 119, 2257, 'Malcesine', 10000, 1),
(13548, 43, 35, 'Baie-Comeau', 10000, 1),
(13549, 14, 1, 'Hurstbridge', 10000, 1),
(13551, 226, 3935, 'Lleida', 10000, 1),
(13552, 254, 152, 'Maple Shade', 10000, 1),
(13553, 82, 1813, 'Lyon', 10000, 1),
(13554, 33, 24, 'Pirassununga', 10000, 1),
(13555, 100, 1985, 'San Jose Pinula', 10000, 1),
(13556, 149, 2897, 'Pontian', 10000, 1),
(13557, 15, 1081, 'Jochberg', 10000, 1),
(13558, 254, 155, 'Hiddenite', 10000, 1),
(13559, 233, 4010, 'Uddevalla', 10000, 1),
(13560, 152, 689, 'Luqa', 10000, 1),
(13561, 109, 646, 'Chai Wan', 10000, 1),
(13562, 254, 165, 'Nazareth', 10000, 1),
(13563, 43, 35, 'Saint-Laurent', 10000, 1),
(13564, 254, 172, 'Stowe', 10000, 1),
(13565, 43, 42, 'Campbellton', 10000, 1),
(13566, 234, 4029, 'Lengnau', 10000, 1),
(13567, 254, 135, 'Broadview', 10000, 1),
(13568, 254, 155, 'Stony Point', 10000, 1),
(13569, 254, 164, 'Mount Juliet', 10000, 1),
(13571, 254, 126, 'Livingston', 10000, 1),
(13572, 254, 160, 'Fredericksburg', 10000, 1),
(13574, 43, 35, 'Cantley', 10000, 1),
(13575, 253, 5392, 'Crawley', 10000, 1),
(13576, 254, 131, 'Apopka', 10000, 1),
(13577, 24, 1136, 'Merelbeke', 10000, 1),
(13578, 91, 1919, 'Landau', 10000, 1),
(13579, 226, 3931, 'Huesca', 10000, 1),
(13581, 254, 157, 'Perrysburg', 10000, 1),
(13582, 254, 165, 'Pflugerville', 10000, 1),
(13583, 175, 2980, '''S-Hertogenbosch', 10000, 1),
(13584, 185, 2996, 'Molde', 10000, 1),
(13587, 254, 131, 'Loxahatchee', 10000, 1),
(13589, 254, 170, 'Minocqua', 10000, 1),
(13590, 175, 2980, 'Breda', 10000, 1),
(13591, 254, 143, 'Florence', 10000, 1),
(13593, 254, 131, 'Zephyrhills', 10000, 1),
(13594, 91, 1913, 'Kaufbeuren', 10000, 1),
(13595, 254, 151, 'Atkinson', 10000, 1),
(13596, 254, 152, 'Manchester Township', 10000, 1),
(13597, 254, 160, 'Jersey Shore', 10000, 1),
(13599, 254, 169, 'Sistersville', 10000, 1),
(13600, 254, 126, 'Desert Hot Springs', 10000, 1),
(13601, 254, 154, 'New Windsor', 10000, 1),
(13602, 254, 149, 'Syracuse', 10000, 1),
(13603, 254, 144, 'Hartford', 10000, 1),
(13604, 254, 128, 'Terryville', 10000, 1),
(13605, 254, 160, 'Moscow', 10000, 1),
(13606, 43, 43, 'Quesnel', 10000, 1),
(13607, 254, 165, 'Addison', 10000, 1),
(13608, 254, 144, 'Armada', 10000, 1),
(13609, 114, 49, 'Klungkung', 10000, 1),
(13610, 254, 160, 'Ellwood City', 10000, 1),
(13612, 226, 3935, 'Igualada', 10000, 1),
(13613, 254, 147, 'Centralia', 10000, 1),
(13614, 226, 3935, 'Esparreguera', 10000, 1),
(13615, 195, 3505, 'Las Pinas City', 10000, 1),
(13616, 81, 5023, 'M', 10000, 1),
(13617, 254, 135, 'Rock Falls', 10000, 1),
(13618, 128, 2456, 'Kostanai', 10000, 1),
(13619, 175, 2983, 'Veenendaal', 10000, 1),
(13620, 175, 2982, 'Oldenzaal', 10000, 1),
(13621, 185, 2993, 'Vads', 10000, 1),
(13623, 233, 4006, 'Sollefte', 10000, 1),
(13624, 175, 2977, 'Zaltbommel', 10000, 1),
(13625, 15, 1077, 'Wiener Neustadt', 10000, 1),
(13626, 65, 1500, 'Almind', 10000, 1),
(13627, 91, 1919, 'Neuwied', 10000, 1),
(13628, 254, 123, 'Glennallen', 10000, 1),
(13629, 253, 5392, 'Northallerton', 10000, 1),
(13630, 253, 5392, 'Yarm', 10000, 1),
(13631, 253, 5392, 'Barking', 10000, 1),
(13633, 175, 2983, 'Woerden', 10000, 1),
(13634, 91, 1912, 'Heilbronn', 10000, 1),
(13635, 175, 2982, 'Hengelo', 10000, 1),
(13637, 119, 2257, 'Treviso', 10000, 1),
(13638, 233, 3990, 'Varberg', 10000, 1),
(13639, 149, 2903, 'Kuala Kangsar', 10000, 1),
(13640, 246, 4236, 'Manisa', 10000, 1),
(13641, 253, 5392, 'Chelmsford', 10000, 1),
(13643, 253, 5392, 'Hoddesdon', 10000, 1),
(13645, 254, 144, 'Blissfield', 10000, 1),
(13646, 254, 137, 'North Liberty', 10000, 1),
(13647, 254, 167, 'Smithfield', 10000, 1),
(13648, 254, 167, 'Stuarts Draft', 10000, 1),
(13649, 65, 1497, 'Roskilde', 10000, 1),
(13651, 198, 3307, 'Albufeira', 10000, 1),
(13652, 175, 2981, 'Enkhuizen', 10000, 1),
(13653, 14, 1, 'Echuca', 10000, 1),
(13655, 10, 1051, 'Caseros', 10000, 1),
(13656, 43, 39, 'Wolfville', 10000, 1),
(13657, 175, 2985, 'Alphen Aan Den Rijn', 10000, 1),
(13664, 254, 127, 'Conifer', 10000, 1),
(13665, 254, 169, 'Chapmanville', 10000, 1),
(13667, 254, 137, 'Hiawatha', 10000, 1),
(13669, 254, 127, 'Evergreen', 10000, 1),
(13670, 233, 3990, 'Falkenberg', 10000, 1),
(13671, 43, 35, 'Victoriaville', 10000, 1),
(13672, 254, 155, 'Morrisville', 10000, 1),
(13673, 254, 140, 'Rayne', 10000, 1),
(13674, 254, 132, 'Morrow', 10000, 1),
(13676, 254, 154, 'Geneva', 10000, 1),
(13678, 254, 157, 'Conneaut', 10000, 1),
(13679, 254, 160, 'King of Prussia', 10000, 1),
(13680, 254, 126, 'Felton', 10000, 1),
(13681, 254, 157, 'Miamisburg', 10000, 1),
(13682, 43, 37, 'Richmond Hill', 10000, 1),
(13683, 254, 152, 'Califon', 10000, 1),
(13684, 254, 160, 'Bryn Mawr', 10000, 1),
(13685, 254, 126, 'Terra Bella', 10000, 1),
(13686, 226, 3935, 'Sabadell', 10000, 1),
(13687, 226, 3935, 'Matadepera', 10000, 1),
(13688, 234, 4048, 'Zug', 10000, 1),
(13689, 91, 1914, 'Bremen', 10000, 1),
(13690, 113, 2174, 'Delhi', 10000, 1),
(13691, 119, 2241, 'solofra', 10000, 1),
(13692, 219, 756, 'Woodlands', 10000, 1),
(13693, 254, 165, 'Vidor', 10000, 1),
(13694, 65, 1496, 'Tim', 10000, 1),
(13695, 254, 126, 'Anza', 10000, 1),
(13696, 253, 5392, 'Dorchester', 10000, 1),
(13700, 254, 164, 'Goodlettsville', 10000, 1),
(13701, 254, 157, 'Oak Harbor', 10000, 1),
(13703, 254, 151, 'Londonderry', 10000, 1),
(13704, 254, 152, 'Lincoln Park', 10000, 1),
(13705, 254, 147, 'Seligman', 10000, 1),
(13706, 185, 2994, 'Elverum', 10000, 1),
(13707, 91, 1912, 'Albstadt', 10000, 1),
(13708, 254, 144, 'Coloma', 10000, 1),
(13709, 185, 2996, '', 10000, 1),
(13710, 233, 4009, '', 10000, 1),
(13711, 253, 5392, 'Dartford', 10000, 1),
(13712, 185, 2996, 'Isfjorden', 10000, 1),
(13714, 254, 170, 'Menasha', 10000, 1),
(13715, 254, 164, 'Bulls Gap', 10000, 1),
(13716, 113, 2191, 'Cuddalore', 10000, 1),
(13717, 43, 43, 'White Rock', 10000, 1),
(13718, 254, 164, 'Viola', 10000, 1),
(13719, 254, 164, 'Blountville', 10000, 1),
(13721, 233, 4010, 'Nossebro', 10000, 1),
(13722, 81, 4879, 'Vantaa', 10000, 1),
(13723, 254, 123, 'Whittier', 10000, 1),
(13725, 254, 155, 'Mount Airy', 10000, 1),
(13726, 178, 3106, 'Blenheim', 10000, 1),
(13727, 254, 144, 'Mason', 10000, 1),
(13728, 185, 2992, 'H', 10000, 1),
(13731, 43, 43, 'Heriot Bay', 10000, 1),
(13733, 159, 203, 'San Luis Potos', 10000, 1),
(13734, 254, 157, 'Dresden', 10000, 1),
(13735, 254, 167, 'Occoquan', 10000, 1),
(13737, 254, 162, 'Easley', 10000, 1),
(13738, 254, 162, 'Pickens', 10000, 1),
(13741, 111, 2072, 'H', 10000, 1),
(13742, 254, 135, 'South Elgin', 10000, 1),
(13743, 254, 160, 'Saxton', 10000, 1),
(13744, 254, 135, 'Kincaid', 10000, 1),
(13745, 254, 170, 'Athens', 10000, 1),
(13746, 254, 140, 'DeQuincy', 10000, 1),
(13747, 254, 133, 'Holualoa', 10000, 1),
(13748, 254, 147, 'Qulin', 10000, 1),
(13749, 254, 158, 'Wellston', 10000, 1),
(13750, 254, 162, 'Manning', 10000, 1),
(13751, 65, 1501, 'Ringkobing', 10000, 1),
(13752, 254, 126, 'Topanga', 10000, 1),
(13754, 254, 132, 'Rex', 10000, 1),
(13756, 254, 144, 'Grand Ledge', 10000, 1),
(13757, 159, 71, 'Valle de Santiago', 10000, 1),
(13758, 254, 167, 'Franklin', 10000, 1),
(13759, 254, 133, 'Waianae', 10000, 1),
(13761, 254, 166, 'Wellsville', 10000, 1),
(13763, 81, 4879, 'H', 10000, 1),
(13766, 254, 157, 'Wellington', 10000, 1),
(13767, 254, 168, 'Tonasket', 10000, 1),
(13770, 254, 136, 'Greentown', 10000, 1),
(13771, 91, 1916, 'Marburg', 10000, 1),
(13772, 202, 3386, 'Ploiesti', 10000, 1),
(13774, 254, 123, 'Delta Junction', 10000, 1),
(13775, 65, 1494, 'Hj', 10000, 1),
(13776, 82, 1814, 'Mutzig', 10000, 1),
(13777, 254, 126, 'Pacoima', 10000, 1),
(13779, 91, 1919, 'Rudesheim', 10000, 1),
(13780, 118, 2232, 'Beer-Sheva', 10000, 1),
(13781, 234, 4043, 'Frauenfeld', 10000, 1),
(13782, 234, 4043, 'Kreuzlingen', 10000, 1),
(13783, 254, 160, 'Loganton', 10000, 1),
(13785, 254, 143, 'Southbridge', 10000, 1),
(13786, 254, 152, 'Dover', 10000, 1),
(13788, 175, 2981, 'Hoofddorp', 10000, 1),
(13790, 119, 2249, 'Settimo Torinese', 10000, 1),
(13791, 254, 142, 'Savage', 10000, 1),
(13792, 111, 2103, 'Szombathely', 10000, 1),
(13793, 213, 3631, 'Jubail', 10000, 1),
(13794, 254, 142, 'Damascus', 10000, 1),
(13795, 33, 17, 'Campina Grande', 10000, 1),
(13796, 195, 3505, 'Malabon', 10000, 1),
(13797, 254, 165, 'Leming', 10000, 1),
(13799, 254, 138, 'Derby', 10000, 1),
(13800, 254, 132, 'Acworth', 10000, 1),
(13801, 15, 1077, 'Zwettl ', 10000, 1),
(13803, 65, 1501, 'Hee', 10000, 1),
(13804, 254, 157, 'Liberty Center', 10000, 1),
(13805, 254, 159, 'Shady Cove', 10000, 1),
(13806, 254, 160, 'Kempton', 10000, 1),
(13807, 134, 2439, 'Khalidia', 10000, 1),
(13808, 65, 1497, 'Greve', 10000, 1),
(13809, 254, 155, 'Elon College', 10000, 1),
(13810, 254, 168, 'Nordland', 10000, 1),
(13811, 254, 144, 'Saint Ignace', 10000, 1),
(13812, 253, 5392, 'Bury', 10000, 1),
(13813, 254, 145, 'Albany', 10000, 1),
(13814, 254, 144, 'West Branch', 10000, 1),
(13815, 254, 170, 'Cedarburg', 10000, 1),
(13816, 254, 147, 'Pilot Grove', 10000, 1),
(13818, 137, 2511, 'Sigulda', 10000, 1),
(13819, 254, 157, 'Berea', 10000, 1),
(13820, 254, 164, 'Strawberry Plains', 10000, 1),
(13822, 254, 143, 'Charlestown', 10000, 1),
(13823, 175, 2976, 'Heerenveen', 10000, 1),
(13824, 254, 145, 'Renville', 10000, 1),
(13825, 254, 165, 'Aransas Pass', 10000, 1),
(13826, 254, 155, 'Weaverville', 10000, 1),
(13827, 254, 168, 'Langley', 10000, 1),
(13828, 254, 136, 'Fountain City', 10000, 1),
(13829, 254, 152, 'Hasbrouck Heights', 10000, 1),
(13830, 82, 1813, 'Annecy', 10000, 1),
(13831, 251, 4435, 'Donetsk', 10000, 1),
(13832, 254, 126, 'Esparto', 10000, 1),
(13833, 198, 3313, 'Trofa', 10000, 1),
(13834, 254, 144, 'Hudson', 10000, 1),
(13835, 254, 147, 'Bolivar', 10000, 1),
(13836, 254, 154, 'Red Creek', 10000, 1),
(13837, 254, 142, 'Lothian', 10000, 1),
(13838, 254, 143, 'Westford', 10000, 1),
(13842, 82, 1803, 'Les Ulis', 10000, 1),
(13844, 254, 154, 'Bayport', 10000, 1),
(13845, 254, 157, 'Avon', 10000, 1),
(13846, 254, 154, 'Holtsville', 10000, 1),
(13847, 61, 5036, 'Rijeka', 10000, 1),
(13848, 254, 168, 'Curlew', 10000, 1),
(13849, 254, 148, 'Ronan', 10000, 1),
(13851, 254, 122, 'Hartselle', 10000, 1),
(13852, 43, 41, 'Mount Pearl', 10000, 1),
(13853, 254, 126, 'Cedarpines Park', 10000, 1),
(13854, 254, 154, 'Nesconset', 10000, 1),
(13855, 99, 636, 'Hagatna', 10000, 1),
(13858, 91, 1913, 'weiden', 10000, 1),
(13859, 65, 1500, 'Fredericia', 10000, 1),
(13860, 254, 152, 'Glen Ridge', 10000, 1),
(13861, 43, 38, 'Grunthal', 10000, 1),
(13862, 254, 132, 'Woodstock', 10000, 1),
(13863, 254, 155, 'Fuqua-Varina', 10000, 1),
(13864, 254, 168, 'Manson', 10000, 1),
(13865, 254, 126, 'La Honda', 10000, 1),
(13866, 254, 162, 'Fort Mill', 10000, 1),
(13867, 254, 135, 'Lincoln', 10000, 1),
(13868, 91, 1920, 'Lebach', 10000, 1),
(13869, 254, 131, 'Ocoee', 10000, 1),
(13870, 233, 4009, 'H', 10000, 1),
(13871, 254, 155, 'Carrboro', 10000, 1),
(13872, 254, 168, 'Ilwaco', 10000, 1),
(13873, 254, 157, 'Loveland', 10000, 1),
(13874, 253, 5392, 'Benfleet', 10000, 1),
(13875, 254, 139, 'Salvisa', 10000, 1),
(13876, 152, 689, 'Tarxien', 10000, 1),
(13878, 254, 147, 'Canton', 10000, 1),
(13879, 254, 133, 'Wahiawa', 10000, 1),
(13881, 175, 2983, 'Driebergen', 10000, 1),
(13882, 254, 138, 'Augusta', 10000, 1),
(13883, 43, 38, 'Winkler', 10000, 1),
(13884, 43, 38, 'Altona', 10000, 1),
(13887, 254, 134, 'Hayden', 10000, 1),
(13888, 254, 142, 'Accokeek', 10000, 1),
(13889, 43, 37, 'Carleton Place', 10000, 1),
(13890, 254, 151, 'Suncook', 10000, 1),
(13891, 254, 145, 'Andover', 10000, 1),
(13893, 14, 3, 'Rockhampton', 10000, 1),
(13894, 254, 160, 'Collegeville', 10000, 1),
(13895, 254, 137, 'Norwalk', 10000, 1),
(13897, 254, 152, 'Middletown', 10000, 1),
(13898, 254, 160, 'Camp Hill', 10000, 1),
(13899, 14, 1, 'Morwell', 10000, 1),
(13902, 254, 134, 'Emmett', 10000, 1),
(13903, 224, 3685, 'White River', 10000, 1),
(13904, 43, 36, 'Leduc', 10000, 1),
(13905, 43, 37, 'Lively', 10000, 1),
(13906, 24, 5306, 'Boortmeerbeek', 10000, 1),
(13907, 254, 136, 'Jasonville', 10000, 1),
(13908, 82, 1803, 'Chantilly', 10000, 1),
(13909, 65, 1491, 'Frederikssund', 10000, 1),
(13910, 82, 1803, 'Levallois-Perret', 10000, 1),
(13911, 175, 2977, 'Wageningen', 10000, 1),
(13912, 233, 3992, 'Bankeryd', 10000, 1),
(13913, 253, 5392, 'Croydon', 10000, 1),
(13914, 226, 3908, 'Villanueva de la Ca', 10000, 1),
(13915, 233, 3993, 'F', 10000, 1),
(13916, 119, 2257, 'Thiene', 10000, 1),
(13917, 82, 1801, 'Besancon', 10000, 1),
(13918, 82, 1801, 'Lons-le-Saunier', 10000, 1),
(13919, 219, 756, 'Paya Lebar', 10000, 1),
(13920, 233, 4010, 'Lidkoping', 10000, 1),
(13921, 82, 1811, 'Poitiers', 10000, 1),
(13922, 254, 160, 'Marysville', 10000, 1),
(13923, 254, 156, 'Zap', 10000, 1),
(13924, 251, 4434, 'Dnepropetrovsk', 10000, 1),
(13926, 91, 1918, 'Neuss', 10000, 1),
(13927, 233, 3992, 'N', 10000, 1),
(13928, 254, 170, 'Redgranite', 10000, 1),
(13930, 254, 157, 'Broadview Heights.', 10000, 1),
(13931, 91, 1916, 'Hofgeismar', 10000, 1),
(13932, 233, 3999, 'Kumla', 10000, 1),
(13933, 254, 160, 'Dillsburg', 10000, 1),
(13935, 43, 37, 'Durham', 10000, 1),
(13936, 251, 4435, 'Makeevka', 10000, 1),
(13937, 254, 167, 'Bridgewater', 10000, 1),
(13939, 185, 3006, 'Oksfjord', 10000, 1),
(13940, 185, 3006, 'S', 10000, 1),
(13941, 33, 24, 'Valinhos', 10000, 1),
(13942, 119, 2246, 'Cologno Monzese', 10000, 1),
(13943, 254, 156, 'Burlington', 10000, 1),
(13944, 254, 156, 'Tioga', 10000, 1),
(13945, 199, 736, 'Barranquitas', 10000, 1),
(13946, 91, 1918, 'Kamp-Lintfort', 10000, 1),
(13947, 119, 2253, 'Cecina', 10000, 1),
(13948, 254, 159, 'Trail', 10000, 1),
(13949, 254, 144, 'Comstock Park', 10000, 1),
(13950, 254, 144, 'South Branch', 10000, 1),
(13951, 233, 4002, 'Str', 10000, 1),
(13954, 254, 156, 'Saint John', 10000, 1),
(13955, 254, 143, 'Bellingham', 10000, 1),
(13957, 254, 157, 'Canal Winchester', 10000, 1),
(13959, 65, 1489, 'Mygind', 10000, 1),
(13960, 254, 154, 'Arcade', 10000, 1),
(13962, 254, 152, 'Ramsey', 10000, 1),
(13963, 91, 1916, 'Wetzlar', 10000, 1),
(13964, 91, 1916, 'Hofheim', 10000, 1),
(13965, 65, 1498, 'Ravsted', 10000, 1),
(13966, 254, 165, 'Cypress', 10000, 1),
(13967, 111, 2084, 'Ny', 10000, 1),
(13968, 175, 2979, 'Sittard', 10000, 1),
(13969, 254, 162, 'Woodruff', 10000, 1),
(13970, 253, 5392, 'Southport', 10000, 1),
(13971, 254, 154, 'Ardsley', 10000, 1),
(13972, 254, 144, 'Ferrysburg', 10000, 1),
(13973, 253, 5392, 'Telford', 10000, 1),
(13975, 253, 5392, 'Seaford', 10000, 1),
(13976, 254, 154, 'Cold Spring', 10000, 1),
(13977, 253, 5392, 'Hastings', 10000, 1),
(13980, 91, 1913, 'Fuerth', 10000, 1),
(13981, 254, 160, 'East Greenville', 10000, 1),
(13982, 254, 145, 'Clarks Grove', 10000, 1),
(13983, 254, 144, 'Suttons Bay', 10000, 1),
(13984, 254, 164, 'Tullahoma', 10000, 1),
(13986, 254, 170, 'Onalaska', 10000, 1),
(13987, 254, 157, 'Pickerington', 10000, 1),
(13988, 144, 2625, 'Hesperange', 10000, 1),
(13989, 254, 126, 'Aromas', 10000, 1),
(13991, 37, 1239, 'Burgas', 10000, 1),
(13992, 254, 165, 'Taylor', 10000, 1),
(13993, 254, 154, 'Cape Vincent', 10000, 1),
(13994, 254, 154, 'Milford', 10000, 1),
(13995, 254, 170, 'Mukwonago', 10000, 1),
(13996, 254, 152, 'Howell', 10000, 1),
(13997, 254, 144, 'Mulliken', 10000, 1),
(13998, 254, 156, 'White Earth', 10000, 1),
(13999, 254, 156, 'Kenmare', 10000, 1),
(14000, 10, 1051, 'Lomas De Zamora', 10000, 1),
(14001, 43, 37, 'Milton', 10000, 1),
(14002, 254, 160, 'Tobyhanna', 10000, 1),
(14004, 254, 135, 'Bradley', 10000, 1),
(14006, 254, 126, 'Lincoln', 10000, 1),
(14007, 254, 154, 'Endwell', 10000, 1),
(14008, 254, 152, 'Pitman', 10000, 1),
(14009, 254, 135, 'Pinckneyville', 10000, 1),
(14010, 254, 144, 'Stockbridge', 10000, 1),
(14011, 254, 142, 'Cockeysville', 10000, 1),
(14012, 254, 156, 'New Town', 10000, 1),
(14013, 254, 160, 'Hanover', 10000, 1),
(14014, 254, 157, 'Raymond', 10000, 1),
(14015, 254, 131, 'Lake Mary', 10000, 1),
(14016, 254, 136, 'Economy', 10000, 1),
(14017, 254, 134, 'Athol', 10000, 1),
(14018, 254, 165, 'Haltom City', 10000, 1),
(14019, 254, 136, 'Pendleton', 10000, 1),
(14020, 254, 156, 'Golden Valley', 10000, 1),
(14021, 254, 168, 'Clinton', 10000, 1),
(14023, 253, 5392, 'Luton', 10000, 1),
(14024, 226, 3932, 'Los Llanos De Aridane', 10000, 1),
(14026, 114, 2163, 'Manado', 10000, 1),
(14027, 114, 2163, 'Tondano', 10000, 1),
(14028, 82, 1804, 'Beziers', 10000, 1),
(14029, 114, 2163, 'Tomohon', 10000, 1),
(14030, 254, 154, 'Taberg', 10000, 1),
(14031, 95, 1970, 'Chania', 10000, 1),
(14032, 254, 156, 'Hazen', 10000, 1),
(14033, 254, 156, 'Maddock', 10000, 1),
(14034, 254, 165, 'Webster', 10000, 1),
(14035, 254, 172, 'Waitsfield', 10000, 1),
(14036, 254, 168, 'Granite Falls', 10000, 1),
(14037, 254, 144, 'Fenton', 10000, 1),
(14039, 254, 135, 'Monmouth', 10000, 1),
(14040, 254, 152, 'Wayne', 10000, 1),
(14041, 114, 2157, 'Kuta', 10000, 1),
(14042, 114, 2157, 'Praya', 10000, 1),
(14043, 254, 143, 'Douglas', 10000, 1),
(14044, 114, 2157, 'Selong', 10000, 1),
(14045, 254, 159, 'Yachats', 10000, 1),
(14047, 254, 152, 'Keyport', 10000, 1),
(14048, 91, 1913, 'Lindau', 10000, 1),
(14049, 233, 3990, 'Laholm', 10000, 1),
(14050, 254, 156, 'Richardton', 10000, 1),
(14051, 253, 5391, 'Stanmore', 10000, 1),
(14052, 253, 5392, 'Saint Albans', 10000, 1),
(14054, 254, 145, 'Lamberton', 10000, 1),
(14055, 43, 43, 'Chilliwack', 10000, 1),
(14056, 253, 5392, 'Church Stretton', 10000, 1),
(14057, 254, 145, 'Clinton', 10000, 1),
(14058, 254, 154, 'Depew', 10000, 1),
(14060, 254, 160, 'Gladwyne', 10000, 1),
(14061, 254, 124, 'Cave Creek', 10000, 1),
(14062, 175, 2975, 'Emmen', 10000, 1),
(14063, 119, 2250, 'Bari', 10000, 1),
(14064, 254, 132, 'Lilburn', 10000, 1),
(14065, 253, 5391, 'Carrickfergus', 10000, 1),
(14067, 253, 5390, 'Dunfermline', 10000, 1),
(14068, 254, 159, 'Jefferson', 10000, 1),
(14070, 221, 3786, 'Gorizia', 10000, 1),
(14071, 43, 43, 'Langley', 10000, 1),
(14072, 254, 160, 'Bellwood', 10000, 1),
(14073, 254, 159, 'Otis', 10000, 1),
(14074, 24, 1135, 'Ciney', 10000, 1),
(14075, 185, 2990, 'Gjerdrum', 10000, 1),
(14076, 254, 138, 'Haysville', 10000, 1),
(14078, 254, 165, 'Eustace', 10000, 1),
(14079, 43, 38, 'Flin Flon', 10000, 1),
(14080, 119, 2253, 'Siena', 10000, 1),
(14082, 43, 37, 'Tecumseh', 10000, 1),
(14083, 254, 138, 'Baldwin City', 10000, 1),
(14084, 254, 147, 'Elsberry', 10000, 1),
(14085, 254, 144, 'Iron River', 10000, 1),
(14086, 114, 49, 'Nusa Dua', 10000, 1),
(14087, 114, 49, 'Kuta', 10000, 1),
(14088, 114, 49, 'Ubud', 10000, 1),
(14089, 254, 160, 'Newville', 10000, 1),
(14090, 254, 144, 'Albion', 10000, 1),
(14091, 254, 156, 'Leeds', 10000, 1),
(14092, 122, 2357, 'Takatsuki', 10000, 1),
(14093, 254, 144, 'Caledonia', 10000, 1),
(14094, 254, 155, 'Speed', 10000, 1),
(14095, 33, 29, 'Teres', 10000, 1),
(14096, 254, 136, 'Alexandria', 10000, 1),
(14097, 43, 815, 'Carcross', 10000, 1),
(14098, 254, 136, 'New Richmond', 10000, 1),
(14099, 254, 170, 'Chaseburg', 10000, 1),
(14100, 254, 140, 'Covington', 10000, 1),
(14103, 254, 135, 'Williamsville', 10000, 1),
(14104, 254, 152, 'Oradell', 10000, 1),
(14107, 254, 164, 'Clinton', 10000, 1),
(14108, 175, 2980, 'Roosendaal', 10000, 1),
(14110, 175, 2977, 'Barneveld', 10000, 1),
(14111, 65, 1492, 'Nyborg', 10000, 1),
(14112, 254, 142, 'Hollywood', 10000, 1),
(14113, 65, 1501, 'Thisted', 10000, 1),
(14114, 254, 152, 'Short Hills', 10000, 1),
(14115, 175, 2985, 'Zoetermeer', 10000, 1),
(14116, 226, 3932, 'Las Palmas', 10000, 1),
(14117, 91, 1916, 'Gross-Zimmern', 10000, 1),
(14118, 254, 154, 'Fairport', 10000, 1),
(14119, 82, 1794, 'Biot', 10000, 1),
(14120, 254, 141, 'Skowhegan', 10000, 1),
(14121, 254, 122, 'Daleville', 10000, 1),
(14123, 254, 164, 'Eidson', 10000, 1),
(14124, 254, 135, 'Coal City', 10000, 1),
(14125, 65, 1494, 'Klokkerholm', 10000, 1),
(14126, 254, 160, 'Plymouth', 10000, 1),
(14127, 61, 5030, 'Koprivnica', 10000, 1),
(14128, 233, 4007, 'Arboga', 10000, 1),
(14129, 43, 37, 'Picton', 10000, 1),
(14131, 254, 165, 'Schertz', 10000, 1),
(14132, 254, 132, 'Loganville', 10000, 1),
(14133, 254, 142, 'Taneytown', 10000, 1),
(14134, 226, 3938, 'San Sebastian', 10000, 1),
(14135, 226, 3931, 'Zaragoza', 10000, 1),
(14136, 254, 136, 'Reelsville', 10000, 1),
(14137, 254, 160, 'New Alexandria', 10000, 1),
(14138, 254, 122, 'Fyffe', 10000, 1),
(14139, 199, 736, 'Rincon', 10000, 1),
(14140, 254, 149, 'La Vista', 10000, 1),
(14141, 254, 154, 'Middle Island', 10000, 1),
(14142, 254, 143, 'Dracut', 10000, 1),
(14144, 254, 126, 'Westwood', 10000, 1),
(14146, 254, 154, 'Beacon', 10000, 1),
(14147, 254, 127, 'Whitewater', 10000, 1),
(14148, 254, 153, 'Loving', 10000, 1),
(14150, 254, 152, 'Bound Brook', 10000, 1),
(14151, 254, 135, 'Lena', 10000, 1),
(14153, 254, 142, 'Hampstead', 10000, 1),
(14154, 254, 158, 'Perkins', 10000, 1),
(14155, 254, 126, 'Los Osos', 10000, 1),
(14156, 43, 43, 'Hope', 10000, 1),
(14158, 175, 2975, 'Hoogeveen', 10000, 1),
(14159, 254, 126, 'Olancha', 10000, 1),
(14160, 253, 5392, 'Horsham', 10000, 1),
(14162, 254, 126, 'San Martin', 10000, 1),
(14163, 254, 135, 'Lockport', 10000, 1),
(14166, 254, 133, 'Kula', 10000, 1),
(14167, 254, 149, 'Champion', 10000, 1),
(14168, 254, 154, 'Orchard Park', 10000, 1),
(14169, 254, 162, 'Ridge Spring', 10000, 1),
(14170, 254, 154, 'Rockaway Park', 10000, 1),
(14171, 254, 167, 'Norton', 10000, 1),
(14173, 254, 170, 'Casco', 10000, 1),
(14174, 254, 144, 'Norway', 10000, 1),
(14175, 254, 168, 'Coupeville', 10000, 1),
(14176, 254, 131, 'Safety Harbor', 10000, 1),
(14177, 254, 153, 'Questa', 10000, 1),
(14179, 254, 142, 'California', 10000, 1),
(14180, 126, 2389, 'Karak', 10000, 1),
(14181, 234, 4049, 'Schlieren', 10000, 1),
(14182, 254, 157, 'Mingo Junction', 10000, 1),
(14183, 119, 2243, 'Udine', 10000, 1),
(14184, 175, 2985, 'Maassluis', 10000, 1),
(14186, 254, 135, 'Antioch', 10000, 1),
(14187, 43, 43, 'Parksville', 10000, 1),
(14188, 14, 3, 'Bundaberg', 10000, 1),
(14189, 254, 126, 'Sanger', 10000, 1),
(14190, 226, 3930, 'Almeria', 10000, 1),
(14191, 234, 4025, 'Bremgarten', 10000, 1),
(14192, 119, 2253, 'Arezzo', 10000, 1),
(14193, 119, 2252, 'Castelvetrano', 10000, 1),
(14194, 118, 2233, 'Natanya', 10000, 1),
(14195, 81, 5023, 'Jamsankoski', 10000, 1),
(14196, 81, 5022, 'Joensuu', 10000, 1),
(14197, 91, 1916, 'Idstein', 10000, 1),
(14198, 253, 5392, 'Stockton-on-Tees', 10000, 1),
(14199, 233, 4010, '', 10000, 1),
(14200, 24, 1136, 'Aalst', 10000, 1),
(14201, 91, 1918, 'Willich', 10000, 1),
(14202, 81, 4879, 'Riihimaki', 10000, 1),
(14203, 254, 154, 'Red Hook', 10000, 1),
(14205, 254, 161, 'Foster', 10000, 1),
(14206, 233, 3990, 'V', 10000, 1),
(14207, 254, 157, 'Seville', 10000, 1),
(14208, 253, 5392, 'Poole', 10000, 1),
(14209, 234, 4032, 'Glarus', 10000, 1),
(14210, 119, 2247, 'Ancona', 10000, 1),
(14211, 254, 155, 'Thomasville', 10000, 1),
(14212, 254, 157, 'Franklin', 10000, 1),
(14213, 43, 35, 'Jonquiere', 10000, 1),
(14215, 226, 3935, 'Girona', 10000, 1),
(14216, 254, 160, 'Hermitage', 10000, 1),
(14217, 253, 5390, 'Dunblane', 10000, 1),
(14218, 226, 3934, 'Segovia', 10000, 1),
(14219, 254, 131, 'Mount Dora', 10000, 1),
(14220, 233, 3987, 'Sandviken', 10000, 1),
(14222, 254, 161, 'Middletown', 10000, 1),
(14223, 220, 2592, 'Poprad', 10000, 1),
(14224, 233, 4000, 'Motala', 10000, 1),
(14225, 254, 136, 'Dillsboro', 10000, 1),
(14226, 254, 122, 'Satsuma', 10000, 1),
(14227, 254, 140, 'Transylvania', 10000, 1),
(14229, 254, 126, 'Inyokern', 10000, 1),
(14230, 254, 152, 'Absecon', 10000, 1),
(14231, 91, 1912, 'Baden-Baden', 10000, 1),
(14232, 43, 35, 'Chateauguay', 10000, 1),
(14233, 254, 164, 'Del Rio', 10000, 1),
(14234, 254, 143, 'Westwood', 10000, 1),
(14235, 254, 122, 'Garden City', 10000, 1),
(14236, 254, 135, 'Brighton', 10000, 1),
(14237, 254, 144, 'Farmington', 10000, 1),
(14239, 233, 4002, 'Nyk', 10000, 1),
(14241, 254, 145, 'Sartell', 10000, 1),
(14242, 254, 160, 'Malvern', 10000, 1),
(14243, 254, 145, 'Hayward', 10000, 1),
(14244, 223, 3872, 'Galkacyo', 10000, 1),
(14246, 254, 157, 'Mineral Ridge', 10000, 1),
(14247, 91, 1912, 'Weinstadt', 10000, 1),
(14249, 91, 1918, 'Geilenkirchen', 10000, 1),
(14250, 254, 157, 'Antwerp', 10000, 1),
(14251, 81, 1772, 'Mariehamn', 10000, 1),
(14252, 254, 144, 'Maple Rapids', 10000, 1),
(14253, 24, 1137, 'Middelkerke', 10000, 1),
(14254, 48, 1367, 'Victoria', 10000, 1),
(14255, 254, 151, 'Merrimack', 10000, 1),
(14256, 254, 144, 'Vestaburg', 10000, 1),
(14257, 271, 5062, 'Herceg-Novi', 10000, 1),
(14258, 254, 145, 'Halstad', 10000, 1),
(14259, 254, 168, 'Kelso', 10000, 1),
(14260, 253, 5392, 'Bristol', 10000, 1),
(14261, 254, 145, 'Belgrade', 10000, 1),
(14262, 254, 168, 'Sammamish', 10000, 1),
(14263, 254, 139, 'Virgie', 10000, 1),
(14264, 254, 126, 'Tarzana', 10000, 1),
(14267, 254, 157, 'Monroe', 10000, 1),
(14268, 119, 2244, 'Civitavecchia', 10000, 1),
(14269, 119, 2244, 'Fregene', 10000, 1),
(14270, 175, 2980, 'Zundert', 10000, 1),
(14271, 119, 2244, 'santa Marinella', 10000, 1),
(14272, 224, 3689, 'George', 10000, 1),
(14273, 254, 144, 'Wayne', 10000, 1),
(14274, 254, 144, 'Buchanan', 10000, 1),
(14275, 254, 141, 'Bucksport', 10000, 1),
(14278, 43, 35, 'Gasp', 10000, 1),
(14279, 254, 135, 'Utica', 10000, 1),
(14280, 254, 132, 'Hiram', 10000, 1),
(14281, 233, 3993, 'Kalmar', 10000, 1),
(14282, 254, 147, 'Hurdland', 10000, 1),
(14283, 254, 133, 'Kapaa', 10000, 1),
(14284, 120, 2386, 'Kingston', 10000, 1),
(14286, 233, 3994, 'Falun', 10000, 1),
(14287, 175, 2985, 'Naaldwijk', 10000, 1),
(14288, 254, 145, 'Ottertail', 10000, 1),
(14289, 233, 3994, 'Avesta', 10000, 1),
(14290, 24, 1136, 'Gentbrugge', 10000, 1),
(14291, 254, 142, 'Crofton', 10000, 1),
(14292, 254, 167, 'Bristol', 10000, 1),
(14293, 234, 4047, 'Yverdon', 10000, 1),
(14294, 254, 170, 'Oak Creek', 10000, 1),
(14295, 254, 147, 'Lone Jack', 10000, 1),
(14296, 254, 159, 'Neotsu', 10000, 1),
(14297, 254, 147, 'Chula', 10000, 1),
(14298, 254, 147, 'Seymour', 10000, 1),
(14299, 254, 160, 'Bethel', 10000, 1),
(14301, 254, 126, 'Santa Fe Springs', 10000, 1),
(14303, 254, 147, 'Bunceton', 10000, 1),
(14304, 254, 160, 'Guys Mills', 10000, 1),
(14305, 254, 131, 'Hobe Sound', 10000, 1),
(14306, 198, 3313, 'Matosinhos', 10000, 1),
(14307, 254, 152, 'Hillsborough', 10000, 1),
(14312, 236, 4273, 'Yung Kang City', 10000, 1),
(14313, 254, 165, 'Castroville', 10000, 1),
(14314, 117, 1611, 'Castlebar', 10000, 1),
(14315, 43, 43, 'Oliver', 10000, 1),
(14316, 254, 143, 'Wrentham', 10000, 1),
(14317, 254, 155, 'Balsam Grove', 10000, 1),
(14318, 43, 42, 'Rothesay', 10000, 1),
(14319, 254, 137, 'Fayette', 10000, 1),
(14321, 254, 136, 'Crown Point', 10000, 1),
(14322, 254, 163, 'Summit', 10000, 1),
(14323, 254, 159, 'Cove', 10000, 1),
(14324, 14, 3, 'Torquay', 10000, 1),
(14325, 175, 2981, 'Hilversum', 10000, 1),
(14327, 254, 165, 'Sutherland Springs', 10000, 1),
(14328, 65, 1489, 'Skibby', 10000, 1),
(14329, 91, 1918, 'Guetersloh', 10000, 1),
(14330, 185, 2996, 'Volda', 10000, 1),
(14331, 143, 2572, 'Elektrenai', 10000, 1),
(14332, 175, 2981, 'Alkmaar', 10000, 1),
(14333, 65, 1491, 'Hiller', 10000, 1),
(14334, 254, 160, 'Vandergrift', 10000, 1),
(14335, 198, 3309, 'Guarda', 10000, 1),
(14336, 175, 2985, 'Pijnacker', 10000, 1),
(14337, 119, 2241, 'Avellino', 10000, 1),
(14338, 233, 4009, 'Barseb', 10000, 1),
(14340, 254, 155, 'Clemmons', 10000, 1),
(14342, 254, 152, 'Matawan', 10000, 1),
(14343, 226, 3908, 'Alcal', 10000, 1),
(14344, 254, 142, 'Dameron', 10000, 1),
(14345, 43, 42, 'Florenceville', 10000, 1),
(14346, 254, 131, 'Fountain', 10000, 1),
(14347, 254, 160, 'Chadds Ford', 10000, 1),
(14348, 175, 2985, 'Dordrecht', 10000, 1),
(14351, 43, 37, 'Ethel', 10000, 1),
(14352, 233, 3992, 'Huskvarna', 10000, 1),
(14354, 254, 135, 'Capron', 10000, 1),
(14355, 226, 3936, 'Badajoz', 10000, 1),
(14356, 254, 157, 'Aurora', 10000, 1),
(14357, 254, 131, 'Havana', 10000, 1),
(14358, 254, 159, 'Sweet Home', 10000, 1),
(14359, 233, 3994, 'T', 10000, 1),
(14360, 254, 170, 'East Troy', 10000, 1),
(14361, 15, 1080, 'Leoben', 10000, 1),
(14363, 254, 159, 'Vernonia', 10000, 1),
(14365, 254, 159, 'Enterprise', 10000, 1),
(14366, 254, 132, 'Yatesville', 10000, 1),
(14367, 233, 4004, 'Kristinehamn', 10000, 1),
(14368, 254, 154, 'Valhalla', 10000, 1),
(14369, 119, 2250, 'Conversano', 10000, 1),
(14370, 254, 151, 'Ashland', 10000, 1),
(14371, 254, 159, 'Warrenton', 10000, 1),
(14372, 233, 4008, 'Kista', 10000, 1),
(14373, 254, 132, 'Grovetown', 10000, 1),
(14374, 254, 160, 'Boyertown', 10000, 1),
(14375, 254, 129, 'Middletown', 10000, 1),
(14376, 199, 736, 'Canovanas', 10000, 1),
(14377, 254, 152, 'Westwood', 10000, 1),
(14378, 119, 2250, 'Foggia', 10000, 1),
(14380, 254, 135, 'Grayslake', 10000, 1),
(14381, 233, 4010, 'Kinna', 10000, 1),
(14382, 254, 145, 'Perham', 10000, 1),
(14383, 24, 1129, 'Bornem', 10000, 1),
(14385, 254, 152, 'Lyndhurst', 10000, 1),
(14386, 185, 2997, 'Svolv', 10000, 1),
(14387, 254, 144, 'Clare', 10000, 1),
(14388, 95, 1941, 'Kavala', 10000, 1),
(14389, 198, 3302, 'Braga', 10000, 1),
(14390, 254, 154, 'High Falls', 10000, 1),
(14391, 10, 1057, 'Buenos Aires', 10000, 1),
(14392, 254, 154, 'Ellenville', 10000, 1),
(14393, 119, 2239, 'Genzano Di Lucania', 10000, 1),
(14394, 254, 156, 'Mayville', 10000, 1),
(14396, 254, 135, 'Glen Carbon', 10000, 1),
(14397, 152, 689, 'Attard', 10000, 1),
(14398, 254, 144, 'Franklin', 10000, 1),
(14399, 254, 145, 'Mabel', 10000, 1),
(14400, 254, 165, 'Cleveland', 10000, 1),
(14401, 43, 43, 'Enderby', 10000, 1),
(14402, 254, 168, 'Stanwood', 10000, 1),
(14403, 254, 154, 'Keeseville', 10000, 1),
(14404, 254, 167, 'Madison Heights', 10000, 1),
(14405, 254, 152, 'Sewell', 10000, 1),
(14406, 254, 164, 'Hermitage', 10000, 1),
(14407, 254, 129, 'Lewes', 10000, 1),
(14408, 254, 135, 'Batavia', 10000, 1),
(14409, 43, 46, 'Alert', 10000, 1),
(14410, 254, 157, 'Buchanan', 10000, 1),
(14411, 254, 152, 'Clinton', 10000, 1),
(14412, 254, 136, 'Milford', 10000, 1),
(14413, 254, 140, 'Gray', 10000, 1),
(14414, 254, 154, 'Rocky Point', 10000, 1),
(14416, 33, 24, 'Ara', 10000, 1),
(14417, 198, 3311, 'Amadora', 10000, 1),
(14418, 254, 144, 'Lowell', 10000, 1),
(14419, 254, 155, 'Kernersville', 10000, 1),
(14420, 254, 143, 'Townsend', 10000, 1),
(14421, 43, 41, 'Corner Brook', 10000, 1),
(14422, 254, 165, 'Eddy', 10000, 1),
(14423, 14, 1, 'Bairnsdale', 10000, 1),
(14424, 254, 137, 'Gowrie', 10000, 1),
(14425, 254, 160, 'Fredericktown', 10000, 1),
(14426, 254, 144, 'Owendale', 10000, 1),
(14427, 254, 168, 'Marysville', 10000, 1),
(14429, 254, 147, 'Park Hills', 10000, 1),
(14431, 43, 38, 'Killarney', 10000, 1),
(14432, 254, 131, 'Homosassa', 10000, 1),
(14433, 226, 3918, 'Santander', 10000, 1),
(14434, 254, 126, 'Wilton', 10000, 1),
(14435, 65, 1493, 'Lyngby', 10000, 1),
(14436, 81, 5022, 'Mikkeli', 10000, 1),
(14438, 119, 2257, 'Rovigo', 10000, 1),
(14439, 14, 3, 'Gympie', 10000, 1),
(14440, 226, 3933, 'Cuenca', 10000, 1),
(14441, 226, 3933, 'Huete', 10000, 1),
(14443, 253, 5392, 'Carlisle', 10000, 1),
(14444, 65, 1501, 'Slagelse', 10000, 1),
(14445, 175, 2979, 'Maastricht', 10000, 1),
(14446, 253, 5392, 'Banbury', 10000, 1),
(14447, 198, 3302, 'Guimar', 10000, 1),
(14448, 251, 4450, 'Sevastopol', 10000, 1),
(14449, 254, 154, 'Miller Place', 10000, 1),
(14450, 33, 27, 'Itamogi', 10000, 1),
(14451, 33, 27, 'S', 10000, 1),
(14452, 24, 5306, 'Vilvoorde', 10000, 1),
(14453, 254, 160, 'Ambler', 10000, 1),
(14455, 254, 164, 'Oliver Springs', 10000, 1),
(14456, 254, 154, 'Clifton Park', 10000, 1),
(14458, 254, 160, 'Landisville', 10000, 1),
(14459, 254, 141, 'Scarborough', 10000, 1),
(14460, 254, 160, 'Cogan Station', 10000, 1),
(14462, 254, 160, 'Exton', 10000, 1),
(14463, 185, 2997, 'Sortland', 10000, 1),
(14464, 149, 2897, 'Muar', 10000, 1),
(14465, 254, 126, 'Littlerock', 10000, 1),
(14467, 254, 172, 'Passumpsic', 10000, 1),
(14470, 254, 135, 'Cary', 10000, 1),
(14471, 254, 154, 'Northport', 10000, 1),
(14473, 254, 135, 'Fox River Grove', 10000, 1),
(14474, 254, 167, 'Great Falls', 10000, 1),
(14475, 119, 2246, 'Lainate', 10000, 1),
(14476, 254, 134, 'Buhl', 10000, 1),
(14477, 81, 5023, 'Pori', 10000, 1),
(14478, 119, 2241, 'Salerno', 10000, 1),
(14479, 254, 136, 'Oakland City', 10000, 1),
(14480, 254, 160, 'Montgomery', 10000, 1),
(14482, 134, 2441, 'Bayan', 10000, 1),
(14484, 254, 126, 'Buellton', 10000, 1),
(14485, 33, 29, 'Niter', 10000, 1),
(14486, 175, 2984, 'Hengstdijk', 10000, 1),
(14487, 114, 2166, 'Binjei', 10000, 1),
(14489, 254, 141, 'Newport', 10000, 1),
(14493, 254, 149, 'Wilsonville', 10000, 1),
(14494, 254, 136, 'Albion', 10000, 1),
(14495, 254, 126, 'Tujunga', 10000, 1),
(14496, 254, 126, 'Aptos', 10000, 1),
(14497, 178, 4706, 'Manukau City', 10000, 1),
(14498, 254, 134, 'Cottonwood', 10000, 1),
(14499, 254, 160, 'Athens', 10000, 1),
(14500, 43, 37, 'Tobermory', 10000, 1),
(14501, 254, 152, 'Great Meadows', 10000, 1),
(14502, 254, 131, 'Merritt Island', 10000, 1),
(14503, 65, 1491, 'Birker', 10000, 1),
(14505, 153, 690, 'Douglas', 10000, 1),
(14506, 253, 5392, 'Guilford', 10000, 1),
(14507, 254, 134, 'Post Falls', 10000, 1),
(14508, 254, 131, 'Port Richey', 10000, 1),
(14509, 81, 5023, 'Nokia', 10000, 1),
(14510, 253, 5392, 'Epsom', 10000, 1),
(14511, 254, 128, 'Mystic', 10000, 1),
(14512, 254, 157, 'Wadsworth', 10000, 1),
(14513, 254, 167, 'Chatham', 10000, 1),
(14514, 91, 1912, 'Balingen', 10000, 1),
(14516, 49, 1344, 'Huang Shi City', 10000, 1),
(14518, 175, 2985, 'Poortugaal', 10000, 1),
(14519, 48, 1372, 'Corral', 10000, 1),
(14520, 65, 1491, 'Helsing', 10000, 1),
(14521, 254, 135, 'Harvard', 10000, 1),
(14522, 254, 143, 'Marblehead', 10000, 1),
(14523, 254, 168, 'Shelton', 10000, 1),
(14524, 253, 5392, 'Southend-on-Sea', 10000, 1),
(14525, 254, 154, 'Roslyn', 10000, 1),
(14526, 221, 3754, 'Kranj', 10000, 1),
(14527, 254, 136, 'Cambridge City', 10000, 1),
(14528, 198, 3311, 'Carcavelos', 10000, 1),
(14529, 33, 15, 'Cascavel', 10000, 1),
(14530, 253, 5392, 'Bicester', 10000, 1),
(14531, 254, 155, 'Richlands', 10000, 1),
(14532, 175, 2981, 'Berkhout', 10000, 1),
(14534, 254, 148, 'Stevensville', 10000, 1),
(14535, 178, 4744, 'Alexandra', 10000, 1),
(14536, 254, 143, 'Gardner', 10000, 1),
(14537, 254, 168, 'Woodland', 10000, 1),
(14538, 254, 154, 'Seaford', 10000, 1),
(14539, 43, 37, 'Paris', 10000, 1),
(14543, 119, 2249, 'Alpignano', 10000, 1),
(14545, 133, 2432, 'P''yongt''aek', 10000, 1),
(14546, 254, 144, 'Lakeview', 10000, 1),
(14547, 91, 1926, 'Jena', 10000, 1),
(14548, 91, 1922, 'Cottbus', 10000, 1),
(14549, 91, 1922, 'Herzberg', 10000, 1),
(14550, 82, 1803, 'Orsay', 10000, 1),
(14551, 254, 157, 'Wellston', 10000, 1),
(14552, 119, 2242, 'Cattolica', 10000, 1),
(14553, 254, 122, 'Coker', 10000, 1),
(14554, 175, 2975, 'Roden', 10000, 1),
(14555, 91, 1912, 'Ellwangen', 10000, 1),
(14556, 254, 128, 'Ansonia', 10000, 1),
(14557, 33, 27, 'Uberl', 10000, 1),
(14559, 82, 1801, 'Morez', 10000, 1),
(14560, 43, 35, 'Trois-Rivi', 10000, 1),
(14561, 254, 127, 'Larkspur', 10000, 1),
(14563, 254, 165, 'Needville', 10000, 1),
(14564, 233, 4009, 'Ystad', 10000, 1),
(14565, 61, 5035, 'Pakrac', 10000, 1),
(14566, 63, 1485, 'Larnaca', 10000, 1),
(14567, 254, 126, 'Newman', 10000, 1),
(14568, 254, 168, 'College Place', 10000, 1),
(14569, 150, 2881, 'Male', 10000, 1),
(14570, 254, 147, 'Cassville', 10000, 1),
(14571, 254, 150, 'Overton', 10000, 1),
(14572, 254, 146, 'Sardis', 10000, 1),
(14573, 254, 134, 'Spencer', 10000, 1),
(14574, 91, 1912, 'Bad Wildbad', 10000, 1),
(14575, 43, 35, 'Montmagny', 10000, 1),
(14577, 65, 1500, 'Horsens', 10000, 1),
(14578, 254, 160, 'Thorndale', 10000, 1),
(14579, 254, 165, 'Bluffton', 10000, 1),
(14580, 254, 165, 'Tow', 10000, 1),
(14581, 254, 126, 'Orange Cove', 10000, 1),
(14582, 254, 126, 'Ferndale', 10000, 1),
(14583, 24, 1129, 'Geel', 10000, 1),
(14585, 254, 160, 'Kunkletown', 10000, 1),
(14586, 24, 5305, 'Waterloo', 10000, 1),
(14587, 234, 4029, 'Biel', 10000, 1),
(14588, 254, 131, 'Beverly Hills', 10000, 1),
(14589, 254, 158, 'Langston', 10000, 1),
(14590, 254, 168, 'Graham', 10000, 1),
(14591, 91, 1912, 'Urbach', 10000, 1),
(14592, 253, 5392, 'Blackburn', 10000, 1),
(14593, 254, 126, 'Colfax', 10000, 1),
(14595, 226, 3911, 'Los Arcos', 10000, 1),
(14597, 175, 2981, 'Heemskerk', 10000, 1),
(14598, 175, 2981, 'Weesp', 10000, 1),
(14599, 254, 135, 'Lemont', 10000, 1),
(14600, 254, 154, 'Monroe', 10000, 1),
(14601, 119, 2246, 'Arese', 10000, 1),
(14603, 175, 2981, 'Medemblik', 10000, 1),
(14604, 253, 5392, 'Farnham', 10000, 1),
(14605, 254, 145, 'Byron', 10000, 1),
(14606, 254, 170, 'Mishicot', 10000, 1),
(14608, 254, 140, 'Eunice', 10000, 1),
(14609, 254, 141, 'Oakland', 10000, 1),
(14611, 254, 131, 'Land O Lakes', 10000, 1),
(14612, 43, 35, 'Val-Belair', 10000, 1),
(14614, 254, 157, 'Belpre', 10000, 1),
(14616, 43, 35, 'Verdun', 10000, 1),
(14618, 198, 3310, 'Leiria', 10000, 1),
(14621, 254, 144, 'Richmond', 10000, 1),
(14622, 254, 136, 'Loogootee', 10000, 1),
(14623, 254, 139, 'Rockholds', 10000, 1),
(14624, 254, 160, 'Elizabeth', 10000, 1),
(14625, 91, 1918, 'Kempen', 10000, 1),
(14629, 119, 2246, 'Varese', 10000, 1),
(14631, 91, 1919, 'Hachenburg', 10000, 1),
(14632, 254, 157, 'Senecaville', 10000, 1),
(14633, 33, 24, 'Taubat', 10000, 1),
(14635, 220, 2592, 'Presov', 10000, 1),
(14636, 14, 5, 'Murray Bridge', 10000, 1),
(14637, 254, 170, 'Muskego', 10000, 1),
(14638, 233, 3992, 'Varnamo', 10000, 1),
(14639, 175, 2977, 'Doetinchem', 10000, 1),
(14640, 254, 155, 'Hillsborough', 10000, 1),
(14641, 43, 37, 'Port Elgin', 10000, 1),
(14642, 254, 126, 'Greenville', 10000, 1),
(14643, 91, 1918, 'Witten', 10000, 1),
(14644, 254, 147, 'Cuba', 10000, 1),
(14645, 226, 3938, 'Bergara', 10000, 1),
(14646, 254, 142, 'Sykesville', 10000, 1),
(14648, 254, 142, 'Mount Airy', 10000, 1),
(14649, 254, 132, 'Mount Airy', 10000, 1),
(14650, 254, 131, 'Saint Marks', 10000, 1),
(14652, 254, 126, 'Middletown', 10000, 1),
(14653, 254, 158, 'Watts', 10000, 1),
(14654, 253, 5392, 'Burnley', 10000, 1),
(14655, 254, 158, 'Ballard', 10000, 1),
(14656, 254, 147, 'Hume', 10000, 1),
(14658, 254, 140, 'Kaplan', 10000, 1),
(14660, 43, 42, 'Sackville', 10000, 1),
(14661, 254, 138, 'Greeley', 10000, 1),
(14662, 254, 139, 'Corbin', 10000, 1),
(14663, 254, 163, 'Valley Springs', 10000, 1),
(14664, 254, 126, 'Cottonwood', 10000, 1),
(14665, 254, 150, 'Lake Tahoe', 10000, 1),
(14667, 254, 131, 'Valrico', 10000, 1),
(14668, 254, 126, 'Janesville', 10000, 1),
(14669, 254, 144, 'Clinton Township', 10000, 1),
(14670, 254, 136, 'Sheridan', 10000, 1),
(14671, 254, 170, 'Boscobel', 10000, 1),
(14672, 254, 145, 'Big Lake', 10000, 1),
(14673, 253, 5392, 'Rochester', 10000, 1),
(14674, 252, 5002, 'Bur Dubai', 10000, 1),
(14675, 254, 140, 'Galliano', 10000, 1),
(14676, 197, 3279, 'Krakow', 10000, 1),
(14677, 254, 158, 'Mustang', 10000, 1),
(14678, 10, 1055, 'Rio Tercero', 10000, 1),
(14679, 254, 140, 'Hessmer', 10000, 1),
(14680, 254, 154, 'East Setauket', 10000, 1),
(14681, 254, 140, 'Moreauville', 10000, 1),
(14682, 119, 2238, 'L''Aquila', 10000, 1),
(14683, 254, 126, 'La Palma', 10000, 1),
(14684, 254, 165, 'Chandler', 10000, 1),
(14685, 254, 147, 'Bonne Terre', 10000, 1),
(14686, 253, 5392, 'Blackpool', 10000, 1),
(14687, 254, 154, 'Fleischmanns', 10000, 1),
(14688, 195, 3450, 'Cainta', 10000, 1),
(14689, 254, 147, 'Mount Vernon', 10000, 1),
(14690, 254, 154, 'Tillson', 10000, 1),
(14691, 149, 2904, 'Kangar', 10000, 1),
(14692, 254, 170, 'New Lisbon', 10000, 1),
(14693, 254, 135, 'Cottage Hills', 10000, 1),
(14694, 254, 171, 'Powell', 10000, 1),
(14695, 254, 165, 'Joshua', 10000, 1),
(14696, 254, 124, 'Buckeye', 10000, 1),
(14697, 65, 1497, 'Koege', 10000, 1),
(14698, 254, 146, 'Magnolia', 10000, 1),
(14699, 8, 4763, 'McMurdo Station', 10000, 1),
(14700, 254, 132, 'Lenox', 10000, 1),
(14701, 234, 4025, 'Zofingen', 10000, 1),
(14702, 65, 1501, 'Viborg', 10000, 1),
(14703, 91, 1918, 'Leverkusen', 10000, 1),
(14704, 15, 1076, 'Feldkirchen', 10000, 1),
(14705, 24, 1131, 'Tournai', 10000, 1),
(14706, 253, 5392, 'Redditch', 10000, 1),
(14707, 119, 2257, 'Bassano Del Grappa', 10000, 1),
(14708, 253, 5392, 'Solihull', 10000, 1),
(14709, 254, 127, 'Manzanola', 10000, 1),
(14710, 119, 2246, 'Carugate', 10000, 1),
(14711, 95, 1970, 'Souda', 10000, 1),
(14712, 43, 37, 'Kincardine', 10000, 1),
(14713, 253, 5392, 'Harrow', 10000, 1),
(14714, 175, 2977, 'Zutphen', 10000, 1),
(14715, 175, 2983, 'Nieuwegein', 10000, 1),
(14718, 233, 4010, 'M', 10000, 1),
(14719, 254, 140, 'Denham Springs', 10000, 1),
(14721, 49, 1361, 'Shantou', 10000, 1),
(14722, 253, 5392, 'Manchester', 10000, 1),
(14723, 254, 160, 'Southampton', 10000, 1),
(14724, 254, 139, 'Regina', 10000, 1),
(14725, 15, 1082, 'Dornbirn', 10000, 1),
(14726, 254, 152, 'Ocean Grove', 10000, 1),
(14727, 91, 1916, 'Fulda', 10000, 1),
(14728, 254, 155, 'Apex', 10000, 1),
(14729, 254, 158, 'Bristow', 10000, 1),
(14730, 254, 144, 'Jenison', 10000, 1),
(14732, 254, 147, 'Louisiana', 10000, 1),
(14733, 254, 168, 'Lakebay', 10000, 1),
(14734, 254, 149, 'Milford', 10000, 1),
(14736, 254, 160, 'Chalfont', 10000, 1),
(14737, 43, 36, 'Drayton Valley', 10000, 1),
(14738, 254, 153, 'Peralta', 10000, 1),
(14739, 233, 4002, 'Julita', 10000, 1),
(14740, 254, 167, 'James City County', 10000, 1),
(14741, 254, 137, 'Everly', 10000, 1),
(14743, 254, 149, 'Shickley', 10000, 1),
(14744, 82, 1803, 'Nanterre', 10000, 1),
(14745, 239, 4109, 'Banchang', 10000, 1),
(14747, 254, 126, 'Albany', 10000, 1),
(14748, 254, 168, 'Washougal', 10000, 1),
(14749, 91, 1917, 'G', 10000, 1),
(14750, 119, 2250, 'Lecce', 10000, 1),
(14751, 65, 1493, 'Virum', 10000, 1),
(14752, 25, 1166, 'San Ignacio', 10000, 1),
(14753, 33, 24, 'Araraquara', 10000, 1),
(14754, 254, 147, 'Willard', 10000, 1),
(14755, 254, 126, 'Somerset', 10000, 1),
(14756, 254, 157, 'Bellevue', 10000, 1),
(14757, 254, 131, 'Waldo', 10000, 1),
(14758, 43, 43, 'Shawnigan Lake', 10000, 1),
(14759, 195, 3455, 'San Juan', 10000, 1),
(14760, 254, 136, 'Hartsville', 10000, 1),
(14761, 254, 170, 'Pewaukee', 10000, 1),
(14762, 82, 1793, 'Terrasson', 10000, 1),
(14763, 254, 135, 'Altona', 10000, 1),
(14765, 254, 167, 'Keysville', 10000, 1),
(14766, 91, 1912, 'Neuenb', 10000, 1),
(14767, 33, 32, 'S', 10000, 1),
(14768, 33, 24, 'S', 10000, 1),
(14769, 24, 1136, 'Lochristi', 10000, 1),
(14771, 33, 24, 'Ribeir', 10000, 1),
(14772, 254, 162, 'Monetta', 10000, 1),
(14773, 43, 37, 'Bancroft', 10000, 1),
(14774, 43, 37, 'Fergus', 10000, 1),
(14775, 234, 4025, 'Aarau', 10000, 1),
(14776, 33, 24, 'Ribeir', 10000, 1),
(14778, 119, 2246, 'Brembate', 10000, 1),
(14779, 254, 126, 'Fall River Mills', 10000, 1),
(14780, 254, 158, 'Bokoshe', 10000, 1),
(14781, 178, 5010, 'Nelson', 10000, 1),
(14783, 224, 3688, 'Rustenburg', 10000, 1),
(14784, 175, 2981, 'Hoorn', 10000, 1),
(14785, 175, 2982, 'Bathmen', 10000, 1),
(14787, 43, 41, 'Stephenville', 10000, 1),
(14788, 175, 2985, 'Moordrecht', 10000, 1),
(14789, 195, 3530, 'Zamboanga City', 10000, 1),
(14790, 14, 2, 'Burnie', 10000, 1),
(14791, 114, 2149, 'Malang', 10000, 1),
(14792, 254, 135, 'Canton', 10000, 1),
(14793, 254, 131, 'Satellite Beach', 10000, 1),
(14794, 14, 1, 'Ascot Vale', 10000, 1),
(14796, 254, 159, 'Rogue River', 10000, 1),
(14797, 254, 159, 'Gold Beach', 10000, 1),
(14798, 254, 144, 'Burt', 10000, 1),
(14799, 113, 2174, 'New Delhi', 10000, 1),
(14801, 253, 5392, 'Hyde', 10000, 1),
(14802, 234, 4047, 'Nyon', 10000, 1),
(14803, 175, 2984, 'Westkapelle', 10000, 1),
(14804, 175, 2981, 'Purmerend', 10000, 1),
(14805, 254, 154, 'Pine Bush', 10000, 1),
(14806, 254, 142, 'Indian Head', 10000, 1),
(14807, 254, 144, 'Manton', 10000, 1),
(14808, 68, 1534, 'Sos', 10000, 1),
(14809, 91, 1912, 'Bad Urach', 10000, 1),
(14810, 43, 37, 'Beaverton', 10000, 1),
(14811, 254, 154, 'South Cairo', 10000, 1),
(14812, 254, 171, 'Story', 10000, 1),
(14813, 254, 135, 'Thomson', 10000, 1),
(14814, 254, 157, 'Brewster', 10000, 1),
(14816, 254, 135, 'Taylor Ridge', 10000, 1),
(14817, 254, 136, 'Bristow', 10000, 1),
(14818, 254, 153, 'Springer', 10000, 1),
(14819, 254, 160, 'Glenolden', 10000, 1),
(14821, 254, 132, 'Martin', 10000, 1),
(14823, 254, 145, 'Hopkins', 10000, 1),
(14824, 118, 2234, 'Nazareth Illit', 10000, 1),
(14825, 119, 2243, 'Lignano', 10000, 1),
(14826, 91, 1918, 'Borgholzhausen', 10000, 1),
(14827, 256, 4496, 'Punta del Este', 10000, 1),
(14828, 43, 37, 'Aylmer', 10000, 1),
(14829, 122, 2354, 'Urasa', 10000, 1),
(14830, 254, 165, 'Dublin', 10000, 1),
(14831, 254, 142, 'Grantsville', 10000, 1),
(14832, 65, 1498, 'Vojens', 10000, 1),
(14834, 254, 134, 'Saint Anthony', 10000, 1),
(14835, 43, 43, 'Port Alberni', 10000, 1),
(14836, 254, 136, 'New Paris', 10000, 1),
(14837, 254, 145, 'La Crescent', 10000, 1),
(14839, 254, 157, 'West Jefferson', 10000, 1),
(14840, 254, 164, 'Smyrna', 10000, 1),
(14842, 254, 151, 'Somersworth', 10000, 1),
(14843, 114, 2147, 'Depok', 10000, 1),
(14844, 195, 3505, 'Mandaluyong City', 10000, 1),
(14845, 233, 3992, 'Gislaved', 10000, 1),
(14848, 82, 1807, 'Saint-Gaudens', 10000, 1),
(14849, 109, 646, 'Tsuen Wan', 10000, 1),
(14850, 254, 154, 'Latham', 10000, 1),
(14851, 91, 1912, 'Gengenbach', 10000, 1),
(14853, 43, 41, 'Happy Valley-Goose Bay', 10000, 1),
(14854, 91, 1917, 'Lueneburg', 10000, 1),
(14855, 113, 2175, 'Gandhinagar', 10000, 1),
(14856, 254, 154, 'Huntington Station', 10000, 1),
(14857, 254, 132, 'Dry Branch', 10000, 1),
(14858, 254, 135, 'Washington', 10000, 1),
(14859, 254, 166, 'Draper', 10000, 1),
(14860, 15, 1078, 'Bad Hall', 10000, 1),
(14861, 254, 160, 'Portage', 10000, 1),
(14862, 254, 135, 'Red Bud', 10000, 1),
(14863, 254, 135, 'Cambridge', 10000, 1),
(14865, 254, 126, 'Biggs', 10000, 1),
(14866, 254, 143, 'Mansfield', 10000, 1),
(14867, 254, 138, 'Altamont', 10000, 1),
(14869, 43, 37, 'Chesley', 10000, 1),
(14871, 91, 1913, 'Burghausen', 10000, 1),
(14872, 175, 2981, 'Huizen', 10000, 1),
(14873, 254, 154, 'Port Jefferson Station', 10000, 1),
(14874, 159, 197, 'Tecom', 10000, 1),
(14875, 254, 170, 'Plymouth', 10000, 1),
(14876, 254, 148, 'Florence', 10000, 1),
(14877, 254, 126, 'El Dorado Hills', 10000, 1),
(14880, 254, 126, 'Joshua Tree', 10000, 1),
(14881, 254, 160, 'North Apollo', 10000, 1),
(14883, 254, 135, 'Midlothian', 10000, 1),
(14884, 254, 166, 'Hill AFB', 10000, 1),
(14885, 254, 159, 'Beavercreek', 10000, 1),
(14886, 24, 1136, 'Maldegem', 10000, 1),
(14887, 81, 1779, 'Ylivieska', 10000, 1),
(14889, 254, 160, 'Green Lane', 10000, 1),
(14890, 17, 1157, 'Fresh Creek', 10000, 1),
(14891, 254, 161, 'Ashaway', 10000, 1),
(14892, 254, 140, 'Scott', 10000, 1),
(14895, 254, 168, 'Sultan', 10000, 1),
(14896, 213, 3636, 'Jeddah', 10000, 1),
(14897, 254, 148, 'Choteau', 10000, 1),
(14898, 254, 126, 'Sun Valley', 10000, 1),
(14899, 91, 1916, 'Lampertheim', 10000, 1),
(14900, 254, 126, 'Shingle Springs', 10000, 1),
(14901, 254, 137, 'Otho', 10000, 1),
(14903, 254, 126, 'Homewood', 10000, 1),
(14904, 254, 160, 'Bernville', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(14905, 199, 736, 'Carolina', 10000, 1),
(14906, 254, 154, 'Middleburgh', 10000, 1),
(14909, 224, 3689, 'Kuils River', 10000, 1),
(14910, 254, 142, 'Abingdon', 10000, 1),
(14912, 254, 154, 'Slate Hill', 10000, 1),
(14914, 81, 5022, 'Iisalmi', 10000, 1),
(14915, 254, 152, 'Allendale', 10000, 1),
(14916, 233, 3991, 'Br', 10000, 1),
(14917, 253, 5392, 'Hatfield', 10000, 1),
(14919, 254, 166, 'Midway', 10000, 1),
(14920, 254, 144, 'Mount Morris', 10000, 1),
(14921, 254, 163, 'Canistota', 10000, 1),
(14922, 175, 2979, 'Weert', 10000, 1),
(14923, 24, 1129, 'Arendonk', 10000, 1),
(14928, 254, 167, 'Cristal City', 10000, 1),
(14929, 254, 126, 'Cotati', 10000, 1),
(14930, 254, 168, 'North Bend', 10000, 1),
(14931, 254, 126, 'Anderson', 10000, 1),
(14932, 254, 159, 'Myrtle Creek', 10000, 1),
(14933, 95, 1932, 'Serres', 10000, 1),
(14934, 233, 4010, 'Svanesund', 10000, 1),
(14935, 175, 2980, 'Aarle-Rixtel', 10000, 1),
(14936, 233, 4010, 'Kung', 10000, 1),
(14937, 233, 3998, 'Boden', 10000, 1),
(14938, 109, 646, 'Hong Kong', 10000, 1),
(14939, 254, 135, 'Somonauk', 10000, 1),
(14940, 254, 162, 'Central', 10000, 1),
(14941, 233, 4010, 'Stenungsund', 10000, 1),
(14943, 254, 144, 'Carsonville', 10000, 1),
(14944, 254, 144, 'Lawrence', 10000, 1),
(14945, 254, 157, 'Homeworth', 10000, 1),
(14946, 18, 1085, 'Ar Rifa', 10000, 1),
(14947, 48, 1364, 'Llay-Llay', 10000, 1),
(14948, 175, 2977, 'Harderwijk', 10000, 1),
(14949, 159, 2889, 'Metepec', 10000, 1),
(14950, 254, 154, 'Ancramdale', 10000, 1),
(14951, 65, 1500, 'Vonge', 10000, 1),
(14952, 254, 154, 'Stanfordville', 10000, 1),
(14954, 118, 2235, 'Hadera', 10000, 1),
(14956, 152, 689, 'Sliema', 10000, 1),
(14957, 43, 35, 'Entrelacs', 10000, 1),
(14958, 254, 166, 'Toquerville', 10000, 1),
(14959, 91, 1917, 'Wagenhoff', 10000, 1),
(14960, 53, 1427, 'Santaf', 10000, 1),
(14961, 254, 164, 'Newbern', 10000, 1),
(14962, 43, 37, 'Englehart', 10000, 1),
(14963, 185, 3002, 'N', 10000, 1),
(14966, 254, 157, 'West Salem', 10000, 1),
(14967, 254, 168, 'Arlington', 10000, 1),
(14968, 254, 158, 'skiatook', 10000, 1),
(14969, 254, 170, 'Prescott', 10000, 1),
(14970, 254, 160, 'Stewartstown', 10000, 1),
(14971, 254, 123, 'Klawock', 10000, 1),
(14972, 254, 153, 'Edgewood', 10000, 1),
(14974, 226, 3935, 'Badalona', 10000, 1),
(14976, 254, 145, 'West Concord', 10000, 1),
(14977, 254, 145, 'Kasson', 10000, 1),
(14978, 254, 165, 'Newark', 10000, 1),
(14980, 254, 159, 'Saint Helens', 10000, 1),
(14982, 254, 135, 'Rockton', 10000, 1),
(14983, 254, 165, 'Rhome', 10000, 1),
(14984, 14, 3, 'Caboolture', 10000, 1),
(14985, 119, 2249, 'Acqui Terme', 10000, 1),
(14986, 91, 1913, 'Utting', 10000, 1),
(14987, 113, 2170, 'Tezpur', 10000, 1),
(14988, 254, 143, 'Shrewsbury', 10000, 1),
(14989, 254, 152, 'Pittstown', 10000, 1),
(14990, 254, 126, 'Garberville', 10000, 1),
(14991, 254, 142, 'Leitersburg', 10000, 1),
(14992, 43, 43, 'New Westminster', 10000, 1),
(14993, 91, 1912, 'Altdorf', 10000, 1),
(14994, 254, 149, 'Wauneta', 10000, 1),
(14998, 254, 159, 'Allegany', 10000, 1),
(14999, 253, 5392, 'Hertford', 10000, 1),
(15002, 119, 2249, 'Biella', 10000, 1),
(15003, 15, 1075, 'Neud', 10000, 1),
(15004, 234, 4042, 'Haerkingen', 10000, 1),
(15005, 82, 1814, 'Blotzheim', 10000, 1),
(15006, 24, 5305, 'Nivelles', 10000, 1),
(15007, 74, 611, 'Taiping', 10000, 1),
(15008, 254, 152, 'Basking Ridge', 10000, 1),
(15009, 254, 160, 'Irwin', 10000, 1),
(15010, 254, 140, 'Mandeville', 10000, 1),
(15011, 253, 5392, 'Louth', 10000, 1),
(15012, 254, 126, 'Capitola', 10000, 1),
(15014, 254, 145, 'Glenville', 10000, 1),
(15015, 254, 131, 'Clermont', 10000, 1),
(15016, 233, 3986, 'Karlshamn', 10000, 1),
(15017, 254, 145, 'Medford', 10000, 1),
(15018, 61, 5036, 'Krk', 10000, 1),
(15019, 254, 152, 'Eatontown', 10000, 1),
(15020, 254, 160, 'Amity', 10000, 1),
(15022, 119, 2244, 'Latina', 10000, 1),
(15023, 43, 35, 'Macamic', 10000, 1),
(15024, 43, 35, 'La Sarre', 10000, 1),
(15025, 43, 35, 'Rouyn-Noranda', 10000, 1),
(15026, 254, 144, 'Brooklyn', 10000, 1),
(15029, 43, 35, 'Amqui', 10000, 1),
(15030, 254, 126, 'Diamond Springs', 10000, 1),
(15031, 119, 2246, 'Lissone', 10000, 1),
(15032, 65, 1489, 'Odder', 10000, 1),
(15033, 197, 3284, 'Gda', 10000, 1),
(15034, 254, 131, 'Grayton Beach', 10000, 1),
(15035, 253, 5392, 'Loughborough', 10000, 1),
(15036, 43, 37, 'Iroquois Falls', 10000, 1),
(15037, 254, 136, 'Ellettsville', 10000, 1),
(15038, 254, 136, 'Cromwell', 10000, 1),
(15039, 254, 154, 'Bloomingburg', 10000, 1),
(15040, 254, 133, 'Naalehu', 10000, 1),
(15041, 254, 154, 'Pleasantville', 10000, 1),
(15042, 254, 154, 'Houghton', 10000, 1),
(15045, 254, 145, 'Gilbert', 10000, 1),
(15046, 175, 2984, 'Aagtekerke', 10000, 1),
(15048, 24, 1136, 'Oudenaarde', 10000, 1),
(15049, 254, 138, 'Gardner', 10000, 1),
(15050, 254, 160, 'Broad Top', 10000, 1),
(15051, 254, 152, 'Edgewater', 10000, 1),
(15052, 254, 131, 'Cape Canaveral', 10000, 1),
(15054, 254, 157, 'Lodi', 10000, 1),
(15055, 226, 3910, 'San Pedro del Pinatar', 10000, 1),
(15056, 254, 144, 'Hazel Park', 10000, 1),
(15057, 254, 168, 'Ione', 10000, 1),
(15058, 224, 3684, 'Randburg', 10000, 1),
(15059, 254, 155, 'Hot Springs', 10000, 1),
(15060, 254, 144, 'Bangor', 10000, 1),
(15061, 61, 5027, 'Orebic', 10000, 1),
(15062, 254, 126, 'Comptche', 10000, 1),
(15063, 175, 2989, 'Emmeloord', 10000, 1),
(15065, 254, 152, 'New Providence', 10000, 1),
(15067, 195, 3505, 'Para', 10000, 1),
(15069, 26, 1198, 'Cotonou', 10000, 1),
(15071, 254, 160, 'Catasauqua', 10000, 1),
(15072, 254, 131, 'Plantation Acres', 10000, 1),
(15073, 43, 43, 'Squamish', 10000, 1),
(15074, 254, 168, 'Malaga', 10000, 1),
(15075, 254, 160, 'Manheim', 10000, 1),
(15076, 254, 128, 'Coventry', 10000, 1),
(15077, 254, 141, 'Yarmouth', 10000, 1),
(15078, 254, 128, 'Glastonbury', 10000, 1),
(15079, 254, 140, 'Vivian', 10000, 1),
(15080, 253, 5392, 'Norwich', 10000, 1),
(15081, 254, 154, 'Horseheads', 10000, 1),
(15082, 253, 5392, 'Bedford', 10000, 1),
(15083, 254, 168, 'Grand Coulee', 10000, 1),
(15084, 254, 165, 'Keller', 10000, 1),
(15085, 254, 122, 'Aliceville', 10000, 1),
(15086, 254, 126, 'Newhall', 10000, 1),
(15087, 254, 160, 'Mechanicsburg', 10000, 1),
(15088, 119, 2242, 'Guastalla', 10000, 1),
(15089, 195, 3434, 'San Fernando', 10000, 1),
(15091, 14, 4, 'Dural', 10000, 1),
(15093, 43, 35, 'Sainte-Foy', 10000, 1),
(15094, 254, 166, 'Morgan', 10000, 1),
(15095, 254, 144, 'Grand Blanc', 10000, 1),
(15096, 254, 168, 'Davenport', 10000, 1),
(15097, 254, 168, 'Sprague', 10000, 1),
(15099, 175, 2981, 'Laren', 10000, 1),
(15100, 178, 4706, 'Waitakere', 10000, 1),
(15101, 175, 2977, 'Neede', 10000, 1),
(15102, 254, 138, 'Cottonwood Falls', 10000, 1),
(15103, 254, 154, 'Hurleyville', 10000, 1),
(15105, 254, 144, 'Rogers City', 10000, 1),
(15106, 254, 122, 'Oxford', 10000, 1),
(15107, 254, 131, 'Zolfo Springs', 10000, 1),
(15108, 254, 165, 'Pilot Point', 10000, 1),
(15109, 254, 165, 'Brazoria', 10000, 1),
(15113, 254, 131, 'Bowling Green', 10000, 1),
(15114, 254, 132, 'Roopville', 10000, 1),
(15115, 254, 154, 'Rensselaer', 10000, 1),
(15116, 254, 155, 'Wake Forest', 10000, 1),
(15117, 254, 165, 'Yantis', 10000, 1),
(15118, 254, 122, 'Catherine', 10000, 1),
(15120, 226, 3939, 'Benicasim', 10000, 1),
(15121, 226, 3939, 'Vistabella del Maestrazgo', 10000, 1),
(15123, 226, 3939, 'Castell', 10000, 1),
(15124, 226, 3939, 'Oropesa', 10000, 1),
(15125, 226, 3939, 'Alcora', 10000, 1),
(15127, 254, 122, 'Furman', 10000, 1),
(15128, 254, 162, 'Edgemoor', 10000, 1),
(15129, 254, 152, 'Totowa', 10000, 1),
(15130, 118, 2236, 'Bat Yam', 10000, 1),
(15131, 202, 3380, 'Iasi', 10000, 1),
(15133, 254, 159, 'Vale', 10000, 1),
(15134, 254, 170, 'De Soto', 10000, 1),
(15136, 119, 2246, 'Treviglio', 10000, 1),
(15137, 254, 122, 'Florala', 10000, 1),
(15138, 254, 165, 'Kilgore', 10000, 1),
(15139, 254, 160, 'Mars', 10000, 1),
(15140, 254, 159, 'Butte Falls', 10000, 1),
(15141, 254, 126, 'Cassel', 10000, 1),
(15143, 43, 43, 'Cumberland', 10000, 1),
(15144, 254, 139, 'Berea', 10000, 1),
(15145, 254, 144, 'Dexter', 10000, 1),
(15146, 254, 142, 'Joppa', 10000, 1),
(15147, 254, 122, 'Centre', 10000, 1),
(15148, 14, 3, 'Southport', 10000, 1),
(15149, 82, 1813, 'Saint-Etienne', 10000, 1),
(15151, 254, 147, 'King City', 10000, 1),
(15152, 254, 126, 'Panorama City', 10000, 1),
(15153, 195, 3414, 'Naga City', 10000, 1),
(15154, 221, 3713, 'Celje', 10000, 1),
(15155, 254, 127, 'New Castle', 10000, 1),
(15156, 254, 153, 'Jemez Springs', 10000, 1),
(15157, 254, 135, 'Morton', 10000, 1),
(15158, 178, 4706, 'North Shore', 10000, 1),
(15160, 233, 4002, 'Flen', 10000, 1),
(15161, 254, 137, 'Holstein', 10000, 1),
(15162, 254, 136, 'Grovertown', 10000, 1),
(15163, 242, 4144, 'Nukualofa', 10000, 1),
(15164, 254, 160, 'Glenside', 10000, 1),
(15165, 254, 126, 'Calistoga', 10000, 1),
(15166, 254, 145, 'Jeffers', 10000, 1),
(15168, 254, 135, 'Frankfort', 10000, 1),
(15169, 254, 155, 'Lattimore', 10000, 1),
(15170, 14, 4, 'Nelson Bay', 10000, 1),
(15172, 82, 1808, 'Hondschoote', 10000, 1),
(15175, 254, 155, 'Rutherfordton', 10000, 1),
(15176, 149, 2907, 'Cyberjaya', 10000, 1),
(15178, 254, 122, 'Trussville', 10000, 1),
(15179, 254, 170, 'Kohler', 10000, 1),
(15180, 254, 129, 'New Castle', 10000, 1),
(15181, 253, 5392, 'Millom', 10000, 1),
(15183, 254, 137, 'Solon', 10000, 1),
(15185, 119, 2247, 'Ascoli Piceno', 10000, 1),
(15186, 254, 168, 'Eatonville', 10000, 1),
(15187, 233, 3998, 'Kalix', 10000, 1),
(15188, 8, 4761, 'Reading', 10000, 1),
(15189, 224, 3684, 'Alberton', 10000, 1),
(15190, 254, 167, 'Richlands', 10000, 1),
(15191, 254, 126, 'Forestville', 10000, 1),
(15192, 254, 133, 'Ewa Beach', 10000, 1),
(15193, 234, 4029, 'Arch', 10000, 1),
(15194, 254, 161, 'Warren', 10000, 1),
(15195, 43, 37, 'Bowmanville', 10000, 1),
(15196, 254, 165, 'Belton', 10000, 1),
(15197, 119, 2250, 'Taranto', 10000, 1),
(15199, 254, 160, 'Darby', 10000, 1),
(15200, 199, 736, 'Rio Grande', 10000, 1),
(15204, 254, 131, 'Lutz', 10000, 1),
(15205, 254, 158, 'Seminole', 10000, 1),
(15206, 122, 2329, 'Nagareyama', 10000, 1),
(15207, 10, 1055, 'Villa Mar', 10000, 1),
(15208, 254, 144, 'Fair Haven', 10000, 1),
(15209, 254, 172, 'Bennington', 10000, 1),
(15210, 119, 2243, 'Pordenone', 10000, 1),
(15211, 254, 165, 'Bridgeport', 10000, 1),
(15212, 254, 155, 'Beaufort', 10000, 1),
(15213, 119, 2238, 'Chieti', 10000, 1),
(15214, 254, 160, 'Brookhaven', 10000, 1),
(15215, 43, 38, 'Plumas', 10000, 1),
(15216, 254, 151, 'Gilmanton', 10000, 1),
(15219, 43, 37, 'Hearst', 10000, 1),
(15220, 254, 154, 'Locust Valley', 10000, 1),
(15221, 118, 2232, 'Dimona', 10000, 1),
(15223, 254, 145, 'Wabasso', 10000, 1),
(15224, 254, 157, 'West Chester', 10000, 1),
(15225, 233, 4002, 'Trosa', 10000, 1),
(15227, 254, 144, 'Spring Lake', 10000, 1),
(15228, 175, 2982, 'Deventer', 10000, 1),
(15229, 254, 144, 'Nunica', 10000, 1),
(15230, 99, 636, 'Mangilao', 10000, 1),
(15231, 254, 148, 'Troy', 10000, 1),
(15232, 254, 136, 'Butlerville', 10000, 1),
(15233, 254, 152, 'Browns Mills', 10000, 1),
(15234, 43, 38, 'Selkirk', 10000, 1),
(15235, 254, 159, 'Philomath', 10000, 1),
(15236, 254, 168, 'Long Beach', 10000, 1),
(15237, 43, 37, 'Sioux Lookout', 10000, 1),
(15238, 43, 39, 'Antigonish', 10000, 1),
(15239, 254, 160, 'Delmont', 10000, 1),
(15240, 254, 122, 'Sulligent', 10000, 1),
(15241, 254, 131, 'Niceville', 10000, 1),
(15243, 43, 35, 'Saint Jean sur Richelieu', 10000, 1),
(15244, 254, 144, 'Brighton', 10000, 1),
(15245, 178, 3126, 'Gore', 10000, 1),
(15246, 234, 4047, 'Payerne', 10000, 1),
(15248, 254, 136, 'Morocco', 10000, 1),
(15249, 254, 148, 'Townsend', 10000, 1),
(15251, 43, 35, 'Saint-J', 10000, 1),
(15252, 33, 24, 'Bragan', 10000, 1),
(15253, 254, 157, 'West Liberty', 10000, 1),
(15254, 254, 122, 'Linden', 10000, 1),
(15256, 254, 147, 'Cottleville', 10000, 1),
(15257, 254, 124, 'Surprise', 10000, 1),
(15258, 233, 4009, 'Malm', 10000, 1),
(15259, 254, 164, 'Orlinda', 10000, 1),
(15260, 233, 3987, 'Hudiksvall', 10000, 1),
(15261, 254, 144, 'Hudsonville', 10000, 1),
(15262, 149, 2897, 'Kluang', 10000, 1),
(15263, 117, 1600, 'Letterkenny', 10000, 1),
(15265, 254, 145, 'Paynesville', 10000, 1),
(15267, 254, 127, 'Minturn', 10000, 1),
(15268, 33, 16, 'Sao Miguel dos Campos', 10000, 1),
(15269, 254, 154, 'Climax', 10000, 1),
(15270, 254, 167, 'Ferrum', 10000, 1),
(15272, 254, 151, 'Conway', 10000, 1),
(15273, 233, 4009, 'H', 10000, 1),
(15274, 43, 37, 'Chelmsford', 10000, 1),
(15275, 24, 1129, 'Herentals', 10000, 1),
(15276, 119, 2246, 'Voghera', 10000, 1),
(15277, 187, 3217, 'Quetta', 10000, 1),
(15278, 254, 126, 'Gualala', 10000, 1),
(15279, 187, 3219, 'sialkot', 10000, 1),
(15280, 43, 43, 'Merritt', 10000, 1),
(15282, 43, 43, 'Richmond', 10000, 1),
(15284, 254, 132, 'Pine Lake', 10000, 1),
(15285, 254, 165, 'Trenton', 10000, 1),
(15286, 149, 2898, 'Sungai Petani', 10000, 1),
(15287, 133, 2432, 'Kunp''o', 10000, 1),
(15288, 119, 2245, 'Albenga', 10000, 1),
(15289, 253, 5392, 'Runcorn', 10000, 1),
(15290, 81, 4879, 'Sipoo', 10000, 1),
(15291, 233, 4000, 'Valdemarsvik', 10000, 1),
(15292, 254, 165, 'Bulverde', 10000, 1),
(15293, 226, 3939, 'Burriana', 10000, 1),
(15294, 254, 165, 'Trinity', 10000, 1),
(15295, 226, 3938, 'Getxo', 10000, 1),
(15296, 254, 170, 'Mason', 10000, 1),
(15300, 254, 144, 'Frankenmuth', 10000, 1),
(15302, 253, 5392, 'Hereford', 10000, 1),
(15303, 212, 4168, 'Sao Tome', 10000, 1),
(15304, 254, 152, 'Keansburg', 10000, 1),
(15305, 197, 3285, 'Tychy', 10000, 1),
(15307, 254, 165, 'Sundown', 10000, 1),
(15308, 254, 152, 'West Creek', 10000, 1),
(15309, 254, 138, 'Valley Center', 10000, 1),
(15310, 254, 160, 'Weston', 10000, 1),
(15311, 254, 168, 'Woodinville', 10000, 1),
(15313, 224, 3680, 'Eshowe', 10000, 1),
(15314, 254, 167, 'Stephens City', 10000, 1),
(15315, 254, 126, 'Emeryville', 10000, 1),
(15317, 10, 1061, 'Santa Rosa', 10000, 1),
(15318, 91, 1919, 'Frankenthal', 10000, 1),
(15320, 254, 129, 'Milford', 10000, 1),
(15321, 254, 132, 'Willacoochee', 10000, 1),
(15323, 254, 143, 'Athol', 10000, 1),
(15324, 254, 135, 'Troy', 10000, 1),
(15326, 254, 139, 'Walton', 10000, 1),
(15327, 43, 37, 'Cobourg', 10000, 1),
(15328, 254, 125, 'Maumelle', 10000, 1),
(15329, 254, 138, 'Rose Hill', 10000, 1),
(15331, 254, 157, 'Plumwood', 10000, 1),
(15332, 14, 1, 'Deer Park', 10000, 1),
(15333, 198, 3311, 'Queluz', 10000, 1),
(15334, 254, 126, 'Loomis', 10000, 1),
(15335, 254, 126, 'Cardiff by the Sea', 10000, 1),
(15337, 254, 147, 'Excelsior Springs', 10000, 1),
(15338, 254, 151, 'North Conway', 10000, 1),
(15339, 254, 141, 'Grand Lake Stream', 10000, 1),
(15341, 43, 35, 'Becancour', 10000, 1),
(15342, 254, 122, 'Gurley', 10000, 1),
(15343, 254, 122, 'Montrose', 10000, 1),
(15344, 254, 147, 'Peculiar', 10000, 1),
(15346, 48, 1364, 'Vi', 10000, 1),
(15347, 43, 43, 'Salmon Arm', 10000, 1),
(15348, 152, 689, 'Cospicua', 10000, 1),
(15351, 91, 1912, 'Wertheim', 10000, 1),
(15353, 254, 145, 'Cosmos', 10000, 1),
(15354, 254, 135, 'Peru', 10000, 1),
(15355, 65, 1494, 'Saltum', 10000, 1),
(15356, 226, 3935, 'Sentmenat', 10000, 1),
(15357, 254, 136, 'Lowell', 10000, 1),
(15358, 10, 1054, 'Puerto Madryn', 10000, 1),
(15359, 43, 36, 'Ponoka', 10000, 1),
(15362, 254, 140, 'Youngsville', 10000, 1),
(15363, 43, 42, 'Riverview', 10000, 1),
(15364, 43, 41, 'Labrador City', 10000, 1),
(15365, 254, 144, 'Davison', 10000, 1),
(15366, 117, 1621, 'Wicklow', 10000, 1),
(15367, 254, 128, 'Stafford Springs', 10000, 1),
(15368, 233, 3994, 'Ludvika', 10000, 1),
(15369, 82, 1803, 'Coubert', 10000, 1),
(15370, 185, 2997, '', 10000, 1),
(15371, 185, 2997, 'Engav', 10000, 1),
(15372, 254, 141, 'Fairfield', 10000, 1),
(15373, 254, 145, 'Melrose', 10000, 1),
(15375, 254, 159, 'Boring', 10000, 1),
(15376, 119, 2251, 'La Maddalena', 10000, 1),
(15377, 253, 5392, 'Dorking', 10000, 1),
(15378, 254, 155, 'Pfafftown', 10000, 1),
(15379, 226, 3939, 'Alicante', 10000, 1),
(15380, 254, 144, 'Shelby', 10000, 1),
(15381, 254, 144, 'Linden', 10000, 1),
(15382, 122, 2337, 'Fukagawa', 10000, 1),
(15383, 119, 2254, 'Merano', 10000, 1),
(15384, 254, 165, 'Winnie', 10000, 1),
(15386, 185, 3001, 'Halden', 10000, 1),
(15387, 14, 6, 'Dongara', 10000, 1),
(15388, 254, 145, 'Round Lake', 10000, 1),
(15392, 254, 154, 'Lakewood', 10000, 1),
(15393, 254, 157, 'Arcanum', 10000, 1),
(15394, 254, 160, 'Archbald', 10000, 1),
(15395, 254, 141, 'Presque Isle', 10000, 1),
(15396, 43, 43, 'Crofton', 10000, 1),
(15397, 254, 140, 'Westwego', 10000, 1),
(15398, 254, 154, 'Jackson Heights', 10000, 1),
(15399, 43, 36, 'Standard', 10000, 1),
(15400, 48, 1367, 'Temuco', 10000, 1),
(15401, 48, 1375, 'Isla De Maipo', 10000, 1),
(15402, 43, 37, 'Edys Mills', 10000, 1),
(15403, 254, 160, 'Coopersburg', 10000, 1),
(15404, 159, 69, 'Allende', 10000, 1),
(15405, 24, 1137, 'Brugge', 10000, 1),
(15406, 254, 144, 'Corunna', 10000, 1),
(15407, 15, 1080, 'Kindberg', 10000, 1),
(15408, 254, 136, 'Cedar Lake', 10000, 1),
(15409, 254, 152, 'Cranbury', 10000, 1),
(15410, 253, 5392, 'Crewe', 10000, 1),
(15411, 254, 138, 'Louisburg', 10000, 1),
(15412, 233, 3987, 'Hofors', 10000, 1),
(15413, 149, 2908, 'Dungun', 10000, 1),
(15414, 226, 3931, 'Teruel', 10000, 1),
(15415, 254, 122, 'Lexington', 10000, 1),
(15416, 43, 43, 'Port Moody', 10000, 1),
(15417, 133, 2432, 'Osan', 10000, 1),
(15418, 254, 142, 'Deale', 10000, 1),
(15419, 14, 4, 'Ballina', 10000, 1),
(15420, 65, 1500, 'Jelling', 10000, 1),
(15422, 253, 5392, 'Oxshott', 10000, 1),
(15423, 119, 2243, 'Maniago', 10000, 1),
(15424, 82, 1812, 'Beauvezer', 10000, 1),
(15425, 253, 5389, 'Lampeter', 10000, 1),
(15426, 233, 3999, 'Fr', 10000, 1),
(15427, 254, 144, 'Gowen', 10000, 1),
(15428, 254, 142, 'Upper Marlboro', 10000, 1),
(15429, 14, 1, 'Wodonga', 10000, 1),
(15431, 254, 170, 'Big Bend', 10000, 1),
(15433, 254, 152, 'Kendall Park', 10000, 1),
(15434, 175, 2977, 'Culemborg', 10000, 1),
(15435, 254, 168, 'Cosmopolis', 10000, 1),
(15436, 254, 160, 'Sewickley', 10000, 1),
(15437, 65, 1501, 'Skive', 10000, 1),
(15440, 254, 154, 'Westfield', 10000, 1),
(15441, 185, 2997, 'Bronnoysund', 10000, 1),
(15442, 33, 15, 'S', 10000, 1),
(15444, 254, 158, 'Chattanooga', 10000, 1),
(15445, 224, 3686, 'Loxton', 10000, 1),
(15446, 254, 154, 'Cherry Valley', 10000, 1),
(15448, 254, 125, 'Judsonia', 10000, 1),
(15449, 254, 136, 'Fort Branch', 10000, 1),
(15451, 43, 35, 'Shawinigan', 10000, 1),
(15452, 118, 2232, 'Kiryat Gat', 10000, 1),
(15453, 254, 152, 'Highland Lakes', 10000, 1),
(15454, 33, 30, 'Crici', 10000, 1),
(15455, 254, 141, 'Monmouth', 10000, 1),
(15456, 146, 5208, 'Ohrid', 10000, 1),
(15457, 254, 167, 'Callaway', 10000, 1),
(15458, 82, 1804, 'Carcassonne', 10000, 1),
(15459, 254, 136, 'Peru', 10000, 1),
(15460, 10, 1051, 'Miramar', 10000, 1),
(15461, 117, 1619, 'Athlone', 10000, 1),
(15462, 254, 131, 'High Springs', 10000, 1),
(15463, 175, 2980, 'Terheijden', 10000, 1),
(15464, 254, 170, 'Rewey', 10000, 1),
(15467, 15, 1076, 'Klagenfurt', 10000, 1),
(15468, 254, 157, 'Covington', 10000, 1),
(15469, 93, 630, 'Gibraltar', 10000, 1),
(15470, 254, 165, 'Wylie', 10000, 1),
(15471, 119, 2257, 'Castelfranco Veneto', 10000, 1),
(15473, 254, 124, 'Marana', 10000, 1),
(15475, 43, 36, 'Coaldale', 10000, 1),
(15476, 254, 172, 'Essex Junction', 10000, 1),
(15478, 91, 1918, 'Wuppertal', 10000, 1),
(15480, 43, 37, 'Bradford', 10000, 1),
(15482, 43, 35, 'Lebel-sur-Quevillon', 10000, 1),
(15483, 10, 1051, 'San Isidro', 10000, 1),
(15484, 43, 37, 'Sauble Beach', 10000, 1),
(15485, 254, 166, 'Magna', 10000, 1),
(15487, 254, 135, 'Mason City', 10000, 1),
(15488, 254, 138, 'Bogue', 10000, 1),
(15489, 254, 136, 'Aurora', 10000, 1),
(15491, 254, 135, 'Montrose', 10000, 1),
(15492, 254, 157, 'Tallmadge', 10000, 1),
(15493, 254, 154, 'Dansville', 10000, 1),
(15494, 43, 36, 'Sherwood Park', 10000, 1),
(15495, 254, 128, 'Gales Ferry', 10000, 1),
(15496, 254, 165, 'Nederland', 10000, 1),
(15498, 119, 2248, 'Campobasso', 10000, 1),
(15501, 254, 162, 'Pelzer', 10000, 1),
(15502, 254, 152, 'Beachwood', 10000, 1),
(15503, 254, 167, 'Rocky Gap', 10000, 1),
(15504, 254, 134, 'American Falls', 10000, 1),
(15507, 254, 170, 'Juneau', 10000, 1),
(15508, 113, 2182, 'Thane', 10000, 1),
(15509, 81, 1779, 'N', 10000, 1),
(15510, 254, 123, 'North Pole', 10000, 1),
(15511, 64, 5131, 'Plzen', 10000, 1),
(15512, 254, 144, 'Berrien Springs', 10000, 1),
(15513, 81, 5023, 'Kannus', 10000, 1),
(15514, 253, 5392, 'Berkhamsted', 10000, 1),
(15515, 114, 2159, 'Batam', 10000, 1),
(15517, 119, 2249, 'Burolo', 10000, 1),
(15518, 253, 5391, 'Loughgall', 10000, 1),
(15519, 202, 3375, 'Galati', 10000, 1),
(15521, 254, 160, 'Wattsburg', 10000, 1),
(15522, 253, 5392, 'Ripon', 10000, 1),
(15523, 226, 3938, 'Basauri', 10000, 1),
(15524, 91, 1912, 'Rottenburg', 10000, 1),
(15525, 149, 2907, 'Dengkil', 10000, 1),
(15526, 254, 122, 'Alabaster', 10000, 1),
(15527, 254, 154, 'Tarrytown', 10000, 1),
(15529, 43, 37, 'Parry Sound', 10000, 1),
(15530, 254, 152, 'Northvale', 10000, 1),
(15531, 254, 124, 'Vail', 10000, 1),
(15534, 254, 145, 'Sauk Centre', 10000, 1),
(15535, 254, 160, 'Hyde', 10000, 1),
(15536, 254, 126, 'Dorris', 10000, 1),
(15537, 254, 157, 'Holgate', 10000, 1),
(15538, 254, 152, 'Moorestown', 10000, 1),
(15539, 65, 1494, 'Hobro', 10000, 1),
(15542, 82, 1794, 'Le Cendre', 10000, 1),
(15545, 224, 3684, 'Vereeniging', 10000, 1),
(15547, 254, 144, 'Newaygo', 10000, 1),
(15550, 254, 157, 'Killbuck', 10000, 1),
(15551, 253, 5389, 'Pontypridd', 10000, 1),
(15552, 65, 1494, 'Aalestrup', 10000, 1),
(15553, 253, 5392, 'Harlow', 10000, 1),
(15554, 254, 165, 'Fort Davis', 10000, 1),
(15555, 254, 166, 'Lehi', 10000, 1),
(15556, 254, 142, 'Friendsville', 10000, 1),
(15557, 15, 1077, 'M', 10000, 1),
(15558, 254, 154, 'Irvington', 10000, 1),
(15559, 254, 145, 'Waconia', 10000, 1),
(15560, 10, 1051, 'Ramos Mejia', 10000, 1),
(15561, 48, 1371, 'San Fernando', 10000, 1),
(15562, 254, 146, 'Southaven', 10000, 1),
(15563, 59, 1434, 'S', 10000, 1),
(15564, 43, 37, 'Georgetown', 10000, 1),
(15565, 133, 2426, 'Chongju', 10000, 1),
(15566, 254, 155, 'Buxton', 10000, 1),
(15567, 137, 2518, 'Ventspils', 10000, 1),
(15568, 137, 2511, 'Jurmala', 10000, 1),
(15569, 82, 1803, 'Sevres', 10000, 1),
(15570, 185, 3003, 'Sogndal', 10000, 1),
(15571, 226, 3935, 'Tarrasa', 10000, 1),
(15572, 149, 2911, 'Beaufort', 10000, 1),
(15574, 119, 2247, 'Pesaro', 10000, 1),
(15575, 254, 160, 'Morrisville', 10000, 1),
(15576, 14, 1, 'Portland', 10000, 1),
(15577, 149, 2906, 'Sri Aman', 10000, 1),
(15578, 43, 43, 'Aldergrove', 10000, 1),
(15579, 159, 206, 'Juan Aldama', 10000, 1),
(15581, 59, 1438, 'Tibas', 10000, 1),
(15582, 254, 126, 'Mission Hills', 10000, 1),
(15583, 152, 689, 'Paola', 10000, 1),
(15584, 254, 136, 'Milan', 10000, 1),
(15585, 254, 160, 'Donora', 10000, 1),
(15586, 254, 144, 'Algonac', 10000, 1),
(15587, 254, 165, 'Port Neches', 10000, 1),
(15589, 43, 37, 'Wasaga Beach', 10000, 1),
(15591, 254, 165, 'Blessing', 10000, 1),
(15592, 254, 126, 'Penn Valley', 10000, 1),
(15595, 254, 137, 'Camanche', 10000, 1),
(15596, 24, 1133, 'Kinrooi', 10000, 1),
(15597, 175, 2984, 'Renesse', 10000, 1),
(15598, 175, 2984, 'Zierikzee', 10000, 1),
(15599, 254, 165, 'El Campo', 10000, 1),
(15600, 81, 4879, 'Lohja', 10000, 1),
(15601, 254, 135, 'Lebanon', 10000, 1),
(15602, 91, 1918, 'Solingen', 10000, 1),
(15604, 91, 1913, 'Steinach', 10000, 1),
(15605, 91, 1926, 'Steinach', 10000, 1),
(15606, 254, 154, 'Elmhurst', 10000, 1),
(15607, 254, 162, 'Laurens', 10000, 1),
(15608, 91, 1913, 'Neuburg', 10000, 1),
(15609, 91, 1917, 'Meppen', 10000, 1),
(15610, 233, 4007, 'Sala', 10000, 1),
(15611, 254, 126, 'Valley Springs', 10000, 1),
(15612, 254, 156, 'Colfax', 10000, 1),
(15613, 234, 4046, 'Sion', 10000, 1),
(15614, 48, 1371, 'San Vicente De Tagua Tagua', 10000, 1),
(15615, 43, 37, 'Prescott', 10000, 1),
(15616, 15, 1077, 'Neulengbach', 10000, 1),
(15617, 254, 135, 'Bunker Hill', 10000, 1),
(15619, 254, 141, 'Windham', 10000, 1),
(15620, 254, 147, 'Reeds Spring', 10000, 1),
(15621, 254, 124, 'Mohave Valley', 10000, 1),
(15622, 254, 132, 'Mineral Bluff', 10000, 1),
(15623, 81, 5022, 'Juuka', 10000, 1),
(15625, 254, 138, 'Plainville', 10000, 1),
(15626, 254, 170, 'Watertown', 10000, 1),
(15628, 61, 5035, 'Nasice', 10000, 1),
(15629, 254, 135, 'Oswego', 10000, 1),
(15631, 254, 159, 'Rickreall', 10000, 1),
(15632, 254, 145, 'Randolph', 10000, 1),
(15633, 254, 166, 'East Carbon', 10000, 1),
(15634, 254, 122, 'Lillian', 10000, 1),
(15636, 254, 142, 'Fort Washington', 10000, 1),
(15637, 254, 147, 'Wheeling', 10000, 1),
(15638, 254, 155, 'Spencer', 10000, 1),
(15639, 254, 167, 'Crewe', 10000, 1),
(15641, 254, 135, 'Palestine', 10000, 1),
(15642, 175, 2981, 'Julianadorp', 10000, 1),
(15644, 254, 124, 'Queen Creek', 10000, 1),
(15645, 14, 4, 'Bondi', 10000, 1),
(15646, 254, 141, 'Bristol', 10000, 1),
(15647, 254, 159, 'Lebanon', 10000, 1),
(15648, 236, 4275, 'Taoyuan', 10000, 1),
(15649, 254, 131, 'Saint Cloud', 10000, 1),
(15650, 14, 2, 'Wynyard', 10000, 1),
(15651, 254, 170, 'Solon Springs', 10000, 1),
(15652, 254, 146, 'Madison', 10000, 1),
(15653, 43, 42, 'Richibucto', 10000, 1),
(15654, 113, 2188, 'Pondicherry', 10000, 1),
(15656, 203, 3601, 'Sredneural''sk', 10000, 1),
(15658, 254, 135, 'Prairie du Rocher', 10000, 1),
(15659, 254, 152, 'Rochelle Park', 10000, 1),
(15660, 254, 132, 'Saint Marys', 10000, 1),
(15661, 254, 122, 'Wetumpka', 10000, 1),
(15662, 254, 168, 'Mead', 10000, 1),
(15663, 43, 37, 'Dundalk', 10000, 1),
(15664, 164, 701, 'Monaco', 10000, 1),
(15665, 75, 1633, 'J', 10000, 1),
(15666, 254, 131, 'Orange City', 10000, 1),
(15667, 254, 151, 'Exeter', 10000, 1),
(15669, 95, 1951, 'Volos', 10000, 1),
(15670, 91, 1913, 'Neustadt', 10000, 1),
(15671, 95, 1951, 'Agria', 10000, 1),
(15674, 254, 152, 'Succasunna', 10000, 1),
(15675, 254, 144, 'Mayville', 10000, 1),
(15676, 254, 154, 'Sag Harbor', 10000, 1),
(15677, 254, 129, 'Bethany Beach', 10000, 1),
(15678, 254, 172, 'Chester', 10000, 1),
(15679, 226, 3932, 'Santa Cruz de Tenerife', 10000, 1),
(15680, 254, 167, 'Fort Belvoir', 10000, 1),
(15681, 33, 27, 'Vi', 10000, 1),
(15682, 233, 4009, 'Bj', 10000, 1),
(15683, 254, 165, 'Spring Branch', 10000, 1),
(15684, 81, 1777, 'Kemij', 10000, 1),
(15685, 49, 1340, 'Daqing', 10000, 1),
(15686, 254, 160, 'Bangor', 10000, 1),
(15687, 254, 146, 'Moss Point', 10000, 1),
(15689, 254, 155, 'Lansing', 10000, 1),
(15690, 254, 144, 'Alanson', 10000, 1),
(15692, 91, 1913, 'Bad Neustadt', 10000, 1),
(15693, 126, 2394, 'Irbid', 10000, 1),
(15696, 159, 69, 'San Nicolas de los Garza', 10000, 1),
(15697, 254, 166, 'American Fork', 10000, 1),
(15698, 233, 3987, 'Alfta', 10000, 1),
(15699, 33, 24, 'Piracicaba', 10000, 1),
(15700, 198, 3307, 'Quarteira', 10000, 1),
(15701, 33, 24, 'Itatiba', 10000, 1),
(15702, 91, 1918, 'Siegen', 10000, 1),
(15703, 254, 160, 'Havertown', 10000, 1),
(15705, 254, 170, 'Tomahawk', 10000, 1),
(15706, 91, 1918, 'Hilden', 10000, 1),
(15707, 253, 5392, 'Aldershot', 10000, 1),
(15708, 254, 152, 'Roselle Park', 10000, 1),
(15710, 254, 144, 'Kingsford', 10000, 1),
(15711, 43, 35, 'Joliette', 10000, 1),
(15712, 43, 35, 'Saint-Hubert', 10000, 1),
(15713, 254, 160, 'Youngwood', 10000, 1),
(15714, 91, 1917, 'Leiferde', 10000, 1),
(15715, 128, 2458, 'Semipalatinsk', 10000, 1),
(15717, 65, 1491, 'Humleb', 10000, 1),
(15719, 65, 1493, 'Herlev', 10000, 1),
(15721, 185, 2991, 'Arendal', 10000, 1),
(15722, 254, 142, 'Saint Leonard', 10000, 1),
(15723, 254, 137, 'Grinnell', 10000, 1),
(15724, 65, 1501, 'Davding', 10000, 1),
(15725, 254, 152, 'Wyckoff', 10000, 1),
(15726, 254, 142, 'Odenton', 10000, 1),
(15727, 10, 1071, 'Suardi', 10000, 1),
(15728, 254, 154, 'Highland Falls', 10000, 1),
(15729, 254, 144, 'Montrose', 10000, 1),
(15731, 14, 6, 'Rockingham', 10000, 1),
(15732, 117, 1599, 'Bantry', 10000, 1),
(15734, 254, 131, 'Charlotte Harbor', 10000, 1),
(15736, 254, 157, 'Coldwater', 10000, 1),
(15737, 254, 162, 'Cottageville', 10000, 1),
(15738, 254, 169, 'Wellsburg', 10000, 1),
(15739, 254, 135, 'Bensenville', 10000, 1),
(15740, 254, 141, 'North Waterboro', 10000, 1),
(15741, 254, 170, 'Lomira', 10000, 1),
(15742, 254, 157, 'Waldo', 10000, 1),
(15743, 254, 152, 'Elmer', 10000, 1),
(15744, 14, 6, 'York', 10000, 1),
(15746, 254, 125, 'Cabot', 10000, 1),
(15747, 254, 144, 'Rives Junction', 10000, 1),
(15748, 119, 2247, 'Macerata', 10000, 1),
(15749, 254, 140, 'Erath', 10000, 1),
(15750, 254, 144, 'Three Oaks', 10000, 1),
(15751, 14, 1, 'Bright', 10000, 1),
(15752, 254, 172, 'Brattleboro', 10000, 1),
(15753, 254, 141, 'Nobleboro', 10000, 1),
(15754, 254, 126, 'Canoga Park', 10000, 1),
(15755, 254, 137, 'Blue Grass', 10000, 1),
(15756, 10, 1051, 'Salto', 10000, 1),
(15758, 254, 139, 'Weeksbury', 10000, 1),
(15759, 43, 43, 'North Delta', 10000, 1),
(15761, 254, 124, 'Paradise Valley', 10000, 1),
(15762, 14, 1, 'Mooroolbark', 10000, 1),
(15763, 49, 1358, 'Shituan', 10000, 1),
(15764, 91, 1913, 'wackersdorf', 10000, 1),
(15765, 254, 139, 'Caneyville', 10000, 1),
(15766, 233, 4008, 'Jakobsberg', 10000, 1),
(15767, 14, 1, 'Traralgon', 10000, 1),
(15768, 14, 4, 'Padstow', 10000, 1),
(15770, 175, 2985, 'Katwijk', 10000, 1),
(15771, 113, 2175, 'Vadodara', 10000, 1),
(15772, 113, 5268, 'Ranchi', 10000, 1),
(15773, 43, 37, 'Orleans', 10000, 1),
(15775, 254, 144, 'Delton', 10000, 1),
(15776, 48, 1370, 'Coquimbo', 10000, 1),
(15777, 95, 1976, 'Naousa', 10000, 1),
(15779, 175, 2977, 'Winterswijk', 10000, 1),
(15780, 24, 1137, 'Waregem', 10000, 1),
(15781, 254, 167, 'Quinby', 10000, 1),
(15782, 43, 37, 'Vaughan', 10000, 1),
(15786, 175, 2981, 'Amstelveen', 10000, 1),
(15789, 254, 143, 'Weymouth', 10000, 1),
(15791, 254, 165, 'Iowa Park', 10000, 1),
(15792, 254, 142, 'Reisterstown', 10000, 1),
(15793, 175, 2976, 'Sneek', 10000, 1),
(15794, 254, 135, 'Flat Rock', 10000, 1),
(15795, 254, 172, 'East Arlington', 10000, 1),
(15797, 254, 165, 'Sanger', 10000, 1),
(15798, 61, 5042, 'Sotin', 10000, 1),
(15799, 254, 149, 'Gering', 10000, 1),
(15800, 254, 144, 'Carleton', 10000, 1),
(15801, 226, 3935, 'Premi', 10000, 1),
(15802, 43, 35, 'Rimouski', 10000, 1),
(15803, 254, 154, 'Lancaster', 10000, 1),
(15804, 24, 1136, 'Lokeren', 10000, 1),
(15805, 254, 125, 'Mabelvale', 10000, 1),
(15806, 144, 2624, 'Petange', 10000, 1),
(15807, 254, 164, 'Surgoinsville', 10000, 1),
(15808, 82, 1796, 'Auxerre', 10000, 1),
(15809, 43, 36, 'Airdrie', 10000, 1),
(15810, 254, 135, 'Bethalto', 10000, 1),
(15811, 254, 158, 'Mooreland', 10000, 1),
(15813, 254, 164, 'Spring City', 10000, 1),
(15814, 91, 1921, 'Bargteheide', 10000, 1),
(15815, 14, 5, 'Loxton', 10000, 1),
(15816, 254, 132, 'Oakwood', 10000, 1),
(15818, 254, 126, 'San Marino', 10000, 1),
(15819, 43, 37, 'Kingsville', 10000, 1),
(15820, 43, 43, 'Tahsis', 10000, 1),
(15822, 43, 36, 'Edson', 10000, 1),
(15823, 254, 160, 'Union City', 10000, 1),
(15824, 254, 131, 'Christmas', 10000, 1),
(15825, 91, 1916, 'Altenstadt', 10000, 1),
(15826, 24, 1134, 'Halanzy', 10000, 1),
(15827, 24, 5051, 'Woluwe-Saint-Pierre', 10000, 1),
(15828, 24, 5051, 'Woluwe-Saint-Lambert', 10000, 1),
(15829, 91, 1916, 'ortenberg', 10000, 1),
(15831, 254, 140, 'Breaux Bridge', 10000, 1),
(15834, 238, 4288, 'Wete', 10000, 1),
(15835, 253, 5392, 'Bury St Edmunds', 10000, 1),
(15836, 59, 1438, 'Curridabat', 10000, 1),
(15837, 254, 165, 'Donna', 10000, 1),
(15838, 254, 170, 'Slinger', 10000, 1),
(15839, 254, 141, 'Troy', 10000, 1),
(15840, 82, 1797, 'Vannes', 10000, 1),
(15841, 253, 5389, 'St Asaph', 10000, 1),
(15842, 82, 1797, 'La Trinite-sur-Mer', 10000, 1),
(15845, 10, 1065, 'Cipolletti', 10000, 1),
(15846, 254, 126, 'American Canyon', 10000, 1),
(15847, 254, 157, 'Mount Sterling', 10000, 1),
(15848, 254, 136, 'Hayden', 10000, 1),
(15849, 113, 2191, 'Dharmapuri', 10000, 1),
(15850, 254, 160, 'Oxford', 10000, 1),
(15851, 254, 159, 'Murphy', 10000, 1),
(15852, 254, 159, 'Williams', 10000, 1),
(15854, 226, 3886, 'Ibiza', 10000, 1),
(15855, 254, 166, 'Woods Cross', 10000, 1),
(15856, 226, 3918, 'Arredondo', 10000, 1),
(15857, 254, 157, 'Oberlin', 10000, 1),
(15858, 15, 1077, 'G', 10000, 1),
(15859, 233, 4010, 'Partille', 10000, 1),
(15861, 246, 4232, 'Kocaeli', 10000, 1),
(15862, 82, 1812, 'Hy', 10000, 1),
(15864, 254, 142, 'Street', 10000, 1),
(15865, 43, 37, 'Keswick', 10000, 1),
(15867, 254, 148, 'Colstrip', 10000, 1),
(15868, 149, 2904, 'Arau', 10000, 1),
(15869, 111, 2082, 'Nagykoros', 10000, 1),
(15870, 91, 1913, 'Faulbach', 10000, 1),
(15871, 119, 2246, 'Assago', 10000, 1),
(15873, 254, 138, 'Hillsdale', 10000, 1),
(15874, 114, 189, 'Jayapura', 10000, 1),
(15875, 114, 189, 'manokwari', 10000, 1),
(15876, 114, 189, 'sorong', 10000, 1),
(15877, 114, 189, 'Biak', 10000, 1),
(15878, 114, 189, 'serui', 10000, 1),
(15879, 114, 189, 'nabire', 10000, 1),
(15880, 114, 189, 'merauke', 10000, 1),
(15881, 114, 189, 'timika', 10000, 1),
(15882, 114, 189, 'Fakfak', 10000, 1),
(15883, 114, 2149, 'Gresik', 10000, 1),
(15885, 91, 1916, 'Nidda', 10000, 1),
(15886, 14, 1, 'Nunawading', 10000, 1),
(15887, 254, 158, 'Noble', 10000, 1),
(15888, 43, 37, 'Coboconk', 10000, 1),
(15889, 49, 1339, 'zhangzhou', 10000, 1),
(15890, 233, 4010, 'N', 10000, 1),
(15891, 233, 4010, 'Hjo', 10000, 1),
(15893, 254, 152, 'Iselin', 10000, 1),
(15894, 61, 5040, 'Varazdin', 10000, 1),
(15895, 254, 152, 'Parlin', 10000, 1),
(15896, 24, 1129, 'Mortsel', 10000, 1),
(15897, 233, 4009, 'H', 10000, 1),
(15898, 14, 1, 'Narre Warren', 10000, 1),
(15899, 14, 1, 'Wangaratta', 10000, 1),
(15900, 118, 2236, 'Tel Aviv', 10000, 1),
(15902, 33, 24, 'S', 10000, 1),
(15904, 234, 4039, 'Rorschach', 10000, 1),
(15905, 219, 756, 'Jurong', 10000, 1),
(15906, 234, 4049, 'Horgen', 10000, 1),
(15908, 224, 3684, 'Kempton Park', 10000, 1),
(15911, 119, 2242, 'Imola', 10000, 1),
(15912, 254, 128, 'Pomfret Center', 10000, 1),
(15913, 254, 128, 'Pomfret', 10000, 1),
(15914, 254, 131, 'Carrabelle', 10000, 1),
(15915, 254, 152, 'Fords', 10000, 1),
(15916, 254, 135, 'Wasco', 10000, 1),
(15917, 113, 2169, 'Secunderabad', 10000, 1),
(15918, 91, 1925, 'Magdeburg', 10000, 1),
(15919, 149, 2908, 'Kemaman', 10000, 1),
(15920, 254, 128, 'Ridgefield', 10000, 1),
(15921, 254, 142, 'Montgomery Village', 10000, 1),
(15923, 254, 135, 'Sycamore', 10000, 1),
(15924, 254, 134, 'Preston', 10000, 1),
(15925, 91, 1912, 'Sasbach', 10000, 1),
(15926, 254, 155, 'Granite Falls', 10000, 1),
(15928, 254, 147, 'Pacific', 10000, 1),
(15929, 254, 160, 'Tafton', 10000, 1),
(15931, 82, 1812, 'Pertuis', 10000, 1),
(15932, 254, 167, 'Shenandoah', 10000, 1),
(15933, 254, 168, 'Cathlamet', 10000, 1),
(15934, 254, 131, 'Cedar Key', 10000, 1),
(15935, 219, 756, 'Bishan', 10000, 1),
(15936, 236, 4275, 'Chia-i Chia-I', 10000, 1),
(15937, 254, 127, 'Calhan', 10000, 1),
(15938, 175, 2977, 'Tiel', 10000, 1),
(15939, 254, 160, 'Grantham', 10000, 1),
(15941, 254, 154, 'Grand Island', 10000, 1),
(15942, 254, 159, 'Vida', 10000, 1),
(15943, 254, 152, 'Budd Lake', 10000, 1),
(15944, 81, 4879, 'Hyvink', 10000, 1),
(15945, 81, 1779, 'Raahe', 10000, 1),
(15946, 253, 5392, 'Windsor', 10000, 1),
(15947, 254, 133, 'Waikiki', 10000, 1),
(15948, 15, 1077, 'Retz', 10000, 1),
(15949, 43, 37, 'Madoc', 10000, 1),
(15950, 226, 3930, 'Ronda', 10000, 1),
(15952, 91, 1912, 'Uberlingen', 10000, 1),
(15953, 226, 3930, 'Marbella', 10000, 1),
(15954, 254, 160, 'Telford', 10000, 1),
(15955, 118, 2234, 'Kiryat Shemoneh', 10000, 1),
(15956, 253, 5392, 'Gosport', 10000, 1),
(15958, 254, 138, 'Osage City', 10000, 1),
(15960, 14, 1, 'Mornington', 10000, 1),
(15961, 254, 165, 'Angleton', 10000, 1),
(15962, 43, 43, 'Sooke', 10000, 1),
(15963, 254, 127, 'La Veta', 10000, 1),
(15964, 24, 5306, 'Aarschot', 10000, 1),
(15965, 43, 35, 'Valleyfield', 10000, 1),
(15966, 254, 139, 'Fort Campbell', 10000, 1),
(15968, 253, 5392, 'Romford', 10000, 1),
(15969, 254, 137, 'Earlham', 10000, 1),
(15971, 254, 126, 'Weimar', 10000, 1),
(15974, 254, 126, 'Meadow Vista', 10000, 1),
(15975, 254, 159, 'Aumsville', 10000, 1),
(15977, 254, 126, 'Cool', 10000, 1),
(15978, 254, 126, 'Alleghany', 10000, 1),
(15979, 254, 126, 'Camptonville', 10000, 1),
(15980, 254, 126, 'Cedar Ridge', 10000, 1),
(15981, 254, 126, 'Chicago Park', 10000, 1),
(15982, 254, 126, 'Grass Valley', 10000, 1),
(15984, 254, 160, 'Saint Marys', 10000, 1),
(15986, 254, 126, 'Lake Wildwood', 10000, 1),
(15987, 254, 126, 'North San Juan', 10000, 1),
(15988, 254, 126, 'Rough And Ready', 10000, 1),
(15989, 48, 1374, 'Cauquenes', 10000, 1),
(15990, 254, 126, 'Alta', 10000, 1),
(15991, 254, 126, 'Applegate', 10000, 1),
(15994, 254, 126, 'Coloma', 10000, 1),
(15995, 254, 126, 'Dutch Flat', 10000, 1),
(15996, 149, 2905, 'Pulau Pinang', 10000, 1),
(15997, 254, 126, 'Gold Run', 10000, 1),
(15998, 254, 126, 'Emigrant Gap', 10000, 1),
(15999, 14, 2, 'Penguin', 10000, 1),
(16000, 254, 122, 'Bear Creek', 10000, 1),
(16001, 117, 1611, 'Westport', 10000, 1),
(16002, 254, 126, 'Garden Valley', 10000, 1),
(16003, 254, 126, 'Georgetown', 10000, 1),
(16004, 117, 1610, 'Dundalk', 10000, 1),
(16005, 254, 126, 'Greenwood', 10000, 1),
(16006, 254, 126, 'Lotus', 10000, 1),
(16007, 113, 2172, 'Chandigarh', 10000, 1),
(16008, 254, 126, 'Newcastle', 10000, 1),
(16010, 254, 126, 'Penryn', 10000, 1),
(16011, 254, 126, 'Pilot Hill', 10000, 1),
(16012, 254, 126, 'Sheridan', 10000, 1),
(16014, 254, 157, 'Brimfield', 10000, 1),
(16015, 43, 37, 'Smiths Falls', 10000, 1),
(16017, 254, 131, 'Saint Augustine', 10000, 1),
(16018, 254, 134, 'Spirit Lake', 10000, 1),
(16019, 254, 160, 'Southeastern', 10000, 1),
(16020, 254, 168, 'White Salmon', 10000, 1),
(16021, 254, 135, 'Dundee', 10000, 1),
(16022, 113, 2175, 'Gadhada', 10000, 1),
(16023, 99, 636, 'Yona', 10000, 1),
(16024, 254, 152, 'Linwood', 10000, 1),
(16027, 254, 144, 'Grosse Pointe', 10000, 1),
(16028, 254, 147, 'Cameron', 10000, 1),
(16030, 43, 37, 'Simcoe', 10000, 1),
(16031, 159, 2889, 'Atizap', 10000, 1),
(16032, 254, 126, 'Canby', 10000, 1),
(16034, 113, 2185, 'Mysore', 10000, 1),
(16036, 254, 154, 'Springville', 10000, 1),
(16037, 254, 126, 'Salyer', 10000, 1),
(16038, 254, 162, 'West Columbia', 10000, 1),
(16039, 99, 636, 'Maite', 10000, 1),
(16040, 213, 3631, 'Ras Tanura', 10000, 1),
(16041, 254, 136, 'Battle Ground', 10000, 1),
(16042, 246, 4251, 'Tokat', 10000, 1),
(16044, 254, 127, 'Hotchkiss', 10000, 1),
(16045, 254, 145, 'Newport', 10000, 1),
(16047, 187, 3220, 'Hyderabad', 10000, 1),
(16048, 147, 2680, 'Antananarivo', 10000, 1),
(16049, 14, 1, 'Frankston', 10000, 1),
(16050, 274, 4690, 'Kwekwe', 10000, 1),
(16051, 24, 5305, 'Jodoigne', 10000, 1),
(16052, 246, 4246, 'Samsun', 10000, 1),
(16053, 119, 2249, 'Valenza', 10000, 1),
(16054, 119, 2257, 'Abano Terme', 10000, 1),
(16056, 253, 5392, 'Hexham', 10000, 1),
(16057, 253, 5392, 'Grays', 10000, 1),
(16058, 253, 5392, 'East Molesey', 10000, 1),
(16059, 198, 3311, 'Massama', 10000, 1),
(16061, 175, 2985, 'Sliedrecht', 10000, 1),
(16062, 271, 3941, 'Pancevo', 10000, 1),
(16063, 234, 4025, 'Wohlen', 10000, 1),
(16065, 91, 1917, 'Leer', 10000, 1),
(16066, 254, 135, 'Mazon', 10000, 1),
(16069, 236, 4275, 'Puli', 10000, 1),
(16070, 254, 165, 'Willis', 10000, 1),
(16072, 254, 160, 'Brownsville', 10000, 1),
(16073, 79, 616, 'T', 10000, 1),
(16074, 61, 5030, 'Djurdjevac', 10000, 1),
(16076, 254, 154, 'Newark Valley', 10000, 1),
(16077, 254, 170, 'Coloma', 10000, 1),
(16078, 254, 165, 'Point', 10000, 1),
(16079, 254, 144, 'Melvin', 10000, 1),
(16080, 234, 4031, 'Versoix', 10000, 1),
(16082, 36, 1249, 'Jerudong', 10000, 1),
(16083, 254, 155, 'Knightdale', 10000, 1),
(16084, 254, 125, 'Bull Shoals', 10000, 1),
(16086, 254, 156, 'Anamoose', 10000, 1),
(16087, 14, 4, 'West Wyalong', 10000, 1),
(16088, 133, 2432, 'Tongduch''on', 10000, 1),
(16089, 254, 163, 'Garretson', 10000, 1),
(16090, 198, 3307, 'Vila Real de Santo Ant', 10000, 1),
(16092, 43, 36, 'La Crete', 10000, 1),
(16093, 254, 145, 'New Richland', 10000, 1),
(16094, 33, 32, 'Santa Cruz do Sul', 10000, 1),
(16095, 254, 127, 'Rollinsville', 10000, 1),
(16097, 254, 127, 'Monument', 10000, 1),
(16099, 219, 756, 'Clementi', 10000, 1),
(16100, 43, 35, 'Prevost', 10000, 1),
(16101, 254, 135, 'Carterville', 10000, 1),
(16103, 109, 646, 'Tai Wan', 10000, 1),
(16104, 254, 170, 'Adams', 10000, 1),
(16107, 254, 136, 'Henryville', 10000, 1),
(16108, 197, 3276, 'Tomaszow Mazowiecki', 10000, 1),
(16111, 175, 2977, 'Zevenaar', 10000, 1),
(16112, 254, 144, 'Romeo', 10000, 1),
(16113, 254, 157, 'Orrville', 10000, 1),
(16114, 253, 5392, 'St Ives', 10000, 1),
(16115, 254, 160, 'Lansford', 10000, 1),
(16116, 254, 140, 'Lacombe', 10000, 1),
(16117, 254, 170, 'Chetek', 10000, 1),
(16118, 254, 135, 'Metamora', 10000, 1),
(16119, 185, 2990, 'Sandvika', 10000, 1),
(16120, 254, 138, 'Franklin', 10000, 1),
(16121, 254, 149, 'Plainview', 10000, 1),
(16124, 254, 145, 'Sauk Rapids', 10000, 1),
(16125, 24, 1132, 'Huy', 10000, 1),
(16126, 254, 160, 'Wallingford', 10000, 1),
(16127, 254, 134, 'Kamiah', 10000, 1),
(16128, 254, 144, 'Fruitport', 10000, 1),
(16129, 118, 2234, 'Maalot', 10000, 1),
(16130, 254, 144, 'Onekama', 10000, 1),
(16131, 254, 143, 'Pepperell', 10000, 1),
(16132, 254, 157, 'Waynesville', 10000, 1),
(16133, 64, 5126, 'Hradec Kralove', 10000, 1),
(16134, 254, 124, 'Prescott Valley', 10000, 1),
(16135, 254, 168, 'Chehalis', 10000, 1),
(16136, 64, 5126, 'Jicin', 10000, 1),
(16137, 254, 157, 'Tipp City', 10000, 1),
(16138, 254, 125, 'Mountain View', 10000, 1),
(16139, 91, 1913, 'Landau', 10000, 1),
(16140, 254, 126, 'Columbia', 10000, 1),
(16141, 254, 147, 'Kearney', 10000, 1),
(16143, 14, 5, 'Whyalla', 10000, 1),
(16144, 43, 40, 'Qu''Appelle', 10000, 1),
(16146, 43, 35, 'Iberville', 10000, 1),
(16147, 113, 2191, 'Thanjavur', 10000, 1),
(16148, 254, 154, 'Clayton', 10000, 1),
(16149, 254, 131, 'Dunnellon', 10000, 1),
(16150, 254, 170, 'Fort Atkinson', 10000, 1),
(16151, 254, 165, 'Richwood', 10000, 1),
(16152, 254, 144, 'West Olive', 10000, 1),
(16153, 254, 135, 'Macon', 10000, 1),
(16154, 119, 2246, 'Lecco', 10000, 1),
(16155, 254, 168, 'Clear Lake', 10000, 1),
(16158, 14, 4, 'Murwillumbah', 10000, 1),
(16160, 149, 2908, 'Kuala Terengganu', 10000, 1),
(16161, 254, 135, 'Long Grove', 10000, 1),
(16162, 175, 2979, 'Beek', 10000, 1),
(16163, 43, 36, 'Morinville', 10000, 1),
(16164, 195, 3505, 'Pasay', 10000, 1),
(16166, 91, 1912, 'Meersburg', 10000, 1),
(16167, 24, 1129, 'Westmalle', 10000, 1),
(16168, 226, 3933, 'Albacete', 10000, 1),
(16169, 43, 37, 'Winchester', 10000, 1),
(16170, 253, 5392, 'Melton Mowbray', 10000, 1),
(16171, 254, 170, 'Owen', 10000, 1),
(16172, 175, 2978, 'Stadskanaal', 10000, 1),
(16174, 271, 3941, 'Subotica', 10000, 1),
(16175, 82, 1797, 'Campbon', 10000, 1),
(16176, 43, 35, 'Cap-de-la-Madeleine', 10000, 1),
(16177, 254, 124, 'Goodyear', 10000, 1),
(16178, 82, 1798, 'Bourges', 10000, 1),
(16179, 30, 5116, 'Livno', 10000, 1),
(16181, 254, 125, 'Cherokee Village', 10000, 1),
(16182, 254, 154, 'Bedford', 10000, 1),
(16183, 254, 144, 'Berrien Center', 10000, 1),
(16186, 254, 127, 'Castle Rock', 10000, 1),
(16187, 254, 127, 'Parker', 10000, 1),
(16189, 254, 157, 'Galloway', 10000, 1),
(16190, 197, 3286, 'Kielce', 10000, 1),
(16192, 254, 154, 'Mount Sinai', 10000, 1),
(16193, 254, 160, 'Freeland', 10000, 1),
(16194, 82, 1803, 'Elancourt', 10000, 1),
(16195, 233, 3986, 'Olofstr', 10000, 1),
(16196, 175, 2983, 'Bunnik', 10000, 1),
(16198, 254, 140, 'Baker', 10000, 1),
(16199, 91, 1913, 'Untersteinach', 10000, 1),
(16200, 118, 2235, 'Kuryat Bialik', 10000, 1),
(16204, 253, 5392, 'Congleton', 10000, 1),
(16205, 175, 2977, 'Oosterbeek', 10000, 1),
(16207, 91, 1918, 'Sankt Augustin', 10000, 1),
(16208, 254, 172, 'White River Junction', 10000, 1),
(16209, 254, 144, 'Dorr', 10000, 1),
(16210, 68, 1523, 'Santo Domingo', 10000, 1),
(16211, 254, 129, 'Delaware City', 10000, 1),
(16216, 254, 122, 'Hazel Green', 10000, 1),
(16217, 254, 162, 'Chesterfield', 10000, 1),
(16218, 228, 1313, 'Gampaha', 10000, 1),
(16219, 254, 133, 'Captain Cook', 10000, 1),
(16220, 43, 37, 'Wallaceburg', 10000, 1),
(16221, 226, 3935, 'Manresa', 10000, 1),
(16222, 254, 160, 'Mahanoy City', 10000, 1),
(16223, 254, 139, 'Pineville', 10000, 1),
(16224, 254, 147, 'Saint Robert', 10000, 1),
(16225, 254, 172, 'Springfield', 10000, 1),
(16227, 14, 4, 'Byron Bay', 10000, 1),
(16228, 14, 6, 'Manjimup', 10000, 1),
(16229, 122, 2358, 'Kanzaki', 10000, 1),
(16230, 114, 2163, 'Bitung', 10000, 1),
(16231, 254, 165, 'Hart', 10000, 1),
(16232, 254, 144, 'Essexville', 10000, 1),
(16233, 254, 162, 'Mauldin', 10000, 1),
(16234, 254, 167, 'Purcellville', 10000, 1),
(16235, 233, 3996, 'Alvesta', 10000, 1),
(16236, 254, 158, 'Blackwell', 10000, 1),
(16237, 221, 3736, 'Hrastnik', 10000, 1),
(16238, 91, 1913, 'Aschaffenburg', 10000, 1),
(16239, 61, 5026, 'Slavonski Brod', 10000, 1),
(16240, 111, 2072, 'Mako', 10000, 1),
(16242, 233, 3993, 'Gamleby', 10000, 1),
(16243, 185, 2996, 'Sunndalsora', 10000, 1),
(16244, 233, 3993, 'Oskarshamn', 10000, 1),
(16245, 233, 4007, 'Koping', 10000, 1),
(16246, 254, 126, 'Walnut Grove', 10000, 1),
(16247, 185, 3001, 'Askim', 10000, 1),
(16248, 233, 4010, 'Str', 10000, 1),
(16249, 81, 4879, 'Loviisa', 10000, 1),
(16250, 119, 2255, 'Foligno', 10000, 1),
(16251, 233, 4003, 'B', 10000, 1),
(16252, 234, 4049, 'Dietikon', 10000, 1),
(16253, 91, 1926, 'Nordhausen', 10000, 1),
(16254, 253, 5392, 'Basildon', 10000, 1),
(16255, 65, 1493, 'Kastrup', 10000, 1),
(16256, 149, 2898, 'Jitra', 10000, 1),
(16257, 226, 3934, 'Salamanca', 10000, 1),
(16261, 254, 155, 'Kings Mountain', 10000, 1),
(16262, 65, 1501, 'Kors', 10000, 1),
(16263, 201, 738, 'Saint Paul', 10000, 1),
(16264, 254, 161, 'Chepachet', 10000, 1),
(16265, 24, 1137, 'Veurne', 10000, 1),
(16266, 254, 152, 'Ringoes', 10000, 1),
(16267, 65, 1501, 'Karup', 10000, 1),
(16268, 254, 154, 'Garrison', 10000, 1),
(16269, 149, 2899, 'Kota Bharu', 10000, 1),
(16270, 254, 144, 'Northville', 10000, 1),
(16272, 226, 3906, 'Logro', 10000, 1),
(16273, 226, 3930, 'Mairena del Alcor', 10000, 1),
(16274, 226, 3938, 'Vitoria', 10000, 1),
(16275, 234, 4039, 'Sankt Gallen', 10000, 1),
(16276, 253, 5392, 'Ringwood', 10000, 1),
(16278, 246, 4198, 'Antalya', 10000, 1),
(16279, 33, 27, 'Divin', 10000, 1),
(16280, 239, 4122, 'Surat Thani', 10000, 1),
(16281, 82, 1793, 'M', 10000, 1),
(16283, 91, 1912, 'Walld', 10000, 1),
(16284, 24, 1136, 'Zottegem', 10000, 1),
(16286, 254, 154, 'Dunkirk', 10000, 1),
(16287, 254, 135, 'Williamsfield', 10000, 1),
(16289, 91, 1913, 'Oberstdorf', 10000, 1),
(16290, 82, 1803, 'Maisons-Laffitte', 10000, 1),
(16292, 254, 157, 'Collins', 10000, 1),
(16293, 254, 140, 'Larose', 10000, 1),
(16295, 43, 43, 'Saanichton', 10000, 1),
(16296, 254, 160, 'New Cumberland', 10000, 1),
(16298, 254, 149, 'Inman', 10000, 1),
(16299, 33, 1217, 'Planaltina', 10000, 1),
(16300, 254, 131, 'Flagler Beach', 10000, 1),
(16301, 21, 1097, 'Christchurch', 10000, 1),
(16302, 254, 144, 'Remus', 10000, 1),
(16303, 254, 144, 'De Witt', 10000, 1),
(16304, 198, 3316, 'Valen', 10000, 1),
(16305, 254, 135, 'Riverton', 10000, 1),
(16306, 43, 42, 'Quispamsis', 10000, 1),
(16307, 254, 157, 'East Sparta', 10000, 1),
(16308, 254, 157, 'Sandyville', 10000, 1),
(16311, 43, 37, 'Port Perry', 10000, 1),
(16312, 254, 134, 'Santa', 10000, 1),
(16313, 254, 144, 'Marine City', 10000, 1),
(16314, 254, 169, 'Vienna', 10000, 1),
(16316, 254, 127, 'Eckert', 10000, 1),
(16317, 185, 2996, '', 10000, 1),
(16318, 254, 148, 'Whitehall', 10000, 1),
(16320, 254, 127, 'Cedaredge', 10000, 1),
(16321, 254, 160, 'Pine Grove', 10000, 1),
(16322, 254, 165, 'Jacksonville', 10000, 1),
(16324, 81, 4879, 'Hanko', 10000, 1),
(16327, 111, 2090, 'Zalaegerszeg', 10000, 1),
(16328, 137, 2511, 'salaspils', 10000, 1),
(16329, 81, 4879, 'Orimattila', 10000, 1),
(16333, 254, 165, 'Harker Heights', 10000, 1),
(16334, 253, 5392, 'Wetherby', 10000, 1),
(16335, 233, 4005, 'Lycksele', 10000, 1),
(16336, 175, 2989, 'Kraggenburg', 10000, 1),
(16337, 254, 149, 'Hemingford', 10000, 1),
(16339, 91, 1916, 'Limburg', 10000, 1),
(16340, 254, 126, 'Murphys', 10000, 1),
(16341, 111, 2080, 'P', 10000, 1),
(16342, 43, 39, 'Ingonish', 10000, 1),
(16343, 82, 1813, 'Sciez', 10000, 1),
(16344, 254, 154, 'Naples', 10000, 1),
(16345, 119, 2246, 'Olgiate Molgora', 10000, 1),
(16346, 254, 158, 'Knowles', 10000, 1),
(16348, 233, 3991, 'Fr', 10000, 1),
(16351, 254, 144, 'Central Lake', 10000, 1),
(16352, 33, 32, 'Montenegro', 10000, 1),
(16353, 254, 170, 'Webster', 10000, 1),
(16354, 254, 155, 'Banner Elk', 10000, 1),
(16355, 254, 152, 'Westville', 10000, 1),
(16356, 254, 152, 'Denville', 10000, 1),
(16357, 49, 1334, 'YUEQING', 10000, 1),
(16358, 254, 167, 'Rixeyville', 10000, 1),
(16359, 43, 37, 'Alliston', 10000, 1),
(16360, 113, 2191, 'Coimbatore', 10000, 1),
(16363, 254, 154, 'Broadalbin', 10000, 1),
(16364, 254, 167, 'Clarksville', 10000, 1),
(16365, 254, 134, 'Ketchum', 10000, 1),
(16366, 114, 5286, 'Karawaci', 10000, 1),
(16367, 254, 162, 'Taylors', 10000, 1),
(16368, 239, 4111, 'Trat', 10000, 1),
(16369, 122, 2335, 'Annaka', 10000, 1),
(16371, 43, 37, 'Orangeville', 10000, 1),
(16372, 133, 2432, 'Seoul', 10000, 1),
(16374, 254, 167, 'Pennington Gap', 10000, 1),
(16375, 113, 2191, 'Tiruppur', 10000, 1),
(16376, 254, 164, 'White Pine', 10000, 1),
(16377, 113, 2175, 'Rajkot', 10000, 1),
(16379, 254, 137, 'Coon Rapids', 10000, 1),
(16380, 233, 3987, 'Skarsa', 10000, 1),
(16381, 65, 1492, 'Ringe', 10000, 1),
(16383, 254, 136, 'Attica', 10000, 1),
(16384, 234, 4033, 'Sils im Domleschg', 10000, 1),
(16385, 202, 3374, 'Craiova', 10000, 1),
(16386, 175, 2979, 'Venray', 10000, 1),
(16388, 43, 43, 'Slocan', 10000, 1),
(16389, 24, 1135, 'Rhisnes', 10000, 1),
(16390, 82, 1799, 'Ch', 10000, 1),
(16392, 254, 153, 'San Jose', 10000, 1),
(16393, 253, 5392, 'Sutton', 10000, 1),
(16394, 226, 3908, 'Daganzo de Arriba', 10000, 1),
(16395, 254, 170, 'Gordon', 10000, 1),
(16396, 95, 1973, 'Agios Nikolaos', 10000, 1),
(16397, 82, 1803, 'Montmorency', 10000, 1),
(16399, 119, 2249, 'Omegna', 10000, 1),
(16401, 254, 165, 'Colmesneil', 10000, 1),
(16402, 251, 4443, 'Slavutich', 10000, 1),
(16403, 233, 4006, 'Bj', 10000, 1),
(16404, 253, 5390, 'Perth', 10000, 1),
(16405, 95, 1962, 'Koridhallos', 10000, 1),
(16406, 254, 165, 'Lake Whitney', 10000, 1),
(16407, 254, 145, 'Nisswa', 10000, 1),
(16408, 254, 160, 'Buckingham', 10000, 1),
(16409, 254, 132, 'Riverdale', 10000, 1),
(16411, 254, 159, 'Estacada', 10000, 1),
(16412, 95, 1944, 'Loannina', 10000, 1),
(16413, 185, 2991, 'Tvedestrand', 10000, 1),
(16414, 191, 3339, 'Port Moresby', 10000, 1),
(16416, 14, 4, 'Broken Hill', 10000, 1),
(16417, 233, 4010, 'Munkedal', 10000, 1),
(16419, 119, 2253, 'Bottegone', 10000, 1),
(16420, 226, 3908, 'Pozuelo de Alarc', 10000, 1),
(16421, 185, 2990, 'Asker', 10000, 1),
(16423, 253, 5392, 'Barrow-in-Furness', 10000, 1),
(16424, 64, 5133, 'Usti nad Labem', 10000, 1),
(16426, 65, 1493, 'Glostrup', 10000, 1),
(16427, 82, 1803, 'Luzarches', 10000, 1),
(16428, 20, 1161, 'Comilla', 10000, 1),
(16429, 118, 2234, 'Kiryat Ata', 10000, 1),
(16431, 254, 141, 'Calais', 10000, 1),
(16432, 91, 1918, 'Kamen', 10000, 1),
(16433, 254, 155, 'Clayton', 10000, 1),
(16437, 254, 139, 'Union', 10000, 1),
(16438, 254, 165, 'Montgomery', 10000, 1),
(16439, 254, 143, 'Acton', 10000, 1),
(16440, 254, 131, 'Jennings', 10000, 1),
(16441, 81, 5023, 'Paimio', 10000, 1),
(16443, 254, 145, 'Cannon Falls', 10000, 1),
(16444, 233, 4009, 'H', 10000, 1),
(16445, 254, 152, 'Clayton', 10000, 1),
(16446, 254, 160, 'Hamburg', 10000, 1),
(16448, 254, 168, 'Newport', 10000, 1),
(16449, 91, 1912, 'Pforzheim', 10000, 1),
(16451, 64, 5133, 'Most', 10000, 1),
(16452, 254, 137, 'Sheffield', 10000, 1),
(16453, 119, 2239, 'Matera', 10000, 1),
(16454, 64, 5127, 'Liberec', 10000, 1),
(16455, 254, 145, 'Cloquet', 10000, 1),
(16456, 226, 3932, 'Tacoronte', 10000, 1),
(16457, 91, 1912, 'Bretten', 10000, 1),
(16458, 175, 2979, 'Klimmen', 10000, 1),
(16459, 176, 5048, 'Oranjestad', 10000, 1),
(16461, 30, 5115, 'Banja Luka', 10000, 1),
(16462, 253, 5392, 'Salford', 10000, 1),
(16463, 226, 3939, 'Rojales', 10000, 1),
(16464, 254, 166, 'Springville', 10000, 1),
(16465, 137, 2490, 'Ligatne', 10000, 1),
(16466, 254, 126, 'McClellan', 10000, 1),
(16467, 65, 1494, 'Sindal', 10000, 1),
(16469, 254, 164, 'La Vergne', 10000, 1),
(16470, 254, 131, 'Maitland', 10000, 1),
(16471, 114, 5286, 'Tangerang', 10000, 1),
(16472, 43, 37, 'Ohsweken', 10000, 1),
(16473, 254, 136, 'Carbon', 10000, 1),
(16474, 254, 155, 'Whitsett', 10000, 1),
(16478, 254, 140, 'Luling', 10000, 1),
(16479, 203, 3579, 'Apatity', 10000, 1),
(16480, 254, 164, 'Cordova', 10000, 1),
(16481, 37, 1240, 'Blagoevgrad', 10000, 1),
(16484, 43, 39, 'Glace Bay', 10000, 1),
(16485, 254, 172, 'Northfield Falls', 10000, 1),
(16486, 254, 147, 'Saint James', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(16487, 254, 144, 'Portland', 10000, 1),
(16488, 43, 42, 'Oromocto', 10000, 1),
(16489, 233, 4008, 'Sigtuna', 10000, 1),
(16490, 233, 4010, 'Lysekil', 10000, 1),
(16491, 254, 136, 'Whiteland', 10000, 1),
(16492, 233, 4009, 'Bj', 10000, 1),
(16493, 254, 141, 'Hartland', 10000, 1),
(16494, 119, 2252, 'Capo d_Orlando', 10000, 1),
(16495, 254, 132, 'Warwick', 10000, 1),
(16496, 91, 1913, 'Lauf', 10000, 1),
(16497, 254, 143, 'Aashburnham', 10000, 1),
(16498, 254, 160, 'Jonestown', 10000, 1),
(16499, 143, 2535, 'Palanga', 10000, 1),
(16500, 253, 5392, 'Camberley', 10000, 1),
(16502, 175, 2985, 'Berkel En Rodenrijs', 10000, 1),
(16503, 254, 151, 'Center Conway', 10000, 1),
(16504, 226, 3935, 'Reus', 10000, 1),
(16505, 254, 126, 'Bonsall', 10000, 1),
(16506, 43, 37, 'Waterford', 10000, 1),
(16507, 254, 160, 'Curwensville', 10000, 1),
(16508, 82, 1803, 'Courbevoic', 10000, 1),
(16512, 43, 40, 'Norquay', 10000, 1),
(16513, 254, 155, 'Stanfield', 10000, 1),
(16514, 254, 155, 'Locust', 10000, 1),
(16515, 15, 1078, 'Hagenberg', 10000, 1),
(16516, 254, 155, 'Matthews', 10000, 1),
(16517, 254, 165, 'Justin', 10000, 1),
(16518, 43, 35, 'Pointe-Au-Pere', 10000, 1),
(16520, 254, 165, 'Ponder', 10000, 1),
(16523, 43, 46, 'Rankin Inlet', 10000, 1),
(16524, 226, 3886, 'Valldemosa', 10000, 1),
(16525, 254, 131, 'Lake Helen', 10000, 1),
(16526, 254, 147, 'Shelbina', 10000, 1),
(16527, 254, 167, 'Clifton', 10000, 1),
(16528, 43, 40, 'Alida', 10000, 1),
(16529, 254, 155, 'Hope Mills', 10000, 1),
(16530, 113, 2169, 'Nellore', 10000, 1),
(16531, 113, 2169, 'Kovur', 10000, 1),
(16533, 254, 122, 'Headland', 10000, 1),
(16535, 43, 42, 'New Maryland', 10000, 1),
(16537, 254, 147, 'Viburnum', 10000, 1),
(16539, 14, 1, 'Castlemaine', 10000, 1),
(16540, 254, 161, 'Narragansett', 10000, 1),
(16541, 254, 157, 'Cedarville', 10000, 1),
(16542, 254, 126, 'Glenn', 10000, 1),
(16543, 118, 2237, 'Maaleh Hahamishah', 10000, 1),
(16544, 112, 2139, 'Patreksfj', 10000, 1),
(16547, 254, 142, 'Harwood', 10000, 1),
(16550, 254, 162, 'Socastee', 10000, 1),
(16553, 49, 1336, 'Lianyungang', 10000, 1),
(16554, 243, 4058, 'Tunapuna', 10000, 1),
(16555, 254, 144, 'Sand Lake', 10000, 1),
(16556, 14, 4, 'Lidcombe', 10000, 1),
(16557, 254, 143, 'Grafton', 10000, 1),
(16559, 259, 4541, 'Maturin', 10000, 1),
(16561, 43, 46, 'Hall Beach', 10000, 1),
(16563, 254, 168, 'Yelm', 10000, 1),
(16564, 254, 122, 'Arley', 10000, 1),
(16565, 254, 154, 'Briarcliff Manor', 10000, 1),
(16566, 254, 152, 'Lincroft', 10000, 1),
(16567, 113, 2191, 'Madurai', 10000, 1),
(16568, 254, 160, 'Ephrata', 10000, 1),
(16569, 254, 132, 'Meansville', 10000, 1),
(16570, 254, 165, 'Shamrock', 10000, 1),
(16574, 65, 1498, 'Vamdrup', 10000, 1),
(16575, 33, 24, 'Osasco', 10000, 1),
(16576, 221, 3787, 'Novo Mesto', 10000, 1),
(16577, 254, 152, 'Andover', 10000, 1),
(16578, 91, 1924, 'Chemnitz', 10000, 1),
(16580, 254, 154, 'Elmsford', 10000, 1),
(16581, 91, 1912, 'Sindelfingen', 10000, 1),
(16582, 254, 168, 'Benton City', 10000, 1),
(16583, 185, 2997, 'Sandnessjoen', 10000, 1),
(16584, 91, 1916, 'Hungen', 10000, 1),
(16586, 175, 2979, 'Geleen', 10000, 1),
(16588, 197, 3285, 'Gliwice', 10000, 1),
(16589, 118, 2237, 'Bethlehem', 10000, 1),
(16591, 81, 1777, 'Tornio', 10000, 1),
(16592, 114, 2155, 'Bandar Lampung', 10000, 1),
(16593, 122, 2362, 'Matsuzaki', 10000, 1),
(16594, 64, 5131, 'Klatovy', 10000, 1),
(16595, 246, 4217, 'Eskisehir', 10000, 1),
(16596, 226, 3935, 'Bellvehi', 10000, 1),
(16597, 15, 1075, 'Eisenstadt', 10000, 1),
(16598, 14, 6, 'Harvey', 10000, 1),
(16599, 175, 2985, 'Vianen', 10000, 1),
(16600, 226, 3908, 'Mostoles', 10000, 1),
(16601, 254, 144, 'Constantine', 10000, 1),
(16602, 43, 36, 'Fort Macleod', 10000, 1),
(16604, 149, 2911, 'Labuan', 10000, 1),
(16605, 219, 756, 'Bukit Batok', 10000, 1),
(16606, 221, 3713, 'Velenje', 10000, 1),
(16609, 254, 144, 'Elsie', 10000, 1),
(16610, 254, 170, 'Bloomer', 10000, 1),
(16611, 43, 37, 'Petrolia', 10000, 1),
(16612, 254, 144, 'Fort Gratiot', 10000, 1),
(16613, 234, 4030, 'Bulle', 10000, 1),
(16614, 254, 157, 'Franklin Furnace', 10000, 1),
(16616, 226, 3935, 'Esplugues de Llobregat', 10000, 1),
(16617, 226, 3935, 'La Seu d''Urgell', 10000, 1),
(16619, 43, 37, 'Southampton', 10000, 1),
(16620, 254, 126, 'Descanso', 10000, 1),
(16621, 219, 756, 'Bedok', 10000, 1),
(16622, 199, 736, 'Humacao', 10000, 1),
(16623, 254, 165, 'Port Aransas', 10000, 1),
(16625, 65, 1501, 'Lemvig', 10000, 1),
(16628, 233, 4008, 'Danderyd', 10000, 1),
(16629, 254, 154, 'Patchogue', 10000, 1),
(16631, 254, 144, 'Mendon', 10000, 1),
(16632, 254, 134, 'Saint Maries', 10000, 1),
(16633, 254, 142, 'Charlotte Hall', 10000, 1),
(16634, 43, 40, 'Yorkton', 10000, 1),
(16635, 254, 170, 'Luxemburg', 10000, 1),
(16638, 43, 37, 'Nanticoke', 10000, 1),
(16640, 254, 143, 'Hingham', 10000, 1),
(16641, 82, 1812, 'Meylan', 10000, 1),
(16642, 254, 128, 'North Franklin', 10000, 1),
(16643, 91, 1913, 'Ottobrunn', 10000, 1),
(16644, 91, 1917, 'Bad Sachsa', 10000, 1),
(16645, 224, 3680, 'Ballito', 10000, 1),
(16646, 233, 4008, 'Uplands V', 10000, 1),
(16647, 254, 167, 'Haysi', 10000, 1),
(16648, 24, 5306, 'Tienen', 10000, 1),
(16650, 233, 3994, 'Hedemora', 10000, 1),
(16651, 254, 154, 'Greenwich', 10000, 1),
(16652, 91, 1916, 'Bensheim', 10000, 1),
(16653, 254, 135, 'Momence', 10000, 1),
(16654, 254, 169, 'Athens', 10000, 1),
(16655, 175, 2980, 'Uden', 10000, 1),
(16656, 253, 5392, 'Stansted', 10000, 1),
(16657, 254, 158, 'Weleetka', 10000, 1),
(16658, 61, 5038, 'Topusko', 10000, 1),
(16659, 253, 5392, 'Dudley', 10000, 1),
(16661, 185, 2992, 'Slemmestad', 10000, 1),
(16662, 254, 155, 'Andrews', 10000, 1),
(16663, 254, 160, 'Cornwall', 10000, 1),
(16664, 254, 155, 'Buies Creek', 10000, 1),
(16665, 43, 42, 'Dalhousie', 10000, 1),
(16666, 254, 142, 'Pasadena', 10000, 1),
(16667, 254, 142, 'Kingsville', 10000, 1),
(16668, 254, 122, 'Dadeville', 10000, 1),
(16670, 254, 126, 'Bangor', 10000, 1),
(16672, 257, 4511, 'Urgench', 10000, 1),
(16675, 43, 41, 'Grand Falls-Windsor', 10000, 1),
(16676, 254, 170, 'Menomonee Falls', 10000, 1),
(16677, 43, 35, 'Cap-Rouge', 10000, 1),
(16678, 254, 135, 'Loves Park', 10000, 1),
(16679, 91, 1918, 'Lemgo', 10000, 1),
(16680, 254, 151, 'New Durham', 10000, 1),
(16681, 10, 1051, 'Tres Arroyos', 10000, 1),
(16682, 43, 35, 'La Baie', 10000, 1),
(16683, 254, 154, 'Manlius', 10000, 1),
(16685, 254, 141, 'Milo', 10000, 1),
(16687, 43, 45, 'Kensington', 10000, 1),
(16689, 254, 154, 'Chester', 10000, 1),
(16690, 254, 157, 'Rudolph', 10000, 1),
(16691, 95, 1970, 'Kissamos', 10000, 1),
(16693, 254, 144, 'Saint Louis', 10000, 1),
(16694, 254, 152, 'Avenel', 10000, 1),
(16697, 254, 152, 'Kingwood', 10000, 1),
(16699, 254, 144, 'Lake Orion', 10000, 1),
(16701, 33, 24, 'Santo Andr', 10000, 1),
(16702, 254, 162, 'Effingham', 10000, 1),
(16703, 149, 2902, 'Kuantan', 10000, 1),
(16704, 254, 152, 'Tenafly', 10000, 1),
(16706, 254, 154, 'Blauvelt', 10000, 1),
(16708, 43, 35, 'Terrebonne', 10000, 1),
(16709, 254, 132, 'Snellville', 10000, 1),
(16710, 254, 165, 'Winnsboro', 10000, 1),
(16712, 254, 170, 'Darien', 10000, 1),
(16713, 10, 1073, 'Ushuaia', 10000, 1),
(16714, 254, 140, 'Port Barre', 10000, 1),
(16715, 254, 122, 'Foley', 10000, 1),
(16716, 43, 37, 'Markstay', 10000, 1),
(16717, 254, 126, 'Wilmington', 10000, 1),
(16718, 254, 170, 'Somerset', 10000, 1),
(16719, 254, 165, 'Evant', 10000, 1),
(16722, 254, 162, 'Fort Lawn', 10000, 1),
(16723, 233, 4000, 'Soderkoping', 10000, 1),
(16724, 9, 820, 'Falmouth', 10000, 1),
(16725, 254, 135, 'Staunton', 10000, 1),
(16726, 122, 2338, 'Yumesaki', 10000, 1),
(16728, 254, 159, 'Milton Freewater', 10000, 1),
(16731, 91, 1913, 'Schwabach', 10000, 1),
(16732, 122, 2329, 'Abiko', 10000, 1),
(16733, 95, 1954, 'Argostoli', 10000, 1),
(16734, 82, 1810, 'Abbeville', 10000, 1),
(16735, 175, 2977, 'Eefde', 10000, 1),
(16736, 65, 1492, 'Tranekaer', 10000, 1),
(16737, 163, 2702, 'Tiraspol', 10000, 1),
(16738, 175, 2985, 'Molenaarsgraaf', 10000, 1),
(16739, 49, 1336, 'Nanjing Jiangsu', 10000, 1),
(16740, 82, 1812, 'Sophia-Antipolis', 10000, 1),
(16742, 43, 35, 'Lachine', 10000, 1),
(16743, 113, 2176, 'Gurgaon', 10000, 1),
(16746, 33, 24, 'Mirassol', 10000, 1),
(16747, 14, 4, 'Narrabri', 10000, 1),
(16749, 254, 168, 'Ridgefield', 10000, 1),
(16751, 254, 145, 'Holloway', 10000, 1),
(16752, 254, 122, 'Repton', 10000, 1),
(16753, 254, 155, 'Etowah', 10000, 1),
(16755, 254, 146, 'Carriere', 10000, 1),
(16756, 254, 172, 'Vergennes', 10000, 1),
(16757, 91, 1918, 'M', 10000, 1),
(16758, 254, 143, 'Ashland', 10000, 1),
(16759, 254, 141, 'Anson', 10000, 1),
(16761, 254, 136, 'Versailles', 10000, 1),
(16762, 149, 2909, 'Cheras', 10000, 1),
(16764, 254, 131, 'San Mateo', 10000, 1),
(16766, 175, 2980, 'Heusden', 10000, 1),
(16767, 254, 139, 'Mount Washington', 10000, 1),
(16768, 43, 40, 'Brownlee', 10000, 1),
(16769, 219, 756, 'Sembawang', 10000, 1),
(16770, 254, 160, 'Huntingdon Valley', 10000, 1),
(16771, 254, 157, 'Columbiana', 10000, 1),
(16772, 14, 6, 'Carnarvon', 10000, 1),
(16773, 14, 6, 'Albany', 10000, 1),
(16774, 14, 6, 'Port Hedland', 10000, 1),
(16775, 14, 6, 'Shark Bay', 10000, 1),
(16776, 24, 1136, 'Belsele', 10000, 1),
(16778, 253, 5392, 'Liverpool', 10000, 1),
(16779, 15, 1076, 'Villach', 10000, 1),
(16780, 254, 139, 'Crestwood', 10000, 1),
(16781, 15, 1076, 'Bodensdorf', 10000, 1),
(16782, 254, 135, 'Godfrey', 10000, 1),
(16784, 254, 141, 'Dexter', 10000, 1),
(16785, 253, 5392, 'Weston Under Lizard', 10000, 1),
(16786, 140, 677, 'Turnersville', 10000, 1),
(16787, 234, 4036, 'La Chaux-de-Fonds', 10000, 1),
(16788, 122, 2359, 'Omiya', 10000, 1),
(16789, 24, 1129, 'Puurs', 10000, 1),
(16790, 91, 1916, 'Gladenbach', 10000, 1),
(16791, 91, 1913, 'Lenggries', 10000, 1),
(16793, 254, 126, 'Sorrento Mesa', 10000, 1),
(16794, 234, 4029, 'Renan', 10000, 1),
(16795, 233, 4000, 'Skara', 10000, 1),
(16802, 219, 756, 'Pasir Ris', 10000, 1),
(16803, 254, 150, 'Silver Springs', 10000, 1),
(16804, 254, 152, 'Bloomingdale', 10000, 1),
(16806, 91, 1913, 'Feuchtwangen', 10000, 1),
(16807, 254, 160, 'Burgettstown', 10000, 1),
(16808, 254, 152, 'Mount Laurel', 10000, 1),
(16809, 175, 2981, 'Heerhugowaard', 10000, 1),
(16810, 175, 2980, 'Rosmalen', 10000, 1),
(16812, 254, 143, 'Hyde Park', 10000, 1),
(16813, 117, 1605, 'Kilkenny', 10000, 1),
(16814, 199, 736, 'Isabela', 10000, 1),
(16815, 15, 1077, 'Rosental', 10000, 1),
(16816, 254, 152, 'Mullica Hill', 10000, 1),
(16817, 254, 160, 'Quincy', 10000, 1),
(16818, 15, 1081, 'Reutte', 10000, 1),
(16820, 43, 41, 'Paradise', 10000, 1),
(16821, 91, 1918, 'Luedenscheid', 10000, 1),
(16822, 254, 160, 'Conneaut Lake', 10000, 1),
(16823, 43, 35, 'Brossard', 10000, 1),
(16824, 254, 136, 'Mentone', 10000, 1),
(16825, 253, 5392, 'Enfield', 10000, 1),
(16826, 254, 160, 'Connellsville', 10000, 1),
(16827, 254, 157, 'Waynesfield', 10000, 1),
(16828, 254, 152, 'Montville', 10000, 1),
(16829, 111, 2075, 'Sopron', 10000, 1),
(16831, 254, 157, 'Pleasant City', 10000, 1),
(16832, 254, 145, 'Winsted', 10000, 1),
(16834, 254, 164, 'Beechgrove', 10000, 1),
(16835, 91, 1916, 'Bad Homburg', 10000, 1),
(16838, 185, 2993, 'Berlev', 10000, 1),
(16839, 254, 143, 'East Bridgewater', 10000, 1),
(16840, 254, 155, 'Oak Ridge', 10000, 1),
(16841, 254, 162, 'Cleveland', 10000, 1),
(16842, 18, 1086, 'Muharraq', 10000, 1),
(16844, 113, 2182, 'Akola', 10000, 1),
(16845, 254, 170, 'Cameron', 10000, 1),
(16846, 254, 131, 'Alva', 10000, 1),
(16847, 122, 2357, 'Suita', 10000, 1),
(16848, 175, 2985, 'Hillegom', 10000, 1),
(16849, 254, 136, 'Leo', 10000, 1),
(16850, 254, 135, 'Andalusia', 10000, 1),
(16851, 254, 160, 'Factoryville', 10000, 1),
(16852, 33, 24, 'S', 10000, 1),
(16854, 254, 151, 'Strafford', 10000, 1),
(16856, 254, 128, 'Uncasville', 10000, 1),
(16857, 254, 168, 'Entiat', 10000, 1),
(16858, 261, 5386, 'Christiansted', 10000, 1),
(16859, 122, 2364, 'Naruto', 10000, 1),
(16860, 254, 126, 'Montrose', 10000, 1),
(16861, 254, 144, 'Rockford', 10000, 1),
(16862, 43, 37, 'Havelock', 10000, 1),
(16863, 254, 159, 'Hermiston', 10000, 1),
(16864, 254, 160, 'Weedville', 10000, 1),
(16866, 43, 40, 'Neilburg', 10000, 1),
(16868, 14, 4, 'Rosebery', 10000, 1),
(16870, 203, 3583, 'Akademgorodok', 10000, 1),
(16871, 113, 2169, 'Guntur', 10000, 1),
(16872, 254, 126, 'Winton', 10000, 1),
(16873, 114, 2147, 'Bekasi', 10000, 1),
(16874, 175, 2975, 'Zuidwolde', 10000, 1),
(16875, 113, 2179, 'Kottayam', 10000, 1),
(16876, 254, 168, 'Leavenworth', 10000, 1),
(16878, 254, 138, 'Highland', 10000, 1),
(16879, 75, 1629, 'saue', 10000, 1),
(16880, 221, 3772, 'Ptuj', 10000, 1),
(16881, 119, 2244, 'Guidonia', 10000, 1),
(16882, 149, 2902, 'Raub', 10000, 1),
(16884, 254, 163, 'Viborg', 10000, 1),
(16886, 236, 4274, 'Panchiao', 10000, 1),
(16887, 259, 4535, 'Maracay', 10000, 1),
(16888, 178, 4721, 'Masterton', 10000, 1),
(16891, 175, 2982, 'Marknesse', 10000, 1),
(16892, 65, 1492, 'Svendborg', 10000, 1),
(16894, 33, 24, 'Guararema', 10000, 1),
(16895, 81, 5023, 'Kauhajoki', 10000, 1),
(16899, 43, 39, 'New Waterford', 10000, 1),
(16901, 91, 1916, 'Egelsbach', 10000, 1),
(16903, 254, 136, 'Advance', 10000, 1),
(16904, 254, 152, 'Sea Girt', 10000, 1),
(16905, 254, 164, 'Crump', 10000, 1),
(16907, 119, 2256, 'Cervinia', 10000, 1),
(16908, 113, 2191, 'Tiruchirappalli', 10000, 1),
(16909, 119, 2256, 'Valtournenche', 10000, 1),
(16910, 119, 2249, 'Trecate', 10000, 1),
(16911, 185, 3002, 'J', 10000, 1),
(16912, 119, 2249, 'Sala Biellese', 10000, 1),
(16913, 113, 2181, 'Indore', 10000, 1),
(16914, 254, 128, 'Portland', 10000, 1),
(16915, 122, 2338, 'Amagasaki-City', 10000, 1),
(16916, 65, 1491, '', 10000, 1),
(16917, 119, 2250, 'Monopoli', 10000, 1),
(16918, 254, 138, 'Wamego', 10000, 1),
(16920, 254, 132, 'Newington', 10000, 1),
(16921, 233, 4008, 'M', 10000, 1),
(16922, 185, 3007, 'Farsund', 10000, 1),
(16924, 254, 134, 'Bellevue', 10000, 1),
(16926, 254, 135, 'Wadsworth', 10000, 1),
(16927, 96, 1911, 'Kangerlussuaq', 10000, 1),
(16928, 254, 131, 'Wausau', 10000, 1),
(16930, 95, 1960, 'Thiva', 10000, 1),
(16931, 254, 126, 'Universal City', 10000, 1),
(16932, 254, 126, 'Encino', 10000, 1),
(16933, 254, 122, 'Robertsdale', 10000, 1),
(16934, 254, 132, 'Fort Stewart', 10000, 1),
(16935, 33, 27, 'Sete Lagoas', 10000, 1),
(16937, 14, 1, 'Noble Park', 10000, 1),
(16938, 233, 3999, 'Degerfors', 10000, 1),
(16939, 187, 3219, 'Gujranwala', 10000, 1),
(16940, 254, 144, 'Fostoria', 10000, 1),
(16941, 233, 4009, 'Klippan', 10000, 1),
(16942, 122, 2331, 'Ohi', 10000, 1),
(16943, 254, 137, 'State Center', 10000, 1),
(16946, 254, 137, 'Masonville', 10000, 1),
(16947, 254, 135, 'Bourbonnais', 10000, 1),
(16949, 254, 131, 'Jacksonville Beach', 10000, 1),
(16950, 254, 133, 'Kurtistown', 10000, 1),
(16951, 111, 2093, 'Dunaujvaros', 10000, 1),
(16952, 122, 2358, 'Takeo', 10000, 1),
(16955, 134, 2444, 'Al Farwaniyah', 10000, 1),
(16956, 14, 4, 'Tingha', 10000, 1),
(16957, 118, 2233, 'Lod', 10000, 1),
(16958, 61, 5038, '', 10000, 1),
(16959, 254, 136, 'Fishers', 10000, 1),
(16960, 254, 131, 'Deleon Springs', 10000, 1),
(16962, 254, 152, 'Martinsville', 10000, 1),
(16963, 254, 153, 'Quemado', 10000, 1),
(16964, 24, 1129, 'Berlaar', 10000, 1),
(16965, 254, 131, 'Floral City', 10000, 1),
(16966, 91, 1926, 'rudolstadt', 10000, 1),
(16967, 254, 135, 'Belleview', 10000, 1),
(16968, 43, 35, 'Greenfield Park', 10000, 1),
(16969, 254, 152, 'Watchung', 10000, 1),
(16970, 65, 1494, 'Hadsund', 10000, 1),
(16971, 198, 3311, 'Sintra', 10000, 1),
(16972, 254, 126, 'La Crescenta', 10000, 1),
(16973, 254, 143, 'Wilmington', 10000, 1),
(16976, 43, 35, 'Cowansville', 10000, 1),
(16978, 246, 4250, 'Tekirda', 10000, 1),
(16980, 254, 131, 'Steinhatchee', 10000, 1),
(16982, 254, 131, 'Sparr', 10000, 1),
(16985, 254, 155, 'Denton', 10000, 1),
(16986, 254, 159, 'Sublimity', 10000, 1),
(16987, 43, 37, 'Gananoque', 10000, 1),
(16988, 14, 1, 'Swan Hill', 10000, 1),
(16989, 43, 38, 'Minnedosa', 10000, 1),
(16991, 43, 37, 'Haliburton', 10000, 1),
(16992, 254, 149, 'Gothenburg', 10000, 1),
(16994, 254, 157, 'Louisville', 10000, 1),
(16995, 252, 4999, 'Ajman', 10000, 1),
(16996, 82, 1803, 'Longjumeau', 10000, 1),
(16997, 149, 2903, 'Taiping', 10000, 1),
(16998, 254, 140, 'Walker', 10000, 1),
(16999, 254, 126, 'Trona', 10000, 1),
(17000, 254, 126, 'French Camp', 10000, 1),
(17001, 221, 3844, 'Medvode', 10000, 1),
(17004, 253, 5392, 'Barnsley', 10000, 1),
(17005, 15, 1078, 'Wels', 10000, 1),
(17006, 236, 4274, 'Lung Tang', 10000, 1),
(17007, 254, 168, 'La Conner', 10000, 1),
(17008, 175, 2981, 'Krommenie', 10000, 1),
(17009, 271, 5063, 'Nis', 10000, 1),
(17010, 254, 160, 'North East', 10000, 1),
(17013, 185, 3008, 'Svelvik', 10000, 1),
(17014, 43, 39, 'Tiverton', 10000, 1),
(17015, 253, 5392, 'Yeovil', 10000, 1),
(17016, 254, 165, 'Cedar Park', 10000, 1),
(17018, 91, 1912, 'Haiterbach', 10000, 1),
(17019, 254, 160, 'Wernersville', 10000, 1),
(17020, 254, 161, 'West Kingston', 10000, 1),
(17021, 254, 135, 'Hickory Hills', 10000, 1),
(17023, 233, 4009, 'Esl', 10000, 1),
(17024, 254, 141, 'Boothbay', 10000, 1),
(17027, 82, 1803, 'Noisy Sur Ecole', 10000, 1),
(17029, 33, 27, 'Ibirite', 10000, 1),
(17030, 254, 152, 'Hopewell', 10000, 1),
(17031, 254, 136, 'Bristol', 10000, 1),
(17032, 10, 1051, 'Berazategui', 10000, 1),
(17033, 175, 2985, 'Spijkenisse', 10000, 1),
(17035, 254, 165, 'Farmersville', 10000, 1),
(17036, 175, 2982, 'Zwartsluis', 10000, 1),
(17038, 254, 168, 'Tumwater', 10000, 1),
(17041, 82, 1799, 'Troyes', 10000, 1),
(17042, 199, 736, 'Arecibo', 10000, 1),
(17044, 254, 167, 'South Hill', 10000, 1),
(17045, 15, 1080, 'M', 10000, 1),
(17046, 65, 1502, 'Thors', 10000, 1),
(17047, 254, 160, 'Mohnton', 10000, 1),
(17049, 254, 139, 'Russell', 10000, 1),
(17050, 198, 3307, 'Loul', 10000, 1),
(17051, 254, 143, 'Jamaica Plain', 10000, 1),
(17052, 14, 1, 'Sunbury', 10000, 1),
(17053, 254, 158, 'Broken Bow', 10000, 1),
(17054, 254, 165, 'Kermit', 10000, 1),
(17055, 254, 126, 'Creston', 10000, 1),
(17056, 14, 1, 'Horsham', 10000, 1),
(17057, 234, 4048, 'Baar', 10000, 1),
(17058, 254, 160, 'Elysburg', 10000, 1),
(17059, 254, 144, 'Plymouth', 10000, 1),
(17060, 43, 37, 'Espanola', 10000, 1),
(17061, 254, 152, 'Neptune', 10000, 1),
(17062, 254, 170, 'Woodville', 10000, 1),
(17063, 119, 2252, 'Enna', 10000, 1),
(17065, 254, 146, 'Ruleville', 10000, 1),
(17066, 254, 138, 'Admire', 10000, 1),
(17067, 254, 155, 'Wagram', 10000, 1),
(17069, 254, 141, 'Mechanic Falls', 10000, 1),
(17072, 254, 163, 'Groton', 10000, 1),
(17073, 254, 142, 'Whiteford', 10000, 1),
(17075, 254, 146, 'Pass Christian', 10000, 1),
(17076, 254, 125, 'Leachville', 10000, 1),
(17078, 254, 169, 'Kermit', 10000, 1),
(17079, 220, 2594, 'Trnava', 10000, 1),
(17080, 33, 1217, 'Guar', 10000, 1),
(17081, 254, 145, 'Hoffman', 10000, 1),
(17082, 149, 2897, 'Segamat', 10000, 1),
(17083, 175, 2989, 'Biddinghuizen', 10000, 1),
(17087, 14, 1, 'Dandenong', 10000, 1),
(17089, 254, 128, 'Wolcott', 10000, 1),
(17090, 254, 154, 'Port Henry', 10000, 1),
(17091, 259, 4540, 'Los Teques', 10000, 1),
(17092, 254, 152, 'Blackwood', 10000, 1),
(17093, 254, 155, 'Henderson', 10000, 1),
(17094, 254, 154, 'New Hartford', 10000, 1),
(17096, 254, 145, 'Excelsior', 10000, 1),
(17097, 253, 5392, 'Newbury', 10000, 1),
(17099, 254, 158, 'Mannford', 10000, 1),
(17100, 254, 126, 'Acampo', 10000, 1),
(17101, 254, 167, 'Bealeton', 10000, 1),
(17103, 43, 36, 'Lacombe', 10000, 1),
(17104, 254, 169, 'Inwood', 10000, 1),
(17105, 254, 146, 'Crystal Springs', 10000, 1),
(17107, 254, 154, 'Port Washington', 10000, 1),
(17109, 91, 1917, 'Celle', 10000, 1),
(17110, 226, 3939, 'Requena', 10000, 1),
(17111, 254, 155, 'Lewisville', 10000, 1),
(17113, 119, 2242, 'San Secondo Parmense', 10000, 1),
(17115, 254, 127, 'Brighton', 10000, 1),
(17116, 254, 164, 'Pickwick Dam', 10000, 1),
(17117, 254, 144, 'Irons', 10000, 1),
(17118, 254, 146, 'Tishomingo', 10000, 1),
(17119, 254, 146, 'Shubuta', 10000, 1),
(17120, 178, 5019, 'Ashhurst', 10000, 1),
(17123, 254, 164, 'Liberty', 10000, 1),
(17124, 254, 144, 'Hartland', 10000, 1),
(17125, 254, 154, 'Bellmore', 10000, 1),
(17127, 254, 169, 'Chester', 10000, 1),
(17128, 254, 146, 'Georgetown', 10000, 1),
(17129, 254, 164, 'Savannah', 10000, 1),
(17130, 254, 135, 'East Alton', 10000, 1),
(17131, 254, 131, 'Cottondale', 10000, 1),
(17134, 226, 3934, '', 10000, 1),
(17135, 254, 142, 'Fort George G Meade', 10000, 1),
(17137, 228, 1308, 'Jaffna', 10000, 1),
(17138, 254, 165, 'Lytle', 10000, 1),
(17141, 254, 164, 'Pegram', 10000, 1),
(17142, 15, 1079, 'Tamsweg', 10000, 1),
(17143, 175, 2981, 'Heemstede', 10000, 1),
(17144, 119, 2246, 'Merate', 10000, 1),
(17145, 254, 158, 'Gene Autry', 10000, 1),
(17147, 254, 159, 'Stayton', 10000, 1),
(17149, 254, 165, 'Kemp', 10000, 1),
(17150, 254, 127, 'Silverthorne', 10000, 1),
(17151, 43, 43, 'Nelson', 10000, 1),
(17152, 254, 158, 'Goodwell', 10000, 1),
(17153, 254, 156, 'Larimore', 10000, 1),
(17154, 254, 170, 'Kewaskum', 10000, 1),
(17155, 91, 1922, 'Frankfurt', 10000, 1),
(17156, 177, 714, 'Noumea', 10000, 1),
(17157, 91, 1918, 'Rheda-Wiedenbrueck', 10000, 1),
(17158, 119, 2241, 'Castello di Cisterna', 10000, 1),
(17160, 24, 1131, 'Soignies', 10000, 1),
(17161, 253, 5392, 'Oxford', 10000, 1),
(17162, 149, 2903, 'Sitiawan', 10000, 1),
(17165, 233, 3990, 'Tv', 10000, 1),
(17166, 254, 154, 'Wading River', 10000, 1),
(17167, 254, 155, 'Graham', 10000, 1),
(17168, 254, 170, 'Amery', 10000, 1),
(17170, 254, 146, 'Walnut', 10000, 1),
(17172, 254, 152, 'Millington', 10000, 1),
(17173, 254, 165, 'Aledo', 10000, 1),
(17174, 175, 2985, 'Scheveningen', 10000, 1),
(17175, 254, 143, 'Andover', 10000, 1),
(17177, 254, 165, 'Mauriceville', 10000, 1),
(17179, 254, 144, 'Rapid River', 10000, 1),
(17180, 254, 165, 'Telephone', 10000, 1),
(17184, 254, 160, 'Bridgeville', 10000, 1),
(17187, 254, 165, 'Fredericksburg', 10000, 1),
(17188, 43, 40, 'Swift Current', 10000, 1),
(17190, 254, 136, 'Huntingburg', 10000, 1),
(17191, 233, 3996, 'R', 10000, 1),
(17192, 254, 152, 'Hackettstown', 10000, 1),
(17194, 254, 160, 'Harrison City', 10000, 1),
(17195, 254, 170, 'Hustisford', 10000, 1),
(17196, 254, 154, 'Ridgewood', 10000, 1),
(17197, 43, 37, 'Delta', 10000, 1),
(17198, 254, 157, 'Oregon', 10000, 1),
(17199, 254, 160, 'Dickson City', 10000, 1),
(17200, 254, 126, 'Port Costa', 10000, 1),
(17202, 254, 134, 'Oldtown', 10000, 1),
(17203, 254, 144, 'Middleville', 10000, 1),
(17204, 254, 154, 'Saint Johnsville', 10000, 1),
(17205, 254, 168, 'Snohomish', 10000, 1),
(17206, 254, 145, 'Pelican Rapids', 10000, 1),
(17207, 254, 140, 'Cut Off', 10000, 1),
(17209, 254, 137, 'Moulton', 10000, 1),
(17210, 254, 157, 'Campbell', 10000, 1),
(17211, 254, 153, 'Texico', 10000, 1),
(17212, 254, 171, 'Banner', 10000, 1),
(17213, 254, 136, 'Liberty Mills', 10000, 1),
(17214, 254, 154, 'Whitney Point', 10000, 1),
(17215, 254, 165, 'Dale', 10000, 1),
(17216, 254, 135, 'Wilmington', 10000, 1),
(17217, 243, 4052, 'Couva', 10000, 1),
(17218, 254, 143, 'East Longmeadow', 10000, 1),
(17219, 254, 160, 'Forest City', 10000, 1),
(17221, 254, 127, 'Poncha Springs', 10000, 1),
(17222, 254, 144, 'Saint Johns', 10000, 1),
(17223, 254, 169, 'Williamstown', 10000, 1),
(17225, 254, 131, 'Pahokee', 10000, 1),
(17226, 254, 168, 'Klickitat', 10000, 1),
(17227, 254, 144, 'Hersey', 10000, 1),
(17228, 254, 144, 'Ada', 10000, 1),
(17229, 254, 157, 'Bremen', 10000, 1),
(17230, 254, 127, 'Walden', 10000, 1),
(17232, 122, 2339, 'Tsukuba', 10000, 1),
(17233, 15, 1077, 'Bad V', 10000, 1),
(17234, 15, 1083, 'Wien', 10000, 1),
(17235, 254, 154, 'Lansing', 10000, 1),
(17236, 233, 3998, 'Gammelstad', 10000, 1),
(17238, 43, 37, 'Deseronto', 10000, 1),
(17240, 175, 2976, 'Harlingen', 10000, 1),
(17241, 65, 1493, 'Copenhagen ', 10000, 1),
(17243, 254, 159, 'Irrigon', 10000, 1),
(17244, 91, 1918, 'Borken', 10000, 1),
(17245, 91, 1917, 'Brake', 10000, 1),
(17246, 24, 1131, 'Binche', 10000, 1),
(17247, 219, 756, 'Yishun', 10000, 1),
(17248, 14, 1, 'Sunshine', 10000, 1),
(17249, 119, 2257, 'Conegliano', 10000, 1),
(17251, 185, 2992, 'Hvittingfoss', 10000, 1),
(17252, 254, 136, 'Huntertown', 10000, 1),
(17255, 152, 689, 'Msida', 10000, 1),
(17256, 254, 152, 'Spotswood', 10000, 1),
(17257, 24, 5305, 'Ottignies', 10000, 1),
(17258, 254, 137, 'Brooklyn', 10000, 1),
(17259, 175, 2982, 'Almelo', 10000, 1),
(17260, 91, 1924, 'Olbernhau', 10000, 1),
(17261, 251, 4456, 'Zaporizhzhya', 10000, 1),
(17262, 91, 1924, 'Zwickau', 10000, 1),
(17263, 254, 145, 'Rogers', 10000, 1),
(17264, 119, 2257, 'Cittadella', 10000, 1),
(17265, 254, 154, 'Ashland', 10000, 1),
(17266, 43, 35, 'Lennoxville', 10000, 1),
(17267, 10, 1051, 'Jose Leon Suarez', 10000, 1),
(17268, 254, 141, 'Damariscotta', 10000, 1),
(17269, 254, 157, 'Maumee', 10000, 1),
(17270, 254, 167, 'Locust Grove', 10000, 1),
(17271, 254, 137, 'Eagle Grove', 10000, 1),
(17272, 254, 125, 'Centerton', 10000, 1),
(17273, 91, 1913, 'Furth Im Wald', 10000, 1),
(17274, 246, 4218, 'Gaziantep', 10000, 1),
(17275, 91, 1919, 'Bitburg', 10000, 1),
(17276, 254, 154, 'Alfred', 10000, 1),
(17277, 254, 165, 'Frisco', 10000, 1),
(17278, 43, 37, 'Baltimore', 10000, 1),
(17280, 270, 4675, 'Ibb', 10000, 1),
(17281, 254, 145, 'Jordan', 10000, 1),
(17282, 254, 143, 'Lenox', 10000, 1),
(17283, 254, 153, 'Aztec', 10000, 1),
(17284, 119, 2250, 'Maglie', 10000, 1),
(17285, 15, 1075, 'G', 10000, 1),
(17286, 254, 154, 'Sherman', 10000, 1),
(17287, 254, 134, 'Priest River', 10000, 1),
(17288, 254, 142, 'Chaptico', 10000, 1),
(17289, 254, 157, 'New Vienna', 10000, 1),
(17291, 91, 1918, 'D', 10000, 1),
(17292, 254, 146, 'D''Iberville', 10000, 1),
(17293, 254, 126, 'Fort Jones', 10000, 1),
(17294, 65, 1492, 'Krogsb', 10000, 1),
(17295, 203, 3546, 'Trekhgorny', 10000, 1),
(17296, 175, 2980, 'Gilze', 10000, 1),
(17297, 175, 2976, 'Franeker', 10000, 1),
(17299, 175, 2981, 'Muiden', 10000, 1),
(17300, 185, 3006, 'Harstad', 10000, 1),
(17301, 152, 689, 'Birzebbugia', 10000, 1),
(17302, 271, 5063, 'Barajevo', 10000, 1),
(17303, 254, 162, 'North Augusta', 10000, 1),
(17305, 65, 1494, 'N', 10000, 1),
(17307, 254, 135, 'La Grange', 10000, 1),
(17309, 254, 135, 'Palos Park', 10000, 1),
(17311, 254, 137, 'Hampton', 10000, 1),
(17312, 254, 151, 'Bethlehem', 10000, 1),
(17313, 254, 160, 'Hazleton', 10000, 1),
(17314, 144, 2625, 'Strassen', 10000, 1),
(17315, 254, 154, 'Somers', 10000, 1),
(17316, 254, 152, 'Rutherford', 10000, 1),
(17317, 254, 122, 'Enon', 10000, 1),
(17318, 254, 155, 'Cullowhee', 10000, 1),
(17319, 254, 152, 'Longport', 10000, 1),
(17320, 43, 37, 'Dunnville', 10000, 1),
(17321, 198, 3315, 'Amora', 10000, 1),
(17323, 254, 131, 'Seminole', 10000, 1),
(17324, 254, 135, 'Gillespie', 10000, 1),
(17325, 254, 154, 'Greene', 10000, 1),
(17326, 254, 160, 'Mifflintown', 10000, 1),
(17328, 254, 158, 'Wynnewood', 10000, 1),
(17330, 43, 40, 'Leader', 10000, 1),
(17331, 254, 154, 'Sherrill', 10000, 1),
(17333, 254, 154, 'Carmel', 10000, 1),
(17334, 254, 170, 'De Forest', 10000, 1),
(17336, 254, 124, 'Camp Verde', 10000, 1),
(17337, 254, 141, 'Brewer', 10000, 1),
(17338, 254, 169, 'Princeton', 10000, 1),
(17339, 254, 131, 'Interlachen', 10000, 1),
(17340, 254, 136, 'Butler', 10000, 1),
(17342, 43, 37, 'Elora', 10000, 1),
(17343, 254, 126, 'Willits', 10000, 1),
(17344, 254, 122, 'Orange Beach', 10000, 1),
(17346, 43, 37, 'Exeter', 10000, 1),
(17347, 254, 137, 'Beaman', 10000, 1),
(17348, 178, 4721, 'Porirua', 10000, 1),
(17349, 43, 37, 'Thamesford', 10000, 1),
(17350, 43, 37, 'Sault Ste. Marie', 10000, 1),
(17351, 48, 1375, 'Buin', 10000, 1),
(17352, 70, 1562, 'San Jacinto', 10000, 1),
(17353, 254, 160, 'New Brighton', 10000, 1),
(17355, 254, 154, 'Peru', 10000, 1),
(17356, 254, 165, 'Crosby', 10000, 1),
(17357, 254, 131, 'Leesburg', 10000, 1),
(17358, 254, 165, 'Crowley', 10000, 1),
(17359, 122, 2329, 'Funabashi', 10000, 1),
(17362, 254, 127, 'Pine', 10000, 1),
(17363, 254, 155, 'Pinnacle', 10000, 1),
(17364, 254, 154, 'Mastic', 10000, 1),
(17365, 254, 153, 'El Rito', 10000, 1),
(17366, 43, 36, 'Beaverlodge', 10000, 1),
(17368, 254, 162, 'Cowpens', 10000, 1),
(17369, 254, 164, 'Cypress Inn', 10000, 1),
(17370, 254, 123, 'Kasilof', 10000, 1),
(17373, 209, 4523, 'Kingstown', 10000, 1),
(17374, 43, 37, 'Brighton', 10000, 1),
(17375, 254, 126, 'La Canada Flintridge', 10000, 1),
(17376, 254, 165, 'Rockdale', 10000, 1),
(17377, 254, 144, 'Holly', 10000, 1),
(17379, 254, 126, 'Three Rivers', 10000, 1),
(17382, 254, 159, 'Dallas', 10000, 1),
(17383, 234, 4035, 'Root', 10000, 1),
(17384, 82, 1812, 'Gap', 10000, 1),
(17385, 14, 3, 'Kingaroy', 10000, 1),
(17386, 119, 2249, 'Borgosesia', 10000, 1),
(17387, 119, 2249, 'Alagna Valsesia', 10000, 1),
(17388, 91, 1919, 'Montabaur', 10000, 1),
(17390, 149, 2909, 'Kuala Lumpur', 10000, 1),
(17391, 15, 1077, 'Grafenbach', 10000, 1),
(17392, 119, 2249, 'Varallo Sesia', 10000, 1),
(17393, 43, 35, 'Dolbeau', 10000, 1),
(17394, 198, 3310, 'Caldas Da Rainha', 10000, 1),
(17395, 246, 4201, 'Balikesir', 10000, 1),
(17397, 37, 1239, 'Sliven', 10000, 1),
(17398, 82, 1804, 'Narbonne', 10000, 1),
(17399, 14, 4, 'Mudgee', 10000, 1),
(17400, 198, 3311, 'Oeiras', 10000, 1),
(17401, 82, 1793, 'Anglet', 10000, 1),
(17402, 24, 5306, 'Diest', 10000, 1),
(17403, 119, 2244, 'Frosinone', 10000, 1),
(17404, 122, 2372, 'Ginowan', 10000, 1),
(17405, 122, 2372, 'Nagata', 10000, 1),
(17407, 254, 166, 'Torrey', 10000, 1),
(17408, 254, 164, 'Atoka', 10000, 1),
(17409, 254, 157, 'Mogadore', 10000, 1),
(17410, 236, 4274, 'Hsin-chu', 10000, 1),
(17411, 202, 3383, 'Tirgu Mures', 10000, 1),
(17412, 81, 1779, 'Kajaani', 10000, 1),
(17414, 254, 149, 'Sutton', 10000, 1),
(17416, 254, 147, 'Kissee Mills', 10000, 1),
(17417, 254, 152, 'Mount Holly', 10000, 1),
(17418, 239, 4108, 'Pattaya', 10000, 1),
(17420, 254, 168, 'Roslyn', 10000, 1),
(17421, 254, 157, 'Lakeville', 10000, 1),
(17422, 171, 4646, 'Tsumeb', 10000, 1),
(17424, 43, 37, 'Shannonville', 10000, 1),
(17425, 254, 168, 'Orting', 10000, 1),
(17426, 254, 145, 'Lynd', 10000, 1),
(17427, 175, 2976, 'Drachten', 10000, 1),
(17428, 175, 2976, 'Hardegarijp', 10000, 1),
(17429, 254, 137, 'Cambridge', 10000, 1),
(17430, 119, 2257, 'Cortina d''Ampezzo', 10000, 1),
(17431, 254, 152, 'Beverly', 10000, 1),
(17432, 254, 126, 'Avila Beach', 10000, 1),
(17433, 118, 2234, 'Kiryat Haim', 10000, 1),
(17435, 159, 73, 'Rosarito', 10000, 1),
(17437, 254, 140, 'Anacoco', 10000, 1),
(17438, 119, 2241, 'Sala Consilina', 10000, 1),
(17439, 43, 36, 'Grimshaw', 10000, 1),
(17440, 175, 2975, 'Beilen', 10000, 1),
(17441, 82, 1810, 'Viry Noureuil', 10000, 1),
(17442, 254, 151, 'Colebrook', 10000, 1),
(17445, 65, 1498, 'Aabenraa', 10000, 1),
(17446, 254, 138, 'Arkansas City', 10000, 1),
(17447, 224, 3681, 'Welkom', 10000, 1),
(17448, 254, 135, 'Grand Ridge', 10000, 1),
(17449, 254, 159, 'Monmouth', 10000, 1),
(17450, 254, 144, 'Ovid', 10000, 1),
(17451, 43, 37, 'Midland', 10000, 1),
(17453, 96, 1911, 'Nuuk', 10000, 1),
(17454, 43, 36, 'Busby', 10000, 1),
(17455, 254, 157, 'Oak Hill', 10000, 1),
(17456, 254, 135, 'Caseyville', 10000, 1),
(17457, 43, 37, 'Thamesville', 10000, 1),
(17458, 254, 170, 'Winneconne', 10000, 1),
(17459, 91, 1919, 'Pirmasens', 10000, 1),
(17460, 254, 158, 'Okeene', 10000, 1),
(17463, 254, 137, 'Lohrville', 10000, 1),
(17464, 254, 165, 'Linden', 10000, 1),
(17465, 10, 1051, 'Ezeiza', 10000, 1),
(17466, 254, 147, 'Sunrise Beach', 10000, 1),
(17467, 254, 126, 'Camino', 10000, 1),
(17468, 253, 5391, 'Derry', 10000, 1),
(17469, 254, 157, 'Rootstown', 10000, 1),
(17470, 198, 3313, 'Vila Nova de Gaia', 10000, 1),
(17473, 254, 143, 'Barre', 10000, 1),
(17475, 24, 1135, 'Sombreffe', 10000, 1),
(17476, 254, 159, 'Saint Benedict', 10000, 1),
(17477, 254, 132, 'Bowersville', 10000, 1),
(17479, 254, 160, 'Fredonia', 10000, 1),
(17480, 254, 144, 'Columbiaville', 10000, 1),
(17481, 254, 155, 'Fairmont', 10000, 1),
(17482, 91, 1921, 'Ahrensburg', 10000, 1),
(17483, 254, 160, 'Kreamer', 10000, 1),
(17484, 254, 136, 'Saint John', 10000, 1),
(17485, 254, 155, 'Conover', 10000, 1),
(17489, 254, 127, 'Niwot', 10000, 1),
(17490, 149, 2907, 'Ampang', 10000, 1),
(17491, 254, 138, 'La Cygne', 10000, 1),
(17495, 254, 157, 'West Milton', 10000, 1),
(17497, 254, 125, 'Charleston', 10000, 1),
(17499, 254, 136, 'Laurel', 10000, 1),
(17500, 254, 144, 'Bloomfield Hills', 10000, 1),
(17501, 254, 138, 'Coffeyville', 10000, 1),
(17503, 239, 4089, 'Nakhon Ratchasima', 10000, 1),
(17504, 43, 35, 'Matane', 10000, 1),
(17505, 254, 131, 'Atlantic Beach', 10000, 1),
(17506, 254, 136, 'Garrett', 10000, 1),
(17507, 43, 43, 'Cobble Hill', 10000, 1),
(17510, 254, 160, 'Dallas', 10000, 1),
(17511, 254, 160, 'Abington', 10000, 1),
(17512, 213, 3633, 'Shaqra', 10000, 1),
(17514, 254, 137, 'Wellman', 10000, 1),
(17516, 195, 3418, 'Tagaytay', 10000, 1),
(17517, 113, 2191, 'Sivakasi', 10000, 1),
(17518, 254, 137, 'Coralville', 10000, 1),
(17519, 254, 145, 'Dawson', 10000, 1),
(17520, 253, 5392, 'Rustington', 10000, 1),
(17521, 253, 5392, 'East Preston', 10000, 1),
(17524, 144, 2623, 'Bourscheid', 10000, 1),
(17525, 254, 142, 'Lutherville Timonium', 10000, 1),
(17526, 254, 143, 'Foxboro', 10000, 1),
(17527, 254, 126, 'Calimesa', 10000, 1),
(17529, 24, 1136, 'Sint-Niklaas', 10000, 1),
(17530, 195, 3450, 'Taytay', 10000, 1),
(17531, 122, 2351, 'Nagano', 10000, 1),
(17532, 30, 5116, 'Bugojno', 10000, 1),
(17533, 254, 165, 'Waxahachie', 10000, 1),
(17534, 253, 5392, 'Coniston', 10000, 1),
(17535, 271, 5062, 'Bar', 10000, 1),
(17536, 24, 1129, 'Lierre', 10000, 1),
(17537, 24, 1131, 'La Louvi', 10000, 1),
(17538, 233, 4004, '', 10000, 1),
(17539, 82, 1813, 'Chambery', 10000, 1),
(17541, 202, 3370, 'Turda', 10000, 1),
(17542, 122, 2372, 'Kadena', 10000, 1),
(17543, 175, 2976, 'Oudega', 10000, 1),
(17544, 24, 1133, 'Bree', 10000, 1),
(17545, 254, 160, 'Lititz', 10000, 1),
(17547, 254, 155, 'Angier', 10000, 1),
(17549, 254, 165, 'Blue Ridge', 10000, 1),
(17550, 234, 4025, 'Lenzburg', 10000, 1),
(17552, 91, 1916, 'Friedberg', 10000, 1),
(17554, 81, 5023, 'Rauma', 10000, 1),
(17555, 91, 1913, 'Wittelshofen', 10000, 1),
(17556, 43, 35, 'Sorel', 10000, 1),
(17557, 43, 35, 'Tracy', 10000, 1),
(17558, 43, 35, 'Saint-Robert', 10000, 1),
(17560, 24, 1131, 'P', 10000, 1),
(17561, 43, 35, 'Yamaska', 10000, 1),
(17562, 43, 35, 'Sainte-Victoire', 10000, 1),
(17563, 43, 35, 'Saint-Joseph-de-Sorel', 10000, 1),
(17564, 43, 35, 'Saint-Ours', 10000, 1),
(17565, 43, 35, 'Baie Du Febvre', 10000, 1),
(17566, 43, 35, 'Pierreville', 10000, 1),
(17567, 43, 35, 'Odanak', 10000, 1),
(17569, 43, 35, 'Saint-Marcel', 10000, 1),
(17570, 43, 35, 'Saint-Louis', 10000, 1),
(17571, 43, 35, 'Saint-Jude', 10000, 1),
(17573, 43, 35, 'Dollard-des-Ormeaux', 10000, 1),
(17574, 254, 151, 'Hampstead', 10000, 1),
(17575, 43, 35, 'Saint-Donat-de-Montcalm', 10000, 1),
(17576, 14, 4, 'Lake Haven', 10000, 1),
(17577, 113, 2183, 'Imphal', 10000, 1),
(17578, 226, 3939, 'Torrevieja', 10000, 1),
(17579, 119, 2251, 'Alghero', 10000, 1),
(17580, 254, 164, 'Westmoreland', 10000, 1),
(17581, 253, 5392, 'Wilmslow', 10000, 1),
(17582, 254, 131, 'Fort Myers Beach', 10000, 1),
(17584, 254, 166, 'Hildale', 10000, 1),
(17585, 254, 160, 'Reynoldsville', 10000, 1),
(17586, 254, 128, 'Seymour', 10000, 1),
(17587, 254, 157, 'Heath', 10000, 1),
(17589, 254, 142, 'Essex', 10000, 1),
(17590, 254, 136, 'Culver', 10000, 1),
(17593, 254, 137, 'Columbus Junction', 10000, 1),
(17594, 254, 139, 'Rousseau', 10000, 1),
(17595, 254, 154, 'New Paltz', 10000, 1),
(17596, 254, 145, 'Saint Joseph', 10000, 1),
(17598, 254, 141, 'Fort Fairfield', 10000, 1),
(17600, 254, 170, 'Coleman', 10000, 1),
(17602, 95, 1962, 'Rafina', 10000, 1),
(17605, 254, 154, 'Pine City', 10000, 1),
(17606, 198, 3307, 'Vilamoura', 10000, 1),
(17607, 24, 1133, 'Maaseik', 10000, 1),
(17608, 254, 157, 'Navarre', 10000, 1),
(17610, 254, 160, 'Baden', 10000, 1),
(17611, 43, 36, 'olds', 10000, 1),
(17612, 43, 40, 'Caronport', 10000, 1),
(17614, 254, 165, 'Grandfalls', 10000, 1),
(17615, 254, 160, 'Beaver', 10000, 1),
(17616, 254, 137, 'Williamsburg', 10000, 1),
(17617, 254, 160, 'Alburtis', 10000, 1),
(17618, 254, 152, 'Rumson', 10000, 1),
(17619, 63, 1484, 'Kyrenia', 10000, 1),
(17620, 254, 158, 'Forgan', 10000, 1),
(17622, 254, 126, 'Piedmont', 10000, 1),
(17623, 254, 154, 'Galway', 10000, 1),
(17624, 254, 134, 'Rigby', 10000, 1),
(17625, 254, 164, 'Bells', 10000, 1),
(17626, 159, 2894, 'Culiacan', 10000, 1),
(17628, 254, 126, 'Loma Linda', 10000, 1),
(17629, 254, 142, 'Hebron', 10000, 1),
(17630, 254, 145, 'New Prague', 10000, 1),
(17631, 254, 157, 'Kitts Hill', 10000, 1),
(17632, 65, 1501, 'Herning', 10000, 1),
(17634, 149, 2902, 'Bentong', 10000, 1),
(17635, 175, 2975, 'Coevorden', 10000, 1),
(17636, 234, 4049, 'B', 10000, 1),
(17637, 233, 4004, 'Eksharad', 10000, 1),
(17638, 65, 1501, 'Sunds', 10000, 1),
(17640, 195, 3439, 'puerto galera', 10000, 1),
(17641, 91, 1923, 'Stralsund', 10000, 1),
(17642, 253, 5391, 'Portstewart', 10000, 1),
(17643, 37, 1242, 'Troyan', 10000, 1),
(17644, 37, 1247, 'Balchik', 10000, 1),
(17645, 134, 2441, 'Mishref', 10000, 1),
(17647, 254, 138, 'Burlingame', 10000, 1),
(17648, 175, 2980, 'Dongen', 10000, 1),
(17649, 254, 157, 'Chesapeake', 10000, 1),
(17651, 254, 135, 'Westville', 10000, 1),
(17652, 14, 4, 'Queanbeyan', 10000, 1),
(17653, 254, 125, 'Green Forest', 10000, 1),
(17654, 254, 154, 'Sound Beach', 10000, 1),
(17656, 81, 1777, 'Kemi', 10000, 1),
(17657, 149, 2902, 'Jerantut', 10000, 1),
(17660, 254, 137, 'Richland', 10000, 1),
(17662, 254, 160, 'Gratz', 10000, 1),
(17663, 254, 141, 'Kennebunk', 10000, 1),
(17665, 91, 1918, 'Meschede', 10000, 1),
(17667, 165, 2742, 'Erdenet', 10000, 1),
(17668, 254, 131, 'Riverview', 10000, 1),
(17669, 199, 736, 'Gurabo', 10000, 1),
(17671, 254, 162, 'Irmo', 10000, 1),
(17672, 254, 157, 'Sugar Grove', 10000, 1),
(17673, 65, 1499, 'Elken', 10000, 1),
(17674, 175, 2977, 'Kerk-Avezaath', 10000, 1),
(17675, 271, 3941, 'Novi Sad', 10000, 1),
(17676, 254, 145, 'Moose Lake', 10000, 1),
(17678, 254, 122, 'Sylacauga', 10000, 1),
(17679, 43, 43, 'Summerland', 10000, 1),
(17680, 91, 1914, 'Bremerhaven', 10000, 1),
(17681, 271, 5063, 'Jagodina', 10000, 1),
(17682, 175, 2983, 'De Bilt', 10000, 1),
(17684, 254, 148, 'Hysham', 10000, 1),
(17685, 254, 160, 'Holmes', 10000, 1),
(17686, 185, 2997, 'Mosjoen', 10000, 1),
(17687, 33, 29, 'Volta Redonda', 10000, 1),
(17689, 254, 140, 'Rodessa', 10000, 1),
(17690, 253, 5392, 'Sandy', 10000, 1),
(17692, 254, 157, 'Macedonia', 10000, 1),
(17693, 65, 1501, 'Holbaek', 10000, 1),
(17694, 91, 1917, 'Bergen', 10000, 1),
(17696, 254, 165, 'Leander', 10000, 1),
(17697, 254, 126, 'Windsor', 10000, 1),
(17698, 254, 131, 'Hudson', 10000, 1),
(17699, 254, 135, 'Princeville', 10000, 1),
(17700, 254, 126, 'Dos Palos', 10000, 1),
(17702, 253, 5392, 'Virginia Water', 10000, 1),
(17703, 254, 154, 'Penfield', 10000, 1),
(17705, 254, 122, 'Theodore', 10000, 1),
(17706, 254, 126, 'Villa Park', 10000, 1),
(17707, 253, 5392, 'Ilford', 10000, 1),
(17708, 91, 1913, 'Freising', 10000, 1),
(17711, 65, 1489, 'Grenaa', 10000, 1),
(17712, 271, 5063, 'Zemun', 10000, 1),
(17713, 271, 3941, 'Ada', 10000, 1),
(17714, 203, 110, 'Naberezhnye Chelny', 10000, 1),
(17715, 198, 3313, 'Pa', 10000, 1),
(17716, 253, 5392, 'Leigh', 10000, 1),
(17717, 254, 172, 'East Corinth', 10000, 1),
(17718, 254, 141, 'Corea', 10000, 1),
(17719, 254, 160, 'Zelienople', 10000, 1),
(17721, 226, 3935, 'Palafrugell', 10000, 1),
(17722, 254, 131, 'Lamont', 10000, 1),
(17723, 254, 160, 'Cranberry Twp', 10000, 1),
(17725, 254, 142, 'Rosedale', 10000, 1),
(17726, 14, 4, 'Hurstville', 10000, 1),
(17727, 149, 2903, 'Teluk Intan', 10000, 1),
(17729, 254, 154, 'Phelps', 10000, 1),
(17730, 175, 2983, 'Baarn', 10000, 1),
(17731, 254, 128, 'Waterford', 10000, 1),
(17732, 195, 3444, 'Dumaguete City', 10000, 1),
(17733, 43, 35, 'Longueuil', 10000, 1),
(17734, 254, 160, 'Waterford', 10000, 1),
(17737, 254, 152, 'Clementon', 10000, 1),
(17738, 254, 155, 'Blounts Creek', 10000, 1),
(17739, 65, 1501, 'Selde', 10000, 1),
(17740, 254, 135, 'North Aurora', 10000, 1),
(17741, 254, 155, 'Lake Waccamaw', 10000, 1),
(17742, 254, 165, 'Lake Dallas', 10000, 1),
(17743, 165, 2741, 'Ulaanbaatar', 10000, 1),
(17744, 14, 4, 'Cessnock', 10000, 1),
(17745, 254, 155, 'Norwood', 10000, 1),
(17746, 254, 142, 'Pomfret', 10000, 1),
(17747, 254, 165, 'Alto', 10000, 1),
(17748, 254, 126, 'Denair', 10000, 1),
(17749, 254, 122, 'Laceys Springs', 10000, 1),
(17750, 254, 165, 'Santa Fe', 10000, 1),
(17751, 254, 161, 'Exeter', 10000, 1),
(17752, 43, 40, 'Melville', 10000, 1),
(17753, 254, 144, 'Kinde', 10000, 1),
(17754, 254, 165, 'Los Fresnos', 10000, 1),
(17756, 43, 35, 'Verch', 10000, 1),
(17757, 254, 136, 'Fortville', 10000, 1),
(17760, 271, 5063, 'Obrenovac', 10000, 1),
(17761, 254, 157, 'Toronto', 10000, 1),
(17762, 254, 140, 'Delhi', 10000, 1),
(17763, 254, 134, 'Payette', 10000, 1),
(17765, 254, 139, 'Van Lear', 10000, 1),
(17766, 254, 160, 'Palmyra', 10000, 1),
(17767, 254, 137, 'Clearfield', 10000, 1),
(17769, 254, 122, 'Opp', 10000, 1),
(17771, 254, 166, 'Hyrum', 10000, 1),
(17773, 43, 43, 'Coquitlam', 10000, 1),
(17774, 254, 154, 'Van Hornesville', 10000, 1),
(17775, 254, 143, 'Dennis', 10000, 1),
(17776, 233, 4000, 'Finsp', 10000, 1),
(17777, 254, 124, 'Sonoita', 10000, 1),
(17778, 133, 2433, 'Kyongju', 10000, 1),
(17779, 254, 145, 'Saint Cloud', 10000, 1),
(17780, 65, 1489, 'Auning', 10000, 1),
(17781, 43, 36, 'Hinton', 10000, 1),
(17782, 224, 3683, 'Grahamstown', 10000, 1),
(17783, 152, 689, 'Saint Venera', 10000, 1),
(17784, 233, 4005, 'Vilhelmina', 10000, 1),
(17786, 138, 2484, 'Ashrafieh', 10000, 1),
(17787, 61, 5034, '', 10000, 1),
(17788, 149, 2905, 'Prai', 10000, 1),
(17789, 246, 4224, 'Isparta', 10000, 1),
(17792, 271, 5063, 'Topola', 10000, 1),
(17793, 65, 1489, 'Tranbjerg', 10000, 1),
(17795, 254, 126, 'Balboa', 10000, 1),
(17796, 254, 160, 'Port Allegany', 10000, 1),
(17797, 224, 3689, 'Somerset West', 10000, 1),
(17798, 224, 3689, 'Robertson', 10000, 1),
(17799, 254, 125, 'Cherry Valley', 10000, 1),
(17800, 254, 143, 'Norfolk', 10000, 1),
(17801, 224, 3684, 'Bedfordview', 10000, 1),
(17802, 119, 2253, 'Massa', 10000, 1),
(17803, 254, 172, 'Middlebury', 10000, 1),
(17804, 195, 3419, 'Lapu-Lapu City', 10000, 1),
(17805, 253, 5392, 'Kenilworth', 10000, 1),
(17807, 175, 2980, 'Veldhoven', 10000, 1),
(17808, 195, 3435, 'Tacloban City', 10000, 1),
(17810, 275, 5388, 'Gaza City', 10000, 1),
(17811, 199, 736, 'Maunabo', 10000, 1),
(17812, 254, 155, 'Beulaville', 10000, 1),
(17813, 254, 143, 'Sandwich', 10000, 1),
(17814, 43, 37, 'Casselman', 10000, 1),
(17815, 254, 132, 'Grayson', 10000, 1),
(17816, 254, 157, 'Hartville', 10000, 1),
(17818, 198, 3300, 'Santo Jo', 10000, 1),
(17819, 254, 122, 'Bayou La Batre', 10000, 1),
(17820, 254, 122, 'Coden', 10000, 1),
(17822, 254, 154, 'South Colton', 10000, 1),
(17823, 195, 3431, 'Laguna', 10000, 1),
(17824, 195, 3431, 'San Pedro', 10000, 1),
(17825, 254, 127, 'Fountain', 10000, 1),
(17826, 254, 165, 'Van', 10000, 1),
(17827, 254, 135, 'Itasca', 10000, 1),
(17829, 254, 131, 'Defuniak Springs', 10000, 1),
(17830, 65, 1494, 'Hirtshals', 10000, 1),
(17831, 254, 168, 'Kingston', 10000, 1),
(17832, 224, 3684, 'Vanderbijlpark', 10000, 1),
(17834, 254, 126, 'Glen Ellen', 10000, 1),
(17835, 118, 2234, 'Araba', 10000, 1),
(17837, 254, 136, 'Rockport', 10000, 1),
(17838, 91, 1921, 'Kaltenkirchen', 10000, 1),
(17840, 224, 3684, 'Rivonia', 10000, 1),
(17841, 254, 154, 'Harrisville', 10000, 1),
(17842, 254, 125, 'Dardanelle', 10000, 1),
(17843, 254, 157, 'Lewis Center', 10000, 1),
(17844, 185, 2997, 'Stokmarknes', 10000, 1),
(17845, 254, 147, 'Sullivan', 10000, 1),
(17847, 254, 155, 'Mooresville', 10000, 1),
(17848, 198, 3314, 'Abrantes', 10000, 1),
(17849, 253, 5392, 'Leicester', 10000, 1),
(17850, 48, 1373, 'Puerto Williams', 10000, 1),
(17851, 43, 37, 'Port Colborne', 10000, 1),
(17852, 221, 3731, 'Gornja Radgona', 10000, 1),
(17853, 254, 172, 'Poultney', 10000, 1),
(17854, 101, 638, 'Saint Peter Port', 10000, 1),
(17855, 254, 168, 'Mountlake Terrace', 10000, 1),
(17856, 117, 1609, 'Edgeworthstown', 10000, 1),
(17857, 254, 160, 'Tamaqua', 10000, 1),
(17858, 114, 2149, 'Blitar', 10000, 1),
(17859, 254, 154, 'Yaphank', 10000, 1),
(17862, 224, 3684, 'Centurion', 10000, 1),
(17864, 254, 141, 'Belfast', 10000, 1),
(17865, 254, 160, 'Strattanville', 10000, 1),
(17866, 254, 149, 'Byron', 10000, 1),
(17867, 24, 1134, 'Arlon', 10000, 1),
(17868, 144, 2625, 'Pontpierre', 10000, 1),
(17869, 254, 157, 'Windham', 10000, 1),
(17871, 254, 154, 'Fort Plain', 10000, 1),
(17872, 91, 1922, 'Brandenburg', 10000, 1),
(17873, 61, 5044, 'Samobor', 10000, 1),
(17874, 72, 1648, 'La Libertad', 10000, 1),
(17875, 43, 37, 'New Liskeard', 10000, 1),
(17878, 254, 145, 'Princeton', 10000, 1),
(17879, 254, 162, 'Williston', 10000, 1),
(17880, 254, 151, 'New London', 10000, 1),
(17882, 254, 152, 'Gibbstown', 10000, 1),
(17883, 254, 152, 'Somerdale', 10000, 1),
(17884, 254, 135, 'Erie', 10000, 1),
(17885, 65, 1494, 'Pandrup', 10000, 1),
(17887, 254, 162, 'North Myrtle Beach', 10000, 1),
(17888, 254, 128, 'Woodstock', 10000, 1),
(17889, 253, 5392, 'Marlow', 10000, 1),
(17891, 254, 154, 'Chappaqua', 10000, 1),
(17892, 271, 3941, 'Senta', 10000, 1),
(17893, 43, 35, 'Masson', 10000, 1),
(17894, 254, 132, 'Powder Springs', 10000, 1),
(17895, 233, 4008, 'Vaxholm', 10000, 1),
(17897, 15, 1077, 'Sankt P', 10000, 1),
(17899, 254, 122, 'Gulf Shores', 10000, 1),
(17900, 254, 158, 'Jay', 10000, 1),
(17901, 254, 168, 'Greenbank', 10000, 1),
(17902, 254, 155, 'Vass', 10000, 1),
(17903, 254, 141, 'Greene', 10000, 1),
(17904, 253, 5392, 'Woodford', 10000, 1),
(17905, 254, 142, 'Crownsville', 10000, 1),
(17906, 254, 160, 'Mount Pleasant', 10000, 1),
(17907, 91, 1912, 'Muellheim', 10000, 1),
(17909, 254, 142, 'Manchester', 10000, 1),
(17911, 254, 145, 'Hastings', 10000, 1),
(17912, 219, 756, 'Singapore', 10000, 1),
(17914, 254, 142, 'Elkridge', 10000, 1),
(17917, 254, 165, 'Cumby', 10000, 1),
(17918, 254, 146, 'Sumrall', 10000, 1),
(17919, 254, 123, 'Nenana', 10000, 1),
(17920, 254, 143, 'Raynham', 10000, 1),
(17922, 254, 132, 'Ila', 10000, 1),
(17923, 43, 37, 'Marathon', 10000, 1),
(17924, 254, 160, 'Pomeroy', 10000, 1),
(17925, 122, 2339, 'Ibaraki', 10000, 1),
(17926, 254, 135, 'Lake Zurich', 10000, 1),
(17927, 43, 37, 'Lancaster', 10000, 1),
(17928, 254, 172, 'Cambridge', 10000, 1),
(17929, 233, 4008, 'Huddinge', 10000, 1),
(17930, 254, 172, 'Underhill', 10000, 1),
(17931, 122, 2335, 'Gunma', 10000, 1),
(17932, 254, 160, 'Dallastown', 10000, 1),
(17933, 254, 148, 'Pony', 10000, 1),
(17934, 254, 160, 'Millheim', 10000, 1),
(17935, 254, 129, 'Claymont', 10000, 1),
(17936, 254, 160, 'Duryea', 10000, 1),
(17937, 254, 165, 'Terrel', 10000, 1),
(17938, 254, 144, 'Wetmore', 10000, 1),
(17941, 48, 1364, 'Recreo', 10000, 1),
(17944, 254, 158, 'Big Cabin', 10000, 1),
(17945, 254, 145, 'Saint Francis', 10000, 1),
(17946, 254, 155, 'Swansboro', 10000, 1),
(17948, 254, 144, 'Quincy', 10000, 1),
(17949, 254, 144, 'Burr Oak', 10000, 1),
(17950, 254, 154, 'Long Island City', 10000, 1),
(17951, 254, 154, 'Congers', 10000, 1),
(17953, 254, 137, 'Gravity', 10000, 1),
(17955, 254, 131, 'Lake Panasoffkee', 10000, 1),
(17956, 254, 157, 'Clayton', 10000, 1),
(17958, 201, 738, 'Saint-Denis', 10000, 1),
(17959, 178, 5020, 'Greymouth', 10000, 1),
(17960, 254, 123, 'Craig', 10000, 1),
(17961, 24, 5306, 'Koningslo', 10000, 1),
(17962, 85, 622, 'Papeete', 10000, 1),
(17963, 254, 168, 'Sumner', 10000, 1),
(17964, 233, 3998, 'Arvidsjaur', 10000, 1),
(17966, 254, 126, 'Morongo Valley', 10000, 1),
(17967, 234, 4030, 'Orsonnens', 10000, 1),
(17968, 91, 1912, 'Reutlingen', 10000, 1),
(17969, 14, 4, 'Bourke', 10000, 1),
(17970, 254, 126, 'Sierra Madre', 10000, 1),
(17971, 221, 3842, 'Vrhnika', 10000, 1),
(17976, 233, 3998, '', 10000, 1),
(17977, 43, 42, 'Sussex', 10000, 1),
(17978, 43, 42, 'Petitcodiac', 10000, 1),
(17979, 254, 141, 'Sangerville', 10000, 1),
(17980, 91, 1918, 'Hennef', 10000, 1),
(17982, 195, 3505, 'Pateros', 10000, 1),
(17983, 24, 1133, 'Dilsen', 10000, 1),
(17984, 254, 152, 'Ringwood', 10000, 1),
(17985, 254, 136, 'Metamora', 10000, 1),
(17986, 43, 37, 'Calabogie', 10000, 1),
(17987, 254, 124, 'Salome', 10000, 1),
(17988, 254, 154, 'Sayville', 10000, 1),
(17989, 254, 167, 'Chincoteague', 10000, 1),
(17990, 254, 145, 'Twin Cities', 10000, 1),
(17992, 43, 37, 'Caledon', 10000, 1),
(17993, 43, 43, 'Golden', 10000, 1),
(17994, 254, 145, 'Eveleth', 10000, 1),
(17995, 43, 43, 'Okanagan Falls', 10000, 1),
(17996, 254, 147, 'Old Monroe', 10000, 1),
(17998, 134, 2442, 'Salmiya', 10000, 1),
(17999, 20, 1164, 'Saginaw', 10000, 1),
(18000, 232, 4659, 'Mbabane', 10000, 1),
(18002, 24, 1133, 'Lanaken', 10000, 1),
(18003, 254, 152, 'Oakland', 10000, 1),
(18004, 175, 2984, 'Goes', 10000, 1),
(18005, 254, 132, 'Lincolnton', 10000, 1),
(18006, 233, 3993, 'V', 10000, 1),
(18008, 239, 4115, 'Nakorn Panom', 10000, 1),
(18009, 254, 149, 'Panama', 10000, 1),
(18010, 239, 4104, 'Samudh Prakarn', 10000, 1),
(18012, 149, 2909, 'Sentul', 10000, 1),
(18013, 254, 168, 'Burbank', 10000, 1),
(18014, 43, 36, 'Fort Saskatchewan', 10000, 1),
(18015, 254, 159, 'Canby', 10000, 1),
(18016, 254, 159, 'Aurora', 10000, 1),
(18017, 254, 160, 'Brockway', 10000, 1),
(18018, 254, 136, 'Churubusco', 10000, 1),
(18019, 254, 132, 'Wadley', 10000, 1),
(18020, 221, 3754, 'Naklo', 10000, 1),
(18021, 254, 138, 'Walton', 10000, 1),
(18022, 119, 2246, 'Olgiate Olona', 10000, 1),
(18023, 254, 160, 'Mercer', 10000, 1),
(18024, 254, 131, 'Oviedo', 10000, 1),
(18025, 271, 3941, 'Kula', 10000, 1),
(18026, 271, 3941, 'Sombor', 10000, 1),
(18027, 254, 159, 'Clatskanie', 10000, 1),
(18028, 43, 37, 'Goderich', 10000, 1),
(18029, 254, 143, 'Fairhaven', 10000, 1),
(18030, 233, 4008, 'Tyres', 10000, 1),
(18031, 254, 157, 'New Concord', 10000, 1),
(18032, 43, 35, 'Saint-Basile ', 10000, 1),
(18033, 43, 37, 'Vankleek Hill', 10000, 1),
(18035, 254, 137, 'Adair', 10000, 1),
(18037, 119, 2254, 'Trento', 10000, 1),
(18038, 254, 154, 'Northville', 10000, 1),
(18039, 254, 172, 'Norwich', 10000, 1),
(18040, 91, 1924, 'Riesa', 10000, 1),
(18041, 271, 5063, 'Leskovac', 10000, 1),
(18042, 254, 134, 'Wallace', 10000, 1),
(18043, 43, 43, 'Lumby', 10000, 1),
(18045, 254, 131, 'Callahan', 10000, 1),
(18046, 49, 1336, 'Jiangyin', 10000, 1),
(18047, 43, 37, 'Rexdale', 10000, 1),
(18048, 239, 4108, 'Chon Buri', 10000, 1),
(18049, 254, 172, 'Castleton', 10000, 1),
(18050, 254, 139, 'Dawson Springs', 10000, 1),
(18051, 254, 137, 'Story City', 10000, 1),
(18052, 254, 131, 'Lehigh Acres', 10000, 1),
(18053, 254, 124, 'Pearce', 10000, 1),
(18054, 254, 154, 'Bohemia', 10000, 1),
(18055, 199, 736, 'Toa Baja', 10000, 1),
(18056, 43, 36, 'Barrhead', 10000, 1),
(18058, 254, 144, 'Marysville', 10000, 1),
(18059, 254, 140, 'Carencro', 10000, 1),
(18060, 254, 172, 'South Londonberry', 10000, 1),
(18062, 82, 1812, 'Martigues', 10000, 1),
(18063, 224, 3684, 'Gauteng', 10000, 1),
(18064, 252, 5002, 'Garhoud', 10000, 1),
(18066, 254, 140, 'Deville', 10000, 1),
(18068, 133, 2432, 'Buchon', 10000, 1),
(18069, 175, 2985, 'Voorburg', 10000, 1),
(18070, 91, 1921, 'Wedel', 10000, 1),
(18071, 254, 155, 'Faison', 10000, 1),
(18073, 234, 4029, 'Bienne', 10000, 1),
(18074, 254, 165, 'Kerens', 10000, 1),
(18075, 254, 167, 'Clifton Forge', 10000, 1),
(18076, 254, 142, 'Swanton', 10000, 1),
(18077, 122, 2329, 'Kamagaya', 10000, 1),
(18079, 254, 144, 'Centreville', 10000, 1),
(18081, 254, 149, 'Doniphan', 10000, 1),
(18082, 122, 2355, 'Nakatsu', 10000, 1),
(18083, 43, 36, 'Crowsnest Pass', 10000, 1),
(18084, 254, 154, 'Brewerton', 10000, 1),
(18086, 253, 5392, 'Woolavington', 10000, 1),
(18087, 174, 3009, 'Banepa', 10000, 1),
(18088, 118, 2233, 'Modiin', 10000, 1),
(18089, 254, 145, 'Dent', 10000, 1),
(18090, 254, 125, 'Mc Gehee', 10000, 1),
(18091, 253, 5390, 'Dumfries', 10000, 1),
(18092, 254, 152, 'Hamburg', 10000, 1),
(18093, 254, 164, 'Mercer', 10000, 1),
(18094, 254, 154, 'Liverpool', 10000, 1),
(18095, 254, 137, 'Langworthy', 10000, 1),
(18097, 33, 32, 'Santo ', 10000, 1),
(18098, 254, 139, 'Wilmore', 10000, 1),
(18100, 254, 136, 'Rome City', 10000, 1),
(18102, 254, 154, 'Hamburg', 10000, 1),
(18103, 254, 160, 'Albion', 10000, 1),
(18106, 254, 144, 'Bronson', 10000, 1),
(18107, 254, 157, 'Rockbridge', 10000, 1),
(18108, 119, 2251, 'Olbia', 10000, 1),
(18109, 14, 1, 'Bacchus Marsh', 10000, 1),
(18110, 149, 2905, 'Butterworth', 10000, 1),
(18111, 239, 4106, 'Klong Luang Peng', 10000, 1),
(18112, 175, 2982, 'Genemuiden', 10000, 1),
(18113, 254, 160, 'Bowmansdale', 10000, 1),
(18114, 254, 126, 'Happy Camp', 10000, 1),
(18115, 234, 4047, 'Bex', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(18116, 254, 144, 'La Salle', 10000, 1),
(18117, 65, 1491, 'Farum', 10000, 1),
(18118, 119, 2251, 'Sassari', 10000, 1),
(18120, 233, 4000, 'Haninge', 10000, 1),
(18121, 254, 168, 'Wapato', 10000, 1),
(18122, 254, 144, 'Fowlerville', 10000, 1),
(18123, 43, 35, 'Sainte-Julie', 10000, 1),
(18124, 254, 142, 'Churchton', 10000, 1),
(18125, 254, 156, 'Wishek', 10000, 1),
(18126, 117, 1601, 'Tallaght', 10000, 1),
(18128, 254, 162, 'Norway', 10000, 1),
(18129, 43, 37, 'Stirling', 10000, 1),
(18130, 233, 4010, 'T', 10000, 1),
(18131, 254, 152, 'Ridgefield', 10000, 1),
(18132, 254, 160, 'Shamokin Dam', 10000, 1),
(18133, 43, 36, 'Saint Paul', 10000, 1),
(18134, 254, 140, 'Broussard', 10000, 1),
(18135, 254, 122, 'Albertville', 10000, 1),
(18136, 254, 169, 'New Haven', 10000, 1),
(18137, 254, 134, 'Fruitland', 10000, 1),
(18138, 254, 157, 'Bedford', 10000, 1),
(18139, 271, 3941, 'Kisac', 10000, 1),
(18140, 246, 4192, 'Adana', 10000, 1),
(18141, 246, 4264, 'Konya', 10000, 1),
(18142, 118, 2233, 'Ashdod', 10000, 1),
(18143, 91, 1912, 'Gaienhofen', 10000, 1),
(18144, 254, 164, 'Holladay', 10000, 1),
(18145, 254, 167, 'Painter', 10000, 1),
(18146, 271, 3941, 'Zrenjanin', 10000, 1),
(18148, 254, 147, 'Mountain View', 10000, 1),
(18149, 254, 149, 'Elba', 10000, 1),
(18150, 254, 135, 'Winnetka', 10000, 1),
(18151, 234, 4026, 'Herisau', 10000, 1),
(18152, 57, 594, 'Rarotonga', 10000, 1),
(18153, 57, 594, 'Avarua', 10000, 1),
(18156, 119, 2244, 'Ostia', 10000, 1),
(18157, 254, 153, 'Hagerman', 10000, 1),
(18158, 254, 168, 'Palouse', 10000, 1),
(18160, 199, 736, 'Manati', 10000, 1),
(18164, 254, 166, 'Castle Dale', 10000, 1),
(18166, 254, 126, 'Jamestown', 10000, 1),
(18167, 234, 4044, 'Chiasso', 10000, 1),
(18168, 195, 3407, 'Batangas', 10000, 1),
(18169, 119, 2242, 'Scandiano', 10000, 1),
(18171, 253, 5392, 'Weymouth', 10000, 1),
(18172, 254, 139, 'Pine Knot', 10000, 1),
(18176, 254, 162, 'Cayce', 10000, 1),
(18178, 254, 135, 'Prophetstown', 10000, 1),
(18179, 254, 162, 'Westminster', 10000, 1),
(18180, 254, 155, 'King', 10000, 1),
(18182, 119, 2249, 'Cuneo', 10000, 1),
(18183, 254, 168, 'Roy', 10000, 1),
(18184, 119, 2252, 'Trapani', 10000, 1),
(18185, 65, 1492, 'Tulleb', 10000, 1),
(18188, 254, 144, 'Chelsea', 10000, 1),
(18189, 254, 165, 'Springtown', 10000, 1),
(18191, 254, 122, 'Elba', 10000, 1),
(18192, 254, 164, 'Friendship', 10000, 1),
(18193, 91, 1913, 'Attenkirchen', 10000, 1),
(18194, 43, 40, 'Weyburn', 10000, 1),
(18196, 213, 3632, 'Rass', 10000, 1),
(18198, 254, 138, 'Haviland', 10000, 1),
(18199, 254, 144, 'Hadley', 10000, 1),
(18200, 254, 122, 'RainbowCity', 10000, 1),
(18201, 119, 2242, 'Sala Bolognese', 10000, 1),
(18203, 91, 1918, 'Lippstadt', 10000, 1),
(18204, 134, 2439, 'Safat', 10000, 1),
(18205, 219, 756, 'Queenstown', 10000, 1),
(18206, 202, 3362, 'Salonta', 10000, 1),
(18207, 254, 171, 'Glenrock', 10000, 1),
(18214, 254, 144, 'Macomb', 10000, 1),
(18216, 91, 1918, 'Geldern', 10000, 1),
(18218, 254, 143, 'North Reading', 10000, 1),
(18219, 119, 2241, 'torre del greco', 10000, 1),
(18220, 254, 158, 'Purcell', 10000, 1),
(18222, 254, 154, 'Perry', 10000, 1),
(18223, 178, 3126, 'Winton', 10000, 1),
(18225, 202, 3362, 'Oradea', 10000, 1),
(18226, 64, 5127, 'Semily', 10000, 1),
(18227, 64, 5129, 'Opava', 10000, 1),
(18228, 64, 5123, 'T', 10000, 1),
(18229, 64, 5133, 'Decin', 10000, 1),
(18230, 195, 3450, 'Antipolo', 10000, 1),
(18231, 254, 136, 'Gas City', 10000, 1),
(18232, 65, 1494, 'Andrup', 10000, 1),
(18233, 64, 5132, 'Mlada Boleslav', 10000, 1),
(18234, 64, 5129, 'Frydek-Mistek', 10000, 1),
(18235, 64, 5125, 'Cheb', 10000, 1),
(18236, 64, 5130, 'Lan', 10000, 1),
(18237, 254, 139, 'Vine Grove', 10000, 1),
(18238, 254, 144, 'Coleman', 10000, 1),
(18241, 254, 157, 'Forest', 10000, 1),
(18242, 64, 5133, 'Teplice', 10000, 1),
(18243, 64, 5130, 'Chocen', 10000, 1),
(18244, 254, 122, 'Cedar Bluff', 10000, 1),
(18245, 111, 2078, 'Esztergom', 10000, 1),
(18247, 64, 5122, 'Blansko', 10000, 1),
(18249, 64, 5132, 'Kralupy Nad Vltavou', 10000, 1),
(18250, 233, 4007, 'Fagersta', 10000, 1),
(18251, 254, 131, 'Micanopy', 10000, 1),
(18252, 91, 1913, 'Ingolstadt', 10000, 1),
(18253, 91, 1913, 'Traunstein', 10000, 1),
(18257, 253, 5392, 'Lakenheath', 10000, 1),
(18258, 254, 131, 'Silver Springs', 10000, 1),
(18259, 24, 1136, 'Gavere', 10000, 1),
(18261, 254, 167, 'Gainesville', 10000, 1),
(18263, 254, 159, 'Winchester', 10000, 1),
(18264, 254, 138, 'Arnold', 10000, 1),
(18266, 254, 144, 'Hamburg', 10000, 1),
(18267, 254, 147, 'Smithton', 10000, 1),
(18268, 254, 157, 'Clyde', 10000, 1),
(18269, 119, 2244, 'Castelnuovo Di porto', 10000, 1),
(18271, 254, 157, 'Olmsted Falls', 10000, 1),
(18273, 254, 165, 'Chico', 10000, 1),
(18274, 91, 1920, 'Homburg', 10000, 1),
(18275, 254, 127, 'Springfield', 10000, 1),
(18276, 254, 132, 'Young Harris', 10000, 1),
(18277, 243, 4056, 'Sangre Grande', 10000, 1),
(18278, 149, 2911, 'Sandakan', 10000, 1),
(18279, 175, 2984, 'Sluis', 10000, 1),
(18280, 175, 2976, 'Kootstertille', 10000, 1),
(18281, 254, 155, 'Zebulon', 10000, 1),
(18282, 43, 37, 'Tillsonburg', 10000, 1),
(18283, 254, 137, 'Ocheyedan', 10000, 1),
(18284, 254, 163, 'Veblen', 10000, 1),
(18287, 43, 43, 'Gibsons', 10000, 1),
(18288, 254, 147, 'Cabool', 10000, 1),
(18289, 254, 170, 'Lake Geneva', 10000, 1),
(18290, 91, 1923, 'Lug', 10000, 1),
(18292, 254, 168, 'Mabton', 10000, 1),
(18294, 254, 158, 'Carnegie', 10000, 1),
(18295, 202, 3392, 'Sinnicolaul Mare', 10000, 1),
(18296, 254, 132, 'Ray City', 10000, 1),
(18297, 119, 2243, 'Budoia', 10000, 1),
(18298, 198, 3300, 'Aveiro', 10000, 1),
(18299, 254, 160, 'Sandy Lake', 10000, 1),
(18300, 178, 4729, 'Whakatane', 10000, 1),
(18301, 43, 35, 'Saint-Lambert', 10000, 1),
(18302, 254, 152, 'Branchville', 10000, 1),
(18304, 198, 3315, 'Sines', 10000, 1),
(18306, 254, 160, 'Ford City', 10000, 1),
(18307, 254, 165, 'Devine', 10000, 1),
(18308, 254, 135, 'Loraine', 10000, 1),
(18309, 43, 35, 'Riviere-du-Loup', 10000, 1),
(18310, 49, 1334, 'wenzhou', 10000, 1),
(18311, 116, 2322, 'Nineveh', 10000, 1),
(18312, 254, 145, 'Harmony', 10000, 1),
(18313, 254, 168, 'South Bend', 10000, 1),
(18314, 43, 35, 'Saint-Pascal', 10000, 1),
(18315, 43, 37, 'Westport', 10000, 1),
(18316, 254, 160, 'Valley Forge', 10000, 1),
(18317, 254, 149, 'Clarks', 10000, 1),
(18319, 254, 144, 'Napoleon', 10000, 1),
(18321, 147, 2676, 'Madagascar', 10000, 1),
(18322, 254, 147, 'Gerald', 10000, 1),
(18324, 254, 149, 'Snyder', 10000, 1),
(18325, 64, 5123, 'Ceske Budejovice', 10000, 1),
(18326, 203, 3589, 'Artem', 10000, 1),
(18327, 24, 1136, 'Dendermonde', 10000, 1),
(18328, 195, 3400, 'Butuan City', 10000, 1),
(18330, 198, 3311, 'Vila Franca de Xira', 10000, 1),
(18331, 91, 1913, 'Landsberg Am Lech', 10000, 1),
(18332, 43, 37, 'Dorset', 10000, 1),
(18333, 254, 152, 'Pine Hill', 10000, 1),
(18334, 64, 5132, 'Pribram', 10000, 1),
(18335, 254, 140, 'Haughton', 10000, 1),
(18336, 64, 5132, 'Obecnice', 10000, 1),
(18337, 254, 160, 'Center Valley', 10000, 1),
(18338, 119, 2240, 'Vibo Valentia', 10000, 1),
(18341, 254, 154, 'Forest Hills', 10000, 1),
(18342, 149, 2900, 'Jasin', 10000, 1),
(18343, 24, 1129, 'Reet', 10000, 1),
(18344, 254, 155, 'Maiden', 10000, 1),
(18348, 113, 2179, 'Cochin', 10000, 1),
(18350, 254, 152, 'Windsor', 10000, 1),
(18351, 199, 736, 'Cabo Rojo', 10000, 1),
(18352, 254, 158, 'Pond Creek', 10000, 1),
(18353, 254, 133, 'Waikoloa', 10000, 1),
(18354, 159, 196, 'Juarez', 10000, 1),
(18355, 254, 122, 'Gardendale', 10000, 1),
(18357, 187, 3219, 'Shekhupura', 10000, 1),
(18358, 254, 166, 'Grantsville', 10000, 1),
(18359, 185, 3003, 'Stryn', 10000, 1),
(18360, 185, 2990, 'Frogner', 10000, 1),
(18362, 224, 3684, 'Boksburg', 10000, 1),
(18363, 254, 128, 'Granby', 10000, 1),
(18364, 254, 155, 'Cherryville', 10000, 1),
(18365, 254, 162, 'Denmark', 10000, 1),
(18366, 43, 37, 'Dorchester', 10000, 1),
(18367, 254, 125, 'Alma', 10000, 1),
(18368, 149, 2907, 'Ulu Kelang', 10000, 1),
(18369, 149, 2901, 'Jelebu', 10000, 1),
(18370, 254, 122, 'Geneva', 10000, 1),
(18373, 234, 4036, 'Les Geneveys-sur-Coffrane', 10000, 1),
(18374, 254, 158, 'Choctaw', 10000, 1),
(18375, 254, 134, 'Blackfoot', 10000, 1),
(18376, 254, 170, 'Pittsville', 10000, 1),
(18377, 64, 5131, 'Stod', 10000, 1),
(18378, 61, 5034, 'Omi', 10000, 1),
(18379, 254, 133, 'Kalaheo', 10000, 1),
(18380, 175, 2983, 'Zeist', 10000, 1),
(18381, 149, 2907, 'Serdang', 10000, 1),
(18383, 64, 5126, 'N', 10000, 1),
(18384, 159, 72, 'Akumal', 10000, 1),
(18385, 37, 1244, 'Smolyan', 10000, 1),
(18386, 254, 165, 'Groves', 10000, 1),
(18388, 254, 155, 'Bailey', 10000, 1),
(18389, 15, 1079, 'Zell am See', 10000, 1),
(18390, 254, 125, 'Rison', 10000, 1),
(18391, 175, 2980, 'Oosterhout', 10000, 1),
(18392, 254, 135, 'Sandwich', 10000, 1),
(18394, 243, 4051, 'Arima', 10000, 1),
(18396, 254, 135, 'Mulkeytown', 10000, 1),
(18397, 254, 160, 'Williamstown', 10000, 1),
(18398, 95, 1967, 'Kalamata', 10000, 1),
(18399, 254, 144, 'Reese', 10000, 1),
(18400, 254, 145, 'Morton', 10000, 1),
(18401, 233, 4008, 'Botkyrka', 10000, 1),
(18402, 234, 4042, 'Solothurn', 10000, 1),
(18403, 254, 157, 'Avon Lake', 10000, 1),
(18405, 254, 154, 'Guilford', 10000, 1),
(18406, 152, 689, 'Saint Julians', 10000, 1),
(18407, 43, 37, 'Keene', 10000, 1),
(18408, 254, 160, 'Derry', 10000, 1),
(18409, 254, 165, 'Valley View', 10000, 1),
(18411, 109, 646, 'Tai Po', 10000, 1),
(18412, 82, 1803, 'Charenton-le-Pont', 10000, 1),
(18413, 156, 4975, 'Nouakchott', 10000, 1),
(18414, 254, 134, 'Nezperce', 10000, 1),
(18415, 254, 128, 'New Canaan', 10000, 1),
(18416, 254, 152, 'North Arlington', 10000, 1),
(18417, 254, 169, 'Shepherdstown', 10000, 1),
(18418, 64, 5127, 'Jablonec nad Nisou', 10000, 1),
(18419, 147, 2676, 'Nosy-Be', 10000, 1),
(18421, 254, 160, 'Horsham', 10000, 1),
(18423, 254, 157, 'Fostoria', 10000, 1),
(18424, 254, 136, 'Cannelton', 10000, 1),
(18425, 254, 157, 'Perrysville', 10000, 1),
(18426, 254, 168, 'Selah', 10000, 1),
(18427, 254, 168, 'Waitsburg', 10000, 1),
(18428, 254, 137, 'Remsen', 10000, 1),
(18429, 254, 160, 'Spring Mills', 10000, 1),
(18430, 254, 131, 'Chiefland', 10000, 1),
(18431, 254, 135, 'Alsip', 10000, 1),
(18432, 254, 126, 'Midpines', 10000, 1),
(18433, 254, 167, 'Studley', 10000, 1),
(18434, 43, 37, 'Blenheim', 10000, 1),
(18435, 254, 136, 'Westville', 10000, 1),
(18436, 253, 5392, 'Birkenhead', 10000, 1),
(18437, 254, 154, 'Hancock', 10000, 1),
(18438, 254, 171, 'Mills', 10000, 1),
(18441, 254, 144, 'Elk Rapids', 10000, 1),
(18442, 254, 124, 'Black Canyon City', 10000, 1),
(18443, 254, 132, 'Wrens', 10000, 1),
(18445, 254, 155, 'Dunn', 10000, 1),
(18446, 254, 144, 'Riga', 10000, 1),
(18447, 254, 132, 'Oconee', 10000, 1),
(18448, 91, 1918, 'Dormagen', 10000, 1),
(18449, 221, 3833, 'Trzic', 10000, 1),
(18450, 254, 122, 'Parrish', 10000, 1),
(18451, 254, 147, 'Bernie', 10000, 1),
(18452, 14, 4, 'Bankstown', 10000, 1),
(18453, 254, 132, 'Cave Spring', 10000, 1),
(18454, 254, 136, 'Crane', 10000, 1),
(18455, 254, 144, 'Laingsburg', 10000, 1),
(18456, 254, 137, 'Scarville', 10000, 1),
(18459, 117, 1604, 'Leixlip', 10000, 1),
(18461, 119, 2247, 'Jesi', 10000, 1),
(18463, 233, 4008, 'Vallentuna', 10000, 1),
(18466, 221, 3723, 'Sentjost', 10000, 1),
(18467, 254, 145, 'Mound', 10000, 1),
(18468, 254, 154, 'Johnson City', 10000, 1),
(18469, 185, 2999, 'Jevnaker', 10000, 1),
(18470, 254, 148, 'Ashland', 10000, 1),
(18471, 254, 143, 'Hull', 10000, 1),
(18472, 171, 4637, 'Swakopmund', 10000, 1),
(18473, 43, 35, 'Les M', 10000, 1),
(18474, 95, 1943, 'Katerini', 10000, 1),
(18477, 254, 160, 'Carnegie', 10000, 1),
(18480, 114, 2149, 'Sidoarjo', 10000, 1),
(18482, 114, 2149, 'Pasuruan', 10000, 1),
(18483, 254, 164, 'Jonesborough', 10000, 1),
(18484, 219, 756, 'Choa Chu Kang', 10000, 1),
(18485, 254, 137, 'Ellsworth', 10000, 1),
(18486, 254, 137, 'Clive', 10000, 1),
(18487, 113, 2182, 'Ahmednagar', 10000, 1),
(18488, 233, 4008, 'Liding', 10000, 1),
(18490, 254, 138, 'Udall', 10000, 1),
(18492, 253, 5392, 'Lowestoft', 10000, 1),
(18493, 254, 158, 'Rattan', 10000, 1),
(18497, 104, 2030, 'Jonestown', 10000, 1),
(18500, 254, 147, 'De Soto', 10000, 1),
(18503, 254, 127, 'Carbondale', 10000, 1),
(18504, 30, 5116, 'Mostar', 10000, 1),
(18505, 43, 46, 'Hay River', 10000, 1),
(18507, 254, 154, 'Farmington', 10000, 1),
(18508, 199, 736, 'Ponce', 10000, 1),
(18509, 159, 2887, 'Morelos', 10000, 1),
(18510, 82, 1804, 'Nimes', 10000, 1),
(18511, 254, 157, 'Millersport', 10000, 1),
(18512, 254, 125, 'Emerson', 10000, 1),
(18518, 254, 144, 'Walkerville', 10000, 1),
(18519, 254, 136, 'Covington', 10000, 1),
(18520, 254, 125, 'Cave City', 10000, 1),
(18521, 254, 170, 'Sussex', 10000, 1),
(18522, 122, 2365, 'Nerima', 10000, 1),
(18523, 49, 586, 'Nanhai', 10000, 1),
(18524, 234, 4044, 'Bellinzona', 10000, 1),
(18525, 254, 139, 'Bellevue', 10000, 1),
(18532, 91, 1916, 'Oberursel', 10000, 1),
(18534, 254, 165, 'White Deer', 10000, 1),
(18536, 254, 165, 'Burkburnett', 10000, 1),
(18538, 134, 2442, 'Ahmadi', 10000, 1),
(18539, 254, 126, 'Bonita', 10000, 1),
(18540, 91, 1922, 'Rathenow', 10000, 1),
(18543, 260, 4590, 'Bien Hoa', 10000, 1),
(18545, 254, 142, 'Derwood', 10000, 1),
(18546, 91, 1912, 'Hockenheim', 10000, 1),
(18547, 33, 26, 'Tangar', 10000, 1),
(18548, 254, 137, 'Orange City', 10000, 1),
(18549, 144, 2625, 'Dudelange', 10000, 1),
(18553, 254, 126, 'Hawaiian Gardens', 10000, 1),
(18554, 43, 43, 'Shearwater', 10000, 1),
(18556, 254, 144, 'Champion', 10000, 1),
(18557, 254, 126, 'Douglas City', 10000, 1),
(18558, 198, 3311, 'Cascais', 10000, 1),
(18559, 233, 3998, '', 10000, 1),
(18560, 239, 4090, 'Nana Plaza', 10000, 1),
(18563, 254, 160, 'Houston', 10000, 1),
(18564, 175, 2985, 'Schiedam', 10000, 1),
(18565, 254, 158, 'Langley', 10000, 1),
(18567, 49, 1336, 'NanTong', 10000, 1),
(18568, 186, 2851, 'Muscat', 10000, 1),
(18569, 186, 2851, 'Ruwi', 10000, 1),
(18570, 48, 1372, 'Puerto Varas', 10000, 1),
(18571, 254, 135, 'Kinderhook', 10000, 1),
(18572, 224, 3684, 'Benoni', 10000, 1),
(18573, 253, 5392, 'Winsford', 10000, 1),
(18574, 253, 5392, 'Nantwich', 10000, 1),
(18575, 253, 5392, 'Alsagers Bank', 10000, 1),
(18576, 253, 5392, 'St Helens', 10000, 1),
(18577, 253, 5392, 'Northwich', 10000, 1),
(18578, 253, 5392, 'Kidsgrove', 10000, 1),
(18579, 253, 5392, 'Radway Green', 10000, 1),
(18580, 254, 143, 'Ipswich', 10000, 1),
(18581, 254, 172, 'Rochester', 10000, 1),
(18582, 43, 37, 'Ingersoll', 10000, 1),
(18583, 254, 122, 'Fort Rucker', 10000, 1),
(18584, 43, 37, 'Campbellford', 10000, 1),
(18587, 254, 157, 'Barnesville', 10000, 1),
(18588, 14, 3, 'Maroochydore', 10000, 1),
(18591, 119, 2242, 'Gambettola', 10000, 1),
(18592, 254, 135, 'Benld', 10000, 1),
(18594, 254, 152, 'Plainsboro', 10000, 1),
(18595, 175, 2981, 'Beverwijk', 10000, 1),
(18596, 175, 2981, 'Castricum', 10000, 1),
(18597, 175, 2981, 'Uitgeest', 10000, 1),
(18598, 254, 153, 'Lovington', 10000, 1),
(18599, 81, 5023, 'Naantali', 10000, 1),
(18600, 202, 3361, 'Bacau', 10000, 1),
(18601, 14, 1, 'Eltham', 10000, 1),
(18602, 14, 1, 'Newstead', 10000, 1),
(18603, 254, 144, 'Thompsonville', 10000, 1),
(18605, 254, 135, 'Sparta', 10000, 1),
(18606, 254, 137, 'Eddyville', 10000, 1),
(18609, 254, 136, 'Orleans', 10000, 1),
(18610, 14, 3, 'Burpengary', 10000, 1),
(18611, 254, 144, 'Ravenna', 10000, 1),
(18612, 254, 147, 'Greenwood', 10000, 1),
(18615, 253, 5392, 'Sudbury', 10000, 1),
(18617, 254, 165, 'Blanco', 10000, 1),
(18618, 122, 2365, 'Hachioji', 10000, 1),
(18619, 233, 4005, 'Dorotea', 10000, 1),
(18622, 254, 165, 'Red Oak', 10000, 1),
(18624, 254, 165, 'Midlothian', 10000, 1),
(18625, 254, 165, 'Italy', 10000, 1),
(18626, 254, 165, 'Ferris', 10000, 1),
(18627, 253, 5392, 'Penrith', 10000, 1),
(18628, 253, 5392, 'Kendal', 10000, 1),
(18632, 254, 144, 'Milan', 10000, 1),
(18633, 254, 152, 'Runnemede', 10000, 1),
(18634, 24, 1133, 'Peer', 10000, 1),
(18638, 254, 157, 'New Carlisle', 10000, 1),
(18639, 254, 128, 'South Windsor', 10000, 1),
(18642, 122, 2372, 'Ginoza', 10000, 1),
(18643, 122, 2365, 'Mitaka', 10000, 1),
(18644, 226, 3935, 'Mollerusa', 10000, 1),
(18647, 254, 137, 'Spirit Lake', 10000, 1),
(18648, 254, 126, 'Corona del mar', 10000, 1),
(18650, 43, 37, 'Waterdown', 10000, 1),
(18654, 254, 127, 'Delta', 10000, 1),
(18655, 254, 171, 'Meeteetse', 10000, 1),
(18660, 254, 144, 'St.Clair', 10000, 1),
(18661, 254, 136, 'Hanover', 10000, 1),
(18662, 254, 164, 'Middleton', 10000, 1),
(18663, 254, 147, 'Crystal City', 10000, 1),
(18664, 175, 2980, 'Valkenswaard', 10000, 1),
(18665, 254, 139, 'Russell Springs', 10000, 1),
(18666, 14, 1, 'Boolarra', 10000, 1),
(18667, 91, 1918, 'Altena', 10000, 1),
(18668, 43, 37, 'Staples', 10000, 1),
(18669, 43, 37, 'Comber', 10000, 1),
(18670, 43, 37, 'Saint. Joachim', 10000, 1),
(18672, 254, 157, 'Rossford', 10000, 1),
(18673, 254, 165, 'Port O''Connor', 10000, 1),
(18674, 254, 170, 'North Prairie', 10000, 1),
(18675, 254, 142, 'Lusby', 10000, 1),
(18676, 14, 5, 'Yorketown', 10000, 1),
(18679, 14, 1, 'Sorrento', 10000, 1),
(18680, 254, 157, 'Canfield', 10000, 1),
(18682, 253, 5392, 'Altrincham', 10000, 1),
(18684, 254, 172, 'Winooski', 10000, 1),
(18685, 254, 170, 'Arena', 10000, 1),
(18686, 254, 147, 'Ravenwood', 10000, 1),
(18689, 254, 169, 'Glen Dale', 10000, 1),
(18690, 254, 158, 'Tuttle', 10000, 1),
(18691, 254, 157, 'Northfield', 10000, 1),
(18692, 254, 136, 'Webster', 10000, 1),
(18694, 254, 126, 'Running Springs', 10000, 1),
(18695, 14, 4, 'Camden', 10000, 1),
(18696, 254, 144, 'Utica', 10000, 1),
(18698, 254, 137, 'Pella', 10000, 1),
(18699, 254, 137, 'Le Grand', 10000, 1),
(18700, 224, 3680, 'Westville', 10000, 1),
(18701, 254, 136, 'Flora', 10000, 1),
(18703, 91, 1920, 'Merzig', 10000, 1),
(18706, 254, 160, 'Kingston', 10000, 1),
(18707, 254, 160, 'Nescopeck', 10000, 1),
(18708, 14, 3, 'Emerald', 10000, 1),
(18710, 254, 136, 'Remington', 10000, 1),
(18711, 254, 136, 'Boswell', 10000, 1),
(18712, 144, 2625, 'Bertrange', 10000, 1),
(18713, 254, 169, 'Hillsboro', 10000, 1),
(18716, 254, 122, 'Weaver', 10000, 1),
(18717, 14, 2, 'Claremont', 10000, 1),
(18718, 254, 164, 'Signal Mountain', 10000, 1),
(18719, 254, 135, 'Ridott', 10000, 1),
(18721, 254, 165, 'Carlton', 10000, 1),
(18722, 233, 4008, 'Taby', 10000, 1),
(18723, 254, 165, 'Universal City', 10000, 1),
(18724, 175, 2980, 'Volkel', 10000, 1),
(18725, 112, 2119, 'Keflavik', 10000, 1),
(18726, 14, 3, 'Longreach', 10000, 1),
(18727, 14, 2, 'Glenorchy', 10000, 1),
(18729, 254, 147, 'Forsyth', 10000, 1),
(18730, 254, 126, 'Los Molinos', 10000, 1),
(18731, 254, 160, 'Spring City', 10000, 1),
(18732, 43, 35, 'La Pocatiere', 10000, 1),
(18733, 254, 152, 'Riverside', 10000, 1),
(18734, 65, 1501, 'Taastrup', 10000, 1),
(18737, 254, 149, 'Osmond', 10000, 1),
(18738, 254, 132, 'Harlem', 10000, 1),
(18739, 254, 165, 'Peaster', 10000, 1),
(18740, 254, 151, 'Chester', 10000, 1),
(18741, 254, 142, 'Hanover', 10000, 1),
(18742, 254, 127, 'Kremmling', 10000, 1),
(18744, 254, 159, 'Logsden', 10000, 1),
(18745, 254, 144, 'Stanton', 10000, 1),
(18746, 149, 2907, 'Puchong', 10000, 1),
(18748, 254, 170, 'Mosinee', 10000, 1),
(18749, 254, 138, 'Ogden', 10000, 1),
(18750, 254, 134, 'Lewisville', 10000, 1),
(18752, 43, 43, 'Winfield', 10000, 1),
(18753, 254, 154, 'Arkville', 10000, 1),
(18754, 254, 125, 'Prairie Grove', 10000, 1),
(18755, 254, 152, 'Vincentown', 10000, 1),
(18756, 254, 136, 'Bicknell', 10000, 1),
(18758, 254, 157, 'Fairview', 10000, 1),
(18763, 254, 135, 'Savanna', 10000, 1),
(18766, 254, 132, 'Wray', 10000, 1),
(18767, 254, 154, 'East Syracuse', 10000, 1),
(18768, 254, 134, 'Firth', 10000, 1),
(18769, 253, 5392, 'Wokingham', 10000, 1),
(18771, 81, 5023, 'Uusikaupunki', 10000, 1),
(18772, 253, 5392, 'Bradford', 10000, 1),
(18773, 91, 1912, 'Kusterdingen', 10000, 1),
(18774, 14, 4, 'Katoomba ', 10000, 1),
(18776, 253, 5392, 'Bexley', 10000, 1),
(18777, 254, 167, 'Lignum', 10000, 1),
(18778, 254, 160, 'Shohola', 10000, 1),
(18779, 254, 131, 'Tangerine', 10000, 1),
(18781, 82, 1813, 'Saint-Julien-en-Genevois', 10000, 1),
(18782, 82, 1811, 'Fontenay-Le-Compte', 10000, 1),
(18785, 14, 4, 'Fairlight', 10000, 1),
(18786, 271, 5062, 'Kolasin', 10000, 1),
(18791, 254, 154, 'Cairo', 10000, 1),
(18793, 91, 1918, 'Gelsenkirchen', 10000, 1),
(18794, 254, 152, 'Morganville', 10000, 1),
(18795, 14, 4, 'Ulladulla', 10000, 1),
(18796, 24, 1136, 'Ninove', 10000, 1),
(18797, 185, 3006, 'Troms', 10000, 1),
(18798, 254, 133, 'Paia', 10000, 1),
(18799, 254, 147, 'Kidder', 10000, 1),
(18800, 65, 1493, 'Br', 10000, 1),
(18801, 234, 4049, 'Hombrechtikon', 10000, 1),
(18803, 254, 172, 'Northfield', 10000, 1),
(18804, 254, 136, 'Westfield', 10000, 1),
(18805, 199, 736, 'Culebra', 10000, 1),
(18806, 174, 3009, 'Lalitpur', 10000, 1),
(18807, 178, 4706, 'Albany', 10000, 1),
(18808, 178, 4706, 'Manurewa', 10000, 1),
(18810, 178, 4706, 'Howick', 10000, 1),
(18811, 181, 2966, 'Warri', 10000, 1),
(18812, 181, 2944, 'Abuja', 10000, 1),
(18813, 181, 2966, 'Sapele', 10000, 1),
(18814, 254, 157, 'Chesterland', 10000, 1),
(18815, 175, 2979, 'Stein', 10000, 1),
(18816, 253, 5390, 'Montrose', 10000, 1),
(18817, 43, 37, 'Winona', 10000, 1),
(18818, 254, 167, 'Midlothian', 10000, 1),
(18820, 253, 5392, 'Brighton', 10000, 1),
(18821, 224, 3685, 'Nelspruit', 10000, 1),
(18822, 224, 3685, 'Malelane', 10000, 1),
(18823, 224, 3685, 'Hazyview', 10000, 1),
(18824, 253, 5392, 'Leeds', 10000, 1),
(18826, 149, 2908, 'Jerteh', 10000, 1),
(18827, 254, 136, 'Dyer', 10000, 1),
(18829, 185, 2990, '', 10000, 1),
(18830, 198, 3305, 'Pombal', 10000, 1),
(18831, 14, 4, 'Sutherland', 10000, 1),
(18832, 14, 4, 'Liverpool', 10000, 1),
(18833, 119, 2247, 'Osimo', 10000, 1),
(18835, 254, 172, 'West Rutland', 10000, 1),
(18836, 254, 154, 'Mayfield', 10000, 1),
(18838, 239, 4108, 'Chonburi', 10000, 1),
(18839, 14, 3, 'Goondiwindi', 10000, 1),
(18840, 14, 4, 'Mungindi', 10000, 1),
(18841, 24, 1137, 'Meulebeke', 10000, 1),
(18842, 171, 4642, 'Rundu', 10000, 1),
(18843, 254, 124, 'Pima', 10000, 1),
(18844, 254, 154, 'West Hempstead', 10000, 1),
(18845, 254, 135, 'Warrenville', 10000, 1),
(18846, 254, 160, 'Barto', 10000, 1),
(18848, 254, 142, 'Cascade', 10000, 1),
(18850, 254, 170, 'Salem', 10000, 1),
(18851, 254, 127, 'Fort Lupton', 10000, 1),
(18852, 254, 136, 'Linden', 10000, 1),
(18854, 254, 160, 'Slatington', 10000, 1),
(18856, 254, 137, 'Leland', 10000, 1),
(18857, 254, 143, 'Mashpee', 10000, 1),
(18858, 254, 126, 'Stevinson', 10000, 1),
(18860, 14, 1, 'Hamilton', 10000, 1),
(18861, 254, 140, 'Maurice', 10000, 1),
(18862, 118, 2237, 'Ramallah', 10000, 1),
(18863, 81, 5022, 'Siilinj', 10000, 1),
(18864, 43, 37, 'Harrowsmith', 10000, 1),
(18865, 119, 2246, 'Vimercate', 10000, 1),
(18866, 254, 154, 'Lewiston', 10000, 1),
(18867, 254, 164, 'Hixson', 10000, 1),
(18868, 254, 135, 'Ava', 10000, 1),
(18869, 118, 2237, 'Palestine', 10000, 1),
(18870, 253, 5392, 'Melborne', 10000, 1),
(18871, 118, 2233, 'Nablus', 10000, 1),
(18872, 118, 2237, 'Gerusaleme', 10000, 1),
(18874, 82, 1803, 'Montigny-le-Bretonneux', 10000, 1),
(18876, 254, 133, 'Koloa', 10000, 1),
(18877, 119, 2242, 'Cesena', 10000, 1),
(18880, 254, 144, 'Britton', 10000, 1),
(18882, 134, 2443, 'Jahra', 10000, 1),
(18884, 254, 128, 'Salem', 10000, 1),
(18886, 254, 156, 'Medora', 10000, 1),
(18887, 178, 4706, 'Takapuna', 10000, 1),
(18889, 133, 670, 'Pusan-Kuso-2-dong', 10000, 1),
(18891, 253, 5392, 'Sheffield', 10000, 1),
(18892, 133, 2429, 'Kuso-dong;Pusan-gu', 10000, 1),
(18895, 254, 160, 'Walnutport', 10000, 1),
(18896, 254, 165, 'Colleyville', 10000, 1),
(18897, 14, 4, 'Richmond', 10000, 1),
(18900, 254, 135, 'Fulton', 10000, 1),
(18902, 254, 157, 'Brookfield', 10000, 1),
(18905, 254, 153, 'Magdalena', 10000, 1),
(18906, 14, 3, 'Ingham', 10000, 1),
(18907, 198, 3302, 'Fafe', 10000, 1),
(18908, 254, 160, 'Summerdale', 10000, 1),
(18909, 254, 164, 'Trezevant', 10000, 1),
(18911, 254, 170, 'Grafton', 10000, 1),
(18912, 254, 131, 'Marineland', 10000, 1),
(18914, 254, 131, 'Green Cove Springs', 10000, 1),
(18916, 118, 2237, 'BEIT JALA', 10000, 1),
(18918, 251, 4447, 'Reni', 10000, 1),
(18919, 254, 126, 'Pearblossom', 10000, 1),
(18920, 254, 147, 'Fair Play', 10000, 1),
(18923, 254, 165, 'Kemah', 10000, 1),
(18925, 119, 2242, 'forli', 10000, 1),
(18927, 233, 4004, 'Charlottenberg', 10000, 1),
(18928, 91, 1918, 'Troisdorf', 10000, 1),
(18929, 254, 164, 'Leoma', 10000, 1),
(18930, 254, 151, 'Whitefield', 10000, 1),
(18933, 159, 2889, 'Ciudad de M', 10000, 1),
(18934, 234, 4030, 'Cugy', 10000, 1),
(18935, 91, 1912, 'Kornwestheim', 10000, 1),
(18936, 254, 142, 'Woodstock', 10000, 1),
(18937, 254, 164, 'Whitwell', 10000, 1),
(18938, 33, 27, 'Nova Lima', 10000, 1),
(18939, 143, 2572, 'Nemencine', 10000, 1),
(18943, 254, 165, 'Troy', 10000, 1),
(18945, 253, 5392, 'Ascot', 10000, 1),
(18946, 226, 3935, 'Crespia', 10000, 1),
(18950, 254, 135, 'Brookfield', 10000, 1),
(18952, 253, 5392, 'Haslemere', 10000, 1),
(18954, 111, 2074, 'Sz', 10000, 1),
(18955, 14, 4, 'Springwood', 10000, 1),
(18956, 254, 148, 'Manhattan', 10000, 1),
(18957, 91, 1912, 'Singen', 10000, 1),
(18958, 254, 152, 'Midland Park', 10000, 1),
(18959, 118, 2232, 'Rechovot', 10000, 1),
(18961, 254, 125, 'Brookland', 10000, 1),
(18962, 254, 155, 'Boiling Springs', 10000, 1),
(18963, 43, 40, 'Southey', 10000, 1),
(18964, 254, 160, 'Aliquippa', 10000, 1),
(18965, 14, 4, 'Woronora Heights', 10000, 1),
(18967, 119, 2252, 'Belmonte Mezzagno', 10000, 1),
(18968, 202, 3388, 'satu mare', 10000, 1),
(18969, 200, 3353, 'Al Wakra', 10000, 1),
(18970, 254, 157, 'Summit Station', 10000, 1),
(18973, 43, 35, 'Saint-Eustache', 10000, 1),
(18974, 254, 136, 'New Market', 10000, 1),
(18975, 254, 139, 'Cave City', 10000, 1),
(18976, 254, 165, 'Southlake', 10000, 1),
(18978, 254, 169, 'Ravenswood', 10000, 1),
(18979, 198, 3313, 'Porto', 10000, 1),
(18980, 198, 3313, 'Vila do Conde', 10000, 1),
(18981, 113, 2181, 'Gwalior', 10000, 1),
(18982, 43, 35, 'Lac-M', 10000, 1),
(18983, 176, 5049, 'Philipsburg', 10000, 1),
(18984, 253, 5390, 'Kilmarnock', 10000, 1),
(18985, 33, 11, 'Trancoso', 10000, 1),
(18986, 203, 3570, 'Krasnoyarsk', 10000, 1),
(18987, 133, 2429, 'Haeundae', 10000, 1),
(18988, 171, 4645, 'Oshakati', 10000, 1),
(18990, 254, 123, 'Clam Gulch', 10000, 1),
(18991, 197, 3285, 'Zabrze', 10000, 1),
(18992, 253, 5390, 'Elgin', 10000, 1),
(18993, 126, 2388, 'Aqaba', 10000, 1),
(18994, 271, 3941, 'Vrsac', 10000, 1),
(18995, 138, 2483, 'Amioun', 10000, 1),
(18996, 202, 3368, 'Buzau', 10000, 1),
(18998, 30, 5116, 'Tuzla', 10000, 1),
(18999, 254, 152, 'Pleasantville', 10000, 1),
(19000, 254, 135, 'Elsah', 10000, 1),
(19002, 233, 4008, 'Nacka', 10000, 1),
(19003, 271, 5062, 'Budva', 10000, 1),
(19004, 138, 2485, 'Jbeil', 10000, 1),
(19005, 14, 4, 'Griffith', 10000, 1),
(19006, 149, 2911, 'Nabawan', 10000, 1),
(19008, 224, 3681, 'Ladybrand', 10000, 1),
(19009, 136, 2478, 'Vientiane', 10000, 1),
(19010, 200, 3354, 'Al-Rayyan', 10000, 1),
(19011, 113, 2181, 'Jabalpur', 10000, 1),
(19012, 254, 145, 'Prior Lake', 10000, 1),
(19013, 274, 4692, 'Marondera', 10000, 1),
(19015, 274, 4693, 'Kadoma', 10000, 1),
(19016, 71, 1580, 'Ramadan 10 City', 10000, 1),
(19017, 82, 1803, 'Les Ormes-sur-Voulzie', 10000, 1),
(19018, 169, 2917, 'Nampula', 10000, 1),
(19019, 254, 170, 'Cadott', 10000, 1),
(19020, 206, 3645, 'Basseterre', 10000, 1),
(19021, 254, 126, 'Lagunitas', 10000, 1),
(19022, 113, 2181, 'Chhindwara', 10000, 1),
(19023, 24, 1129, 'Heist-op-den-Berg', 10000, 1),
(19024, 99, 636, 'Piti', 10000, 1),
(19025, 128, 2454, 'Pavlodar', 10000, 1),
(19027, 199, 736, 'Isabel Segunda', 10000, 1),
(19028, 152, 689, 'San Gwann', 10000, 1),
(19029, 254, 167, 'Pembroke', 10000, 1),
(19030, 254, 128, 'Sherman', 10000, 1),
(19031, 254, 157, 'Englewood', 10000, 1),
(19032, 254, 127, 'Nucla', 10000, 1),
(19033, 254, 147, 'Pleasant Hill', 10000, 1),
(19034, 226, 3932, 'Arrecife', 10000, 1),
(19035, 113, 2193, 'Meerut', 10000, 1),
(19036, 115, 2210, 'Kish', 10000, 1),
(19037, 91, 1913, 'Vilseck', 10000, 1),
(19038, 175, 2984, 'Kruiningen', 10000, 1),
(19039, 253, 5392, 'Little Chalfont', 10000, 1),
(19040, 253, 5389, 'Newport', 10000, 1),
(19041, 153, 690, 'Castletown', 10000, 1),
(19042, 213, 3635, 'Ha''il', 10000, 1),
(19043, 160, 1792, 'Colonia', 10000, 1),
(19044, 43, 37, 'Webequie', 10000, 1),
(19045, 65, 1489, 'Silkeborg', 10000, 1),
(19046, 254, 160, 'Aaronsburg', 10000, 1),
(19047, 254, 146, 'Abbeville', 10000, 1),
(19048, 254, 141, 'Abbot', 10000, 1),
(19049, 254, 170, 'Abbotsford', 10000, 1),
(19050, 254, 165, 'Abbott', 10000, 1),
(19051, 254, 160, 'Abbottstown', 10000, 1),
(19052, 254, 138, 'Abbyville', 10000, 1),
(19053, 254, 142, 'Abell', 10000, 1),
(19054, 254, 156, 'Abercrombie', 10000, 1),
(19055, 254, 134, 'Aberdeen', 10000, 1),
(19056, 254, 139, 'Aberdeen', 10000, 1),
(19057, 254, 142, 'Aberdeen', 10000, 1),
(19058, 254, 155, 'Aberdeen', 10000, 1),
(19059, 254, 157, 'Aberdeen', 10000, 1),
(19060, 254, 142, 'Aberdeen Proving Ground', 10000, 1),
(19061, 254, 122, 'Abernant', 10000, 1),
(19062, 254, 165, 'Abernathy', 10000, 1),
(19063, 254, 149, 'Abie', 10000, 1),
(19064, 254, 135, 'Abingdon', 10000, 1),
(19065, 254, 128, 'Abington', 10000, 1),
(19066, 254, 143, 'Abington', 10000, 1),
(19067, 254, 153, 'Abiquiu', 10000, 1),
(19068, 254, 140, 'Abita Springs', 10000, 1),
(19069, 254, 170, 'Abrams', 10000, 1),
(19070, 254, 156, 'Absaraka', 10000, 1),
(19071, 254, 148, 'Absarokee', 10000, 1),
(19072, 254, 142, 'Accident', 10000, 1),
(19073, 254, 143, 'Accord', 10000, 1),
(19074, 254, 154, 'Accord', 10000, 1),
(19075, 254, 169, 'Accoville', 10000, 1),
(19076, 254, 165, 'Ace', 10000, 1),
(19077, 254, 158, 'Achille', 10000, 1),
(19078, 254, 167, 'Achilles', 10000, 1),
(19079, 254, 165, 'Ackerly', 10000, 1),
(19080, 254, 160, 'Ackermanville', 10000, 1),
(19081, 254, 137, 'Ackley', 10000, 1),
(19082, 254, 137, 'Ackworth', 10000, 1),
(19083, 254, 140, 'Acme', 10000, 1),
(19084, 254, 144, 'Acme', 10000, 1),
(19085, 254, 160, 'Acme', 10000, 1),
(19086, 254, 168, 'Acme', 10000, 1),
(19087, 254, 160, 'Acosta', 10000, 1),
(19088, 254, 154, 'Acra', 10000, 1),
(19089, 254, 126, 'Acton', 10000, 1),
(19090, 254, 141, 'Acton', 10000, 1),
(19091, 254, 148, 'Acton', 10000, 1),
(19092, 254, 143, 'Acushnet', 10000, 1),
(19093, 254, 151, 'Acworth', 10000, 1),
(19094, 254, 157, 'Ada', 10000, 1),
(19095, 254, 160, 'Adah', 10000, 1),
(19096, 254, 135, 'Adair', 10000, 1),
(19097, 254, 158, 'Adair', 10000, 1),
(19098, 254, 132, 'Adairsville', 10000, 1),
(19099, 254, 139, 'Adairville', 10000, 1),
(19100, 254, 123, 'Adak', 10000, 1),
(19101, 254, 172, 'Adamant', 10000, 1),
(19102, 254, 139, 'Adams', 10000, 1),
(19103, 254, 143, 'Adams', 10000, 1),
(19104, 254, 145, 'Adams', 10000, 1),
(19105, 254, 156, 'Adams', 10000, 1),
(19106, 254, 149, 'Adams', 10000, 1),
(19107, 254, 158, 'Adams', 10000, 1),
(19108, 254, 159, 'Adams', 10000, 1),
(19109, 254, 164, 'Adams', 10000, 1),
(19110, 254, 154, 'Adams Basin', 10000, 1),
(19111, 254, 154, 'Adams Center', 10000, 1),
(19112, 254, 162, 'Adams Run', 10000, 1),
(19113, 254, 160, 'Adamsburg', 10000, 1),
(19114, 254, 142, 'Adamstown', 10000, 1),
(19115, 254, 160, 'Adamstown', 10000, 1),
(19116, 254, 122, 'Adamsville', 10000, 1),
(19117, 254, 157, 'Adamsville', 10000, 1),
(19118, 254, 160, 'Adamsville', 10000, 1),
(19119, 254, 161, 'Adamsville', 10000, 1),
(19120, 254, 164, 'Adamsville', 10000, 1),
(19121, 254, 135, 'Addieville', 10000, 1),
(19122, 254, 158, 'Addington', 10000, 1),
(19123, 254, 140, 'Addis', 10000, 1),
(19124, 254, 122, 'Addison', 10000, 1),
(19125, 254, 141, 'Addison', 10000, 1),
(19126, 254, 144, 'Addison', 10000, 1),
(19127, 254, 154, 'Addison', 10000, 1),
(19128, 254, 160, 'Addison', 10000, 1),
(19129, 254, 168, 'Addy', 10000, 1),
(19130, 254, 157, 'Addyston', 10000, 1),
(19131, 254, 137, 'Adel', 10000, 1),
(19132, 254, 159, 'Adel', 10000, 1),
(19133, 254, 170, 'Adell', 10000, 1),
(19134, 254, 157, 'Adelphi', 10000, 1),
(19135, 254, 152, 'Adelphia', 10000, 1),
(19136, 254, 157, 'Adena', 10000, 1),
(19137, 254, 122, 'Adger', 10000, 1),
(19138, 254, 126, 'Adin', 10000, 1),
(19139, 254, 154, 'Adirondack', 10000, 1),
(19140, 254, 165, 'Adkins', 10000, 1),
(19141, 254, 168, 'Adna', 10000, 1),
(19142, 254, 145, 'Adolph', 10000, 1),
(19143, 254, 139, 'Adolphus', 10000, 1),
(19144, 254, 125, 'Adona', 10000, 1),
(19145, 254, 132, 'Adrian', 10000, 1),
(19146, 254, 135, 'Adrian', 10000, 1),
(19147, 254, 145, 'Adrian', 10000, 1),
(19148, 254, 147, 'Adrian', 10000, 1),
(19149, 254, 157, 'Adrian', 10000, 1),
(19150, 254, 159, 'Adrian', 10000, 1),
(19151, 254, 160, 'Adrian', 10000, 1),
(19152, 254, 165, 'Adrian', 10000, 1),
(19153, 254, 169, 'Adrian', 10000, 1),
(19154, 254, 147, 'Advance', 10000, 1),
(19155, 254, 155, 'Advance', 10000, 1),
(19156, 254, 169, 'Advent', 10000, 1),
(19157, 254, 137, 'Afton', 10000, 1),
(19158, 254, 144, 'Afton', 10000, 1),
(19159, 254, 145, 'Afton', 10000, 1),
(19160, 254, 154, 'Afton', 10000, 1),
(19161, 254, 164, 'Afton', 10000, 1),
(19162, 254, 165, 'Afton', 10000, 1),
(19163, 254, 167, 'Afton', 10000, 1),
(19164, 254, 170, 'Afton', 10000, 1),
(19165, 254, 171, 'Afton', 10000, 1),
(19166, 254, 163, 'Agar', 10000, 1),
(19167, 254, 127, 'Agate', 10000, 1),
(19168, 254, 156, 'Agate', 10000, 1),
(19169, 254, 137, 'Agency', 10000, 1),
(19170, 254, 147, 'Agency', 10000, 1),
(19171, 254, 138, 'Agenda', 10000, 1),
(19172, 254, 139, 'Ages Brookside', 10000, 1),
(19173, 254, 159, 'Agness', 10000, 1),
(19174, 254, 138, 'Agra', 10000, 1),
(19175, 254, 165, 'Agua Dulce', 10000, 1),
(19176, 254, 126, 'Aguanga', 10000, 1),
(19177, 254, 124, 'Aguila', 10000, 1),
(19178, 254, 127, 'Aguilar', 10000, 1),
(19179, 254, 145, 'Ah Gwah Ching', 10000, 1),
(19180, 254, 144, 'Ahmeek', 10000, 1),
(19181, 254, 155, 'Ahoskie', 10000, 1),
(19182, 254, 134, 'Ahsahka', 10000, 1),
(19183, 254, 126, 'Ahwahnee', 10000, 1),
(19184, 254, 133, 'Aiea', 10000, 1),
(19185, 254, 165, 'Aiken', 10000, 1),
(19186, 254, 132, 'Ailey', 10000, 1),
(19187, 254, 140, 'Aimwell', 10000, 1),
(19188, 254, 137, 'Ainsworth', 10000, 1),
(19189, 254, 160, 'Airville', 10000, 1),
(19190, 254, 168, 'Airway Heights', 10000, 1),
(19191, 254, 124, 'Ajo', 10000, 1),
(19192, 254, 163, 'Akaska', 10000, 1),
(19193, 254, 145, 'Akeley', 10000, 1),
(19194, 254, 140, 'Akers', 10000, 1),
(19195, 254, 123, 'Akiachak', 10000, 1),
(19196, 254, 123, 'Akiak', 10000, 1),
(19197, 254, 135, 'Akin', 10000, 1),
(19198, 254, 122, 'Akron', 10000, 1),
(19199, 254, 137, 'Akron', 10000, 1),
(19200, 254, 136, 'Akron', 10000, 1),
(19201, 254, 144, 'Akron', 10000, 1),
(19202, 254, 154, 'Akron', 10000, 1),
(19203, 254, 160, 'Akron', 10000, 1),
(19204, 254, 123, 'Akutan', 10000, 1),
(19205, 254, 154, 'Alabama', 10000, 1),
(19206, 254, 171, 'Aladdin', 10000, 1),
(19207, 254, 123, 'Alakanuk', 10000, 1),
(19208, 254, 155, 'Alamance', 10000, 1),
(19209, 254, 136, 'Alamo', 10000, 1),
(19210, 254, 156, 'Alamo', 10000, 1),
(19211, 254, 150, 'Alamo', 10000, 1),
(19212, 254, 165, 'Alanreed', 10000, 1),
(19213, 254, 132, 'Alapaha', 10000, 1),
(19214, 254, 144, 'Alba', 10000, 1),
(19215, 254, 147, 'Alba', 10000, 1),
(19216, 254, 160, 'Alba', 10000, 1),
(19217, 254, 165, 'Alba', 10000, 1),
(19218, 254, 135, 'Albany', 10000, 1),
(19219, 254, 136, 'Albany', 10000, 1),
(19220, 254, 140, 'Albany', 10000, 1),
(19221, 254, 157, 'Albany', 10000, 1),
(19222, 254, 158, 'Albany', 10000, 1),
(19223, 254, 172, 'Albany', 10000, 1),
(19224, 254, 170, 'Albany', 10000, 1),
(19225, 254, 135, 'Albers', 10000, 1),
(19226, 254, 138, 'Albert', 10000, 1),
(19227, 254, 158, 'Albert', 10000, 1),
(19228, 254, 137, 'Albert City', 10000, 1),
(19229, 254, 122, 'Alberta', 10000, 1),
(19230, 254, 145, 'Alberta', 10000, 1),
(19231, 254, 167, 'Alberta', 10000, 1),
(19232, 254, 148, 'Alberton', 10000, 1),
(19233, 254, 155, 'Albertson', 10000, 1),
(19234, 254, 154, 'Albertson', 10000, 1),
(19235, 254, 145, 'Albertville', 10000, 1),
(19236, 254, 171, 'Albin', 10000, 1),
(19237, 254, 126, 'Albion', 10000, 1),
(19238, 254, 137, 'Albion', 10000, 1),
(19239, 254, 134, 'Albion', 10000, 1),
(19240, 254, 141, 'Albion', 10000, 1),
(19241, 254, 158, 'Albion', 10000, 1),
(19242, 254, 161, 'Albion', 10000, 1),
(19243, 254, 168, 'Albion', 10000, 1),
(19244, 254, 145, 'Alborn', 10000, 1),
(19245, 254, 169, 'Albright', 10000, 1),
(19246, 254, 160, 'Albrightsville', 10000, 1),
(19247, 254, 172, 'Alburg', 10000, 1),
(19248, 254, 137, 'Alburnett', 10000, 1),
(19249, 254, 153, 'Alcalde', 10000, 1),
(19250, 254, 125, 'Alco', 10000, 1),
(19251, 254, 164, 'Alcoa', 10000, 1),
(19252, 254, 162, 'Alcolu', 10000, 1),
(19253, 254, 171, 'Alcova', 10000, 1),
(19254, 254, 154, 'Alcove', 10000, 1),
(19255, 254, 149, 'Alda', 10000, 1),
(19256, 254, 137, 'Alden', 10000, 1),
(19257, 254, 135, 'Alden', 10000, 1),
(19258, 254, 138, 'Alden', 10000, 1),
(19259, 254, 144, 'Alden', 10000, 1),
(19260, 254, 145, 'Alden', 10000, 1),
(19261, 254, 154, 'Alden', 10000, 1),
(19262, 254, 160, 'Aldenville', 10000, 1),
(19263, 254, 148, 'Alder', 10000, 1),
(19264, 254, 154, 'Alder Creek', 10000, 1),
(19265, 254, 126, 'Alderpoint', 10000, 1),
(19266, 254, 158, 'Alderson', 10000, 1),
(19267, 254, 169, 'Alderson', 10000, 1),
(19268, 254, 167, 'Aldie', 10000, 1),
(19269, 254, 145, 'Aldrich', 10000, 1),
(19270, 254, 147, 'Aldrich', 10000, 1),
(19271, 254, 123, 'Aleknagik', 10000, 1),
(19272, 254, 160, 'Aleppo', 10000, 1),
(19273, 254, 158, 'Alex', 10000, 1),
(19274, 254, 125, 'Alexander', 10000, 1),
(19275, 254, 137, 'Alexander', 10000, 1),
(19276, 254, 135, 'Alexander', 10000, 1),
(19277, 254, 138, 'Alexander', 10000, 1),
(19278, 254, 155, 'Alexander', 10000, 1),
(19279, 254, 154, 'Alexander', 10000, 1),
(19280, 254, 122, 'Alexandria', 10000, 1),
(19281, 254, 147, 'Alexandria', 10000, 1),
(19282, 254, 149, 'Alexandria', 10000, 1),
(19283, 254, 157, 'Alexandria', 10000, 1),
(19284, 254, 160, 'Alexandria', 10000, 1),
(19285, 254, 164, 'Alexandria', 10000, 1),
(19287, 254, 154, 'Alexandria Bay', 10000, 1),
(19288, 254, 135, 'Alexis', 10000, 1),
(19289, 254, 155, 'Alexis', 10000, 1),
(19290, 254, 131, 'Alford', 10000, 1),
(19291, 254, 141, 'Alfred', 10000, 1),
(19292, 254, 154, 'Alfred Station', 10000, 1),
(19293, 254, 144, 'Alger', 10000, 1),
(19294, 254, 157, 'Alger', 10000, 1),
(19295, 254, 153, 'Algodones', 10000, 1),
(19296, 254, 146, 'Algoma', 10000, 1),
(19297, 254, 135, 'Algonquin', 10000, 1),
(19298, 254, 135, 'Alhambra', 10000, 1),
(19299, 254, 125, 'Alicia', 10000, 1),
(19300, 254, 165, 'Alief', 10000, 1),
(19301, 254, 158, 'Aline', 10000, 1),
(19302, 254, 125, 'Alix', 10000, 1),
(19303, 254, 169, 'Alkol', 10000, 1),
(19304, 254, 123, 'Allakaket', 10000, 1),
(19305, 254, 152, 'Allamuchy', 10000, 1),
(19306, 254, 164, 'Allardt', 10000, 1),
(19307, 254, 157, 'Alledonia', 10000, 1),
(19308, 254, 125, 'Alleene', 10000, 1),
(19309, 254, 154, 'Allegany', 10000, 1),
(19310, 254, 139, 'Allegre', 10000, 1),
(19311, 254, 137, 'Alleman', 10000, 1),
(19312, 254, 138, 'Allen', 10000, 1),
(19313, 254, 139, 'Allen', 10000, 1),
(19314, 254, 142, 'Allen', 10000, 1),
(19315, 254, 144, 'Allen', 10000, 1),
(19316, 254, 149, 'Allen', 10000, 1),
(19317, 254, 158, 'Allen', 10000, 1),
(19318, 254, 163, 'Allen', 10000, 1),
(19319, 254, 169, 'Allen Junction', 10000, 1),
(19320, 254, 135, 'Allendale', 10000, 1),
(19321, 254, 147, 'Allendale', 10000, 1),
(19322, 254, 137, 'Allendorf', 10000, 1),
(19323, 254, 132, 'Allenhurst', 10000, 1),
(19324, 254, 152, 'Allenhurst', 10000, 1),
(19325, 254, 160, 'Allenport', 10000, 1),
(19326, 254, 139, 'Allensville', 10000, 1),
(19327, 254, 160, 'Allensville', 10000, 1),
(19328, 254, 144, 'Allenton', 10000, 1),
(19329, 254, 147, 'Allenton', 10000, 1),
(19330, 254, 170, 'Allenton', 10000, 1),
(19331, 254, 132, 'Allentown', 10000, 1),
(19332, 254, 152, 'Allentown', 10000, 1),
(19333, 254, 154, 'Allentown', 10000, 1),
(19334, 254, 152, 'Allenwood', 10000, 1),
(19335, 254, 160, 'Allenwood', 10000, 1),
(19336, 254, 137, 'Allerton', 10000, 1),
(19337, 254, 135, 'Allerton', 10000, 1),
(19338, 254, 165, 'Alleyton', 10000, 1),
(19339, 254, 122, 'Allgood', 10000, 1),
(19340, 254, 155, 'Alliance', 10000, 1),
(19341, 254, 146, 'Alligator', 10000, 1),
(19342, 254, 160, 'Allison', 10000, 1),
(19343, 254, 165, 'Allison', 10000, 1),
(19344, 254, 160, 'Allison Park', 10000, 1),
(19345, 254, 164, 'Allons', 10000, 1),
(19346, 254, 144, 'Allouez', 10000, 1),
(19347, 254, 152, 'Alloway', 10000, 1),
(19348, 254, 169, 'Alloy', 10000, 1),
(19349, 254, 160, 'Allport', 10000, 1),
(19350, 254, 164, 'Allred', 10000, 1),
(19351, 254, 143, 'Allston', 10000, 1),
(19352, 254, 168, 'Allyn', 10000, 1),
(19353, 254, 122, 'Alma', 10000, 1),
(19354, 254, 127, 'Alma', 10000, 1),
(19355, 254, 135, 'Alma', 10000, 1),
(19356, 254, 138, 'Alma', 10000, 1),
(19357, 254, 147, 'Alma', 10000, 1),
(19358, 254, 154, 'Alma', 10000, 1),
(19359, 254, 169, 'Alma', 10000, 1),
(19360, 254, 170, 'Alma Center', 10000, 1),
(19361, 254, 145, 'Almelund', 10000, 1),
(19362, 254, 138, 'Almena', 10000, 1),
(19363, 254, 170, 'Almena', 10000, 1),
(19364, 254, 168, 'Almira', 10000, 1),
(19365, 254, 134, 'Almo', 10000, 1),
(19366, 254, 139, 'Almo', 10000, 1),
(19367, 254, 155, 'Almond', 10000, 1),
(19368, 254, 154, 'Almond', 10000, 1),
(19369, 254, 170, 'Almond', 10000, 1),
(19370, 254, 127, 'Almont', 10000, 1),
(19371, 254, 144, 'Almont', 10000, 1),
(19372, 254, 156, 'Almont', 10000, 1),
(19373, 254, 125, 'Almyra', 10000, 1),
(19374, 254, 141, 'Alna', 10000, 1),
(19375, 254, 126, 'Alpaugh', 10000, 1),
(19376, 254, 125, 'Alpena', 10000, 1),
(19377, 254, 163, 'Alpena', 10000, 1),
(19378, 254, 135, 'Alpha', 10000, 1),
(19379, 254, 139, 'Alpha', 10000, 1),
(19380, 254, 144, 'Alpha', 10000, 1),
(19381, 254, 145, 'Alpha', 10000, 1),
(19382, 254, 157, 'Alpha', 10000, 1),
(19383, 254, 122, 'Alpine', 10000, 1),
(19384, 254, 125, 'Alpine', 10000, 1),
(19385, 254, 152, 'Alpine', 10000, 1),
(19386, 254, 154, 'Alpine', 10000, 1),
(19387, 254, 164, 'Alpine', 10000, 1),
(19388, 254, 166, 'Alpine', 10000, 1),
(19389, 254, 171, 'Alpine', 10000, 1),
(19390, 254, 154, 'Alplaus', 10000, 1),
(19391, 254, 159, 'Alsea', 10000, 1),
(19392, 254, 156, 'Alsen', 10000, 1),
(19393, 254, 135, 'Alsey', 10000, 1),
(19394, 254, 151, 'Alstead', 10000, 1),
(19395, 254, 132, 'Alston', 10000, 1),
(19396, 254, 137, 'Alta', 10000, 1),
(19397, 254, 137, 'Alta Vista', 10000, 1),
(19398, 254, 138, 'Alta Vista', 10000, 1),
(19399, 254, 165, 'Altair', 10000, 1),
(19400, 254, 155, 'Altamahaw', 10000, 1),
(19401, 254, 135, 'Altamont', 10000, 1),
(19402, 254, 147, 'Altamont', 10000, 1),
(19403, 254, 154, 'Altamont', 10000, 1),
(19404, 254, 166, 'Altamont', 10000, 1),
(19405, 254, 126, 'Altaville', 10000, 1),
(19406, 254, 167, 'Altavista', 10000, 1),
(19407, 254, 147, 'Altenburg', 10000, 1),
(19408, 254, 131, 'Altha', 10000, 1),
(19409, 254, 125, 'Altheimer', 10000, 1),
(19410, 254, 154, 'Altmar', 10000, 1),
(19411, 254, 132, 'Alto', 10000, 1),
(19412, 254, 144, 'Alto', 10000, 1),
(19413, 254, 153, 'Alto', 10000, 1),
(19414, 254, 135, 'Alto Pass', 10000, 1),
(19415, 254, 122, 'Alton', 10000, 1),
(19416, 254, 137, 'Alton', 10000, 1),
(19417, 254, 138, 'Alton', 10000, 1),
(19418, 254, 151, 'Alton', 10000, 1),
(19419, 254, 154, 'Alton', 10000, 1),
(19420, 254, 166, 'Alton', 10000, 1),
(19421, 254, 167, 'Alton', 10000, 1),
(19422, 254, 151, 'Alton Bay', 10000, 1),
(19423, 254, 154, 'Altona', 10000, 1),
(19424, 254, 166, 'Altonah', 10000, 1),
(19425, 254, 122, 'Altoona', 10000, 1),
(19426, 254, 131, 'Altoona', 10000, 1),
(19427, 254, 137, 'Altoona', 10000, 1),
(19428, 254, 138, 'Altoona', 10000, 1),
(19429, 254, 170, 'Altoona', 10000, 1),
(19430, 254, 145, 'Altura', 10000, 1),
(19431, 254, 131, 'Alturas', 10000, 1),
(19432, 254, 125, 'Altus', 10000, 1),
(19433, 254, 158, 'Altus AFB', 10000, 1),
(19434, 254, 169, 'Alum Bridge', 10000, 1),
(19435, 254, 169, 'Alum Creek', 10000, 1),
(19436, 254, 171, 'Alva', 10000, 1),
(19437, 254, 157, 'Alvada', 10000, 1),
(19438, 254, 159, 'Alvadore', 10000, 1),
(19439, 254, 145, 'Alvarado', 10000, 1),
(19440, 254, 165, 'Alvarado', 10000, 1),
(19441, 254, 139, 'Alvaton', 10000, 1),
(19442, 254, 160, 'Alverda', 10000, 1),
(19443, 254, 160, 'Alverton', 10000, 1),
(19444, 254, 135, 'Alvin', 10000, 1),
(19445, 254, 126, 'Alviso', 10000, 1),
(19446, 254, 149, 'Alvo', 10000, 1),
(19447, 254, 137, 'Alvord', 10000, 1),
(19448, 254, 165, 'Alvord', 10000, 1),
(19449, 254, 157, 'Alvordton', 10000, 1),
(19450, 254, 148, 'Alzada', 10000, 1),
(19451, 254, 140, 'Ama', 10000, 1),
(19452, 254, 124, 'Amado', 10000, 1),
(19453, 254, 126, 'Amador City', 10000, 1),
(19454, 254, 154, 'Amagansett', 10000, 1),
(19455, 254, 125, 'Amagon', 10000, 1),
(19456, 254, 153, 'Amalia', 10000, 1),
(19457, 254, 137, 'Amana', 10000, 1),
(19458, 254, 157, 'Amanda', 10000, 1),
(19459, 254, 168, 'Amanda Park', 10000, 1),
(19460, 254, 150, 'Amargosa Valley', 10000, 1),
(19462, 254, 144, 'Amasa', 10000, 1),
(19463, 254, 154, 'Amawalk', 10000, 1),
(19464, 254, 147, 'Amazonia', 10000, 1),
(19465, 254, 158, 'Amber', 10000, 1),
(19466, 254, 170, 'Amberg', 10000, 1),
(19467, 254, 160, 'Amberson', 10000, 1),
(19468, 254, 136, 'Ambia', 10000, 1),
(19469, 254, 123, 'Ambler', 10000, 1),
(19470, 254, 126, 'Amboy', 10000, 1),
(19471, 254, 136, 'Amboy', 10000, 1),
(19472, 254, 145, 'Amboy', 10000, 1),
(19473, 254, 168, 'Amboy', 10000, 1),
(19474, 254, 160, 'Ambridge', 10000, 1),
(19475, 254, 132, 'Ambrose', 10000, 1),
(19476, 254, 156, 'Ambrose', 10000, 1),
(19477, 254, 169, 'Ameagle', 10000, 1),
(19478, 254, 140, 'Amelia', 10000, 1),
(19479, 254, 149, 'Amelia', 10000, 1),
(19480, 254, 157, 'Amelia', 10000, 1),
(19481, 254, 167, 'Amelia Court House', 10000, 1),
(19482, 254, 156, 'Amenia', 10000, 1),
(19483, 254, 154, 'Amenia', 10000, 1),
(19484, 254, 138, 'Americus', 10000, 1),
(19485, 254, 149, 'Ames', 10000, 1),
(19486, 254, 158, 'Ames', 10000, 1),
(19487, 254, 157, 'Amesville', 10000, 1),
(19488, 254, 135, 'AMF O''Hare', 10000, 1),
(19489, 254, 127, 'Amherst', 10000, 1),
(19490, 254, 149, 'Amherst', 10000, 1),
(19491, 254, 151, 'Amherst', 10000, 1),
(19492, 254, 163, 'Amherst', 10000, 1),
(19493, 254, 165, 'Amherst', 10000, 1),
(19494, 254, 170, 'Amherst', 10000, 1),
(19495, 254, 170, 'Amherst Junction', 10000, 1),
(19496, 254, 169, 'Amherstdale', 10000, 1),
(19497, 254, 169, 'Amigo', 10000, 1),
(19498, 254, 167, 'Amissville', 10000, 1),
(19499, 254, 153, 'Amistad', 10000, 1),
(19500, 254, 140, 'Amite', 10000, 1),
(19501, 254, 125, 'Amity', 10000, 1),
(19502, 254, 147, 'Amity', 10000, 1),
(19503, 254, 157, 'Amlin', 10000, 1),
(19504, 254, 169, 'Amma', 10000, 1),
(19505, 254, 167, 'Ammon', 10000, 1),
(19506, 254, 136, 'Amo', 10000, 1),
(19507, 254, 167, 'Amonate', 10000, 1),
(19508, 254, 147, 'Amoret', 10000, 1),
(19509, 254, 158, 'Amorita', 10000, 1),
(19510, 254, 146, 'Amory', 10000, 1),
(19511, 254, 157, 'Amsden', 10000, 1),
(19512, 254, 147, 'Amsterdam', 10000, 1),
(19513, 254, 157, 'Amsterdam', 10000, 1),
(19514, 254, 128, 'Amston', 10000, 1),
(19515, 254, 147, 'Anabel', 10000, 1),
(19516, 254, 133, 'Anahola', 10000, 1),
(19517, 254, 123, 'Anaktuvuk Pass', 10000, 1),
(19518, 254, 160, 'Analomink', 10000, 1),
(19519, 254, 168, 'Anatone', 10000, 1),
(19520, 254, 169, 'Anawalt', 10000, 1),
(19521, 254, 135, 'Anchor', 10000, 1),
(19522, 254, 123, 'Anchor Point', 10000, 1),
(19523, 254, 144, 'Anchorville', 10000, 1),
(19524, 254, 135, 'Ancona', 10000, 1),
(19525, 254, 154, 'Ancram', 10000, 1),
(19526, 254, 138, 'Andale', 10000, 1),
(19527, 254, 123, 'Anderson', 10000, 1),
(19528, 254, 122, 'Anderson', 10000, 1),
(19529, 254, 147, 'Anderson', 10000, 1),
(19530, 254, 165, 'Anderson', 10000, 1),
(19531, 254, 168, 'Anderson Island', 10000, 1),
(19532, 254, 132, 'Andersonville', 10000, 1),
(19533, 254, 164, 'Andersonville', 10000, 1),
(19534, 254, 154, 'Andes', 10000, 1),
(19535, 254, 128, 'Andover', 10000, 1),
(19536, 254, 137, 'Andover', 10000, 1),
(19537, 254, 135, 'Andover', 10000, 1),
(19538, 254, 138, 'Andover', 10000, 1),
(19539, 254, 141, 'Andover', 10000, 1),
(19540, 254, 151, 'Andover', 10000, 1),
(19541, 254, 154, 'Andover', 10000, 1),
(19542, 254, 157, 'Andover', 10000, 1),
(19543, 254, 163, 'Andover', 10000, 1),
(19544, 254, 167, 'Andover', 10000, 1),
(19545, 254, 160, 'Andreas', 10000, 1),
(19546, 254, 137, 'Andrew', 10000, 1),
(19547, 254, 136, 'Andrews', 10000, 1),
(19548, 254, 162, 'Andrews', 10000, 1),
(19549, 254, 156, 'Aneta', 10000, 1),
(19550, 254, 166, 'Aneth', 10000, 1),
(19551, 254, 148, 'Angela', 10000, 1),
(19552, 254, 154, 'Angelica', 10000, 1),
(19553, 254, 126, 'Angelus Oaks', 10000, 1),
(19554, 254, 140, 'Angie', 10000, 1),
(19555, 254, 154, 'Angola', 10000, 1),
(19556, 254, 123, 'Angoon', 10000, 1),
(19557, 254, 145, 'Angora', 10000, 1),
(19558, 254, 149, 'Angora', 10000, 1),
(19559, 254, 146, 'Anguilla', 10000, 1),
(19560, 254, 145, 'Angus', 10000, 1),
(19561, 254, 126, 'Angwin', 10000, 1),
(19562, 254, 123, 'Aniak', 10000, 1),
(19563, 254, 153, 'Animas', 10000, 1),
(19564, 254, 137, 'Anita', 10000, 1),
(19565, 254, 160, 'Anita', 10000, 1),
(19566, 254, 170, 'Aniwa', 10000, 1),
(19567, 254, 169, 'Anmoore', 10000, 1),
(19568, 254, 157, 'Anna', 10000, 1),
(19569, 254, 165, 'Anna', 10000, 1),
(19570, 254, 131, 'Anna Maria', 10000, 1),
(19571, 254, 166, 'Annabella', 10000, 1),
(19572, 254, 147, 'Annada', 10000, 1),
(19573, 254, 145, 'Annandale', 10000, 1),
(19574, 254, 152, 'Annandale', 10000, 1),
(19575, 254, 154, 'Annandale on Hudson', 10000, 1),
(19576, 254, 126, 'Annapolis', 10000, 1),
(19577, 254, 135, 'Annapolis', 10000, 1),
(19578, 254, 147, 'Annapolis', 10000, 1),
(19579, 254, 142, 'Annapolis Junction', 10000, 1),
(19580, 254, 135, 'Annawan', 10000, 1),
(19581, 254, 122, 'Annemanie', 10000, 1),
(19582, 254, 147, 'Anniston', 10000, 1),
(19583, 254, 165, 'Annona', 10000, 1),
(19584, 254, 139, 'Annville', 10000, 1),
(19585, 254, 149, 'Anselmo', 10000, 1),
(19586, 254, 149, 'Ansley', 10000, 1),
(19587, 254, 157, 'Ansonia', 10000, 1),
(19588, 254, 155, 'Ansonville', 10000, 1),
(19589, 254, 169, 'Ansted', 10000, 1),
(19590, 254, 148, 'Antelope', 10000, 1),
(19591, 254, 159, 'Antelope', 10000, 1),
(19592, 254, 160, 'Antes Fort', 10000, 1),
(19593, 254, 137, 'Anthon', 10000, 1),
(19594, 254, 131, 'Anthony', 10000, 1),
(19595, 254, 153, 'Anthony', 10000, 1),
(19596, 254, 165, 'Anthony', 10000, 1),
(19597, 254, 166, 'Antimony', 10000, 1),
(19598, 254, 156, 'Antler', 10000, 1),
(19599, 254, 125, 'Antoine', 10000, 1),
(19600, 254, 127, 'Anton', 10000, 1),
(19601, 254, 165, 'Anton', 10000, 1),
(19602, 254, 153, 'Anton Chico', 10000, 1),
(19603, 254, 127, 'Antonito', 10000, 1),
(19604, 254, 151, 'Antrim', 10000, 1),
(19605, 254, 154, 'Antwerp', 10000, 1),
(19606, 254, 123, 'Anvik', 10000, 1),
(19607, 254, 158, 'Apache', 10000, 1),
(19608, 254, 154, 'Apalachin', 10000, 1),
(19609, 254, 164, 'Apison', 10000, 1),
(19610, 254, 137, 'Aplington', 10000, 1),
(19611, 254, 160, 'Apollo', 10000, 1),
(19612, 254, 131, 'Apollo Beach', 10000, 1),
(19613, 254, 167, 'Appalachia', 10000, 1),
(19614, 254, 157, 'Apple Creek', 10000, 1),
(19615, 254, 169, 'Apple Grove', 10000, 1),
(19616, 254, 135, 'Apple River', 10000, 1),
(19617, 254, 165, 'Apple Springs', 10000, 1),
(19618, 254, 144, 'Applegate', 10000, 1),
(19619, 254, 145, 'Appleton', 10000, 1),
(19620, 254, 154, 'Appleton', 10000, 1),
(19621, 254, 168, 'Appleton', 10000, 1),
(19622, 254, 147, 'Appleton City', 10000, 1),
(19623, 254, 154, 'Apulia Station', 10000, 1),
(19624, 254, 142, 'Aquasco', 10000, 1),
(19625, 254, 160, 'Aquashicola', 10000, 1),
(19626, 254, 154, 'Aquebogue', 10000, 1),
(19627, 254, 165, 'Aquilla', 10000, 1),
(19628, 254, 132, 'Arabi', 10000, 1),
(19629, 254, 140, 'Arabi', 10000, 1),
(19630, 254, 132, 'Aragon', 10000, 1),
(19631, 254, 153, 'Aragon', 10000, 1),
(19632, 254, 158, 'Arapaho', 10000, 1),
(19633, 254, 127, 'Arapahoe', 10000, 1),
(19634, 254, 155, 'Arapahoe', 10000, 1),
(19635, 254, 149, 'Arapahoe', 10000, 1),
(19636, 254, 171, 'Arapahoe', 10000, 1),
(19637, 254, 155, 'Ararat', 10000, 1),
(19638, 254, 167, 'Ararat', 10000, 1),
(19639, 254, 147, 'Arbela', 10000, 1),
(19640, 254, 127, 'Arboles', 10000, 1),
(19641, 254, 134, 'Arbon', 10000, 1),
(19642, 254, 169, 'Arbovale', 10000, 1),
(19643, 254, 126, 'Arbuckle', 10000, 1),
(19644, 254, 147, 'Arbyrd', 10000, 1),
(19645, 254, 137, 'Arcadia', 10000, 1),
(19646, 254, 136, 'Arcadia', 10000, 1),
(19647, 254, 138, 'Arcadia', 10000, 1),
(19648, 254, 140, 'Arcadia', 10000, 1),
(19649, 254, 144, 'Arcadia', 10000, 1),
(19650, 254, 147, 'Arcadia', 10000, 1),
(19651, 254, 149, 'Arcadia', 10000, 1),
(19652, 254, 157, 'Arcadia', 10000, 1),
(19653, 254, 158, 'Arcadia', 10000, 1),
(19654, 254, 160, 'Arcadia', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(19655, 254, 162, 'Arcadia', 10000, 1),
(19656, 254, 170, 'Arcadia', 10000, 1),
(19657, 254, 159, 'Arch Cape', 10000, 1),
(19658, 254, 137, 'Archer', 10000, 1),
(19659, 254, 149, 'Archer', 10000, 1),
(19660, 254, 140, 'Archibald', 10000, 1),
(19661, 254, 147, 'Archie', 10000, 1),
(19662, 254, 134, 'Arco', 10000, 1),
(19663, 254, 145, 'Arco', 10000, 1),
(19664, 254, 135, 'Arcola', 10000, 1),
(19665, 254, 136, 'Arcola', 10000, 1),
(19666, 254, 147, 'Arcola', 10000, 1),
(19667, 254, 146, 'Arcola', 10000, 1),
(19668, 254, 160, 'Arcola', 10000, 1),
(19669, 254, 167, 'Arcola', 10000, 1),
(19670, 254, 160, 'Ardara', 10000, 1),
(19671, 254, 154, 'Arden', 10000, 1),
(19672, 254, 168, 'Ardenvoir', 10000, 1),
(19673, 254, 122, 'Ardmore', 10000, 1),
(19674, 254, 160, 'Ardmore', 10000, 1),
(19675, 254, 164, 'Ardmore', 10000, 1),
(19676, 254, 156, 'Ardoch', 10000, 1),
(19677, 254, 154, 'Ardsley on Hudson', 10000, 1),
(19678, 254, 137, 'Aredale', 10000, 1),
(19679, 254, 153, 'Arenas Valley', 10000, 1),
(19680, 254, 160, 'Arendtsville', 10000, 1),
(19681, 254, 135, 'Arenzville', 10000, 1),
(19682, 254, 135, 'Argenta', 10000, 1),
(19683, 254, 139, 'Argillite', 10000, 1),
(19684, 254, 138, 'Argonia', 10000, 1),
(19685, 254, 170, 'Argonne', 10000, 1),
(19686, 254, 136, 'Argos', 10000, 1),
(19687, 254, 156, 'Argusville', 10000, 1),
(19688, 254, 131, 'Argyle', 10000, 1),
(19689, 254, 132, 'Argyle', 10000, 1),
(19690, 254, 137, 'Argyle', 10000, 1),
(19691, 254, 144, 'Argyle', 10000, 1),
(19692, 254, 145, 'Argyle', 10000, 1),
(19693, 254, 147, 'Argyle', 10000, 1),
(19694, 254, 154, 'Argyle', 10000, 1),
(19695, 254, 165, 'Argyle', 10000, 1),
(19696, 254, 170, 'Argyle', 10000, 1),
(19697, 254, 168, 'Ariel', 10000, 1),
(19698, 254, 134, 'Arimo', 10000, 1),
(19699, 254, 137, 'Arion', 10000, 1),
(19700, 254, 131, 'Aripeka', 10000, 1),
(19701, 254, 137, 'Arispe', 10000, 1),
(19702, 254, 160, 'Aristes', 10000, 1),
(19703, 254, 122, 'Ariton', 10000, 1),
(19704, 254, 124, 'Arivaca', 10000, 1),
(19705, 254, 124, 'Arizona City', 10000, 1),
(19706, 254, 139, 'Arjay', 10000, 1),
(19707, 254, 167, 'Ark', 10000, 1),
(19708, 254, 146, 'Arkabutla', 10000, 1),
(19709, 254, 170, 'Arkansaw', 10000, 1),
(19710, 254, 170, 'Arkdale', 10000, 1),
(19711, 254, 158, 'Arkoma', 10000, 1),
(19712, 254, 154, 'Arkport', 10000, 1),
(19713, 254, 148, 'Arlee', 10000, 1),
(19714, 254, 122, 'Arlington', 10000, 1),
(19715, 254, 124, 'Arlington', 10000, 1),
(19716, 254, 127, 'Arlington', 10000, 1),
(19717, 254, 132, 'Arlington', 10000, 1),
(19718, 254, 137, 'Arlington', 10000, 1),
(19719, 254, 135, 'Arlington', 10000, 1),
(19720, 254, 136, 'Arlington', 10000, 1),
(19721, 254, 138, 'Arlington', 10000, 1),
(19722, 254, 139, 'Arlington', 10000, 1),
(19723, 254, 145, 'Arlington', 10000, 1),
(19724, 254, 149, 'Arlington', 10000, 1),
(19725, 254, 157, 'Arlington', 10000, 1),
(19726, 254, 159, 'Arlington', 10000, 1),
(19727, 254, 163, 'Arlington', 10000, 1),
(19728, 254, 164, 'Arlington', 10000, 1),
(19729, 254, 172, 'Arlington', 10000, 1),
(19730, 254, 170, 'Arlington', 10000, 1),
(19731, 254, 143, 'Arlington Heights', 10000, 1),
(19732, 254, 138, 'Arma', 10000, 1),
(19733, 254, 160, 'Armagh', 10000, 1),
(19734, 254, 160, 'Armbrust', 10000, 1),
(19735, 254, 135, 'Armington', 10000, 1),
(19736, 254, 171, 'Arminto', 10000, 1),
(19737, 254, 126, 'Armona', 10000, 1),
(19738, 254, 125, 'Armorel', 10000, 1),
(19739, 254, 137, 'Armstrong', 10000, 1),
(19740, 254, 135, 'Armstrong', 10000, 1),
(19741, 254, 147, 'Armstrong', 10000, 1),
(19742, 254, 165, 'Armstrong', 10000, 1),
(19743, 254, 170, 'Armstrong Creek', 10000, 1),
(19744, 254, 132, 'Armuchee', 10000, 1),
(19745, 254, 140, 'Arnaudville', 10000, 1),
(19746, 254, 156, 'Arnegard', 10000, 1),
(19747, 254, 158, 'Arnett', 10000, 1),
(19748, 254, 169, 'Arnett', 10000, 1),
(19749, 254, 144, 'Arnold', 10000, 1),
(19750, 254, 149, 'Arnold', 10000, 1),
(19751, 254, 164, 'Arnold AFB', 10000, 1),
(19752, 254, 137, 'Arnolds Park', 10000, 1),
(19753, 254, 169, 'Arnoldsburg', 10000, 1),
(19754, 254, 132, 'Arnoldsville', 10000, 1),
(19755, 254, 160, 'Arnot', 10000, 1),
(19756, 254, 159, 'Arock', 10000, 1),
(19757, 254, 167, 'Aroda', 10000, 1),
(19758, 254, 135, 'Aroma Park', 10000, 1),
(19759, 254, 160, 'Arona', 10000, 1),
(19760, 254, 165, 'Arp', 10000, 1),
(19761, 254, 170, 'Arpin', 10000, 1),
(19762, 254, 153, 'Arrey', 10000, 1),
(19763, 254, 127, 'Arriba', 10000, 1),
(19764, 254, 164, 'Arrington', 10000, 1),
(19765, 254, 167, 'Arrington', 10000, 1),
(19766, 254, 147, 'Arrow Rock', 10000, 1),
(19767, 254, 135, 'Arrowsmith', 10000, 1),
(19768, 254, 153, 'Arroyo Hondo', 10000, 1),
(19769, 254, 153, 'Arroyo Seco', 10000, 1),
(19770, 254, 165, 'Art', 10000, 1),
(19771, 254, 160, 'Artemas', 10000, 1),
(19772, 254, 139, 'Artemus', 10000, 1),
(19773, 254, 126, 'Artesia', 10000, 1),
(19774, 254, 146, 'Artesia', 10000, 1),
(19775, 254, 165, 'Artesia Wells', 10000, 1),
(19776, 254, 163, 'Artesian', 10000, 1),
(19777, 254, 137, 'Arthur', 10000, 1),
(19778, 254, 135, 'Arthur', 10000, 1),
(19779, 254, 156, 'Arthur', 10000, 1),
(19780, 254, 164, 'Arthur', 10000, 1),
(19781, 254, 165, 'Arthur City', 10000, 1),
(19782, 254, 169, 'Arthurdale', 10000, 1),
(19783, 254, 169, 'Artie', 10000, 1),
(19784, 254, 171, 'Arvada', 10000, 1),
(19785, 254, 154, 'Arverne', 10000, 1),
(19786, 254, 156, 'Arvilla', 10000, 1),
(19787, 254, 167, 'Arvonia', 10000, 1),
(19788, 254, 139, 'Ary', 10000, 1),
(19789, 254, 147, 'Asbury', 10000, 1),
(19790, 254, 152, 'Asbury', 10000, 1),
(19791, 254, 169, 'Asbury', 10000, 1),
(19792, 254, 172, 'Ascutney', 10000, 1),
(19793, 254, 155, 'Ash', 10000, 1),
(19794, 254, 147, 'Ash Grove', 10000, 1),
(19795, 254, 147, 'Ashburn', 10000, 1),
(19796, 254, 143, 'Ashburnham', 10000, 1),
(19797, 254, 143, 'Ashby', 10000, 1),
(19798, 254, 145, 'Ashby', 10000, 1),
(19799, 254, 149, 'Ashby', 10000, 1),
(19800, 254, 139, 'Ashcamp', 10000, 1),
(19801, 254, 139, 'Asher', 10000, 1),
(19802, 254, 158, 'Asher', 10000, 1),
(19803, 254, 165, 'Asherton', 10000, 1),
(19804, 254, 143, 'Ashfield', 10000, 1),
(19805, 254, 160, 'Ashfield', 10000, 1),
(19806, 254, 122, 'Ashford', 10000, 1),
(19807, 254, 128, 'Ashford', 10000, 1),
(19808, 254, 168, 'Ashford', 10000, 1),
(19809, 254, 169, 'Ashford', 10000, 1),
(19810, 254, 170, 'Ashippun', 10000, 1),
(19811, 254, 135, 'Ashkum', 10000, 1),
(19812, 254, 135, 'Ashland', 10000, 1),
(19813, 254, 140, 'Ashland', 10000, 1),
(19814, 254, 141, 'Ashland', 10000, 1),
(19815, 254, 147, 'Ashland', 10000, 1),
(19816, 254, 149, 'Ashland', 10000, 1),
(19817, 254, 160, 'Ashland', 10000, 1),
(19818, 254, 167, 'Ashland', 10000, 1),
(19819, 254, 135, 'Ashley', 10000, 1),
(19820, 254, 136, 'Ashley', 10000, 1),
(19821, 254, 144, 'Ashley', 10000, 1),
(19822, 254, 157, 'Ashley', 10000, 1),
(19823, 254, 143, 'Ashley Falls', 10000, 1),
(19824, 254, 135, 'Ashmore', 10000, 1),
(19825, 254, 137, 'Ashton', 10000, 1),
(19826, 254, 134, 'Ashton', 10000, 1),
(19827, 254, 135, 'Ashton', 10000, 1),
(19828, 254, 142, 'Ashton', 10000, 1),
(19829, 254, 149, 'Ashton', 10000, 1),
(19830, 254, 163, 'Ashton', 10000, 1),
(19831, 254, 169, 'Ashton', 10000, 1),
(19832, 254, 151, 'Ashuelot', 10000, 1),
(19833, 254, 122, 'Ashville', 10000, 1),
(19834, 254, 154, 'Ashville', 10000, 1),
(19835, 254, 157, 'Ashville', 10000, 1),
(19836, 254, 160, 'Ashville', 10000, 1),
(19837, 254, 159, 'Ashwood', 10000, 1),
(19838, 254, 145, 'Askov', 10000, 1),
(19839, 254, 168, 'Asotin', 10000, 1),
(19840, 254, 137, 'Aspinwall', 10000, 1),
(19841, 254, 138, 'Assaria', 10000, 1),
(19842, 254, 167, 'Assawoman', 10000, 1),
(19843, 254, 143, 'Assonet', 10000, 1),
(19844, 254, 135, 'Assumption', 10000, 1),
(19845, 254, 131, 'Astatula', 10000, 1),
(19846, 254, 160, 'Aston', 10000, 1),
(19847, 254, 131, 'Astor', 10000, 1),
(19848, 254, 135, 'Astoria', 10000, 1),
(19849, 254, 154, 'Astoria', 10000, 1),
(19850, 254, 163, 'Astoria', 10000, 1),
(19851, 254, 137, 'Atalissa', 10000, 1),
(19852, 254, 165, 'Atascosa', 10000, 1),
(19853, 254, 160, 'Atglen', 10000, 1),
(19854, 254, 170, 'Athelstane', 10000, 1),
(19855, 254, 159, 'Athena', 10000, 1),
(19856, 254, 135, 'Athens', 10000, 1),
(19857, 254, 136, 'Athens', 10000, 1),
(19858, 254, 140, 'Athens', 10000, 1),
(19859, 254, 141, 'Athens', 10000, 1),
(19860, 254, 144, 'Athens', 10000, 1),
(19861, 254, 154, 'Athens', 10000, 1),
(19862, 254, 126, 'Atherton', 10000, 1),
(19863, 254, 138, 'Athol', 10000, 1),
(19864, 254, 139, 'Athol', 10000, 1),
(19865, 254, 154, 'Athol', 10000, 1),
(19866, 254, 154, 'Athol Springs', 10000, 1),
(19867, 254, 123, 'Atka', 10000, 1),
(19868, 254, 125, 'Atkins', 10000, 1),
(19869, 254, 137, 'Atkins', 10000, 1),
(19870, 254, 167, 'Atkins', 10000, 1),
(19871, 254, 135, 'Atkinson', 10000, 1),
(19872, 254, 155, 'Atkinson', 10000, 1),
(19873, 254, 149, 'Atkinson', 10000, 1),
(19874, 254, 134, 'Atlanta', 10000, 1),
(19875, 254, 135, 'Atlanta', 10000, 1),
(19876, 254, 136, 'Atlanta', 10000, 1),
(19877, 254, 138, 'Atlanta', 10000, 1),
(19878, 254, 140, 'Atlanta', 10000, 1),
(19879, 254, 147, 'Atlanta', 10000, 1),
(19880, 254, 149, 'Atlanta', 10000, 1),
(19881, 254, 154, 'Atlanta', 10000, 1),
(19882, 254, 155, 'Atlantic', 10000, 1),
(19883, 254, 160, 'Atlantic', 10000, 1),
(19884, 254, 167, 'Atlantic', 10000, 1),
(19885, 254, 154, 'Atlantic Beach', 10000, 1),
(19886, 254, 152, 'Atlantic Highlands', 10000, 1),
(19887, 254, 144, 'Atlantic Mine', 10000, 1),
(19888, 254, 144, 'Atlas', 10000, 1),
(19889, 254, 160, 'Atlasburg', 10000, 1),
(19890, 254, 122, 'Atmore', 10000, 1),
(19891, 254, 134, 'Atomic City', 10000, 1),
(19892, 254, 123, 'Atqasuk', 10000, 1),
(19893, 254, 122, 'Attalla', 10000, 1),
(19894, 254, 132, 'Attapulgus', 10000, 1),
(19895, 254, 138, 'Attica', 10000, 1),
(19896, 254, 144, 'Attica', 10000, 1),
(19897, 254, 154, 'Attica', 10000, 1),
(19898, 254, 157, 'Attica', 10000, 1),
(19899, 254, 143, 'Attleboro Falls', 10000, 1),
(19900, 254, 135, 'Atwater', 10000, 1),
(19901, 254, 145, 'Atwater', 10000, 1),
(19902, 254, 157, 'Atwater', 10000, 1),
(19903, 254, 126, 'Atwood', 10000, 1),
(19904, 254, 127, 'Atwood', 10000, 1),
(19905, 254, 135, 'Atwood', 10000, 1),
(19906, 254, 136, 'Atwood', 10000, 1),
(19907, 254, 158, 'Atwood', 10000, 1),
(19908, 254, 164, 'Atwood', 10000, 1),
(19909, 254, 144, 'Au Gres', 10000, 1),
(19910, 254, 144, 'Au Train', 10000, 1),
(19911, 254, 126, 'Auberry', 10000, 1),
(19912, 254, 125, 'Aubrey', 10000, 1),
(19913, 254, 165, 'Aubrey', 10000, 1),
(19914, 254, 132, 'Auburn', 10000, 1),
(19915, 254, 137, 'Auburn', 10000, 1),
(19916, 254, 135, 'Auburn', 10000, 1),
(19917, 254, 138, 'Auburn', 10000, 1),
(19918, 254, 139, 'Auburn', 10000, 1),
(19919, 254, 143, 'Auburn', 10000, 1),
(19920, 254, 144, 'Auburn', 10000, 1),
(19921, 254, 151, 'Auburn', 10000, 1),
(19922, 254, 160, 'Auburn', 10000, 1),
(19923, 254, 169, 'Auburn', 10000, 1),
(19924, 254, 171, 'Auburn', 10000, 1),
(19925, 254, 122, 'Auburn University', 10000, 1),
(19926, 254, 131, 'Auburndale', 10000, 1),
(19927, 254, 143, 'Auburndale', 10000, 1),
(19928, 254, 170, 'Auburndale', 10000, 1),
(19929, 254, 164, 'Auburntown', 10000, 1),
(19930, 254, 145, 'Audubon', 10000, 1),
(19931, 254, 152, 'Audubon', 10000, 1),
(19932, 254, 160, 'Audubon', 10000, 1),
(19933, 254, 135, 'Augusta', 10000, 1),
(19934, 254, 139, 'Augusta', 10000, 1),
(19935, 254, 144, 'Augusta', 10000, 1),
(19936, 254, 147, 'Augusta', 10000, 1),
(19937, 254, 148, 'Augusta', 10000, 1),
(19938, 254, 152, 'Augusta', 10000, 1),
(19939, 254, 157, 'Augusta', 10000, 1),
(19940, 254, 170, 'Augusta', 10000, 1),
(19941, 254, 169, 'Augusta', 10000, 1),
(19942, 254, 167, 'Augusta Springs', 10000, 1),
(19943, 254, 123, 'Auke Bay', 10000, 1),
(19944, 254, 155, 'Aulander', 10000, 1),
(19945, 254, 127, 'Ault', 10000, 1),
(19946, 254, 160, 'Aultman', 10000, 1),
(19947, 254, 137, 'Aurelia', 10000, 1),
(19948, 254, 154, 'Auriesville', 10000, 1),
(19950, 254, 137, 'Aurora', 10000, 1),
(19952, 254, 138, 'Aurora', 10000, 1),
(19953, 254, 141, 'Aurora', 10000, 1),
(19954, 254, 145, 'Aurora', 10000, 1),
(19955, 254, 155, 'Aurora', 10000, 1),
(19956, 254, 154, 'Aurora', 10000, 1),
(19957, 254, 163, 'Aurora', 10000, 1),
(19958, 254, 166, 'Aurora', 10000, 1),
(19959, 254, 169, 'Aurora', 10000, 1),
(19960, 254, 154, 'Austerlitz', 10000, 1),
(19961, 254, 125, 'Austin', 10000, 1),
(19962, 254, 127, 'Austin', 10000, 1),
(19963, 254, 136, 'Austin', 10000, 1),
(19964, 254, 139, 'Austin', 10000, 1),
(19965, 254, 160, 'Austin', 10000, 1),
(19967, 254, 157, 'Austinburg', 10000, 1),
(19968, 254, 137, 'Austinville', 10000, 1),
(19969, 254, 167, 'Austinville', 10000, 1),
(19970, 254, 165, 'Austwell', 10000, 1),
(19971, 254, 122, 'Autaugaville', 10000, 1),
(19972, 254, 169, 'Auto', 10000, 1),
(19973, 254, 155, 'Autryville', 10000, 1),
(19974, 254, 139, 'Auxier', 10000, 1),
(19975, 254, 147, 'Auxvasse', 10000, 1),
(19976, 254, 154, 'Ava', 10000, 1),
(19977, 254, 157, 'Ava', 10000, 1),
(19978, 254, 146, 'Avalon', 10000, 1),
(19979, 254, 165, 'Avalon', 10000, 1),
(19980, 254, 170, 'Avalon', 10000, 1),
(19981, 254, 158, 'Avant', 10000, 1),
(19982, 254, 139, 'Avawam', 10000, 1),
(19983, 254, 160, 'Avella', 10000, 1),
(19984, 254, 142, 'Avenue', 10000, 1),
(19985, 254, 132, 'Avera', 10000, 1),
(19986, 254, 172, 'Averill', 10000, 1),
(19987, 254, 154, 'Averill Park', 10000, 1),
(19988, 254, 126, 'Avery', 10000, 1),
(19989, 254, 134, 'Avery', 10000, 1),
(19990, 254, 165, 'Avery', 10000, 1),
(19991, 254, 140, 'Avery Island', 10000, 1),
(19992, 254, 136, 'Avilla', 10000, 1),
(19993, 254, 147, 'Avilla', 10000, 1),
(19994, 254, 165, 'Avinger', 10000, 1),
(19995, 254, 160, 'Avis', 10000, 1),
(19996, 254, 135, 'Aviston', 10000, 1),
(19997, 254, 125, 'Avoca', 10000, 1),
(19998, 254, 137, 'Avoca', 10000, 1),
(19999, 254, 136, 'Avoca', 10000, 1),
(20000, 254, 144, 'Avoca', 10000, 1),
(20001, 254, 145, 'Avoca', 10000, 1),
(20002, 254, 149, 'Avoca', 10000, 1),
(20003, 254, 154, 'Avoca', 10000, 1),
(20004, 254, 165, 'Avoca', 10000, 1),
(20005, 254, 170, 'Avoca', 10000, 1),
(20006, 254, 127, 'Avon', 10000, 1),
(20007, 254, 135, 'Avon', 10000, 1),
(20008, 254, 136, 'Avon', 10000, 1),
(20009, 254, 143, 'Avon', 10000, 1),
(20010, 254, 145, 'Avon', 10000, 1),
(20011, 254, 146, 'Avon', 10000, 1),
(20012, 254, 148, 'Avon', 10000, 1),
(20013, 254, 155, 'Avon', 10000, 1),
(20014, 254, 154, 'Avon', 10000, 1),
(20015, 254, 163, 'Avon', 10000, 1),
(20016, 254, 152, 'Avon by the Sea', 10000, 1),
(20017, 254, 127, 'Avondale', 10000, 1),
(20018, 254, 160, 'Avondale', 10000, 1),
(20019, 254, 169, 'Avondale', 10000, 1),
(20020, 254, 132, 'Avondale Estates', 10000, 1),
(20021, 254, 160, 'Avonmore', 10000, 1),
(20022, 254, 162, 'Awendaw', 10000, 1),
(20023, 254, 122, 'Axis', 10000, 1),
(20024, 254, 132, 'Axson', 10000, 1),
(20025, 254, 138, 'Axtell', 10000, 1),
(20026, 254, 149, 'Axtell', 10000, 1),
(20027, 254, 165, 'Axtell', 10000, 1),
(20028, 254, 166, 'Axtell', 10000, 1),
(20029, 254, 167, 'Axton', 10000, 1),
(20030, 254, 155, 'Ayden', 10000, 1),
(20031, 254, 155, 'Aydlett', 10000, 1),
(20032, 254, 143, 'Ayer', 10000, 1),
(20033, 254, 167, 'Aylett', 10000, 1),
(20034, 254, 162, 'Aynor', 10000, 1),
(20035, 254, 156, 'Ayr', 10000, 1),
(20036, 254, 149, 'Ayr', 10000, 1),
(20037, 254, 137, 'Ayrshire', 10000, 1),
(20038, 254, 159, 'Azalea', 10000, 1),
(20039, 254, 144, 'Azalia', 10000, 1),
(20040, 254, 165, 'Azle', 10000, 1),
(20042, 254, 148, 'Babb', 10000, 1),
(20043, 254, 145, 'Babbitt', 10000, 1),
(20044, 254, 170, 'Babcock', 10000, 1),
(20045, 254, 131, 'Babson Park', 10000, 1),
(20046, 254, 143, 'Babson Park', 10000, 1),
(20047, 254, 145, 'Backus', 10000, 1),
(20048, 254, 165, 'Bacliff', 10000, 1),
(20049, 254, 132, 'Baconton', 10000, 1),
(20050, 254, 167, 'Bacova', 10000, 1),
(20051, 254, 126, 'Badger', 10000, 1),
(20052, 254, 137, 'Badger', 10000, 1),
(20053, 254, 145, 'Badger', 10000, 1),
(20054, 254, 163, 'Badger', 10000, 1),
(20055, 254, 155, 'Badin', 10000, 1),
(20056, 254, 124, 'Bagdad', 10000, 1),
(20057, 254, 131, 'Bagdad', 10000, 1),
(20058, 254, 139, 'Bagdad', 10000, 1),
(20059, 254, 171, 'Baggs', 10000, 1),
(20060, 254, 137, 'Bagley', 10000, 1),
(20061, 254, 170, 'Bagley', 10000, 1),
(20062, 254, 165, 'Bagwell', 10000, 1),
(20063, 254, 155, 'Bahama', 10000, 1),
(20064, 254, 127, 'Bailey', 10000, 1),
(20065, 254, 144, 'Bailey', 10000, 1),
(20066, 254, 146, 'Bailey', 10000, 1),
(20067, 254, 165, 'Bailey', 10000, 1),
(20068, 254, 141, 'Bailey Island', 10000, 1),
(20069, 254, 170, 'Baileys Harbor', 10000, 1),
(20070, 254, 122, 'Baileyton', 10000, 1),
(20071, 254, 135, 'Baileyville', 10000, 1),
(20072, 254, 138, 'Baileyville', 10000, 1),
(20073, 254, 141, 'Baileyville', 10000, 1),
(20074, 254, 136, 'Bainbridge', 10000, 1),
(20075, 254, 154, 'Bainbridge', 10000, 1),
(20076, 254, 157, 'Bainbridge', 10000, 1),
(20077, 254, 160, 'Bainbridge', 10000, 1),
(20078, 254, 148, 'Bainville', 10000, 1),
(20079, 254, 165, 'Baird', 10000, 1),
(20080, 254, 160, 'Bairdford', 10000, 1),
(20081, 254, 171, 'Bairoil', 10000, 1),
(20082, 254, 169, 'Baisden', 10000, 1),
(20083, 254, 126, 'Baker', 10000, 1),
(20084, 254, 131, 'Baker', 10000, 1),
(20085, 254, 145, 'Baker', 10000, 1),
(20086, 254, 150, 'Baker', 10000, 1),
(20087, 254, 169, 'Baker', 10000, 1),
(20088, 254, 154, 'Bakers Mills', 10000, 1),
(20089, 254, 160, 'Bakers Summit', 10000, 1),
(20090, 254, 147, 'Bakersfield', 10000, 1),
(20091, 254, 172, 'Bakersfield', 10000, 1),
(20092, 254, 160, 'Bakerstown', 10000, 1),
(20093, 254, 157, 'Bakersville', 10000, 1),
(20094, 254, 139, 'Bakerton', 10000, 1),
(20095, 254, 169, 'Bakerton', 10000, 1),
(20096, 254, 164, 'Bakewell', 10000, 1),
(20097, 254, 160, 'Bala Cynwyd', 10000, 1),
(20098, 254, 145, 'Balaton', 10000, 1),
(20099, 254, 125, 'Bald Knob', 10000, 1),
(20100, 254, 169, 'Bald Knob', 10000, 1),
(20101, 254, 132, 'Baldwin', 10000, 1),
(20102, 254, 137, 'Baldwin', 10000, 1),
(20103, 254, 135, 'Baldwin', 10000, 1),
(20104, 254, 140, 'Baldwin', 10000, 1),
(20105, 254, 142, 'Baldwin', 10000, 1),
(20106, 254, 156, 'Baldwin', 10000, 1),
(20107, 254, 170, 'Baldwin', 10000, 1),
(20108, 254, 154, 'Baldwin Place', 10000, 1),
(20109, 254, 143, 'Baldwinville', 10000, 1),
(20110, 254, 146, 'Baldwyn', 10000, 1),
(20111, 254, 156, 'Balfour', 10000, 1),
(20112, 254, 158, 'Balko', 10000, 1),
(20113, 254, 132, 'Ball Ground', 10000, 1),
(20114, 254, 148, 'Ballantine', 10000, 1),
(20115, 254, 169, 'Ballard', 10000, 1),
(20116, 254, 169, 'Ballengee', 10000, 1),
(20117, 254, 162, 'Ballentine', 10000, 1),
(20118, 254, 126, 'Ballico', 10000, 1),
(20119, 254, 128, 'Ballouville', 10000, 1),
(20120, 254, 154, 'Ballston Spa', 10000, 1),
(20121, 254, 160, 'Bally', 10000, 1),
(20122, 254, 131, 'Balm', 10000, 1),
(20123, 254, 165, 'Balmorhea', 10000, 1),
(20124, 254, 155, 'Balsam', 10000, 1),
(20125, 254, 156, 'Balta', 10000, 1),
(20126, 254, 128, 'Baltic', 10000, 1),
(20127, 254, 157, 'Baltic', 10000, 1),
(20128, 254, 163, 'Baltic', 10000, 1),
(20131, 254, 157, 'Baltimore', 10000, 1),
(20132, 254, 167, 'Banco', 10000, 1),
(20133, 254, 137, 'Bancroft', 10000, 1),
(20134, 254, 134, 'Bancroft', 10000, 1),
(20135, 254, 144, 'Bancroft', 10000, 1),
(20136, 254, 149, 'Bancroft', 10000, 1),
(20137, 254, 170, 'Bancroft', 10000, 1),
(20138, 254, 169, 'Bancroft', 10000, 1),
(20139, 254, 167, 'Bandy', 10000, 1),
(20140, 254, 154, 'Bangall', 10000, 1),
(20141, 254, 170, 'Bangor', 10000, 1),
(20142, 254, 165, 'Bangs', 10000, 1),
(20143, 254, 122, 'Banks', 10000, 1),
(20144, 254, 125, 'Banks', 10000, 1),
(20145, 254, 134, 'Banks', 10000, 1),
(20146, 254, 159, 'Banks', 10000, 1),
(20147, 254, 122, 'Bankston', 10000, 1),
(20148, 254, 139, 'Banner', 10000, 1),
(20149, 254, 146, 'Banner', 10000, 1),
(20150, 254, 144, 'Bannister', 10000, 1),
(20151, 254, 157, 'Bannock', 10000, 1),
(20152, 254, 165, 'Banquete', 10000, 1),
(20153, 254, 128, 'Bantam', 10000, 1),
(20154, 254, 156, 'Bantry', 10000, 1),
(20155, 254, 124, 'Bapchule', 10000, 1),
(20156, 254, 152, 'Baptistown', 10000, 1),
(20157, 254, 141, 'Bar Mills', 10000, 1),
(20158, 254, 144, 'Barbeau', 10000, 1),
(20159, 254, 133, 'Barbers Point', 10000, 1),
(20160, 254, 131, 'Barberville', 10000, 1),
(20161, 254, 167, 'Barboursville', 10000, 1),
(20162, 254, 169, 'Barboursville', 10000, 1),
(20163, 254, 142, 'Barclay', 10000, 1),
(20164, 254, 155, 'Barco', 10000, 1),
(20165, 254, 126, 'Bard', 10000, 1),
(20166, 254, 153, 'Bard', 10000, 1),
(20167, 254, 135, 'Bardolph', 10000, 1),
(20168, 254, 165, 'Bardwell', 10000, 1),
(20169, 254, 136, 'Bargersville', 10000, 1),
(20170, 254, 167, 'Barhamsville', 10000, 1),
(20171, 254, 147, 'Baring', 10000, 1),
(20172, 254, 168, 'Baring', 10000, 1),
(20173, 254, 155, 'Barium Springs', 10000, 1),
(20174, 254, 144, 'Bark River', 10000, 1),
(20175, 254, 154, 'Barker', 10000, 1),
(20176, 254, 165, 'Barker', 10000, 1),
(20177, 254, 128, 'Barkhamsted', 10000, 1),
(20178, 254, 165, 'Barksdale', 10000, 1),
(20179, 254, 140, 'Barksdale AFB', 10000, 1),
(20180, 254, 125, 'Barling', 10000, 1),
(20181, 254, 139, 'Barlow', 10000, 1),
(20182, 254, 157, 'Barlow', 10000, 1),
(20183, 254, 138, 'Barnard', 10000, 1),
(20184, 254, 147, 'Barnard', 10000, 1),
(20185, 254, 163, 'Barnard', 10000, 1),
(20186, 254, 172, 'Barnard', 10000, 1),
(20187, 254, 155, 'Barnardsville', 10000, 1),
(20188, 254, 152, 'Barnegat Light', 10000, 1),
(20189, 254, 138, 'Barnes', 10000, 1),
(20190, 254, 137, 'Barnes City', 10000, 1),
(20191, 254, 149, 'Barneston', 10000, 1),
(20192, 254, 145, 'Barnesville', 10000, 1),
(20193, 254, 155, 'Barnesville', 10000, 1),
(20194, 254, 172, 'Barnet', 10000, 1),
(20195, 254, 147, 'Barnett', 10000, 1),
(20196, 254, 154, 'Barneveld', 10000, 1),
(20197, 254, 170, 'Barneveld', 10000, 1),
(20198, 254, 132, 'Barney', 10000, 1),
(20199, 254, 156, 'Barney', 10000, 1),
(20200, 254, 147, 'Barnhart', 10000, 1),
(20201, 254, 165, 'Barnhart', 10000, 1),
(20202, 254, 135, 'Barnhill', 10000, 1),
(20203, 254, 158, 'Barnsdall', 10000, 1),
(20204, 254, 151, 'Barnstead', 10000, 1),
(20205, 254, 137, 'Barnum', 10000, 1),
(20206, 254, 145, 'Barnum', 10000, 1),
(20207, 254, 144, 'Baroda', 10000, 1),
(20208, 254, 169, 'Barrackville', 10000, 1),
(20209, 254, 167, 'Barren Springs', 10000, 1),
(20210, 254, 145, 'Barrett', 10000, 1),
(20211, 254, 151, 'Barrington', 10000, 1),
(20212, 254, 152, 'Barrington', 10000, 1),
(20213, 254, 161, 'Barrington', 10000, 1),
(20214, 254, 170, 'Barronett', 10000, 1),
(20215, 254, 135, 'Barry', 10000, 1),
(20216, 254, 145, 'Barry', 10000, 1),
(20217, 254, 165, 'Barry', 10000, 1),
(20218, 254, 144, 'Barryton', 10000, 1),
(20219, 254, 154, 'Barrytown', 10000, 1),
(20220, 254, 154, 'Barryville', 10000, 1),
(20221, 254, 135, 'Barstow', 10000, 1),
(20222, 254, 142, 'Barstow', 10000, 1),
(20223, 254, 165, 'Barstow', 10000, 1),
(20224, 254, 160, 'Bart', 10000, 1),
(20225, 254, 135, 'Bartelso', 10000, 1),
(20226, 254, 138, 'Bartlett', 10000, 1),
(20227, 254, 151, 'Bartlett', 10000, 1),
(20228, 254, 157, 'Bartlett', 10000, 1),
(20229, 254, 165, 'Bartlett', 10000, 1),
(20230, 254, 149, 'Bartley', 10000, 1),
(20231, 254, 169, 'Bartley', 10000, 1),
(20232, 254, 125, 'Barton', 10000, 1),
(20233, 254, 142, 'Barton', 10000, 1),
(20234, 254, 154, 'Barton', 10000, 1),
(20235, 254, 157, 'Barton', 10000, 1),
(20236, 254, 172, 'Barton', 10000, 1),
(20237, 254, 144, 'Barton City', 10000, 1),
(20238, 254, 160, 'Bartonsville', 10000, 1),
(20239, 254, 132, 'Bartow', 10000, 1),
(20240, 254, 132, 'Barwick', 10000, 1),
(20241, 254, 127, 'Basalt', 10000, 1),
(20242, 254, 134, 'Basalt', 10000, 1),
(20243, 254, 135, 'Basco', 10000, 1),
(20244, 254, 131, 'Bascom', 10000, 1),
(20245, 254, 157, 'Bascom', 10000, 1),
(20246, 254, 138, 'Basehor', 10000, 1),
(20247, 254, 140, 'Basile', 10000, 1),
(20248, 254, 148, 'Basin', 10000, 1),
(20249, 254, 171, 'Basin', 10000, 1),
(20250, 254, 167, 'Baskerville', 10000, 1),
(20251, 254, 139, 'Baskett', 10000, 1),
(20252, 254, 140, 'Baskin', 10000, 1),
(20253, 254, 154, 'Basom', 10000, 1),
(20254, 254, 141, 'Bass Harbor', 10000, 1),
(20255, 254, 126, 'Bass Lake', 10000, 1),
(20256, 254, 125, 'Bassett', 10000, 1),
(20257, 254, 167, 'Bassett', 10000, 1),
(20258, 254, 170, 'Bassett', 10000, 1),
(20259, 254, 146, 'Bassfield', 10000, 1),
(20260, 254, 167, 'Bastian', 10000, 1),
(20261, 254, 155, 'Bat Cave', 10000, 1),
(20262, 254, 137, 'Batavia', 10000, 1),
(20263, 254, 140, 'Batchelor', 10000, 1),
(20264, 254, 135, 'Batchtown', 10000, 1),
(20265, 254, 125, 'Bates', 10000, 1),
(20266, 254, 159, 'Bates', 10000, 1),
(20267, 254, 147, 'Bates City', 10000, 1),
(20268, 254, 162, 'Batesburg', 10000, 1),
(20269, 254, 163, 'Batesland', 10000, 1),
(20270, 254, 165, 'Batesville', 10000, 1),
(20271, 254, 167, 'Batesville', 10000, 1),
(20272, 254, 135, 'Bath', 10000, 1),
(20273, 254, 136, 'Bath', 10000, 1),
(20274, 254, 144, 'Bath', 10000, 1),
(20275, 254, 155, 'Bath', 10000, 1),
(20276, 254, 151, 'Bath', 10000, 1),
(20277, 254, 157, 'Bath', 10000, 1),
(20278, 254, 160, 'Bath', 10000, 1),
(20279, 254, 162, 'Bath', 10000, 1),
(20280, 254, 163, 'Bath', 10000, 1),
(20281, 254, 164, 'Bath Springs', 10000, 1),
(20282, 254, 156, 'Bathgate', 10000, 1),
(20283, 254, 165, 'Batson', 10000, 1),
(20284, 254, 167, 'Battery Park', 10000, 1),
(20285, 254, 158, 'Battiest', 10000, 1),
(20286, 254, 137, 'Battle Creek', 10000, 1),
(20287, 254, 149, 'Battle Creek', 10000, 1),
(20288, 254, 168, 'Battle Ground', 10000, 1),
(20289, 254, 145, 'Battle Lake', 10000, 1),
(20290, 254, 155, 'Battleboro', 10000, 1),
(20291, 254, 127, 'Battlement Mesa', 10000, 1),
(20292, 254, 139, 'Battletown', 10000, 1),
(20293, 254, 160, 'Bausman', 10000, 1),
(20294, 254, 125, 'Bauxite', 10000, 1),
(20295, 254, 137, 'Baxter', 10000, 1),
(20296, 254, 139, 'Baxter', 10000, 1),
(20297, 254, 145, 'Baxter', 10000, 1),
(20298, 254, 164, 'Baxter', 10000, 1),
(20299, 254, 169, 'Baxter', 10000, 1),
(20300, 254, 138, 'Baxter Springs', 10000, 1),
(20301, 254, 125, 'Bay', 10000, 1),
(20302, 254, 168, 'Bay Center', 10000, 1),
(20303, 254, 159, 'Bay City', 10000, 1),
(20304, 254, 170, 'Bay City', 10000, 1),
(20305, 254, 131, 'Bay Pines', 10000, 1),
(20306, 254, 144, 'Bay Port', 10000, 1),
(20307, 254, 146, 'Bay Saint Louis', 10000, 1),
(20308, 254, 144, 'Bay Shore', 10000, 1),
(20309, 254, 157, 'Bay Village', 10000, 1),
(20310, 254, 137, 'Bayard', 10000, 1),
(20311, 254, 149, 'Bayard', 10000, 1),
(20312, 254, 153, 'Bayard', 10000, 1),
(20313, 254, 169, 'Bayard', 10000, 1),
(20314, 254, 155, 'Bayboro', 10000, 1),
(20315, 254, 127, 'Bayfield', 10000, 1),
(20316, 254, 135, 'Baylis', 10000, 1),
(20317, 254, 140, 'Bayou Goula', 10000, 1),
(20318, 254, 145, 'Bayport', 10000, 1),
(20319, 254, 139, 'Bays', 10000, 1),
(20320, 254, 126, 'Bayside', 10000, 1),
(20321, 254, 154, 'Bayside', 10000, 1),
(20322, 254, 165, 'Bayside', 10000, 1),
(20323, 254, 134, 'Bayview', 10000, 1),
(20324, 254, 141, 'Bayville', 10000, 1),
(20325, 254, 152, 'Bayville', 10000, 1),
(20326, 254, 154, 'Bayville', 10000, 1),
(20327, 254, 138, 'Bazine', 10000, 1),
(20328, 254, 157, 'Beach City', 10000, 1),
(20329, 254, 160, 'Beach Haven', 10000, 1),
(20330, 254, 160, 'Beach Lake', 10000, 1),
(20331, 254, 157, 'Beachwood', 10000, 1),
(20332, 254, 137, 'Beacon', 10000, 1),
(20333, 254, 128, 'Beacon Falls', 10000, 1),
(20334, 254, 126, 'Beale AFB', 10000, 1),
(20335, 254, 142, 'Beallsville', 10000, 1),
(20336, 254, 157, 'Beallsville', 10000, 1),
(20337, 254, 160, 'Beallsville', 10000, 1),
(20338, 254, 141, 'Beals', 10000, 1),
(20339, 254, 164, 'Bean Station', 10000, 1),
(20340, 254, 129, 'Bear', 10000, 1),
(20341, 254, 139, 'Bear Branch', 10000, 1),
(20342, 254, 155, 'Bear Creek', 10000, 1),
(20343, 254, 160, 'Bear Creek', 10000, 1),
(20344, 254, 170, 'Bear Creek', 10000, 1),
(20345, 254, 144, 'Bear Lake', 10000, 1),
(20346, 254, 160, 'Bear Lake', 10000, 1),
(20347, 254, 154, 'Bear Mountain', 10000, 1),
(20348, 254, 166, 'Bear River City', 10000, 1),
(20349, 254, 148, 'Bearcreek', 10000, 1),
(20350, 254, 125, 'Bearden', 10000, 1),
(20351, 254, 145, 'Beardsley', 10000, 1),
(20352, 254, 154, 'Bearsville', 10000, 1),
(20353, 254, 165, 'Beasley', 10000, 1),
(20354, 254, 135, 'Beason', 10000, 1),
(20355, 254, 122, 'Beatrice', 10000, 1),
(20356, 254, 138, 'Beattie', 10000, 1),
(20357, 254, 150, 'Beatty', 10000, 1),
(20358, 254, 159, 'Beatty', 10000, 1),
(20359, 254, 147, 'Beaufort', 10000, 1),
(20360, 254, 138, 'Beaumont', 10000, 1),
(20361, 254, 139, 'Beaumont', 10000, 1),
(20362, 254, 146, 'Beaumont', 10000, 1),
(20363, 254, 167, 'Beaumont', 10000, 1),
(20364, 254, 139, 'Beauty', 10000, 1),
(20365, 254, 123, 'Beaver', 10000, 1),
(20366, 254, 125, 'Beaver', 10000, 1),
(20367, 254, 137, 'Beaver', 10000, 1),
(20368, 254, 139, 'Beaver', 10000, 1),
(20369, 254, 157, 'Beaver', 10000, 1),
(20370, 254, 159, 'Beaver', 10000, 1),
(20371, 254, 166, 'Beaver', 10000, 1),
(20372, 254, 168, 'Beaver', 10000, 1),
(20373, 254, 145, 'Beaver Bay', 10000, 1),
(20374, 254, 145, 'Beaver Creek', 10000, 1),
(20375, 254, 149, 'Beaver Crossing', 10000, 1),
(20376, 254, 139, 'Beaver Dam', 10000, 1),
(20377, 254, 154, 'Beaver Dams', 10000, 1),
(20378, 254, 154, 'Beaver Falls', 10000, 1),
(20379, 254, 144, 'Beaver Island', 10000, 1),
(20380, 254, 160, 'Beaver Meadows', 10000, 1),
(20381, 254, 160, 'Beaver Springs', 10000, 1),
(20382, 254, 160, 'Beaverdale', 10000, 1),
(20383, 254, 157, 'Beaverdam', 10000, 1),
(20384, 254, 167, 'Beaverdam', 10000, 1),
(20385, 254, 122, 'Beaverton', 10000, 1),
(20386, 254, 144, 'Beaverton', 10000, 1),
(20387, 254, 160, 'Beavertown', 10000, 1),
(20388, 254, 135, 'Beaverville', 10000, 1),
(20389, 254, 165, 'Bebe', 10000, 1),
(20390, 254, 160, 'Beccaria', 10000, 1),
(20391, 254, 160, 'Bechtelsville', 10000, 1),
(20392, 254, 135, 'Beckemeyer', 10000, 1),
(20393, 254, 145, 'Becker', 10000, 1),
(20394, 254, 146, 'Becker', 10000, 1),
(20395, 254, 143, 'Becket', 10000, 1),
(20396, 254, 165, 'Beckville', 10000, 1),
(20397, 254, 126, 'Beckwourth', 10000, 1),
(20398, 254, 144, 'Bedford', 10000, 1),
(20399, 254, 151, 'Bedford', 10000, 1),
(20400, 254, 171, 'Bedford', 10000, 1),
(20401, 254, 154, 'Bedford Hills', 10000, 1),
(20402, 254, 135, 'Bedford Park', 10000, 1),
(20403, 254, 165, 'Bedias', 10000, 1),
(20404, 254, 152, 'Bedminster', 10000, 1),
(20405, 254, 160, 'Bedminster', 10000, 1),
(20406, 254, 127, 'Bedrock', 10000, 1),
(20407, 254, 149, 'Bee', 10000, 1),
(20408, 254, 167, 'Bee', 10000, 1),
(20409, 254, 125, 'Bee Branch', 10000, 1),
(20410, 254, 139, 'Bee Spring', 10000, 1),
(20411, 254, 172, 'Beebe Plain', 10000, 1),
(20412, 254, 164, 'Beech Bluff', 10000, 1),
(20413, 254, 169, 'Beech Bottom', 10000, 1),
(20414, 254, 139, 'Beech Creek', 10000, 1),
(20415, 254, 160, 'Beech Creek', 10000, 1),
(20416, 254, 125, 'Beech Grove', 10000, 1),
(20417, 254, 136, 'Beech Grove', 10000, 1),
(20418, 254, 139, 'Beech Grove', 10000, 1),
(20419, 254, 162, 'Beech Island', 10000, 1),
(20420, 254, 135, 'Beecher', 10000, 1),
(20421, 254, 135, 'Beecher City', 10000, 1),
(20422, 254, 172, 'Beecher Falls', 10000, 1),
(20423, 254, 139, 'Beechmont', 10000, 1),
(20424, 254, 125, 'Beedeville', 10000, 1),
(20425, 254, 138, 'Beeler', 10000, 1),
(20426, 254, 149, 'Beemer', 10000, 1),
(20427, 254, 164, 'Beersheba Springs', 10000, 1),
(20428, 254, 169, 'Beeson', 10000, 1),
(20429, 254, 170, 'Beetown', 10000, 1),
(20430, 254, 158, 'Beggs', 10000, 1),
(20431, 254, 125, 'Beirne', 10000, 1),
(20432, 254, 145, 'Bejou', 10000, 1),
(20433, 254, 142, 'Bel Alton', 10000, 1),
(20434, 254, 142, 'Belcamp', 10000, 1),
(20435, 254, 139, 'Belcher', 10000, 1),
(20436, 254, 140, 'Belcher', 10000, 1),
(20437, 254, 156, 'Belcourt', 10000, 1),
(20438, 254, 126, 'Belden', 10000, 1),
(20439, 254, 146, 'Belden', 10000, 1),
(20440, 254, 149, 'Belden', 10000, 1),
(20441, 254, 170, 'Beldenville', 10000, 1),
(20442, 254, 144, 'Belding', 10000, 1),
(20443, 254, 146, 'Belen', 10000, 1),
(20444, 254, 155, 'Belews Creek', 10000, 1),
(20445, 254, 154, 'Belfast', 10000, 1),
(20446, 254, 164, 'Belfast', 10000, 1),
(20447, 254, 156, 'Belfield', 10000, 1),
(20448, 254, 152, 'Belford', 10000, 1),
(20449, 254, 139, 'Belfry', 10000, 1),
(20450, 254, 148, 'Belfry', 10000, 1),
(20451, 254, 170, 'Belgium', 10000, 1),
(20452, 254, 141, 'Belgrade', 10000, 1),
(20453, 254, 147, 'Belgrade', 10000, 1),
(20454, 254, 149, 'Belgrade', 10000, 1),
(20455, 254, 141, 'Belgrade Lakes', 10000, 1),
(20456, 254, 155, 'Belhaven', 10000, 1),
(20457, 254, 169, 'Belington', 10000, 1),
(20458, 254, 122, 'Belk', 10000, 1),
(20459, 254, 135, 'Belknap', 10000, 1),
(20460, 254, 131, 'Bell', 10000, 1),
(20461, 254, 164, 'Bell Buckle', 10000, 1),
(20462, 254, 140, 'Bell City', 10000, 1),
(20463, 254, 147, 'Bell City', 10000, 1),
(20464, 254, 153, 'Bell Ranch', 10000, 1),
(20465, 254, 126, 'Bella Vista', 10000, 1),
(20466, 254, 165, 'Bellaire', 10000, 1),
(20467, 254, 122, 'Bellamy', 10000, 1),
(20468, 254, 167, 'Bellamy', 10000, 1),
(20469, 254, 155, 'Bellarthur', 10000, 1),
(20470, 254, 157, 'Bellbrook', 10000, 1),
(20471, 254, 147, 'Belle', 10000, 1),
(20472, 254, 157, 'Belle Center', 10000, 1),
(20473, 254, 140, 'Belle Chasse', 10000, 1),
(20474, 254, 167, 'Belle Haven', 10000, 1),
(20475, 254, 122, 'Belle Mina', 10000, 1),
(20476, 254, 137, 'Belle Plaine', 10000, 1),
(20477, 254, 138, 'Belle Plaine', 10000, 1),
(20478, 254, 145, 'Belle Plaine', 10000, 1),
(20479, 254, 135, 'Belle Rive', 10000, 1),
(20480, 254, 140, 'Belle Rose', 10000, 1),
(20481, 254, 157, 'Belle Valley', 10000, 1),
(20482, 254, 131, 'Belleair Beach', 10000, 1),
(20483, 254, 146, 'Bellefontaine', 10000, 1),
(20484, 254, 124, 'Bellemont', 10000, 1),
(20485, 254, 154, 'Bellerose', 10000, 1),
(20486, 254, 131, 'Belleview', 10000, 1),
(20487, 254, 147, 'Belleview', 10000, 1),
(20488, 254, 125, 'Belleville', 10000, 1),
(20489, 254, 144, 'Belleville', 10000, 1),
(20490, 254, 154, 'Belleville', 10000, 1),
(20491, 254, 160, 'Belleville', 10000, 1),
(20492, 254, 169, 'Belleville', 10000, 1),
(20493, 254, 137, 'Bellevue', 10000, 1),
(20494, 254, 144, 'Bellevue', 10000, 1),
(20495, 254, 165, 'Bellevue', 10000, 1),
(20496, 254, 135, 'Bellflower', 10000, 1),
(20497, 254, 147, 'Bellflower', 10000, 1),
(20498, 254, 145, 'Bellingham', 10000, 1),
(20499, 254, 135, 'Bellmont', 10000, 1),
(20500, 254, 136, 'Bellmore', 10000, 1),
(20501, 254, 154, 'Bellona', 10000, 1),
(20502, 254, 172, 'Bellows Falls', 10000, 1),
(20503, 254, 154, 'Bellport', 10000, 1),
(20504, 254, 165, 'Bells', 10000, 1),
(20505, 254, 154, 'Bellvale', 10000, 1),
(20506, 254, 132, 'Bellville', 10000, 1),
(20507, 254, 157, 'Bellville', 10000, 1),
(20508, 254, 127, 'Bellvue', 10000, 1),
(20509, 254, 122, 'Bellwood', 10000, 1),
(20510, 254, 149, 'Bellwood', 10000, 1),
(20511, 254, 137, 'Belmond', 10000, 1),
(20512, 254, 140, 'Belmont', 10000, 1),
(20513, 254, 144, 'Belmont', 10000, 1),
(20514, 254, 146, 'Belmont', 10000, 1),
(20515, 254, 155, 'Belmont', 10000, 1),
(20516, 254, 151, 'Belmont', 10000, 1),
(20517, 254, 154, 'Belmont', 10000, 1),
(20518, 254, 157, 'Belmont', 10000, 1),
(20519, 254, 165, 'Belmont', 10000, 1),
(20520, 254, 172, 'Belmont', 10000, 1),
(20521, 254, 168, 'Belmont', 10000, 1),
(20522, 254, 170, 'Belmont', 10000, 1),
(20523, 254, 169, 'Belmont', 10000, 1),
(20524, 254, 157, 'Belmore', 10000, 1),
(20525, 254, 157, 'Beloit', 10000, 1),
(20526, 254, 138, 'Belpre', 10000, 1),
(20527, 254, 160, 'Belsano', 10000, 1),
(20528, 254, 167, 'Belspring', 10000, 1),
(20529, 254, 148, 'Belt', 10000, 1),
(20530, 254, 139, 'Belton', 10000, 1),
(20531, 254, 145, 'Beltrami', 10000, 1),
(20532, 254, 142, 'Beltsville', 10000, 1),
(20533, 254, 169, 'Belva', 10000, 1),
(20534, 254, 126, 'Belvedere Tiburon', 10000, 1),
(20535, 254, 155, 'Belvidere', 10000, 1),
(20536, 254, 149, 'Belvidere', 10000, 1),
(20537, 254, 152, 'Belvidere', 10000, 1),
(20538, 254, 163, 'Belvidere', 10000, 1),
(20539, 254, 164, 'Belvidere', 10000, 1),
(20540, 254, 172, 'Belvidere Center', 10000, 1),
(20541, 254, 145, 'Belview', 10000, 1),
(20542, 254, 138, 'Belvue', 10000, 1),
(20543, 254, 135, 'Bement', 10000, 1),
(20544, 254, 154, 'Bemus Point', 10000, 1),
(20545, 254, 165, 'Ben Bolt', 10000, 1),
(20546, 254, 165, 'Ben Franklin', 10000, 1),
(20547, 254, 167, 'Ben Hur', 10000, 1),
(20548, 254, 125, 'Ben Lomond', 10000, 1),
(20549, 254, 126, 'Ben Lomond', 10000, 1),
(20550, 254, 165, 'Ben Wheeler', 10000, 1),
(20551, 254, 145, 'Bena', 10000, 1),
(20552, 254, 167, 'Bena', 10000, 1),
(20553, 254, 165, 'Benavides', 10000, 1),
(20554, 254, 165, 'Bend', 10000, 1),
(20555, 254, 147, 'Bendavis', 10000, 1),
(20556, 254, 138, 'Bendena', 10000, 1),
(20557, 254, 160, 'Bendersville', 10000, 1),
(20558, 254, 138, 'Benedict', 10000, 1),
(20559, 254, 142, 'Benedict', 10000, 1),
(20560, 254, 145, 'Benedict', 10000, 1),
(20561, 254, 156, 'Benedict', 10000, 1),
(20562, 254, 149, 'Benedict', 10000, 1),
(20563, 254, 141, 'Benedicta', 10000, 1),
(20564, 254, 170, 'Benet Lake', 10000, 1),
(20565, 254, 160, 'Benezett', 10000, 1),
(20566, 254, 168, 'Benge', 10000, 1),
(20567, 254, 139, 'Benham', 10000, 1),
(20568, 254, 149, 'Bennet', 10000, 1),
(20569, 254, 127, 'Bennett', 10000, 1),
(20570, 254, 137, 'Bennett', 10000, 1),
(20571, 254, 155, 'Bennett', 10000, 1),
(20572, 254, 136, 'Bennington', 10000, 1),
(20573, 254, 138, 'Bennington', 10000, 1),
(20574, 254, 149, 'Bennington', 10000, 1),
(20575, 254, 151, 'Bennington', 10000, 1),
(20576, 254, 158, 'Bennington', 10000, 1),
(20577, 254, 146, 'Benoit', 10000, 1),
(20578, 254, 170, 'Benoit', 10000, 1),
(20579, 254, 169, 'Bens Run', 10000, 1),
(20580, 254, 160, 'Bensalem', 10000, 1),
(20581, 254, 135, 'Benson', 10000, 1),
(20582, 254, 142, 'Benson', 10000, 1),
(20583, 254, 155, 'Benson', 10000, 1),
(20584, 254, 172, 'Benson', 10000, 1),
(20585, 254, 153, 'Bent', 10000, 1),
(20586, 254, 167, 'Bent Mountain', 10000, 1),
(20587, 254, 138, 'Bentley', 10000, 1),
(20588, 254, 140, 'Bentley', 10000, 1),
(20589, 254, 144, 'Bentley', 10000, 1),
(20590, 254, 160, 'Bentleyville', 10000, 1),
(20591, 254, 126, 'Benton', 10000, 1),
(20592, 254, 137, 'Benton', 10000, 1),
(20593, 254, 138, 'Benton', 10000, 1),
(20594, 254, 140, 'Benton', 10000, 1),
(20595, 254, 146, 'Benton', 10000, 1),
(20596, 254, 160, 'Benton', 10000, 1),
(20597, 254, 170, 'Benton', 10000, 1),
(20598, 254, 147, 'Benton City', 10000, 1),
(20599, 254, 157, 'Benton Ridge', 10000, 1),
(20600, 254, 146, 'Bentonia', 10000, 1),
(20601, 254, 136, 'Bentonville', 10000, 1),
(20602, 254, 157, 'Bentonville', 10000, 1),
(20603, 254, 167, 'Bentonville', 10000, 1),
(20604, 254, 169, 'Bentree', 10000, 1),
(20605, 254, 169, 'Benwood', 10000, 1),
(20606, 254, 144, 'Benzonia', 10000, 1),
(20607, 254, 165, 'Berclair', 10000, 1),
(20608, 254, 169, 'Berea', 10000, 1),
(20609, 254, 154, 'Bergen', 10000, 1),
(20610, 254, 147, 'Berger', 10000, 1),
(20611, 254, 165, 'Bergheim', 10000, 1),
(20612, 254, 157, 'Bergholz', 10000, 1),
(20613, 254, 144, 'Bergland', 10000, 1),
(20614, 254, 125, 'Bergman', 10000, 1),
(20615, 254, 169, 'Bergoo', 10000, 1),
(20616, 254, 167, 'Bergton', 10000, 1),
(20617, 254, 153, 'Berino', 10000, 1),
(20618, 254, 135, 'Berkeley', 10000, 1),
(20619, 254, 152, 'Berkeley Heights', 10000, 1),
(20620, 254, 157, 'Berkey', 10000, 1),
(20621, 254, 144, 'Berkley', 10000, 1),
(20622, 254, 143, 'Berkshire', 10000, 1),
(20623, 254, 154, 'Berkshire', 10000, 1),
(20624, 254, 132, 'Berlin', 10000, 1),
(20625, 254, 143, 'Berlin', 10000, 1),
(20626, 254, 142, 'Berlin', 10000, 1),
(20627, 254, 156, 'Berlin', 10000, 1),
(20628, 254, 152, 'Berlin', 10000, 1),
(20629, 254, 154, 'Berlin', 10000, 1),
(20630, 254, 157, 'Berlin', 10000, 1),
(20631, 254, 160, 'Berlin', 10000, 1),
(20632, 254, 157, 'Berlin Center', 10000, 1),
(20633, 254, 157, 'Berlin Heights', 10000, 1),
(20634, 254, 134, 'Bern', 10000, 1),
(20635, 254, 138, 'Bern', 10000, 1),
(20636, 254, 137, 'Bernard', 10000, 1),
(20637, 254, 141, 'Bernard', 10000, 1),
(20638, 254, 143, 'Bernardston', 10000, 1),
(20639, 254, 152, 'Bernardsville', 10000, 1),
(20640, 254, 136, 'Berne', 10000, 1),
(20641, 254, 154, 'Berne', 10000, 1),
(20642, 254, 154, 'Bernhards Bay', 10000, 1),
(20643, 254, 140, 'Bernice', 10000, 1),
(20644, 254, 122, 'Berry', 10000, 1),
(20645, 254, 139, 'Berry', 10000, 1),
(20646, 254, 126, 'Berry Creek', 10000, 1),
(20647, 254, 160, 'Berrysburg', 10000, 1),
(20648, 254, 138, 'Berryton', 10000, 1),
(20649, 254, 145, 'Bertha', 10000, 1),
(20650, 254, 156, 'Berthold', 10000, 1),
(20651, 254, 127, 'Berthoud', 10000, 1),
(20652, 254, 165, 'Bertram', 10000, 1),
(20653, 254, 147, 'Bertrand', 10000, 1),
(20654, 254, 149, 'Bertrand', 10000, 1),
(20655, 254, 137, 'Berwick', 10000, 1),
(20656, 254, 135, 'Berwick', 10000, 1),
(20657, 254, 140, 'Berwick', 10000, 1),
(20658, 254, 141, 'Berwick', 10000, 1),
(20659, 254, 169, 'Berwind', 10000, 1),
(20660, 254, 149, 'Berwyn', 10000, 1),
(20661, 254, 160, 'Berwyn', 10000, 1),
(20662, 254, 166, 'Beryl', 10000, 1),
(20663, 254, 160, 'Bessemer', 10000, 1),
(20664, 254, 155, 'Bessemer City', 10000, 1),
(20665, 254, 158, 'Bessie', 10000, 1),
(20666, 254, 155, 'Bethania', 10000, 1),
(20667, 254, 128, 'Bethany', 10000, 1),
(20668, 254, 135, 'Bethany', 10000, 1),
(20669, 254, 139, 'Bethany', 10000, 1),
(20670, 254, 140, 'Bethany', 10000, 1),
(20671, 254, 169, 'Bethany', 10000, 1),
(20672, 254, 128, 'Bethel', 10000, 1),
(20673, 254, 129, 'Bethel', 10000, 1),
(20674, 254, 141, 'Bethel', 10000, 1),
(20675, 254, 145, 'Bethel', 10000, 1),
(20676, 254, 147, 'Bethel', 10000, 1),
(20677, 254, 155, 'Bethel', 10000, 1),
(20678, 254, 154, 'Bethel', 10000, 1),
(20679, 254, 157, 'Bethel', 10000, 1),
(20680, 254, 158, 'Bethel', 10000, 1),
(20681, 254, 172, 'Bethel', 10000, 1),
(20682, 254, 126, 'Bethel Island', 10000, 1),
(20683, 254, 164, 'Bethel Springs', 10000, 1),
(20684, 254, 139, 'Bethelridge', 10000, 1),
(20685, 254, 162, 'Bethera', 10000, 1),
(20686, 254, 157, 'Bethesda', 10000, 1),
(20687, 254, 128, 'Bethlehem', 10000, 1),
(20688, 254, 132, 'Bethlehem', 10000, 1),
(20689, 254, 136, 'Bethlehem', 10000, 1),
(20690, 254, 139, 'Bethlehem', 10000, 1),
(20691, 254, 142, 'Bethlehem', 10000, 1),
(20693, 254, 154, 'Bethpage', 10000, 1),
(20694, 254, 164, 'Bethpage', 10000, 1),
(20695, 254, 127, 'Bethune', 10000, 1),
(20696, 254, 162, 'Bethune', 10000, 1),
(20697, 254, 139, 'Betsy Layne', 10000, 1),
(20698, 254, 142, 'Betterton', 10000, 1),
(20699, 254, 157, 'Bettsville', 10000, 1),
(20700, 254, 127, 'Beulah', 10000, 1),
(20701, 254, 144, 'Beulah', 10000, 1),
(20702, 254, 147, 'Beulah', 10000, 1),
(20703, 254, 146, 'Beulah', 10000, 1),
(20704, 254, 171, 'Beulah', 10000, 1),
(20705, 254, 138, 'Beverly', 10000, 1),
(20706, 254, 139, 'Beverly', 10000, 1),
(20707, 254, 157, 'Beverly', 10000, 1),
(20708, 254, 168, 'Beverly', 10000, 1),
(20709, 254, 169, 'Beverly', 10000, 1),
(20710, 254, 136, 'Beverly Shores', 10000, 1),
(20711, 254, 147, 'Bevier', 10000, 1),
(20712, 254, 137, 'Bevington', 10000, 1),
(20713, 254, 139, 'Bevinsville', 10000, 1),
(20714, 254, 125, 'Bexar', 10000, 1),
(20715, 254, 160, 'Beyer', 10000, 1),
(20716, 254, 154, 'Bible School Park', 10000, 1),
(20717, 254, 168, 'Bickleton', 10000, 1),
(20718, 254, 169, 'Bickmore', 10000, 1),
(20719, 254, 141, 'Biddeford Pool', 10000, 1),
(20720, 254, 148, 'Biddle', 10000, 1),
(20721, 254, 157, 'Bidwell', 10000, 1),
(20722, 254, 126, 'Bieber', 10000, 1),
(20723, 254, 140, 'Bienville', 10000, 1),
(20724, 254, 148, 'Big Arm', 10000, 1),
(20725, 254, 126, 'Big Bar', 10000, 1),
(20726, 254, 144, 'Big Bay', 10000, 1),
(20727, 254, 126, 'Big Bear Lake', 10000, 1),
(20728, 254, 126, 'Big Bend', 10000, 1),
(20729, 254, 169, 'Big Bend', 10000, 1),
(20730, 254, 165, 'Big Bend National Park', 10000, 1),
(20731, 254, 139, 'Big Clifty', 10000, 1),
(20732, 254, 160, 'Big Cove Tannery', 10000, 1),
(20733, 254, 126, 'Big Creek', 10000, 1),
(20734, 254, 139, 'Big Creek', 10000, 1),
(20735, 254, 146, 'Big Creek', 10000, 1),
(20736, 254, 169, 'Big Creek', 10000, 1),
(20737, 254, 145, 'Big Falls', 10000, 1),
(20738, 254, 170, 'Big Falls', 10000, 1),
(20739, 254, 125, 'Big Flat', 10000, 1),
(20740, 254, 154, 'Big Flats', 10000, 1),
(20741, 254, 171, 'Big Horn', 10000, 1),
(20742, 254, 154, 'Big Indian', 10000, 1),
(20743, 254, 167, 'Big Island', 10000, 1),
(20744, 254, 123, 'Big Lake', 10000, 1),
(20745, 254, 139, 'Big Laurel', 10000, 1),
(20746, 254, 126, 'Big Oak Flat', 10000, 1),
(20747, 254, 126, 'Big Pine', 10000, 1),
(20748, 254, 131, 'Big Pine Key', 10000, 1),
(20749, 254, 142, 'Big Pool', 10000, 1),
(20750, 254, 157, 'Big Prairie', 10000, 1),
(20751, 254, 135, 'Big Rock', 10000, 1),
(20752, 254, 164, 'Big Rock', 10000, 1),
(20753, 254, 167, 'Big Rock', 10000, 1),
(20754, 254, 160, 'Big Run', 10000, 1),
(20755, 254, 169, 'Big Run', 10000, 1),
(20756, 254, 148, 'Big Sandy', 10000, 1),
(20757, 254, 164, 'Big Sandy', 10000, 1),
(20758, 254, 165, 'Big Sandy', 10000, 1),
(20759, 254, 169, 'Big Sandy', 10000, 1),
(20760, 254, 148, 'Big Sky', 10000, 1),
(20761, 254, 149, 'Big Springs', 10000, 1),
(20762, 254, 169, 'Big Springs', 10000, 1),
(20763, 254, 163, 'Big Stone City', 10000, 1),
(20764, 254, 167, 'Big Stone Gap', 10000, 1),
(20765, 254, 165, 'Big Wells', 10000, 1),
(20766, 254, 125, 'Bigelow', 10000, 1),
(20767, 254, 145, 'Bigelow', 10000, 1),
(20768, 254, 165, 'Bigfoot', 10000, 1),
(20769, 254, 145, 'Bigfork', 10000, 1),
(20770, 254, 148, 'Bigfork', 10000, 1),
(20771, 254, 125, 'Biggers', 10000, 1),
(20772, 254, 135, 'Biggsville', 10000, 1),
(20773, 254, 139, 'Bighill', 10000, 1),
(20774, 254, 148, 'Bighorn', 10000, 1),
(20775, 254, 160, 'Bigler', 10000, 1),
(20776, 254, 160, 'Biglerville', 10000, 1),
(20777, 254, 171, 'Bill', 10000, 1),
(20778, 254, 147, 'Billings', 10000, 1),
(20779, 254, 154, 'Billings', 10000, 1),
(20780, 254, 158, 'Billings', 10000, 1),
(20781, 254, 122, 'Billingsley', 10000, 1),
(20782, 254, 169, 'Bim', 10000, 1),
(20783, 254, 139, 'Bimble', 10000, 1),
(20784, 254, 156, 'Binford', 10000, 1),
(20785, 254, 168, 'Bingen', 10000, 1),
(20786, 254, 158, 'Binger', 10000, 1),
(20787, 254, 135, 'Bingham', 10000, 1),
(20788, 254, 141, 'Bingham', 10000, 1),
(20789, 254, 149, 'Bingham', 10000, 1),
(20790, 254, 166, 'Bingham Canyon', 10000, 1),
(20791, 254, 145, 'Bingham Lake', 10000, 1),
(20792, 254, 126, 'Biola', 10000, 1),
(20793, 254, 136, 'Bippus', 10000, 1),
(20794, 254, 141, 'Birch Harbor', 10000, 1),
(20795, 254, 169, 'Birch River', 10000, 1),
(20796, 254, 144, 'Birch Run', 10000, 1),
(20797, 254, 147, 'Birch Tree', 10000, 1),
(20798, 254, 145, 'Birchdale', 10000, 1),
(20799, 254, 167, 'Birchleaf', 10000, 1),
(20800, 254, 160, 'Birchrunville', 10000, 1),
(20801, 254, 164, 'Birchwood', 10000, 1),
(20802, 254, 170, 'Birchwood', 10000, 1),
(20803, 254, 138, 'Bird City', 10000, 1),
(20804, 254, 160, 'Bird in Hand', 10000, 1),
(20805, 254, 145, 'Bird Island', 10000, 1),
(20806, 254, 125, 'Birdeye', 10000, 1),
(20807, 254, 135, 'Birds', 10000, 1),
(20808, 254, 126, 'Birds Landing', 10000, 1),
(20809, 254, 160, 'Birdsboro', 10000, 1),
(20810, 254, 136, 'Birdseye', 10000, 1),
(20811, 254, 167, 'Birdsnest', 10000, 1),
(20813, 254, 137, 'Birmingham', 10000, 1),
(20814, 254, 152, 'Birmingham', 10000, 1),
(20815, 254, 157, 'Birmingham', 10000, 1),
(20816, 254, 170, 'Birnamwood', 10000, 1),
(20817, 254, 148, 'Birney', 10000, 1),
(20818, 254, 156, 'Bisbee', 10000, 1),
(20819, 254, 125, 'Biscoe', 10000, 1),
(20820, 254, 155, 'Biscoe', 10000, 1),
(20821, 254, 132, 'Bishop', 10000, 1),
(20822, 254, 165, 'Bishop', 10000, 1),
(20823, 254, 167, 'Bishop', 10000, 1),
(20824, 254, 135, 'Bishop Hill', 10000, 1),
(20825, 254, 142, 'Bishopville', 10000, 1),
(20826, 254, 125, 'Bismarck', 10000, 1),
(20827, 254, 135, 'Bismarck', 10000, 1),
(20828, 254, 147, 'Bismarck', 10000, 1),
(20829, 254, 138, 'Bison', 10000, 1),
(20830, 254, 158, 'Bison', 10000, 1),
(20831, 254, 144, 'Bitely', 10000, 1),
(20832, 254, 142, 'Bittinger', 10000, 1),
(20833, 254, 142, 'Bivalve', 10000, 1),
(20834, 254, 165, 'Bivins', 10000, 1),
(20835, 254, 147, 'Bixby', 10000, 1),
(20836, 254, 159, 'Blachly', 10000, 1),
(20837, 254, 122, 'Black', 10000, 1),
(20838, 254, 147, 'Black', 10000, 1),
(20839, 254, 155, 'Black Creek', 10000, 1),
(20840, 254, 154, 'Black Creek', 10000, 1),
(20841, 254, 170, 'Black Creek', 10000, 1),
(20842, 254, 168, 'Black Diamond', 10000, 1),
(20843, 254, 148, 'Black Eagle', 10000, 1),
(20844, 254, 127, 'Black Hawk', 10000, 1),
(20845, 254, 163, 'Black Hawk', 10000, 1),
(20846, 254, 160, 'Black Lick', 10000, 1),
(20847, 254, 125, 'Black Oak', 10000, 1),
(20848, 254, 144, 'Black River', 10000, 1),
(20849, 254, 154, 'Black River', 10000, 1),
(20850, 254, 125, 'Black Rock', 10000, 1),
(20851, 254, 147, 'Blackburn', 10000, 1),
(20852, 254, 145, 'Blackduck', 10000, 1),
(20853, 254, 139, 'Blackey', 10000, 1),
(20854, 254, 139, 'Blackford', 10000, 1),
(20855, 254, 157, 'Blacklick', 10000, 1),
(20856, 254, 162, 'Blacksburg', 10000, 1),
(20857, 254, 162, 'Blackstock', 10000, 1),
(20858, 254, 135, 'Blackstone', 10000, 1),
(20859, 254, 143, 'Blackstone', 10000, 1),
(20860, 254, 167, 'Blackstone', 10000, 1),
(20861, 254, 169, 'Blacksville', 10000, 1),
(20862, 254, 162, 'Blackville', 10000, 1),
(20863, 254, 147, 'Blackwater', 10000, 1),
(20864, 254, 167, 'Blackwater', 10000, 1),
(20865, 254, 147, 'Blackwell', 10000, 1),
(20866, 254, 165, 'Blackwell', 10000, 1),
(20867, 254, 149, 'Bladen', 10000, 1),
(20868, 254, 155, 'Bladenboro', 10000, 1),
(20869, 254, 142, 'Bladensburg', 10000, 1),
(20870, 254, 157, 'Bladensburg', 10000, 1),
(20871, 254, 160, 'Blain', 10000, 1),
(20872, 254, 139, 'Blaine', 10000, 1),
(20873, 254, 141, 'Blaine', 10000, 1),
(20874, 254, 157, 'Blaine', 10000, 1),
(20875, 254, 164, 'Blaine', 10000, 1),
(20876, 254, 158, 'Blair', 10000, 1),
(20877, 254, 162, 'Blair', 10000, 1),
(20878, 254, 170, 'Blair', 10000, 1),
(20879, 254, 169, 'Blair', 10000, 1),
(20880, 254, 167, 'Blairs', 10000, 1),
(20881, 254, 160, 'Blairs Mills', 10000, 1),
(20882, 254, 137, 'Blairsburg', 10000, 1),
(20883, 254, 126, 'Blairsden-Graeagle', 10000, 1),
(20884, 254, 137, 'Blairstown', 10000, 1),
(20885, 254, 147, 'Blairstown', 10000, 1),
(20886, 254, 152, 'Blairstown', 10000, 1),
(20887, 254, 168, 'Blakely Island', 10000, 1),
(20888, 254, 137, 'Blakesburg', 10000, 1),
(20889, 254, 157, 'Blakeslee', 10000, 1),
(20890, 254, 160, 'Blakeslee', 10000, 1),
(20891, 254, 127, 'Blanca', 10000, 1),
(20892, 254, 155, 'Blanch', 10000, 1),
(20893, 254, 137, 'Blanchard', 10000, 1),
(20894, 254, 134, 'Blanchard', 10000, 1),
(20895, 254, 140, 'Blanchard', 10000, 1),
(20896, 254, 144, 'Blanchard', 10000, 1),
(20897, 254, 156, 'Blanchard', 10000, 1),
(20898, 254, 160, 'Blanchard', 10000, 1),
(20899, 254, 170, 'Blanchardville', 10000, 1),
(20900, 254, 157, 'Blanchester', 10000, 1),
(20901, 254, 153, 'Blanco', 10000, 1),
(20902, 254, 158, 'Blanco', 10000, 1),
(20903, 254, 147, 'Bland', 10000, 1),
(20904, 254, 160, 'Blandburg', 10000, 1),
(20905, 254, 143, 'Blandford', 10000, 1),
(20906, 254, 135, 'Blandinsville', 10000, 1),
(20907, 254, 160, 'Blandon', 10000, 1),
(20908, 254, 169, 'Blandville', 10000, 1),
(20909, 254, 136, 'Blanford', 10000, 1),
(20910, 254, 165, 'Blanket', 10000, 1),
(20911, 254, 140, 'Blanks', 10000, 1),
(20912, 254, 152, 'Blawenburg', 10000, 1),
(20913, 254, 139, 'Bledsoe', 10000, 1),
(20914, 254, 165, 'Bledsoe', 10000, 1),
(20915, 254, 165, 'Bleiblerville', 10000, 1),
(20916, 254, 137, 'Blencoe', 10000, 1),
(20917, 254, 162, 'Blenheim', 10000, 1),
(20918, 254, 170, 'Blenker', 10000, 1),
(20919, 254, 125, 'Blevins', 10000, 1),
(20920, 254, 134, 'Bliss', 10000, 1),
(20921, 254, 154, 'Bliss', 10000, 1),
(20922, 254, 157, 'Blissfield', 10000, 1),
(20923, 254, 158, 'Blocker', 10000, 1),
(20924, 254, 126, 'Blocksburg', 10000, 1),
(20925, 254, 137, 'Blockton', 10000, 1),
(20926, 254, 147, 'Blodgett', 10000, 1),
(20927, 254, 159, 'Blodgett', 10000, 1),
(20928, 254, 154, 'Blodgett Mills', 10000, 1),
(20929, 254, 145, 'Blomkest', 10000, 1),
(20930, 254, 165, 'Bloomburg', 10000, 1),
(20931, 254, 157, 'Bloomdale', 10000, 1),
(20932, 254, 169, 'Bloomery', 10000, 1),
(20933, 254, 128, 'Bloomfield', 10000, 1),
(20934, 254, 139, 'Bloomfield', 10000, 1),
(20935, 254, 147, 'Bloomfield', 10000, 1),
(20936, 254, 148, 'Bloomfield', 10000, 1),
(20937, 254, 153, 'Bloomfield', 10000, 1),
(20938, 254, 154, 'Bloomfield', 10000, 1),
(20939, 254, 160, 'Blooming Glen', 10000, 1),
(20940, 254, 154, 'Blooming Grove', 10000, 1),
(20941, 254, 165, 'Blooming Grove', 10000, 1),
(20942, 254, 145, 'Blooming Prairie', 10000, 1),
(20943, 254, 157, 'Bloomingburg', 10000, 1),
(20944, 254, 132, 'Bloomingdale', 10000, 1),
(20945, 254, 135, 'Bloomingdale', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(20946, 254, 136, 'Bloomingdale', 10000, 1),
(20947, 254, 144, 'Bloomingdale', 10000, 1),
(20948, 254, 154, 'Bloomingdale', 10000, 1),
(20949, 254, 157, 'Bloomingdale', 10000, 1),
(20950, 254, 169, 'Bloomingrose', 10000, 1),
(20951, 254, 126, 'Bloomington', 10000, 1),
(20952, 254, 134, 'Bloomington', 10000, 1),
(20953, 254, 142, 'Bloomington', 10000, 1),
(20954, 254, 149, 'Bloomington', 10000, 1),
(20955, 254, 154, 'Bloomington', 10000, 1),
(20956, 254, 165, 'Bloomington', 10000, 1),
(20957, 254, 170, 'Bloomington', 10000, 1),
(20958, 254, 164, 'Bloomington Springs', 10000, 1),
(20959, 254, 152, 'Bloomsbury', 10000, 1),
(20960, 254, 147, 'Bloomsdale', 10000, 1),
(20961, 254, 154, 'Bloomville', 10000, 1),
(20962, 254, 157, 'Bloomville', 10000, 1),
(20963, 254, 160, 'Blossburg', 10000, 1),
(20964, 254, 165, 'Blossom', 10000, 1),
(20965, 254, 154, 'Blossvale', 10000, 1),
(20966, 254, 169, 'Blount', 10000, 1),
(20967, 254, 122, 'Blountsville', 10000, 1),
(20968, 254, 155, 'Blowing Rock', 10000, 1),
(20969, 254, 167, 'Bloxom', 10000, 1),
(20970, 254, 124, 'Blue', 10000, 1),
(20971, 254, 160, 'Blue Ball', 10000, 1),
(20972, 254, 160, 'Blue Bell', 10000, 1),
(20973, 254, 157, 'Blue Creek', 10000, 1),
(20974, 254, 169, 'Blue Creek', 10000, 1),
(20975, 254, 150, 'Blue Diamond', 10000, 1),
(20976, 254, 147, 'Blue Eye', 10000, 1),
(20977, 254, 124, 'Blue Gap', 10000, 1),
(20978, 254, 167, 'Blue Grass', 10000, 1),
(20979, 254, 141, 'Blue Hill', 10000, 1),
(20980, 254, 149, 'Blue Hill', 10000, 1),
(20981, 254, 141, 'Blue Hill Falls', 10000, 1),
(20982, 254, 126, 'Blue Jay', 10000, 1),
(20983, 254, 169, 'Blue Jay', 10000, 1),
(20984, 254, 126, 'Blue Lake', 10000, 1),
(20985, 254, 135, 'Blue Mound', 10000, 1),
(20986, 254, 138, 'Blue Mound', 10000, 1),
(20987, 254, 170, 'Blue Mounds', 10000, 1),
(20988, 254, 125, 'Blue Mountain', 10000, 1),
(20989, 254, 146, 'Blue Mountain', 10000, 1),
(20990, 254, 154, 'Blue Mountain Lake', 10000, 1),
(20991, 254, 154, 'Blue Point', 10000, 1),
(20992, 254, 167, 'Blue Ridge', 10000, 1),
(20993, 254, 160, 'Blue Ridge Summit', 10000, 1),
(20994, 254, 139, 'Blue River', 10000, 1),
(20995, 254, 159, 'Blue River', 10000, 1),
(20996, 254, 170, 'Blue River', 10000, 1),
(20997, 254, 157, 'Blue Rock', 10000, 1),
(20998, 254, 146, 'Blue Springs', 10000, 1),
(20999, 254, 149, 'Blue Springs', 10000, 1),
(21000, 254, 166, 'Bluebell', 10000, 1),
(21001, 254, 167, 'Bluefield', 10000, 1),
(21002, 254, 165, 'Bluegrove', 10000, 1),
(21003, 254, 158, 'Bluejacket', 10000, 1),
(21004, 254, 167, 'Bluemont', 10000, 1),
(21005, 254, 153, 'Bluewater', 10000, 1),
(21006, 254, 166, 'Bluff', 10000, 1),
(21007, 254, 125, 'Bluff City', 10000, 1),
(21008, 254, 138, 'Bluff City', 10000, 1),
(21009, 254, 164, 'Bluff City', 10000, 1),
(21010, 254, 165, 'Bluff Dale', 10000, 1),
(21011, 254, 135, 'Bluff Springs', 10000, 1),
(21012, 254, 135, 'Bluffs', 10000, 1),
(21013, 254, 125, 'Bluffton', 10000, 1),
(21014, 254, 132, 'Bluffton', 10000, 1),
(21015, 254, 145, 'Bluffton', 10000, 1),
(21016, 254, 162, 'Bluffton', 10000, 1),
(21017, 254, 135, 'Bluford', 10000, 1),
(21018, 254, 165, 'Blum', 10000, 1),
(21019, 254, 163, 'Blunt', 10000, 1),
(21020, 254, 159, 'Bly', 10000, 1),
(21021, 254, 132, 'Blythe', 10000, 1),
(21022, 254, 147, 'Blythedale', 10000, 1),
(21023, 254, 162, 'Blythewood', 10000, 1),
(21024, 254, 160, 'Boalsburg', 10000, 1),
(21025, 254, 125, 'Board Camp', 10000, 1),
(21026, 254, 139, 'Boaz', 10000, 1),
(21027, 254, 169, 'Bob White', 10000, 1),
(21028, 254, 160, 'Bobtown', 10000, 1),
(21029, 254, 131, 'Boca Grande', 10000, 1),
(21030, 254, 145, 'Bock', 10000, 1),
(21031, 254, 137, 'Bode', 10000, 1),
(21032, 254, 126, 'Bodega', 10000, 1),
(21033, 254, 126, 'Bodfish', 10000, 1),
(21034, 254, 160, 'Bodines', 10000, 1),
(21035, 254, 149, 'Boelus', 10000, 1),
(21037, 254, 147, 'Bogard', 10000, 1),
(21038, 254, 132, 'Bogart', 10000, 1),
(21039, 254, 165, 'Bogata', 10000, 1),
(21040, 254, 136, 'Boggstown', 10000, 1),
(21041, 254, 152, 'Bogota', 10000, 1),
(21042, 254, 164, 'Bogota', 10000, 1),
(21043, 254, 146, 'Bogue Chitto', 10000, 1),
(21044, 254, 167, 'Bohannon', 10000, 1),
(21045, 254, 154, 'Boiceville', 10000, 1),
(21046, 254, 160, 'Boiling Springs', 10000, 1),
(21047, 254, 147, 'Bois D Arc', 10000, 1),
(21048, 254, 167, 'Boissevain', 10000, 1),
(21049, 254, 158, 'Bokchito', 10000, 1),
(21050, 254, 131, 'Bokeelia', 10000, 1),
(21051, 254, 147, 'Bolckow', 10000, 1),
(21052, 254, 125, 'Boles', 10000, 1),
(21053, 254, 135, 'Boles', 10000, 1),
(21054, 254, 158, 'Boley', 10000, 1),
(21055, 254, 122, 'Boligee', 10000, 1),
(21056, 254, 126, 'Bolinas', 10000, 1),
(21057, 254, 165, 'Boling', 10000, 1),
(21058, 254, 132, 'Bolingbroke', 10000, 1),
(21059, 254, 154, 'Bolivar', 10000, 1),
(21060, 254, 157, 'Bolivar', 10000, 1),
(21061, 254, 160, 'Bolivar', 10000, 1),
(21062, 254, 155, 'Bolivia', 10000, 1),
(21063, 254, 169, 'Bolt', 10000, 1),
(21064, 254, 128, 'Bolton', 10000, 1),
(21065, 254, 143, 'Bolton', 10000, 1),
(21066, 254, 146, 'Bolton', 10000, 1),
(21067, 254, 155, 'Bolton', 10000, 1),
(21068, 254, 154, 'Bolton Landing', 10000, 1),
(21069, 254, 154, 'Bombay', 10000, 1),
(21070, 254, 169, 'Bomont', 10000, 1),
(21071, 254, 172, 'Bomoseen', 10000, 1),
(21072, 254, 122, 'Bon Air', 10000, 1),
(21073, 254, 164, 'Bon Aqua', 10000, 1),
(21074, 254, 122, 'Bon Secour', 10000, 1),
(21075, 254, 165, 'Bon Wier', 10000, 1),
(21076, 254, 159, 'Bonanza', 10000, 1),
(21077, 254, 166, 'Bonanza', 10000, 1),
(21078, 254, 137, 'Bonaparte', 10000, 1),
(21079, 254, 127, 'Boncarbo', 10000, 1),
(21080, 254, 127, 'Bond', 10000, 1),
(21081, 254, 143, 'Bondsville', 10000, 1),
(21082, 254, 170, 'Bonduel', 10000, 1),
(21083, 254, 137, 'Bondurant', 10000, 1),
(21084, 254, 171, 'Bondurant', 10000, 1),
(21085, 254, 135, 'Bondville', 10000, 1),
(21086, 254, 172, 'Bondville', 10000, 1),
(21087, 254, 135, 'Bone Gap', 10000, 1),
(21088, 254, 163, 'Bonesteel', 10000, 1),
(21089, 254, 132, 'Boneville', 10000, 1),
(21090, 254, 135, 'Bonfield', 10000, 1),
(21091, 254, 140, 'Bonita', 10000, 1),
(21092, 254, 155, 'Bonlee', 10000, 1),
(21093, 254, 162, 'Bonneau', 10000, 1),
(21094, 254, 148, 'Bonner', 10000, 1),
(21095, 254, 125, 'Bonnerdale', 10000, 1),
(21096, 254, 134, 'Bonners Ferry', 10000, 1),
(21097, 254, 135, 'Bonnie', 10000, 1),
(21098, 254, 139, 'Bonnieville', 10000, 1),
(21099, 254, 147, 'Bonnots Mill', 10000, 1),
(21100, 254, 139, 'Bonnyman', 10000, 1),
(21101, 254, 125, 'Bono', 10000, 1),
(21102, 254, 135, 'Boody', 10000, 1),
(21103, 254, 165, 'Booker', 10000, 1),
(21104, 254, 155, 'Boomer', 10000, 1),
(21105, 254, 169, 'Boomer', 10000, 1),
(21106, 254, 144, 'Boon', 10000, 1),
(21107, 254, 127, 'Boone', 10000, 1),
(21108, 254, 136, 'Boone Grove', 10000, 1),
(21109, 254, 167, 'Boones Mill', 10000, 1),
(21110, 254, 137, 'Booneville', 10000, 1),
(21111, 254, 139, 'Boons Camp', 10000, 1),
(21112, 254, 142, 'Boonsboro', 10000, 1),
(21113, 254, 126, 'Boonville', 10000, 1),
(21114, 254, 155, 'Boonville', 10000, 1),
(21115, 254, 122, 'Booth', 10000, 1),
(21116, 254, 169, 'Booth', 10000, 1),
(21117, 254, 141, 'Boothbay Harbor', 10000, 1),
(21118, 254, 140, 'Bordelonville', 10000, 1),
(21119, 254, 136, 'Borden', 10000, 1),
(21120, 254, 169, 'Borderland', 10000, 1),
(21121, 254, 142, 'Boring', 10000, 1),
(21122, 254, 126, 'Boron', 10000, 1),
(21123, 254, 145, 'Borup', 10000, 1),
(21124, 254, 171, 'Bosler', 10000, 1),
(21125, 254, 153, 'Bosque', 10000, 1),
(21126, 254, 153, 'Bosque Farms', 10000, 1),
(21127, 254, 147, 'Boss', 10000, 1),
(21128, 254, 155, 'Bostic', 10000, 1),
(21129, 254, 132, 'Boston', 10000, 1),
(21130, 254, 136, 'Boston', 10000, 1),
(21131, 254, 139, 'Boston', 10000, 1),
(21133, 254, 154, 'Boston', 10000, 1),
(21134, 254, 167, 'Boston', 10000, 1),
(21135, 254, 131, 'Bostwick', 10000, 1),
(21136, 254, 132, 'Bostwick', 10000, 1),
(21137, 254, 125, 'Boswell', 10000, 1),
(21138, 254, 158, 'Boswell', 10000, 1),
(21139, 254, 160, 'Boswell', 10000, 1),
(21140, 254, 147, 'Bosworth', 10000, 1),
(21141, 254, 157, 'Botkins', 10000, 1),
(21142, 254, 128, 'Botsford', 10000, 1),
(21143, 254, 154, 'Bouckville', 10000, 1),
(21144, 254, 148, 'Boulder', 10000, 1),
(21145, 254, 166, 'Boulder', 10000, 1),
(21146, 254, 171, 'Boulder', 10000, 1),
(21147, 254, 150, 'Boulder City', 10000, 1),
(21148, 254, 170, 'Boulder Junction', 10000, 1),
(21149, 254, 126, 'Boulevard', 10000, 1),
(21150, 254, 136, 'Bourbon', 10000, 1),
(21151, 254, 147, 'Bourbon', 10000, 1),
(21152, 254, 140, 'Bourg', 10000, 1),
(21153, 254, 157, 'Bourneville', 10000, 1),
(21154, 254, 124, 'Bouse', 10000, 1),
(21155, 254, 137, 'Bouton', 10000, 1),
(21156, 254, 140, 'Boutte', 10000, 1),
(21157, 254, 160, 'Bovard', 10000, 1),
(21158, 254, 145, 'Bovey', 10000, 1),
(21159, 254, 134, 'Bovill', 10000, 1),
(21160, 254, 165, 'Bovina', 10000, 1),
(21161, 254, 154, 'Bovina Center', 10000, 1),
(21162, 254, 151, 'Bow', 10000, 1),
(21163, 254, 168, 'Bow', 10000, 1),
(21164, 254, 169, 'Bowden', 10000, 1),
(21165, 254, 163, 'Bowdle', 10000, 1),
(21166, 254, 141, 'Bowdoin', 10000, 1),
(21167, 254, 141, 'Bowdoinham', 10000, 1),
(21168, 254, 132, 'Bowdon', 10000, 1),
(21169, 254, 156, 'Bowdon', 10000, 1),
(21170, 254, 132, 'Bowdon Junction', 10000, 1),
(21171, 254, 135, 'Bowen', 10000, 1),
(21172, 254, 160, 'Bowers', 10000, 1),
(21173, 254, 157, 'Bowerston', 10000, 1),
(21174, 254, 157, 'Bowersville', 10000, 1),
(21175, 254, 124, 'Bowie', 10000, 1),
(21176, 254, 158, 'Bowlegs', 10000, 1),
(21177, 254, 170, 'Bowler', 10000, 1),
(21178, 254, 136, 'Bowling Green', 10000, 1),
(21179, 254, 162, 'Bowling Green', 10000, 1),
(21180, 254, 145, 'Bowlus', 10000, 1),
(21181, 254, 132, 'Bowman', 10000, 1),
(21182, 254, 162, 'Bowman', 10000, 1),
(21183, 254, 160, 'Bowmanstown', 10000, 1),
(21184, 254, 154, 'Bowmansville', 10000, 1),
(21185, 254, 160, 'Bowmansville', 10000, 1),
(21186, 254, 158, 'Bowring', 10000, 1),
(21187, 254, 145, 'Bowstring', 10000, 1),
(21188, 254, 148, 'Box Elder', 10000, 1),
(21189, 254, 163, 'Box Elder', 10000, 1),
(21190, 254, 132, 'Box Springs', 10000, 1),
(21191, 254, 143, 'Boxborough', 10000, 1),
(21192, 254, 137, 'Boxholm', 10000, 1),
(21193, 254, 140, 'Boyce', 10000, 1),
(21194, 254, 167, 'Boyce', 10000, 1),
(21195, 254, 170, 'Boyceville', 10000, 1),
(21196, 254, 145, 'Boyd', 10000, 1),
(21197, 254, 148, 'Boyd', 10000, 1),
(21198, 254, 165, 'Boyd', 10000, 1),
(21199, 254, 170, 'Boyd', 10000, 1),
(21200, 254, 137, 'Boyden', 10000, 1),
(21201, 254, 142, 'Boyds', 10000, 1),
(21202, 254, 168, 'Boyds', 10000, 1),
(21203, 254, 160, 'Boyers', 10000, 1),
(21204, 254, 148, 'Boyes', 10000, 1),
(21205, 254, 126, 'Boyes Hot Springs', 10000, 1),
(21206, 254, 122, 'Boykin', 10000, 1),
(21207, 254, 167, 'Boykins', 10000, 1),
(21208, 254, 146, 'Boyle', 10000, 1),
(21209, 254, 143, 'Boylston', 10000, 1),
(21210, 254, 144, 'Boyne City', 10000, 1),
(21211, 254, 144, 'Boyne Falls', 10000, 1),
(21212, 254, 158, 'Boynton', 10000, 1),
(21213, 254, 160, 'Boynton', 10000, 1),
(21214, 254, 165, 'Boys Ranch', 10000, 1),
(21215, 254, 149, 'Boys Town', 10000, 1),
(21216, 254, 142, 'Bozman', 10000, 1),
(21217, 254, 128, 'Bozrah', 10000, 1),
(21218, 254, 135, 'Braceville', 10000, 1),
(21219, 254, 167, 'Bracey', 10000, 1),
(21220, 254, 160, 'Brackenridge', 10000, 1),
(21221, 254, 160, 'Brackney', 10000, 1),
(21222, 254, 156, 'Braddock', 10000, 1),
(21223, 254, 160, 'Braddock', 10000, 1),
(21224, 254, 142, 'Braddock Heights', 10000, 1),
(21225, 254, 137, 'Braddyville', 10000, 1),
(21226, 254, 164, 'Braden', 10000, 1),
(21227, 254, 131, 'Bradenton Beach', 10000, 1),
(21228, 254, 160, 'Bradenville', 10000, 1),
(21229, 254, 125, 'Bradford', 10000, 1),
(21230, 254, 137, 'Bradford', 10000, 1),
(21231, 254, 135, 'Bradford', 10000, 1),
(21232, 254, 136, 'Bradford', 10000, 1),
(21233, 254, 141, 'Bradford', 10000, 1),
(21234, 254, 151, 'Bradford', 10000, 1),
(21235, 254, 154, 'Bradford', 10000, 1),
(21236, 254, 157, 'Bradford', 10000, 1),
(21237, 254, 161, 'Bradford', 10000, 1),
(21238, 254, 164, 'Bradford', 10000, 1),
(21239, 254, 172, 'Bradford', 10000, 1),
(21240, 254, 139, 'Bradfordsville', 10000, 1),
(21241, 254, 160, 'Bradfordwoods', 10000, 1),
(21242, 254, 137, 'Bradgate', 10000, 1),
(21243, 254, 125, 'Bradley', 10000, 1),
(21244, 254, 126, 'Bradley', 10000, 1),
(21245, 254, 131, 'Bradley', 10000, 1),
(21246, 254, 141, 'Bradley', 10000, 1),
(21247, 254, 144, 'Bradley', 10000, 1),
(21248, 254, 158, 'Bradley', 10000, 1),
(21249, 254, 162, 'Bradley', 10000, 1),
(21250, 254, 163, 'Bradley', 10000, 1),
(21251, 254, 169, 'Bradley', 10000, 1),
(21252, 254, 152, 'Bradley Beach', 10000, 1),
(21253, 254, 147, 'Bradleyville', 10000, 1),
(21254, 254, 157, 'Bradner', 10000, 1),
(21255, 254, 149, 'Bradshaw', 10000, 1),
(21256, 254, 169, 'Bradshaw', 10000, 1),
(21257, 254, 148, 'Brady', 10000, 1),
(21258, 254, 149, 'Brady', 10000, 1),
(21259, 254, 157, 'Brady Lake', 10000, 1),
(21260, 254, 164, 'Bradyville', 10000, 1),
(21261, 254, 147, 'Bragg City', 10000, 1),
(21262, 254, 147, 'Braggadocio', 10000, 1),
(21263, 254, 158, 'Braggs', 10000, 1),
(21264, 254, 145, 'Braham', 10000, 1),
(21265, 254, 135, 'Braidwood', 10000, 1),
(21266, 254, 149, 'Brainard', 10000, 1),
(21267, 254, 154, 'Brainard', 10000, 1),
(21268, 254, 154, 'Brainardsville', 10000, 1),
(21269, 254, 140, 'Braithwaite', 10000, 1),
(21270, 254, 158, 'Braman', 10000, 1),
(21271, 254, 169, 'Bramwell', 10000, 1),
(21272, 254, 125, 'Branch', 10000, 1),
(21273, 254, 140, 'Branch', 10000, 1),
(21274, 254, 144, 'Branch', 10000, 1),
(21275, 254, 170, 'Branch', 10000, 1),
(21276, 254, 160, 'Branchdale', 10000, 1),
(21277, 254, 169, 'Branchland', 10000, 1),
(21278, 254, 154, 'Branchport', 10000, 1),
(21279, 254, 160, 'Branchton', 10000, 1),
(21280, 254, 136, 'Branchville', 10000, 1),
(21281, 254, 162, 'Branchville', 10000, 1),
(21282, 254, 167, 'Branchville', 10000, 1),
(21283, 254, 160, 'Brandamore', 10000, 1),
(21284, 254, 137, 'Brandon', 10000, 1),
(21285, 254, 145, 'Brandon', 10000, 1),
(21286, 254, 163, 'Brandon', 10000, 1),
(21287, 254, 165, 'Brandon', 10000, 1),
(21288, 254, 172, 'Brandon', 10000, 1),
(21289, 254, 170, 'Brandon', 10000, 1),
(21290, 254, 147, 'Brandsville', 10000, 1),
(21291, 254, 163, 'Brandt', 10000, 1),
(21292, 254, 160, 'Brandy Camp', 10000, 1),
(21293, 254, 167, 'Brandy Station', 10000, 1),
(21294, 254, 142, 'Brandywine', 10000, 1),
(21295, 254, 169, 'Brandywine', 10000, 1),
(21296, 254, 128, 'Branford', 10000, 1),
(21297, 254, 126, 'Branscomb', 10000, 1),
(21298, 254, 127, 'Branson', 10000, 1),
(21299, 254, 144, 'Brant', 10000, 1),
(21300, 254, 154, 'Brant', 10000, 1),
(21301, 254, 154, 'Brant Lake', 10000, 1),
(21302, 254, 143, 'Brant Rock', 10000, 1),
(21303, 254, 154, 'Brantingham', 10000, 1),
(21304, 254, 122, 'Brantley', 10000, 1),
(21305, 254, 170, 'Brantwood', 10000, 1),
(21306, 254, 132, 'Braselton', 10000, 1),
(21307, 254, 147, 'Brashear', 10000, 1),
(21308, 254, 165, 'Brashear', 10000, 1),
(21309, 254, 154, 'Brasher Falls', 10000, 1),
(21310, 254, 155, 'Brasstown', 10000, 1),
(21311, 254, 160, 'Brave', 10000, 1),
(21312, 254, 146, 'Braxton', 10000, 1),
(21313, 254, 158, 'Bray', 10000, 1),
(21314, 254, 147, 'Braymer', 10000, 1),
(21315, 254, 137, 'Brayton', 10000, 1),
(21316, 254, 147, 'Brazeau', 10000, 1),
(21317, 254, 167, 'Breaks', 10000, 1),
(21318, 254, 144, 'Breckenridge', 10000, 1),
(21319, 254, 147, 'Breckenridge', 10000, 1),
(21320, 254, 157, 'Brecksville', 10000, 1),
(21321, 254, 137, 'Breda', 10000, 1),
(21322, 254, 169, 'Breeden', 10000, 1),
(21323, 254, 139, 'Breeding', 10000, 1),
(21324, 254, 144, 'Breedsville', 10000, 1),
(21325, 254, 135, 'Breese', 10000, 1),
(21326, 254, 154, 'Breesport', 10000, 1),
(21327, 254, 160, 'Breezewood', 10000, 1),
(21328, 254, 154, 'Breezy Point', 10000, 1),
(21329, 254, 160, 'Breinigsville', 10000, 1),
(21330, 254, 122, 'Bremen', 10000, 1),
(21331, 254, 132, 'Bremen', 10000, 1),
(21332, 254, 136, 'Bremen', 10000, 1),
(21333, 254, 138, 'Bremen', 10000, 1),
(21334, 254, 139, 'Bremen', 10000, 1),
(21335, 254, 141, 'Bremen', 10000, 1),
(21336, 254, 156, 'Bremen', 10000, 1),
(21337, 254, 167, 'Bremo Bluff', 10000, 1),
(21338, 254, 122, 'Brent', 10000, 1),
(21339, 254, 163, 'Brentford', 10000, 1),
(21340, 254, 169, 'Brenton', 10000, 1),
(21341, 254, 142, 'Brentwood', 10000, 1),
(21342, 254, 144, 'Brethren', 10000, 1),
(21343, 254, 151, 'Bretton Woods', 10000, 1),
(21344, 254, 169, 'Bretz', 10000, 1),
(21345, 254, 123, 'Brevig Mission', 10000, 1),
(21346, 254, 138, 'Brewster', 10000, 1),
(21347, 254, 143, 'Brewster', 10000, 1),
(21348, 254, 145, 'Brewster', 10000, 1),
(21349, 254, 168, 'Brewster', 10000, 1),
(21350, 254, 147, 'Briar', 10000, 1),
(21351, 254, 157, 'Brice', 10000, 1),
(21352, 254, 145, 'Bricelyn', 10000, 1),
(21353, 254, 164, 'Briceville', 10000, 1),
(21354, 254, 125, 'Brickeys', 10000, 1),
(21355, 254, 159, 'Bridal Veil', 10000, 1),
(21356, 254, 165, 'Bridge City', 10000, 1),
(21357, 254, 154, 'Bridgehampton', 10000, 1),
(21358, 254, 122, 'Bridgeport', 10000, 1),
(21359, 254, 135, 'Bridgeport', 10000, 1),
(21360, 254, 144, 'Bridgeport', 10000, 1),
(21361, 254, 152, 'Bridgeport', 10000, 1),
(21362, 254, 154, 'Bridgeport', 10000, 1),
(21363, 254, 157, 'Bridgeport', 10000, 1),
(21364, 254, 159, 'Bridgeport', 10000, 1),
(21365, 254, 160, 'Bridgeport', 10000, 1),
(21366, 254, 168, 'Bridgeport', 10000, 1),
(21367, 254, 148, 'Bridger', 10000, 1),
(21368, 254, 136, 'Bridgeton', 10000, 1),
(21369, 254, 147, 'Bridgeton', 10000, 1),
(21370, 254, 155, 'Bridgeton', 10000, 1),
(21371, 254, 135, 'Bridgeview', 10000, 1),
(21372, 254, 126, 'Bridgeville', 10000, 1),
(21373, 254, 129, 'Bridgeville', 10000, 1),
(21374, 254, 128, 'Bridgewater', 10000, 1),
(21375, 254, 137, 'Bridgewater', 10000, 1),
(21376, 254, 141, 'Bridgewater', 10000, 1),
(21377, 254, 144, 'Bridgewater', 10000, 1),
(21378, 254, 154, 'Bridgewater', 10000, 1),
(21379, 254, 163, 'Bridgewater', 10000, 1),
(21380, 254, 172, 'Bridgewater', 10000, 1),
(21381, 254, 172, 'Bridgewater Corners', 10000, 1),
(21382, 254, 144, 'Bridgman', 10000, 1),
(21383, 254, 141, 'Bridgton', 10000, 1),
(21384, 254, 172, 'Bridport', 10000, 1),
(21385, 254, 152, 'Brielle', 10000, 1),
(21386, 254, 154, 'Brier Hill', 10000, 1),
(21387, 254, 160, 'Brier Hill', 10000, 1),
(21388, 254, 122, 'Brierfield', 10000, 1),
(21389, 254, 152, 'Brigantine', 10000, 1),
(21390, 254, 165, 'Briggs', 10000, 1),
(21391, 254, 127, 'Briggsdale', 10000, 1),
(21392, 254, 125, 'Briggsville', 10000, 1),
(21393, 254, 170, 'Briggsville', 10000, 1),
(21394, 254, 137, 'Brighton', 10000, 1),
(21395, 254, 164, 'Brighton', 10000, 1),
(21396, 254, 154, 'Brightwaters', 10000, 1),
(21397, 254, 159, 'Brightwood', 10000, 1),
(21398, 254, 167, 'Brightwood', 10000, 1),
(21399, 254, 170, 'Brill', 10000, 1),
(21400, 254, 122, 'Brilliant', 10000, 1),
(21401, 254, 157, 'Brilliant', 10000, 1),
(21402, 254, 170, 'Brillion', 10000, 1),
(21403, 254, 135, 'Brimfield', 10000, 1),
(21404, 254, 136, 'Brimfield', 10000, 1),
(21405, 254, 143, 'Brimfield', 10000, 1),
(21406, 254, 153, 'Brimhall', 10000, 1),
(21407, 254, 144, 'Brimley', 10000, 1),
(21408, 254, 145, 'Brimson', 10000, 1),
(21409, 254, 136, 'Bringhurst', 10000, 1),
(21410, 254, 157, 'Brinkhaven', 10000, 1),
(21411, 254, 125, 'Brinkley', 10000, 1),
(21412, 254, 142, 'Brinklow', 10000, 1),
(21413, 254, 147, 'Brinktown', 10000, 1),
(21414, 254, 168, 'Brinnon', 10000, 1),
(21415, 254, 156, 'Brinsmade', 10000, 1),
(21416, 254, 132, 'Brinson', 10000, 1),
(21417, 254, 126, 'Brisbane', 10000, 1),
(21418, 254, 160, 'Brisbin', 10000, 1),
(21419, 254, 165, 'Briscoe', 10000, 1),
(21420, 254, 132, 'Bristol', 10000, 1),
(21421, 254, 135, 'Bristol', 10000, 1),
(21422, 254, 151, 'Bristol', 10000, 1),
(21423, 254, 163, 'Bristol', 10000, 1),
(21424, 254, 172, 'Bristol', 10000, 1),
(21425, 254, 170, 'Bristol', 10000, 1),
(21426, 254, 169, 'Bristol', 10000, 1),
(21427, 254, 157, 'Bristolville', 10000, 1),
(21428, 254, 137, 'Bristow', 10000, 1),
(21429, 254, 149, 'Bristow', 10000, 1),
(21430, 254, 167, 'Bristow', 10000, 1),
(21431, 254, 137, 'Britt', 10000, 1),
(21432, 254, 145, 'Britt', 10000, 1),
(21433, 254, 140, 'Brittany', 10000, 1),
(21434, 254, 147, 'Brixey', 10000, 1),
(21435, 254, 128, 'Broad Brook', 10000, 1),
(21436, 254, 167, 'Broad Run', 10000, 1),
(21437, 254, 159, 'Broadbent', 10000, 1),
(21438, 254, 165, 'Broaddus', 10000, 1),
(21439, 254, 167, 'Broadford', 10000, 1),
(21440, 254, 135, 'Broadlands', 10000, 1),
(21441, 254, 148, 'Broadview', 10000, 1),
(21442, 254, 153, 'Broadview', 10000, 1),
(21443, 254, 157, 'Broadview Heights', 10000, 1),
(21444, 254, 149, 'Broadwater', 10000, 1),
(21445, 254, 155, 'Broadway', 10000, 1),
(21446, 254, 152, 'Broadway', 10000, 1),
(21447, 254, 157, 'Broadway', 10000, 1),
(21448, 254, 167, 'Broadway', 10000, 1),
(21449, 254, 149, 'Brock', 10000, 1),
(21450, 254, 156, 'Brocket', 10000, 1),
(21451, 254, 160, 'Brockport', 10000, 1),
(21452, 254, 148, 'Brockton', 10000, 1),
(21453, 254, 160, 'Brockton', 10000, 1),
(21454, 254, 148, 'Brockway', 10000, 1),
(21455, 254, 125, 'Brockwell', 10000, 1),
(21456, 254, 135, 'Brocton', 10000, 1),
(21457, 254, 154, 'Brocton', 10000, 1),
(21458, 254, 139, 'Brodhead', 10000, 1),
(21459, 254, 170, 'Brodhead', 10000, 1),
(21460, 254, 160, 'Brodheadsville', 10000, 1),
(21461, 254, 167, 'Brodnax', 10000, 1),
(21462, 254, 159, 'Brogan', 10000, 1),
(21463, 254, 160, 'Brogue', 10000, 1),
(21464, 254, 169, 'Brohard', 10000, 1),
(21465, 254, 144, 'Brohman', 10000, 1),
(21466, 254, 170, 'Brokaw', 10000, 1),
(21468, 254, 158, 'Bromide', 10000, 1),
(21469, 254, 147, 'Bronaugh', 10000, 1),
(21470, 254, 137, 'Bronson', 10000, 1),
(21471, 254, 138, 'Bronson', 10000, 1),
(21472, 254, 165, 'Bronson', 10000, 1),
(21473, 254, 139, 'Bronston', 10000, 1),
(21474, 254, 165, 'Bronte', 10000, 1),
(21475, 254, 132, 'Bronwood', 10000, 1),
(21476, 254, 154, 'Bronxville', 10000, 1),
(21477, 254, 136, 'Brook', 10000, 1),
(21478, 254, 145, 'Brook Park', 10000, 1),
(21479, 254, 126, 'Brookdale', 10000, 1),
(21480, 254, 167, 'Brooke', 10000, 1),
(21481, 254, 165, 'Brookeland', 10000, 1),
(21482, 254, 131, 'Brooker', 10000, 1),
(21483, 254, 165, 'Brookesmith', 10000, 1),
(21484, 254, 142, 'Brookeville', 10000, 1),
(21485, 254, 128, 'Brookfield', 10000, 1),
(21486, 254, 132, 'Brookfield', 10000, 1),
(21487, 254, 143, 'Brookfield', 10000, 1),
(21488, 254, 154, 'Brookfield', 10000, 1),
(21489, 254, 172, 'Brookfield', 10000, 1),
(21490, 254, 154, 'Brookhaven', 10000, 1),
(21491, 254, 142, 'Brooklandville', 10000, 1),
(21492, 254, 132, 'Brooklet', 10000, 1),
(21493, 254, 141, 'Brooklin', 10000, 1),
(21494, 254, 143, 'Brookline', 10000, 1),
(21495, 254, 151, 'Brookline', 10000, 1),
(21496, 254, 147, 'Brookline Station', 10000, 1),
(21497, 254, 143, 'Brookline Village', 10000, 1),
(21498, 254, 122, 'Brooklyn', 10000, 1),
(21499, 254, 128, 'Brooklyn', 10000, 1),
(21500, 254, 136, 'Brooklyn', 10000, 1),
(21501, 254, 139, 'Brooklyn', 10000, 1),
(21502, 254, 142, 'Brooklyn', 10000, 1),
(21503, 254, 146, 'Brooklyn', 10000, 1),
(21504, 254, 160, 'Brooklyn', 10000, 1),
(21505, 254, 170, 'Brooklyn', 10000, 1),
(21506, 254, 167, 'Brookneal', 10000, 1),
(21507, 254, 135, 'Brookport', 10000, 1),
(21508, 254, 126, 'Brooks', 10000, 1),
(21509, 254, 132, 'Brooks', 10000, 1),
(21510, 254, 139, 'Brooks', 10000, 1),
(21511, 254, 141, 'Brooks', 10000, 1),
(21512, 254, 145, 'Brooks', 10000, 1),
(21513, 254, 122, 'Brookside', 10000, 1),
(21514, 254, 152, 'Brookside', 10000, 1),
(21515, 254, 136, 'Brookston', 10000, 1),
(21516, 254, 145, 'Brookston', 10000, 1),
(21517, 254, 165, 'Brookston', 10000, 1),
(21518, 254, 141, 'Brooksville', 10000, 1),
(21519, 254, 146, 'Brooksville', 10000, 1),
(21520, 254, 141, 'Brookton', 10000, 1),
(21521, 254, 154, 'Brooktondale', 10000, 1),
(21522, 254, 138, 'Brookville', 10000, 1),
(21523, 254, 157, 'Brookville', 10000, 1),
(21524, 254, 160, 'Brookville', 10000, 1),
(21525, 254, 122, 'Brookwood', 10000, 1),
(21526, 254, 160, 'Broomall', 10000, 1),
(21527, 254, 142, 'Broomes Island', 10000, 1),
(21529, 254, 145, 'Brooten', 10000, 1),
(21530, 254, 147, 'Broseley', 10000, 1),
(21531, 254, 159, 'Brothers', 10000, 1),
(21532, 254, 135, 'Broughton', 10000, 1),
(21533, 254, 139, 'Browder', 10000, 1),
(21534, 254, 145, 'Browerville', 10000, 1),
(21535, 254, 144, 'Brown City', 10000, 1),
(21536, 254, 138, 'Brownell', 10000, 1),
(21537, 254, 141, 'Brownfield', 10000, 1),
(21538, 254, 160, 'Brownfield', 10000, 1),
(21539, 254, 135, 'Browning', 10000, 1),
(21540, 254, 147, 'Browning', 10000, 1),
(21541, 254, 148, 'Browning', 10000, 1),
(21542, 254, 135, 'Browns', 10000, 1),
(21543, 254, 155, 'Browns Summit', 10000, 1),
(21544, 254, 145, 'Browns Valley', 10000, 1),
(21545, 254, 122, 'Brownsboro', 10000, 1),
(21546, 254, 165, 'Brownsboro', 10000, 1),
(21547, 254, 167, 'Brownsburg', 10000, 1),
(21548, 254, 145, 'Brownsdale', 10000, 1),
(21549, 254, 135, 'Brownstown', 10000, 1),
(21550, 254, 160, 'Brownstown', 10000, 1),
(21551, 254, 168, 'Brownstown', 10000, 1),
(21552, 254, 126, 'Brownsville', 10000, 1),
(21553, 254, 136, 'Brownsville', 10000, 1),
(21554, 254, 142, 'Brownsville', 10000, 1),
(21555, 254, 145, 'Brownsville', 10000, 1),
(21556, 254, 157, 'Brownsville', 10000, 1),
(21557, 254, 159, 'Brownsville', 10000, 1),
(21558, 254, 172, 'Brownsville', 10000, 1),
(21559, 254, 170, 'Brownsville', 10000, 1),
(21560, 254, 145, 'Brownton', 10000, 1),
(21561, 254, 169, 'Brownton', 10000, 1),
(21562, 254, 170, 'Browntown', 10000, 1),
(21563, 254, 141, 'Brownville', 10000, 1),
(21564, 254, 149, 'Brownville', 10000, 1),
(21565, 254, 154, 'Brownville', 10000, 1),
(21566, 254, 141, 'Brownville Junction', 10000, 1),
(21567, 254, 147, 'Brownwood', 10000, 1),
(21568, 254, 132, 'Broxton', 10000, 1),
(21569, 254, 146, 'Bruce', 10000, 1),
(21570, 254, 163, 'Bruce', 10000, 1),
(21571, 254, 170, 'Bruce', 10000, 1),
(21572, 254, 144, 'Bruce Crossing', 10000, 1),
(21573, 254, 164, 'Bruceton', 10000, 1),
(21574, 254, 169, 'Bruceton Mills', 10000, 1),
(21575, 254, 167, 'Brucetown', 10000, 1),
(21576, 254, 136, 'Bruceville', 10000, 1),
(21577, 254, 165, 'Bruceville', 10000, 1),
(21578, 254, 160, 'Bruin', 10000, 1),
(21579, 254, 149, 'Brule', 10000, 1),
(21580, 254, 170, 'Brule', 10000, 1),
(21581, 254, 147, 'Brumley', 10000, 1),
(21582, 254, 122, 'Brundidge', 10000, 1),
(21583, 254, 134, 'Bruneau', 10000, 1),
(21584, 254, 147, 'Bruner', 10000, 1),
(21585, 254, 149, 'Bruning', 10000, 1),
(21586, 254, 145, 'Bruno', 10000, 1),
(21587, 254, 149, 'Bruno', 10000, 1),
(21588, 254, 169, 'Bruno', 10000, 1),
(21589, 254, 162, 'Brunson', 10000, 1),
(21590, 254, 137, 'Brunsville', 10000, 1),
(21591, 254, 147, 'Brunswick', 10000, 1),
(21592, 254, 155, 'Brunswick', 10000, 1),
(21593, 254, 149, 'Brunswick', 10000, 1),
(21594, 254, 164, 'Brunswick', 10000, 1),
(21595, 254, 148, 'Brusett', 10000, 1),
(21596, 254, 127, 'Brush', 10000, 1),
(21597, 254, 164, 'Brush Creek', 10000, 1),
(21598, 254, 168, 'Brush Prairie', 10000, 1),
(21599, 254, 160, 'Brush Valley', 10000, 1),
(21600, 254, 154, 'Brushton', 10000, 1),
(21601, 254, 140, 'Brusly', 10000, 1),
(21602, 254, 135, 'Brussels', 10000, 1),
(21603, 254, 170, 'Brussels', 10000, 1),
(21604, 254, 144, 'Brutus', 10000, 1),
(21605, 254, 142, 'Bryans Road', 10000, 1),
(21606, 254, 122, 'Bryant', 10000, 1),
(21607, 254, 125, 'Bryant', 10000, 1),
(21608, 254, 131, 'Bryant', 10000, 1),
(21609, 254, 137, 'Bryant', 10000, 1),
(21610, 254, 135, 'Bryant', 10000, 1),
(21611, 254, 136, 'Bryant', 10000, 1),
(21612, 254, 163, 'Bryant', 10000, 1),
(21613, 254, 170, 'Bryant', 10000, 1),
(21614, 254, 141, 'Bryant Pond', 10000, 1),
(21615, 254, 142, 'Bryantown', 10000, 1),
(21616, 254, 139, 'Bryants Store', 10000, 1),
(21617, 254, 139, 'Bryantsville', 10000, 1),
(21618, 254, 143, 'Bryantville', 10000, 1),
(21619, 254, 166, 'Bryce', 10000, 1),
(21620, 254, 131, 'Bryceville', 10000, 1),
(21621, 254, 160, 'Bryn Athyn', 10000, 1),
(21622, 254, 126, 'Bryn Mawr', 10000, 1),
(21623, 254, 165, 'Bryson', 10000, 1),
(21624, 254, 156, 'Buchanan', 10000, 1),
(21625, 254, 154, 'Buchanan', 10000, 1),
(21626, 254, 164, 'Buchanan', 10000, 1),
(21627, 254, 167, 'Buchanan', 10000, 1),
(21628, 254, 165, 'Buchanan Dam', 10000, 1),
(21629, 254, 157, 'Buchtel', 10000, 1),
(21630, 254, 136, 'Buck Creek', 10000, 1),
(21631, 254, 160, 'Buck Hill Falls', 10000, 1),
(21632, 254, 146, 'Buckatunna', 10000, 1),
(21633, 254, 137, 'Buckeye', 10000, 1),
(21634, 254, 169, 'Buckeye', 10000, 1),
(21635, 254, 157, 'Buckeye Lake', 10000, 1),
(21636, 254, 142, 'Buckeystown', 10000, 1),
(21637, 254, 141, 'Buckfield', 10000, 1),
(21638, 254, 132, 'Buckhead', 10000, 1),
(21639, 254, 165, 'Buckholts', 10000, 1),
(21640, 254, 139, 'Buckhorn', 10000, 1),
(21641, 254, 153, 'Buckhorn', 10000, 1),
(21642, 254, 137, 'Buckingham', 10000, 1),
(21643, 254, 135, 'Buckingham', 10000, 1),
(21644, 254, 123, 'Buckland', 10000, 1),
(21645, 254, 143, 'Buckland', 10000, 1),
(21646, 254, 157, 'Buckland', 10000, 1),
(21647, 254, 135, 'Buckley', 10000, 1),
(21648, 254, 144, 'Buckley', 10000, 1),
(21649, 254, 168, 'Buckley', 10000, 1),
(21650, 254, 138, 'Bucklin', 10000, 1),
(21651, 254, 147, 'Bucklin', 10000, 1),
(21652, 254, 145, 'Buckman', 10000, 1),
(21653, 254, 125, 'Buckner', 10000, 1),
(21654, 254, 135, 'Buckner', 10000, 1),
(21655, 254, 139, 'Buckner', 10000, 1),
(21656, 254, 147, 'Buckner', 10000, 1),
(21657, 254, 122, 'Bucks', 10000, 1),
(21658, 254, 136, 'Buckskin', 10000, 1),
(21659, 254, 168, 'Bucoda', 10000, 1),
(21660, 254, 138, 'Bucyrus', 10000, 1),
(21661, 254, 147, 'Bucyrus', 10000, 1),
(21662, 254, 169, 'Bud', 10000, 1),
(21663, 254, 135, 'Buda', 10000, 1),
(21664, 254, 146, 'Bude', 10000, 1),
(21665, 254, 140, 'Bueche', 10000, 1),
(21666, 254, 152, 'Buena', 10000, 1),
(21667, 254, 168, 'Buena', 10000, 1),
(21668, 254, 153, 'Buena Vista', 10000, 1),
(21669, 254, 160, 'Buena Vista', 10000, 1),
(21670, 254, 164, 'Buena Vista', 10000, 1),
(21671, 254, 167, 'Buena Vista', 10000, 1),
(21672, 254, 137, 'Buffalo', 10000, 1),
(21673, 254, 135, 'Buffalo', 10000, 1),
(21674, 254, 136, 'Buffalo', 10000, 1),
(21675, 254, 138, 'Buffalo', 10000, 1),
(21676, 254, 139, 'Buffalo', 10000, 1),
(21677, 254, 148, 'Buffalo', 10000, 1),
(21678, 254, 156, 'Buffalo', 10000, 1),
(21679, 254, 157, 'Buffalo', 10000, 1),
(21680, 254, 162, 'Buffalo', 10000, 1),
(21681, 254, 165, 'Buffalo', 10000, 1),
(21682, 254, 169, 'Buffalo', 10000, 1),
(21683, 254, 137, 'Buffalo Center', 10000, 1),
(21684, 254, 127, 'Buffalo Creek', 10000, 1),
(21685, 254, 163, 'Buffalo Gap', 10000, 1),
(21686, 254, 165, 'Buffalo Gap', 10000, 1),
(21687, 254, 167, 'Buffalo Junction', 10000, 1),
(21688, 254, 145, 'Buffalo Lake', 10000, 1),
(21689, 254, 160, 'Buffalo Mills', 10000, 1),
(21690, 254, 135, 'Buffalo Prairie', 10000, 1),
(21691, 254, 163, 'Buffalo Ridge', 10000, 1),
(21692, 254, 164, 'Buffalo Valley', 10000, 1),
(21693, 254, 132, 'Buford', 10000, 1),
(21694, 254, 157, 'Buford', 10000, 1),
(21695, 254, 171, 'Buford', 10000, 1),
(21696, 254, 122, 'Buhl', 10000, 1),
(21697, 254, 145, 'Buhl', 10000, 1),
(21698, 254, 138, 'Buhler', 10000, 1),
(21699, 254, 165, 'Bula', 10000, 1),
(21700, 254, 139, 'Bulan', 10000, 1),
(21701, 254, 160, 'Bulger', 10000, 1),
(21702, 254, 165, 'Bullard', 10000, 1),
(21703, 254, 163, 'Bullhead', 10000, 1),
(21704, 254, 155, 'Bullock', 10000, 1),
(21705, 254, 154, 'Bullville', 10000, 1),
(21706, 254, 135, 'Bulpitt', 10000, 1),
(21707, 254, 167, 'Bumpass', 10000, 1),
(21708, 254, 164, 'Bumpus Mills', 10000, 1),
(21709, 254, 165, 'Buna', 10000, 1),
(21710, 254, 158, 'Bunch', 10000, 1),
(21711, 254, 135, 'Buncombe', 10000, 1),
(21712, 254, 147, 'Bunker', 10000, 1),
(21713, 254, 136, 'Bunker Hill', 10000, 1),
(21714, 254, 138, 'Bunker Hill', 10000, 1),
(21715, 254, 169, 'Bunker Hill', 10000, 1),
(21716, 254, 150, 'Bunkerville', 10000, 1),
(21717, 254, 155, 'Bunn', 10000, 1),
(21718, 254, 131, 'Bunnell', 10000, 1),
(21719, 254, 155, 'Bunnlevel', 10000, 1),
(21720, 254, 160, 'Bunola', 10000, 1),
(21721, 254, 140, 'Buras', 10000, 1),
(21722, 254, 157, 'Burbank', 10000, 1),
(21723, 254, 158, 'Burbank', 10000, 1),
(21724, 254, 163, 'Burbank', 10000, 1),
(21725, 254, 149, 'Burchard', 10000, 1),
(21726, 254, 138, 'Burden', 10000, 1),
(21727, 254, 138, 'Burdett', 10000, 1),
(21728, 254, 154, 'Burdett', 10000, 1),
(21729, 254, 125, 'Burdette', 10000, 1),
(21730, 254, 138, 'Burdick', 10000, 1),
(21731, 254, 139, 'Burdine', 10000, 1),
(21732, 254, 135, 'Bureau', 10000, 1),
(21733, 254, 147, 'Burfordville', 10000, 1),
(21734, 254, 167, 'Burgess', 10000, 1),
(21735, 254, 157, 'Burghill', 10000, 1),
(21736, 254, 139, 'Burgin', 10000, 1),
(21737, 254, 157, 'Burgoon', 10000, 1),
(21738, 254, 154, 'Burke', 10000, 1),
(21739, 254, 167, 'Burkes Garden', 10000, 1),
(21740, 254, 136, 'Burket', 10000, 1),
(21741, 254, 165, 'Burkett', 10000, 1),
(21742, 254, 157, 'Burkettsville', 10000, 1),
(21743, 254, 165, 'Burkeville', 10000, 1),
(21744, 254, 167, 'Burkeville', 10000, 1),
(21745, 254, 142, 'Burkittsville', 10000, 1),
(21746, 254, 165, 'Burleson', 10000, 1),
(21747, 254, 168, 'Burley', 10000, 1),
(21748, 254, 154, 'Burlingham', 10000, 1),
(21749, 254, 128, 'Burlington', 10000, 1),
(21750, 254, 135, 'Burlington', 10000, 1),
(21751, 254, 136, 'Burlington', 10000, 1),
(21752, 254, 139, 'Burlington', 10000, 1),
(21753, 254, 141, 'Burlington', 10000, 1),
(21754, 254, 144, 'Burlington', 10000, 1),
(21755, 254, 158, 'Burlington', 10000, 1),
(21756, 254, 160, 'Burlington', 10000, 1),
(21757, 254, 165, 'Burlington', 10000, 1),
(21758, 254, 169, 'Burlington', 10000, 1),
(21759, 254, 171, 'Burlington', 10000, 1),
(21760, 254, 154, 'Burlington Flats', 10000, 1),
(21761, 254, 147, 'Burlington Junction', 10000, 1),
(21762, 254, 164, 'Burlison', 10000, 1),
(21763, 254, 139, 'Burna', 10000, 1),
(21764, 254, 170, 'Burnett', 10000, 1),
(21765, 254, 136, 'Burnettsville', 10000, 1),
(21766, 254, 158, 'Burneyville', 10000, 1),
(21767, 254, 141, 'Burnham', 10000, 1),
(21768, 254, 160, 'Burnham', 10000, 1),
(21769, 254, 144, 'Burnips', 10000, 1),
(21770, 254, 127, 'Burns', 10000, 1),
(21771, 254, 138, 'Burns', 10000, 1),
(21772, 254, 164, 'Burns', 10000, 1),
(21773, 254, 171, 'Burns', 10000, 1),
(21774, 254, 158, 'Burns Flat', 10000, 1),
(21775, 254, 137, 'Burnside', 10000, 1),
(21776, 254, 135, 'Burnside', 10000, 1),
(21777, 254, 139, 'Burnside', 10000, 1),
(21778, 254, 140, 'Burnside', 10000, 1),
(21779, 254, 160, 'Burnside', 10000, 1),
(21780, 254, 146, 'Burnsville', 10000, 1),
(21781, 254, 169, 'Burnsville', 10000, 1),
(21782, 254, 160, 'Burnt Cabins', 10000, 1),
(21783, 254, 122, 'Burnt Corn', 10000, 1),
(21784, 254, 154, 'Burnt Hills', 10000, 1),
(21785, 254, 135, 'Burnt Prairie', 10000, 1),
(21786, 254, 126, 'Burnt Ranch', 10000, 1),
(21787, 254, 122, 'Burnwell', 10000, 1),
(21788, 254, 149, 'Burr', 10000, 1),
(21789, 254, 167, 'Burr Hill', 10000, 1),
(21790, 254, 138, 'Burr Oak', 10000, 1),
(21791, 254, 126, 'Burrel', 10000, 1),
(21792, 254, 136, 'Burrows', 10000, 1),
(21793, 254, 138, 'Burrton', 10000, 1),
(21794, 254, 126, 'Burson', 10000, 1),
(21795, 254, 137, 'Burt', 10000, 1),
(21796, 254, 154, 'Burt', 10000, 1),
(21797, 254, 144, 'Burt Lake', 10000, 1),
(21798, 254, 157, 'Burton', 10000, 1),
(21799, 254, 165, 'Burton', 10000, 1),
(21800, 254, 168, 'Burton', 10000, 1),
(21801, 254, 169, 'Burton', 10000, 1),
(21802, 254, 142, 'Burtonsville', 10000, 1),
(21803, 254, 145, 'Burtrum', 10000, 1),
(21804, 254, 148, 'Busby', 10000, 1),
(21805, 254, 139, 'Bush', 10000, 1),
(21806, 254, 140, 'Bush', 10000, 1),
(21807, 254, 160, 'Bushkill', 10000, 1),
(21808, 254, 165, 'Bushland', 10000, 1),
(21809, 254, 135, 'Bushnell', 10000, 1),
(21810, 254, 149, 'Bushnell', 10000, 1),
(21811, 254, 138, 'Bushton', 10000, 1),
(21812, 254, 142, 'Bushwood', 10000, 1),
(21813, 254, 154, 'Buskirk', 10000, 1),
(21814, 254, 137, 'Bussey', 10000, 1),
(21815, 254, 141, 'Bustins Island', 10000, 1),
(21816, 254, 139, 'Busy', 10000, 1),
(21817, 254, 135, 'Butler', 10000, 1),
(21818, 254, 139, 'Butler', 10000, 1),
(21819, 254, 142, 'Butler', 10000, 1),
(21820, 254, 157, 'Butler', 10000, 1),
(21821, 254, 158, 'Butler', 10000, 1),
(21822, 254, 164, 'Butler', 10000, 1),
(21823, 254, 170, 'Butler', 10000, 1),
(21824, 254, 156, 'Butte', 10000, 1),
(21825, 254, 126, 'Butte City', 10000, 1),
(21826, 254, 170, 'Butte des Morts', 10000, 1),
(21827, 254, 145, 'Butterfield', 10000, 1),
(21828, 254, 147, 'Butterfield', 10000, 1),
(21829, 254, 170, 'Butternut', 10000, 1),
(21830, 254, 152, 'Buttzville', 10000, 1),
(21831, 254, 156, 'Buxton', 10000, 1),
(21832, 254, 159, 'Buxton', 10000, 1),
(21833, 254, 143, 'Buzzards Bay', 10000, 1),
(21834, 254, 158, 'Byars', 10000, 1),
(21835, 254, 164, 'Bybee', 10000, 1),
(21836, 254, 127, 'Byers', 10000, 1),
(21837, 254, 138, 'Byers', 10000, 1),
(21838, 254, 165, 'Byers', 10000, 1),
(21839, 254, 157, 'Byesville', 10000, 1),
(21840, 254, 143, 'Byfield', 10000, 1),
(21841, 254, 146, 'Byhalia', 10000, 1),
(21842, 254, 124, 'Bylas', 10000, 1),
(21843, 254, 122, 'Bynum', 10000, 1),
(21844, 254, 148, 'Bynum', 10000, 1),
(21845, 254, 155, 'Bynum', 10000, 1),
(21846, 254, 165, 'Bynum', 10000, 1),
(21847, 254, 139, 'Bypro', 10000, 1),
(21848, 254, 160, 'Byrnedale', 10000, 1),
(21849, 254, 132, 'Byromville', 10000, 1),
(21850, 254, 132, 'Byron', 10000, 1),
(21851, 254, 135, 'Byron', 10000, 1),
(21852, 254, 144, 'Byron', 10000, 1),
(21853, 254, 154, 'Byron', 10000, 1),
(21854, 254, 171, 'Byron', 10000, 1),
(21855, 254, 144, 'Byron Center', 10000, 1),
(21856, 254, 153, 'Caballo', 10000, 1),
(21857, 254, 126, 'Cabazon', 10000, 1),
(21858, 254, 135, 'Cabery', 10000, 1),
(21859, 254, 169, 'Cabin Creek', 10000, 1),
(21860, 254, 142, 'Cabin John', 10000, 1),
(21861, 254, 169, 'Cabins', 10000, 1),
(21862, 254, 157, 'Cable', 10000, 1),
(21863, 254, 170, 'Cable', 10000, 1),
(21864, 254, 160, 'Cabot', 10000, 1),
(21865, 254, 172, 'Cabot', 10000, 1),
(21866, 254, 135, 'Cache', 10000, 1),
(21867, 254, 158, 'Cache', 10000, 1),
(21868, 254, 166, 'Cache Junction', 10000, 1),
(21869, 254, 165, 'Cactus', 10000, 1),
(21870, 254, 158, 'Caddo', 10000, 1),
(21871, 254, 165, 'Caddo', 10000, 1),
(21872, 254, 125, 'Caddo Gap', 10000, 1),
(21873, 254, 165, 'Caddo Mills', 10000, 1),
(21874, 254, 140, 'Cade', 10000, 1),
(21875, 254, 162, 'Cades', 10000, 1),
(21876, 254, 147, 'Cadet', 10000, 1),
(21877, 254, 160, 'Cadogan', 10000, 1),
(21878, 254, 132, 'Cadwell', 10000, 1),
(21879, 254, 154, 'Cadyville', 10000, 1),
(21880, 254, 127, 'Cahone', 10000, 1),
(21881, 254, 147, 'Cainsville', 10000, 1),
(21882, 254, 160, 'Cairnbrook', 10000, 1),
(21883, 254, 147, 'Cairo', 10000, 1),
(21884, 254, 149, 'Cairo', 10000, 1),
(21885, 254, 157, 'Cairo', 10000, 1),
(21886, 254, 169, 'Cairo', 10000, 1),
(21887, 254, 150, 'Cal Nev Ari', 10000, 1),
(21888, 254, 155, 'Calabash', 10000, 1),
(21889, 254, 172, 'Calais', 10000, 1),
(21890, 254, 137, 'Calamus', 10000, 1),
(21891, 254, 154, 'Calcium', 10000, 1),
(21892, 254, 134, 'Calder', 10000, 1),
(21893, 254, 125, 'Caldwell', 10000, 1),
(21894, 254, 138, 'Caldwell', 10000, 1),
(21895, 254, 169, 'Caldwell', 10000, 1),
(21896, 254, 125, 'Cale', 10000, 1),
(21897, 254, 135, 'Caledonia', 10000, 1),
(21898, 254, 147, 'Caledonia', 10000, 1),
(21899, 254, 146, 'Caledonia', 10000, 1),
(21900, 254, 156, 'Caledonia', 10000, 1),
(21901, 254, 154, 'Caledonia', 10000, 1),
(21902, 254, 157, 'Caledonia', 10000, 1),
(21903, 254, 170, 'Caledonia', 10000, 1),
(21904, 254, 122, 'Calera', 10000, 1),
(21905, 254, 135, 'Calhoun', 10000, 1),
(21906, 254, 140, 'Calhoun', 10000, 1),
(21907, 254, 147, 'Calhoun', 10000, 1),
(21908, 254, 164, 'Calhoun', 10000, 1),
(21909, 254, 146, 'Calhoun City', 10000, 1),
(21910, 254, 162, 'Calhoun Falls', 10000, 1),
(21911, 254, 125, 'Calico Rock', 10000, 1),
(21912, 254, 126, 'Caliente', 10000, 1),
(21913, 254, 139, 'California', 10000, 1),
(21914, 254, 126, 'California Hot Springs', 10000, 1),
(21915, 254, 125, 'Calion', 10000, 1),
(21916, 254, 126, 'Calipatria', 10000, 1),
(21917, 254, 165, 'Call', 10000, 1),
(21918, 254, 126, 'Callahan', 10000, 1),
(21919, 254, 167, 'Callands', 10000, 1),
(21920, 254, 147, 'Callao', 10000, 1),
(21921, 254, 167, 'Callao', 10000, 1),
(21922, 254, 142, 'Callaway', 10000, 1),
(21923, 254, 145, 'Callaway', 10000, 1),
(21924, 254, 149, 'Callaway', 10000, 1),
(21925, 254, 137, 'Callender', 10000, 1),
(21926, 254, 160, 'Callensburg', 10000, 1),
(21927, 254, 160, 'Callery', 10000, 1),
(21928, 254, 154, 'Callicoon', 10000, 1),
(21929, 254, 154, 'Callicoon Center', 10000, 1),
(21930, 254, 165, 'Calliham', 10000, 1),
(21931, 254, 137, 'Calmar', 10000, 1),
(21932, 254, 126, 'Calpella', 10000, 1),
(21933, 254, 126, 'Calpine', 10000, 1),
(21934, 254, 137, 'Calumet', 10000, 1),
(21935, 254, 145, 'Calumet', 10000, 1),
(21936, 254, 158, 'Calumet', 10000, 1),
(21937, 254, 160, 'Calumet', 10000, 1),
(21938, 254, 132, 'Calvary', 10000, 1),
(21939, 254, 122, 'Calvert', 10000, 1),
(21940, 254, 165, 'Calvert', 10000, 1),
(21941, 254, 139, 'Calvert City', 10000, 1),
(21942, 254, 154, 'Calverton', 10000, 1),
(21943, 254, 167, 'Calverton', 10000, 1),
(21944, 254, 139, 'Calvin', 10000, 1),
(21945, 254, 140, 'Calvin', 10000, 1),
(21946, 254, 156, 'Calvin', 10000, 1),
(21947, 254, 158, 'Calvin', 10000, 1),
(21948, 254, 160, 'Calvin', 10000, 1),
(21949, 254, 169, 'Calvin', 10000, 1),
(21950, 254, 155, 'Calypso', 10000, 1),
(21951, 254, 132, 'Camak', 10000, 1),
(21952, 254, 135, 'Camargo', 10000, 1),
(21953, 254, 158, 'Camargo', 10000, 1),
(21954, 254, 168, 'Camas', 10000, 1),
(21955, 254, 159, 'Camas Valley', 10000, 1),
(21956, 254, 160, 'Cambra', 10000, 1),
(21957, 254, 135, 'Cambria', 10000, 1),
(21958, 254, 170, 'Cambria', 10000, 1),
(21959, 254, 134, 'Cambridge', 10000, 1),
(21960, 254, 138, 'Cambridge', 10000, 1),
(21961, 254, 141, 'Cambridge', 10000, 1),
(21962, 254, 149, 'Cambridge', 10000, 1),
(21963, 254, 154, 'Cambridge', 10000, 1),
(21964, 254, 160, 'Cambridge Springs', 10000, 1),
(21965, 254, 172, 'Cambridgeport', 10000, 1),
(21966, 254, 136, 'Camby', 10000, 1),
(21967, 254, 135, 'Camden', 10000, 1),
(21968, 254, 136, 'Camden', 10000, 1),
(21969, 254, 141, 'Camden', 10000, 1),
(21970, 254, 144, 'Camden', 10000, 1),
(21971, 254, 147, 'Camden', 10000, 1),
(21972, 254, 146, 'Camden', 10000, 1),
(21973, 254, 154, 'Camden', 10000, 1),
(21974, 254, 157, 'Camden', 10000, 1),
(21975, 254, 165, 'Camden', 10000, 1),
(21976, 254, 169, 'Camden', 10000, 1),
(21977, 254, 169, 'Camden on Gauley', 10000, 1),
(21978, 254, 147, 'Camden Point', 10000, 1),
(21979, 254, 129, 'Camden Wyoming', 10000, 1),
(21980, 254, 124, 'Cameron', 10000, 1),
(21981, 254, 135, 'Cameron', 10000, 1),
(21982, 254, 148, 'Cameron', 10000, 1),
(21983, 254, 155, 'Cameron', 10000, 1),
(21984, 254, 154, 'Cameron', 10000, 1),
(21985, 254, 157, 'Cameron', 10000, 1),
(21986, 254, 158, 'Cameron', 10000, 1),
(21987, 254, 162, 'Cameron', 10000, 1),
(21988, 254, 169, 'Cameron', 10000, 1),
(21989, 254, 154, 'Cameron Mills', 10000, 1),
(21990, 254, 132, 'Camilla', 10000, 1),
(21991, 254, 154, 'Camillus', 10000, 1),
(21992, 254, 125, 'Camp', 10000, 1),
(21993, 254, 169, 'Camp Creek', 10000, 1),
(21994, 254, 163, 'Camp Crook', 10000, 1),
(21995, 254, 157, 'Camp Dennison', 10000, 1),
(21996, 254, 139, 'Camp Dix', 10000, 1),
(21997, 254, 170, 'Camp Douglas', 10000, 1),
(21998, 254, 135, 'Camp Grove', 10000, 1),
(21999, 254, 133, 'Camp H M Smith', 10000, 1),
(22000, 254, 122, 'Camp Hill', 10000, 1),
(22001, 254, 170, 'Camp Lake', 10000, 1),
(22002, 254, 126, 'Camp Meeker', 10000, 1),
(22003, 254, 126, 'Camp Nelson', 10000, 1),
(22004, 254, 135, 'Camp Point', 10000, 1),
(22005, 254, 159, 'Camp Sherman', 10000, 1),
(22006, 254, 165, 'Camp Wood', 10000, 1),
(22007, 254, 164, 'Campaign', 10000, 1),
(22008, 254, 122, 'Campbell', 10000, 1),
(22009, 254, 145, 'Campbell', 10000, 1),
(22010, 254, 147, 'Campbell', 10000, 1),
(22011, 254, 149, 'Campbell', 10000, 1),
(22012, 254, 154, 'Campbell', 10000, 1),
(22013, 254, 165, 'Campbell', 10000, 1),
(22014, 254, 154, 'Campbell Hall', 10000, 1),
(22015, 254, 135, 'Campbell Hill', 10000, 1),
(22016, 254, 136, 'Campbellsburg', 10000, 1),
(22017, 254, 139, 'Campbellsburg', 10000, 1),
(22018, 254, 170, 'Campbellsport', 10000, 1),
(22019, 254, 131, 'Campbellton', 10000, 1),
(22020, 254, 165, 'Campbellton', 10000, 1),
(22021, 254, 160, 'Campbelltown', 10000, 1),
(22022, 254, 127, 'Campo', 10000, 1),
(22023, 254, 126, 'Campo Seco', 10000, 1),
(22024, 254, 162, 'Campobello', 10000, 1),
(22025, 254, 140, 'Campti', 10000, 1),
(22026, 254, 151, 'Campton', 10000, 1),
(22027, 254, 160, 'Camptown', 10000, 1),
(22028, 254, 135, 'Campus', 10000, 1),
(22029, 254, 167, 'Cana', 10000, 1),
(22030, 254, 136, 'Canaan', 10000, 1),
(22031, 254, 141, 'Canaan', 10000, 1),
(22032, 254, 151, 'Canaan', 10000, 1),
(22033, 254, 154, 'Canaan', 10000, 1),
(22034, 254, 172, 'Canaan', 10000, 1),
(22035, 254, 139, 'Canada', 10000, 1),
(22036, 254, 160, 'Canadensis', 10000, 1),
(22037, 254, 158, 'Canadian', 10000, 1),
(22038, 254, 162, 'Canadys', 10000, 1),
(22039, 254, 154, 'Canajoharie', 10000, 1),
(22040, 254, 157, 'Canal Fulton', 10000, 1),
(22041, 254, 131, 'Canal Point', 10000, 1),
(22042, 254, 147, 'Canalou', 10000, 1),
(22043, 254, 154, 'Canaseraga', 10000, 1),
(22044, 254, 154, 'Canastota', 10000, 1),
(22045, 254, 151, 'Candia', 10000, 1),
(22046, 254, 131, 'Candler', 10000, 1),
(22047, 254, 155, 'Candor', 10000, 1),
(22048, 254, 154, 'Candor', 10000, 1),
(22049, 254, 139, 'Cane Valley', 10000, 1),
(22050, 254, 154, 'Caneadea', 10000, 1),
(22051, 254, 125, 'Canehill', 10000, 1),
(22052, 254, 138, 'Caney', 10000, 1),
(22053, 254, 158, 'Caney', 10000, 1),
(22054, 254, 154, 'Canisteo', 10000, 1),
(22055, 254, 153, 'Canjilon', 10000, 1),
(22056, 254, 139, 'Canmer', 10000, 1),
(22057, 254, 139, 'Cannel City', 10000, 1),
(22058, 254, 136, 'Cannelburg', 10000, 1),
(22059, 254, 169, 'Cannelton', 10000, 1),
(22060, 254, 139, 'Cannon', 10000, 1),
(22061, 254, 153, 'Cannon AFB', 10000, 1),
(22062, 254, 156, 'Cannon Ball', 10000, 1),
(22063, 254, 159, 'Cannon Beach', 10000, 1),
(22064, 254, 144, 'Cannonsburg', 10000, 1),
(22065, 254, 166, 'Cannonville', 10000, 1),
(22066, 254, 132, 'Canon', 10000, 1),
(22067, 254, 153, 'Canones', 10000, 1),
(22068, 254, 160, 'Canonsburg', 10000, 1),
(22069, 254, 163, 'Canova', 10000, 1),
(22070, 254, 128, 'Canterbury', 10000, 1),
(22071, 254, 151, 'Canterbury', 10000, 1),
(22072, 254, 126, 'Cantil', 10000, 1),
(22073, 254, 128, 'Canton', 10000, 1),
(22074, 254, 138, 'Canton', 10000, 1),
(22075, 254, 143, 'Canton', 10000, 1),
(22076, 254, 145, 'Canton', 10000, 1),
(22077, 254, 155, 'Canton', 10000, 1),
(22078, 254, 158, 'Canton', 10000, 1),
(22079, 254, 160, 'Canton', 10000, 1),
(22080, 254, 128, 'Canton Center', 10000, 1),
(22081, 254, 131, 'Cantonment', 10000, 1),
(22082, 254, 135, 'Cantrall', 10000, 1),
(22083, 254, 137, 'Cantril', 10000, 1),
(22084, 254, 126, 'Cantua Creek', 10000, 1),
(22085, 254, 123, 'Cantwell', 10000, 1),
(22086, 254, 158, 'Canute', 10000, 1),
(22087, 254, 165, 'Canutillo', 10000, 1),
(22088, 254, 169, 'Canvas', 10000, 1),
(22089, 254, 126, 'Canyon', 10000, 1),
(22090, 254, 145, 'Canyon', 10000, 1),
(22091, 254, 159, 'Canyon City', 10000, 1),
(22092, 254, 126, 'Canyon Country', 10000, 1),
(22093, 254, 148, 'Canyon Creek', 10000, 1),
(22094, 254, 165, 'Canyon Lake', 10000, 1),
(22095, 254, 126, 'Canyondam', 10000, 1),
(22096, 254, 159, 'Canyonville', 10000, 1),
(22097, 254, 144, 'Capac', 10000, 1),
(22098, 254, 126, 'Capay', 10000, 1),
(22099, 254, 167, 'Cape Charles', 10000, 1),
(22100, 254, 141, 'Cape Elizabeth', 10000, 1),
(22101, 254, 147, 'Cape Fair', 10000, 1),
(22102, 254, 152, 'Cape May Court House', 10000, 1),
(22103, 254, 152, 'Cape May Point', 10000, 1),
(22104, 254, 141, 'Cape Neddick', 10000, 1),
(22105, 254, 141, 'Cape Porpoise', 10000, 1),
(22106, 254, 169, 'Capels', 10000, 1),
(22107, 254, 167, 'Capeville', 10000, 1),
(22108, 254, 126, 'Capistrano Beach', 10000, 1),
(22109, 254, 153, 'Capitan', 10000, 1),
(22110, 254, 148, 'Capitol', 10000, 1),
(22111, 254, 142, 'Capitol Heights', 10000, 1),
(22112, 254, 147, 'Caplinger Mills', 10000, 1),
(22113, 254, 169, 'Capon Bridge', 10000, 1),
(22114, 254, 169, 'Capon Springs', 10000, 1),
(22115, 254, 153, 'Caprock', 10000, 1),
(22116, 254, 167, 'Capron', 10000, 1),
(22117, 254, 122, 'Capshaw', 10000, 1),
(22118, 254, 131, 'Captiva', 10000, 1),
(22119, 254, 127, 'Capulin', 10000, 1),
(22120, 254, 153, 'Capulin', 10000, 1),
(22121, 254, 163, 'Caputa', 10000, 1),
(22122, 254, 141, 'Caratunk', 10000, 1),
(22123, 254, 125, 'Caraway', 10000, 1),
(22124, 254, 137, 'Carbon', 10000, 1),
(22125, 254, 165, 'Carbon', 10000, 1),
(22126, 254, 135, 'Carbon Cliff', 10000, 1),
(22127, 254, 122, 'Carbon Hill', 10000, 1),
(22128, 254, 157, 'Carbon Hill', 10000, 1),
(22129, 254, 168, 'Carbonado', 10000, 1),
(22130, 254, 138, 'Carbondale', 10000, 1),
(22131, 254, 157, 'Carbondale', 10000, 1),
(22132, 254, 160, 'Carbondale', 10000, 1),
(22133, 254, 160, 'Cardale', 10000, 1),
(22134, 254, 122, 'Cardiff', 10000, 1),
(22135, 254, 158, 'Cardin', 10000, 1),
(22136, 254, 167, 'Cardinal', 10000, 1),
(22137, 254, 147, 'Cardwell', 10000, 1),
(22138, 254, 148, 'Cardwell', 10000, 1),
(22139, 254, 167, 'Caret', 10000, 1),
(22140, 254, 169, 'Caretta', 10000, 1),
(22141, 254, 134, 'Carey', 10000, 1),
(22142, 254, 157, 'Carey', 10000, 1),
(22143, 254, 165, 'Carey', 10000, 1),
(22144, 254, 134, 'Careywood', 10000, 1),
(22145, 254, 147, 'Carl Junction', 10000, 1),
(22146, 254, 154, 'Carle Place', 10000, 1),
(22147, 254, 149, 'Carleton', 10000, 1),
(22148, 254, 171, 'Carlile', 10000, 1),
(22149, 254, 150, 'Carlin', 10000, 1),
(22150, 254, 125, 'Carlisle', 10000, 1),
(22151, 254, 137, 'Carlisle', 10000, 1),
(22152, 254, 136, 'Carlisle', 10000, 1),
(22153, 254, 140, 'Carlisle', 10000, 1),
(22154, 254, 143, 'Carlisle', 10000, 1),
(22155, 254, 154, 'Carlisle', 10000, 1),
(22156, 254, 162, 'Carlisle', 10000, 1),
(22157, 254, 135, 'Carlock', 10000, 1),
(22158, 254, 145, 'Carlos', 10000, 1),
(22159, 254, 126, 'Carlotta', 10000, 1),
(22160, 254, 165, 'Carlsbad', 10000, 1),
(22161, 254, 168, 'Carlsborg', 10000, 1),
(22162, 254, 152, 'Carlstadt', 10000, 1),
(22163, 254, 122, 'Carlton', 10000, 1),
(22164, 254, 132, 'Carlton', 10000, 1),
(22165, 254, 145, 'Carlton', 10000, 1),
(22166, 254, 160, 'Carlton', 10000, 1),
(22167, 254, 168, 'Carlton', 10000, 1),
(22168, 254, 135, 'Carman', 10000, 1),
(22169, 254, 141, 'Carmel', 10000, 1),
(22170, 254, 126, 'Carmel Valley', 10000, 1),
(22171, 254, 134, 'Carmen', 10000, 1),
(22172, 254, 158, 'Carmen', 10000, 1),
(22173, 254, 160, 'Carmichaels', 10000, 1),
(22174, 254, 165, 'Carmine', 10000, 1),
(22175, 254, 168, 'Carnation', 10000, 1),
(22176, 254, 126, 'Carnelian Bay', 10000, 1),
(22177, 254, 144, 'Carney', 10000, 1),
(22178, 254, 158, 'Carney', 10000, 1),
(22179, 254, 154, 'Caroga Lake', 10000, 1),
(22180, 254, 155, 'Caroleen', 10000, 1),
(22181, 254, 161, 'Carolina', 10000, 1),
(22182, 254, 169, 'Carolina', 10000, 1),
(22183, 254, 155, 'Carolina Beach', 10000, 1),
(22184, 254, 170, 'Caroline', 10000, 1),
(22185, 254, 144, 'Carp Lake', 10000, 1),
(22186, 254, 137, 'Carpenter', 10000, 1),
(22187, 254, 163, 'Carpenter', 10000, 1),
(22188, 254, 171, 'Carpenter', 10000, 1),
(22189, 254, 156, 'Carpio', 10000, 1),
(22190, 254, 127, 'Carr', 10000, 1),
(22191, 254, 139, 'Carrie', 10000, 1),
(22192, 254, 158, 'Carrier', 10000, 1),
(22193, 254, 135, 'Carrier Mills', 10000, 1),
(22194, 254, 149, 'Carroll', 10000, 1),
(22195, 254, 157, 'Carroll', 10000, 1),
(22196, 254, 168, 'Carrolls', 10000, 1),
(22197, 254, 144, 'Carrollton', 10000, 1),
(22199, 254, 167, 'Carrollton', 10000, 1),
(22200, 254, 160, 'Carrolltown', 10000, 1),
(22201, 254, 167, 'Carrsville', 10000, 1),
(22202, 254, 137, 'Carson', 10000, 1),
(22203, 254, 146, 'Carson', 10000, 1),
(22204, 254, 153, 'Carson', 10000, 1),
(22205, 254, 167, 'Carson', 10000, 1),
(22206, 254, 168, 'Carson', 10000, 1),
(22207, 254, 144, 'Carson City', 10000, 1),
(22209, 254, 139, 'Carter', 10000, 1),
(22210, 254, 148, 'Carter', 10000, 1),
(22211, 254, 158, 'Carter', 10000, 1),
(22212, 254, 163, 'Carter', 10000, 1),
(22213, 254, 137, 'Carter Lake', 10000, 1),
(22214, 254, 152, 'Carteret', 10000, 1),
(22215, 254, 136, 'Cartersburg', 10000, 1),
(22216, 254, 167, 'Cartersville', 10000, 1),
(22217, 254, 147, 'Carterville', 10000, 1),
(22218, 254, 125, 'Carthage', 10000, 1),
(22219, 254, 136, 'Carthage', 10000, 1),
(22220, 254, 155, 'Carthage', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(22221, 254, 154, 'Carthage', 10000, 1),
(22222, 254, 163, 'Carthage', 10000, 1),
(22223, 254, 156, 'Cartwright', 10000, 1),
(22224, 254, 158, 'Cartwright', 10000, 1),
(22225, 254, 126, 'Caruthers', 10000, 1),
(22226, 254, 143, 'Carver', 10000, 1),
(22227, 254, 145, 'Carver', 10000, 1),
(22228, 254, 160, 'Carversville', 10000, 1),
(22229, 254, 140, 'Carville', 10000, 1),
(22230, 254, 146, 'Cary', 10000, 1),
(22231, 254, 131, 'Caryville', 10000, 1),
(22232, 254, 164, 'Caryville', 10000, 1),
(22233, 254, 125, 'Casa', 10000, 1),
(22234, 254, 153, 'Casa Blanca', 10000, 1),
(22235, 254, 167, 'Casanova', 10000, 1),
(22236, 254, 155, 'Casar', 10000, 1),
(22237, 254, 127, 'Cascade', 10000, 1),
(22238, 254, 137, 'Cascade', 10000, 1),
(22239, 254, 134, 'Cascade', 10000, 1),
(22240, 254, 147, 'Cascade', 10000, 1),
(22241, 254, 148, 'Cascade', 10000, 1),
(22242, 254, 167, 'Cascade', 10000, 1),
(22243, 254, 170, 'Cascade', 10000, 1),
(22244, 254, 159, 'Cascade Locks', 10000, 1),
(22245, 254, 159, 'Cascadia', 10000, 1),
(22246, 254, 146, 'Cascilla', 10000, 1),
(22247, 254, 144, 'Casco', 10000, 1),
(22248, 254, 144, 'Caseville', 10000, 1),
(22249, 254, 137, 'Casey', 10000, 1),
(22250, 254, 135, 'Casey', 10000, 1),
(22251, 254, 125, 'Cash', 10000, 1),
(22252, 254, 155, 'Cashiers', 10000, 1),
(22253, 254, 124, 'Cashion', 10000, 1),
(22254, 254, 158, 'Cashion', 10000, 1),
(22255, 254, 168, 'Cashmere', 10000, 1),
(22256, 254, 170, 'Cashton', 10000, 1),
(22257, 254, 160, 'Cashtown', 10000, 1),
(22258, 254, 126, 'Casmalia', 10000, 1),
(22259, 254, 144, 'Casnovia', 10000, 1),
(22260, 254, 165, 'Cason', 10000, 1),
(22261, 254, 126, 'Caspar', 10000, 1),
(22262, 254, 144, 'Caspian', 10000, 1),
(22263, 254, 169, 'Cass', 10000, 1),
(22264, 254, 144, 'Cass City', 10000, 1),
(22265, 254, 145, 'Cass Lake', 10000, 1),
(22266, 254, 131, 'Cassadaga', 10000, 1),
(22267, 254, 154, 'Cassadaga', 10000, 1),
(22268, 254, 160, 'Cassandra', 10000, 1),
(22269, 254, 162, 'Cassatt', 10000, 1),
(22270, 254, 125, 'Casscoe', 10000, 1),
(22271, 254, 138, 'Cassoday', 10000, 1),
(22272, 254, 157, 'Casstown', 10000, 1),
(22273, 254, 132, 'Cassville', 10000, 1),
(22274, 254, 154, 'Cassville', 10000, 1),
(22275, 254, 160, 'Cassville', 10000, 1),
(22276, 254, 170, 'Cassville', 10000, 1),
(22277, 254, 169, 'Cassville', 10000, 1),
(22278, 254, 126, 'Castaic', 10000, 1),
(22279, 254, 137, 'Castalia', 10000, 1),
(22280, 254, 155, 'Castalia', 10000, 1),
(22281, 254, 157, 'Castalia', 10000, 1),
(22282, 254, 164, 'Castalian Springs', 10000, 1),
(22283, 254, 137, 'Castana', 10000, 1),
(22284, 254, 160, 'Castanea', 10000, 1),
(22285, 254, 165, 'Castell', 10000, 1),
(22286, 254, 126, 'Castella', 10000, 1),
(22287, 254, 154, 'Castile', 10000, 1),
(22288, 254, 141, 'Castine', 10000, 1),
(22289, 254, 158, 'Castle', 10000, 1),
(22290, 254, 154, 'Castle Creek', 10000, 1),
(22291, 254, 155, 'Castle Hayne', 10000, 1),
(22292, 254, 154, 'Castle Point', 10000, 1),
(22293, 254, 145, 'Castle Rock', 10000, 1),
(22294, 254, 168, 'Castle Rock', 10000, 1),
(22295, 254, 122, 'Castleberry', 10000, 1),
(22296, 254, 134, 'Castleford', 10000, 1),
(22297, 254, 135, 'Castleton', 10000, 1),
(22298, 254, 167, 'Castleton', 10000, 1),
(22299, 254, 154, 'Castleton on Hudson', 10000, 1),
(22300, 254, 163, 'Castlewood', 10000, 1),
(22301, 254, 167, 'Castlewood', 10000, 1),
(22302, 254, 140, 'Castor', 10000, 1),
(22303, 254, 154, 'Castorland', 10000, 1),
(22304, 254, 165, 'Cat Spring', 10000, 1),
(22305, 254, 134, 'Cataldo', 10000, 1),
(22306, 254, 124, 'Catalina', 10000, 1),
(22307, 254, 170, 'Cataract', 10000, 1),
(22308, 254, 165, 'Catarina', 10000, 1),
(22309, 254, 132, 'Cataula', 10000, 1),
(22310, 254, 143, 'Cataumet', 10000, 1),
(22311, 254, 155, 'Catawba', 10000, 1),
(22312, 254, 157, 'Catawba', 10000, 1),
(22313, 254, 162, 'Catawba', 10000, 1),
(22314, 254, 167, 'Catawba', 10000, 1),
(22315, 254, 170, 'Catawba', 10000, 1),
(22316, 254, 147, 'Catawissa', 10000, 1),
(22317, 254, 160, 'Catawissa', 10000, 1),
(22318, 254, 138, 'Catharine', 10000, 1),
(22319, 254, 167, 'Catharpin', 10000, 1),
(22320, 254, 156, 'Cathay', 10000, 1),
(22321, 254, 126, 'Catheys Valley', 10000, 1),
(22322, 254, 135, 'Catlin', 10000, 1),
(22323, 254, 154, 'Cato', 10000, 1),
(22324, 254, 142, 'Catonsville', 10000, 1),
(22325, 254, 158, 'Catoosa', 10000, 1),
(22326, 254, 147, 'Catron', 10000, 1),
(22327, 254, 154, 'Cattaraugus', 10000, 1),
(22328, 254, 147, 'Caulfield', 10000, 1),
(22329, 254, 153, 'Causey', 10000, 1),
(22330, 254, 135, 'Cave in Rock', 10000, 1),
(22331, 254, 125, 'Cave Springs', 10000, 1),
(22332, 254, 172, 'Cavendish', 10000, 1),
(22333, 254, 142, 'Cavetown', 10000, 1),
(22334, 254, 163, 'Cavour', 10000, 1),
(22335, 254, 138, 'Cawker City', 10000, 1),
(22336, 254, 139, 'Cawood', 10000, 1),
(22337, 254, 136, 'Cayuga', 10000, 1),
(22338, 254, 156, 'Cayuga', 10000, 1),
(22339, 254, 154, 'Cayuga', 10000, 1),
(22340, 254, 165, 'Cayuga', 10000, 1),
(22341, 254, 159, 'Cayuse', 10000, 1),
(22342, 254, 154, 'Cayuta', 10000, 1),
(22343, 254, 126, 'Cazadero', 10000, 1),
(22344, 254, 154, 'Cazenovia', 10000, 1),
(22345, 254, 170, 'Cazenovia', 10000, 1),
(22346, 254, 153, 'Cebolla', 10000, 1),
(22347, 254, 122, 'Cecil', 10000, 1),
(22348, 254, 125, 'Cecil', 10000, 1),
(22349, 254, 132, 'Cecil', 10000, 1),
(22350, 254, 157, 'Cecil', 10000, 1),
(22351, 254, 160, 'Cecil', 10000, 1),
(22352, 254, 170, 'Cecil', 10000, 1),
(22353, 254, 139, 'Cecilia', 10000, 1),
(22354, 254, 140, 'Cecilia', 10000, 1),
(22355, 254, 142, 'Cecilton', 10000, 1),
(22356, 254, 137, 'Cedar', 10000, 1),
(22357, 254, 138, 'Cedar', 10000, 1),
(22358, 254, 144, 'Cedar', 10000, 1),
(22359, 254, 145, 'Cedar', 10000, 1),
(22360, 254, 167, 'Cedar Bluff', 10000, 1),
(22361, 254, 149, 'Cedar Bluffs', 10000, 1),
(22362, 254, 152, 'Cedar Brook', 10000, 1),
(22363, 254, 147, 'Cedar City', 10000, 1),
(22364, 254, 149, 'Cedar Creek', 10000, 1),
(22365, 254, 165, 'Cedar Creek', 10000, 1),
(22366, 254, 153, 'Cedar Crest', 10000, 1),
(22367, 254, 155, 'Cedar Falls', 10000, 1),
(22368, 254, 126, 'Cedar Glen', 10000, 1),
(22369, 254, 136, 'Cedar Grove', 10000, 1),
(22370, 254, 155, 'Cedar Grove', 10000, 1),
(22371, 254, 152, 'Cedar Grove', 10000, 1),
(22372, 254, 164, 'Cedar Grove', 10000, 1),
(22373, 254, 170, 'Cedar Grove', 10000, 1),
(22374, 254, 169, 'Cedar Grove', 10000, 1),
(22375, 254, 147, 'Cedar Hill', 10000, 1),
(22376, 254, 164, 'Cedar Hill', 10000, 1),
(22377, 254, 155, 'Cedar Island', 10000, 1),
(22378, 254, 152, 'Cedar Knolls', 10000, 1),
(22379, 254, 144, 'Cedar Lake', 10000, 1),
(22380, 254, 165, 'Cedar Lane', 10000, 1),
(22381, 254, 155, 'Cedar Mountain', 10000, 1),
(22382, 254, 135, 'Cedar Point', 10000, 1),
(22383, 254, 138, 'Cedar Point', 10000, 1),
(22384, 254, 149, 'Cedar Rapids', 10000, 1),
(22385, 254, 144, 'Cedar River', 10000, 1),
(22386, 254, 160, 'Cedar Run', 10000, 1),
(22387, 254, 132, 'Cedar Springs', 10000, 1),
(22388, 254, 138, 'Cedar Vale', 10000, 1),
(22389, 254, 166, 'Cedar Valley', 10000, 1),
(22390, 254, 146, 'Cedarbluff', 10000, 1),
(22391, 254, 147, 'Cedarcreek', 10000, 1),
(22392, 254, 160, 'Cedars', 10000, 1),
(22393, 254, 125, 'Cedarville', 10000, 1),
(22394, 254, 126, 'Cedarville', 10000, 1),
(22395, 254, 135, 'Cedarville', 10000, 1),
(22396, 254, 144, 'Cedarville', 10000, 1),
(22397, 254, 152, 'Cedarville', 10000, 1),
(22398, 254, 169, 'Cedarville', 10000, 1),
(22399, 254, 165, 'Cee Vee', 10000, 1),
(22400, 254, 165, 'Celeste', 10000, 1),
(22401, 254, 136, 'Celestine', 10000, 1),
(22402, 254, 165, 'Celina', 10000, 1),
(22403, 254, 154, 'Celoron', 10000, 1),
(22404, 254, 158, 'Cement', 10000, 1),
(22405, 254, 144, 'Cement City', 10000, 1),
(22406, 254, 162, 'Centenary', 10000, 1),
(22407, 254, 171, 'Centennial', 10000, 1),
(22408, 254, 127, 'Center', 10000, 1),
(22409, 254, 139, 'Center', 10000, 1),
(22410, 254, 147, 'Center', 10000, 1),
(22411, 254, 149, 'Center', 10000, 1),
(22412, 254, 151, 'Center Barnstead', 10000, 1),
(22413, 254, 145, 'Center City', 10000, 1),
(22414, 254, 167, 'Center Cross', 10000, 1),
(22415, 254, 151, 'Center Harbor', 10000, 1),
(22416, 254, 131, 'Center Hill', 10000, 1),
(22417, 254, 137, 'Center Junction', 10000, 1),
(22418, 254, 144, 'Center Line', 10000, 1),
(22419, 254, 141, 'Center Lovell', 10000, 1),
(22420, 254, 154, 'Center Moriches', 10000, 1),
(22421, 254, 151, 'Center Ossipee', 10000, 1),
(22422, 254, 137, 'Center Point', 10000, 1),
(22423, 254, 140, 'Center Point', 10000, 1),
(22424, 254, 165, 'Center Point', 10000, 1),
(22425, 254, 169, 'Center Point', 10000, 1),
(22426, 254, 125, 'Center Ridge', 10000, 1),
(22427, 254, 172, 'Center Rutland', 10000, 1),
(22428, 254, 151, 'Center Sandwich', 10000, 1),
(22429, 254, 151, 'Center Strafford', 10000, 1),
(22430, 254, 151, 'Center Tuftonboro', 10000, 1),
(22431, 254, 128, 'Centerbrook', 10000, 1),
(22432, 254, 157, 'Centerburg', 10000, 1),
(22433, 254, 166, 'Centerfield', 10000, 1),
(22434, 254, 136, 'Centerpoint', 10000, 1),
(22435, 254, 154, 'Centerport', 10000, 1),
(22436, 254, 160, 'Centerport', 10000, 1),
(22437, 254, 139, 'Centertown', 10000, 1),
(22438, 254, 147, 'Centertown', 10000, 1),
(22439, 254, 147, 'Centerview', 10000, 1),
(22440, 254, 125, 'Centerville', 10000, 1),
(22441, 254, 136, 'Centerville', 10000, 1),
(22442, 254, 138, 'Centerville', 10000, 1),
(22443, 254, 140, 'Centerville', 10000, 1),
(22444, 254, 143, 'Centerville', 10000, 1),
(22445, 254, 154, 'Centerville', 10000, 1),
(22446, 254, 160, 'Centerville', 10000, 1),
(22447, 254, 163, 'Centerville', 10000, 1),
(22448, 254, 168, 'Centerville', 10000, 1),
(22449, 254, 158, 'Centrahoma', 10000, 1),
(22450, 254, 123, 'Central', 10000, 1),
(22451, 254, 124, 'Central', 10000, 1),
(22452, 254, 136, 'Central', 10000, 1),
(22453, 254, 166, 'Central', 10000, 1),
(22454, 254, 154, 'Central Bridge', 10000, 1),
(22455, 254, 127, 'Central City', 10000, 1),
(22456, 254, 137, 'Central City', 10000, 1),
(22457, 254, 139, 'Central City', 10000, 1),
(22458, 254, 160, 'Central City', 10000, 1),
(22459, 254, 161, 'Central Falls', 10000, 1),
(22460, 254, 154, 'Central Square', 10000, 1),
(22461, 254, 154, 'Central Valley', 10000, 1),
(22462, 254, 128, 'Central Village', 10000, 1),
(22463, 254, 138, 'Centralia', 10000, 1),
(22464, 254, 160, 'Centralia', 10000, 1),
(22465, 254, 165, 'Centralia', 10000, 1),
(22466, 254, 169, 'Centralia', 10000, 1),
(22467, 254, 160, 'Centre Hall', 10000, 1),
(22468, 254, 146, 'Centreville', 10000, 1),
(22469, 254, 170, 'Centuria', 10000, 1),
(22470, 254, 131, 'Century', 10000, 1),
(22471, 254, 169, 'Ceredo', 10000, 1),
(22472, 254, 154, 'Ceres', 10000, 1),
(22473, 254, 167, 'Ceres', 10000, 1),
(22474, 254, 144, 'Ceresco', 10000, 1),
(22475, 254, 149, 'Ceresco', 10000, 1),
(22476, 254, 153, 'Cerrillos', 10000, 1),
(22477, 254, 153, 'Cerro', 10000, 1),
(22478, 254, 135, 'Cerro Gordo', 10000, 1),
(22479, 254, 155, 'Cerro Gordo', 10000, 1),
(22480, 254, 139, 'Cerulean', 10000, 1),
(22481, 254, 145, 'Ceylon', 10000, 1),
(22482, 254, 153, 'Chacon', 10000, 1),
(22483, 254, 155, 'Chadbourn', 10000, 1),
(22484, 254, 135, 'Chadwick', 10000, 1),
(22485, 254, 147, 'Chadwick', 10000, 1),
(22486, 254, 154, 'Chadwicks', 10000, 1),
(22487, 254, 147, 'Chaffee', 10000, 1),
(22488, 254, 156, 'Chaffee', 10000, 1),
(22489, 254, 154, 'Chaffee', 10000, 1),
(22490, 254, 157, 'Chagrin Falls', 10000, 1),
(22492, 254, 165, 'Chalk', 10000, 1),
(22493, 254, 160, 'Chalk Hill', 10000, 1),
(22494, 254, 123, 'Chalkyitsik', 10000, 1),
(22495, 254, 126, 'Challenge', 10000, 1),
(22496, 254, 136, 'Chalmers', 10000, 1),
(22497, 254, 127, 'Chama', 10000, 1),
(22498, 254, 153, 'Chamberino', 10000, 1),
(22499, 254, 141, 'Chamberlain', 10000, 1),
(22500, 254, 124, 'Chambers', 10000, 1),
(22501, 254, 149, 'Chambers', 10000, 1),
(22502, 254, 135, 'Chambersburg', 10000, 1),
(22503, 254, 160, 'Chambersville', 10000, 1),
(22504, 254, 153, 'Chamisal', 10000, 1),
(22505, 254, 147, 'Chamois', 10000, 1),
(22506, 254, 160, 'Champion', 10000, 1),
(22507, 254, 154, 'Champlain', 10000, 1),
(22508, 254, 167, 'Champlain', 10000, 1),
(22509, 254, 135, 'Chana', 10000, 1),
(22510, 254, 122, 'Chancellor', 10000, 1),
(22511, 254, 163, 'Chancellor', 10000, 1),
(22512, 254, 136, 'Chandler', 10000, 1),
(22513, 254, 145, 'Chandler', 10000, 1),
(22514, 254, 124, 'Chandler Heights', 10000, 1),
(22515, 254, 160, 'Chandlers Valley', 10000, 1),
(22516, 254, 157, 'Chandlersville', 10000, 1),
(22517, 254, 135, 'Chandlerville', 10000, 1),
(22518, 254, 152, 'Changewater', 10000, 1),
(22519, 254, 135, 'Channahon', 10000, 1),
(22521, 254, 164, 'Chapel Hill', 10000, 1),
(22522, 254, 137, 'Chapin', 10000, 1),
(22523, 254, 135, 'Chapin', 10000, 1),
(22524, 254, 162, 'Chapin', 10000, 1),
(22525, 254, 128, 'Chaplin', 10000, 1),
(22526, 254, 139, 'Chaplin', 10000, 1),
(22527, 254, 122, 'Chapman', 10000, 1),
(22528, 254, 138, 'Chapman', 10000, 1),
(22529, 254, 149, 'Chapman', 10000, 1),
(22530, 254, 165, 'Chapman Ranch', 10000, 1),
(22531, 254, 164, 'Chapmansboro', 10000, 1),
(22532, 254, 139, 'Chappell', 10000, 1),
(22533, 254, 165, 'Chappell Hill', 10000, 1),
(22534, 254, 162, 'Chappells', 10000, 1),
(22535, 254, 140, 'Charenton', 10000, 1),
(22536, 254, 143, 'Charlemont', 10000, 1),
(22537, 254, 160, 'Charleroi', 10000, 1),
(22538, 254, 167, 'Charles City', 10000, 1),
(22539, 254, 141, 'Charleston', 10000, 1),
(22541, 254, 164, 'Charleston', 10000, 1),
(22542, 254, 162, 'Charleston AFB', 10000, 1),
(22543, 254, 142, 'Charlestown', 10000, 1),
(22544, 254, 151, 'Charlestown', 10000, 1),
(22545, 254, 161, 'Charlestown', 10000, 1),
(22546, 254, 148, 'Charlo', 10000, 1),
(22547, 254, 125, 'Charlotte', 10000, 1),
(22548, 254, 137, 'Charlotte', 10000, 1),
(22549, 254, 164, 'Charlotte', 10000, 1),
(22550, 254, 165, 'Charlotte', 10000, 1),
(22551, 254, 172, 'Charlotte', 10000, 1),
(22552, 254, 167, 'Charlotte Court House', 10000, 1),
(22553, 254, 136, 'Charlottesville', 10000, 1),
(22555, 254, 154, 'Charlotteville', 10000, 1),
(22556, 254, 143, 'Charlton', 10000, 1),
(22557, 254, 143, 'Charlton City', 10000, 1),
(22558, 254, 143, 'Charlton Depot', 10000, 1),
(22559, 254, 169, 'Charlton Heights', 10000, 1),
(22560, 254, 157, 'Charm', 10000, 1),
(22561, 254, 169, 'Charmco', 10000, 1),
(22562, 254, 137, 'Charter Oak', 10000, 1),
(22563, 254, 143, 'Chartley', 10000, 1),
(22564, 254, 140, 'Chase', 10000, 1),
(22565, 254, 142, 'Chase', 10000, 1),
(22566, 254, 144, 'Chase', 10000, 1),
(22567, 254, 167, 'Chase City', 10000, 1),
(22568, 254, 154, 'Chase Mills', 10000, 1),
(22569, 254, 156, 'Chaseley', 10000, 1),
(22570, 254, 144, 'Chassell', 10000, 1),
(22571, 254, 140, 'Chataignier', 10000, 1),
(22572, 254, 146, 'Chatawa', 10000, 1),
(22573, 254, 154, 'Chateaugay', 10000, 1),
(22574, 254, 145, 'Chatfield', 10000, 1),
(22575, 254, 157, 'Chatfield', 10000, 1),
(22576, 254, 165, 'Chatfield', 10000, 1),
(22577, 254, 140, 'Chatham', 10000, 1),
(22578, 254, 144, 'Chatham', 10000, 1),
(22579, 254, 146, 'Chatham', 10000, 1),
(22580, 254, 152, 'Chatham', 10000, 1),
(22581, 254, 154, 'Chatham', 10000, 1),
(22582, 254, 160, 'Chatham', 10000, 1),
(22583, 254, 137, 'Chatsworth', 10000, 1),
(22584, 254, 135, 'Chatsworth', 10000, 1),
(22585, 254, 152, 'Chatsworth', 10000, 1),
(22586, 254, 131, 'Chattahoochee', 10000, 1),
(22587, 254, 168, 'Chattaroy', 10000, 1),
(22588, 254, 169, 'Chattaroy', 10000, 1),
(22589, 254, 154, 'Chaumont', 10000, 1),
(22590, 254, 132, 'Chauncey', 10000, 1),
(22591, 254, 157, 'Chauncey', 10000, 1),
(22592, 254, 169, 'Chauncey', 10000, 1),
(22593, 254, 138, 'Chautauqua', 10000, 1),
(22594, 254, 154, 'Chautauqua', 10000, 1),
(22595, 254, 140, 'Chauvin', 10000, 1),
(22596, 254, 139, 'Chavies', 10000, 1),
(22597, 254, 154, 'Chazy', 10000, 1),
(22598, 254, 135, 'Chebanse', 10000, 1),
(22599, 254, 141, 'Chebeague Island', 10000, 1),
(22600, 254, 167, 'Check', 10000, 1),
(22601, 254, 158, 'Checotah', 10000, 1),
(22602, 254, 123, 'Chefornak', 10000, 1),
(22603, 254, 168, 'Chelan', 10000, 1),
(22604, 254, 168, 'Chelan Falls', 10000, 1),
(22605, 254, 143, 'Chelmsford', 10000, 1),
(22606, 254, 122, 'Chelsea', 10000, 1),
(22607, 254, 137, 'Chelsea', 10000, 1),
(22608, 254, 154, 'Chelsea', 10000, 1),
(22609, 254, 158, 'Chelsea', 10000, 1),
(22610, 254, 172, 'Chelsea', 10000, 1),
(22611, 254, 142, 'Cheltenham', 10000, 1),
(22612, 254, 160, 'Cheltenham', 10000, 1),
(22613, 254, 159, 'Chemult', 10000, 1),
(22614, 254, 154, 'Chemung', 10000, 1),
(22615, 254, 154, 'Chenango Bridge', 10000, 1),
(22616, 254, 154, 'Chenango Forks', 10000, 1),
(22617, 254, 138, 'Cheney', 10000, 1),
(22618, 254, 140, 'Cheneyville', 10000, 1),
(22619, 254, 135, 'Chenoa', 10000, 1),
(22620, 254, 127, 'Cheraw', 10000, 1),
(22621, 254, 167, 'Cheriton', 10000, 1),
(22622, 254, 122, 'Cherokee', 10000, 1),
(22623, 254, 138, 'Cherokee', 10000, 1),
(22624, 254, 165, 'Cherokee', 10000, 1),
(22625, 254, 135, 'Cherry', 10000, 1),
(22626, 254, 154, 'Cherry Creek', 10000, 1),
(22627, 254, 163, 'Cherry Creek', 10000, 1),
(22628, 254, 157, 'Cherry Fork', 10000, 1),
(22629, 254, 154, 'Cherry Plain', 10000, 1),
(22630, 254, 160, 'Cherry Tree', 10000, 1),
(22631, 254, 135, 'Cherry Valley', 10000, 1),
(22632, 254, 143, 'Cherry Valley', 10000, 1),
(22633, 254, 141, 'Cherryfield', 10000, 1),
(22634, 254, 132, 'Cherrylog', 10000, 1),
(22635, 254, 138, 'Cherryvale', 10000, 1),
(22636, 254, 147, 'Cherryville', 10000, 1),
(22637, 254, 160, 'Cherryville', 10000, 1),
(22638, 254, 144, 'Chesaning', 10000, 1),
(22639, 254, 142, 'Chesapeake City', 10000, 1),
(22640, 254, 143, 'Cheshire', 10000, 1),
(22641, 254, 157, 'Cheshire', 10000, 1),
(22642, 254, 159, 'Cheshire', 10000, 1),
(22643, 254, 162, 'Chesnee', 10000, 1),
(22644, 254, 160, 'Chest Springs', 10000, 1),
(22645, 254, 125, 'Chester', 10000, 1),
(22646, 254, 126, 'Chester', 10000, 1),
(22647, 254, 128, 'Chester', 10000, 1),
(22648, 254, 132, 'Chester', 10000, 1),
(22649, 254, 137, 'Chester', 10000, 1),
(22650, 254, 134, 'Chester', 10000, 1),
(22651, 254, 143, 'Chester', 10000, 1),
(22652, 254, 142, 'Chester', 10000, 1),
(22653, 254, 148, 'Chester', 10000, 1),
(22654, 254, 149, 'Chester', 10000, 1),
(22655, 254, 157, 'Chester', 10000, 1),
(22656, 254, 158, 'Chester', 10000, 1),
(22657, 254, 163, 'Chester', 10000, 1),
(22658, 254, 165, 'Chester', 10000, 1),
(22659, 254, 166, 'Chester', 10000, 1),
(22660, 254, 167, 'Chester', 10000, 1),
(22661, 254, 172, 'Chester Depot', 10000, 1),
(22662, 254, 167, 'Chester Gap', 10000, 1),
(22663, 254, 160, 'Chester Heights', 10000, 1),
(22664, 254, 160, 'Chester Springs', 10000, 1),
(22665, 254, 135, 'Chesterfield', 10000, 1),
(22666, 254, 143, 'Chesterfield', 10000, 1),
(22667, 254, 151, 'Chesterfield', 10000, 1),
(22668, 254, 157, 'Chesterhill', 10000, 1),
(22669, 254, 154, 'Chestertown', 10000, 1),
(22670, 254, 157, 'Chesterville', 10000, 1),
(22671, 254, 135, 'Chestnut', 10000, 1),
(22672, 254, 143, 'Chestnut Hill', 10000, 1),
(22673, 254, 164, 'Chestnut Mound', 10000, 1),
(22674, 254, 132, 'Chestnut Mountain', 10000, 1),
(22675, 254, 160, 'Chestnut Ridge', 10000, 1),
(22676, 254, 147, 'Chestnutridge', 10000, 1),
(22677, 254, 160, 'Cheswick', 10000, 1),
(22678, 254, 129, 'Cheswold', 10000, 1),
(22679, 254, 138, 'Chetopa', 10000, 1),
(22680, 254, 123, 'Chevak', 10000, 1),
(22681, 254, 142, 'Chevy Chase', 10000, 1),
(22682, 254, 164, 'Chewalla', 10000, 1),
(22683, 254, 168, 'Chewelah', 10000, 1),
(22684, 254, 142, 'Chewsville', 10000, 1),
(22685, 254, 160, 'Cheyney', 10000, 1),
(22686, 254, 135, 'Chicago Ridge', 10000, 1),
(22687, 254, 154, 'Chichester', 10000, 1),
(22688, 254, 132, 'Chickamauga', 10000, 1),
(22689, 254, 157, 'Chickasaw', 10000, 1),
(22690, 254, 123, 'Chicken', 10000, 1),
(22691, 254, 160, 'Chicora', 10000, 1),
(22692, 254, 165, 'Chicota', 10000, 1),
(22693, 254, 125, 'Chidester', 10000, 1),
(22694, 254, 123, 'Chignik', 10000, 1),
(22695, 254, 123, 'Chignik Lagoon', 10000, 1),
(22696, 254, 123, 'Chignik Lake', 10000, 1),
(22697, 254, 126, 'Chilcoot', 10000, 1),
(22698, 254, 122, 'Childersburg', 10000, 1),
(22699, 254, 142, 'Childs', 10000, 1),
(22700, 254, 154, 'Childwold', 10000, 1),
(22701, 254, 147, 'Chilhowee', 10000, 1),
(22702, 254, 167, 'Chilhowie', 10000, 1),
(22703, 254, 170, 'Chili', 10000, 1),
(22704, 254, 137, 'Chillicothe', 10000, 1),
(22705, 254, 135, 'Chillicothe', 10000, 1),
(22706, 254, 165, 'Chillicothe', 10000, 1),
(22707, 254, 143, 'Chilmark', 10000, 1),
(22708, 254, 157, 'Chilo', 10000, 1),
(22709, 254, 159, 'Chiloquin', 10000, 1),
(22710, 254, 165, 'Chilton', 10000, 1),
(22711, 254, 168, 'Chimacum', 10000, 1),
(22712, 254, 153, 'Chimayo', 10000, 1),
(22713, 254, 127, 'Chimney Rock', 10000, 1),
(22714, 254, 155, 'Chimney Rock', 10000, 1),
(22715, 254, 141, 'China', 10000, 1),
(22716, 254, 165, 'China', 10000, 1),
(22717, 254, 165, 'China Spring', 10000, 1),
(22718, 254, 160, 'Chinchilla', 10000, 1),
(22719, 254, 167, 'Chincoteague Island', 10000, 1),
(22720, 254, 126, 'Chinese Camp', 10000, 1),
(22721, 254, 124, 'Chino Valley', 10000, 1),
(22722, 254, 148, 'Chinook', 10000, 1),
(22723, 254, 168, 'Chinook', 10000, 1),
(22724, 254, 155, 'Chinquapin', 10000, 1),
(22725, 254, 154, 'Chippewa Bay', 10000, 1),
(22726, 254, 144, 'Chippewa Lake', 10000, 1),
(22727, 254, 157, 'Chippewa Lake', 10000, 1),
(22728, 254, 165, 'Chireno', 10000, 1),
(22729, 254, 145, 'Chisago City', 10000, 1),
(22730, 254, 123, 'Chitina', 10000, 1),
(22731, 254, 154, 'Chittenango', 10000, 1),
(22732, 254, 172, 'Chittenden', 10000, 1),
(22733, 254, 169, 'Chloe', 10000, 1),
(22734, 254, 124, 'Chloride', 10000, 1),
(22735, 254, 122, 'Choccolocco', 10000, 1),
(22736, 254, 151, 'Chocorua', 10000, 1),
(22737, 254, 155, 'Chocowinity', 10000, 1),
(22738, 254, 125, 'Choctaw', 10000, 1),
(22739, 254, 145, 'Chokio', 10000, 1),
(22740, 254, 131, 'Chokoloskee', 10000, 1),
(22741, 254, 140, 'Choudrant', 10000, 1),
(22742, 254, 158, 'Chouteau', 10000, 1),
(22743, 254, 165, 'Chriesman', 10000, 1),
(22744, 254, 135, 'Chrisman', 10000, 1),
(22745, 254, 136, 'Chrisney', 10000, 1),
(22746, 254, 167, 'Christchurch', 10000, 1),
(22747, 254, 160, 'Christiana', 10000, 1),
(22748, 254, 164, 'Christiana', 10000, 1),
(22749, 254, 157, 'Christiansburg', 10000, 1),
(22750, 254, 156, 'Christine', 10000, 1),
(22751, 254, 165, 'Christine', 10000, 1),
(22752, 254, 159, 'Christmas Valley', 10000, 1),
(22753, 254, 165, 'Christoval', 10000, 1),
(22754, 254, 127, 'Chromo', 10000, 1),
(22755, 254, 126, 'Chualar', 10000, 1),
(22756, 254, 164, 'Chuckey', 10000, 1),
(22757, 254, 123, 'Chugiak', 10000, 1),
(22758, 254, 171, 'Chugwater', 10000, 1),
(22759, 254, 132, 'Chula', 10000, 1),
(22760, 254, 122, 'Chunchula', 10000, 1),
(22761, 254, 146, 'Chunky', 10000, 1),
(22762, 254, 142, 'Church Creek', 10000, 1),
(22763, 254, 142, 'Church Hill', 10000, 1),
(22764, 254, 164, 'Church Hill', 10000, 1),
(22765, 254, 140, 'Church Point', 10000, 1),
(22766, 254, 167, 'Church Road', 10000, 1),
(22767, 254, 153, 'Church Rock', 10000, 1),
(22768, 254, 167, 'Church View', 10000, 1),
(22769, 254, 156, 'Churchs Ferry', 10000, 1),
(22770, 254, 142, 'Churchville', 10000, 1),
(22771, 254, 154, 'Churchville', 10000, 1),
(22772, 254, 167, 'Churchville', 10000, 1),
(22773, 254, 137, 'Churdan', 10000, 1),
(22774, 254, 154, 'Churubusco', 10000, 1),
(22775, 254, 124, 'Cibecue', 10000, 1),
(22776, 254, 124, 'Cibola', 10000, 1),
(22777, 254, 165, 'Cibolo', 10000, 1),
(22778, 254, 136, 'Cicero', 10000, 1),
(22779, 254, 154, 'Cicero', 10000, 1),
(22780, 254, 126, 'Cima', 10000, 1),
(22781, 254, 127, 'Cimarron', 10000, 1),
(22782, 254, 153, 'Cimarron', 10000, 1),
(22783, 254, 137, 'Cincinnati', 10000, 1),
(22784, 254, 154, 'Cincinnatus', 10000, 1),
(22785, 254, 168, 'Cinebar', 10000, 1),
(22786, 254, 123, 'Circle', 10000, 1),
(22787, 254, 148, 'Circle', 10000, 1),
(22788, 254, 145, 'Circle Pines', 10000, 1),
(22789, 254, 138, 'Circleville', 10000, 1),
(22790, 254, 154, 'Circleville', 10000, 1),
(22791, 254, 166, 'Circleville', 10000, 1),
(22792, 254, 132, 'Cisco', 10000, 1),
(22793, 254, 135, 'Cisco', 10000, 1),
(22794, 254, 139, 'Cisco', 10000, 1),
(22795, 254, 165, 'Cisco', 10000, 1),
(22796, 254, 166, 'Cisco', 10000, 1),
(22797, 254, 135, 'Cisne', 10000, 1),
(22798, 254, 135, 'Cissna Park', 10000, 1),
(22799, 254, 131, 'Citra', 10000, 1),
(22800, 254, 122, 'Citronelle', 10000, 1),
(22801, 254, 126, 'City of Industry', 10000, 1),
(22802, 254, 159, 'Clackamas', 10000, 1),
(22803, 254, 138, 'Claflin', 10000, 1),
(22804, 254, 142, 'Claiborne', 10000, 1),
(22805, 254, 163, 'Claire City', 10000, 1),
(22806, 254, 164, 'Clairfield', 10000, 1),
(22807, 254, 160, 'Clairton', 10000, 1),
(22808, 254, 168, 'Clallam Bay', 10000, 1),
(22809, 254, 170, 'Clam Lake', 10000, 1),
(22810, 254, 148, 'Clancy', 10000, 1),
(22811, 254, 146, 'Clara', 10000, 1),
(22812, 254, 145, 'Clara City', 10000, 1),
(22813, 254, 131, 'Clarcona', 10000, 1),
(22814, 254, 137, 'Clare', 10000, 1),
(22815, 254, 135, 'Clare', 10000, 1),
(22816, 254, 135, 'Claremont', 10000, 1),
(22817, 254, 145, 'Claremont', 10000, 1),
(22818, 254, 155, 'Claremont', 10000, 1),
(22819, 254, 163, 'Claremont', 10000, 1),
(22820, 254, 167, 'Claremont', 10000, 1),
(22821, 254, 137, 'Clarence', 10000, 1),
(22822, 254, 140, 'Clarence', 10000, 1),
(22823, 254, 147, 'Clarence', 10000, 1),
(22824, 254, 154, 'Clarence', 10000, 1),
(22825, 254, 160, 'Clarence', 10000, 1),
(22826, 254, 154, 'Clarence Center', 10000, 1),
(22827, 254, 155, 'Clarendon', 10000, 1),
(22828, 254, 154, 'Clarendon', 10000, 1),
(22829, 254, 160, 'Clarendon', 10000, 1),
(22830, 254, 135, 'Clarendon Hills', 10000, 1),
(22831, 254, 160, 'Claridge', 10000, 1),
(22832, 254, 157, 'Clarington', 10000, 1),
(22833, 254, 160, 'Clarington', 10000, 1),
(22834, 254, 145, 'Clarissa', 10000, 1),
(22835, 254, 158, 'Clarita', 10000, 1),
(22836, 254, 127, 'Clark', 10000, 1),
(22837, 254, 147, 'Clark', 10000, 1),
(22838, 254, 160, 'Clark', 10000, 1),
(22839, 254, 134, 'Clark Fork', 10000, 1),
(22840, 254, 154, 'Clark Mills', 10000, 1),
(22841, 254, 132, 'Clarkdale', 10000, 1),
(22842, 254, 125, 'Clarkedale', 10000, 1),
(22843, 254, 145, 'Clarkfield', 10000, 1),
(22844, 254, 134, 'Clarkia', 10000, 1),
(22845, 254, 144, 'Clarklake', 10000, 1),
(22846, 254, 164, 'Clarkrange', 10000, 1),
(22847, 254, 125, 'Clarkridge', 10000, 1),
(22848, 254, 140, 'Clarks', 10000, 1),
(22849, 254, 136, 'Clarks Hill', 10000, 1),
(22850, 254, 162, 'Clarks Hill', 10000, 1),
(22851, 254, 160, 'Clarks Mills', 10000, 1),
(22852, 254, 123, 'Clarks Point', 10000, 1),
(22853, 254, 152, 'Clarksboro', 10000, 1),
(22854, 254, 126, 'Clarksburg', 10000, 1),
(22855, 254, 136, 'Clarksburg', 10000, 1),
(22856, 254, 147, 'Clarksburg', 10000, 1),
(22857, 254, 152, 'Clarksburg', 10000, 1),
(22858, 254, 157, 'Clarksburg', 10000, 1),
(22859, 254, 160, 'Clarksburg', 10000, 1),
(22860, 254, 164, 'Clarksburg', 10000, 1),
(22861, 254, 147, 'Clarksdale', 10000, 1),
(22862, 254, 139, 'Clarkson', 10000, 1),
(22863, 254, 149, 'Clarkson', 10000, 1),
(22864, 254, 154, 'Clarkson', 10000, 1),
(22865, 254, 132, 'Clarkston', 10000, 1),
(22866, 254, 166, 'Clarkston', 10000, 1),
(22867, 254, 131, 'Clarksville', 10000, 1),
(22868, 254, 137, 'Clarksville', 10000, 1),
(22869, 254, 142, 'Clarksville', 10000, 1),
(22870, 254, 144, 'Clarksville', 10000, 1),
(22871, 254, 147, 'Clarksville', 10000, 1),
(22872, 254, 154, 'Clarksville', 10000, 1),
(22873, 254, 157, 'Clarksville', 10000, 1),
(22874, 254, 160, 'Clarksville', 10000, 1),
(22875, 254, 147, 'Clarkton', 10000, 1),
(22876, 254, 155, 'Clarkton', 10000, 1),
(22877, 254, 154, 'Claryville', 10000, 1),
(22878, 254, 149, 'Clatonia', 10000, 1),
(22879, 254, 167, 'Claudville', 10000, 1),
(22880, 254, 153, 'Claunch', 10000, 1),
(22881, 254, 154, 'Claverack', 10000, 1),
(22882, 254, 144, 'Clawson', 10000, 1),
(22883, 254, 166, 'Clawson', 10000, 1),
(22884, 254, 132, 'Claxton', 10000, 1),
(22885, 254, 122, 'Clay', 10000, 1),
(22886, 254, 139, 'Clay', 10000, 1),
(22887, 254, 154, 'Clay', 10000, 1),
(22888, 254, 165, 'Clay', 10000, 1),
(22889, 254, 157, 'Clay Center', 10000, 1),
(22890, 254, 135, 'Clay City', 10000, 1),
(22891, 254, 136, 'Clay City', 10000, 1),
(22892, 254, 139, 'Clay City', 10000, 1),
(22893, 254, 124, 'Clay Springs', 10000, 1),
(22894, 254, 139, 'Clayhole', 10000, 1),
(22895, 254, 124, 'Claypool', 10000, 1),
(22896, 254, 136, 'Claypool', 10000, 1),
(22897, 254, 160, 'Claysburg', 10000, 1),
(22898, 254, 160, 'Claysville', 10000, 1),
(22899, 254, 122, 'Clayton', 10000, 1),
(22900, 254, 129, 'Clayton', 10000, 1),
(22901, 254, 134, 'Clayton', 10000, 1),
(22902, 254, 135, 'Clayton', 10000, 1),
(22903, 254, 136, 'Clayton', 10000, 1),
(22904, 254, 138, 'Clayton', 10000, 1),
(22905, 254, 140, 'Clayton', 10000, 1),
(22906, 254, 144, 'Clayton', 10000, 1),
(22907, 254, 158, 'Clayton', 10000, 1),
(22908, 254, 165, 'Clayton', 10000, 1),
(22909, 254, 168, 'Clayton', 10000, 1),
(22910, 254, 170, 'Clayton', 10000, 1),
(22911, 254, 135, 'Claytonville', 10000, 1),
(22912, 254, 154, 'Clayville', 10000, 1),
(22913, 254, 161, 'Clayville', 10000, 1),
(22914, 254, 168, 'Cle Elum', 10000, 1),
(22915, 254, 123, 'Clear', 10000, 1),
(22916, 254, 167, 'Clear Brook', 10000, 1),
(22917, 254, 136, 'Clear Creek', 10000, 1),
(22918, 254, 169, 'Clear Creek', 10000, 1),
(22919, 254, 169, 'Clear Fork', 10000, 1),
(22920, 254, 145, 'Clear Lake', 10000, 1),
(22921, 254, 170, 'Clear Lake', 10000, 1),
(22922, 254, 142, 'Clear Spring', 10000, 1),
(22923, 254, 145, 'Clearbrook', 10000, 1),
(22924, 254, 139, 'Clearfield', 10000, 1),
(22925, 254, 168, 'Clearlake', 10000, 1),
(22926, 254, 126, 'Clearlake Oaks', 10000, 1),
(22927, 254, 126, 'Clearlake Park', 10000, 1),
(22928, 254, 147, 'Clearmont', 10000, 1),
(22929, 254, 171, 'Clearmont', 10000, 1),
(22930, 254, 138, 'Clearview City', 10000, 1),
(22931, 254, 160, 'Clearville', 10000, 1),
(22932, 254, 138, 'Clearwater', 10000, 1),
(22933, 254, 149, 'Clearwater', 10000, 1),
(22934, 254, 162, 'Clearwater', 10000, 1),
(22935, 254, 131, 'Clearwater Beach', 10000, 1),
(22936, 254, 139, 'Cleaton', 10000, 1),
(22937, 254, 137, 'Cleghorn', 10000, 1),
(22938, 254, 126, 'Clements', 10000, 1),
(22939, 254, 142, 'Clements', 10000, 1),
(22940, 254, 145, 'Clements', 10000, 1),
(22941, 254, 137, 'Clemons', 10000, 1),
(22942, 254, 154, 'Clemons', 10000, 1),
(22943, 254, 169, 'Clendenin', 10000, 1),
(22944, 254, 158, 'Cleo Springs', 10000, 1),
(22945, 254, 132, 'Clermont', 10000, 1),
(22946, 254, 137, 'Clermont', 10000, 1),
(22947, 254, 139, 'Clermont', 10000, 1),
(22948, 254, 122, 'Cleveland', 10000, 1),
(22949, 254, 125, 'Cleveland', 10000, 1),
(22950, 254, 145, 'Cleveland', 10000, 1),
(22951, 254, 147, 'Cleveland', 10000, 1),
(22952, 254, 155, 'Cleveland', 10000, 1),
(22953, 254, 156, 'Cleveland', 10000, 1),
(22954, 254, 153, 'Cleveland', 10000, 1),
(22955, 254, 154, 'Cleveland', 10000, 1),
(22956, 254, 158, 'Cleveland', 10000, 1),
(22957, 254, 166, 'Cleveland', 10000, 1),
(22958, 254, 167, 'Cleveland', 10000, 1),
(22959, 254, 170, 'Cleveland', 10000, 1),
(22960, 254, 169, 'Cleveland', 10000, 1),
(22961, 254, 147, 'Clever', 10000, 1),
(22962, 254, 154, 'Cleverdale', 10000, 1),
(22963, 254, 157, 'Cleves', 10000, 1),
(22964, 254, 153, 'Cliff', 10000, 1),
(22965, 254, 141, 'Cliff Island', 10000, 1),
(22966, 254, 136, 'Clifford', 10000, 1),
(22967, 254, 144, 'Clifford', 10000, 1),
(22968, 254, 156, 'Clifford', 10000, 1),
(22969, 254, 160, 'Clifford', 10000, 1),
(22970, 254, 167, 'Clifford', 10000, 1),
(22971, 254, 155, 'Cliffside', 10000, 1),
(22972, 254, 152, 'Cliffwood', 10000, 1),
(22973, 254, 124, 'Clifton', 10000, 1),
(22974, 254, 127, 'Clifton', 10000, 1),
(22975, 254, 134, 'Clifton', 10000, 1),
(22976, 254, 135, 'Clifton', 10000, 1),
(22977, 254, 138, 'Clifton', 10000, 1),
(22978, 254, 157, 'Clifton', 10000, 1),
(22979, 254, 162, 'Clifton', 10000, 1),
(22980, 254, 164, 'Clifton', 10000, 1),
(22981, 254, 147, 'Clifton Hill', 10000, 1),
(22982, 254, 154, 'Clifton Springs', 10000, 1),
(22983, 254, 139, 'Clifty', 10000, 1),
(22984, 254, 127, 'Climax', 10000, 1),
(22985, 254, 132, 'Climax', 10000, 1),
(22986, 254, 144, 'Climax', 10000, 1),
(22987, 254, 145, 'Climax', 10000, 1),
(22988, 254, 155, 'Climax', 10000, 1),
(22989, 254, 160, 'Climax', 10000, 1),
(22990, 254, 147, 'Climax Springs', 10000, 1),
(22991, 254, 137, 'Climbing Hill', 10000, 1),
(22992, 254, 167, 'Clinchco', 10000, 1),
(22993, 254, 132, 'Clinchfield', 10000, 1),
(22994, 254, 153, 'Clines Corners', 10000, 1),
(22995, 254, 165, 'Clint', 10000, 1),
(22996, 254, 122, 'Clinton', 10000, 1),
(22997, 254, 128, 'Clinton', 10000, 1),
(22998, 254, 136, 'Clinton', 10000, 1),
(22999, 254, 143, 'Clinton', 10000, 1),
(23000, 254, 141, 'Clinton', 10000, 1),
(23001, 254, 148, 'Clinton', 10000, 1),
(23002, 254, 154, 'Clinton', 10000, 1),
(23003, 254, 157, 'Clinton', 10000, 1),
(23004, 254, 160, 'Clinton', 10000, 1),
(23005, 254, 170, 'Clinton', 10000, 1),
(23006, 254, 154, 'Clinton Corners', 10000, 1),
(23007, 254, 154, 'Clintondale', 10000, 1),
(23008, 254, 160, 'Clintonville', 10000, 1),
(23009, 254, 170, 'Clintonville', 10000, 1),
(23010, 254, 122, 'Clio', 10000, 1),
(23011, 254, 126, 'Clio', 10000, 1),
(23012, 254, 137, 'Clio', 10000, 1),
(23013, 254, 144, 'Clio', 10000, 1),
(23014, 254, 162, 'Clio', 10000, 1),
(23015, 254, 169, 'Clio', 10000, 1),
(23016, 254, 126, 'Clipper Mills', 10000, 1),
(23017, 254, 145, 'Clitherall', 10000, 1),
(23018, 254, 154, 'Clockville', 10000, 1),
(23019, 254, 145, 'Clontarf', 10000, 1),
(23020, 254, 122, 'Clopton', 10000, 1),
(23021, 254, 139, 'Closplint', 10000, 1),
(23022, 254, 152, 'Closter', 10000, 1),
(23023, 254, 169, 'Clothier', 10000, 1),
(23024, 254, 140, 'Cloutierville', 10000, 1),
(23025, 254, 162, 'Clover', 10000, 1),
(23026, 254, 167, 'Clover', 10000, 1),
(23027, 254, 122, 'Cloverdale', 10000, 1),
(23028, 254, 136, 'Cloverdale', 10000, 1),
(23029, 254, 144, 'Cloverdale', 10000, 1),
(23030, 254, 157, 'Cloverdale', 10000, 1),
(23031, 254, 159, 'Cloverdale', 10000, 1),
(23032, 254, 167, 'Cloverdale', 10000, 1),
(23033, 254, 139, 'Cloverport', 10000, 1),
(23034, 254, 147, 'Clubb', 10000, 1),
(23035, 254, 160, 'Clune', 10000, 1),
(23036, 254, 167, 'Cluster Springs', 10000, 1),
(23037, 254, 137, 'Clutier', 10000, 1),
(23038, 254, 138, 'Clyde', 10000, 1),
(23039, 254, 147, 'Clyde', 10000, 1),
(23040, 254, 155, 'Clyde', 10000, 1),
(23041, 254, 154, 'Clyde', 10000, 1),
(23042, 254, 148, 'Clyde Park', 10000, 1),
(23043, 254, 170, 'Clyman', 10000, 1),
(23044, 254, 154, 'Clymer', 10000, 1),
(23045, 254, 132, 'Clyo', 10000, 1),
(23046, 254, 126, 'Coachella', 10000, 1),
(23047, 254, 146, 'Coahoma', 10000, 1),
(23048, 254, 165, 'Coahoma', 10000, 1),
(23049, 254, 160, 'Coal Center', 10000, 1),
(23050, 254, 136, 'Coal City', 10000, 1),
(23051, 254, 169, 'Coal City', 10000, 1),
(23052, 254, 127, 'Coal Creek', 10000, 1),
(23053, 254, 125, 'Coal Hill', 10000, 1),
(23054, 254, 169, 'Coal Mountain', 10000, 1),
(23055, 254, 157, 'Coal Run', 10000, 1),
(23056, 254, 160, 'Coal Township', 10000, 1),
(23057, 254, 135, 'Coal Valley', 10000, 1),
(23058, 254, 127, 'Coaldale', 10000, 1),
(23059, 254, 160, 'Coaldale', 10000, 1),
(23060, 254, 164, 'Coalfield', 10000, 1),
(23061, 254, 139, 'Coalgood', 10000, 1),
(23062, 254, 122, 'Coaling', 10000, 1),
(23063, 254, 127, 'Coalmont', 10000, 1),
(23064, 254, 136, 'Coalmont', 10000, 1),
(23065, 254, 164, 'Coalmont', 10000, 1),
(23066, 254, 160, 'Coalport', 10000, 1),
(23067, 254, 157, 'Coalton', 10000, 1),
(23068, 254, 169, 'Coalton', 10000, 1),
(23069, 254, 169, 'Coalwood', 10000, 1),
(23070, 254, 136, 'Coatesville', 10000, 1),
(23071, 254, 138, 'Coats', 10000, 1),
(23072, 254, 155, 'Coats', 10000, 1),
(23073, 254, 135, 'Coatsburg', 10000, 1),
(23074, 254, 147, 'Coatsville', 10000, 1),
(23075, 254, 128, 'Cobalt', 10000, 1),
(23076, 254, 134, 'Cobalt', 10000, 1),
(23077, 254, 132, 'Cobb', 10000, 1),
(23078, 254, 170, 'Cobb', 10000, 1),
(23079, 254, 142, 'Cobb Island', 10000, 1),
(23080, 254, 167, 'Cobbs Creek', 10000, 1),
(23081, 254, 132, 'Cobbtown', 10000, 1),
(23082, 254, 135, 'Cobden', 10000, 1),
(23083, 254, 160, 'Coburn', 10000, 1),
(23084, 254, 154, 'Cochecton', 10000, 1),
(23085, 254, 154, 'Cochecton Center', 10000, 1),
(23086, 254, 124, 'Cochise', 10000, 1),
(23087, 254, 153, 'Cochiti Lake', 10000, 1),
(23088, 254, 153, 'Cochiti Pueblo', 10000, 1),
(23089, 254, 170, 'Cochrane', 10000, 1),
(23090, 254, 160, 'Cochranton', 10000, 1),
(23091, 254, 160, 'Cochranville', 10000, 1),
(23092, 254, 131, 'Cocoa Beach', 10000, 1),
(23093, 254, 134, 'Cocolalla', 10000, 1),
(23094, 254, 160, 'Cocolamus', 10000, 1),
(23095, 254, 160, 'Codorus', 10000, 1),
(23096, 254, 149, 'Cody', 10000, 1),
(23097, 254, 167, 'Coeburn', 10000, 1),
(23098, 254, 135, 'Coello', 10000, 1),
(23099, 254, 134, 'Coeur d Alene', 10000, 1),
(23100, 254, 154, 'Coeymans', 10000, 1),
(23101, 254, 154, 'Coeymans Hollow', 10000, 1),
(23102, 254, 148, 'Coffee Creek', 10000, 1),
(23103, 254, 122, 'Coffee Springs', 10000, 1),
(23104, 254, 135, 'Coffeen', 10000, 1),
(23105, 254, 122, 'Coffeeville', 10000, 1),
(23106, 254, 147, 'Coffey', 10000, 1),
(23107, 254, 123, 'Coffman Cove', 10000, 1),
(23108, 254, 155, 'Cofield', 10000, 1),
(23109, 254, 137, 'Coggon', 10000, 1),
(23110, 254, 156, 'Cogswell', 10000, 1),
(23111, 254, 148, 'Cohagen', 10000, 1),
(23112, 254, 143, 'Cohasset', 10000, 1),
(23113, 254, 145, 'Cohasset', 10000, 1),
(23114, 254, 144, 'Cohoctah', 10000, 1),
(23115, 254, 154, 'Cohocton', 10000, 1),
(23116, 254, 154, 'Cohoes', 10000, 1),
(23117, 254, 132, 'Cohutta', 10000, 1),
(23118, 254, 146, 'Coila', 10000, 1),
(23119, 254, 137, 'Coin', 10000, 1),
(23120, 254, 155, 'Coinjock', 10000, 1),
(23121, 254, 145, 'Cokato', 10000, 1),
(23122, 254, 160, 'Cokeburg', 10000, 1),
(23123, 254, 164, 'Cokercreek', 10000, 1),
(23124, 254, 171, 'Cokeville', 10000, 1),
(23125, 254, 132, 'Colbert', 10000, 1),
(23126, 254, 168, 'Colbert', 10000, 1),
(23127, 254, 134, 'Colburn', 10000, 1),
(23128, 254, 170, 'Colby', 10000, 1),
(23129, 254, 135, 'Colchester', 10000, 1),
(23130, 254, 158, 'Colcord', 10000, 1),
(23131, 254, 169, 'Colcord', 10000, 1),
(23132, 254, 154, 'Cold Brook', 10000, 1),
(23133, 254, 154, 'Cold Spring Harbor', 10000, 1),
(23134, 254, 154, 'Colden', 10000, 1),
(23135, 254, 139, 'Coldiron', 10000, 1),
(23136, 254, 146, 'Coldwater', 10000, 1),
(23137, 254, 147, 'Cole Camp', 10000, 1),
(23138, 254, 128, 'Colebrook', 10000, 1),
(23139, 254, 156, 'Coleharbor', 10000, 1),
(23140, 254, 131, 'Coleman', 10000, 1),
(23141, 254, 132, 'Coleman', 10000, 1),
(23142, 254, 158, 'Coleman', 10000, 1),
(23143, 254, 167, 'Coleman Falls', 10000, 1),
(23144, 254, 155, 'Colerain', 10000, 1),
(23145, 254, 157, 'Colerain', 10000, 1),
(23146, 254, 145, 'Coleraine', 10000, 1),
(23147, 254, 149, 'Coleridge', 10000, 1),
(23148, 254, 167, 'Coles Point', 10000, 1),
(23149, 254, 137, 'Colesburg', 10000, 1),
(23150, 254, 126, 'Coleville', 10000, 1),
(23151, 254, 137, 'Colfax', 10000, 1),
(23152, 254, 135, 'Colfax', 10000, 1),
(23153, 254, 136, 'Colfax', 10000, 1),
(23154, 254, 155, 'Colfax', 10000, 1),
(23155, 254, 168, 'Colfax', 10000, 1),
(23156, 254, 170, 'Colfax', 10000, 1),
(23157, 254, 169, 'Colfax', 10000, 1),
(23158, 254, 170, 'Colgate', 10000, 1),
(23159, 254, 127, 'Collbran', 10000, 1),
(23160, 254, 126, 'College City', 10000, 1),
(23161, 254, 157, 'College Corner', 10000, 1),
(23162, 254, 164, 'College Grove', 10000, 1),
(23163, 254, 154, 'College Point', 10000, 1),
(23164, 254, 137, 'College Springs', 10000, 1),
(23165, 254, 125, 'College Station', 10000, 1),
(23166, 254, 164, 'Collegedale', 10000, 1),
(23167, 254, 165, 'Collegeport', 10000, 1),
(23168, 254, 155, 'Collettsville', 10000, 1),
(23169, 254, 169, 'Colliers', 10000, 1),
(23170, 254, 154, 'Colliersville', 10000, 1),
(23171, 254, 152, 'Collingswood', 10000, 1),
(23172, 254, 132, 'Collins', 10000, 1),
(23173, 254, 137, 'Collins', 10000, 1),
(23174, 254, 147, 'Collins', 10000, 1),
(23175, 254, 154, 'Collins', 10000, 1),
(23176, 254, 170, 'Collins', 10000, 1),
(23177, 254, 154, 'Collins Center', 10000, 1),
(23178, 254, 140, 'Collinston', 10000, 1),
(23179, 254, 166, 'Collinston', 10000, 1),
(23180, 254, 122, 'Collinsville', 10000, 1),
(23181, 254, 128, 'Collinsville', 10000, 1),
(23182, 254, 146, 'Collinsville', 10000, 1),
(23183, 254, 157, 'Collinsville', 10000, 1),
(23184, 254, 158, 'Collinsville', 10000, 1),
(23185, 254, 165, 'Collinsville', 10000, 1),
(23186, 254, 167, 'Collinsville', 10000, 1),
(23187, 254, 164, 'Collinwood', 10000, 1),
(23188, 254, 135, 'Collison', 10000, 1),
(23189, 254, 138, 'Collyer', 10000, 1),
(23190, 254, 163, 'Colman', 10000, 1),
(23191, 254, 160, 'Colmar', 10000, 1),
(23192, 254, 137, 'Colo', 10000, 1),
(23193, 254, 145, 'Cologne', 10000, 1),
(23194, 254, 152, 'Cologne', 10000, 1),
(23195, 254, 163, 'Colome', 10000, 1),
(23196, 254, 144, 'Colon', 10000, 1),
(23197, 254, 149, 'Colon', 10000, 1),
(23198, 254, 135, 'Colona', 10000, 1),
(23199, 254, 152, 'Colonia', 10000, 1),
(23200, 254, 138, 'Colony', 10000, 1),
(23201, 254, 158, 'Colony', 10000, 1),
(23202, 254, 142, 'Colora', 10000, 1),
(23203, 254, 124, 'Colorado City', 10000, 1),
(23204, 254, 127, 'Colorado City', 10000, 1),
(23205, 254, 135, 'Colp', 10000, 1),
(23206, 254, 143, 'Colrain', 10000, 1),
(23207, 254, 125, 'Colt', 10000, 1),
(23208, 254, 154, 'Colton', 10000, 1),
(23209, 254, 157, 'Colton', 10000, 1),
(23210, 254, 159, 'Colton', 10000, 1),
(23211, 254, 163, 'Colton', 10000, 1),
(23212, 254, 168, 'Colton', 10000, 1),
(23213, 254, 142, 'Coltons Point', 10000, 1),
(23214, 254, 152, 'Colts Neck', 10000, 1),
(23215, 254, 122, 'Columbia', 10000, 1),
(23216, 254, 128, 'Columbia', 10000, 1),
(23217, 254, 137, 'Columbia', 10000, 1),
(23218, 254, 152, 'Columbia', 10000, 1),
(23219, 254, 160, 'Columbia', 10000, 1),
(23221, 254, 163, 'Columbia', 10000, 1),
(23222, 254, 167, 'Columbia', 10000, 1),
(23223, 254, 159, 'Columbia City', 10000, 1),
(23224, 254, 160, 'Columbia Cross Roads', 10000, 1),
(23225, 254, 141, 'Columbia Falls', 10000, 1),
(23226, 254, 148, 'Columbia Falls', 10000, 1),
(23227, 254, 157, 'Columbia Station', 10000, 1),
(23228, 254, 154, 'Columbiaville', 10000, 1),
(23229, 254, 125, 'Columbus', 10000, 1),
(23230, 254, 139, 'Columbus', 10000, 1),
(23231, 254, 144, 'Columbus', 10000, 1),
(23232, 254, 148, 'Columbus', 10000, 1),
(23233, 254, 156, 'Columbus', 10000, 1),
(23234, 254, 152, 'Columbus', 10000, 1),
(23235, 254, 153, 'Columbus', 10000, 1),
(23236, 254, 160, 'Columbus', 10000, 1),
(23237, 254, 170, 'Columbus', 10000, 1),
(23238, 254, 137, 'Columbus City', 10000, 1),
(23239, 254, 157, 'Columbus Grove', 10000, 1),
(23240, 254, 135, 'Colusa', 10000, 1),
(23241, 254, 160, 'Colver', 10000, 1),
(23242, 254, 137, 'Colwell', 10000, 1),
(23243, 254, 138, 'Colwich', 10000, 1),
(23244, 254, 158, 'Comanche', 10000, 1),
(23245, 254, 165, 'Combes', 10000, 1),
(23246, 254, 170, 'Combined Locks', 10000, 1),
(23247, 254, 125, 'Combs', 10000, 1),
(23248, 254, 139, 'Combs', 10000, 1),
(23249, 254, 132, 'Comer', 10000, 1),
(23250, 254, 155, 'Comfort', 10000, 1),
(23251, 254, 165, 'Comfort', 10000, 1),
(23252, 254, 169, 'Comfort', 10000, 1),
(23253, 254, 145, 'Comfrey', 10000, 1),
(23254, 254, 144, 'Comins', 10000, 1),
(23255, 254, 132, 'Commerce', 10000, 1),
(23256, 254, 147, 'Commerce', 10000, 1),
(23257, 254, 158, 'Commerce', 10000, 1),
(23258, 254, 127, 'Commerce City', 10000, 1),
(23259, 254, 144, 'Commerce Township', 10000, 1),
(23260, 254, 157, 'Commercial Point', 10000, 1),
(23261, 254, 136, 'Commiskey', 10000, 1),
(23262, 254, 160, 'Commodore', 10000, 1),
(23263, 254, 127, 'Como', 10000, 1),
(23264, 254, 146, 'Como', 10000, 1),
(23265, 254, 155, 'Como', 10000, 1),
(23266, 254, 164, 'Como', 10000, 1),
(23267, 254, 165, 'Como', 10000, 1),
(23268, 254, 125, 'Compton', 10000, 1),
(23269, 254, 135, 'Compton', 10000, 1),
(23270, 254, 142, 'Compton', 10000, 1),
(23271, 254, 144, 'Comstock', 10000, 1),
(23272, 254, 145, 'Comstock', 10000, 1),
(23273, 254, 149, 'Comstock', 10000, 1),
(23274, 254, 154, 'Comstock', 10000, 1),
(23275, 254, 165, 'Comstock', 10000, 1),
(23276, 254, 170, 'Comstock', 10000, 1),
(23277, 254, 164, 'Conasauga', 10000, 1),
(23278, 254, 165, 'Concan', 10000, 1),
(23279, 254, 165, 'Concepcion', 10000, 1),
(23280, 254, 147, 'Conception', 10000, 1),
(23281, 254, 147, 'Conception Junction', 10000, 1),
(23282, 254, 153, 'Conchas Dam', 10000, 1),
(23283, 254, 124, 'Concho', 10000, 1),
(23284, 254, 158, 'Concho', 10000, 1),
(23285, 254, 168, 'Conconully', 10000, 1),
(23286, 254, 125, 'Concord', 10000, 1),
(23287, 254, 132, 'Concord', 10000, 1),
(23288, 254, 135, 'Concord', 10000, 1),
(23289, 254, 144, 'Concord', 10000, 1),
(23290, 254, 149, 'Concord', 10000, 1),
(23291, 254, 160, 'Concord', 10000, 1),
(23292, 254, 165, 'Concord', 10000, 1),
(23293, 254, 167, 'Concord', 10000, 1),
(23294, 254, 172, 'Concord', 10000, 1),
(23295, 254, 147, 'Concordia', 10000, 1),
(23296, 254, 168, 'Concrete', 10000, 1),
(23297, 254, 134, 'Conda', 10000, 1),
(23298, 254, 163, 'Conde', 10000, 1),
(23299, 254, 148, 'Condon', 10000, 1),
(23300, 254, 159, 'Condon', 10000, 1),
(23301, 254, 146, 'Conehatta', 10000, 1),
(23302, 254, 127, 'Conejos', 10000, 1),
(23303, 254, 162, 'Conestee', 10000, 1),
(23304, 254, 160, 'Conestoga', 10000, 1),
(23305, 254, 154, 'Conesus', 10000, 1),
(23306, 254, 137, 'Conesville', 10000, 1),
(23307, 254, 157, 'Conesville', 10000, 1),
(23308, 254, 155, 'Conetoe', 10000, 1),
(23309, 254, 154, 'Conewango Valley', 10000, 1),
(23310, 254, 139, 'Confluence', 10000, 1),
(23311, 254, 160, 'Confluence', 10000, 1),
(23312, 254, 145, 'Conger', 10000, 1),
(23313, 254, 135, 'Congerville', 10000, 1),
(23314, 254, 124, 'Congress', 10000, 1),
(23315, 254, 144, 'Conklin', 10000, 1),
(23316, 254, 154, 'Conklin', 10000, 1),
(23317, 254, 132, 'Conley', 10000, 1),
(23318, 254, 160, 'Conneautville', 10000, 1),
(23319, 254, 168, 'Connell', 10000, 1),
(23320, 254, 154, 'Connelly', 10000, 1),
(23321, 254, 155, 'Connelly Springs', 10000, 1),
(23322, 254, 148, 'Conner', 10000, 1),
(23323, 254, 158, 'Connerville', 10000, 1),
(23324, 254, 160, 'Connoquenessing', 10000, 1),
(23325, 254, 157, 'Conover', 10000, 1),
(23326, 254, 170, 'Conover', 10000, 1),
(23327, 254, 142, 'Conowingo', 10000, 1),
(23328, 254, 137, 'Conrad', 10000, 1),
(23329, 254, 148, 'Conrad', 10000, 1),
(23330, 254, 147, 'Conran', 10000, 1),
(23331, 254, 170, 'Conrath', 10000, 1),
(23332, 254, 137, 'Conroy', 10000, 1),
(23333, 254, 154, 'Constable', 10000, 1),
(23334, 254, 154, 'Constableville', 10000, 1),
(23335, 254, 154, 'Constantia', 10000, 1),
(23336, 254, 157, 'Continental', 10000, 1),
(23337, 254, 153, 'Continental Divide', 10000, 1),
(23338, 254, 151, 'Contoocook', 10000, 1),
(23339, 254, 140, 'Convent', 10000, 1),
(23340, 254, 136, 'Converse', 10000, 1),
(23341, 254, 140, 'Converse', 10000, 1),
(23342, 254, 162, 'Converse', 10000, 1),
(23343, 254, 165, 'Converse', 10000, 1),
(23344, 254, 157, 'Convoy', 10000, 1),
(23345, 254, 143, 'Conway', 10000, 1),
(23346, 254, 144, 'Conway', 10000, 1),
(23347, 254, 147, 'Conway', 10000, 1),
(23348, 254, 155, 'Conway', 10000, 1),
(23349, 254, 160, 'Conway', 10000, 1),
(23350, 254, 168, 'Conway', 10000, 1),
(23351, 254, 138, 'Conway Springs', 10000, 1),
(23352, 254, 160, 'Conyngham', 10000, 1),
(23353, 254, 149, 'Cook', 10000, 1),
(23354, 254, 122, 'Cook Springs', 10000, 1),
(23355, 254, 147, 'Cook Station', 10000, 1),
(23356, 254, 148, 'Cooke City', 10000, 1),
(23357, 254, 144, 'Cooks', 10000, 1),
(23358, 254, 160, 'Cooksburg', 10000, 1),
(23359, 254, 158, 'Cookson', 10000, 1),
(23360, 254, 152, 'Cookstown', 10000, 1),
(23361, 254, 135, 'Cooksville', 10000, 1),
(23362, 254, 142, 'Cooksville', 10000, 1),
(23363, 254, 169, 'Cool Ridge', 10000, 1),
(23364, 254, 155, 'Cooleemee', 10000, 1),
(23365, 254, 132, 'Coolidge', 10000, 1),
(23366, 254, 138, 'Coolidge', 10000, 1),
(23367, 254, 165, 'Coolidge', 10000, 1),
(23368, 254, 134, 'Coolin', 10000, 1),
(23369, 254, 160, 'Coolspring', 10000, 1),
(23370, 254, 157, 'Coolville', 10000, 1),
(23371, 254, 170, 'Coon Valley', 10000, 1),
(23372, 254, 137, 'Cooper', 10000, 1),
(23373, 254, 123, 'Cooper Landing', 10000, 1),
(23374, 254, 141, 'Coopers Mills', 10000, 1),
(23375, 254, 154, 'Coopers Plains', 10000, 1),
(23376, 254, 160, 'Cooperstown', 10000, 1),
(23377, 254, 144, 'Coopersville', 10000, 1),
(23378, 254, 132, 'Coosa', 10000, 1),
(23379, 254, 122, 'Coosada', 10000, 1),
(23380, 254, 162, 'Coosawatchie', 10000, 1),
(23381, 254, 147, 'Cooter', 10000, 1),
(23382, 254, 154, 'Copake', 10000, 1),
(23383, 254, 154, 'Copake Falls', 10000, 1),
(23384, 254, 168, 'Copalis Beach', 10000, 1),
(23385, 254, 168, 'Copalis Crossing', 10000, 1),
(23386, 254, 158, 'Copan', 10000, 1),
(23387, 254, 127, 'Cope', 10000, 1),
(23388, 254, 162, 'Cope', 10000, 1),
(23389, 254, 131, 'Copeland', 10000, 1),
(23390, 254, 138, 'Copeland', 10000, 1),
(23391, 254, 144, 'Copemish', 10000, 1),
(23392, 254, 169, 'Copen', 10000, 1),
(23393, 254, 154, 'Copenhagen', 10000, 1),
(23394, 254, 165, 'Copeville', 10000, 1),
(23395, 254, 160, 'Coplay', 10000, 1),
(23396, 254, 123, 'Copper Center', 10000, 1),
(23397, 254, 144, 'Copper City', 10000, 1),
(23398, 254, 144, 'Copper Harbor', 10000, 1),
(23399, 254, 167, 'Copper Hill', 10000, 1),
(23400, 254, 164, 'Copperhill', 10000, 1),
(23401, 254, 126, 'Copperopolis', 10000, 1),
(23402, 254, 169, 'Cora', 10000, 1),
(23403, 254, 171, 'Cora', 10000, 1),
(23404, 254, 144, 'Coral', 10000, 1),
(23405, 254, 160, 'Coral', 10000, 1),
(23406, 254, 148, 'Coram', 10000, 1),
(23407, 254, 155, 'Corapeake', 10000, 1),
(23408, 254, 159, 'Corbett', 10000, 1),
(23409, 254, 154, 'Corbettsville', 10000, 1),
(23410, 254, 167, 'Corbin', 10000, 1),
(23411, 254, 126, 'Corcoran', 10000, 1),
(23412, 254, 125, 'Cord', 10000, 1),
(23413, 254, 147, 'Corder', 10000, 1),
(23414, 254, 162, 'Cordesville', 10000, 1),
(23415, 254, 122, 'Cordova', 10000, 1),
(23416, 254, 135, 'Cordova', 10000, 1),
(23417, 254, 142, 'Cordova', 10000, 1),
(23418, 254, 155, 'Cordova', 10000, 1),
(23419, 254, 149, 'Cordova', 10000, 1),
(23420, 254, 153, 'Cordova', 10000, 1),
(23421, 254, 162, 'Cordova', 10000, 1),
(23422, 254, 169, 'Core', 10000, 1),
(23423, 254, 154, 'Corfu', 10000, 1),
(23424, 254, 141, 'Corinna', 10000, 1),
(23425, 254, 166, 'Corinne', 10000, 1),
(23426, 254, 169, 'Corinne', 10000, 1),
(23427, 254, 139, 'Corinth', 10000, 1),
(23428, 254, 141, 'Corinth', 10000, 1),
(23429, 254, 154, 'Corinth', 10000, 1),
(23430, 254, 172, 'Corinth', 10000, 1),
(23431, 254, 158, 'Corn', 10000, 1),
(23432, 254, 132, 'Cornelia', 10000, 1),
(23433, 254, 155, 'Cornelius', 10000, 1),
(23434, 254, 135, 'Cornell', 10000, 1),
(23435, 254, 144, 'Cornell', 10000, 1),
(23436, 254, 170, 'Cornell', 10000, 1),
(23437, 254, 164, 'Cornersville', 10000, 1),
(23438, 254, 139, 'Cornettsville', 10000, 1),
(23439, 254, 138, 'Corning', 10000, 1),
(23440, 254, 157, 'Corning', 10000, 1),
(23441, 254, 141, 'Cornish', 10000, 1),
(23442, 254, 151, 'Cornish', 10000, 1),
(23443, 254, 166, 'Cornish', 10000, 1),
(23444, 254, 151, 'Cornish Flat', 10000, 1),
(23445, 254, 135, 'Cornland', 10000, 1),
(23446, 254, 170, 'Cornucopia', 10000, 1),
(23447, 254, 124, 'Cornville', 10000, 1),
(23448, 254, 128, 'Cornwall', 10000, 1),
(23449, 254, 154, 'Cornwall', 10000, 1),
(23450, 254, 128, 'Cornwall Bridge', 10000, 1),
(23451, 254, 154, 'Cornwall on Hudson', 10000, 1),
(23452, 254, 154, 'Cornwallville', 10000, 1),
(23453, 254, 153, 'Corona', 10000, 1),
(23454, 254, 154, 'Corona', 10000, 1),
(23455, 254, 163, 'Corona', 10000, 1),
(23456, 254, 134, 'Corral', 10000, 1),
(23457, 254, 153, 'Corrales', 10000, 1),
(23458, 254, 137, 'Correctionville', 10000, 1),
(23459, 254, 145, 'Correll', 10000, 1),
(23460, 254, 165, 'Corrigan', 10000, 1),
(23461, 254, 142, 'Corriganville', 10000, 1),
(23462, 254, 164, 'Corryton', 10000, 1),
(23463, 254, 160, 'Corsica', 10000, 1),
(23464, 254, 124, 'Cortaro', 10000, 1),
(23465, 254, 131, 'Cortez', 10000, 1),
(23466, 254, 135, 'Cortland', 10000, 1),
(23467, 254, 136, 'Cortland', 10000, 1),
(23468, 254, 149, 'Cortland', 10000, 1),
(23469, 254, 157, 'Cortland', 10000, 1),
(23470, 254, 154, 'Cortlandt Manor', 10000, 1),
(23471, 254, 136, 'Corunna', 10000, 1),
(23472, 254, 148, 'Corvallis', 10000, 1),
(23473, 254, 137, 'Corwith', 10000, 1),
(23474, 254, 127, 'Cory', 10000, 1),
(23475, 254, 136, 'Cory', 10000, 1),
(23476, 254, 128, 'Cos Cob', 10000, 1),
(23477, 254, 147, 'Cosby', 10000, 1),
(23478, 254, 164, 'Cosby', 10000, 1),
(23479, 254, 154, 'Cossayuna', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(23480, 254, 165, 'Cost', 10000, 1),
(23481, 254, 169, 'Costa', 10000, 1),
(23482, 254, 141, 'Costigan', 10000, 1),
(23483, 254, 153, 'Costilla', 10000, 1),
(23484, 254, 127, 'Cotopaxi', 10000, 1),
(23485, 254, 164, 'Cottage Grove', 10000, 1),
(23486, 254, 170, 'Cottage Grove', 10000, 1),
(23487, 254, 169, 'Cottageville', 10000, 1),
(23488, 254, 154, 'Cottekill', 10000, 1),
(23489, 254, 125, 'Cotter', 10000, 1),
(23490, 254, 132, 'Cotton', 10000, 1),
(23491, 254, 145, 'Cotton', 10000, 1),
(23492, 254, 165, 'Cotton Center', 10000, 1),
(23493, 254, 125, 'Cotton Plant', 10000, 1),
(23494, 254, 140, 'Cotton Valley', 10000, 1),
(23495, 254, 122, 'Cottondale', 10000, 1),
(23496, 254, 140, 'Cottonport', 10000, 1),
(23497, 254, 122, 'Cottonton', 10000, 1),
(23498, 254, 164, 'Cottontown', 10000, 1),
(23499, 254, 122, 'Cottonwood', 10000, 1),
(23500, 254, 145, 'Cottonwood', 10000, 1),
(23501, 254, 143, 'Cotuit', 10000, 1),
(23502, 254, 147, 'Couch', 10000, 1),
(23503, 254, 170, 'Couderay', 10000, 1),
(23504, 254, 168, 'Cougar', 10000, 1),
(23505, 254, 168, 'Coulee City', 10000, 1),
(23506, 254, 168, 'Coulee Dam', 10000, 1),
(23507, 254, 137, 'Coulter', 10000, 1),
(23508, 254, 160, 'Coulters', 10000, 1),
(23509, 254, 126, 'Coulterville', 10000, 1),
(23510, 254, 135, 'Coulterville', 10000, 1),
(23511, 254, 164, 'Counce', 10000, 1),
(23512, 254, 134, 'Council', 10000, 1),
(23513, 254, 155, 'Council', 10000, 1),
(23514, 254, 158, 'Council Hill', 10000, 1),
(23515, 254, 153, 'Counselor', 10000, 1),
(23516, 254, 135, 'Country Club Hills', 10000, 1),
(23517, 254, 158, 'Countyline', 10000, 1),
(23518, 254, 165, 'Coupland', 10000, 1),
(23519, 254, 160, 'Coupon', 10000, 1),
(23520, 254, 156, 'Courtenay', 10000, 1),
(23521, 254, 122, 'Courtland', 10000, 1),
(23522, 254, 126, 'Courtland', 10000, 1),
(23523, 254, 138, 'Courtland', 10000, 1),
(23524, 254, 145, 'Courtland', 10000, 1),
(23525, 254, 146, 'Courtland', 10000, 1),
(23526, 254, 125, 'Cove', 10000, 1),
(23527, 254, 155, 'Cove City', 10000, 1),
(23528, 254, 169, 'Covel', 10000, 1),
(23529, 254, 126, 'Covelo', 10000, 1),
(23530, 254, 161, 'Coventry', 10000, 1),
(23531, 254, 172, 'Coventry', 10000, 1),
(23532, 254, 144, 'Covert', 10000, 1),
(23533, 254, 167, 'Covesville', 10000, 1),
(23534, 254, 144, 'Covington', 10000, 1),
(23535, 254, 158, 'Covington', 10000, 1),
(23536, 254, 160, 'Covington', 10000, 1),
(23537, 254, 165, 'Covington', 10000, 1),
(23538, 254, 164, 'Cowan', 10000, 1),
(23539, 254, 160, 'Cowanesque', 10000, 1),
(23540, 254, 160, 'Cowansville', 10000, 1),
(23541, 254, 162, 'Coward', 10000, 1),
(23542, 254, 122, 'Cowarts', 10000, 1),
(23543, 254, 135, 'Cowden', 10000, 1),
(23544, 254, 127, 'Cowdrey', 10000, 1),
(23545, 254, 169, 'Cowen', 10000, 1),
(23546, 254, 158, 'Coweta', 10000, 1),
(23547, 254, 147, 'Cowgill', 10000, 1),
(23548, 254, 168, 'Cowiche', 10000, 1),
(23549, 254, 154, 'Cowlesville', 10000, 1),
(23550, 254, 171, 'Cowley', 10000, 1),
(23551, 254, 139, 'Coxs Creek', 10000, 1),
(23552, 254, 169, 'Coxs Mills', 10000, 1),
(23553, 254, 154, 'Coxsackie', 10000, 1),
(23554, 254, 122, 'Coy', 10000, 1),
(23555, 254, 125, 'Coy', 10000, 1),
(23556, 254, 165, 'Coyanosa', 10000, 1),
(23557, 254, 158, 'Coyle', 10000, 1),
(23558, 254, 126, 'Coyote', 10000, 1),
(23559, 254, 153, 'Coyote', 10000, 1),
(23560, 254, 138, 'Coyville', 10000, 1),
(23561, 254, 149, 'Cozad', 10000, 1),
(23562, 254, 139, 'Crab Orchard', 10000, 1),
(23563, 254, 149, 'Crab Orchard', 10000, 1),
(23564, 254, 164, 'Crab Orchard', 10000, 1),
(23565, 254, 169, 'Crab Orchard', 10000, 1),
(23566, 254, 159, 'Crabtree', 10000, 1),
(23567, 254, 160, 'Crabtree', 10000, 1),
(23568, 254, 167, 'Craddockville', 10000, 1),
(23569, 254, 172, 'Craftsbury', 10000, 1),
(23570, 254, 172, 'Craftsbury Common', 10000, 1),
(23571, 254, 122, 'Cragford', 10000, 1),
(23572, 254, 154, 'Cragsmoor', 10000, 1),
(23573, 254, 137, 'Craig', 10000, 1),
(23574, 254, 147, 'Craig', 10000, 1),
(23575, 254, 149, 'Craig', 10000, 1),
(23576, 254, 134, 'Craigmont', 10000, 1),
(23577, 254, 167, 'Craigsville', 10000, 1),
(23578, 254, 169, 'Craigsville', 10000, 1),
(23579, 254, 136, 'Craigville', 10000, 1),
(23580, 254, 160, 'Craley', 10000, 1),
(23581, 254, 155, 'Cramerton', 10000, 1),
(23582, 254, 160, 'Cranberry', 10000, 1),
(23583, 254, 141, 'Cranberry Isles', 10000, 1),
(23584, 254, 154, 'Cranberry Lake', 10000, 1),
(23585, 254, 132, 'Crandall', 10000, 1),
(23586, 254, 136, 'Crandall', 10000, 1),
(23587, 254, 165, 'Crandall', 10000, 1),
(23588, 254, 147, 'Crane', 10000, 1),
(23589, 254, 148, 'Crane', 10000, 1),
(23590, 254, 159, 'Crane', 10000, 1),
(23591, 254, 122, 'Crane Hill', 10000, 1),
(23592, 254, 145, 'Crane Lake', 10000, 1),
(23593, 254, 160, 'Cranesville', 10000, 1),
(23594, 254, 165, 'Cranfills Gap', 10000, 1),
(23595, 254, 139, 'Cranks', 10000, 1),
(23596, 254, 142, 'Crapo', 10000, 1),
(23597, 254, 156, 'Crary', 10000, 1),
(23598, 254, 154, 'Craryville', 10000, 1),
(23599, 254, 159, 'Crater Lake', 10000, 1),
(23600, 254, 127, 'Crawford', 10000, 1),
(23601, 254, 132, 'Crawford', 10000, 1),
(23602, 254, 146, 'Crawford', 10000, 1),
(23603, 254, 149, 'Crawford', 10000, 1),
(23604, 254, 158, 'Crawford', 10000, 1),
(23605, 254, 164, 'Crawford', 10000, 1),
(23606, 254, 165, 'Crawford', 10000, 1),
(23607, 254, 169, 'Crawford', 10000, 1),
(23608, 254, 125, 'Crawfordsville', 10000, 1),
(23609, 254, 137, 'Crawfordsville', 10000, 1),
(23610, 254, 159, 'Crawfordsville', 10000, 1),
(23611, 254, 169, 'Crawley', 10000, 1),
(23612, 254, 139, 'Crayne', 10000, 1),
(23613, 254, 135, 'Creal Springs', 10000, 1),
(23614, 254, 152, 'Cream Ridge', 10000, 1),
(23615, 254, 160, 'Creamery', 10000, 1),
(23616, 254, 127, 'Creede', 10000, 1),
(23617, 254, 155, 'Creedmoor', 10000, 1),
(23618, 254, 160, 'Creekside', 10000, 1),
(23619, 254, 147, 'Creighton', 10000, 1),
(23620, 254, 149, 'Creighton', 10000, 1),
(23621, 254, 160, 'Creighton', 10000, 1),
(23622, 254, 163, 'Creighton', 10000, 1),
(23623, 254, 146, 'Crenshaw', 10000, 1),
(23624, 254, 122, 'Creola', 10000, 1),
(23625, 254, 157, 'Creola', 10000, 1),
(23626, 254, 140, 'Creole', 10000, 1),
(23627, 254, 163, 'Cresbard', 10000, 1),
(23628, 254, 132, 'Crescent', 10000, 1),
(23629, 254, 137, 'Crescent', 10000, 1),
(23630, 254, 158, 'Crescent', 10000, 1),
(23631, 254, 159, 'Crescent', 10000, 1),
(23632, 254, 160, 'Crescent', 10000, 1),
(23633, 254, 131, 'Crescent City', 10000, 1),
(23634, 254, 135, 'Crescent City', 10000, 1),
(23635, 254, 159, 'Crescent Lake', 10000, 1),
(23636, 254, 126, 'Crescent Mills', 10000, 1),
(23637, 254, 150, 'Crescent Valley', 10000, 1),
(23638, 254, 160, 'Cresco', 10000, 1),
(23639, 254, 126, 'Cressey', 10000, 1),
(23640, 254, 152, 'Cresskill', 10000, 1),
(23641, 254, 165, 'Cresson', 10000, 1),
(23642, 254, 160, 'Cressona', 10000, 1),
(23643, 254, 126, 'Crest Park', 10000, 1),
(23644, 254, 138, 'Crestline', 10000, 1),
(23645, 254, 157, 'Crestline', 10000, 1),
(23646, 254, 135, 'Creston', 10000, 1),
(23647, 254, 155, 'Creston', 10000, 1),
(23648, 254, 149, 'Creston', 10000, 1),
(23649, 254, 157, 'Creston', 10000, 1),
(23650, 254, 168, 'Creston', 10000, 1),
(23651, 254, 169, 'Creston', 10000, 1),
(23652, 254, 127, 'Crestone', 10000, 1),
(23653, 254, 155, 'Creswell', 10000, 1),
(23654, 254, 159, 'Creswell', 10000, 1),
(23655, 254, 135, 'Crete', 10000, 1),
(23656, 254, 135, 'Creve Coeur', 10000, 1),
(23657, 254, 169, 'Crichton', 10000, 1),
(23658, 254, 167, 'Criders', 10000, 1),
(23659, 254, 167, 'Crimora', 10000, 1),
(23660, 254, 167, 'Cripple Creek', 10000, 1),
(23661, 254, 139, 'Crittenden', 10000, 1),
(23662, 254, 154, 'Crittenden', 10000, 1),
(23663, 254, 167, 'Critz', 10000, 1),
(23664, 254, 170, 'Crivitz', 10000, 1),
(23665, 254, 142, 'Crocheron', 10000, 1),
(23666, 254, 147, 'Crocker', 10000, 1),
(23667, 254, 139, 'Crockett', 10000, 1),
(23668, 254, 167, 'Crockett', 10000, 1),
(23669, 254, 125, 'Crocketts Bluff', 10000, 1),
(23670, 254, 162, 'Crocketville', 10000, 1),
(23671, 254, 139, 'Crofton', 10000, 1),
(23672, 254, 149, 'Crofton', 10000, 1),
(23673, 254, 154, 'Croghan', 10000, 1),
(23674, 254, 139, 'Cromona', 10000, 1),
(23675, 254, 154, 'Crompond', 10000, 1),
(23676, 254, 122, 'Cromwell', 10000, 1),
(23677, 254, 137, 'Cromwell', 10000, 1),
(23678, 254, 139, 'Cromwell', 10000, 1),
(23679, 254, 145, 'Cromwell', 10000, 1),
(23680, 254, 158, 'Cromwell', 10000, 1),
(23681, 254, 127, 'Crook', 10000, 1),
(23682, 254, 123, 'Crooked Creek', 10000, 1),
(23683, 254, 163, 'Crooks', 10000, 1),
(23684, 254, 149, 'Crookston', 10000, 1),
(23685, 254, 157, 'Crooksville', 10000, 1),
(23686, 254, 135, 'Cropsey', 10000, 1),
(23687, 254, 154, 'Cropseyville', 10000, 1),
(23688, 254, 122, 'Cropwell', 10000, 1),
(23689, 254, 146, 'Crosby', 10000, 1),
(23690, 254, 160, 'Crosby', 10000, 1),
(23691, 254, 162, 'Cross', 10000, 1),
(23692, 254, 162, 'Cross Anchor', 10000, 1),
(23693, 254, 160, 'Cross Fork', 10000, 1),
(23694, 254, 162, 'Cross Hill', 10000, 1),
(23695, 254, 167, 'Cross Junction', 10000, 1),
(23696, 254, 136, 'Cross Plains', 10000, 1),
(23697, 254, 164, 'Cross Plains', 10000, 1),
(23698, 254, 165, 'Cross Plains', 10000, 1),
(23699, 254, 154, 'Cross River', 10000, 1),
(23700, 254, 147, 'Cross Timbers', 10000, 1),
(23701, 254, 144, 'Cross Village', 10000, 1),
(23702, 254, 145, 'Crosslake', 10000, 1),
(23703, 254, 155, 'Crossnore', 10000, 1),
(23704, 254, 153, 'Crossroads', 10000, 1),
(23705, 254, 122, 'Crossville', 10000, 1),
(23706, 254, 135, 'Crossville', 10000, 1),
(23707, 254, 152, 'Crosswicks', 10000, 1),
(23708, 254, 136, 'Crothersville', 10000, 1),
(23709, 254, 157, 'Croton', 10000, 1),
(23710, 254, 154, 'Croton Falls', 10000, 1),
(23711, 254, 154, 'Croton on Hudson', 10000, 1),
(23712, 254, 155, 'Crouse', 10000, 1),
(23713, 254, 141, 'Crouseville', 10000, 1),
(23714, 254, 148, 'Crow Agency', 10000, 1),
(23715, 254, 146, 'Crowder', 10000, 1),
(23716, 254, 158, 'Crowder', 10000, 1),
(23717, 254, 171, 'Crowheart', 10000, 1),
(23718, 254, 127, 'Crowley', 10000, 1),
(23719, 254, 160, 'Crown', 10000, 1),
(23720, 254, 157, 'Crown City', 10000, 1),
(23721, 254, 124, 'Crown King', 10000, 1),
(23722, 254, 154, 'Crown Point', 10000, 1),
(23723, 254, 126, 'Crows Landing', 10000, 1),
(23724, 254, 140, 'Crowville', 10000, 1),
(23725, 254, 160, 'Croydon', 10000, 1),
(23726, 254, 166, 'Croydon', 10000, 1),
(23727, 254, 167, 'Crozet', 10000, 1),
(23728, 254, 167, 'Crozier', 10000, 1),
(23729, 254, 160, 'Crucible', 10000, 1),
(23730, 254, 146, 'Cruger', 10000, 1),
(23731, 254, 169, 'Crum', 10000, 1),
(23732, 254, 160, 'Crum Lynne', 10000, 1),
(23733, 254, 155, 'Crumpler', 10000, 1),
(23734, 254, 169, 'Crumpler', 10000, 1),
(23735, 254, 142, 'Crumpton', 10000, 1),
(23736, 254, 125, 'Crumrod', 10000, 1),
(23737, 254, 144, 'Crystal', 10000, 1),
(23738, 254, 156, 'Crystal', 10000, 1),
(23739, 254, 145, 'Crystal Bay', 10000, 1),
(23740, 254, 150, 'Crystal Bay', 10000, 1),
(23741, 254, 131, 'Crystal Beach', 10000, 1),
(23742, 254, 167, 'Crystal Hill', 10000, 1),
(23743, 254, 137, 'Crystal Lake', 10000, 1),
(23744, 254, 160, 'Crystal Spring', 10000, 1),
(23745, 254, 131, 'Crystal Springs', 10000, 1),
(23746, 254, 139, 'Cub Run', 10000, 1),
(23747, 254, 122, 'Cuba', 10000, 1),
(23748, 254, 135, 'Cuba', 10000, 1),
(23749, 254, 138, 'Cuba', 10000, 1),
(23750, 254, 153, 'Cuba', 10000, 1),
(23751, 254, 154, 'Cuba', 10000, 1),
(23752, 254, 157, 'Cuba', 10000, 1),
(23753, 254, 170, 'Cuba City', 10000, 1),
(23754, 254, 153, 'Cubero', 10000, 1),
(23755, 254, 169, 'Cucumber', 10000, 1),
(23756, 254, 170, 'Cudahy', 10000, 1),
(23757, 254, 154, 'Cuddebackville', 10000, 1),
(23758, 254, 160, 'Cuddy', 10000, 1),
(23759, 254, 153, 'Cuervo', 10000, 1),
(23760, 254, 155, 'Culberson', 10000, 1),
(23761, 254, 148, 'Culbertson', 10000, 1),
(23762, 254, 134, 'Culdesac', 10000, 1),
(23763, 254, 140, 'Cullen', 10000, 1),
(23764, 254, 167, 'Cullen', 10000, 1),
(23765, 254, 164, 'Culleoka', 10000, 1),
(23766, 254, 132, 'Culloden', 10000, 1),
(23767, 254, 169, 'Culloden', 10000, 1),
(23768, 254, 135, 'Cullom', 10000, 1),
(23769, 254, 159, 'Culp Creek', 10000, 1),
(23770, 254, 159, 'Culver', 10000, 1),
(23771, 254, 137, 'Cumberland', 10000, 1),
(23772, 254, 139, 'Cumberland', 10000, 1),
(23773, 254, 155, 'Cumberland', 10000, 1),
(23774, 254, 157, 'Cumberland', 10000, 1),
(23775, 254, 161, 'Cumberland', 10000, 1),
(23776, 254, 170, 'Cumberland', 10000, 1),
(23777, 254, 141, 'Cumberland Center', 10000, 1),
(23778, 254, 164, 'Cumberland City', 10000, 1),
(23779, 254, 141, 'Cumberland Foreside', 10000, 1),
(23780, 254, 164, 'Cumberland Furnace', 10000, 1),
(23781, 254, 164, 'Cumberland Gap', 10000, 1),
(23782, 254, 160, 'Cumbola', 10000, 1),
(23783, 254, 143, 'Cummaquid', 10000, 1),
(23784, 254, 137, 'Cumming', 10000, 1),
(23785, 254, 138, 'Cummings', 10000, 1),
(23786, 254, 156, 'Cummings', 10000, 1),
(23787, 254, 143, 'Cummington', 10000, 1),
(23788, 254, 155, 'Cumnock', 10000, 1),
(23789, 254, 165, 'Cuney', 10000, 1),
(23790, 254, 138, 'Cunningham', 10000, 1),
(23791, 254, 139, 'Cunningham', 10000, 1),
(23792, 254, 164, 'Cunningham', 10000, 1),
(23793, 254, 165, 'Cunningham', 10000, 1),
(23794, 254, 168, 'Cunningham', 10000, 1),
(23795, 254, 139, 'Curdsville', 10000, 1),
(23796, 254, 137, 'Curlew', 10000, 1),
(23797, 254, 160, 'Curllsville', 10000, 1),
(23798, 254, 144, 'Curran', 10000, 1),
(23799, 254, 145, 'Currie', 10000, 1),
(23800, 254, 155, 'Currie', 10000, 1),
(23801, 254, 147, 'Curryville', 10000, 1),
(23802, 254, 160, 'Curryville', 10000, 1),
(23803, 254, 157, 'Curtice', 10000, 1),
(23804, 254, 159, 'Curtin', 10000, 1),
(23805, 254, 125, 'Curtis', 10000, 1),
(23806, 254, 144, 'Curtis', 10000, 1),
(23807, 254, 149, 'Curtis', 10000, 1),
(23808, 254, 168, 'Curtis', 10000, 1),
(23809, 254, 142, 'Curtis Bay', 10000, 1),
(23810, 254, 170, 'Curtiss', 10000, 1),
(23811, 254, 160, 'Curtisville', 10000, 1),
(23812, 254, 137, 'Cushing', 10000, 1),
(23813, 254, 141, 'Cushing', 10000, 1),
(23814, 254, 145, 'Cushing', 10000, 1),
(23815, 254, 158, 'Cushing', 10000, 1),
(23816, 254, 165, 'Cushing', 10000, 1),
(23817, 254, 170, 'Cushing', 10000, 1),
(23818, 254, 125, 'Cushman', 10000, 1),
(23819, 254, 168, 'Cusick', 10000, 1),
(23820, 254, 122, 'Cusseta', 10000, 1),
(23821, 254, 157, 'Custar', 10000, 1),
(23822, 254, 139, 'Custer', 10000, 1),
(23823, 254, 144, 'Custer', 10000, 1),
(23824, 254, 148, 'Custer', 10000, 1),
(23825, 254, 168, 'Custer', 10000, 1),
(23826, 254, 170, 'Custer', 10000, 1),
(23827, 254, 158, 'Custer City', 10000, 1),
(23828, 254, 160, 'Custer City', 10000, 1),
(23829, 254, 154, 'Cutchogue', 10000, 1),
(23830, 254, 126, 'Cutler', 10000, 1),
(23831, 254, 135, 'Cutler', 10000, 1),
(23832, 254, 136, 'Cutler', 10000, 1),
(23833, 254, 141, 'Cutler', 10000, 1),
(23834, 254, 157, 'Cutler', 10000, 1),
(23835, 254, 126, 'Cutten', 10000, 1),
(23836, 254, 172, 'Cuttingsville', 10000, 1),
(23837, 254, 143, 'Cuttyhunk', 10000, 1),
(23838, 254, 160, 'Cyclone', 10000, 1),
(23839, 254, 169, 'Cyclone', 10000, 1),
(23840, 254, 157, 'Cygnet', 10000, 1),
(23841, 254, 137, 'Cylinder', 10000, 1),
(23842, 254, 136, 'Cynthiana', 10000, 1),
(23843, 254, 157, 'Cynthiana', 10000, 1),
(23844, 254, 131, 'Cypress', 10000, 1),
(23845, 254, 135, 'Cypress', 10000, 1),
(23846, 254, 158, 'Cyril', 10000, 1),
(23847, 254, 145, 'Cyrus', 10000, 1),
(23848, 254, 165, 'D Hanis', 10000, 1),
(23849, 254, 146, 'D Lo', 10000, 1),
(23850, 254, 139, 'Dabolt', 10000, 1),
(23851, 254, 158, 'Dacoma', 10000, 1),
(23852, 254, 127, 'Dacono', 10000, 1),
(23853, 254, 132, 'Dacula', 10000, 1),
(23854, 254, 147, 'Dadeville', 10000, 1),
(23855, 254, 144, 'Dafter', 10000, 1),
(23856, 254, 126, 'Daggett', 10000, 1),
(23857, 254, 144, 'Daggett', 10000, 1),
(23858, 254, 148, 'Dagmar', 10000, 1),
(23859, 254, 129, 'Dagsboro', 10000, 1),
(23860, 254, 160, 'Dagus Mines', 10000, 1),
(23861, 254, 135, 'Dahinda', 10000, 1),
(23862, 254, 156, 'Dahlen', 10000, 1),
(23863, 254, 135, 'Dahlgren', 10000, 1),
(23864, 254, 167, 'Dahlgren', 10000, 1),
(23865, 254, 169, 'Dailey', 10000, 1),
(23866, 254, 159, 'Dairy', 10000, 1),
(23867, 254, 165, 'Daisetta', 10000, 1),
(23868, 254, 132, 'Daisy', 10000, 1),
(23869, 254, 147, 'Daisy', 10000, 1),
(23870, 254, 158, 'Daisy', 10000, 1),
(23871, 254, 160, 'Daisytown', 10000, 1),
(23872, 254, 135, 'Dakota', 10000, 1),
(23873, 254, 145, 'Dakota', 10000, 1),
(23874, 254, 137, 'Dakota City', 10000, 1),
(23875, 254, 145, 'Dalbo', 10000, 1),
(23876, 254, 135, 'Dale', 10000, 1),
(23877, 254, 136, 'Dale', 10000, 1),
(23878, 254, 154, 'Dale', 10000, 1),
(23879, 254, 162, 'Dale', 10000, 1),
(23880, 254, 170, 'Dale', 10000, 1),
(23881, 254, 136, 'Daleville', 10000, 1),
(23882, 254, 146, 'Daleville', 10000, 1),
(23883, 254, 167, 'Daleville', 10000, 1),
(23884, 254, 165, 'Dallardsville', 10000, 1),
(23885, 254, 137, 'Dallas', 10000, 1),
(23886, 254, 155, 'Dallas', 10000, 1),
(23887, 254, 163, 'Dallas', 10000, 1),
(23888, 254, 170, 'Dallas', 10000, 1),
(23889, 254, 169, 'Dallas', 10000, 1),
(23890, 254, 137, 'Dallas Center', 10000, 1),
(23891, 254, 135, 'Dallas City', 10000, 1),
(23892, 254, 168, 'Dallesport', 10000, 1),
(23893, 254, 160, 'Dalmatia', 10000, 1),
(23894, 254, 143, 'Dalton', 10000, 1),
(23895, 254, 145, 'Dalton', 10000, 1),
(23896, 254, 147, 'Dalton', 10000, 1),
(23897, 254, 149, 'Dalton', 10000, 1),
(23898, 254, 154, 'Dalton', 10000, 1),
(23899, 254, 157, 'Dalton', 10000, 1),
(23900, 254, 160, 'Dalton', 10000, 1),
(23901, 254, 170, 'Dalton', 10000, 1),
(23902, 254, 135, 'Dalton City', 10000, 1),
(23903, 254, 135, 'Dalzell', 10000, 1),
(23904, 254, 162, 'Dalzell', 10000, 1),
(23905, 254, 138, 'Damar', 10000, 1),
(23906, 254, 125, 'Damascus', 10000, 1),
(23907, 254, 132, 'Damascus', 10000, 1),
(23908, 254, 157, 'Damascus', 10000, 1),
(23909, 254, 160, 'Damascus', 10000, 1),
(23910, 254, 167, 'Damascus', 10000, 1),
(23911, 254, 166, 'Dammeron Valley', 10000, 1),
(23912, 254, 165, 'Damon', 10000, 1),
(23913, 254, 137, 'Dana', 10000, 1),
(23914, 254, 135, 'Dana', 10000, 1),
(23915, 254, 136, 'Dana', 10000, 1),
(23916, 254, 139, 'Dana', 10000, 1),
(23917, 254, 155, 'Dana', 10000, 1),
(23918, 254, 160, 'Danboro', 10000, 1),
(23919, 254, 137, 'Danbury', 10000, 1),
(23920, 254, 149, 'Danbury', 10000, 1),
(23921, 254, 151, 'Danbury', 10000, 1),
(23922, 254, 165, 'Danbury', 10000, 1),
(23923, 254, 170, 'Danbury', 10000, 1),
(23924, 254, 172, 'Danby', 10000, 1),
(23925, 254, 165, 'Danciger', 10000, 1),
(23926, 254, 164, 'Dandridge', 10000, 1),
(23927, 254, 170, 'Dane', 10000, 1),
(23928, 254, 169, 'Danese', 10000, 1),
(23929, 254, 165, 'Danevang', 10000, 1),
(23930, 254, 135, 'Danforth', 10000, 1),
(23931, 254, 141, 'Danforth', 10000, 1),
(23932, 254, 171, 'Daniel', 10000, 1),
(23933, 254, 169, 'Daniels', 10000, 1),
(23934, 254, 128, 'Danielson', 10000, 1),
(23935, 254, 160, 'Danielsville', 10000, 1),
(23936, 254, 149, 'Dannebrog', 10000, 1),
(23937, 254, 154, 'Dannemora', 10000, 1),
(23938, 254, 144, 'Dansville', 10000, 1),
(23939, 254, 163, 'Dante', 10000, 1),
(23940, 254, 167, 'Dante', 10000, 1),
(23941, 254, 145, 'Danube', 10000, 1),
(23942, 254, 135, 'Danvers', 10000, 1),
(23943, 254, 145, 'Danvers', 10000, 1),
(23944, 254, 122, 'Danville', 10000, 1),
(23945, 254, 132, 'Danville', 10000, 1),
(23946, 254, 137, 'Danville', 10000, 1),
(23947, 254, 136, 'Danville', 10000, 1),
(23948, 254, 138, 'Danville', 10000, 1),
(23949, 254, 141, 'Danville', 10000, 1),
(23950, 254, 151, 'Danville', 10000, 1),
(23951, 254, 157, 'Danville', 10000, 1),
(23952, 254, 172, 'Danville', 10000, 1),
(23953, 254, 168, 'Danville', 10000, 1),
(23954, 254, 148, 'Darby', 10000, 1),
(23955, 254, 126, 'Dardanelle', 10000, 1),
(23956, 254, 164, 'Darden', 10000, 1),
(23957, 254, 145, 'Darfur', 10000, 1),
(23958, 254, 128, 'Darien', 10000, 1),
(23959, 254, 154, 'Darien Center', 10000, 1),
(23960, 254, 146, 'Darling', 10000, 1),
(23961, 254, 136, 'Darlington', 10000, 1),
(23962, 254, 142, 'Darlington', 10000, 1),
(23963, 254, 147, 'Darlington', 10000, 1),
(23964, 254, 160, 'Darlington', 10000, 1),
(23965, 254, 162, 'Darlington', 10000, 1),
(23966, 254, 160, 'Darragh', 10000, 1),
(23967, 254, 165, 'Darrouzett', 10000, 1),
(23968, 254, 140, 'Darrow', 10000, 1),
(23969, 254, 126, 'Darwin', 10000, 1),
(23970, 254, 145, 'Darwin', 10000, 1),
(23971, 254, 124, 'Dateland', 10000, 1),
(23972, 254, 153, 'Datil', 10000, 1),
(23973, 254, 125, 'Datto', 10000, 1),
(23974, 254, 162, 'Daufuskie Island', 10000, 1),
(23975, 254, 160, 'Dauphin', 10000, 1),
(23976, 254, 122, 'Dauphin Island', 10000, 1),
(23977, 254, 140, 'Davant', 10000, 1),
(23978, 254, 126, 'Davenport', 10000, 1),
(23979, 254, 131, 'Davenport', 10000, 1),
(23980, 254, 156, 'Davenport', 10000, 1),
(23981, 254, 149, 'Davenport', 10000, 1),
(23982, 254, 154, 'Davenport', 10000, 1),
(23983, 254, 158, 'Davenport', 10000, 1),
(23984, 254, 167, 'Davenport', 10000, 1),
(23985, 254, 154, 'Davenport Center', 10000, 1),
(23986, 254, 149, 'Davey', 10000, 1),
(23987, 254, 139, 'David', 10000, 1),
(23988, 254, 155, 'Davidson', 10000, 1),
(23989, 254, 158, 'Davidson', 10000, 1),
(23990, 254, 142, 'Davidsonville', 10000, 1),
(23991, 254, 160, 'Davidsville', 10000, 1),
(23992, 254, 165, 'Davilla', 10000, 1),
(23993, 254, 169, 'Davin', 10000, 1),
(23994, 254, 135, 'Davis', 10000, 1),
(23995, 254, 155, 'Davis', 10000, 1),
(23996, 254, 158, 'Davis', 10000, 1),
(23997, 254, 163, 'Davis', 10000, 1),
(23998, 254, 169, 'Davis', 10000, 1),
(23999, 254, 137, 'Davis City', 10000, 1),
(24000, 254, 126, 'Davis Creek', 10000, 1),
(24001, 254, 135, 'Davis Junction', 10000, 1),
(24002, 254, 162, 'Davis Station', 10000, 1),
(24003, 254, 167, 'Davis Wharf', 10000, 1),
(24004, 254, 132, 'Davisboro', 10000, 1),
(24005, 254, 144, 'Davisburg', 10000, 1),
(24006, 254, 122, 'Daviston', 10000, 1),
(24007, 254, 147, 'Davisville', 10000, 1),
(24008, 254, 169, 'Davisville', 10000, 1),
(24009, 254, 169, 'Davy', 10000, 1),
(24010, 254, 169, 'Dawes', 10000, 1),
(24011, 254, 147, 'Dawn', 10000, 1),
(24012, 254, 165, 'Dawn', 10000, 1),
(24013, 254, 122, 'Dawson', 10000, 1),
(24014, 254, 137, 'Dawson', 10000, 1),
(24015, 254, 135, 'Dawson', 10000, 1),
(24016, 254, 156, 'Dawson', 10000, 1),
(24017, 254, 149, 'Dawson', 10000, 1),
(24018, 254, 160, 'Dawson', 10000, 1),
(24019, 254, 165, 'Dawson', 10000, 1),
(24020, 254, 131, 'Day', 10000, 1),
(24021, 254, 139, 'Dayhoit', 10000, 1),
(24022, 254, 149, 'Daykin', 10000, 1),
(24023, 254, 159, 'Days Creek', 10000, 1),
(24024, 254, 137, 'Dayton', 10000, 1),
(24025, 254, 134, 'Dayton', 10000, 1),
(24026, 254, 136, 'Dayton', 10000, 1),
(24027, 254, 139, 'Dayton', 10000, 1),
(24028, 254, 142, 'Dayton', 10000, 1),
(24029, 254, 145, 'Dayton', 10000, 1),
(24030, 254, 148, 'Dayton', 10000, 1),
(24031, 254, 150, 'Dayton', 10000, 1),
(24032, 254, 154, 'Dayton', 10000, 1),
(24033, 254, 160, 'Dayton', 10000, 1),
(24034, 254, 165, 'Dayton', 10000, 1),
(24035, 254, 167, 'Dayton', 10000, 1),
(24036, 254, 168, 'Dayton', 10000, 1),
(24037, 254, 171, 'Dayton', 10000, 1),
(24038, 254, 128, 'Dayville', 10000, 1),
(24039, 254, 159, 'Dayville', 10000, 1),
(24040, 254, 156, 'Dazey', 10000, 1),
(24041, 254, 122, 'De Armanville', 10000, 1),
(24042, 254, 127, 'De Beque', 10000, 1),
(24043, 254, 165, 'De Berry', 10000, 1),
(24044, 254, 148, 'De Borgia', 10000, 1),
(24045, 254, 157, 'De Graff', 10000, 1),
(24046, 254, 147, 'De Kalb', 10000, 1),
(24047, 254, 165, 'De Kalb', 10000, 1),
(24048, 254, 154, 'De Kalb Junction', 10000, 1),
(24049, 254, 154, 'De Lancey', 10000, 1),
(24050, 254, 160, 'De Lancey', 10000, 1),
(24051, 254, 135, 'De Land', 10000, 1),
(24052, 254, 165, 'De Leon', 10000, 1),
(24053, 254, 131, 'De Leon Springs', 10000, 1),
(24054, 254, 139, 'De Mossville', 10000, 1),
(24055, 254, 154, 'De Peyster', 10000, 1),
(24056, 254, 154, 'De Ruyter', 10000, 1),
(24057, 254, 132, 'De Soto', 10000, 1),
(24058, 254, 137, 'De Soto', 10000, 1),
(24059, 254, 135, 'De Soto', 10000, 1),
(24060, 254, 138, 'De Soto', 10000, 1),
(24061, 254, 144, 'De Tour Village', 10000, 1),
(24062, 254, 125, 'De Valls Bluff', 10000, 1),
(24063, 254, 137, 'De Witt', 10000, 1),
(24064, 254, 147, 'De Witt', 10000, 1),
(24065, 254, 149, 'De Witt', 10000, 1),
(24066, 254, 160, 'De Young', 10000, 1),
(24067, 254, 159, 'Deadwood', 10000, 1),
(24068, 254, 152, 'Deal', 10000, 1),
(24069, 254, 142, 'Deal Island', 10000, 1),
(24070, 254, 139, 'Deane', 10000, 1),
(24071, 254, 154, 'Deansboro', 10000, 1),
(24072, 254, 165, 'Deanville', 10000, 1),
(24073, 254, 147, 'Dearborn', 10000, 1),
(24074, 254, 132, 'Dearing', 10000, 1),
(24075, 254, 138, 'Dearing', 10000, 1),
(24076, 254, 134, 'Deary', 10000, 1),
(24077, 254, 126, 'Death Valley', 10000, 1),
(24078, 254, 122, 'Deatsville', 10000, 1),
(24079, 254, 171, 'Deaver', 10000, 1),
(24080, 254, 139, 'Debord', 10000, 1),
(24081, 254, 125, 'Decatur', 10000, 1),
(24082, 254, 137, 'Decatur', 10000, 1),
(24083, 254, 144, 'Decatur', 10000, 1),
(24084, 254, 149, 'Decatur', 10000, 1),
(24085, 254, 157, 'Decatur', 10000, 1),
(24086, 254, 164, 'Decaturville', 10000, 1),
(24087, 254, 164, 'Decherd', 10000, 1),
(24088, 254, 136, 'Decker', 10000, 1),
(24089, 254, 144, 'Decker', 10000, 1),
(24090, 254, 148, 'Decker', 10000, 1),
(24091, 254, 144, 'Deckerville', 10000, 1),
(24092, 254, 134, 'Declo', 10000, 1),
(24093, 254, 137, 'Dedham', 10000, 1),
(24094, 254, 136, 'Deedsville', 10000, 1),
(24095, 254, 155, 'Deep Gap', 10000, 1),
(24096, 254, 128, 'Deep River', 10000, 1),
(24097, 254, 137, 'Deep River', 10000, 1),
(24098, 254, 155, 'Deep Run', 10000, 1),
(24099, 254, 169, 'Deep Water', 10000, 1),
(24100, 254, 147, 'Deepwater', 10000, 1),
(24101, 254, 152, 'Deepwater', 10000, 1),
(24102, 254, 125, 'Deer', 10000, 1),
(24103, 254, 135, 'Deer Creek', 10000, 1),
(24104, 254, 158, 'Deer Creek', 10000, 1),
(24105, 254, 135, 'Deer Grove', 10000, 1),
(24106, 254, 168, 'Deer Harbor', 10000, 1),
(24107, 254, 159, 'Deer Island', 10000, 1),
(24108, 254, 141, 'Deer Isle', 10000, 1),
(24109, 254, 148, 'Deer Lodge', 10000, 1),
(24110, 254, 164, 'Deer Lodge', 10000, 1),
(24111, 254, 122, 'Deer Park', 10000, 1),
(24112, 254, 126, 'Deer Park', 10000, 1),
(24113, 254, 168, 'Deer Park', 10000, 1),
(24114, 254, 170, 'Deer Park', 10000, 1),
(24115, 254, 145, 'Deer River', 10000, 1),
(24116, 254, 154, 'Deer River', 10000, 1),
(24117, 254, 127, 'Deer Trail', 10000, 1),
(24118, 254, 170, 'Deerbrook', 10000, 1),
(24119, 254, 138, 'Deerfield', 10000, 1),
(24120, 254, 143, 'Deerfield', 10000, 1),
(24121, 254, 144, 'Deerfield', 10000, 1),
(24122, 254, 147, 'Deerfield', 10000, 1),
(24123, 254, 151, 'Deerfield', 10000, 1),
(24124, 254, 157, 'Deerfield', 10000, 1),
(24125, 254, 167, 'Deerfield', 10000, 1),
(24126, 254, 152, 'Deerfield Street', 10000, 1),
(24127, 254, 123, 'Deering', 10000, 1),
(24128, 254, 147, 'Deering', 10000, 1),
(24129, 254, 156, 'Deering', 10000, 1),
(24130, 254, 157, 'Deersville', 10000, 1),
(24131, 254, 144, 'Deerton', 10000, 1),
(24132, 254, 145, 'Deerwood', 10000, 1),
(24133, 254, 150, 'Deeth', 10000, 1),
(24134, 254, 154, 'Deferiet', 10000, 1),
(24135, 254, 137, 'Defiance', 10000, 1),
(24136, 254, 147, 'Defiance', 10000, 1),
(24137, 254, 160, 'Defiance', 10000, 1),
(24138, 254, 144, 'Deford', 10000, 1),
(24139, 254, 127, 'Del Norte', 10000, 1),
(24140, 254, 165, 'Del Valle', 10000, 1),
(24141, 254, 170, 'Delafield', 10000, 1),
(24142, 254, 145, 'Delano', 10000, 1),
(24143, 254, 160, 'Delano', 10000, 1),
(24144, 254, 164, 'Delano', 10000, 1),
(24145, 254, 154, 'Delanson', 10000, 1),
(24146, 254, 125, 'Delaplaine', 10000, 1),
(24147, 254, 167, 'Delaplane', 10000, 1),
(24148, 254, 135, 'Delavan', 10000, 1),
(24149, 254, 145, 'Delavan', 10000, 1),
(24150, 254, 125, 'Delaware', 10000, 1),
(24151, 254, 137, 'Delaware', 10000, 1),
(24152, 254, 152, 'Delaware', 10000, 1),
(24153, 254, 158, 'Delaware', 10000, 1),
(24154, 254, 160, 'Delaware Water Gap', 10000, 1),
(24155, 254, 169, 'Delbarton', 10000, 1),
(24156, 254, 140, 'Delcambre', 10000, 1),
(24157, 254, 155, 'Delco', 10000, 1),
(24158, 254, 154, 'Delevan', 10000, 1),
(24159, 254, 126, 'Delhi', 10000, 1),
(24160, 254, 137, 'Delhi', 10000, 1),
(24161, 254, 138, 'Delia', 10000, 1),
(24162, 254, 125, 'Delight', 10000, 1),
(24163, 254, 125, 'Dell', 10000, 1),
(24164, 254, 148, 'Dell', 10000, 1),
(24165, 254, 165, 'Dell City', 10000, 1),
(24166, 254, 163, 'Dell Rapids', 10000, 1),
(24167, 254, 164, 'Dellrose', 10000, 1),
(24168, 254, 157, 'Dellroy', 10000, 1),
(24169, 254, 169, 'Dellslow', 10000, 1),
(24170, 254, 170, 'Dellwood', 10000, 1),
(24171, 254, 122, 'Delmar', 10000, 1),
(24172, 254, 129, 'Delmar', 10000, 1),
(24173, 254, 137, 'Delmar', 10000, 1),
(24174, 254, 142, 'Delmar', 10000, 1),
(24175, 254, 154, 'Delmar', 10000, 1),
(24176, 254, 165, 'Delmita', 10000, 1),
(24177, 254, 152, 'Delmont', 10000, 1),
(24178, 254, 163, 'Delmont', 10000, 1),
(24179, 254, 137, 'Deloit', 10000, 1),
(24180, 254, 136, 'Delong', 10000, 1),
(24181, 254, 154, 'Delphi Falls', 10000, 1),
(24182, 254, 139, 'Delphia', 10000, 1),
(24183, 254, 138, 'Delphos', 10000, 1),
(24184, 254, 157, 'Delphos', 10000, 1),
(24185, 254, 169, 'Delray', 10000, 1),
(24186, 254, 122, 'Delta', 10000, 1),
(24187, 254, 137, 'Delta', 10000, 1),
(24188, 254, 140, 'Delta', 10000, 1),
(24189, 254, 147, 'Delta', 10000, 1),
(24190, 254, 160, 'Delta', 10000, 1),
(24191, 254, 146, 'Delta City', 10000, 1),
(24192, 254, 167, 'Deltaville', 10000, 1),
(24193, 254, 139, 'Dema', 10000, 1),
(24194, 254, 152, 'Demarest', 10000, 1),
(24195, 254, 132, 'Demorest', 10000, 1),
(24196, 254, 136, 'Demotte', 10000, 1),
(24197, 254, 160, 'Denbo', 10000, 1),
(24198, 254, 167, 'Dendron', 10000, 1),
(24199, 254, 156, 'Denhoff', 10000, 1),
(24200, 254, 150, 'Denio', 10000, 1),
(24201, 254, 138, 'Denison', 10000, 1),
(24202, 254, 137, 'Denmark', 10000, 1),
(24203, 254, 141, 'Denmark', 10000, 1),
(24204, 254, 154, 'Denmark', 10000, 1),
(24205, 254, 164, 'Denmark', 10000, 1),
(24206, 254, 170, 'Denmark', 10000, 1),
(24207, 254, 125, 'Dennard', 10000, 1),
(24208, 254, 124, 'Dennehotso', 10000, 1),
(24209, 254, 138, 'Dennis', 10000, 1),
(24210, 254, 146, 'Dennis', 10000, 1),
(24211, 254, 165, 'Dennis', 10000, 1),
(24212, 254, 143, 'Dennis Port', 10000, 1),
(24213, 254, 135, 'Dennison', 10000, 1),
(24214, 254, 145, 'Dennison', 10000, 1),
(24215, 254, 157, 'Dennison', 10000, 1),
(24216, 254, 139, 'Denniston', 10000, 1),
(24217, 254, 152, 'Dennisville', 10000, 1),
(24218, 254, 141, 'Dennysville', 10000, 1),
(24219, 254, 132, 'Denton', 10000, 1),
(24220, 254, 138, 'Denton', 10000, 1),
(24221, 254, 139, 'Denton', 10000, 1),
(24222, 254, 148, 'Denton', 10000, 1),
(24223, 254, 149, 'Denton', 10000, 1),
(24226, 254, 137, 'Denver', 10000, 1),
(24227, 254, 139, 'Denver', 10000, 1),
(24228, 254, 147, 'Denver', 10000, 1),
(24229, 254, 155, 'Denver', 10000, 1),
(24230, 254, 154, 'Denver', 10000, 1),
(24231, 254, 160, 'Denver', 10000, 1),
(24232, 254, 154, 'Depauville', 10000, 1),
(24233, 254, 136, 'Depauw', 10000, 1),
(24234, 254, 158, 'Depew', 10000, 1),
(24235, 254, 159, 'Depoe Bay', 10000, 1),
(24236, 254, 165, 'Deport', 10000, 1),
(24237, 254, 154, 'Deposit', 10000, 1),
(24238, 254, 135, 'Depue', 10000, 1),
(24239, 254, 136, 'Deputy', 10000, 1),
(24240, 254, 128, 'Derby', 10000, 1),
(24241, 254, 137, 'Derby', 10000, 1),
(24242, 254, 136, 'Derby', 10000, 1),
(24243, 254, 154, 'Derby', 10000, 1),
(24244, 254, 157, 'Derby', 10000, 1),
(24245, 254, 172, 'Derby', 10000, 1),
(24246, 254, 172, 'Derby Line', 10000, 1),
(24247, 254, 146, 'Derma', 10000, 1),
(24248, 254, 125, 'Dermott', 10000, 1),
(24249, 254, 160, 'Derrick City', 10000, 1),
(24250, 254, 153, 'Derry', 10000, 1),
(24251, 254, 157, 'Derwent', 10000, 1),
(24252, 254, 140, 'Des Allemands', 10000, 1),
(24253, 254, 147, 'Des Arc', 10000, 1),
(24254, 254, 156, 'Des Lacs', 10000, 1),
(24255, 254, 153, 'Des Moines', 10000, 1),
(24256, 254, 165, 'Desdemona', 10000, 1),
(24257, 254, 126, 'Desert Center', 10000, 1),
(24258, 254, 125, 'Desha', 10000, 1),
(24259, 254, 149, 'Deshler', 10000, 1),
(24260, 254, 157, 'Deshler', 10000, 1),
(24261, 254, 134, 'Desmet', 10000, 1),
(24263, 254, 140, 'Destrehan', 10000, 1),
(24264, 254, 122, 'Detroit', 10000, 1),
(24265, 254, 141, 'Detroit', 10000, 1),
(24266, 254, 159, 'Detroit', 10000, 1),
(24267, 254, 165, 'Detroit', 10000, 1),
(24268, 254, 160, 'Devault', 10000, 1),
(24269, 254, 165, 'Devers', 10000, 1),
(24270, 254, 147, 'Devils Elbow', 10000, 1),
(24271, 254, 171, 'Devils Tower', 10000, 1),
(24272, 254, 158, 'Devol', 10000, 1),
(24273, 254, 137, 'Dewar', 10000, 1),
(24274, 254, 158, 'Dewar', 10000, 1),
(24275, 254, 160, 'Dewart', 10000, 1),
(24276, 254, 149, 'Deweese', 10000, 1),
(24277, 254, 124, 'Dewey', 10000, 1),
(24278, 254, 135, 'Dewey', 10000, 1),
(24279, 254, 158, 'Dewey', 10000, 1),
(24280, 254, 165, 'Deweyville', 10000, 1),
(24281, 254, 166, 'Deweyville', 10000, 1),
(24282, 254, 135, 'Dewitt', 10000, 1),
(24283, 254, 139, 'Dewitt', 10000, 1),
(24284, 254, 144, 'Dewitt', 10000, 1),
(24285, 254, 167, 'Dewitt', 10000, 1),
(24286, 254, 154, 'Dewittville', 10000, 1),
(24287, 254, 132, 'Dewy Rose', 10000, 1),
(24288, 254, 132, 'Dexter', 10000, 1),
(24289, 254, 137, 'Dexter', 10000, 1),
(24290, 254, 138, 'Dexter', 10000, 1),
(24291, 254, 139, 'Dexter', 10000, 1),
(24292, 254, 145, 'Dexter', 10000, 1),
(24293, 254, 153, 'Dexter', 10000, 1),
(24294, 254, 154, 'Dexter', 10000, 1),
(24295, 254, 159, 'Dexter', 10000, 1),
(24296, 254, 157, 'Dexter City', 10000, 1),
(24297, 254, 126, 'Diablo', 10000, 1),
(24298, 254, 137, 'Diagonal', 10000, 1),
(24299, 254, 147, 'Diamond', 10000, 1),
(24300, 254, 157, 'Diamond', 10000, 1),
(24301, 254, 159, 'Diamond', 10000, 1),
(24302, 254, 125, 'Diamond City', 10000, 1),
(24303, 254, 154, 'Diamond Point', 10000, 1),
(24304, 254, 146, 'Diamondhead', 10000, 1),
(24305, 254, 171, 'Diamondville', 10000, 1),
(24306, 254, 165, 'Diana', 10000, 1),
(24307, 254, 169, 'Diana', 10000, 1),
(24308, 254, 125, 'Diaz', 10000, 1),
(24309, 254, 158, 'Dibble', 10000, 1),
(24310, 254, 165, 'Diboll', 10000, 1),
(24311, 254, 139, 'Dice', 10000, 1),
(24312, 254, 137, 'Dickens', 10000, 1),
(24313, 254, 149, 'Dickens', 10000, 1),
(24314, 254, 142, 'Dickerson', 10000, 1),
(24315, 254, 160, 'Dickerson Run', 10000, 1),
(24316, 254, 156, 'Dickey', 10000, 1),
(24317, 254, 170, 'Dickeyville', 10000, 1),
(24318, 254, 122, 'Dickinson', 10000, 1),
(24319, 254, 165, 'Dickinson', 10000, 1),
(24320, 254, 154, 'Dickinson Center', 10000, 1),
(24321, 254, 125, 'Dierks', 10000, 1),
(24322, 254, 135, 'Dieterich', 10000, 1),
(24323, 254, 134, 'Dietrich', 10000, 1),
(24324, 254, 147, 'Diggins', 10000, 1),
(24325, 254, 167, 'Diggs', 10000, 1),
(24326, 254, 137, 'Dike', 10000, 1),
(24327, 254, 165, 'Dike', 10000, 1),
(24328, 254, 158, 'Dill City', 10000, 1),
(24329, 254, 132, 'Dillard', 10000, 1),
(24330, 254, 159, 'Dillard', 10000, 1),
(24331, 254, 169, 'Dille', 10000, 1),
(24332, 254, 149, 'Diller', 10000, 1),
(24333, 254, 165, 'Dilley', 10000, 1),
(24334, 254, 160, 'Dilliner', 10000, 1),
(24335, 254, 126, 'Dillon Beach', 10000, 1),
(24336, 254, 157, 'Dillonvale', 10000, 1),
(24337, 254, 155, 'Dillsboro', 10000, 1),
(24338, 254, 160, 'Dilltown', 10000, 1),
(24339, 254, 167, 'Dillwyn', 10000, 1),
(24340, 254, 145, 'Dilworth', 10000, 1),
(24341, 254, 165, 'Dime Box', 10000, 1),
(24342, 254, 160, 'Dimock', 10000, 1),
(24343, 254, 163, 'Dimock', 10000, 1),
(24344, 254, 144, 'Dimondale', 10000, 1),
(24345, 254, 165, 'Dinero', 10000, 1),
(24346, 254, 169, 'Dingess', 10000, 1),
(24347, 254, 134, 'Dingle', 10000, 1),
(24348, 254, 160, 'Dingmans Ferry', 10000, 1),
(24349, 254, 127, 'Dinosaur', 10000, 1),
(24350, 254, 167, 'Dinwiddie', 10000, 1),
(24351, 254, 167, 'Disputanta', 10000, 1),
(24352, 254, 160, 'Distant', 10000, 1),
(24353, 254, 147, 'Dittmer', 10000, 1),
(24354, 254, 135, 'Divernon', 10000, 1),
(24355, 254, 148, 'Divide', 10000, 1),
(24356, 254, 152, 'Dividing Creek', 10000, 1),
(24357, 254, 135, 'Dix', 10000, 1),
(24358, 254, 149, 'Dix', 10000, 1),
(24359, 254, 141, 'Dixfield', 10000, 1),
(24360, 254, 132, 'Dixie', 10000, 1),
(24361, 254, 168, 'Dixie', 10000, 1),
(24362, 254, 169, 'Dixie', 10000, 1),
(24363, 254, 141, 'Dixmont', 10000, 1),
(24364, 254, 137, 'Dixon', 10000, 1),
(24365, 254, 147, 'Dixon', 10000, 1),
(24366, 254, 148, 'Dixon', 10000, 1),
(24367, 254, 149, 'Dixon', 10000, 1),
(24368, 254, 153, 'Dixon', 10000, 1),
(24369, 254, 171, 'Dixon', 10000, 1),
(24370, 254, 164, 'Dixon Springs', 10000, 1),
(24371, 254, 122, 'Dixons Mills', 10000, 1),
(24372, 254, 160, 'Dixonville', 10000, 1),
(24373, 254, 165, 'Dobbin', 10000, 1),
(24374, 254, 126, 'Dobbins', 10000, 1),
(24375, 254, 154, 'Dobbs Ferry', 10000, 1),
(24376, 254, 122, 'Docena', 10000, 1),
(24377, 254, 131, 'Doctors Inlet', 10000, 1),
(24378, 254, 165, 'Dodd City', 10000, 1),
(24379, 254, 125, 'Doddridge', 10000, 1),
(24380, 254, 146, 'Doddsville', 10000, 1),
(24381, 254, 156, 'Dodge', 10000, 1),
(24382, 254, 149, 'Dodge', 10000, 1),
(24383, 254, 165, 'Dodge', 10000, 1),
(24384, 254, 170, 'Dodge', 10000, 1),
(24385, 254, 145, 'Dodge Center', 10000, 1),
(24386, 254, 144, 'Dodgeville', 10000, 1),
(24387, 254, 140, 'Dodson', 10000, 1),
(24388, 254, 148, 'Dodson', 10000, 1),
(24389, 254, 165, 'Dodson', 10000, 1),
(24390, 254, 167, 'Doe Hill', 10000, 1),
(24391, 254, 147, 'Doe Run', 10000, 1),
(24392, 254, 132, 'Doerun', 10000, 1),
(24393, 254, 167, 'Dogue', 10000, 1),
(24394, 254, 157, 'Dola', 10000, 1),
(24395, 254, 124, 'Dolan Springs', 10000, 1),
(24396, 254, 163, 'Doland', 10000, 1),
(24397, 254, 154, 'Dolgeville', 10000, 1),
(24398, 254, 144, 'Dollar Bay', 10000, 1),
(24399, 254, 137, 'Dolliver', 10000, 1),
(24400, 254, 122, 'Dolomite', 10000, 1),
(24401, 254, 127, 'Dolores', 10000, 1),
(24402, 254, 125, 'Dolph', 10000, 1),
(24403, 254, 167, 'Dolphin', 10000, 1),
(24404, 254, 137, 'Donahue', 10000, 1),
(24405, 254, 159, 'Donald', 10000, 1),
(24406, 254, 162, 'Donalds', 10000, 1),
(24407, 254, 125, 'Donaldson', 10000, 1),
(24408, 254, 136, 'Donaldson', 10000, 1),
(24409, 254, 145, 'Donaldson', 10000, 1),
(24410, 254, 160, 'Donegal', 10000, 1),
(24411, 254, 135, 'Dongola', 10000, 1),
(24412, 254, 165, 'Donie', 10000, 1),
(24413, 254, 137, 'Donnellson', 10000, 1),
(24414, 254, 135, 'Donnellson', 10000, 1),
(24415, 254, 134, 'Donnelly', 10000, 1),
(24416, 254, 145, 'Donnelly', 10000, 1),
(24417, 254, 157, 'Donnelsville', 10000, 1),
(24418, 254, 140, 'Donner', 10000, 1),
(24419, 254, 156, 'Donnybrook', 10000, 1),
(24420, 254, 135, 'Donovan', 10000, 1),
(24421, 254, 165, 'Doole', 10000, 1),
(24422, 254, 137, 'Doon', 10000, 1),
(24423, 254, 122, 'Dora', 10000, 1),
(24424, 254, 147, 'Dora', 10000, 1),
(24425, 254, 153, 'Dora', 10000, 1),
(24426, 254, 167, 'Doran', 10000, 1),
(24427, 254, 137, 'Dorchester', 10000, 1),
(24428, 254, 149, 'Dorchester', 10000, 1),
(24429, 254, 152, 'Dorchester', 10000, 1),
(24430, 254, 162, 'Dorchester', 10000, 1),
(24431, 254, 170, 'Dorchester', 10000, 1),
(24432, 254, 159, 'Dorena', 10000, 1),
(24433, 254, 154, 'Dormansville', 10000, 1),
(24434, 254, 160, 'Dornsife', 10000, 1),
(24435, 254, 152, 'Dorothy', 10000, 1),
(24436, 254, 169, 'Dorothy', 10000, 1),
(24437, 254, 138, 'Dorrance', 10000, 1),
(24438, 254, 157, 'Dorset', 10000, 1),
(24439, 254, 172, 'Dorset', 10000, 1),
(24440, 254, 135, 'Dorsey', 10000, 1),
(24441, 254, 139, 'Dorton', 10000, 1),
(24442, 254, 126, 'Dos Rios', 10000, 1),
(24443, 254, 165, 'Doss', 10000, 1),
(24444, 254, 167, 'Doswell', 10000, 1),
(24445, 254, 169, 'Dothan', 10000, 1),
(24446, 254, 168, 'Doty', 10000, 1),
(24447, 254, 165, 'Doucette', 10000, 1),
(24448, 254, 137, 'Douds', 10000, 1),
(24449, 254, 137, 'Dougherty', 10000, 1),
(24450, 254, 158, 'Dougherty', 10000, 1),
(24451, 254, 165, 'Dougherty', 10000, 1),
(24452, 254, 123, 'Douglas', 10000, 1),
(24453, 254, 122, 'Douglas', 10000, 1),
(24454, 254, 144, 'Douglas', 10000, 1),
(24455, 254, 156, 'Douglas', 10000, 1),
(24456, 254, 149, 'Douglas', 10000, 1),
(24457, 254, 158, 'Douglas', 10000, 1),
(24458, 254, 126, 'Douglas Flat', 10000, 1),
(24459, 254, 138, 'Douglass', 10000, 1),
(24460, 254, 165, 'Douglass', 10000, 1),
(24461, 254, 160, 'Douglassville', 10000, 1),
(24462, 254, 165, 'Douglassville', 10000, 1),
(24463, 254, 170, 'Dousman', 10000, 1),
(24464, 254, 127, 'Dove Creek', 10000, 1),
(24465, 254, 125, 'Dover', 10000, 1),
(24466, 254, 131, 'Dover', 10000, 1),
(24467, 254, 132, 'Dover', 10000, 1),
(24468, 254, 134, 'Dover', 10000, 1),
(24469, 254, 135, 'Dover', 10000, 1),
(24470, 254, 138, 'Dover', 10000, 1),
(24471, 254, 139, 'Dover', 10000, 1),
(24472, 254, 143, 'Dover', 10000, 1),
(24473, 254, 145, 'Dover', 10000, 1),
(24474, 254, 147, 'Dover', 10000, 1),
(24475, 254, 155, 'Dover', 10000, 1),
(24476, 254, 158, 'Dover', 10000, 1),
(24477, 254, 160, 'Dover', 10000, 1),
(24478, 254, 129, 'Dover AFB', 10000, 1),
(24479, 254, 141, 'Dover Foxcroft', 10000, 1),
(24480, 254, 154, 'Dover Plains', 10000, 1),
(24481, 254, 145, 'Dovray', 10000, 1),
(24482, 254, 135, 'Dow', 10000, 1),
(24483, 254, 137, 'Dow City', 10000, 1),
(24484, 254, 135, 'Dowell', 10000, 1),
(24485, 254, 142, 'Dowell', 10000, 1),
(24486, 254, 164, 'Dowelltown', 10000, 1),
(24487, 254, 144, 'Dowling', 10000, 1),
(24488, 254, 134, 'Downey', 10000, 1),
(24489, 254, 126, 'Downieville', 10000, 1),
(24490, 254, 147, 'Downing', 10000, 1),
(24491, 254, 170, 'Downing', 10000, 1),
(24492, 254, 135, 'Downs', 10000, 1),
(24493, 254, 138, 'Downs', 10000, 1),
(24494, 254, 140, 'Downsville', 10000, 1),
(24495, 254, 154, 'Downsville', 10000, 1),
(24496, 254, 170, 'Downsville', 10000, 1),
(24497, 254, 137, 'Dows', 10000, 1),
(24498, 254, 126, 'Doyle', 10000, 1),
(24499, 254, 164, 'Doyle', 10000, 1),
(24500, 254, 160, 'Doylesburg', 10000, 1),
(24501, 254, 157, 'Doylestown', 10000, 1),
(24502, 254, 170, 'Doylestown', 10000, 1),
(24503, 254, 140, 'Doyline', 10000, 1),
(24504, 254, 122, 'Dozier', 10000, 1),
(24505, 254, 159, 'Drain', 10000, 1),
(24506, 254, 127, 'Drake', 10000, 1),
(24507, 254, 139, 'Drake', 10000, 1),
(24508, 254, 156, 'Drake', 10000, 1),
(24509, 254, 167, 'Drakes Branch', 10000, 1),
(24510, 254, 139, 'Drakesboro', 10000, 1),
(24511, 254, 137, 'Drakesville', 10000, 1),
(24512, 254, 163, 'Draper', 10000, 1),
(24513, 254, 167, 'Draper', 10000, 1),
(24514, 254, 125, 'Drasco', 10000, 1),
(24515, 254, 160, 'Dravosburg', 10000, 1),
(24516, 254, 142, 'Drayden', 10000, 1),
(24517, 254, 156, 'Drayton', 10000, 1),
(24518, 254, 162, 'Drayton', 10000, 1),
(24519, 254, 144, 'Drayton Plains', 10000, 1),
(24520, 254, 169, 'Drennen', 10000, 1),
(24521, 254, 138, 'Dresden', 10000, 1),
(24522, 254, 141, 'Dresden', 10000, 1),
(24523, 254, 154, 'Dresden', 10000, 1),
(24524, 254, 164, 'Dresden', 10000, 1),
(24525, 254, 160, 'Dresher', 10000, 1),
(24526, 254, 146, 'Drew', 10000, 1),
(24527, 254, 167, 'Drewryville', 10000, 1),
(24528, 254, 159, 'Drewsey', 10000, 1),
(24529, 254, 151, 'Drewsville', 10000, 1),
(24530, 254, 147, 'Drexel', 10000, 1),
(24531, 254, 155, 'Drexel', 10000, 1),
(24532, 254, 139, 'Drift', 10000, 1),
(24533, 254, 160, 'Drifting', 10000, 1),
(24534, 254, 160, 'Drifton', 10000, 1),
(24535, 254, 160, 'Driftwood', 10000, 1),
(24536, 254, 165, 'Driftwood', 10000, 1),
(24537, 254, 165, 'Dripping Springs', 10000, 1),
(24538, 254, 156, 'Driscoll', 10000, 1),
(24539, 254, 165, 'Driscoll', 10000, 1),
(24540, 254, 125, 'Driver', 10000, 1),
(24541, 254, 158, 'Drummond', 10000, 1),
(24542, 254, 170, 'Drummond', 10000, 1),
(24543, 254, 144, 'Drummond Island', 10000, 1),
(24544, 254, 164, 'Drummonds', 10000, 1),
(24545, 254, 160, 'Drumore', 10000, 1),
(24546, 254, 158, 'Drumright', 10000, 1),
(24547, 254, 160, 'Drums', 10000, 1),
(24548, 254, 143, 'Drury', 10000, 1),
(24549, 254, 147, 'Drury', 10000, 1),
(24550, 254, 140, 'Dry Creek', 10000, 1),
(24551, 254, 169, 'Dry Creek', 10000, 1),
(24552, 254, 167, 'Dry Fork', 10000, 1),
(24553, 254, 140, 'Dry Prong', 10000, 1),
(24554, 254, 139, 'Dry Ridge', 10000, 1),
(24555, 254, 160, 'Dry Run', 10000, 1),
(24556, 254, 169, 'Drybranch', 10000, 1),
(24557, 254, 141, 'Dryden', 10000, 1),
(24558, 254, 144, 'Dryden', 10000, 1),
(24559, 254, 154, 'Dryden', 10000, 1),
(24560, 254, 165, 'Dryden', 10000, 1),
(24561, 254, 167, 'Dryden', 10000, 1),
(24562, 254, 168, 'Dryden', 10000, 1),
(24563, 254, 169, 'Dryfork', 10000, 1),
(24564, 254, 126, 'Drytown', 10000, 1),
(24565, 254, 135, 'Du Bois', 10000, 1),
(24566, 254, 149, 'Du Bois', 10000, 1),
(24567, 254, 132, 'Du Pont', 10000, 1),
(24568, 254, 154, 'Duanesburg', 10000, 1),
(24569, 254, 140, 'Dubach', 10000, 1),
(24570, 254, 140, 'Dubberly', 10000, 1),
(24571, 254, 136, 'Dublin', 10000, 1),
(24572, 254, 146, 'Dublin', 10000, 1),
(24573, 254, 155, 'Dublin', 10000, 1),
(24574, 254, 151, 'Dublin', 10000, 1),
(24575, 254, 160, 'Dublin', 10000, 1),
(24576, 254, 167, 'Dublin', 10000, 1),
(24577, 254, 134, 'Dubois', 10000, 1),
(24578, 254, 136, 'Dubois', 10000, 1),
(24579, 254, 171, 'Dubois', 10000, 1),
(24580, 254, 139, 'Dubre', 10000, 1),
(24581, 254, 169, 'Duck', 10000, 1),
(24582, 254, 166, 'Duck Creek Village', 10000, 1),
(24583, 254, 146, 'Duck Hill', 10000, 1),
(24584, 254, 164, 'Duck River', 10000, 1),
(24585, 254, 164, 'Ducktown', 10000, 1),
(24586, 254, 150, 'Duckwater', 10000, 1),
(24587, 254, 126, 'Ducor', 10000, 1),
(24588, 254, 132, 'Dudley', 10000, 1),
(24589, 254, 143, 'Dudley', 10000, 1),
(24590, 254, 147, 'Dudley', 10000, 1),
(24591, 254, 155, 'Dudley', 10000, 1),
(24592, 254, 160, 'Dudley', 10000, 1),
(24593, 254, 162, 'Due West', 10000, 1),
(24594, 254, 147, 'Duenweg', 10000, 1),
(24595, 254, 164, 'Duff', 10000, 1),
(24596, 254, 167, 'Duffield', 10000, 1),
(24597, 254, 136, 'Dugger', 10000, 1),
(24598, 254, 167, 'Dugspur', 10000, 1),
(24599, 254, 166, 'Dugway', 10000, 1),
(24600, 254, 147, 'Duke', 10000, 1),
(24601, 254, 158, 'Duke', 10000, 1),
(24602, 254, 160, 'Duke Center', 10000, 1),
(24603, 254, 164, 'Dukedom', 10000, 1),
(24604, 254, 140, 'Dulac', 10000, 1),
(24605, 254, 153, 'Dulce', 10000, 1),
(24606, 254, 126, 'Dulzura', 10000, 1),
(24607, 254, 146, 'Dumas', 10000, 1),
(24608, 254, 167, 'Dumfries', 10000, 1),
(24609, 254, 127, 'Dumont', 10000, 1),
(24610, 254, 137, 'Dumont', 10000, 1),
(24611, 254, 145, 'Dumont', 10000, 1),
(24612, 254, 165, 'Dumont', 10000, 1),
(24613, 254, 139, 'Dunbar', 10000, 1),
(24614, 254, 149, 'Dunbar', 10000, 1),
(24615, 254, 160, 'Dunbar', 10000, 1),
(24616, 254, 170, 'Dunbar', 10000, 1),
(24617, 254, 169, 'Dunbar', 10000, 1),
(24618, 254, 151, 'Dunbarton', 10000, 1),
(24619, 254, 157, 'Dunbridge', 10000, 1),
(24620, 254, 124, 'Duncan', 10000, 1),
(24621, 254, 146, 'Duncan', 10000, 1),
(24622, 254, 149, 'Duncan', 10000, 1),
(24623, 254, 157, 'Duncan Falls', 10000, 1),
(24624, 254, 160, 'Duncannon', 10000, 1),
(24625, 254, 126, 'Duncans Mills', 10000, 1),
(24626, 254, 160, 'Duncansville', 10000, 1),
(24627, 254, 122, 'Duncanville', 10000, 1),
(24628, 254, 137, 'Duncombe', 10000, 1),
(24629, 254, 135, 'Dundas', 10000, 1),
(24630, 254, 145, 'Dundas', 10000, 1),
(24631, 254, 167, 'Dundas', 10000, 1),
(24632, 254, 131, 'Dundee', 10000, 1),
(24633, 254, 137, 'Dundee', 10000, 1),
(24634, 254, 139, 'Dundee', 10000, 1),
(24635, 254, 144, 'Dundee', 10000, 1),
(24636, 254, 146, 'Dundee', 10000, 1),
(24637, 254, 154, 'Dundee', 10000, 1),
(24638, 254, 157, 'Dundee', 10000, 1),
(24639, 254, 152, 'Dunellen', 10000, 1),
(24640, 254, 135, 'Dunfermline', 10000, 1),
(24641, 254, 167, 'Dungannon', 10000, 1),
(24642, 254, 137, 'Dunkerton', 10000, 1),
(24643, 254, 142, 'Dunkirk', 10000, 1),
(24644, 254, 157, 'Dunkirk', 10000, 1),
(24645, 254, 126, 'Dunlap', 10000, 1),
(24646, 254, 137, 'Dunlap', 10000, 1),
(24647, 254, 135, 'Dunlap', 10000, 1),
(24648, 254, 160, 'Dunlevy', 10000, 1),
(24649, 254, 160, 'Dunlo', 10000, 1),
(24650, 254, 169, 'Dunlow', 10000, 1),
(24651, 254, 139, 'Dunmor', 10000, 1),
(24652, 254, 169, 'Dunmore', 10000, 1),
(24653, 254, 165, 'Dunn', 10000, 1),
(24654, 254, 156, 'Dunn Center', 10000, 1),
(24655, 254, 167, 'Dunn Loring', 10000, 1),
(24656, 254, 147, 'Dunnegan', 10000, 1),
(24657, 254, 145, 'Dunnell', 10000, 1),
(24659, 254, 126, 'Dunnigan', 10000, 1),
(24660, 254, 149, 'Dunning', 10000, 1),
(24661, 254, 167, 'Dunnsville', 10000, 1),
(24662, 254, 139, 'Dunnville', 10000, 1),
(24663, 254, 136, 'Dunreith', 10000, 1),
(24664, 254, 156, 'Dunseith', 10000, 1),
(24665, 254, 143, 'Dunstable', 10000, 1),
(24666, 254, 140, 'Duplessis', 10000, 1),
(24667, 254, 135, 'Dupo', 10000, 1),
(24668, 254, 127, 'Dupont', 10000, 1),
(24669, 254, 136, 'Dupont', 10000, 1),
(24670, 254, 140, 'Dupont', 10000, 1),
(24671, 254, 157, 'Dupont', 10000, 1),
(24672, 254, 168, 'Dupont', 10000, 1),
(24673, 254, 163, 'Dupree', 10000, 1),
(24674, 254, 148, 'Dupuyer', 10000, 1),
(24675, 254, 160, 'Duquesne', 10000, 1),
(24676, 254, 135, 'Durand', 10000, 1),
(24677, 254, 144, 'Durand', 10000, 1),
(24678, 254, 137, 'Durango', 10000, 1),
(24679, 254, 131, 'Durant', 10000, 1),
(24680, 254, 137, 'Durant', 10000, 1),
(24681, 254, 146, 'Durant', 10000, 1),
(24682, 254, 155, 'Durants Neck', 10000, 1),
(24683, 254, 169, 'Durbin', 10000, 1),
(24684, 254, 126, 'Durham', 10000, 1),
(24685, 254, 138, 'Durham', 10000, 1),
(24686, 254, 141, 'Durham', 10000, 1),
(24687, 254, 147, 'Durham', 10000, 1),
(24688, 254, 151, 'Durham', 10000, 1),
(24689, 254, 154, 'Durham', 10000, 1),
(24690, 254, 158, 'Durham', 10000, 1),
(24691, 254, 160, 'Durham', 10000, 1),
(24692, 254, 154, 'Durhamville', 10000, 1),
(24693, 254, 159, 'Durkee', 10000, 1),
(24694, 254, 160, 'Dushore', 10000, 1),
(24695, 254, 140, 'Duson', 10000, 1),
(24696, 254, 158, 'Dustin', 10000, 1),
(24697, 254, 166, 'Dutch John', 10000, 1),
(24698, 254, 147, 'Dutchtown', 10000, 1),
(24699, 254, 122, 'Dutton', 10000, 1),
(24700, 254, 148, 'Dutton', 10000, 1),
(24701, 254, 167, 'Dutton', 10000, 1),
(24702, 254, 147, 'Dutzow', 10000, 1),
(24703, 254, 143, 'Duxbury', 10000, 1),
(24704, 254, 139, 'Dwale', 10000, 1),
(24705, 254, 139, 'Dwarf', 10000, 1),
(24706, 254, 135, 'Dwight', 10000, 1),
(24707, 254, 138, 'Dwight', 10000, 1),
(24708, 254, 149, 'Dwight', 10000, 1),
(24709, 254, 139, 'Dycusburg', 10000, 1),
(24710, 254, 125, 'Dyer', 10000, 1),
(24711, 254, 150, 'Dyer', 10000, 1),
(24712, 254, 164, 'Dyer', 10000, 1),
(24713, 254, 137, 'Dyersville', 10000, 1),
(24714, 254, 125, 'Dyess', 10000, 1),
(24715, 254, 165, 'Dyess AFB', 10000, 1),
(24716, 254, 167, 'Dyke', 10000, 1),
(24717, 254, 137, 'Dysart', 10000, 1),
(24718, 254, 160, 'Dysart', 10000, 1),
(24719, 254, 164, 'Eads', 10000, 1),
(24720, 254, 164, 'Eagan', 10000, 1),
(24721, 254, 124, 'Eagar', 10000, 1),
(24722, 254, 135, 'Eagarville', 10000, 1),
(24723, 254, 123, 'Eagle', 10000, 1),
(24724, 254, 144, 'Eagle', 10000, 1),
(24725, 254, 149, 'Eagle', 10000, 1),
(24726, 254, 170, 'Eagle', 10000, 1),
(24727, 254, 154, 'Eagle Bay', 10000, 1),
(24728, 254, 145, 'Eagle Bend', 10000, 1),
(24729, 254, 154, 'Eagle Bridge', 10000, 1),
(24730, 254, 163, 'Eagle Butte', 10000, 1),
(24731, 254, 159, 'Eagle Creek', 10000, 1),
(24732, 254, 131, 'Eagle Lake', 10000, 1),
(24733, 254, 141, 'Eagle Lake', 10000, 1),
(24734, 254, 145, 'Eagle Lake', 10000, 1),
(24735, 254, 165, 'Eagle Lake', 10000, 1),
(24736, 254, 153, 'Eagle Nest', 10000, 1),
(24737, 254, 159, 'Eagle Point', 10000, 1),
(24738, 254, 147, 'Eagle Rock', 10000, 1),
(24739, 254, 167, 'Eagle Rock', 10000, 1),
(24740, 254, 155, 'Eagle Springs', 10000, 1),
(24741, 254, 160, 'Eagles Mere', 10000, 1),
(24742, 254, 158, 'Eagletown', 10000, 1),
(24743, 254, 126, 'Eagleville', 10000, 1),
(24744, 254, 147, 'Eagleville', 10000, 1),
(24745, 254, 164, 'Eagleville', 10000, 1),
(24746, 254, 158, 'Eakly', 10000, 1),
(24747, 254, 155, 'Earl', 10000, 1),
(24748, 254, 136, 'Earl Park', 10000, 1),
(24749, 254, 125, 'Earle', 10000, 1),
(24750, 254, 131, 'Earleton', 10000, 1),
(24751, 254, 142, 'Earleville', 10000, 1),
(24752, 254, 137, 'Earling', 10000, 1),
(24753, 254, 139, 'Earlington', 10000, 1),
(24754, 254, 160, 'Earlington', 10000, 1),
(24755, 254, 158, 'Earlsboro', 10000, 1),
(24756, 254, 154, 'Earlton', 10000, 1),
(24757, 254, 137, 'Earlville', 10000, 1),
(24758, 254, 135, 'Earlville', 10000, 1),
(24759, 254, 154, 'Earlville', 10000, 1),
(24760, 254, 160, 'Earlville', 10000, 1),
(24761, 254, 137, 'Early', 10000, 1),
(24762, 254, 165, 'Early', 10000, 1),
(24763, 254, 162, 'Early Branch', 10000, 1),
(24764, 254, 167, 'Earlysville', 10000, 1),
(24765, 254, 126, 'Earp', 10000, 1),
(24766, 254, 165, 'Earth', 10000, 1),
(24767, 254, 147, 'Earth City', 10000, 1),
(24768, 254, 154, 'East Amherst', 10000, 1),
(24769, 254, 141, 'East Andover', 10000, 1),
(24770, 254, 151, 'East Andover', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(24771, 254, 154, 'East Aurora', 10000, 1),
(24772, 254, 141, 'East Baldwin', 10000, 1),
(24773, 254, 169, 'East Bank', 10000, 1),
(24774, 254, 172, 'East Barre', 10000, 1),
(24775, 254, 155, 'East Bend', 10000, 1),
(24776, 254, 172, 'East Berkshire', 10000, 1),
(24777, 254, 128, 'East Berlin', 10000, 1),
(24778, 254, 160, 'East Berlin', 10000, 1),
(24779, 254, 165, 'East Bernard', 10000, 1),
(24780, 254, 154, 'East Berne', 10000, 1),
(24781, 254, 139, 'East Bernstadt', 10000, 1),
(24782, 254, 154, 'East Bethany', 10000, 1),
(24783, 254, 154, 'East Bloomfield', 10000, 1),
(24784, 254, 141, 'East Blue Hill', 10000, 1),
(24785, 254, 141, 'East Boothbay', 10000, 1),
(24786, 254, 143, 'East Boston', 10000, 1),
(24787, 254, 160, 'East Brady', 10000, 1),
(24788, 254, 154, 'East Branch', 10000, 1),
(24789, 254, 143, 'East Brookfield', 10000, 1),
(24790, 254, 152, 'East Brunswick', 10000, 1),
(24791, 254, 172, 'East Burke', 10000, 1),
(24792, 254, 160, 'East Butler', 10000, 1),
(24793, 254, 172, 'East Calais', 10000, 1),
(24794, 254, 128, 'East Canaan', 10000, 1),
(24795, 254, 151, 'East Candia', 10000, 1),
(24796, 254, 135, 'East Carondelet', 10000, 1),
(24797, 254, 172, 'East Charleston', 10000, 1),
(24798, 254, 154, 'East Chatham', 10000, 1),
(24799, 254, 144, 'East China', 10000, 1),
(24800, 254, 157, 'East Claridon', 10000, 1),
(24801, 254, 154, 'East Concord', 10000, 1),
(24802, 254, 143, 'East Dennis', 10000, 1),
(24803, 254, 151, 'East Derry', 10000, 1),
(24804, 254, 141, 'East Dixfield', 10000, 1),
(24805, 254, 172, 'East Dorset', 10000, 1),
(24806, 254, 172, 'East Dover', 10000, 1),
(24807, 254, 135, 'East Dubuque', 10000, 1),
(24808, 254, 154, 'East Durham', 10000, 1),
(24809, 254, 160, 'East Earl', 10000, 1),
(24810, 254, 132, 'East Ellijay', 10000, 1),
(24811, 254, 170, 'East Ellsworth', 10000, 1),
(24812, 254, 154, 'East Elmhurst', 10000, 1),
(24813, 254, 136, 'East Enterprise', 10000, 1),
(24814, 254, 172, 'East Fairfield', 10000, 1),
(24815, 254, 143, 'East Falmouth', 10000, 1),
(24816, 254, 155, 'East Flat Rock', 10000, 1),
(24817, 254, 143, 'East Freetown', 10000, 1),
(24818, 254, 157, 'East Fultonham', 10000, 1),
(24819, 254, 135, 'East Galesburg', 10000, 1),
(24820, 254, 148, 'East Glacier Park', 10000, 1),
(24821, 254, 128, 'East Glastonbury', 10000, 1),
(24822, 254, 128, 'East Granby', 10000, 1),
(24823, 254, 145, 'East Grand Forks', 10000, 1),
(24824, 254, 154, 'East Greenbush', 10000, 1),
(24825, 254, 128, 'East Haddam', 10000, 1),
(24826, 254, 151, 'East Hampstead', 10000, 1),
(24827, 254, 128, 'East Hampton', 10000, 1),
(24828, 254, 154, 'East Hampton', 10000, 1),
(24829, 254, 152, 'East Hanover', 10000, 1),
(24830, 254, 172, 'East Hardwick', 10000, 1),
(24831, 254, 128, 'East Hartland', 10000, 1),
(24832, 254, 172, 'East Haven', 10000, 1),
(24833, 254, 151, 'East Hebron', 10000, 1),
(24834, 254, 148, 'East Helena', 10000, 1),
(24835, 254, 160, 'East Hickory', 10000, 1),
(24836, 254, 154, 'East Homer', 10000, 1),
(24837, 254, 126, 'East Irvine', 10000, 1),
(24838, 254, 154, 'East Islip', 10000, 1),
(24839, 254, 154, 'East Jewett', 10000, 1),
(24840, 254, 128, 'East Killingly', 10000, 1),
(24841, 254, 151, 'East Kingston', 10000, 1),
(24842, 254, 144, 'East Leroy', 10000, 1),
(24843, 254, 157, 'East Liberty', 10000, 1),
(24844, 254, 141, 'East Livermore', 10000, 1),
(24845, 254, 128, 'East Lyme', 10000, 1),
(24846, 254, 135, 'East Lynn', 10000, 1),
(24847, 254, 169, 'East Lynn', 10000, 1),
(24848, 254, 147, 'East Lynne', 10000, 1),
(24849, 254, 141, 'East Machias', 10000, 1),
(24850, 254, 143, 'East Mansfield', 10000, 1),
(24851, 254, 154, 'East Marion', 10000, 1),
(24852, 254, 160, 'East Mc Keesport', 10000, 1),
(24853, 254, 154, 'East Meadow', 10000, 1),
(24854, 254, 154, 'East Meredith', 10000, 1),
(24855, 254, 172, 'East Middlebury', 10000, 1),
(24856, 254, 160, 'East Millsboro', 10000, 1),
(24857, 254, 172, 'East Montpelier', 10000, 1),
(24858, 254, 154, 'East Moriches', 10000, 1),
(24859, 254, 154, 'East Nassau', 10000, 1),
(24860, 254, 142, 'East New Market', 10000, 1),
(24861, 254, 141, 'East Newport', 10000, 1),
(24862, 254, 154, 'East Norwich', 10000, 1),
(24863, 254, 168, 'East Olympia', 10000, 1),
(24864, 254, 141, 'East Orland', 10000, 1),
(24865, 254, 143, 'East Orleans', 10000, 1),
(24866, 254, 143, 'East Otis', 10000, 1),
(24867, 254, 154, 'East Otto', 10000, 1),
(24868, 254, 131, 'East Palatka', 10000, 1),
(24869, 254, 157, 'East Palestine', 10000, 1),
(24870, 254, 141, 'East Parsonfield', 10000, 1),
(24871, 254, 154, 'East Pembroke', 10000, 1),
(24872, 254, 160, 'East Petersburg', 10000, 1),
(24873, 254, 154, 'East Pharsalia', 10000, 1),
(24874, 254, 160, 'East Pittsburgh', 10000, 1),
(24875, 254, 139, 'East Point', 10000, 1),
(24876, 254, 140, 'East Point', 10000, 1),
(24877, 254, 141, 'East Poland', 10000, 1),
(24878, 254, 172, 'East Poultney', 10000, 1),
(24879, 254, 147, 'East Prairie', 10000, 1),
(24880, 254, 143, 'East Princeton', 10000, 1),
(24881, 254, 160, 'East Prospect', 10000, 1),
(24882, 254, 154, 'East Quogue', 10000, 1),
(24883, 254, 154, 'East Randolph', 10000, 1),
(24884, 254, 172, 'East Randolph', 10000, 1),
(24885, 254, 154, 'East Rochester', 10000, 1),
(24886, 254, 157, 'East Rochester', 10000, 1),
(24887, 254, 154, 'East Rockaway', 10000, 1),
(24888, 254, 152, 'East Rutherford', 10000, 1),
(24889, 254, 172, 'East Ryegate', 10000, 1),
(24890, 254, 172, 'East Saint Johnsbury', 10000, 1),
(24891, 254, 143, 'East Sandwich', 10000, 1),
(24892, 254, 154, 'East Schodack', 10000, 1),
(24893, 254, 160, 'East Smethport', 10000, 1),
(24894, 254, 160, 'East Smithfield', 10000, 1),
(24895, 254, 155, 'East Spencer', 10000, 1),
(24896, 254, 154, 'East Springfield', 10000, 1),
(24897, 254, 157, 'East Springfield', 10000, 1),
(24898, 254, 160, 'East Springfield', 10000, 1),
(24899, 254, 167, 'East Stone Gap', 10000, 1),
(24900, 254, 122, 'East Tallassee', 10000, 1),
(24901, 254, 143, 'East Taunton', 10000, 1),
(24902, 254, 144, 'East Tawas', 10000, 1),
(24903, 254, 143, 'East Templeton', 10000, 1),
(24904, 254, 160, 'East Texas', 10000, 1),
(24905, 254, 172, 'East Thetford', 10000, 1),
(24906, 254, 160, 'East Vandergrift', 10000, 1),
(24907, 254, 141, 'East Vassalboro', 10000, 1),
(24908, 254, 151, 'East Wakefield', 10000, 1),
(24909, 254, 172, 'East Wallingford', 10000, 1),
(24910, 254, 143, 'East Walpole', 10000, 1),
(24911, 254, 143, 'East Wareham', 10000, 1),
(24912, 254, 141, 'East Waterboro', 10000, 1),
(24913, 254, 160, 'East Waterford', 10000, 1),
(24914, 254, 168, 'East Wenatchee', 10000, 1),
(24915, 254, 154, 'East Williamson', 10000, 1),
(24916, 254, 141, 'East Wilton', 10000, 1),
(24917, 254, 128, 'East Windsor Hill', 10000, 1),
(24918, 254, 141, 'East Winthrop', 10000, 1),
(24919, 254, 128, 'East Woodstock', 10000, 1),
(24920, 254, 154, 'East Worcester', 10000, 1),
(24921, 254, 122, 'Eastaboga', 10000, 1),
(24922, 254, 146, 'Eastabuchie', 10000, 1),
(24923, 254, 132, 'Eastanollee', 10000, 1),
(24924, 254, 154, 'Eastchester', 10000, 1),
(24925, 254, 139, 'Eastern', 10000, 1),
(24926, 254, 128, 'Eastford', 10000, 1),
(24927, 254, 143, 'Eastham', 10000, 1),
(24928, 254, 143, 'Easthampton', 10000, 1),
(24929, 254, 127, 'Eastlake', 10000, 1),
(24930, 254, 144, 'Eastlake', 10000, 1),
(24931, 254, 131, 'Eastlake Weir', 10000, 1),
(24932, 254, 170, 'Eastman', 10000, 1),
(24933, 254, 128, 'Easton', 10000, 1),
(24934, 254, 135, 'Easton', 10000, 1),
(24935, 254, 138, 'Easton', 10000, 1),
(24936, 254, 143, 'Easton', 10000, 1),
(24937, 254, 141, 'Easton', 10000, 1),
(24938, 254, 145, 'Easton', 10000, 1),
(24939, 254, 147, 'Easton', 10000, 1),
(24940, 254, 165, 'Easton', 10000, 1),
(24941, 254, 168, 'Easton', 10000, 1),
(24942, 254, 162, 'Eastover', 10000, 1),
(24943, 254, 131, 'Eastpoint', 10000, 1),
(24944, 254, 134, 'Eastport', 10000, 1),
(24945, 254, 141, 'Eastport', 10000, 1),
(24946, 254, 144, 'Eastport', 10000, 1),
(24947, 254, 154, 'Eastport', 10000, 1),
(24948, 254, 168, 'Eastsound', 10000, 1),
(24949, 254, 139, 'Eastview', 10000, 1),
(24950, 254, 139, 'Eastwood', 10000, 1),
(24951, 254, 127, 'Eaton', 10000, 1),
(24952, 254, 136, 'Eaton', 10000, 1),
(24953, 254, 154, 'Eaton', 10000, 1),
(24954, 254, 164, 'Eaton', 10000, 1),
(24955, 254, 151, 'Eaton Center', 10000, 1),
(24956, 254, 131, 'Eaton Park', 10000, 1),
(24957, 254, 144, 'Eaton Rapids', 10000, 1),
(24958, 254, 144, 'Eau Claire', 10000, 1),
(24959, 254, 160, 'Eau Claire', 10000, 1),
(24960, 254, 170, 'Eau Galle', 10000, 1),
(24961, 254, 144, 'Eben Junction', 10000, 1),
(24962, 254, 160, 'Ebensburg', 10000, 1),
(24963, 254, 160, 'Ebervale', 10000, 1),
(24964, 254, 167, 'Ebony', 10000, 1),
(24965, 254, 131, 'Ebro', 10000, 1),
(24966, 254, 169, 'Eccles', 10000, 1),
(24967, 254, 140, 'Echo', 10000, 1),
(24968, 254, 145, 'Echo', 10000, 1),
(24969, 254, 159, 'Echo', 10000, 1),
(24970, 254, 166, 'Echo', 10000, 1),
(24971, 254, 126, 'Echo Lake', 10000, 1),
(24972, 254, 122, 'Echola', 10000, 1),
(24973, 254, 156, 'Eckelson', 10000, 1),
(24974, 254, 144, 'Eckerman', 10000, 1),
(24975, 254, 136, 'Eckerty', 10000, 1),
(24976, 254, 142, 'Eckhart Mines', 10000, 1),
(24977, 254, 127, 'Eckley', 10000, 1),
(24978, 254, 169, 'Eckman', 10000, 1),
(24979, 254, 165, 'Ecleto', 10000, 1),
(24980, 254, 144, 'Ecorse', 10000, 1),
(24981, 254, 146, 'Ecru', 10000, 1),
(24982, 254, 165, 'Ector', 10000, 1),
(24983, 254, 165, 'Edcouch', 10000, 1),
(24984, 254, 141, 'Eddington', 10000, 1),
(24985, 254, 135, 'Eddyville', 10000, 1),
(24986, 254, 149, 'Eddyville', 10000, 1),
(24987, 254, 159, 'Eddyville', 10000, 1),
(24988, 254, 135, 'Edelstein', 10000, 1),
(24989, 254, 124, 'Eden', 10000, 1),
(24990, 254, 132, 'Eden', 10000, 1),
(24991, 254, 134, 'Eden', 10000, 1),
(24992, 254, 142, 'Eden', 10000, 1),
(24993, 254, 154, 'Eden', 10000, 1),
(24994, 254, 163, 'Eden', 10000, 1),
(24995, 254, 165, 'Eden', 10000, 1),
(24996, 254, 166, 'Eden', 10000, 1),
(24997, 254, 172, 'Eden', 10000, 1),
(24998, 254, 170, 'Eden', 10000, 1),
(24999, 254, 172, 'Eden Mills', 10000, 1),
(25000, 254, 145, 'Eden Valley', 10000, 1),
(25001, 254, 144, 'Edenville', 10000, 1),
(25002, 254, 148, 'Edgar', 10000, 1),
(25003, 254, 149, 'Edgar', 10000, 1),
(25004, 254, 170, 'Edgar', 10000, 1),
(25005, 254, 147, 'Edgar Springs', 10000, 1),
(25006, 254, 140, 'Edgard', 10000, 1),
(25007, 254, 169, 'Edgarton', 10000, 1),
(25008, 254, 141, 'Edgecomb', 10000, 1),
(25009, 254, 156, 'Edgeley', 10000, 1),
(25010, 254, 125, 'Edgemont', 10000, 1),
(25011, 254, 160, 'Edgemont', 10000, 1),
(25012, 254, 138, 'Edgerton', 10000, 1),
(25013, 254, 145, 'Edgerton', 10000, 1),
(25014, 254, 147, 'Edgerton', 10000, 1),
(25015, 254, 157, 'Edgerton', 10000, 1),
(25016, 254, 171, 'Edgerton', 10000, 1),
(25017, 254, 142, 'Edgewater', 10000, 1),
(25018, 254, 170, 'Edgewater', 10000, 1),
(25019, 254, 137, 'Edgewood', 10000, 1),
(25020, 254, 135, 'Edgewood', 10000, 1),
(25021, 254, 165, 'Edgewood', 10000, 1),
(25022, 254, 135, 'Edinburg', 10000, 1),
(25023, 254, 156, 'Edinburg', 10000, 1),
(25024, 254, 160, 'Edinburg', 10000, 1),
(25025, 254, 167, 'Edinburg', 10000, 1),
(25026, 254, 136, 'Edinburgh', 10000, 1),
(25027, 254, 132, 'Edison', 10000, 1),
(25028, 254, 149, 'Edison', 10000, 1),
(25029, 254, 157, 'Edison', 10000, 1),
(25030, 254, 162, 'Edisto Island', 10000, 1),
(25031, 254, 154, 'Edmeston', 10000, 1),
(25032, 254, 160, 'Edmon', 10000, 1),
(25033, 254, 169, 'Edmond', 10000, 1),
(25034, 254, 125, 'Edmondson', 10000, 1),
(25035, 254, 165, 'Edmonson', 10000, 1),
(25036, 254, 144, 'Edmore', 10000, 1),
(25037, 254, 156, 'Edmore', 10000, 1),
(25038, 254, 170, 'Edmund', 10000, 1),
(25039, 254, 138, 'Edna', 10000, 1),
(25040, 254, 139, 'Edna', 10000, 1),
(25041, 254, 155, 'Edneyville', 10000, 1),
(25042, 254, 157, 'Edon', 10000, 1),
(25043, 254, 165, 'Edroy', 10000, 1),
(25044, 254, 138, 'Edson', 10000, 1),
(25045, 254, 168, 'Edwall', 10000, 1),
(25046, 254, 155, 'Edward', 10000, 1),
(25047, 254, 126, 'Edwards', 10000, 1),
(25048, 254, 127, 'Edwards', 10000, 1),
(25049, 254, 135, 'Edwards', 10000, 1),
(25050, 254, 147, 'Edwards', 10000, 1),
(25051, 254, 146, 'Edwards', 10000, 1),
(25052, 254, 154, 'Edwards', 10000, 1),
(25053, 254, 144, 'Edwardsburg', 10000, 1),
(25054, 254, 136, 'Edwardsport', 10000, 1),
(25055, 254, 122, 'Edwardsville', 10000, 1),
(25056, 254, 167, 'Edwardsville', 10000, 1),
(25057, 254, 123, 'Eek', 10000, 1),
(25058, 254, 140, 'Effie', 10000, 1),
(25059, 254, 145, 'Effie', 10000, 1),
(25060, 254, 138, 'Effingham', 10000, 1),
(25061, 254, 151, 'Effingham', 10000, 1),
(25062, 254, 160, 'Effort', 10000, 1),
(25063, 254, 155, 'Efland', 10000, 1),
(25064, 254, 140, 'Egan', 10000, 1),
(25065, 254, 163, 'Egan', 10000, 1),
(25066, 254, 123, 'Egegik', 10000, 1),
(25067, 254, 156, 'Egeland', 10000, 1),
(25068, 254, 170, 'Egg Harbor', 10000, 1),
(25069, 254, 152, 'Egg Harbor Township', 10000, 1),
(25070, 254, 167, 'Eggleston', 10000, 1),
(25071, 254, 131, 'Eglin AFB', 10000, 1),
(25072, 254, 169, 'Eglon', 10000, 1),
(25073, 254, 127, 'Egnar', 10000, 1),
(25074, 254, 125, 'Egypt', 10000, 1),
(25075, 254, 165, 'Egypt', 10000, 1),
(25076, 254, 124, 'Ehrenberg', 10000, 1),
(25077, 254, 162, 'Ehrhardt', 10000, 1),
(25078, 254, 123, 'Eielson AFB', 10000, 1),
(25079, 254, 122, 'Eight Mile', 10000, 1),
(25080, 254, 139, 'Eighty Eight', 10000, 1),
(25081, 254, 160, 'Eighty Four', 10000, 1),
(25082, 254, 145, 'Eitzen', 10000, 1),
(25083, 254, 148, 'Ekalaka', 10000, 1),
(25084, 254, 139, 'Ekron', 10000, 1),
(25085, 254, 123, 'Ekwok', 10000, 1),
(25086, 254, 126, 'El Dorado', 10000, 1),
(25087, 254, 147, 'El Dorado Springs', 10000, 1),
(25088, 254, 165, 'El Indio', 10000, 1),
(25089, 254, 131, 'El Jobean', 10000, 1),
(25090, 254, 126, 'El Macero', 10000, 1),
(25091, 254, 124, 'El Mirage', 10000, 1),
(25092, 254, 126, 'El Nido', 10000, 1),
(25093, 254, 125, 'El Paso', 10000, 1),
(25094, 254, 135, 'El Paso', 10000, 1),
(25095, 254, 126, 'El Portal', 10000, 1),
(25096, 254, 153, 'El Prado', 10000, 1),
(25097, 254, 126, 'El Toro', 10000, 1),
(25098, 254, 126, 'El Verano', 10000, 1),
(25099, 254, 125, 'Elaine', 10000, 1),
(25100, 254, 170, 'Eland', 10000, 1),
(25101, 254, 154, 'Elba', 10000, 1),
(25102, 254, 168, 'Elbe', 10000, 1),
(25103, 254, 136, 'Elberfeld', 10000, 1),
(25104, 254, 137, 'Elberon', 10000, 1),
(25105, 254, 167, 'Elberon', 10000, 1),
(25106, 254, 127, 'Elbert', 10000, 1),
(25107, 254, 169, 'Elbert', 10000, 1),
(25108, 254, 144, 'Elberta', 10000, 1),
(25109, 254, 166, 'Elberta', 10000, 1),
(25110, 254, 138, 'Elbing', 10000, 1),
(25111, 254, 154, 'Elbridge', 10000, 1),
(25112, 254, 135, 'Elburn', 10000, 1),
(25113, 254, 170, 'Elcho', 10000, 1),
(25114, 254, 160, 'Elco', 10000, 1),
(25115, 254, 135, 'Eldena', 10000, 1),
(25116, 254, 170, 'Elderon', 10000, 1),
(25117, 254, 160, 'Eldersville', 10000, 1),
(25118, 254, 137, 'Eldon', 10000, 1),
(25119, 254, 147, 'Eldon', 10000, 1),
(25120, 254, 137, 'Eldora', 10000, 1),
(25121, 254, 157, 'Eldorado', 10000, 1),
(25122, 254, 158, 'Eldorado', 10000, 1),
(25123, 254, 170, 'Eldorado', 10000, 1),
(25124, 254, 127, 'Eldorado Springs', 10000, 1),
(25125, 254, 135, 'Eldred', 10000, 1),
(25126, 254, 154, 'Eldred', 10000, 1),
(25127, 254, 160, 'Eldred', 10000, 1),
(25128, 254, 122, 'Eldridge', 10000, 1),
(25129, 254, 126, 'Eldridge', 10000, 1),
(25130, 254, 137, 'Eldridge', 10000, 1),
(25131, 254, 147, 'Eldridge', 10000, 1),
(25132, 254, 169, 'Eleanor', 10000, 1),
(25133, 254, 165, 'Electra', 10000, 1),
(25134, 254, 168, 'Electric City', 10000, 1),
(25135, 254, 133, 'Eleele', 10000, 1),
(25136, 254, 153, 'Elephant Butte', 10000, 1),
(25137, 254, 135, 'Eleroy', 10000, 1),
(25138, 254, 170, 'Eleva', 10000, 1),
(25139, 254, 131, 'Elfers', 10000, 1),
(25140, 254, 123, 'Elfin Cove', 10000, 1),
(25141, 254, 124, 'Elfrida', 10000, 1),
(25142, 254, 145, 'Elgin', 10000, 1),
(25143, 254, 156, 'Elgin', 10000, 1),
(25144, 254, 149, 'Elgin', 10000, 1),
(25145, 254, 157, 'Elgin', 10000, 1),
(25146, 254, 158, 'Elgin', 10000, 1),
(25147, 254, 159, 'Elgin', 10000, 1),
(25148, 254, 160, 'Elgin', 10000, 1),
(25149, 254, 162, 'Elgin', 10000, 1),
(25150, 254, 164, 'Elgin', 10000, 1),
(25151, 254, 165, 'Elgin', 10000, 1),
(25152, 254, 153, 'Elida', 10000, 1),
(25153, 254, 123, 'Elim', 10000, 1),
(25154, 254, 141, 'Eliot', 10000, 1),
(25155, 254, 125, 'Elizabeth', 10000, 1),
(25156, 254, 127, 'Elizabeth', 10000, 1),
(25157, 254, 135, 'Elizabeth', 10000, 1),
(25158, 254, 136, 'Elizabeth', 10000, 1),
(25159, 254, 140, 'Elizabeth', 10000, 1),
(25160, 254, 145, 'Elizabeth', 10000, 1),
(25161, 254, 136, 'Elizabethtown', 10000, 1),
(25162, 254, 160, 'Elizabethville', 10000, 1),
(25163, 254, 139, 'Elizaville', 10000, 1),
(25164, 254, 154, 'Elizaville', 10000, 1),
(25165, 254, 126, 'Elk', 10000, 1),
(25166, 254, 168, 'Elk', 10000, 1),
(25167, 254, 138, 'Elk City', 10000, 1),
(25168, 254, 126, 'Elk Creek', 10000, 1),
(25169, 254, 147, 'Elk Creek', 10000, 1),
(25170, 254, 149, 'Elk Creek', 10000, 1),
(25171, 254, 167, 'Elk Creek', 10000, 1),
(25172, 254, 138, 'Elk Falls', 10000, 1),
(25173, 254, 169, 'Elk Garden', 10000, 1),
(25174, 254, 137, 'Elk Horn', 10000, 1),
(25175, 254, 139, 'Elk Horn', 10000, 1),
(25176, 254, 142, 'Elk Mills', 10000, 1),
(25177, 254, 170, 'Elk Mound', 10000, 1),
(25178, 254, 171, 'Elk Mountain', 10000, 1),
(25179, 254, 155, 'Elk Park', 10000, 1),
(25180, 254, 163, 'Elk Point', 10000, 1),
(25181, 254, 134, 'Elk River', 10000, 1),
(25182, 254, 154, 'Elka Park', 10000, 1),
(25183, 254, 139, 'Elkfork', 10000, 1),
(25184, 254, 137, 'Elkhart', 10000, 1),
(25185, 254, 135, 'Elkhart', 10000, 1),
(25186, 254, 165, 'Elkhart', 10000, 1),
(25187, 254, 170, 'Elkhart Lake', 10000, 1),
(25188, 254, 149, 'Elkhorn', 10000, 1),
(25189, 254, 169, 'Elkhorn', 10000, 1),
(25190, 254, 155, 'Elkin', 10000, 1),
(25191, 254, 125, 'Elkins', 10000, 1),
(25192, 254, 151, 'Elkins', 10000, 1),
(25193, 254, 160, 'Elkins Park', 10000, 1),
(25194, 254, 147, 'Elkland', 10000, 1),
(25195, 254, 160, 'Elkland', 10000, 1),
(25196, 254, 122, 'Elkmont', 10000, 1),
(25197, 254, 132, 'Elko', 10000, 1),
(25198, 254, 145, 'Elko', 10000, 1),
(25199, 254, 162, 'Elko', 10000, 1),
(25200, 254, 137, 'Elkport', 10000, 1),
(25201, 254, 131, 'Elkton', 10000, 1),
(25202, 254, 144, 'Elkton', 10000, 1),
(25203, 254, 145, 'Elkton', 10000, 1),
(25204, 254, 157, 'Elkton', 10000, 1),
(25205, 254, 159, 'Elkton', 10000, 1),
(25206, 254, 163, 'Elkton', 10000, 1),
(25207, 254, 164, 'Elkton', 10000, 1),
(25208, 254, 167, 'Elkton', 10000, 1),
(25209, 254, 169, 'Elkview', 10000, 1),
(25210, 254, 135, 'Elkville', 10000, 1),
(25211, 254, 167, 'Elkwood', 10000, 1),
(25212, 254, 132, 'Ellabell', 10000, 1),
(25213, 254, 169, 'Ellamore', 10000, 1),
(25214, 254, 155, 'Ellenboro', 10000, 1),
(25215, 254, 169, 'Ellenboro', 10000, 1),
(25216, 254, 154, 'Ellenburg', 10000, 1),
(25217, 254, 154, 'Ellenburg Center', 10000, 1),
(25218, 254, 154, 'Ellenburg Depot', 10000, 1),
(25219, 254, 129, 'Ellendale', 10000, 1),
(25220, 254, 145, 'Ellendale', 10000, 1),
(25221, 254, 164, 'Ellendale', 10000, 1),
(25222, 254, 131, 'Ellenton', 10000, 1),
(25223, 254, 132, 'Ellenton', 10000, 1),
(25224, 254, 132, 'Ellenwood', 10000, 1),
(25225, 254, 155, 'Ellerbe', 10000, 1),
(25226, 254, 132, 'Ellerslie', 10000, 1),
(25227, 254, 142, 'Ellerslie', 10000, 1),
(25228, 254, 135, 'Ellery', 10000, 1),
(25229, 254, 154, 'Ellicottville', 10000, 1),
(25230, 254, 165, 'Ellinger', 10000, 1),
(25231, 254, 128, 'Ellington', 10000, 1),
(25232, 254, 147, 'Ellington', 10000, 1),
(25233, 254, 154, 'Ellington', 10000, 1),
(25234, 254, 138, 'Ellinwood', 10000, 1),
(25235, 254, 137, 'Elliott', 10000, 1),
(25236, 254, 135, 'Elliott', 10000, 1),
(25237, 254, 146, 'Elliott', 10000, 1),
(25238, 254, 162, 'Elliott', 10000, 1),
(25239, 254, 160, 'Elliottsburg', 10000, 1),
(25240, 254, 139, 'Elliottville', 10000, 1),
(25241, 254, 134, 'Ellis', 10000, 1),
(25242, 254, 138, 'Ellis', 10000, 1),
(25243, 254, 135, 'Ellis Grove', 10000, 1),
(25244, 254, 154, 'Ellisburg', 10000, 1),
(25245, 254, 170, 'Ellison Bay', 10000, 1),
(25246, 254, 148, 'Elliston', 10000, 1),
(25247, 254, 167, 'Elliston', 10000, 1),
(25248, 254, 135, 'Ellisville', 10000, 1),
(25249, 254, 146, 'Ellisville', 10000, 1),
(25250, 254, 162, 'Elloree', 10000, 1),
(25251, 254, 147, 'Ellsinore', 10000, 1),
(25252, 254, 137, 'Ellston', 10000, 1),
(25253, 254, 135, 'Ellsworth', 10000, 1),
(25254, 254, 144, 'Ellsworth', 10000, 1),
(25255, 254, 145, 'Ellsworth', 10000, 1),
(25256, 254, 149, 'Ellsworth', 10000, 1),
(25257, 254, 157, 'Ellsworth', 10000, 1),
(25258, 254, 160, 'Ellsworth', 10000, 1),
(25259, 254, 170, 'Ellsworth', 10000, 1),
(25260, 254, 163, 'Ellsworth AFB', 10000, 1),
(25261, 254, 160, 'Elm', 10000, 1),
(25262, 254, 155, 'Elm City', 10000, 1),
(25263, 254, 149, 'Elm Creek', 10000, 1),
(25264, 254, 140, 'Elm Grove', 10000, 1),
(25265, 254, 170, 'Elm Grove', 10000, 1),
(25266, 254, 144, 'Elm Hall', 10000, 1),
(25267, 254, 165, 'Elm Mott', 10000, 1),
(25268, 254, 125, 'Elm Springs', 10000, 1),
(25269, 254, 163, 'Elm Springs', 10000, 1),
(25270, 254, 137, 'Elma', 10000, 1),
(25271, 254, 154, 'Elma', 10000, 1),
(25272, 254, 168, 'Elma', 10000, 1),
(25273, 254, 165, 'Elmaton', 10000, 1),
(25274, 254, 138, 'Elmdale', 10000, 1),
(25275, 254, 165, 'Elmendorf', 10000, 1),
(25276, 254, 140, 'Elmer', 10000, 1),
(25277, 254, 147, 'Elmer', 10000, 1),
(25278, 254, 158, 'Elmer', 10000, 1),
(25279, 254, 168, 'Elmer City', 10000, 1),
(25280, 254, 160, 'Elmhurst', 10000, 1),
(25281, 254, 126, 'Elmira', 10000, 1),
(25282, 254, 144, 'Elmira', 10000, 1),
(25283, 254, 159, 'Elmira', 10000, 1),
(25284, 254, 169, 'Elmira', 10000, 1),
(25285, 254, 147, 'Elmo', 10000, 1),
(25286, 254, 148, 'Elmo', 10000, 1),
(25287, 254, 165, 'Elmo', 10000, 1),
(25288, 254, 166, 'Elmo', 10000, 1),
(25289, 254, 160, 'Elmora', 10000, 1),
(25290, 254, 122, 'Elmore', 10000, 1),
(25291, 254, 145, 'Elmore', 10000, 1),
(25292, 254, 157, 'Elmore', 10000, 1),
(25293, 254, 158, 'Elmore City', 10000, 1),
(25294, 254, 135, 'Elmwood', 10000, 1),
(25295, 254, 143, 'Elmwood', 10000, 1),
(25296, 254, 149, 'Elmwood', 10000, 1),
(25297, 254, 164, 'Elmwood', 10000, 1),
(25298, 254, 170, 'Elmwood', 10000, 1),
(25299, 254, 136, 'Elnora', 10000, 1),
(25300, 254, 164, 'Elora', 10000, 1),
(25301, 254, 124, 'Eloy', 10000, 1),
(25302, 254, 160, 'Elrama', 10000, 1),
(25303, 254, 122, 'Elrod', 10000, 1),
(25304, 254, 145, 'Elrosa', 10000, 1),
(25305, 254, 170, 'Elroy', 10000, 1),
(25306, 254, 165, 'Elsa', 10000, 1),
(25307, 254, 139, 'Elsie', 10000, 1),
(25308, 254, 149, 'Elsie', 10000, 1),
(25309, 254, 166, 'Elsinore', 10000, 1),
(25310, 254, 149, 'Elsmere', 10000, 1),
(25311, 254, 138, 'Elsmore', 10000, 1),
(25312, 254, 140, 'Elton', 10000, 1),
(25313, 254, 160, 'Elton', 10000, 1),
(25314, 254, 170, 'Elton', 10000, 1),
(25315, 254, 169, 'Elton', 10000, 1),
(25316, 254, 168, 'Eltopia', 10000, 1),
(25317, 254, 135, 'Elvaston', 10000, 1),
(25318, 254, 160, 'Elverson', 10000, 1),
(25319, 254, 126, 'Elverta', 10000, 1),
(25320, 254, 144, 'Elwell', 10000, 1),
(25321, 254, 135, 'Elwin', 10000, 1),
(25322, 254, 137, 'Elwood', 10000, 1),
(25323, 254, 135, 'Elwood', 10000, 1),
(25324, 254, 138, 'Elwood', 10000, 1),
(25325, 254, 152, 'Elwood', 10000, 1),
(25326, 254, 137, 'Ely', 10000, 1),
(25327, 254, 149, 'Elyria', 10000, 1),
(25328, 254, 145, 'Elysian', 10000, 1),
(25329, 254, 165, 'Elysian Fields', 10000, 1),
(25330, 254, 145, 'Embarrass', 10000, 1),
(25331, 254, 170, 'Embarrass', 10000, 1),
(25332, 254, 171, 'Emblem', 10000, 1),
(25333, 254, 153, 'Embudo', 10000, 1),
(25334, 254, 135, 'Emden', 10000, 1),
(25335, 254, 147, 'Emden', 10000, 1),
(25336, 254, 160, 'Emeigh', 10000, 1),
(25337, 254, 122, 'Emelle', 10000, 1),
(25338, 254, 156, 'Emerado', 10000, 1),
(25339, 254, 170, 'Emerald', 10000, 1),
(25340, 254, 155, 'Emerald Isle', 10000, 1),
(25341, 254, 132, 'Emerson', 10000, 1),
(25342, 254, 137, 'Emerson', 10000, 1),
(25343, 254, 139, 'Emerson', 10000, 1),
(25344, 254, 149, 'Emerson', 10000, 1),
(25345, 254, 152, 'Emerson', 10000, 1),
(25346, 254, 163, 'Emery', 10000, 1),
(25347, 254, 166, 'Emery', 10000, 1),
(25348, 254, 148, 'Emigrant', 10000, 1),
(25349, 254, 160, 'Emigsville', 10000, 1),
(25350, 254, 145, 'Emily', 10000, 1),
(25351, 254, 136, 'Eminence', 10000, 1),
(25352, 254, 139, 'Eminence', 10000, 1),
(25353, 254, 135, 'Emington', 10000, 1),
(25354, 254, 160, 'Emlenton', 10000, 1),
(25355, 254, 139, 'Emlyn', 10000, 1),
(25356, 254, 135, 'Emma', 10000, 1),
(25357, 254, 147, 'Emma', 10000, 1),
(25358, 254, 139, 'Emmalena', 10000, 1),
(25359, 254, 160, 'Emmaus', 10000, 1),
(25360, 254, 125, 'Emmet', 10000, 1),
(25361, 254, 149, 'Emmet', 10000, 1),
(25362, 254, 138, 'Emmett', 10000, 1),
(25363, 254, 144, 'Emmett', 10000, 1),
(25364, 254, 123, 'Emmonak', 10000, 1),
(25365, 254, 145, 'Emmons', 10000, 1),
(25366, 254, 167, 'Emory', 10000, 1),
(25367, 254, 122, 'Empire', 10000, 1),
(25368, 254, 126, 'Empire', 10000, 1),
(25369, 254, 127, 'Empire', 10000, 1),
(25370, 254, 140, 'Empire', 10000, 1),
(25371, 254, 144, 'Empire', 10000, 1),
(25372, 254, 150, 'Empire', 10000, 1),
(25373, 254, 157, 'Empire', 10000, 1),
(25374, 254, 160, 'Emporium', 10000, 1),
(25375, 254, 171, 'Encampment', 10000, 1),
(25376, 254, 153, 'Encino', 10000, 1),
(25377, 254, 165, 'Encino', 10000, 1),
(25378, 254, 160, 'Endeavor', 10000, 1),
(25379, 254, 170, 'Endeavor', 10000, 1),
(25380, 254, 156, 'Enderlin', 10000, 1),
(25381, 254, 149, 'Enders', 10000, 1),
(25382, 254, 149, 'Endicott', 10000, 1),
(25383, 254, 168, 'Endicott', 10000, 1),
(25384, 254, 135, 'Energy', 10000, 1),
(25385, 254, 165, 'Energy', 10000, 1),
(25386, 254, 135, 'Enfield', 10000, 1),
(25387, 254, 155, 'Enfield', 10000, 1),
(25388, 254, 151, 'Enfield', 10000, 1),
(25389, 254, 151, 'Enfield Center', 10000, 1),
(25390, 254, 144, 'Engadine', 10000, 1),
(25391, 254, 155, 'Engelhard', 10000, 1),
(25392, 254, 125, 'England', 10000, 1),
(25393, 254, 138, 'Englewood', 10000, 1),
(25394, 254, 164, 'Englewood', 10000, 1),
(25395, 254, 152, 'Englewood Cliffs', 10000, 1),
(25396, 254, 169, 'English', 10000, 1),
(25397, 254, 146, 'Enid', 10000, 1),
(25398, 254, 132, 'Enigma', 10000, 1),
(25399, 254, 165, 'Enloe', 10000, 1),
(25400, 254, 155, 'Ennice', 10000, 1),
(25401, 254, 163, 'Enning', 10000, 1),
(25402, 254, 148, 'Ennis', 10000, 1),
(25403, 254, 165, 'Enochs', 10000, 1),
(25404, 254, 125, 'Enola', 10000, 1),
(25405, 254, 160, 'Enola', 10000, 1),
(25406, 254, 157, 'Enon', 10000, 1),
(25407, 254, 160, 'Enon Valley', 10000, 1),
(25408, 254, 162, 'Enoree', 10000, 1),
(25409, 254, 172, 'Enosburg Falls', 10000, 1),
(25410, 254, 138, 'Ensign', 10000, 1),
(25411, 254, 138, 'Enterprise', 10000, 1),
(25412, 254, 140, 'Enterprise', 10000, 1),
(25413, 254, 146, 'Enterprise', 10000, 1),
(25414, 254, 166, 'Enterprise', 10000, 1),
(25415, 254, 169, 'Enterprise', 10000, 1),
(25416, 254, 160, 'Entriken', 10000, 1),
(25417, 254, 164, 'Enville', 10000, 1),
(25418, 254, 135, 'Eola', 10000, 1),
(25419, 254, 165, 'Eola', 10000, 1),
(25420, 254, 139, 'Eolia', 10000, 1),
(25421, 254, 147, 'Eolia', 10000, 1),
(25422, 254, 122, 'Epes', 10000, 1),
(25423, 254, 170, 'Ephraim', 10000, 1),
(25424, 254, 156, 'Epping', 10000, 1),
(25425, 254, 151, 'Epping', 10000, 1),
(25426, 254, 140, 'Epps', 10000, 1),
(25427, 254, 151, 'Epsom', 10000, 1),
(25428, 254, 132, 'Epworth', 10000, 1),
(25429, 254, 137, 'Epworth', 10000, 1),
(25430, 254, 122, 'Equality', 10000, 1),
(25431, 254, 135, 'Equality', 10000, 1),
(25432, 254, 160, 'Equinunk', 10000, 1),
(25433, 254, 165, 'Era', 10000, 1),
(25434, 254, 169, 'Erbacon', 10000, 1),
(25435, 254, 145, 'Erhard', 10000, 1),
(25436, 254, 158, 'Erick', 10000, 1),
(25437, 254, 149, 'Ericson', 10000, 1),
(25438, 254, 138, 'Erie', 10000, 1),
(25439, 254, 144, 'Erie', 10000, 1),
(25440, 254, 156, 'Erie', 10000, 1),
(25441, 254, 154, 'Erieville', 10000, 1),
(25442, 254, 139, 'Eriline', 10000, 1),
(25443, 254, 154, 'Erin', 10000, 1),
(25444, 254, 139, 'Erlanger', 10000, 1),
(25445, 254, 139, 'Ermine', 10000, 1),
(25446, 254, 160, 'Ernest', 10000, 1),
(25447, 254, 155, 'Ernul', 10000, 1),
(25448, 254, 140, 'Eros', 10000, 1),
(25449, 254, 151, 'Errol', 10000, 1),
(25450, 254, 145, 'Erskine', 10000, 1),
(25451, 254, 143, 'Erving', 10000, 1),
(25452, 254, 155, 'Erwin', 10000, 1),
(25453, 254, 163, 'Erwin', 10000, 1),
(25454, 254, 160, 'Erwinna', 10000, 1),
(25455, 254, 140, 'Erwinville', 10000, 1),
(25456, 254, 138, 'Esbon', 10000, 1),
(25457, 254, 146, 'Escatawpa', 10000, 1),
(25458, 254, 169, 'Eskdale', 10000, 1),
(25459, 254, 145, 'Esko', 10000, 1),
(25460, 254, 138, 'Eskridge', 10000, 1),
(25461, 254, 135, 'Esmond', 10000, 1),
(25462, 254, 156, 'Esmond', 10000, 1),
(25463, 254, 167, 'Esmont', 10000, 1),
(25464, 254, 132, 'Esom Hill', 10000, 1),
(25465, 254, 154, 'Esopus', 10000, 1),
(25466, 254, 154, 'Esperance', 10000, 1),
(25467, 254, 126, 'Essex', 10000, 1),
(25468, 254, 128, 'Essex', 10000, 1),
(25469, 254, 137, 'Essex', 10000, 1),
(25470, 254, 135, 'Essex', 10000, 1),
(25471, 254, 143, 'Essex', 10000, 1),
(25472, 254, 147, 'Essex', 10000, 1),
(25473, 254, 148, 'Essex', 10000, 1),
(25474, 254, 154, 'Essex', 10000, 1),
(25475, 254, 172, 'Essex', 10000, 1),
(25476, 254, 152, 'Essex Fells', 10000, 1),
(25477, 254, 139, 'Essie', 10000, 1),
(25478, 254, 145, 'Essig', 10000, 1),
(25479, 254, 160, 'Essington', 10000, 1),
(25480, 254, 153, 'Estancia', 10000, 1),
(25481, 254, 141, 'Estcourt Station', 10000, 1),
(25482, 254, 152, 'Estell Manor', 10000, 1),
(25483, 254, 163, 'Estelline', 10000, 1),
(25484, 254, 165, 'Estelline', 10000, 1),
(25485, 254, 123, 'Ester', 10000, 1),
(25486, 254, 131, 'Estero', 10000, 1),
(25487, 254, 140, 'Estherwood', 10000, 1),
(25488, 254, 162, 'Estill', 10000, 1),
(25489, 254, 164, 'Estill Springs', 10000, 1),
(25490, 254, 122, 'Estillfork', 10000, 1),
(25491, 254, 163, 'Ethan', 10000, 1),
(25492, 254, 125, 'Ethel', 10000, 1),
(25493, 254, 140, 'Ethel', 10000, 1),
(25494, 254, 147, 'Ethel', 10000, 1),
(25495, 254, 146, 'Ethel', 10000, 1),
(25496, 254, 168, 'Ethel', 10000, 1),
(25497, 254, 169, 'Ethel', 10000, 1),
(25498, 254, 122, 'Ethelsville', 10000, 1),
(25499, 254, 155, 'Ether', 10000, 1),
(25500, 254, 148, 'Ethridge', 10000, 1),
(25501, 254, 164, 'Ethridge', 10000, 1),
(25502, 254, 167, 'Etlan', 10000, 1),
(25503, 254, 126, 'Etna', 10000, 1),
(25504, 254, 141, 'Etna', 10000, 1),
(25505, 254, 151, 'Etna', 10000, 1),
(25506, 254, 154, 'Etna', 10000, 1),
(25507, 254, 157, 'Etna', 10000, 1),
(25508, 254, 171, 'Etna', 10000, 1),
(25509, 254, 136, 'Etna Green', 10000, 1),
(25510, 254, 139, 'Etoile', 10000, 1),
(25511, 254, 165, 'Etoile', 10000, 1),
(25512, 254, 132, 'Eton', 10000, 1),
(25513, 254, 125, 'Etowah', 10000, 1),
(25514, 254, 164, 'Etowah', 10000, 1),
(25515, 254, 146, 'Etta', 10000, 1),
(25516, 254, 160, 'Etters', 10000, 1),
(25517, 254, 147, 'Etterville', 10000, 1),
(25518, 254, 170, 'Ettrick', 10000, 1),
(25519, 254, 139, 'Eubank', 10000, 1),
(25520, 254, 145, 'Euclid', 10000, 1),
(25521, 254, 125, 'Eudora', 10000, 1),
(25522, 254, 138, 'Eudora', 10000, 1),
(25523, 254, 147, 'Eudora', 10000, 1),
(25524, 254, 147, 'Eugene', 10000, 1),
(25525, 254, 147, 'Eunice', 10000, 1),
(25526, 254, 153, 'Eunice', 10000, 1),
(25527, 254, 146, 'Eupora', 10000, 1),
(25528, 254, 155, 'Eure', 10000, 1),
(25529, 254, 135, 'Eureka', 10000, 1),
(25530, 254, 144, 'Eureka', 10000, 1),
(25531, 254, 147, 'Eureka', 10000, 1),
(25532, 254, 148, 'Eureka', 10000, 1),
(25533, 254, 163, 'Eureka', 10000, 1),
(25534, 254, 166, 'Eureka', 10000, 1),
(25535, 254, 170, 'Eureka', 10000, 1),
(25536, 254, 141, 'Eustis', 10000, 1),
(25537, 254, 149, 'Eustis', 10000, 1),
(25538, 254, 162, 'Eutawville', 10000, 1),
(25539, 254, 122, 'Eva', 10000, 1),
(25540, 254, 164, 'Eva', 10000, 1),
(25541, 254, 165, 'Evadale', 10000, 1),
(25542, 254, 140, 'Evangeline', 10000, 1),
(25543, 254, 127, 'Evans', 10000, 1),
(25544, 254, 132, 'Evans', 10000, 1),
(25545, 254, 140, 'Evans', 10000, 1),
(25546, 254, 168, 'Evans', 10000, 1),
(25547, 254, 169, 'Evans', 10000, 1),
(25548, 254, 160, 'Evans City', 10000, 1),
(25549, 254, 154, 'Evans Mills', 10000, 1),
(25550, 254, 137, 'Evansdale', 10000, 1),
(25551, 254, 157, 'Evansport', 10000, 1),
(25552, 254, 136, 'Evanston', 10000, 1),
(25553, 254, 125, 'Evansville', 10000, 1),
(25554, 254, 135, 'Evansville', 10000, 1),
(25555, 254, 145, 'Evansville', 10000, 1),
(25556, 254, 171, 'Evansville', 10000, 1),
(25557, 254, 144, 'Evart', 10000, 1),
(25558, 254, 139, 'Evarts', 10000, 1),
(25559, 254, 125, 'Evening Shade', 10000, 1),
(25560, 254, 164, 'Evensville', 10000, 1),
(25561, 254, 138, 'Everest', 10000, 1),
(25562, 254, 160, 'Everett', 10000, 1),
(25563, 254, 155, 'Everetts', 10000, 1),
(25564, 254, 169, 'Everettville', 10000, 1),
(25565, 254, 140, 'Evergreen', 10000, 1),
(25566, 254, 167, 'Evergreen', 10000, 1),
(25567, 254, 160, 'Everson', 10000, 1),
(25568, 254, 168, 'Everson', 10000, 1),
(25569, 254, 125, 'Everton', 10000, 1),
(25570, 254, 147, 'Everton', 10000, 1),
(25571, 254, 167, 'Evington', 10000, 1),
(25572, 254, 131, 'Evinston', 10000, 1),
(25573, 254, 152, 'Ewan', 10000, 1),
(25574, 254, 142, 'Ewell', 10000, 1),
(25575, 254, 144, 'Ewen', 10000, 1),
(25576, 254, 135, 'Ewing', 10000, 1),
(25577, 254, 139, 'Ewing', 10000, 1),
(25578, 254, 147, 'Ewing', 10000, 1),
(25579, 254, 149, 'Ewing', 10000, 1),
(25580, 254, 167, 'Ewing', 10000, 1),
(25581, 254, 122, 'Excel', 10000, 1),
(25582, 254, 147, 'Excello', 10000, 1),
(25583, 254, 160, 'Excelsior', 10000, 1),
(25584, 254, 169, 'Exchange', 10000, 1),
(25585, 254, 170, 'Exeland', 10000, 1),
(25586, 254, 126, 'Exeter', 10000, 1),
(25587, 254, 141, 'Exeter', 10000, 1),
(25588, 254, 147, 'Exeter', 10000, 1),
(25589, 254, 149, 'Exeter', 10000, 1),
(25590, 254, 137, 'Exira', 10000, 1),
(25591, 254, 137, 'Exline', 10000, 1),
(25592, 254, 167, 'Exmore', 10000, 1),
(25593, 254, 132, 'Experiment', 10000, 1),
(25594, 254, 160, 'Export', 10000, 1),
(25595, 254, 145, 'Eyota', 10000, 1),
(25596, 254, 139, 'Ezel', 10000, 1),
(25597, 254, 165, 'Fabens', 10000, 1),
(25598, 254, 167, 'Faber', 10000, 1),
(25599, 254, 154, 'Fabius', 10000, 1),
(25600, 254, 128, 'Fabyan', 10000, 1),
(25601, 254, 122, 'Fackler', 10000, 1),
(25602, 254, 147, 'Fagus', 10000, 1),
(25603, 254, 155, 'Fair Bluff', 10000, 1),
(25604, 254, 152, 'Fair Haven', 10000, 1),
(25605, 254, 154, 'Fair Haven', 10000, 1),
(25606, 254, 172, 'Fair Haven', 10000, 1),
(25607, 254, 136, 'Fair Oaks', 10000, 1),
(25608, 254, 162, 'Fair Play', 10000, 1),
(25609, 254, 153, 'Fairacres', 10000, 1),
(25610, 254, 137, 'Fairbank', 10000, 1),
(25611, 254, 160, 'Fairbank', 10000, 1),
(25612, 254, 136, 'Fairbanks', 10000, 1),
(25613, 254, 140, 'Fairbanks', 10000, 1),
(25614, 254, 132, 'Fairburn', 10000, 1),
(25615, 254, 163, 'Fairburn', 10000, 1),
(25616, 254, 135, 'Fairbury', 10000, 1),
(25617, 254, 160, 'Fairchance', 10000, 1),
(25618, 254, 170, 'Fairchild', 10000, 1),
(25619, 254, 168, 'Fairchild Air Force Base', 10000, 1),
(25620, 254, 139, 'Fairdale', 10000, 1),
(25621, 254, 156, 'Fairdale', 10000, 1),
(25622, 254, 169, 'Fairdale', 10000, 1),
(25623, 254, 147, 'Fairdealing', 10000, 1),
(25624, 254, 137, 'Fairfax', 10000, 1),
(25625, 254, 145, 'Fairfax', 10000, 1),
(25626, 254, 147, 'Fairfax', 10000, 1),
(25627, 254, 158, 'Fairfax', 10000, 1),
(25628, 254, 162, 'Fairfax', 10000, 1),
(25629, 254, 163, 'Fairfax', 10000, 1),
(25631, 254, 167, 'Fairfax Station', 10000, 1),
(25632, 254, 122, 'Fairfield', 10000, 1),
(25633, 254, 131, 'Fairfield', 10000, 1),
(25634, 254, 134, 'Fairfield', 10000, 1),
(25635, 254, 139, 'Fairfield', 10000, 1),
(25636, 254, 148, 'Fairfield', 10000, 1),
(25637, 254, 155, 'Fairfield', 10000, 1),
(25638, 254, 156, 'Fairfield', 10000, 1),
(25639, 254, 149, 'Fairfield', 10000, 1),
(25640, 254, 167, 'Fairfield', 10000, 1),
(25641, 254, 172, 'Fairfield', 10000, 1),
(25642, 254, 168, 'Fairfield', 10000, 1),
(25643, 254, 125, 'Fairfield Bay', 10000, 1),
(25644, 254, 162, 'Fairforest', 10000, 1),
(25645, 254, 144, 'Fairgrove', 10000, 1),
(25646, 254, 122, 'Fairhope', 10000, 1),
(25647, 254, 160, 'Fairhope', 10000, 1),
(25648, 254, 136, 'Fairland', 10000, 1),
(25649, 254, 158, 'Fairland', 10000, 1),
(25650, 254, 169, 'Fairlea', 10000, 1),
(25651, 254, 172, 'Fairlee', 10000, 1),
(25652, 254, 160, 'Fairless Hills', 10000, 1),
(25653, 254, 149, 'Fairmont', 10000, 1),
(25654, 254, 158, 'Fairmont', 10000, 1),
(25655, 254, 132, 'Fairmount', 10000, 1),
(25656, 254, 135, 'Fairmount', 10000, 1),
(25657, 254, 136, 'Fairmount', 10000, 1),
(25658, 254, 156, 'Fairmount', 10000, 1),
(25659, 254, 160, 'Fairmount City', 10000, 1),
(25660, 254, 127, 'Fairplay', 10000, 1),
(25661, 254, 139, 'Fairplay', 10000, 1),
(25662, 254, 142, 'Fairplay', 10000, 1),
(25663, 254, 157, 'Fairpoint', 10000, 1),
(25664, 254, 147, 'Fairport', 10000, 1),
(25665, 254, 135, 'Fairview', 10000, 1),
(25666, 254, 138, 'Fairview', 10000, 1),
(25667, 254, 139, 'Fairview', 10000, 1),
(25668, 254, 144, 'Fairview', 10000, 1),
(25669, 254, 147, 'Fairview', 10000, 1),
(25670, 254, 148, 'Fairview', 10000, 1),
(25671, 254, 155, 'Fairview', 10000, 1),
(25672, 254, 152, 'Fairview', 10000, 1),
(25673, 254, 159, 'Fairview', 10000, 1),
(25674, 254, 160, 'Fairview', 10000, 1),
(25675, 254, 164, 'Fairview', 10000, 1),
(25676, 254, 166, 'Fairview', 10000, 1),
(25677, 254, 169, 'Fairview', 10000, 1),
(25678, 254, 171, 'Fairview', 10000, 1),
(25679, 254, 160, 'Fairview Village', 10000, 1),
(25680, 254, 170, 'Fairwater', 10000, 1),
(25681, 254, 155, 'Faith', 10000, 1),
(25682, 254, 163, 'Faith', 10000, 1),
(25683, 254, 139, 'Falcon', 10000, 1),
(25684, 254, 147, 'Falcon', 10000, 1),
(25685, 254, 146, 'Falcon', 10000, 1),
(25686, 254, 155, 'Falcon', 10000, 1),
(25687, 254, 165, 'Falcon Heights', 10000, 1),
(25688, 254, 154, 'Falconer', 10000, 1),
(25689, 254, 155, 'Falkland', 10000, 1),
(25690, 254, 146, 'Falkner', 10000, 1),
(25691, 254, 122, 'Falkville', 10000, 1),
(25692, 254, 164, 'Fall Branch', 10000, 1),
(25693, 254, 159, 'Fall Creek', 10000, 1),
(25694, 254, 170, 'Fall Creek', 10000, 1),
(25695, 254, 138, 'Fall River', 10000, 1),
(25696, 254, 170, 'Fall River', 10000, 1),
(25697, 254, 139, 'Fall Rock', 10000, 1),
(25698, 254, 160, 'Fallentimber', 10000, 1),
(25699, 254, 169, 'Falling Rock', 10000, 1),
(25700, 254, 169, 'Falling Waters', 10000, 1),
(25701, 254, 148, 'Fallon', 10000, 1),
(25702, 254, 160, 'Falls', 10000, 1),
(25704, 254, 159, 'Falls City', 10000, 1),
(25705, 254, 165, 'Falls City', 10000, 1),
(25706, 254, 160, 'Falls Creek', 10000, 1),
(25707, 254, 167, 'Falls Mills', 10000, 1),
(25708, 254, 139, 'Falls of Rough', 10000, 1),
(25709, 254, 128, 'Falls Village', 10000, 1),
(25710, 254, 154, 'Fallsburg', 10000, 1),
(25711, 254, 142, 'Fallston', 10000, 1),
(25712, 254, 155, 'Fallston', 10000, 1),
(25713, 254, 136, 'Falmouth', 10000, 1),
(25714, 254, 141, 'Falmouth', 10000, 1),
(25715, 254, 144, 'Falmouth', 10000, 1),
(25716, 254, 123, 'False Pass', 10000, 1),
(25717, 254, 138, 'Falun', 10000, 1),
(25718, 254, 154, 'Fancher', 10000, 1),
(25719, 254, 139, 'Fancy Farm', 10000, 1),
(25720, 254, 167, 'Fancy Gap', 10000, 1),
(25721, 254, 160, 'Fannettsburg', 10000, 1),
(25722, 254, 165, 'Fannin', 10000, 1),
(25723, 254, 169, 'Fanrock', 10000, 1),
(25724, 254, 158, 'Fanshawe', 10000, 1),
(25725, 254, 152, 'Fanwood', 10000, 1),
(25726, 254, 152, 'Far Hills', 10000, 1),
(25727, 254, 154, 'Far Rockaway', 10000, 1),
(25728, 254, 147, 'Farber', 10000, 1),
(25729, 254, 132, 'Fargo', 10000, 1),
(25730, 254, 158, 'Fargo', 10000, 1),
(25731, 254, 135, 'Farina', 10000, 1),
(25732, 254, 137, 'Farley', 10000, 1),
(25733, 254, 147, 'Farley', 10000, 1),
(25734, 254, 138, 'Farlington', 10000, 1),
(25735, 254, 157, 'Farmdale', 10000, 1),
(25736, 254, 157, 'Farmer', 10000, 1),
(25737, 254, 135, 'Farmer City', 10000, 1),
(25738, 254, 139, 'Farmers', 10000, 1),
(25739, 254, 137, 'Farmersburg', 10000, 1),
(25740, 254, 136, 'Farmersburg', 10000, 1),
(25741, 254, 126, 'Farmersville', 10000, 1),
(25742, 254, 135, 'Farmersville', 10000, 1),
(25743, 254, 157, 'Farmersville', 10000, 1),
(25744, 254, 154, 'Farmersville Station', 10000, 1),
(25745, 254, 141, 'Farmingdale', 10000, 1),
(25746, 254, 152, 'Farmingdale', 10000, 1),
(25747, 254, 125, 'Farmington', 10000, 1),
(25748, 254, 126, 'Farmington', 10000, 1),
(25749, 254, 132, 'Farmington', 10000, 1),
(25750, 254, 137, 'Farmington', 10000, 1),
(25751, 254, 135, 'Farmington', 10000, 1),
(25752, 254, 139, 'Farmington', 10000, 1),
(25753, 254, 145, 'Farmington', 10000, 1),
(25754, 254, 151, 'Farmington', 10000, 1),
(25755, 254, 160, 'Farmington', 10000, 1),
(25756, 254, 166, 'Farmington', 10000, 1),
(25757, 254, 168, 'Farmington', 10000, 1),
(25758, 254, 169, 'Farmington', 10000, 1),
(25759, 254, 141, 'Farmington Falls', 10000, 1),
(25760, 254, 154, 'Farmingville', 10000, 1),
(25761, 254, 136, 'Farmland', 10000, 1),
(25762, 254, 155, 'Farmville', 10000, 1),
(25763, 254, 149, 'Farnam', 10000, 1),
(25764, 254, 164, 'Farner', 10000, 1),
(25765, 254, 154, 'Farnham', 10000, 1),
(25766, 254, 167, 'Farnham', 10000, 1),
(25767, 254, 137, 'Farnhamville', 10000, 1),
(25768, 254, 165, 'Farnsworth', 10000, 1),
(25769, 254, 137, 'Farragut', 10000, 1),
(25770, 254, 147, 'Farrar', 10000, 1),
(25771, 254, 146, 'Farrell', 10000, 1),
(25772, 254, 160, 'Farrell', 10000, 1),
(25773, 254, 171, 'Farson', 10000, 1),
(25774, 254, 144, 'Farwell', 10000, 1),
(25775, 254, 145, 'Farwell', 10000, 1),
(25776, 254, 149, 'Farwell', 10000, 1),
(25777, 254, 165, 'Fate', 10000, 1),
(25778, 254, 147, 'Faucett', 10000, 1),
(25779, 254, 142, 'Faulkner', 10000, 1),
(25780, 254, 122, 'Faunsdale', 10000, 1),
(25781, 254, 160, 'Fawn Grove', 10000, 1),
(25782, 254, 126, 'Fawnskin', 10000, 1),
(25783, 254, 158, 'Faxon', 10000, 1),
(25784, 254, 158, 'Fay', 10000, 1),
(25785, 254, 154, 'Fayette', 10000, 1),
(25786, 254, 157, 'Fayette', 10000, 1),
(25787, 254, 166, 'Fayette', 10000, 1),
(25788, 254, 160, 'Fayette City', 10000, 1),
(25789, 254, 154, 'Fayetteville', 10000, 1),
(25790, 254, 157, 'Fayetteville', 10000, 1),
(25791, 254, 160, 'Fayetteville', 10000, 1),
(25792, 254, 165, 'Fayetteville', 10000, 1),
(25793, 254, 169, 'Fayetteville', 10000, 1),
(25794, 254, 143, 'Fayville', 10000, 1),
(25795, 254, 153, 'Faywood', 10000, 1),
(25796, 254, 171, 'FE Warren AFB', 10000, 1),
(25797, 254, 126, 'Feather Falls', 10000, 1),
(25798, 254, 131, 'Fedhaven', 10000, 1),
(25799, 254, 163, 'Fedora', 10000, 1),
(25800, 254, 139, 'Fedscreek', 10000, 1),
(25801, 254, 143, 'Feeding Hills', 10000, 1),
(25802, 254, 157, 'Feesburg', 10000, 1),
(25803, 254, 144, 'Felch', 10000, 1),
(25804, 254, 131, 'Felda', 10000, 1),
(25805, 254, 157, 'Felicity', 10000, 1),
(25806, 254, 126, 'Fellows', 10000, 1),
(25807, 254, 131, 'Fellsmere', 10000, 1),
(25808, 254, 134, 'Felt', 10000, 1),
(25809, 254, 158, 'Felt', 10000, 1),
(25810, 254, 129, 'Felton', 10000, 1),
(25811, 254, 132, 'Felton', 10000, 1),
(25812, 254, 145, 'Felton', 10000, 1),
(25813, 254, 160, 'Felton', 10000, 1),
(25814, 254, 154, 'Felts Mills', 10000, 1),
(25815, 254, 170, 'Fence', 10000, 1),
(25816, 254, 153, 'Fence Lake', 10000, 1),
(25817, 254, 160, 'Fenelton', 10000, 1),
(25818, 254, 134, 'Fenn', 10000, 1),
(25819, 254, 170, 'Fennimore', 10000, 1),
(25820, 254, 137, 'Fenton', 10000, 1),
(25821, 254, 135, 'Fenton', 10000, 1),
(25822, 254, 140, 'Fenton', 10000, 1),
(25823, 254, 147, 'Fenton', 10000, 1),
(25824, 254, 165, 'Fentress', 10000, 1),
(25825, 254, 144, 'Fenwick', 10000, 1),
(25826, 254, 169, 'Fenwick', 10000, 1),
(25827, 254, 129, 'Fenwick Island', 10000, 1),
(25828, 254, 134, 'Ferdinand', 10000, 1),
(25829, 254, 136, 'Ferdinand', 10000, 1),
(25830, 254, 137, 'Ferguson', 10000, 1),
(25831, 254, 139, 'Ferguson', 10000, 1),
(25832, 254, 155, 'Ferguson', 10000, 1),
(25833, 254, 131, 'Ferndale', 10000, 1),
(25834, 254, 160, 'Ferndale', 10000, 1),
(25835, 254, 163, 'Ferney', 10000, 1),
(25836, 254, 134, 'Fernwood', 10000, 1),
(25837, 254, 146, 'Fernwood', 10000, 1),
(25838, 254, 140, 'Ferriday', 10000, 1),
(25839, 254, 135, 'Ferris', 10000, 1),
(25840, 254, 172, 'Ferrisburg', 10000, 1),
(25841, 254, 166, 'Ferron', 10000, 1),
(25842, 254, 170, 'Ferryville', 10000, 1),
(25843, 254, 137, 'Fertile', 10000, 1),
(25844, 254, 145, 'Fertile', 10000, 1),
(25845, 254, 147, 'Festus', 10000, 1),
(25846, 254, 154, 'Feura Bush', 10000, 1),
(25847, 254, 135, 'Fiatt', 10000, 1),
(25848, 254, 126, 'Fiddletown', 10000, 1),
(25849, 254, 135, 'Fidelity', 10000, 1),
(25850, 254, 167, 'Fieldale', 10000, 1),
(25851, 254, 166, 'Fielding', 10000, 1),
(25852, 254, 135, 'Fieldon', 10000, 1),
(25853, 254, 159, 'Fields', 10000, 1),
(25854, 254, 126, 'Fields Landing', 10000, 1),
(25855, 254, 165, 'Fieldton', 10000, 1),
(25856, 254, 167, 'Fife', 10000, 1),
(25857, 254, 144, 'Fife Lake', 10000, 1),
(25858, 254, 170, 'Fifield', 10000, 1),
(25859, 254, 145, 'Fifty Lakes', 10000, 1),
(25860, 254, 125, 'Fifty Six', 10000, 1),
(25861, 254, 134, 'Filer', 10000, 1),
(25862, 254, 144, 'Filer City', 10000, 1),
(25863, 254, 144, 'Filion', 10000, 1),
(25864, 254, 149, 'Filley', 10000, 1),
(25865, 254, 135, 'Fillmore', 10000, 1),
(25866, 254, 136, 'Fillmore', 10000, 1),
(25867, 254, 147, 'Fillmore', 10000, 1),
(25868, 254, 154, 'Fillmore', 10000, 1),
(25869, 254, 139, 'Finchville', 10000, 1),
(25870, 254, 135, 'Findlay', 10000, 1),
(25871, 254, 154, 'Findley Lake', 10000, 1),
(25872, 254, 154, 'Fine', 10000, 1),
(25873, 254, 156, 'Fingal', 10000, 1),
(25874, 254, 164, 'Finger', 10000, 1),
(25875, 254, 162, 'Fingerville', 10000, 1),
(25876, 254, 145, 'Finland', 10000, 1),
(25877, 254, 126, 'Finley', 10000, 1),
(25878, 254, 158, 'Finley', 10000, 1),
(25879, 254, 164, 'Finley', 10000, 1),
(25880, 254, 160, 'Finleyville', 10000, 1),
(25881, 254, 136, 'Finly', 10000, 1),
(25882, 254, 126, 'Firebaugh', 10000, 1),
(25883, 254, 139, 'Firebrick', 10000, 1),
(25884, 254, 163, 'Firesteel', 10000, 1),
(25885, 254, 127, 'Firestone', 10000, 1),
(25886, 254, 149, 'Firth', 10000, 1),
(25887, 254, 165, 'Fischer', 10000, 1),
(25888, 254, 126, 'Fish Camp', 10000, 1),
(25889, 254, 170, 'Fish Creek', 10000, 1),
(25890, 254, 134, 'Fish Haven', 10000, 1),
(25891, 254, 125, 'Fisher', 10000, 1),
(25892, 254, 135, 'Fisher', 10000, 1),
(25893, 254, 140, 'Fisher', 10000, 1),
(25894, 254, 145, 'Fisher', 10000, 1),
(25895, 254, 160, 'Fisher', 10000, 1),
(25896, 254, 169, 'Fisher', 10000, 1),
(25897, 254, 154, 'Fishers', 10000, 1),
(25898, 254, 167, 'Fishers Hill', 10000, 1),
(25899, 254, 154, 'Fishers Island', 10000, 1),
(25900, 254, 154, 'Fishers Landing', 10000, 1),
(25901, 254, 167, 'Fishersville', 10000, 1),
(25902, 254, 160, 'Fishertown', 10000, 1),
(25903, 254, 139, 'Fisherville', 10000, 1),
(25904, 254, 142, 'Fishing Creek', 10000, 1),
(25905, 254, 154, 'Fishkill', 10000, 1),
(25906, 254, 154, 'Fishs Eddy', 10000, 1),
(25907, 254, 148, 'Fishtail', 10000, 1),
(25908, 254, 147, 'Fisk', 10000, 1),
(25909, 254, 143, 'Fiskdale', 10000, 1),
(25910, 254, 161, 'Fiskeville', 10000, 1),
(25911, 254, 139, 'Fisty', 10000, 1),
(25912, 254, 135, 'Fithian', 10000, 1),
(25913, 254, 158, 'Fittstown', 10000, 1),
(25914, 254, 158, 'Fitzhugh', 10000, 1),
(25915, 254, 122, 'Fitzpatrick', 10000, 1),
(25916, 254, 151, 'Fitzwilliam', 10000, 1),
(25917, 254, 122, 'Five Points', 10000, 1),
(25918, 254, 126, 'Five Points', 10000, 1),
(25919, 254, 164, 'Five Points', 10000, 1),
(25920, 254, 164, 'Flag Pond', 10000, 1),
(25921, 254, 127, 'Flagler', 10000, 1),
(25922, 254, 152, 'Flagtown', 10000, 1),
(25923, 254, 156, 'Flasher', 10000, 1),
(25924, 254, 123, 'Flat', 10000, 1),
(25925, 254, 165, 'Flat', 10000, 1),
(25926, 254, 139, 'Flat Lick', 10000, 1),
(25927, 254, 122, 'Flat Rock', 10000, 1),
(25928, 254, 136, 'Flat Rock', 10000, 1),
(25929, 254, 144, 'Flat Rock', 10000, 1),
(25930, 254, 155, 'Flat Rock', 10000, 1),
(25931, 254, 157, 'Flat Rock', 10000, 1),
(25932, 254, 169, 'Flat Top', 10000, 1),
(25933, 254, 139, 'Flatgap', 10000, 1),
(25934, 254, 165, 'Flatonia', 10000, 1),
(25935, 254, 139, 'Flatwoods', 10000, 1),
(25936, 254, 140, 'Flatwoods', 10000, 1),
(25937, 254, 169, 'Flatwoods', 10000, 1),
(25938, 254, 156, 'Flaxton', 10000, 1),
(25939, 254, 148, 'Flaxville', 10000, 1),
(25940, 254, 160, 'Fleetville', 10000, 1),
(25941, 254, 155, 'Fleetwood', 10000, 1),
(25942, 254, 160, 'Fleetwood', 10000, 1),
(25943, 254, 127, 'Fleming', 10000, 1),
(25944, 254, 132, 'Fleming', 10000, 1),
(25945, 254, 157, 'Fleming', 10000, 1),
(25946, 254, 160, 'Fleming', 10000, 1),
(25947, 254, 147, 'Flemington', 10000, 1),
(25948, 254, 169, 'Flemington', 10000, 1),
(25949, 254, 145, 'Flensburg', 10000, 1),
(25950, 254, 147, 'Fletcher', 10000, 1),
(25951, 254, 155, 'Fletcher', 10000, 1),
(25952, 254, 157, 'Fletcher', 10000, 1),
(25953, 254, 158, 'Fletcher', 10000, 1),
(25954, 254, 160, 'Flicksville', 10000, 1),
(25955, 254, 165, 'Flint', 10000, 1),
(25956, 254, 167, 'Flint Hill', 10000, 1),
(25957, 254, 147, 'Flinthill', 10000, 1),
(25958, 254, 160, 'Flinton', 10000, 1),
(25959, 254, 132, 'Flintstone', 10000, 1),
(25960, 254, 142, 'Flintstone', 10000, 1),
(25961, 254, 164, 'Flintville', 10000, 1),
(25962, 254, 125, 'Flippin', 10000, 1),
(25963, 254, 145, 'Flom', 10000, 1),
(25964, 254, 122, 'Flomaton', 10000, 1),
(25965, 254, 165, 'Flomot', 10000, 1),
(25966, 254, 145, 'Floodwood', 10000, 1),
(25967, 254, 140, 'Flora', 10000, 1),
(25968, 254, 146, 'Flora', 10000, 1),
(25969, 254, 153, 'Flora Vista', 10000, 1),
(25970, 254, 131, 'Florahome', 10000, 1),
(25971, 254, 125, 'Floral', 10000, 1),
(25973, 254, 124, 'Florence', 10000, 1),
(25974, 254, 127, 'Florence', 10000, 1),
(25975, 254, 136, 'Florence', 10000, 1),
(25976, 254, 138, 'Florence', 10000, 1),
(25977, 254, 147, 'Florence', 10000, 1),
(25978, 254, 146, 'Florence', 10000, 1),
(25979, 254, 152, 'Florence', 10000, 1),
(25980, 254, 163, 'Florence', 10000, 1),
(25981, 254, 165, 'Florence', 10000, 1),
(25982, 254, 172, 'Florence', 10000, 1),
(25983, 254, 152, 'Florham Park', 10000, 1),
(25984, 254, 140, 'Florien', 10000, 1),
(25985, 254, 137, 'Floris', 10000, 1),
(25986, 254, 126, 'Floriston', 10000, 1),
(25987, 254, 135, 'Flossmoor', 10000, 1),
(25988, 254, 126, 'Flournoy', 10000, 1),
(25989, 254, 160, 'Flourtown', 10000, 1),
(25990, 254, 132, 'Flovilla', 10000, 1),
(25991, 254, 148, 'Floweree', 10000, 1),
(25992, 254, 137, 'Floyd', 10000, 1),
(25993, 254, 153, 'Floyd', 10000, 1),
(25994, 254, 162, 'Floyd Dale', 10000, 1),
(25995, 254, 136, 'Floyds Knobs', 10000, 1),
(25996, 254, 140, 'Fluker', 10000, 1),
(25997, 254, 157, 'Flushing', 10000, 1),
(25998, 254, 165, 'Fluvanna', 10000, 1),
(25999, 254, 154, 'Fly Creek', 10000, 1),
(26000, 254, 165, 'Flynn', 10000, 1),
(26001, 254, 160, 'Fogelsville', 10000, 1),
(26002, 254, 147, 'Foley', 10000, 1),
(26003, 254, 169, 'Follansbee', 10000, 1),
(26004, 254, 165, 'Follett', 10000, 1),
(26005, 254, 162, 'Folly Beach', 10000, 1),
(26006, 254, 140, 'Folsom', 10000, 1),
(26007, 254, 153, 'Folsom', 10000, 1),
(26008, 254, 160, 'Folsom', 10000, 1),
(26009, 254, 169, 'Folsom', 10000, 1),
(26010, 254, 136, 'Folsomville', 10000, 1),
(26011, 254, 160, 'Fombell', 10000, 1),
(26012, 254, 137, 'Fonda', 10000, 1),
(26013, 254, 138, 'Fontana', 10000, 1),
(26014, 254, 170, 'Fontana', 10000, 1),
(26015, 254, 155, 'Fontana Dam', 10000, 1),
(26016, 254, 137, 'Fontanelle', 10000, 1),
(26017, 254, 136, 'Fontanet', 10000, 1),
(26018, 254, 135, 'Foosland', 10000, 1),
(26019, 254, 170, 'Footville', 10000, 1),
(26020, 254, 145, 'Forbes', 10000, 1),
(26021, 254, 156, 'Forbes', 10000, 1),
(26022, 254, 160, 'Forbes Road', 10000, 1),
(26023, 254, 126, 'Forbestown', 10000, 1),
(26024, 254, 160, 'Force', 10000, 1),
(26025, 254, 138, 'Ford', 10000, 1),
(26026, 254, 139, 'Ford', 10000, 1),
(26027, 254, 167, 'Ford', 10000, 1),
(26028, 254, 168, 'Ford', 10000, 1),
(26029, 254, 160, 'Ford Cliff', 10000, 1),
(26030, 254, 147, 'Fordland', 10000, 1),
(26031, 254, 140, 'Fordoche', 10000, 1),
(26032, 254, 139, 'Fords Branch', 10000, 1),
(26033, 254, 139, 'Fordsville', 10000, 1),
(26034, 254, 156, 'Fordville', 10000, 1),
(26035, 254, 149, 'Fordyce', 10000, 1),
(26036, 254, 125, 'Foreman', 10000, 1),
(26037, 254, 136, 'Forest', 10000, 1),
(26038, 254, 140, 'Forest', 10000, 1),
(26039, 254, 167, 'Forest', 10000, 1),
(26040, 254, 135, 'Forest City', 10000, 1),
(26041, 254, 147, 'Forest City', 10000, 1),
(26042, 254, 172, 'Forest Dale', 10000, 1),
(26043, 254, 126, 'Forest Falls', 10000, 1),
(26044, 254, 160, 'Forest Grove', 10000, 1),
(26045, 254, 140, 'Forest Hill', 10000, 1),
(26046, 254, 142, 'Forest Hill', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(26047, 254, 169, 'Forest Hill', 10000, 1),
(26048, 254, 139, 'Forest Hills', 10000, 1),
(26049, 254, 122, 'Forest Home', 10000, 1),
(26050, 254, 170, 'Forest Junction', 10000, 1),
(26051, 254, 126, 'Forest Knolls', 10000, 1),
(26052, 254, 124, 'Forest Lakes', 10000, 1),
(26053, 254, 132, 'Forest Park', 10000, 1),
(26054, 254, 135, 'Forest Park', 10000, 1),
(26055, 254, 126, 'Forest Ranch', 10000, 1),
(26056, 254, 156, 'Forest River', 10000, 1),
(26057, 254, 165, 'Forestburg', 10000, 1),
(26058, 254, 154, 'Forestburgh', 10000, 1),
(26059, 254, 143, 'Forestdale', 10000, 1),
(26060, 254, 161, 'Forestdale', 10000, 1),
(26061, 254, 148, 'Forestgrove', 10000, 1),
(26062, 254, 145, 'Foreston', 10000, 1),
(26063, 254, 154, 'Forestport', 10000, 1),
(26064, 254, 144, 'Forestville', 10000, 1),
(26065, 254, 154, 'Forestville', 10000, 1),
(26066, 254, 160, 'Forestville', 10000, 1),
(26067, 254, 170, 'Forestville', 10000, 1),
(26068, 254, 147, 'Foristell', 10000, 1),
(26069, 254, 142, 'Fork', 10000, 1),
(26070, 254, 162, 'Fork', 10000, 1),
(26071, 254, 167, 'Fork Union', 10000, 1),
(26072, 254, 122, 'Forkland', 10000, 1),
(26073, 254, 126, 'Forks of Salmon', 10000, 1),
(26074, 254, 160, 'Forksville', 10000, 1),
(26075, 254, 138, 'Formoso', 10000, 1),
(26076, 254, 165, 'Forney', 10000, 1),
(26077, 254, 135, 'Forrest', 10000, 1),
(26078, 254, 135, 'Forreston', 10000, 1),
(26079, 254, 165, 'Forreston', 10000, 1),
(26080, 254, 165, 'Forsan', 10000, 1),
(26081, 254, 135, 'Forsyth', 10000, 1),
(26082, 254, 148, 'Forsyth', 10000, 1),
(26083, 254, 154, 'Fort Ann', 10000, 1),
(26084, 254, 124, 'Fort Apache', 10000, 1),
(26085, 254, 169, 'Fort Ashby', 10000, 1),
(26086, 254, 137, 'Fort Atkinson', 10000, 1),
(26087, 254, 153, 'Fort Bayard', 10000, 1),
(26088, 254, 148, 'Fort Benton', 10000, 1),
(26089, 254, 126, 'Fort Bidwell', 10000, 1),
(26090, 254, 167, 'Fort Blackmore', 10000, 1),
(26091, 254, 155, 'Fort Bragg', 10000, 1),
(26092, 254, 171, 'Fort Bridger', 10000, 1),
(26093, 254, 149, 'Fort Calhoun', 10000, 1),
(26094, 254, 158, 'Fort Cobb', 10000, 1),
(26095, 254, 154, 'Fort Covington', 10000, 1),
(26096, 254, 122, 'Fort Davis', 10000, 1),
(26097, 254, 124, 'Fort Defiance', 10000, 1),
(26098, 254, 167, 'Fort Defiance', 10000, 1),
(26099, 254, 122, 'Fort Deposit', 10000, 1),
(26100, 254, 126, 'Fort Dick', 10000, 1),
(26101, 254, 154, 'Fort Drum', 10000, 1),
(26102, 254, 166, 'Fort Duchesne', 10000, 1),
(26103, 254, 154, 'Fort Edward', 10000, 1),
(26104, 254, 167, 'Fort Eustis', 10000, 1),
(26105, 254, 127, 'Fort Garland', 10000, 1),
(26106, 254, 169, 'Fort Gay', 10000, 1),
(26107, 254, 158, 'Fort Gibson', 10000, 1),
(26108, 254, 134, 'Fort Hall', 10000, 1),
(26109, 254, 165, 'Fort Hancock', 10000, 1),
(26110, 254, 148, 'Fort Harrison', 10000, 1),
(26111, 254, 160, 'Fort Hill', 10000, 1),
(26112, 254, 142, 'Fort Howard', 10000, 1),
(26113, 254, 124, 'Fort Huachuca', 10000, 1),
(26114, 254, 154, 'Fort Hunter', 10000, 1),
(26115, 254, 126, 'Fort Irwin', 10000, 1),
(26116, 254, 157, 'Fort Jennings', 10000, 1),
(26117, 254, 154, 'Fort Johnson', 10000, 1),
(26118, 254, 141, 'Fort Kent Mills', 10000, 1),
(26119, 254, 159, 'Fort Klamath', 10000, 1),
(26120, 254, 139, 'Fort Knox', 10000, 1),
(26121, 254, 171, 'Fort Laramie', 10000, 1),
(26122, 254, 138, 'Fort Leavenworth', 10000, 1),
(26123, 254, 167, 'Fort Lee', 10000, 1),
(26124, 254, 147, 'Fort Leonard Wood', 10000, 1),
(26125, 254, 160, 'Fort Littleton', 10000, 1),
(26126, 254, 157, 'Fort Loramie', 10000, 1),
(26127, 254, 160, 'Fort Loudon', 10000, 1),
(26128, 254, 127, 'Fort Lyon', 10000, 1),
(26129, 254, 131, 'Fort Mc Coy', 10000, 1),
(26130, 254, 165, 'Fort Mc Kavett', 10000, 1),
(26131, 254, 124, 'Fort McDowell', 10000, 1),
(26132, 254, 131, 'Fort Meade', 10000, 1),
(26133, 254, 163, 'Fort Meade', 10000, 1),
(26134, 254, 122, 'Fort Mitchell', 10000, 1),
(26135, 254, 167, 'Fort Mitchell', 10000, 1),
(26136, 254, 124, 'Fort Mohave', 10000, 1),
(26137, 254, 152, 'Fort Monmouth', 10000, 1),
(26138, 254, 167, 'Fort Monroe', 10000, 1),
(26139, 254, 154, 'Fort Montgomery', 10000, 1),
(26140, 254, 140, 'Fort Necessity', 10000, 1),
(26141, 254, 131, 'Fort Ogden', 10000, 1),
(26142, 254, 132, 'Fort Oglethorpe', 10000, 1),
(26143, 254, 148, 'Fort Peck', 10000, 1),
(26144, 254, 163, 'Fort Pierre', 10000, 1),
(26145, 254, 156, 'Fort Ransom', 10000, 1),
(26146, 254, 157, 'Fort Recovery', 10000, 1),
(26147, 254, 123, 'Fort Richardson', 10000, 1),
(26148, 254, 138, 'Fort Riley', 10000, 1),
(26149, 254, 145, 'Fort Ripley', 10000, 1),
(26150, 254, 136, 'Fort Ritner', 10000, 1),
(26151, 254, 159, 'Fort Rock', 10000, 1),
(26152, 254, 133, 'Fort Shafter', 10000, 1),
(26153, 254, 148, 'Fort Shaw', 10000, 1),
(26154, 254, 135, 'Fort Sheridan', 10000, 1),
(26155, 254, 169, 'Fort Spring', 10000, 1),
(26156, 254, 153, 'Fort Stanton', 10000, 1),
(26157, 254, 158, 'Fort Supply', 10000, 1),
(26158, 254, 124, 'Fort Thomas', 10000, 1),
(26159, 254, 163, 'Fort Thompson', 10000, 1),
(26160, 254, 156, 'Fort Totten', 10000, 1),
(26161, 254, 158, 'Fort Towson', 10000, 1),
(26162, 254, 167, 'Fort Valley', 10000, 1),
(26163, 254, 123, 'Fort Wainwright', 10000, 1),
(26164, 254, 171, 'Fort Washakie', 10000, 1),
(26165, 254, 160, 'Fort Washington', 10000, 1),
(26166, 254, 131, 'Fort White', 10000, 1),
(26167, 254, 153, 'Fort Wingate', 10000, 1),
(26168, 254, 152, 'Fortescue', 10000, 1),
(26169, 254, 148, 'Fortine', 10000, 1),
(26170, 254, 132, 'Fortson', 10000, 1),
(26171, 254, 126, 'Fortuna', 10000, 1),
(26172, 254, 147, 'Fortuna', 10000, 1),
(26173, 254, 156, 'Fortuna', 10000, 1),
(26174, 254, 158, 'Foss', 10000, 1),
(26175, 254, 159, 'Fossil', 10000, 1),
(26176, 254, 145, 'Fosston', 10000, 1),
(26177, 254, 139, 'Foster', 10000, 1),
(26178, 254, 147, 'Foster', 10000, 1),
(26179, 254, 149, 'Foster', 10000, 1),
(26180, 254, 158, 'Foster', 10000, 1),
(26181, 254, 159, 'Foster', 10000, 1),
(26182, 254, 167, 'Foster', 10000, 1),
(26183, 254, 169, 'Foster', 10000, 1),
(26184, 254, 144, 'Foster City', 10000, 1),
(26185, 254, 122, 'Fosters', 10000, 1),
(26186, 254, 164, 'Fosterville', 10000, 1),
(26187, 254, 137, 'Fostoria', 10000, 1),
(26188, 254, 138, 'Fostoria', 10000, 1),
(26189, 254, 144, 'Fountain', 10000, 1),
(26190, 254, 145, 'Fountain', 10000, 1),
(26191, 254, 155, 'Fountain', 10000, 1),
(26192, 254, 170, 'Fountain City', 10000, 1),
(26193, 254, 166, 'Fountain Green', 10000, 1),
(26194, 254, 125, 'Fountain Hill', 10000, 1),
(26195, 254, 124, 'Fountain Hills', 10000, 1),
(26196, 254, 162, 'Fountain Inn', 10000, 1),
(26197, 254, 139, 'Fountain Run', 10000, 1),
(26198, 254, 136, 'Fountaintown', 10000, 1),
(26199, 254, 160, 'Fountainville', 10000, 1),
(26200, 254, 171, 'Four Corners', 10000, 1),
(26201, 254, 168, 'Four Lakes', 10000, 1),
(26202, 254, 155, 'Four Oaks', 10000, 1),
(26203, 254, 169, 'Four States', 10000, 1),
(26204, 254, 139, 'Fourmile', 10000, 1),
(26205, 254, 126, 'Fowler', 10000, 1),
(26206, 254, 127, 'Fowler', 10000, 1),
(26207, 254, 135, 'Fowler', 10000, 1),
(26208, 254, 138, 'Fowler', 10000, 1),
(26209, 254, 144, 'Fowler', 10000, 1),
(26210, 254, 157, 'Fowler', 10000, 1),
(26211, 254, 136, 'Fowlerton', 10000, 1),
(26212, 254, 165, 'Fowlerton', 10000, 1),
(26213, 254, 132, 'Fowlstown', 10000, 1),
(26214, 254, 125, 'Fox', 10000, 1),
(26215, 254, 158, 'Fox', 10000, 1),
(26216, 254, 159, 'Fox', 10000, 1),
(26217, 254, 168, 'Fox Island', 10000, 1),
(26218, 254, 135, 'Fox Lake', 10000, 1),
(26219, 254, 170, 'Fox Lake', 10000, 1),
(26220, 254, 135, 'Fox Valley', 10000, 1),
(26221, 254, 170, 'Foxboro', 10000, 1),
(26222, 254, 160, 'Foxburg', 10000, 1),
(26223, 254, 145, 'Foxhome', 10000, 1),
(26224, 254, 146, 'Foxworth', 10000, 1),
(26225, 254, 158, 'Foyil', 10000, 1),
(26226, 254, 160, 'Frackville', 10000, 1),
(26227, 254, 139, 'Frakes', 10000, 1),
(26228, 254, 169, 'Frametown', 10000, 1),
(26229, 254, 151, 'Francestown', 10000, 1),
(26230, 254, 136, 'Francesville', 10000, 1),
(26231, 254, 158, 'Francis', 10000, 1),
(26232, 254, 170, 'Francis Creek', 10000, 1),
(26233, 254, 136, 'Francisco', 10000, 1),
(26234, 254, 165, 'Francitas', 10000, 1),
(26235, 254, 151, 'Franconia', 10000, 1),
(26236, 254, 160, 'Franconia', 10000, 1),
(26237, 254, 164, 'Frankewing', 10000, 1),
(26238, 254, 129, 'Frankford', 10000, 1),
(26239, 254, 147, 'Frankford', 10000, 1),
(26240, 254, 169, 'Frankford', 10000, 1),
(26241, 254, 138, 'Frankfort', 10000, 1),
(26242, 254, 141, 'Frankfort', 10000, 1),
(26243, 254, 154, 'Frankfort', 10000, 1),
(26244, 254, 157, 'Frankfort', 10000, 1),
(26245, 254, 163, 'Frankfort', 10000, 1),
(26246, 254, 135, 'Frankfort Heights', 10000, 1),
(26247, 254, 122, 'Franklin', 10000, 1),
(26248, 254, 125, 'Franklin', 10000, 1),
(26249, 254, 134, 'Franklin', 10000, 1),
(26250, 254, 135, 'Franklin', 10000, 1),
(26251, 254, 141, 'Franklin', 10000, 1),
(26252, 254, 145, 'Franklin', 10000, 1),
(26253, 254, 147, 'Franklin', 10000, 1),
(26254, 254, 151, 'Franklin', 10000, 1),
(26255, 254, 154, 'Franklin', 10000, 1),
(26256, 254, 165, 'Franklin', 10000, 1),
(26257, 254, 172, 'Franklin', 10000, 1),
(26258, 254, 135, 'Franklin Grove', 10000, 1),
(26259, 254, 152, 'Franklin Lakes', 10000, 1),
(26260, 254, 152, 'Franklin Park', 10000, 1),
(26261, 254, 132, 'Franklin Springs', 10000, 1),
(26262, 254, 154, 'Franklin Springs', 10000, 1),
(26263, 254, 140, 'Franklinton', 10000, 1),
(26264, 254, 155, 'Franklinton', 10000, 1),
(26265, 254, 160, 'Franklintown', 10000, 1),
(26266, 254, 155, 'Franklinville', 10000, 1),
(26267, 254, 152, 'Franklinville', 10000, 1),
(26268, 254, 154, 'Franklinville', 10000, 1),
(26269, 254, 165, 'Frankston', 10000, 1),
(26270, 254, 170, 'Franksville', 10000, 1),
(26271, 254, 136, 'Frankton', 10000, 1),
(26272, 254, 127, 'Franktown', 10000, 1),
(26273, 254, 167, 'Franktown', 10000, 1),
(26274, 254, 122, 'Frankville', 10000, 1),
(26275, 254, 171, 'Frannie', 10000, 1),
(26276, 254, 127, 'Fraser', 10000, 1),
(26277, 254, 144, 'Fraser', 10000, 1),
(26278, 254, 148, 'Frazer', 10000, 1),
(26279, 254, 157, 'Frazeysburg', 10000, 1),
(26280, 254, 169, 'Fraziers Bottom', 10000, 1),
(26281, 254, 165, 'Fred', 10000, 1),
(26282, 254, 144, 'Frederic', 10000, 1),
(26283, 254, 170, 'Frederic', 10000, 1),
(26284, 254, 129, 'Frederica', 10000, 1),
(26285, 254, 127, 'Frederick', 10000, 1),
(26286, 254, 135, 'Frederick', 10000, 1),
(26287, 254, 160, 'Frederick', 10000, 1),
(26288, 254, 163, 'Frederick', 10000, 1),
(26289, 254, 137, 'Fredericksburg', 10000, 1),
(26290, 254, 136, 'Fredericksburg', 10000, 1),
(26291, 254, 157, 'Fredericksburg', 10000, 1),
(26293, 254, 137, 'Frederika', 10000, 1),
(26294, 254, 124, 'Fredonia', 10000, 1),
(26295, 254, 139, 'Fredonia', 10000, 1),
(26296, 254, 156, 'Fredonia', 10000, 1),
(26297, 254, 165, 'Fredonia', 10000, 1),
(26298, 254, 170, 'Fredonia', 10000, 1),
(26299, 254, 144, 'Free Soil', 10000, 1),
(26300, 254, 167, 'Free Union', 10000, 1),
(26301, 254, 145, 'Freeborn', 10000, 1),
(26302, 254, 135, 'Freeburg', 10000, 1),
(26303, 254, 147, 'Freeburg', 10000, 1),
(26304, 254, 160, 'Freeburg', 10000, 1),
(26305, 254, 139, 'Freeburn', 10000, 1),
(26306, 254, 126, 'Freedom', 10000, 1),
(26307, 254, 136, 'Freedom', 10000, 1),
(26308, 254, 141, 'Freedom', 10000, 1),
(26309, 254, 151, 'Freedom', 10000, 1),
(26310, 254, 154, 'Freedom', 10000, 1),
(26311, 254, 158, 'Freedom', 10000, 1),
(26312, 254, 160, 'Freedom', 10000, 1),
(26313, 254, 170, 'Freedom', 10000, 1),
(26314, 254, 171, 'Freedom', 10000, 1),
(26315, 254, 154, 'Freehold', 10000, 1),
(26316, 254, 142, 'Freeland', 10000, 1),
(26317, 254, 144, 'Freeland', 10000, 1),
(26318, 254, 136, 'Freelandville', 10000, 1),
(26319, 254, 147, 'Freeman', 10000, 1),
(26320, 254, 163, 'Freeman', 10000, 1),
(26321, 254, 167, 'Freeman', 10000, 1),
(26322, 254, 168, 'Freeman', 10000, 1),
(26323, 254, 169, 'Freeman', 10000, 1),
(26324, 254, 135, 'Freeman Spur', 10000, 1),
(26325, 254, 131, 'Freeport', 10000, 1),
(26326, 254, 138, 'Freeport', 10000, 1),
(26327, 254, 144, 'Freeport', 10000, 1),
(26328, 254, 145, 'Freeport', 10000, 1),
(26329, 254, 157, 'Freeport', 10000, 1),
(26330, 254, 160, 'Freeport', 10000, 1),
(26331, 254, 165, 'Freer', 10000, 1),
(26332, 254, 136, 'Freetown', 10000, 1),
(26333, 254, 154, 'Freeville', 10000, 1),
(26334, 254, 147, 'Freistatt', 10000, 1),
(26335, 254, 137, 'Fremont', 10000, 1),
(26336, 254, 136, 'Fremont', 10000, 1),
(26337, 254, 147, 'Fremont', 10000, 1),
(26338, 254, 155, 'Fremont', 10000, 1),
(26339, 254, 151, 'Fremont', 10000, 1),
(26340, 254, 170, 'Fremont', 10000, 1),
(26341, 254, 154, 'Fremont Center', 10000, 1),
(26342, 254, 146, 'French Camp', 10000, 1),
(26343, 254, 169, 'French Creek', 10000, 1),
(26344, 254, 126, 'French Gulch', 10000, 1),
(26345, 254, 140, 'French Settlement', 10000, 1),
(26346, 254, 147, 'French Village', 10000, 1),
(26347, 254, 141, 'Frenchboro', 10000, 1),
(26348, 254, 159, 'Frenchglen', 10000, 1),
(26349, 254, 125, 'Frenchmans Bayou', 10000, 1),
(26350, 254, 169, 'Frenchton', 10000, 1),
(26351, 254, 148, 'Frenchtown', 10000, 1),
(26352, 254, 141, 'Frenchville', 10000, 1),
(26353, 254, 160, 'Frenchville', 10000, 1),
(26354, 254, 154, 'Fresh Meadows', 10000, 1),
(26355, 254, 157, 'Fresno', 10000, 1),
(26356, 254, 165, 'Fresno', 10000, 1),
(26357, 254, 154, 'Frewsburg', 10000, 1),
(26358, 254, 126, 'Friant', 10000, 1),
(26359, 254, 146, 'Friars Point', 10000, 1),
(26360, 254, 160, 'Friedens', 10000, 1),
(26361, 254, 160, 'Friedensburg', 10000, 1),
(26362, 254, 147, 'Friedheim', 10000, 1),
(26363, 254, 149, 'Friend', 10000, 1),
(26364, 254, 169, 'Friendly', 10000, 1),
(26365, 254, 125, 'Friendship', 10000, 1),
(26366, 254, 136, 'Friendship', 10000, 1),
(26367, 254, 142, 'Friendship', 10000, 1),
(26368, 254, 141, 'Friendship', 10000, 1),
(26369, 254, 154, 'Friendship', 10000, 1),
(26370, 254, 157, 'Friendship', 10000, 1),
(26371, 254, 160, 'Friendsville', 10000, 1),
(26372, 254, 164, 'Friendsville', 10000, 1),
(26373, 254, 140, 'Frierson', 10000, 1),
(26374, 254, 167, 'Fries', 10000, 1),
(26375, 254, 170, 'Friesland', 10000, 1),
(26376, 254, 165, 'Friona', 10000, 1),
(26377, 254, 127, 'Frisco', 10000, 1),
(26378, 254, 155, 'Frisco', 10000, 1),
(26379, 254, 122, 'Frisco City', 10000, 1),
(26380, 254, 165, 'Fritch', 10000, 1),
(26381, 254, 147, 'Frohna', 10000, 1),
(26382, 254, 148, 'Froid', 10000, 1),
(26383, 254, 148, 'Fromberg', 10000, 1),
(26384, 254, 138, 'Frontenac', 10000, 1),
(26385, 254, 145, 'Frontenac', 10000, 1),
(26386, 254, 144, 'Frontier', 10000, 1),
(26387, 254, 171, 'Frontier', 10000, 1),
(26388, 254, 145, 'Frost', 10000, 1),
(26389, 254, 165, 'Frost', 10000, 1),
(26390, 254, 160, 'Frostburg', 10000, 1),
(26391, 254, 131, 'Frostproof', 10000, 1),
(26392, 254, 127, 'Fruita', 10000, 1),
(26393, 254, 122, 'Fruitdale', 10000, 1),
(26394, 254, 163, 'Fruitdale', 10000, 1),
(26395, 254, 122, 'Fruithurst', 10000, 1),
(26396, 254, 137, 'Fruitland', 10000, 1),
(26397, 254, 142, 'Fruitland', 10000, 1),
(26398, 254, 153, 'Fruitland', 10000, 1),
(26399, 254, 166, 'Fruitland', 10000, 1),
(26400, 254, 168, 'Fruitland', 10000, 1),
(26401, 254, 131, 'Fruitland Park', 10000, 1),
(26402, 254, 134, 'Fruitvale', 10000, 1),
(26403, 254, 164, 'Fruitvale', 10000, 1),
(26404, 254, 165, 'Fruitvale', 10000, 1),
(26405, 254, 160, 'Fryburg', 10000, 1),
(26406, 254, 141, 'Fryeburg', 10000, 1),
(26407, 254, 139, 'Ft Mitchell', 10000, 1),
(26408, 254, 167, 'Ft Myer', 10000, 1),
(26409, 254, 136, 'Fulda', 10000, 1),
(26410, 254, 145, 'Fulda', 10000, 1),
(26411, 254, 167, 'Fulks Run', 10000, 1),
(26412, 254, 140, 'Fullerton', 10000, 1),
(26413, 254, 156, 'Fullerton', 10000, 1),
(26414, 254, 165, 'Fulshear', 10000, 1),
(26415, 254, 122, 'Fulton', 10000, 1),
(26416, 254, 125, 'Fulton', 10000, 1),
(26417, 254, 126, 'Fulton', 10000, 1),
(26418, 254, 136, 'Fulton', 10000, 1),
(26419, 254, 138, 'Fulton', 10000, 1),
(26420, 254, 139, 'Fulton', 10000, 1),
(26421, 254, 142, 'Fulton', 10000, 1),
(26422, 254, 144, 'Fulton', 10000, 1),
(26423, 254, 154, 'Fulton', 10000, 1),
(26424, 254, 157, 'Fulton', 10000, 1),
(26425, 254, 163, 'Fulton', 10000, 1),
(26426, 254, 165, 'Fulton', 10000, 1),
(26427, 254, 122, 'Fultondale', 10000, 1),
(26428, 254, 154, 'Fultonham', 10000, 1),
(26429, 254, 157, 'Fultonham', 10000, 1),
(26430, 254, 135, 'Fults', 10000, 1),
(26431, 254, 149, 'Funk', 10000, 1),
(26432, 254, 142, 'Funkstown', 10000, 1),
(26433, 254, 132, 'Funston', 10000, 1),
(26434, 254, 155, 'Fuquay Varina', 10000, 1),
(26435, 254, 160, 'Furlong', 10000, 1),
(26436, 254, 162, 'Furman', 10000, 1),
(26437, 254, 144, 'Gaastra', 10000, 1),
(26438, 254, 150, 'Gabbs', 10000, 1),
(26439, 254, 162, 'Gable', 10000, 1),
(26440, 254, 154, 'Gabriels', 10000, 1),
(26441, 254, 156, 'Gackle', 10000, 1),
(26442, 254, 124, 'Gadsden', 10000, 1),
(26443, 254, 162, 'Gadsden', 10000, 1),
(26444, 254, 164, 'Gadsden', 10000, 1),
(26445, 254, 144, 'Gagetown', 10000, 1),
(26446, 254, 144, 'Gaines', 10000, 1),
(26447, 254, 160, 'Gaines', 10000, 1),
(26448, 254, 122, 'Gainestown', 10000, 1),
(26449, 254, 122, 'Gainesville', 10000, 1),
(26450, 254, 154, 'Gainesville', 10000, 1),
(26451, 254, 148, 'Galata', 10000, 1),
(26452, 254, 135, 'Galatia', 10000, 1),
(26453, 254, 138, 'Galena', 10000, 1),
(26454, 254, 142, 'Galena', 10000, 1),
(26455, 254, 157, 'Galena', 10000, 1),
(26456, 254, 165, 'Galena Park', 10000, 1),
(26457, 254, 159, 'Gales Creek', 10000, 1),
(26458, 254, 138, 'Galesburg', 10000, 1),
(26459, 254, 144, 'Galesburg', 10000, 1),
(26460, 254, 156, 'Galesburg', 10000, 1),
(26461, 254, 142, 'Galesville', 10000, 1),
(26462, 254, 170, 'Galesville', 10000, 1),
(26463, 254, 127, 'Galeton', 10000, 1),
(26464, 254, 160, 'Galeton', 10000, 1),
(26465, 254, 144, 'Galien', 10000, 1),
(26466, 254, 162, 'Galivants Ferry', 10000, 1),
(26467, 254, 169, 'Gallagher', 10000, 1),
(26468, 254, 122, 'Gallant', 10000, 1),
(26469, 254, 165, 'Gallatin', 10000, 1),
(26470, 254, 148, 'Gallatin Gateway', 10000, 1),
(26471, 254, 164, 'Gallaway', 10000, 1),
(26472, 254, 153, 'Gallina', 10000, 1),
(26473, 254, 122, 'Gallion', 10000, 1),
(26474, 254, 169, 'Gallipolis Ferry', 10000, 1),
(26475, 254, 160, 'Gallitzin', 10000, 1),
(26476, 254, 146, 'Gallman', 10000, 1),
(26477, 254, 170, 'Galloway', 10000, 1),
(26478, 254, 169, 'Galloway', 10000, 1),
(26479, 254, 154, 'Gallupville', 10000, 1),
(26480, 254, 137, 'Galt', 10000, 1),
(26481, 254, 135, 'Galt', 10000, 1),
(26482, 254, 147, 'Galt', 10000, 1),
(26483, 254, 137, 'Galva', 10000, 1),
(26484, 254, 135, 'Galva', 10000, 1),
(26485, 254, 138, 'Galva', 10000, 1),
(26486, 254, 136, 'Galveston', 10000, 1),
(26487, 254, 168, 'Galvin', 10000, 1),
(26488, 254, 125, 'Gamaliel', 10000, 1),
(26489, 254, 139, 'Gamaliel', 10000, 1),
(26490, 254, 123, 'Gambell', 10000, 1),
(26491, 254, 157, 'Gambier', 10000, 1),
(26492, 254, 142, 'Gambrills', 10000, 1),
(26493, 254, 153, 'Gamerco', 10000, 1),
(26494, 254, 124, 'Ganado', 10000, 1),
(26495, 254, 165, 'Ganado', 10000, 1),
(26496, 254, 169, 'Gandeeville', 10000, 1),
(26497, 254, 163, 'Gann Valley', 10000, 1),
(26498, 254, 158, 'Gans', 10000, 1),
(26499, 254, 160, 'Gans', 10000, 1),
(26500, 254, 154, 'Gansevoort', 10000, 1),
(26501, 254, 122, 'Gantt', 10000, 1),
(26502, 254, 160, 'Gap', 10000, 1),
(26503, 254, 169, 'Gap Mills', 10000, 1),
(26504, 254, 142, 'Gapland', 10000, 1),
(26505, 254, 139, 'Gapville', 10000, 1),
(26506, 254, 160, 'Garards Fort', 10000, 1),
(26507, 254, 137, 'Garber', 10000, 1),
(26508, 254, 158, 'Garber', 10000, 1),
(26509, 254, 127, 'Garcia', 10000, 1),
(26510, 254, 165, 'Garciasville', 10000, 1),
(26511, 254, 144, 'Garden', 10000, 1),
(26512, 254, 137, 'Garden City', 10000, 1),
(26513, 254, 134, 'Garden City', 10000, 1),
(26514, 254, 140, 'Garden City', 10000, 1),
(26515, 254, 145, 'Garden City', 10000, 1),
(26516, 254, 147, 'Garden City', 10000, 1),
(26517, 254, 163, 'Garden City', 10000, 1),
(26518, 254, 166, 'Garden City', 10000, 1),
(26519, 254, 137, 'Garden Grove', 10000, 1),
(26520, 254, 138, 'Garden Plain', 10000, 1),
(26521, 254, 135, 'Garden Prairie', 10000, 1),
(26522, 254, 134, 'Garden Valley', 10000, 1),
(26523, 254, 165, 'Gardendale', 10000, 1),
(26524, 254, 160, 'Gardenville', 10000, 1),
(26525, 254, 148, 'Gardiner', 10000, 1),
(26526, 254, 154, 'Gardiner', 10000, 1),
(26527, 254, 159, 'Gardiner', 10000, 1),
(26528, 254, 135, 'Gardner', 10000, 1),
(26529, 254, 140, 'Gardner', 10000, 1),
(26530, 254, 156, 'Gardner', 10000, 1),
(26531, 254, 160, 'Gardners', 10000, 1),
(26532, 254, 125, 'Garfield', 10000, 1),
(26533, 254, 132, 'Garfield', 10000, 1),
(26534, 254, 138, 'Garfield', 10000, 1),
(26535, 254, 139, 'Garfield', 10000, 1),
(26536, 254, 145, 'Garfield', 10000, 1),
(26537, 254, 153, 'Garfield', 10000, 1),
(26538, 254, 168, 'Garfield', 10000, 1),
(26539, 254, 159, 'Garibaldi', 10000, 1),
(26540, 254, 153, 'Garita', 10000, 1),
(26541, 254, 138, 'Garland', 10000, 1),
(26542, 254, 141, 'Garland', 10000, 1),
(26543, 254, 155, 'Garland', 10000, 1),
(26544, 254, 149, 'Garland', 10000, 1),
(26545, 254, 160, 'Garland', 10000, 1),
(26546, 254, 166, 'Garland', 10000, 1),
(26547, 254, 125, 'Garland City', 10000, 1),
(26548, 254, 137, 'Garnavillo', 10000, 1),
(26549, 254, 148, 'Garneill', 10000, 1),
(26550, 254, 125, 'Garner', 10000, 1),
(26551, 254, 139, 'Garner', 10000, 1),
(26552, 254, 154, 'Garnerville', 10000, 1),
(26553, 254, 162, 'Garnett', 10000, 1),
(26554, 254, 139, 'Garrard', 10000, 1),
(26555, 254, 154, 'Garrattsville', 10000, 1),
(26556, 254, 139, 'Garrett', 10000, 1),
(26557, 254, 160, 'Garrett', 10000, 1),
(26558, 254, 171, 'Garrett', 10000, 1),
(26559, 254, 142, 'Garrett Park', 10000, 1),
(26560, 254, 157, 'Garrettsville', 10000, 1),
(26561, 254, 137, 'Garrison', 10000, 1),
(26562, 254, 139, 'Garrison', 10000, 1),
(26563, 254, 142, 'Garrison', 10000, 1),
(26564, 254, 145, 'Garrison', 10000, 1),
(26565, 254, 147, 'Garrison', 10000, 1),
(26566, 254, 148, 'Garrison', 10000, 1),
(26567, 254, 165, 'Garrison', 10000, 1),
(26568, 254, 166, 'Garrison', 10000, 1),
(26569, 254, 167, 'Garrisonville', 10000, 1),
(26570, 254, 148, 'Garryowen', 10000, 1),
(26571, 254, 145, 'Garvin', 10000, 1),
(26572, 254, 158, 'Garvin', 10000, 1),
(26573, 254, 137, 'Garwin', 10000, 1),
(26574, 254, 152, 'Garwood', 10000, 1),
(26575, 254, 165, 'Garwood', 10000, 1),
(26576, 254, 145, 'Gary', 10000, 1),
(26577, 254, 163, 'Gary', 10000, 1),
(26578, 254, 165, 'Gary', 10000, 1),
(26579, 254, 169, 'Gary', 10000, 1),
(26580, 254, 155, 'Garysburg', 10000, 1),
(26581, 254, 140, 'Garyville', 10000, 1),
(26582, 254, 138, 'Gas', 10000, 1),
(26583, 254, 167, 'Gasburg', 10000, 1),
(26584, 254, 147, 'Gasconade', 10000, 1),
(26585, 254, 154, 'Gasport', 10000, 1),
(26586, 254, 126, 'Gasquet', 10000, 1),
(26587, 254, 169, 'Gassaway', 10000, 1),
(26588, 254, 125, 'Gassville', 10000, 1),
(26589, 254, 136, 'Gaston', 10000, 1),
(26590, 254, 155, 'Gaston', 10000, 1),
(26591, 254, 159, 'Gaston', 10000, 1),
(26592, 254, 162, 'Gaston', 10000, 1),
(26593, 254, 160, 'Gastonville', 10000, 1),
(26594, 254, 158, 'Gate', 10000, 1),
(26595, 254, 155, 'Gates', 10000, 1),
(26596, 254, 159, 'Gates', 10000, 1),
(26597, 254, 164, 'Gates', 10000, 1),
(26598, 254, 125, 'Gateway', 10000, 1),
(26599, 254, 127, 'Gateway', 10000, 1),
(26600, 254, 147, 'Gatewood', 10000, 1),
(26601, 254, 146, 'Gattman', 10000, 1),
(26602, 254, 145, 'Gatzke', 10000, 1),
(26603, 254, 169, 'Gauley Bridge', 10000, 1),
(26604, 254, 165, 'Gause', 10000, 1),
(26605, 254, 146, 'Gautier', 10000, 1),
(26606, 254, 132, 'Gay', 10000, 1),
(26607, 254, 169, 'Gay', 10000, 1),
(26608, 254, 122, 'Gaylesville', 10000, 1),
(26609, 254, 138, 'Gaylord', 10000, 1),
(26610, 254, 128, 'Gaylordsville', 10000, 1),
(26611, 254, 135, 'Gays', 10000, 1),
(26612, 254, 139, 'Gays Creek', 10000, 1),
(26613, 254, 170, 'Gays Mills', 10000, 1),
(26614, 254, 172, 'Gaysville', 10000, 1),
(26615, 254, 163, 'Gayville', 10000, 1),
(26616, 254, 126, 'Gazelle', 10000, 1),
(26617, 254, 158, 'Geary', 10000, 1),
(26618, 254, 135, 'Geff', 10000, 1),
(26619, 254, 160, 'Geigertown', 10000, 1),
(26620, 254, 140, 'Geismar', 10000, 1),
(26621, 254, 138, 'Gem', 10000, 1),
(26622, 254, 134, 'Genesee', 10000, 1),
(26623, 254, 144, 'Genesee', 10000, 1),
(26624, 254, 160, 'Genesee', 10000, 1),
(26625, 254, 170, 'Genesee Depot', 10000, 1),
(26626, 254, 138, 'Geneseo', 10000, 1),
(26627, 254, 131, 'Geneva', 10000, 1),
(26628, 254, 132, 'Geneva', 10000, 1),
(26629, 254, 137, 'Geneva', 10000, 1),
(26630, 254, 134, 'Geneva', 10000, 1),
(26631, 254, 145, 'Geneva', 10000, 1),
(26632, 254, 157, 'Geneva', 10000, 1),
(26633, 254, 165, 'Geneva', 10000, 1),
(26634, 254, 125, 'Genoa', 10000, 1),
(26635, 254, 127, 'Genoa', 10000, 1),
(26636, 254, 135, 'Genoa', 10000, 1),
(26637, 254, 149, 'Genoa', 10000, 1),
(26638, 254, 150, 'Genoa', 10000, 1),
(26639, 254, 154, 'Genoa', 10000, 1),
(26640, 254, 157, 'Genoa', 10000, 1),
(26641, 254, 170, 'Genoa', 10000, 1),
(26642, 254, 169, 'Genoa', 10000, 1),
(26643, 254, 170, 'Genoa City', 10000, 1),
(26644, 254, 125, 'Gentry', 10000, 1),
(26645, 254, 147, 'Gentry', 10000, 1),
(26646, 254, 136, 'Gentryville', 10000, 1),
(26647, 254, 137, 'George', 10000, 1),
(26648, 254, 168, 'George', 10000, 1),
(26649, 254, 151, 'Georges Mills', 10000, 1),
(26650, 254, 127, 'Georgetown', 10000, 1),
(26651, 254, 128, 'Georgetown', 10000, 1),
(26652, 254, 131, 'Georgetown', 10000, 1),
(26653, 254, 134, 'Georgetown', 10000, 1),
(26654, 254, 136, 'Georgetown', 10000, 1),
(26655, 254, 140, 'Georgetown', 10000, 1),
(26656, 254, 143, 'Georgetown', 10000, 1),
(26657, 254, 142, 'Georgetown', 10000, 1),
(26658, 254, 141, 'Georgetown', 10000, 1),
(26659, 254, 145, 'Georgetown', 10000, 1),
(26660, 254, 154, 'Georgetown', 10000, 1),
(26662, 254, 160, 'Georgetown', 10000, 1),
(26663, 254, 164, 'Georgetown', 10000, 1),
(26664, 254, 122, 'Georgiana', 10000, 1),
(26665, 254, 125, 'Gepp', 10000, 1),
(26666, 254, 122, 'Geraldine', 10000, 1),
(26667, 254, 148, 'Geraldine', 10000, 1),
(26668, 254, 126, 'Gerber', 10000, 1),
(26669, 254, 150, 'Gerlach', 10000, 1),
(26670, 254, 135, 'Gerlaw', 10000, 1),
(26671, 254, 135, 'German Valley', 10000, 1),
(26672, 254, 160, 'Germansville', 10000, 1),
(26673, 254, 155, 'Germanton', 10000, 1),
(26674, 254, 135, 'Germantown', 10000, 1),
(26675, 254, 139, 'Germantown', 10000, 1),
(26676, 254, 154, 'Germantown', 10000, 1),
(26677, 254, 157, 'Germantown', 10000, 1),
(26678, 254, 170, 'Germantown', 10000, 1),
(26679, 254, 144, 'Germfask', 10000, 1),
(26680, 254, 158, 'Geronimo', 10000, 1),
(26681, 254, 165, 'Geronimo', 10000, 1),
(26682, 254, 169, 'Gerrardstown', 10000, 1),
(26683, 254, 154, 'Gerry', 10000, 1),
(26684, 254, 155, 'Gerton', 10000, 1),
(26685, 254, 159, 'Gervais', 10000, 1),
(26686, 254, 157, 'Gettysburg', 10000, 1),
(26687, 254, 154, 'Getzville', 10000, 1),
(26688, 254, 138, 'Geuda Springs', 10000, 1),
(26689, 254, 148, 'Geyser', 10000, 1),
(26690, 254, 126, 'Geyserville', 10000, 1),
(26691, 254, 140, 'Gheens', 10000, 1),
(26692, 254, 139, 'Ghent', 10000, 1),
(26693, 254, 145, 'Ghent', 10000, 1),
(26694, 254, 154, 'Ghent', 10000, 1),
(26695, 254, 169, 'Ghent', 10000, 1),
(26696, 254, 145, 'Gibbon', 10000, 1),
(26697, 254, 149, 'Gibbon', 10000, 1),
(26698, 254, 160, 'Gibbon Glade', 10000, 1),
(26699, 254, 134, 'Gibbonsville', 10000, 1),
(26700, 254, 147, 'Gibbs', 10000, 1),
(26701, 254, 152, 'Gibbsboro', 10000, 1),
(26702, 254, 140, 'Gibsland', 10000, 1),
(26703, 254, 137, 'Gibson', 10000, 1),
(26704, 254, 140, 'Gibson', 10000, 1),
(26705, 254, 147, 'Gibson', 10000, 1),
(26706, 254, 155, 'Gibson', 10000, 1),
(26707, 254, 160, 'Gibson', 10000, 1),
(26708, 254, 164, 'Gibson', 10000, 1),
(26709, 254, 142, 'Gibson Island', 10000, 1),
(26710, 254, 157, 'Gibsonburg', 10000, 1),
(26711, 254, 160, 'Gibsonia', 10000, 1),
(26712, 254, 131, 'Gibsonton', 10000, 1),
(26713, 254, 155, 'Gibsonville', 10000, 1),
(26714, 254, 147, 'Gideon', 10000, 1),
(26715, 254, 137, 'Gifford', 10000, 1),
(26716, 254, 135, 'Gifford', 10000, 1),
(26717, 254, 160, 'Gifford', 10000, 1),
(26718, 254, 162, 'Gifford', 10000, 1),
(26719, 254, 168, 'Gifford', 10000, 1),
(26720, 254, 153, 'Gila', 10000, 1),
(26721, 254, 125, 'Gilbert', 10000, 1),
(26722, 254, 137, 'Gilbert', 10000, 1),
(26723, 254, 140, 'Gilbert', 10000, 1),
(26724, 254, 160, 'Gilbert', 10000, 1),
(26725, 254, 162, 'Gilbert', 10000, 1),
(26726, 254, 169, 'Gilbert', 10000, 1),
(26727, 254, 160, 'Gilberton', 10000, 1),
(26728, 254, 122, 'Gilbertown', 10000, 1),
(26729, 254, 135, 'Gilberts', 10000, 1),
(26730, 254, 139, 'Gilbertsville', 10000, 1),
(26731, 254, 154, 'Gilbertsville', 10000, 1),
(26732, 254, 160, 'Gilbertsville', 10000, 1),
(26733, 254, 137, 'Gilbertville', 10000, 1),
(26734, 254, 143, 'Gilbertville', 10000, 1),
(26735, 254, 154, 'Gilboa', 10000, 1),
(26736, 254, 169, 'Gilboa', 10000, 1),
(26737, 254, 156, 'Gilby', 10000, 1),
(26738, 254, 159, 'Gilchrist', 10000, 1),
(26739, 254, 165, 'Gilchrist', 10000, 1),
(26740, 254, 127, 'Gilcrest', 10000, 1),
(26741, 254, 148, 'Gildford', 10000, 1),
(26742, 254, 170, 'Gile', 10000, 1),
(26743, 254, 149, 'Gilead', 10000, 1),
(26744, 254, 144, 'Gilford', 10000, 1),
(26745, 254, 151, 'Gilford', 10000, 1),
(26746, 254, 127, 'Gill', 10000, 1),
(26747, 254, 125, 'Gillett', 10000, 1),
(26748, 254, 160, 'Gillett', 10000, 1),
(26749, 254, 165, 'Gillett', 10000, 1),
(26750, 254, 170, 'Gillett', 10000, 1),
(26751, 254, 137, 'Gillett Grove', 10000, 1),
(26752, 254, 152, 'Gillette', 10000, 1),
(26753, 254, 125, 'Gillham', 10000, 1),
(26754, 254, 140, 'Gilliam', 10000, 1),
(26755, 254, 147, 'Gilliam', 10000, 1),
(26756, 254, 132, 'Gillsville', 10000, 1),
(26757, 254, 128, 'Gilman', 10000, 1),
(26758, 254, 137, 'Gilman', 10000, 1),
(26759, 254, 135, 'Gilman', 10000, 1),
(26760, 254, 145, 'Gilman', 10000, 1),
(26761, 254, 172, 'Gilman', 10000, 1),
(26762, 254, 170, 'Gilman', 10000, 1),
(26763, 254, 147, 'Gilman City', 10000, 1),
(26764, 254, 170, 'Gilmanton', 10000, 1),
(26765, 254, 151, 'Gilmanton Iron Works', 10000, 1),
(26766, 254, 169, 'Gilmer', 10000, 1),
(26767, 254, 125, 'Gilmore', 10000, 1),
(26768, 254, 137, 'Gilmore City', 10000, 1),
(26769, 254, 135, 'Gilson', 10000, 1),
(26770, 254, 151, 'Gilsum', 10000, 1),
(26771, 254, 149, 'Giltner', 10000, 1),
(26772, 254, 147, 'Gipsy', 10000, 1),
(26773, 254, 160, 'Gipsy', 10000, 1),
(26774, 254, 132, 'Girard', 10000, 1),
(26775, 254, 135, 'Girard', 10000, 1),
(26776, 254, 138, 'Girard', 10000, 1),
(26777, 254, 165, 'Girard', 10000, 1),
(26778, 254, 160, 'Girardville', 10000, 1),
(26779, 254, 139, 'Girdler', 10000, 1),
(26780, 254, 142, 'Girdletree', 10000, 1),
(26781, 254, 165, 'Girvin', 10000, 1),
(26782, 254, 169, 'Given', 10000, 1),
(26783, 254, 169, 'Glace', 10000, 1),
(26784, 254, 163, 'Glad Valley', 10000, 1),
(26785, 254, 137, 'Gladbrook', 10000, 1),
(26786, 254, 138, 'Glade', 10000, 1),
(26787, 254, 167, 'Glade Hill', 10000, 1),
(26788, 254, 127, 'Glade Park', 10000, 1),
(26789, 254, 167, 'Glade Spring', 10000, 1),
(26790, 254, 155, 'Glade Valley', 10000, 1),
(26791, 254, 164, 'Gladeville', 10000, 1),
(26792, 254, 165, 'Gladewater', 10000, 1),
(26793, 254, 135, 'Gladstone', 10000, 1),
(26794, 254, 144, 'Gladstone', 10000, 1),
(26795, 254, 156, 'Gladstone', 10000, 1),
(26796, 254, 152, 'Gladstone', 10000, 1),
(26797, 254, 153, 'Gladstone', 10000, 1),
(26798, 254, 167, 'Gladstone', 10000, 1),
(26799, 254, 169, 'Glady', 10000, 1),
(26800, 254, 167, 'Gladys', 10000, 1),
(26801, 254, 157, 'Glandorf', 10000, 1),
(26802, 254, 138, 'Glasco', 10000, 1),
(26803, 254, 154, 'Glasco', 10000, 1),
(26804, 254, 135, 'Glasford', 10000, 1),
(26805, 254, 128, 'Glasgo', 10000, 1),
(26806, 254, 147, 'Glasgow', 10000, 1),
(26807, 254, 160, 'Glasgow', 10000, 1),
(26808, 254, 167, 'Glasgow', 10000, 1),
(26809, 254, 169, 'Glasgow', 10000, 1),
(26810, 254, 152, 'Glasser', 10000, 1),
(26811, 254, 160, 'Glassport', 10000, 1),
(26812, 254, 156, 'Glasston', 10000, 1),
(26813, 254, 164, 'Gleason', 10000, 1),
(26814, 254, 170, 'Gleason', 10000, 1),
(26815, 254, 146, 'Glen', 10000, 1),
(26816, 254, 148, 'Glen', 10000, 1),
(26817, 254, 151, 'Glen', 10000, 1),
(26818, 254, 169, 'Glen', 10000, 1),
(26819, 254, 146, 'Glen Allan', 10000, 1),
(26820, 254, 122, 'Glen Allen', 10000, 1),
(26821, 254, 167, 'Glen Allen', 10000, 1),
(26823, 254, 155, 'Glen Alpine', 10000, 1),
(26824, 254, 144, 'Glen Arbor', 10000, 1),
(26825, 254, 142, 'Glen Arm', 10000, 1),
(26826, 254, 154, 'Glen Aubrey', 10000, 1),
(26827, 254, 160, 'Glen Campbell', 10000, 1),
(26828, 254, 141, 'Glen Cove', 10000, 1),
(26829, 254, 169, 'Glen Daniel', 10000, 1),
(26830, 254, 169, 'Glen Easton', 10000, 1),
(26831, 254, 142, 'Glen Echo', 10000, 1),
(26832, 254, 138, 'Glen Elder', 10000, 1),
(26833, 254, 169, 'Glen Ferris', 10000, 1),
(26834, 254, 165, 'Glen Flora', 10000, 1),
(26835, 254, 170, 'Glen Flora', 10000, 1),
(26836, 254, 169, 'Glen Fork', 10000, 1),
(26837, 254, 152, 'Glen Gardner', 10000, 1),
(26838, 254, 127, 'Glen Haven', 10000, 1),
(26839, 254, 170, 'Glen Haven', 10000, 1),
(26840, 254, 154, 'Glen Head', 10000, 1),
(26841, 254, 160, 'Glen Hope', 10000, 1),
(26842, 254, 169, 'Glen Jean', 10000, 1),
(26843, 254, 167, 'Glen Lyn', 10000, 1),
(26844, 254, 160, 'Glen Lyon', 10000, 1),
(26845, 254, 160, 'Glen Mills', 10000, 1),
(26846, 254, 169, 'Glen Morgan', 10000, 1),
(26847, 254, 154, 'Glen Oaks', 10000, 1),
(26848, 254, 160, 'Glen Richey', 10000, 1),
(26849, 254, 160, 'Glen Riddle Lima', 10000, 1),
(26850, 254, 152, 'Glen Rock', 10000, 1),
(26851, 254, 160, 'Glen Rock', 10000, 1),
(26852, 254, 169, 'Glen Rogers', 10000, 1),
(26853, 254, 131, 'Glen Saint Mary', 10000, 1),
(26854, 254, 154, 'Glen Spey', 10000, 1),
(26855, 254, 156, 'Glen Ullin', 10000, 1),
(26856, 254, 169, 'Glen White', 10000, 1),
(26857, 254, 154, 'Glen Wild', 10000, 1),
(26858, 254, 167, 'Glen Wilton', 10000, 1),
(26859, 254, 147, 'Glenallen', 10000, 1),
(26860, 254, 135, 'Glenarm', 10000, 1),
(26861, 254, 170, 'Glenbeulah', 10000, 1),
(26862, 254, 150, 'Glenbrook', 10000, 1),
(26863, 254, 156, 'Glenburn', 10000, 1),
(26864, 254, 151, 'Glencliff', 10000, 1),
(26865, 254, 125, 'Glencoe', 10000, 1),
(26866, 254, 126, 'Glencoe', 10000, 1),
(26867, 254, 139, 'Glencoe', 10000, 1),
(26868, 254, 145, 'Glencoe', 10000, 1),
(26869, 254, 147, 'Glencoe', 10000, 1),
(26870, 254, 153, 'Glencoe', 10000, 1),
(26871, 254, 157, 'Glencoe', 10000, 1),
(26872, 254, 158, 'Glencoe', 10000, 1),
(26873, 254, 163, 'Glencross', 10000, 1),
(26874, 254, 139, 'Glendale', 10000, 1),
(26875, 254, 143, 'Glendale', 10000, 1),
(26876, 254, 159, 'Glendale', 10000, 1),
(26877, 254, 161, 'Glendale', 10000, 1),
(26878, 254, 162, 'Glendale', 10000, 1),
(26879, 254, 166, 'Glendale', 10000, 1),
(26880, 254, 155, 'Glendale Springs', 10000, 1),
(26881, 254, 146, 'Glendora', 10000, 1),
(26882, 254, 152, 'Glendora', 10000, 1),
(26883, 254, 159, 'Gleneden Beach', 10000, 1),
(26884, 254, 142, 'Glenelg', 10000, 1),
(26885, 254, 156, 'Glenfield', 10000, 1),
(26886, 254, 154, 'Glenfield', 10000, 1),
(26887, 254, 154, 'Glenford', 10000, 1),
(26888, 254, 157, 'Glenford', 10000, 1),
(26889, 254, 169, 'Glengary', 10000, 1),
(26890, 254, 154, 'Glenham', 10000, 1),
(26891, 254, 163, 'Glenham', 10000, 1),
(26892, 254, 126, 'Glenhaven', 10000, 1),
(26893, 254, 169, 'Glenhayes', 10000, 1),
(26894, 254, 154, 'Glenmont', 10000, 1),
(26895, 254, 157, 'Glenmont', 10000, 1),
(26896, 254, 160, 'Glenmoore', 10000, 1),
(26897, 254, 140, 'Glenmora', 10000, 1),
(26898, 254, 132, 'Glenn', 10000, 1),
(26899, 254, 142, 'Glenn Dale', 10000, 1),
(26900, 254, 144, 'Glennie', 10000, 1),
(26901, 254, 134, 'Glenns Ferry', 10000, 1),
(26902, 254, 132, 'Glennville', 10000, 1),
(26903, 254, 168, 'Glenoma', 10000, 1),
(26904, 254, 139, 'Glens Fork', 10000, 1),
(26905, 254, 160, 'Glenshaw', 10000, 1),
(26906, 254, 148, 'Glentana', 10000, 1),
(26907, 254, 139, 'Glenview', 10000, 1),
(26908, 254, 135, 'Glenview NAS', 10000, 1),
(26909, 254, 149, 'Glenvil', 10000, 1),
(26910, 254, 160, 'Glenville', 10000, 1),
(26911, 254, 122, 'Glenwood', 10000, 1),
(26912, 254, 125, 'Glenwood', 10000, 1),
(26913, 254, 131, 'Glenwood', 10000, 1),
(26914, 254, 132, 'Glenwood', 10000, 1),
(26915, 254, 135, 'Glenwood', 10000, 1),
(26916, 254, 136, 'Glenwood', 10000, 1),
(26917, 254, 142, 'Glenwood', 10000, 1),
(26918, 254, 147, 'Glenwood', 10000, 1),
(26919, 254, 155, 'Glenwood', 10000, 1),
(26920, 254, 152, 'Glenwood', 10000, 1),
(26921, 254, 153, 'Glenwood', 10000, 1),
(26922, 254, 166, 'Glenwood', 10000, 1),
(26923, 254, 168, 'Glenwood', 10000, 1),
(26924, 254, 169, 'Glenwood', 10000, 1),
(26925, 254, 170, 'Glenwood City', 10000, 1),
(26926, 254, 137, 'Glidden', 10000, 1),
(26927, 254, 165, 'Glidden', 10000, 1),
(26928, 254, 170, 'Glidden', 10000, 1),
(26929, 254, 159, 'Glide', 10000, 1),
(26930, 254, 153, 'Glorieta', 10000, 1),
(26931, 254, 140, 'Gloster', 10000, 1),
(26932, 254, 146, 'Gloster', 10000, 1),
(26933, 254, 155, 'Gloucester', 10000, 1),
(26934, 254, 152, 'Gloucester City', 10000, 1),
(26935, 254, 167, 'Gloucester Point', 10000, 1),
(26936, 254, 157, 'Glouster', 10000, 1),
(26937, 254, 147, 'Glover', 10000, 1),
(26938, 254, 172, 'Glover', 10000, 1),
(26939, 254, 162, 'Gloverville', 10000, 1),
(26940, 254, 142, 'Glyndon', 10000, 1),
(26941, 254, 145, 'Glyndon', 10000, 1),
(26942, 254, 140, 'Glynn', 10000, 1),
(26943, 254, 157, 'Gnadenhutten', 10000, 1),
(26944, 254, 165, 'Gober', 10000, 1),
(26945, 254, 147, 'Gobler', 10000, 1),
(26946, 254, 144, 'Gobles', 10000, 1),
(26947, 254, 138, 'Goddard', 10000, 1),
(26948, 254, 154, 'Godeffroy', 10000, 1),
(26949, 254, 165, 'Godley', 10000, 1),
(26950, 254, 155, 'Godwin', 10000, 1),
(26951, 254, 149, 'Goehner', 10000, 1),
(26952, 254, 138, 'Goessel', 10000, 1),
(26953, 254, 144, 'Goetzville', 10000, 1),
(26954, 254, 138, 'Goff', 10000, 1),
(26955, 254, 151, 'Goffstown', 10000, 1),
(26956, 254, 150, 'Golconda', 10000, 1),
(26957, 254, 168, 'Gold Bar', 10000, 1),
(26958, 254, 148, 'Gold Creek', 10000, 1),
(26959, 254, 155, 'Gold Hill', 10000, 1),
(26960, 254, 159, 'Gold Hill', 10000, 1),
(26961, 254, 167, 'Goldbond', 10000, 1),
(26962, 254, 135, 'Golden', 10000, 1),
(26963, 254, 147, 'Golden', 10000, 1),
(26964, 254, 146, 'Golden', 10000, 1),
(26965, 254, 158, 'Golden', 10000, 1),
(26966, 254, 165, 'Golden', 10000, 1),
(26967, 254, 147, 'Golden City', 10000, 1),
(26968, 254, 135, 'Golden Eagle', 10000, 1),
(26969, 254, 135, 'Golden Gate', 10000, 1),
(26970, 254, 124, 'Golden Valley', 10000, 1),
(26971, 254, 168, 'Goldendale', 10000, 1),
(26972, 254, 131, 'Goldenrod', 10000, 1),
(26973, 254, 154, 'Goldens Bridge', 10000, 1),
(26974, 254, 137, 'Goldfield', 10000, 1),
(26975, 254, 150, 'Goldfield', 10000, 1),
(26976, 254, 140, 'Goldonna', 10000, 1),
(26977, 254, 142, 'Goldsboro', 10000, 1),
(26978, 254, 165, 'Goldsboro', 10000, 1),
(26979, 254, 136, 'Goldsmith', 10000, 1),
(26980, 254, 165, 'Goldsmith', 10000, 1),
(26981, 254, 155, 'Goldston', 10000, 1),
(26982, 254, 167, 'Goldvein', 10000, 1),
(26983, 254, 135, 'Golf', 10000, 1),
(26984, 254, 158, 'Goltry', 10000, 1),
(26985, 254, 156, 'Golva', 10000, 1),
(26986, 254, 157, 'Gomer', 10000, 1),
(26987, 254, 126, 'Gonzales', 10000, 1),
(26988, 254, 131, 'Gonzalez', 10000, 1),
(26989, 254, 144, 'Good Hart', 10000, 1),
(26990, 254, 132, 'Good Hope', 10000, 1),
(26991, 254, 135, 'Good Hope', 10000, 1),
(26992, 254, 145, 'Good Thunder', 10000, 1),
(26993, 254, 167, 'Goode', 10000, 1),
(26994, 254, 137, 'Goodell', 10000, 1),
(26995, 254, 144, 'Goodells', 10000, 1),
(26996, 254, 165, 'Goodfellow AFB', 10000, 1),
(26997, 254, 135, 'Goodfield', 10000, 1),
(26998, 254, 145, 'Goodhue', 10000, 1),
(26999, 254, 134, 'Gooding', 10000, 1),
(27000, 254, 131, 'Goodland', 10000, 1),
(27001, 254, 136, 'Goodland', 10000, 1),
(27002, 254, 145, 'Goodland', 10000, 1),
(27003, 254, 147, 'Goodman', 10000, 1),
(27004, 254, 146, 'Goodman', 10000, 1),
(27005, 254, 170, 'Goodman', 10000, 1),
(27006, 254, 123, 'Goodnews Bay', 10000, 1),
(27007, 254, 144, 'Goodrich', 10000, 1),
(27008, 254, 156, 'Goodrich', 10000, 1),
(27009, 254, 165, 'Goodrich', 10000, 1),
(27010, 254, 145, 'Goodridge', 10000, 1),
(27011, 254, 147, 'Goodson', 10000, 1),
(27012, 254, 164, 'Goodspring', 10000, 1),
(27013, 254, 122, 'Goodsprings', 10000, 1),
(27014, 254, 167, 'Goodview', 10000, 1),
(27015, 254, 160, 'Goodville', 10000, 1),
(27016, 254, 122, 'Goodwater', 10000, 1),
(27017, 254, 122, 'Goodway', 10000, 1),
(27018, 254, 125, 'Goodwin', 10000, 1),
(27019, 254, 163, 'Goodwin', 10000, 1),
(27020, 254, 126, 'Goodyears Bar', 10000, 1),
(27021, 254, 137, 'Goose Lake', 10000, 1),
(27022, 254, 168, 'Goose Prairie', 10000, 1),
(27023, 254, 139, 'Goose Rock', 10000, 1),
(27024, 254, 122, 'Gordo', 10000, 1),
(27025, 254, 122, 'Gordon', 10000, 1),
(27026, 254, 132, 'Gordon', 10000, 1),
(27027, 254, 139, 'Gordon', 10000, 1),
(27028, 254, 149, 'Gordon', 10000, 1),
(27029, 254, 160, 'Gordon', 10000, 1),
(27030, 254, 165, 'Gordon', 10000, 1),
(27031, 254, 169, 'Gordon', 10000, 1),
(27032, 254, 164, 'Gordonsville', 10000, 1),
(27033, 254, 167, 'Gordonsville', 10000, 1),
(27034, 254, 147, 'Gordonville', 10000, 1),
(27035, 254, 160, 'Gordonville', 10000, 1),
(27036, 254, 165, 'Gordonville', 10000, 1),
(27037, 254, 158, 'Gore', 10000, 1),
(27038, 254, 167, 'Gore', 10000, 1),
(27039, 254, 146, 'Gore Springs', 10000, 1),
(27040, 254, 165, 'Goree', 10000, 1),
(27041, 254, 135, 'Goreville', 10000, 1),
(27042, 254, 135, 'Gorham', 10000, 1),
(27043, 254, 138, 'Gorham', 10000, 1),
(27044, 254, 141, 'Gorham', 10000, 1),
(27045, 254, 151, 'Gorham', 10000, 1),
(27046, 254, 154, 'Gorham', 10000, 1),
(27047, 254, 147, 'Gorin', 10000, 1),
(27048, 254, 165, 'Gorman', 10000, 1),
(27049, 254, 169, 'Gormania', 10000, 1),
(27050, 254, 140, 'Gorum', 10000, 1),
(27051, 254, 122, 'Goshen', 10000, 1),
(27052, 254, 125, 'Goshen', 10000, 1),
(27053, 254, 126, 'Goshen', 10000, 1),
(27054, 254, 139, 'Goshen', 10000, 1),
(27055, 254, 143, 'Goshen', 10000, 1),
(27056, 254, 151, 'Goshen', 10000, 1),
(27057, 254, 152, 'Goshen', 10000, 1),
(27058, 254, 154, 'Goshen', 10000, 1),
(27059, 254, 157, 'Goshen', 10000, 1),
(27060, 254, 166, 'Goshen', 10000, 1),
(27061, 254, 167, 'Goshen', 10000, 1),
(27062, 254, 125, 'Gosnell', 10000, 1),
(27063, 254, 136, 'Gosport', 10000, 1),
(27064, 254, 158, 'Gotebo', 10000, 1),
(27065, 254, 131, 'Gotha', 10000, 1),
(27066, 254, 170, 'Gotham', 10000, 1),
(27067, 254, 132, 'Gough', 10000, 1),
(27068, 254, 125, 'Gould', 10000, 1),
(27069, 254, 158, 'Gould', 10000, 1),
(27070, 254, 144, 'Gould City', 10000, 1),
(27071, 254, 165, 'Gouldbusk', 10000, 1),
(27072, 254, 141, 'Gouldsboro', 10000, 1),
(27073, 254, 160, 'Gouldsboro', 10000, 1),
(27074, 254, 154, 'Gouverneur', 10000, 1),
(27075, 254, 154, 'Gowanda', 10000, 1),
(27076, 254, 158, 'Gowen', 10000, 1),
(27077, 254, 160, 'Gowen City', 10000, 1),
(27078, 254, 147, 'Gower', 10000, 1),
(27079, 254, 136, 'Grabill', 10000, 1),
(27080, 254, 146, 'Grace', 10000, 1),
(27081, 254, 156, 'Grace City', 10000, 1),
(27082, 254, 158, 'Gracemont', 10000, 1),
(27083, 254, 131, 'Graceville', 10000, 1),
(27084, 254, 145, 'Graceville', 10000, 1),
(27085, 254, 132, 'Gracewood', 10000, 1),
(27086, 254, 139, 'Gracey', 10000, 1),
(27087, 254, 122, 'Grady', 10000, 1),
(27088, 254, 125, 'Grady', 10000, 1),
(27089, 254, 153, 'Grady', 10000, 1),
(27090, 254, 139, 'Gradyville', 10000, 1),
(27091, 254, 160, 'Gradyville', 10000, 1),
(27092, 254, 137, 'Graettinger', 10000, 1),
(27093, 254, 147, 'Graff', 10000, 1),
(27094, 254, 165, 'Graford', 10000, 1),
(27095, 254, 137, 'Grafton', 10000, 1),
(27096, 254, 135, 'Grafton', 10000, 1),
(27097, 254, 149, 'Grafton', 10000, 1),
(27098, 254, 151, 'Grafton', 10000, 1),
(27099, 254, 154, 'Grafton', 10000, 1),
(27100, 254, 157, 'Grafton', 10000, 1),
(27101, 254, 172, 'Grafton', 10000, 1),
(27102, 254, 122, 'Graham', 10000, 1),
(27103, 254, 131, 'Graham', 10000, 1),
(27104, 254, 139, 'Graham', 10000, 1),
(27105, 254, 147, 'Graham', 10000, 1),
(27106, 254, 158, 'Graham', 10000, 1),
(27107, 254, 154, 'Grahamsville', 10000, 1),
(27108, 254, 139, 'Grahn', 10000, 1),
(27109, 254, 147, 'Grain Valley', 10000, 1),
(27110, 254, 138, 'Grainfield', 10000, 1),
(27111, 254, 140, 'Gramercy', 10000, 1),
(27112, 254, 162, 'Gramling', 10000, 1),
(27113, 254, 136, 'Grammer', 10000, 1),
(27114, 254, 160, 'Grampian', 10000, 1),
(27115, 254, 127, 'Granada', 10000, 1),
(27116, 254, 145, 'Granada', 10000, 1),
(27117, 254, 127, 'Granby', 10000, 1),
(27118, 254, 143, 'Granby', 10000, 1),
(27119, 254, 147, 'Granby', 10000, 1),
(27120, 254, 172, 'Granby', 10000, 1),
(27121, 254, 122, 'Grand Bay', 10000, 1),
(27122, 254, 140, 'Grand Cane', 10000, 1),
(27123, 254, 135, 'Grand Chain', 10000, 1),
(27124, 254, 140, 'Grand Chenier', 10000, 1),
(27125, 254, 140, 'Grand Coteau', 10000, 1),
(27126, 254, 156, 'Grand Forks AFB', 10000, 1),
(27127, 254, 154, 'Grand Gorge', 10000, 1),
(27128, 254, 131, 'Grand Island', 10000, 1),
(27129, 254, 140, 'Grand Isle', 10000, 1),
(27130, 254, 141, 'Grand Isle', 10000, 1),
(27131, 254, 172, 'Grand Isle', 10000, 1),
(27132, 254, 137, 'Grand Junction', 10000, 1),
(27133, 254, 144, 'Grand Junction', 10000, 1),
(27134, 254, 164, 'Grand Junction', 10000, 1),
(27135, 254, 127, 'Grand Lake', 10000, 1),
(27136, 254, 144, 'Grand Marais', 10000, 1),
(27137, 254, 170, 'Grand Marsh', 10000, 1),
(27138, 254, 145, 'Grand Meadow', 10000, 1),
(27139, 254, 137, 'Grand Mound', 10000, 1),
(27140, 254, 145, 'Grand Portage', 10000, 1),
(27141, 254, 157, 'Grand Rapids', 10000, 1),
(27142, 254, 131, 'Grand Ridge', 10000, 1),
(27143, 254, 137, 'Grand River', 10000, 1),
(27144, 254, 157, 'Grand River', 10000, 1),
(27145, 254, 139, 'Grand Rivers', 10000, 1),
(27146, 254, 159, 'Grand Ronde', 10000, 1),
(27147, 254, 165, 'Grand Saline', 10000, 1),
(27148, 254, 126, 'Grand Terrace', 10000, 1),
(27149, 254, 135, 'Grand Tower', 10000, 1),
(27150, 254, 160, 'Grand Valley', 10000, 1),
(27151, 254, 134, 'Grand View', 10000, 1),
(27152, 254, 170, 'Grand View', 10000, 1),
(27153, 254, 158, 'Grandfield', 10000, 1),
(27154, 254, 131, 'Grandin', 10000, 1),
(27155, 254, 147, 'Grandin', 10000, 1),
(27156, 254, 156, 'Grandin', 10000, 1),
(27157, 254, 137, 'Grandview', 10000, 1),
(27158, 254, 136, 'Grandview', 10000, 1),
(27159, 254, 164, 'Grandview', 10000, 1),
(27160, 254, 165, 'Grandview', 10000, 1),
(27161, 254, 144, 'Grandville', 10000, 1),
(27162, 254, 145, 'Grandy', 10000, 1),
(27163, 254, 155, 'Grandy', 10000, 1),
(27164, 254, 137, 'Granger', 10000, 1),
(27165, 254, 147, 'Granger', 10000, 1),
(27166, 254, 165, 'Granger', 10000, 1),
(27167, 254, 168, 'Granger', 10000, 1),
(27168, 254, 171, 'Granger', 10000, 1),
(27169, 254, 127, 'Granite', 10000, 1),
(27170, 254, 158, 'Granite', 10000, 1),
(27171, 254, 126, 'Granite Bay', 10000, 1),
(27172, 254, 171, 'Granite Canon', 10000, 1),
(27173, 254, 155, 'Granite Quarry', 10000, 1),
(27174, 254, 154, 'Granite Springs', 10000, 1),
(27175, 254, 162, 'Graniteville', 10000, 1),
(27176, 254, 172, 'Graniteville', 10000, 1),
(27177, 254, 125, 'Grannis', 10000, 1),
(27178, 254, 122, 'Grant', 10000, 1),
(27179, 254, 127, 'Grant', 10000, 1),
(27180, 254, 131, 'Grant', 10000, 1),
(27181, 254, 137, 'Grant', 10000, 1),
(27182, 254, 140, 'Grant', 10000, 1),
(27183, 254, 144, 'Grant', 10000, 1),
(27184, 254, 158, 'Grant', 10000, 1),
(27185, 254, 135, 'Grant Park', 10000, 1),
(27186, 254, 169, 'Grant Town', 10000, 1),
(27187, 254, 151, 'Grantham', 10000, 1),
(27188, 254, 170, 'Granton', 10000, 1),
(27189, 254, 155, 'Grantsboro', 10000, 1),
(27190, 254, 135, 'Grantsburg', 10000, 1),
(27191, 254, 136, 'Grantsburg', 10000, 1),
(27192, 254, 170, 'Grantsburg', 10000, 1),
(27193, 254, 148, 'Grantsdale', 10000, 1),
(27194, 254, 132, 'Grantville', 10000, 1),
(27195, 254, 138, 'Grantville', 10000, 1),
(27196, 254, 160, 'Grantville', 10000, 1),
(27197, 254, 137, 'Granville', 10000, 1),
(27198, 254, 135, 'Granville', 10000, 1),
(27199, 254, 143, 'Granville', 10000, 1),
(27200, 254, 156, 'Granville', 10000, 1),
(27201, 254, 154, 'Granville', 10000, 1),
(27202, 254, 157, 'Granville', 10000, 1),
(27203, 254, 160, 'Granville', 10000, 1),
(27204, 254, 164, 'Granville', 10000, 1),
(27205, 254, 172, 'Granville', 10000, 1),
(27206, 254, 169, 'Granville', 10000, 1),
(27207, 254, 160, 'Granville Summit', 10000, 1),
(27208, 254, 165, 'Grapeland', 10000, 1),
(27209, 254, 168, 'Grapeview', 10000, 1),
(27210, 254, 160, 'Grapeville', 10000, 1),
(27211, 254, 125, 'Grapevine', 10000, 1),
(27212, 254, 142, 'Grasonville', 10000, 1),
(27213, 254, 136, 'Grass Creek', 10000, 1),
(27214, 254, 144, 'Grass Lake', 10000, 1),
(27215, 254, 148, 'Grass Range', 10000, 1),
(27216, 254, 159, 'Grass Valley', 10000, 1),
(27217, 254, 160, 'Grassflat', 10000, 1),
(27218, 254, 145, 'Grasston', 10000, 1),
(27219, 254, 147, 'Grassy', 10000, 1),
(27220, 254, 156, 'Grassy Butte', 10000, 1),
(27221, 254, 155, 'Grassy Creek', 10000, 1),
(27222, 254, 169, 'Grassy Meadows', 10000, 1),
(27223, 254, 157, 'Gratiot', 10000, 1),
(27224, 254, 170, 'Gratiot', 10000, 1),
(27225, 254, 157, 'Gratis', 10000, 1),
(27226, 254, 126, 'Graton', 10000, 1),
(27227, 254, 139, 'Gravel Switch', 10000, 1),
(27228, 254, 125, 'Gravelly', 10000, 1),
(27229, 254, 167, 'Graves Mill', 10000, 1),
(27230, 254, 125, 'Gravette', 10000, 1),
(27231, 254, 147, 'Gravois Mills', 10000, 1),
(27232, 254, 144, 'Grawn', 10000, 1),
(27233, 254, 137, 'Gray', 10000, 1),
(27234, 254, 139, 'Gray', 10000, 1),
(27235, 254, 141, 'Gray', 10000, 1),
(27236, 254, 160, 'Gray', 10000, 1),
(27237, 254, 162, 'Gray Court', 10000, 1),
(27238, 254, 139, 'Gray Hawk', 10000, 1),
(27239, 254, 124, 'Gray Mountain', 10000, 1),
(27240, 254, 147, 'Gray Summit', 10000, 1),
(27241, 254, 168, 'Grayland', 10000, 1),
(27242, 254, 123, 'Grayling', 10000, 1),
(27243, 254, 135, 'Graymont', 10000, 1),
(27244, 254, 147, 'Grayridge', 10000, 1),
(27245, 254, 139, 'Grays Knob', 10000, 1),
(27246, 254, 168, 'Grays River', 10000, 1),
(27247, 254, 140, 'Grayson', 10000, 1),
(27248, 254, 122, 'Graysville', 10000, 1),
(27249, 254, 132, 'Graysville', 10000, 1),
(27250, 254, 136, 'Graysville', 10000, 1),
(27251, 254, 157, 'Graysville', 10000, 1),
(27252, 254, 160, 'Graysville', 10000, 1),
(27253, 254, 164, 'Graysville', 10000, 1),
(27254, 254, 157, 'Graytown', 10000, 1),
(27255, 254, 135, 'Grayville', 10000, 1),
(27256, 254, 143, 'Great Barrington', 10000, 1),
(27257, 254, 156, 'Great Bend', 10000, 1),
(27258, 254, 154, 'Great Bend', 10000, 1),
(27259, 254, 160, 'Great Bend', 10000, 1),
(27260, 254, 169, 'Great Cacapon', 10000, 1),
(27261, 254, 162, 'Great Falls', 10000, 1),
(27262, 254, 135, 'Great Lakes', 10000, 1),
(27263, 254, 142, 'Great Mills', 10000, 1),
(27264, 254, 154, 'Great River', 10000, 1),
(27265, 254, 154, 'Great Valley', 10000, 1),
(27266, 254, 137, 'Greeley', 10000, 1),
(27267, 254, 160, 'Greeley', 10000, 1),
(27268, 254, 162, 'Greeleyville', 10000, 1),
(27269, 254, 138, 'Green', 10000, 1),
(27270, 254, 167, 'Green Bay', 10000, 1),
(27271, 254, 157, 'Green Camp', 10000, 1),
(27272, 254, 147, 'Green Castle', 10000, 1),
(27273, 254, 147, 'Green City', 10000, 1),
(27274, 254, 152, 'Green Creek', 10000, 1),
(27275, 254, 143, 'Green Harbor', 10000, 1),
(27276, 254, 145, 'Green Isle', 10000, 1),
(27277, 254, 170, 'Green Lake', 10000, 1),
(27278, 254, 127, 'Green Mountain Falls', 10000, 1),
(27279, 254, 160, 'Green Park', 10000, 1),
(27280, 254, 122, 'Green Pond', 10000, 1),
(27281, 254, 162, 'Green Pond', 10000, 1),
(27282, 254, 147, 'Green Ridge', 10000, 1),
(27283, 254, 139, 'Green Road', 10000, 1),
(27284, 254, 162, 'Green Sea', 10000, 1),
(27285, 254, 169, 'Green Spring', 10000, 1),
(27286, 254, 157, 'Green Springs', 10000, 1),
(27287, 254, 169, 'Green Sulphur Springs', 10000, 1),
(27288, 254, 135, 'Green Valley', 10000, 1),
(27289, 254, 170, 'Green Valley', 10000, 1),
(27290, 254, 126, 'Green Valley Lake', 10000, 1),
(27291, 254, 152, 'Green Village', 10000, 1),
(27292, 254, 168, 'Greenacres', 10000, 1),
(27293, 254, 164, 'Greenback', 10000, 1),
(27294, 254, 167, 'Greenbackville', 10000, 1),
(27295, 254, 126, 'Greenbrae', 10000, 1),
(27296, 254, 125, 'Greenbrier', 10000, 1),
(27297, 254, 143, 'Greenbush', 10000, 1),
(27298, 254, 141, 'Greenbush', 10000, 1),
(27299, 254, 144, 'Greenbush', 10000, 1),
(27300, 254, 145, 'Greenbush', 10000, 1),
(27301, 254, 167, 'Greenbush', 10000, 1),
(27302, 254, 170, 'Greenbush', 10000, 1),
(27303, 254, 160, 'Greencastle', 10000, 1),
(27304, 254, 134, 'Greencreek', 10000, 1),
(27305, 254, 170, 'Greendale', 10000, 1),
(27306, 254, 152, 'Greendell', 10000, 1),
(27307, 254, 137, 'Greene', 10000, 1);
INSERT INTO `[[dbprefix]]geo_cities` VALUES
(27308, 254, 161, 'Greene', 10000, 1),
(27309, 254, 126, 'Greenfield', 10000, 1),
(27310, 254, 135, 'Greenfield', 10000, 1),
(27311, 254, 151, 'Greenfield', 10000, 1),
(27312, 254, 157, 'Greenfield', 10000, 1),
(27313, 254, 158, 'Greenfield', 10000, 1),
(27314, 254, 164, 'Greenfield', 10000, 1),
(27315, 254, 154, 'Greenfield Center', 10000, 1),
(27316, 254, 154, 'Greenfield Park', 10000, 1),
(27317, 254, 157, 'Greenford', 10000, 1),
(27318, 254, 154, 'Greenhurst', 10000, 1),
(27319, 254, 125, 'Greenland', 10000, 1),
(27320, 254, 144, 'Greenland', 10000, 1),
(27321, 254, 151, 'Greenland', 10000, 1),
(27322, 254, 154, 'Greenlawn', 10000, 1),
(27323, 254, 134, 'Greenleaf', 10000, 1),
(27324, 254, 138, 'Greenleaf', 10000, 1),
(27325, 254, 170, 'Greenleaf', 10000, 1),
(27326, 254, 155, 'Greenmountain', 10000, 1),
(27327, 254, 160, 'Greenock', 10000, 1),
(27328, 254, 148, 'Greenough', 10000, 1),
(27329, 254, 128, 'Greens Farms', 10000, 1),
(27330, 254, 136, 'Greens Fork', 10000, 1),
(27331, 254, 131, 'Greensboro', 10000, 1),
(27332, 254, 136, 'Greensboro', 10000, 1),
(27333, 254, 142, 'Greensboro', 10000, 1),
(27334, 254, 160, 'Greensboro', 10000, 1),
(27335, 254, 172, 'Greensboro', 10000, 1),
(27336, 254, 172, 'Greensboro Bend', 10000, 1),
(27337, 254, 147, 'Greentop', 10000, 1),
(27338, 254, 157, 'Greentown', 10000, 1),
(27339, 254, 160, 'Greentown', 10000, 1),
(27340, 254, 135, 'Greenup', 10000, 1),
(27341, 254, 126, 'Greenview', 10000, 1),
(27342, 254, 135, 'Greenview', 10000, 1),
(27343, 254, 131, 'Greenville', 10000, 1),
(27344, 254, 137, 'Greenville', 10000, 1),
(27345, 254, 136, 'Greenville', 10000, 1),
(27346, 254, 151, 'Greenville', 10000, 1),
(27347, 254, 154, 'Greenville', 10000, 1),
(27348, 254, 161, 'Greenville', 10000, 1),
(27349, 254, 166, 'Greenville', 10000, 1),
(27350, 254, 167, 'Greenville', 10000, 1),
(27351, 254, 170, 'Greenville', 10000, 1),
(27352, 254, 169, 'Greenville', 10000, 1),
(27353, 254, 141, 'Greenville Junction', 10000, 1),
(27354, 254, 145, 'Greenwald', 10000, 1),
(27355, 254, 125, 'Greenway', 10000, 1),
(27356, 254, 167, 'Greenway', 10000, 1),
(27357, 254, 140, 'Greenwell Springs', 10000, 1),
(27358, 254, 138, 'Greenwich', 10000, 1),
(27359, 254, 152, 'Greenwich', 10000, 1),
(27360, 254, 157, 'Greenwich', 10000, 1),
(27361, 254, 166, 'Greenwich', 10000, 1),
(27362, 254, 125, 'Greenwood', 10000, 1),
(27363, 254, 129, 'Greenwood', 10000, 1),
(27364, 254, 131, 'Greenwood', 10000, 1),
(27365, 254, 140, 'Greenwood', 10000, 1),
(27366, 254, 141, 'Greenwood', 10000, 1),
(27367, 254, 149, 'Greenwood', 10000, 1),
(27368, 254, 154, 'Greenwood', 10000, 1),
(27369, 254, 165, 'Greenwood', 10000, 1),
(27370, 254, 167, 'Greenwood', 10000, 1),
(27371, 254, 170, 'Greenwood', 10000, 1),
(27372, 254, 154, 'Greenwood Lake', 10000, 1),
(27373, 254, 146, 'Greenwood Springs', 10000, 1),
(27374, 254, 125, 'Gregory', 10000, 1),
(27375, 254, 144, 'Gregory', 10000, 1),
(27376, 254, 163, 'Gregory', 10000, 1),
(27377, 254, 165, 'Gregory', 10000, 1),
(27378, 254, 154, 'Greig', 10000, 1),
(27379, 254, 157, 'Grelton', 10000, 1),
(27380, 254, 126, 'Grenada', 10000, 1),
(27381, 254, 152, 'Grenloch', 10000, 1),
(27382, 254, 138, 'Grenola', 10000, 1),
(27383, 254, 156, 'Grenora', 10000, 1),
(27384, 254, 163, 'Grenville', 10000, 1),
(27385, 254, 149, 'Gresham', 10000, 1),
(27386, 254, 162, 'Gresham', 10000, 1),
(27387, 254, 170, 'Gresham', 10000, 1),
(27388, 254, 139, 'Grethel', 10000, 1),
(27389, 254, 131, 'Gretna', 10000, 1),
(27390, 254, 149, 'Gretna', 10000, 1),
(27391, 254, 167, 'Gretna', 10000, 1),
(27392, 254, 145, 'Grey Eagle', 10000, 1),
(27393, 254, 171, 'Greybull', 10000, 1),
(27394, 254, 148, 'Greycliff', 10000, 1),
(27395, 254, 138, 'Gridley', 10000, 1),
(27396, 254, 136, 'Griffin', 10000, 1),
(27397, 254, 136, 'Griffith', 10000, 1),
(27398, 254, 169, 'Griffithsville', 10000, 1),
(27399, 254, 125, 'Griffithville', 10000, 1),
(27400, 254, 155, 'Grifton', 10000, 1),
(27401, 254, 135, 'Griggsville', 10000, 1),
(27402, 254, 126, 'Grimes', 10000, 1),
(27403, 254, 137, 'Grimes', 10000, 1),
(27404, 254, 155, 'Grimesland', 10000, 1),
(27405, 254, 169, 'Grimms Landing', 10000, 1),
(27406, 254, 164, 'Grimsley', 10000, 1),
(27407, 254, 167, 'Grimstead', 10000, 1),
(27408, 254, 160, 'Grindstone', 10000, 1),
(27409, 254, 138, 'Grinnell', 10000, 1),
(27410, 254, 136, 'Grissom ARB', 10000, 1),
(27411, 254, 137, 'Griswold', 10000, 1),
(27412, 254, 126, 'Grizzly Flats', 10000, 1),
(27413, 254, 165, 'Groom', 10000, 1),
(27414, 254, 144, 'Grosse Ile', 10000, 1),
(27415, 254, 140, 'Grosse Tete', 10000, 1),
(27416, 254, 128, 'Grosvenor Dale', 10000, 1),
(27417, 254, 154, 'Groton', 10000, 1),
(27418, 254, 172, 'Groton', 10000, 1),
(27419, 254, 167, 'Grottoes', 10000, 1),
(27420, 254, 166, 'Grouse Creek', 10000, 1),
(27421, 254, 145, 'Grove City', 10000, 1),
(27422, 254, 160, 'Grove City', 10000, 1),
(27423, 254, 122, 'Grove Hill', 10000, 1),
(27424, 254, 126, 'Groveland', 10000, 1),
(27425, 254, 131, 'Groveland', 10000, 1),
(27426, 254, 135, 'Groveland', 10000, 1),
(27427, 254, 143, 'Groveland', 10000, 1),
(27428, 254, 154, 'Groveland', 10000, 1),
(27429, 254, 122, 'Groveoak', 10000, 1),
(27430, 254, 157, 'Groveport', 10000, 1),
(27431, 254, 127, 'Grover', 10000, 1),
(27432, 254, 147, 'Grover', 10000, 1),
(27433, 254, 155, 'Grover', 10000, 1),
(27434, 254, 160, 'Grover', 10000, 1),
(27435, 254, 162, 'Grover', 10000, 1),
(27436, 254, 171, 'Grover', 10000, 1),
(27437, 254, 157, 'Grover Hill', 10000, 1),
(27438, 254, 147, 'Grovespring', 10000, 1),
(27439, 254, 151, 'Groveton', 10000, 1),
(27440, 254, 125, 'Grubbs', 10000, 1),
(27441, 254, 147, 'Grubville', 10000, 1),
(27442, 254, 164, 'Gruetli Laager', 10000, 1),
(27443, 254, 165, 'Grulla', 10000, 1),
(27444, 254, 137, 'Grundy Center', 10000, 1),
(27445, 254, 137, 'Gruver', 10000, 1),
(27446, 254, 165, 'Gruver', 10000, 1),
(27447, 254, 145, 'Grygla', 10000, 1),
(27448, 254, 126, 'Guadalupe', 10000, 1),
(27449, 254, 153, 'Guadalupita', 10000, 1),
(27450, 254, 126, 'Guasti', 10000, 1),
(27451, 254, 126, 'Guatay', 10000, 1),
(27452, 254, 137, 'Guernsey', 10000, 1),
(27453, 254, 165, 'Guerra', 10000, 1),
(27454, 254, 140, 'Gueydan', 10000, 1),
(27455, 254, 127, 'Guffey', 10000, 1),
(27456, 254, 149, 'Guide Rock', 10000, 1),
(27457, 254, 151, 'Guild', 10000, 1),
(27458, 254, 164, 'Guild', 10000, 1),
(27459, 254, 154, 'Guilderland', 10000, 1),
(27460, 254, 154, 'Guilderland Center', 10000, 1),
(27461, 254, 172, 'Guildhall', 10000, 1),
(27462, 254, 128, 'Guilford', 10000, 1),
(27463, 254, 136, 'Guilford', 10000, 1),
(27464, 254, 147, 'Guilford', 10000, 1),
(27465, 254, 122, 'Guin', 10000, 1),
(27466, 254, 126, 'Guinda', 10000, 1),
(27467, 254, 125, 'Guion', 10000, 1),
(27468, 254, 155, 'Gulf', 10000, 1),
(27469, 254, 131, 'Gulf Hammock', 10000, 1),
(27470, 254, 144, 'Gulliver', 10000, 1),
(27471, 254, 145, 'Gully', 10000, 1),
(27472, 254, 127, 'Gulnare', 10000, 1),
(27473, 254, 139, 'Gulston', 10000, 1),
(27474, 254, 167, 'Gum Spring', 10000, 1),
(27475, 254, 155, 'Gumberry', 10000, 1),
(27476, 254, 139, 'Gunlock', 10000, 1),
(27477, 254, 166, 'Gunlock', 10000, 1),
(27478, 254, 146, 'Gunnison', 10000, 1),
(27479, 254, 166, 'Gunnison', 10000, 1),
(27480, 254, 142, 'Gunpowder', 10000, 1),
(27481, 254, 165, 'Gunter', 10000, 1),
(27482, 254, 146, 'Guntown', 10000, 1),
(27483, 254, 125, 'Gurdon', 10000, 1),
(27484, 254, 149, 'Gurley', 10000, 1),
(27485, 254, 166, 'Gusher', 10000, 1),
(27486, 254, 126, 'Gustine', 10000, 1),
(27487, 254, 165, 'Gustine', 10000, 1),
(27488, 254, 139, 'Guston', 10000, 1),
(27489, 254, 139, 'Guthrie', 10000, 1),
(27490, 254, 137, 'Guttenberg', 10000, 1),
(27491, 254, 125, 'Guy', 10000, 1),
(27492, 254, 165, 'Guy', 10000, 1),
(27493, 254, 164, 'Guys', 10000, 1),
(27494, 254, 157, 'Guysville', 10000, 1),
(27495, 254, 132, 'Guyton', 10000, 1),
(27496, 254, 144, 'Gwinn', 10000, 1),
(27497, 254, 156, 'Gwinner', 10000, 1),
(27498, 254, 160, 'Gwynedd', 10000, 1),
(27499, 254, 160, 'Gwynedd Valley', 10000, 1),
(27500, 254, 167, 'Gwynn', 10000, 1),
(27501, 254, 142, 'Gwynn Oak', 10000, 1),
(27502, 254, 136, 'Gwynneville', 10000, 1),
(27503, 254, 138, 'Gypsum', 10000, 1),
(27504, 254, 157, 'Gypsum', 10000, 1),
(27505, 254, 169, 'Gypsy', 10000, 1),
(27506, 254, 153, 'Hachita', 10000, 1),
(27507, 254, 124, 'Hackberry', 10000, 1),
(27508, 254, 140, 'Hackberry', 10000, 1),
(27509, 254, 145, 'Hackensack', 10000, 1),
(27510, 254, 169, 'Hacker Valley', 10000, 1),
(27511, 254, 125, 'Hackett', 10000, 1),
(27512, 254, 122, 'Hackleburg', 10000, 1),
(27513, 254, 167, 'Hacksneck', 10000, 1),
(27514, 254, 149, 'Hadar', 10000, 1),
(27515, 254, 128, 'Haddam', 10000, 1),
(27516, 254, 138, 'Haddam', 10000, 1),
(27517, 254, 132, 'Haddock', 10000, 1),
(27518, 254, 152, 'Haddon Heights', 10000, 1),
(27519, 254, 152, 'Haddonfield', 10000, 1),
(27520, 254, 167, 'Hadensville', 10000, 1),
(27521, 254, 139, 'Hadley', 10000, 1),
(27522, 254, 143, 'Hadley', 10000, 1),
(27523, 254, 154, 'Hadley', 10000, 1),
(27524, 254, 160, 'Hadley', 10000, 1),
(27525, 254, 128, 'Hadlyme', 10000, 1),
(27526, 254, 154, 'Hagaman', 10000, 1),
(27527, 254, 144, 'Hagar Shores', 10000, 1),
(27528, 254, 135, 'Hagarstown', 10000, 1),
(27529, 254, 125, 'Hagarville', 10000, 1),
(27530, 254, 170, 'Hager City', 10000, 1),
(27531, 254, 139, 'Hagerhill', 10000, 1),
(27532, 254, 136, 'Hagerstown', 10000, 1),
(27533, 254, 156, 'Hague', 10000, 1),
(27534, 254, 154, 'Hague', 10000, 1),
(27535, 254, 167, 'Hague', 10000, 1),
(27536, 254, 132, 'Hahira', 10000, 1),
(27537, 254, 140, 'Hahnville', 10000, 1),
(27538, 254, 149, 'Haigler', 10000, 1),
(27539, 254, 133, 'Haiku', 10000, 1),
(27540, 254, 154, 'Hailesboro', 10000, 1),
(27541, 254, 158, 'Haileyville', 10000, 1),
(27542, 254, 159, 'Haines', 10000, 1),
(27543, 254, 131, 'Haines City', 10000, 1),
(27544, 254, 154, 'Haines Falls', 10000, 1),
(27545, 254, 152, 'Hainesport', 10000, 1),
(27546, 254, 133, 'Hakalau', 10000, 1),
(27547, 254, 137, 'Halbur', 10000, 1),
(27548, 254, 154, 'Halcottsville', 10000, 1),
(27549, 254, 139, 'Haldeman', 10000, 1),
(27550, 254, 144, 'Hale', 10000, 1),
(27551, 254, 147, 'Hale', 10000, 1),
(27552, 254, 165, 'Hale Center', 10000, 1),
(27553, 254, 152, 'Haledon', 10000, 1),
(27554, 254, 170, 'Hales Corners', 10000, 1),
(27555, 254, 142, 'Halethorpe', 10000, 1),
(27556, 254, 122, 'Haleyville', 10000, 1),
(27557, 254, 147, 'Half Way', 10000, 1),
(27558, 254, 139, 'Halfway', 10000, 1),
(27559, 254, 159, 'Halfway', 10000, 1),
(27560, 254, 143, 'Halifax', 10000, 1),
(27561, 254, 160, 'Halifax', 10000, 1),
(27562, 254, 167, 'Halifax', 10000, 1),
(27563, 254, 148, 'Hall', 10000, 1),
(27564, 254, 154, 'Hall', 10000, 1),
(27565, 254, 140, 'Hall Summit', 10000, 1),
(27566, 254, 149, 'Hallam', 10000, 1),
(27567, 254, 150, 'Halleck', 10000, 1),
(27568, 254, 158, 'Hallett', 10000, 1),
(27569, 254, 165, 'Hallettsville', 10000, 1),
(27570, 254, 156, 'Halliday', 10000, 1),
(27571, 254, 139, 'Hallie', 10000, 1),
(27572, 254, 164, 'Halls', 10000, 1),
(27573, 254, 155, 'Hallsboro', 10000, 1),
(27574, 254, 160, 'Hallstead', 10000, 1),
(27575, 254, 147, 'Hallsville', 10000, 1),
(27576, 254, 157, 'Hallsville', 10000, 1),
(27577, 254, 165, 'Hallsville', 10000, 1),
(27578, 254, 147, 'Halltown', 10000, 1),
(27579, 254, 169, 'Halltown', 10000, 1),
(27580, 254, 167, 'Hallwood', 10000, 1),
(27581, 254, 145, 'Halma', 10000, 1),
(27582, 254, 149, 'Halsey', 10000, 1),
(27583, 254, 159, 'Halsey', 10000, 1),
(27584, 254, 138, 'Halstead', 10000, 1),
(27585, 254, 156, 'Hamberg', 10000, 1),
(27586, 254, 169, 'Hambleton', 10000, 1),
(27587, 254, 125, 'Hamburg', 10000, 1),
(27588, 254, 137, 'Hamburg', 10000, 1),
(27589, 254, 135, 'Hamburg', 10000, 1),
(27590, 254, 140, 'Hamburg', 10000, 1),
(27591, 254, 145, 'Hamburg', 10000, 1),
(27592, 254, 154, 'Hamden', 10000, 1),
(27593, 254, 157, 'Hamden', 10000, 1),
(27594, 254, 135, 'Hamel', 10000, 1),
(27595, 254, 145, 'Hamel', 10000, 1),
(27596, 254, 134, 'Hamer', 10000, 1),
(27597, 254, 162, 'Hamer', 10000, 1),
(27598, 254, 157, 'Hamersville', 10000, 1),
(27599, 254, 163, 'Hamill', 10000, 1),
(27600, 254, 127, 'Hamilton', 10000, 1),
(27601, 254, 137, 'Hamilton', 10000, 1),
(27602, 254, 135, 'Hamilton', 10000, 1),
(27603, 254, 136, 'Hamilton', 10000, 1),
(27604, 254, 138, 'Hamilton', 10000, 1),
(27605, 254, 143, 'Hamilton', 10000, 1),
(27606, 254, 144, 'Hamilton', 10000, 1),
(27607, 254, 147, 'Hamilton', 10000, 1),
(27608, 254, 146, 'Hamilton', 10000, 1),
(27609, 254, 155, 'Hamilton', 10000, 1),
(27610, 254, 156, 'Hamilton', 10000, 1),
(27611, 254, 154, 'Hamilton', 10000, 1),
(27612, 254, 160, 'Hamilton', 10000, 1),
(27613, 254, 167, 'Hamilton', 10000, 1),
(27614, 254, 168, 'Hamilton', 10000, 1),
(27615, 254, 126, 'Hamilton City', 10000, 1),
(27616, 254, 171, 'Hamilton Dome', 10000, 1),
(27617, 254, 136, 'Hamlet', 10000, 1),
(27618, 254, 155, 'Hamlet', 10000, 1),
(27619, 254, 149, 'Hamlet', 10000, 1),
(27620, 254, 135, 'Hamletsburg', 10000, 1),
(27621, 254, 137, 'Hamlin', 10000, 1),
(27622, 254, 139, 'Hamlin', 10000, 1),
(27623, 254, 154, 'Hamlin', 10000, 1),
(27624, 254, 160, 'Hamlin', 10000, 1),
(27625, 254, 165, 'Hamlin', 10000, 1),
(27626, 254, 134, 'Hammett', 10000, 1),
(27627, 254, 158, 'Hammon', 10000, 1),
(27628, 254, 148, 'Hammond', 10000, 1),
(27629, 254, 154, 'Hammond', 10000, 1),
(27630, 254, 159, 'Hammond', 10000, 1),
(27631, 254, 170, 'Hammond', 10000, 1),
(27632, 254, 154, 'Hammondsport', 10000, 1),
(27633, 254, 157, 'Hammondsville', 10000, 1),
(27634, 254, 143, 'Hampden', 10000, 1),
(27635, 254, 141, 'Hampden', 10000, 1),
(27636, 254, 156, 'Hampden', 10000, 1),
(27637, 254, 169, 'Hampden', 10000, 1),
(27638, 254, 167, 'Hampden Sydney', 10000, 1),
(27639, 254, 135, 'Hampshire', 10000, 1),
(27640, 254, 164, 'Hampshire', 10000, 1),
(27641, 254, 128, 'Hampton', 10000, 1),
(27642, 254, 131, 'Hampton', 10000, 1),
(27643, 254, 132, 'Hampton', 10000, 1),
(27644, 254, 135, 'Hampton', 10000, 1),
(27645, 254, 139, 'Hampton', 10000, 1),
(27646, 254, 145, 'Hampton', 10000, 1),
(27647, 254, 149, 'Hampton', 10000, 1),
(27648, 254, 151, 'Hampton', 10000, 1),
(27649, 254, 152, 'Hampton', 10000, 1),
(27650, 254, 154, 'Hampton', 10000, 1),
(27651, 254, 164, 'Hampton', 10000, 1),
(27652, 254, 154, 'Hampton Bays', 10000, 1),
(27653, 254, 151, 'Hampton Falls', 10000, 1),
(27654, 254, 155, 'Hamptonville', 10000, 1),
(27655, 254, 165, 'Hamshire', 10000, 1),
(27656, 254, 144, 'Hamtramck', 10000, 1),
(27657, 254, 133, 'Hana', 10000, 1),
(27658, 254, 133, 'Hanamaulu', 10000, 1),
(27659, 254, 122, 'Hanceville', 10000, 1),
(27660, 254, 137, 'Hancock', 10000, 1),
(27661, 254, 142, 'Hancock', 10000, 1),
(27662, 254, 141, 'Hancock', 10000, 1),
(27663, 254, 145, 'Hancock', 10000, 1),
(27664, 254, 151, 'Hancock', 10000, 1),
(27665, 254, 172, 'Hancock', 10000, 1),
(27666, 254, 170, 'Hancock', 10000, 1),
(27667, 254, 152, 'Hancocks Bridge', 10000, 1),
(27668, 254, 169, 'Handley', 10000, 1),
(27669, 254, 165, 'Hankamer', 10000, 1),
(27670, 254, 154, 'Hankins', 10000, 1),
(27671, 254, 156, 'Hankinson', 10000, 1),
(27672, 254, 145, 'Hanley Falls', 10000, 1),
(27673, 254, 137, 'Hanlontown', 10000, 1),
(27674, 254, 136, 'Hanna', 10000, 1),
(27675, 254, 158, 'Hanna', 10000, 1),
(27676, 254, 166, 'Hanna', 10000, 1),
(27677, 254, 135, 'Hanna City', 10000, 1),
(27678, 254, 154, 'Hannacroix', 10000, 1),
(27679, 254, 156, 'Hannaford', 10000, 1),
(27680, 254, 156, 'Hannah', 10000, 1),
(27681, 254, 160, 'Hannastown', 10000, 1),
(27682, 254, 154, 'Hannawa Falls', 10000, 1),
(27683, 254, 154, 'Hannibal', 10000, 1),
(27684, 254, 157, 'Hannibal', 10000, 1),
(27685, 254, 170, 'Hannibal', 10000, 1),
(27686, 254, 128, 'Hanover', 10000, 1),
(27687, 254, 135, 'Hanover', 10000, 1),
(27688, 254, 138, 'Hanover', 10000, 1),
(27689, 254, 143, 'Hanover', 10000, 1),
(27690, 254, 141, 'Hanover', 10000, 1),
(27691, 254, 144, 'Hanover', 10000, 1),
(27692, 254, 145, 'Hanover', 10000, 1),
(27693, 254, 153, 'Hanover', 10000, 1),
(27694, 254, 170, 'Hanover', 10000, 1),
(27695, 254, 169, 'Hanover', 10000, 1),
(27696, 254, 157, 'Hanoverton', 10000, 1),
(27697, 254, 156, 'Hansboro', 10000, 1),
(27698, 254, 143, 'Hanscom AFB', 10000, 1),
(27699, 254, 134, 'Hansen', 10000, 1),
(27700, 254, 169, 'Hansford', 10000, 1),
(27701, 254, 145, 'Hanska', 10000, 1),
(27702, 254, 139, 'Hanson', 10000, 1),
(27703, 254, 143, 'Hanson', 10000, 1),
(27704, 254, 138, 'Hanston', 10000, 1),
(27705, 254, 168, 'Hansville', 10000, 1),
(27706, 254, 139, 'Happy', 10000, 1),
(27707, 254, 124, 'Happy Jack', 10000, 1),
(27708, 254, 132, 'Haralson', 10000, 1),
(27709, 254, 144, 'Harbert', 10000, 1),
(27710, 254, 129, 'Harbeson', 10000, 1),
(27711, 254, 155, 'Harbinger', 10000, 1),
(27712, 254, 144, 'Harbor Springs', 10000, 1),
(27713, 254, 157, 'Harbor View', 10000, 1),
(27714, 254, 160, 'Harborcreek', 10000, 1),
(27715, 254, 141, 'Harborside', 10000, 1),
(27716, 254, 167, 'Harborton', 10000, 1),
(27717, 254, 137, 'Harcourt', 10000, 1),
(27718, 254, 122, 'Hardaway', 10000, 1),
(27719, 254, 139, 'Hardburly', 10000, 1),
(27720, 254, 162, 'Hardeeville', 10000, 1),
(27721, 254, 147, 'Hardenville', 10000, 1),
(27722, 254, 158, 'Hardesty', 10000, 1),
(27723, 254, 139, 'Hardin', 10000, 1),
(27724, 254, 147, 'Hardin', 10000, 1),
(27725, 254, 165, 'Hardin', 10000, 1),
(27726, 254, 136, 'Hardinsburg', 10000, 1),
(27727, 254, 138, 'Hardtner', 10000, 1),
(27728, 254, 132, 'Hardwick', 10000, 1),
(27729, 254, 143, 'Hardwick', 10000, 1),
(27730, 254, 145, 'Hardwick', 10000, 1),
(27731, 254, 172, 'Hardwick', 10000, 1),
(27732, 254, 125, 'Hardy', 10000, 1),
(27733, 254, 137, 'Hardy', 10000, 1),
(27734, 254, 139, 'Hardy', 10000, 1),
(27735, 254, 149, 'Hardy', 10000, 1),
(27736, 254, 167, 'Hardy', 10000, 1),
(27737, 254, 139, 'Hardyville', 10000, 1),
(27738, 254, 167, 'Hardyville', 10000, 1),
(27739, 254, 154, 'Harford', 10000, 1),
(27740, 254, 160, 'Harford', 10000, 1),
(27741, 254, 165, 'Hargill', 10000, 1),
(27742, 254, 155, 'Harkers Island', 10000, 1),
(27743, 254, 136, 'Harlan', 10000, 1),
(27744, 254, 160, 'Harleigh', 10000, 1),
(27745, 254, 148, 'Harlem', 10000, 1),
(27746, 254, 157, 'Harlem Springs', 10000, 1),
(27747, 254, 165, 'Harleton', 10000, 1),
(27748, 254, 160, 'Harleysville', 10000, 1),
(27749, 254, 162, 'Harleyville', 10000, 1),
(27750, 254, 167, 'Harman', 10000, 1),
(27751, 254, 169, 'Harman', 10000, 1),
(27752, 254, 142, 'Harmans', 10000, 1),
(27753, 254, 135, 'Harmon', 10000, 1),
(27754, 254, 140, 'Harmon', 10000, 1),
(27755, 254, 160, 'Harmonsburg', 10000, 1),
(27756, 254, 126, 'Harmony', 10000, 1),
(27757, 254, 136, 'Harmony', 10000, 1),
(27758, 254, 141, 'Harmony', 10000, 1),
(27759, 254, 155, 'Harmony', 10000, 1),
(27760, 254, 160, 'Harmony', 10000, 1),
(27761, 254, 161, 'Harmony', 10000, 1),
(27762, 254, 139, 'Harned', 10000, 1),
(27763, 254, 131, 'Harold', 10000, 1),
(27764, 254, 137, 'Harper', 10000, 1),
(27765, 254, 138, 'Harper', 10000, 1),
(27766, 254, 159, 'Harper', 10000, 1),
(27767, 254, 165, 'Harper', 10000, 1),
(27768, 254, 169, 'Harper', 10000, 1),
(27769, 254, 144, 'Harper Woods', 10000, 1),
(27770, 254, 137, 'Harpers Ferry', 10000, 1),
(27771, 254, 169, 'Harpers Ferry', 10000, 1),
(27772, 254, 154, 'Harpersfield', 10000, 1),
(27773, 254, 122, 'Harpersville', 10000, 1),
(27774, 254, 146, 'Harperville', 10000, 1),
(27775, 254, 157, 'Harpster', 10000, 1),
(27776, 254, 141, 'Harpswell', 10000, 1),
(27777, 254, 154, 'Harpursville', 10000, 1),
(27778, 254, 158, 'Harrah', 10000, 1),
(27779, 254, 168, 'Harrah', 10000, 1),
(27780, 254, 125, 'Harrell', 10000, 1),
(27781, 254, 155, 'Harrells', 10000, 1),
(27782, 254, 155, 'Harrellsville', 10000, 1),
(27783, 254, 125, 'Harriet', 10000, 1),
(27784, 254, 144, 'Harrietta', 10000, 1),
(27785, 254, 164, 'Harriman', 10000, 1),
(27786, 254, 129, 'Harrington', 10000, 1),
(27787, 254, 141, 'Harrington', 10000, 1),
(27788, 254, 168, 'Harrington', 10000, 1),
(27789, 254, 152, 'Harrington Park', 10000, 1),
(27790, 254, 137, 'Harris', 10000, 1),
(27791, 254, 144, 'Harris', 10000, 1),
(27792, 254, 145, 'Harris', 10000, 1),
(27793, 254, 147, 'Harris', 10000, 1),
(27794, 254, 155, 'Harris', 10000, 1),
(27795, 254, 154, 'Harris', 10000, 1),
(27796, 254, 125, 'Harrisburg', 10000, 1),
(27797, 254, 147, 'Harrisburg', 10000, 1),
(27798, 254, 155, 'Harrisburg', 10000, 1),
(27799, 254, 157, 'Harrisburg', 10000, 1),
(27800, 254, 159, 'Harrisburg', 10000, 1),
(27801, 254, 163, 'Harrisburg', 10000, 1),
(27802, 254, 132, 'Harrison', 10000, 1),
(27803, 254, 134, 'Harrison', 10000, 1),
(27804, 254, 141, 'Harrison', 10000, 1),
(27805, 254, 148, 'Harrison', 10000, 1),
(27806, 254, 152, 'Harrison', 10000, 1),
(27807, 254, 163, 'Harrison', 10000, 1),
(27808, 254, 164, 'Harrison', 10000, 1),
(27809, 254, 144, 'Harrison Township', 10000, 1),
(27810, 254, 160, 'Harrison Valley', 10000, 1),
(27812, 254, 147, 'Harrisonville', 10000, 1),
(27813, 254, 152, 'Harrisonville', 10000, 1),
(27814, 254, 160, 'Harrisonville', 10000, 1),
(27815, 254, 146, 'Harriston', 10000, 1),
(27816, 254, 135, 'Harristown', 10000, 1),
(27817, 254, 146, 'Harrisville', 10000, 1),
(27818, 254, 151, 'Harrisville', 10000, 1),
(27819, 254, 157, 'Harrisville', 10000, 1),
(27820, 254, 160, 'Harrisville', 10000, 1),
(27821, 254, 161, 'Harrisville', 10000, 1),
(27822, 254, 157, 'Harrod', 10000, 1),
(27823, 254, 139, 'Harrods Creek', 10000, 1),
(27824, 254, 136, 'Harrodsburg', 10000, 1),
(27825, 254, 164, 'Harrogate', 10000, 1),
(27826, 254, 163, 'Harrold', 10000, 1),
(27827, 254, 165, 'Harrold', 10000, 1),
(27828, 254, 144, 'Harsens Island', 10000, 1),
(27829, 254, 170, 'Harshaw', 10000, 1),
(27830, 254, 167, 'Hartfield', 10000, 1),
(27831, 254, 125, 'Hartford', 10000, 1),
(27832, 254, 137, 'Hartford', 10000, 1),
(27833, 254, 135, 'Hartford', 10000, 1),
(27834, 254, 138, 'Hartford', 10000, 1),
(27835, 254, 154, 'Hartford', 10000, 1),
(27836, 254, 157, 'Hartford', 10000, 1),
(27837, 254, 163, 'Hartford', 10000, 1),
(27838, 254, 164, 'Hartford', 10000, 1),
(27839, 254, 172, 'Hartford', 10000, 1),
(27840, 254, 169, 'Hartford', 10000, 1),
(27841, 254, 145, 'Hartland', 10000, 1),
(27842, 254, 170, 'Hartland', 10000, 1),
(27843, 254, 172, 'Hartland Four Corners', 10000, 1),
(27844, 254, 160, 'Hartleton', 10000, 1),
(27845, 254, 137, 'Hartley', 10000, 1),
(27846, 254, 165, 'Hartley', 10000, 1),
(27847, 254, 168, 'Hartline', 10000, 1),
(27848, 254, 129, 'Hartly', 10000, 1),
(27849, 254, 125, 'Hartman', 10000, 1),
(27850, 254, 127, 'Hartman', 10000, 1),
(27851, 254, 169, 'Harts', 10000, 1),
(27852, 254, 135, 'Hartsburg', 10000, 1),
(27853, 254, 147, 'Hartsburg', 10000, 1),
(27854, 254, 154, 'Hartsdale', 10000, 1),
(27855, 254, 127, 'Hartsel', 10000, 1),
(27856, 254, 132, 'Hartsfield', 10000, 1),
(27857, 254, 147, 'Hartshorn', 10000, 1),
(27858, 254, 158, 'Hartshorne', 10000, 1),
(27859, 254, 160, 'Hartstown', 10000, 1),
(27860, 254, 171, 'Hartville', 10000, 1),
(27861, 254, 137, 'Hartwick', 10000, 1),
(27862, 254, 154, 'Hartwick', 10000, 1),
(27863, 254, 167, 'Hartwood', 10000, 1),
(27864, 254, 134, 'Harvard', 10000, 1),
(27865, 254, 149, 'Harvard', 10000, 1),
(27866, 254, 135, 'Harvel', 10000, 1),
(27867, 254, 122, 'Harvest', 10000, 1),
(27868, 254, 125, 'Harvey', 10000, 1),
(27869, 254, 137, 'Harvey', 10000, 1),
(27870, 254, 156, 'Harvey', 10000, 1),
(27871, 254, 160, 'Harveys Lake', 10000, 1),
(27872, 254, 157, 'Harveysburg', 10000, 1),
(27873, 254, 138, 'Harveyville', 10000, 1),
(27874, 254, 147, 'Harviell', 10000, 1),
(27875, 254, 143, 'Harwich Port', 10000, 1),
(27876, 254, 160, 'Harwick', 10000, 1),
(27877, 254, 128, 'Harwinton', 10000, 1),
(27878, 254, 147, 'Harwood', 10000, 1),
(27879, 254, 156, 'Harwood', 10000, 1),
(27880, 254, 165, 'Harwood', 10000, 1),
(27881, 254, 135, 'Harwood Heights', 10000, 1),
(27882, 254, 152, 'Haskell', 10000, 1),
(27883, 254, 158, 'Haskell', 10000, 1),
(27884, 254, 157, 'Haskins', 10000, 1),
(27885, 254, 165, 'Haslet', 10000, 1),
(27886, 254, 155, 'Hassell', 10000, 1),
(27887, 254, 131, 'Hastings', 10000, 1),
(27888, 254, 137, 'Hastings', 10000, 1),
(27889, 254, 154, 'Hastings', 10000, 1),
(27890, 254, 158, 'Hastings', 10000, 1),
(27891, 254, 160, 'Hastings', 10000, 1),
(27892, 254, 154, 'Hastings on Hudson', 10000, 1),
(27893, 254, 125, 'Hasty', 10000, 1),
(27894, 254, 127, 'Hasty', 10000, 1),
(27895, 254, 127, 'Haswell', 10000, 1),
(27896, 254, 126, 'Hat Creek', 10000, 1),
(27897, 254, 160, 'Hatboro', 10000, 1),
(27898, 254, 153, 'Hatch', 10000, 1),
(27899, 254, 166, 'Hatch', 10000, 1),
(27900, 254, 122, 'Hatchechubbee', 10000, 1),
(27901, 254, 125, 'Hatfield', 10000, 1),
(27902, 254, 136, 'Hatfield', 10000, 1),
(27903, 254, 143, 'Hatfield', 10000, 1),
(27904, 254, 147, 'Hatfield', 10000, 1),
(27905, 254, 148, 'Hathaway', 10000, 1),
(27906, 254, 126, 'Hathaway Pines', 10000, 1),
(27907, 254, 143, 'Hathorne', 10000, 1),
(27908, 254, 170, 'Hatley', 10000, 1),
(27909, 254, 125, 'Hattieville', 10000, 1),
(27910, 254, 125, 'Hatton', 10000, 1),
(27911, 254, 156, 'Hatton', 10000, 1),
(27912, 254, 168, 'Hatton', 10000, 1),
(27913, 254, 136, 'Haubstadt', 10000, 1),
(27914, 254, 148, 'Haugan', 10000, 1),
(27915, 254, 170, 'Haugen', 10000, 1),
(27916, 254, 133, 'Hauula', 10000, 1),
(27917, 254, 169, 'Havaco', 10000, 1),
(27918, 254, 125, 'Havana', 10000, 1),
(27919, 254, 138, 'Havana', 10000, 1),
(27920, 254, 156, 'Havana', 10000, 1),
(27921, 254, 137, 'Havelock', 10000, 1),
(27922, 254, 138, 'Haven', 10000, 1),
(27923, 254, 138, 'Havensville', 10000, 1),
(27924, 254, 160, 'Haverford', 10000, 1),
(27925, 254, 137, 'Haverhill', 10000, 1),
(27926, 254, 151, 'Haverhill', 10000, 1),
(27927, 254, 157, 'Haverhill', 10000, 1),
(27928, 254, 154, 'Haverstraw', 10000, 1),
(27929, 254, 157, 'Haviland', 10000, 1),
(27930, 254, 155, 'Haw River', 10000, 1),
(27931, 254, 133, 'Hawaii National Park', 10000, 1),
(27932, 254, 137, 'Hawarden', 10000, 1),
(27933, 254, 133, 'Hawi', 10000, 1),
(27934, 254, 145, 'Hawick', 10000, 1),
(27935, 254, 147, 'Hawk Point', 10000, 1),
(27936, 254, 160, 'Hawk Run', 10000, 1),
(27937, 254, 171, 'Hawk Springs', 10000, 1),
(27938, 254, 137, 'Hawkeye', 10000, 1),
(27939, 254, 165, 'Hawkins', 10000, 1),
(27940, 254, 170, 'Hawkins', 10000, 1),
(27941, 254, 144, 'Hawks', 10000, 1),
(27942, 254, 145, 'Hawley', 10000, 1),
(27943, 254, 165, 'Hawley', 10000, 1),
(27944, 254, 128, 'Hawleyville', 10000, 1),
(27945, 254, 152, 'Haworth', 10000, 1),
(27946, 254, 158, 'Haworth', 10000, 1),
(27947, 254, 160, 'Hawthorn', 10000, 1),
(27948, 254, 131, 'Hawthorne', 10000, 1),
(27949, 254, 170, 'Hawthorne', 10000, 1),
(27950, 254, 127, 'Haxtun', 10000, 1),
(27951, 254, 168, 'Hay', 10000, 1),
(27952, 254, 149, 'Hay Springs', 10000, 1),
(27953, 254, 122, 'Hayden', 10000, 1),
(27954, 254, 124, 'Hayden', 10000, 1),
(27955, 254, 127, 'Hayden', 10000, 1),
(27956, 254, 143, 'Haydenville', 10000, 1),
(27957, 254, 157, 'Haydenville', 10000, 1),
(27958, 254, 140, 'Hayes', 10000, 1),
(27959, 254, 167, 'Hayes', 10000, 1),
(27960, 254, 137, 'Hayesville', 10000, 1),
(27961, 254, 157, 'Hayesville', 10000, 1),
(27962, 254, 145, 'Hayfield', 10000, 1),
(27963, 254, 167, 'Haymarket', 10000, 1),
(27964, 254, 125, 'Haynes', 10000, 1),
(27965, 254, 140, 'Haynesville', 10000, 1),
(27966, 254, 167, 'Haynesville', 10000, 1),
(27967, 254, 148, 'Hays', 10000, 1),
(27968, 254, 155, 'Hays', 10000, 1),
(27969, 254, 147, 'Hayti', 10000, 1),
(27970, 254, 167, 'Haywood', 10000, 1),
(27971, 254, 169, 'Haywood', 10000, 1),
(27972, 254, 149, 'Hazard', 10000, 1),
(27973, 254, 139, 'Hazel', 10000, 1),
(27974, 254, 163, 'Hazel', 10000, 1),
(27975, 254, 135, 'Hazel Crest', 10000, 1),
(27976, 254, 139, 'Hazel Green', 10000, 1),
(27977, 254, 170, 'Hazel Green', 10000, 1),
(27978, 254, 160, 'Hazel Hurst', 10000, 1),
(27979, 254, 170, 'Hazelhurst', 10000, 1),
(27980, 254, 134, 'Hazelton', 10000, 1),
(27981, 254, 138, 'Hazelton', 10000, 1),
(27982, 254, 156, 'Hazelton', 10000, 1),
(27983, 254, 169, 'Hazelton', 10000, 1),
(27984, 254, 155, 'Hazelwood', 10000, 1),
(27985, 254, 125, 'Hazen', 10000, 1),
(27986, 254, 137, 'Hazleton', 10000, 1),
(27987, 254, 136, 'Hazleton', 10000, 1),
(27988, 254, 167, 'Head Waters', 10000, 1),
(27989, 254, 158, 'Headrick', 10000, 1),
(27990, 254, 170, 'Heafford Junction', 10000, 1),
(27991, 254, 158, 'Healdton', 10000, 1),
(27992, 254, 138, 'Healy', 10000, 1),
(27993, 254, 148, 'Heart Butte', 10000, 1),
(27994, 254, 149, 'Heartwell', 10000, 1),
(27995, 254, 169, 'Heaters', 10000, 1),
(27996, 254, 143, 'Heath', 10000, 1),
(27997, 254, 162, 'Heath Springs', 10000, 1),
(27998, 254, 158, 'Heavener', 10000, 1),
(27999, 254, 126, 'Heber', 10000, 1),
(28000, 254, 159, 'Hebo', 10000, 1),
(28001, 254, 128, 'Hebron', 10000, 1),
(28002, 254, 135, 'Hebron', 10000, 1),
(28003, 254, 136, 'Hebron', 10000, 1),
(28004, 254, 139, 'Hebron', 10000, 1),
(28005, 254, 141, 'Hebron', 10000, 1),
(28006, 254, 156, 'Hebron', 10000, 1),
(28007, 254, 151, 'Hebron', 10000, 1),
(28008, 254, 157, 'Hebron', 10000, 1),
(28009, 254, 135, 'Hecker', 10000, 1),
(28010, 254, 163, 'Hecla', 10000, 1),
(28011, 254, 125, 'Hector', 10000, 1),
(28012, 254, 145, 'Hector', 10000, 1),
(28013, 254, 154, 'Hector', 10000, 1),
(28014, 254, 169, 'Hedgesville', 10000, 1),
(28015, 254, 165, 'Hedley', 10000, 1),
(28016, 254, 137, 'Hedrick', 10000, 1),
(28017, 254, 140, 'Heflin', 10000, 1),
(28018, 254, 160, 'Hegins', 10000, 1),
(28019, 254, 139, 'Heidelberg', 10000, 1),
(28020, 254, 146, 'Heidelberg', 10000, 1),
(28021, 254, 165, 'Heidenheimer', 10000, 1),
(28022, 254, 139, 'Heidrick', 10000, 1),
(28023, 254, 160, 'Heilwood', 10000, 1),
(28024, 254, 164, 'Heiskell', 10000, 1),
(28025, 254, 152, 'Heislerville', 10000, 1),
(28026, 254, 168, 'Heisson', 10000, 1),
(28027, 254, 132, 'Helen', 10000, 1),
(28028, 254, 142, 'Helen', 10000, 1),
(28029, 254, 169, 'Helen', 10000, 1),
(28030, 254, 122, 'Helena', 10000, 1),
(28031, 254, 132, 'Helena', 10000, 1),
(28032, 254, 147, 'Helena', 10000, 1),
(28033, 254, 154, 'Helena', 10000, 1),
(28034, 254, 157, 'Helena', 10000, 1),
(28035, 254, 158, 'Helena', 10000, 1),
(28036, 254, 126, 'Helendale', 10000, 1),
(28037, 254, 170, 'Helenville', 10000, 1),
(28038, 254, 164, 'Helenwood', 10000, 1),
(28039, 254, 159, 'Helix', 10000, 1),
(28040, 254, 160, 'Hellertown', 10000, 1),
(28041, 254, 139, 'Hellier', 10000, 1),
(28042, 254, 126, 'Helm', 10000, 1),
(28043, 254, 152, 'Helmetta', 10000, 1),
(28044, 254, 136, 'Helmsburg', 10000, 1),
(28045, 254, 148, 'Helmville', 10000, 1),
(28046, 254, 165, 'Helotes', 10000, 1),
(28047, 254, 166, 'Helper', 10000, 1),
(28048, 254, 139, 'Helton', 10000, 1),
(28049, 254, 136, 'Heltonville', 10000, 1),
(28050, 254, 169, 'Helvetia', 10000, 1),
(28051, 254, 147, 'Hematite', 10000, 1),
(28052, 254, 162, 'Hemingway', 10000, 1),
(28053, 254, 136, 'Hemlock', 10000, 1),
(28054, 254, 144, 'Hemlock', 10000, 1),
(28055, 254, 154, 'Hemlock', 10000, 1),
(28056, 254, 169, 'Hemphill', 10000, 1),
(28057, 254, 122, 'Henagar', 10000, 1),
(28058, 254, 125, 'Henderson', 10000, 1),
(28059, 254, 127, 'Henderson', 10000, 1),
(28060, 254, 137, 'Henderson', 10000, 1),
(28061, 254, 135, 'Henderson', 10000, 1),
(28062, 254, 142, 'Henderson', 10000, 1),
(28063, 254, 144, 'Henderson', 10000, 1),
(28064, 254, 145, 'Henderson', 10000, 1),
(28065, 254, 149, 'Henderson', 10000, 1),
(28066, 254, 154, 'Henderson', 10000, 1),
(28067, 254, 169, 'Henderson', 10000, 1),
(28068, 254, 154, 'Henderson Harbor', 10000, 1),
(28069, 254, 160, 'Hendersonville', 10000, 1),
(28070, 254, 149, 'Hendley', 10000, 1),
(28071, 254, 145, 'Hendricks', 10000, 1),
(28072, 254, 169, 'Hendricks', 10000, 1),
(28073, 254, 158, 'Hendrix', 10000, 1),
(28074, 254, 145, 'Hendrum', 10000, 1),
(28075, 254, 166, 'Henefer', 10000, 1),
(28076, 254, 169, 'Henlawson', 10000, 1),
(28077, 254, 147, 'Henley', 10000, 1),
(28078, 254, 135, 'Hennepin', 10000, 1),
(28079, 254, 158, 'Hennepin', 10000, 1),
(28080, 254, 151, 'Henniker', 10000, 1),
(28081, 254, 135, 'Henning', 10000, 1),
(28082, 254, 145, 'Henning', 10000, 1),
(28083, 254, 164, 'Henning', 10000, 1),
(28084, 254, 155, 'Henrico', 10000, 1),
(28085, 254, 147, 'Henrietta', 10000, 1),
(28086, 254, 155, 'Henrietta', 10000, 1),
(28087, 254, 145, 'Henriette', 10000, 1),
(28088, 254, 166, 'Henrieville', 10000, 1),
(28089, 254, 135, 'Henry', 10000, 1),
(28090, 254, 149, 'Henry', 10000, 1),
(28091, 254, 163, 'Henry', 10000, 1),
(28092, 254, 164, 'Henry', 10000, 1),
(28093, 254, 167, 'Henry', 10000, 1),
(28094, 254, 158, 'Henryetta', 10000, 1),
(28095, 254, 142, 'Henryton', 10000, 1),
(28096, 254, 160, 'Henryville', 10000, 1),
(28097, 254, 156, 'Hensel', 10000, 1),
(28098, 254, 125, 'Hensley', 10000, 1),
(28099, 254, 169, 'Hensley', 10000, 1),
(28100, 254, 154, 'Hensonville', 10000, 1),
(28101, 254, 132, 'Hephzibah', 10000, 1),
(28102, 254, 138, 'Hepler', 10000, 1),
(28103, 254, 159, 'Heppner', 10000, 1),
(28104, 254, 169, 'Hepzibah', 10000, 1),
(28105, 254, 126, 'Herald', 10000, 1),
(28106, 254, 135, 'Herald', 10000, 1),
(28107, 254, 170, 'Herbster', 10000, 1),
(28108, 254, 124, 'Hereford', 10000, 1),
(28109, 254, 127, 'Hereford', 10000, 1),
(28110, 254, 159, 'Hereford', 10000, 1),
(28111, 254, 160, 'Hereford', 10000, 1),
(28112, 254, 138, 'Herington', 10000, 1),
(28113, 254, 154, 'Herkimer', 10000, 1),
(28114, 254, 126, 'Herlong', 10000, 1),
(28115, 254, 145, 'Herman', 10000, 1),
(28116, 254, 149, 'Herman', 10000, 1),
(28117, 254, 160, 'Herman', 10000, 1),
(28118, 254, 144, 'Hermansville', 10000, 1),
(28119, 254, 146, 'Hermanville', 10000, 1),
(28120, 254, 160, 'Herminie', 10000, 1),
(28121, 254, 125, 'Hermitage', 10000, 1),
(28122, 254, 165, 'Hermleigh', 10000, 1),
(28123, 254, 154, 'Hermon', 10000, 1),
(28124, 254, 163, 'Hermosa', 10000, 1),
(28125, 254, 153, 'Hernandez', 10000, 1),
(28126, 254, 138, 'Herndon', 10000, 1),
(28127, 254, 139, 'Herndon', 10000, 1),
(28128, 254, 160, 'Herndon', 10000, 1),
(28129, 254, 169, 'Herndon', 10000, 1),
(28130, 254, 169, 'Hernshaw', 10000, 1),
(28131, 254, 135, 'Herod', 10000, 1),
(28132, 254, 148, 'Heron', 10000, 1),
(28133, 254, 145, 'Heron Lake', 10000, 1),
(28134, 254, 163, 'Herreid', 10000, 1),
(28135, 254, 135, 'Herrick', 10000, 1),
(28136, 254, 163, 'Herrick', 10000, 1),
(28137, 254, 160, 'Herrick Center', 10000, 1),
(28138, 254, 144, 'Herron', 10000, 1),
(28139, 254, 135, 'Herscher', 10000, 1),
(28140, 254, 149, 'Hershey', 10000, 1),
(28141, 254, 170, 'Hertel', 10000, 1),
(28142, 254, 144, 'Hesperia', 10000, 1),
(28143, 254, 