<?php

  include_once "counter/db/config.php";

  session_start();

?>

<html>
<head>  
  <title>Admin | Irungi Kitchen &copy;</title>


  <!-- Favicon  -->
    <link rel="icon" href="../logo/7.png">

  <!--Boxicons-->
  <link href="assets/boxicon.min.css" rel="stylesheet">


  <!--CSS-->
  <link rel="stylesheet" type="text/css" href="assets/css/bootstrap/bootstrap.min.css">
  <link rel="stylesheet" type="text/css" href="assets/datatable/dataTable.bootstrap.min.css">



<style type="text/css">


body {
  background: black;
}

.top-btns {
  padding: 20px;
}




h1 {
    text-transform: uppercase;
    font-weight: bold;
    font-size: 30px;
    color: #f195b2;
    text-align: center;
    margin-bottom: 40px;
}


h2 {
    font-weight: bold;
    font-size: 25px;
    color: #f195b2;
    text-align: center;
}


.sec-pad{
  padding: 20px 20px 20px 20px;
}


/*Industry*/

.industry-section {
    margin-bottom: 20px;
    border-radius: 10px;
    box-shadow: 0 0 4px 0 #f195b2;
}



.industry-section h3 {
    font-weight: bold;
    font-size: 14px;
    color: #f195b2;
    text-align: center;
    padding-top: 10px;
}



.industry-section a{
  font-size: 20px;
  margin: 20px;
}


.industry-section .bx-trash {
  color: #f195b2;
}


.industry-section .bx-edit {
  color: #f195b2;
}


.industry-section h6{
    font-weight: bold;
    font-size: 12px;
    text-transform: uppercase;
    text-align: center;
    color: #f195b2;
    margin-top: 10px;
    margin-bottom: 10px;
}

.industry-section .id{
  margin: 5px;
  text-align: center;
  font-size: 12px;
  color: #FEFAFA;
  width: 25px;
  height: 25px;
  padding: 4px;
  border-radius: 50px;
  background: #f195b2;
  box-shadow: 1px 1px 2px 0 rgba(0, 0, 0, 0.2);
}


.industry-section img{
    width: 100%;
    height: 250px;
    object-fit: cover;
    object-position: top;
  margin-bottom: 10px;
}

.industry-section b {
  font-size: 14px;
  color: white;
  padding: 5px 10px;
  border-radius: 30px;
  background: #f195b2;
}

.industry-section p {
  margin-top: 20px;
}


.industry-section .price {
  font-weight: bold;
  font-size: 20px;
  text-align: center;
  color: #f195b2;
  margin-top: 20px;
  margin-bottom: 20px;
}



.count {
  text-align: center;
  font-weight: bold;
  color: #f195b2;
  text-decoration: underline;
}



.approve-links {
  margin: 30px 20px 5px 20px;
  color: white;
  border: none;
  border-radius: 5px;
  padding: 10px 20px;
  background: #f195b2;
}

.approve-links a {
  color: white !important;
  font-size: 12px;
}


.filter-links {
  margin: 0 20px 20px 20px;
  color: white;
  border: none;
  border-radius: 5px;
  padding: 10px 20px;
  background: #f195b2;
}

.filter-links a {
  display: inline-block;
  color: white !important;
  font-size: 12px;
}



.search {
  margin: 30px 20px 50px 20px;
}

.search form input[type=text] {
padding: 5px;
border: 0;
color: #f195b2;
border-bottom: 1px solid #f195b2;
background: none;
transition: 1s;
}

.search form input[type=text]:hover {
  width: 40%;
border-bottom: 1px solid #f195b2;
}

.search form button {
  color: #f195b2;
padding: 5px;
border: 0;
background: none;
}

.search form button i:hover {
  width: 30%;
}



/*Upload Wrapper*/
    
.upload-wrapper {
    width: 40%;
    border-radius: 10px;
}

.upload-btn-wrapper input[type=file] {
  font-size: 100px;
  width: 200px;
  height: 150px;
  margin-top: -120px;
  margin-bottom: 20px;
  opacity: 0;
  z-index: 9;
}

.upload-btn-wrapper .btn img {
    width: 100px;
    height: 100px;
    border-radius: 10px;
}

.output_image1 {
    margin-top: -160px;
  width: 120px;
    height: 120px;
    border-radius: 10px;
}

img.output_image1{
  width: 120px;
    height: 120px;
  object-fit: cover;
}


/* If the screen size is  btn 440.98px wide or less */
@media screen and (max-width: 440.98px) and (min-width: 0) {

.upload-btn-wrapper input[type=file] {
  width: 120px;
  height: 120px;
}

.upload-btn-wrapper .btn img {
    width: 100px;
    height: 100px;
}

.output_image1 {
    margin-top: -140px;
  width: 120px;
    height: 120px;
}

 }


/* If the screen size is  btn 575.98px wide and 441px less */
@media screen and (max-width: 575.98px) and (min-width: 441px) {

.upload-btn-wrapper input[type=file] {
  width: 140px;
  height: 130px;
}

.upload-btn-wrapper .btn img {
    width: 100px;
    height: 100px;
}

.output_image1 {
    margin-top: -140px;
  width: 120px;
    height: 120px;
}

 }

/* If the screen size is  btn 767.98px less and 576px wide */
@media screen and (max-width: 767.98px) and (min-width: 576px) {

.upload-btn-wrapper input[type=file] {
  width: 200px;
  height: 120px;
}

.upload-btn-wrapper .btn img {
    width: 100px;
    height: 100px;
}

.output_image1 {
    margin-top: -140px;
  width: 120px;
    height: 120px;
}



 }


 /* If the screen size is  btn 991.98px less and 768px wide */
@media screen and (max-width: 991.98px) and (min-width: 768px) {

.upload-btn-wrapper input[type=file] {
  width: 180px;
  height: 150px;
  margin-bottom: -100px;
}

.output_image1 {
    margin-top: -50px;
    margin-left: 0;
}

 }

/* If the screen size is btn 119.98px less and 992px wide */
@media screen and (max-width: 1199.98px) and (min-width: 992px) {

.upload-btn-wrapper input[type=file] {
  font-size: 100px;
  width: 200px;
  height: 150px;
}

 }


/*Counters*/

.count-box,
.msg-box {
  position: absolute;
  font-size: 8px;
  margin-top: -4px;
}


</style>

</head>

<body>

  <div align="center"> <br>
  <a href="../"><img src="../img/irungi-logo.png"></a>
  </div>
  
      <?php
        if(isset($_SESSION['error'])){
          echo
          " <br>
          <div class='alert alert-danger text-center'>
            <button class='close'>&times;</button>
            ".$_SESSION['error']."
          </div>
          ";
          unset($_SESSION['error']);
        }
        if(isset($_SESSION['success'])){
          echo
          " <br>
          <div class='alert alert-success text-center'>
            <button class='close'>&times;</button>
            ".$_SESSION['success']."
          </div>
          ";
          unset($_SESSION['success']);
        }
      ?>
      
      <div class="top-btns">
        <a href="#addnew" data-toggle="modal" class="btn btn-primary" style="background: #f195b2;border: none;position: fixed;z-index: 9;"><span class="glyphicon glyphicon-plus"></span> New</a>

        <a href="contact/seen" class="btn btn-success pull-right" style="background: #f195b2;border: none;border-top-left-radius: 0;border-bottom-left-radius: 0;"><span class="bx bx-chat" style="font-size: 25px;"></span> <span class="msg-box"></span></a>

        <a href="orders/seen" class="btn btn-success pull-right" style="background: #f195b2;border: none;border-top-right-radius: 0;border-bottom-right-radius: 0;border-right: 1px solid white;"><span class="bx bx-cart" style="font-size: 25px;"></span> <span class="count-box"></span></a>

      </div>


      
      <div class="chat-box">

      </div>

<br> <br>


<h1>Products</h1>

<div class="count">

      <?php 

 include_once('db/count_db.php');

// of college_data table 

$sql = "SELECT count(*) FROM shop"; 

$result = $conn->query($sql); 

  
// Display data on web page 

while($row = mysqli_fetch_array($result)) { 

    echo $row['count(*)']. " Items in the Irungi Database"; 

    echo "<br />"; 
} 

   
// Close the connection 

$conn->close(); 

  
?>

</div>



<!--Search-->


<div class="search" align="center">
  
  <form action="search/index.php" method="post">
    
    <input type="text" name="valueToSearch" placeholder="Search Database" required>

    <button name="search"><i class="bx-fw bx bx-search"></i></button>

  </form>

</div>
     


     <!--Start Categories-->
      

 <section class="sec-pad" align="center">


       

                <div class="row">

            <?php

              include_once('db/connection.php');
              $sql = "SELECT * FROM shop ORDER BY id DESC";

              //use for MySQLi-OOP
              $query = $conn->query($sql);
              while($row = $query->fetch_assoc()){

        echo "<div class='col-12 col-sm-6 col-lg-3'>";

        echo "<div class='industry-section wow fadeInUpBig' data-wow-delay='0.2s' data-wow-delay='0.2s'>";

         echo "<h3>".$row['name']."</h3>";

         if ($row['image']=='') {
                echo '<img src="../img/irungi.png">';
              } else {
                echo '<img src="images/'.$row['image'].'">';
              }

                echo "<div align='center'>";

            
            echo "<b>".$row['cat']."</b>";     

            
            echo "<p>".$row['ingredients']."</p>";     

         echo "</div>";

         if ($row['price_1']=='') {
            echo "<div class='price'>Ush"." ".number_format ($row['p_range1'])."</div>";
         } else {
             echo "<div class='price'>Ush"." ".number_format ($row['price_1'])."</div>";
         }

             echo "<hr style='color: #f195b2;'>";

                     echo "<div align='center'>";

          echo "<div class='approve-links'>";

        if ($row['instock']=="") { echo "<a href=\"filters/stock/in/index.php?id=$row[id]\" onClick=\"return confirm('Are you sure this item is available in stock?')\">Add to Stock</a> | <a href=\"filters/stock/out/index.php?id=$row[id]\" onClick=\"return confirm('Are you sure this item is out of stock?')\">Out of Stock</a>"; }

          elseif ($row['instock']==1) { echo "<a><i class='bx-fw bx bxs-check-circle'></i> In Stock</a> | <a href=\"filters/stock/out/index.php?id=$row[id]\" onClick=\"return confirm('Are you sure you this item is out of stock?')\">Out of Stock</a>"; } 

          elseif ($row['instock']==2) { echo "<a href=\"filters/stock/in/index.php?id=$row[id]\" onClick=\"return confirm('Are you sure this item is available in stock?')\">Add to Stock</a> | <a><i class='bx-fw bx bxs-check-circle'></i> Out of Stock</a>"; }
        echo "</div>";


        

echo "<div class='filter-links'>";

        if ($row['picks']=="") { echo "<a href=\"filters/picks/in/index.php?id=$row[id]\">Top Picks</a>"; }

          elseif ($row['picks']==1) { echo "<a href=\"filters/picks/out/index.php?id=$row[id]\"><i class='bx-fw bx bxs-check-circle'></i>Top Picks</a>"; } 

          if ($row['recom']=="") { echo "<a href=\"filters/recom/in/index.php?id=$row[id]\">Recommended</a>"; }

          elseif ($row['recom']==1) { echo "<a href=\"filters/recom/out/index.php?id=$row[id]\"><i class='bx-fw bx bxs-check-circle'></i>Recommended</a>"; } 

          if ($row['essential']=="") { echo "<a href=\"filters/essentials/in/index.php?id=$row[id]\">Essentials</a>"; }

          elseif ($row['essential']==1) { echo "<a href=\"filters/essentials/out/index.php?id=$row[id]\"><i class='bx-fw bx bxs-check-circle'></i>Essentials</a>"; } 

          if ($row['arrivals']=="") { echo "<a href=\"filters/arrivals/in/index.php?id=$row[id]\">New Arrivals</a>"; }

          elseif ($row['arrivals']==1) { echo "<a href=\"filters/arrivals/out/index.php?id=$row[id]\"><i class='bx-fw bx bxs-check-circle'></i>New Arrivals</a>"; } 

          if ($row['trend']=="") { echo "<a href=\"filters/trend/in/index.php?id=$row[id]\">Top Seller</a>"; }

          elseif ($row['trend']==1) { echo "<a href=\"filters/trend/out/index.php?id=$row[id]\"><i class='bx-fw bx bxs-check-circle'></i>Top Seller</a>"; } 
          
        echo "</div>";


        echo "<a href='#edit_".$row['id']."' data-toggle='modal'><i class='bx-fw bx bx-edit'></i></a> <span style='color: #f195b2;'>|</span> <a href='#delete_".$row['id']."' data-toggle='modal'><i class='bx-fw bx bx-trash'></i></a>";

         echo "</div>";

 

      echo "<br>";  

    echo "</div>";

    echo "</div>";




//Edit Image Upload

echo "<script>

function preview_image".$row['id']."(event) 
{
var reader = new FileReader();
reader.onload = function()
{
  var output = document.getElementById('output_image".$row['id']."');
  output.src = reader.result;
}
reader.readAsDataURL(event.target.files[0]);
}

function myFunction() { 
  document.getElementById('myFile".$row['id']."').required = false; 
}

</script>";
    

     include('edit_delete_modal.php');

     }
  ?>



    </div>

</section>


     <!--End Categories-->



     



     <?php include('add_modal.php') ?>

<script src="assets/js/jquery/jquery.min.js"></script>
<script src="assets/js/bootstrap.min.js"></script>
<script src="assets/js/datatable/jquery.dataTables.min.js"></script>
<script src="assets/js/datatable/dataTable.bootstrap.min.js"></script>

<script src="../js/upload_img_script.js"></script>

<script src="counter/chat.js"></script>

<script>
$(document).ready(function(){
  //inialize datatable
    $('#myTable').DataTable();

    //hide alert
    $(document).on('click', '.close', function(){
      $('.alert').hide();
    })
});


</script>


</body>
</html>