<?php
    session_start();
   
    include_once('../db/saucerer.php');

// Check if the user is already logged in, if yes then redirect him to welcome page
if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true){
  header("location: ../");
  exit;
}

if (empty($_GET['page'])) {
    $page = '';
} else {
    $page = $_GET['page'];
}


// Generating a random number
date_default_timezone_set('Africa/Kampala');
$today = date("His-dmY",time());

$code1 = rand(1,9); 
$code2 = rand(1,9);
$code3 = $code1 * $code2; 
$tokens = "$code3-$today";


 
//IP Address Protocol
$ip_address = $_SERVER["REMOTE_ADDR"];

// Check if the "mobile" word exists in User-Agent 
$isMob = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "mobile")); 
  
// Check if the "tablet" word exists in User-Agent 
$isTab = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "tablet")); 
 

// Platform check  
$isWin = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "windows")); 
$isAndroid = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "android")); 
$isIPhone = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "iphone")); 
$isIPad = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "ipad")); 
$isIOS = $isIPhone || $isIPad; 
  
    if($isTab){ 
        if ($isIPad) {
        $device = 'iPad';
    } else {
        $device = 'Tablet'; 
    }
  } elseif($isMob){ 
    if ($isIPhone) {
        $device = 'iPhone';
    } else {
        $device = 'Phone'; 
    }

  } else{ 
        $device = 'Desktop'; 
} 
 
if($isIOS){ 
    $system = 'iOS'; 
}elseif($isAndroid){ 
    $system = 'ANDROID'; 
}elseif($isWin){ 
    $system = 'WINDOWS'; 
}

if ($system == 'WINDOWS') {
    $system_one = ' on &nbsp;<i class="fa fa-windows"></i> '.$system.'';
} elseif ($system == 'ANDROID') {
    $system_one = ' on this &nbsp;<i class="fa fa-android"></i> '.$system.'';
} elseif ($system == 'iOS') {
    $system_one = ' on this &nbsp;<i class="fa fa-apple"></i> '.$device.'';
}



    if(isset($_POST['submit'])){

        $name = $_POST['name'];
        $token = $_POST['token'];
        $access = $_POST['access'];
        $user = $_POST['name'];
        $handler = 'Admin';

    $sql = "SELECT * FROM access";

              //use for MySQLi-OOP
              $query = $conn->query($sql);
              while($row = $query->fetch_assoc()){
                $access_code = $row['code'];

        if($_POST['access'] == $row['code']){

            $_SESSION['token'] = $token;
            $_SESSION['access'] = $access;

            $action = "Access";
            $attempt = "Succesful";

            $result = "Success";
            $summary = "".$name." access succesful";
            $channel = "System";
            
            header('location: ../login/?page='.$page.'');

        } else {

            $_SESSION['error'] = 'Invalid access code!';

            $action = "Access";
            $attempt = "Failed";

            $result = "Fail";
            $summary = "".$name." failed access due to incorrect access code";
            $channel = "System";

        }

        $filter = "Admin";
        $category = "Validator";
        $link = "#!";

            $sql = "INSERT INTO secure (name, token, access, attempt, action, user, handler, result, filter, category, channel, summary, link, ip_address, device_name, system_name) VALUES ('$name', '$token', '$access', '$attempt', '$action', '$user', 'Admin', '$result', '$filter', '$category', '$channel', '$summary', '$link', '$ip_address', '$device', '$system')";
        
            $conn->query($sql);

    }
              

}

?>

<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Validator | Irungi Kitchen</title>
    <!-- Favicon icon -->
        <link rel="shortcut icon" href="../../img/fav-icon.png">
        <link rel="apple-touch-icon" href="../../img/apple-touch-icon.png">
    <link href="../css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
</head>

<body class="h-100">
    <div class="authincation h-100">
        <div class="container h-100">


                <?php
                if(isset($_SESSION['error'])){
                    echo "<div class='alert alert-danger solid alert-right-icon alert-dismissible fade show alert pop'>
                                    <span><i class='fa fa-exclamation-mark'></i></span>
                                    <button type='button' class='close h-100' data-dismiss='alert' aria-label='Close'><span>&times;</span>
                                    </button>
                                    <strong>Warning!</strong> ".$_SESSION['error']."
                    </div>";
                    unset($_SESSION['error']);
                }
                if(isset($_SESSION['success'])){
                    echo "<div class='alert alert-success solid alert-right-icon alert-dismissible fade show alert pop'>
                                    <span><i class='fa fa-check'></i></span>
                                    <button type='button' class='close h-100' data-dismiss='alert' aria-label='Close'><span>&times;</span>
                                    </button> ".$_SESSION['success']."
                    </div>";
                    unset($_SESSION['success']);
                }
            ?>


            <div class="row justify-content-center h-100 align-items-center">
                <div class="col-md-6">
                    <div class="authincation-content">
                        <div class="row no-gutters">
                            <div class="col-xl-12">
                                <div class="auth-form">
                                    <div class="text-center mb-3">
                                        <a href="#!"><img src="../../img/irungi-logo.png" alt="Irungi Kitchen"></a>
                                    </div>
                                    <h2 class="text-center text-pink">Secure Validator</h2>
                                    <h4 class="text-center mb-4 text-white fs-12">Authorized personels only, enter code to access</h4>
                
                <form action="./?page=<?php echo ($page);?>" enctype="multipart/form-data" method="POST">
                                        
                               <input type="hidden" name="name" value="<?php echo "".$device." (".$system.")"; ?>" required>

                            <div class="form-group">
                                <input type="text" class="form-control" name="access" placeholder="Access Code" required>
                            </div>

                  <input class="form-control" type="hidden" name="token" value="<?php echo $tokens; ?>">

                                        <div class="text-center">
                                            <button type="submit" name="submit" class="btn bg-white text-primary btn-block">Gain Access &nbsp;<i class="fa fa-arrow-right"></i></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--**********************************
        Scripts
    ***********************************-->
    <!-- Required vendors -->
    <script src="../vendor/global/global.min.js"></script>
    <script src="../js/custom.min.js"></script>
    <script src="../js/deznav-init.js"></script>

</body>

</html>