<?php
 /**
 * Jamroom Timeline module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: mention_profiles
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAction_mention_profiles($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    if (isset($_post['q']) && strlen($_post['q']) > 1) {
        $_post['q'] = substr($_post['q'], 1);
        $_rt = array(
            'search'        => array(
                "profile_name like {$_post['q']}%"
            ),
            'skip_triggers' => true,
            'return_keys'   => array('_profile_id', 'profile_url', 'profile_name', 'profile_image_extension', 'profile_image_time')
        );
        $lim = 25;
        if (isset($_post['limit']) && jrCore_checktype($_post['limit'], 'number_nz')) {
            if ($_post['limit'] <= 500) {
                $lim = (int) $_post['limit'];
            }
        }
        $_rt['limit'] = $lim;
        $_rt          = jrCore_db_search_items('jrProfile', $_rt);
        if ($_rt && isset($_rt['_items']) && is_array($_rt['_items'])) {

            // If any of these are profiles we follow, make them first
            if (count($_rt['_items']) > 10) {
                if (jrCore_module_is_active('jrFollower')) {
                    if ($_ui = jrFollower_get_profiles_followed($_user['_user_id'])) {
                        uasort($_rt['_items'], function ($a, $b) use ($_ui) {
                            return (isset($_ui["{$a['_profile_id']}"])) ? 1 : -1;
                        });
                    }
                }
            }

            $_rs = array();
            $nam = jrUser_get_profile_home_key('profile_name');
            foreach ($_rt['_items'] as $_v) {
                if ($_v['profile_name'] != $nam) {
                    $_im       = array(
                        'crop'     => 'square',
                        'width'    => 32,
                        'height'   => 32,
                        'ext'      => (!empty($_prf['profile_image_extension'])) ? $_prf['profile_image_extension'] : '',
                        '_v'       => (!empty($_prf['profile_image_time'])) ? $_prf['profile_image_time'] : false,
                        'src_only' => true
                    );
                    $_rs[] = array(
                        'id'     => $_v['_profile_id'],
                        'name'   => "@{$_v['profile_url']}",
                        'avatar' => jrImage_get_image_src('jrProfile', 'profile_image', $_v['_profile_id'], 'small', $_im),
                        'type'   => 'contact'
                    );
                }
            }
            jrCore_json_response($_rs);
        }
    }
    jrCore_exit();
}
