<?php
 /**
 * Jamroom Blog module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrBlog_update_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();

    // Validate all incoming posted data
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrBlog');

    // Make sure we get a good _item_id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 14);
        jrCore_form_result();
    }

    // Get data
    $_rt = jrCore_db_get_item('jrBlog', $_post['id']);
    if (!isset($_rt) || !is_array($_rt)) {
        // Item does not exist....
        jrCore_set_form_notice('error', 15);
        jrCore_form_result();
    }

    // Make sure the calling user has permission to edit this item
    if (!jrUser_can_edit_item($_rt)) {
        jrUser_not_authorized();
    }

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_sv = jrCore_form_get_save_data('jrBlog', 'update', $_post);

    // Add in our SEO URL names
    $_sv['blog_title_url']    = jrCore_url_string($_sv['blog_title']);
    $_sv['blog_category_url'] = jrCore_url_string($_sv['blog_category']);
    //check for a 'read more'
    $_sv['blog_readmore'] = (strpos($_sv['blog_text'], '<!-- pagebreak -->')) ? 1 : 0;

    // Save all updated fields to the Data Store
    jrCore_db_update_item('jrBlog', $_post['id'], $_sv);

    // Save any uploaded media file
    jrCore_save_all_media_files('jrBlog', 'update', $_user['user_active_profile_id'], $_post['id']);
    // Add to Actions if publish date not in the future
    if (!isset($_sv['blog_publish_date']) || $_sv['blog_publish_date'] < time() + 3600) {
        jrCore_run_module_function('jrAction_save', 'update', 'jrBlog', $_post['id']);
    }

    jrCore_form_delete_session();
    jrProfile_reset_cache();
    jrUser_reset_cache($_user['_user_id'], 'jrBlog');
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}/{$_post['id']}/{$_sv['blog_title_url']}");
}
