// Jamroom Core Javascript
// @copyright 2003-2013 by Talldude Networks LLC

var __frs = 0;

/**
 * Set number of rows for pagination
 * @param n Number
 * @param cb {function}
 */
function jrCore_set_pager_rows(n, cb)
{
    jrSetCookie('rows', n, 30);
    return cb();
}

/**
 * Set CSRF location cookie
 * Validated on the server site with jrCore_validate_location_url()
 * @param {string} u URL
 */
function jrCore_set_csrf_cookie(u)
{
    return jrSetCookie('loc', u, 1);
}

/**
 * Set location CSRF cookie and redirect
 * @param {string} u URL
 */
function jrCore_window_location(u)
{
    jrCore_set_csrf_cookie(u);
    if (typeof u !== 'undefined' && u.indexOf('#') > -1) {
        // This URL has a fragment - reload if already on page
        if (window.location.href.indexOf(u) > -1) {
            window.location.reload();
        }
        else {
            window.location = u;
        }
    }
    else {
        window.location = u;
    }
}

/**
 * Creates a checkbox in form to prevent spam bots from submitting forms
 * @param {string} n Name of checkbox element to add
 * @param {number} i Tab Index value for form
 * @return {boolean}
 */
function jrFormSpamBotCheckbox(n, i)
{
    setTimeout(function() {
        if (!$('#' + n).length) {
            $('#sb_' + n).prepend('<input type="checkbox" id="' + n + '" name="' + n + '" tabindex="' + i + '">');
        }
    }, 1000);
    return true;
}

/**
 * Handle Stream URL Errors from the Media Player
 * @param {object} e jPlayer error response object
 * @return {boolean}
 */
function jrCore_stream_url_error(e)
{
    if (e.jPlayer.error.type === 'e_url') {
        // Get module_url from media URL
        var _tm = e.jPlayer.error.context.replace(core_system_url + '/', '').split('/');
        var url = _tm[0];
        $.get(core_system_url + '/' + jrCore_url + '/stream_url_error/' + url, function(r) {
            if (typeof r.login != "undefined") {
                jrCore_confirm('', r.login, function() {
                    jrCore_window_location(core_system_url + '/' + jrUser_url + '/login/r=1')
                }, r.button);
            }
            else if (typeof r.error != "undefined") {
                jrCore_alert(r.error);
            }
            else if (typeof e.jPlayer.error.message != "undefined") {
                jrCore_alert(e.jPlayer.error.message);
            }
            else {
                jrCore_alert('an unknown error has occured - please try again');
            }
        });
    }
    return true;
}

/**
 * Submits a form handling validation
 * @param {string} fi Form ID to submit
 * @param {string} ck MD5 checksum for validation key
 * @param {string} mt ajax/modal/post - post form as an AJAX form or normal (post) form
 */
function jrFormSubmit(fi, ck, mt)
{
    __frs = 0;
    var rv = false;
    var si = $(fi).find('#form_submit_indicator');
    var ms = 300;
    if (si.length === 0) {
        si = $('body');
        ms = 0;
    }
    var sb = $('.form_submit_section input');
    $('.field-hilight').removeClass('field-hilight');
    sb.jrCore_disable_button();
    si.show(ms, function() {
        var to = setTimeout(function() {
            // get all the inputs into an array.
            $('.form_editor').each(function() {
                $('#' + this.name + '_editor_contents').val(tinyMCE.get('e' + this.name).getContent());
            });
            var values = $(fi).serializeArray();
            // See if we have saved off entries on load
            if (typeof values !== "object" || values.length === 0) {
                si.hide(ms, function() {
                    sb.jrCore_enable_button();
                    jrFormSystemError(fi, "Unable to serialize form elements for submitting!");
                });
                clearTimeout(to);
                return false;
            }
            var action = $(fi).attr("action");
            if (typeof action === "undefined") {
                si.hide(ms, function() {
                    sb.jrCore_enable_button();
                    jrFormSystemError(fi, "Unable to retrieve form action value for submitting");
                });
                clearTimeout(to);
                return false;
            }

            // Handle form validation
            if (typeof ck !== "undefined" && ck !== false) {

                // Submit URL for validation
                $.ajax({
                    type: 'POST',
                    data: values,
                    cache: false,
                    dataType: 'json',
                    url: core_system_url + '/' + jrCore_url + '/form_validate/__ajax=1',
                    success: function(r) {
                        // Handle any messages
                        if (typeof r === "undefined" || r === null) {
                            si.hide(ms, function() {
                                sb.jrCore_enable_button();
                                jrFormSystemError(fi, 'Empty response received from server - please try again');
                            });
                        }
                        else if (typeof r.OK === "undefined" || Number(r.OK) !== 1) {
                            if (typeof r.redirect != "undefined") {
                                clearTimeout(to);
                                window.location = r.redirect;
                                return true;
                            }
                            else if (typeof r.on_close != "undefined") {
                                clearTimeout(to);
                                return window[r.on_close](r);
                            }
                            jrFormMessages(fi, r);
                        }
                        else {
                            // r is "OK" - looks OK to submit now
                            if (typeof mt == "undefined" || mt === "ajax") {
                                $.ajax({
                                    type: 'POST',
                                    url: action,
                                    data: values,
                                    cache: false,
                                    dataType: 'json',
                                    success: function(_pmsg) {
                                        // Check for URL redirection
                                        if (typeof _pmsg.redirect != "undefined") {
                                            clearTimeout(to);
                                            window.location = _pmsg.redirect;
                                        }
                                        else if (typeof _pmsg.on_close != "undefined") {
                                            clearTimeout(to);
                                            return window[_pmsg.on_close](_pmsg);
                                        }
                                        else {
                                            jrFormMessages(fi, _pmsg);
                                        }
                                        rv = true;
                                    },
                                    error: function(x, t, e) {
                                        si.hide(ms, function() {
                                            sb.jrCore_enable_button();
                                            // See if we got a message back from the core
                                            var msg = 'a system level error was encountered trying to validate the form values: ' + t + ': ' + e;
                                            if (typeof x.responseText !== "undefined" && x.responseText.length > 1) {
                                                msg = 'JSON response error: ' + x.responseText;
                                            }
                                            jrFormSystemError(fi, msg);
                                        });
                                    }
                                });
                            }

                            // Modal window
                            else if (mt === "modal") {

                                si.hide((ms * 2), function() {
                                    var k = $('#jr_html_modal_token').val();
                                    var n = 0;
                                    $('#modal_window').modal();
                                    $('#modal_indicator').show();

                                    // Setup our "listener" which will update our work progress
                                    var sid = setInterval(function() {
                                        sb.jrCore_enable_button();
                                        $.ajax({
                                            cache: false,
                                            dataType: 'json',
                                            url: core_system_url + '/' + jrCore_url + '/form_modal_status/k=' + k + '/__ajax=1',
                                            success: function(t) {
                                                n = 0;
                                                jrFormModalSubmit_update_process(t, sid);
                                            },
                                            error: function(r, t, e) {
                                                // Track errors - if we get to 10 we error out
                                                n++;
                                                if (n > 10) {
                                                    clearInterval(sid);
                                                    jrCore_alert('An error was encountered communicating with the server: ' + t + ': ' + e);
                                                }
                                            }
                                        })
                                    }, 1000);

                                    // Submit form
                                    $.ajax({
                                        type: 'POST',
                                        url: action,
                                        data: values,
                                        cache: false,
                                        dataType: 'json',
                                        success: function() {
                                            clearTimeout(to);
                                            return true;
                                        }
                                    });
                                });
                            }

                            // normal POST submit
                            else {
                                $(fi).submit();
                                rv = true;
                            }
                        }
                    },
                    error: function(x, t, e) {
                        si.hide(ms, function() {
                            sb.jrCore_enable_button();
                            // See if we got a message back from the core
                            var msg = 'a system level error was encountered trying to validate the form values: ' + t + ': ' + e;
                            if (typeof x.responseText !== "undefined" && x.responseText.length > 1) {
                                msg = 'JSON response error: ' + x.responseText;
                            }
                            jrFormSystemError(fi, msg);
                        });
                    }
                });
            }
            // No validation
            else {

                // AJAX or normal submit?
                if (typeof mt == "undefined" || mt === "ajax") {
                    $.ajax({
                        type: 'POST',
                        url: action,
                        data: values,
                        cache: false,
                        dataType: 'json',
                        success: function(r) {
                            // Check for URL redirection
                            if (typeof r.redirect != "undefined") {
                                window.location = r.redirect;
                            }
                            else if (typeof r.on_close != "undefined") {
                                return window[r.on_close](r);
                            }
                            else {
                                jrFormMessages(fi, r);
                            }
                            rv = true;
                        },
                        error: function(x, t, e) {
                            si.hide(ms, function() {
                                sb.jrCore_enable_button();
                                // See if we got a message back from the core
                                var msg = 'a system level error was encountered trying to validate the form values: ' + t + ': ' + e;
                                if (typeof x.responseText !== "undefined" && x.responseText.length > 1) {
                                    msg = 'JSON response error: ' + x.responseText;
                                }
                                jrFormSystemError(fi, msg);
                            });
                        }
                    });
                }

                // Modal window
                else if (mt === "modal") {

                    si.hide((ms * 2), function() {
                        var k = $('#jr_html_modal_token').val();
                        var n = 0;
                        $('#modal_window').modal();
                        $('#modal_indicator').show();
                        // Setup our "listener" which will update our work progress
                        var sid = setInterval(function() {
                            sb.jrCore_enable_button();
                            $.ajax({
                                cache: false,
                                dataType: 'json',
                                url: core_system_url + '/' + jrCore_url + '/form_modal_status/k=' + k + '/__ajax=1',
                                success: function(t) {
                                    n = 0;
                                    jrFormModalSubmit_update_process(t, sid);
                                },
                                error: function(r, t, e) {
                                    // Track errors - if we get to 10 we error out
                                    n++;
                                    if (n > 10) {
                                        clearInterval(sid);
                                        jrCore_alert('An error was encountered communicating with the server: ' + t + ': ' + e);
                                    }
                                }
                            })
                        }, 1000);

                        // Submit form
                        $.post(action, values, function() {
                            clearTimeout(to);
                        });
                    });
                }

                else {
                    $(fi).submit();
                    rv = true;
                }
            }
            clearTimeout(to);
            return rv;
        }, (ms + 200));
    });
}

/**
 * Reset a form
 * @param {string} Form Name
 * @param {number} r 0|1
 * @param {function} cb Callback function
 * @returns {boolean}
 */
function jrCore_reset_form(n, r, cb)
{
    // If r is equal to 0 it means we don't need a reset
    if (r === 0) {
        return cb();
    }
    var f = $("form[id='" + n + "']");
    if (f.length === 0) {
        return false;
    }
    var s = f.find('#jr_html_form_token').val();
    if (s.length === 0) {
        s = 0;
    }
    var u = core_system_url + '/' + jrCore_url + '/form_reset_save/__ajax=1';
    jrCore_set_csrf_cookie(u);
    $.post(u, {id: s}, function(r) {
        return cb();
    });
}

/**
 * Show a system notice
 */
function jrFormSystemError(fi, t)
{
    jrFormMessages(fi + '_msg', {"notices": [{'type': 'error', 'text': t}]});
}

/**
 * jrFormMessages
 */
function jrFormMessages(fi, r)
{
    var m = $(fi + '_msg');
    var rv = true;
    var nr = '';
    $('.page-notice-shown').hide(10);
    // Handle any messages
    if (typeof r.notices !== "undefined") {
        m.html('');
        for (var n in r.notices) {
            if (r.notices.hasOwnProperty(n)) {
                nr += '<div class="page_notice ' + r.notices[n].type + '">' + r.notices[n].text + '</div>';
                if (r.notices[n].type === 'error') {
                    __frs = 1;
                    rv = false;
                }
            }
        }
        m.html(nr);
    }
    // Handle any error fields
    if (typeof r.error_fields !== "undefined") {
        for (var e in r.error_fields) {
            if (r.error_fields.hasOwnProperty(e)) {
                $(r.error_fields[e]).addClass('field-hilight');
            }
        }
    }
    else {
        // Remove any previous errors
        $('.field-hilight').removeClass('field-hilight');
    }
    var si = $(fi).find('#form_submit_indicator');
    var ss = $('.form_submit_section input');
    var sc = $('.simplemodal-container');
    if (si.length > 0) {
        si.hide(300, function() {
            m.slideDown(150, function() {
                ss.jrCore_enable_button();
                if (sc.length === 0) {
                    if (m.offset() && m.offset().top < $(window).scrollTop()) {
                        $('html').animate({scrollTop: (m.offset().top - 100)}, 300);
                    }
                }
                else {
                    sc.find('.simplemodal-data').scrollTop(0);
                }
            });
        });
    }
    else {
        m.slideDown(150, function() {
            ss.jrCore_enable_button();
            if (sc.length === 0 && m.offset() && m.offset().top > 0 && m.offset().top < $(window).scrollTop()) {
                $('html,body').animate({scrollTop: (m.offset().top - 100)}, 300);
            }
        });
    }
    return rv;
}

/**
 * Create a popup window
 * @param {string} u URL to open
 * @param {string} t Page title
 * @param {int} w window width
 * @param {int} h window height
 * @param {string} scr Show scrollbars yes|no
 */
function popwin(u, t, w, h, scr)
{
    var b = $('body');
    var l = (b.width() / 2) - (w / 2);
    var t = (screen.height - h) / 2;
    var s = 'height=' + h + ',width=' + w + ',top=' + t + ',left=' + l + ',scrollbars=' + scr + ',resizable';
    var o = window.open(u, t, s);
    if (o === null) {
        return o;
    }
    if (o.opener === null) {
        o.opener = self;
    }
}

/**
 * Get the unique cookie ID
 * @returns {*}
 */
function jrCore_get_cookie_id()
{
    return (typeof core_cookie_id !== "undefined") ? core_cookie_id : '';
}

/**
 * Set a cookie
 * @param {string} n Cookie Name
 * @param {string} v Cookie Value
 * @param {int} d Expiration Days
 */
function jrSetCookie(n, v, d)
{
    if (typeof d !== "number") {
        d = 30;
    }
    var s = (location.protocol === 'https:') ? ';secure' : '';
    var e = new Date();
    e.setTime(e.getTime() + (d * 86400000));
    e = s + "; expires=" + e.toGMTString();
    document.cookie = n + jrCore_get_cookie_id() + "=" + jrCore_urlencode(JSON.stringify(v)) + e + "; path=/;SameSite=Lax";
}

/**
 * Get value of cookie
 * @param {string} n Cookie Name
 * @returns {string|null}
 */
function jrReadCookie(n)
{
    var ne = n + jrCore_get_cookie_id() + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) === ' ') c = c.substring(1, c.length);
        {
            if (c.indexOf(ne) === 0) return jrCore_parse_cookie_value(jrCore_urldecode(c.substring(ne.length, c.length)));
        }
    }
    return null;
}

/**
 * Erase a cookie
 * @param {string} n Cookie name
 */
function jrEraseCookie(n)
{
    jrSetCookie(n, '', -1);
}

/**
 * Parse a Cookie Value
 * @param {mixed} v
 * @returns {any}
 */
function jrCore_parse_cookie_value(v)
{
    if (typeof v === "object" || v.indexOf('"') === 0) {
        v = JSON.parse(v);
    }
    return v;
}

/**
 * JS equivalent of PHP urlencode()
 * @link https://locutus.io/php/url/urlencode/
 * @param {mixed} v
 * @returns {string}
 */
function jrCore_urlencode(v)
{
    v = (v + '')
    return encodeURIComponent(v)
        .replace(/!/g, '%21')
        .replace(/'/g, '%27')
        .replace(/\(/g, '%28')
        .replace(/\)/g, '%29')
        .replace(/\*/g, '%2A')
        .replace(/~/g, '%7E')
        .replace(/%20/g, '+');
}

/**
 * JS equivalent of PHP urldecode()
 * @param {string} v
 * @returns {string}
 */
function jrCore_urldecode(v)
{
    return decodeURIComponent((v + '')
        .replace(/%(?![\da-f]{2})/gi, function() {
            // PHP tolerates poorly formed escape sequences
            return '%25'
        }).replace(/\+/g, '%20'));
}

/**
 * Check for module updates
 * @param {object} data Message Object
 * @param {number} sid Update Interval Timer name
 * @return {boolean}
 */
function jrFormModalSubmit_update_process(data, sid)
{
    // Check for any error/complete messages
    for (var u in data) {
        if (data.hasOwnProperty(u)) {
            // When our work is complete on the server we will get a "type"
            // message back (complete,update,error)
            var k = $('#jr_html_modal_token');
            if (typeof data[u].t !== "undefined") {
                var e = $('#modal_error');
                var t = $('#modal_updates');
                var s = $('#modal_success');
                switch (data[u].t) {
                    case 'complete':
                        clearInterval(sid);
                        e.hide();
                        s.prepend(data[u].m + '<br><br>').show();
                        jrFormModalCleanup(k.val());
                        break;
                    case 'update':
                        t.prepend(data[u].m + '<br>');
                        break;
                    case 'empty':
                        return true;
                    case 'error':
                        t.prepend(data[u].m + '<br>');
                        s.hide();
                        e.prepend(data[u].m + '<br><br>').show();
                        break;
                    default:
                        clearInterval(sid);
                        jrFormModalCleanup(k.val());
                        break;
                }
            }
            else {
                clearInterval(sid);
                jrFormModalCleanup(k.val());
            }
        }
    }
    return true;
}

/**
 * jrFormModalCleanup
 * @param {string} k Form ID
 * @return {boolean}
 */
function jrFormModalCleanup(k)
{
    $('#modal_indicator').hide();
    $.post(core_system_url + '/' + jrCore_url + '/form_modal_cleanup/k=' + k + '/__ajax=1');
}

/**
 * jrE - encodeURIComponent
 * @param {string} t String to encode
 * @return {string}
 */
function jrE(t)
{
    return encodeURIComponent(t.replace('/', '%2F'));
}

/**
 * Load a URL into a DOM element with spinner and fade in/out
 * @param {string} id DOM element
 * @param {string} url URL to load
 * @returns {boolean}
 */
function jrCore_load_into(id, url)
{
    if (typeof url === "undefined") {
        return false;
    }
    var i = $(id);
    i.fadeOut(100, function() {
        i.html('<div style="text-align:center;padding:20px;margin:0 auto;"><img src="' + core_system_url + '/' + jrImage_url + '/img/module/jrCore/loading.gif" style="margin:15px" alt="loading"></div>').fadeIn(100, function() {
            i.load(url, function(r) {
                i.html(r);
            });
        })
    });
    return false;
}

/**
 * Delete an Attachment
 * @param {number} id Item ID
 * @param {string} f upload field
 * @param {string} m upload module
 * @param {number} i index
 */
function jrCore_delete_attachment(id, f, m, i)
{
    var u = core_system_url + '/' + jrCore_url + '/attachment_delete';
    jrCore_set_csrf_cookie(u);
    $.post(u, {id: id, upload_field: f, upload_module: m}, function(r) {
        if (typeof r.success !== "undefined") {
            $('#' + m + '_' + id + '_' + i).fadeOut(300, function() {
                $(this).remove();
                var ab = $('#ab' + id + ' .image_delete');
                if (ab.length === 0) {
                    $('#ab' + id).remove();
                }
            });
        }
    });
}

/**
 * Show an alert
 * @param {string} text
 */
function jrCore_alert(text, confirm, type)
{
    if (typeof confirm == "undefined") {
        confirm = 'OK';
    }
    if (typeof type == "undefined") {
        type = 'warning';
    }
    swal({
        type: type,
        title: '',
        text: text,
        html: true,
        animation: false,
        confirmButtonText: confirm,
        closeOnConfirm: true
    });
}

/**
 * Show a confirmation prompt
 * @param {string} title
 * @param {string} text
 * @param {function} conf
 * @param {string=optional} confirm OK text
 * @param {string=optional} cancel Cancel text
 * @param {string=optional} cls custom data class
 * @param {string=optional} type Type success|warning|error - default is "warning"
 * @param {function=optional} func Function to run if CANCEL is pressed
 * @return {boolean}
 */
function jrCore_confirm(title, text, conf, confirm, cancel, cls, type, func)
{
    if (typeof confirm == "undefined") {
        confirm = 'OK';
    }
    if (typeof cancel == "undefined") {
        cancel = 'Cancel';
    }
    if (typeof type == "undefined") {
        type = 'warning';
    }
    var o = {
        type: type,
        title: title,
        animation: false,
        customClass: cls,
        confirmButtonText: confirm,
        showCancelButton: true,
        cancelButtonText: cancel,
        closeOnConfirm: false
    };
    if (typeof text !== "undefined") {
        o.text = text;
        o.html = true;
    }
    swal(o, function(c) {
        if (c) {
            swal.close();
            return conf();
        }
        else {
            if (typeof func !== 'undefined' && typeof func === "function") {
                swal.close();
                return func();
            }
            else {
                return false;
            }
        }
    });
}

/**
 * toggle the jrCore_page_button_menu open/close
 * @param {string} n
 */
function jrCore_toggle_button_menu(n)
{
    var t = $('#' + n + ' .form_button_menu_ul');
    $('.form_button_menu_ul').not(t).hide();
    t.toggle();
}

/**
 * Strip HTML from a string
 * @param {string} t
 * @returns {string}
 */
function jrCore_strip_html(t)
{
    return $("<div/>").html(t).text();
}

/**
 * Empty a daterange field
 * @param id
 */
function jrCore_clear_daterange(id)
{
    $('#' + id).val('');
}

/**
 * Custom Jamroom jQuery functions
 */
(function($) {
    $.fn.jrCore_enable_button = function() {
        this.removeClass('form_button_disabled').removeAttr('disabled');
        return this;
    };
    $.fn.jrCore_disable_button = function() {
        this.addClass('form_button_disabled').attr('disabled', 'disabled');
        return this;
    };
}(jQuery));
