<?php
/**
 * Country specific Phone Number formatter
 * @copyright 2003-2022 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Return the COUNTRY CODE for this country plugin
 * @return string
 */
function jrCore_plugin_format_phone_number_NZ_country_code()
{
    return '(64) ';
}

/**
 * Format a phone number specific for a country
 * @see https://en.wikipedia.org/wiki/National_conventions_for_writing_telephone_numbers#New_Zealand
 * @param string $string Phone Number to format
 * @return string
 */
function jrCore_plugin_format_phone_number_NZ($string)
{
    // Format as: 0XX 1234 5678
    if (strpos("{$string}", "64") === 0) {
        $string = substr($string, 2);
    }
    $_parts = array();
    $length = strlen($string);
    if ($length === 7) {
        // 000 0000
        $_parts[] = substr($string, 0, 3);
        $_parts[] = '-' . substr($string, 3);
    }
    else {
        // 0000 0000
        $_parts[] = substr($string, 0, 4);
        $_parts[] = '-' . substr($string, 4);
    }
    return implode('', $_parts);
}