<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: cache_reset_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_cache_reset_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Javascript
    if (!$skin = jrCore_get_config_value('jrCore', 'active_skin', false)) {
        jrCore_set_form_notice('error', 'Unable to determine active skin - check skin settings');
        jrCore_form_result();
    }
    if (isset($_post['reset_javascript_cache']) && $_post['reset_javascript_cache'] == 'on') {
        jrCore_create_master_javascript($skin);
    }

    // CSS
    if (isset($_post['reset_css_cache']) && $_post['reset_css_cache'] == 'on') {
        jrCore_create_master_css($skin);
    }

    // Database Items
    if (isset($_post['reset_database_cache']) && $_post['reset_database_cache'] == 'on') {
        jrCore_delete_all_cache_entries();
        // Our DS row counts key will be removed - update
        jrCore_queue_create('jrCore', 'update_ds_counts', array('update' => 1), 3, null, 1);
    }

    // Language Strings
    // @note jrCore_delete_all_cache_entries covers language strings - thus the elseif
    elseif (isset($_post['reset_language_cache']) && $_post['reset_language_cache'] == 'on') {
        $_dl = array();
        if ($_ln = jrUser_get_languages()) {
            foreach ($_ln as $code => $name) {
                $_dl[] = array('jrUser', "load_lang_string_{$code}_0");
                $_dl[] = array('jrUser', "load_lang_string_{$code}_1");
            }
        }
        if (count($_dl) > 0) {
            jrCore_delete_multiple_cache_entries($_dl);
        }
    }

    // APCu
    if (isset($_post['reset_local_cache']) && $_post['reset_local_cache'] == 'on') {
        jrCore_reset_local_cache();
    }

    // Sprite icons
    if (isset($_post['reset_sprite_cache']) && $_post['reset_sprite_cache'] == 'on') {
        jrCore_reset_sprite_cache();
    }

    // Form sessions
    if (isset($_post['reset_form_cache']) && $_post['reset_form_cache'] == 'on') {
        jrCore_form_delete_all_form_sessions();
    }

    // Templates
    if (isset($_post['reset_template_cache']) && $_post['reset_template_cache'] == 'on') {
        jrCore_reset_template_cache();
    }
    elseif (!empty($_post['reset_template_cache_file'])) {
        if ($_files = explode(',', $_post['reset_template_cache_file'])) {
            jrCore_reset_template_cache_files($_files);
        }
    }

    // Opcode Cache
    if (function_exists('opcache_reset') && isset($_post['reset_opcode_cache']) && $_post['reset_opcode_cache'] == 'on') {
        jrCore_reset_opcode_cache();
    }

    jrCore_delete_config_cache(true);
    jrCore_set_form_notice('success', 'The selected caches were successfully reset');
    jrCore_location('referrer');
}
