<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: css_reset_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_css_reset_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    // Reset CSS elements
    if (empty($_post['skin'])) {
        jrCore_set_form_notice('error', 'Invalid skin - please try again');
        jrCore_form_result();
    }
    if (empty($_post['tag'])) {
        jrCore_set_form_notice('error', 'Invalid element tag - please try again');
        jrCore_form_result();
    }
    $_post['tag'] = urldecode($_post['tag']);

    // Remove info about this element from the custom css
    $tbl = jrCore_db_table_name('jrCore', 'skin');
    $req = "SELECT skin_custom_css FROM {$tbl} WHERE skin_directory = '" . jrCore_db_escape($_post['skin']) . "'";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if ($_rt && is_array($_rt) && strlen($_rt['skin_custom_css']) > 3) {
        $_new = json_decode($_rt['skin_custom_css'], true);
        if ($_new && is_array($_new)) {
            if (isset($_new["{$_post['tag']}"])) {
                unset($_new["{$_post['tag']}"]);
                $_new = json_encode($_new);
                $req  = "UPDATE {$tbl} SET skin_updated = UNIX_TIMESTAMP(), skin_custom_css = '" . jrCore_db_escape($_new) . "' WHERE skin_directory = '" . jrCore_db_escape($_post['skin']) . "'";
                $cnt  = jrCore_db_query($req, 'COUNT');
                if ($cnt === 0) {
                    jrCore_set_form_notice('error', 'An error was enountered saving the custom style to the database - please try again');
                    jrCore_form_result();
                }
            }
        }
    }
    jrCore_form_delete_session();

    // Rebuild CSS
    if ($_post['skin'] == $_conf['jrCore_active_skin']) {
        jrCore_create_master_css($_post['skin']);
    }

    jrCore_form_result();
}
