<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: dashboard_panels
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_dashboard_panels($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();

    list(, $row, $col) = explode('-', $_post['_1']);
    $one = (int) $row + 1;
    $two = (int) $col + 1;

    // See if we have an existing function
    $_cfg = array();
    if (!empty($_conf['jrCore_dashboard_config'])) {
        $_cfg = json_decode($_conf['jrCore_dashboard_config'], true);
    }
    $func = false;
    if (isset($_cfg['_panels'][$row][$col]['f'])) {
        $func = "{$_cfg['_panels'][$row][$col]['f']}|{$_cfg['_panels'][$row][$col]['t']}";
    }

    jrCore_page_banner('Dashboard Panels', "row {$one}, column {$two}");
    $_fnc = array();
    if ($_tmp = jrCore_get_registered_module_features('jrCore', 'dashboard_panel')) {

        if ($_cnt = jrCore_get_dashboard_ds_count_options()) {
            $_tmp['jrCore'] = array_merge($_tmp['jrCore'], $_cnt['jrCore']);
        }

        foreach ($_tmp as $mod => $_opts) {
            $nam = $_mods[$mod]['module_name'];
            if (!isset($_fnc[$nam])) {
                $_fnc[$nam] = array();
            }
            foreach ($_opts as $title => $fnc) {
                $key              = "{$fnc}|{$title}";
                $_fnc[$nam][$key] = $title;
            }
        }
    }
    $_tmp = array(
        'name'     => 'panel',
        'label'    => 'available panels',
        'help'     => 'Select the panel you would like to appear in this dashboard location',
        'type'     => 'select',
        'options'  => $_fnc,
        'value'    => $func,
        'onchange' => "jrCore_set_dashboard_panel({$row}, {$col}, $(this).val());",
        'required' => true,
        'size'     => 8
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_close_button('$.modal.close();');
    jrCore_page_set_no_header_or_footer();
    jrCore_page_display();
}
