<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: export_datastore_csv
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_export_datastore_csv($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();
    @ini_set('max_execution_time', 3600);
    @ini_set('memory_limit', '512M');
    if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
        jrCore_json_response(array('error' => 'invalid module'));
    }
    $_tm = jrCore_db_get_unique_keys($_post['m']);
    if ($_tm && is_array($_tm)) {
        $_fl = array();
        foreach ($_tm as $k) {
            $_fl[$k] = $k;
        }
        ksort($_fl);
        switch ($_post['m']) {
            case 'jrUser':
                $key = '_user_id';
                unset($_fl['user_password'], $_fl['user_old_password']);
                break;
            case 'jrProfile':
                $key = '_profile_id';
                break;
            default:
                $key = '_item_id';
                break;
        }
        $out = array($key => $key);
        unset($_fl[$key]);
        $_fl = array_merge($out, $_fl);
        $cdr = jrCore_get_module_cache_dir('jrCore');

        // Delete old CSV files
        jrCore_delete_old_datastore_csv_files();

        $tag = '';
        $add = false;
        $url = jrCore_get_local_referrer();
        if (strpos($url, 'search_string')) {
            $_ur = jrCore_parse_url($url, false, false, true);
            if (!empty($_ur['search_string'])) {
                $add = jrCore_get_ds_search_condition($_ur['search_string']);
                $tag = 'matching_results_';
            }
        }

        $fil = "{$cdr}/{$_post['m']}_datastore_" . $tag . date('YmdHi') . ".csv";
        jrCore_write_to_file($fil, implode(',', $_fl) . "\n");

        $uid = 0;
        while (true) {
            $_it = array(
                'search'          => array(
                    "_item_id > {$uid}"
                ),
                'order_by'        => array('_item_id' => 'asc'),
                'skip_all_checks' => true,
                'limit'           => 500
            );
            if ($add) {
                $_it['search'][] = $add;
            }
            $_it = jrCore_db_search_items($_post['m'], $_it);
            if ($_it && is_array($_it) && isset($_it['_items'])) {
                $out = array();
                foreach ($_it['_items'] as $i) {
                    $_tm = array();
                    foreach ($_fl as $f) {
                        if (isset($i[$f]) && strlen($i[$f]) > 0) {
                            if (is_numeric($i[$f])) {
                                if (strlen($i[$f]) === 10) {
                                    $_tm[$f] = jrCore_format_time($i[$f]);
                                }
                                else {
                                    $_tm[$f] = $i[$f];
                                }
                            }
                            else {
                                $_tm[$f] = '"' . str_replace('"', '""', $i[$f]) . '"';
                            }
                        }
                        else {
                            $_tm[$f] = '';
                        }
                    }
                    $out[] = implode(',', $_tm);
                    $uid   = $i[$key];
                }
                jrCore_write_to_file($fil, jrCore_replace_emoji(implode("\n", $out)) . "\n", 'append');
                if (count($_it['_items']) < 500) {
                    // We are done
                    break;
                }
            }
            else {
                // We are done
                break;
            }
        }
        jrCore_json_response(array('url' => jrCore_get_base_url() . "/{$_post['module_url']}/download_datastore_csv/file=" . basename($fil)));
        jrCore_exit();
    }
    jrCore_json_response(array('error' => 'no datastore entries found for module'));
}
