<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: get_dashboard_panel_data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_get_dashboard_panel_data($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_validate_location_url();

    // Default layout
    $rows = 2;
    $cols = 4;
    // check for custom layout
    if ($_cfg = jrCore_get_config_value('jrCore', 'dashboard_config', false)) {
        $_cfg = json_decode($_cfg, true);
        if (isset($_cfg['rows']) && jrCore_checktype($_cfg['rows'], 'number_nz')) {
            $rows = (int) $_cfg['rows'];
        }
        if (isset($_cfg['cols']) && jrCore_checktype($_cfg['cols'], 'number_nz')) {
            $cols = (int) $_cfg['cols'];
        }
    }

    // Our default panel setup
    $_def = jrCore_get_default_dashboard_panels();
    foreach ($_def as $row => $_cols) {
        foreach ($_cols as $col => $_inf) {
            if (!isset($_cfg['_panels'][$row][$col])) {
                $_cfg['_panels'][$row][$col] = $_inf;
            }
        }
    }
    ksort($_cfg['_panels'], SORT_NUMERIC);

    $_rp = array();
    for ($r = 0; $r < $rows; $r++) {
        for ($c = 0; $c < $cols; $c++) {
            if (!empty($_cfg['_panels'][$r][$c]['f'])) {
                $func = $_cfg['_panels'][$r][$c]['f'];
                if (function_exists($func)) {
                    $_rp["#id-{$r}-{$c}"] = $func($_cfg['_panels'][$r][$c]['t']);
                }
            }
        }
    }
    jrCore_json_response(array('data' => $_rp), true, false);
}
