<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: item_display_order
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_item_display_order($_post, $_user, $_conf)
{
    jrUser_session_require_login();

    // Make sure this module has registered for item_order
    $_md = jrCore_get_registered_module_features('jrCore', 'item_order_support');
    if (!isset($_md["{$_post['module']}"])) {
        jrCore_notice_page('error', 'Invalid module - module is not registered for item_order support');
    }

    $pfx = jrCore_db_get_prefix($_post['module']);
    if ($pfx) {
        if (!$_rt = jrCore_db_get_display_order_for_profile_id($_post['module'], $_user['user_active_profile_id'], 'asc')) {
            jrCore_notice_page('notice', 'There are no items to set the order for!');
        }
        $_rt = array(
            'search'          => array(
                '_item_id in ' . implode(',', $_rt)
            ),
            'return_keys'     => array('_item_id', "{$pfx}_title"),
            'skip_all_checks' => true,
            'quota_check'     => false,
            'limit'           => count($_rt)
        );
        $_rt = jrCore_db_search_items($_post['module'], $_rt);
        if (!$_rt || !is_array($_rt) || !isset($_rt['_items']) || !is_array($_rt['_items'])) {
            jrCore_notice_page('notice', 'There are no items to set the order for!');
        }
    }
    else {
        // See if we have been given a custom function to get items
        if (isset($_md["{$_post['module']}"]['on']) && function_exists($_md["{$_post['module']}"]['on'])) {
            $fnc = $_md["{$_post['module']}"]['on'];
            $_rt = $fnc($_post);
            if (!isset($_rt['_items']) || !is_array($_rt['_items'])) {
                jrCore_notice_page('notice', 'There are no items to set the order for!');
                return false;
            }
        }
        else {
            jrCore_notice_page('error', 'Invalid module - module does not use a DataStore');
            return false;
        }
    }

    $_ln = jrUser_load_lang_strings();
    $btn = jrCore_page_button('c', $_ln['jrCore'][87], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}')");
    jrCore_page_banner($_ln['jrCore'][83], $btn);

    // Let modules inspect our display order items
    $_rt = jrCore_trigger_event('jrCore', 'display_order', $_rt);

    $tmp = '<ul class="item_sortable list">';
    foreach ($_rt['_items'] as $_item) {
        if (isset($_item['data-id'])) {
            // This module is handling it's own id's and titles
            $tmp .= "<li data-id=\"{$_item['data-id']}\">" . $_item['title'] . "</li>\n";
        }
        else {
            $tmp .= "<li data-id=\"{$_item['_item_id']}\">" . $_item["{$pfx}_title"] . "</li>\n";
        }
    }
    $tmp .= '</ul>';
    jrCore_page_custom($tmp, $_ln['jrCore'][83], $_ln['jrCore'][85]);

    if ($pfx) {
        $url = "{$_conf['jrCore_base_url']}/" . jrCore_get_module_url('jrCore') . "/item_display_order_update/m={$_post['module']}/__ajax=1";
    }
    else {
        $url = "{$_conf['jrCore_base_url']}/" . jrCore_get_module_url($_post['module']) . "/item_display_order_update/__ajax=1";
    }
    $tmp = array('$(function() {
           $(\'.item_sortable\').sortable().bind(\'sortupdate\', function(event,ui) {
               var o = $(\'ul.item_sortable li\').map(function(){ return $(this).data("id"); }).get();
               $.post(\'' . $url . '\', { iid: o });
           });
       });');
    jrCore_create_page_element('javascript_footer_function', $tmp);
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}", $_ln['jrCore'][87]);
    return jrCore_page_display(true);
}
