<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: pending_item_reject
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_pending_item_reject($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_admin_only();

    if (!isset($_post['_1']) || !isset($_mods["{$_post['_1']}"])) {
        jrCore_set_form_notice('error', 'Invalid module');
        jrCore_location('referrer');
    }
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'Invalid item id');
        jrCore_location('referrer');
    }
    $tbl = jrCore_db_table_name('jrCore', 'pending');
    $req = "SELECT * FROM {$tbl} WHERE pending_module = '" . jrCore_db_escape($_post['_1']) . "' AND pending_item_id = '" . intval($_post['id']) . "' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'Invalid pending id');
        jrCore_location('referrer');
    }
    // Get item
    $_it = jrCore_db_get_item($_rt['pending_module'], $_rt['pending_item_id']);
    if (!$_it || !is_array($_it)) {
        jrCore_set_form_notice('error', 'Invalid item - unable to retrieve data from DataStore');
        jrCore_form_result();
    }

    // Show our tabs if we are from the dashboard
    $url = jrCore_get_local_referrer();
    if (strpos($url, 'dashboard') || strpos($url, 'pending')) {
        jrCore_page_dashboard_tabs('pending');
    }

    // Show reject notice page
    jrCore_page_banner('reject item');
    $pfx = jrCore_db_get_prefix($_rt['pending_module']);
    $ttl = "{$url}/{$_it['_item_id']}";
    $seo = '';
    if (isset($_it["{$pfx}_title_url"]) && strpos($_it["{$pfx}_title_url"], 'http') !== 0) {
        $seo = '/' . $_it["{$pfx}_title_url"];
        $ttl = $_it["{$pfx}_title"];
    }
    $url = jrCore_get_module_url($_rt['pending_module']);

    // Form init
    $_tmp = array(
        'submit_value' => 'reject item and notify user',
        'cancel'       => 'referrer'
    );
    jrCore_form_create($_tmp);

    // Module
    $_tmp = array(
        'name'  => 'pending_id',
        'type'  => 'hidden',
        'value' => $_rt['pending_id']
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_custom("&nbsp;<a href=\"{$_conf['jrCore_base_url']}/{$_it['profile_url']}/{$url}/{$_it['_item_id']}{$seo}\"><u>{$ttl}</u></a>", 'item URL');

    // Create an item list of our custom "quick reject" options
    $lbl = 'reason';
    $tbl = jrCore_db_table_name('jrCore', 'pending_reason');
    $req = "SELECT * FROM {$tbl} ORDER BY reason_text ASC";
    $_pr = jrCore_db_query($req, 'reason_key', false, 'reason_text');
    if ($_pr && is_array($_pr)) {
        // Add in our delete button
        $_att = array('class' => 'rejected_reason_delete');
        foreach ($_pr as $k => $v) {
            $_pr[$k] = jrCore_page_button("d{$k}", 'X', "jrCore_confirm('delete this reason?', '', function(){ jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/pending_reason_delete/key={$k}')} )", $_att) . '&nbsp' . $v;
        }
        $_tmp = array(
            'name'     => 'reject_reason',
            'label'    => 'reason',
            'sublabel' => 'select all that apply',
            'help'     => 'Select predefined reasons for rejecting this item',
            'type'     => 'optionlist',
            'validate' => 'hex',
            'options'  => $_pr,
            'required' => false
        );
        jrCore_form_field_create($_tmp);
        $lbl = 'new reason';
    }

    $_tmp = array(
        'name'     => 'new_reject_reason',
        'label'    => $lbl,
        'help'     => 'Enter a NEW reject reason here and it will be saved for use on future rejection notices.',
        'type'     => 'text',
        'validate' => 'printable',
        'required' => false
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'reject_message',
        'label'    => 'message',
        'sublabel' => '(optional)',
        'help'     => 'Enter a custom message to send to the profile owner(s) that explains why this item has been rejected.',
        'type'     => 'textarea',
        'validate' => 'printable',
        'required' => false
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'reject_delete',
        'label'    => 'delete item',
        'help'     => 'Check this option to delete this item after sending the rejection email',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => false
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
