<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: performance_share_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_performance_share_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Make sure performance results exist
    $pid = intval($_post['p_id']);
    $tbl = jrCore_db_table_name('jrCore', 'performance');
    $req = "SELECT * FROM {$tbl} WHERE p_id = '{$pid}' LIMIT 1";
    $_tm = jrCore_db_query($req, 'SINGLE');
    if (!$_tm || !is_array($_tm)) {
        jrCore_set_form_notice('error', 'Unable to find results to share - please try again');
        jrCore_location('referrer');
    }

    // Save our updated results
    $prv = jrCore_db_escape($_post['provider']);
    $cmt = jrCore_db_escape($_post['comment']);
    $typ = jrCore_db_escape($_post['type']);
    $prc = (int) $_post['price'];
    $rtg = (int) $_post['rating'];
    $req = "UPDATE {$tbl} SET p_provider = '{$prv}', p_comment = '{$cmt}', p_price = '{$prc}', p_rating = '{$rtg}', p_type = '{$typ}' WHERE p_id = '{$pid}' LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt !== 1) {
        jrCore_set_form_notice('error', 'Unable to save share results - please try again');
        jrCore_location('referrer');
    }

    // Active Marketplace info
    $_mk = jrMarket_get_active_release_system();

    // Our payload
    $_up            = array(
        'payload' => array(
            'system_id' => $_mk['system_code'],
            'result'    => $_post['result'],
            'provider'  => jrCore_strip_html($_post['provider']),
            'price'     => intval($_post['price']),
            'comment'   => jrCore_strip_html($_post['comment']),
            'rating'    => intval($_post['rating']),
            'type'      => $_post['type'],
            'cpu'       => floatval($_post['p_cpu']),
            'mem'       => $_post['p_mem'],
        )
    );
    $_up['payload'] = jrCore_url_encode_string(json_encode($_up['payload']));
    $_rs            = jrCore_load_url("http://www.jamroom.net/networkperformance/submit", $_up, 'POST');
    if (!$_rs || strlen($_rs) < 3) {
        jrCore_set_form_notice('error', 'Unable to share results to server - please try again');
        jrCore_location('referrer');
    }
    $_rs = json_decode($_rs, true);
    if (!$_rs || !is_array($_rs)) {
        jrCore_set_form_notice('error', 'Invalid results received from share server - please try again');
        jrCore_location('referrer');
    }
    if (isset($_rs['error'])) {
        jrCore_set_form_notice('error', $_rs['error']);
    }
    else {
        jrCore_form_delete_session();
        jrCore_set_form_notice('success', $_rs['success']);
    }
    jrCore_set_temp_value('jrCore', 'performance_shared', 1);
    jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/performance_share");
}
