<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: package_skin_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_package_skin_save($_post, $_user, $_conf)
{
    $_skins = jrCore_get_skins();
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_skins["{$_post['zip_skin']}"])) {
        jrCore_set_form_notice('error', 'Invalid skin - please select a skin from the list');
        jrCore_form_field_hilight('zip_skin');
        jrCore_form_result();
    }
    // Get version
    $_mta = jrCore_skin_meta_data($_post['zip_skin']);
    if (!$_mta || !isset($_mta['version'])) {
        jrCore_set_form_notice('error', "The skin is missing the required &quot;version&quot; attribute in the {$_post['zip_skin']}_meta() function");
        jrCore_form_result();
    }
    $mdir = jrCore_get_media_directory(0, FORCE_LOCAL);
    if (is_file("{$mdir}/{$_post['zip_skin']}-{$_mta['version']}.zip")) {
        unlink("{$mdir}/{$_post['zip_skin']}-{$_mta['version']}.zip");
    }
    if (is_dir("{$mdir}/skins")) {
        jrCore_delete_dir_contents("{$mdir}/skins", false);
        rmdir("{$mdir}/skins");
    }
    mkdir("{$mdir}/skins", $_conf['jrCore_dir_perms'], true);

    // Copy files to work directory
    jrCore_copy_dir_recursive(APP_DIR . "/skins/{$_post['zip_skin']}", "{$mdir}/skins/{$_post['zip_skin']}");

    $_temp = jrCore_get_directory_files("{$mdir}/skins/{$_post['zip_skin']}");
    if (!$_temp || !is_array($_temp)) {
        jrCore_set_form_notice('error', "Invalid skin - unable to find any skin files");
        jrCore_form_result();
    }

    $_files = array();
    foreach ($_temp as $fullpath => $file) {

        // Cleanup some files we do not need
        switch ($file) {
            case '.DS_Store':
                unlink($fullpath);
                continue 2;
            default:
                break;
        }

        // Add in the license header depending on the license we got
        if (!strpos($fullpath, '/contrib/') && !strpos($fullpath, '/tools/') && jrCore_file_extension($file) === 'php') {
            jrDeveloper_add_license_header('skin', $_post['zip_skin'], $fullpath, $_post['zip_license']);
        }

        // Included for ZIP file
        $_files["skins/{$_post['zip_skin']}/{$file}"] = $fullpath;
    }

    // Add in full license file
    $_rep = array(
        'item_name'      => $_post['zip_skin'],
        'item_directory' => $_post['zip_skin'],
        'item_type'      => 'skin'
    );
    $temp = jrCore_parse_template("{$_post['zip_license']}.tpl", $_rep, 'jrDeveloper');
    jrCore_write_to_file("{$mdir}/skins/{$_post['zip_skin']}/license.html", $temp);
    $_files["skins/{$_post['zip_skin']}/license.html"] = "{$mdir}/skins/{$_post['zip_skin']}/license.html";

    jrCore_create_zip_file("{$mdir}/{$_post['zip_skin']}-{$_mta['version']}.zip", $_files);
    jrCore_delete_dir_contents("{$mdir}/skins", false);
    rmdir("{$mdir}/skins");
    jrCore_form_delete_session();
    jrCore_location('referrer');
}
