<?php
 /**
 * Jamroom Geo Location module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: database
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrGeo_database($_post, $_user, $_conf)
{
    // Master Only
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrGeo', 'database');
    jrCore_page_banner('Geo Databases');
    jrCore_page_notice('success', "Geo Database files are required for Geo Location functions to work correctly.<br>Click the Install or Update buttons below to install the latest Geo Database files", false);
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'database';
    $dat[1]['width'] = '50%';
    $dat[2]['title'] = 'size';
    $dat[2]['width'] = '20%';
    $dat[3]['title'] = 'installed';
    $dat[3]['width'] = '20%';
    $dat[4]['title'] = 'action';
    $dat[4]['width'] = '10%';
    jrCore_page_table_header($dat);

    $_db = jrGeo_get_available_database_info();
    foreach ($_db as $pfx => $d) {

        $img             = jrCore_get_activity_indicator("s-{$pfx}", 24);
        $fnc             = "$('#b-{$pfx}').hide(); $('#s-{$pfx}').show(300, function(){ jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/install_db/{$pfx}') });";
        $dat             = array();
        $dat[1]['title'] = '<h3>' . $d[1] . '</h3>';
        if (!empty($d[4])) {
            $dat[1]['title'] .= "<br><small>{$d[4]}</small>";
        }
        $dat[1]['class'] = 'center p10';
        $_files          = jrCore_get_media_files(0, "{$pfx}*");
        if (is_array($_files) && isset($_files[0])) {
            $dat[2]['title'] = jrCore_format_size($_files[0]['size']);
            $dat[3]['title'] = jrCore_format_time($_files[0]['time']);
            $dat[4]['title'] = $img . jrCore_page_button("b-{$pfx}", "update database", "jrCore_confirm('Update this database?', 'Please be patient - it could take several minutes to update the database files', function(){ {$fnc} })");
        }
        else {
            $dat[2]['title'] = '-';
            $dat[3]['title'] = '-';
            $dat[4]['title'] = $img . jrCore_page_button("b-{$pfx}", "install database", "jrCore_confirm('Install this database?', 'Please be patient - it could take several minutes to install the database files', function(){ {$fnc} })");
        }
        $dat[2]['class'] = 'center';
        $dat[3]['class'] = 'center';
        $dat[4]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_display();
}
