<?php
 /**
 * Jamroom Image Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: cache_reset_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrImage_cache_reset_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Setup new cache dir for all new requests
    if (isset($_post['image_cache_reset']) && $_post['image_cache_reset'] == 'on') {

        $cdr = jrCore_get_module_cache_dir('jrImage');
        $old = $_conf['jrImage_active_cache_dir'];
        $dir = substr(md5(microtime() . mt_rand()), 0, 5);
        if (!is_dir("{$cdr}/{$dir}")) {
            mkdir("{$cdr}/{$dir}", $_conf['jrCore_dir_perms'], true);
        }
        // Update to new setting
        if (jrCore_set_setting_value('jrImage', 'active_cache_dir', $dir)) {

            jrCore_delete_config_cache();

            // Delete old directory via a Queue Worker
            $_queue = array(
                'new_cache_dir' => $dir,
                'old_cache_dir' => $old
            );
            jrCore_queue_create('jrImage', 'clear_cache', $_queue, 10);

            jrCore_set_form_notice('success', 'The image cache was successfully reset');
            jrCore_form_delete_session();
        }
        else {
            jrCore_set_form_notice('error', 'an error was encountered saving the new cache directory to the global settings');
        }
    }
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/cache_reset");
}
