<?php
 /**
 * Jamroom Image Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: limit_image_size
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrImage_limit_image_size($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrImage');
    jrCore_page_banner('Resize Item Images', 'Limit item images to a maximum height or width');
    $text = '';
    $_tmp = array('jrPayment', 'jrFoxyCart', 'jrPayPal');
    foreach ($_tmp as $m) {
        if (jrCore_module_is_active($m)) {
            $text = '<br><b>Note:</b> items that are for sale will not have their image resized.';
            break;
        }
    }
    $note = "The Resize Item Images tool searches for item images with a width or height <b>greater</b> than the selected value<br>and if found, reduces them (in proportion) to the new value which can help save server disk space.{$text}<br><br><b>Important!</b> Once images have been resized the original size cannot be recovered!";
    jrCore_page_note($note, false);

    // Form init
    $_tmp = array(
        'submit_value'  => 'Resize Item Images',
        'cancel'        => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'submit_prompt' => 'Are you sure you want to resize the images?',
        'submit_modal'  => 'update',
        'modal_width'   => 800,
        'modal_height'  => 400,
        'modal_note'    => 'Please be patient while the images are processed'
    );
    jrCore_form_create($_tmp);

    $_opt = array();
    foreach ($_mods as $m => $i) {
        switch ($m) {
            case 'jrCore':
            case 'jrImage':
            case 'jrInject':
            case 'jrListParams':
            case 'jrSearch':
                break;
            default:
                if (jrCore_is_datastore_module($m)) {
                    $_opt[$m] = $i['module_name'];
                }
                break;
        }
    }
    natcasesort($_opt);
    $_tmp = array(
        'name'     => 'image_module',
        'label'    => 'Module',
        'help'     => 'Select the module you want to limit the item image size for',
        'options'  => $_opt,
        'type'     => 'select',
        'validate' => 'printable',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_sz = array();
    foreach (range(256, 2560, 64) as $sz) {
        $_sz[$sz] = "{$sz} pixels";
    }
    $_tmp = array(
        'name'     => 'max_item_size',
        'type'     => 'select',
        'default'  => '2048',
        'options'  => $_sz,
        'label'    => 'Max Item Size',
        'validate' => 'number_nz',
        'help'     => "Select the maximum size (in pixels) for the height or width of the item image:<br><br><b>NOTE:</b> Items that are for sale will not be resized!"
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'dry_run',
        'label'    => 'Test Run',
        'default'  => 'on',
        'type'     => 'checkbox',
        'required' => 'on',
        'validate' => 'onoff',
        'help'     => "If checked, image resizing will not be applied to the images, but the difference between the original and new file sizes will be shown so you can view the potential disk space savings."
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_display();
}
