<?php
 /**
 * Jamroom Image Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: rb_image
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrImage_rb_image($_post, $_user, $_conf)
{
    jrUser_is_admin();

    $tbl = jrCore_db_table_name('jrCore', 'recycle');
    $req = "SELECT r_module AS module, r_item_id AS iid, r_profile_id AS pid, r_data FROM {$tbl} WHERE r_id = '{$_post['_1']}'";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        $_post['_3'] = 'icon';
        jrImage_display_default_image($_post, $_conf);
    }
    $_data = json_decode($_rt['r_data'], true);
    if (!$_data || !is_array($_data)) {
        $_post['_3'] = 'icon';
        jrImage_display_default_image($_post, $_conf);
    }

    $_im = array('image_time' => $_data['_updated']);
    foreach (array('name', 'size', 'type', 'extension', 'width', 'height') as $i) {
        if (isset($_data["{$_post['_3']}_{$i}"])) {
            $_im["image_{$i}"] = $_data["{$_post['_3']}_{$i}"];
        }
    }

    // Ensure master image is local for resize
    jrCore_db_close();
    $dir = jrCore_get_media_directory($_data['_profile_id'], FORCE_LOCAL);
    $nam = "rb_{$_post['_2']}_{$_data['_item_id']}_{$_post['_3']}.{$_data["{$_post['_3']}_extension"]}";
    jrCore_confirm_media_file_is_local($_rt['pid'], $nam, "{$dir}/{$nam}");
    if (!is_file("{$dir}/{$nam}")) {
        $_post['_3'] = 'icon';
        jrImage_display_default_image($_post, $_conf);
    }
    if (!jrImage_is_valid_image_file("{$dir}/{$nam}")) {
        $_post['_3'] = 'icon';
        jrImage_display_default_image($_post, $_conf);
    }
    // Have we already resized this image?
    $ext = jrCore_file_extension($nam);
    $img = "{$dir}/{$nam}";
    if (is_file("{$dir}/{$nam}.{$ext}")) {
        $img = "{$dir}/{$nam}.{$ext}";
    }
    else {
        $_tm = getimagesize($img);
        if ($_tm[0] > 512 || $_tm[1] > 512) {
            if ($new = jrImage_resize_image("{$dir}/{$nam}", "{$dir}/{$nam}.{$ext}", 512)) {
                if (is_file($new)) {
                    $img = $new;
                }
            }
        }
    }

    // On PHP 7 systems session handling will set some default "no cache" headers that we
    // we need to remove.  This _should_ be fixed by setting session_cache_limiter(''), but
    // have found that makes sessions a bit on the flaky side, so we just unset the headers here
    header_remove('Cache-Control');
    header_remove('Expires');
    header_remove('Pragma');

    // Get right mime type - sometimes it can be wrong when PHP is wrong
    switch ($_im['image_extension']) {
        case 'jpg':
        case 'jpe':
        case 'jpeg':
        case 'jif':
        case 'jfi':
        case 'jfif':
            $mime = "image/jpeg";
            break;
        case 'png':
            $mime = "image/png";
            break;
        case 'gif':
            $mime = "image/gif";
            break;
        default:
            $mime = $_im['image_type'];
            break;
    }

    jrCore_set_custom_header("Last-Modified: " . gmdate('D, d M Y H:i:s \G\M\T', $_im['image_time']));
    jrCore_set_custom_header("Content-Type: {$mime}");
    jrCore_set_custom_header('Content-Disposition: inline; filename="' . $_im['image_name'] . '"');
    jrCore_set_custom_header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 86400000));
    jrCore_run_module_function('jrCloudClient_start_timer', 'jrCore', 'filesystem');
    $img = file_get_contents($img);
    jrCore_run_module_function('jrCloudClient_stop_timer', 'jrCore', 'filesystem');
    jrCore_send_response_and_detach($img);
}
