<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: install_result
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_install_result($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMarket', 'system_update');
    jrCore_page_banner('install results');

    // We need a valid install id
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_notice_page('error', 'Invalid install_id');
    }
    $tbl = jrCore_db_table_name('jrMarket', 'install');
    $req = "SELECT * FROM {$tbl} WHERE install_id = '{$_post['_1']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_notice_page('error', 'Invalid install_id');
    }
    $_rt = json_decode($_rt['install_data'], true);

    if (isset($_rt['modules']) && is_array($_rt['modules']) && count($_rt['modules']) > 0) {

        $dat             = array();
        $dat[1]['title'] = '';
        $dat[1]['width'] = '2%';
        $dat[2]['title'] = 'module';
        $dat[2]['width'] = '63%';
        $dat[3]['title'] = 'old version';
        $dat[3]['width'] = '10%';
        $dat[4]['title'] = 'version';
        $dat[4]['width'] = '10%';
        $dat[5]['title'] = 'action';
        $dat[5]['width'] = '10%';
        $dat[6]['title'] = 'info';
        $dat[6]['width'] = '5%';
        jrCore_page_table_header($dat);

        foreach ($_rt['modules'] as $name => $_inf) {
            $dat             = array();
            $dat[1]['title'] = jrCore_get_module_icon_html($name, 32);
            $dat[1]['width'] = '2%';
            $dat[2]['title'] = $_mods[$name]['module_name'];
            $dat[3]['title'] = $_inf['old_version'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = $_mods[$name]['module_version'];
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = $_inf['action'];
            $dat[5]['class'] = 'center';
            $url             = jrCore_get_module_url($name);
            $dat[6]['title'] = jrCore_page_button($name, 'info', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/admin/info')");
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_footer();
    }

    if (isset($_rt['skins']) && is_array($_rt['skins']) && count($_rt['skins']) > 0) {

        $dat             = array();
        $dat[1]['title'] = '';
        $dat[1]['width'] = '2%';
        $dat[2]['title'] = 'skin';
        $dat[2]['width'] = '63%';
        $dat[3]['title'] = 'old version';
        $dat[3]['width'] = '10%';
        $dat[4]['title'] = 'version';
        $dat[4]['width'] = '10%';
        $dat[5]['title'] = 'action';
        $dat[5]['width'] = '10%';
        $dat[6]['title'] = 'info';
        $dat[6]['width'] = '5%';
        jrCore_page_table_header($dat);

        $url = jrCore_get_module_url('jrCore');
        foreach ($_rt['skins'] as $name => $_inf) {
            $_mta            = jrCore_skin_meta_data($name);
            $dat             = array();
            $dat[1]['title'] = jrCore_get_skin_icon_html($name, 32);
            $dat[1]['width'] = '2%';
            $dat[2]['title'] = $_mta['name'];
            $dat[3]['title'] = $_inf['old_version'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = $_mta['version'];
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = $_inf['action'];
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = jrCore_page_button($name, 'info', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/skin_admin/info/skin={$name}')");
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_footer();
    }

    if (strpos(jrCore_get_local_referrer(), 'history')) {
        jrCore_page_cancel_button('referrer', 'cancel');
    }
    else {
        jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse", 'continue');
    }
    jrCore_page_display();
}
