/**
 * Get pulse counts for viewer
 * @param cb callback function
 */
function jrProfile_get_pulse_counts(cb)
{
    if (typeof jrProfile_disable_pulse !== 'undefined' && jrProfile_disable_pulse === 'on') {
        return false;
    }
    var k = true;
    var n = Math.floor(Date.now() / 1000);
    var v = localStorage.getItem('ppc_check');
    if (typeof v === "undefined" || v === null) {
        localStorage.setItem('ppc_check', n);
    }
    else {
        if ((n - v) < 30) {
            // Too soon to check again
            var r = localStorage.getItem('ppc_data');
            if (typeof r !== 'undefined' && r !== null) {
                r = JSON.parse(r);
                if (cb !== null && typeof cb == "function") {
                    if (__ppcb === null) {
                        __ppcb = cb;
                    }
                    return cb(r);
                }
            }
            return false;
        }
        localStorage.setItem('ppc_check', n);
    }
    var u = core_system_url + '/' + jrProfile_url + '/get_pulse_counts';
    $.get(u, function(r) {
        localStorage.setItem('ppc_data', JSON.stringify(r));
        if (cb !== null && typeof cb == "function") {
            if (__ppcb === null) {
                __ppcb = cb;
            }
            cb(r);
        }
    });
}

/**
 * Reset Pulse count for a key
 * @param key string Key to reset
 * @param cb function callback
 */
function jrProfile_reset_pulse_key(key, cb)
{
    var u = core_system_url + '/' + jrProfile_url + '/reset_pulse_count';
    jrCore_set_csrf_cookie(u);
    $.post(u, {key: key}, function() {

        var r = localStorage.getItem('ppc_data');
        if (typeof r !== 'undefined' && r !== null) {
            r = JSON.parse(r);
        }
        var n = 0;
        for (var i in r) {
            if (r !== null && r.hasOwnProperty(i)) {
                if (i === key) {
                    delete r[i];
                }
                else {
                    n++;
                }
            }
        }
        if (n === 0) {
            localStorage.removeItem('ppc_data');
        }
        else {
            localStorage.setItem('ppc_data', JSON.stringify(r));
        }

        if (cb !== null && typeof cb == "function") {
            return cb();
        }
        return false;
    });
}

var __ppcb = null;
$(window).bind('storage', function(e) {
    if (__ppcb !== null) {
        if (e.originalEvent.key === 'ppc_data') {
            var r = localStorage.getItem('ppc_data');
            if (r !== null) {
                r = JSON.parse(r);
                __ppcb(r);
            }
        }
    }
});