<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: quota_browser
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_quota_browser($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrProfile', 'quota_browser');
    jrCore_page_banner('Profile Quotas');

    // Start our output
    $dat             = array();
    $dat[1]['title'] = 'ID';
    $dat[1]['width'] = '5%';
    $dat[2]['title'] = 'name';
    $dat[2]['width'] = '60%';
    $dat[3]['title'] = 'profiles';
    $dat[3]['width'] = '5%';
    $dat[4]['title'] = 'signup';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'note';
    $dat[5]['width'] = '5%';
    $dat[6]['title'] = 'rename';
    $dat[6]['width'] = '5%';
    $dat[7]['title'] = 'clone';
    $dat[7]['width'] = '5%';
    $dat[8]['title'] = 'transfer';
    $dat[8]['width'] = '5%';
    $dat[9]['title'] = 'delete';
    $dat[9]['width'] = '5%';
    jrCore_page_table_header($dat);

    // Get existing quotas
    $tbl = jrCore_db_table_name('jrProfile', 'quota_value');
    $req = "SELECT `quota_id`, `name`, `value` FROM {$tbl} WHERE `name` IN('name','allow_signups','admin_note','profile_count') ORDER BY `quota_id` ASC";
    $_rt = jrCore_db_query($req, 'NUMERIC');
    $_ft = array();
    if ($_rt && is_array($_rt)) {
        foreach ($_rt as $_v) {
            $_ft["{$_v['quota_id']}"]["{$_v['name']}"] = $_v['value'];
        }
    }
    $pass  = jrCore_get_option_image('pass');
    $fail  = jrCore_get_option_image('fail');
    $murlu = jrCore_get_module_url('jrUser');

    foreach ($_ft as $qid => $_qt) {

        $num             = (isset($_qt['profile_count'])) ? (int) $_qt['profile_count'] : '0';
        $dat             = array();
        $dat[1]['title'] = $qid;
        $dat[1]['class'] = 'center';
        $dat[2]['title'] = $_qt['name'];
        if ($num > 0) {
            $dat[3]['title'] = jrCore_page_button("qb-c{$qid}", jrCore_number_format($num), "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/dashboard/browser/search_string=profile_quota_id:{$qid}')");
        }
        else {
            $dat[3]['title'] = '0';
        }
        $dat[3]['class'] = 'center';
        $dat[4]['title'] = (isset($_qt['allow_signups']) && $_qt['allow_signups'] == 'on') ? '<a href="' . $_conf['jrCore_base_url'] . '/' . $murlu . '/admin/quota/id=' . $qid . '">' . $pass . '</a>' : '<a href="' . $_conf['jrCore_base_url'] . '/' . $murlu . '/admin/quota/id=' . $qid . '">' . $fail . '</a>';
        $dat[4]['class'] = 'center';
        $dat[5]['title'] = (!empty($_qt['admin_note'])) ? '<img src="' . $_conf['jrCore_base_url'] . '/modules/jrProfile/img/note.png" width="24" height="24" alt="' . jrCore_entity_string($_qt['admin_note']) . '" title="' . jrCore_entity_string($_qt['admin_note']) . '" onclick="jrCore_alert(\'' . jrCore_entity_string($_qt['admin_note']) . '\')">' : '&nbsp;';
        $dat[5]['class'] = 'center';
        $dat[6]['title'] = jrCore_page_button("qb-r{$qid}", 'rename', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/quota/id={$qid}/hl=name')");
        $dat[7]['title'] = jrCore_page_button("qb-c{$qid}", 'clone', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/quota_clone/id={$qid}')");
        if ($num > 0) {
            $dat[8]['title'] = jrCore_page_button("qb-t{$qid}", 'transfer', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/quota_transfer/id={$qid}')");
            $dat[9]['title'] = jrCore_page_button("qb-d{$qid}", 'delete', 'disabled');
        }
        else {
            $dat[8]['title'] = jrCore_page_button("qb-t{$qid}", 'transfer', 'disabled');
            $dat[9]['title'] = jrCore_page_button("qb-d{$qid}", 'delete', " jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/quota_delete/id={$qid}')");
        }
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    // Form init
    $_tmp = array(
        'submit_value'     => 'create new quota',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // New Quota Name
    $_tmp = array(
        'name'      => 'new_quota_name',
        'label'     => 'new quota name',
        'help'      => 'To create a new Profile Quota, enter the name of the new quota you would like to create.',
        'type'      => 'text',
        'error_msg' => 'Please enter a valid quota name',
        'validate'  => 'printable'
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_display();
}
