<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: quota_transfer
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_quota_transfer($_post, $_user, $_conf)
{
    jrUser_master_only();

    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid quota_id - please try again');
        jrCore_form_result();
    }

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrProfile');
    jrCore_page_banner('Select Quota to Transfer to');

    // Form init
    $_tmp = array(
        'submit_value' => 'transfer profiles',
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/quota_browser"
    );
    jrCore_form_create($_tmp);

    $_qt = jrProfile_get_quotas();
    unset($_qt["{$_post['id']}"]);

    // Clone Quota ID
    $_tmp = array(
        'name'  => 'transfer_id',
        'type'  => 'hidden',
        'value' => $_post['id']
    );
    jrCore_form_field_create($_tmp);

    // New Quota Name
    $_tmp = array(
        'name'      => 'new_quota_id',
        'label'     => 'transfer to quota',
        'help'      => 'Select the Quota you want to transfer profiles to.',
        'type'      => 'select',
        'options'   => $_qt,
        'error_msg' => 'Please enter a valid quota name',
        'validate'  => 'printable'
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
