<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: settings_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_settings_save($_post, $_user, $_conf)
{
    global $_mods, $_urls;

    jrUser_session_require_login();
    jrCore_form_validate($_post);
    jrUser_load_lang_strings();

    if (isset($_post['profile_id']) && jrCore_checktype($_post['profile_id'], 'number_nz')) {
        if (jrUser_is_admin()) {
            $_profile = jrCore_db_get_item('jrProfile', $_post['profile_id']);
        }
        elseif (jrUser_is_power_user() || jrUser_is_multi_user()) {
            // For a Power or Multi User we need to make sure they have
            // access to the profile they are trying to modify
            $_pr = jrProfile_get_user_linked_profiles($_user['_user_id']);
            if (!isset($_pr["{$_post['profile_id']}"])) {
                jrCore_set_form_notice('error', 'invalid profile_id - please try again');
                jrCore_form_result();
            }
            $_profile = jrCore_db_get_item('jrProfile', $_post['profile_id']);
        }
        else {
            $_profile = jrCore_db_get_item('jrProfile', $_user['user_active_profile_id']);
        }
    }
    else {
        $_profile = jrCore_db_get_item('jrProfile', $_user['user_active_profile_id']);
    }

    // Profile name checks
    if (!jrUser_is_admin() && !empty($_post['profile_name'])) {
        if (!jrCore_checktype($_post['profile_name'], 'valid_name')) {
            jrCore_set_form_notice('error', 18);
            jrCore_form_field_hilight('profile_name');
            jrCore_form_result();
        }
    }

    if (!jrUser_is_admin()) {
        unset($_post['profile_active']);
    }
    else {
        $_post['profile_active'] = ($_post['profile_active'] == 'on') ? 1 : 0;
        // If the admin is changing the profile active, change user_active as well
        $_us = jrProfile_get_owner_info($_profile['_profile_id']);
        if ($_us && is_array($_us)) {
            $_up = array('user_active' => $_post['profile_active']);
            foreach ($_us as $_u) {
                if ($_u['_user_id'] != $_user['_user_id']) {
                    // We want to set an user accounts that are ONLY associated with
                    // this profile to inactive as well (user_active = 0)
                    $_pr = jrProfile_get_user_linked_profiles($_u['_user_id']);
                    if (!$_pr || count($_pr) === 1) {
                        jrCore_db_update_item('jrUser', $_u['_user_id'], $_up);
                    }
                }
            }
        }
        $_rt = jrCore_db_get_item_by_key('jrProfile', 'profile_name', $_post['profile_name']);
        if ($_post['profile_active'] != $_rt['profile_active']) {
            // changing active - reset inactive profile cache
            jrCore_delete_cache('jrProfile', 'jrprofile_inactive_profiles', false, false);
        }
    }

    if (isset($_post['profile_quota_id']) && jrCore_checktype($_post['profile_quota_id'], 'number_nz')) {
        // Validate posted Quota
        $_qut = jrProfile_get_quotas();
        if (!jrUser_is_admin()) {

            if (jrUser_is_power_user()) {
                // We're a power user and may only have access to selected Quotas
                $key = jrUser_get_profile_home_key('quota_jrUser_power_user_quotas');
                if (strpos($key, ',')) {
                    $_all = array();
                    foreach (explode(',', $key) as $qid) {
                        if (isset($_qut[$qid])) {
                            $_all[$qid] = $_qut[$qid];
                        }
                    }
                    $_qut = $_all;
                    unset($_all);
                }
                elseif (jrCore_checktype($key, 'number_nz') && isset($_qut[$key])) {
                    $_qut = array($key => $_qut[$key]);
                }
                else {
                    jrCore_set_form_notice('error', 32);
                    jrCore_form_field_hilight('profile_quota_id');
                    jrCore_form_result();
                }
            }
            elseif (isset($_conf['jrProfile_change']) && $_conf['jrProfile_change'] == 'on') {
                // We can only change to a quota that allows signup
                $_qot = jrProfile_get_signup_quotas();
                if (!isset($_qot["{$_post['profile_quota_id']}"])) {
                    jrCore_set_form_notice('error', 31);
                    jrCore_form_field_hilight('profile_quota_id');
                    jrCore_form_result();
                }
            }
            else {
                // No change
                $_post['profile_quota_id'] = $_profile['profile_quota_id'];
            }
        }
        $qid = (int) $_post['profile_quota_id'];
        $hqi = (int) jrUser_get_profile_home_key('profile_quota_id');
        if (!isset($_qut[$qid]) && $qid !== $hqi) {
            jrCore_set_form_notice('error', 31);
            jrCore_form_field_hilight('profile_quota_id');
            jrCore_form_result();
        }
    }

    $_post['profile_private'] = (int) $_post['profile_private'];
    $_data                    = jrCore_form_get_save_data('jrProfile', 'settings', $_post);

    if (isset($_data['profile_name']) && strlen($_data['profile_name']) > 0) {

        // Make sure we have a good profile_name
        if (strpos(' ' . $_data['profile_name'], '>') || strpos(' ' . $_data['profile_name'], '<') || stripos(' ' . $_data['profile_name'], 'script')) {
            jrCore_set_form_notice('error', 47);
            jrCore_form_field_hilight('profile_name');
            jrCore_form_result();
        }

        // Custom profile url checking
        if ((jrUser_is_admin() || (isset($_user['quota_jrProfile_url_changes']) && $_user['quota_jrProfile_url_changes'] == 'on')) && isset($_data['profile_url']) && strlen($_data['profile_url']) > 0) {
            $profile_url = jrCore_url_string($_data['profile_url']);
            $highlight   = 'profile_url';
        }
        else {
            $profile_url = jrCore_url_string($_post['profile_name']);
            $highlight   = 'profile_name';
        }
        if ($profile_url != $_profile['profile_url']) {
            // Make sure the url isn't being used already
            if (jrCore_db_get_item_by_key('jrProfile', 'profile_url', $profile_url)) {
                jrCore_set_form_notice('error', 45);
                jrCore_form_field_hilight($highlight);
                jrCore_form_result();
            }
            // Check for an active skin template with that name...
            if (is_file(APP_DIR . "/skins/{$_conf['jrCore_active_skin']}/{$profile_url}.tpl")) {
                jrCore_set_form_notice('error', 45);
                jrCore_form_field_hilight($highlight);
                jrCore_form_result();
            }
            // Make sure it is NOT a module URL
            if (isset($_mods[$profile_url]) || isset($_urls[$profile_url])) {
                jrCore_set_form_notice('error', 45);
                jrCore_form_field_hilight($highlight);
                jrCore_form_result();
            }
        }
        $_data['profile_url'] = $profile_url;
    }
    jrCore_db_update_item('jrProfile', $_profile['_profile_id'], $_data);

    // Update Quota Counts for quotas if we are changing
    if (jrUser_is_admin() && isset($_post['profile_quota_id']) && $_post['profile_quota_id'] != $_profile['profile_quota_id']) {
        // Update counts in both Quotas
        jrProfile_increment_quota_profile_count($_post['profile_quota_id']);
        jrProfile_decrement_quota_profile_count($_profile['profile_quota_id']);
    }

    // Check for file upload
    $_image = jrCore_save_media_file('jrProfile', 'profile_image', $_profile['_profile_id'], $_profile['_profile_id']);

    // If the user does NOT have a user image, and we are uploading one to our home profile...
    if (!isset($_user['user_image_size']) && isset($_image) && is_array($_image) && $_profile['_profile_id'] == jrUser_get_profile_home_key('_profile_id')) {
        $_user             = array_merge($_user, $_image);
        $_user['_item_id'] = $_profile['_profile_id'];
        $profile_image     = jrCore_get_media_file_path('jrProfile', 'profile_image', $_user);
        if (is_file($profile_image)) {
            $ext = jrCore_file_extension($profile_image);
            $nam = "{$_user['_user_id']}_user_image";
            if (jrCore_copy_media_file($_profile['_profile_id'], $profile_image, $nam)) {
                $dir = dirname($profile_image);
                jrCore_write_to_file("{$dir}/{$nam}.tmp", "user_image.{$ext}");
                jrCore_save_media_file('jrUser', "{$dir}/{$nam}", $_profile['_profile_id'], $_user['_user_id']);
                unlink("{$dir}/{$nam}");
                unlink("{$dir}/{$nam}.tmp");
            }
        }
    }

    // Save any uploaded media files added in by custom form fields
    jrCore_save_all_media_files('jrProfile', 'settings', $_profile['_profile_id'], $_profile['_profile_id']);

    // If we have updated our OWN profile, then we need to update home keys
    if ($_profile['_profile_id'] == jrUser_get_profile_home_key('_profile_id') || $_profile['_profile_id'] == $_user['user_active_profile_id']) {
        jrUser_save_profile_home_keys();
        jrUser_session_sync();
    }
    jrCore_form_delete_session();

    // Send out profile updated trigger
    jrCore_trigger_event('jrProfile', 'profile_updated', $_profile, $_data);

    // If this is an admin from the browser...
    if (jrUser_is_admin() && isset($_post['from_browser']) && jrCore_checktype($_post['from_browser'], 'url')) {
        jrCore_form_result($_post['from_browser']);
    }
    jrUser_reset_cache($_user['_user_id']);
    jrProfile_reset_cache($_profile['_profile_id']);
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_data['profile_url']}");
}
