<?php
 /**
 * Jamroom Search module
 *
 * copyright 2022 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: results
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrSearch_results($_post, $_user, $_conf)
{
    global $_mods;
    $saved = jrUser_get_session_key('jrsearch_last_search_string');
    if (empty($_post['search_string'])) {
        if ($saved) {
            $_post['search_string'] = $saved;
        }
        else {
            $_fn = array();
            $out = jrCore_parse_template('header.tpl');
            $out .= jrCore_parse_template('search_results.tpl', $_fn, 'jrSearch');
            return $out;
        }
    }

    // Cleanup search string - no HTML allowed
    $_post['search_string'] = strip_tags(trim(str_replace(array('(', ')'), '', $_post['search_string'])));

    // our saved search is what we show to the user on the results page
    $saved_search = jrCore_entity_string(strip_tags(str_replace('"', '', $_post['search_string'])));
    jrUser_set_session_key('jrsearch_last_search_string', $saved_search);

    // First - find modules we are going to be searching
    $_rm = jrCore_get_registered_module_features('jrSearch', 'search_fields');

    // Allow other modules to inject into search
    $_rm = jrCore_trigger_event('jrSearch', 'search_fields', $_rm);

    // Prune out any disabled modules
    if ($_rm && is_array($_rm)) {
        foreach ($_rm as $m => $v) {
            if (jrSearch_is_disabled_module($m)) {
                unset($_rm[$m]);
            }
        }
    }

    // Specific modules
    $all = true;
    $_ln = jrUser_load_lang_strings();
    if (!empty($_post['_1']) && $_post['_1'] != 'all') {
        $_tm = explode(',', $_post['_1']);
        if ($_tm && is_array($_tm)) {
            $_at = array();
            foreach ($_tm as $mod) {
                if (isset($_rm[$mod])) {
                    $_at[$mod] = $_rm[$mod];
                }
            }
            if (count($_at) > 0) {
                $_rm = $_at;
                $all = false;
            }
        }
    }

    jrCore_page_title($_ln['jrSearch'][13]);
    $out = jrCore_parse_template('header.tpl');

    // figure pagebreak
    $page = 1;
    if (!empty($saved) && !empty($saved_search) && $saved != $saved_search) {
        // we had a search, then went to page two, then had a different search term, so go back to page 1
        $page = $page;
    }
    elseif (!empty($_post['_2'])) {
        $page = (int) $_post['_2'];
    }
    $pbrk = jrCore_get_config_value('jrSearch', 'index_limit', 4);
    if (!empty($_post['_3'])) {
        $pbrk = (int) $_post['_3'];
    }

    // Search string must be 3 chars or longer
    if (strlen($_post['search_string']) >= 3) {

        if ($fields = jrCore_get_config_value('jrSearch', 'search_fields', false)) {
            $_af = explode("\n", $fields);
            if ($_af && is_array($_af)) {
                $_pf = array();
                foreach ($_mods as $dir => $_in) {
                    if (isset($_rm[$dir])) {
                        if (isset($_in['module_prefix']) && strlen($_in['module_prefix']) > 0) {
                            $_pf["{$_in['module_prefix']}"] = $dir;
                        }
                    }
                }
                foreach ($_af as $fld) {
                    if (strpos($fld, ',')) {
                        list($fld,) = explode(',', $fld);
                        $fld = trim($fld);
                    }
                    $fld = trim($fld);
                    // See if we have a lang string
                    if (strpos($fld, ':')) {
                        list($fld, $lng) = explode(':', $fld, 2);
                        $lng = intval($lng);
                    }
                    else {
                        $lng = $fld;
                    }
                    list($pfx,) = explode('_', $fld, 2);
                    if (isset($_pf[$pfx])) {
                        $smod = $_pf[$pfx];
                        if (!isset($_rm[$smod])) {
                            $_rm[$smod]       = array();
                            $_rm[$smod][$fld] = $lng;
                        }
                        else {
                            $tkey = array_keys($_rm[$smod]);
                            $tkey = reset($tkey);
                            if (!function_exists($tkey)) {
                                $fval = $_rm[$smod][$tkey];
                                unset($_rm[$smod]);
                                $_rm[$smod]["{$tkey},{$fld}"] = $fval;
                            }
                        }
                    }
                }
            }
        }

        if (is_array($_rm)) {

            $ttl = 0;
            if (!$html = jrCore_is_cached('jrSearch', $_post['_uri'])) {

                // "use like"
                $_ul = array();
                foreach ($_rm as $m => $v) {
                    $_ul[$m] = false;
                }

                $_fn = array(
                    'titles'  => array(),
                    'results' => array()
                );
                $_ln = jrUser_load_lang_strings();
                $ltl = '';

                // Are we doing natural language or boolean?
                // http://dev.mysql.com/doc/refman/5.1/en/fulltext-boolean.html
                // http://dev.mysql.com/doc/refman/5.1/en/fulltext-natural-language.html
                $nat = true;
                $_fm = array();
                $_fo = array();
                $len = 4;
                if (strlen($_post['search_string']) < 5) {
                    $len = jrSearch_get_ft_min_word_length();
                }
                if (strlen($_post['search_string']) >= $len && strpos(trim($_post['search_string']), '"') !== 0) {
                    $_mt = explode(' ', $_post['search_string']);
                    if (stripos($_post['search_string'], ' AND ') || stripos($_post['search_string'], ' OR ') || stripos($_post['search_string'], ' NOT ')) {
                        // apple and pine not pineapple
                        // apple and pine or banana
                        // Clean boolean operators
                        foreach ($_mt as $k => $word) {
                            $word = strtolower($word);
                            if ($word == 'and') {
                                // With an AND we add + to the preceding AND next word in the search phrase
                                $prv = ($k - 1);
                                if (isset($_mt[$prv])) {
                                    $_mt[$prv] = '+' . str_replace(array('+', '-'), '', $_mt[$prv]);
                                }
                                $nxt = ($k + 1);
                                if (isset($_mt[$nxt])) {
                                    $_mt[$nxt] = '+' . str_replace(array('+', '-'), '', $_mt[$nxt]);
                                }
                                unset($_mt[$k]);
                            }
                            elseif ($word == 'or') {
                                // Or is the default, so we just remove our OR
                                unset($_mt[$k]);
                            }
                            elseif ($word == 'not') {
                                // With NOT with add a "-" sign to the next word in the search phrase
                                $nxt = ($k + 1);
                                if (isset($_mt[$nxt])) {
                                    $_mt[$nxt] = '-' . str_replace(array('+', '-'), '', $_mt[$nxt]);
                                }
                                unset($_mt[$k]);
                            }
                        }
                        $_post['original_search_string'] = $_post['search_string'];
                        $_post['search_string']          = implode(' ', $_mt);
                    }

                    $_mt = explode(' ', $_post['search_string']);
                    if ($_mt && is_array($_mt)) {
                        foreach ($_mt as $str) {
                            $char = substr($str, 0, 1);
                            switch ($char) {
                                case '+';
                                case '-';
                                case '"';
                                case '~';
                                    $nat = false;
                                    break 2;
                            }
                            if (strpos($str, '*')) {
                                $nat = false;
                                break;
                            }
                        }
                    }
                    $sst = jrCore_db_escape($_post['search_string']);
                    $tbl = jrCore_db_table_name('jrSearch', 'fulltext');

                    // Get search method
                    if (!isset($_conf['jrSearch_method'])) {
                        $_conf['jrSearch_method'] = 'both';
                    }
                    $smd = 'IN BOOLEAN MODE';
                    switch ($_conf['jrSearch_method']) {
                        case 'natural':
                            $smd = 'IN NATURAL LANGUAGE MODE';
                            break;
                        default:
                            if ($nat || count($_mt) > 4) {
                                $smd = 'IN NATURAL LANGUAGE MODE';
                            }
                            break;
                    }

                    // Do we have a dedicated index?
                    $req = false;
                    if (count($_rm) === 1) {
                        $tmd = array_keys($_rm);
                        $tmd = reset($tmd);
                        if (jrSearch_module_has_dedicated_index($tmd)) {
                            $tbt = jrCore_db_table_name('jrSearch', "fulltext_{$tmd}");
                            $req = "SELECT '{$tmd}' AS m, `s_id` AS i, ROUND(MATCH(`s_text`) AGAINST('{$sst}' {$smd}) * `s_mod`, 3) AS s FROM {$tbt} WHERE MATCH(`s_text`) AGAINST('{$sst}' {$smd})";
                        }
                    }
                    if (!$req) {
                        $req = "SELECT `s_module` AS m, `s_id` AS i, ROUND(MATCH(`s_text`) AGAINST('{$sst}' {$smd}) * `s_mod`, 3) AS s FROM {$tbl} WHERE MATCH(`s_text`) AGAINST('{$sst}' {$smd})";
                        if (!$all) {
                            $req .= " AND `s_module` IN('" . implode("','", array_keys($_rm)) . "')";
                        }
                        if (jrCore_get_config_value('jrSearch', 'optimize', 'on')) {
                            $lim = jrCore_get_config_value('jrSearch', 'module_limit', 2500);
                            $req .= " HAVING s > 1 LIMIT {$lim}";
                        }
                    }

                    $_rt = jrCore_db_query($req, 'NUMERIC');
                    if ($_rt && is_array($_rt)) {

                        // NOTE: The results from the query are automatically sorted by relevance - see:
                        // https://dev.mysql.com/doc/refman/5.5/en/fulltext-natural-language.html
                        foreach ($_rt as $v) {
                            if (isset($_rm["{$v['m']}"])) {
                                if (!isset($_fm["{$v['m']}"])) {
                                    $_fm["{$v['m']}"] = array();
                                }
                                $_fm["{$v['m']}"][] = $v['i'];
                            }
                        }

                        // Trigger for other modules
                        // module => item_id array
                        $_ag = array(
                            'page'      => $page,
                            'pagebreak' => $pbrk
                        );
                        $_fm = jrCore_trigger_event('jrSearch', 'search_item_ids', $_fm, $_ag);
                        if (count($_fm) > 0) {
                            foreach ($_fm as $m => $r) {
                                if (!empty($r)) {
                                    // We got at least one result - no need to use a LIKE search on this module
                                    unset($_ul[$m]);
                                }
                            }
                        }
                    }
                }

                // Fall through - did we get anything?
                if (jrCore_get_config_value('jrSearch', 'partial', 'on') === 'on' && count($_ul) > 0) {

                    // We are searching with a search string that is too short for full text
                    // OR we came out of the FULLTEXT search with no matches
                    $sst = jrCore_db_escape(str_replace('"', '', $_post['search_string']));
                    $tbl = jrCore_db_table_name('jrSearch', 'fulltext');
                    $req = "SELECT `s_module` AS m, `s_id` AS i FROM {$tbl} WHERE `s_text` LIKE '%{$sst}%' AND `s_module` IN('" . implode("','", array_keys($_ul)) . "')";
                    $_rt = jrCore_db_query($req, 'NUMERIC');
                    if ($_rt && is_array($_rt)) {

                        foreach ($_rt as $v) {
                            if (!isset($_fm["{$v['m']}"])) {
                                $_fm["{$v['m']}"] = array();
                                $_fo["{$v['m']}"] = 1;
                            }
                            $_fm["{$v['m']}"][] = $v['i'];
                        }

                        // Trigger for other modules
                        // module => item_id
                        $_ag = array(
                            'page'      => $page,
                            'pagebreak' => $pbrk
                        );
                        $_fm = jrCore_trigger_event('jrSearch', 'search_item_ids', $_fm, $_ag);

                        unset($_rt);
                        if (count($_fo) > 0) {
                            $_nm = array();
                            foreach ($_fo as $m => $v) {
                                if (isset($_rm[$m])) {
                                    $_nm[$m] = $_rm[$m];
                                    unset($_rm[$m]);
                                }
                            }
                            $_rm = array_merge($_rm, $_nm);
                            unset($_nm);
                        }
                    }
                }

                // Did we get results?
                if (count($_fm) > 0) {
                    foreach ($_rm as $mod => $_mod) {

                        if (!jrCore_module_is_active($mod)) {
                            continue;
                        }
                        if (jrSearch_is_excluded_module($mod)) {
                            continue;
                        }
                        $pfx = jrCore_db_get_prefix($mod);
                        if ($pfx) {

                            $_rt = false;
                            $fnc = false;
                            foreach ($_mod as $fields => $title) {
                                // A module can give us a custom search function
                                if (function_exists($fields)) {
                                    $fnc = $fields;
                                }
                                $_fn['titles'][$mod] = (!empty($_ln[$mod][$title])) ? $_ln[$mod][$title] : $_mods[$mod]['module_name'];
                            }

                            if (!$fnc) {

                                // no results...
                                if (empty($_fm[$mod]) || count($_fm[$mod]) === 0) {
                                    continue;
                                }
                                if (!isset($_fm[$mod]['_items'])) {

                                    $rcnt = count($_fm[$mod]);
                                    $_sc  = array(
                                        'page'                => $page,
                                        'pagebreak'           => $pbrk,
                                        'use_total_row_count' => $rcnt
                                    );
                                    if ($all) {
                                        unset($_sc['pagebreak']);
                                        $_sc['simplepagebreak'] = $pbrk;
                                    }

                                    // Prune down our result set if we can...
                                    if ($pbrk > 0 && $rcnt > $pbrk && $rcnt > 200 && (!isset($_conf['jrSearch_optimize']) || $_conf['jrSearch_optimize'] == 'on')) {
                                        $_fm[$mod] = array_slice($_fm[$mod], 0, (($page * 3) * $pbrk), true);
                                    }
                                    if (empty($_fm[$mod]) || count($_fm[$mod]) === 0) {
                                        // NO results for this page
                                        continue;
                                    }

                                    $_sc['ignore_missing']                      = true;
                                    $_sc['search']                              = array('_item_id in ' . implode(',', $_fm[$mod]));
                                    $_sc['jrcore_list_function_call_is_active'] = 1;

                                    $_rt = jrCore_db_search_items($mod, $_sc);
                                }
                                else {
                                    $_rt = $_fm[$mod];
                                }

                            }

                            else {
                                // This module has a custom function for returning matching item_ids
                                if (isset($_fm[$mod]) && count($_fm[$mod]) > 0) {
                                    // Custom module function for results
                                    $_rt = $fnc($_post['search_string'], $pbrk, $page);
                                }
                            }

                            if ($_rt && is_array($_rt) && isset($_rt['_items']) && count($_rt['_items']) > 0) {
                                if (is_file(APP_DIR . "/skins/{$_conf['jrCore_active_skin']}/{$mod}_item_search.tpl")) {
                                    $_fn['results'][$mod] = jrCore_parse_template("{$mod}_item_search.tpl", $_rt);
                                }
                                elseif (is_file(APP_DIR . "/modules/{$mod}/templates/item_search.tpl")) {
                                    $_fn['results'][$mod] = jrCore_parse_template('item_search.tpl', $_rt, $mod);
                                }
                                elseif (is_file(APP_DIR . "/skins/{$_conf['jrCore_active_skin']}/{$mod}_item_list.tpl")) {
                                    $_fn['results'][$mod] = jrCore_parse_template("{$mod}_item_list.tpl", $_rt);
                                }
                                elseif (is_file(APP_DIR . "/modules/{$mod}/templates/item_list.tpl")) {
                                    $_fn['results'][$mod] = jrCore_parse_template('item_list.tpl', $_rt, $mod);
                                }
                                $_fn['info'][$mod] = $_rt['info'];
                                $ttl               += count($_rt['_items']);
                                $ltl               = $_fn['titles'][$mod];
                            }
                        }
                    }
                }
                else {
                    if (isset($_conf['jrSearch_log_no_result']) && $_conf['jrSearch_log_no_result'] == 'on') {
                        jrCore_logger('MIN', "no search results found for &quot;" . jrCore_entity_string($_post['search_string']) . '&quot;');
                    }
                }
                if (isset($_post['original_search_string'])) {
                    $_fn['search_string'] = jrCore_entity_string(strip_tags(trim($_post['original_search_string'])));
                }
                else {
                    $_fn['search_string'] = jrCore_entity_string(strip_tags(trim($_post['search_string'])));
                }
                $_fn['pagebreak']    = $pbrk;
                $_fn['page']         = $page;
                $_fn['modules']      = (isset($_post['_1']) && isset($_mods["{$_post['_1']}"])) ? $_post['_1'] : 'all';
                $_fn['module_count'] = count($_fn['results']);
                if ($_fn['module_count'] === 1) {
                    $_fn['titles']['all'] = $ltl;
                }

                // display order
                if (isset($_conf['jrSearch_display_order'])) {
                    $_order = explode(',', $_conf['jrSearch_display_order']);
                    if (!empty($_order)) {
                        foreach ($_order as $k => $o) {
                            if (!array_key_exists($o, $_fn['results'])) {
                                unset($_order[$k]);
                            }
                        }
                        $_fn['results'] = array_replace(array_flip($_order), $_fn['results']);
                    }
                }

                $html = jrCore_parse_template('search_results.tpl', $_fn, 'jrSearch');
                jrCore_add_to_cache('jrSearch', $_post['_uri'], $html);

                // Save search details
                if (jrUser_is_logged_in()) {
                    $_data = array(
                        'search_string'  => $_post['search_string'],
                        'search_module'  => (isset($_post['_1']) && isset($_mods["{$_post['_1']}"])) ? $_post['_1'] : 'all',
                        'search_results' => $ttl
                    );
                    jrCore_db_create_item('jrSearch', $_data, null, false);
                }
            }

            // Add in results
            $out .= $html;
        }
    }
    else {
        // We have too short of a search string
        $_fn = array(
            'pagebreak'     => $pbrk,
            'page'          => $page,
            'modules'       => 'all',
            'results'       => array(),
            'search_string' => jrCore_entity_string(strip_tags(trim($_post['search_string'])))
        );
        $out .= jrCore_parse_template('search_results.tpl', $_fn, 'jrSearch');
    }
    $out .= jrCore_parse_template('footer.tpl');
    session_cache_limiter('private');
    return $out;
}
