<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_create($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrUser_load_lang_strings();

    // If this a master admin creating...
    if (jrUser_is_master()) {
        jrCore_page_include_admin_menu();
        jrCore_page_admin_tabs('jrUser');
    }
    else {
        jrCore_page_dashboard_tabs();
    }

    // our page banner
    jrCore_page_banner('create user account');

    // Form init
    $_tmp = array(
        'submit_value'     => 'create user',
        'cancel'           => 'referrer',
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // User Name
    $_tmp = array(
        'name'      => 'user_name',
        'label'     => 4,
        'help'      => 5,
        'type'      => 'text',
        'error_msg' => 6,
        'required'  => true,
        'validate'  => 'printable'
    );
    jrCore_form_field_create($_tmp);

    // User Email
    $_tmp = array(
        'name'     => 'user_email',
        'label'    => 18,
        'help'     => 57,
        'type'     => 'text',
        'required' => true,
        'validate' => 'email'
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_section_header('password options');

    // Generate Password
    $_tmp = array(
        'name'     => 'user_password_create',
        'label'    => 'create password',
        'sublabel' => 'and send user an email',
        'help'     => 'If this option is checked, a random password will be generated for this new User Account if NO PASSWORD is entered into the password form field.  The new user will be sent an email with their password - the user can change their password when they login.',
        'type'     => 'checkbox',
        'value'    => 'on'
    );
    jrCore_form_field_create($_tmp);

    // Password #1
    $_tmp = array(
        'name'      => 'user_passwd1',
        'label'     => 7,
        'help'      => 8,
        'type'      => 'password',
        'error_msg' => 9,
        'required'  => false,
        'validate'  => 'not_empty'
    );
    jrCore_form_field_create($_tmp);

    // Password #2
    $_tmp = array(
        'name'      => 'user_passwd2',
        'label'     => 32,
        'help'      => 23,
        'type'      => 'password',
        'error_msg' => 9,
        'required'  => false,
        'validate'  => 'not_empty'
    );
    jrCore_form_field_create($_tmp);

    // Master Admin options
    if (jrUser_is_admin()) {

        jrCore_page_section_header('admin options');

        $_tmp = array(
            'name'     => 'create_profile',
            'label'    => 'create profile for user',
            'help'     => 'If this option is checked, a Profile will be created for this User Account.  If left unchecked, you will be able to select a Profile to link this User Account to.',
            'type'     => 'checkbox',
            'value'    => 'on',
            'validate' => 'onoff',
            'required' => true
        );
        jrCore_form_field_create($_tmp);

        if (jrUser_is_master()) {
            $_tmp = array(
                'name'     => 'user_group',
                'label'    => 'user group',
                'help'     => 'Select the user group this user should be part of:<br><br><b>Standard User:</b> a normal user account in your system - can modify items they have created only.<br><b>Profile Admin:</b> can modify users and profiles and items created by any user on the system. Has access to the Dashboard.<br><b>Master Admin:</b> full access to all system areas including the Admin Control Panel and Dashboard.',
                'type'     => 'select',
                'options'  => array('user' => 'Standard User', 'admin' => 'Profile Admin', 'master' => 'Master Admin'),
                'value'    => 'user',
                'validate' => 'core_string'
            );
            jrCore_form_field_create($_tmp);
        }
    }
    jrCore_page_display();
}
