<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: user_resend
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_user_resend($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_validate_location_url();

    if (!(isset($_post['user_id']) && (jrCore_checktype($_post['user_id'], 'number_nz') || strpos($_post['user_id'], ',')))) {
        jrCore_set_form_notice('error', 'Invalid user_id - please try again');
        jrCore_location('referrer');
    }
    $_uids = explode(',', $_post['user_id']);
    foreach ($_uids as $uid) {
        if (!jrCore_checktype($uid, 'number_nz')) {
            jrCore_set_form_notice('error', 'Invalid user_id - please try again');
            jrCore_location('referrer');
        }
        $_rt = jrCore_db_get_item('jrUser', $uid, false, true);
        if (!$_rt || !is_array($_rt)) {
            jrCore_set_form_notice('error', 'Invalid user_id - data not found - please try again');
            jrCore_location('referrer');
        }
        if ($_rt['user_validated'] != '1' || $_rt['user_active'] != '1') {
            // Send User Account validation email
            $_rp = array(
                'system_name'    => $_conf['jrCore_system_name'],
                'activation_url' => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/activate/{$_rt['user_validate']}"
            );
            list($sub, $msg) = jrCore_parse_email_templates('jrUser', 'signup', $_rp);
            jrCore_send_email($_rt['user_email'], $sub, $msg);
        }
    }

    jrCore_set_form_notice('success', 'The Signup Activation email(s) have been resent to the User(s)');
    jrCore_location('referrer');
}
