# Security Policy

## Supported Versions

The following versions are supported with security updates:

| Version | Supported          |
| ------- | ------------------ |
| 2.8.0  | :white_check_mark: |
| 2.7.0  | :white_check_mark: |
| 2.6.0  | :x: |
| 2.5.0  | :x: |
| <2.4   | :x: |

As for supported PHP versions, this project only supports the actively supported versions of PHP and versions of PHP
that only receive critical security updates. Currently, that is PHP 8.1, 8.2, 8.3 and 8.4.
Please refer to the [supported versions](https://www.php.net/supported-versions.php) page, to find more details.
When a version of PHP becomes EOL, generally a new release of this project will be issued that sunsets the
support of that retired PHP version.

## Reporting a Vulnerability

If you would like to report a vulnerability or have any security concerns with this project,
please [open an issue](https://github.com/azuyalabs/yasumi/issues/new?labels=security).

To investigate your request as good as possible, please include any of the following when reporting:

- Proof of concept / Code example
- Any tools, including versions used
- Any relevant output

I will take all disclosures very seriously and will do my best to rapidly respond and verify the vulnerability before
taking the necessary steps to fix it. After my initial reply to your disclosure, which should be directly after
receiving it, I will periodically update you with the status of the fix.
