<?php

declare(strict_types = 1);

/**
 * This file is part of the 'Yasumi' package.
 *
 * The easy PHP Library for calculating holidays.
 *
 * Copyright (c) 2015 - 2025 AzuyaLabs
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @author Sacha Telgenhof <me at sachatelgenhof dot com>
 */

namespace Yasumi\Filters;

use Yasumi\SubstituteHoliday;

abstract class AbstractFilter extends \FilterIterator implements \Countable
{
    /**
     * Returns the number of holidays returned by this iterator.
     *
     * In case a holiday is substituted (e.g. observed), the holiday is only counted once.
     *
     * @return int number of unique holidays
     */
    public function count(): int
    {
        $names = [];

        foreach ($this as $holiday) {
            $key = $holiday instanceof SubstituteHoliday
                ? $holiday->getSubstitutedHoliday()->getKey()
                : $holiday->getKey();

            $names[$key] = true;
        }

        return count($names);
    }
}
