<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Item type identification codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdItemTypeIdentificationCodes
{
    /**
     * Product version number
     */
    public const UNTDID_7143_AA = 'AA';

    /**
     * Assembly
     */
    public const UNTDID_7143_AB = 'AB';

    /**
     * HIBC (Health Industry Bar Code)
     */
    public const UNTDID_7143_AC = 'AC';

    /**
     * Cold roll number
     */
    public const UNTDID_7143_AD = 'AD';

    /**
     * Hot roll number
     */
    public const UNTDID_7143_AE = 'AE';

    /**
     * Slab number
     */
    public const UNTDID_7143_AF = 'AF';

    /**
     * Software revision number
     */
    public const UNTDID_7143_AG = 'AG';

    /**
     * UPC (Universal Product Code) Consumer package code (1-5-5)
     */
    public const UNTDID_7143_AH = 'AH';

    /**
     * UPC (Universal Product Code) Consumer package code (1-5-5-
     */
    public const UNTDID_7143_AI = 'AI';

    /**
     * Sample number
     */
    public const UNTDID_7143_AJ = 'AJ';

    /**
     * Pack number
     */
    public const UNTDID_7143_AK = 'AK';

    /**
     * UPC (Universal Product Code) Shipping container code (1-2-
     */
    public const UNTDID_7143_AL = 'AL';

    /**
     * UPC (Universal Product Code)/EAN (European article number)
     */
    public const UNTDID_7143_AM = 'AM';

    /**
     * UPC (Universal Product Code) suffix
     */
    public const UNTDID_7143_AN = 'AN';

    /**
     * State label code
     */
    public const UNTDID_7143_AO = 'AO';

    /**
     * Heat number
     */
    public const UNTDID_7143_AP = 'AP';

    /**
     * Coupon number
     */
    public const UNTDID_7143_AQ = 'AQ';

    /**
     * Resource number
     */
    public const UNTDID_7143_AR = 'AR';

    /**
     * Work task number
     */
    public const UNTDID_7143_AS = 'AS';

    /**
     * Price look up number
     */
    public const UNTDID_7143_AT = 'AT';

    /**
     * NSN (North Atlantic Treaty Organization Stock Number)
     */
    public const UNTDID_7143_AU = 'AU';

    /**
     * Refined product code
     */
    public const UNTDID_7143_AV = 'AV';

    /**
     * Exhibit
     */
    public const UNTDID_7143_AW = 'AW';

    /**
     * End item
     */
    public const UNTDID_7143_AX = 'AX';

    /**
     * Federal supply classification
     */
    public const UNTDID_7143_AY = 'AY';

    /**
     * Engineering data list
     */
    public const UNTDID_7143_AZ = 'AZ';

    /**
     * Milestone event number
     */
    public const UNTDID_7143_BA = 'BA';

    /**
     * Lot number
     */
    public const UNTDID_7143_BB = 'BB';

    /**
     * National drug code 4-4-2 format
     */
    public const UNTDID_7143_BC = 'BC';

    /**
     * National drug code 5-3-2 format
     */
    public const UNTDID_7143_BD = 'BD';

    /**
     * National drug code 5-4-1 format
     */
    public const UNTDID_7143_BE = 'BE';

    /**
     * National drug code 5-4-2 format
     */
    public const UNTDID_7143_BF = 'BF';

    /**
     * National drug code
     */
    public const UNTDID_7143_BG = 'BG';

    /**
     * Part number
     */
    public const UNTDID_7143_BH = 'BH';

    /**
     * Local Stock Number (LSN)
     */
    public const UNTDID_7143_BI = 'BI';

    /**
     * Next higher assembly number
     */
    public const UNTDID_7143_BJ = 'BJ';

    /**
     * Data category
     */
    public const UNTDID_7143_BK = 'BK';

    /**
     * Control number
     */
    public const UNTDID_7143_BL = 'BL';

    /**
     * Special material identification code
     */
    public const UNTDID_7143_BM = 'BM';

    /**
     * Locally assigned control number
     */
    public const UNTDID_7143_BN = 'BN';

    /**
     * Buyer's colour
     */
    public const UNTDID_7143_BO = 'BO';

    /**
     * Buyer's part number
     */
    public const UNTDID_7143_BP = 'BP';

    /**
     * Variable measure product code
     */
    public const UNTDID_7143_BQ = 'BQ';

    /**
     * Financial phase
     */
    public const UNTDID_7143_BR = 'BR';

    /**
     * Contract breakdown
     */
    public const UNTDID_7143_BS = 'BS';

    /**
     * Technical phase
     */
    public const UNTDID_7143_BT = 'BT';

    /**
     * Dye lot number
     */
    public const UNTDID_7143_BU = 'BU';

    /**
     * Daily statement of activities
     */
    public const UNTDID_7143_BV = 'BV';

    /**
     * Periodical statement of activities within a bilaterally
     */
    public const UNTDID_7143_BW = 'BW';

    /**
     * Calendar week statement of activities
     */
    public const UNTDID_7143_BX = 'BX';

    /**
     * Calendar month statement of activities
     */
    public const UNTDID_7143_BY = 'BY';

    /**
     * Original equipment number
     */
    public const UNTDID_7143_BZ = 'BZ';

    /**
     * Industry commodity code
     */
    public const UNTDID_7143_CC = 'CC';

    /**
     * Commodity grouping
     */
    public const UNTDID_7143_CG = 'CG';

    /**
     * Colour number
     */
    public const UNTDID_7143_CL = 'CL';

    /**
     * Contract number
     */
    public const UNTDID_7143_CR = 'CR';

    /**
     * Customs article number
     */
    public const UNTDID_7143_CV = 'CV';

    /**
     * Drawing revision number
     */
    public const UNTDID_7143_DR = 'DR';

    /**
     * Drawing
     */
    public const UNTDID_7143_DW = 'DW';

    /**
     * Engineering change level
     */
    public const UNTDID_7143_EC = 'EC';

    /**
     * Material code
     */
    public const UNTDID_7143_EF = 'EF';

    /**
     * International Article Numbering Association (EAN)
     */
    public const UNTDID_7143_EN = 'EN';

    /**
     * Fish species
     */
    public const UNTDID_7143_FS = 'FS';

    /**
     * Buyer's internal product group code
     */
    public const UNTDID_7143_GB = 'GB';

    /**
     * National product group code
     */
    public const UNTDID_7143_GN = 'GN';

    /**
     * General specification number
     */
    public const UNTDID_7143_GS = 'GS';

    /**
     * Harmonised system
     */
    public const UNTDID_7143_HS = 'HS';

    /**
     * ISBN (International Standard Book Number)
     */
    public const UNTDID_7143_IB = 'IB';

    /**
     * Buyer's item number
     */
    public const UNTDID_7143_IN = 'IN';

    /**
     * ISSN (International Standard Serial Number)
     */
    public const UNTDID_7143_IS = 'IS';

    /**
     * Buyer's style number
     */
    public const UNTDID_7143_IT = 'IT';

    /**
     * Buyer's size code
     */
    public const UNTDID_7143_IZ = 'IZ';

    /**
     * Machine number
     */
    public const UNTDID_7143_MA = 'MA';

    /**
     * Manufacturer's (producer's) article number
     */
    public const UNTDID_7143_MF = 'MF';

    /**
     * Model number
     */
    public const UNTDID_7143_MN = 'MN';

    /**
     * Product/service identification number
     */
    public const UNTDID_7143_MP = 'MP';

    /**
     * Batch number
     */
    public const UNTDID_7143_NB = 'NB';

    /**
     * Customer order number
     */
    public const UNTDID_7143_ON = 'ON';

    /**
     * Part number description
     */
    public const UNTDID_7143_PD = 'PD';

    /**
     * Purchaser's order line number
     */
    public const UNTDID_7143_PL = 'PL';

    /**
     * Purchase order number
     */
    public const UNTDID_7143_PO = 'PO';

    /**
     * Promotional variant number
     */
    public const UNTDID_7143_PV = 'PV';

    /**
     * Buyer's qualifier for size
     */
    public const UNTDID_7143_QS = 'QS';

    /**
     * Returnable container number
     */
    public const UNTDID_7143_RC = 'RC';

    /**
     * Release number
     */
    public const UNTDID_7143_RN = 'RN';

    /**
     * Run number
     */
    public const UNTDID_7143_RU = 'RU';

    /**
     * Record keeping of model year
     */
    public const UNTDID_7143_RY = 'RY';

    /**
     * Supplier's article number
     */
    public const UNTDID_7143_SA = 'SA';

    /**
     * Standard group of products (mixed assortment)
     */
    public const UNTDID_7143_SG = 'SG';

    /**
     * SKU (Stock keeping unit)
     */
    public const UNTDID_7143_SK = 'SK';

    /**
     * Serial number
     */
    public const UNTDID_7143_SN = 'SN';

    /**
     * RSK number
     */
    public const UNTDID_7143_SRS = 'SRS';

    /**
     * IFLS (Institut Francais du Libre Service) 5 digit product
     */
    public const UNTDID_7143_SRT = 'SRT';

    /**
     * IFLS (Institut Francais du Libre Service) 9 digit product
     */
    public const UNTDID_7143_SRU = 'SRU';

    /**
     * GS1 Global Trade Item Number
     */
    public const UNTDID_7143_SRV = 'SRV';

    /**
     * EDIS (Energy Data Identification System)
     */
    public const UNTDID_7143_SRW = 'SRW';

    /**
     * Slaughter number
     */
    public const UNTDID_7143_SRX = 'SRX';

    /**
     * Official animal number
     */
    public const UNTDID_7143_SRY = 'SRY';

    /**
     * Harmonized tariff schedule
     */
    public const UNTDID_7143_SRZ = 'SRZ';

    /**
     * Supplier's supplier article number
     */
    public const UNTDID_7143_SS = 'SS';

    /**
     * 46 Level DOT Code
     */
    public const UNTDID_7143_SSA = 'SSA';

    /**
     * Airline Tariff 6D
     */
    public const UNTDID_7143_SSB = 'SSB';

    /**
     * Title 49 Code of Federal Regulations
     */
    public const UNTDID_7143_SSC = 'SSC';

    /**
     * International Civil Aviation Administration code
     */
    public const UNTDID_7143_SSD = 'SSD';

    /**
     * Hazardous Materials ID DOT
     */
    public const UNTDID_7143_SSE = 'SSE';

    /**
     * Endorsement
     */
    public const UNTDID_7143_SSF = 'SSF';

    /**
     * Air Force Regulation 71-4
     */
    public const UNTDID_7143_SSG = 'SSG';

    /**
     * Breed
     */
    public const UNTDID_7143_SSH = 'SSH';

    /**
     * Chemical Abstract Service (CAS) registry number
     */
    public const UNTDID_7143_SSI = 'SSI';

    /**
     * Engine model designation
     */
    public const UNTDID_7143_SSJ = 'SSJ';

    /**
     * Institutional Meat Purchase Specifications (IMPS) Number
     */
    public const UNTDID_7143_SSK = 'SSK';

    /**
     * Price Look-Up code (PLU)
     */
    public const UNTDID_7143_SSL = 'SSL';

    /**
     * International Maritime Organization (IMO) Code
     */
    public const UNTDID_7143_SSM = 'SSM';

    /**
     * Bureau of Explosives 600-A (rail)
     */
    public const UNTDID_7143_SSN = 'SSN';

    /**
     * United Nations Dangerous Goods List
     */
    public const UNTDID_7143_SSO = 'SSO';

    /**
     * International Code of Botanical Nomenclature (ICBN)
     */
    public const UNTDID_7143_SSP = 'SSP';

    /**
     * International Code of Zoological Nomenclature (ICZN)
     */
    public const UNTDID_7143_SSQ = 'SSQ';

    /**
     * International Code of Nomenclature for Cultivated Plants
     */
    public const UNTDID_7143_SSR = 'SSR';

    /**
     * Distributor’s article identifier
     */
    public const UNTDID_7143_SSS = 'SSS';

    /**
     * Norwegian Classification system ENVA
     */
    public const UNTDID_7143_SST = 'SST';

    /**
     * Supplier assigned classification
     */
    public const UNTDID_7143_SSU = 'SSU';

    /**
     * Mexican classification system AMECE
     */
    public const UNTDID_7143_SSV = 'SSV';

    /**
     * German classification system CCG
     */
    public const UNTDID_7143_SSW = 'SSW';

    /**
     * Finnish classification system EANFIN
     */
    public const UNTDID_7143_SSX = 'SSX';

    /**
     * Canadian classification system ICC
     */
    public const UNTDID_7143_SSY = 'SSY';

    /**
     * French classification system IFLS5
     */
    public const UNTDID_7143_SSZ = 'SSZ';

    /**
     * Style number
     */
    public const UNTDID_7143_ST = 'ST';

    /**
     * Dutch classification system CBL
     */
    public const UNTDID_7143_STA = 'STA';

    /**
     * Japanese classification system JICFS
     */
    public const UNTDID_7143_STB = 'STB';

    /**
     * European Union dairy subsidy eligibility classification
     */
    public const UNTDID_7143_STC = 'STC';

    /**
     * GS1 Spain classification system
     */
    public const UNTDID_7143_STD = 'STD';

    /**
     * GS1 Poland classification system
     */
    public const UNTDID_7143_STE = 'STE';

    /**
     * Federal Agency on Technical Regulating and Metrology of the
     */
    public const UNTDID_7143_STF = 'STF';

    /**
     * Efficient Consumer Response (ECR) Austria classification
     */
    public const UNTDID_7143_STG = 'STG';

    /**
     * GS1 Italy classification system
     */
    public const UNTDID_7143_STH = 'STH';

    /**
     * CPV (Common Procurement Vocabulary)
     */
    public const UNTDID_7143_STI = 'STI';

    /**
     * IFDA (International Foodservice Distributors Association)
     */
    public const UNTDID_7143_STJ = 'STJ';

    /**
     * AHFS (American Hospital Formulary Service) pharmacologic -
     */
    public const UNTDID_7143_STK = 'STK';

    /**
     * ATC (Anatomical Therapeutic Chemical) classification system
     */
    public const UNTDID_7143_STL = 'STL';

    /**
     * CLADIMED (Classification des Dispositifs Médicaux)
     */
    public const UNTDID_7143_STM = 'STM';

    /**
     * CMDR (Canadian Medical Device Regulations) classification
     */
    public const UNTDID_7143_STN = 'STN';

    /**
     * CNDM (Classificazione Nazionale dei Dispositivi Medici)
     */
    public const UNTDID_7143_STO = 'STO';

    /**
     * UK DM&D (Dictionary of Medicines & Devices) standard coding
     */
    public const UNTDID_7143_STP = 'STP';

    /**
     * eCl@ss
     */
    public const UNTDID_7143_STQ = 'STQ';

    /**
     * EDMA (European Diagnostic Manufacturers Association)
     */
    public const UNTDID_7143_STR = 'STR';

    /**
     * EGAR (European Generic Article Register)
     */
    public const UNTDID_7143_STS = 'STS';

    /**
     * GMDN (Global Medical Devices Nomenclature)
     */
    public const UNTDID_7143_STT = 'STT';

    /**
     * GPI (Generic Product Identifier)
     */
    public const UNTDID_7143_STU = 'STU';

    /**
     * HCPCS (Healthcare Common Procedure Coding System)
     */
    public const UNTDID_7143_STV = 'STV';

    /**
     * ICPS (International Classification for Patient Safety)
     */
    public const UNTDID_7143_STW = 'STW';

    /**
     * MedDRA (Medical Dictionary for Regulatory Activities)
     */
    public const UNTDID_7143_STX = 'STX';

    /**
     * Medical Columbus
     */
    public const UNTDID_7143_STY = 'STY';

    /**
     * NAPCS (North American Product Classification System)
     */
    public const UNTDID_7143_STZ = 'STZ';

    /**
     * NHS (National Health Services) eClass
     */
    public const UNTDID_7143_SUA = 'SUA';

    /**
     * US FDA (Food and Drug Administration) Product Code
     */
    public const UNTDID_7143_SUB = 'SUB';

    /**
     * SNOMED CT (Systematized Nomenclature of Medicine-Clinical
     */
    public const UNTDID_7143_SUC = 'SUC';

    /**
     * UMDNS (Universal Medical Device Nomenclature System)
     */
    public const UNTDID_7143_SUD = 'SUD';

    /**
     * GS1 Global Returnable Asset Identifier, non-serialised
     */
    public const UNTDID_7143_SUE = 'SUE';

    /**
     * IMEI
     */
    public const UNTDID_7143_SUF = 'SUF';

    /**
     * Waste Type (EMSA)
     */
    public const UNTDID_7143_SUG = 'SUG';

    /**
     * Ship's store classification type
     */
    public const UNTDID_7143_SUH = 'SUH';

    /**
     * Emergency fire code
     */
    public const UNTDID_7143_SUI = 'SUI';

    /**
     * Emergency spillage code
     */
    public const UNTDID_7143_SUJ = 'SUJ';

    /**
     * IMDG packing group
     */
    public const UNTDID_7143_SUK = 'SUK';

    /**
     * MARPOL Code IBC
     */
    public const UNTDID_7143_SUL = 'SUL';

    /**
     * IMDG subsidiary risk class
     */
    public const UNTDID_7143_SUM = 'SUM';

    /**
     * Transport group number
     */
    public const UNTDID_7143_TG = 'TG';

    /**
     * Taxonomic Serial Number
     */
    public const UNTDID_7143_TSN = 'TSN';

    /**
     * IMDG main hazard class
     */
    public const UNTDID_7143_TSO = 'TSO';

    /**
     * EU Combined Nomenclature
     */
    public const UNTDID_7143_TSP = 'TSP';

    /**
     * Therapeutic classification number
     */
    public const UNTDID_7143_TSQ = 'TSQ';

    /**
     * European Waste Catalogue
     */
    public const UNTDID_7143_TSR = 'TSR';

    /**
     * Price grouping code
     */
    public const UNTDID_7143_TSS = 'TSS';

    /**
     * UNSPSC
     */
    public const UNTDID_7143_TST = 'TST';

    /**
     * Ultimate customer's article number
     */
    public const UNTDID_7143_UA = 'UA';

    /**
     * UPC (Universal product code)
     */
    public const UNTDID_7143_UP = 'UP';

    /**
     * Vendor item number
     */
    public const UNTDID_7143_VN = 'VN';

    /**
     * Vendor's (seller's) part number
     */
    public const UNTDID_7143_VP = 'VP';

    /**
     * Vendor's supplemental item number
     */
    public const UNTDID_7143_VS = 'VS';

    /**
     * Vendor specification number
     */
    public const UNTDID_7143_VX = 'VX';

    /**
     * Mutually defined
     */
    public const UNTDID_7143_ZZZ = 'ZZZ';
}
